/*********************                                                        */
/*! \file module_template.cpp
 ** \verbatim
 ** Top contributors (to current version):
 **   Mathias Preiner
 ** This file is part of the CVC4 project.
 ** Copyright (c) 2009-2020 by the authors listed in the file AUTHORS
 ** in the top-level source directory) and their institutional affiliations.
 ** All rights reserved.  See the file COPYING in the top-level source
 ** directory for licensing information.\endverbatim
 **
 ** \brief Option template for option modules.
 **
 ** For each <module>_options.toml configuration file, mkoptions.py
 ** expands this template and generates a <module>_options.cpp file.
 **/

#include "options/options_holder.h"
#include "base/check.h"

namespace CVC4 {

template <> const options::abstractValues__option_t::type& Options::operator[](
    options::abstractValues__option_t) const
{
  return d_holder->abstractValues;
}
template <> bool Options::wasSetByUser(options::abstractValues__option_t) const
{
  return d_holder->abstractValues__setByUser__;
}
template <> void Options::set(
    options::ackermann__option_t,
    const options::ackermann__option_t::type& x)
{
  d_holder->ackermann = x;
}
template <> const options::ackermann__option_t::type& Options::operator[](
    options::ackermann__option_t) const
{
  return d_holder->ackermann;
}
template <> bool Options::wasSetByUser(options::ackermann__option_t) const
{
  return d_holder->ackermann__setByUser__;
}
template <> const options::bitblastStep__option_t::type& Options::operator[](
    options::bitblastStep__option_t) const
{
  return d_holder->bitblastStep;
}
template <> bool Options::wasSetByUser(options::bitblastStep__option_t) const
{
  return d_holder->bitblastStep__setByUser__;
}
template <> void Options::set(
    options::blockModelsMode__option_t,
    const options::blockModelsMode__option_t::type& x)
{
  d_holder->blockModelsMode = x;
}
template <> const options::blockModelsMode__option_t::type& Options::operator[](
    options::blockModelsMode__option_t) const
{
  return d_holder->blockModelsMode;
}
template <> bool Options::wasSetByUser(options::blockModelsMode__option_t) const
{
  return d_holder->blockModelsMode__setByUser__;
}
template <> const options::bvEagerAssertStep__option_t::type& Options::operator[](
    options::bvEagerAssertStep__option_t) const
{
  return d_holder->bvEagerAssertStep;
}
template <> bool Options::wasSetByUser(options::bvEagerAssertStep__option_t) const
{
  return d_holder->bvEagerAssertStep__setByUser__;
}
template <> const options::bvPropagationStep__option_t::type& Options::operator[](
    options::bvPropagationStep__option_t) const
{
  return d_holder->bvPropagationStep;
}
template <> bool Options::wasSetByUser(options::bvPropagationStep__option_t) const
{
  return d_holder->bvPropagationStep__setByUser__;
}
template <> const options::bvSatConflictStep__option_t::type& Options::operator[](
    options::bvSatConflictStep__option_t) const
{
  return d_holder->bvSatConflictStep;
}
template <> bool Options::wasSetByUser(options::bvSatConflictStep__option_t) const
{
  return d_holder->bvSatConflictStep__setByUser__;
}
template <> const options::checkAbducts__option_t::type& Options::operator[](
    options::checkAbducts__option_t) const
{
  return d_holder->checkAbducts;
}
template <> bool Options::wasSetByUser(options::checkAbducts__option_t) const
{
  return d_holder->checkAbducts__setByUser__;
}
template <> void Options::set(
    options::checkModels__option_t,
    const options::checkModels__option_t::type& x)
{
  d_holder->checkModels = x;
}
template <> const options::checkModels__option_t::type& Options::operator[](
    options::checkModels__option_t) const
{
  return d_holder->checkModels;
}
template <> bool Options::wasSetByUser(options::checkModels__option_t) const
{
  return d_holder->checkModels__setByUser__;
}
template <> void Options::set(
    options::checkProofs__option_t,
    const options::checkProofs__option_t::type& x)
{
  d_holder->checkProofs = x;
}
template <> const options::checkProofs__option_t::type& Options::operator[](
    options::checkProofs__option_t) const
{
  return d_holder->checkProofs;
}
template <> bool Options::wasSetByUser(options::checkProofs__option_t) const
{
  return d_holder->checkProofs__setByUser__;
}
template <> const options::checkSynthSol__option_t::type& Options::operator[](
    options::checkSynthSol__option_t) const
{
  return d_holder->checkSynthSol;
}
template <> bool Options::wasSetByUser(options::checkSynthSol__option_t) const
{
  return d_holder->checkSynthSol__setByUser__;
}
template <> void Options::set(
    options::checkUnsatCores__option_t,
    const options::checkUnsatCores__option_t::type& x)
{
  d_holder->checkUnsatCores = x;
}
template <> const options::checkUnsatCores__option_t::type& Options::operator[](
    options::checkUnsatCores__option_t) const
{
  return d_holder->checkUnsatCores;
}
template <> bool Options::wasSetByUser(options::checkUnsatCores__option_t) const
{
  return d_holder->checkUnsatCores__setByUser__;
}
template <> const options::cnfStep__option_t::type& Options::operator[](
    options::cnfStep__option_t) const
{
  return d_holder->cnfStep;
}
template <> bool Options::wasSetByUser(options::cnfStep__option_t) const
{
  return d_holder->cnfStep__setByUser__;
}
template <> const options::cpuTime__option_t::type& Options::operator[](
    options::cpuTime__option_t) const
{
  return d_holder->cpuTime;
}
template <> bool Options::wasSetByUser(options::cpuTime__option_t) const
{
  return d_holder->cpuTime__setByUser__;
}
template <> void Options::set(
    options::debugCheckModels__option_t,
    const options::debugCheckModels__option_t::type& x)
{
  d_holder->debugCheckModels = x;
}
template <> const options::debugCheckModels__option_t::type& Options::operator[](
    options::debugCheckModels__option_t) const
{
  return d_holder->debugCheckModels;
}
template <> bool Options::wasSetByUser(options::debugCheckModels__option_t) const
{
  return d_holder->debugCheckModels__setByUser__;
}
template <> const options::decisionStep__option_t::type& Options::operator[](
    options::decisionStep__option_t) const
{
  return d_holder->decisionStep;
}
template <> bool Options::wasSetByUser(options::decisionStep__option_t) const
{
  return d_holder->decisionStep__setByUser__;
}
template <> const options::diagnosticChannelName__option_t::type& Options::operator[](
    options::diagnosticChannelName__option_t) const
{
  return d_holder->diagnosticChannelName;
}
template <> bool Options::wasSetByUser(options::diagnosticChannelName__option_t) const
{
  return d_holder->diagnosticChannelName__setByUser__;
}
template <> const options::dumpInstantiations__option_t::type& Options::operator[](
    options::dumpInstantiations__option_t) const
{
  return d_holder->dumpInstantiations;
}
template <> bool Options::wasSetByUser(options::dumpInstantiations__option_t) const
{
  return d_holder->dumpInstantiations__setByUser__;
}
template <> const options::dumpModels__option_t::type& Options::operator[](
    options::dumpModels__option_t) const
{
  return d_holder->dumpModels;
}
template <> bool Options::wasSetByUser(options::dumpModels__option_t) const
{
  return d_holder->dumpModels__setByUser__;
}
template <> const options::dumpProofs__option_t::type& Options::operator[](
    options::dumpProofs__option_t) const
{
  return d_holder->dumpProofs;
}
template <> bool Options::wasSetByUser(options::dumpProofs__option_t) const
{
  return d_holder->dumpProofs__setByUser__;
}
template <> void Options::set(
    options::dumpSynth__option_t,
    const options::dumpSynth__option_t::type& x)
{
  d_holder->dumpSynth = x;
}
template <> const options::dumpSynth__option_t::type& Options::operator[](
    options::dumpSynth__option_t) const
{
  return d_holder->dumpSynth;
}
template <> bool Options::wasSetByUser(options::dumpSynth__option_t) const
{
  return d_holder->dumpSynth__setByUser__;
}
template <> const options::dumpToFileName__option_t::type& Options::operator[](
    options::dumpToFileName__option_t) const
{
  return d_holder->dumpToFileName;
}
template <> bool Options::wasSetByUser(options::dumpToFileName__option_t) const
{
  return d_holder->dumpToFileName__setByUser__;
}
template <> void Options::set(
    options::dumpUnsatCores__option_t,
    const options::dumpUnsatCores__option_t::type& x)
{
  d_holder->dumpUnsatCores = x;
}
template <> const options::dumpUnsatCores__option_t::type& Options::operator[](
    options::dumpUnsatCores__option_t) const
{
  return d_holder->dumpUnsatCores;
}
template <> bool Options::wasSetByUser(options::dumpUnsatCores__option_t) const
{
  return d_holder->dumpUnsatCores__setByUser__;
}
template <> const options::dumpUnsatCoresFull__option_t::type& Options::operator[](
    options::dumpUnsatCoresFull__option_t) const
{
  return d_holder->dumpUnsatCoresFull;
}
template <> bool Options::wasSetByUser(options::dumpUnsatCoresFull__option_t) const
{
  return d_holder->dumpUnsatCoresFull__setByUser__;
}
template <> const options::dumpModeString__option_t::type& Options::operator[](
    options::dumpModeString__option_t) const
{
  return d_holder->dumpModeString;
}
template <> bool Options::wasSetByUser(options::dumpModeString__option_t) const
{
  return d_holder->dumpModeString__setByUser__;
}
template <> const options::expandDefinitions__option_t::type& Options::operator[](
    options::expandDefinitions__option_t) const
{
  return d_holder->expandDefinitions;
}
template <> bool Options::wasSetByUser(options::expandDefinitions__option_t) const
{
  return d_holder->expandDefinitions__setByUser__;
}
template <> void Options::set(
    options::extRewPrep__option_t,
    const options::extRewPrep__option_t::type& x)
{
  d_holder->extRewPrep = x;
}
template <> const options::extRewPrep__option_t::type& Options::operator[](
    options::extRewPrep__option_t) const
{
  return d_holder->extRewPrep;
}
template <> bool Options::wasSetByUser(options::extRewPrep__option_t) const
{
  return d_holder->extRewPrep__setByUser__;
}
template <> void Options::set(
    options::extRewPrepAgg__option_t,
    const options::extRewPrepAgg__option_t::type& x)
{
  d_holder->extRewPrepAgg = x;
}
template <> const options::extRewPrepAgg__option_t::type& Options::operator[](
    options::extRewPrepAgg__option_t) const
{
  return d_holder->extRewPrepAgg;
}
template <> bool Options::wasSetByUser(options::extRewPrepAgg__option_t) const
{
  return d_holder->extRewPrepAgg__setByUser__;
}
template <> const options::forceNoLimitCpuWhileDump__option_t::type& Options::operator[](
    options::forceNoLimitCpuWhileDump__option_t) const
{
  return d_holder->forceNoLimitCpuWhileDump;
}
template <> bool Options::wasSetByUser(options::forceNoLimitCpuWhileDump__option_t) const
{
  return d_holder->forceNoLimitCpuWhileDump__setByUser__;
}
template <> const options::hardLimit__option_t::type& Options::operator[](
    options::hardLimit__option_t) const
{
  return d_holder->hardLimit;
}
template <> bool Options::wasSetByUser(options::hardLimit__option_t) const
{
  return d_holder->hardLimit__setByUser__;
}
template <> const options::incrementalSolving__option_t::type& Options::operator[](
    options::incrementalSolving__option_t) const
{
  return d_holder->incrementalSolving;
}
template <> bool Options::wasSetByUser(options::incrementalSolving__option_t) const
{
  return d_holder->incrementalSolving__setByUser__;
}
template <> void Options::set(
    options::interactiveMode__option_t,
    const options::interactiveMode__option_t::type& x)
{
  d_holder->interactiveMode = x;
}
template <> const options::interactiveMode__option_t::type& Options::operator[](
    options::interactiveMode__option_t) const
{
  return d_holder->interactiveMode;
}
template <> bool Options::wasSetByUser(options::interactiveMode__option_t) const
{
  return d_holder->interactiveMode__setByUser__;
}
template <> void Options::set(
    options::doITESimp__option_t,
    const options::doITESimp__option_t::type& x)
{
  d_holder->doITESimp = x;
}
template <> const options::doITESimp__option_t::type& Options::operator[](
    options::doITESimp__option_t) const
{
  return d_holder->doITESimp;
}
template <> bool Options::wasSetByUser(options::doITESimp__option_t) const
{
  return d_holder->doITESimp__setByUser__;
}
template <> const options::lemmaStep__option_t::type& Options::operator[](
    options::lemmaStep__option_t) const
{
  return d_holder->lemmaStep;
}
template <> bool Options::wasSetByUser(options::lemmaStep__option_t) const
{
  return d_holder->lemmaStep__setByUser__;
}
template <> void Options::set(
    options::modelCoresMode__option_t,
    const options::modelCoresMode__option_t::type& x)
{
  d_holder->modelCoresMode = x;
}
template <> const options::modelCoresMode__option_t::type& Options::operator[](
    options::modelCoresMode__option_t) const
{
  return d_holder->modelCoresMode;
}
template <> bool Options::wasSetByUser(options::modelCoresMode__option_t) const
{
  return d_holder->modelCoresMode__setByUser__;
}
template <> const options::modelUninterpDtEnum__option_t::type& Options::operator[](
    options::modelUninterpDtEnum__option_t) const
{
  return d_holder->modelUninterpDtEnum;
}
template <> bool Options::wasSetByUser(options::modelUninterpDtEnum__option_t) const
{
  return d_holder->modelUninterpDtEnum__setByUser__;
}
template <> const options::modelWitnessValue__option_t::type& Options::operator[](
    options::modelWitnessValue__option_t) const
{
  return d_holder->modelWitnessValue;
}
template <> bool Options::wasSetByUser(options::modelWitnessValue__option_t) const
{
  return d_holder->modelWitnessValue__setByUser__;
}
template <> void Options::set(
    options::doITESimpOnRepeat__option_t,
    const options::doITESimpOnRepeat__option_t::type& x)
{
  d_holder->doITESimpOnRepeat = x;
}
template <> const options::doITESimpOnRepeat__option_t::type& Options::operator[](
    options::doITESimpOnRepeat__option_t) const
{
  return d_holder->doITESimpOnRepeat;
}
template <> bool Options::wasSetByUser(options::doITESimpOnRepeat__option_t) const
{
  return d_holder->doITESimpOnRepeat__setByUser__;
}
template <> const options::parseStep__option_t::type& Options::operator[](
    options::parseStep__option_t) const
{
  return d_holder->parseStep;
}
template <> bool Options::wasSetByUser(options::parseStep__option_t) const
{
  return d_holder->parseStep__setByUser__;
}
template <> const options::preprocessStep__option_t::type& Options::operator[](
    options::preprocessStep__option_t) const
{
  return d_holder->preprocessStep;
}
template <> bool Options::wasSetByUser(options::preprocessStep__option_t) const
{
  return d_holder->preprocessStep__setByUser__;
}
template <> const options::produceAbducts__option_t::type& Options::operator[](
    options::produceAbducts__option_t) const
{
  return d_holder->produceAbducts;
}
template <> bool Options::wasSetByUser(options::produceAbducts__option_t) const
{
  return d_holder->produceAbducts__setByUser__;
}
template <> void Options::set(
    options::produceAssertions__option_t,
    const options::produceAssertions__option_t::type& x)
{
  d_holder->produceAssertions = x;
}
template <> const options::produceAssertions__option_t::type& Options::operator[](
    options::produceAssertions__option_t) const
{
  return d_holder->produceAssertions;
}
template <> bool Options::wasSetByUser(options::produceAssertions__option_t) const
{
  return d_holder->produceAssertions__setByUser__;
}
template <> void Options::set(
    options::produceAssignments__option_t,
    const options::produceAssignments__option_t::type& x)
{
  d_holder->produceAssignments = x;
}
template <> const options::produceAssignments__option_t::type& Options::operator[](
    options::produceAssignments__option_t) const
{
  return d_holder->produceAssignments;
}
template <> bool Options::wasSetByUser(options::produceAssignments__option_t) const
{
  return d_holder->produceAssignments__setByUser__;
}
template <> void Options::set(
    options::produceModels__option_t,
    const options::produceModels__option_t::type& x)
{
  d_holder->produceModels = x;
}
template <> const options::produceModels__option_t::type& Options::operator[](
    options::produceModels__option_t) const
{
  return d_holder->produceModels;
}
template <> bool Options::wasSetByUser(options::produceModels__option_t) const
{
  return d_holder->produceModels__setByUser__;
}
template <> const options::unsatAssumptions__option_t::type& Options::operator[](
    options::unsatAssumptions__option_t) const
{
  return d_holder->unsatAssumptions;
}
template <> bool Options::wasSetByUser(options::unsatAssumptions__option_t) const
{
  return d_holder->unsatAssumptions__setByUser__;
}
template <> void Options::set(
    options::unsatCores__option_t,
    const options::unsatCores__option_t::type& x)
{
  d_holder->unsatCores = x;
}
template <> const options::unsatCores__option_t::type& Options::operator[](
    options::unsatCores__option_t) const
{
  return d_holder->unsatCores;
}
template <> bool Options::wasSetByUser(options::unsatCores__option_t) const
{
  return d_holder->unsatCores__setByUser__;
}
template <> void Options::set(
    options::proof__option_t,
    const options::proof__option_t::type& x)
{
  d_holder->proof = x;
}
template <> const options::proof__option_t::type& Options::operator[](
    options::proof__option_t) const
{
  return d_holder->proof;
}
template <> bool Options::wasSetByUser(options::proof__option_t) const
{
  return d_holder->proof__setByUser__;
}
template <> const options::quantifierStep__option_t::type& Options::operator[](
    options::quantifierStep__option_t) const
{
  return d_holder->quantifierStep;
}
template <> bool Options::wasSetByUser(options::quantifierStep__option_t) const
{
  return d_holder->quantifierStep__setByUser__;
}
template <> const options::regularChannelName__option_t::type& Options::operator[](
    options::regularChannelName__option_t) const
{
  return d_holder->regularChannelName;
}
template <> bool Options::wasSetByUser(options::regularChannelName__option_t) const
{
  return d_holder->regularChannelName__setByUser__;
}
template <> void Options::set(
    options::repeatSimp__option_t,
    const options::repeatSimp__option_t::type& x)
{
  d_holder->repeatSimp = x;
}
template <> const options::repeatSimp__option_t::type& Options::operator[](
    options::repeatSimp__option_t) const
{
  return d_holder->repeatSimp;
}
template <> bool Options::wasSetByUser(options::repeatSimp__option_t) const
{
  return d_holder->repeatSimp__setByUser__;
}
template <> const options::restartStep__option_t::type& Options::operator[](
    options::restartStep__option_t) const
{
  return d_holder->restartStep;
}
template <> bool Options::wasSetByUser(options::restartStep__option_t) const
{
  return d_holder->restartStep__setByUser__;
}
template <> const options::rewriteStep__option_t::type& Options::operator[](
    options::rewriteStep__option_t) const
{
  return d_holder->rewriteStep;
}
template <> bool Options::wasSetByUser(options::rewriteStep__option_t) const
{
  return d_holder->rewriteStep__setByUser__;
}
template <> const options::perCallResourceLimit__option_t::type& Options::operator[](
    options::perCallResourceLimit__option_t) const
{
  return d_holder->perCallResourceLimit;
}
template <> bool Options::wasSetByUser(options::perCallResourceLimit__option_t) const
{
  return d_holder->perCallResourceLimit__setByUser__;
}
template <> const options::cumulativeResourceLimit__option_t::type& Options::operator[](
    options::cumulativeResourceLimit__option_t) const
{
  return d_holder->cumulativeResourceLimit;
}
template <> bool Options::wasSetByUser(options::cumulativeResourceLimit__option_t) const
{
  return d_holder->cumulativeResourceLimit__setByUser__;
}
template <> const options::satConflictStep__option_t::type& Options::operator[](
    options::satConflictStep__option_t) const
{
  return d_holder->satConflictStep;
}
template <> bool Options::wasSetByUser(options::satConflictStep__option_t) const
{
  return d_holder->satConflictStep__setByUser__;
}
template <> void Options::set(
    options::compressItes__option_t,
    const options::compressItes__option_t::type& x)
{
  d_holder->compressItes = x;
}
template <> const options::compressItes__option_t::type& Options::operator[](
    options::compressItes__option_t) const
{
  return d_holder->compressItes;
}
template <> bool Options::wasSetByUser(options::compressItes__option_t) const
{
  return d_holder->compressItes__setByUser__;
}
template <> const options::zombieHuntThreshold__option_t::type& Options::operator[](
    options::zombieHuntThreshold__option_t) const
{
  return d_holder->zombieHuntThreshold;
}
template <> bool Options::wasSetByUser(options::zombieHuntThreshold__option_t) const
{
  return d_holder->zombieHuntThreshold__setByUser__;
}
template <> void Options::set(
    options::simplifyWithCareEnabled__option_t,
    const options::simplifyWithCareEnabled__option_t::type& x)
{
  d_holder->simplifyWithCareEnabled = x;
}
template <> const options::simplifyWithCareEnabled__option_t::type& Options::operator[](
    options::simplifyWithCareEnabled__option_t) const
{
  return d_holder->simplifyWithCareEnabled;
}
template <> bool Options::wasSetByUser(options::simplifyWithCareEnabled__option_t) const
{
  return d_holder->simplifyWithCareEnabled__setByUser__;
}
template <> void Options::set(
    options::simplificationMode__option_t,
    const options::simplificationMode__option_t::type& x)
{
  d_holder->simplificationMode = x;
}
template <> const options::simplificationMode__option_t::type& Options::operator[](
    options::simplificationMode__option_t) const
{
  return d_holder->simplificationMode;
}
template <> bool Options::wasSetByUser(options::simplificationMode__option_t) const
{
  return d_holder->simplificationMode__setByUser__;
}
template <> const options::solveBVAsInt__option_t::type& Options::operator[](
    options::solveBVAsInt__option_t) const
{
  return d_holder->solveBVAsInt;
}
template <> bool Options::wasSetByUser(options::solveBVAsInt__option_t) const
{
  return d_holder->solveBVAsInt__setByUser__;
}
template <> const options::solveIntAsBV__option_t::type& Options::operator[](
    options::solveIntAsBV__option_t) const
{
  return d_holder->solveIntAsBV;
}
template <> bool Options::wasSetByUser(options::solveIntAsBV__option_t) const
{
  return d_holder->solveIntAsBV__setByUser__;
}
template <> const options::solveRealAsInt__option_t::type& Options::operator[](
    options::solveRealAsInt__option_t) const
{
  return d_holder->solveRealAsInt;
}
template <> bool Options::wasSetByUser(options::solveRealAsInt__option_t) const
{
  return d_holder->solveRealAsInt__setByUser__;
}
template <> void Options::set(
    options::sortInference__option_t,
    const options::sortInference__option_t::type& x)
{
  d_holder->sortInference = x;
}
template <> const options::sortInference__option_t::type& Options::operator[](
    options::sortInference__option_t) const
{
  return d_holder->sortInference;
}
template <> bool Options::wasSetByUser(options::sortInference__option_t) const
{
  return d_holder->sortInference__setByUser__;
}
template <> const options::doStaticLearning__option_t::type& Options::operator[](
    options::doStaticLearning__option_t) const
{
  return d_holder->doStaticLearning;
}
template <> bool Options::wasSetByUser(options::doStaticLearning__option_t) const
{
  return d_holder->doStaticLearning__setByUser__;
}
template <> void Options::set(
    options::sygusOut__option_t,
    const options::sygusOut__option_t::type& x)
{
  d_holder->sygusOut = x;
}
template <> const options::sygusOut__option_t::type& Options::operator[](
    options::sygusOut__option_t) const
{
  return d_holder->sygusOut;
}
template <> bool Options::wasSetByUser(options::sygusOut__option_t) const
{
  return d_holder->sygusOut__setByUser__;
}
template <> const options::sygusPrintCallbacks__option_t::type& Options::operator[](
    options::sygusPrintCallbacks__option_t) const
{
  return d_holder->sygusPrintCallbacks;
}
template <> bool Options::wasSetByUser(options::sygusPrintCallbacks__option_t) const
{
  return d_holder->sygusPrintCallbacks__setByUser__;
}
template <> const options::theoryCheckStep__option_t::type& Options::operator[](
    options::theoryCheckStep__option_t) const
{
  return d_holder->theoryCheckStep;
}
template <> bool Options::wasSetByUser(options::theoryCheckStep__option_t) const
{
  return d_holder->theoryCheckStep__setByUser__;
}
template <> const options::perCallMillisecondLimit__option_t::type& Options::operator[](
    options::perCallMillisecondLimit__option_t) const
{
  return d_holder->perCallMillisecondLimit;
}
template <> bool Options::wasSetByUser(options::perCallMillisecondLimit__option_t) const
{
  return d_holder->perCallMillisecondLimit__setByUser__;
}
template <> const options::cumulativeMillisecondLimit__option_t::type& Options::operator[](
    options::cumulativeMillisecondLimit__option_t) const
{
  return d_holder->cumulativeMillisecondLimit;
}
template <> bool Options::wasSetByUser(options::cumulativeMillisecondLimit__option_t) const
{
  return d_holder->cumulativeMillisecondLimit__setByUser__;
}
template <> void Options::set(
    options::unconstrainedSimp__option_t,
    const options::unconstrainedSimp__option_t::type& x)
{
  d_holder->unconstrainedSimp = x;
}
template <> const options::unconstrainedSimp__option_t::type& Options::operator[](
    options::unconstrainedSimp__option_t) const
{
  return d_holder->unconstrainedSimp;
}
template <> bool Options::wasSetByUser(options::unconstrainedSimp__option_t) const
{
  return d_holder->unconstrainedSimp__setByUser__;
}


namespace options {

struct abstractValues__option_t abstractValues;
struct ackermann__option_t ackermann;
struct bitblastStep__option_t bitblastStep;
struct blockModelsMode__option_t blockModelsMode;
struct bvEagerAssertStep__option_t bvEagerAssertStep;
struct bvPropagationStep__option_t bvPropagationStep;
struct bvSatConflictStep__option_t bvSatConflictStep;
struct checkAbducts__option_t checkAbducts;
struct checkModels__option_t checkModels;
struct checkProofs__option_t checkProofs;
struct checkSynthSol__option_t checkSynthSol;
struct checkUnsatCores__option_t checkUnsatCores;
struct cnfStep__option_t cnfStep;
struct cpuTime__option_t cpuTime;
struct debugCheckModels__option_t debugCheckModels;
struct decisionStep__option_t decisionStep;
struct diagnosticChannelName__option_t diagnosticChannelName;
struct dumpInstantiations__option_t dumpInstantiations;
struct dumpModels__option_t dumpModels;
struct dumpProofs__option_t dumpProofs;
struct dumpSynth__option_t dumpSynth;
struct dumpToFileName__option_t dumpToFileName;
struct dumpUnsatCores__option_t dumpUnsatCores;
struct dumpUnsatCoresFull__option_t dumpUnsatCoresFull;
struct dumpModeString__option_t dumpModeString;
struct expandDefinitions__option_t expandDefinitions;
struct extRewPrep__option_t extRewPrep;
struct extRewPrepAgg__option_t extRewPrepAgg;
struct forceNoLimitCpuWhileDump__option_t forceNoLimitCpuWhileDump;
struct hardLimit__option_t hardLimit;
struct incrementalSolving__option_t incrementalSolving;
struct interactiveMode__option_t interactiveMode;
struct doITESimp__option_t doITESimp;
struct lemmaStep__option_t lemmaStep;
struct modelCoresMode__option_t modelCoresMode;
struct modelUninterpDtEnum__option_t modelUninterpDtEnum;
struct modelWitnessValue__option_t modelWitnessValue;
struct doITESimpOnRepeat__option_t doITESimpOnRepeat;
struct parseStep__option_t parseStep;
struct preprocessStep__option_t preprocessStep;
struct produceAbducts__option_t produceAbducts;
struct produceAssertions__option_t produceAssertions;
struct produceAssignments__option_t produceAssignments;
struct produceModels__option_t produceModels;
struct unsatAssumptions__option_t unsatAssumptions;
struct unsatCores__option_t unsatCores;
struct proof__option_t proof;
struct quantifierStep__option_t quantifierStep;
struct regularChannelName__option_t regularChannelName;
struct repeatSimp__option_t repeatSimp;
struct restartStep__option_t restartStep;
struct rewriteStep__option_t rewriteStep;
struct perCallResourceLimit__option_t perCallResourceLimit;
struct cumulativeResourceLimit__option_t cumulativeResourceLimit;
struct satConflictStep__option_t satConflictStep;
struct compressItes__option_t compressItes;
struct zombieHuntThreshold__option_t zombieHuntThreshold;
struct simplifyWithCareEnabled__option_t simplifyWithCareEnabled;
struct simplificationMode__option_t simplificationMode;
struct solveBVAsInt__option_t solveBVAsInt;
struct solveIntAsBV__option_t solveIntAsBV;
struct solveRealAsInt__option_t solveRealAsInt;
struct sortInference__option_t sortInference;
struct doStaticLearning__option_t doStaticLearning;
struct sygusOut__option_t sygusOut;
struct sygusPrintCallbacks__option_t sygusPrintCallbacks;
struct theoryCheckStep__option_t theoryCheckStep;
struct perCallMillisecondLimit__option_t perCallMillisecondLimit;
struct cumulativeMillisecondLimit__option_t cumulativeMillisecondLimit;
struct unconstrainedSimp__option_t unconstrainedSimp;


std::ostream&
operator<<(std::ostream& os, BlockModelsMode mode)
{
  os << "BlockModelsMode::";
  switch(mode) {
    case BlockModelsMode::NONE:
      os << "NONE";
      break;
    case BlockModelsMode::LITERALS:
      os << "LITERALS";
      break;
    case BlockModelsMode::VALUES:
      os << "VALUES";
      break;
    default:
        Unreachable();
  }
  return os;
}

BlockModelsMode
stringToBlockModelsMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return BlockModelsMode::NONE;
  }
  else if (optarg == "literals")
  {
    return BlockModelsMode::LITERALS;
  }
  else if (optarg == "values")
  {
    return BlockModelsMode::VALUES;
  }
  else if (optarg == "help")
  {
    puts("Blocking models modes.\n"
         "Available modes for --block-models are:\n"
         "+ none (default)\n"
         "  Do not block models.\n"
         "+ literals\n"
         "  Block models based on the SAT skeleton.\n"
         "+ values\n"
         "  Block models based on the concrete model values for the free variables.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --block-models: `") +
                          optarg + "'.  Try --block-models=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, ModelCoresMode mode)
{
  os << "ModelCoresMode::";
  switch(mode) {
    case ModelCoresMode::NONE:
      os << "NONE";
      break;
    case ModelCoresMode::SIMPLE:
      os << "SIMPLE";
      break;
    case ModelCoresMode::NON_IMPLIED:
      os << "NON_IMPLIED";
      break;
    default:
        Unreachable();
  }
  return os;
}

ModelCoresMode
stringToModelCoresMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return ModelCoresMode::NONE;
  }
  else if (optarg == "simple")
  {
    return ModelCoresMode::SIMPLE;
  }
  else if (optarg == "non-implied")
  {
    return ModelCoresMode::NON_IMPLIED;
  }
  else if (optarg == "help")
  {
    puts("Model cores modes.\n"
         "Available modes for --model-cores are:\n"
         "+ none (default)\n"
         "  Do not compute model cores.\n"
         "+ simple\n"
         "  Only include a subset of variables whose values are sufficient to show the\n"
         "  input formula is satisfied by the given model.\n"
         "+ non-implied\n"
         "  Only include a subset of variables whose values, in addition to the values of\n"
         "  variables whose values are implied, are sufficient to show the input formula\n"
         "  is satisfied by the given model.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --model-cores: `") +
                          optarg + "'.  Try --model-cores=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, SimplificationMode mode)
{
  os << "SimplificationMode::";
  switch(mode) {
    case SimplificationMode::NONE:
      os << "NONE";
      break;
    case SimplificationMode::BATCH:
      os << "BATCH";
      break;
    default:
        Unreachable();
  }
  return os;
}

SimplificationMode
stringToSimplificationMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "none")
  {
    return SimplificationMode::NONE;
  }
  else if (optarg == "batch")
  {
    return SimplificationMode::BATCH;
  }
  else if (optarg == "help")
  {
    puts("Simplification modes.\n"
         "Available modes for --simplification are:\n"
         "+ none\n"
         "  Do not perform nonclausal simplification.\n"
         "+ batch (default)\n"
         "  Save up all ASSERTions; run nonclausal simplification and clausal (MiniSat)\n"
         "  propagation for all of them only after reaching a querying command (CHECKSAT\n"
         "  or QUERY or predicate SUBTYPE declaration).\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --simplification: `") +
                          optarg + "'.  Try --simplification=help.");
  }
}

std::ostream&
operator<<(std::ostream& os, SygusSolutionOutMode mode)
{
  os << "SygusSolutionOutMode::";
  switch(mode) {
    case SygusSolutionOutMode::STATUS:
      os << "STATUS";
      break;
    case SygusSolutionOutMode::STATUS_AND_DEF:
      os << "STATUS_AND_DEF";
      break;
    case SygusSolutionOutMode::STATUS_OR_DEF:
      os << "STATUS_OR_DEF";
      break;
    case SygusSolutionOutMode::STANDARD:
      os << "STANDARD";
      break;
    default:
        Unreachable();
  }
  return os;
}

SygusSolutionOutMode
stringToSygusSolutionOutMode(const std::string& option, const std::string& optarg)
{
  if (optarg == "status")
  {
    return SygusSolutionOutMode::STATUS;
  }
  else if (optarg == "status-and-def")
  {
    return SygusSolutionOutMode::STATUS_AND_DEF;
  }
  else if (optarg == "status-or-def")
  {
    return SygusSolutionOutMode::STATUS_OR_DEF;
  }
  else if (optarg == "sygus-standard")
  {
    return SygusSolutionOutMode::STANDARD;
  }
  else if (optarg == "help")
  {
    puts("Modes for sygus solution output.\n"
         "Available modes for --sygus-out are:\n"
         "+ status\n"
         "  Print only status for check-synth calls.\n"
         "+ status-and-def (default)\n"
         "  Print status followed by definition corresponding to solution.\n"
         "+ status-or-def\n"
         "  Print status if infeasible, or definition corresponding to solution if\n"
         "  feasible.\n"
         "+ sygus-standard\n"
         "  Print based on SyGuS standard.\n");
    exit(1);
  }
  else
  {
    throw OptionException(std::string("unknown option for --sygus-out: `") +
                          optarg + "'.  Try --sygus-out=help.");
  }
}


}  // namespace options
}  // namespace CVC4
