/* search_entry.c generated by valac 0.56.17, the Vala compiler
 * generated from search_entry.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>

#define GETTEXT_PACKAGE "deepin-terminal-gtk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_SEARCH_ENTRY (widgets_search_entry_get_type ())
#define WIDGETS_SEARCH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_SEARCH_ENTRY, WidgetsSearchEntry))
#define WIDGETS_SEARCH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_SEARCH_ENTRY, WidgetsSearchEntryClass))
#define WIDGETS_IS_SEARCH_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_SEARCH_ENTRY))
#define WIDGETS_IS_SEARCH_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_SEARCH_ENTRY))
#define WIDGETS_SEARCH_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_SEARCH_ENTRY, WidgetsSearchEntryClass))

typedef struct _WidgetsSearchEntry WidgetsSearchEntry;
typedef struct _WidgetsSearchEntryClass WidgetsSearchEntryClass;
typedef struct _WidgetsSearchEntryPrivate WidgetsSearchEntryPrivate;

#define ANIMATION_TYPE_ANIMATE_TIMER (animation_animate_timer_get_type ())
#define ANIMATION_ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), ANIMATION_TYPE_ANIMATE_TIMER, AnimationAnimateTimer))
#define ANIMATION_ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), ANIMATION_TYPE_ANIMATE_TIMER, AnimationAnimateTimerClass))
#define ANIMATION_IS_ANIMATE_TIMER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), ANIMATION_TYPE_ANIMATE_TIMER))
#define ANIMATION_IS_ANIMATE_TIMER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), ANIMATION_TYPE_ANIMATE_TIMER))
#define ANIMATION_ANIMATE_TIMER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), ANIMATION_TYPE_ANIMATE_TIMER, AnimationAnimateTimerClass))

typedef struct _AnimationAnimateTimer AnimationAnimateTimer;
typedef struct _AnimationAnimateTimerClass AnimationAnimateTimerClass;

#define WIDGETS_TYPE_CLICK_EVENT_BOX (widgets_click_event_box_get_type ())
#define WIDGETS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBox))
#define WIDGETS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))
#define WIDGETS_IS_CLICK_EVENT_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_IS_CLICK_EVENT_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CLICK_EVENT_BOX))
#define WIDGETS_CLICK_EVENT_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CLICK_EVENT_BOX, WidgetsClickEventBoxClass))

typedef struct _WidgetsClickEventBox WidgetsClickEventBox;
typedef struct _WidgetsClickEventBoxClass WidgetsClickEventBoxClass;

#define WIDGETS_TYPE_IMAGE_BUTTON (widgets_image_button_get_type ())
#define WIDGETS_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_IMAGE_BUTTON, WidgetsImageButton))
#define WIDGETS_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_IMAGE_BUTTON, WidgetsImageButtonClass))
#define WIDGETS_IS_IMAGE_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_IMAGE_BUTTON))
#define WIDGETS_IS_IMAGE_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_IMAGE_BUTTON))
#define WIDGETS_IMAGE_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_IMAGE_BUTTON, WidgetsImageButtonClass))

typedef struct _WidgetsImageButton WidgetsImageButton;
typedef struct _WidgetsImageButtonClass WidgetsImageButtonClass;

#define WIDGETS_TYPE_ENTRY (widgets_entry_get_type ())
#define WIDGETS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_ENTRY, WidgetsEntry))
#define WIDGETS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_ENTRY, WidgetsEntryClass))
#define WIDGETS_IS_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_ENTRY))
#define WIDGETS_IS_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_ENTRY))
#define WIDGETS_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_ENTRY, WidgetsEntryClass))

typedef struct _WidgetsEntry WidgetsEntry;
typedef struct _WidgetsEntryClass WidgetsEntryClass;
enum  {
	WIDGETS_SEARCH_ENTRY_0_PROPERTY,
	WIDGETS_SEARCH_ENTRY_NUM_PROPERTIES
};
static GParamSpec* widgets_search_entry_properties[WIDGETS_SEARCH_ENTRY_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef gdouble (*AnimationAnimateTimerEasingFunc) (gdouble x, gpointer user_data);

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _WidgetsSearchEntry {
	GtkEventBox parent_instance;
	WidgetsSearchEntryPrivate * priv;
	AnimationAnimateTimer* timer;
	GtkBox* box;
	GtkBox* display_box;
	GtkLabel* search_label;
	WidgetsImageButton* clear_button;
	WidgetsEntry* search_entry;
	WidgetsImageButton* search_image;
	gint animation_time;
	gint clear_button_margin_right;
	gint height;
	gint search_image_animate_start_x;
	gint search_image_margin_right;
	gint search_image_margin_x;
};

struct _WidgetsSearchEntryClass {
	GtkEventBoxClass parent_class;
};

static gpointer widgets_search_entry_parent_class = NULL;

VALA_EXTERN GType widgets_search_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsSearchEntry, g_object_unref)
VALA_EXTERN GType animation_animate_timer_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AnimationAnimateTimer, g_object_unref)
VALA_EXTERN GType widgets_click_event_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsClickEventBox, g_object_unref)
VALA_EXTERN GType widgets_image_button_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsImageButton, g_object_unref)
VALA_EXTERN GType widgets_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsEntry, g_object_unref)
VALA_EXTERN WidgetsSearchEntry* widgets_search_entry_new (void);
VALA_EXTERN WidgetsSearchEntry* widgets_search_entry_construct (GType object_type);
VALA_EXTERN gdouble animation_animate_timer_ease_in_out (gdouble x);
static gdouble _animation_animate_timer_ease_in_out_animation_animate_timer_easing_func (gdouble x,
                                                                                  gpointer self);
VALA_EXTERN AnimationAnimateTimer* animation_animate_timer_new (AnimationAnimateTimerEasingFunc func,
                                                    gpointer func_target,
                                                    gint speed);
VALA_EXTERN AnimationAnimateTimer* animation_animate_timer_construct (GType object_type,
                                                          AnimationAnimateTimerEasingFunc func,
                                                          gpointer func_target,
                                                          gint speed);
VALA_EXTERN void widgets_search_entry_on_animate (WidgetsSearchEntry* self,
                                      gdouble progress);
static void _widgets_search_entry_on_animate_animation_animate_timer_animate (AnimationAnimateTimer* _sender,
                                                                       gdouble progress,
                                                                       gpointer self);
VALA_EXTERN WidgetsImageButton* widgets_image_button_new (const gchar* image_path,
                                              gboolean theme_button,
                                              const gchar* text,
                                              gint text_size);
VALA_EXTERN WidgetsImageButton* widgets_image_button_construct (GType object_type,
                                                    const gchar* image_path,
                                                    gboolean theme_button,
                                                    const gchar* text,
                                                    gint text_size);
VALA_EXTERN WidgetsEntry* widgets_entry_new (void);
VALA_EXTERN WidgetsEntry* widgets_entry_construct (GType object_type);
static void __lambda27_ (WidgetsSearchEntry* self,
                  WidgetsClickEventBox* w,
                  GdkEventButton* e);
static void ___lambda27__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                                   GdkEventButton* event,
                                                   gpointer self);
VALA_EXTERN void widgets_search_entry_switch_to_display (WidgetsSearchEntry* self);
static void __lambda28_ (WidgetsSearchEntry* self,
                  GtkWidget* w);
VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN gboolean widgets_config_window_is_light_theme (WidgetsConfigWindow* self);
static void ___lambda28__gtk_widget_realize (GtkWidget* _sender,
                                      gpointer self);
static gboolean __lambda29_ (WidgetsSearchEntry* self,
                      GtkWidget* w,
                      GdkEventButton* e);
VALA_EXTERN void animation_animate_timer_reset (AnimationAnimateTimer* self,
                                    gint temp_speed);
static gboolean ___lambda29__gtk_widget_button_press_event (GtkWidget* _sender,
                                                     GdkEventButton* event,
                                                     gpointer self);
static gboolean __lambda30_ (WidgetsSearchEntry* self,
                      GtkWidget* w,
                      GdkEventKey* e);
VALA_EXTERN gchar* keymap_get_keyevent_name (GdkEventKey* key_event);
static gboolean ___lambda30__gtk_widget_key_press_event (GtkWidget* _sender,
                                                  GdkEventKey* event,
                                                  gpointer self);
VALA_EXTERN void animation_animate_timer_stop (AnimationAnimateTimer* self);
VALA_EXTERN void widgets_search_entry_switch_to_input (WidgetsSearchEntry* self);
VALA_EXTERN void utils_remove_all_children (GtkContainer* container);
static void widgets_search_entry_finalize (GObject * obj);
static GType widgets_search_entry_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static gdouble
_animation_animate_timer_ease_in_out_animation_animate_timer_easing_func (gdouble x,
                                                                          gpointer self)
{
	gdouble result;
	result = animation_animate_timer_ease_in_out (x);
	return result;
}

static void
_widgets_search_entry_on_animate_animation_animate_timer_animate (AnimationAnimateTimer* _sender,
                                                                  gdouble progress,
                                                                  gpointer self)
{
	widgets_search_entry_on_animate ((WidgetsSearchEntry*) self, progress);
}

static void
__lambda27_ (WidgetsSearchEntry* self,
             WidgetsClickEventBox* w,
             GdkEventButton* e)
{
	WidgetsEntry* _tmp0_;
	g_return_if_fail (w != NULL);
	g_return_if_fail (e != NULL);
	_tmp0_ = self->search_entry;
	gtk_entry_set_text ((GtkEntry*) _tmp0_, "");
}

static void
___lambda27__widgets_click_event_box_clicked (WidgetsClickEventBox* _sender,
                                              GdkEventButton* event,
                                              gpointer self)
{
	__lambda27_ ((WidgetsSearchEntry*) self, _sender, event);
}

static void
__lambda28_ (WidgetsSearchEntry* self,
             GtkWidget* w)
{
	gboolean is_light_theme = FALSE;
	GtkWidget* _tmp0_;
	g_return_if_fail (w != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	is_light_theme = widgets_config_window_is_light_theme (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
	if (is_light_theme) {
		WidgetsEntry* _tmp1_;
		GtkStyleContext* _tmp2_;
		GtkLabel* _tmp3_;
		GtkStyleContext* _tmp4_;
		_tmp1_ = self->search_entry;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) _tmp1_);
		gtk_style_context_add_class (_tmp2_, "remote_search_light_entry");
		_tmp3_ = self->search_label;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
		gtk_style_context_add_class (_tmp4_, "remote_search_label_light");
	} else {
		WidgetsEntry* _tmp5_;
		GtkStyleContext* _tmp6_;
		GtkLabel* _tmp7_;
		GtkStyleContext* _tmp8_;
		_tmp5_ = self->search_entry;
		_tmp6_ = gtk_widget_get_style_context ((GtkWidget*) _tmp5_);
		gtk_style_context_add_class (_tmp6_, "remote_search_dark_entry");
		_tmp7_ = self->search_label;
		_tmp8_ = gtk_widget_get_style_context ((GtkWidget*) _tmp7_);
		gtk_style_context_add_class (_tmp8_, "remote_search_label_dark");
	}
}

static void
___lambda28__gtk_widget_realize (GtkWidget* _sender,
                                 gpointer self)
{
	__lambda28_ ((WidgetsSearchEntry*) self, _sender);
}

static gboolean
__lambda29_ (WidgetsSearchEntry* self,
             GtkWidget* w,
             GdkEventButton* e)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkLabel* _tmp2_;
	WidgetsImageButton* _tmp3_;
	gint _tmp4_ = 0;
	WidgetsImageButton* _tmp5_;
	AnimationAnimateTimer* _tmp6_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = self->display_box;
	gtk_widget_set_halign ((GtkWidget*) _tmp0_, GTK_ALIGN_START);
	_tmp1_ = self->display_box;
	_tmp2_ = self->search_label;
	gtk_container_remove ((GtkContainer*) _tmp1_, (GtkWidget*) _tmp2_);
	_tmp3_ = self->search_image;
	gtk_widget_translate_coordinates ((GtkWidget*) self, (GtkWidget*) _tmp3_, 0, 0, &_tmp4_, NULL);
	self->search_image_animate_start_x = _tmp4_;
	self->search_image_animate_start_x = abs (self->search_image_animate_start_x) - self->search_image_margin_x;
	_tmp5_ = self->search_image;
	gtk_widget_set_margin_left ((GtkWidget*) _tmp5_, self->search_image_margin_x + self->search_image_animate_start_x);
	_tmp6_ = self->timer;
	animation_animate_timer_reset (_tmp6_, -1);
	result = FALSE;
	return result;
}

static gboolean
___lambda29__gtk_widget_button_press_event (GtkWidget* _sender,
                                            GdkEventButton* event,
                                            gpointer self)
{
	gboolean result;
	result = __lambda29_ ((WidgetsSearchEntry*) self, _sender, event);
	return result;
}

static gboolean
__lambda30_ (WidgetsSearchEntry* self,
             GtkWidget* w,
             GdkEventKey* e)
{
	gchar* keyname = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	_tmp0_ = keymap_get_keyevent_name (e);
	keyname = _tmp0_;
	_tmp1_ = keyname;
	if (g_strcmp0 (_tmp1_, "Esc") == 0) {
		widgets_search_entry_switch_to_display (self);
	}
	result = FALSE;
	_g_free0 (keyname);
	return result;
}

static gboolean
___lambda30__gtk_widget_key_press_event (GtkWidget* _sender,
                                         GdkEventKey* event,
                                         gpointer self)
{
	gboolean result;
	result = __lambda30_ ((WidgetsSearchEntry*) self, _sender, event);
	return result;
}

WidgetsSearchEntry*
widgets_search_entry_construct (GType object_type)
{
	WidgetsSearchEntry * self = NULL;
	AnimationAnimateTimer* _tmp0_;
	AnimationAnimateTimer* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	WidgetsImageButton* _tmp4_;
	WidgetsImageButton* _tmp5_;
	WidgetsImageButton* _tmp6_;
	GtkLabel* _tmp7_;
	GtkLabel* _tmp8_;
	GtkLabel* _tmp9_;
	WidgetsEntry* _tmp10_;
	WidgetsEntry* _tmp11_;
	WidgetsImageButton* _tmp12_;
	WidgetsImageButton* _tmp13_;
	WidgetsImageButton* _tmp14_;
	WidgetsImageButton* _tmp15_;
	GtkBox* _tmp16_;
	self = (WidgetsSearchEntry*) g_object_new (object_type, NULL);
	bindtextdomain (GETTEXT_PACKAGE, "/usr/share/locale");
	gtk_widget_add_events ((GtkWidget*) self, (gint) (((GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK) | GDK_POINTER_MOTION_MASK) | GDK_LEAVE_NOTIFY_MASK));
	gtk_widget_set_size_request ((GtkWidget*) self, -1, self->height);
	_tmp0_ = animation_animate_timer_new (_animation_animate_timer_ease_in_out_animation_animate_timer_easing_func, NULL, self->animation_time);
	_g_object_unref0 (self->timer);
	self->timer = _tmp0_;
	_tmp1_ = self->timer;
	g_signal_connect_object (_tmp1_, "animate", (GCallback) _widgets_search_entry_on_animate_animation_animate_timer_animate, self, 0);
	_tmp2_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->box);
	self->box = _tmp2_;
	_tmp3_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->display_box);
	self->display_box = _tmp3_;
	_tmp4_ = widgets_image_button_new ("search", TRUE, NULL, 12);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->search_image);
	self->search_image = _tmp4_;
	_tmp5_ = self->search_image;
	gtk_widget_set_margin_end ((GtkWidget*) _tmp5_, self->search_image_margin_right);
	_tmp6_ = self->search_image;
	gtk_widget_set_valign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	_tmp7_ = (GtkLabel*) gtk_label_new (NULL);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->search_label);
	self->search_label = _tmp7_;
	_tmp8_ = self->search_label;
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_CENTER);
	_tmp9_ = self->search_label;
	gtk_label_set_text (_tmp9_, _ ("Search"));
	_tmp10_ = widgets_entry_new ();
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->search_entry);
	self->search_entry = _tmp10_;
	_tmp11_ = self->search_entry;
	gtk_entry_set_placeholder_text ((GtkEntry*) _tmp11_, _ ("Search"));
	_tmp12_ = widgets_image_button_new ("search_clear", TRUE, NULL, 12);
	g_object_ref_sink (_tmp12_);
	_g_object_unref0 (self->clear_button);
	self->clear_button = _tmp12_;
	_tmp13_ = self->clear_button;
	gtk_widget_set_margin_right ((GtkWidget*) _tmp13_, self->clear_button_margin_right);
	_tmp14_ = self->clear_button;
	gtk_widget_set_valign ((GtkWidget*) _tmp14_, GTK_ALIGN_CENTER);
	_tmp15_ = self->clear_button;
	g_signal_connect_object ((WidgetsClickEventBox*) _tmp15_, "clicked", (GCallback) ___lambda27__widgets_click_event_box_clicked, self, 0);
	widgets_search_entry_switch_to_display (self);
	g_signal_connect_object ((GtkWidget*) self, "realize", (GCallback) ___lambda28__gtk_widget_realize, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) ___lambda29__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) ___lambda30__gtk_widget_key_press_event, self, 0);
	_tmp16_ = self->box;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp16_);
	return self;
}

WidgetsSearchEntry*
widgets_search_entry_new (void)
{
	return widgets_search_entry_construct (WIDGETS_TYPE_SEARCH_ENTRY);
}

void
widgets_search_entry_on_animate (WidgetsSearchEntry* self,
                                 gdouble progress)
{
	WidgetsImageButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->search_image;
	gtk_widget_set_margin_left ((GtkWidget*) _tmp0_, self->search_image_margin_x + ((gint) (self->search_image_animate_start_x * (1.0 - progress))));
	if (progress >= 1.0) {
		AnimationAnimateTimer* _tmp1_;
		_tmp1_ = self->timer;
		animation_animate_timer_stop (_tmp1_);
		widgets_search_entry_switch_to_input (self);
	}
}

void
widgets_search_entry_switch_to_display (WidgetsSearchEntry* self)
{
	GtkBox* _tmp0_;
	WidgetsImageButton* _tmp1_;
	GtkBox* _tmp2_;
	WidgetsImageButton* _tmp3_;
	GtkBox* _tmp4_;
	GtkLabel* _tmp5_;
	GtkBox* _tmp6_;
	GtkBox* _tmp7_;
	GtkBox* _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->box;
	utils_remove_all_children ((GtkContainer*) _tmp0_);
	_tmp1_ = self->search_image;
	gtk_widget_set_margin_left ((GtkWidget*) _tmp1_, 0);
	_tmp2_ = self->display_box;
	_tmp3_ = self->search_image;
	gtk_box_pack_start (_tmp2_, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 0);
	_tmp4_ = self->display_box;
	_tmp5_ = self->search_label;
	gtk_box_pack_start (_tmp4_, (GtkWidget*) _tmp5_, FALSE, FALSE, (guint) 0);
	_tmp6_ = self->display_box;
	gtk_widget_set_halign ((GtkWidget*) _tmp6_, GTK_ALIGN_CENTER);
	_tmp7_ = self->box;
	_tmp8_ = self->display_box;
	gtk_box_pack_start (_tmp7_, (GtkWidget*) _tmp8_, TRUE, TRUE, (guint) 0);
	gtk_widget_show_all ((GtkWidget*) self);
}

void
widgets_search_entry_switch_to_input (WidgetsSearchEntry* self)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	WidgetsImageButton* _tmp3_;
	GtkBox* _tmp4_;
	WidgetsEntry* _tmp5_;
	GtkBox* _tmp6_;
	WidgetsImageButton* _tmp7_;
	WidgetsImageButton* _tmp8_;
	WidgetsEntry* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->box;
	utils_remove_all_children ((GtkContainer*) _tmp0_);
	_tmp1_ = self->display_box;
	utils_remove_all_children ((GtkContainer*) _tmp1_);
	_tmp2_ = self->box;
	_tmp3_ = self->search_image;
	gtk_box_pack_start (_tmp2_, (GtkWidget*) _tmp3_, FALSE, FALSE, (guint) 0);
	_tmp4_ = self->box;
	_tmp5_ = self->search_entry;
	gtk_box_pack_start (_tmp4_, (GtkWidget*) _tmp5_, TRUE, TRUE, (guint) 0);
	_tmp6_ = self->box;
	_tmp7_ = self->clear_button;
	gtk_box_pack_start (_tmp6_, (GtkWidget*) _tmp7_, FALSE, FALSE, (guint) 0);
	_tmp8_ = self->search_image;
	gtk_widget_set_margin_left ((GtkWidget*) _tmp8_, self->search_image_margin_x);
	_tmp9_ = self->search_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp9_);
	gtk_widget_show_all ((GtkWidget*) self);
}

static void
widgets_search_entry_class_init (WidgetsSearchEntryClass * klass,
                                 gpointer klass_data)
{
	widgets_search_entry_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = widgets_search_entry_finalize;
}

static void
widgets_search_entry_instance_init (WidgetsSearchEntry * self,
                                    gpointer klass)
{
	self->animation_time = 100;
	self->clear_button_margin_right = 12;
	self->height = 36;
	self->search_image_margin_right = 5;
	self->search_image_margin_x = 18;
}

static void
widgets_search_entry_finalize (GObject * obj)
{
	WidgetsSearchEntry * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_SEARCH_ENTRY, WidgetsSearchEntry);
	_g_object_unref0 (self->timer);
	_g_object_unref0 (self->box);
	_g_object_unref0 (self->display_box);
	_g_object_unref0 (self->search_label);
	_g_object_unref0 (self->clear_button);
	_g_object_unref0 (self->search_entry);
	_g_object_unref0 (self->search_image);
	G_OBJECT_CLASS (widgets_search_entry_parent_class)->finalize (obj);
}

static GType
widgets_search_entry_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsSearchEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_search_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsSearchEntry), 0, (GInstanceInitFunc) widgets_search_entry_instance_init, NULL };
	GType widgets_search_entry_type_id;
	widgets_search_entry_type_id = g_type_register_static (gtk_event_box_get_type (), "WidgetsSearchEntry", &g_define_type_info, 0);
	return widgets_search_entry_type_id;
}

GType
widgets_search_entry_get_type (void)
{
	static volatile gsize widgets_search_entry_type_id__once = 0;
	if (g_once_init_enter (&widgets_search_entry_type_id__once)) {
		GType widgets_search_entry_type_id;
		widgets_search_entry_type_id = widgets_search_entry_get_type_once ();
		g_once_init_leave (&widgets_search_entry_type_id__once, widgets_search_entry_type_id);
	}
	return widgets_search_entry_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

