/* tabbar.c generated by valac 0.56.17, the Vala compiler
 * generated from tabbar.vala, do not modify */

/* -*- Mode: Vala; indent-tabs-mode: nil; tab-width: 4 -*-
 * -*- coding: utf-8 -*-
 *
 * Copyright (C) 2011 ~ 2018 Deepin, Inc.
 *               2011 ~ 2018 Wang Yong
 *
 * Author:     Wang Yong <wangyong@deepin.com>
 * Maintainer: Wang Yong <wangyong@deepin.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <gdk/gdk.h>
#include <gee.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <pango/pango.h>
#include <cairo-gobject.h>
#include <float.h>
#include <math.h>
#include <glib/gi18n-lib.h>

#define GETTEXT_PACKAGE "deepin-terminal-gtk"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define WIDGETS_TYPE_TABBAR (widgets_tabbar_get_type ())
#define WIDGETS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbar))
#define WIDGETS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))
#define WIDGETS_IS_TABBAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_TABBAR))
#define WIDGETS_IS_TABBAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_TABBAR))
#define WIDGETS_TABBAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_TABBAR, WidgetsTabbarClass))

typedef struct _WidgetsTabbar WidgetsTabbar;
typedef struct _WidgetsTabbarClass WidgetsTabbarClass;
typedef struct _WidgetsTabbarPrivate WidgetsTabbarPrivate;
enum  {
	WIDGETS_TABBAR_0_PROPERTY,
	WIDGETS_TABBAR_NUM_PROPERTIES
};
static GParamSpec* widgets_tabbar_properties[WIDGETS_TABBAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define WIDGETS_TYPE_WORKSPACE_MANAGER (widgets_workspace_manager_get_type ())
#define WIDGETS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManager))
#define WIDGETS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))
#define WIDGETS_IS_WORKSPACE_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_IS_WORKSPACE_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE_MANAGER))
#define WIDGETS_WORKSPACE_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE_MANAGER, WidgetsWorkspaceManagerClass))

typedef struct _WidgetsWorkspaceManager WidgetsWorkspaceManager;
typedef struct _WidgetsWorkspaceManagerClass WidgetsWorkspaceManagerClass;

#define WIDGETS_TYPE_CONFIG_WINDOW (widgets_config_window_get_type ())
#define WIDGETS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow))
#define WIDGETS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))
#define WIDGETS_IS_CONFIG_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_IS_CONFIG_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIG_WINDOW))
#define WIDGETS_CONFIG_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindowClass))

typedef struct _WidgetsConfigWindow WidgetsConfigWindow;
typedef struct _WidgetsConfigWindowClass WidgetsConfigWindowClass;
typedef struct _Block41Data Block41Data;
typedef struct _Block42Data Block42Data;

#define WIDGETS_TYPE_WORKSPACE (widgets_workspace_get_type ())
#define WIDGETS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspace))
#define WIDGETS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))
#define WIDGETS_IS_WORKSPACE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_IS_WORKSPACE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_WORKSPACE))
#define WIDGETS_WORKSPACE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_WORKSPACE, WidgetsWorkspaceClass))

typedef struct _WidgetsWorkspace WidgetsWorkspace;
typedef struct _WidgetsWorkspaceClass WidgetsWorkspaceClass;
typedef struct _WidgetsWorkspaceManagerPrivate WidgetsWorkspaceManagerPrivate;

#define WIDGETS_TYPE_DIALOG (widgets_dialog_get_type ())
#define WIDGETS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_DIALOG, WidgetsDialog))
#define WIDGETS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_DIALOG, WidgetsDialogClass))
#define WIDGETS_IS_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_DIALOG))
#define WIDGETS_IS_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_DIALOG))
#define WIDGETS_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_DIALOG, WidgetsDialogClass))

typedef struct _WidgetsDialog WidgetsDialog;
typedef struct _WidgetsDialogClass WidgetsDialogClass;

#define WIDGETS_TYPE_CONFIRM_DIALOG (widgets_confirm_dialog_get_type ())
#define WIDGETS_CONFIRM_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), WIDGETS_TYPE_CONFIRM_DIALOG, WidgetsConfirmDialog))
#define WIDGETS_CONFIRM_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), WIDGETS_TYPE_CONFIRM_DIALOG, WidgetsConfirmDialogClass))
#define WIDGETS_IS_CONFIRM_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), WIDGETS_TYPE_CONFIRM_DIALOG))
#define WIDGETS_IS_CONFIRM_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), WIDGETS_TYPE_CONFIRM_DIALOG))
#define WIDGETS_CONFIRM_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), WIDGETS_TYPE_CONFIRM_DIALOG, WidgetsConfirmDialogClass))

typedef struct _WidgetsConfirmDialog WidgetsConfirmDialog;
typedef struct _WidgetsConfirmDialogClass WidgetsConfirmDialogClass;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
typedef struct _WidgetsConfigWindowPrivate WidgetsConfigWindowPrivate;

#define CONFIG_TYPE_CONFIG (config_config_get_type ())
#define CONFIG_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), CONFIG_TYPE_CONFIG, ConfigConfig))
#define CONFIG_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), CONFIG_TYPE_CONFIG, ConfigConfigClass))
#define CONFIG_IS_CONFIG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), CONFIG_TYPE_CONFIG))
#define CONFIG_IS_CONFIG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), CONFIG_TYPE_CONFIG))
#define CONFIG_CONFIG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), CONFIG_TYPE_CONFIG, ConfigConfigClass))

typedef struct _ConfigConfig ConfigConfig;
typedef struct _ConfigConfigClass ConfigConfigClass;
typedef struct _ConfigConfigPrivate ConfigConfigPrivate;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
enum  {
	WIDGETS_TABBAR_PRESS_TAB_SIGNAL,
	WIDGETS_TABBAR_UPDATE_TAB_UNDERLINE_SIGNAL,
	WIDGETS_TABBAR_CLOSE_TAB_SIGNAL,
	WIDGETS_TABBAR_NEW_TAB_SIGNAL,
	WIDGETS_TABBAR_NUM_SIGNALS
};
static guint widgets_tabbar_signals[WIDGETS_TABBAR_NUM_SIGNALS] = {0};

struct _WidgetsTabbar {
	GtkDrawingArea parent_instance;
	WidgetsTabbarPrivate * priv;
	GdkRGBA tab_split_dark_color;
	GdkRGBA tab_split_light_color;
	GeeHashMap* tab_highlight_map;
	GeeArrayList* tab_list;
	GdkRGBA hover_arrow_color;
	GdkRGBA inactive_arrow_color;
	GdkRGBA tab_text_color;
	GdkRGBA text_active_color;
	GdkRGBA text_dark_color;
	GdkRGBA text_highlight_color;
	GdkRGBA text_hover_dark_color;
	GdkRGBA text_hover_light_color;
	GdkRGBA text_light_color;
	GeeHashMap* tab_name_map;
	PangoFontDescription* font_description;
	gboolean allowed_add_tab;
	gint font_size;
	gint height;
	gint hover_clip_right_offset;
	gint min_tab_width;
	gint tab_index;
};

struct _WidgetsTabbarClass {
	GtkDrawingAreaClass parent_class;
};

struct _WidgetsTabbarPrivate {
	cairo_surface_t* add_hover_dark_surface;
	cairo_surface_t* add_hover_light_surface;
	cairo_surface_t* add_normal_dark_surface;
	cairo_surface_t* add_normal_light_surface;
	cairo_surface_t* add_press_dark_surface;
	cairo_surface_t* add_press_light_surface;
	cairo_surface_t* close_hover_surface;
	cairo_surface_t* close_normal_surface;
	cairo_surface_t* close_press_surface;
	gboolean draw_hover;
	gboolean is_button_press;
	gdouble draw_scale;
	gint add_button_width;
	gint button_press_x;
	gint button_press_y;
	gint close_button_padding_x;
	gint hover_x;
	gint tab_min_width;
	gint tab_split_width;
	gint text_padding_x;
};

struct _Block41Data {
	int _ref_count_;
	WidgetsTabbar* self;
	WidgetsWorkspaceManager* workspace_manager;
	WidgetsConfigWindow* window;
};

struct _Block42Data {
	int _ref_count_;
	Block41Data * _data41_;
	gint tab_index;
	gint tab_id;
};

struct _WidgetsWorkspaceManager {
	GtkBox parent_instance;
	WidgetsWorkspaceManagerPrivate * priv;
	GeeHashMap* workspace_map;
	WidgetsTabbar* tabbar;
	WidgetsWorkspace* focus_workspace;
	gint workspace_index;
};

struct _WidgetsWorkspaceManagerClass {
	GtkBoxClass parent_class;
};

struct _WidgetsConfigWindow {
	GtkWindow parent_instance;
	WidgetsConfigWindowPrivate * priv;
	ConfigConfig* config;
	GdkRGBA title_line_dark_color;
	GdkRGBA title_line_light_color;
	GdkScreen* screen_monitor;
	GtkBox* box;
	GtkBox* top_box;
	GtkBox* window_frame_box;
	GtkBox* window_widget_box;
	WidgetsWorkspaceManager* workspace_manager;
	gboolean quake_mode;
	gboolean show_quake_menu;
	gboolean* config_theme_is_light;
	gint active_tab_underline_width;
	gint active_tab_underline_x;
	gint cache_height;
	gint cache_width;
	gint reset_timeout_delay;
	gint resize_cache_x;
	gint resize_cache_y;
	gint resize_cache_width;
	gint resize_cache_height;
	gint resize_timeout_delay;
	guint* reset_timeout_source_id;
	guint* resize_timeout_source_id;
};

struct _WidgetsConfigWindowClass {
	GtkWindowClass parent_class;
	void (*toggle_fullscreen) (WidgetsConfigWindow* self);
	void (*window_save_before_quit) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_frame_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
	void (*update_frame) (WidgetsConfigWindow* self);
	GdkCursorType* (*get_cursor_type) (WidgetsConfigWindow* self, gdouble x, gdouble y);
};

struct _ConfigConfig {
	GObject parent_instance;
	ConfigConfigPrivate * priv;
	GeeArrayList* backspace_key_erase_names;
	GeeArrayList* del_key_erase_names;
	GeeArrayList* encoding_names;
	GeeHashMap* erase_map;
	gdouble default_opacity;
	gint default_size;
	gchar* default_mono_font;
	GKeyFile* config_file;
	gchar* config_file_path;
	gchar* temp_theme;
};

struct _ConfigConfigClass {
	GObjectClass parent_class;
};

static gint WidgetsTabbar_private_offset;
static gpointer widgets_tabbar_parent_class = NULL;
VALA_EXTERN gint constant_TITLEBAR_HEIGHT;

VALA_EXTERN GType widgets_tabbar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsTabbar, g_object_unref)
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
VALA_EXTERN WidgetsTabbar* widgets_tabbar_new (void);
VALA_EXTERN WidgetsTabbar* widgets_tabbar_construct (GType object_type);
VALA_EXTERN cairo_surface_t* utils_create_image_surface (const gchar* surface_path);
VALA_EXTERN void utils_hex_to_rgba (const gchar* hex_color,
                        gdouble alpha,
                        GdkRGBA* result);
VALA_EXTERN gboolean widgets_tabbar_on_draw (WidgetsTabbar* self,
                                 GtkWidget* widget,
                                 cairo_t* cr);
static gboolean _widgets_tabbar_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                                  cairo_t* cr,
                                                  gpointer self);
VALA_EXTERN gboolean widgets_tabbar_on_configure (WidgetsTabbar* self,
                                      GtkWidget* widget,
                                      GdkEventConfigure* event);
static gboolean _widgets_tabbar_on_configure_gtk_widget_configure_event (GtkWidget* _sender,
                                                                  GdkEventConfigure* event,
                                                                  gpointer self);
VALA_EXTERN gboolean widgets_tabbar_on_button_press (WidgetsTabbar* self,
                                         GtkWidget* widget,
                                         GdkEventButton* event);
static gboolean _widgets_tabbar_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                                        GdkEventButton* event,
                                                                        gpointer self);
VALA_EXTERN gboolean widgets_tabbar_on_button_release (WidgetsTabbar* self,
                                           GtkWidget* widget,
                                           GdkEventButton* event);
static gboolean _widgets_tabbar_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                            GdkEventButton* event,
                                                                            gpointer self);
VALA_EXTERN gboolean widgets_tabbar_on_motion_notify (WidgetsTabbar* self,
                                          GtkWidget* widget,
                                          GdkEventMotion* event);
static gboolean _widgets_tabbar_on_motion_notify_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                          GdkEventMotion* event,
                                                                          gpointer self);
VALA_EXTERN gboolean widgets_tabbar_on_leave_notify (WidgetsTabbar* self,
                                         GtkWidget* widget,
                                         GdkEventCrossing* event);
static gboolean _widgets_tabbar_on_leave_notify_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                                        GdkEventCrossing* event,
                                                                        gpointer self);
VALA_EXTERN GType widgets_workspace_manager_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspaceManager, g_object_unref)
VALA_EXTERN GType widgets_config_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfigWindow, g_object_unref)
VALA_EXTERN void widgets_tabbar_init (WidgetsTabbar* self,
                          WidgetsWorkspaceManager* workspace_manager,
                          WidgetsConfigWindow* window);
static Block41Data* block41_data_ref (Block41Data* _data41_);
static void block41_data_unref (void * _userdata_);
static void __lambda74_ (Block41Data* _data41_,
                  WidgetsTabbar* t,
                  gint tab_index,
                  gint tab_id);
VALA_EXTERN void widgets_tabbar_unhighlight_tab (WidgetsTabbar* self,
                                     gint tab_id);
VALA_EXTERN void widgets_workspace_manager_switch_workspace (WidgetsWorkspaceManager* self,
                                                 gint workspace_index);
static void ___lambda74__widgets_tabbar_press_tab (WidgetsTabbar* _sender,
                                            gint tab_index,
                                            gint tab_id,
                                            gpointer self);
static void __lambda75_ (Block41Data* _data41_,
                  WidgetsTabbar* t,
                  gint tab_index,
                  gint tab_id);
static Block42Data* block42_data_ref (Block42Data* _data42_);
static void block42_data_unref (void * _userdata_);
VALA_EXTERN GType widgets_workspace_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsWorkspace, g_object_unref)
VALA_EXTERN gboolean widgets_workspace_has_active_term (WidgetsWorkspace* self);
VALA_EXTERN GType widgets_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsDialog, g_object_unref)
VALA_EXTERN GType widgets_confirm_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (WidgetsConfirmDialog, g_object_unref)
VALA_EXTERN WidgetsConfirmDialog* widgets_create_running_confirm_dialog (WidgetsConfigWindow* window);
static void ___lambda84_ (Block42Data* _data42_,
                   WidgetsConfirmDialog* d);
VALA_EXTERN void widgets_tabbar_destroy_tab (WidgetsTabbar* self,
                                 gint index);
VALA_EXTERN void widgets_workspace_manager_remove_workspace (WidgetsWorkspaceManager* self,
                                                 gint index);
static void ____lambda84__widgets_confirm_dialog_confirm (WidgetsConfirmDialog* _sender,
                                                   gpointer self);
static void ___lambda75__widgets_tabbar_close_tab (WidgetsTabbar* _sender,
                                            gint tab_index,
                                            gint tab_id,
                                            gpointer self);
static void __lambda86_ (Block41Data* _data41_,
                  WidgetsTabbar* t);
VALA_EXTERN void widgets_workspace_manager_new_workspace_with_current_directory (WidgetsWorkspaceManager* self,
                                                                     gboolean remote_serve_action);
static void ___lambda86__widgets_tabbar_new_tab (WidgetsTabbar* _sender,
                                          gpointer self);
VALA_EXTERN void widgets_tabbar_reset (WidgetsTabbar* self);
VALA_EXTERN void widgets_tabbar_add_tab (WidgetsTabbar* self,
                             const gchar* tab_name,
                             gint tab_id);
VALA_EXTERN void widgets_tabbar_update_tab_scale (WidgetsTabbar* self);
VALA_EXTERN void widgets_tabbar_rename_tab (WidgetsTabbar* self,
                                gint tab_id,
                                const gchar* tab_name);
VALA_EXTERN gboolean widgets_tabbar_is_focus_tab (WidgetsTabbar* self,
                                      gint tab_id);
VALA_EXTERN void widgets_tabbar_update_window_title (WidgetsTabbar* self,
                                         const gchar* title);
VALA_EXTERN void widgets_tabbar_highlight_tab (WidgetsTabbar* self,
                                   gint tab_id);
static gint* _int_dup (gint* self);
static gboolean _int_equal (const gint * s1,
                     const gint * s2);
VALA_EXTERN void widgets_tabbar_select_next_tab (WidgetsTabbar* self);
VALA_EXTERN void widgets_tabbar_switch_tab (WidgetsTabbar* self,
                                gint new_index);
VALA_EXTERN void widgets_tabbar_select_previous_tab (WidgetsTabbar* self);
VALA_EXTERN void widgets_tabbar_select_first_tab (WidgetsTabbar* self);
VALA_EXTERN void widgets_tabbar_select_end_tab (WidgetsTabbar* self);
VALA_EXTERN void widgets_tabbar_select_nth_tab (WidgetsTabbar* self,
                                    gint index);
VALA_EXTERN void widgets_tabbar_select_tab_with_id (WidgetsTabbar* self,
                                        gint tab_id);
VALA_EXTERN void widgets_tabbar_close_current_tab (WidgetsTabbar* self);
VALA_EXTERN void widgets_tabbar_close_nth_tab (WidgetsTabbar* self,
                                   gint index);
VALA_EXTERN gboolean utils_is_action_mouse_button (GdkEventButton* event);
VALA_EXTERN PangoLayout* widgets_tabbar_get_text_size (WidgetsTabbar* self,
                                           const gchar* text,
                                           gint* width,
                                           gint* height);
VALA_EXTERN gint widgets_tabbar_get_tab_width (WidgetsTabbar* self,
                                   gint name_width);
VALA_EXTERN gint widgets_tabbar_get_tab_close_button_padding (WidgetsTabbar* self);
VALA_EXTERN gboolean utils_is_left_button (GdkEventButton* event);
VALA_EXTERN gboolean utils_is_mouse_wheel (GdkEventButton* event);
VALA_EXTERN gint widgets_tabbar_is_at_tab_close_button (WidgetsTabbar* self,
                                            gint x);
VALA_EXTERN gint widgets_tabbar_get_tab_render_width (WidgetsTabbar* self,
                                          gint name_width);
VALA_EXTERN gboolean widgets_config_window_is_light_theme (WidgetsConfigWindow* self);
VALA_EXTERN void utils_set_context_color (cairo_t* cr,
                              GdkRGBA* color);
VALA_EXTERN void draw_draw_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h,
                          gboolean fill);
VALA_EXTERN GType config_config_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ConfigConfig, g_object_unref)
VALA_EXTERN void draw_clip_rectangle (cairo_t* cr,
                          gint x,
                          gint y,
                          gint w,
                          gint h);
VALA_EXTERN void draw_draw_surface (cairo_t* cr,
                        cairo_surface_t* surface,
                        gint x,
                        gint y,
                        gint width,
                        gint height);
VALA_EXTERN gint widgets_tabbar_get_tab_text_padding (WidgetsTabbar* self);
VALA_EXTERN void draw_draw_layout (cairo_t* cr,
                       PangoLayout* layout,
                       gint x,
                       gint y);
static void g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                            GValue * return_value,
                                            guint n_param_values,
                                            const GValue * param_values,
                                            gpointer invocation_hint,
                                            gpointer marshal_data);
static void widgets_tabbar_finalize (GObject * obj);
static GType widgets_tabbar_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
widgets_tabbar_get_instance_private (WidgetsTabbar* self)
{
	return G_STRUCT_MEMBER_P (self, WidgetsTabbar_private_offset);
}

static void
_vala_PangoFontDescription_free (PangoFontDescription* self)
{
	g_boxed_free (pango_font_description_get_type (), self);
}

static gboolean
_widgets_tabbar_on_draw_gtk_widget_draw (GtkWidget* _sender,
                                         cairo_t* cr,
                                         gpointer self)
{
	gboolean result;
	result = widgets_tabbar_on_draw ((WidgetsTabbar*) self, _sender, cr);
	return result;
}

static gboolean
_widgets_tabbar_on_configure_gtk_widget_configure_event (GtkWidget* _sender,
                                                         GdkEventConfigure* event,
                                                         gpointer self)
{
	gboolean result;
	result = widgets_tabbar_on_configure ((WidgetsTabbar*) self, _sender, event);
	return result;
}

static gboolean
_widgets_tabbar_on_button_press_gtk_widget_button_press_event (GtkWidget* _sender,
                                                               GdkEventButton* event,
                                                               gpointer self)
{
	gboolean result;
	result = widgets_tabbar_on_button_press ((WidgetsTabbar*) self, _sender, event);
	return result;
}

static gboolean
_widgets_tabbar_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender,
                                                                   GdkEventButton* event,
                                                                   gpointer self)
{
	gboolean result;
	result = widgets_tabbar_on_button_release ((WidgetsTabbar*) self, _sender, event);
	return result;
}

static gboolean
_widgets_tabbar_on_motion_notify_gtk_widget_motion_notify_event (GtkWidget* _sender,
                                                                 GdkEventMotion* event,
                                                                 gpointer self)
{
	gboolean result;
	result = widgets_tabbar_on_motion_notify ((WidgetsTabbar*) self, _sender, event);
	return result;
}

static gboolean
_widgets_tabbar_on_leave_notify_gtk_widget_leave_notify_event (GtkWidget* _sender,
                                                               GdkEventCrossing* event,
                                                               gpointer self)
{
	gboolean result;
	result = widgets_tabbar_on_leave_notify ((WidgetsTabbar*) self, _sender, event);
	return result;
}

WidgetsTabbar*
widgets_tabbar_construct (GType object_type)
{
	WidgetsTabbar * self = NULL;
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	GeeHashMap* _tmp2_;
	PangoFontDescription* _tmp3_;
	PangoFontDescription* _tmp4_;
	cairo_surface_t* _tmp5_;
	cairo_surface_t* _tmp6_;
	cairo_surface_t* _tmp7_;
	cairo_surface_t* _tmp8_;
	cairo_surface_t* _tmp9_;
	cairo_surface_t* _tmp10_;
	cairo_surface_t* _tmp11_;
	cairo_surface_t* _tmp12_;
	cairo_surface_t* _tmp13_;
	GdkRGBA _tmp14_ = {0};
	GdkRGBA _tmp15_ = {0};
	GdkRGBA _tmp16_ = {0};
	GdkRGBA _tmp17_ = {0};
	GdkRGBA _tmp18_ = {0};
	GdkRGBA _tmp19_ = {0};
	GdkRGBA _tmp20_ = {0};
	GdkRGBA _tmp21_ = {0};
	GdkRGBA _tmp22_ = {0};
	self = (WidgetsTabbar*) g_object_new (object_type, NULL);
	bindtextdomain (GETTEXT_PACKAGE, "/usr/share/locale");
	gtk_widget_add_events ((GtkWidget*) self, (gint) (((GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK) | GDK_POINTER_MOTION_MASK) | GDK_LEAVE_NOTIFY_MASK));
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->tab_list);
	self->tab_list = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->tab_name_map);
	self->tab_name_map = _tmp1_;
	_tmp2_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, G_TYPE_BOOLEAN, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->tab_highlight_map);
	self->tab_highlight_map = _tmp2_;
	_tmp3_ = pango_font_description_new ();
	__vala_PangoFontDescription_free0 (self->font_description);
	self->font_description = _tmp3_;
	_tmp4_ = self->font_description;
	pango_font_description_set_size (_tmp4_, (gint) (self->font_size * PANGO_SCALE));
	gtk_widget_set_size_request ((GtkWidget*) self, -1, self->height);
	_tmp5_ = utils_create_image_surface ("tab_close_normal.svg");
	_cairo_surface_destroy0 (self->priv->close_normal_surface);
	self->priv->close_normal_surface = _tmp5_;
	_tmp6_ = utils_create_image_surface ("tab_close_hover.svg");
	_cairo_surface_destroy0 (self->priv->close_hover_surface);
	self->priv->close_hover_surface = _tmp6_;
	_tmp7_ = utils_create_image_surface ("tab_close_press.svg");
	_cairo_surface_destroy0 (self->priv->close_press_surface);
	self->priv->close_press_surface = _tmp7_;
	_tmp8_ = utils_create_image_surface ("tab_add_dark_normal.svg");
	_cairo_surface_destroy0 (self->priv->add_normal_dark_surface);
	self->priv->add_normal_dark_surface = _tmp8_;
	_tmp9_ = utils_create_image_surface ("tab_add_dark_hover.svg");
	_cairo_surface_destroy0 (self->priv->add_hover_dark_surface);
	self->priv->add_hover_dark_surface = _tmp9_;
	_tmp10_ = utils_create_image_surface ("tab_add_dark_press.svg");
	_cairo_surface_destroy0 (self->priv->add_press_dark_surface);
	self->priv->add_press_dark_surface = _tmp10_;
	_tmp11_ = utils_create_image_surface ("tab_add_light_normal.svg");
	_cairo_surface_destroy0 (self->priv->add_normal_light_surface);
	self->priv->add_normal_light_surface = _tmp11_;
	_tmp12_ = utils_create_image_surface ("tab_add_light_hover.svg");
	_cairo_surface_destroy0 (self->priv->add_hover_light_surface);
	self->priv->add_hover_light_surface = _tmp12_;
	_tmp13_ = utils_create_image_surface ("tab_add_light_press.svg");
	_cairo_surface_destroy0 (self->priv->add_press_light_surface);
	self->priv->add_press_light_surface = _tmp13_;
	utils_hex_to_rgba ("#393937", 1.0, &_tmp14_);
	self->inactive_arrow_color = _tmp14_;
	utils_hex_to_rgba ("#494943", 1.0, &_tmp15_);
	self->hover_arrow_color = _tmp15_;
	utils_hex_to_rgba ("#ffffff", 1.0, &_tmp16_);
	self->text_hover_dark_color = _tmp16_;
	utils_hex_to_rgba ("#000000", 1.0, &_tmp17_);
	self->text_hover_light_color = _tmp17_;
	utils_hex_to_rgba ("#ffffff", 0.8, &_tmp18_);
	self->text_dark_color = _tmp18_;
	utils_hex_to_rgba ("#000000", 0.8, &_tmp19_);
	self->text_light_color = _tmp19_;
	utils_hex_to_rgba ("#ff9600", 1.0, &_tmp20_);
	self->text_highlight_color = _tmp20_;
	utils_hex_to_rgba ("#ffffff", 0.05, &_tmp21_);
	self->tab_split_dark_color = _tmp21_;
	utils_hex_to_rgba ("#000000", 0.05, &_tmp22_);
	self->tab_split_light_color = _tmp22_;
	memset (&self->text_active_color, 0, sizeof (GdkRGBA));
	memset (&self->tab_text_color, 0, sizeof (GdkRGBA));
	g_signal_connect_object ((GtkWidget*) self, "draw", (GCallback) _widgets_tabbar_on_draw_gtk_widget_draw, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "configure-event", (GCallback) _widgets_tabbar_on_configure_gtk_widget_configure_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) _widgets_tabbar_on_button_press_gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _widgets_tabbar_on_button_release_gtk_widget_button_release_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "motion-notify-event", (GCallback) _widgets_tabbar_on_motion_notify_gtk_widget_motion_notify_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "leave-notify-event", (GCallback) _widgets_tabbar_on_leave_notify_gtk_widget_leave_notify_event, self, 0);
	return self;
}

WidgetsTabbar*
widgets_tabbar_new (void)
{
	return widgets_tabbar_construct (WIDGETS_TYPE_TABBAR);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block41Data*
block41_data_ref (Block41Data* _data41_)
{
	g_atomic_int_inc (&_data41_->_ref_count_);
	return _data41_;
}

static void
block41_data_unref (void * _userdata_)
{
	Block41Data* _data41_;
	_data41_ = (Block41Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data41_->_ref_count_)) {
		WidgetsTabbar* self;
		self = _data41_->self;
		_g_object_unref0 (_data41_->workspace_manager);
		_g_object_unref0 (_data41_->window);
		_g_object_unref0 (self);
		g_slice_free (Block41Data, _data41_);
	}
}

static void
__lambda74_ (Block41Data* _data41_,
             WidgetsTabbar* t,
             gint tab_index,
             gint tab_id)
{
	WidgetsTabbar* self;
	self = _data41_->self;
	g_return_if_fail (t != NULL);
	widgets_tabbar_unhighlight_tab (self, tab_id);
	widgets_workspace_manager_switch_workspace (_data41_->workspace_manager, tab_id);
}

static void
___lambda74__widgets_tabbar_press_tab (WidgetsTabbar* _sender,
                                       gint tab_index,
                                       gint tab_id,
                                       gpointer self)
{
	__lambda74_ (self, _sender, tab_index, tab_id);
}

static Block42Data*
block42_data_ref (Block42Data* _data42_)
{
	g_atomic_int_inc (&_data42_->_ref_count_);
	return _data42_;
}

static void
block42_data_unref (void * _userdata_)
{
	Block42Data* _data42_;
	_data42_ = (Block42Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data42_->_ref_count_)) {
		WidgetsTabbar* self;
		self = _data42_->_data41_->self;
		block41_data_unref (_data42_->_data41_);
		_data42_->_data41_ = NULL;
		g_slice_free (Block42Data, _data42_);
	}
}

static void
___lambda84_ (Block42Data* _data42_,
              WidgetsConfirmDialog* d)
{
	Block41Data* _data41_;
	WidgetsTabbar* self;
	_data41_ = _data42_->_data41_;
	self = _data41_->self;
	g_return_if_fail (d != NULL);
	widgets_tabbar_destroy_tab (self, _data42_->tab_index);
	widgets_workspace_manager_remove_workspace (_data41_->workspace_manager, _data42_->tab_id);
}

static void
____lambda84__widgets_confirm_dialog_confirm (WidgetsConfirmDialog* _sender,
                                              gpointer self)
{
	___lambda84_ (self, _sender);
}

static void
__lambda75_ (Block41Data* _data41_,
             WidgetsTabbar* t,
             gint tab_index,
             gint tab_id)
{
	WidgetsTabbar* self;
	Block42Data* _data42_;
	WidgetsWorkspace* focus_workspace = NULL;
	GeeHashMap* _tmp0_;
	gpointer _tmp1_;
	WidgetsWorkspace* _tmp2_;
	self = _data41_->self;
	g_return_if_fail (t != NULL);
	_data42_ = g_slice_new0 (Block42Data);
	_data42_->_ref_count_ = 1;
	_data42_->_data41_ = block41_data_ref (_data41_);
	_data42_->tab_index = tab_index;
	_data42_->tab_id = tab_id;
	_tmp0_ = _data41_->workspace_manager->workspace_map;
	_tmp1_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) _data42_->tab_id));
	focus_workspace = (WidgetsWorkspace*) _tmp1_;
	_tmp2_ = focus_workspace;
	if (widgets_workspace_has_active_term (_tmp2_)) {
		WidgetsConfirmDialog* dialog = NULL;
		WidgetsConfirmDialog* _tmp3_;
		WidgetsConfirmDialog* _tmp4_;
		_tmp3_ = widgets_create_running_confirm_dialog (_data41_->window);
		_g_object_unref0 (dialog);
		dialog = _tmp3_;
		_tmp4_ = dialog;
		g_signal_connect_data (_tmp4_, "confirm", (GCallback) ____lambda84__widgets_confirm_dialog_confirm, block42_data_ref (_data42_), (GClosureNotify) block42_data_unref, 0);
		_g_object_unref0 (dialog);
	} else {
		widgets_tabbar_destroy_tab (self, _data42_->tab_index);
		widgets_workspace_manager_remove_workspace (_data41_->workspace_manager, _data42_->tab_id);
	}
	_g_object_unref0 (focus_workspace);
	block42_data_unref (_data42_);
	_data42_ = NULL;
}

static void
___lambda75__widgets_tabbar_close_tab (WidgetsTabbar* _sender,
                                       gint tab_index,
                                       gint tab_id,
                                       gpointer self)
{
	__lambda75_ (self, _sender, tab_index, tab_id);
}

static void
__lambda86_ (Block41Data* _data41_,
             WidgetsTabbar* t)
{
	WidgetsTabbar* self;
	self = _data41_->self;
	g_return_if_fail (t != NULL);
	widgets_workspace_manager_new_workspace_with_current_directory (_data41_->workspace_manager, FALSE);
}

static void
___lambda86__widgets_tabbar_new_tab (WidgetsTabbar* _sender,
                                     gpointer self)
{
	__lambda86_ (self, _sender);
}

void
widgets_tabbar_init (WidgetsTabbar* self,
                     WidgetsWorkspaceManager* workspace_manager,
                     WidgetsConfigWindow* window)
{
	Block41Data* _data41_;
	WidgetsWorkspaceManager* _tmp0_;
	WidgetsConfigWindow* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (workspace_manager != NULL);
	g_return_if_fail (window != NULL);
	_data41_ = g_slice_new0 (Block41Data);
	_data41_->_ref_count_ = 1;
	_data41_->self = g_object_ref (self);
	_tmp0_ = _g_object_ref0 (workspace_manager);
	_g_object_unref0 (_data41_->workspace_manager);
	_data41_->workspace_manager = _tmp0_;
	_tmp1_ = _g_object_ref0 (window);
	_g_object_unref0 (_data41_->window);
	_data41_->window = _tmp1_;
	g_signal_connect_data (self, "press-tab", (GCallback) ___lambda74__widgets_tabbar_press_tab, block41_data_ref (_data41_), (GClosureNotify) block41_data_unref, 0);
	g_signal_connect_data (self, "close-tab", (GCallback) ___lambda75__widgets_tabbar_close_tab, block41_data_ref (_data41_), (GClosureNotify) block41_data_unref, 0);
	g_signal_connect_data (self, "new-tab", (GCallback) ___lambda86__widgets_tabbar_new_tab, block41_data_ref (_data41_), (GClosureNotify) block41_data_unref, 0);
	block41_data_unref (_data41_);
	_data41_ = NULL;
}

void
widgets_tabbar_reset (WidgetsTabbar* self)
{
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_INT, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->tab_list);
	self->tab_list = _tmp0_;
	_tmp1_ = gee_hash_map_new (G_TYPE_INT, NULL, NULL, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->tab_name_map);
	self->tab_name_map = _tmp1_;
	self->tab_index = 0;
}

void
widgets_tabbar_add_tab (WidgetsTabbar* self,
                        const gchar* tab_name,
                        gint tab_id)
{
	GeeArrayList* _tmp0_;
	GeeHashMap* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab_name != NULL);
	_tmp0_ = self->tab_list;
	gee_abstract_collection_add ((GeeAbstractCollection*) _tmp0_, (gpointer) ((gintptr) tab_id));
	_tmp1_ = self->tab_name_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) tab_id), tab_name);
	widgets_tabbar_update_tab_scale (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

void
widgets_tabbar_rename_tab (WidgetsTabbar* self,
                           gint tab_id,
                           const gchar* tab_name)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tab_name != NULL);
	_tmp0_ = self->tab_name_map;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) tab_id), tab_name);
	if (widgets_tabbar_is_focus_tab (self, tab_id)) {
		widgets_tabbar_update_window_title (self, tab_name);
	}
	widgets_tabbar_update_tab_scale (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

void
widgets_tabbar_highlight_tab (WidgetsTabbar* self,
                              gint tab_id)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tab_highlight_map;
	if (!gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) tab_id))) {
		GeeHashMap* _tmp1_;
		_tmp1_ = self->tab_highlight_map;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) tab_id), (gpointer) ((gintptr) TRUE));
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
}

void
widgets_tabbar_unhighlight_tab (WidgetsTabbar* self,
                                gint tab_id)
{
	GeeHashMap* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tab_highlight_map;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp0_, (gpointer) ((gintptr) tab_id))) {
		GeeHashMap* _tmp1_;
		_tmp1_ = self->tab_highlight_map;
		gee_abstract_map_unset ((GeeAbstractMap*) _tmp1_, (gpointer) ((gintptr) tab_id), NULL);
		gtk_widget_queue_draw ((GtkWidget*) self);
	}
}

static gint*
_int_dup (gint* self)
{
	gint* dup;
	dup = g_new0 (gint, 1);
	memcpy (dup, self, sizeof (gint));
	return dup;
}

static gpointer
__int_dup0 (gpointer self)
{
	return self ? _int_dup (self) : NULL;
}

static gboolean
_int_equal (const gint * s1,
            const gint * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

gboolean
widgets_tabbar_is_focus_tab (WidgetsTabbar* self,
                             gint tab_id)
{
	gint* index = NULL;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint* _tmp2_;
	gint* _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->tab_list;
	_tmp1_ = gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, (gpointer) ((gintptr) tab_id));
	_tmp2_ = __int_dup0 (&_tmp1_);
	index = _tmp2_;
	_tmp3_ = index;
	if (_tmp3_ != NULL) {
		gint* _tmp4_;
		_tmp4_ = index;
		result = _int_equal (&self->tab_index, _tmp4_) == TRUE;
		_g_free0 (index);
		return result;
	} else {
		result = FALSE;
		_g_free0 (index);
		return result;
	}
}

void
widgets_tabbar_select_next_tab (WidgetsTabbar* self)
{
	gint index = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	index = self->tab_index + 1;
	_tmp0_ = self->tab_list;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (index >= _tmp2_) {
		index = 0;
	}
	widgets_tabbar_switch_tab (self, index);
}

void
widgets_tabbar_select_previous_tab (WidgetsTabbar* self)
{
	gint index = 0;
	g_return_if_fail (self != NULL);
	index = self->tab_index - 1;
	if (index < 0) {
		GeeArrayList* _tmp0_;
		gint _tmp1_;
		gint _tmp2_;
		_tmp0_ = self->tab_list;
		_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
		_tmp2_ = _tmp1_;
		index = _tmp2_ - 1;
	}
	widgets_tabbar_switch_tab (self, index);
}

void
widgets_tabbar_select_first_tab (WidgetsTabbar* self)
{
	g_return_if_fail (self != NULL);
	widgets_tabbar_switch_tab (self, 0);
}

void
widgets_tabbar_select_end_tab (WidgetsTabbar* self)
{
	gint index = 0;
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	index = 0;
	_tmp0_ = self->tab_list;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		index = 0;
	} else {
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp3_ = self->tab_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		index = _tmp5_ - 1;
	}
	widgets_tabbar_switch_tab (self, index);
}

void
widgets_tabbar_select_nth_tab (WidgetsTabbar* self,
                               gint index)
{
	g_return_if_fail (self != NULL);
	widgets_tabbar_switch_tab (self, index);
}

void
widgets_tabbar_select_tab_with_id (WidgetsTabbar* self,
                                   gint tab_id)
{
	GeeArrayList* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tab_list;
	widgets_tabbar_switch_tab (self, gee_abstract_list_index_of ((GeeAbstractList*) _tmp0_, (gpointer) ((gintptr) tab_id)));
}

void
widgets_tabbar_close_current_tab (WidgetsTabbar* self)
{
	g_return_if_fail (self != NULL);
	widgets_tabbar_close_nth_tab (self, self->tab_index);
}

void
widgets_tabbar_close_nth_tab (WidgetsTabbar* self,
                              gint index)
{
	GeeArrayList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tab_list;
	_tmp1_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ > 0) {
		gint tab_id = 0;
		GeeArrayList* _tmp3_;
		gpointer _tmp4_;
		_tmp3_ = self->tab_list;
		_tmp4_ = gee_abstract_list_get ((GeeAbstractList*) _tmp3_, index);
		tab_id = (gint) ((gintptr) _tmp4_);
		g_signal_emit (self, widgets_tabbar_signals[WIDGETS_TABBAR_CLOSE_TAB_SIGNAL], 0, index, tab_id);
	}
}

void
widgets_tabbar_destroy_tab (WidgetsTabbar* self,
                            gint index)
{
	gint tab_id = 0;
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	GeeArrayList* _tmp2_;
	GeeHashMap* _tmp3_;
	GeeArrayList* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->tab_list;
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, index);
	tab_id = (gint) ((gintptr) _tmp1_);
	_tmp2_ = self->tab_list;
	gee_abstract_list_remove_at ((GeeAbstractList*) _tmp2_, index);
	_tmp3_ = self->tab_name_map;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp3_, (gpointer) ((gintptr) tab_id), NULL);
	_tmp4_ = self->tab_list;
	_tmp5_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp4_);
	_tmp6_ = _tmp5_;
	if (_tmp6_ == 0) {
		self->tab_index = 0;
	} else {
		GeeArrayList* _tmp7_;
		gint _tmp8_;
		gint _tmp9_;
		_tmp7_ = self->tab_list;
		_tmp8_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp7_);
		_tmp9_ = _tmp8_;
		if (self->tab_index >= _tmp9_) {
			GeeArrayList* _tmp10_;
			gint _tmp11_;
			gint _tmp12_;
			_tmp10_ = self->tab_list;
			_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
			_tmp12_ = _tmp11_;
			self->tab_index = _tmp12_ - 1;
		}
	}
	widgets_tabbar_update_tab_scale (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}

gboolean
widgets_tabbar_on_configure (WidgetsTabbar* self,
                             GtkWidget* widget,
                             GdkEventConfigure* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	widgets_tabbar_update_tab_scale (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

gboolean
widgets_tabbar_on_button_press (WidgetsTabbar* self,
                                GtkWidget* widget,
                                GdkEventButton* event)
{
	GdkDevice* _tmp0_;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->is_button_press = TRUE;
	_tmp0_ = event->device;
	gdk_device_get_position (_tmp0_, NULL, &_tmp1_, &_tmp2_);
	self->priv->button_press_x = _tmp1_;
	self->priv->button_press_y = _tmp2_;
	result = FALSE;
	return result;
}

gboolean
widgets_tabbar_on_button_release (WidgetsTabbar* self,
                                  GtkWidget* widget,
                                  GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->is_button_press = FALSE;
	if (utils_is_action_mouse_button (event)) {
		gint button_release_x = 0;
		gint button_release_y = 0;
		GdkDevice* _tmp0_;
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		gboolean _tmp3_ = FALSE;
		_tmp0_ = event->device;
		gdk_device_get_position (_tmp0_, NULL, &_tmp1_, &_tmp2_);
		button_release_x = _tmp1_;
		button_release_y = _tmp2_;
		if (button_release_x == self->priv->button_press_x) {
			_tmp3_ = button_release_y == self->priv->button_press_y;
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			gint release_x = 0;
			GtkAllocation alloc = {0};
			GtkAllocation _tmp4_ = {0};
			gint draw_x = 0;
			gint counter = 0;
			gboolean _tmp23_ = FALSE;
			release_x = (gint) event->x;
			gtk_widget_get_allocation (widget, &_tmp4_);
			alloc = _tmp4_;
			draw_x = 0;
			counter = 0;
			{
				GeeArrayList* _tab_id_list = NULL;
				GeeArrayList* _tmp5_;
				gint _tab_id_size = 0;
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				gint _tab_id_index = 0;
				_tmp5_ = self->tab_list;
				_tab_id_list = _tmp5_;
				_tmp6_ = _tab_id_list;
				_tmp7_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp6_);
				_tmp8_ = _tmp7_;
				_tab_id_size = _tmp8_;
				_tab_id_index = -1;
				while (TRUE) {
					gint _tmp9_;
					gint _tmp10_;
					gint tab_id = 0;
					GeeArrayList* _tmp11_;
					gpointer _tmp12_;
					gint name_width = 0;
					gint name_height = 0;
					GeeHashMap* _tmp13_;
					gpointer _tmp14_;
					gchar* _tmp15_;
					gint _tmp16_ = 0;
					gint _tmp17_ = 0;
					PangoLayout* _tmp18_;
					PangoLayout* _tmp19_;
					gint tab_width = 0;
					gboolean _tmp20_ = FALSE;
					gint _tmp22_;
					_tab_id_index = _tab_id_index + 1;
					_tmp9_ = _tab_id_index;
					_tmp10_ = _tab_id_size;
					if (!(_tmp9_ < _tmp10_)) {
						break;
					}
					_tmp11_ = _tab_id_list;
					_tmp12_ = gee_abstract_list_get ((GeeAbstractList*) _tmp11_, _tab_id_index);
					tab_id = (gint) ((gintptr) _tmp12_);
					_tmp13_ = self->tab_name_map;
					_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp13_, (gpointer) ((gintptr) tab_id));
					_tmp15_ = (gchar*) _tmp14_;
					_tmp18_ = widgets_tabbar_get_text_size (self, _tmp15_, &_tmp16_, &_tmp17_);
					name_width = _tmp16_;
					name_height = _tmp17_;
					_tmp19_ = _tmp18_;
					_g_object_unref0 (_tmp19_);
					_g_free0 (_tmp15_);
					tab_width = widgets_tabbar_get_tab_width (self, name_width);
					if (release_x > draw_x) {
						_tmp20_ = release_x < (draw_x + tab_width);
					} else {
						_tmp20_ = FALSE;
					}
					if (_tmp20_) {
						gboolean _tmp21_ = FALSE;
						if (release_x > draw_x) {
							_tmp21_ = release_x < ((draw_x + tab_width) - widgets_tabbar_get_tab_close_button_padding (self));
						} else {
							_tmp21_ = FALSE;
						}
						if (_tmp21_) {
							if (utils_is_left_button (event)) {
								widgets_tabbar_select_nth_tab (self, counter);
								g_signal_emit (self, widgets_tabbar_signals[WIDGETS_TABBAR_PRESS_TAB_SIGNAL], 0, counter, tab_id);
								result = FALSE;
								return result;
							}
							if (utils_is_mouse_wheel (event)) {
								widgets_tabbar_close_nth_tab (self, counter);
								result = FALSE;
								return result;
							}
						} else {
							if (release_x > ((draw_x + tab_width) - widgets_tabbar_get_tab_close_button_padding (self))) {
								widgets_tabbar_close_nth_tab (self, counter);
								result = FALSE;
								return result;
							}
						}
					}
					draw_x += tab_width;
					_tmp22_ = counter;
					counter = _tmp22_ + 1;
				}
			}
			if (release_x > draw_x) {
				_tmp23_ = release_x < (draw_x + self->priv->add_button_width);
			} else {
				_tmp23_ = FALSE;
			}
			if (_tmp23_) {
				g_signal_emit (self, widgets_tabbar_signals[WIDGETS_TABBAR_NEW_TAB_SIGNAL], 0);
			}
			gtk_widget_queue_draw ((GtkWidget*) self);
		}
	}
	result = FALSE;
	return result;
}

gint
widgets_tabbar_is_at_tab_close_button (WidgetsTabbar* self,
                                       gint x)
{
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	gint draw_x = 0;
	gint counter = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	alloc = _tmp0_;
	draw_x = 0;
	counter = 0;
	{
		GeeArrayList* _tab_id_list = NULL;
		GeeArrayList* _tmp1_;
		gint _tab_id_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tab_id_index = 0;
		_tmp1_ = self->tab_list;
		_tab_id_list = _tmp1_;
		_tmp2_ = _tab_id_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tab_id_size = _tmp4_;
		_tab_id_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint tab_id = 0;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			gint name_width = 0;
			gint name_height = 0;
			GeeHashMap* _tmp9_;
			gpointer _tmp10_;
			gchar* _tmp11_;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			PangoLayout* _tmp14_;
			PangoLayout* _tmp15_;
			gint tab_width = 0;
			gboolean _tmp16_ = FALSE;
			gint _tmp17_;
			_tab_id_index = _tab_id_index + 1;
			_tmp5_ = _tab_id_index;
			_tmp6_ = _tab_id_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _tab_id_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tab_id_index);
			tab_id = (gint) ((gintptr) _tmp8_);
			_tmp9_ = self->tab_name_map;
			_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, (gpointer) ((gintptr) tab_id));
			_tmp11_ = (gchar*) _tmp10_;
			_tmp14_ = widgets_tabbar_get_text_size (self, _tmp11_, &_tmp12_, &_tmp13_);
			name_width = _tmp12_;
			name_height = _tmp13_;
			_tmp15_ = _tmp14_;
			_g_object_unref0 (_tmp15_);
			_g_free0 (_tmp11_);
			tab_width = widgets_tabbar_get_tab_width (self, name_width);
			if (x > draw_x) {
				_tmp16_ = x < (draw_x + tab_width);
			} else {
				_tmp16_ = FALSE;
			}
			if (_tmp16_) {
				if (x > ((draw_x + tab_width) - widgets_tabbar_get_tab_close_button_padding (self))) {
					result = counter;
					return result;
				}
			}
			draw_x += tab_width;
			_tmp17_ = counter;
			counter = _tmp17_ + 1;
		}
	}
	result = -1;
	return result;
}

gboolean
widgets_tabbar_on_motion_notify (WidgetsTabbar* self,
                                 GtkWidget* widget,
                                 GdkEventMotion* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->draw_hover = TRUE;
	self->priv->hover_x = (gint) event->x;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

gboolean
widgets_tabbar_on_leave_notify (WidgetsTabbar* self,
                                GtkWidget* widget,
                                GdkEventCrossing* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	self->priv->draw_hover = FALSE;
	self->priv->hover_x = 0;
	gtk_widget_queue_draw ((GtkWidget*) self);
	result = FALSE;
	return result;
}

void
widgets_tabbar_update_tab_scale (WidgetsTabbar* self)
{
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	gint tab_width = 0;
	GtkAllocation _tmp16_;
	g_return_if_fail (self != NULL);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	alloc = _tmp0_;
	tab_width = 0;
	{
		GeeArrayList* _tab_id_list = NULL;
		GeeArrayList* _tmp1_;
		gint _tab_id_size = 0;
		GeeArrayList* _tmp2_;
		gint _tmp3_;
		gint _tmp4_;
		gint _tab_id_index = 0;
		_tmp1_ = self->tab_list;
		_tab_id_list = _tmp1_;
		_tmp2_ = _tab_id_list;
		_tmp3_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp2_);
		_tmp4_ = _tmp3_;
		_tab_id_size = _tmp4_;
		_tab_id_index = -1;
		while (TRUE) {
			gint _tmp5_;
			gint _tmp6_;
			gint tab_id = 0;
			GeeArrayList* _tmp7_;
			gpointer _tmp8_;
			gint name_width = 0;
			gint name_height = 0;
			GeeHashMap* _tmp9_;
			gpointer _tmp10_;
			gchar* _tmp11_;
			gint _tmp12_ = 0;
			gint _tmp13_ = 0;
			PangoLayout* _tmp14_;
			PangoLayout* _tmp15_;
			_tab_id_index = _tab_id_index + 1;
			_tmp5_ = _tab_id_index;
			_tmp6_ = _tab_id_size;
			if (!(_tmp5_ < _tmp6_)) {
				break;
			}
			_tmp7_ = _tab_id_list;
			_tmp8_ = gee_abstract_list_get ((GeeAbstractList*) _tmp7_, _tab_id_index);
			tab_id = (gint) ((gintptr) _tmp8_);
			_tmp9_ = self->tab_name_map;
			_tmp10_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp9_, (gpointer) ((gintptr) tab_id));
			_tmp11_ = (gchar*) _tmp10_;
			_tmp14_ = widgets_tabbar_get_text_size (self, _tmp11_, &_tmp12_, &_tmp13_);
			name_width = _tmp12_;
			name_height = _tmp13_;
			_tmp15_ = _tmp14_;
			_g_object_unref0 (_tmp15_);
			_g_free0 (_tmp11_);
			tab_width += widgets_tabbar_get_tab_render_width (self, name_width);
		}
	}
	_tmp16_ = alloc;
	if ((tab_width + self->priv->add_button_width) > _tmp16_.width) {
		GtkAllocation _tmp17_;
		_tmp17_ = alloc;
		self->priv->draw_scale = (((gdouble) _tmp17_.width) / (tab_width + self->priv->add_button_width)) * 0.97;
	} else {
		self->priv->draw_scale = 1.0;
	}
}

gboolean
widgets_tabbar_on_draw (WidgetsTabbar* self,
                        GtkWidget* widget,
                        cairo_t* cr)
{
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	gboolean is_light_theme = FALSE;
	GtkWidget* _tmp1_;
	gint draw_x = 0;
	gint counter = 0;
	gint max_tab_width = 0;
	gint max_tab_height = 0;
	gboolean _tmp66_ = FALSE;
	gboolean _tmp67_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (cr != NULL, FALSE);
	gtk_widget_get_allocation (widget, &_tmp0_);
	alloc = _tmp0_;
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	is_light_theme = widgets_config_window_is_light_theme (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow));
	draw_x = 0;
	counter = 0;
	{
		GeeArrayList* _tab_id_list = NULL;
		GeeArrayList* _tmp2_;
		gint _tab_id_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _tab_id_index = 0;
		_tmp2_ = self->tab_list;
		_tab_id_list = _tmp2_;
		_tmp3_ = _tab_id_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_tab_id_size = _tmp5_;
		_tab_id_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gint tab_id = 0;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			gint name_width = 0;
			gint name_height = 0;
			GeeHashMap* _tmp10_;
			gpointer _tmp11_;
			gchar* _tmp12_;
			gint _tmp13_ = 0;
			gint _tmp14_ = 0;
			PangoLayout* _tmp15_;
			PangoLayout* _tmp16_;
			gint tab_width = 0;
			GeeArrayList* _tmp19_;
			gint _tmp20_;
			gint _tmp21_;
			gint _tmp22_;
			_tab_id_index = _tab_id_index + 1;
			_tmp6_ = _tab_id_index;
			_tmp7_ = _tab_id_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _tab_id_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _tab_id_index);
			tab_id = (gint) ((gintptr) _tmp9_);
			_tmp10_ = self->tab_name_map;
			_tmp11_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp10_, (gpointer) ((gintptr) tab_id));
			_tmp12_ = (gchar*) _tmp11_;
			_tmp15_ = widgets_tabbar_get_text_size (self, _tmp12_, &_tmp13_, &_tmp14_);
			name_width = _tmp13_;
			name_height = _tmp14_;
			_tmp16_ = _tmp15_;
			_g_object_unref0 (_tmp16_);
			_g_free0 (_tmp12_);
			tab_width = widgets_tabbar_get_tab_width (self, name_width);
			if (is_light_theme) {
				GdkRGBA _tmp17_;
				_tmp17_ = self->tab_split_light_color;
				utils_set_context_color (cr, &_tmp17_);
			} else {
				GdkRGBA _tmp18_;
				_tmp18_ = self->tab_split_dark_color;
				utils_set_context_color (cr, &_tmp18_);
			}
			_tmp19_ = self->tab_list;
			_tmp20_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp19_);
			_tmp21_ = _tmp20_;
			if (counter < _tmp21_) {
				draw_draw_rectangle (cr, draw_x, 0, self->priv->tab_split_width, self->height, TRUE);
			}
			draw_x += tab_width;
			_tmp22_ = counter;
			counter = _tmp22_ + 1;
		}
	}
	draw_x = 0;
	counter = 0;
	{
		gchar* _tmp23_ = NULL;
		GtkWidget* _tmp24_;
		ConfigConfig* _tmp25_;
		GKeyFile* _tmp26_;
		gchar* _tmp27_;
		GdkRGBA _tmp28_ = {0};
		_tmp24_ = gtk_widget_get_toplevel ((GtkWidget*) self);
		_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, WIDGETS_TYPE_CONFIG_WINDOW, WidgetsConfigWindow)->config;
		_tmp26_ = _tmp25_->config_file;
		_tmp27_ = g_key_file_get_string (_tmp26_, "theme", "tab", &_inner_error0_);
		_tmp23_ = _tmp27_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		utils_hex_to_rgba (_tmp23_, 1.0, &_tmp28_);
		self->text_active_color = _tmp28_;
		_g_free0 (_tmp23_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_print ("Tabbar draw: %s\n", _tmp30_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp31_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp31_;
	}
	max_tab_width = 0;
	max_tab_height = 0;
	{
		GeeArrayList* _tab_id_list = NULL;
		GeeArrayList* _tmp32_;
		gint _tab_id_size = 0;
		GeeArrayList* _tmp33_;
		gint _tmp34_;
		gint _tmp35_;
		gint _tab_id_index = 0;
		_tmp32_ = self->tab_list;
		_tab_id_list = _tmp32_;
		_tmp33_ = _tab_id_list;
		_tmp34_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp33_);
		_tmp35_ = _tmp34_;
		_tab_id_size = _tmp35_;
		_tab_id_index = -1;
		while (TRUE) {
			gint _tmp36_;
			gint _tmp37_;
			gint tab_id = 0;
			GeeArrayList* _tmp38_;
			gpointer _tmp39_;
			gint name_width = 0;
			gint name_height = 0;
			PangoLayout* layout = NULL;
			GeeHashMap* _tmp40_;
			gpointer _tmp41_;
			gchar* _tmp42_;
			gint _tmp43_ = 0;
			gint _tmp44_ = 0;
			PangoLayout* _tmp45_;
			PangoLayout* _tmp46_;
			gint tab_width = 0;
			GeeHashMap* _tmp47_;
			GdkRGBA _tmp61_;
			gboolean is_hover = FALSE;
			gint text_render_y = 0;
			GtkAllocation _tmp63_;
			PangoLayout* _tmp64_;
			gint _tmp65_;
			_tab_id_index = _tab_id_index + 1;
			_tmp36_ = _tab_id_index;
			_tmp37_ = _tab_id_size;
			if (!(_tmp36_ < _tmp37_)) {
				break;
			}
			_tmp38_ = _tab_id_list;
			_tmp39_ = gee_abstract_list_get ((GeeAbstractList*) _tmp38_, _tab_id_index);
			tab_id = (gint) ((gintptr) _tmp39_);
			_tmp40_ = self->tab_name_map;
			_tmp41_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp40_, (gpointer) ((gintptr) tab_id));
			_tmp42_ = (gchar*) _tmp41_;
			_tmp45_ = widgets_tabbar_get_text_size (self, _tmp42_, &_tmp43_, &_tmp44_);
			name_width = _tmp43_;
			name_height = _tmp44_;
			_tmp46_ = _tmp45_;
			_g_free0 (_tmp42_);
			layout = _tmp46_;
			tab_width = widgets_tabbar_get_tab_width (self, name_width);
			max_tab_height = MAX (max_tab_height, name_height);
			_tmp47_ = self->tab_highlight_map;
			if (gee_abstract_map_has_key ((GeeAbstractMap*) _tmp47_, (gpointer) ((gintptr) tab_id))) {
				GdkRGBA _tmp48_;
				_tmp48_ = self->text_highlight_color;
				self->tab_text_color = _tmp48_;
			} else {
				if (is_light_theme) {
					GdkRGBA _tmp49_;
					_tmp49_ = self->text_light_color;
					self->tab_text_color = _tmp49_;
				} else {
					GdkRGBA _tmp50_;
					_tmp50_ = self->text_dark_color;
					self->tab_text_color = _tmp50_;
				}
			}
			if (counter == self->tab_index) {
				GdkRGBA _tmp51_;
				cairo_save (cr);
				draw_clip_rectangle (cr, draw_x, 0, tab_width, self->height);
				g_signal_emit (self, widgets_tabbar_signals[WIDGETS_TABBAR_UPDATE_TAB_UNDERLINE_SIGNAL], 0, draw_x + 1, tab_width - 1);
				cairo_restore (cr);
				_tmp51_ = self->text_active_color;
				self->tab_text_color = _tmp51_;
			} else {
				gboolean is_hover = FALSE;
				is_hover = FALSE;
				if (self->priv->draw_hover) {
					gboolean _tmp52_ = FALSE;
					if (self->priv->hover_x > draw_x) {
						_tmp52_ = self->priv->hover_x < (draw_x + tab_width);
					} else {
						_tmp52_ = FALSE;
					}
					if (_tmp52_) {
						is_hover = TRUE;
					}
				}
				if (is_hover) {
					cairo_save (cr);
					draw_clip_rectangle (cr, draw_x, 0, tab_width + 1, self->height);
					if (is_light_theme) {
						GdkRGBA _tmp53_;
						_tmp53_ = self->tab_split_light_color;
						utils_set_context_color (cr, &_tmp53_);
					} else {
						GdkRGBA _tmp54_;
						_tmp54_ = self->tab_split_dark_color;
						utils_set_context_color (cr, &_tmp54_);
					}
					draw_draw_rectangle (cr, draw_x, 0, tab_width + 1, self->height, TRUE);
					cairo_restore (cr);
					if (is_light_theme) {
						GdkRGBA _tmp55_;
						_tmp55_ = self->text_hover_light_color;
						self->tab_text_color = _tmp55_;
					} else {
						GdkRGBA _tmp56_;
						_tmp56_ = self->text_hover_dark_color;
						self->tab_text_color = _tmp56_;
					}
				} else {
					cairo_set_source_rgba (cr, (gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) 0);
					draw_draw_rectangle (cr, draw_x, 0, tab_width, self->height, TRUE);
				}
			}
			if (self->priv->draw_hover) {
				gboolean _tmp57_ = FALSE;
				if (self->priv->hover_x > draw_x) {
					_tmp57_ = self->priv->hover_x < (draw_x + tab_width);
				} else {
					_tmp57_ = FALSE;
				}
				if (_tmp57_) {
					if (self->priv->hover_x > ((draw_x + tab_width) - widgets_tabbar_get_tab_close_button_padding (self))) {
						if (self->priv->is_button_press) {
							cairo_surface_t* _tmp58_;
							_tmp58_ = self->priv->close_press_surface;
							draw_draw_surface (cr, _tmp58_, (draw_x + tab_width) - widgets_tabbar_get_tab_close_button_padding (self), 0, 0, self->height);
						} else {
							cairo_surface_t* _tmp59_;
							_tmp59_ = self->priv->close_hover_surface;
							draw_draw_surface (cr, _tmp59_, (draw_x + tab_width) - widgets_tabbar_get_tab_close_button_padding (self), 0, 0, self->height);
						}
					} else {
						cairo_surface_t* _tmp60_;
						_tmp60_ = self->priv->close_normal_surface;
						draw_draw_surface (cr, _tmp60_, (draw_x + tab_width) - widgets_tabbar_get_tab_close_button_padding (self), 0, 0, self->height);
					}
				}
			}
			cairo_save (cr);
			draw_clip_rectangle (cr, draw_x + widgets_tabbar_get_tab_text_padding (self), 0, tab_width - (widgets_tabbar_get_tab_text_padding (self) * 2), self->height);
			_tmp61_ = self->tab_text_color;
			utils_set_context_color (cr, &_tmp61_);
			is_hover = FALSE;
			if (self->priv->draw_hover) {
				gboolean _tmp62_ = FALSE;
				if (self->priv->hover_x > draw_x) {
					_tmp62_ = self->priv->hover_x < (draw_x + tab_width);
				} else {
					_tmp62_ = FALSE;
				}
				if (_tmp62_) {
					is_hover = TRUE;
				}
			}
			_tmp63_ = alloc;
			text_render_y = (_tmp63_.height - max_tab_height) / 2;
			if (is_hover) {
				cairo_rectangle (cr, (gdouble) draw_x, (gdouble) text_render_y, (gdouble) ((tab_width - widgets_tabbar_get_tab_close_button_padding (self)) - self->hover_clip_right_offset), (gdouble) self->height);
				cairo_clip (cr);
			}
			_tmp64_ = layout;
			draw_draw_layout (cr, _tmp64_, draw_x + widgets_tabbar_get_tab_text_padding (self), text_render_y);
			cairo_restore (cr);
			draw_x += tab_width;
			max_tab_width = MAX (max_tab_width, tab_width);
			_tmp65_ = counter;
			counter = _tmp65_ + 1;
			_g_object_unref0 (layout);
		}
	}
	if (max_tab_width > self->min_tab_width) {
		_tmp66_ = TRUE;
	} else {
		_tmp66_ = self->priv->draw_scale >= 1.0;
	}
	self->allowed_add_tab = _tmp66_;
	if (self->priv->hover_x > draw_x) {
		_tmp67_ = self->priv->hover_x < (draw_x + self->priv->add_button_width);
	} else {
		_tmp67_ = FALSE;
	}
	if (_tmp67_) {
		if (self->priv->is_button_press) {
			if (is_light_theme) {
				cairo_surface_t* _tmp68_;
				_tmp68_ = self->priv->add_press_light_surface;
				draw_draw_surface (cr, _tmp68_, draw_x, 0, 0, self->height);
			} else {
				cairo_surface_t* _tmp69_;
				_tmp69_ = self->priv->add_press_dark_surface;
				draw_draw_surface (cr, _tmp69_, draw_x, 0, 0, self->height);
			}
		} else {
			if (self->priv->draw_hover) {
				if (is_light_theme) {
					cairo_surface_t* _tmp70_;
					_tmp70_ = self->priv->add_hover_light_surface;
					draw_draw_surface (cr, _tmp70_, draw_x, 0, 0, self->height);
				} else {
					cairo_surface_t* _tmp71_;
					_tmp71_ = self->priv->add_hover_dark_surface;
					draw_draw_surface (cr, _tmp71_, draw_x, 0, 0, self->height);
				}
			}
		}
	} else {
		if (is_light_theme) {
			cairo_surface_t* _tmp72_;
			_tmp72_ = self->priv->add_normal_light_surface;
			draw_draw_surface (cr, _tmp72_, draw_x, 0, 0, self->height);
		} else {
			cairo_surface_t* _tmp73_;
			_tmp73_ = self->priv->add_normal_dark_surface;
			draw_draw_surface (cr, _tmp73_, draw_x, 0, 0, self->height);
		}
	}
	result = TRUE;
	return result;
}

gint
widgets_tabbar_get_tab_render_width (WidgetsTabbar* self,
                                     gint name_width)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = MAX (name_width + (widgets_tabbar_get_tab_text_padding (self) * 2), self->priv->tab_min_width);
	return result;
}

gint
widgets_tabbar_get_tab_width (WidgetsTabbar* self,
                              gint name_width)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = MAX ((gint) ((name_width + (widgets_tabbar_get_tab_text_padding (self) * 2)) * self->priv->draw_scale), (gint) (self->priv->tab_min_width * self->priv->draw_scale));
	return result;
}

gint
widgets_tabbar_get_tab_text_padding (WidgetsTabbar* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->text_padding_x;
	return result;
}

gint
widgets_tabbar_get_tab_close_button_padding (WidgetsTabbar* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->close_button_padding_x;
	return result;
}

void
widgets_tabbar_switch_tab (WidgetsTabbar* self,
                           gint new_index)
{
	GeeArrayList* _tmp0_;
	gpointer _tmp1_;
	g_return_if_fail (self != NULL);
	self->tab_index = new_index;
	_tmp0_ = self->tab_list;
	_tmp1_ = gee_abstract_list_get ((GeeAbstractList*) _tmp0_, self->tab_index);
	g_signal_emit (self, widgets_tabbar_signals[WIDGETS_TABBAR_PRESS_TAB_SIGNAL], 0, self->tab_index, (gint) ((gintptr) _tmp1_));
	gtk_widget_queue_draw ((GtkWidget*) self);
}

PangoLayout*
widgets_tabbar_get_text_size (WidgetsTabbar* self,
                              const gchar* text,
                              gint* width,
                              gint* height)
{
	gint _vala_width = 0;
	gint _vala_height = 0;
	PangoLayout* layout = NULL;
	PangoLayout* _tmp0_;
	PangoFontDescription* _tmp1_;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	PangoLayout* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (text != NULL, NULL);
	_tmp0_ = gtk_widget_create_pango_layout ((GtkWidget*) self, text);
	layout = _tmp0_;
	_tmp1_ = self->font_description;
	pango_layout_set_font_description (layout, _tmp1_);
	pango_layout_get_pixel_size (layout, &_tmp2_, &_tmp3_);
	_vala_width = _tmp2_;
	_vala_height = _tmp3_;
	result = layout;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
	return result;
}

void
widgets_tabbar_update_window_title (WidgetsTabbar* self,
                                    const gchar* title)
{
	GtkWidget* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (title != NULL);
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = g_strdup_printf ("%s - %s", title, _ ("Deepin Terminal"));
	_tmp2_ = _tmp1_;
	gtk_window_set_title (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), _tmp2_);
	_g_free0 (_tmp2_);
}

static void
g_cclosure_user_marshal_VOID__INT_INT (GClosure * closure,
                                       GValue * return_value,
                                       guint n_param_values,
                                       const GValue * param_values,
                                       gpointer invocation_hint,
                                       gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_VOID__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__INT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
}

static void
widgets_tabbar_class_init (WidgetsTabbarClass * klass,
                           gpointer klass_data)
{
	widgets_tabbar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &WidgetsTabbar_private_offset);
	G_OBJECT_CLASS (klass)->finalize = widgets_tabbar_finalize;
	widgets_tabbar_signals[WIDGETS_TABBAR_PRESS_TAB_SIGNAL] = g_signal_new ("press-tab", WIDGETS_TYPE_TABBAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	widgets_tabbar_signals[WIDGETS_TABBAR_UPDATE_TAB_UNDERLINE_SIGNAL] = g_signal_new ("update-tab-underline", WIDGETS_TYPE_TABBAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	widgets_tabbar_signals[WIDGETS_TABBAR_CLOSE_TAB_SIGNAL] = g_signal_new ("close-tab", WIDGETS_TYPE_TABBAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__INT_INT, G_TYPE_NONE, 2, G_TYPE_INT, G_TYPE_INT);
	widgets_tabbar_signals[WIDGETS_TABBAR_NEW_TAB_SIGNAL] = g_signal_new ("new-tab", WIDGETS_TYPE_TABBAR, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
widgets_tabbar_instance_init (WidgetsTabbar * self,
                              gpointer klass)
{
	self->priv = widgets_tabbar_get_instance_private (self);
	self->priv->draw_hover = FALSE;
	self->priv->is_button_press = FALSE;
	self->priv->draw_scale = 1.0;
	self->priv->add_button_width = 50;
	self->priv->button_press_x = 0;
	self->priv->button_press_y = 0;
	self->priv->close_button_padding_x = 28;
	self->priv->hover_x = 0;
	self->priv->tab_min_width = 80;
	self->priv->tab_split_width = 1;
	self->priv->text_padding_x = 20;
	self->allowed_add_tab = TRUE;
	self->font_size = 11;
	self->height = constant_TITLEBAR_HEIGHT;
	self->hover_clip_right_offset = 6;
	self->min_tab_width = 70;
	self->tab_index = 0;
}

static void
widgets_tabbar_finalize (GObject * obj)
{
	WidgetsTabbar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, WIDGETS_TYPE_TABBAR, WidgetsTabbar);
	_g_object_unref0 (self->tab_highlight_map);
	_cairo_surface_destroy0 (self->priv->add_hover_dark_surface);
	_cairo_surface_destroy0 (self->priv->add_hover_light_surface);
	_cairo_surface_destroy0 (self->priv->add_normal_dark_surface);
	_cairo_surface_destroy0 (self->priv->add_normal_light_surface);
	_cairo_surface_destroy0 (self->priv->add_press_dark_surface);
	_cairo_surface_destroy0 (self->priv->add_press_light_surface);
	_cairo_surface_destroy0 (self->priv->close_hover_surface);
	_cairo_surface_destroy0 (self->priv->close_normal_surface);
	_cairo_surface_destroy0 (self->priv->close_press_surface);
	_g_object_unref0 (self->tab_list);
	_g_object_unref0 (self->tab_name_map);
	__vala_PangoFontDescription_free0 (self->font_description);
	G_OBJECT_CLASS (widgets_tabbar_parent_class)->finalize (obj);
}

static GType
widgets_tabbar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WidgetsTabbarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) widgets_tabbar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WidgetsTabbar), 0, (GInstanceInitFunc) widgets_tabbar_instance_init, NULL };
	GType widgets_tabbar_type_id;
	widgets_tabbar_type_id = g_type_register_static (gtk_drawing_area_get_type (), "WidgetsTabbar", &g_define_type_info, 0);
	WidgetsTabbar_private_offset = g_type_add_instance_private (widgets_tabbar_type_id, sizeof (WidgetsTabbarPrivate));
	return widgets_tabbar_type_id;
}

GType
widgets_tabbar_get_type (void)
{
	static volatile gsize widgets_tabbar_type_id__once = 0;
	if (g_once_init_enter (&widgets_tabbar_type_id__once)) {
		GType widgets_tabbar_type_id;
		widgets_tabbar_type_id = widgets_tabbar_get_type_once ();
		g_once_init_leave (&widgets_tabbar_type_id__once, widgets_tabbar_type_id);
	}
	return widgets_tabbar_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

