#include <stdint.h>
#include <fcitx/fcitx.h>
#include <fcitx-utils/utils.h>
#include <fcitx/instance.h>
#include <fcitx/addon.h>
#include <fcitx/module.h>


#ifndef __FCITX_MODULE_FCITX_DBUS_ADD_FUNCTION_H
#define __FCITX_MODULE_FCITX_DBUS_ADD_FUNCTION_H

#ifdef __cplusplus
extern "C" {
#endif

DEFINE_GET_ADDON("fcitx-dbus", _DBus_)

static void*
__fcitx_DBus_function_GetConnection(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxDBus*, __self, _self);
    FCITX_UNUSED(_args);
    FcitxDBus* self = __self;
    FCITX_UNUSED(self);
    DBusConnection* res = ((self)->conn);
    FCITX_RETURN_AS_PTR(DBusConnection*, res);
}

static void*
__fcitx_DBus_function_GetPrivConnection(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxDBus*, __self, _self);
    FCITX_UNUSED(_args);
    FcitxDBus* self = __self;
    FCITX_UNUSED(self);
    DBusConnection* res = ((self)->privconn);
    FCITX_RETURN_AS_PTR(DBusConnection*, res);
}

static void*
__fcitx_DBus_function_WatchName(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxDBus*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(const char*, arg0, _args.args[0]);
    FCITX_DEF_CAST_FROM_PTR(void*, arg1, _args.args[1]);
    FCITX_DEF_CAST_FROM_PTR(FcitxDBusWatchNameCallback, arg2, _args.args[2]);
    FCITX_DEF_CAST_FROM_PTR(void*, arg3, _args.args[3]);
    FCITX_DEF_CAST_FROM_PTR(FcitxDestroyNotify, arg4, _args.args[4]);
    FcitxDBus* self = __self;
    FCITX_UNUSED(self);
    int res = (DBusWatchName(self, arg0, arg1, arg2, arg3, arg4));
    int _res = ((res) + 1);
    FCITX_RETURN_AS_PTR(int, _res);
}

static void*
__fcitx_DBus_function_UnwatchName(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxDBus*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(int, _arg0, _args.args[0]);
    FcitxDBus* self = __self;
    FCITX_UNUSED(self);
    int arg0 = ((_arg0) - 1);
    DBusUnwatchName(self, arg0);
    return NULL;
}

static void*
__fcitx_DBus_function_AttachConnection(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxDBus*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(DBusConnection *, arg0, _args.args[0]);
    FcitxDBus* self = __self;
    FCITX_UNUSED(self);
    boolean res = (DBusAttachConnection(self, arg0));
    FCITX_RETURN_AS_PTR(boolean, res);
}

static void*
__fcitx_DBus_function_DeattachConnection(void *_self, FcitxModuleFunctionArg _args)
{
    FCITX_DEF_CAST_FROM_PTR(FcitxDBus*, __self, _self);
    FCITX_DEF_CAST_FROM_PTR(DBusConnection *, arg0, _args.args[0]);
    FcitxDBus* self = __self;
    FCITX_UNUSED(self);
    DBusDeattachConnection(self, arg0);
    return NULL;
}

static void
FcitxDBusAddFunctions(FcitxInstance *instance)
{
    int i;
    FcitxAddon *addon = Fcitx_DBus_GetAddon(instance);
    static const FcitxModuleFunction ____fcitx_DBus_addon_functions_table[] = {
        __fcitx_DBus_function_GetConnection,
        __fcitx_DBus_function_GetPrivConnection,
        __fcitx_DBus_function_WatchName,
        __fcitx_DBus_function_UnwatchName,
        __fcitx_DBus_function_AttachConnection,
        __fcitx_DBus_function_DeattachConnection,
    };
    for (i = 0;i < 6;i++) {
        FcitxModuleAddFunction(addon, ____fcitx_DBus_addon_functions_table[i]);
    }
}

#ifdef __cplusplus
}
#endif

#endif
