/* simple-query.c generated by valac 0.56.18, the Vala compiler
 * generated from simple-query.vala, do not modify */

/*
 * Copyright (C) 2011, 2015 Collabora Ltd.
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Travis Reitter <travis.reitter@collabora.co.uk>
 *       Philip Withnall <philip.withnall@collabora.co.uk>
 */

#include "folks/folks.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <locale.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FOLKS_SIMPLE_QUERY_0_PROPERTY,
	FOLKS_SIMPLE_QUERY_QUERY_STRING_PROPERTY,
	FOLKS_SIMPLE_QUERY_QUERY_LOCALE_PROPERTY,
	FOLKS_SIMPLE_QUERY_NUM_PROPERTIES
};
static GParamSpec* folks_simple_query_properties[FOLKS_SIMPLE_QUERY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FolksSimpleQueryPrivate {
	gchar* _query_string;
	gchar** _query_tokens;
	gint _query_tokens_length1;
	gint __query_tokens_size_;
	gchar* _query_locale;
};

static gint FolksSimpleQuery_private_offset;
static gpointer folks_simple_query_parent_class = NULL;

static void _folks_simple_query_update_query_string (FolksSimpleQuery* self,
                                              const gchar* query_string,
                                              const gchar* query_locale);
static gchar** _vala_array_dup6 (gchar** self,
                          gssize length);
static guint folks_simple_query_real_is_match (FolksQuery* base,
                                        FolksIndividual* individual);
static guint _folks_simple_query_prop_contains_token (FolksSimpleQuery* self,
                                               FolksIndividual* individual,
                                               const gchar* individual_translit_locale,
                                               const gchar* prop_name,
                                               GParamSpec* prop_spec,
                                               const gchar* token);
static inline guint _folks_simple_query_string_matches_token (FolksSimpleQuery* self,
                                                const gchar* str,
                                                const gchar* token,
                                                const gchar* str_translit_locale);
static guint _folks_simple_query_prop_contains_token_fd_string (FolksSimpleQuery* self,
                                                         FolksIndividual* individual,
                                                         const gchar* individual_translit_locale,
                                                         const gchar* prop_name,
                                                         GParamSpec* prop_spec,
                                                         FolksAbstractFieldDetails* val,
                                                         const gchar* token);
static guint _folks_simple_query_prop_contains_token_fd_role (FolksSimpleQuery* self,
                                                       FolksIndividual* individual,
                                                       const gchar* individual_translit_locale,
                                                       const gchar* prop_name,
                                                       GParamSpec* prop_spec,
                                                       FolksAbstractFieldDetails* val,
                                                       const gchar* token);
static guint _folks_simple_query_prop_contains_token_fd_postal_address (FolksSimpleQuery* self,
                                                                 FolksIndividual* individual,
                                                                 const gchar* individual_translit_locale,
                                                                 const gchar* prop_name,
                                                                 GParamSpec* prop_spec,
                                                                 FolksAbstractFieldDetails* val,
                                                                 const gchar* token);
static void folks_simple_query_finalize (GObject * obj);
static GType folks_simple_query_get_type_once (void);
static void _vala_folks_simple_query_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_folks_simple_query_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
folks_simple_query_get_instance_private (FolksSimpleQuery* self)
{
	return G_STRUCT_MEMBER_P (self, FolksSimpleQuery_private_offset);
}

static void
_folks_simple_query_update_query_string (FolksSimpleQuery* self,
                                         const gchar* query_string,
                                         const gchar* query_locale)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	g_return_if_fail (self != NULL);
	g_return_if_fail (query_string != NULL);
	_tmp0_ = g_strdup (query_string);
	_g_free0 (self->priv->_query_string);
	self->priv->_query_string = _tmp0_;
	_tmp1_ = g_strdup (query_locale);
	_g_free0 (self->priv->_query_locale);
	self->priv->_query_locale = _tmp1_;
	_tmp2_ = self->priv->_query_string;
	_tmp3_ = folks_simple_query_get_query_locale (self);
	_tmp4_ = _tmp3_;
	_tmp6_ = _tmp5_ = g_str_tokenize_and_fold (_tmp2_, _tmp4_, NULL);
	self->priv->_query_tokens = (_vala_array_free (self->priv->_query_tokens, self->priv->_query_tokens_length1, (GDestroyNotify) g_free), NULL);
	self->priv->_query_tokens = _tmp6_;
	self->priv->_query_tokens_length1 = _vala_array_length (_tmp5_);
	self->priv->__query_tokens_size_ = self->priv->_query_tokens_length1;
	g_debug ("simple-query.vala:102: Created simple query with tokens:");
	_tmp7_ = self->priv->_query_tokens;
	_tmp7__length1 = self->priv->_query_tokens_length1;
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp7_;
		token_collection_length1 = _tmp7__length1;
		for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
			gchar* _tmp8_;
			gchar* token = NULL;
			_tmp8_ = g_strdup (token_collection[token_it]);
			token = _tmp8_;
			{
				const gchar* _tmp9_;
				_tmp9_ = token;
				g_debug ("simple-query.vala:104: \t%s", _tmp9_);
				_g_free0 (token);
			}
		}
	}
	g_object_freeze_notify ((GObject*) self);
	g_object_notify ((GObject*) self, "query-string");
	g_object_notify ((GObject*) self, "query-locale");
	g_object_thaw_notify ((GObject*) self);
}

/**
   * Create a simple text query.
   *
   * @param query_string text to match contacts against. Results will match all
   * tokens within the whitespace-delimited string (logical-ANDing the tokens).
   * A value of "" will match all contacts. However, it is recommended to not
   * use a query at all if filtering is not required.
   * @param match_fields the field names to apply this query to. See
   * {@link Query.match_fields} for more details. An empty array will match all
   * contacts. However, it is recommended to use the
   * {@link IndividualAggregator} directly if filtering is not required.
   * {@link PersonaDetail} and {@link PersonaStore.detail_key} for pre-defined
   * field names.
   *
   * @since 0.11.0
   */
static gchar**
_vala_array_dup6 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

FolksSimpleQuery*
folks_simple_query_construct (GType object_type,
                              const gchar* query_string,
                              gchar** match_fields,
                              gint match_fields_length1)
{
	FolksSimpleQuery * self = NULL;
	gchar** match_fields_safe = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	gint match_fields_safe_length1;
	gint _match_fields_safe_size_;
	const gchar* _tmp1_;
	g_return_val_if_fail (query_string != NULL, NULL);
	_tmp0_ = (match_fields != NULL) ? _vala_array_dup6 (match_fields, match_fields_length1) : match_fields;
	_tmp0__length1 = match_fields_length1;
	match_fields_safe = _tmp0_;
	match_fields_safe_length1 = _tmp0__length1;
	_match_fields_safe_size_ = match_fields_safe_length1;
	_tmp1_ = setlocale (LC_ALL, NULL);
	self = (FolksSimpleQuery*) g_object_new (object_type, "query-string", query_string, "match-fields", match_fields_safe, "query-locale", _tmp1_, NULL);
	match_fields_safe = (_vala_array_free (match_fields_safe, match_fields_safe_length1, (GDestroyNotify) g_free), NULL);
	return self;
}

FolksSimpleQuery*
folks_simple_query_new (const gchar* query_string,
                        gchar** match_fields,
                        gint match_fields_length1)
{
	return folks_simple_query_construct (FOLKS_TYPE_SIMPLE_QUERY, query_string, match_fields, match_fields_length1);
}

/**
   * {@inheritDoc}
   *
   * @since 0.11.0
   */
static guint
folks_simple_query_real_is_match (FolksQuery* base,
                                  FolksIndividual* individual)
{
	FolksSimpleQuery * self;
	gboolean _tmp0_ = FALSE;
	gchar** _tmp1_;
	gint _tmp1__length1;
	GeeHashSet* tokens_remaining = NULL;
	GeeHashSet* _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* individual_translit_locale = NULL;
	guint match_score = 0U;
	gchar** _tmp10_;
	gint _tmp10__length1;
	gint _tmp11_ = 0;
	gchar** _tmp12_;
	gint _tmp12__length1;
	GeeHashSet* _tmp32_;
	gint _tmp33_;
	gint _tmp34_;
	guint result;
	self = (FolksSimpleQuery*) base;
	g_return_val_if_fail (individual != NULL, 0U);
	_tmp1_ = self->priv->_query_tokens;
	_tmp1__length1 = self->priv->_query_tokens_length1;
	if (_tmp1__length1 < 1) {
		_tmp0_ = TRUE;
	} else {
		gchar** _tmp2_;
		gint _tmp2__length1;
		gint _tmp3_ = 0;
		gchar** _tmp4_;
		gint _tmp4__length1;
		_tmp2_ = folks_query_get_match_fields ((FolksQuery*) self, &_tmp3_);
		_tmp2__length1 = _tmp3_;
		_tmp4_ = _tmp2_;
		_tmp4__length1 = _tmp2__length1;
		_tmp0_ = _tmp4__length1 < 1;
	}
	if (_tmp0_) {
		result = (guint) 1;
		return result;
	}
	_tmp5_ = gee_hash_set_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	tokens_remaining = _tmp5_;
	_tmp6_ = self->priv->_query_tokens;
	_tmp6__length1 = self->priv->_query_tokens_length1;
	{
		gchar** t_collection = NULL;
		gint t_collection_length1 = 0;
		gint _t_collection_size_ = 0;
		gint t_it = 0;
		t_collection = _tmp6_;
		t_collection_length1 = _tmp6__length1;
		for (t_it = 0; t_it < t_collection_length1; t_it = t_it + 1) {
			gchar* _tmp7_;
			gchar* t = NULL;
			_tmp7_ = g_strdup (t_collection[t_it]);
			t = _tmp7_;
			{
				GeeHashSet* _tmp8_;
				const gchar* _tmp9_;
				_tmp8_ = tokens_remaining;
				_tmp9_ = t;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp8_, _tmp9_);
				_g_free0 (t);
			}
		}
	}
	individual_translit_locale = NULL;
	match_score = (guint) 0;
	_tmp10_ = folks_query_get_match_fields ((FolksQuery*) self, &_tmp11_);
	_tmp10__length1 = _tmp11_;
	_tmp12_ = _tmp10_;
	_tmp12__length1 = _tmp10__length1;
	{
		gchar** prop_name_collection = NULL;
		gint prop_name_collection_length1 = 0;
		gint _prop_name_collection_size_ = 0;
		gint prop_name_it = 0;
		prop_name_collection = _tmp12_;
		prop_name_collection_length1 = _tmp12__length1;
		for (prop_name_it = 0; prop_name_it < prop_name_collection_length1; prop_name_it = prop_name_it + 1) {
			const gchar* prop_name = NULL;
			prop_name = prop_name_collection[prop_name_it];
			{
				GObjectClass* iclass = NULL;
				GObjectClass* _tmp13_;
				GParamSpec* prop_spec = NULL;
				GObjectClass* _tmp14_;
				const gchar* _tmp15_;
				GParamSpec* _tmp16_;
				GParamSpec* _tmp17_;
				_tmp13_ = G_OBJECT_GET_CLASS ((GObject*) individual);
				iclass = _tmp13_;
				_tmp14_ = iclass;
				_tmp15_ = prop_name;
				_tmp16_ = g_object_class_find_property (_tmp14_, _tmp15_);
				prop_spec = _tmp16_;
				_tmp17_ = prop_spec;
				if (_tmp17_ == NULL) {
					const gchar* _tmp18_;
					_tmp18_ = prop_name;
					g_warning ("simple-query.vala:182: Folks.Individual does not contain property '%s'", _tmp18_);
				} else {
					GeeIterator* iter = NULL;
					GeeHashSet* _tmp19_;
					GeeIterator* _tmp20_;
					_tmp19_ = tokens_remaining;
					_tmp20_ = gee_abstract_collection_iterator ((GeeAbstractCollection*) _tmp19_);
					iter = _tmp20_;
					while (TRUE) {
						GeeIterator* _tmp21_;
						gchar* token = NULL;
						GeeIterator* _tmp22_;
						gpointer _tmp23_;
						guint inc = 0U;
						const gchar* _tmp24_;
						const gchar* _tmp25_;
						GParamSpec* _tmp26_;
						const gchar* _tmp27_;
						_tmp21_ = iter;
						if (!gee_iterator_next (_tmp21_)) {
							break;
						}
						_tmp22_ = iter;
						_tmp23_ = gee_iterator_get (_tmp22_);
						token = (gchar*) _tmp23_;
						_tmp24_ = individual_translit_locale;
						_tmp25_ = prop_name;
						_tmp26_ = prop_spec;
						_tmp27_ = token;
						inc = _folks_simple_query_prop_contains_token (self, individual, _tmp24_, _tmp25_, _tmp26_, _tmp27_);
						match_score += inc;
						if (inc > ((guint) 0)) {
							GeeIterator* _tmp28_;
							GeeHashSet* _tmp29_;
							gint _tmp30_;
							gint _tmp31_;
							_tmp28_ = iter;
							gee_iterator_remove (_tmp28_);
							_tmp29_ = tokens_remaining;
							_tmp30_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp29_);
							_tmp31_ = _tmp30_;
							if (_tmp31_ == 0) {
								result = match_score;
								_g_free0 (token);
								_g_object_unref0 (iter);
								_g_free0 (individual_translit_locale);
								_g_object_unref0 (tokens_remaining);
								return result;
							}
						}
						_g_free0 (token);
					}
					_g_object_unref0 (iter);
				}
			}
		}
	}
	_tmp32_ = tokens_remaining;
	_tmp33_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp32_);
	_tmp34_ = _tmp33_;
	_vala_assert (_tmp34_ > 0, "tokens_remaining.size > 0");
	result = (guint) 0;
	_g_free0 (individual_translit_locale);
	_g_object_unref0 (tokens_remaining);
	return result;
}

static guint
_folks_simple_query_prop_contains_token (FolksSimpleQuery* self,
                                         FolksIndividual* individual,
                                         const gchar* individual_translit_locale,
                                         const gchar* prop_name,
                                         GParamSpec* prop_spec,
                                         const gchar* token)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (individual != NULL, 0U);
	g_return_val_if_fail (prop_name != NULL, 0U);
	g_return_val_if_fail (prop_spec != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	if (FALSE) {
	} else {
		if (prop_spec->value_type == G_TYPE_STRING) {
			gchar* prop_value = NULL;
			gchar* _tmp0_ = NULL;
			gboolean _tmp1_ = FALSE;
			const gchar* _tmp2_;
			guint score = 0U;
			const gchar* _tmp4_;
			g_object_get ((GObject*) individual, prop_name, &_tmp0_, NULL);
			_g_free0 (prop_value);
			prop_value = _tmp0_;
			_tmp2_ = prop_value;
			if (_tmp2_ == NULL) {
				_tmp1_ = TRUE;
			} else {
				const gchar* _tmp3_;
				_tmp3_ = prop_value;
				_tmp1_ = g_strcmp0 (_tmp3_, "") == 0;
			}
			if (_tmp1_) {
				result = (guint) 0;
				_g_free0 (prop_value);
				return result;
			}
			_tmp4_ = prop_value;
			score = _folks_simple_query_string_matches_token (self, _tmp4_, token, individual_translit_locale);
			if (score > ((guint) 0)) {
				gboolean _tmp5_ = FALSE;
				if (g_strcmp0 (prop_name, "full-name") == 0) {
					_tmp5_ = TRUE;
				} else {
					_tmp5_ = g_strcmp0 (prop_name, "nickname") == 0;
				}
				if (_tmp5_) {
					result = score * 10;
					_g_free0 (prop_value);
					return result;
				} else {
					result = score * 2;
					_g_free0 (prop_value);
					return result;
				}
			}
			_g_free0 (prop_value);
		} else {
			if (prop_spec->value_type == FOLKS_TYPE_STRUCTURED_NAME) {
				FolksStructuredName* prop_value = NULL;
				FolksStructuredName* _tmp6_ = NULL;
				FolksStructuredName* _tmp7_;
				guint score = 0U;
				FolksStructuredName* _tmp8_;
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				FolksStructuredName* _tmp11_;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				FolksStructuredName* _tmp14_;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				g_object_get ((GObject*) individual, prop_name, &_tmp6_, NULL);
				_g_object_unref0 (prop_value);
				prop_value = _tmp6_;
				_tmp7_ = prop_value;
				if (_tmp7_ == NULL) {
					result = (guint) 0;
					_g_object_unref0 (prop_value);
					return result;
				}
				_tmp8_ = prop_value;
				_tmp9_ = folks_structured_name_get_given_name (_tmp8_);
				_tmp10_ = _tmp9_;
				score = _folks_simple_query_string_matches_token (self, _tmp10_, token, individual_translit_locale);
				if (score > ((guint) 0)) {
					result = score * 10;
					_g_object_unref0 (prop_value);
					return result;
				}
				_tmp11_ = prop_value;
				_tmp12_ = folks_structured_name_get_family_name (_tmp11_);
				_tmp13_ = _tmp12_;
				score = _folks_simple_query_string_matches_token (self, _tmp13_, token, individual_translit_locale);
				if (score > ((guint) 0)) {
					result = score * 10;
					_g_object_unref0 (prop_value);
					return result;
				}
				_tmp14_ = prop_value;
				_tmp15_ = folks_structured_name_get_additional_names (_tmp14_);
				_tmp16_ = _tmp15_;
				score = _folks_simple_query_string_matches_token (self, _tmp16_, token, individual_translit_locale);
				if (score > ((guint) 0)) {
					result = score * 5;
					_g_object_unref0 (prop_value);
					return result;
				}
				_g_object_unref0 (prop_value);
			} else {
				if (prop_spec->value_type == GEE_TYPE_SET) {
					GeeSet* prop_value_set = NULL;
					GeeSet* _tmp17_ = NULL;
					gboolean _tmp18_ = FALSE;
					GeeSet* _tmp19_;
					GeeSet* _tmp23_;
					GType _tmp24_;
					GType _tmp25_;
					g_object_get ((GObject*) individual, prop_name, &_tmp17_, NULL);
					_g_object_unref0 (prop_value_set);
					prop_value_set = _tmp17_;
					_tmp19_ = prop_value_set;
					if (_tmp19_ == NULL) {
						_tmp18_ = TRUE;
					} else {
						GeeSet* _tmp20_;
						gboolean _tmp21_;
						gboolean _tmp22_;
						_tmp20_ = prop_value_set;
						_tmp21_ = gee_collection_get_is_empty ((GeeCollection*) _tmp20_);
						_tmp22_ = _tmp21_;
						_tmp18_ = _tmp22_;
					}
					if (_tmp18_) {
						result = (guint) 0;
						_g_object_unref0 (prop_value_set);
						return result;
					}
					_tmp23_ = prop_value_set;
					_tmp24_ = gee_traversable_get_element_type ((GeeTraversable*) _tmp23_);
					_tmp25_ = _tmp24_;
					if (g_type_is_a (_tmp25_, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS)) {
						GeeSet* prop_value_afd = NULL;
						GeeSet* _tmp26_;
						_tmp26_ = prop_value_set;
						prop_value_afd = G_TYPE_CHECK_INSTANCE_TYPE (_tmp26_, GEE_TYPE_SET) ? ((GeeSet*) _tmp26_) : NULL;
						{
							GeeIterator* _val_it = NULL;
							GeeSet* _tmp27_;
							GeeIterator* _tmp28_;
							_tmp27_ = prop_value_afd;
							_tmp28_ = gee_iterable_iterator ((GeeIterable*) _tmp27_);
							_val_it = _tmp28_;
							while (TRUE) {
								GeeIterator* _tmp29_;
								FolksAbstractFieldDetails* val = NULL;
								GeeIterator* _tmp30_;
								gpointer _tmp31_;
								FolksAbstractFieldDetails* _tmp32_;
								GType _tmp33_;
								GType _tmp34_;
								_tmp29_ = _val_it;
								if (!gee_iterator_next (_tmp29_)) {
									break;
								}
								_tmp30_ = _val_it;
								_tmp31_ = gee_iterator_get (_tmp30_);
								val = (FolksAbstractFieldDetails*) _tmp31_;
								_tmp32_ = val;
								_tmp33_ = folks_abstract_field_details_get_value_type (_tmp32_);
								_tmp34_ = _tmp33_;
								if (_tmp34_ == G_TYPE_STRING) {
									guint score = 0U;
									FolksAbstractFieldDetails* _tmp35_;
									_tmp35_ = val;
									score = _folks_simple_query_prop_contains_token_fd_string (self, individual, individual_translit_locale, prop_name, prop_spec, _tmp35_, token);
									if (score > ((guint) 0)) {
										if (g_strcmp0 (prop_name, "email-addresses") == 0) {
											result = score * 4;
											_g_object_unref0 (val);
											_g_object_unref0 (_val_it);
											_g_object_unref0 (prop_value_set);
											return result;
										} else {
											result = score * 2;
											_g_object_unref0 (val);
											_g_object_unref0 (_val_it);
											_g_object_unref0 (prop_value_set);
											return result;
										}
									}
								} else {
									FolksAbstractFieldDetails* _tmp36_;
									GType _tmp37_;
									GType _tmp38_;
									_tmp36_ = val;
									_tmp37_ = folks_abstract_field_details_get_value_type (_tmp36_);
									_tmp38_ = _tmp37_;
									if (_tmp38_ == FOLKS_TYPE_ROLE) {
										guint score = 0U;
										FolksAbstractFieldDetails* _tmp39_;
										_tmp39_ = val;
										score = _folks_simple_query_prop_contains_token_fd_role (self, individual, individual_translit_locale, prop_name, prop_spec, _tmp39_, token);
										if (score > ((guint) 0)) {
											result = score * 1;
											_g_object_unref0 (val);
											_g_object_unref0 (_val_it);
											_g_object_unref0 (prop_value_set);
											return result;
										}
									} else {
										FolksAbstractFieldDetails* _tmp40_;
										GType _tmp41_;
										GType _tmp42_;
										_tmp40_ = val;
										_tmp41_ = folks_abstract_field_details_get_value_type (_tmp40_);
										_tmp42_ = _tmp41_;
										if (_tmp42_ == FOLKS_TYPE_POSTAL_ADDRESS) {
											guint score = 0U;
											FolksAbstractFieldDetails* _tmp43_;
											_tmp43_ = val;
											score = _folks_simple_query_prop_contains_token_fd_postal_address (self, individual, individual_translit_locale, prop_name, prop_spec, _tmp43_, token);
											if (score > ((guint) 0)) {
												result = score * 3;
												_g_object_unref0 (val);
												_g_object_unref0 (_val_it);
												_g_object_unref0 (prop_value_set);
												return result;
											}
										} else {
											FolksAbstractFieldDetails* _tmp44_;
											GType _tmp45_;
											GType _tmp46_;
											const gchar* _tmp47_;
											_tmp44_ = val;
											_tmp45_ = folks_abstract_field_details_get_value_type (_tmp44_);
											_tmp46_ = _tmp45_;
											_tmp47_ = g_type_name (_tmp46_);
											g_warning ("Cannot check for match in detail type " "Gee.Set<AbstractFieldDetails<%s>>", _tmp47_);
											result = (guint) 0;
											_g_object_unref0 (val);
											_g_object_unref0 (_val_it);
											_g_object_unref0 (prop_value_set);
											return result;
										}
									}
								}
								_g_object_unref0 (val);
							}
							_g_object_unref0 (_val_it);
						}
					} else {
						GeeSet* _tmp48_;
						GType _tmp49_;
						GType _tmp50_;
						_tmp48_ = prop_value_set;
						_tmp49_ = gee_traversable_get_element_type ((GeeTraversable*) _tmp48_);
						_tmp50_ = _tmp49_;
						if (_tmp50_ == G_TYPE_STRING) {
							GeeSet* prop_value_string = NULL;
							GeeSet* _tmp51_;
							_tmp51_ = prop_value_set;
							prop_value_string = G_TYPE_CHECK_INSTANCE_TYPE (_tmp51_, GEE_TYPE_SET) ? ((GeeSet*) _tmp51_) : NULL;
							{
								GeeIterator* _val_it = NULL;
								GeeSet* _tmp52_;
								GeeIterator* _tmp53_;
								_tmp52_ = prop_value_string;
								_tmp53_ = gee_iterable_iterator ((GeeIterable*) _tmp52_);
								_val_it = _tmp53_;
								while (TRUE) {
									GeeIterator* _tmp54_;
									gchar* val = NULL;
									GeeIterator* _tmp55_;
									gpointer _tmp56_;
									gboolean _tmp57_ = FALSE;
									const gchar* _tmp58_;
									guint score = 0U;
									const gchar* _tmp60_;
									_tmp54_ = _val_it;
									if (!gee_iterator_next (_tmp54_)) {
										break;
									}
									_tmp55_ = _val_it;
									_tmp56_ = gee_iterator_get (_tmp55_);
									val = (gchar*) _tmp56_;
									_tmp58_ = val;
									if (_tmp58_ == NULL) {
										_tmp57_ = TRUE;
									} else {
										const gchar* _tmp59_;
										_tmp59_ = val;
										_tmp57_ = g_strcmp0 (_tmp59_, "") == 0;
									}
									if (_tmp57_) {
										_g_free0 (val);
										continue;
									}
									_tmp60_ = val;
									score = _folks_simple_query_string_matches_token (self, _tmp60_, token, individual_translit_locale);
									if (score > ((guint) 0)) {
										result = score * 1;
										_g_free0 (val);
										_g_object_unref0 (_val_it);
										_g_object_unref0 (prop_value_set);
										return result;
									}
									_g_free0 (val);
								}
								_g_object_unref0 (_val_it);
							}
						} else {
							GeeSet* _tmp61_;
							GType _tmp62_;
							GType _tmp63_;
							const gchar* _tmp64_;
							_tmp61_ = prop_value_set;
							_tmp62_ = gee_traversable_get_element_type ((GeeTraversable*) _tmp61_);
							_tmp63_ = _tmp62_;
							_tmp64_ = g_type_name (_tmp63_);
							g_warning ("Cannot check for match in property ‘%s’, detail type " "Gee.Set<%s>", prop_name, _tmp64_);
							result = (guint) 0;
							_g_object_unref0 (prop_value_set);
							return result;
						}
					}
					_g_object_unref0 (prop_value_set);
				} else {
					if (prop_spec->value_type == GEE_TYPE_MULTI_MAP) {
						GeeMultiMap* prop_value_multi_map = NULL;
						GeeMultiMap* _tmp65_ = NULL;
						gboolean _tmp66_ = FALSE;
						GeeMultiMap* _tmp67_;
						GType key_type = 0UL;
						GeeMultiMap* _tmp71_;
						GType _tmp72_;
						GType _tmp73_;
						GType value_type = 0UL;
						GeeMultiMap* _tmp74_;
						GType _tmp75_;
						GType _tmp76_;
						gboolean _tmp77_ = FALSE;
						g_object_get ((GObject*) individual, prop_name, &_tmp65_, NULL);
						_g_object_unref0 (prop_value_multi_map);
						prop_value_multi_map = _tmp65_;
						_tmp67_ = prop_value_multi_map;
						if (_tmp67_ == NULL) {
							_tmp66_ = TRUE;
						} else {
							GeeMultiMap* _tmp68_;
							gint _tmp69_;
							gint _tmp70_;
							_tmp68_ = prop_value_multi_map;
							_tmp69_ = gee_multi_map_get_size (_tmp68_);
							_tmp70_ = _tmp69_;
							_tmp66_ = _tmp70_ < 1;
						}
						if (_tmp66_) {
							result = (guint) 0;
							_g_object_unref0 (prop_value_multi_map);
							return result;
						}
						_tmp71_ = prop_value_multi_map;
						_tmp72_ = gee_multi_map_get_key_type (_tmp71_);
						_tmp73_ = _tmp72_;
						key_type = _tmp73_;
						_tmp74_ = prop_value_multi_map;
						_tmp75_ = gee_multi_map_get_value_type (_tmp74_);
						_tmp76_ = _tmp75_;
						value_type = _tmp76_;
						if (g_type_is_a (key_type, G_TYPE_STRING)) {
							_tmp77_ = g_type_is_a (value_type, FOLKS_TYPE_ABSTRACT_FIELD_DETAILS);
						} else {
							_tmp77_ = FALSE;
						}
						if (_tmp77_) {
							GeeMultiMap* prop_value_multi_map_afd = NULL;
							GeeMultiMap* _tmp78_;
							GeeMapIterator* iter = NULL;
							GeeMultiMap* _tmp79_;
							GeeMapIterator* _tmp80_;
							_tmp78_ = prop_value_multi_map;
							prop_value_multi_map_afd = G_TYPE_CHECK_INSTANCE_TYPE (_tmp78_, GEE_TYPE_MULTI_MAP) ? ((GeeMultiMap*) _tmp78_) : NULL;
							_tmp79_ = prop_value_multi_map_afd;
							_tmp80_ = gee_multi_map_map_iterator (_tmp79_);
							iter = _tmp80_;
							while (TRUE) {
								GeeMapIterator* _tmp81_;
								FolksAbstractFieldDetails* val = NULL;
								GeeMapIterator* _tmp82_;
								gpointer _tmp83_;
								FolksAbstractFieldDetails* _tmp84_;
								GType _tmp85_;
								GType _tmp86_;
								_tmp81_ = iter;
								if (!gee_map_iterator_next (_tmp81_)) {
									break;
								}
								_tmp82_ = iter;
								_tmp83_ = gee_map_iterator_get_value (_tmp82_);
								val = (FolksAbstractFieldDetails*) _tmp83_;
								_tmp84_ = val;
								_tmp85_ = folks_abstract_field_details_get_value_type (_tmp84_);
								_tmp86_ = _tmp85_;
								if (_tmp86_ == G_TYPE_STRING) {
									guint score = 0U;
									FolksAbstractFieldDetails* _tmp87_;
									_tmp87_ = val;
									score = _folks_simple_query_prop_contains_token_fd_string (self, individual, individual_translit_locale, prop_name, prop_spec, _tmp87_, token);
									if (score > ((guint) 0)) {
										result = score * 2;
										_g_object_unref0 (val);
										_g_object_unref0 (iter);
										_g_object_unref0 (prop_value_multi_map);
										return result;
									}
								}
								_g_object_unref0 (val);
							}
							_g_object_unref0 (iter);
						} else {
							const gchar* _tmp88_;
							const gchar* _tmp89_;
							_tmp88_ = g_type_name (key_type);
							_tmp89_ = g_type_name (value_type);
							g_warning ("Cannot check for match in detail type " "Gee.MultiMap<%s, %s>", _tmp88_, _tmp89_);
							result = (guint) 0;
							_g_object_unref0 (prop_value_multi_map);
							return result;
						}
						_g_object_unref0 (prop_value_multi_map);
					} else {
						const gchar* _tmp90_;
						_tmp90_ = g_type_name (prop_spec->value_type);
						g_warning ("simple-query.vala:398: Cannot check for match in detail type %s", _tmp90_);
					}
				}
			}
		}
	}
	result = (guint) 0;
	return result;
}

static guint
_folks_simple_query_prop_contains_token_fd_string (FolksSimpleQuery* self,
                                                   FolksIndividual* individual,
                                                   const gchar* individual_translit_locale,
                                                   const gchar* prop_name,
                                                   GParamSpec* prop_spec,
                                                   FolksAbstractFieldDetails* val,
                                                   const gchar* token)
{
	gconstpointer _tmp10_;
	gconstpointer _tmp11_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (individual != NULL, 0U);
	g_return_val_if_fail (prop_name != NULL, 0U);
	g_return_val_if_fail (prop_spec != NULL, 0U);
	g_return_val_if_fail (val != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	if (G_TYPE_FROM_INSTANCE ((GObject*) val) == FOLKS_TYPE_PHONE_FIELD_DETAILS) {
		FolksPhoneFieldDetails* pfd = NULL;
		FolksPhoneFieldDetails* _tmp0_;
		FolksPhoneFieldDetails* _tmp1_;
		gchar* normalized_token = NULL;
		FolksPhoneFieldDetails* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp0_ = folks_phone_field_details_new (token, NULL);
		pfd = _tmp0_;
		_tmp1_ = pfd;
		if (folks_abstract_field_details_values_equal (val, (FolksAbstractFieldDetails*) _tmp1_)) {
			result = (guint) 2;
			_g_object_unref0 (pfd);
			return result;
		}
		_tmp2_ = pfd;
		_tmp3_ = folks_phone_field_details_get_normalised (_tmp2_);
		normalized_token = _tmp3_;
		_tmp4_ = normalized_token;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ != 0) {
			gchar* normalized_val = NULL;
			gchar* _tmp7_;
			guint score = 0U;
			const gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp7_ = folks_phone_field_details_get_normalised (G_TYPE_CHECK_INSTANCE_CAST (val, FOLKS_TYPE_PHONE_FIELD_DETAILS, FolksPhoneFieldDetails));
			normalized_val = _tmp7_;
			_tmp8_ = normalized_val;
			_tmp9_ = normalized_token;
			score = _folks_simple_query_string_matches_token (self, _tmp8_, _tmp9_, individual_translit_locale);
			if (score > ((guint) 0)) {
				result = score;
				_g_free0 (normalized_val);
				_g_free0 (normalized_token);
				_g_object_unref0 (pfd);
				return result;
			}
			_g_free0 (normalized_val);
		}
		_g_free0 (normalized_token);
		_g_object_unref0 (pfd);
	}
	_tmp10_ = folks_abstract_field_details_get_value (val);
	_tmp11_ = _tmp10_;
	result = _folks_simple_query_string_matches_token (self, (const gchar*) _tmp11_, token, individual_translit_locale);
	return result;
}

static guint
_folks_simple_query_prop_contains_token_fd_postal_address (FolksSimpleQuery* self,
                                                           FolksIndividual* individual,
                                                           const gchar* individual_translit_locale,
                                                           const gchar* prop_name,
                                                           GParamSpec* prop_spec,
                                                           FolksAbstractFieldDetails* val,
                                                           const gchar* token)
{
	guint score = 0U;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gconstpointer _tmp4_;
	gconstpointer _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gconstpointer _tmp8_;
	gconstpointer _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gconstpointer _tmp12_;
	gconstpointer _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (individual != NULL, 0U);
	g_return_val_if_fail (prop_name != NULL, 0U);
	g_return_val_if_fail (prop_spec != NULL, 0U);
	g_return_val_if_fail (val != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	_tmp0_ = folks_abstract_field_details_get_value (val);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_postal_address_get_street ((FolksPostalAddress*) _tmp1_);
	_tmp3_ = _tmp2_;
	score = _folks_simple_query_string_matches_token (self, _tmp3_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp4_ = folks_abstract_field_details_get_value (val);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_postal_address_get_locality ((FolksPostalAddress*) _tmp5_);
	_tmp7_ = _tmp6_;
	score = _folks_simple_query_string_matches_token (self, _tmp7_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp8_ = folks_abstract_field_details_get_value (val);
	_tmp9_ = _tmp8_;
	_tmp10_ = folks_postal_address_get_region ((FolksPostalAddress*) _tmp9_);
	_tmp11_ = _tmp10_;
	score = _folks_simple_query_string_matches_token (self, _tmp11_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp12_ = folks_abstract_field_details_get_value (val);
	_tmp13_ = _tmp12_;
	_tmp14_ = folks_postal_address_get_country ((FolksPostalAddress*) _tmp13_);
	_tmp15_ = _tmp14_;
	score = _folks_simple_query_string_matches_token (self, _tmp15_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	result = (guint) 0;
	return result;
}

static guint
_folks_simple_query_prop_contains_token_fd_role (FolksSimpleQuery* self,
                                                 FolksIndividual* individual,
                                                 const gchar* individual_translit_locale,
                                                 const gchar* prop_name,
                                                 GParamSpec* prop_spec,
                                                 FolksAbstractFieldDetails* val,
                                                 const gchar* token)
{
	guint score = 0U;
	gconstpointer _tmp0_;
	gconstpointer _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	gconstpointer _tmp4_;
	gconstpointer _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gconstpointer _tmp8_;
	gconstpointer _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (individual != NULL, 0U);
	g_return_val_if_fail (prop_name != NULL, 0U);
	g_return_val_if_fail (prop_spec != NULL, 0U);
	g_return_val_if_fail (val != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	_tmp0_ = folks_abstract_field_details_get_value (val);
	_tmp1_ = _tmp0_;
	_tmp2_ = folks_role_get_organisation_name ((FolksRole*) _tmp1_);
	_tmp3_ = _tmp2_;
	score = _folks_simple_query_string_matches_token (self, _tmp3_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp4_ = folks_abstract_field_details_get_value (val);
	_tmp5_ = _tmp4_;
	_tmp6_ = folks_role_get_title ((FolksRole*) _tmp5_);
	_tmp7_ = _tmp6_;
	score = _folks_simple_query_string_matches_token (self, _tmp7_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	_tmp8_ = folks_abstract_field_details_get_value (val);
	_tmp9_ = _tmp8_;
	_tmp10_ = folks_role_get_role ((FolksRole*) _tmp9_);
	_tmp11_ = _tmp10_;
	score = _folks_simple_query_string_matches_token (self, _tmp11_, token, individual_translit_locale);
	if (score > ((guint) 0)) {
		result = score;
		return result;
	}
	result = (guint) 0;
	return result;
}

static inline guint
_folks_simple_query_string_matches_token (FolksSimpleQuery* self,
                                          const gchar* str,
                                          const gchar* token,
                                          const gchar* str_translit_locale)
{
	gchar** alternates = NULL;
	gint alternates_length1 = 0;
	gint _alternates_size_ = 0;
	gchar** str_tokens = NULL;
	gchar** _tmp0_ = NULL;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint str_tokens_length1;
	gint _str_tokens_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (str != NULL, 0U);
	g_return_val_if_fail (token != NULL, 0U);
	g_debug ("simple-query.vala:503: Matching string ‘%s’ against token ‘%s’.", str, token);
	_tmp2_ = _tmp1_ = g_str_tokenize_and_fold (str, str_translit_locale, &_tmp0_);
	alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
	alternates = _tmp0_;
	alternates_length1 = -1;
	_alternates_size_ = alternates_length1;
	alternates_length1 = _vala_array_length (alternates);
	str_tokens = _tmp2_;
	str_tokens_length1 = _vala_array_length (_tmp1_);
	_str_tokens_size_ = str_tokens_length1;
	_tmp3_ = str_tokens;
	_tmp3__length1 = str_tokens_length1;
	{
		gchar** str_token_collection = NULL;
		gint str_token_collection_length1 = 0;
		gint _str_token_collection_size_ = 0;
		gint str_token_it = 0;
		str_token_collection = _tmp3_;
		str_token_collection_length1 = _tmp3__length1;
		for (str_token_it = 0; str_token_it < str_token_collection_length1; str_token_it = str_token_it + 1) {
			const gchar* str_token = NULL;
			str_token = str_token_collection[str_token_it];
			{
				const gchar* _tmp4_;
				_tmp4_ = str_token;
				if (g_strcmp0 (_tmp4_, token) == 0) {
					result = (guint) 3;
					str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
					alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
					return result;
				} else {
					const gchar* _tmp5_;
					_tmp5_ = str_token;
					if (g_str_has_prefix (_tmp5_, token)) {
						result = (guint) 2;
						str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
						alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
				}
			}
		}
	}
	_tmp6_ = alternates;
	_tmp6__length1 = alternates_length1;
	{
		gchar** str_token_collection = NULL;
		gint str_token_collection_length1 = 0;
		gint _str_token_collection_size_ = 0;
		gint str_token_it = 0;
		str_token_collection = _tmp6_;
		str_token_collection_length1 = _tmp6__length1;
		for (str_token_it = 0; str_token_it < str_token_collection_length1; str_token_it = str_token_it + 1) {
			const gchar* str_token = NULL;
			str_token = str_token_collection[str_token_it];
			{
				const gchar* _tmp7_;
				_tmp7_ = str_token;
				if (g_strcmp0 (_tmp7_, token) == 0) {
					result = (guint) 2;
					str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
					alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
					return result;
				} else {
					const gchar* _tmp8_;
					_tmp8_ = str_token;
					if (g_str_has_prefix (_tmp8_, token)) {
						result = (guint) 1;
						str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
						alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
						return result;
					}
				}
			}
		}
	}
	result = (guint) 0;
	str_tokens = (_vala_array_free (str_tokens, str_tokens_length1, (GDestroyNotify) g_free), NULL);
	alternates = (_vala_array_free (alternates, alternates_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

const gchar*
folks_simple_query_get_query_string (FolksSimpleQuery* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_query_string;
	result = _tmp0_;
	return result;
}

void
folks_simple_query_set_query_string (FolksSimpleQuery* self,
                                     const gchar* value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	if (value == NULL) {
		value = "";
	}
	_tmp0_ = self->priv->_query_string;
	if (g_strcmp0 (_tmp0_, value) == 0) {
		return;
	}
	_tmp1_ = self->priv->_query_locale;
	_folks_simple_query_update_query_string (self, value, _tmp1_);
	g_object_notify_by_pspec ((GObject *) self, folks_simple_query_properties[FOLKS_SIMPLE_QUERY_QUERY_STRING_PROPERTY]);
}

const gchar*
folks_simple_query_get_query_locale (FolksSimpleQuery* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_query_locale;
	result = _tmp0_;
	return result;
}

void
folks_simple_query_set_query_locale (FolksSimpleQuery* self,
                                     const gchar* value)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_query_locale;
	if (g_strcmp0 (_tmp0_, value) == 0) {
		return;
	}
	_tmp1_ = self->priv->_query_string;
	_folks_simple_query_update_query_string (self, _tmp1_, value);
	g_object_notify_by_pspec ((GObject *) self, folks_simple_query_properties[FOLKS_SIMPLE_QUERY_QUERY_LOCALE_PROPERTY]);
}

static void
folks_simple_query_class_init (FolksSimpleQueryClass * klass,
                               gpointer klass_data)
{
	folks_simple_query_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FolksSimpleQuery_private_offset);
	((FolksQueryClass *) klass)->is_match = (guint (*) (FolksQuery*, FolksIndividual*)) folks_simple_query_real_is_match;
	G_OBJECT_CLASS (klass)->get_property = _vala_folks_simple_query_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_folks_simple_query_set_property;
	G_OBJECT_CLASS (klass)->finalize = folks_simple_query_finalize;
	/**
	   * The text query string.
	   *
	   * This re-evaluates the query immediately, so most clients should implement
	   * de-bouncing to ensure re-evaluation only happens when (for example) the
	   * user has stopped typing a new query.
	   *
	   * @since 0.11.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_SIMPLE_QUERY_QUERY_STRING_PROPERTY, folks_simple_query_properties[FOLKS_SIMPLE_QUERY_QUERY_STRING_PROPERTY] = g_param_spec_string ("query-string", "query-string", "query-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	/**
	   * Locale to interpret the {@link SimpleQuery.query_string} in.
	   *
	   * If possible, locale-specific query string transliteration is done to
	   * increase the number of matches. Set this property to a POSIX locale name
	   * (e.g. ‘en’, ‘de_DE’, ‘de_DE@euro’ or ‘C’) to potentially improve the
	   * transliteration performed.
	   *
	   * This may be `null` if the locale is unknown, in which case the current
	   * locale will be used. To perform transliteration for no specific locale,
	   * use `C`.
	   *
	   * @since 0.11.0
	   */
	g_object_class_install_property (G_OBJECT_CLASS (klass), FOLKS_SIMPLE_QUERY_QUERY_LOCALE_PROPERTY, folks_simple_query_properties[FOLKS_SIMPLE_QUERY_QUERY_LOCALE_PROPERTY] = g_param_spec_string ("query-locale", "query-locale", "query-locale", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
folks_simple_query_instance_init (FolksSimpleQuery * self,
                                  gpointer klass)
{
	self->priv = folks_simple_query_get_instance_private (self);
	self->priv->_query_locale = NULL;
}

static void
folks_simple_query_finalize (GObject * obj)
{
	FolksSimpleQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery);
	_g_free0 (self->priv->_query_string);
	self->priv->_query_tokens = (_vala_array_free (self->priv->_query_tokens, self->priv->_query_tokens_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (self->priv->_query_locale);
	G_OBJECT_CLASS (folks_simple_query_parent_class)->finalize (obj);
}

/**
 * A simple text-based contact query.
 *
 * This is a generic implementation of the {@link Query} interface which
 * supports general UI-style search use cases. It implements case-insensitive
 * prefix matching, with transliteration of accents and other non-ASCII
 * characters to improve matching against accented characters. It also
 * normalises phone numbers to make matches invariant to hyphenation and spacing
 * in phone numbers.
 *
 * @see SearchView
 * @since 0.11.0
 */
static GType
folks_simple_query_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FolksSimpleQueryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) folks_simple_query_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FolksSimpleQuery), 0, (GInstanceInitFunc) folks_simple_query_instance_init, NULL };
	GType folks_simple_query_type_id;
	folks_simple_query_type_id = g_type_register_static (FOLKS_TYPE_QUERY, "FolksSimpleQuery", &g_define_type_info, 0);
	FolksSimpleQuery_private_offset = g_type_add_instance_private (folks_simple_query_type_id, sizeof (FolksSimpleQueryPrivate));
	return folks_simple_query_type_id;
}

GType
folks_simple_query_get_type (void)
{
	static volatile gsize folks_simple_query_type_id__once = 0;
	if (g_once_init_enter (&folks_simple_query_type_id__once)) {
		GType folks_simple_query_type_id;
		folks_simple_query_type_id = folks_simple_query_get_type_once ();
		g_once_init_leave (&folks_simple_query_type_id__once, folks_simple_query_type_id);
	}
	return folks_simple_query_type_id__once;
}

static void
_vala_folks_simple_query_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	FolksSimpleQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery);
	switch (property_id) {
		case FOLKS_SIMPLE_QUERY_QUERY_STRING_PROPERTY:
		g_value_set_string (value, folks_simple_query_get_query_string (self));
		break;
		case FOLKS_SIMPLE_QUERY_QUERY_LOCALE_PROPERTY:
		g_value_set_string (value, folks_simple_query_get_query_locale (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_folks_simple_query_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	FolksSimpleQuery * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FOLKS_TYPE_SIMPLE_QUERY, FolksSimpleQuery);
	switch (property_id) {
		case FOLKS_SIMPLE_QUERY_QUERY_STRING_PROPERTY:
		folks_simple_query_set_query_string (self, g_value_get_string (value));
		break;
		case FOLKS_SIMPLE_QUERY_QUERY_LOCALE_PROPERTY:
		folks_simple_query_set_query_locale (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

