/* game-window.c generated by valac 0.56.18, the Vala compiler
 * generated from game-window.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
   This file is part of GNOME Four-in-a-row.

   Copyright © 2015, 2016, 2019 Arnaud Bonatti

   GNOME Four-in-a-row is free software: you can redistribute it and/or
   modify it under the terms of the GNU General Public License as published
   by the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME Four-in-a-row is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License along
   with GNOME Four-in-a-row.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <gtk/gtk.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

typedef enum  {
	GAME_WINDOW_FLAGS_SHOW_UNDO = 1 << 0,
	GAME_WINDOW_FLAGS_SHOW_START_BUTTON = 1 << 1
} GameWindowFlags;

#define TYPE_GAME_WINDOW_FLAGS (game_window_flags_get_type ())

#define TYPE_ADAPTATIVE_WINDOW (adaptative_window_get_type ())
#define ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindow))
#define ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))
#define IS_ADAPTATIVE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WINDOW))
#define IS_ADAPTATIVE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ADAPTATIVE_WINDOW))
#define ADAPTATIVE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ADAPTATIVE_WINDOW, AdaptativeWindowClass))

typedef struct _AdaptativeWindow AdaptativeWindow;
typedef struct _AdaptativeWindowClass AdaptativeWindowClass;
typedef struct _AdaptativeWindowPrivate AdaptativeWindowPrivate;

#define TYPE_ADAPTATIVE_WIDGET (adaptative_widget_get_type ())
#define ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget))
#define IS_ADAPTATIVE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ADAPTATIVE_WIDGET))
#define ADAPTATIVE_WIDGET_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidgetIface))

typedef struct _AdaptativeWidget AdaptativeWidget;
typedef struct _AdaptativeWidgetIface AdaptativeWidgetIface;
typedef enum  {
	ADAPTATIVE_WIDGET_WINDOW_SIZE_START_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_USUAL_SIZE,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_QUITE_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_VERT,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_HZTL,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_PHONE_BOTH,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_THIN,
	ADAPTATIVE_WIDGET_WINDOW_SIZE_EXTRA_FLAT
} AdaptativeWidgetWindowSize;

#define ADAPTATIVE_WIDGET_TYPE_WINDOW_SIZE (adaptative_widget_window_size_get_type ())

#define TYPE_GAME_WINDOW (game_window_get_type ())
#define GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_WINDOW, GameWindow))
#define GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_WINDOW, GameWindowClass))
#define IS_GAME_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_WINDOW))
#define IS_GAME_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_WINDOW))
#define GAME_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_WINDOW, GameWindowClass))

typedef struct _GameWindow GameWindow;
typedef struct _GameWindowClass GameWindowClass;
typedef struct _GameWindowPrivate GameWindowPrivate;

#define TYPE_GAME_ACTION_BAR (game_action_bar_get_type ())
#define GAME_ACTION_BAR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_ACTION_BAR, GameActionBar))
#define GAME_ACTION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_ACTION_BAR, GameActionBarClass))
#define IS_GAME_ACTION_BAR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_ACTION_BAR))
#define IS_GAME_ACTION_BAR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_ACTION_BAR))
#define GAME_ACTION_BAR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_ACTION_BAR, GameActionBarClass))

typedef struct _GameActionBar GameActionBar;
typedef struct _GameActionBarClass GameActionBarClass;
enum  {
	GAME_WINDOW_0_PROPERTY,
	GAME_WINDOW_IS_EXTRA_THIN_PROPERTY,
	GAME_WINDOW_NUM_PROPERTIES
};
static GParamSpec* game_window_properties[GAME_WINDOW_NUM_PROPERTIES];
typedef void (*GSimpleActionActivateCallback) (GSimpleAction* action, GVariant* parameter, gpointer user_data);
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_GAME_ACTION_BAR_PLACE_HOLDER (game_action_bar_place_holder_get_type ())
#define GAME_ACTION_BAR_PLACE_HOLDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GAME_ACTION_BAR_PLACE_HOLDER, GameActionBarPlaceHolder))
#define GAME_ACTION_BAR_PLACE_HOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GAME_ACTION_BAR_PLACE_HOLDER, GameActionBarPlaceHolderClass))
#define IS_GAME_ACTION_BAR_PLACE_HOLDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GAME_ACTION_BAR_PLACE_HOLDER))
#define IS_GAME_ACTION_BAR_PLACE_HOLDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GAME_ACTION_BAR_PLACE_HOLDER))
#define GAME_ACTION_BAR_PLACE_HOLDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GAME_ACTION_BAR_PLACE_HOLDER, GameActionBarPlaceHolderClass))

typedef struct _GameActionBarPlaceHolder GameActionBarPlaceHolder;
typedef struct _GameActionBarPlaceHolderClass GameActionBarPlaceHolderClass;
enum  {
	GAME_WINDOW_PLAY_SIGNAL,
	GAME_WINDOW_WAIT_SIGNAL,
	GAME_WINDOW_BACK_SIGNAL,
	GAME_WINDOW_UNDO_SIGNAL,
	GAME_WINDOW_HINT_SIGNAL,
	GAME_WINDOW_NUM_SIGNALS
};
static guint game_window_signals[GAME_WINDOW_NUM_SIGNALS] = {0};

struct _AdaptativeWindow {
	GtkApplicationWindow parent_instance;
	AdaptativeWindowPrivate * priv;
};

struct _AdaptativeWindowClass {
	GtkApplicationWindowClass parent_class;
	void (*on_fullscreen) (AdaptativeWindow* self);
	void (*on_unfullscreen) (AdaptativeWindow* self);
	void (*before_destroy) (AdaptativeWindow* self);
};

struct _AdaptativeWidgetIface {
	GTypeInterface parent_iface;
	void (*set_window_size) (AdaptativeWidget* self, AdaptativeWidgetWindowSize new_size);
};

struct _GameWindow {
	AdaptativeWindow parent_instance;
	GameWindowPrivate * priv;
};

struct _GameWindowClass {
	AdaptativeWindowClass parent_class;
};

struct _GameWindowPrivate {
	gboolean game_finished;
	gchar* program_name;
	GtkHeaderBar* headerbar;
	GtkOverlay* overlay;
	GtkStack* stack;
	GtkButton* start_game_button;
	GtkButton* new_game_button;
	GtkButton* back_button;
	GtkButton* unfullscreen_button;
	GtkBox* game_box;
	GtkBox* new_game_box;
	GtkWidget* view;
	GtkWidget* game_widget_1;
	GameActionBar* actionbar;
	GSimpleAction* back_action;
	GSimpleAction* undo_action;
	GSimpleAction* hint_action;
	gboolean _is_extra_thin;
	gboolean is_quite_thin;
	gchar* last_subtitle;
	GtkMenuButton* info_button;
};

static gint GameWindow_private_offset;
static gpointer game_window_parent_class = NULL;
static AdaptativeWidgetIface * game_window_adaptative_widget_parent_iface = NULL;

VALA_EXTERN GType game_window_flags_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWindow, g_object_unref)
VALA_EXTERN GType adaptative_widget_window_size_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType adaptative_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AdaptativeWidget, g_object_unref)
VALA_EXTERN GType game_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameWindow, g_object_unref)
VALA_EXTERN GType game_action_bar_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameActionBar, g_object_unref)
VALA_EXTERN void adaptative_window_on_fullscreen (AdaptativeWindow* self);
VALA_EXTERN void adaptative_window_on_unfullscreen (AdaptativeWindow* self);
static void game_window_new_game_cb (GameWindow* self);
static void _game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
static void game_window_start_game_cb (GameWindow* self);
static void _game_window_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                                  GVariant* parameter,
                                                                  gpointer self);
static void game_window_back_cb (GameWindow* self);
static void _game_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void game_window_undo_cb (GameWindow* self);
static void _game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static void game_window_hint_cb (GameWindow* self);
static void _game_window_hint_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                            GVariant* parameter,
                                                            gpointer self);
static inline void game_window_toggle_hamburger (GameWindow* self);
static void _game_window_toggle_hamburger_gsimple_action_activate_callback (GSimpleAction* action,
                                                                     GVariant* parameter,
                                                                     gpointer self);
static void _gtk_window_unfullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self);
VALA_EXTERN GameWindow* game_window_new (const gchar* css_resource,
                             const gchar* name,
                             gboolean start_now,
                             GameWindowFlags flags,
                             GtkBox* new_game_screen,
                             GtkWidget* _view,
                             GMenu* app_menu,
                             GtkWidget* _game_widget_1,
                             GtkWidget* game_widget_2);
VALA_EXTERN GameWindow* game_window_construct (GType object_type,
                                   const gchar* css_resource,
                                   const gchar* name,
                                   gboolean start_now,
                                   GameWindowFlags flags,
                                   GtkBox* new_game_screen,
                                   GtkWidget* _view,
                                   GMenu* app_menu,
                                   GtkWidget* _game_widget_1,
                                   GtkWidget* game_widget_2);
static void game_window_install_ui_action_entries (GameWindow* self);
VALA_EXTERN gboolean game_window_get_is_extra_thin (GameWindow* self);
VALA_EXTERN void adaptative_window_add_adaptative_child (AdaptativeWindow* self,
                                             AdaptativeWidget* child);
VALA_EXTERN GameActionBar* game_action_bar_new (const gchar* _game_name,
                                    GtkWidget* _game_widget,
                                    gboolean _show_actionbar);
VALA_EXTERN GameActionBar* game_action_bar_construct (GType object_type,
                                          const gchar* _game_name,
                                          GtkWidget* _game_widget,
                                          gboolean _show_actionbar);
VALA_EXTERN GType game_action_bar_place_holder_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GameActionBarPlaceHolder, g_object_unref)
VALA_EXTERN GameActionBarPlaceHolder* game_action_bar_place_holder_new (GameActionBar* _actionbar);
VALA_EXTERN GameActionBarPlaceHolder* game_action_bar_place_holder_construct (GType object_type,
                                                                  GameActionBar* _actionbar);
static void game_window_show_view (GameWindow* self);
static void game_window_show_new_game_screen (GameWindow* self);
static void game_window_real_on_fullscreen (AdaptativeWindow* base);
static void game_window_real_on_unfullscreen (AdaptativeWindow* base);
VALA_EXTERN void game_window_cannot_undo_more (GameWindow* self);
VALA_EXTERN void game_window_set_subtitle (GameWindow* self,
                               const gchar* subtitle);
VALA_EXTERN void game_action_bar_set_visibility (GameActionBar* self,
                                     gboolean new_visibility);
VALA_EXTERN void game_action_bar_update_title (GameActionBar* self,
                                   const gchar* new_title);
VALA_EXTERN void game_window_finish_game (GameWindow* self);
VALA_EXTERN void game_window_allow_hint (GameWindow* self,
                             gboolean allow);
VALA_EXTERN void game_window_allow_undo (GameWindow* self,
                             gboolean allow);
static void game_window_real_set_window_size (AdaptativeWidget* base,
                                       AdaptativeWidgetWindowSize new_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_quite_thin (AdaptativeWidgetWindowSize window_size);
VALA_EXTERN gboolean adaptative_widget_window_size_is_extra_thin (AdaptativeWidgetWindowSize window_size);
static void game_window_set_is_extra_thin (GameWindow* self,
                                    gboolean value);
VALA_EXTERN gboolean game_window_new_game_screen_visible (GameWindow* self);
VALA_EXTERN void game_window_close_hamburger (GameWindow* self);
VALA_EXTERN void adaptative_widget_set_window_size (AdaptativeWidget* self,
                                        AdaptativeWidgetWindowSize new_size);
static void game_window_finalize (GObject * obj);
static GType game_window_get_type_once (void);
static void _vala_game_window_get_property (GObject * object,
                                     guint property_id,
                                     GValue * value,
                                     GParamSpec * pspec);
static void _vala_game_window_set_property (GObject * object,
                                     guint property_id,
                                     const GValue * value,
                                     GParamSpec * pspec);

static const GActionEntry GAME_WINDOW_ui_action_entries[7] = {{"new-game", _game_window_new_game_cb_gsimple_action_activate_callback}, {"start-game", _game_window_start_game_cb_gsimple_action_activate_callback}, {"back", _game_window_back_cb_gsimple_action_activate_callback}, {"undo", _game_window_undo_cb_gsimple_action_activate_callback}, {"hint", _game_window_hint_cb_gsimple_action_activate_callback}, {"toggle-hamburger", _game_window_toggle_hamburger_gsimple_action_activate_callback}, {"unfullscreen", _gtk_window_unfullscreen_gsimple_action_activate_callback}};

static GType
game_window_flags_get_type_once (void)
{
	static const GFlagsValue values[] = {{GAME_WINDOW_FLAGS_SHOW_UNDO, "GAME_WINDOW_FLAGS_SHOW_UNDO", "show-undo"}, {GAME_WINDOW_FLAGS_SHOW_START_BUTTON, "GAME_WINDOW_FLAGS_SHOW_START_BUTTON", "show-start-button"}, {0, NULL, NULL}};
	GType game_window_flags_type_id;
	game_window_flags_type_id = g_flags_register_static ("GameWindowFlags", values);
	return game_window_flags_type_id;
}

GType
game_window_flags_get_type (void)
{
	static volatile gsize game_window_flags_type_id__once = 0;
	if (g_once_init_enter (&game_window_flags_type_id__once)) {
		GType game_window_flags_type_id;
		game_window_flags_type_id = game_window_flags_get_type_once ();
		g_once_init_leave (&game_window_flags_type_id__once, game_window_flags_type_id);
	}
	return game_window_flags_type_id__once;
}

static inline gpointer
game_window_get_instance_private (GameWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GameWindow_private_offset);
}

static void
_game_window_new_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	game_window_new_game_cb ((GameWindow*) self);
}

static void
_game_window_start_game_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                             GVariant* parameter,
                                                             gpointer self)
{
	game_window_start_game_cb ((GameWindow*) self);
}

static void
_game_window_back_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	game_window_back_cb ((GameWindow*) self);
}

static void
_game_window_undo_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	game_window_undo_cb ((GameWindow*) self);
}

static void
_game_window_hint_cb_gsimple_action_activate_callback (GSimpleAction* action,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	game_window_hint_cb ((GameWindow*) self);
}

static void
_game_window_toggle_hamburger_gsimple_action_activate_callback (GSimpleAction* action,
                                                                GVariant* parameter,
                                                                gpointer self)
{
	game_window_toggle_hamburger ((GameWindow*) self);
}

static void
_gtk_window_unfullscreen_gsimple_action_activate_callback (GSimpleAction* action,
                                                           GVariant* parameter,
                                                           gpointer self)
{
	gtk_window_unfullscreen ((GtkWindow*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GameWindow*
game_window_construct (GType object_type,
                       const gchar* css_resource,
                       const gchar* name,
                       gboolean start_now,
                       GameWindowFlags flags,
                       GtkBox* new_game_screen,
                       GtkWidget* _view,
                       GMenu* app_menu,
                       GtkWidget* _game_widget_1,
                       GtkWidget* game_widget_2)
{
	GameWindow * self = NULL;
	GtkWidget* _tmp7_;
	GtkWidget* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	GtkMenuButton* _tmp12_;
	GtkWidget* _tmp13_;
	GameActionBar* _tmp17_;
	GameActionBar* _tmp18_;
	GameActionBar* _tmp19_;
	GtkOverlay* _tmp20_;
	GameActionBar* _tmp21_;
	GameActionBarPlaceHolder* actionbar_placeholder = NULL;
	GameActionBar* _tmp22_;
	GameActionBarPlaceHolder* _tmp23_;
	GameActionBarPlaceHolder* _tmp24_;
	GtkBox* _tmp25_;
	GameActionBarPlaceHolder* _tmp26_;
	GtkBox* _tmp27_;
	GameActionBar* _tmp28_;
	GameActionBarPlaceHolder* _tmp29_;
	GtkBox* _tmp42_;
	GtkWidget* _tmp43_;
	GtkBox* _tmp44_;
	GtkWidget* _tmp45_;
	GtkWidget* _tmp46_;
	GtkWidget* _tmp47_;
	GtkWidget* _tmp48_;
	g_return_val_if_fail (name != NULL, NULL);
	g_return_val_if_fail (new_game_screen != NULL, NULL);
	g_return_val_if_fail (_view != NULL, NULL);
	g_return_val_if_fail (app_menu != NULL, NULL);
	self = (GameWindow*) g_object_new (object_type, "window-title", name, "specific-css-class-or-empty", "", "schema-path", "/org/gnome/Four-in-a-row/", NULL);
	if (css_resource != NULL) {
		GtkCssProvider* css_provider = NULL;
		GtkCssProvider* _tmp0_;
		GtkCssProvider* _tmp1_;
		GdkScreen* gdk_screen = NULL;
		GdkScreen* _tmp2_;
		GdkScreen* _tmp3_;
		GdkScreen* _tmp4_;
		_tmp0_ = gtk_css_provider_new ();
		css_provider = _tmp0_;
		_tmp1_ = css_provider;
		gtk_css_provider_load_from_resource (_tmp1_, (const gchar*) css_resource);
		_tmp2_ = gdk_screen_get_default ();
		_tmp3_ = _g_object_ref0 (_tmp2_);
		gdk_screen = _tmp3_;
		_tmp4_ = gdk_screen;
		if (_tmp4_ != NULL) {
			GdkScreen* _tmp5_;
			GtkCssProvider* _tmp6_;
			_tmp5_ = gdk_screen;
			_tmp6_ = css_provider;
			gtk_style_context_add_provider_for_screen (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, gdk_screen_get_type (), GdkScreen), (GtkStyleProvider*) _tmp6_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
		}
		_g_object_unref0 (gdk_screen);
		_g_object_unref0 (css_provider);
	}
	_tmp7_ = _g_object_ref0 (_view);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp7_;
	_tmp8_ = _g_object_ref0 (_game_widget_1);
	_g_object_unref0 (self->priv->game_widget_1);
	self->priv->game_widget_1 = _tmp8_;
	game_window_install_ui_action_entries (self);
	_tmp9_ = g_strdup (name);
	_g_free0 (self->priv->program_name);
	self->priv->program_name = _tmp9_;
	gtk_window_set_title ((GtkWindow*) self, name);
	_tmp10_ = self->priv->_is_extra_thin;
	if (!_tmp10_) {
		GtkHeaderBar* _tmp11_;
		_tmp11_ = self->priv->headerbar;
		gtk_header_bar_set_title (_tmp11_, name);
	}
	_tmp12_ = self->priv->info_button;
	gtk_menu_button_set_menu_model (_tmp12_, (GMenuModel*) app_menu);
	_tmp13_ = self->priv->game_widget_1;
	if (_tmp13_ != NULL) {
		GtkHeaderBar* _tmp14_;
		GtkWidget* _tmp15_;
		GtkWidget* _tmp16_;
		_tmp14_ = self->priv->headerbar;
		_tmp15_ = self->priv->game_widget_1;
		gtk_header_bar_pack_end (_tmp14_, G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, gtk_widget_get_type (), GtkWidget));
		_tmp16_ = self->priv->game_widget_1;
		adaptative_window_add_adaptative_child ((AdaptativeWindow*) self, G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_widget_get_type (), GtkWidget), TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget));
	}
	_tmp17_ = game_action_bar_new (name, game_widget_2, start_now);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->actionbar);
	self->priv->actionbar = _tmp17_;
	_tmp18_ = self->priv->actionbar;
	gtk_widget_show ((GtkWidget*) _tmp18_);
	_tmp19_ = self->priv->actionbar;
	gtk_widget_set_valign ((GtkWidget*) _tmp19_, GTK_ALIGN_END);
	_tmp20_ = self->priv->overlay;
	_tmp21_ = self->priv->actionbar;
	gtk_overlay_add_overlay (_tmp20_, (GtkWidget*) _tmp21_);
	_tmp22_ = self->priv->actionbar;
	_tmp23_ = game_action_bar_place_holder_new (_tmp22_);
	g_object_ref_sink (_tmp23_);
	actionbar_placeholder = _tmp23_;
	_tmp24_ = actionbar_placeholder;
	gtk_widget_show ((GtkWidget*) _tmp24_);
	_tmp25_ = self->priv->game_box;
	_tmp26_ = actionbar_placeholder;
	gtk_box_pack_end (_tmp25_, (GtkWidget*) _tmp26_, FALSE, TRUE, (guint) 0);
	_tmp27_ = self->priv->new_game_box;
	gtk_box_pack_start (_tmp27_, (GtkWidget*) new_game_screen, TRUE, TRUE, (guint) 0);
	adaptative_window_add_adaptative_child ((AdaptativeWindow*) self, G_TYPE_CHECK_INSTANCE_CAST (new_game_screen, TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget));
	_tmp28_ = self->priv->actionbar;
	adaptative_window_add_adaptative_child ((AdaptativeWindow*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp28_, TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget));
	_tmp29_ = actionbar_placeholder;
	adaptative_window_add_adaptative_child ((AdaptativeWindow*) self, G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget));
	adaptative_window_add_adaptative_child ((AdaptativeWindow*) self, G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ADAPTATIVE_WIDGET, AdaptativeWidget));
	if ((flags & GAME_WINDOW_FLAGS_SHOW_START_BUTTON) == GAME_WINDOW_FLAGS_SHOW_START_BUTTON) {
		GtkButton* _start_game_button = NULL;
		GtkButton* _tmp30_;
		GtkButton* _tmp31_;
		GtkStyleContext* _tmp32_;
		GtkButton* _tmp33_;
		GtkButton* _tmp34_;
		GtkButton* _tmp35_;
		GtkStyleContext* _tmp36_;
		GtkButton* _tmp37_;
		GtkBox* _tmp38_;
		GtkButton* _tmp39_;
		GtkButton* _tmp40_;
		GtkButton* _tmp41_;
		_tmp30_ = (GtkButton*) gtk_button_new_with_mnemonic (_ ("_Start Game"));
		g_object_ref_sink (_tmp30_);
		_start_game_button = _tmp30_;
		_tmp31_ = _start_game_button;
		_tmp32_ = gtk_widget_get_style_context ((GtkWidget*) _tmp31_);
		gtk_style_context_add_class (_tmp32_, "start-game-button");
		_tmp33_ = _start_game_button;
		gtk_widget_set_halign ((GtkWidget*) _tmp33_, GTK_ALIGN_CENTER);
		_tmp34_ = _start_game_button;
		gtk_actionable_set_action_name ((GtkActionable*) _tmp34_, "ui.start-game");
		_tmp35_ = _start_game_button;
		_tmp36_ = gtk_widget_get_style_context ((GtkWidget*) _tmp35_);
		gtk_style_context_add_class (G_TYPE_CHECK_INSTANCE_CAST (_tmp36_, gtk_style_context_get_type (), GtkStyleContext), "suggested-action");
		_tmp37_ = _start_game_button;
		gtk_widget_show ((GtkWidget*) _tmp37_);
		_tmp38_ = self->priv->new_game_box;
		_tmp39_ = _start_game_button;
		gtk_box_pack_end (_tmp38_, (GtkWidget*) _tmp39_, FALSE, FALSE, (guint) 0);
		_tmp40_ = _start_game_button;
		_tmp41_ = _g_object_ref0 (_tmp40_);
		_g_object_unref0 (self->priv->start_game_button);
		self->priv->start_game_button = _tmp41_;
		_g_object_unref0 (_start_game_button);
	}
	_tmp42_ = self->priv->game_box;
	_tmp43_ = self->priv->view;
	gtk_box_pack_start (_tmp42_, _tmp43_, TRUE, TRUE, (guint) 0);
	_tmp44_ = self->priv->game_box;
	_tmp45_ = self->priv->view;
	gtk_container_set_focus_child ((GtkContainer*) _tmp44_, _tmp45_);
	_tmp46_ = self->priv->view;
	gtk_widget_set_halign (_tmp46_, GTK_ALIGN_FILL);
	_tmp47_ = self->priv->view;
	gtk_widget_set_can_focus (_tmp47_, TRUE);
	_tmp48_ = self->priv->view;
	gtk_widget_show (_tmp48_);
	if (start_now) {
		game_window_show_view (self);
	} else {
		game_window_show_new_game_screen (self);
	}
	_g_object_unref0 (actionbar_placeholder);
	return self;
}

GameWindow*
game_window_new (const gchar* css_resource,
                 const gchar* name,
                 gboolean start_now,
                 GameWindowFlags flags,
                 GtkBox* new_game_screen,
                 GtkWidget* _view,
                 GMenu* app_menu,
                 GtkWidget* _game_widget_1,
                 GtkWidget* game_widget_2)
{
	return game_window_construct (TYPE_GAME_WINDOW, css_resource, name, start_now, flags, new_game_screen, _view, app_menu, _game_widget_1, game_widget_2);
}

static void
game_window_install_ui_action_entries (GameWindow* self)
{
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp0_;
	GAction* _tmp1_;
	GSimpleAction* _tmp2_;
	GAction* _tmp3_;
	GSimpleAction* _tmp4_;
	GAction* _tmp5_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GSimpleAction* _tmp8_;
	GSimpleAction* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_simple_action_group_new ();
	action_group = _tmp0_;
	g_action_map_add_action_entries ((GActionMap*) action_group, GAME_WINDOW_ui_action_entries, (gint) G_N_ELEMENTS (GAME_WINDOW_ui_action_entries), self);
	gtk_widget_insert_action_group ((GtkWidget*) self, "ui", (GActionGroup*) action_group);
	_tmp1_ = g_action_map_lookup_action ((GActionMap*) action_group, "back");
	_tmp2_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->back_action);
	self->priv->back_action = _tmp2_;
	_tmp3_ = g_action_map_lookup_action ((GActionMap*) action_group, "undo");
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->undo_action);
	self->priv->undo_action = _tmp4_;
	_tmp5_ = g_action_map_lookup_action ((GActionMap*) action_group, "hint");
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, g_simple_action_get_type (), GSimpleAction));
	_g_object_unref0 (self->priv->hint_action);
	self->priv->hint_action = _tmp6_;
	_tmp7_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp7_, FALSE);
	_tmp8_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp8_, FALSE);
	_tmp9_ = self->priv->hint_action;
	g_simple_action_set_enabled (_tmp9_, FALSE);
	_g_object_unref0 (action_group);
}

static void
game_window_real_on_fullscreen (AdaptativeWindow* base)
{
	GameWindow * self;
	GtkButton* _tmp0_;
	self = (GameWindow*) base;
	_tmp0_ = self->priv->unfullscreen_button;
	gtk_widget_show ((GtkWidget*) _tmp0_);
}

static void
game_window_real_on_unfullscreen (AdaptativeWindow* base)
{
	GameWindow * self;
	GtkButton* _tmp0_;
	self = (GameWindow*) base;
	_tmp0_ = self->priv->unfullscreen_button;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
}

void
game_window_cannot_undo_more (GameWindow* self)
{
	GSimpleAction* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp0_, FALSE);
	_tmp1_ = self->priv->view;
	gtk_widget_grab_focus (_tmp1_);
}

void
game_window_set_subtitle (GameWindow* self,
                          const gchar* subtitle)
{
	gboolean _tmp0_;
	gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_extra_thin;
	if (!_tmp0_) {
		GtkHeaderBar* _tmp1_;
		_tmp1_ = self->priv->headerbar;
		gtk_header_bar_set_title (_tmp1_, subtitle);
	}
	_tmp2_ = g_strdup (subtitle);
	_g_free0 (self->priv->last_subtitle);
	self->priv->last_subtitle = _tmp2_;
	if (subtitle == NULL) {
		GameActionBar* _tmp3_;
		_tmp3_ = self->priv->actionbar;
		game_action_bar_set_visibility (_tmp3_, FALSE);
	} else {
		GameActionBar* _tmp4_;
		GameActionBar* _tmp5_;
		_tmp4_ = self->priv->actionbar;
		game_action_bar_update_title (_tmp4_, (const gchar*) subtitle);
		_tmp5_ = self->priv->actionbar;
		game_action_bar_set_visibility (_tmp5_, TRUE);
	}
}

void
game_window_finish_game (GameWindow* self)
{
	GtkButton* _tmp0_;
	g_return_if_fail (self != NULL);
	self->priv->game_finished = TRUE;
	_tmp0_ = self->priv->new_game_button;
	gtk_widget_grab_focus ((GtkWidget*) _tmp0_);
}

void
game_window_allow_hint (GameWindow* self,
                        gboolean allow)
{
	gchar* stack_child = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GSimpleAction* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	stack_child = _tmp2_;
	_tmp4_ = stack_child;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = stack_child;
		_tmp3_ = g_strcmp0 ((const gchar*) _tmp5_, "game-box") != 0;
	}
	if (_tmp3_) {
		_g_free0 (stack_child);
		return;
	}
	_tmp6_ = self->priv->hint_action;
	g_simple_action_set_enabled (_tmp6_, allow);
	_g_free0 (stack_child);
}

void
game_window_allow_undo (GameWindow* self,
                        gboolean allow)
{
	gchar* stack_child = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GSimpleAction* _tmp6_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	stack_child = _tmp2_;
	_tmp4_ = stack_child;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = stack_child;
		_tmp3_ = g_strcmp0 ((const gchar*) _tmp5_, "game-box") != 0;
	}
	if (_tmp3_) {
		_g_free0 (stack_child);
		return;
	}
	_tmp6_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp6_, allow);
	_g_free0 (stack_child);
}

static void
game_window_real_set_window_size (AdaptativeWidget* base,
                                  AdaptativeWidgetWindowSize new_size)
{
	GameWindow * self;
	gboolean _is_extra_thin = FALSE;
	gboolean _tmp0_;
	gboolean _tmp1_;
	self = (GameWindow*) base;
	self->priv->is_quite_thin = adaptative_widget_window_size_is_quite_thin (new_size);
	_is_extra_thin = adaptative_widget_window_size_is_extra_thin (new_size);
	_tmp0_ = self->priv->_is_extra_thin;
	if (_is_extra_thin == _tmp0_) {
		return;
	}
	game_window_set_is_extra_thin (self, _is_extra_thin);
	_tmp1_ = self->priv->_is_extra_thin;
	if (_tmp1_) {
		GtkHeaderBar* _tmp2_;
		GtkWidget* _tmp3_;
		_tmp2_ = self->priv->headerbar;
		gtk_header_bar_set_title (_tmp2_, NULL);
		_tmp3_ = self->priv->game_widget_1;
		if (_tmp3_ != NULL) {
			GtkWidget* _tmp4_;
			_tmp4_ = self->priv->game_widget_1;
			gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, gtk_widget_get_type (), GtkWidget));
		}
	} else {
		gboolean _tmp5_ = FALSE;
		GtkWidget* _tmp6_;
		gchar* panel_name = NULL;
		GtkStack* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		_tmp6_ = self->priv->game_widget_1;
		if (_tmp6_ != NULL) {
			GtkStack* _tmp7_;
			const gchar* _tmp8_;
			_tmp7_ = self->priv->stack;
			_tmp8_ = gtk_stack_get_visible_child_name (_tmp7_);
			_tmp5_ = g_strcmp0 ((const gchar*) _tmp8_, "game-box") == 0;
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GtkWidget* _tmp9_;
			_tmp9_ = self->priv->game_widget_1;
			gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
		}
		_tmp10_ = self->priv->stack;
		_tmp11_ = gtk_stack_get_visible_child_name (_tmp10_);
		_tmp12_ = g_strdup (_tmp11_);
		panel_name = _tmp12_;
		_tmp14_ = panel_name;
		if (_tmp14_ != NULL) {
			const gchar* _tmp15_;
			_tmp15_ = panel_name;
			_tmp13_ = g_strcmp0 ((const gchar*) _tmp15_, "start-box") == 0;
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			GtkHeaderBar* _tmp16_;
			const gchar* _tmp17_;
			_tmp16_ = self->priv->headerbar;
			_tmp17_ = self->priv->program_name;
			gtk_header_bar_set_title (_tmp16_, _tmp17_);
		} else {
			GtkHeaderBar* _tmp18_;
			const gchar* _tmp19_;
			_tmp18_ = self->priv->headerbar;
			_tmp19_ = self->priv->last_subtitle;
			gtk_header_bar_set_title (_tmp18_, _tmp19_);
		}
		_g_free0 (panel_name);
	}
}

static void
game_window_show_new_game_screen (GameWindow* self)
{
	gboolean _tmp0_;
	GameActionBar* _tmp3_;
	GtkStack* _tmp4_;
	GtkWidget* _tmp5_;
	GtkButton* _tmp7_;
	gboolean _tmp8_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_extra_thin;
	if (!_tmp0_) {
		GtkHeaderBar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->headerbar;
		_tmp2_ = self->priv->program_name;
		gtk_header_bar_set_title (_tmp1_, _tmp2_);
	}
	_tmp3_ = self->priv->actionbar;
	game_action_bar_set_visibility (_tmp3_, FALSE);
	_tmp4_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp4_, "start-box");
	_tmp5_ = self->priv->game_widget_1;
	if (_tmp5_ != NULL) {
		GtkWidget* _tmp6_;
		_tmp6_ = self->priv->game_widget_1;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp7_ = self->priv->new_game_button;
	gtk_widget_hide ((GtkWidget*) _tmp7_);
	if (!self->priv->game_finished) {
		GtkButton* _tmp9_;
		gboolean _tmp10_;
		gboolean _tmp11_;
		_tmp9_ = self->priv->back_button;
		_tmp10_ = gtk_widget_get_visible ((GtkWidget*) _tmp9_);
		_tmp11_ = _tmp10_;
		_tmp8_ = _tmp11_;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		GtkButton* _tmp12_;
		_tmp12_ = self->priv->back_button;
		gtk_widget_grab_focus ((GtkWidget*) _tmp12_);
	} else {
		GtkButton* _tmp13_;
		_tmp13_ = self->priv->start_game_button;
		if (_tmp13_ != NULL) {
			GtkButton* _tmp14_;
			_tmp14_ = self->priv->start_game_button;
			gtk_widget_grab_focus ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, gtk_button_get_type (), GtkButton));
		}
	}
}

static void
game_window_show_view (GameWindow* self)
{
	gboolean _tmp0_;
	GameActionBar* _tmp3_;
	GtkStack* _tmp4_;
	GtkButton* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GtkWidget* _tmp7_;
	GtkButton* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_is_extra_thin;
	if (!_tmp0_) {
		GtkHeaderBar* _tmp1_;
		const gchar* _tmp2_;
		_tmp1_ = self->priv->headerbar;
		_tmp2_ = self->priv->last_subtitle;
		gtk_header_bar_set_title (_tmp1_, _tmp2_);
	}
	_tmp3_ = self->priv->actionbar;
	game_action_bar_set_visibility (_tmp3_, TRUE);
	_tmp4_ = self->priv->stack;
	gtk_stack_set_visible_child_name (_tmp4_, "game-box");
	_tmp5_ = self->priv->back_button;
	gtk_widget_hide ((GtkWidget*) _tmp5_);
	_tmp7_ = self->priv->game_widget_1;
	if (_tmp7_ != NULL) {
		gboolean _tmp8_;
		_tmp8_ = self->priv->_is_extra_thin;
		_tmp6_ = !_tmp8_;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		GtkWidget* _tmp9_;
		_tmp9_ = self->priv->game_widget_1;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp10_ = self->priv->new_game_button;
	gtk_widget_show ((GtkWidget*) _tmp10_);
	if (self->priv->game_finished) {
		GtkButton* _tmp11_;
		_tmp11_ = self->priv->new_game_button;
		gtk_widget_grab_focus ((GtkWidget*) _tmp11_);
	} else {
		GtkWidget* _tmp12_;
		_tmp12_ = self->priv->view;
		gtk_widget_grab_focus (_tmp12_);
	}
}

static void
game_window_new_game_cb (GameWindow* self)
{
	gchar* stack_child = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GtkStack* _tmp6_;
	GtkStack* _tmp7_;
	GtkButton* _tmp8_;
	GSimpleAction* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	stack_child = _tmp2_;
	_tmp4_ = stack_child;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = stack_child;
		_tmp3_ = g_strcmp0 ((const gchar*) _tmp5_, "game-box") != 0;
	}
	if (_tmp3_) {
		_g_free0 (stack_child);
		return;
	}
	g_signal_emit (self, game_window_signals[GAME_WINDOW_WAIT_SIGNAL], 0);
	_tmp6_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp6_, GTK_STACK_TRANSITION_TYPE_SLIDE_LEFT);
	_tmp7_ = self->priv->stack;
	gtk_stack_set_transition_duration (_tmp7_, (guint) 800);
	_tmp8_ = self->priv->back_button;
	gtk_widget_show ((GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->back_action;
	g_simple_action_set_enabled (_tmp9_, TRUE);
	game_window_show_new_game_screen (self);
	_g_free0 (stack_child);
}

static void
game_window_start_game_cb (GameWindow* self)
{
	gchar* stack_child = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GSimpleAction* _tmp6_;
	GSimpleAction* _tmp7_;
	GtkStack* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	stack_child = _tmp2_;
	_tmp4_ = stack_child;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = stack_child;
		_tmp3_ = g_strcmp0 ((const gchar*) _tmp5_, "start-box") != 0;
	}
	if (_tmp3_) {
		_g_free0 (stack_child);
		return;
	}
	_g_free0 (self->priv->last_subtitle);
	self->priv->last_subtitle = NULL;
	self->priv->game_finished = FALSE;
	_tmp6_ = self->priv->undo_action;
	g_simple_action_set_enabled (_tmp6_, FALSE);
	_tmp7_ = self->priv->hint_action;
	g_simple_action_set_enabled (_tmp7_, TRUE);
	g_signal_emit (self, game_window_signals[GAME_WINDOW_PLAY_SIGNAL], 0);
	if (self->priv->is_quite_thin) {
		GtkStack* _tmp8_;
		_tmp8_ = self->priv->stack;
		gtk_stack_set_transition_type (_tmp8_, GTK_STACK_TRANSITION_TYPE_SLIDE_DOWN);
	} else {
		GtkStack* _tmp9_;
		_tmp9_ = self->priv->stack;
		gtk_stack_set_transition_type (_tmp9_, GTK_STACK_TRANSITION_TYPE_OVER_DOWN_UP);
	}
	_tmp10_ = self->priv->stack;
	gtk_stack_set_transition_duration (_tmp10_, (guint) 1000);
	game_window_show_view (self);
	_g_free0 (stack_child);
}

static void
game_window_back_cb (GameWindow* self)
{
	gchar* stack_child = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	GtkStack* _tmp6_;
	GtkStack* _tmp7_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	stack_child = _tmp2_;
	_tmp4_ = stack_child;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = stack_child;
		_tmp3_ = g_strcmp0 ((const gchar*) _tmp5_, "start-box") != 0;
	}
	if (_tmp3_) {
		_g_free0 (stack_child);
		return;
	}
	_tmp6_ = self->priv->stack;
	gtk_stack_set_transition_type (_tmp6_, GTK_STACK_TRANSITION_TYPE_SLIDE_RIGHT);
	_tmp7_ = self->priv->stack;
	gtk_stack_set_transition_duration (_tmp7_, (guint) 800);
	game_window_show_view (self);
	g_signal_emit (self, game_window_signals[GAME_WINDOW_BACK_SIGNAL], 0);
	_g_free0 (stack_child);
}

gboolean
game_window_new_game_screen_visible (GameWindow* self)
{
	gchar* stack_child = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	stack_child = _tmp2_;
	if (stack_child == NULL) {
		g_assert_not_reached ();
	}
	if (g_strcmp0 ((const gchar*) stack_child, "game-box") == 0) {
		result = FALSE;
		_g_free0 (stack_child);
		return result;
	} else {
		result = TRUE;
		_g_free0 (stack_child);
		return result;
	}
}

static void
game_window_undo_cb (GameWindow* self)
{
	gchar* stack_child = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkButton* _tmp6_;
	gboolean _tmp7_;
	gboolean _tmp8_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	stack_child = _tmp2_;
	_tmp3_ = stack_child;
	if (_tmp3_ == NULL) {
		_g_free0 (stack_child);
		return;
	}
	_tmp4_ = stack_child;
	if (g_strcmp0 ((const gchar*) _tmp4_, "game-box") != 0) {
		GSimpleAction* _tmp5_;
		_tmp5_ = self->priv->back_action;
		if (g_action_get_enabled ((GAction*) _tmp5_)) {
			game_window_back_cb (self);
		}
		_g_free0 (stack_child);
		return;
	}
	self->priv->game_finished = FALSE;
	_tmp6_ = self->priv->back_button;
	g_object_get ((GtkWidget*) _tmp6_, "is-focus", &_tmp7_, NULL);
	_tmp8_ = _tmp7_;
	if (!_tmp8_) {
		GtkWidget* _tmp9_;
		_tmp9_ = self->priv->view;
		gtk_widget_grab_focus (_tmp9_);
	}
	g_signal_emit (self, game_window_signals[GAME_WINDOW_UNDO_SIGNAL], 0);
	_g_free0 (stack_child);
}

static void
game_window_hint_cb (GameWindow* self)
{
	gchar* stack_child = NULL;
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	stack_child = _tmp2_;
	_tmp4_ = stack_child;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = stack_child;
		_tmp3_ = g_strcmp0 ((const gchar*) _tmp5_, "game-box") != 0;
	}
	if (_tmp3_) {
		_g_free0 (stack_child);
		return;
	}
	g_signal_emit (self, game_window_signals[GAME_WINDOW_HINT_SIGNAL], 0);
	_g_free0 (stack_child);
}

static inline void
game_window_toggle_hamburger (GameWindow* self)
{
	GtkMenuButton* _tmp0_;
	GtkMenuButton* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->info_button;
	_tmp1_ = self->priv->info_button;
	_tmp2_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_);
	_tmp3_ = _tmp2_;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, !_tmp3_);
}

inline void
game_window_close_hamburger (GameWindow* self)
{
	GtkMenuButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->info_button;
	gtk_toggle_button_set_active ((GtkToggleButton*) _tmp0_, FALSE);
}

gboolean
game_window_get_is_extra_thin (GameWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_is_extra_thin;
	return result;
}

static void
game_window_set_is_extra_thin (GameWindow* self,
                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = game_window_get_is_extra_thin (self);
	if (old_value != value) {
		self->priv->_is_extra_thin = value;
		g_object_notify_by_pspec ((GObject *) self, game_window_properties[GAME_WINDOW_IS_EXTRA_THIN_PROPERTY]);
	}
}

static void
game_window_class_init (GameWindowClass * klass,
                        gpointer klass_data)
{
	game_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GameWindow_private_offset);
	((AdaptativeWindowClass *) klass)->on_fullscreen = (void (*) (AdaptativeWindow*)) game_window_real_on_fullscreen;
	((AdaptativeWindowClass *) klass)->on_unfullscreen = (void (*) (AdaptativeWindow*)) game_window_real_on_unfullscreen;
	G_OBJECT_CLASS (klass)->get_property = _vala_game_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_game_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = game_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAME_WINDOW_IS_EXTRA_THIN_PROPERTY, game_window_properties[GAME_WINDOW_IS_EXTRA_THIN_PROPERTY] = g_param_spec_boolean ("is-extra-thin", "is-extra-thin", "is-extra-thin", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/org/gnome/Four-in-a-row/ui/game-window.ui");
	game_window_signals[GAME_WINDOW_PLAY_SIGNAL] = g_signal_new ("play", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_WAIT_SIGNAL] = g_signal_new ("wait", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_BACK_SIGNAL] = g_signal_new ("back", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_UNDO_SIGNAL] = g_signal_new ("undo", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	game_window_signals[GAME_WINDOW_HINT_SIGNAL] = g_signal_new ("hint", TYPE_GAME_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "overlay", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, overlay));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stack", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, stack));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_game_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, new_game_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "back_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, back_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "unfullscreen_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, unfullscreen_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "game_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, game_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "new_game_box", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, new_game_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "info_button", FALSE, GameWindow_private_offset + G_STRUCT_OFFSET (GameWindowPrivate, info_button));
}

static void
game_window_adaptative_widget_interface_init (AdaptativeWidgetIface * iface,
                                              gpointer iface_data)
{
	game_window_adaptative_widget_parent_iface = g_type_interface_peek_parent (iface);
	iface->set_window_size = (void (*) (AdaptativeWidget*, AdaptativeWidgetWindowSize)) game_window_real_set_window_size;
}

static void
game_window_instance_init (GameWindow * self,
                           gpointer klass)
{
	gchar* _tmp0_;
	self->priv = game_window_get_instance_private (self);
	self->priv->game_finished = FALSE;
	_tmp0_ = g_strdup ("");
	self->priv->program_name = _tmp0_;
	self->priv->start_game_button = NULL;
	self->priv->_is_extra_thin = FALSE;
	self->priv->is_quite_thin = FALSE;
	self->priv->last_subtitle = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
game_window_finalize (GObject * obj)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GAME_WINDOW, GameWindow);
	_g_free0 (self->priv->program_name);
	_g_object_unref0 (self->priv->start_game_button);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->game_widget_1);
	_g_object_unref0 (self->priv->actionbar);
	_g_object_unref0 (self->priv->back_action);
	_g_object_unref0 (self->priv->undo_action);
	_g_object_unref0 (self->priv->hint_action);
	_g_free0 (self->priv->last_subtitle);
	G_OBJECT_CLASS (game_window_parent_class)->finalize (obj);
}

static GType
game_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GameWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) game_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GameWindow), 0, (GInstanceInitFunc) game_window_instance_init, NULL };
	static const GInterfaceInfo adaptative_widget_info = { (GInterfaceInitFunc) game_window_adaptative_widget_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType game_window_type_id;
	game_window_type_id = g_type_register_static (TYPE_ADAPTATIVE_WINDOW, "GameWindow", &g_define_type_info, 0);
	g_type_add_interface_static (game_window_type_id, TYPE_ADAPTATIVE_WIDGET, &adaptative_widget_info);
	GameWindow_private_offset = g_type_add_instance_private (game_window_type_id, sizeof (GameWindowPrivate));
	return game_window_type_id;
}

GType
game_window_get_type (void)
{
	static volatile gsize game_window_type_id__once = 0;
	if (g_once_init_enter (&game_window_type_id__once)) {
		GType game_window_type_id;
		game_window_type_id = game_window_get_type_once ();
		g_once_init_leave (&game_window_type_id__once, game_window_type_id);
	}
	return game_window_type_id__once;
}

static void
_vala_game_window_get_property (GObject * object,
                                guint property_id,
                                GValue * value,
                                GParamSpec * pspec)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_WINDOW, GameWindow);
	switch (property_id) {
		case GAME_WINDOW_IS_EXTRA_THIN_PROPERTY:
		g_value_set_boolean (value, game_window_get_is_extra_thin (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_game_window_set_property (GObject * object,
                                guint property_id,
                                const GValue * value,
                                GParamSpec * pspec)
{
	GameWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GAME_WINDOW, GameWindow);
	switch (property_id) {
		case GAME_WINDOW_IS_EXTRA_THIN_PROPERTY:
		game_window_set_is_extra_thin (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

