/* PopupWindow.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from PopupWindow.vala, do not modify */

/*
 * Copyright 2017 Adam Bieńkowski
 * Copyright 2023 elementary, Inc. <https://elementary.io>
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include "gala-pip.h"
#include <glib.h>
#include <meta/display.h>
#include <meta/meta-window-actor.h>
#include <clutter/clutter.h>
#include "gala.h"
#include <float.h>
#include <math.h>
#include <meta/window.h>
#include <glib-object.h>
#include <graphene-gobject.h>
#include <meta/common.h>
#include <meta/meta-workspace-manager.h>
#include <meta/workspace.h>
#include <mtk/mtk.h>

#define GALA_PLUGINS_PIP_POPUP_WINDOW_FADE_OUT_TIMEOUT ((guint) 200)
#define GALA_PLUGINS_PIP_POPUP_WINDOW_MINIMUM_SCALE 0.1f
#define GALA_PLUGINS_PIP_POPUP_WINDOW_MAXIMUM_SCALE 1.0f
#define GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN 0
#define GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_PERCENT 0.5f
#define GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS 80
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GALA_PLUGINS_PIP_POPUP_WINDOW_0_PROPERTY,
	GALA_PLUGINS_PIP_POPUP_WINDOW_DISPLAY_PROPERTY,
	GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY,
	GALA_PLUGINS_PIP_POPUP_WINDOW_NUM_PROPERTIES
};
static GParamSpec* gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
enum  {
	GALA_PLUGINS_PIP_POPUP_WINDOW_CLOSED_SIGNAL,
	GALA_PLUGINS_PIP_POPUP_WINDOW_NUM_SIGNALS
};
static guint gala_plugins_pip_popup_window_signals[GALA_PLUGINS_PIP_POPUP_WINDOW_NUM_SIGNALS] = {0};

struct _GalaPluginsPIPPopupWindowPrivate {
	gint button_size;
	gint container_margin;
	MetaDisplay* _display;
	MetaWindowActor* _window_actor;
	ClutterClone* clone;
	ClutterActor* clone_container;
	ClutterActor* container;
	GalaCloseButton* close_button;
	ClutterActor* resize_button;
	GalaDragDropAction* move_action;
	gfloat begin_resize_width;
	gfloat begin_resize_height;
	gfloat resize_start_x;
	gfloat resize_start_y;
	gboolean resizing;
	gboolean off_screen;
	ClutterGrab* grab;
};

struct _Block4Data {
	int _ref_count_;
	GalaPluginsPIPPopupWindow* self;
	gulong completed_id;
};

static gint GalaPluginsPIPPopupWindow_private_offset;
static gpointer gala_plugins_pip_popup_window_parent_class = NULL;
static MetaWindow* gala_plugins_pip_popup_window_previous_focus;
static MetaWindow* gala_plugins_pip_popup_window_previous_focus = NULL;

static void gala_plugins_pip_popup_window_calculate_aspect_ratio_size_fit (gfloat src_width,
                                                                    gfloat src_height,
                                                                    gfloat max_width,
                                                                    gfloat max_height,
                                                                    gfloat* width,
                                                                    gfloat* height);
static gboolean gala_plugins_pip_popup_window_get_window_is_normal (MetaWindow* window);
static void gala_plugins_pip_popup_window_real_show (ClutterActor* base);
static void gala_plugins_pip_popup_window_real_hide (ClutterActor* base);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void ___lambda4_ (Block4Data* _data4_);
static void ____lambda4__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                       gpointer self);
static gboolean gala_plugins_pip_popup_window_real_enter_event (ClutterActor* base,
                                                         ClutterEvent* event);
static gboolean gala_plugins_pip_popup_window_real_leave_event (ClutterActor* base,
                                                         ClutterEvent* event);
static void gala_plugins_pip_popup_window_update_clone_container_scale (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_on_allocation_changed (GalaPluginsPIPPopupWindow* self);
static ClutterActor* gala_plugins_pip_popup_window_on_move_begin (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_on_move_end (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_update_screen_position (GalaPluginsPIPPopupWindow* self);
static gboolean gala_plugins_pip_popup_window_on_resize_button_press (GalaPluginsPIPPopupWindow* self,
                                                               ClutterEvent* event);
static gboolean gala_plugins_pip_popup_window_on_resize_event (GalaPluginsPIPPopupWindow* self,
                                                        ClutterEvent* event);
static gboolean _gala_plugins_pip_popup_window_on_resize_event_clutter_actor_event (ClutterActor* _sender,
                                                                             ClutterEvent* event,
                                                                             gpointer self);
static void gala_plugins_pip_popup_window_stop_resizing (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_update_size (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_update_clone_clip (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_on_close_click_clicked (GalaPluginsPIPPopupWindow* self);
static gboolean __lambda5_ (GalaPluginsPIPPopupWindow* self);
static gboolean ___lambda5__gsource_func (gpointer self);
static void gala_plugins_pip_popup_window_update_window_focus (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_get_target_window_size (GalaPluginsPIPPopupWindow* self,
                                                           gfloat* width,
                                                           gfloat* height);
static void gala_plugins_pip_popup_window_update_clone_container_position (GalaPluginsPIPPopupWindow* self);
static gboolean gala_plugins_pip_popup_window_place_window_off_screen (GalaPluginsPIPPopupWindow* self);
static void gala_plugins_pip_popup_window_place_window_in_screen (GalaPluginsPIPPopupWindow* self);
static gboolean gala_plugins_pip_popup_window_coord_is_in_other_monitor (GalaPluginsPIPPopupWindow* self,
                                                                  gfloat coord,
                                                                  ClutterOrientation axis);
static void gala_plugins_pip_popup_window_activate (GalaPluginsPIPPopupWindow* self);
static GObject * gala_plugins_pip_popup_window_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties);
static ClutterActor* _gala_plugins_pip_popup_window_on_move_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                                             gfloat x,
                                                                                             gfloat y,
                                                                                             gpointer self);
static void _gala_plugins_pip_popup_window_on_move_end_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                                     gpointer self);
static void _gala_plugins_pip_popup_window_activate_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                                  guint32 button,
                                                                                  ClutterInputDeviceType device_type,
                                                                                  gpointer self);
static void _gala_plugins_pip_popup_window_on_close_click_clicked_gala_close_button_triggered (GalaCloseButton* _sender,
                                                                                        guint32 timestamp,
                                                                                        gpointer self);
static gboolean _gala_plugins_pip_popup_window_on_resize_button_press_clutter_actor_button_press_event (ClutterActor* _sender,
                                                                                                 ClutterEvent* event,
                                                                                                 gpointer self);
static void _gala_plugins_pip_popup_window_on_allocation_changed_g_object_notify (GObject* _sender,
                                                                           GParamSpec* pspec,
                                                                           gpointer self);
static void _gala_plugins_pip_popup_window_on_close_click_clicked_meta_window_unmanaged (MetaWindow* _sender,
                                                                                  gpointer self);
static void _gala_plugins_pip_popup_window_update_window_focus_g_object_notify (GObject* _sender,
                                                                         GParamSpec* pspec,
                                                                         gpointer self);
static void _gala_plugins_pip_popup_window_update_window_focus_meta_workspace_manager_active_workspace_changed (MetaWorkspaceManager* _sender,
                                                                                                         gpointer self);
static void gala_plugins_pip_popup_window_finalize (GObject * obj);
static GType gala_plugins_pip_popup_window_get_type_once (void);
static void _vala_gala_plugins_pip_popup_window_get_property (GObject * object,
                                                       guint property_id,
                                                       GValue * value,
                                                       GParamSpec * pspec);
static void _vala_gala_plugins_pip_popup_window_set_property (GObject * object,
                                                       guint property_id,
                                                       const GValue * value,
                                                       GParamSpec * pspec);

static inline gpointer
gala_plugins_pip_popup_window_get_instance_private (GalaPluginsPIPPopupWindow* self)
{
	return G_STRUCT_MEMBER_P (self, GalaPluginsPIPPopupWindow_private_offset);
}

static void
gala_plugins_pip_popup_window_calculate_aspect_ratio_size_fit (gfloat src_width,
                                                               gfloat src_height,
                                                               gfloat max_width,
                                                               gfloat max_height,
                                                               gfloat* width,
                                                               gfloat* height)
{
	gfloat _vala_width = 0.0F;
	gfloat _vala_height = 0.0F;
	gfloat ratio = 0.0F;
	ratio = MIN (max_width / src_width, max_height / src_height);
	_vala_width = src_width * ratio;
	_vala_height = src_height * ratio;
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static gboolean
gala_plugins_pip_popup_window_get_window_is_normal (MetaWindow* window)
{
	MetaWindowType window_type = 0;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean result;
	g_return_val_if_fail (window != NULL, FALSE);
	window_type = meta_window_get_window_type (window);
	if (window_type == META_WINDOW_NORMAL) {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = window_type == META_WINDOW_DIALOG;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = window_type == META_WINDOW_MODAL_DIALOG;
	}
	result = _tmp0_;
	return result;
}

GalaPluginsPIPPopupWindow*
gala_plugins_pip_popup_window_construct (GType object_type,
                                         MetaDisplay* display,
                                         MetaWindowActor* window_actor)
{
	GalaPluginsPIPPopupWindow * self = NULL;
	g_return_val_if_fail (display != NULL, NULL);
	g_return_val_if_fail (window_actor != NULL, NULL);
	self = (GalaPluginsPIPPopupWindow*) g_object_new (object_type, "display", display, "window-actor", window_actor, NULL);
	return self;
}

GalaPluginsPIPPopupWindow*
gala_plugins_pip_popup_window_new (MetaDisplay* display,
                                   MetaWindowActor* window_actor)
{
	return gala_plugins_pip_popup_window_construct (GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, display, window_actor);
}

static void
gala_plugins_pip_popup_window_real_show (ClutterActor* base)
{
	GalaPluginsPIPPopupWindow * self;
	self = (GalaPluginsPIPPopupWindow*) base;
	CLUTTER_ACTOR_CLASS (gala_plugins_pip_popup_window_parent_class)->show (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, gala_utils_get_animation_duration ((guint) 200));
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		GalaPluginsPIPPopupWindow* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static void
___lambda4_ (Block4Data* _data4_)
{
	GalaPluginsPIPPopupWindow* self;
	self = _data4_->self;
	g_signal_handler_disconnect ((GObject*) self, _data4_->completed_id);
	CLUTTER_ACTOR_CLASS (gala_plugins_pip_popup_window_parent_class)->hide (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor));
}

static void
____lambda4__clutter_actor_transitions_completed (ClutterActor* _sender,
                                                  gpointer self)
{
	___lambda4_ (self);
}

static void
gala_plugins_pip_popup_window_real_hide (ClutterActor* base)
{
	GalaPluginsPIPPopupWindow * self;
	guint duration = 0U;
	self = (GalaPluginsPIPPopupWindow*) base;
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 255);
	duration = gala_utils_get_animation_duration ((guint) 200);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, duration);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	if (duration == ((guint) 0)) {
		CLUTTER_ACTOR_CLASS (gala_plugins_pip_popup_window_parent_class)->hide (G_TYPE_CHECK_INSTANCE_CAST (self, clutter_actor_get_type (), ClutterActor));
	} else {
		Block4Data* _data4_;
		gulong _tmp0_;
		_data4_ = g_slice_new0 (Block4Data);
		_data4_->_ref_count_ = 1;
		_data4_->self = g_object_ref (self);
		_data4_->completed_id = (gulong) 0;
		_tmp0_ = g_signal_connect_data ((ClutterActor*) self, "transitions-completed", (GCallback) ____lambda4__clutter_actor_transitions_completed, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
		_data4_->completed_id = _tmp0_;
		block4_data_unref (_data4_);
		_data4_ = NULL;
	}
}

static gboolean
gala_plugins_pip_popup_window_real_enter_event (ClutterActor* base,
                                                ClutterEvent* event)
{
	GalaPluginsPIPPopupWindow * self;
	guint duration = 0U;
	GalaCloseButton* _tmp0_;
	GalaCloseButton* _tmp1_;
	GalaCloseButton* _tmp2_;
	GalaCloseButton* _tmp3_;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	gboolean result;
	self = (GalaPluginsPIPPopupWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	duration = gala_utils_get_animation_duration ((guint) 300);
	_tmp0_ = self->priv->close_button;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->close_button;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp1_, duration);
	_tmp2_ = self->priv->close_button;
	clutter_actor_set_opacity ((ClutterActor*) _tmp2_, (guint) 255);
	_tmp3_ = self->priv->close_button;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp3_);
	_tmp4_ = self->priv->resize_button;
	clutter_actor_save_easing_state (_tmp4_);
	_tmp5_ = self->priv->resize_button;
	clutter_actor_set_easing_duration (_tmp5_, duration);
	_tmp6_ = self->priv->resize_button;
	clutter_actor_set_opacity (_tmp6_, (guint) 255);
	_tmp7_ = self->priv->resize_button;
	clutter_actor_restore_easing_state (_tmp7_);
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static gboolean
gala_plugins_pip_popup_window_real_leave_event (ClutterActor* base,
                                                ClutterEvent* event)
{
	GalaPluginsPIPPopupWindow * self;
	guint duration = 0U;
	GalaCloseButton* _tmp0_;
	GalaCloseButton* _tmp1_;
	GalaCloseButton* _tmp2_;
	GalaCloseButton* _tmp3_;
	ClutterActor* _tmp4_;
	ClutterActor* _tmp5_;
	ClutterActor* _tmp6_;
	ClutterActor* _tmp7_;
	gboolean result;
	self = (GalaPluginsPIPPopupWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	duration = gala_utils_get_animation_duration ((guint) 300);
	_tmp0_ = self->priv->close_button;
	clutter_actor_save_easing_state ((ClutterActor*) _tmp0_);
	_tmp1_ = self->priv->close_button;
	clutter_actor_set_easing_duration ((ClutterActor*) _tmp1_, duration);
	_tmp2_ = self->priv->close_button;
	clutter_actor_set_opacity ((ClutterActor*) _tmp2_, (guint) 0);
	_tmp3_ = self->priv->close_button;
	clutter_actor_restore_easing_state ((ClutterActor*) _tmp3_);
	_tmp4_ = self->priv->resize_button;
	clutter_actor_save_easing_state (_tmp4_);
	_tmp5_ = self->priv->resize_button;
	clutter_actor_set_easing_duration (_tmp5_, duration);
	_tmp6_ = self->priv->resize_button;
	clutter_actor_set_opacity (_tmp6_, (guint) 0);
	_tmp7_ = self->priv->resize_button;
	clutter_actor_restore_easing_state (_tmp7_);
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

void
gala_plugins_pip_popup_window_set_container_clip (GalaPluginsPIPPopupWindow* self,
                                                  graphene_rect_t* container_clip)
{
	ClutterActor* _tmp0_;
	graphene_rect_t _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clone_container;
	_tmp1_ = *container_clip;
	g_object_set (_tmp0_, "clip-rect", &_tmp1_, NULL);
	gala_plugins_pip_popup_window_update_clone_container_scale (self);
	gala_plugins_pip_popup_window_on_allocation_changed (self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static ClutterActor*
gala_plugins_pip_popup_window_on_move_begin (GalaPluginsPIPPopupWindow* self)
{
	MetaDisplay* _tmp0_;
	ClutterActor* _tmp1_;
	ClutterActor* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	meta_display_set_cursor (_tmp0_, META_CURSOR_DND_IN_DRAG);
	_tmp1_ = _g_object_ref0 ((ClutterActor*) self);
	result = _tmp1_;
	return result;
}

static void
gala_plugins_pip_popup_window_on_move_end (GalaPluginsPIPPopupWindow* self)
{
	MetaDisplay* _tmp0_;
	g_return_if_fail (self != NULL);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	gala_plugins_pip_popup_window_update_screen_position (self);
	_tmp0_ = self->priv->_display;
	meta_display_set_cursor (_tmp0_, META_CURSOR_DEFAULT);
}

static gboolean
_gala_plugins_pip_popup_window_on_resize_event_clutter_actor_event (ClutterActor* _sender,
                                                                    ClutterEvent* event,
                                                                    gpointer self)
{
	gboolean result;
	result = gala_plugins_pip_popup_window_on_resize_event ((GalaPluginsPIPPopupWindow*) self, event);
	return result;
}

static gboolean
gala_plugins_pip_popup_window_on_resize_button_press (GalaPluginsPIPPopupWindow* self,
                                                      ClutterEvent* event)
{
	gboolean _tmp0_ = FALSE;
	gfloat _tmp1_ = 0.0F;
	gfloat _tmp2_ = 0.0F;
	gfloat _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	ClutterActor* _tmp7_;
	ClutterStage* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterGrab* _tmp10_;
	ClutterActor* _tmp11_;
	MetaDisplay* _tmp12_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (self->priv->resizing) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = clutter_event_get_button (event) != CLUTTER_BUTTON_PRIMARY;
	}
	if (_tmp0_) {
		result = CLUTTER_EVENT_STOP;
		return result;
	}
	self->priv->resizing = TRUE;
	clutter_event_get_coords (event, &_tmp1_, &_tmp2_);
	self->priv->resize_start_x = _tmp1_;
	self->priv->resize_start_y = _tmp2_;
	_tmp3_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp4_ = _tmp3_;
	self->priv->begin_resize_width = _tmp4_;
	_tmp5_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp6_ = _tmp5_;
	self->priv->begin_resize_height = _tmp6_;
	_tmp7_ = self->priv->resize_button;
	_tmp8_ = (ClutterStage*) clutter_actor_get_stage (_tmp7_);
	_tmp9_ = self->priv->resize_button;
	_tmp10_ = clutter_stage_grab (_tmp8_, _tmp9_);
	_g_object_unref0 (self->priv->grab);
	self->priv->grab = _tmp10_;
	_tmp11_ = self->priv->resize_button;
	g_signal_connect_object (_tmp11_, "event", (GCallback) _gala_plugins_pip_popup_window_on_resize_event_clutter_actor_event, self, 0);
	_tmp12_ = self->priv->_display;
	meta_display_set_cursor (_tmp12_, META_CURSOR_SE_RESIZE);
	result = CLUTTER_EVENT_PROPAGATE;
	return result;
}

static gboolean
gala_plugins_pip_popup_window_on_resize_event (GalaPluginsPIPPopupWindow* self,
                                               ClutterEvent* event)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (!self->priv->resizing) {
		result = CLUTTER_EVENT_STOP;
		return result;
	}
	switch (clutter_event_type (event)) {
		case CLUTTER_MOTION:
		{
			ClutterModifierType mods = 0U;
			gfloat event_x = 0.0F;
			gfloat event_y = 0.0F;
			gfloat _tmp0_ = 0.0F;
			gfloat _tmp1_ = 0.0F;
			gfloat diff_x = 0.0F;
			gfloat diff_y = 0.0F;
			mods = clutter_event_get_state (event);
			if (!((mods & CLUTTER_BUTTON1_MASK) == CLUTTER_BUTTON1_MASK)) {
				gala_plugins_pip_popup_window_stop_resizing (self);
				break;
			}
			clutter_event_get_coords (event, &_tmp0_, &_tmp1_);
			event_x = _tmp0_;
			event_y = _tmp1_;
			diff_x = event_x - self->priv->resize_start_x;
			diff_y = event_y - self->priv->resize_start_y;
			clutter_actor_set_width ((ClutterActor*) self, self->priv->begin_resize_width + diff_x);
			clutter_actor_set_height ((ClutterActor*) self, self->priv->begin_resize_height + diff_y);
			gala_plugins_pip_popup_window_update_clone_container_scale (self);
			gala_plugins_pip_popup_window_update_size (self);
			break;
		}
		case CLUTTER_BUTTON_RELEASE:
		{
			if (clutter_event_get_button (event) == CLUTTER_BUTTON_PRIMARY) {
				gala_plugins_pip_popup_window_stop_resizing (self);
			}
			break;
		}
		case CLUTTER_LEAVE:
		case CLUTTER_ENTER:
		{
			result = CLUTTER_EVENT_PROPAGATE;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = CLUTTER_EVENT_STOP;
	return result;
}

static void
gala_plugins_pip_popup_window_stop_resizing (GalaPluginsPIPPopupWindow* self)
{
	ClutterGrab* _tmp0_;
	MetaDisplay* _tmp4_;
	g_return_if_fail (self != NULL);
	if (!self->priv->resizing) {
		return;
	}
	_tmp0_ = self->priv->grab;
	if (_tmp0_ != NULL) {
		ClutterGrab* _tmp1_;
		ClutterActor* _tmp2_;
		guint _tmp3_;
		_tmp1_ = self->priv->grab;
		clutter_grab_dismiss (_tmp1_);
		_tmp2_ = self->priv->resize_button;
		g_signal_parse_name ("event", clutter_actor_get_type (), &_tmp3_, NULL, FALSE);
		g_signal_handlers_disconnect_matched (_tmp2_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp3_, 0, NULL, (GCallback) _gala_plugins_pip_popup_window_on_resize_event_clutter_actor_event, self);
		_g_object_unref0 (self->priv->grab);
		self->priv->grab = NULL;
	}
	self->priv->resizing = FALSE;
	gala_plugins_pip_popup_window_update_screen_position (self);
	_tmp4_ = self->priv->_display;
	meta_display_set_cursor (_tmp4_, META_CURSOR_DEFAULT);
}

static void
gala_plugins_pip_popup_window_on_allocation_changed (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	gala_plugins_pip_popup_window_update_clone_clip (self);
	gala_plugins_pip_popup_window_update_size (self);
}

static gboolean
__lambda5_ (GalaPluginsPIPPopupWindow* self)
{
	gboolean result;
	g_signal_emit (self, gala_plugins_pip_popup_window_signals[GALA_PLUGINS_PIP_POPUP_WINDOW_CLOSED_SIGNAL], 0);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda5_ ((GalaPluginsPIPPopupWindow*) self);
	return result;
}

static void
gala_plugins_pip_popup_window_on_close_click_clicked (GalaPluginsPIPPopupWindow* self)
{
	guint duration = 0U;
	g_return_if_fail (self != NULL);
	duration = gala_utils_get_animation_duration (GALA_PLUGINS_PIP_POPUP_WINDOW_FADE_OUT_TIMEOUT);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_duration ((ClutterActor*) self, duration);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	clutter_threads_add_timeout (duration, ___lambda5__gsource_func, self);
}

static void
gala_plugins_pip_popup_window_update_window_focus (GalaPluginsPIPPopupWindow* self)
{
	MetaWindow* focus_window = NULL;
	MetaDisplay* _tmp0_;
	MetaWindow* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	MetaWindow* _tmp4_;
	MetaWorkspaceManager* workspace_manager = NULL;
	MetaDisplay* _tmp10_;
	MetaWorkspaceManager* _tmp11_;
	MetaWorkspace* active_workspace = NULL;
	MetaWorkspaceManager* _tmp12_;
	MetaWorkspace* _tmp13_;
	MetaWindow* window = NULL;
	MetaWindowActor* _tmp14_;
	MetaWindow* _tmp15_;
	gboolean _tmp16_ = FALSE;
	MetaWindow* _tmp17_;
	gboolean _tmp18_;
	gboolean _tmp19_;
	MetaWindow* _tmp23_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_display_get_focus_window (_tmp0_);
	focus_window = _tmp1_;
	_tmp4_ = focus_window;
	if (_tmp4_ != NULL) {
		MetaWindow* _tmp5_;
		_tmp5_ = focus_window;
		_tmp3_ = !gala_plugins_pip_popup_window_get_window_is_normal (_tmp5_);
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp6_ = FALSE;
		MetaWindow* _tmp7_;
		_tmp7_ = gala_plugins_pip_popup_window_previous_focus;
		if (_tmp7_ != NULL) {
			MetaWindow* _tmp8_;
			_tmp8_ = gala_plugins_pip_popup_window_previous_focus;
			_tmp6_ = !gala_plugins_pip_popup_window_get_window_is_normal (_tmp8_);
		} else {
			_tmp6_ = FALSE;
		}
		_tmp2_ = _tmp6_;
	}
	if (_tmp2_) {
		MetaWindow* _tmp9_;
		_tmp9_ = focus_window;
		gala_plugins_pip_popup_window_previous_focus = _tmp9_;
		return;
	}
	_tmp10_ = self->priv->_display;
	_tmp11_ = meta_display_get_workspace_manager (_tmp10_);
	workspace_manager = _tmp11_;
	_tmp12_ = workspace_manager;
	_tmp13_ = meta_workspace_manager_get_active_workspace (_tmp12_);
	active_workspace = _tmp13_;
	_tmp14_ = self->priv->_window_actor;
	_tmp15_ = meta_window_actor_get_meta_window (_tmp14_);
	window = _tmp15_;
	_tmp17_ = window;
	g_object_get (_tmp17_, "appears-focused", &_tmp18_, NULL);
	_tmp19_ = _tmp18_;
	if (_tmp19_) {
		MetaWindow* _tmp20_;
		MetaWorkspace* _tmp21_;
		_tmp20_ = window;
		_tmp21_ = active_workspace;
		_tmp16_ = meta_window_located_on_workspace (_tmp20_, _tmp21_);
	} else {
		_tmp16_ = FALSE;
	}
	if (_tmp16_) {
		clutter_actor_hide ((ClutterActor*) self);
	} else {
		MetaWindowActor* _tmp22_;
		_tmp22_ = self->priv->_window_actor;
		if (!meta_window_actor_is_destroyed (_tmp22_)) {
			clutter_actor_show ((ClutterActor*) self);
		}
	}
	_tmp23_ = focus_window;
	gala_plugins_pip_popup_window_previous_focus = _tmp23_;
}

static void
gala_plugins_pip_popup_window_update_size (GalaPluginsPIPPopupWindow* self)
{
	gint clone_container_width = 0;
	gint clone_container_height = 0;
	ClutterActor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	ClutterActor* _tmp24_;
	ClutterActor* _tmp25_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clone_container;
	g_object_get (_tmp0_, "has-clip", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gfloat src_width = 0.0F;
		gfloat src_height = 0.0F;
		ClutterActor* _tmp3_;
		gfloat _tmp4_ = 0.0F;
		gfloat _tmp5_ = 0.0F;
		ClutterActor* _tmp6_;
		gdouble _tmp7_;
		gdouble _tmp8_;
		ClutterActor* _tmp9_;
		gdouble _tmp10_;
		gdouble _tmp11_;
		src_width = 0.0f;
		src_height = 0.0f;
		_tmp3_ = self->priv->clone_container;
		clutter_actor_get_clip (_tmp3_, NULL, NULL, &_tmp4_, &_tmp5_);
		src_width = _tmp4_;
		src_height = _tmp5_;
		_tmp6_ = self->priv->clone_container;
		g_object_get (_tmp6_, "scale-x", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		clone_container_width = (gint) (src_width * _tmp8_);
		_tmp9_ = self->priv->clone_container;
		g_object_get (_tmp9_, "scale-y", &_tmp10_, NULL);
		_tmp11_ = _tmp10_;
		clone_container_height = (gint) (src_height * _tmp11_);
	} else {
		ClutterActor* _tmp12_;
		gfloat _tmp13_;
		gfloat _tmp14_;
		ClutterActor* _tmp15_;
		gdouble _tmp16_;
		gdouble _tmp17_;
		ClutterActor* _tmp18_;
		gfloat _tmp19_;
		gfloat _tmp20_;
		ClutterActor* _tmp21_;
		gdouble _tmp22_;
		gdouble _tmp23_;
		_tmp12_ = self->priv->clone_container;
		_tmp13_ = clutter_actor_get_width (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = self->priv->clone_container;
		g_object_get (_tmp15_, "scale-x", &_tmp16_, NULL);
		_tmp17_ = _tmp16_;
		clone_container_width = (gint) (_tmp14_ * _tmp17_);
		_tmp18_ = self->priv->clone_container;
		_tmp19_ = clutter_actor_get_height (_tmp18_);
		_tmp20_ = _tmp19_;
		_tmp21_ = self->priv->clone_container;
		g_object_get (_tmp21_, "scale-y", &_tmp22_, NULL);
		_tmp23_ = _tmp22_;
		clone_container_height = (gint) (_tmp20_ * _tmp23_);
	}
	_tmp24_ = self->priv->container;
	clutter_actor_set_width (_tmp24_, (gfloat) clone_container_width);
	_tmp25_ = self->priv->container;
	clutter_actor_set_height (_tmp25_, (gfloat) clone_container_height);
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) (clone_container_width + self->priv->button_size));
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) (clone_container_height + self->priv->button_size));
}

static void
gala_plugins_pip_popup_window_update_clone_clip (GalaPluginsPIPPopupWindow* self)
{
	MtkRectangle rect = {0};
	MetaWindowActor* _tmp0_;
	MetaWindow* _tmp1_;
	MtkRectangle _tmp2_ = {0};
	gfloat x_offset = 0.0F;
	MtkRectangle _tmp3_;
	MetaWindowActor* _tmp4_;
	gfloat _tmp5_;
	gfloat _tmp6_;
	gfloat y_offset = 0.0F;
	MtkRectangle _tmp7_;
	MetaWindowActor* _tmp8_;
	gfloat _tmp9_;
	gfloat _tmp10_;
	ClutterClone* _tmp11_;
	MtkRectangle _tmp12_;
	MtkRectangle _tmp13_;
	ClutterClone* _tmp14_;
	ClutterActor* _tmp15_;
	MtkRectangle _tmp16_;
	MtkRectangle _tmp17_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_window_actor;
	_tmp1_ = meta_window_actor_get_meta_window (_tmp0_);
	meta_window_get_frame_rect (_tmp1_, &_tmp2_);
	rect = _tmp2_;
	_tmp3_ = rect;
	_tmp4_ = self->priv->_window_actor;
	_tmp5_ = clutter_actor_get_x ((ClutterActor*) _tmp4_);
	_tmp6_ = _tmp5_;
	x_offset = _tmp3_.x - _tmp6_;
	_tmp7_ = rect;
	_tmp8_ = self->priv->_window_actor;
	_tmp9_ = clutter_actor_get_y ((ClutterActor*) _tmp8_);
	_tmp10_ = _tmp9_;
	y_offset = _tmp7_.y - _tmp10_;
	_tmp11_ = self->priv->clone;
	_tmp12_ = rect;
	_tmp13_ = rect;
	clutter_actor_set_clip ((ClutterActor*) _tmp11_, x_offset, y_offset, (gfloat) _tmp12_.width, (gfloat) _tmp13_.height);
	_tmp14_ = self->priv->clone;
	clutter_actor_set_position ((ClutterActor*) _tmp14_, -x_offset, -y_offset);
	_tmp15_ = self->priv->clone_container;
	_tmp16_ = rect;
	_tmp17_ = rect;
	clutter_actor_set_size (_tmp15_, (gfloat) _tmp16_.width, (gfloat) _tmp17_.height);
}

static void
gala_plugins_pip_popup_window_update_clone_container_scale (GalaPluginsPIPPopupWindow* self)
{
	gfloat src_width = 0.0F;
	gfloat src_height = 0.0F;
	ClutterActor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gfloat max_width = 0.0F;
	gfloat _tmp12_;
	gfloat _tmp13_;
	gfloat max_height = 0.0F;
	gfloat _tmp14_;
	gfloat _tmp15_;
	gfloat new_width = 0.0F;
	gfloat new_height = 0.0F;
	gfloat _tmp16_ = 0.0F;
	gfloat _tmp17_ = 0.0F;
	gfloat window_width = 0.0F;
	gfloat window_height = 0.0F;
	gfloat _tmp18_ = 0.0F;
	gfloat _tmp19_ = 0.0F;
	gfloat new_scale_x = 0.0F;
	gfloat new_scale_y = 0.0F;
	ClutterActor* _tmp20_;
	ClutterActor* _tmp21_;
	g_return_if_fail (self != NULL);
	src_width = 1.0f;
	src_height = 1.0f;
	_tmp0_ = self->priv->clone_container;
	g_object_get (_tmp0_, "has-clip", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ClutterActor* _tmp3_;
		gfloat _tmp4_ = 0.0F;
		gfloat _tmp5_ = 0.0F;
		_tmp3_ = self->priv->clone_container;
		clutter_actor_get_clip (_tmp3_, NULL, NULL, &_tmp4_, &_tmp5_);
		src_width = _tmp4_;
		src_height = _tmp5_;
	} else {
		ClutterActor* _tmp6_;
		gfloat _tmp7_;
		gfloat _tmp8_;
		ClutterActor* _tmp9_;
		gfloat _tmp10_;
		gfloat _tmp11_;
		_tmp6_ = self->priv->clone_container;
		_tmp7_ = clutter_actor_get_width (_tmp6_);
		_tmp8_ = _tmp7_;
		src_width = _tmp8_;
		_tmp9_ = self->priv->clone_container;
		_tmp10_ = clutter_actor_get_height (_tmp9_);
		_tmp11_ = _tmp10_;
		src_height = _tmp11_;
	}
	_tmp12_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp13_ = _tmp12_;
	max_width = _tmp13_ - self->priv->button_size;
	_tmp14_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp15_ = _tmp14_;
	max_height = _tmp15_ - self->priv->button_size;
	gala_plugins_pip_popup_window_calculate_aspect_ratio_size_fit (src_width, src_height, max_width, max_height, &_tmp16_, &_tmp17_);
	new_width = _tmp16_;
	new_height = _tmp17_;
	window_width = 1.0f;
	window_height = 1.0f;
	gala_plugins_pip_popup_window_get_target_window_size (self, &_tmp18_, &_tmp19_);
	window_width = _tmp18_;
	window_height = _tmp19_;
	new_scale_x = new_width / window_width;
	new_scale_y = new_height / window_height;
	_tmp20_ = self->priv->clone_container;
	g_object_set (_tmp20_, "scale-x", (gdouble) CLAMP (new_scale_x, GALA_PLUGINS_PIP_POPUP_WINDOW_MINIMUM_SCALE, GALA_PLUGINS_PIP_POPUP_WINDOW_MAXIMUM_SCALE), NULL);
	_tmp21_ = self->priv->clone_container;
	g_object_set (_tmp21_, "scale-y", (gdouble) CLAMP (new_scale_y, GALA_PLUGINS_PIP_POPUP_WINDOW_MINIMUM_SCALE, GALA_PLUGINS_PIP_POPUP_WINDOW_MAXIMUM_SCALE), NULL);
	gala_plugins_pip_popup_window_update_clone_container_position (self);
}

static void
gala_plugins_pip_popup_window_update_clone_container_position (GalaPluginsPIPPopupWindow* self)
{
	ClutterActor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clone_container;
	g_object_get (_tmp0_, "has-clip", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gfloat clip_x = 0.0F;
		gfloat clip_y = 0.0F;
		ClutterActor* _tmp3_;
		gfloat _tmp4_ = 0.0F;
		gfloat _tmp5_ = 0.0F;
		ClutterActor* _tmp6_;
		ClutterActor* _tmp7_;
		gdouble _tmp8_;
		gdouble _tmp9_;
		ClutterActor* _tmp10_;
		ClutterActor* _tmp11_;
		gdouble _tmp12_;
		gdouble _tmp13_;
		clip_x = 0.0f;
		clip_y = 0.0f;
		_tmp3_ = self->priv->clone_container;
		clutter_actor_get_clip (_tmp3_, &_tmp4_, &_tmp5_, NULL, NULL);
		clip_x = _tmp4_;
		clip_y = _tmp5_;
		_tmp6_ = self->priv->clone_container;
		_tmp7_ = self->priv->clone_container;
		g_object_get (_tmp7_, "scale-x", &_tmp8_, NULL);
		_tmp9_ = _tmp8_;
		clutter_actor_set_x (_tmp6_, (gfloat) ((-clip_x) * _tmp9_));
		_tmp10_ = self->priv->clone_container;
		_tmp11_ = self->priv->clone_container;
		g_object_get (_tmp11_, "scale-y", &_tmp12_, NULL);
		_tmp13_ = _tmp12_;
		clutter_actor_set_y (_tmp10_, (gfloat) ((-clip_y) * _tmp13_));
	}
}

static void
gala_plugins_pip_popup_window_update_screen_position (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	if (!gala_plugins_pip_popup_window_place_window_off_screen (self)) {
		gala_plugins_pip_popup_window_place_window_in_screen (self);
	}
}

static void
gala_plugins_pip_popup_window_place_window_in_screen (GalaPluginsPIPPopupWindow* self)
{
	MtkRectangle workarea_rect = {0};
	MetaDisplay* _tmp0_;
	MetaWorkspaceManager* _tmp1_;
	MetaWorkspace* _tmp2_;
	MtkRectangle _tmp3_ = {0};
	gint screen_limit_start_x = 0;
	MtkRectangle _tmp4_;
	gfloat screen_limit_end_x = 0.0F;
	MtkRectangle _tmp5_;
	MtkRectangle _tmp6_;
	gfloat _tmp7_;
	gfloat _tmp8_;
	gint screen_limit_start_y = 0;
	MtkRectangle _tmp9_;
	gfloat screen_limit_end_y = 0.0F;
	MtkRectangle _tmp10_;
	MtkRectangle _tmp11_;
	gfloat _tmp12_;
	gfloat _tmp13_;
	guint duration = 0U;
	gfloat _tmp14_;
	gfloat _tmp15_;
	gfloat _tmp16_;
	gfloat _tmp17_;
	g_return_if_fail (self != NULL);
	self->priv->off_screen = FALSE;
	_tmp0_ = self->priv->_display;
	_tmp1_ = meta_display_get_workspace_manager (_tmp0_);
	_tmp2_ = meta_workspace_manager_get_active_workspace (_tmp1_);
	meta_workspace_get_work_area_all_monitors (_tmp2_, &_tmp3_);
	workarea_rect = _tmp3_;
	_tmp4_ = workarea_rect;
	screen_limit_start_x = _tmp4_.x + GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN;
	_tmp5_ = workarea_rect;
	_tmp6_ = workarea_rect;
	_tmp7_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp8_ = _tmp7_;
	screen_limit_end_x = ((_tmp5_.x + _tmp6_.width) - GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN) - _tmp8_;
	_tmp9_ = workarea_rect;
	screen_limit_start_y = _tmp9_.y + GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN;
	_tmp10_ = workarea_rect;
	_tmp11_ = workarea_rect;
	_tmp12_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp13_ = _tmp12_;
	screen_limit_end_y = ((_tmp10_.y + _tmp11_.height) - GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN) - _tmp13_;
	duration = gala_utils_get_animation_duration ((guint) 300);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_BACK);
	clutter_actor_set_easing_duration ((ClutterActor*) self, duration);
	_tmp14_ = clutter_actor_get_x ((ClutterActor*) self);
	_tmp15_ = _tmp14_;
	clutter_actor_set_x ((ClutterActor*) self, CLAMP (_tmp15_, (gfloat) screen_limit_start_x, screen_limit_end_x));
	_tmp16_ = clutter_actor_get_y ((ClutterActor*) self);
	_tmp17_ = _tmp16_;
	clutter_actor_set_y ((ClutterActor*) self, CLAMP (_tmp17_, (gfloat) screen_limit_start_y, screen_limit_end_y));
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}

static gboolean
gala_plugins_pip_popup_window_place_window_off_screen (GalaPluginsPIPPopupWindow* self)
{
	guint duration = 0U;
	MtkRectangle monitor_rect = {0};
	MetaDisplay* _tmp0_;
	MetaDisplay* _tmp1_;
	MtkRectangle _tmp2_ = {0};
	gint monitor_x = 0;
	MtkRectangle _tmp3_;
	gint monitor_y = 0;
	MtkRectangle _tmp4_;
	gint monitor_width = 0;
	MtkRectangle _tmp5_;
	gint monitor_height = 0;
	MtkRectangle _tmp6_;
	gfloat off_screen_x_threshold = 0.0F;
	gfloat _tmp7_;
	gfloat _tmp8_;
	gboolean off_screen_x = FALSE;
	gfloat _tmp9_;
	gfloat _tmp10_;
	gboolean _tmp11_ = FALSE;
	gboolean off_screen_w = FALSE;
	gfloat _tmp16_;
	gfloat _tmp17_;
	gfloat _tmp18_;
	gfloat _tmp19_;
	gboolean _tmp20_ = FALSE;
	gfloat off_screen_y_threshold = 0.0F;
	gfloat _tmp25_;
	gfloat _tmp26_;
	gboolean off_screen_y = FALSE;
	gfloat _tmp27_;
	gfloat _tmp28_;
	gboolean _tmp29_ = FALSE;
	gboolean off_screen_h = FALSE;
	gfloat _tmp34_;
	gfloat _tmp35_;
	gfloat _tmp36_;
	gfloat _tmp37_;
	gboolean _tmp38_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->off_screen = FALSE;
	duration = gala_utils_get_animation_duration ((guint) 300);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_BACK);
	clutter_actor_set_easing_duration ((ClutterActor*) self, duration);
	_tmp0_ = self->priv->_display;
	_tmp1_ = self->priv->_display;
	meta_display_get_monitor_geometry (_tmp0_, meta_display_get_current_monitor (_tmp1_), &_tmp2_);
	monitor_rect = _tmp2_;
	_tmp3_ = monitor_rect;
	monitor_x = _tmp3_.x;
	_tmp4_ = monitor_rect;
	monitor_y = _tmp4_.y;
	_tmp5_ = monitor_rect;
	monitor_width = _tmp5_.width;
	_tmp6_ = monitor_rect;
	monitor_height = _tmp6_.height;
	_tmp7_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp8_ = _tmp7_;
	off_screen_x_threshold = _tmp8_ * GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_PERCENT;
	_tmp9_ = clutter_actor_get_x ((ClutterActor*) self);
	_tmp10_ = _tmp9_;
	off_screen_x = (_tmp10_ - monitor_x) < (-off_screen_x_threshold);
	if (off_screen_x) {
		gfloat _tmp12_;
		gfloat _tmp13_;
		_tmp12_ = clutter_actor_get_x ((ClutterActor*) self);
		_tmp13_ = _tmp12_;
		_tmp11_ = !gala_plugins_pip_popup_window_coord_is_in_other_monitor (self, _tmp13_, CLUTTER_ORIENTATION_HORIZONTAL);
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		gfloat _tmp14_;
		gfloat _tmp15_;
		self->priv->off_screen = TRUE;
		_tmp14_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp15_ = _tmp14_;
		clutter_actor_set_x ((ClutterActor*) self, (monitor_x - _tmp15_) + GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS);
	}
	_tmp16_ = clutter_actor_get_x ((ClutterActor*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = clutter_actor_get_width ((ClutterActor*) self);
	_tmp19_ = _tmp18_;
	off_screen_w = (_tmp17_ + _tmp19_) > ((monitor_x + monitor_width) + off_screen_x_threshold);
	if (off_screen_w) {
		gfloat _tmp21_;
		gfloat _tmp22_;
		gfloat _tmp23_;
		gfloat _tmp24_;
		_tmp21_ = clutter_actor_get_x ((ClutterActor*) self);
		_tmp22_ = _tmp21_;
		_tmp23_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp24_ = _tmp23_;
		_tmp20_ = !gala_plugins_pip_popup_window_coord_is_in_other_monitor (self, _tmp22_ + _tmp24_, CLUTTER_ORIENTATION_HORIZONTAL);
	} else {
		_tmp20_ = FALSE;
	}
	if (_tmp20_) {
		self->priv->off_screen = TRUE;
		clutter_actor_set_x ((ClutterActor*) self, (gfloat) ((monitor_x + monitor_width) - GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS));
	}
	_tmp25_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp26_ = _tmp25_;
	off_screen_y_threshold = _tmp26_ * GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_PERCENT;
	_tmp27_ = clutter_actor_get_y ((ClutterActor*) self);
	_tmp28_ = _tmp27_;
	off_screen_y = (_tmp28_ - monitor_y) < (-off_screen_y_threshold);
	if (off_screen_y) {
		gfloat _tmp30_;
		gfloat _tmp31_;
		_tmp30_ = clutter_actor_get_y ((ClutterActor*) self);
		_tmp31_ = _tmp30_;
		_tmp29_ = !gala_plugins_pip_popup_window_coord_is_in_other_monitor (self, _tmp31_, CLUTTER_ORIENTATION_VERTICAL);
	} else {
		_tmp29_ = FALSE;
	}
	if (_tmp29_) {
		gfloat _tmp32_;
		gfloat _tmp33_;
		self->priv->off_screen = TRUE;
		_tmp32_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp33_ = _tmp32_;
		clutter_actor_set_y ((ClutterActor*) self, (monitor_y - _tmp33_) + GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS);
	}
	_tmp34_ = clutter_actor_get_y ((ClutterActor*) self);
	_tmp35_ = _tmp34_;
	_tmp36_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp37_ = _tmp36_;
	off_screen_h = (_tmp35_ + _tmp37_) > ((monitor_y + monitor_height) + off_screen_y_threshold);
	if (off_screen_h) {
		gfloat _tmp39_;
		gfloat _tmp40_;
		gfloat _tmp41_;
		gfloat _tmp42_;
		_tmp39_ = clutter_actor_get_y ((ClutterActor*) self);
		_tmp40_ = _tmp39_;
		_tmp41_ = clutter_actor_get_height ((ClutterActor*) self);
		_tmp42_ = _tmp41_;
		_tmp38_ = !gala_plugins_pip_popup_window_coord_is_in_other_monitor (self, _tmp40_ + _tmp42_, CLUTTER_ORIENTATION_VERTICAL);
	} else {
		_tmp38_ = FALSE;
	}
	if (_tmp38_) {
		self->priv->off_screen = TRUE;
		clutter_actor_set_y ((ClutterActor*) self, (gfloat) ((monitor_y + monitor_height) - GALA_PLUGINS_PIP_POPUP_WINDOW_OFF_SCREEN_VISIBLE_PIXELS));
	}
	clutter_actor_restore_easing_state ((ClutterActor*) self);
	result = self->priv->off_screen;
	return result;
}

static gboolean
gala_plugins_pip_popup_window_coord_is_in_other_monitor (GalaPluginsPIPPopupWindow* self,
                                                         gfloat coord,
                                                         ClutterOrientation axis)
{
	gint n_monitors = 0;
	MetaDisplay* _tmp0_;
	gint current = 0;
	MetaDisplay* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_display;
	n_monitors = meta_display_get_n_monitors (_tmp0_);
	if (n_monitors == 1) {
		result = FALSE;
		return result;
	}
	_tmp1_ = self->priv->_display;
	current = meta_display_get_current_monitor (_tmp1_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < n_monitors)) {
					break;
				}
				if (i != current) {
					MtkRectangle monitor_rect = {0};
					MetaDisplay* _tmp4_;
					MtkRectangle _tmp5_ = {0};
					gboolean in_monitor = FALSE;
					_tmp4_ = self->priv->_display;
					meta_display_get_monitor_geometry (_tmp4_, i, &_tmp5_);
					monitor_rect = _tmp5_;
					in_monitor = FALSE;
					if (axis == CLUTTER_ORIENTATION_HORIZONTAL) {
						gboolean _tmp6_ = FALSE;
						MtkRectangle _tmp7_;
						_tmp7_ = monitor_rect;
						if (coord >= ((gfloat) _tmp7_.x)) {
							MtkRectangle _tmp8_;
							MtkRectangle _tmp9_;
							_tmp8_ = monitor_rect;
							_tmp9_ = monitor_rect;
							_tmp6_ = coord <= ((gfloat) (_tmp8_.x + _tmp9_.width));
						} else {
							_tmp6_ = FALSE;
						}
						in_monitor = _tmp6_;
					} else {
						gboolean _tmp10_ = FALSE;
						MtkRectangle _tmp11_;
						_tmp11_ = monitor_rect;
						if (coord >= ((gfloat) _tmp11_.y)) {
							MtkRectangle _tmp12_;
							MtkRectangle _tmp13_;
							_tmp12_ = monitor_rect;
							_tmp13_ = monitor_rect;
							_tmp10_ = coord <= ((gfloat) (_tmp12_.y + _tmp13_.height));
						} else {
							_tmp10_ = FALSE;
						}
						in_monitor = _tmp10_;
					}
					if (in_monitor) {
						result = TRUE;
						return result;
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}

static void
gala_plugins_pip_popup_window_get_target_window_size (GalaPluginsPIPPopupWindow* self,
                                                      gfloat* width,
                                                      gfloat* height)
{
	gfloat _vala_width = 0.0F;
	gfloat _vala_height = 0.0F;
	ClutterActor* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->clone_container;
	g_object_get (_tmp0_, "has-clip", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		ClutterActor* _tmp3_;
		gfloat _tmp4_ = 0.0F;
		gfloat _tmp5_ = 0.0F;
		_tmp3_ = self->priv->clone_container;
		clutter_actor_get_clip (_tmp3_, NULL, NULL, &_tmp4_, &_tmp5_);
		_vala_width = _tmp4_;
		_vala_height = _tmp5_;
	} else {
		ClutterClone* _tmp6_;
		gboolean _tmp7_;
		gboolean _tmp8_;
		_tmp6_ = self->priv->clone;
		g_object_get ((ClutterActor*) _tmp6_, "has-clip", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		if (_tmp8_) {
			ClutterClone* _tmp9_;
			gfloat _tmp10_ = 0.0F;
			gfloat _tmp11_ = 0.0F;
			_tmp9_ = self->priv->clone;
			clutter_actor_get_clip ((ClutterActor*) _tmp9_, NULL, NULL, &_tmp10_, &_tmp11_);
			_vala_width = _tmp10_;
			_vala_height = _tmp11_;
		} else {
			ClutterClone* _tmp12_;
			gfloat _tmp13_;
			gfloat _tmp14_;
			ClutterClone* _tmp15_;
			gfloat _tmp16_;
			gfloat _tmp17_;
			_tmp12_ = self->priv->clone;
			_tmp13_ = clutter_actor_get_width ((ClutterActor*) _tmp12_);
			_tmp14_ = _tmp13_;
			_vala_width = _tmp14_;
			_tmp15_ = self->priv->clone;
			_tmp16_ = clutter_actor_get_height ((ClutterActor*) _tmp15_);
			_tmp17_ = _tmp16_;
			_vala_height = _tmp17_;
		}
	}
	if (width) {
		*width = _vala_width;
	}
	if (height) {
		*height = _vala_height;
	}
}

static void
gala_plugins_pip_popup_window_activate (GalaPluginsPIPPopupWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->off_screen) {
		gala_plugins_pip_popup_window_place_window_in_screen (self);
	} else {
		MetaWindow* window = NULL;
		MetaWindowActor* _tmp0_;
		MetaWindow* _tmp1_;
		MetaWindow* _tmp2_;
		MetaWindow* _tmp3_;
		_tmp0_ = self->priv->_window_actor;
		_tmp1_ = meta_window_actor_get_meta_window (_tmp0_);
		_tmp2_ = _g_object_ref0 (_tmp1_);
		window = _tmp2_;
		_tmp3_ = window;
		meta_window_activate (_tmp3_, clutter_get_current_event_time ());
		_g_object_unref0 (window);
	}
}

MetaDisplay*
gala_plugins_pip_popup_window_get_display (GalaPluginsPIPPopupWindow* self)
{
	MetaDisplay* result;
	MetaDisplay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_display;
	result = _tmp0_;
	return result;
}

static void
gala_plugins_pip_popup_window_set_display (GalaPluginsPIPPopupWindow* self,
                                           MetaDisplay* value)
{
	MetaDisplay* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_plugins_pip_popup_window_get_display (self);
	if (old_value != value) {
		MetaDisplay* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_display);
		self->priv->_display = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_DISPLAY_PROPERTY]);
	}
}

MetaWindowActor*
gala_plugins_pip_popup_window_get_window_actor (GalaPluginsPIPPopupWindow* self)
{
	MetaWindowActor* result;
	MetaWindowActor* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_window_actor;
	result = _tmp0_;
	return result;
}

static void
gala_plugins_pip_popup_window_set_window_actor (GalaPluginsPIPPopupWindow* self,
                                                MetaWindowActor* value)
{
	MetaWindowActor* old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_plugins_pip_popup_window_get_window_actor (self);
	if (old_value != value) {
		MetaWindowActor* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_window_actor);
		self->priv->_window_actor = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY]);
	}
}

static ClutterActor*
_gala_plugins_pip_popup_window_on_move_begin_gala_drag_drop_action_drag_begin (GalaDragDropAction* _sender,
                                                                               gfloat x,
                                                                               gfloat y,
                                                                               gpointer self)
{
	ClutterActor* result;
	result = gala_plugins_pip_popup_window_on_move_begin ((GalaPluginsPIPPopupWindow*) self);
	return result;
}

static void
_gala_plugins_pip_popup_window_on_move_end_gala_drag_drop_action_drag_canceled (GalaDragDropAction* _sender,
                                                                                gpointer self)
{
	gala_plugins_pip_popup_window_on_move_end ((GalaPluginsPIPPopupWindow*) self);
}

static void
_gala_plugins_pip_popup_window_activate_gala_drag_drop_action_actor_clicked (GalaDragDropAction* _sender,
                                                                             guint32 button,
                                                                             ClutterInputDeviceType device_type,
                                                                             gpointer self)
{
	gala_plugins_pip_popup_window_activate ((GalaPluginsPIPPopupWindow*) self);
}

static void
_gala_plugins_pip_popup_window_on_close_click_clicked_gala_close_button_triggered (GalaCloseButton* _sender,
                                                                                   guint32 timestamp,
                                                                                   gpointer self)
{
	gala_plugins_pip_popup_window_on_close_click_clicked ((GalaPluginsPIPPopupWindow*) self);
}

static gboolean
_gala_plugins_pip_popup_window_on_resize_button_press_clutter_actor_button_press_event (ClutterActor* _sender,
                                                                                        ClutterEvent* event,
                                                                                        gpointer self)
{
	gboolean result;
	result = gala_plugins_pip_popup_window_on_resize_button_press ((GalaPluginsPIPPopupWindow*) self, event);
	return result;
}

static void
_gala_plugins_pip_popup_window_on_allocation_changed_g_object_notify (GObject* _sender,
                                                                      GParamSpec* pspec,
                                                                      gpointer self)
{
	gala_plugins_pip_popup_window_on_allocation_changed ((GalaPluginsPIPPopupWindow*) self);
}

static void
_gala_plugins_pip_popup_window_on_close_click_clicked_meta_window_unmanaged (MetaWindow* _sender,
                                                                             gpointer self)
{
	gala_plugins_pip_popup_window_on_close_click_clicked ((GalaPluginsPIPPopupWindow*) self);
}

static void
_gala_plugins_pip_popup_window_update_window_focus_g_object_notify (GObject* _sender,
                                                                    GParamSpec* pspec,
                                                                    gpointer self)
{
	gala_plugins_pip_popup_window_update_window_focus ((GalaPluginsPIPPopupWindow*) self);
}

static void
_gala_plugins_pip_popup_window_update_window_focus_meta_workspace_manager_active_workspace_changed (MetaWorkspaceManager* _sender,
                                                                                                    gpointer self)
{
	gala_plugins_pip_popup_window_update_window_focus ((GalaPluginsPIPPopupWindow*) self);
}

static GObject *
gala_plugins_pip_popup_window_constructor (GType type,
                                           guint n_construct_properties,
                                           GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GalaPluginsPIPPopupWindow * self;
	gfloat scale = 0.0F;
	MetaDisplay* _tmp0_;
	MetaDisplay* _tmp1_;
	MetaWindowActor* _tmp2_;
	ClutterClone* _tmp3_;
	ClutterActor* _tmp4_ = NULL;
	ClutterActor* _tmp5_;
	ClutterClone* _tmp6_;
	ClutterActor* _tmp7_ = NULL;
	ClutterActor* _tmp8_;
	ClutterActor* _tmp9_;
	ClutterActor* _tmp10_;
	GalaShadowEffect* _tmp11_;
	GalaShadowEffect* _tmp12_;
	GalaDragDropAction* _tmp13_;
	GalaDragDropAction* _tmp14_;
	GalaDragDropAction* _tmp15_;
	GalaDragDropAction* _tmp16_;
	GalaDragDropAction* _tmp17_;
	MtkRectangle workarea_rect = {0};
	MetaDisplay* _tmp18_;
	MetaWorkspaceManager* _tmp19_;
	MetaWorkspace* _tmp20_;
	MtkRectangle _tmp21_ = {0};
	gfloat x_position = 0.0F;
	gfloat y_position = 0.0F;
	MtkRectangle _tmp27_;
	MtkRectangle _tmp28_;
	gfloat _tmp29_;
	gfloat _tmp30_;
	GalaCloseButton* _tmp31_ = NULL;
	GalaCloseButton* _tmp32_;
	ClutterAlignConstraint* _tmp33_;
	ClutterAlignConstraint* _tmp34_;
	GalaCloseButton* _tmp35_;
	ClutterAlignConstraint* _tmp36_;
	ClutterAlignConstraint* _tmp37_;
	GalaCloseButton* _tmp38_;
	ClutterActor* _tmp39_;
	ClutterActor* _tmp40_;
	ClutterActor* _tmp41_;
	ClutterActor* _tmp42_;
	ClutterAlignConstraint* _tmp43_;
	ClutterAlignConstraint* _tmp44_;
	ClutterActor* _tmp45_;
	ClutterAlignConstraint* _tmp46_;
	ClutterAlignConstraint* _tmp47_;
	ClutterActor* _tmp48_;
	ClutterActor* _tmp49_;
	GalaCloseButton* _tmp50_;
	ClutterActor* _tmp51_;
	MetaWindowActor* _tmp52_;
	ClutterActor* _tmp53_;
	MetaWindow* window = NULL;
	MetaWindowActor* _tmp54_;
	MetaWindow* _tmp55_;
	MetaWindow* _tmp56_;
	MetaWindow* _tmp57_;
	MetaWorkspaceManager* workspace_manager = NULL;
	MetaDisplay* _tmp58_;
	MetaWorkspaceManager* _tmp59_;
	MetaWorkspaceManager* _tmp60_;
	parent_class = G_OBJECT_CLASS (gala_plugins_pip_popup_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, GalaPluginsPIPPopupWindow);
	_tmp0_ = self->priv->_display;
	_tmp1_ = self->priv->_display;
	scale = meta_display_get_monitor_scale (_tmp0_, meta_display_get_current_monitor (_tmp1_));
	self->priv->button_size = gala_utils_scale_to_int (36, scale);
	self->priv->container_margin = self->priv->button_size / 2;
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_IN_QUAD);
	_tmp2_ = self->priv->_window_actor;
	_tmp3_ = (ClutterClone*) clutter_clone_new ((ClutterActor*) _tmp2_);
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->clone);
	self->priv->clone = _tmp3_;
	_tmp4_ = clutter_actor_new ();
	g_object_set (_tmp4_, "scale-x", (gdouble) 0.35f, NULL);
	g_object_set (_tmp4_, "scale-y", (gdouble) 0.35f, NULL);
	g_object_ref_sink (_tmp4_);
	_g_object_unref0 (self->priv->clone_container);
	self->priv->clone_container = _tmp4_;
	_tmp5_ = self->priv->clone_container;
	_tmp6_ = self->priv->clone;
	clutter_actor_add_child (_tmp5_, (ClutterActor*) _tmp6_);
	_tmp7_ = clutter_actor_new ();
	clutter_actor_set_reactive (_tmp7_, TRUE);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->container);
	self->priv->container = _tmp7_;
	_tmp8_ = self->priv->container;
	_tmp9_ = self->priv->clone_container;
	clutter_actor_add_child (_tmp8_, _tmp9_);
	_tmp10_ = self->priv->container;
	_tmp11_ = gala_shadow_effect_new ("window", scale);
	g_object_ref_sink (_tmp11_);
	_tmp12_ = _tmp11_;
	clutter_actor_add_effect (_tmp10_, (ClutterEffect*) _tmp12_);
	_g_object_unref0 (_tmp12_);
	_tmp13_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_SOURCE, "pip");
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->move_action);
	self->priv->move_action = _tmp13_;
	_tmp14_ = self->priv->move_action;
	g_signal_connect_object (_tmp14_, "drag-begin", (GCallback) _gala_plugins_pip_popup_window_on_move_begin_gala_drag_drop_action_drag_begin, self, 0);
	_tmp15_ = self->priv->move_action;
	g_signal_connect_object (_tmp15_, "drag-canceled", (GCallback) _gala_plugins_pip_popup_window_on_move_end_gala_drag_drop_action_drag_canceled, self, 0);
	_tmp16_ = self->priv->move_action;
	g_signal_connect_object (_tmp16_, "actor-clicked", (GCallback) _gala_plugins_pip_popup_window_activate_gala_drag_drop_action_actor_clicked, self, 0);
	_tmp17_ = self->priv->move_action;
	clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) _tmp17_);
	gala_plugins_pip_popup_window_update_size (self);
	_tmp18_ = self->priv->_display;
	_tmp19_ = meta_display_get_workspace_manager (_tmp18_);
	_tmp20_ = meta_workspace_manager_get_active_workspace (_tmp19_);
	meta_workspace_get_work_area_all_monitors (_tmp20_, &_tmp21_);
	workarea_rect = _tmp21_;
	if (clutter_get_default_text_direction () == CLUTTER_TEXT_DIRECTION_RTL) {
		MtkRectangle _tmp22_;
		_tmp22_ = workarea_rect;
		x_position = (gfloat) (GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN + _tmp22_.x);
	} else {
		MtkRectangle _tmp23_;
		MtkRectangle _tmp24_;
		gfloat _tmp25_;
		gfloat _tmp26_;
		_tmp23_ = workarea_rect;
		_tmp24_ = workarea_rect;
		_tmp25_ = clutter_actor_get_width ((ClutterActor*) self);
		_tmp26_ = _tmp25_;
		x_position = ((_tmp23_.x + _tmp24_.width) - GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN) - _tmp26_;
	}
	_tmp27_ = workarea_rect;
	_tmp28_ = workarea_rect;
	_tmp29_ = clutter_actor_get_height ((ClutterActor*) self);
	_tmp30_ = _tmp29_;
	y_position = ((_tmp27_.y + _tmp28_.height) - GALA_PLUGINS_PIP_POPUP_WINDOW_SCREEN_MARGIN) - _tmp30_;
	clutter_actor_set_position ((ClutterActor*) self, x_position, y_position);
	_tmp31_ = gala_close_button_new (scale);
	clutter_actor_set_opacity ((ClutterActor*) _tmp31_, (guint) 0);
	g_object_ref_sink (_tmp31_);
	_g_object_unref0 (self->priv->close_button);
	self->priv->close_button = _tmp31_;
	_tmp32_ = self->priv->close_button;
	_tmp33_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_X_AXIS, 0.0f);
	g_object_ref_sink (_tmp33_);
	_tmp34_ = _tmp33_;
	clutter_actor_add_constraint ((ClutterActor*) _tmp32_, (ClutterConstraint*) _tmp34_);
	_g_object_unref0 (_tmp34_);
	_tmp35_ = self->priv->close_button;
	_tmp36_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_Y_AXIS, 0.0f);
	g_object_ref_sink (_tmp36_);
	_tmp37_ = _tmp36_;
	clutter_actor_add_constraint ((ClutterActor*) _tmp35_, (ClutterConstraint*) _tmp37_);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = self->priv->close_button;
	g_signal_connect_object (_tmp38_, "triggered", (GCallback) _gala_plugins_pip_popup_window_on_close_click_clicked_gala_close_button_triggered, self, 0);
	_tmp39_ = gala_utils_create_resize_button (scale);
	_g_object_unref0 (self->priv->resize_button);
	self->priv->resize_button = _tmp39_;
	_tmp40_ = self->priv->resize_button;
	clutter_actor_set_opacity (_tmp40_, (guint) 0);
	_tmp41_ = self->priv->resize_button;
	clutter_actor_set_reactive (_tmp41_, TRUE);
	_tmp42_ = self->priv->resize_button;
	_tmp43_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_X_AXIS, 1.0f);
	g_object_ref_sink (_tmp43_);
	_tmp44_ = _tmp43_;
	clutter_actor_add_constraint (_tmp42_, (ClutterConstraint*) _tmp44_);
	_g_object_unref0 (_tmp44_);
	_tmp45_ = self->priv->resize_button;
	_tmp46_ = (ClutterAlignConstraint*) clutter_align_constraint_new ((ClutterActor*) self, CLUTTER_ALIGN_Y_AXIS, 1.0f);
	g_object_ref_sink (_tmp46_);
	_tmp47_ = _tmp46_;
	clutter_actor_add_constraint (_tmp45_, (ClutterConstraint*) _tmp47_);
	_g_object_unref0 (_tmp47_);
	_tmp48_ = self->priv->resize_button;
	g_signal_connect_object (_tmp48_, "button-press-event", (GCallback) _gala_plugins_pip_popup_window_on_resize_button_press_clutter_actor_button_press_event, self, 0);
	_tmp49_ = self->priv->container;
	clutter_actor_add_child ((ClutterActor*) self, _tmp49_);
	_tmp50_ = self->priv->close_button;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) _tmp50_);
	_tmp51_ = self->priv->resize_button;
	clutter_actor_add_child ((ClutterActor*) self, _tmp51_);
	_tmp52_ = self->priv->_window_actor;
	g_signal_connect_object ((GObject*) _tmp52_, "notify::allocation", (GCallback) _gala_plugins_pip_popup_window_on_allocation_changed_g_object_notify, self, 0);
	_tmp53_ = self->priv->container;
	clutter_actor_set_position (_tmp53_, (gfloat) self->priv->container_margin, (gfloat) self->priv->container_margin);
	gala_plugins_pip_popup_window_update_clone_clip (self);
	_tmp54_ = self->priv->_window_actor;
	_tmp55_ = meta_window_actor_get_meta_window (_tmp54_);
	window = _tmp55_;
	_tmp56_ = window;
	g_signal_connect_object (_tmp56_, "unmanaged", (GCallback) _gala_plugins_pip_popup_window_on_close_click_clicked_meta_window_unmanaged, self, 0);
	_tmp57_ = window;
	g_signal_connect_object ((GObject*) _tmp57_, "notify::appears-focused", (GCallback) _gala_plugins_pip_popup_window_update_window_focus_g_object_notify, self, 0);
	_tmp58_ = self->priv->_display;
	_tmp59_ = meta_display_get_workspace_manager (_tmp58_);
	workspace_manager = _tmp59_;
	_tmp60_ = workspace_manager;
	g_signal_connect_object (_tmp60_, "active-workspace-changed", (GCallback) _gala_plugins_pip_popup_window_update_window_focus_meta_workspace_manager_active_workspace_changed, self, 0);
	return obj;
}

static void
gala_plugins_pip_popup_window_class_init (GalaPluginsPIPPopupWindowClass * klass,
                                          gpointer klass_data)
{
	gala_plugins_pip_popup_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaPluginsPIPPopupWindow_private_offset);
	((ClutterActorClass *) klass)->show = (void (*) (ClutterActor*)) gala_plugins_pip_popup_window_real_show;
	((ClutterActorClass *) klass)->hide = (void (*) (ClutterActor*)) gala_plugins_pip_popup_window_real_hide;
	((ClutterActorClass *) klass)->enter_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_plugins_pip_popup_window_real_enter_event;
	((ClutterActorClass *) klass)->leave_event = (gboolean (*) (ClutterActor*, ClutterEvent*)) gala_plugins_pip_popup_window_real_leave_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_plugins_pip_popup_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_plugins_pip_popup_window_set_property;
	G_OBJECT_CLASS (klass)->constructor = gala_plugins_pip_popup_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = gala_plugins_pip_popup_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGINS_PIP_POPUP_WINDOW_DISPLAY_PROPERTY, gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_DISPLAY_PROPERTY] = g_param_spec_object ("display", "display", "display", meta_display_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY, gala_plugins_pip_popup_window_properties[GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY] = g_param_spec_object ("window-actor", "window-actor", "window-actor", meta_window_actor_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	gala_plugins_pip_popup_window_signals[GALA_PLUGINS_PIP_POPUP_WINDOW_CLOSED_SIGNAL] = g_signal_new ("closed", GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
gala_plugins_pip_popup_window_instance_init (GalaPluginsPIPPopupWindow * self,
                                             gpointer klass)
{
	self->priv = gala_plugins_pip_popup_window_get_instance_private (self);
	self->priv->begin_resize_width = 0.0f;
	self->priv->begin_resize_height = 0.0f;
	self->priv->resize_start_x = 0.0f;
	self->priv->resize_start_y = 0.0f;
	self->priv->resizing = FALSE;
	self->priv->off_screen = FALSE;
	self->priv->grab = NULL;
}

static void
gala_plugins_pip_popup_window_finalize (GObject * obj)
{
	GalaPluginsPIPPopupWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, GalaPluginsPIPPopupWindow);
	_g_object_unref0 (self->priv->_display);
	_g_object_unref0 (self->priv->_window_actor);
	_g_object_unref0 (self->priv->clone);
	_g_object_unref0 (self->priv->clone_container);
	_g_object_unref0 (self->priv->container);
	_g_object_unref0 (self->priv->close_button);
	_g_object_unref0 (self->priv->resize_button);
	_g_object_unref0 (self->priv->move_action);
	_g_object_unref0 (self->priv->grab);
	G_OBJECT_CLASS (gala_plugins_pip_popup_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_plugins_pip_popup_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaPluginsPIPPopupWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_plugins_pip_popup_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaPluginsPIPPopupWindow), 0, (GInstanceInitFunc) gala_plugins_pip_popup_window_instance_init, NULL };
	GType gala_plugins_pip_popup_window_type_id;
	gala_plugins_pip_popup_window_type_id = g_type_register_static (clutter_actor_get_type (), "GalaPluginsPIPPopupWindow", &g_define_type_info, 0);
	GalaPluginsPIPPopupWindow_private_offset = g_type_add_instance_private (gala_plugins_pip_popup_window_type_id, sizeof (GalaPluginsPIPPopupWindowPrivate));
	return gala_plugins_pip_popup_window_type_id;
}

GType
gala_plugins_pip_popup_window_get_type (void)
{
	static gsize gala_plugins_pip_popup_window_type_id__once = 0;
	if (g_once_init_enter (&gala_plugins_pip_popup_window_type_id__once)) {
		GType gala_plugins_pip_popup_window_type_id;
		gala_plugins_pip_popup_window_type_id = gala_plugins_pip_popup_window_get_type_once ();
		g_once_init_leave (&gala_plugins_pip_popup_window_type_id__once, gala_plugins_pip_popup_window_type_id);
	}
	return gala_plugins_pip_popup_window_type_id__once;
}

static void
_vala_gala_plugins_pip_popup_window_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec)
{
	GalaPluginsPIPPopupWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, GalaPluginsPIPPopupWindow);
	switch (property_id) {
		case GALA_PLUGINS_PIP_POPUP_WINDOW_DISPLAY_PROPERTY:
		g_value_set_object (value, gala_plugins_pip_popup_window_get_display (self));
		break;
		case GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY:
		g_value_set_object (value, gala_plugins_pip_popup_window_get_window_actor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_plugins_pip_popup_window_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec)
{
	GalaPluginsPIPPopupWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_PLUGINS_PIP_TYPE_POPUP_WINDOW, GalaPluginsPIPPopupWindow);
	switch (property_id) {
		case GALA_PLUGINS_PIP_POPUP_WINDOW_DISPLAY_PROPERTY:
		gala_plugins_pip_popup_window_set_display (self, g_value_get_object (value));
		break;
		case GALA_PLUGINS_PIP_POPUP_WINDOW_WINDOW_ACTOR_PROPERTY:
		gala_plugins_pip_popup_window_set_window_actor (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

