/* ToucheggBackend.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ToucheggBackend.vala, do not modify */

/*
 * Copyright 2020 - 2021 elementary, Inc (https://elementary.io)
 *           2020 - 2021 José Expósito <jose.exposito89@gmail.com>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <meta/common.h>
#include <clutter/clutter.h>

#define GALA_TOUCHEGG_BACKEND_DBUS_ADDRESS "unix:abstract=touchegg"
#define GALA_TOUCHEGG_BACKEND_DBUS_INTERFACE_NAME "io.github.joseexposito.Touchegg"
#define GALA_TOUCHEGG_BACKEND_DBUS_OBJECT_PATH "/io/github/joseexposito/Touchegg"
#define GALA_TOUCHEGG_BACKEND_DBUS_ON_GESTURE_BEGIN "OnGestureBegin"
#define GALA_TOUCHEGG_BACKEND_DBUS_ON_GESTURE_UPDATE "OnGestureUpdate"
#define GALA_TOUCHEGG_BACKEND_DBUS_ON_GESTURE_END "OnGestureEnd"
#define GALA_TOUCHEGG_BACKEND_MAX_RECONNECTION_ATTEMPTS 10
#define GALA_TOUCHEGG_BACKEND_RECONNECTION_USLEEP_TIME 5000000
#define GALA_TOUCHEGG_BACKEND_DELTA_MULTIPLIER 0.01
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_GESTURE_BACKEND (gala_gesture_backend_get_type ())
#define GALA_GESTURE_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE_BACKEND, GalaGestureBackend))
#define GALA_IS_GESTURE_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE_BACKEND))
#define GALA_GESTURE_BACKEND_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GALA_TYPE_GESTURE_BACKEND, GalaGestureBackendIface))

typedef struct _GalaGestureBackend GalaGestureBackend;
typedef struct _GalaGestureBackendIface GalaGestureBackendIface;

#define GALA_TYPE_TOUCHEGG_BACKEND (gala_touchegg_backend_get_type ())
#define GALA_TOUCHEGG_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_TOUCHEGG_BACKEND, GalaToucheggBackend))
#define GALA_TOUCHEGG_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_TOUCHEGG_BACKEND, GalaToucheggBackendClass))
#define GALA_IS_TOUCHEGG_BACKEND(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_TOUCHEGG_BACKEND))
#define GALA_IS_TOUCHEGG_BACKEND_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_TOUCHEGG_BACKEND))
#define GALA_TOUCHEGG_BACKEND_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_TOUCHEGG_BACKEND, GalaToucheggBackendClass))

typedef struct _GalaToucheggBackend GalaToucheggBackend;
typedef struct _GalaToucheggBackendClass GalaToucheggBackendClass;
typedef struct _GalaToucheggBackendPrivate GalaToucheggBackendPrivate;
enum  {
	GALA_TOUCHEGG_BACKEND_0_PROPERTY,
	GALA_TOUCHEGG_BACKEND_NUM_PROPERTIES
};
static GParamSpec* gala_touchegg_backend_properties[GALA_TOUCHEGG_BACKEND_NUM_PROPERTIES];
typedef enum  {
	GALA_TOUCHEGG_BACKEND_GESTURE_TYPE_NOT_SUPPORTED = 0,
	GALA_TOUCHEGG_BACKEND_GESTURE_TYPE_SWIPE = 1,
	GALA_TOUCHEGG_BACKEND_GESTURE_TYPE_PINCH = 2
} GalaToucheggBackendGestureType;

#define GALA_TOUCHEGG_BACKEND_TYPE_GESTURE_TYPE (gala_touchegg_backend_gesture_type_get_type ())
typedef enum  {
	GALA_TOUCHEGG_BACKEND_DEVICE_TYPE_UNKNOWN = 0,
	GALA_TOUCHEGG_BACKEND_DEVICE_TYPE_TOUCHPAD = 1,
	GALA_TOUCHEGG_BACKEND_DEVICE_TYPE_TOUCHSCREEN = 2
} GalaToucheggBackendDeviceType;

#define GALA_TOUCHEGG_BACKEND_TYPE_DEVICE_TYPE (gala_touchegg_backend_device_type_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
typedef enum  {
	GALA_GESTURE_DIRECTION_UNKNOWN = 0,
	GALA_GESTURE_DIRECTION_UP = 1,
	GALA_GESTURE_DIRECTION_DOWN = 2,
	GALA_GESTURE_DIRECTION_LEFT = 3,
	GALA_GESTURE_DIRECTION_RIGHT = 4,
	GALA_GESTURE_DIRECTION_IN = 5,
	GALA_GESTURE_DIRECTION_OUT = 6
} GalaGestureDirection;

#define GALA_TYPE_GESTURE_DIRECTION (gala_gesture_direction_get_type ())
typedef struct _Block52Data Block52Data;

#define GALA_TYPE_GESTURE (gala_gesture_get_type ())
#define GALA_GESTURE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_GESTURE, GalaGesture))
#define GALA_GESTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_GESTURE, GalaGestureClass))
#define GALA_IS_GESTURE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_GESTURE))
#define GALA_IS_GESTURE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_GESTURE))
#define GALA_GESTURE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_GESTURE, GalaGestureClass))

typedef struct _GalaGesture GalaGesture;
typedef struct _GalaGestureClass GalaGestureClass;
#define _gala_gesture_unref0(var) ((var == NULL) ? NULL : (var = (gala_gesture_unref (var), NULL)))
typedef struct _GalaGesturePrivate GalaGesturePrivate;

struct _GalaGestureBackendIface {
	GTypeInterface parent_iface;
	void (*prepare_gesture_handling) (GalaGestureBackend* self);
	void (*cancel_gesture) (GalaGestureBackend* self);
};

struct _GalaToucheggBackend {
	GObject parent_instance;
	GalaToucheggBackendPrivate * priv;
};

struct _GalaToucheggBackendClass {
	GObjectClass parent_class;
};

struct _GalaToucheggBackendPrivate {
	GDBusConnection* connection;
	gint reconnection_attempts;
	gchar* last_signal_received;
	GVariant* last_params_received;
};

struct _Block52Data {
	int _ref_count_;
	GalaToucheggBackend* self;
	GalaToucheggBackendGestureType type;
	GalaGestureDirection direction;
	gint fingers;
	GalaToucheggBackendDeviceType performed_on_device_type;
	guint64 elapsed_time;
	gdouble delta;
};

struct _GalaGesture {
	GTypeInstance parent_instance;
	volatile int ref_count;
	GalaGesturePrivate * priv;
	ClutterEventType type;
	GalaGestureDirection direction;
	gint fingers;
	ClutterInputDeviceType performed_on_device_type;
	gfloat origin_x;
	gfloat origin_y;
};

struct _GalaGestureClass {
	GTypeClass parent_class;
	void (*finalize) (GalaGesture *self);
};

static gint GalaToucheggBackend_private_offset;
static gpointer gala_touchegg_backend_parent_class = NULL;
static GalaToucheggBackend* gala_touchegg_backend_instance;
static GalaToucheggBackend* gala_touchegg_backend_instance = NULL;
static GalaGestureBackendIface * gala_touchegg_backend_gala_gesture_backend_parent_iface = NULL;

VALA_EXTERN GType gala_gesture_backend_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGestureBackend, g_object_unref)
VALA_EXTERN GType gala_touchegg_backend_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaToucheggBackend, g_object_unref)
static GType gala_touchegg_backend_gesture_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static GType gala_touchegg_backend_device_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
VALA_EXTERN GalaToucheggBackend* gala_touchegg_backend_get_default (void);
VALA_EXTERN GalaToucheggBackend* gala_touchegg_backend_new (void);
VALA_EXTERN GalaToucheggBackend* gala_touchegg_backend_construct (GType object_type);
static void gala_touchegg_backend_stablish_connection (GalaToucheggBackend* self);
static void __lambda4_ (GalaToucheggBackend* self);
static void gala_touchegg_backend_on_new_message (GDBusConnection* connection,
                                           const gchar* sender_name,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* signal_name,
                                           GVariant* parameters,
                                           GalaToucheggBackend* self);
static void gala_touchegg_backend_on_disconnected (GalaToucheggBackend* self,
                                            gboolean remote_peer_vanished,
                                            GError* _error_);
static void _gala_touchegg_backend_on_disconnected_g_dbus_connection_closed (GDBusConnection* _sender,
                                                                      gboolean remote_peer_vanished,
                                                                      GError* _error_,
                                                                      gpointer self);
static gpointer ___lambda4__gthread_func (gpointer self);
VALA_EXTERN void gala_touchegg_backend_stop (GalaToucheggBackend* self);
static void gala_touchegg_backend_emit_event (GalaToucheggBackend* self,
                                       const gchar* signal_name,
                                       GVariant* signal_params);
VALA_EXTERN GType gala_gesture_direction_get_type (void) G_GNUC_CONST ;
static Block52Data* block52_data_ref (Block52Data* _data52_);
static void block52_data_unref (void * _userdata_);
static gboolean ___lambda5_ (Block52Data* _data52_);
VALA_EXTERN gpointer gala_gesture_ref (gpointer instance);
VALA_EXTERN void gala_gesture_unref (gpointer instance);
VALA_EXTERN GParamSpec* gala_param_spec_gesture (const gchar* name,
                                     const gchar* nick,
                                     const gchar* blurb,
                                     GType object_type,
                                     GParamFlags flags);
VALA_EXTERN void gala_value_set_gesture (GValue* value,
                             gpointer v_object);
VALA_EXTERN void gala_value_take_gesture (GValue* value,
                              gpointer v_object);
VALA_EXTERN gpointer gala_value_get_gesture (const GValue* value);
VALA_EXTERN GType gala_gesture_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaGesture, gala_gesture_unref)
static GalaGesture* gala_touchegg_backend_make_gesture (GalaToucheggBackendGestureType type,
                                                 GalaGestureDirection direction,
                                                 gint fingers,
                                                 GalaToucheggBackendDeviceType performed_on_device_type);
static gboolean ____lambda5__gsource_func (gpointer self);
static gboolean ___lambda6_ (Block52Data* _data52_);
static gboolean ____lambda6__gsource_func (gpointer self);
static gboolean ___lambda7_ (Block52Data* _data52_);
static gboolean ____lambda7__gsource_func (gpointer self);
VALA_EXTERN GalaGesture* gala_gesture_new (void);
VALA_EXTERN GalaGesture* gala_gesture_construct (GType object_type);
static void gala_touchegg_backend_finalize (GObject * obj);
static GType gala_touchegg_backend_get_type_once (void);

static inline gpointer
gala_touchegg_backend_get_instance_private (GalaToucheggBackend* self)
{
	return G_STRUCT_MEMBER_P (self, GalaToucheggBackend_private_offset);
}

/**
     * Gesture type as returned by the daemon.
     */
 G_GNUC_NO_INLINE static GType
gala_touchegg_backend_gesture_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_TOUCHEGG_BACKEND_GESTURE_TYPE_NOT_SUPPORTED, "GALA_TOUCHEGG_BACKEND_GESTURE_TYPE_NOT_SUPPORTED", "not-supported"}, {GALA_TOUCHEGG_BACKEND_GESTURE_TYPE_SWIPE, "GALA_TOUCHEGG_BACKEND_GESTURE_TYPE_SWIPE", "swipe"}, {GALA_TOUCHEGG_BACKEND_GESTURE_TYPE_PINCH, "GALA_TOUCHEGG_BACKEND_GESTURE_TYPE_PINCH", "pinch"}, {0, NULL, NULL}};
	GType gala_touchegg_backend_gesture_type_type_id;
	gala_touchegg_backend_gesture_type_type_id = g_enum_register_static ("GalaToucheggBackendGestureType", values);
	return gala_touchegg_backend_gesture_type_type_id;
}

static GType
gala_touchegg_backend_gesture_type_get_type (void)
{
	static gsize gala_touchegg_backend_gesture_type_type_id__once = 0;
	if (g_once_init_enter (&gala_touchegg_backend_gesture_type_type_id__once)) {
		GType gala_touchegg_backend_gesture_type_type_id;
		gala_touchegg_backend_gesture_type_type_id = gala_touchegg_backend_gesture_type_get_type_once ();
		g_once_init_leave (&gala_touchegg_backend_gesture_type_type_id__once, gala_touchegg_backend_gesture_type_type_id);
	}
	return gala_touchegg_backend_gesture_type_type_id__once;
}

/**
     * Device type as returned by the daemon.
     */
 G_GNUC_NO_INLINE static GType
gala_touchegg_backend_device_type_get_type_once (void)
{
	static const GEnumValue values[] = {{GALA_TOUCHEGG_BACKEND_DEVICE_TYPE_UNKNOWN, "GALA_TOUCHEGG_BACKEND_DEVICE_TYPE_UNKNOWN", "unknown"}, {GALA_TOUCHEGG_BACKEND_DEVICE_TYPE_TOUCHPAD, "GALA_TOUCHEGG_BACKEND_DEVICE_TYPE_TOUCHPAD", "touchpad"}, {GALA_TOUCHEGG_BACKEND_DEVICE_TYPE_TOUCHSCREEN, "GALA_TOUCHEGG_BACKEND_DEVICE_TYPE_TOUCHSCREEN", "touchscreen"}, {0, NULL, NULL}};
	GType gala_touchegg_backend_device_type_type_id;
	gala_touchegg_backend_device_type_type_id = g_enum_register_static ("GalaToucheggBackendDeviceType", values);
	return gala_touchegg_backend_device_type_type_id;
}

static GType
gala_touchegg_backend_device_type_get_type (void)
{
	static gsize gala_touchegg_backend_device_type_type_id__once = 0;
	if (g_once_init_enter (&gala_touchegg_backend_device_type_type_id__once)) {
		GType gala_touchegg_backend_device_type_type_id;
		gala_touchegg_backend_device_type_type_id = gala_touchegg_backend_device_type_get_type_once ();
		g_once_init_leave (&gala_touchegg_backend_device_type_type_id__once, gala_touchegg_backend_device_type_type_id);
	}
	return gala_touchegg_backend_device_type_type_id__once;
}

/**
     * @return Single instance of the class.
     */
GalaToucheggBackend*
gala_touchegg_backend_get_default (void)
{
	GalaToucheggBackend* _tmp0_;
	GalaToucheggBackend* _tmp3_;
	GalaToucheggBackend* result;
	_tmp0_ = gala_touchegg_backend_instance;
	if (_tmp0_ == NULL) {
		GalaToucheggBackend* _tmp1_;
		GalaToucheggBackend* _tmp2_;
		_tmp1_ = gala_touchegg_backend_new ();
		_g_object_unref0 (gala_touchegg_backend_instance);
		gala_touchegg_backend_instance = _tmp1_;
		_tmp2_ = gala_touchegg_backend_instance;
		gala_touchegg_backend_stablish_connection (_tmp2_);
	}
	_tmp3_ = gala_touchegg_backend_instance;
	result = _tmp3_;
	return result;
}

/**
     * Stablish a connection with the daemon server.
     */
static void
_gala_touchegg_backend_on_disconnected_g_dbus_connection_closed (GDBusConnection* _sender,
                                                                 gboolean remote_peer_vanished,
                                                                 GError* _error_,
                                                                 gpointer self)
{
	gala_touchegg_backend_on_disconnected ((GalaToucheggBackend*) self, remote_peer_vanished, _error_);
}

static void
__lambda4_ (GalaToucheggBackend* self)
{
	gboolean connected = FALSE;
	GError* _inner_error0_ = NULL;
	connected = FALSE;
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		if (!connected) {
			_tmp0_ = self->priv->reconnection_attempts < GALA_TOUCHEGG_BACKEND_MAX_RECONNECTION_ATTEMPTS;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		{
			GDBusConnection* _tmp1_ = NULL;
			GDBusConnection* _tmp2_;
			GDBusConnection* _tmp3_;
			GDBusConnection* _tmp4_;
			GDBusConnection* _tmp5_;
			g_debug ("ToucheggBackend.vala:122: Connecting to Touchégg daemon");
			_tmp2_ = g_dbus_connection_new_for_address_sync (GALA_TOUCHEGG_BACKEND_DBUS_ADDRESS, G_DBUS_CONNECTION_FLAGS_AUTHENTICATION_CLIENT, NULL, NULL, &_inner_error0_);
			_tmp1_ = _tmp2_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp3_ = _tmp1_;
			_tmp1_ = NULL;
			_g_object_unref0 (self->priv->connection);
			self->priv->connection = _tmp3_;
			g_debug ("ToucheggBackend.vala:128: Connection with Touchégg established");
			connected = TRUE;
			self->priv->reconnection_attempts = 0;
			_tmp4_ = self->priv->connection;
			g_dbus_connection_signal_subscribe (_tmp4_, NULL, GALA_TOUCHEGG_BACKEND_DBUS_INTERFACE_NAME, NULL, GALA_TOUCHEGG_BACKEND_DBUS_OBJECT_PATH, NULL, G_DBUS_SIGNAL_FLAGS_NONE, (GDBusSignalCallback) gala_touchegg_backend_on_new_message, g_object_ref (self), g_object_unref);
			_tmp5_ = self->priv->connection;
			g_signal_connect_object (_tmp5_, "closed", (GCallback) _gala_touchegg_backend_on_disconnected_g_dbus_connection_closed, self, 0);
			_g_object_unref0 (_tmp1_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp6_;
			const gchar* _tmp7_;
			gint _tmp8_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp6_ = e;
			_tmp7_ = _tmp6_->message;
			g_warning ("ToucheggBackend.vala:136: Error connecting to Touchégg daemon: %s", _tmp7_);
			connected = FALSE;
			_tmp8_ = self->priv->reconnection_attempts;
			self->priv->reconnection_attempts = _tmp8_ + 1;
			if (self->priv->reconnection_attempts < GALA_TOUCHEGG_BACKEND_MAX_RECONNECTION_ATTEMPTS) {
				g_debug ("ToucheggBackend.vala:141: Reconnecting to Touchégg daemon in 5 seconds");
				g_usleep ((gulong) GALA_TOUCHEGG_BACKEND_RECONNECTION_USLEEP_TIME);
			} else {
				g_warning ("ToucheggBackend.vala:144: Maximum number of reconnections reached, abo" \
"rting");
			}
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

static gpointer
___lambda4__gthread_func (gpointer self)
{
	gpointer result;
	__lambda4_ ((GalaToucheggBackend*) self);
	result = NULL;
	g_object_unref (self);
	return result;
}

static void
gala_touchegg_backend_stablish_connection (GalaToucheggBackend* self)
{
	GThreadFunc run = NULL;
	gpointer run_target;
	GThreadFunc _tmp0_;
	gpointer _tmp0__target;
	GThread* _tmp1_;
	GThread* _tmp2_;
	g_return_if_fail (self != NULL);
	run = ___lambda4__gthread_func;
	run_target = g_object_ref (self);
	_tmp0_ = run;
	_tmp0__target = run_target;
	run = NULL;
	run_target = NULL;
	_tmp1_ = g_thread_new (NULL, _tmp0_, _tmp0__target);
	_tmp2_ = _tmp1_;
	_g_thread_unref0 (_tmp2_);
}

void
gala_touchegg_backend_stop (GalaToucheggBackend* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GDBusConnection* _tmp0_;
		gboolean _tmp1_;
		gboolean _tmp2_;
		self->priv->reconnection_attempts = GALA_TOUCHEGG_BACKEND_MAX_RECONNECTION_ATTEMPTS;
		_tmp0_ = self->priv->connection;
		g_object_get (_tmp0_, "closed", &_tmp1_, NULL);
		_tmp2_ = _tmp1_;
		if (!_tmp2_) {
			GDBusConnection* _tmp3_;
			_tmp3_ = self->priv->connection;
			g_dbus_connection_close_sync (_tmp3_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gpointer
_g_variant_ref0 (gpointer self)
{
	return self ? g_variant_ref (self) : NULL;
}

static void
gala_touchegg_backend_on_new_message (GDBusConnection* connection,
                                      const gchar* sender_name,
                                      const gchar* object_path,
                                      const gchar* interface_name,
                                      const gchar* signal_name,
                                      GVariant* parameters,
                                      GalaToucheggBackend* self)
{
	gchar* _tmp0_;
	GVariant* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (object_path != NULL);
	g_return_if_fail (interface_name != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (parameters != NULL);
	_tmp0_ = g_strdup (signal_name);
	_g_free0 (self->priv->last_signal_received);
	self->priv->last_signal_received = _tmp0_;
	_tmp1_ = _g_variant_ref0 (parameters);
	_g_variant_unref0 (self->priv->last_params_received);
	self->priv->last_params_received = _tmp1_;
	gala_touchegg_backend_emit_event (self, signal_name, parameters);
}

static void
gala_touchegg_backend_on_disconnected (GalaToucheggBackend* self,
                                       gboolean remote_peer_vanished,
                                       GError* _error_)
{
	const gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _error_->message;
	g_debug ("ToucheggBackend.vala:174: Connection with Touchégg daemon lost %s", _tmp0_);
	_tmp2_ = self->priv->last_signal_received;
	if (g_strcmp0 (_tmp2_, GALA_TOUCHEGG_BACKEND_DBUS_ON_GESTURE_BEGIN) == 0) {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp3_;
		_tmp3_ = self->priv->last_signal_received;
		_tmp1_ = g_strcmp0 (_tmp3_, GALA_TOUCHEGG_BACKEND_DBUS_ON_GESTURE_UPDATE) == 0;
	}
	if (_tmp1_) {
		GVariant* _tmp4_;
		g_debug ("ToucheggBackend.vala:177: Connection lost in the middle of a gesture, " \
"ending it");
		_tmp4_ = self->priv->last_params_received;
		gala_touchegg_backend_emit_event (self, GALA_TOUCHEGG_BACKEND_DBUS_ON_GESTURE_END, _tmp4_);
	}
	gala_touchegg_backend_stablish_connection (self);
}

static Block52Data*
block52_data_ref (Block52Data* _data52_)
{
	g_atomic_int_inc (&_data52_->_ref_count_);
	return _data52_;
}

static void
block52_data_unref (void * _userdata_)
{
	Block52Data* _data52_;
	_data52_ = (Block52Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data52_->_ref_count_)) {
		GalaToucheggBackend* self;
		self = _data52_->self;
		_g_object_unref0 (self);
		g_slice_free (Block52Data, _data52_);
	}
}

static gboolean
___lambda5_ (Block52Data* _data52_)
{
	GalaToucheggBackend* self;
	GalaGesture* _tmp0_;
	GalaGesture* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	self = _data52_->self;
	_tmp0_ = gala_touchegg_backend_make_gesture (_data52_->type, _data52_->direction, _data52_->fingers, _data52_->performed_on_device_type);
	_tmp1_ = _tmp0_;
	g_signal_emit_by_name ((GalaGestureBackend*) self, "on-gesture-detected", _tmp1_, (guint32) META_CURRENT_TIME, &_tmp2_);
	_gala_gesture_unref0 (_tmp1_);
	g_signal_emit_by_name ((GalaGestureBackend*) self, "on-begin", _data52_->delta, _data52_->elapsed_time);
	result = FALSE;
	return result;
}

static gboolean
____lambda5__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda5_ (self);
	return result;
}

static gboolean
___lambda6_ (Block52Data* _data52_)
{
	GalaToucheggBackend* self;
	gboolean result;
	self = _data52_->self;
	g_signal_emit_by_name ((GalaGestureBackend*) self, "on-update", _data52_->delta, _data52_->elapsed_time);
	result = FALSE;
	return result;
}

static gboolean
____lambda6__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda6_ (self);
	return result;
}

static gboolean
___lambda7_ (Block52Data* _data52_)
{
	GalaToucheggBackend* self;
	gboolean result;
	self = _data52_->self;
	g_signal_emit_by_name ((GalaGestureBackend*) self, "on-end", _data52_->delta, _data52_->elapsed_time);
	result = FALSE;
	return result;
}

static gboolean
____lambda7__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda7_ (self);
	return result;
}

static void
gala_touchegg_backend_emit_event (GalaToucheggBackend* self,
                                  const gchar* signal_name,
                                  GVariant* signal_params)
{
	Block52Data* _data52_;
	gdouble percentage = 0.0;
	GalaToucheggBackendGestureType _tmp0_ = 0;
	GalaGestureDirection _tmp1_ = 0;
	gdouble _tmp2_ = 0.0;
	gint _tmp3_ = 0;
	GalaToucheggBackendDeviceType _tmp4_ = 0;
	guint64 _tmp5_ = 0ULL;
	const gchar* _tmp6_;
	GQuark _tmp8_ = 0U;
	static GQuark _tmp7_label0 = 0;
	static GQuark _tmp7_label1 = 0;
	static GQuark _tmp7_label2 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (signal_name != NULL);
	g_return_if_fail (signal_params != NULL);
	_data52_ = g_slice_new0 (Block52Data);
	_data52_->_ref_count_ = 1;
	_data52_->self = g_object_ref (self);
	g_variant_get (signal_params, "(uudiut)", &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, NULL);
	_data52_->type = _tmp0_;
	_data52_->direction = _tmp1_;
	percentage = _tmp2_;
	_data52_->fingers = _tmp3_;
	_data52_->performed_on_device_type = _tmp4_;
	_data52_->elapsed_time = _tmp5_;
	_data52_->delta = percentage * GALA_TOUCHEGG_BACKEND_DELTA_MULTIPLIER;
	_tmp6_ = signal_name;
	_tmp8_ = (NULL == _tmp6_) ? 0 : g_quark_from_string (_tmp6_);
	if (_tmp8_ == ((0 != _tmp7_label0) ? _tmp7_label0 : (_tmp7_label0 = g_quark_from_static_string (GALA_TOUCHEGG_BACKEND_DBUS_ON_GESTURE_BEGIN)))) {
		switch (0) {
			default:
			{
				g_idle_add_full (G_PRIORITY_DEFAULT, ____lambda5__gsource_func, block52_data_ref (_data52_), block52_data_unref);
				break;
			}
		}
	} else if (_tmp8_ == ((0 != _tmp7_label1) ? _tmp7_label1 : (_tmp7_label1 = g_quark_from_static_string (GALA_TOUCHEGG_BACKEND_DBUS_ON_GESTURE_UPDATE)))) {
		switch (0) {
			default:
			{
				g_idle_add_full (G_PRIORITY_DEFAULT, ____lambda6__gsource_func, block52_data_ref (_data52_), block52_data_unref);
				break;
			}
		}
	} else if (_tmp8_ == ((0 != _tmp7_label2) ? _tmp7_label2 : (_tmp7_label2 = g_quark_from_static_string (GALA_TOUCHEGG_BACKEND_DBUS_ON_GESTURE_END)))) {
		switch (0) {
			default:
			{
				g_idle_add_full (G_PRIORITY_DEFAULT, ____lambda7__gsource_func, block52_data_ref (_data52_), block52_data_unref);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	block52_data_unref (_data52_);
	_data52_ = NULL;
}

static GalaGesture*
gala_touchegg_backend_make_gesture (GalaToucheggBackendGestureType type,
                                    GalaGestureDirection direction,
                                    gint fingers,
                                    GalaToucheggBackendDeviceType performed_on_device_type)
{
	ClutterEventType event_type = 0;
	ClutterInputDeviceType input_source = 0;
	GalaGesture* _tmp0_ = NULL;
	GalaGesture* result;
	switch (type) {
		case GALA_TOUCHEGG_BACKEND_GESTURE_TYPE_SWIPE:
		{
			event_type = CLUTTER_TOUCHPAD_SWIPE;
			break;
		}
		case GALA_TOUCHEGG_BACKEND_GESTURE_TYPE_PINCH:
		{
			event_type = CLUTTER_TOUCHPAD_PINCH;
			break;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
	switch (performed_on_device_type) {
		case GALA_TOUCHEGG_BACKEND_DEVICE_TYPE_TOUCHPAD:
		{
			input_source = CLUTTER_TOUCHPAD_DEVICE;
			break;
		}
		case GALA_TOUCHEGG_BACKEND_DEVICE_TYPE_TOUCHSCREEN:
		{
			input_source = CLUTTER_TOUCHSCREEN_DEVICE;
			break;
		}
		default:
		{
			result = NULL;
			return result;
		}
	}
	_tmp0_ = gala_gesture_new ();
	_tmp0_->type = event_type;
	_tmp0_->direction = direction;
	_tmp0_->fingers = fingers;
	_tmp0_->performed_on_device_type = input_source;
	result = _tmp0_;
	return result;
}

GalaToucheggBackend*
gala_touchegg_backend_construct (GType object_type)
{
	GalaToucheggBackend * self = NULL;
	self = (GalaToucheggBackend*) g_object_new (object_type, NULL);
	return self;
}

GalaToucheggBackend*
gala_touchegg_backend_new (void)
{
	return gala_touchegg_backend_construct (GALA_TYPE_TOUCHEGG_BACKEND);
}

static void
gala_touchegg_backend_class_init (GalaToucheggBackendClass * klass,
                                  gpointer klass_data)
{
	gala_touchegg_backend_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaToucheggBackend_private_offset);
	G_OBJECT_CLASS (klass)->finalize = gala_touchegg_backend_finalize;
}

static void
gala_touchegg_backend_gala_gesture_backend_interface_init (GalaGestureBackendIface * iface,
                                                           gpointer iface_data)
{
	gala_touchegg_backend_gala_gesture_backend_parent_iface = g_type_interface_peek_parent (iface);
}

static void
gala_touchegg_backend_instance_init (GalaToucheggBackend * self,
                                     gpointer klass)
{
	self->priv = gala_touchegg_backend_get_instance_private (self);
	self->priv->connection = NULL;
	self->priv->reconnection_attempts = 0;
	self->priv->last_signal_received = NULL;
	self->priv->last_params_received = NULL;
}

static void
gala_touchegg_backend_finalize (GObject * obj)
{
	GalaToucheggBackend * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_TOUCHEGG_BACKEND, GalaToucheggBackend);
	_g_object_unref0 (self->priv->connection);
	_g_free0 (self->priv->last_signal_received);
	_g_variant_unref0 (self->priv->last_params_received);
	G_OBJECT_CLASS (gala_touchegg_backend_parent_class)->finalize (obj);
}

/**
 * Singleton class to manage the connection with Touchégg daemon and receive touch events.
 * See: [[https://github.com/JoseExposito/touchegg]]
 */
 G_GNUC_NO_INLINE static GType
gala_touchegg_backend_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaToucheggBackendClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_touchegg_backend_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaToucheggBackend), 0, (GInstanceInitFunc) gala_touchegg_backend_instance_init, NULL };
	static const GInterfaceInfo gala_gesture_backend_info = { (GInterfaceInitFunc) gala_touchegg_backend_gala_gesture_backend_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType gala_touchegg_backend_type_id;
	gala_touchegg_backend_type_id = g_type_register_static (G_TYPE_OBJECT, "GalaToucheggBackend", &g_define_type_info, 0);
	g_type_add_interface_static (gala_touchegg_backend_type_id, GALA_TYPE_GESTURE_BACKEND, &gala_gesture_backend_info);
	GalaToucheggBackend_private_offset = g_type_add_instance_private (gala_touchegg_backend_type_id, sizeof (GalaToucheggBackendPrivate));
	return gala_touchegg_backend_type_id;
}

GType
gala_touchegg_backend_get_type (void)
{
	static gsize gala_touchegg_backend_type_id__once = 0;
	if (g_once_init_enter (&gala_touchegg_backend_type_id__once)) {
		GType gala_touchegg_backend_type_id;
		gala_touchegg_backend_type_id = gala_touchegg_backend_get_type_once ();
		g_once_init_leave (&gala_touchegg_backend_type_id__once, gala_touchegg_backend_type_id);
	}
	return gala_touchegg_backend_type_id__once;
}

