/* WorkspaceInsertThumb.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from WorkspaceInsertThumb.vala, do not modify */

/*
 * Copyright 2014 Tom Beckmann
 * Copyright 2023 elementary, Inc. (https://elementary.io)
 * SPDX-License-Identifier: GPL-3.0-or-later
 */

#include <clutter/clutter.h>
#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include "gala.h"
#include <meta/window.h>
#include <meta/prefs.h>

#define GALA_WORKSPACE_INSERT_THUMB_EXPAND_DELAY 300
#define GALA_ICON_GROUP_CONTAINER_SPACING 48
#define GALA_ICON_GROUP_CONTAINER_GROUP_WIDTH 64
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define GALA_TYPE_WORKSPACE_INSERT_THUMB (gala_workspace_insert_thumb_get_type ())
#define GALA_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb))
#define GALA_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))
#define GALA_IS_WORKSPACE_INSERT_THUMB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_IS_WORKSPACE_INSERT_THUMB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GALA_TYPE_WORKSPACE_INSERT_THUMB))
#define GALA_WORKSPACE_INSERT_THUMB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumbClass))

typedef struct _GalaWorkspaceInsertThumb GalaWorkspaceInsertThumb;
typedef struct _GalaWorkspaceInsertThumbClass GalaWorkspaceInsertThumbClass;
typedef struct _GalaWorkspaceInsertThumbPrivate GalaWorkspaceInsertThumbPrivate;
enum  {
	GALA_WORKSPACE_INSERT_THUMB_0_PROPERTY,
	GALA_WORKSPACE_INSERT_THUMB_WORKSPACE_INDEX_PROPERTY,
	GALA_WORKSPACE_INSERT_THUMB_EXPANDED_PROPERTY,
	GALA_WORKSPACE_INSERT_THUMB_DELAY_PROPERTY,
	GALA_WORKSPACE_INSERT_THUMB_SCALE_FACTOR_PROPERTY,
	GALA_WORKSPACE_INSERT_THUMB_NUM_PROPERTIES
};
static GParamSpec* gala_workspace_insert_thumb_properties[GALA_WORKSPACE_INSERT_THUMB_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _GalaWorkspaceInsertThumb {
	ClutterActor parent_instance;
	GalaWorkspaceInsertThumbPrivate * priv;
};

struct _GalaWorkspaceInsertThumbClass {
	ClutterActorClass parent_class;
};

struct _GalaWorkspaceInsertThumbPrivate {
	gint _workspace_index;
	gboolean _expanded;
	gint _delay;
	gfloat _scale_factor;
	guint expand_timeout;
};

static gint GalaWorkspaceInsertThumb_private_offset;
static gpointer gala_workspace_insert_thumb_parent_class = NULL;

VALA_EXTERN GType gala_workspace_insert_thumb_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (GalaWorkspaceInsertThumb, g_object_unref)
VALA_EXTERN GalaWorkspaceInsertThumb* gala_workspace_insert_thumb_new (gint workspace_index,
                                                           gfloat scale);
VALA_EXTERN GalaWorkspaceInsertThumb* gala_workspace_insert_thumb_construct (GType object_type,
                                                                 gint workspace_index,
                                                                 gfloat scale);
static void gala_workspace_insert_thumb_reallocate (GalaWorkspaceInsertThumb* self);
static void __lambda74_ (GalaWorkspaceInsertThumb* self,
                  ClutterActor* target,
                  gboolean hovered);
static void gala_workspace_insert_thumb_transform (GalaWorkspaceInsertThumb* self,
                                            gboolean expand);
VALA_EXTERN gint gala_workspace_insert_thumb_get_delay (GalaWorkspaceInsertThumb* self);
static gboolean gala_workspace_insert_thumb_expand (GalaWorkspaceInsertThumb* self);
static gboolean _gala_workspace_insert_thumb_expand_gsource_func (gpointer self);
static void ___lambda74__gala_drag_drop_action_crossed (GalaDragDropAction* _sender,
                                                 ClutterActor* target,
                                                 gboolean hovered,
                                                 gpointer self);
VALA_EXTERN gfloat gala_workspace_insert_thumb_get_scale_factor (GalaWorkspaceInsertThumb* self);
VALA_EXTERN void gala_workspace_insert_thumb_set_window_thumb (GalaWorkspaceInsertThumb* self,
                                                   MetaWindow* window);
VALA_EXTERN void gala_workspace_insert_thumb_set_expanded (GalaWorkspaceInsertThumb* self,
                                               gboolean value);
static void gala_workspace_insert_thumb_add_pulse_animation (GalaWorkspaceInsertThumb* self);
VALA_EXTERN gint gala_workspace_insert_thumb_get_workspace_index (GalaWorkspaceInsertThumb* self);
VALA_EXTERN void gala_workspace_insert_thumb_set_workspace_index (GalaWorkspaceInsertThumb* self,
                                                      gint value);
VALA_EXTERN gboolean gala_workspace_insert_thumb_get_expanded (GalaWorkspaceInsertThumb* self);
VALA_EXTERN void gala_workspace_insert_thumb_set_delay (GalaWorkspaceInsertThumb* self,
                                            gint value);
VALA_EXTERN void gala_workspace_insert_thumb_set_scale_factor (GalaWorkspaceInsertThumb* self,
                                                   gfloat value);
static void gala_workspace_insert_thumb_finalize (GObject * obj);
static GType gala_workspace_insert_thumb_get_type_once (void);
static void _vala_gala_workspace_insert_thumb_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_gala_workspace_insert_thumb_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);

static inline gpointer
gala_workspace_insert_thumb_get_instance_private (GalaWorkspaceInsertThumb* self)
{
	return G_STRUCT_MEMBER_P (self, GalaWorkspaceInsertThumb_private_offset);
}

static gboolean
_gala_workspace_insert_thumb_expand_gsource_func (gpointer self)
{
	gboolean result;
	result = gala_workspace_insert_thumb_expand ((GalaWorkspaceInsertThumb*) self);
	return result;
}

static void
__lambda74_ (GalaWorkspaceInsertThumb* self,
             ClutterActor* target,
             gboolean hovered)
{
	if (!hovered) {
		if (self->priv->expand_timeout != ((guint) 0)) {
			g_source_remove (self->priv->expand_timeout);
			self->priv->expand_timeout = (guint) 0;
		}
		gala_workspace_insert_thumb_transform (self, FALSE);
	} else {
		gint _tmp0_;
		_tmp0_ = self->priv->_delay;
		self->priv->expand_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp0_, _gala_workspace_insert_thumb_expand_gsource_func, g_object_ref (self), g_object_unref);
	}
}

static void
___lambda74__gala_drag_drop_action_crossed (GalaDragDropAction* _sender,
                                            ClutterActor* target,
                                            gboolean hovered,
                                            gpointer self)
{
	__lambda74_ ((GalaWorkspaceInsertThumb*) self, target, hovered);
}

GalaWorkspaceInsertThumb*
gala_workspace_insert_thumb_construct (GType object_type,
                                       gint workspace_index,
                                       gfloat scale)
{
	GalaWorkspaceInsertThumb * self = NULL;
	GalaDragDropAction* drop = NULL;
	GalaDragDropAction* _tmp0_;
	self = (GalaWorkspaceInsertThumb*) g_object_new (object_type, "workspace-index", workspace_index, "scale-factor", scale, NULL);
	gala_workspace_insert_thumb_reallocate (self);
	clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
	clutter_actor_set_pivot_point ((ClutterActor*) self, 0.5f, 0.5f);
	clutter_actor_set_reactive ((ClutterActor*) self, TRUE);
	clutter_actor_set_x_align ((ClutterActor*) self, CLUTTER_ACTOR_ALIGN_CENTER);
	_tmp0_ = gala_drag_drop_action_new (GALA_DRAG_DROP_ACTION_TYPE_DESTINATION, "multitaskingview-window");
	g_object_ref_sink (_tmp0_);
	drop = _tmp0_;
	g_signal_connect_object (drop, "crossed", (GCallback) ___lambda74__gala_drag_drop_action_crossed, self, 0);
	clutter_actor_add_action ((ClutterActor*) self, (ClutterAction*) drop);
	_g_object_unref0 (drop);
	return self;
}

GalaWorkspaceInsertThumb*
gala_workspace_insert_thumb_new (gint workspace_index,
                                 gfloat scale)
{
	return gala_workspace_insert_thumb_construct (GALA_TYPE_WORKSPACE_INSERT_THUMB, workspace_index, scale);
}

static void
gala_workspace_insert_thumb_reallocate (GalaWorkspaceInsertThumb* self)
{
	gfloat _tmp0_;
	gfloat _tmp1_;
	gfloat _tmp2_;
	gfloat _tmp3_;
	gfloat _tmp4_;
	gfloat _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gala_workspace_insert_thumb_get_scale_factor (self);
	_tmp1_ = _tmp0_;
	clutter_actor_set_width ((ClutterActor*) self, (gfloat) gala_utils_scale_to_int (GALA_ICON_GROUP_CONTAINER_SPACING, _tmp1_));
	_tmp2_ = gala_workspace_insert_thumb_get_scale_factor (self);
	_tmp3_ = _tmp2_;
	clutter_actor_set_height ((ClutterActor*) self, (gfloat) gala_utils_scale_to_int (GALA_ICON_GROUP_CONTAINER_GROUP_WIDTH, _tmp3_));
	_tmp4_ = gala_workspace_insert_thumb_get_scale_factor (self);
	_tmp5_ = _tmp4_;
	clutter_actor_set_y ((ClutterActor*) self, (gfloat) (gala_utils_scale_to_int (GALA_ICON_GROUP_CONTAINER_GROUP_WIDTH - GALA_ICON_GROUP_CONTAINER_SPACING, _tmp5_) / 2));
}

void
gala_workspace_insert_thumb_set_window_thumb (GalaWorkspaceInsertThumb* self,
                                              MetaWindow* window)
{
	GalaWindowIcon* icon = NULL;
	gfloat _tmp0_;
	gfloat _tmp1_;
	GalaWindowIcon* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (window != NULL);
	clutter_actor_destroy_all_children ((ClutterActor*) self);
	_tmp0_ = gala_workspace_insert_thumb_get_scale_factor (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gala_window_icon_new (window, GALA_ICON_GROUP_CONTAINER_GROUP_WIDTH, (gint) round ((gdouble) _tmp1_));
	clutter_actor_set_x ((ClutterActor*) _tmp2_, (gfloat) GALA_ICON_GROUP_CONTAINER_SPACING);
	clutter_actor_set_x_align ((ClutterActor*) _tmp2_, CLUTTER_ACTOR_ALIGN_CENTER);
	g_object_ref_sink (_tmp2_);
	icon = _tmp2_;
	clutter_actor_add_child ((ClutterActor*) self, (ClutterActor*) icon);
	_g_object_unref0 (icon);
}

static gboolean
gala_workspace_insert_thumb_expand (GalaWorkspaceInsertThumb* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	self->priv->expand_timeout = (guint) 0;
	gala_workspace_insert_thumb_transform (self, TRUE);
	result = G_SOURCE_REMOVE;
	return result;
}

static void
gala_workspace_insert_thumb_transform (GalaWorkspaceInsertThumb* self,
                                       gboolean expand)
{
	g_return_if_fail (self != NULL);
	clutter_actor_save_easing_state ((ClutterActor*) self);
	clutter_actor_set_easing_mode ((ClutterActor*) self, CLUTTER_EASE_OUT_QUAD);
	clutter_actor_set_easing_duration ((ClutterActor*) self, gala_utils_get_animation_duration ((guint) 200));
	if (!expand) {
		gfloat _tmp0_;
		gfloat _tmp1_;
		clutter_actor_remove_transition ((ClutterActor*) self, "pulse");
		clutter_actor_set_opacity ((ClutterActor*) self, (guint) 0);
		_tmp0_ = gala_workspace_insert_thumb_get_scale_factor (self);
		_tmp1_ = _tmp0_;
		clutter_actor_set_width ((ClutterActor*) self, (gfloat) gala_utils_scale_to_int (GALA_ICON_GROUP_CONTAINER_SPACING, _tmp1_));
		gala_workspace_insert_thumb_set_expanded (self, FALSE);
	} else {
		gfloat _tmp2_;
		gfloat _tmp3_;
		gala_workspace_insert_thumb_add_pulse_animation (self);
		clutter_actor_set_opacity ((ClutterActor*) self, (guint) 200);
		_tmp2_ = gala_workspace_insert_thumb_get_scale_factor (self);
		_tmp3_ = _tmp2_;
		clutter_actor_set_width ((ClutterActor*) self, (gfloat) gala_utils_scale_to_int (GALA_ICON_GROUP_CONTAINER_GROUP_WIDTH + (GALA_ICON_GROUP_CONTAINER_SPACING * 2), _tmp3_));
		gala_workspace_insert_thumb_set_expanded (self, TRUE);
	}
	clutter_actor_restore_easing_state ((ClutterActor*) self);
}

static void
gala_workspace_insert_thumb_add_pulse_animation (GalaWorkspaceInsertThumb* self)
{
	ClutterTransitionGroup* transition = NULL;
	ClutterTransitionGroup* _tmp0_ = NULL;
	ClutterPropertyTransition* scale_x_transition = NULL;
	ClutterPropertyTransition* _tmp1_;
	ClutterPropertyTransition* _tmp2_;
	GValue _tmp3_ = {0};
	ClutterPropertyTransition* _tmp4_;
	GValue _tmp5_ = {0};
	ClutterPropertyTransition* _tmp6_;
	ClutterPropertyTransition* scale_y_transition = NULL;
	ClutterPropertyTransition* _tmp7_;
	ClutterPropertyTransition* _tmp8_;
	GValue _tmp9_ = {0};
	ClutterPropertyTransition* _tmp10_;
	GValue _tmp11_ = {0};
	ClutterPropertyTransition* _tmp12_;
	ClutterTransitionGroup* _tmp13_;
	ClutterPropertyTransition* _tmp14_;
	ClutterTransitionGroup* _tmp15_;
	ClutterPropertyTransition* _tmp16_;
	ClutterTransitionGroup* _tmp17_;
	g_return_if_fail (self != NULL);
	if (!meta_prefs_get_gnome_animations ()) {
		return;
	}
	_tmp0_ = (ClutterTransitionGroup*) clutter_transition_group_new ();
	clutter_timeline_set_duration ((ClutterTimeline*) _tmp0_, (guint) 800);
	clutter_timeline_set_auto_reverse ((ClutterTimeline*) _tmp0_, TRUE);
	clutter_timeline_set_repeat_count ((ClutterTimeline*) _tmp0_, -1);
	clutter_timeline_set_progress_mode ((ClutterTimeline*) _tmp0_, CLUTTER_LINEAR);
	transition = _tmp0_;
	_tmp1_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-x");
	scale_x_transition = _tmp1_;
	_tmp2_ = scale_x_transition;
	g_value_init (&_tmp3_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp3_, 0.8);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp2_, &_tmp3_);
	G_IS_VALUE (&_tmp3_) ? (g_value_unset (&_tmp3_), NULL) : NULL;
	_tmp4_ = scale_x_transition;
	g_value_init (&_tmp5_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp5_, 1.1);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp4_, &_tmp5_);
	G_IS_VALUE (&_tmp5_) ? (g_value_unset (&_tmp5_), NULL) : NULL;
	_tmp6_ = scale_x_transition;
	clutter_timeline_set_auto_reverse ((ClutterTimeline*) _tmp6_, TRUE);
	_tmp7_ = (ClutterPropertyTransition*) clutter_property_transition_new ("scale-y");
	scale_y_transition = _tmp7_;
	_tmp8_ = scale_y_transition;
	g_value_init (&_tmp9_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp9_, 0.8);
	clutter_transition_set_from_value ((ClutterTransition*) _tmp8_, &_tmp9_);
	G_IS_VALUE (&_tmp9_) ? (g_value_unset (&_tmp9_), NULL) : NULL;
	_tmp10_ = scale_y_transition;
	g_value_init (&_tmp11_, G_TYPE_DOUBLE);
	g_value_set_double (&_tmp11_, 1.1);
	clutter_transition_set_to_value ((ClutterTransition*) _tmp10_, &_tmp11_);
	G_IS_VALUE (&_tmp11_) ? (g_value_unset (&_tmp11_), NULL) : NULL;
	_tmp12_ = scale_y_transition;
	clutter_timeline_set_auto_reverse ((ClutterTimeline*) _tmp12_, TRUE);
	_tmp13_ = transition;
	_tmp14_ = scale_x_transition;
	clutter_transition_group_add_transition (_tmp13_, (ClutterTransition*) _tmp14_);
	_tmp15_ = transition;
	_tmp16_ = scale_y_transition;
	clutter_transition_group_add_transition (_tmp15_, (ClutterTransition*) _tmp16_);
	_tmp17_ = transition;
	clutter_actor_add_transition ((ClutterActor*) self, "pulse", (ClutterTransition*) _tmp17_);
	_g_object_unref0 (scale_y_transition);
	_g_object_unref0 (scale_x_transition);
	_g_object_unref0 (transition);
}

gint
gala_workspace_insert_thumb_get_workspace_index (GalaWorkspaceInsertThumb* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_workspace_index;
	return result;
}

void
gala_workspace_insert_thumb_set_workspace_index (GalaWorkspaceInsertThumb* self,
                                                 gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_insert_thumb_get_workspace_index (self);
	if (old_value != value) {
		self->priv->_workspace_index = value;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_insert_thumb_properties[GALA_WORKSPACE_INSERT_THUMB_WORKSPACE_INDEX_PROPERTY]);
	}
}

gboolean
gala_workspace_insert_thumb_get_expanded (GalaWorkspaceInsertThumb* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_expanded;
	return result;
}

void
gala_workspace_insert_thumb_set_expanded (GalaWorkspaceInsertThumb* self,
                                          gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_insert_thumb_get_expanded (self);
	if (old_value != value) {
		self->priv->_expanded = value;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_insert_thumb_properties[GALA_WORKSPACE_INSERT_THUMB_EXPANDED_PROPERTY]);
	}
}

gint
gala_workspace_insert_thumb_get_delay (GalaWorkspaceInsertThumb* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_delay;
	return result;
}

void
gala_workspace_insert_thumb_set_delay (GalaWorkspaceInsertThumb* self,
                                       gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = gala_workspace_insert_thumb_get_delay (self);
	if (old_value != value) {
		self->priv->_delay = value;
		g_object_notify_by_pspec ((GObject *) self, gala_workspace_insert_thumb_properties[GALA_WORKSPACE_INSERT_THUMB_DELAY_PROPERTY]);
	}
}

gfloat
gala_workspace_insert_thumb_get_scale_factor (GalaWorkspaceInsertThumb* self)
{
	gfloat result;
	g_return_val_if_fail (self != NULL, 0.0F);
	result = self->priv->_scale_factor;
	return result;
}

void
gala_workspace_insert_thumb_set_scale_factor (GalaWorkspaceInsertThumb* self,
                                              gfloat value)
{
	g_return_if_fail (self != NULL);
	if (value != self->priv->_scale_factor) {
		self->priv->_scale_factor = value;
		gala_workspace_insert_thumb_reallocate (self);
	}
	g_object_notify_by_pspec ((GObject *) self, gala_workspace_insert_thumb_properties[GALA_WORKSPACE_INSERT_THUMB_SCALE_FACTOR_PROPERTY]);
}

static void
gala_workspace_insert_thumb_class_init (GalaWorkspaceInsertThumbClass * klass,
                                        gpointer klass_data)
{
	gala_workspace_insert_thumb_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GalaWorkspaceInsertThumb_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_gala_workspace_insert_thumb_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gala_workspace_insert_thumb_set_property;
	G_OBJECT_CLASS (klass)->finalize = gala_workspace_insert_thumb_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_INSERT_THUMB_WORKSPACE_INDEX_PROPERTY, gala_workspace_insert_thumb_properties[GALA_WORKSPACE_INSERT_THUMB_WORKSPACE_INDEX_PROPERTY] = g_param_spec_int ("workspace-index", "workspace-index", "workspace-index", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_INSERT_THUMB_EXPANDED_PROPERTY, gala_workspace_insert_thumb_properties[GALA_WORKSPACE_INSERT_THUMB_EXPANDED_PROPERTY] = g_param_spec_boolean ("expanded", "expanded", "expanded", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_INSERT_THUMB_DELAY_PROPERTY, gala_workspace_insert_thumb_properties[GALA_WORKSPACE_INSERT_THUMB_DELAY_PROPERTY] = g_param_spec_int ("delay", "delay", "delay", G_MININT, G_MAXINT, GALA_WORKSPACE_INSERT_THUMB_EXPAND_DELAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GALA_WORKSPACE_INSERT_THUMB_SCALE_FACTOR_PROPERTY, gala_workspace_insert_thumb_properties[GALA_WORKSPACE_INSERT_THUMB_SCALE_FACTOR_PROPERTY] = g_param_spec_float ("scale-factor", "scale-factor", "scale-factor", -G_MAXFLOAT, G_MAXFLOAT, 0.0F, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
}

static void
gala_workspace_insert_thumb_instance_init (GalaWorkspaceInsertThumb * self,
                                           gpointer klass)
{
	self->priv = gala_workspace_insert_thumb_get_instance_private (self);
	self->priv->_expanded = FALSE;
	self->priv->_delay = GALA_WORKSPACE_INSERT_THUMB_EXPAND_DELAY;
	self->priv->_scale_factor = 1.0f;
	self->priv->expand_timeout = (guint) 0;
}

static void
gala_workspace_insert_thumb_finalize (GObject * obj)
{
	GalaWorkspaceInsertThumb * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb);
	G_OBJECT_CLASS (gala_workspace_insert_thumb_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gala_workspace_insert_thumb_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GalaWorkspaceInsertThumbClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gala_workspace_insert_thumb_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GalaWorkspaceInsertThumb), 0, (GInstanceInitFunc) gala_workspace_insert_thumb_instance_init, NULL };
	GType gala_workspace_insert_thumb_type_id;
	gala_workspace_insert_thumb_type_id = g_type_register_static (clutter_actor_get_type (), "GalaWorkspaceInsertThumb", &g_define_type_info, 0);
	GalaWorkspaceInsertThumb_private_offset = g_type_add_instance_private (gala_workspace_insert_thumb_type_id, sizeof (GalaWorkspaceInsertThumbPrivate));
	return gala_workspace_insert_thumb_type_id;
}

GType
gala_workspace_insert_thumb_get_type (void)
{
	static gsize gala_workspace_insert_thumb_type_id__once = 0;
	if (g_once_init_enter (&gala_workspace_insert_thumb_type_id__once)) {
		GType gala_workspace_insert_thumb_type_id;
		gala_workspace_insert_thumb_type_id = gala_workspace_insert_thumb_get_type_once ();
		g_once_init_leave (&gala_workspace_insert_thumb_type_id__once, gala_workspace_insert_thumb_type_id);
	}
	return gala_workspace_insert_thumb_type_id__once;
}

static void
_vala_gala_workspace_insert_thumb_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GalaWorkspaceInsertThumb * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb);
	switch (property_id) {
		case GALA_WORKSPACE_INSERT_THUMB_WORKSPACE_INDEX_PROPERTY:
		g_value_set_int (value, gala_workspace_insert_thumb_get_workspace_index (self));
		break;
		case GALA_WORKSPACE_INSERT_THUMB_EXPANDED_PROPERTY:
		g_value_set_boolean (value, gala_workspace_insert_thumb_get_expanded (self));
		break;
		case GALA_WORKSPACE_INSERT_THUMB_DELAY_PROPERTY:
		g_value_set_int (value, gala_workspace_insert_thumb_get_delay (self));
		break;
		case GALA_WORKSPACE_INSERT_THUMB_SCALE_FACTOR_PROPERTY:
		g_value_set_float (value, gala_workspace_insert_thumb_get_scale_factor (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_gala_workspace_insert_thumb_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GalaWorkspaceInsertThumb * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GALA_TYPE_WORKSPACE_INSERT_THUMB, GalaWorkspaceInsertThumb);
	switch (property_id) {
		case GALA_WORKSPACE_INSERT_THUMB_WORKSPACE_INDEX_PROPERTY:
		gala_workspace_insert_thumb_set_workspace_index (self, g_value_get_int (value));
		break;
		case GALA_WORKSPACE_INSERT_THUMB_EXPANDED_PROPERTY:
		gala_workspace_insert_thumb_set_expanded (self, g_value_get_boolean (value));
		break;
		case GALA_WORKSPACE_INSERT_THUMB_DELAY_PROPERTY:
		gala_workspace_insert_thumb_set_delay (self, g_value_get_int (value));
		break;
		case GALA_WORKSPACE_INSERT_THUMB_SCALE_FACTOR_PROPERTY:
		gala_workspace_insert_thumb_set_scale_factor (self, g_value_get_float (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

