// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_reserved_marshaling
//
// (impl) generated by codegen/vulkan/vulkan-docs/scripts/genvk.py -registry
// codegen/vulkan/vulkan-docs/xml/vk.xml -registryGfxstream
// codegen/vulkan/vulkan-docs/xml/vk_gfxstream.xml cereal -o host/vulkan/cereal
//
// Please do not modify directly;
// re-run gfxstream-protocols/scripts/generate-vulkan-sources.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o
// $CEREAL_OUTPUT_DIR
//

#include "goldfish_vk_reserved_marshaling.h"

#include <string.h>

#include "goldfish_vk_extension_structs.h"
#include "goldfish_vk_private_defs.h"

namespace gfxstream {
namespace vk {

void reservedmarshal_extension_struct(VulkanStream* vkStream, VkStructureType rootType,
                                      const void* structExtension, uint8_t** ptr);

void reservedunmarshal_extension_struct(VulkanStream* vkStream, VkStructureType rootType,
                                        void* structExtension_out, uint8_t** ptr);

#ifdef VK_VERSION_1_0
void reservedunmarshal_VkExtent2D(VulkanStream* vkStream, VkStructureType rootType,
                                  VkExtent2D* forUnmarshaling, uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->width, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->height, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkExtent3D(VulkanStream* vkStream, VkStructureType rootType,
                                  VkExtent3D* forUnmarshaling, uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->width, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->height, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->depth, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkOffset2D(VulkanStream* vkStream, VkStructureType rootType,
                                  VkOffset2D* forUnmarshaling, uint8_t** ptr) {
    memcpy((int32_t*)&forUnmarshaling->x, *ptr, sizeof(int32_t));
    *ptr += sizeof(int32_t);
    memcpy((int32_t*)&forUnmarshaling->y, *ptr, sizeof(int32_t));
    *ptr += sizeof(int32_t);
}

void reservedunmarshal_VkOffset3D(VulkanStream* vkStream, VkStructureType rootType,
                                  VkOffset3D* forUnmarshaling, uint8_t** ptr) {
    memcpy((int32_t*)&forUnmarshaling->x, *ptr, sizeof(int32_t));
    *ptr += sizeof(int32_t);
    memcpy((int32_t*)&forUnmarshaling->y, *ptr, sizeof(int32_t));
    *ptr += sizeof(int32_t);
    memcpy((int32_t*)&forUnmarshaling->z, *ptr, sizeof(int32_t));
    *ptr += sizeof(int32_t);
}

void reservedunmarshal_VkRect2D(VulkanStream* vkStream, VkStructureType rootType,
                                VkRect2D* forUnmarshaling, uint8_t** ptr) {
    reservedunmarshal_VkOffset2D(vkStream, rootType, (VkOffset2D*)(&forUnmarshaling->offset), ptr);
    reservedunmarshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forUnmarshaling->extent), ptr);
}

void reservedunmarshal_VkBaseInStructure(VulkanStream* vkStream, VkStructureType rootType,
                                         VkBaseInStructure* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((VkBaseInStructure*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
}

void reservedunmarshal_VkBaseOutStructure(VulkanStream* vkStream, VkStructureType rootType,
                                          VkBaseOutStructure* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((VkBaseOutStructure*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
}

void reservedunmarshal_VkBufferMemoryBarrier(VulkanStream* vkStream, VkStructureType rootType,
                                             VkBufferMemoryBarrier* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkAccessFlags*)&forUnmarshaling->srcAccessMask, *ptr, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy((VkAccessFlags*)&forUnmarshaling->dstAccessMask, *ptr, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy((uint32_t*)&forUnmarshaling->srcQueueFamilyIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->dstQueueFamilyIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkBuffer*)&forUnmarshaling->buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
    memcpy((VkDeviceSize*)&forUnmarshaling->offset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->size, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkDispatchIndirectCommand(VulkanStream* vkStream, VkStructureType rootType,
                                                 VkDispatchIndirectCommand* forUnmarshaling,
                                                 uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->x, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->y, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->z, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkDrawIndexedIndirectCommand(VulkanStream* vkStream,
                                                    VkStructureType rootType,
                                                    VkDrawIndexedIndirectCommand* forUnmarshaling,
                                                    uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->indexCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->instanceCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->firstIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((int32_t*)&forUnmarshaling->vertexOffset, *ptr, sizeof(int32_t));
    *ptr += sizeof(int32_t);
    memcpy((uint32_t*)&forUnmarshaling->firstInstance, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkDrawIndirectCommand(VulkanStream* vkStream, VkStructureType rootType,
                                             VkDrawIndirectCommand* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->vertexCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->instanceCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->firstVertex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->firstInstance, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkImageSubresourceRange(VulkanStream* vkStream, VkStructureType rootType,
                                               VkImageSubresourceRange* forUnmarshaling,
                                               uint8_t** ptr) {
    memcpy((VkImageAspectFlags*)&forUnmarshaling->aspectMask, *ptr, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
    memcpy((uint32_t*)&forUnmarshaling->baseMipLevel, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->levelCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->baseArrayLayer, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->layerCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkImageMemoryBarrier(VulkanStream* vkStream, VkStructureType rootType,
                                            VkImageMemoryBarrier* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkAccessFlags*)&forUnmarshaling->srcAccessMask, *ptr, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy((VkAccessFlags*)&forUnmarshaling->dstAccessMask, *ptr, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy((VkImageLayout*)&forUnmarshaling->oldLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((VkImageLayout*)&forUnmarshaling->newLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((uint32_t*)&forUnmarshaling->srcQueueFamilyIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->dstQueueFamilyIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->image = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
    reservedunmarshal_VkImageSubresourceRange(
        vkStream, rootType, (VkImageSubresourceRange*)(&forUnmarshaling->subresourceRange), ptr);
}

void reservedunmarshal_VkMemoryBarrier(VulkanStream* vkStream, VkStructureType rootType,
                                       VkMemoryBarrier* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkAccessFlags*)&forUnmarshaling->srcAccessMask, *ptr, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy((VkAccessFlags*)&forUnmarshaling->dstAccessMask, *ptr, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
}

void reservedunmarshal_VkPipelineCacheHeaderVersionOne(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineCacheHeaderVersionOne* forUnmarshaling, uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->headerSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkPipelineCacheHeaderVersion*)&forUnmarshaling->headerVersion, *ptr,
           sizeof(VkPipelineCacheHeaderVersion));
    *ptr += sizeof(VkPipelineCacheHeaderVersion);
    memcpy((uint32_t*)&forUnmarshaling->vendorID, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->deviceID, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint8_t*)forUnmarshaling->pipelineCacheUUID, *ptr, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
}

void reservedunmarshal_VkAllocationCallbacks(VulkanStream* vkStream, VkStructureType rootType,
                                             VkAllocationCallbacks* forUnmarshaling,
                                             uint8_t** ptr) {
    // WARNING PTR CHECK
    memcpy((void**)&forUnmarshaling->pUserData, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pUserData);
    *ptr += 8;
    if (forUnmarshaling->pUserData) {
        vkStream->alloc((void**)&forUnmarshaling->pUserData, sizeof(uint8_t));
        memcpy((void*)forUnmarshaling->pUserData, *ptr, sizeof(uint8_t));
        *ptr += sizeof(uint8_t);
    }
    memcpy((PFN_vkAllocationFunction*)&forUnmarshaling->pfnAllocation, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pfnAllocation);
    *ptr += 8;
    memcpy((PFN_vkReallocationFunction*)&forUnmarshaling->pfnReallocation, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pfnReallocation);
    *ptr += 8;
    memcpy((PFN_vkFreeFunction*)&forUnmarshaling->pfnFree, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pfnFree);
    *ptr += 8;
    memcpy((PFN_vkInternalAllocationNotification*)&forUnmarshaling->pfnInternalAllocation, (*ptr),
           8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pfnInternalAllocation);
    *ptr += 8;
    memcpy((PFN_vkInternalFreeNotification*)&forUnmarshaling->pfnInternalFree, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pfnInternalFree);
    *ptr += 8;
}

void reservedunmarshal_VkApplicationInfo(VulkanStream* vkStream, VkStructureType rootType,
                                         VkApplicationInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT) {
        // WARNING PTR CHECK
        memcpy((char**)&forUnmarshaling->pApplicationName, (*ptr), 8);
        android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pApplicationName);
        *ptr += 8;
        if (forUnmarshaling->pApplicationName) {
            vkStream->loadStringInPlaceWithStreamPtr((char**)&forUnmarshaling->pApplicationName,
                                                     ptr);
        }
    } else {
        vkStream->loadStringInPlaceWithStreamPtr((char**)&forUnmarshaling->pApplicationName, ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->applicationVersion, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_NULL_OPTIONAL_STRINGS_BIT) {
        // WARNING PTR CHECK
        memcpy((char**)&forUnmarshaling->pEngineName, (*ptr), 8);
        android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pEngineName);
        *ptr += 8;
        if (forUnmarshaling->pEngineName) {
            vkStream->loadStringInPlaceWithStreamPtr((char**)&forUnmarshaling->pEngineName, ptr);
        }
    } else {
        vkStream->loadStringInPlaceWithStreamPtr((char**)&forUnmarshaling->pEngineName, ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->engineVersion, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->apiVersion, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkFormatProperties(VulkanStream* vkStream, VkStructureType rootType,
                                          VkFormatProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkFormatFeatureFlags*)&forUnmarshaling->linearTilingFeatures, *ptr,
           sizeof(VkFormatFeatureFlags));
    *ptr += sizeof(VkFormatFeatureFlags);
    memcpy((VkFormatFeatureFlags*)&forUnmarshaling->optimalTilingFeatures, *ptr,
           sizeof(VkFormatFeatureFlags));
    *ptr += sizeof(VkFormatFeatureFlags);
    memcpy((VkFormatFeatureFlags*)&forUnmarshaling->bufferFeatures, *ptr,
           sizeof(VkFormatFeatureFlags));
    *ptr += sizeof(VkFormatFeatureFlags);
}

void reservedunmarshal_VkImageFormatProperties(VulkanStream* vkStream, VkStructureType rootType,
                                               VkImageFormatProperties* forUnmarshaling,
                                               uint8_t** ptr) {
    reservedunmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->maxExtent),
                                 ptr);
    memcpy((uint32_t*)&forUnmarshaling->maxMipLevels, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxArrayLayers, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkSampleCountFlags*)&forUnmarshaling->sampleCounts, *ptr, sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy((VkDeviceSize*)&forUnmarshaling->maxResourceSize, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkInstanceCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                            VkInstanceCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkInstanceCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkInstanceCreateFlags));
    *ptr += sizeof(VkInstanceCreateFlags);
    // WARNING PTR CHECK
    memcpy((VkApplicationInfo**)&forUnmarshaling->pApplicationInfo, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pApplicationInfo);
    *ptr += 8;
    if (forUnmarshaling->pApplicationInfo) {
        vkStream->alloc((void**)&forUnmarshaling->pApplicationInfo,
                        sizeof(const VkApplicationInfo));
        reservedunmarshal_VkApplicationInfo(
            vkStream, rootType, (VkApplicationInfo*)(forUnmarshaling->pApplicationInfo), ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->enabledLayerCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->loadStringArrayInPlaceWithStreamPtr((char***)&forUnmarshaling->ppEnabledLayerNames,
                                                  ptr);
    memcpy((uint32_t*)&forUnmarshaling->enabledExtensionCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->loadStringArrayInPlaceWithStreamPtr(
        (char***)&forUnmarshaling->ppEnabledExtensionNames, ptr);
}

void reservedunmarshal_VkMemoryHeap(VulkanStream* vkStream, VkStructureType rootType,
                                    VkMemoryHeap* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkDeviceSize*)&forUnmarshaling->size, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkMemoryHeapFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkMemoryHeapFlags));
    *ptr += sizeof(VkMemoryHeapFlags);
}

void reservedunmarshal_VkMemoryType(VulkanStream* vkStream, VkStructureType rootType,
                                    VkMemoryType* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkMemoryPropertyFlags*)&forUnmarshaling->propertyFlags, *ptr,
           sizeof(VkMemoryPropertyFlags));
    *ptr += sizeof(VkMemoryPropertyFlags);
    memcpy((uint32_t*)&forUnmarshaling->heapIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkPhysicalDeviceFeatures(VulkanStream* vkStream, VkStructureType rootType,
                                                VkPhysicalDeviceFeatures* forUnmarshaling,
                                                uint8_t** ptr) {
    memcpy((VkBool32*)&forUnmarshaling->robustBufferAccess, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->fullDrawIndexUint32, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->imageCubeArray, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->independentBlend, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->geometryShader, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->tessellationShader, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->sampleRateShading, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->dualSrcBlend, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->logicOp, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->multiDrawIndirect, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->drawIndirectFirstInstance, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->depthClamp, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->depthBiasClamp, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->fillModeNonSolid, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->depthBounds, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->wideLines, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->largePoints, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->alphaToOne, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->multiViewport, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->samplerAnisotropy, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->textureCompressionETC2, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->textureCompressionASTC_LDR, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->textureCompressionBC, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->occlusionQueryPrecise, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->pipelineStatisticsQuery, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->vertexPipelineStoresAndAtomics, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->fragmentStoresAndAtomics, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderTessellationAndGeometryPointSize, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderImageGatherExtended, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageImageExtendedFormats, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageImageMultisample, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageImageReadWithoutFormat, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageImageWriteWithoutFormat, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderUniformBufferArrayDynamicIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderSampledImageArrayDynamicIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageBufferArrayDynamicIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageImageArrayDynamicIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderClipDistance, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderCullDistance, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderFloat64, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderInt64, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderInt16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderResourceResidency, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderResourceMinLod, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->sparseBinding, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->sparseResidencyBuffer, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->sparseResidencyImage2D, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->sparseResidencyImage3D, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->sparseResidency2Samples, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->sparseResidency4Samples, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->sparseResidency8Samples, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->sparseResidency16Samples, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->sparseResidencyAliased, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->variableMultisampleRate, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->inheritedQueries, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceLimits(VulkanStream* vkStream, VkStructureType rootType,
                                              VkPhysicalDeviceLimits* forUnmarshaling,
                                              uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->maxImageDimension1D, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxImageDimension2D, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxImageDimension3D, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxImageDimensionCube, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxImageArrayLayers, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTexelBufferElements, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxUniformBufferRange, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxStorageBufferRange, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPushConstantsSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxMemoryAllocationCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxSamplerAllocationCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkDeviceSize*)&forUnmarshaling->bufferImageGranularity, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->sparseAddressSpaceSize, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((uint32_t*)&forUnmarshaling->maxBoundDescriptorSets, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorSamplers, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUniformBuffers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorStorageBuffers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorSampledImages, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorStorageImages, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorInputAttachments, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageResources, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetSamplers, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUniformBuffers, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUniformBuffersDynamic, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetStorageBuffers, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetStorageBuffersDynamic, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetSampledImages, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetStorageImages, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetInputAttachments, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxVertexInputAttributes, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxVertexInputBindings, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxVertexInputAttributeOffset, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxVertexInputBindingStride, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxVertexOutputComponents, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTessellationGenerationLevel, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTessellationPatchSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTessellationControlPerVertexInputComponents, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTessellationControlPerVertexOutputComponents, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTessellationControlPerPatchOutputComponents, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTessellationControlTotalOutputComponents, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTessellationEvaluationInputComponents, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTessellationEvaluationOutputComponents, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxGeometryShaderInvocations, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxGeometryInputComponents, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxGeometryOutputComponents, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxGeometryOutputVertices, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxGeometryTotalOutputComponents, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxFragmentInputComponents, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxFragmentOutputAttachments, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxFragmentDualSrcAttachments, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxFragmentCombinedOutputResources, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxComputeSharedMemorySize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)forUnmarshaling->maxComputeWorkGroupCount, *ptr, 3 * sizeof(uint32_t));
    *ptr += 3 * sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxComputeWorkGroupInvocations, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)forUnmarshaling->maxComputeWorkGroupSize, *ptr, 3 * sizeof(uint32_t));
    *ptr += 3 * sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->subPixelPrecisionBits, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->subTexelPrecisionBits, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->mipmapPrecisionBits, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDrawIndexedIndexValue, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDrawIndirectCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((float*)&forUnmarshaling->maxSamplerLodBias, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((float*)&forUnmarshaling->maxSamplerAnisotropy, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((uint32_t*)&forUnmarshaling->maxViewports, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)forUnmarshaling->maxViewportDimensions, *ptr, 2 * sizeof(uint32_t));
    *ptr += 2 * sizeof(uint32_t);
    memcpy((float*)forUnmarshaling->viewportBoundsRange, *ptr, 2 * sizeof(float));
    *ptr += 2 * sizeof(float);
    memcpy((uint32_t*)&forUnmarshaling->viewportSubPixelBits, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((size_t*)&forUnmarshaling->minMemoryMapAlignment, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->minMemoryMapAlignment);
    *ptr += 8;
    memcpy((VkDeviceSize*)&forUnmarshaling->minTexelBufferOffsetAlignment, *ptr,
           sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->minUniformBufferOffsetAlignment, *ptr,
           sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->minStorageBufferOffsetAlignment, *ptr,
           sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((int32_t*)&forUnmarshaling->minTexelOffset, *ptr, sizeof(int32_t));
    *ptr += sizeof(int32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTexelOffset, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((int32_t*)&forUnmarshaling->minTexelGatherOffset, *ptr, sizeof(int32_t));
    *ptr += sizeof(int32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTexelGatherOffset, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((float*)&forUnmarshaling->minInterpolationOffset, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((float*)&forUnmarshaling->maxInterpolationOffset, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((uint32_t*)&forUnmarshaling->subPixelInterpolationOffsetBits, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxFramebufferWidth, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxFramebufferHeight, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxFramebufferLayers, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkSampleCountFlags*)&forUnmarshaling->framebufferColorSampleCounts, *ptr,
           sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy((VkSampleCountFlags*)&forUnmarshaling->framebufferDepthSampleCounts, *ptr,
           sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy((VkSampleCountFlags*)&forUnmarshaling->framebufferStencilSampleCounts, *ptr,
           sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy((VkSampleCountFlags*)&forUnmarshaling->framebufferNoAttachmentsSampleCounts, *ptr,
           sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy((uint32_t*)&forUnmarshaling->maxColorAttachments, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkSampleCountFlags*)&forUnmarshaling->sampledImageColorSampleCounts, *ptr,
           sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy((VkSampleCountFlags*)&forUnmarshaling->sampledImageIntegerSampleCounts, *ptr,
           sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy((VkSampleCountFlags*)&forUnmarshaling->sampledImageDepthSampleCounts, *ptr,
           sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy((VkSampleCountFlags*)&forUnmarshaling->sampledImageStencilSampleCounts, *ptr,
           sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy((VkSampleCountFlags*)&forUnmarshaling->storageImageSampleCounts, *ptr,
           sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
    memcpy((uint32_t*)&forUnmarshaling->maxSampleMaskWords, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkBool32*)&forUnmarshaling->timestampComputeAndGraphics, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((float*)&forUnmarshaling->timestampPeriod, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((uint32_t*)&forUnmarshaling->maxClipDistances, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxCullDistances, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxCombinedClipAndCullDistances, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->discreteQueuePriorities, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((float*)forUnmarshaling->pointSizeRange, *ptr, 2 * sizeof(float));
    *ptr += 2 * sizeof(float);
    memcpy((float*)forUnmarshaling->lineWidthRange, *ptr, 2 * sizeof(float));
    *ptr += 2 * sizeof(float);
    memcpy((float*)&forUnmarshaling->pointSizeGranularity, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((float*)&forUnmarshaling->lineWidthGranularity, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((VkBool32*)&forUnmarshaling->strictLines, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->standardSampleLocations, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkDeviceSize*)&forUnmarshaling->optimalBufferCopyOffsetAlignment, *ptr,
           sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->optimalBufferCopyRowPitchAlignment, *ptr,
           sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->nonCoherentAtomSize, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkPhysicalDeviceMemoryProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceMemoryProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->memoryTypeCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_TYPES; ++i) {
        reservedunmarshal_VkMemoryType(vkStream, rootType,
                                       (VkMemoryType*)(forUnmarshaling->memoryTypes + i), ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->memoryHeapCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    for (uint32_t i = 0; i < (uint32_t)VK_MAX_MEMORY_HEAPS; ++i) {
        reservedunmarshal_VkMemoryHeap(vkStream, rootType,
                                       (VkMemoryHeap*)(forUnmarshaling->memoryHeaps + i), ptr);
    }
}

void reservedunmarshal_VkPhysicalDeviceSparseProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceSparseProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkBool32*)&forUnmarshaling->residencyStandard2DBlockShape, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->residencyStandard2DMultisampleBlockShape, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->residencyStandard3DBlockShape, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->residencyAlignedMipSize, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->residencyNonResidentStrict, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceProperties(VulkanStream* vkStream, VkStructureType rootType,
                                                  VkPhysicalDeviceProperties* forUnmarshaling,
                                                  uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->apiVersion, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->driverVersion, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->vendorID, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->deviceID, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkPhysicalDeviceType*)&forUnmarshaling->deviceType, *ptr, sizeof(VkPhysicalDeviceType));
    *ptr += sizeof(VkPhysicalDeviceType);
    memcpy((char*)forUnmarshaling->deviceName, *ptr,
           VK_MAX_PHYSICAL_DEVICE_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_PHYSICAL_DEVICE_NAME_SIZE * sizeof(char);
    memcpy((uint8_t*)forUnmarshaling->pipelineCacheUUID, *ptr, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
    reservedunmarshal_VkPhysicalDeviceLimits(
        vkStream, rootType, (VkPhysicalDeviceLimits*)(&forUnmarshaling->limits), ptr);
    reservedunmarshal_VkPhysicalDeviceSparseProperties(
        vkStream, rootType, (VkPhysicalDeviceSparseProperties*)(&forUnmarshaling->sparseProperties),
        ptr);
}

void reservedunmarshal_VkQueueFamilyProperties(VulkanStream* vkStream, VkStructureType rootType,
                                               VkQueueFamilyProperties* forUnmarshaling,
                                               uint8_t** ptr) {
    memcpy((VkQueueFlags*)&forUnmarshaling->queueFlags, *ptr, sizeof(VkQueueFlags));
    *ptr += sizeof(VkQueueFlags);
    memcpy((uint32_t*)&forUnmarshaling->queueCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->timestampValidBits, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    reservedunmarshal_VkExtent3D(vkStream, rootType,
                                 (VkExtent3D*)(&forUnmarshaling->minImageTransferGranularity), ptr);
}

void reservedunmarshal_VkDeviceQueueCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                               VkDeviceQueueCreateInfo* forUnmarshaling,
                                               uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDeviceQueueCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkDeviceQueueCreateFlags));
    *ptr += sizeof(VkDeviceQueueCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->queueFamilyIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->queueCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pQueuePriorities,
                    forUnmarshaling->queueCount * sizeof(const float));
    memcpy((float*)forUnmarshaling->pQueuePriorities, *ptr,
           forUnmarshaling->queueCount * sizeof(const float));
    *ptr += forUnmarshaling->queueCount * sizeof(const float);
}

void reservedunmarshal_VkDeviceCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                          VkDeviceCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDeviceCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkDeviceCreateFlags));
    *ptr += sizeof(VkDeviceCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->queueCreateInfoCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pQueueCreateInfos,
                    forUnmarshaling->queueCreateInfoCount * sizeof(const VkDeviceQueueCreateInfo));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->queueCreateInfoCount; ++i) {
        reservedunmarshal_VkDeviceQueueCreateInfo(
            vkStream, rootType, (VkDeviceQueueCreateInfo*)(forUnmarshaling->pQueueCreateInfos + i),
            ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->enabledLayerCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->loadStringArrayInPlaceWithStreamPtr((char***)&forUnmarshaling->ppEnabledLayerNames,
                                                  ptr);
    memcpy((uint32_t*)&forUnmarshaling->enabledExtensionCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->loadStringArrayInPlaceWithStreamPtr(
        (char***)&forUnmarshaling->ppEnabledExtensionNames, ptr);
    // WARNING PTR CHECK
    memcpy((VkPhysicalDeviceFeatures**)&forUnmarshaling->pEnabledFeatures, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pEnabledFeatures);
    *ptr += 8;
    if (forUnmarshaling->pEnabledFeatures) {
        vkStream->alloc((void**)&forUnmarshaling->pEnabledFeatures,
                        sizeof(const VkPhysicalDeviceFeatures));
        reservedunmarshal_VkPhysicalDeviceFeatures(
            vkStream, rootType, (VkPhysicalDeviceFeatures*)(forUnmarshaling->pEnabledFeatures),
            ptr);
    }
}

void reservedunmarshal_VkExtensionProperties(VulkanStream* vkStream, VkStructureType rootType,
                                             VkExtensionProperties* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((char*)forUnmarshaling->extensionName, *ptr, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
    memcpy((uint32_t*)&forUnmarshaling->specVersion, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkLayerProperties(VulkanStream* vkStream, VkStructureType rootType,
                                         VkLayerProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((char*)forUnmarshaling->layerName, *ptr, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
    memcpy((uint32_t*)&forUnmarshaling->specVersion, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->implementationVersion, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((char*)forUnmarshaling->description, *ptr, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
}

void reservedunmarshal_VkSubmitInfo(VulkanStream* vkStream, VkStructureType rootType,
                                    VkSubmitInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->waitSemaphoreCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pWaitSemaphores,
                    forUnmarshaling->waitSemaphoreCount * sizeof(const VkSemaphore));
    if (forUnmarshaling->waitSemaphoreCount) {
        uint8_t* cgen_var_0_ptr = (uint8_t*)(*ptr);
        *ptr += 8 * forUnmarshaling->waitSemaphoreCount;
        if (forUnmarshaling) {
            for (uint32_t k = 0; k < forUnmarshaling->waitSemaphoreCount; ++k) {
                uint64_t tmpval;
                memcpy(&tmpval, cgen_var_0_ptr + k * 8, sizeof(uint64_t));
                *(((VkSemaphore*)forUnmarshaling->pWaitSemaphores) + k) =
                    (VkSemaphore)unbox_VkSemaphore((VkSemaphore)tmpval);
            }
        }
    }
    vkStream->alloc((void**)&forUnmarshaling->pWaitDstStageMask,
                    forUnmarshaling->waitSemaphoreCount * sizeof(const VkPipelineStageFlags));
    memcpy((VkPipelineStageFlags*)forUnmarshaling->pWaitDstStageMask, *ptr,
           forUnmarshaling->waitSemaphoreCount * sizeof(const VkPipelineStageFlags));
    *ptr += forUnmarshaling->waitSemaphoreCount * sizeof(const VkPipelineStageFlags);
    memcpy((uint32_t*)&forUnmarshaling->commandBufferCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pCommandBuffers,
                    forUnmarshaling->commandBufferCount * sizeof(const VkCommandBuffer));
    if (forUnmarshaling->commandBufferCount) {
        uint8_t* cgen_var_1_ptr = (uint8_t*)(*ptr);
        *ptr += 8 * forUnmarshaling->commandBufferCount;
        if (forUnmarshaling) {
            for (uint32_t k = 0; k < forUnmarshaling->commandBufferCount; ++k) {
                uint64_t tmpval;
                memcpy(&tmpval, cgen_var_1_ptr + k * 8, sizeof(uint64_t));
                *(((VkCommandBuffer*)forUnmarshaling->pCommandBuffers) + k) =
                    (VkCommandBuffer)unbox_VkCommandBuffer((VkCommandBuffer)tmpval);
            }
        }
    }
    memcpy((uint32_t*)&forUnmarshaling->signalSemaphoreCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pSignalSemaphores,
                    forUnmarshaling->signalSemaphoreCount * sizeof(const VkSemaphore));
    if (forUnmarshaling->signalSemaphoreCount) {
        uint8_t* cgen_var_2_ptr = (uint8_t*)(*ptr);
        *ptr += 8 * forUnmarshaling->signalSemaphoreCount;
        if (forUnmarshaling) {
            for (uint32_t k = 0; k < forUnmarshaling->signalSemaphoreCount; ++k) {
                uint64_t tmpval;
                memcpy(&tmpval, cgen_var_2_ptr + k * 8, sizeof(uint64_t));
                *(((VkSemaphore*)forUnmarshaling->pSignalSemaphores) + k) =
                    (VkSemaphore)unbox_VkSemaphore((VkSemaphore)tmpval);
            }
        }
    }
}

void reservedunmarshal_VkMappedMemoryRange(VulkanStream* vkStream, VkStructureType rootType,
                                           VkMappedMemoryRange* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkDeviceMemory*)&forUnmarshaling->memory =
        (VkDeviceMemory)unbox_VkDeviceMemory((VkDeviceMemory)(*&cgen_var_0));
    memcpy((VkDeviceSize*)&forUnmarshaling->offset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->size, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkMemoryAllocateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                            VkMemoryAllocateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDeviceSize*)&forUnmarshaling->allocationSize, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((uint32_t*)&forUnmarshaling->memoryTypeIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkMemoryRequirements(VulkanStream* vkStream, VkStructureType rootType,
                                            VkMemoryRequirements* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkDeviceSize*)&forUnmarshaling->size, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->alignment, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((uint32_t*)&forUnmarshaling->memoryTypeBits, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkSparseMemoryBind(VulkanStream* vkStream, VkStructureType rootType,
                                          VkSparseMemoryBind* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkDeviceSize*)&forUnmarshaling->resourceOffset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->size, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkDeviceMemory*)&forUnmarshaling->memory =
        (VkDeviceMemory)unbox_VkDeviceMemory((VkDeviceMemory)(*&cgen_var_0));
    memcpy((VkDeviceSize*)&forUnmarshaling->memoryOffset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkSparseMemoryBindFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkSparseMemoryBindFlags));
    *ptr += sizeof(VkSparseMemoryBindFlags);
}

void reservedunmarshal_VkSparseBufferMemoryBindInfo(VulkanStream* vkStream,
                                                    VkStructureType rootType,
                                                    VkSparseBufferMemoryBindInfo* forUnmarshaling,
                                                    uint8_t** ptr) {
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkBuffer*)&forUnmarshaling->buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
    memcpy((uint32_t*)&forUnmarshaling->bindCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pBinds,
                    forUnmarshaling->bindCount * sizeof(const VkSparseMemoryBind));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->bindCount; ++i) {
        reservedunmarshal_VkSparseMemoryBind(
            vkStream, rootType, (VkSparseMemoryBind*)(forUnmarshaling->pBinds + i), ptr);
    }
}

void reservedunmarshal_VkSparseImageOpaqueMemoryBindInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkSparseImageOpaqueMemoryBindInfo* forUnmarshaling, uint8_t** ptr) {
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->image = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
    memcpy((uint32_t*)&forUnmarshaling->bindCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pBinds,
                    forUnmarshaling->bindCount * sizeof(const VkSparseMemoryBind));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->bindCount; ++i) {
        reservedunmarshal_VkSparseMemoryBind(
            vkStream, rootType, (VkSparseMemoryBind*)(forUnmarshaling->pBinds + i), ptr);
    }
}

void reservedunmarshal_VkImageSubresource(VulkanStream* vkStream, VkStructureType rootType,
                                          VkImageSubresource* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkImageAspectFlags*)&forUnmarshaling->aspectMask, *ptr, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
    memcpy((uint32_t*)&forUnmarshaling->mipLevel, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->arrayLayer, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkSparseImageMemoryBind(VulkanStream* vkStream, VkStructureType rootType,
                                               VkSparseImageMemoryBind* forUnmarshaling,
                                               uint8_t** ptr) {
    reservedunmarshal_VkImageSubresource(vkStream, rootType,
                                         (VkImageSubresource*)(&forUnmarshaling->subresource), ptr);
    reservedunmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->offset), ptr);
    reservedunmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->extent), ptr);
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkDeviceMemory*)&forUnmarshaling->memory =
        (VkDeviceMemory)unbox_VkDeviceMemory((VkDeviceMemory)(*&cgen_var_0));
    memcpy((VkDeviceSize*)&forUnmarshaling->memoryOffset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkSparseMemoryBindFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkSparseMemoryBindFlags));
    *ptr += sizeof(VkSparseMemoryBindFlags);
}

void reservedunmarshal_VkSparseImageMemoryBindInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                   VkSparseImageMemoryBindInfo* forUnmarshaling,
                                                   uint8_t** ptr) {
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->image = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
    memcpy((uint32_t*)&forUnmarshaling->bindCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pBinds,
                    forUnmarshaling->bindCount * sizeof(const VkSparseImageMemoryBind));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->bindCount; ++i) {
        reservedunmarshal_VkSparseImageMemoryBind(
            vkStream, rootType, (VkSparseImageMemoryBind*)(forUnmarshaling->pBinds + i), ptr);
    }
}

void reservedunmarshal_VkBindSparseInfo(VulkanStream* vkStream, VkStructureType rootType,
                                        VkBindSparseInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->waitSemaphoreCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pWaitSemaphores,
                    forUnmarshaling->waitSemaphoreCount * sizeof(const VkSemaphore));
    if (forUnmarshaling->waitSemaphoreCount) {
        uint8_t* cgen_var_0_ptr = (uint8_t*)(*ptr);
        *ptr += 8 * forUnmarshaling->waitSemaphoreCount;
        if (forUnmarshaling) {
            for (uint32_t k = 0; k < forUnmarshaling->waitSemaphoreCount; ++k) {
                uint64_t tmpval;
                memcpy(&tmpval, cgen_var_0_ptr + k * 8, sizeof(uint64_t));
                *(((VkSemaphore*)forUnmarshaling->pWaitSemaphores) + k) =
                    (VkSemaphore)unbox_VkSemaphore((VkSemaphore)tmpval);
            }
        }
    }
    memcpy((uint32_t*)&forUnmarshaling->bufferBindCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pBufferBinds,
                    forUnmarshaling->bufferBindCount * sizeof(const VkSparseBufferMemoryBindInfo));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->bufferBindCount; ++i) {
        reservedunmarshal_VkSparseBufferMemoryBindInfo(
            vkStream, rootType, (VkSparseBufferMemoryBindInfo*)(forUnmarshaling->pBufferBinds + i),
            ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->imageOpaqueBindCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc(
        (void**)&forUnmarshaling->pImageOpaqueBinds,
        forUnmarshaling->imageOpaqueBindCount * sizeof(const VkSparseImageOpaqueMemoryBindInfo));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->imageOpaqueBindCount; ++i) {
        reservedunmarshal_VkSparseImageOpaqueMemoryBindInfo(
            vkStream, rootType,
            (VkSparseImageOpaqueMemoryBindInfo*)(forUnmarshaling->pImageOpaqueBinds + i), ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->imageBindCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pImageBinds,
                    forUnmarshaling->imageBindCount * sizeof(const VkSparseImageMemoryBindInfo));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->imageBindCount; ++i) {
        reservedunmarshal_VkSparseImageMemoryBindInfo(
            vkStream, rootType, (VkSparseImageMemoryBindInfo*)(forUnmarshaling->pImageBinds + i),
            ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->signalSemaphoreCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pSignalSemaphores,
                    forUnmarshaling->signalSemaphoreCount * sizeof(const VkSemaphore));
    if (forUnmarshaling->signalSemaphoreCount) {
        uint8_t* cgen_var_1_ptr = (uint8_t*)(*ptr);
        *ptr += 8 * forUnmarshaling->signalSemaphoreCount;
        if (forUnmarshaling) {
            for (uint32_t k = 0; k < forUnmarshaling->signalSemaphoreCount; ++k) {
                uint64_t tmpval;
                memcpy(&tmpval, cgen_var_1_ptr + k * 8, sizeof(uint64_t));
                *(((VkSemaphore*)forUnmarshaling->pSignalSemaphores) + k) =
                    (VkSemaphore)unbox_VkSemaphore((VkSemaphore)tmpval);
            }
        }
    }
}

void reservedunmarshal_VkSparseImageFormatProperties(VulkanStream* vkStream,
                                                     VkStructureType rootType,
                                                     VkSparseImageFormatProperties* forUnmarshaling,
                                                     uint8_t** ptr) {
    memcpy((VkImageAspectFlags*)&forUnmarshaling->aspectMask, *ptr, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
    reservedunmarshal_VkExtent3D(vkStream, rootType,
                                 (VkExtent3D*)(&forUnmarshaling->imageGranularity), ptr);
    memcpy((VkSparseImageFormatFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkSparseImageFormatFlags));
    *ptr += sizeof(VkSparseImageFormatFlags);
}

void reservedunmarshal_VkSparseImageMemoryRequirements(
    VulkanStream* vkStream, VkStructureType rootType,
    VkSparseImageMemoryRequirements* forUnmarshaling, uint8_t** ptr) {
    reservedunmarshal_VkSparseImageFormatProperties(
        vkStream, rootType, (VkSparseImageFormatProperties*)(&forUnmarshaling->formatProperties),
        ptr);
    memcpy((uint32_t*)&forUnmarshaling->imageMipTailFirstLod, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkDeviceSize*)&forUnmarshaling->imageMipTailSize, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->imageMipTailOffset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->imageMipTailStride, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkFenceCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                         VkFenceCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkFenceCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkFenceCreateFlags));
    *ptr += sizeof(VkFenceCreateFlags);
}

void reservedunmarshal_VkSemaphoreCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                             VkSemaphoreCreateInfo* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkSemaphoreCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkSemaphoreCreateFlags));
    *ptr += sizeof(VkSemaphoreCreateFlags);
}

void reservedunmarshal_VkEventCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                         VkEventCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkEventCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkEventCreateFlags));
    *ptr += sizeof(VkEventCreateFlags);
}

void reservedunmarshal_VkQueryPoolCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                             VkQueryPoolCreateInfo* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkQueryPoolCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkQueryPoolCreateFlags));
    *ptr += sizeof(VkQueryPoolCreateFlags);
    memcpy((VkQueryType*)&forUnmarshaling->queryType, *ptr, sizeof(VkQueryType));
    *ptr += sizeof(VkQueryType);
    memcpy((uint32_t*)&forUnmarshaling->queryCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkQueryPipelineStatisticFlags*)&forUnmarshaling->pipelineStatistics, *ptr,
           sizeof(VkQueryPipelineStatisticFlags));
    *ptr += sizeof(VkQueryPipelineStatisticFlags);
}

void reservedunmarshal_VkBufferCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                          VkBufferCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBufferCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkBufferCreateFlags));
    *ptr += sizeof(VkBufferCreateFlags);
    memcpy((VkDeviceSize*)&forUnmarshaling->size, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkBufferUsageFlags*)&forUnmarshaling->usage, *ptr, sizeof(VkBufferUsageFlags));
    *ptr += sizeof(VkBufferUsageFlags);
    memcpy((VkSharingMode*)&forUnmarshaling->sharingMode, *ptr, sizeof(VkSharingMode));
    *ptr += sizeof(VkSharingMode);
    memcpy((uint32_t*)&forUnmarshaling->queueFamilyIndexCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    memcpy((uint32_t**)&forUnmarshaling->pQueueFamilyIndices, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pQueueFamilyIndices);
    *ptr += 8;
    if (forUnmarshaling->pQueueFamilyIndices) {
        vkStream->alloc((void**)&forUnmarshaling->pQueueFamilyIndices,
                        forUnmarshaling->queueFamilyIndexCount * sizeof(const uint32_t));
        memcpy((uint32_t*)forUnmarshaling->pQueueFamilyIndices, *ptr,
               forUnmarshaling->queueFamilyIndexCount * sizeof(const uint32_t));
        *ptr += forUnmarshaling->queueFamilyIndexCount * sizeof(const uint32_t);
    }
}

void reservedunmarshal_VkBufferViewCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                              VkBufferViewCreateInfo* forUnmarshaling,
                                              uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBufferViewCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkBufferViewCreateFlags));
    *ptr += sizeof(VkBufferViewCreateFlags);
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkBuffer*)&forUnmarshaling->buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
    memcpy((VkFormat*)&forUnmarshaling->format, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy((VkDeviceSize*)&forUnmarshaling->offset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->range, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkImageCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                         VkImageCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkImageCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkImageCreateFlags));
    *ptr += sizeof(VkImageCreateFlags);
    memcpy((VkImageType*)&forUnmarshaling->imageType, *ptr, sizeof(VkImageType));
    *ptr += sizeof(VkImageType);
    memcpy((VkFormat*)&forUnmarshaling->format, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    reservedunmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->extent), ptr);
    memcpy((uint32_t*)&forUnmarshaling->mipLevels, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->arrayLayers, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkSampleCountFlagBits*)&forUnmarshaling->samples, *ptr, sizeof(VkSampleCountFlagBits));
    *ptr += sizeof(VkSampleCountFlagBits);
    memcpy((VkImageTiling*)&forUnmarshaling->tiling, *ptr, sizeof(VkImageTiling));
    *ptr += sizeof(VkImageTiling);
    memcpy((VkImageUsageFlags*)&forUnmarshaling->usage, *ptr, sizeof(VkImageUsageFlags));
    *ptr += sizeof(VkImageUsageFlags);
    memcpy((VkSharingMode*)&forUnmarshaling->sharingMode, *ptr, sizeof(VkSharingMode));
    *ptr += sizeof(VkSharingMode);
    memcpy((uint32_t*)&forUnmarshaling->queueFamilyIndexCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    memcpy((uint32_t**)&forUnmarshaling->pQueueFamilyIndices, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pQueueFamilyIndices);
    *ptr += 8;
    if (forUnmarshaling->pQueueFamilyIndices) {
        vkStream->alloc((void**)&forUnmarshaling->pQueueFamilyIndices,
                        forUnmarshaling->queueFamilyIndexCount * sizeof(const uint32_t));
        memcpy((uint32_t*)forUnmarshaling->pQueueFamilyIndices, *ptr,
               forUnmarshaling->queueFamilyIndexCount * sizeof(const uint32_t));
        *ptr += forUnmarshaling->queueFamilyIndexCount * sizeof(const uint32_t);
    }
    memcpy((VkImageLayout*)&forUnmarshaling->initialLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedunmarshal_VkSubresourceLayout(VulkanStream* vkStream, VkStructureType rootType,
                                           VkSubresourceLayout* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkDeviceSize*)&forUnmarshaling->offset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->size, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->rowPitch, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->arrayPitch, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->depthPitch, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkComponentMapping(VulkanStream* vkStream, VkStructureType rootType,
                                          VkComponentMapping* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkComponentSwizzle*)&forUnmarshaling->r, *ptr, sizeof(VkComponentSwizzle));
    *ptr += sizeof(VkComponentSwizzle);
    memcpy((VkComponentSwizzle*)&forUnmarshaling->g, *ptr, sizeof(VkComponentSwizzle));
    *ptr += sizeof(VkComponentSwizzle);
    memcpy((VkComponentSwizzle*)&forUnmarshaling->b, *ptr, sizeof(VkComponentSwizzle));
    *ptr += sizeof(VkComponentSwizzle);
    memcpy((VkComponentSwizzle*)&forUnmarshaling->a, *ptr, sizeof(VkComponentSwizzle));
    *ptr += sizeof(VkComponentSwizzle);
}

void reservedunmarshal_VkImageViewCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                             VkImageViewCreateInfo* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkImageViewCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkImageViewCreateFlags));
    *ptr += sizeof(VkImageViewCreateFlags);
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->image = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
    memcpy((VkImageViewType*)&forUnmarshaling->viewType, *ptr, sizeof(VkImageViewType));
    *ptr += sizeof(VkImageViewType);
    memcpy((VkFormat*)&forUnmarshaling->format, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    reservedunmarshal_VkComponentMapping(vkStream, rootType,
                                         (VkComponentMapping*)(&forUnmarshaling->components), ptr);
    reservedunmarshal_VkImageSubresourceRange(
        vkStream, rootType, (VkImageSubresourceRange*)(&forUnmarshaling->subresourceRange), ptr);
}

void reservedunmarshal_VkShaderModuleCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                VkShaderModuleCreateInfo* forUnmarshaling,
                                                uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkShaderModuleCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkShaderModuleCreateFlags));
    *ptr += sizeof(VkShaderModuleCreateFlags);
    memcpy((size_t*)&forUnmarshaling->codeSize, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->codeSize);
    *ptr += 8;
    vkStream->alloc((void**)&forUnmarshaling->pCode,
                    (forUnmarshaling->codeSize / 4) * sizeof(const uint32_t));
    memcpy((uint32_t*)forUnmarshaling->pCode, *ptr,
           (forUnmarshaling->codeSize / 4) * sizeof(const uint32_t));
    *ptr += (forUnmarshaling->codeSize / 4) * sizeof(const uint32_t);
}

void reservedunmarshal_VkPipelineCacheCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                 VkPipelineCacheCreateInfo* forUnmarshaling,
                                                 uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineCacheCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineCacheCreateFlags));
    *ptr += sizeof(VkPipelineCacheCreateFlags);
    memcpy((size_t*)&forUnmarshaling->initialDataSize, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->initialDataSize);
    *ptr += 8;
    vkStream->alloc((void**)&forUnmarshaling->pInitialData,
                    forUnmarshaling->initialDataSize * sizeof(const uint8_t));
    memcpy((void*)forUnmarshaling->pInitialData, *ptr,
           forUnmarshaling->initialDataSize * sizeof(const uint8_t));
    *ptr += forUnmarshaling->initialDataSize * sizeof(const uint8_t);
}

void reservedunmarshal_VkSpecializationMapEntry(VulkanStream* vkStream, VkStructureType rootType,
                                                VkSpecializationMapEntry* forUnmarshaling,
                                                uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->constantID, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->offset, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((size_t*)&forUnmarshaling->size, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->size);
    *ptr += 8;
}

void reservedunmarshal_VkSpecializationInfo(VulkanStream* vkStream, VkStructureType rootType,
                                            VkSpecializationInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->mapEntryCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pMapEntries,
                    forUnmarshaling->mapEntryCount * sizeof(const VkSpecializationMapEntry));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->mapEntryCount; ++i) {
        reservedunmarshal_VkSpecializationMapEntry(
            vkStream, rootType, (VkSpecializationMapEntry*)(forUnmarshaling->pMapEntries + i), ptr);
    }
    memcpy((size_t*)&forUnmarshaling->dataSize, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->dataSize);
    *ptr += 8;
    vkStream->alloc((void**)&forUnmarshaling->pData,
                    forUnmarshaling->dataSize * sizeof(const uint8_t));
    memcpy((void*)forUnmarshaling->pData, *ptr, forUnmarshaling->dataSize * sizeof(const uint8_t));
    *ptr += forUnmarshaling->dataSize * sizeof(const uint8_t);
}

void reservedunmarshal_VkPipelineShaderStageCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineShaderStageCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineShaderStageCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineShaderStageCreateFlags));
    *ptr += sizeof(VkPipelineShaderStageCreateFlags);
    memcpy((VkShaderStageFlagBits*)&forUnmarshaling->stage, *ptr, sizeof(VkShaderStageFlagBits));
    *ptr += sizeof(VkShaderStageFlagBits);
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkShaderModule*)&forUnmarshaling->module =
        (VkShaderModule)unbox_VkShaderModule((VkShaderModule)(*&cgen_var_0));
    vkStream->loadStringInPlaceWithStreamPtr((char**)&forUnmarshaling->pName, ptr);
    // WARNING PTR CHECK
    memcpy((VkSpecializationInfo**)&forUnmarshaling->pSpecializationInfo, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pSpecializationInfo);
    *ptr += 8;
    if (forUnmarshaling->pSpecializationInfo) {
        vkStream->alloc((void**)&forUnmarshaling->pSpecializationInfo,
                        sizeof(const VkSpecializationInfo));
        reservedunmarshal_VkSpecializationInfo(
            vkStream, rootType, (VkSpecializationInfo*)(forUnmarshaling->pSpecializationInfo), ptr);
    }
}

void reservedunmarshal_VkComputePipelineCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                   VkComputePipelineCreateInfo* forUnmarshaling,
                                                   uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkPipelineCreateFlags));
    *ptr += sizeof(VkPipelineCreateFlags);
    reservedunmarshal_VkPipelineShaderStageCreateInfo(
        vkStream, rootType, (VkPipelineShaderStageCreateInfo*)(&forUnmarshaling->stage), ptr);
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkPipelineLayout*)&forUnmarshaling->layout =
        (VkPipelineLayout)unbox_VkPipelineLayout((VkPipelineLayout)(*&cgen_var_0));
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkPipeline*)&forUnmarshaling->basePipelineHandle =
        (VkPipeline)unbox_VkPipeline((VkPipeline)(*&cgen_var_1));
    memcpy((int32_t*)&forUnmarshaling->basePipelineIndex, *ptr, sizeof(int32_t));
    *ptr += sizeof(int32_t);
}

void reservedunmarshal_VkVertexInputBindingDescription(
    VulkanStream* vkStream, VkStructureType rootType,
    VkVertexInputBindingDescription* forUnmarshaling, uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->binding, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->stride, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkVertexInputRate*)&forUnmarshaling->inputRate, *ptr, sizeof(VkVertexInputRate));
    *ptr += sizeof(VkVertexInputRate);
}

void reservedunmarshal_VkVertexInputAttributeDescription(
    VulkanStream* vkStream, VkStructureType rootType,
    VkVertexInputAttributeDescription* forUnmarshaling, uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->location, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->binding, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkFormat*)&forUnmarshaling->format, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy((uint32_t*)&forUnmarshaling->offset, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkPipelineVertexInputStateCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineVertexInputStateCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineVertexInputStateCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineVertexInputStateCreateFlags));
    *ptr += sizeof(VkPipelineVertexInputStateCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->vertexBindingDescriptionCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pVertexBindingDescriptions,
                    forUnmarshaling->vertexBindingDescriptionCount *
                        sizeof(const VkVertexInputBindingDescription));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->vertexBindingDescriptionCount; ++i) {
        reservedunmarshal_VkVertexInputBindingDescription(
            vkStream, rootType,
            (VkVertexInputBindingDescription*)(forUnmarshaling->pVertexBindingDescriptions + i),
            ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->vertexAttributeDescriptionCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pVertexAttributeDescriptions,
                    forUnmarshaling->vertexAttributeDescriptionCount *
                        sizeof(const VkVertexInputAttributeDescription));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->vertexAttributeDescriptionCount; ++i) {
        reservedunmarshal_VkVertexInputAttributeDescription(
            vkStream, rootType,
            (VkVertexInputAttributeDescription*)(forUnmarshaling->pVertexAttributeDescriptions + i),
            ptr);
    }
}

void reservedunmarshal_VkPipelineInputAssemblyStateCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineInputAssemblyStateCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineInputAssemblyStateCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineInputAssemblyStateCreateFlags));
    *ptr += sizeof(VkPipelineInputAssemblyStateCreateFlags);
    memcpy((VkPrimitiveTopology*)&forUnmarshaling->topology, *ptr, sizeof(VkPrimitiveTopology));
    *ptr += sizeof(VkPrimitiveTopology);
    memcpy((VkBool32*)&forUnmarshaling->primitiveRestartEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPipelineTessellationStateCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineTessellationStateCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineTessellationStateCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineTessellationStateCreateFlags));
    *ptr += sizeof(VkPipelineTessellationStateCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->patchControlPoints, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkViewport(VulkanStream* vkStream, VkStructureType rootType,
                                  VkViewport* forUnmarshaling, uint8_t** ptr) {
    memcpy((float*)&forUnmarshaling->x, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((float*)&forUnmarshaling->y, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((float*)&forUnmarshaling->width, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((float*)&forUnmarshaling->height, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((float*)&forUnmarshaling->minDepth, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((float*)&forUnmarshaling->maxDepth, *ptr, sizeof(float));
    *ptr += sizeof(float);
}

void reservedunmarshal_VkPipelineViewportStateCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineViewportStateCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineViewportStateCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineViewportStateCreateFlags));
    *ptr += sizeof(VkPipelineViewportStateCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->viewportCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    memcpy((VkViewport**)&forUnmarshaling->pViewports, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pViewports);
    *ptr += 8;
    if (forUnmarshaling->pViewports) {
        vkStream->alloc((void**)&forUnmarshaling->pViewports,
                        forUnmarshaling->viewportCount * sizeof(const VkViewport));
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->viewportCount; ++i) {
            reservedunmarshal_VkViewport(vkStream, rootType,
                                         (VkViewport*)(forUnmarshaling->pViewports + i), ptr);
        }
    }
    memcpy((uint32_t*)&forUnmarshaling->scissorCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    memcpy((VkRect2D**)&forUnmarshaling->pScissors, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pScissors);
    *ptr += 8;
    if (forUnmarshaling->pScissors) {
        vkStream->alloc((void**)&forUnmarshaling->pScissors,
                        forUnmarshaling->scissorCount * sizeof(const VkRect2D));
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->scissorCount; ++i) {
            reservedunmarshal_VkRect2D(vkStream, rootType,
                                       (VkRect2D*)(forUnmarshaling->pScissors + i), ptr);
        }
    }
}

void reservedunmarshal_VkPipelineRasterizationStateCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineRasterizationStateCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineRasterizationStateCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineRasterizationStateCreateFlags));
    *ptr += sizeof(VkPipelineRasterizationStateCreateFlags);
    memcpy((VkBool32*)&forUnmarshaling->depthClampEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->rasterizerDiscardEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkPolygonMode*)&forUnmarshaling->polygonMode, *ptr, sizeof(VkPolygonMode));
    *ptr += sizeof(VkPolygonMode);
    memcpy((VkCullModeFlags*)&forUnmarshaling->cullMode, *ptr, sizeof(VkCullModeFlags));
    *ptr += sizeof(VkCullModeFlags);
    memcpy((VkFrontFace*)&forUnmarshaling->frontFace, *ptr, sizeof(VkFrontFace));
    *ptr += sizeof(VkFrontFace);
    memcpy((VkBool32*)&forUnmarshaling->depthBiasEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((float*)&forUnmarshaling->depthBiasConstantFactor, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((float*)&forUnmarshaling->depthBiasClamp, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((float*)&forUnmarshaling->depthBiasSlopeFactor, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((float*)&forUnmarshaling->lineWidth, *ptr, sizeof(float));
    *ptr += sizeof(float);
}

void reservedunmarshal_VkPipelineMultisampleStateCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineMultisampleStateCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineMultisampleStateCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineMultisampleStateCreateFlags));
    *ptr += sizeof(VkPipelineMultisampleStateCreateFlags);
    memcpy((VkSampleCountFlagBits*)&forUnmarshaling->rasterizationSamples, *ptr,
           sizeof(VkSampleCountFlagBits));
    *ptr += sizeof(VkSampleCountFlagBits);
    memcpy((VkBool32*)&forUnmarshaling->sampleShadingEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((float*)&forUnmarshaling->minSampleShading, *ptr, sizeof(float));
    *ptr += sizeof(float);
    // WARNING PTR CHECK
    memcpy((VkSampleMask**)&forUnmarshaling->pSampleMask, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pSampleMask);
    *ptr += 8;
    if (forUnmarshaling->pSampleMask) {
        vkStream->alloc(
            (void**)&forUnmarshaling->pSampleMask,
            (((forUnmarshaling->rasterizationSamples) + 31) / 32) * sizeof(const VkSampleMask));
        memcpy((VkSampleMask*)forUnmarshaling->pSampleMask, *ptr,
               (((forUnmarshaling->rasterizationSamples) + 31) / 32) * sizeof(const VkSampleMask));
        *ptr += (((forUnmarshaling->rasterizationSamples) + 31) / 32) * sizeof(const VkSampleMask);
    }
    memcpy((VkBool32*)&forUnmarshaling->alphaToCoverageEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->alphaToOneEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkStencilOpState(VulkanStream* vkStream, VkStructureType rootType,
                                        VkStencilOpState* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStencilOp*)&forUnmarshaling->failOp, *ptr, sizeof(VkStencilOp));
    *ptr += sizeof(VkStencilOp);
    memcpy((VkStencilOp*)&forUnmarshaling->passOp, *ptr, sizeof(VkStencilOp));
    *ptr += sizeof(VkStencilOp);
    memcpy((VkStencilOp*)&forUnmarshaling->depthFailOp, *ptr, sizeof(VkStencilOp));
    *ptr += sizeof(VkStencilOp);
    memcpy((VkCompareOp*)&forUnmarshaling->compareOp, *ptr, sizeof(VkCompareOp));
    *ptr += sizeof(VkCompareOp);
    memcpy((uint32_t*)&forUnmarshaling->compareMask, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->writeMask, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->reference, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkPipelineDepthStencilStateCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineDepthStencilStateCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineDepthStencilStateCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineDepthStencilStateCreateFlags));
    *ptr += sizeof(VkPipelineDepthStencilStateCreateFlags);
    memcpy((VkBool32*)&forUnmarshaling->depthTestEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->depthWriteEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkCompareOp*)&forUnmarshaling->depthCompareOp, *ptr, sizeof(VkCompareOp));
    *ptr += sizeof(VkCompareOp);
    memcpy((VkBool32*)&forUnmarshaling->depthBoundsTestEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->stencilTestEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    reservedunmarshal_VkStencilOpState(vkStream, rootType,
                                       (VkStencilOpState*)(&forUnmarshaling->front), ptr);
    reservedunmarshal_VkStencilOpState(vkStream, rootType,
                                       (VkStencilOpState*)(&forUnmarshaling->back), ptr);
    memcpy((float*)&forUnmarshaling->minDepthBounds, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((float*)&forUnmarshaling->maxDepthBounds, *ptr, sizeof(float));
    *ptr += sizeof(float);
}

void reservedunmarshal_VkPipelineColorBlendAttachmentState(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineColorBlendAttachmentState* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkBool32*)&forUnmarshaling->blendEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBlendFactor*)&forUnmarshaling->srcColorBlendFactor, *ptr, sizeof(VkBlendFactor));
    *ptr += sizeof(VkBlendFactor);
    memcpy((VkBlendFactor*)&forUnmarshaling->dstColorBlendFactor, *ptr, sizeof(VkBlendFactor));
    *ptr += sizeof(VkBlendFactor);
    memcpy((VkBlendOp*)&forUnmarshaling->colorBlendOp, *ptr, sizeof(VkBlendOp));
    *ptr += sizeof(VkBlendOp);
    memcpy((VkBlendFactor*)&forUnmarshaling->srcAlphaBlendFactor, *ptr, sizeof(VkBlendFactor));
    *ptr += sizeof(VkBlendFactor);
    memcpy((VkBlendFactor*)&forUnmarshaling->dstAlphaBlendFactor, *ptr, sizeof(VkBlendFactor));
    *ptr += sizeof(VkBlendFactor);
    memcpy((VkBlendOp*)&forUnmarshaling->alphaBlendOp, *ptr, sizeof(VkBlendOp));
    *ptr += sizeof(VkBlendOp);
    memcpy((VkColorComponentFlags*)&forUnmarshaling->colorWriteMask, *ptr,
           sizeof(VkColorComponentFlags));
    *ptr += sizeof(VkColorComponentFlags);
}

void reservedunmarshal_VkPipelineColorBlendStateCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineColorBlendStateCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineColorBlendStateCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineColorBlendStateCreateFlags));
    *ptr += sizeof(VkPipelineColorBlendStateCreateFlags);
    memcpy((VkBool32*)&forUnmarshaling->logicOpEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkLogicOp*)&forUnmarshaling->logicOp, *ptr, sizeof(VkLogicOp));
    *ptr += sizeof(VkLogicOp);
    memcpy((uint32_t*)&forUnmarshaling->attachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc(
        (void**)&forUnmarshaling->pAttachments,
        forUnmarshaling->attachmentCount * sizeof(const VkPipelineColorBlendAttachmentState));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->attachmentCount; ++i) {
        reservedunmarshal_VkPipelineColorBlendAttachmentState(
            vkStream, rootType,
            (VkPipelineColorBlendAttachmentState*)(forUnmarshaling->pAttachments + i), ptr);
    }
    memcpy((float*)forUnmarshaling->blendConstants, *ptr, 4 * sizeof(float));
    *ptr += 4 * sizeof(float);
}

void reservedunmarshal_VkPipelineDynamicStateCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineDynamicStateCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineDynamicStateCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineDynamicStateCreateFlags));
    *ptr += sizeof(VkPipelineDynamicStateCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->dynamicStateCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pDynamicStates,
                    forUnmarshaling->dynamicStateCount * sizeof(const VkDynamicState));
    memcpy((VkDynamicState*)forUnmarshaling->pDynamicStates, *ptr,
           forUnmarshaling->dynamicStateCount * sizeof(const VkDynamicState));
    *ptr += forUnmarshaling->dynamicStateCount * sizeof(const VkDynamicState);
}

void reservedunmarshal_VkGraphicsPipelineCreateInfo(VulkanStream* vkStream,
                                                    VkStructureType rootType,
                                                    VkGraphicsPipelineCreateInfo* forUnmarshaling,
                                                    uint8_t** ptr) {
    uint32_t hasRasterization = 1;
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) {
        memcpy((uint32_t*)&hasRasterization, (*ptr), 4);
        android::base::Stream::fromBe32((uint8_t*)&hasRasterization);
        *ptr += 4;
    }
    uint32_t hasTessellation = 1;
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) {
        memcpy((uint32_t*)&hasTessellation, (*ptr), 4);
        android::base::Stream::fromBe32((uint8_t*)&hasTessellation);
        *ptr += 4;
    }
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkPipelineCreateFlags));
    *ptr += sizeof(VkPipelineCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->stageCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pStages,
                    forUnmarshaling->stageCount * sizeof(const VkPipelineShaderStageCreateInfo));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->stageCount; ++i) {
        reservedunmarshal_VkPipelineShaderStageCreateInfo(
            vkStream, rootType, (VkPipelineShaderStageCreateInfo*)(forUnmarshaling->pStages + i),
            ptr);
    }
    // WARNING PTR CHECK
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) {
        memcpy((VkPipelineVertexInputStateCreateInfo**)&forUnmarshaling->pVertexInputState, (*ptr),
               8);
        android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pVertexInputState);
        *ptr += 8;
    }
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) ||
         forUnmarshaling->pVertexInputState)) {
        vkStream->alloc((void**)&forUnmarshaling->pVertexInputState,
                        sizeof(const VkPipelineVertexInputStateCreateInfo));
        reservedunmarshal_VkPipelineVertexInputStateCreateInfo(
            vkStream, rootType,
            (VkPipelineVertexInputStateCreateInfo*)(forUnmarshaling->pVertexInputState), ptr);
    }
    // WARNING PTR CHECK
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) {
        memcpy((VkPipelineInputAssemblyStateCreateInfo**)&forUnmarshaling->pInputAssemblyState,
               (*ptr), 8);
        android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pInputAssemblyState);
        *ptr += 8;
    }
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) ||
         forUnmarshaling->pInputAssemblyState)) {
        vkStream->alloc((void**)&forUnmarshaling->pInputAssemblyState,
                        sizeof(const VkPipelineInputAssemblyStateCreateInfo));
        reservedunmarshal_VkPipelineInputAssemblyStateCreateInfo(
            vkStream, rootType,
            (VkPipelineInputAssemblyStateCreateInfo*)(forUnmarshaling->pInputAssemblyState), ptr);
    }
    // WARNING PTR CHECK
    memcpy((VkPipelineTessellationStateCreateInfo**)&forUnmarshaling->pTessellationState, (*ptr),
           8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pTessellationState);
    *ptr += 8;
    if (forUnmarshaling->pTessellationState) {
        if (hasTessellation) {
            vkStream->alloc((void**)&forUnmarshaling->pTessellationState,
                            sizeof(const VkPipelineTessellationStateCreateInfo));
            reservedunmarshal_VkPipelineTessellationStateCreateInfo(
                vkStream, rootType,
                (VkPipelineTessellationStateCreateInfo*)(forUnmarshaling->pTessellationState), ptr);
        } else {
            forUnmarshaling->pTessellationState = 0;
        }
    }
    // WARNING PTR CHECK
    memcpy((VkPipelineViewportStateCreateInfo**)&forUnmarshaling->pViewportState, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pViewportState);
    *ptr += 8;
    if (forUnmarshaling->pViewportState) {
        if (hasRasterization) {
            vkStream->alloc((void**)&forUnmarshaling->pViewportState,
                            sizeof(const VkPipelineViewportStateCreateInfo));
            reservedunmarshal_VkPipelineViewportStateCreateInfo(
                vkStream, rootType,
                (VkPipelineViewportStateCreateInfo*)(forUnmarshaling->pViewportState), ptr);
        } else {
            forUnmarshaling->pViewportState = 0;
        }
    }
    // WARNING PTR CHECK
    if (vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) {
        memcpy((VkPipelineRasterizationStateCreateInfo**)&forUnmarshaling->pRasterizationState,
               (*ptr), 8);
        android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pRasterizationState);
        *ptr += 8;
    }
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) ||
         forUnmarshaling->pRasterizationState)) {
        vkStream->alloc((void**)&forUnmarshaling->pRasterizationState,
                        sizeof(const VkPipelineRasterizationStateCreateInfo));
        reservedunmarshal_VkPipelineRasterizationStateCreateInfo(
            vkStream, rootType,
            (VkPipelineRasterizationStateCreateInfo*)(forUnmarshaling->pRasterizationState), ptr);
    }
    // WARNING PTR CHECK
    memcpy((VkPipelineMultisampleStateCreateInfo**)&forUnmarshaling->pMultisampleState, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pMultisampleState);
    *ptr += 8;
    if (forUnmarshaling->pMultisampleState) {
        if (hasRasterization) {
            vkStream->alloc((void**)&forUnmarshaling->pMultisampleState,
                            sizeof(const VkPipelineMultisampleStateCreateInfo));
            reservedunmarshal_VkPipelineMultisampleStateCreateInfo(
                vkStream, rootType,
                (VkPipelineMultisampleStateCreateInfo*)(forUnmarshaling->pMultisampleState), ptr);
        } else {
            forUnmarshaling->pMultisampleState = 0;
        }
    }
    // WARNING PTR CHECK
    memcpy((VkPipelineDepthStencilStateCreateInfo**)&forUnmarshaling->pDepthStencilState, (*ptr),
           8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pDepthStencilState);
    *ptr += 8;
    if (forUnmarshaling->pDepthStencilState) {
        if (hasRasterization) {
            vkStream->alloc((void**)&forUnmarshaling->pDepthStencilState,
                            sizeof(const VkPipelineDepthStencilStateCreateInfo));
            reservedunmarshal_VkPipelineDepthStencilStateCreateInfo(
                vkStream, rootType,
                (VkPipelineDepthStencilStateCreateInfo*)(forUnmarshaling->pDepthStencilState), ptr);
        } else {
            forUnmarshaling->pDepthStencilState = 0;
        }
    }
    // WARNING PTR CHECK
    memcpy((VkPipelineColorBlendStateCreateInfo**)&forUnmarshaling->pColorBlendState, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pColorBlendState);
    *ptr += 8;
    if (forUnmarshaling->pColorBlendState) {
        if (hasRasterization) {
            vkStream->alloc((void**)&forUnmarshaling->pColorBlendState,
                            sizeof(const VkPipelineColorBlendStateCreateInfo));
            reservedunmarshal_VkPipelineColorBlendStateCreateInfo(
                vkStream, rootType,
                (VkPipelineColorBlendStateCreateInfo*)(forUnmarshaling->pColorBlendState), ptr);
        } else {
            forUnmarshaling->pColorBlendState = 0;
        }
    }
    // WARNING PTR CHECK
    memcpy((VkPipelineDynamicStateCreateInfo**)&forUnmarshaling->pDynamicState, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pDynamicState);
    *ptr += 8;
    if (forUnmarshaling->pDynamicState) {
        vkStream->alloc((void**)&forUnmarshaling->pDynamicState,
                        sizeof(const VkPipelineDynamicStateCreateInfo));
        reservedunmarshal_VkPipelineDynamicStateCreateInfo(
            vkStream, rootType, (VkPipelineDynamicStateCreateInfo*)(forUnmarshaling->pDynamicState),
            ptr);
    }
    uint64_t cgen_var_6;
    memcpy((uint64_t*)&cgen_var_6, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkPipelineLayout*)&forUnmarshaling->layout =
        (VkPipelineLayout)unbox_VkPipelineLayout((VkPipelineLayout)(*&cgen_var_6));
    uint64_t cgen_var_7;
    memcpy((uint64_t*)&cgen_var_7, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkRenderPass*)&forUnmarshaling->renderPass =
        (VkRenderPass)unbox_VkRenderPass((VkRenderPass)(*&cgen_var_7));
    memcpy((uint32_t*)&forUnmarshaling->subpass, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_8;
    memcpy((uint64_t*)&cgen_var_8, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkPipeline*)&forUnmarshaling->basePipelineHandle =
        (VkPipeline)unbox_VkPipeline((VkPipeline)(*&cgen_var_8));
    memcpy((int32_t*)&forUnmarshaling->basePipelineIndex, *ptr, sizeof(int32_t));
    *ptr += sizeof(int32_t);
}

void reservedunmarshal_VkPushConstantRange(VulkanStream* vkStream, VkStructureType rootType,
                                           VkPushConstantRange* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkShaderStageFlags*)&forUnmarshaling->stageFlags, *ptr, sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    memcpy((uint32_t*)&forUnmarshaling->offset, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->size, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkPipelineLayoutCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                  VkPipelineLayoutCreateInfo* forUnmarshaling,
                                                  uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineLayoutCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineLayoutCreateFlags));
    *ptr += sizeof(VkPipelineLayoutCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->setLayoutCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pSetLayouts,
                    forUnmarshaling->setLayoutCount * sizeof(const VkDescriptorSetLayout));
    if (forUnmarshaling->setLayoutCount) {
        uint8_t* cgen_var_0_ptr = (uint8_t*)(*ptr);
        *ptr += 8 * forUnmarshaling->setLayoutCount;
        if (forUnmarshaling) {
            for (uint32_t k = 0; k < forUnmarshaling->setLayoutCount; ++k) {
                uint64_t tmpval;
                memcpy(&tmpval, cgen_var_0_ptr + k * 8, sizeof(uint64_t));
                *(((VkDescriptorSetLayout*)forUnmarshaling->pSetLayouts) + k) =
                    (VkDescriptorSetLayout)unbox_VkDescriptorSetLayout(
                        (VkDescriptorSetLayout)tmpval);
            }
        }
    }
    memcpy((uint32_t*)&forUnmarshaling->pushConstantRangeCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pPushConstantRanges,
                    forUnmarshaling->pushConstantRangeCount * sizeof(const VkPushConstantRange));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->pushConstantRangeCount; ++i) {
        reservedunmarshal_VkPushConstantRange(
            vkStream, rootType, (VkPushConstantRange*)(forUnmarshaling->pPushConstantRanges + i),
            ptr);
    }
}

void reservedunmarshal_VkSamplerCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                           VkSamplerCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkSamplerCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkSamplerCreateFlags));
    *ptr += sizeof(VkSamplerCreateFlags);
    memcpy((VkFilter*)&forUnmarshaling->magFilter, *ptr, sizeof(VkFilter));
    *ptr += sizeof(VkFilter);
    memcpy((VkFilter*)&forUnmarshaling->minFilter, *ptr, sizeof(VkFilter));
    *ptr += sizeof(VkFilter);
    memcpy((VkSamplerMipmapMode*)&forUnmarshaling->mipmapMode, *ptr, sizeof(VkSamplerMipmapMode));
    *ptr += sizeof(VkSamplerMipmapMode);
    memcpy((VkSamplerAddressMode*)&forUnmarshaling->addressModeU, *ptr,
           sizeof(VkSamplerAddressMode));
    *ptr += sizeof(VkSamplerAddressMode);
    memcpy((VkSamplerAddressMode*)&forUnmarshaling->addressModeV, *ptr,
           sizeof(VkSamplerAddressMode));
    *ptr += sizeof(VkSamplerAddressMode);
    memcpy((VkSamplerAddressMode*)&forUnmarshaling->addressModeW, *ptr,
           sizeof(VkSamplerAddressMode));
    *ptr += sizeof(VkSamplerAddressMode);
    memcpy((float*)&forUnmarshaling->mipLodBias, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((VkBool32*)&forUnmarshaling->anisotropyEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((float*)&forUnmarshaling->maxAnisotropy, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((VkBool32*)&forUnmarshaling->compareEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkCompareOp*)&forUnmarshaling->compareOp, *ptr, sizeof(VkCompareOp));
    *ptr += sizeof(VkCompareOp);
    memcpy((float*)&forUnmarshaling->minLod, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((float*)&forUnmarshaling->maxLod, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((VkBorderColor*)&forUnmarshaling->borderColor, *ptr, sizeof(VkBorderColor));
    *ptr += sizeof(VkBorderColor);
    memcpy((VkBool32*)&forUnmarshaling->unnormalizedCoordinates, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkCopyDescriptorSet(VulkanStream* vkStream, VkStructureType rootType,
                                           VkCopyDescriptorSet* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkDescriptorSet*)&forUnmarshaling->srcSet =
        (VkDescriptorSet)unbox_VkDescriptorSet((VkDescriptorSet)(*&cgen_var_0));
    memcpy((uint32_t*)&forUnmarshaling->srcBinding, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->srcArrayElement, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkDescriptorSet*)&forUnmarshaling->dstSet =
        (VkDescriptorSet)unbox_VkDescriptorSet((VkDescriptorSet)(*&cgen_var_1));
    memcpy((uint32_t*)&forUnmarshaling->dstBinding, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->dstArrayElement, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->descriptorCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkDescriptorBufferInfo(VulkanStream* vkStream, VkStructureType rootType,
                                              VkDescriptorBufferInfo* forUnmarshaling,
                                              uint8_t** ptr) {
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkBuffer*)&forUnmarshaling->buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
    memcpy((VkDeviceSize*)&forUnmarshaling->offset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->range, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkDescriptorImageInfo(VulkanStream* vkStream, VkStructureType rootType,
                                             VkDescriptorImageInfo* forUnmarshaling,
                                             uint8_t** ptr) {
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkSampler*)&forUnmarshaling->sampler = (VkSampler)unbox_VkSampler((VkSampler)(*&cgen_var_0));
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImageView*)&forUnmarshaling->imageView =
        (VkImageView)unbox_VkImageView((VkImageView)(*&cgen_var_1));
    memcpy((VkImageLayout*)&forUnmarshaling->imageLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedunmarshal_VkDescriptorPoolSize(VulkanStream* vkStream, VkStructureType rootType,
                                            VkDescriptorPoolSize* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkDescriptorType*)&forUnmarshaling->type, *ptr, sizeof(VkDescriptorType));
    *ptr += sizeof(VkDescriptorType);
    memcpy((uint32_t*)&forUnmarshaling->descriptorCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkDescriptorPoolCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                  VkDescriptorPoolCreateInfo* forUnmarshaling,
                                                  uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDescriptorPoolCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkDescriptorPoolCreateFlags));
    *ptr += sizeof(VkDescriptorPoolCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->maxSets, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->poolSizeCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pPoolSizes,
                    forUnmarshaling->poolSizeCount * sizeof(const VkDescriptorPoolSize));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->poolSizeCount; ++i) {
        reservedunmarshal_VkDescriptorPoolSize(
            vkStream, rootType, (VkDescriptorPoolSize*)(forUnmarshaling->pPoolSizes + i), ptr);
    }
}

void reservedunmarshal_VkDescriptorSetAllocateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                   VkDescriptorSetAllocateInfo* forUnmarshaling,
                                                   uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkDescriptorPool*)&forUnmarshaling->descriptorPool =
        (VkDescriptorPool)unbox_VkDescriptorPool((VkDescriptorPool)(*&cgen_var_0));
    memcpy((uint32_t*)&forUnmarshaling->descriptorSetCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pSetLayouts,
                    forUnmarshaling->descriptorSetCount * sizeof(const VkDescriptorSetLayout));
    if (forUnmarshaling->descriptorSetCount) {
        uint8_t* cgen_var_1_ptr = (uint8_t*)(*ptr);
        *ptr += 8 * forUnmarshaling->descriptorSetCount;
        if (forUnmarshaling) {
            for (uint32_t k = 0; k < forUnmarshaling->descriptorSetCount; ++k) {
                uint64_t tmpval;
                memcpy(&tmpval, cgen_var_1_ptr + k * 8, sizeof(uint64_t));
                *(((VkDescriptorSetLayout*)forUnmarshaling->pSetLayouts) + k) =
                    (VkDescriptorSetLayout)unbox_VkDescriptorSetLayout(
                        (VkDescriptorSetLayout)tmpval);
            }
        }
    }
}

void reservedunmarshal_VkDescriptorSetLayoutBinding(VulkanStream* vkStream,
                                                    VkStructureType rootType,
                                                    VkDescriptorSetLayoutBinding* forUnmarshaling,
                                                    uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->binding, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkDescriptorType*)&forUnmarshaling->descriptorType, *ptr, sizeof(VkDescriptorType));
    *ptr += sizeof(VkDescriptorType);
    memcpy((uint32_t*)&forUnmarshaling->descriptorCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkShaderStageFlags*)&forUnmarshaling->stageFlags, *ptr, sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    // WARNING PTR CHECK
    memcpy((VkSampler**)&forUnmarshaling->pImmutableSamplers, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pImmutableSamplers);
    *ptr += 8;
    if (forUnmarshaling->pImmutableSamplers) {
        vkStream->alloc((void**)&forUnmarshaling->pImmutableSamplers,
                        forUnmarshaling->descriptorCount * sizeof(const VkSampler));
        if (forUnmarshaling->descriptorCount) {
            uint8_t* cgen_var_0_0_ptr = (uint8_t*)(*ptr);
            *ptr += 8 * forUnmarshaling->descriptorCount;
            if (forUnmarshaling) {
                for (uint32_t k = 0; k < forUnmarshaling->descriptorCount; ++k) {
                    uint64_t tmpval;
                    memcpy(&tmpval, cgen_var_0_0_ptr + k * 8, sizeof(uint64_t));
                    *(((VkSampler*)forUnmarshaling->pImmutableSamplers) + k) =
                        (VkSampler)unbox_VkSampler((VkSampler)tmpval);
                }
            }
        }
    }
}

void reservedunmarshal_VkDescriptorSetLayoutCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDescriptorSetLayoutCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDescriptorSetLayoutCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkDescriptorSetLayoutCreateFlags));
    *ptr += sizeof(VkDescriptorSetLayoutCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->bindingCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pBindings,
                    forUnmarshaling->bindingCount * sizeof(const VkDescriptorSetLayoutBinding));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->bindingCount; ++i) {
        reservedunmarshal_VkDescriptorSetLayoutBinding(
            vkStream, rootType, (VkDescriptorSetLayoutBinding*)(forUnmarshaling->pBindings + i),
            ptr);
    }
}

void reservedunmarshal_VkWriteDescriptorSet(VulkanStream* vkStream, VkStructureType rootType,
                                            VkWriteDescriptorSet* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkDescriptorSet*)&forUnmarshaling->dstSet =
        (VkDescriptorSet)unbox_VkDescriptorSet((VkDescriptorSet)(*&cgen_var_0));
    memcpy((uint32_t*)&forUnmarshaling->dstBinding, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->dstArrayElement, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->descriptorCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkDescriptorType*)&forUnmarshaling->descriptorType, *ptr, sizeof(VkDescriptorType));
    *ptr += sizeof(VkDescriptorType);
    // WARNING PTR CHECK
    memcpy((VkDescriptorImageInfo**)&forUnmarshaling->pImageInfo, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pImageInfo);
    *ptr += 8;
    if (forUnmarshaling->pImageInfo) {
        if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) ||
             ((VK_DESCRIPTOR_TYPE_SAMPLER == forUnmarshaling->descriptorType) ||
              (VK_DESCRIPTOR_TYPE_COMBINED_IMAGE_SAMPLER == forUnmarshaling->descriptorType) ||
              (VK_DESCRIPTOR_TYPE_SAMPLED_IMAGE == forUnmarshaling->descriptorType) ||
              (VK_DESCRIPTOR_TYPE_STORAGE_IMAGE == forUnmarshaling->descriptorType) ||
              (VK_DESCRIPTOR_TYPE_INPUT_ATTACHMENT == forUnmarshaling->descriptorType)))) {
            vkStream->alloc((void**)&forUnmarshaling->pImageInfo,
                            forUnmarshaling->descriptorCount * sizeof(const VkDescriptorImageInfo));
            for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->descriptorCount; ++i) {
                reservedunmarshal_VkDescriptorImageInfo(
                    vkStream, rootType, (VkDescriptorImageInfo*)(forUnmarshaling->pImageInfo + i),
                    ptr);
            }
        } else {
            forUnmarshaling->pImageInfo = 0;
        }
    }
    // WARNING PTR CHECK
    memcpy((VkDescriptorBufferInfo**)&forUnmarshaling->pBufferInfo, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pBufferInfo);
    *ptr += 8;
    if (forUnmarshaling->pBufferInfo) {
        if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) ||
             ((VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER == forUnmarshaling->descriptorType) ||
              (VK_DESCRIPTOR_TYPE_UNIFORM_BUFFER_DYNAMIC == forUnmarshaling->descriptorType) ||
              (VK_DESCRIPTOR_TYPE_STORAGE_BUFFER == forUnmarshaling->descriptorType) ||
              (VK_DESCRIPTOR_TYPE_STORAGE_BUFFER_DYNAMIC == forUnmarshaling->descriptorType)))) {
            vkStream->alloc(
                (void**)&forUnmarshaling->pBufferInfo,
                forUnmarshaling->descriptorCount * sizeof(const VkDescriptorBufferInfo));
            for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->descriptorCount; ++i) {
                reservedunmarshal_VkDescriptorBufferInfo(
                    vkStream, rootType, (VkDescriptorBufferInfo*)(forUnmarshaling->pBufferInfo + i),
                    ptr);
            }
        } else {
            forUnmarshaling->pBufferInfo = 0;
        }
    }
    // WARNING PTR CHECK
    memcpy((VkBufferView**)&forUnmarshaling->pTexelBufferView, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pTexelBufferView);
    *ptr += 8;
    if (forUnmarshaling->pTexelBufferView) {
        if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) ||
             ((VK_DESCRIPTOR_TYPE_UNIFORM_TEXEL_BUFFER == forUnmarshaling->descriptorType) ||
              (VK_DESCRIPTOR_TYPE_STORAGE_TEXEL_BUFFER == forUnmarshaling->descriptorType)))) {
            vkStream->alloc((void**)&forUnmarshaling->pTexelBufferView,
                            forUnmarshaling->descriptorCount * sizeof(const VkBufferView));
            if (forUnmarshaling->descriptorCount) {
                uint8_t* cgen_var_3_0_ptr = (uint8_t*)(*ptr);
                *ptr += 8 * forUnmarshaling->descriptorCount;
                if (forUnmarshaling) {
                    for (uint32_t k = 0; k < forUnmarshaling->descriptorCount; ++k) {
                        uint64_t tmpval;
                        memcpy(&tmpval, cgen_var_3_0_ptr + k * 8, sizeof(uint64_t));
                        *(((VkBufferView*)forUnmarshaling->pTexelBufferView) + k) =
                            (VkBufferView)unbox_VkBufferView((VkBufferView)tmpval);
                    }
                }
            }
        } else {
            forUnmarshaling->pTexelBufferView = 0;
        }
    }
}

void reservedunmarshal_VkAttachmentDescription(VulkanStream* vkStream, VkStructureType rootType,
                                               VkAttachmentDescription* forUnmarshaling,
                                               uint8_t** ptr) {
    memcpy((VkAttachmentDescriptionFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkAttachmentDescriptionFlags));
    *ptr += sizeof(VkAttachmentDescriptionFlags);
    memcpy((VkFormat*)&forUnmarshaling->format, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy((VkSampleCountFlagBits*)&forUnmarshaling->samples, *ptr, sizeof(VkSampleCountFlagBits));
    *ptr += sizeof(VkSampleCountFlagBits);
    memcpy((VkAttachmentLoadOp*)&forUnmarshaling->loadOp, *ptr, sizeof(VkAttachmentLoadOp));
    *ptr += sizeof(VkAttachmentLoadOp);
    memcpy((VkAttachmentStoreOp*)&forUnmarshaling->storeOp, *ptr, sizeof(VkAttachmentStoreOp));
    *ptr += sizeof(VkAttachmentStoreOp);
    memcpy((VkAttachmentLoadOp*)&forUnmarshaling->stencilLoadOp, *ptr, sizeof(VkAttachmentLoadOp));
    *ptr += sizeof(VkAttachmentLoadOp);
    memcpy((VkAttachmentStoreOp*)&forUnmarshaling->stencilStoreOp, *ptr,
           sizeof(VkAttachmentStoreOp));
    *ptr += sizeof(VkAttachmentStoreOp);
    memcpy((VkImageLayout*)&forUnmarshaling->initialLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((VkImageLayout*)&forUnmarshaling->finalLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedunmarshal_VkAttachmentReference(VulkanStream* vkStream, VkStructureType rootType,
                                             VkAttachmentReference* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->attachment, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkImageLayout*)&forUnmarshaling->layout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedunmarshal_VkFramebufferCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                               VkFramebufferCreateInfo* forUnmarshaling,
                                               uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkFramebufferCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkFramebufferCreateFlags));
    *ptr += sizeof(VkFramebufferCreateFlags);
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkRenderPass*)&forUnmarshaling->renderPass =
        (VkRenderPass)unbox_VkRenderPass((VkRenderPass)(*&cgen_var_0));
    memcpy((uint32_t*)&forUnmarshaling->attachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    if ((!(vkStream->getFeatureBits() & VULKAN_STREAM_FEATURE_IGNORED_HANDLES_BIT) ||
         (((forUnmarshaling->flags & VK_FRAMEBUFFER_CREATE_IMAGELESS_BIT) == 0)))) {
        vkStream->alloc((void**)&forUnmarshaling->pAttachments,
                        forUnmarshaling->attachmentCount * sizeof(const VkImageView));
        if (forUnmarshaling->attachmentCount) {
            uint8_t* cgen_var_0_0_ptr = (uint8_t*)(*ptr);
            *ptr += 8 * forUnmarshaling->attachmentCount;
            if (forUnmarshaling) {
                for (uint32_t k = 0; k < forUnmarshaling->attachmentCount; ++k) {
                    uint64_t tmpval;
                    memcpy(&tmpval, cgen_var_0_0_ptr + k * 8, sizeof(uint64_t));
                    *(((VkImageView*)forUnmarshaling->pAttachments) + k) =
                        (VkImageView)unbox_VkImageView((VkImageView)tmpval);
                }
            }
        }
    } else {
        forUnmarshaling->pAttachments = 0;
    }
    memcpy((uint32_t*)&forUnmarshaling->width, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->height, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->layers, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkSubpassDescription(VulkanStream* vkStream, VkStructureType rootType,
                                            VkSubpassDescription* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkSubpassDescriptionFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkSubpassDescriptionFlags));
    *ptr += sizeof(VkSubpassDescriptionFlags);
    memcpy((VkPipelineBindPoint*)&forUnmarshaling->pipelineBindPoint, *ptr,
           sizeof(VkPipelineBindPoint));
    *ptr += sizeof(VkPipelineBindPoint);
    memcpy((uint32_t*)&forUnmarshaling->inputAttachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pInputAttachments,
                    forUnmarshaling->inputAttachmentCount * sizeof(const VkAttachmentReference));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->inputAttachmentCount; ++i) {
        reservedunmarshal_VkAttachmentReference(
            vkStream, rootType, (VkAttachmentReference*)(forUnmarshaling->pInputAttachments + i),
            ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->colorAttachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pColorAttachments,
                    forUnmarshaling->colorAttachmentCount * sizeof(const VkAttachmentReference));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->colorAttachmentCount; ++i) {
        reservedunmarshal_VkAttachmentReference(
            vkStream, rootType, (VkAttachmentReference*)(forUnmarshaling->pColorAttachments + i),
            ptr);
    }
    // WARNING PTR CHECK
    memcpy((VkAttachmentReference**)&forUnmarshaling->pResolveAttachments, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pResolveAttachments);
    *ptr += 8;
    if (forUnmarshaling->pResolveAttachments) {
        vkStream->alloc(
            (void**)&forUnmarshaling->pResolveAttachments,
            forUnmarshaling->colorAttachmentCount * sizeof(const VkAttachmentReference));
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->colorAttachmentCount; ++i) {
            reservedunmarshal_VkAttachmentReference(
                vkStream, rootType,
                (VkAttachmentReference*)(forUnmarshaling->pResolveAttachments + i), ptr);
        }
    }
    // WARNING PTR CHECK
    memcpy((VkAttachmentReference**)&forUnmarshaling->pDepthStencilAttachment, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pDepthStencilAttachment);
    *ptr += 8;
    if (forUnmarshaling->pDepthStencilAttachment) {
        vkStream->alloc((void**)&forUnmarshaling->pDepthStencilAttachment,
                        sizeof(const VkAttachmentReference));
        reservedunmarshal_VkAttachmentReference(
            vkStream, rootType, (VkAttachmentReference*)(forUnmarshaling->pDepthStencilAttachment),
            ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->preserveAttachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pPreserveAttachments,
                    forUnmarshaling->preserveAttachmentCount * sizeof(const uint32_t));
    memcpy((uint32_t*)forUnmarshaling->pPreserveAttachments, *ptr,
           forUnmarshaling->preserveAttachmentCount * sizeof(const uint32_t));
    *ptr += forUnmarshaling->preserveAttachmentCount * sizeof(const uint32_t);
}

void reservedunmarshal_VkSubpassDependency(VulkanStream* vkStream, VkStructureType rootType,
                                           VkSubpassDependency* forUnmarshaling, uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->srcSubpass, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->dstSubpass, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkPipelineStageFlags*)&forUnmarshaling->srcStageMask, *ptr,
           sizeof(VkPipelineStageFlags));
    *ptr += sizeof(VkPipelineStageFlags);
    memcpy((VkPipelineStageFlags*)&forUnmarshaling->dstStageMask, *ptr,
           sizeof(VkPipelineStageFlags));
    *ptr += sizeof(VkPipelineStageFlags);
    memcpy((VkAccessFlags*)&forUnmarshaling->srcAccessMask, *ptr, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy((VkAccessFlags*)&forUnmarshaling->dstAccessMask, *ptr, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy((VkDependencyFlags*)&forUnmarshaling->dependencyFlags, *ptr, sizeof(VkDependencyFlags));
    *ptr += sizeof(VkDependencyFlags);
}

void reservedunmarshal_VkRenderPassCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                              VkRenderPassCreateInfo* forUnmarshaling,
                                              uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkRenderPassCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkRenderPassCreateFlags));
    *ptr += sizeof(VkRenderPassCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->attachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pAttachments,
                    forUnmarshaling->attachmentCount * sizeof(const VkAttachmentDescription));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->attachmentCount; ++i) {
        reservedunmarshal_VkAttachmentDescription(
            vkStream, rootType, (VkAttachmentDescription*)(forUnmarshaling->pAttachments + i), ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->subpassCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pSubpasses,
                    forUnmarshaling->subpassCount * sizeof(const VkSubpassDescription));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->subpassCount; ++i) {
        reservedunmarshal_VkSubpassDescription(
            vkStream, rootType, (VkSubpassDescription*)(forUnmarshaling->pSubpasses + i), ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->dependencyCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pDependencies,
                    forUnmarshaling->dependencyCount * sizeof(const VkSubpassDependency));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->dependencyCount; ++i) {
        reservedunmarshal_VkSubpassDependency(
            vkStream, rootType, (VkSubpassDependency*)(forUnmarshaling->pDependencies + i), ptr);
    }
}

void reservedunmarshal_VkCommandPoolCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                               VkCommandPoolCreateInfo* forUnmarshaling,
                                               uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkCommandPoolCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkCommandPoolCreateFlags));
    *ptr += sizeof(VkCommandPoolCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->queueFamilyIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkCommandBufferAllocateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                   VkCommandBufferAllocateInfo* forUnmarshaling,
                                                   uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkCommandPool*)&forUnmarshaling->commandPool =
        (VkCommandPool)unbox_VkCommandPool((VkCommandPool)(*&cgen_var_0));
    memcpy((VkCommandBufferLevel*)&forUnmarshaling->level, *ptr, sizeof(VkCommandBufferLevel));
    *ptr += sizeof(VkCommandBufferLevel);
    memcpy((uint32_t*)&forUnmarshaling->commandBufferCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkCommandBufferInheritanceInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkCommandBufferInheritanceInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkRenderPass*)&forUnmarshaling->renderPass =
        (VkRenderPass)unbox_VkRenderPass((VkRenderPass)(*&cgen_var_0));
    memcpy((uint32_t*)&forUnmarshaling->subpass, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkFramebuffer*)&forUnmarshaling->framebuffer =
        (VkFramebuffer)unbox_VkFramebuffer((VkFramebuffer)(*&cgen_var_1));
    memcpy((VkBool32*)&forUnmarshaling->occlusionQueryEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkQueryControlFlags*)&forUnmarshaling->queryFlags, *ptr, sizeof(VkQueryControlFlags));
    *ptr += sizeof(VkQueryControlFlags);
    memcpy((VkQueryPipelineStatisticFlags*)&forUnmarshaling->pipelineStatistics, *ptr,
           sizeof(VkQueryPipelineStatisticFlags));
    *ptr += sizeof(VkQueryPipelineStatisticFlags);
}

void reservedunmarshal_VkCommandBufferBeginInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                VkCommandBufferBeginInfo* forUnmarshaling,
                                                uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkCommandBufferUsageFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkCommandBufferUsageFlags));
    *ptr += sizeof(VkCommandBufferUsageFlags);
    // WARNING PTR CHECK
    memcpy((VkCommandBufferInheritanceInfo**)&forUnmarshaling->pInheritanceInfo, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pInheritanceInfo);
    *ptr += 8;
    if (forUnmarshaling->pInheritanceInfo) {
        vkStream->alloc((void**)&forUnmarshaling->pInheritanceInfo,
                        sizeof(const VkCommandBufferInheritanceInfo));
        reservedunmarshal_VkCommandBufferInheritanceInfo(
            vkStream, rootType,
            (VkCommandBufferInheritanceInfo*)(forUnmarshaling->pInheritanceInfo), ptr);
    }
}

void reservedunmarshal_VkBufferCopy(VulkanStream* vkStream, VkStructureType rootType,
                                    VkBufferCopy* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkDeviceSize*)&forUnmarshaling->srcOffset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->dstOffset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->size, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkImageSubresourceLayers(VulkanStream* vkStream, VkStructureType rootType,
                                                VkImageSubresourceLayers* forUnmarshaling,
                                                uint8_t** ptr) {
    memcpy((VkImageAspectFlags*)&forUnmarshaling->aspectMask, *ptr, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
    memcpy((uint32_t*)&forUnmarshaling->mipLevel, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->baseArrayLayer, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->layerCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkBufferImageCopy(VulkanStream* vkStream, VkStructureType rootType,
                                         VkBufferImageCopy* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkDeviceSize*)&forUnmarshaling->bufferOffset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((uint32_t*)&forUnmarshaling->bufferRowLength, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->bufferImageHeight, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->imageSubresource), ptr);
    reservedunmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->imageOffset),
                                 ptr);
    reservedunmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->imageExtent),
                                 ptr);
}

void reservedunmarshal_VkClearColorValue(VulkanStream* vkStream, VkStructureType rootType,
                                         VkClearColorValue* forUnmarshaling, uint8_t** ptr) {
    memcpy((float*)forUnmarshaling->float32, *ptr, 4 * sizeof(float));
    *ptr += 4 * sizeof(float);
}

void reservedunmarshal_VkClearDepthStencilValue(VulkanStream* vkStream, VkStructureType rootType,
                                                VkClearDepthStencilValue* forUnmarshaling,
                                                uint8_t** ptr) {
    memcpy((float*)&forUnmarshaling->depth, *ptr, sizeof(float));
    *ptr += sizeof(float);
    memcpy((uint32_t*)&forUnmarshaling->stencil, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkClearValue(VulkanStream* vkStream, VkStructureType rootType,
                                    VkClearValue* forUnmarshaling, uint8_t** ptr) {
    reservedunmarshal_VkClearColorValue(vkStream, rootType,
                                        (VkClearColorValue*)(&forUnmarshaling->color), ptr);
}

void reservedunmarshal_VkClearAttachment(VulkanStream* vkStream, VkStructureType rootType,
                                         VkClearAttachment* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkImageAspectFlags*)&forUnmarshaling->aspectMask, *ptr, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
    memcpy((uint32_t*)&forUnmarshaling->colorAttachment, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    reservedunmarshal_VkClearValue(vkStream, rootType,
                                   (VkClearValue*)(&forUnmarshaling->clearValue), ptr);
}

void reservedunmarshal_VkClearRect(VulkanStream* vkStream, VkStructureType rootType,
                                   VkClearRect* forUnmarshaling, uint8_t** ptr) {
    reservedunmarshal_VkRect2D(vkStream, rootType, (VkRect2D*)(&forUnmarshaling->rect), ptr);
    memcpy((uint32_t*)&forUnmarshaling->baseArrayLayer, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->layerCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkImageBlit(VulkanStream* vkStream, VkStructureType rootType,
                                   VkImageBlit* forUnmarshaling, uint8_t** ptr) {
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->srcSubresource), ptr);
    for (uint32_t i = 0; i < (uint32_t)2; ++i) {
        reservedunmarshal_VkOffset3D(vkStream, rootType,
                                     (VkOffset3D*)(forUnmarshaling->srcOffsets + i), ptr);
    }
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->dstSubresource), ptr);
    for (uint32_t i = 0; i < (uint32_t)2; ++i) {
        reservedunmarshal_VkOffset3D(vkStream, rootType,
                                     (VkOffset3D*)(forUnmarshaling->dstOffsets + i), ptr);
    }
}

void reservedunmarshal_VkImageCopy(VulkanStream* vkStream, VkStructureType rootType,
                                   VkImageCopy* forUnmarshaling, uint8_t** ptr) {
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->srcSubresource), ptr);
    reservedunmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->srcOffset),
                                 ptr);
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->dstSubresource), ptr);
    reservedunmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->dstOffset),
                                 ptr);
    reservedunmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->extent), ptr);
}

void reservedunmarshal_VkImageResolve(VulkanStream* vkStream, VkStructureType rootType,
                                      VkImageResolve* forUnmarshaling, uint8_t** ptr) {
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->srcSubresource), ptr);
    reservedunmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->srcOffset),
                                 ptr);
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->dstSubresource), ptr);
    reservedunmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->dstOffset),
                                 ptr);
    reservedunmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->extent), ptr);
}

void reservedunmarshal_VkRenderPassBeginInfo(VulkanStream* vkStream, VkStructureType rootType,
                                             VkRenderPassBeginInfo* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkRenderPass*)&forUnmarshaling->renderPass =
        (VkRenderPass)unbox_VkRenderPass((VkRenderPass)(*&cgen_var_0));
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkFramebuffer*)&forUnmarshaling->framebuffer =
        (VkFramebuffer)unbox_VkFramebuffer((VkFramebuffer)(*&cgen_var_1));
    reservedunmarshal_VkRect2D(vkStream, rootType, (VkRect2D*)(&forUnmarshaling->renderArea), ptr);
    memcpy((uint32_t*)&forUnmarshaling->clearValueCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    memcpy((VkClearValue**)&forUnmarshaling->pClearValues, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pClearValues);
    *ptr += 8;
    if (forUnmarshaling->pClearValues) {
        vkStream->alloc((void**)&forUnmarshaling->pClearValues,
                        forUnmarshaling->clearValueCount * sizeof(const VkClearValue));
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->clearValueCount; ++i) {
            reservedunmarshal_VkClearValue(vkStream, rootType,
                                           (VkClearValue*)(forUnmarshaling->pClearValues + i), ptr);
        }
    }
}

#endif
#ifdef VK_VERSION_1_1
void reservedunmarshal_VkPhysicalDeviceSubgroupProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceSubgroupProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->subgroupSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkShaderStageFlags*)&forUnmarshaling->supportedStages, *ptr,
           sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    memcpy((VkSubgroupFeatureFlags*)&forUnmarshaling->supportedOperations, *ptr,
           sizeof(VkSubgroupFeatureFlags));
    *ptr += sizeof(VkSubgroupFeatureFlags);
    memcpy((VkBool32*)&forUnmarshaling->quadOperationsInAllStages, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkBindBufferMemoryInfo(VulkanStream* vkStream, VkStructureType rootType,
                                              VkBindBufferMemoryInfo* forUnmarshaling,
                                              uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkBuffer*)&forUnmarshaling->buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkDeviceMemory*)&forUnmarshaling->memory =
        (VkDeviceMemory)unbox_VkDeviceMemory((VkDeviceMemory)(*&cgen_var_1));
    memcpy((VkDeviceSize*)&forUnmarshaling->memoryOffset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkBindImageMemoryInfo(VulkanStream* vkStream, VkStructureType rootType,
                                             VkBindImageMemoryInfo* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->image = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkDeviceMemory*)&forUnmarshaling->memory =
        (VkDeviceMemory)unbox_VkDeviceMemory((VkDeviceMemory)(*&cgen_var_1));
    memcpy((VkDeviceSize*)&forUnmarshaling->memoryOffset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkPhysicalDevice16BitStorageFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDevice16BitStorageFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->storageBuffer16BitAccess, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->uniformAndStorageBuffer16BitAccess, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->storagePushConstant16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->storageInputOutput16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkMemoryDedicatedRequirements(VulkanStream* vkStream,
                                                     VkStructureType rootType,
                                                     VkMemoryDedicatedRequirements* forUnmarshaling,
                                                     uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->prefersDedicatedAllocation, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->requiresDedicatedAllocation, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkMemoryDedicatedAllocateInfo(VulkanStream* vkStream,
                                                     VkStructureType rootType,
                                                     VkMemoryDedicatedAllocateInfo* forUnmarshaling,
                                                     uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->image = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkBuffer*)&forUnmarshaling->buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_1));
}

void reservedunmarshal_VkMemoryAllocateFlagsInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                 VkMemoryAllocateFlagsInfo* forUnmarshaling,
                                                 uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkMemoryAllocateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkMemoryAllocateFlags));
    *ptr += sizeof(VkMemoryAllocateFlags);
    memcpy((uint32_t*)&forUnmarshaling->deviceMask, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkDeviceGroupRenderPassBeginInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDeviceGroupRenderPassBeginInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->deviceMask, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->deviceRenderAreaCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pDeviceRenderAreas,
                    forUnmarshaling->deviceRenderAreaCount * sizeof(const VkRect2D));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->deviceRenderAreaCount; ++i) {
        reservedunmarshal_VkRect2D(vkStream, rootType,
                                   (VkRect2D*)(forUnmarshaling->pDeviceRenderAreas + i), ptr);
    }
}

void reservedunmarshal_VkDeviceGroupCommandBufferBeginInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDeviceGroupCommandBufferBeginInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->deviceMask, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkDeviceGroupSubmitInfo(VulkanStream* vkStream, VkStructureType rootType,
                                               VkDeviceGroupSubmitInfo* forUnmarshaling,
                                               uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->waitSemaphoreCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pWaitSemaphoreDeviceIndices,
                    forUnmarshaling->waitSemaphoreCount * sizeof(const uint32_t));
    memcpy((uint32_t*)forUnmarshaling->pWaitSemaphoreDeviceIndices, *ptr,
           forUnmarshaling->waitSemaphoreCount * sizeof(const uint32_t));
    *ptr += forUnmarshaling->waitSemaphoreCount * sizeof(const uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->commandBufferCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pCommandBufferDeviceMasks,
                    forUnmarshaling->commandBufferCount * sizeof(const uint32_t));
    memcpy((uint32_t*)forUnmarshaling->pCommandBufferDeviceMasks, *ptr,
           forUnmarshaling->commandBufferCount * sizeof(const uint32_t));
    *ptr += forUnmarshaling->commandBufferCount * sizeof(const uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->signalSemaphoreCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pSignalSemaphoreDeviceIndices,
                    forUnmarshaling->signalSemaphoreCount * sizeof(const uint32_t));
    memcpy((uint32_t*)forUnmarshaling->pSignalSemaphoreDeviceIndices, *ptr,
           forUnmarshaling->signalSemaphoreCount * sizeof(const uint32_t));
    *ptr += forUnmarshaling->signalSemaphoreCount * sizeof(const uint32_t);
}

void reservedunmarshal_VkDeviceGroupBindSparseInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                   VkDeviceGroupBindSparseInfo* forUnmarshaling,
                                                   uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->resourceDeviceIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->memoryDeviceIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkBindBufferMemoryDeviceGroupInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkBindBufferMemoryDeviceGroupInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->deviceIndexCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pDeviceIndices,
                    forUnmarshaling->deviceIndexCount * sizeof(const uint32_t));
    memcpy((uint32_t*)forUnmarshaling->pDeviceIndices, *ptr,
           forUnmarshaling->deviceIndexCount * sizeof(const uint32_t));
    *ptr += forUnmarshaling->deviceIndexCount * sizeof(const uint32_t);
}

void reservedunmarshal_VkBindImageMemoryDeviceGroupInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkBindImageMemoryDeviceGroupInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->deviceIndexCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pDeviceIndices,
                    forUnmarshaling->deviceIndexCount * sizeof(const uint32_t));
    memcpy((uint32_t*)forUnmarshaling->pDeviceIndices, *ptr,
           forUnmarshaling->deviceIndexCount * sizeof(const uint32_t));
    *ptr += forUnmarshaling->deviceIndexCount * sizeof(const uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->splitInstanceBindRegionCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pSplitInstanceBindRegions,
                    forUnmarshaling->splitInstanceBindRegionCount * sizeof(const VkRect2D));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->splitInstanceBindRegionCount; ++i) {
        reservedunmarshal_VkRect2D(
            vkStream, rootType, (VkRect2D*)(forUnmarshaling->pSplitInstanceBindRegions + i), ptr);
    }
}

void reservedunmarshal_VkPhysicalDeviceGroupProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceGroupProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->physicalDeviceCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkPhysicalDevice*)forUnmarshaling->physicalDevices, *ptr,
           VK_MAX_DEVICE_GROUP_SIZE * sizeof(VkPhysicalDevice));
    *ptr += VK_MAX_DEVICE_GROUP_SIZE * sizeof(VkPhysicalDevice);
    memcpy((VkBool32*)&forUnmarshaling->subsetAllocation, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkDeviceGroupDeviceCreateInfo(VulkanStream* vkStream,
                                                     VkStructureType rootType,
                                                     VkDeviceGroupDeviceCreateInfo* forUnmarshaling,
                                                     uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->physicalDeviceCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pPhysicalDevices,
                    forUnmarshaling->physicalDeviceCount * sizeof(const VkPhysicalDevice));
    if (forUnmarshaling->physicalDeviceCount) {
        uint8_t* cgen_var_0_ptr = (uint8_t*)(*ptr);
        *ptr += 8 * forUnmarshaling->physicalDeviceCount;
        if (forUnmarshaling) {
            for (uint32_t k = 0; k < forUnmarshaling->physicalDeviceCount; ++k) {
                uint64_t tmpval;
                memcpy(&tmpval, cgen_var_0_ptr + k * 8, sizeof(uint64_t));
                *(((VkPhysicalDevice*)forUnmarshaling->pPhysicalDevices) + k) =
                    (VkPhysicalDevice)unbox_VkPhysicalDevice((VkPhysicalDevice)tmpval);
            }
        }
    }
}

void reservedunmarshal_VkBufferMemoryRequirementsInfo2(
    VulkanStream* vkStream, VkStructureType rootType,
    VkBufferMemoryRequirementsInfo2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkBuffer*)&forUnmarshaling->buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
}

void reservedunmarshal_VkImageMemoryRequirementsInfo2(
    VulkanStream* vkStream, VkStructureType rootType,
    VkImageMemoryRequirementsInfo2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->image = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
}

void reservedunmarshal_VkImageSparseMemoryRequirementsInfo2(
    VulkanStream* vkStream, VkStructureType rootType,
    VkImageSparseMemoryRequirementsInfo2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->image = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
}

void reservedunmarshal_VkMemoryRequirements2(VulkanStream* vkStream, VkStructureType rootType,
                                             VkMemoryRequirements2* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkMemoryRequirements(
        vkStream, rootType, (VkMemoryRequirements*)(&forUnmarshaling->memoryRequirements), ptr);
}

void reservedunmarshal_VkSparseImageMemoryRequirements2(
    VulkanStream* vkStream, VkStructureType rootType,
    VkSparseImageMemoryRequirements2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkSparseImageMemoryRequirements(
        vkStream, rootType,
        (VkSparseImageMemoryRequirements*)(&forUnmarshaling->memoryRequirements), ptr);
}

void reservedunmarshal_VkPhysicalDeviceFeatures2(VulkanStream* vkStream, VkStructureType rootType,
                                                 VkPhysicalDeviceFeatures2* forUnmarshaling,
                                                 uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkPhysicalDeviceFeatures(
        vkStream, rootType, (VkPhysicalDeviceFeatures*)(&forUnmarshaling->features), ptr);
}

void reservedunmarshal_VkPhysicalDeviceProperties2(VulkanStream* vkStream, VkStructureType rootType,
                                                   VkPhysicalDeviceProperties2* forUnmarshaling,
                                                   uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkPhysicalDeviceProperties(
        vkStream, rootType, (VkPhysicalDeviceProperties*)(&forUnmarshaling->properties), ptr);
}

void reservedunmarshal_VkFormatProperties2(VulkanStream* vkStream, VkStructureType rootType,
                                           VkFormatProperties2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkFormatProperties(
        vkStream, rootType, (VkFormatProperties*)(&forUnmarshaling->formatProperties), ptr);
}

void reservedunmarshal_VkImageFormatProperties2(VulkanStream* vkStream, VkStructureType rootType,
                                                VkImageFormatProperties2* forUnmarshaling,
                                                uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkImageFormatProperties(
        vkStream, rootType, (VkImageFormatProperties*)(&forUnmarshaling->imageFormatProperties),
        ptr);
}

void reservedunmarshal_VkPhysicalDeviceImageFormatInfo2(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceImageFormatInfo2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkFormat*)&forUnmarshaling->format, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy((VkImageType*)&forUnmarshaling->type, *ptr, sizeof(VkImageType));
    *ptr += sizeof(VkImageType);
    memcpy((VkImageTiling*)&forUnmarshaling->tiling, *ptr, sizeof(VkImageTiling));
    *ptr += sizeof(VkImageTiling);
    memcpy((VkImageUsageFlags*)&forUnmarshaling->usage, *ptr, sizeof(VkImageUsageFlags));
    *ptr += sizeof(VkImageUsageFlags);
    memcpy((VkImageCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkImageCreateFlags));
    *ptr += sizeof(VkImageCreateFlags);
}

void reservedunmarshal_VkQueueFamilyProperties2(VulkanStream* vkStream, VkStructureType rootType,
                                                VkQueueFamilyProperties2* forUnmarshaling,
                                                uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkQueueFamilyProperties(
        vkStream, rootType, (VkQueueFamilyProperties*)(&forUnmarshaling->queueFamilyProperties),
        ptr);
}

void reservedunmarshal_VkPhysicalDeviceMemoryProperties2(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceMemoryProperties2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkPhysicalDeviceMemoryProperties(
        vkStream, rootType, (VkPhysicalDeviceMemoryProperties*)(&forUnmarshaling->memoryProperties),
        ptr);
}

void reservedunmarshal_VkSparseImageFormatProperties2(
    VulkanStream* vkStream, VkStructureType rootType,
    VkSparseImageFormatProperties2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkSparseImageFormatProperties(
        vkStream, rootType, (VkSparseImageFormatProperties*)(&forUnmarshaling->properties), ptr);
}

void reservedunmarshal_VkPhysicalDeviceSparseImageFormatInfo2(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceSparseImageFormatInfo2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkFormat*)&forUnmarshaling->format, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy((VkImageType*)&forUnmarshaling->type, *ptr, sizeof(VkImageType));
    *ptr += sizeof(VkImageType);
    memcpy((VkSampleCountFlagBits*)&forUnmarshaling->samples, *ptr, sizeof(VkSampleCountFlagBits));
    *ptr += sizeof(VkSampleCountFlagBits);
    memcpy((VkImageUsageFlags*)&forUnmarshaling->usage, *ptr, sizeof(VkImageUsageFlags));
    *ptr += sizeof(VkImageUsageFlags);
    memcpy((VkImageTiling*)&forUnmarshaling->tiling, *ptr, sizeof(VkImageTiling));
    *ptr += sizeof(VkImageTiling);
}

void reservedunmarshal_VkPhysicalDevicePointClippingProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDevicePointClippingProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPointClippingBehavior*)&forUnmarshaling->pointClippingBehavior, *ptr,
           sizeof(VkPointClippingBehavior));
    *ptr += sizeof(VkPointClippingBehavior);
}

void reservedunmarshal_VkInputAttachmentAspectReference(
    VulkanStream* vkStream, VkStructureType rootType,
    VkInputAttachmentAspectReference* forUnmarshaling, uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->subpass, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->inputAttachmentIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkImageAspectFlags*)&forUnmarshaling->aspectMask, *ptr, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
}

void reservedunmarshal_VkRenderPassInputAttachmentAspectCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkRenderPassInputAttachmentAspectCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->aspectReferenceCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc(
        (void**)&forUnmarshaling->pAspectReferences,
        forUnmarshaling->aspectReferenceCount * sizeof(const VkInputAttachmentAspectReference));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->aspectReferenceCount; ++i) {
        reservedunmarshal_VkInputAttachmentAspectReference(
            vkStream, rootType,
            (VkInputAttachmentAspectReference*)(forUnmarshaling->pAspectReferences + i), ptr);
    }
}

void reservedunmarshal_VkImageViewUsageCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                  VkImageViewUsageCreateInfo* forUnmarshaling,
                                                  uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkImageUsageFlags*)&forUnmarshaling->usage, *ptr, sizeof(VkImageUsageFlags));
    *ptr += sizeof(VkImageUsageFlags);
}

void reservedunmarshal_VkPipelineTessellationDomainOriginStateCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineTessellationDomainOriginStateCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkTessellationDomainOrigin*)&forUnmarshaling->domainOrigin, *ptr,
           sizeof(VkTessellationDomainOrigin));
    *ptr += sizeof(VkTessellationDomainOrigin);
}

void reservedunmarshal_VkRenderPassMultiviewCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkRenderPassMultiviewCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->subpassCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pViewMasks,
                    forUnmarshaling->subpassCount * sizeof(const uint32_t));
    memcpy((uint32_t*)forUnmarshaling->pViewMasks, *ptr,
           forUnmarshaling->subpassCount * sizeof(const uint32_t));
    *ptr += forUnmarshaling->subpassCount * sizeof(const uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->dependencyCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pViewOffsets,
                    forUnmarshaling->dependencyCount * sizeof(const int32_t));
    memcpy((int32_t*)forUnmarshaling->pViewOffsets, *ptr,
           forUnmarshaling->dependencyCount * sizeof(const int32_t));
    *ptr += forUnmarshaling->dependencyCount * sizeof(const int32_t);
    memcpy((uint32_t*)&forUnmarshaling->correlationMaskCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pCorrelationMasks,
                    forUnmarshaling->correlationMaskCount * sizeof(const uint32_t));
    memcpy((uint32_t*)forUnmarshaling->pCorrelationMasks, *ptr,
           forUnmarshaling->correlationMaskCount * sizeof(const uint32_t));
    *ptr += forUnmarshaling->correlationMaskCount * sizeof(const uint32_t);
}

void reservedunmarshal_VkPhysicalDeviceMultiviewFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceMultiviewFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->multiview, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->multiviewGeometryShader, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->multiviewTessellationShader, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceMultiviewProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceMultiviewProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->maxMultiviewViewCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxMultiviewInstanceIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkPhysicalDeviceVariablePointersFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceVariablePointersFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->variablePointersStorageBuffer, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->variablePointers, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceProtectedMemoryFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceProtectedMemoryFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->protectedMemory, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceProtectedMemoryProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceProtectedMemoryProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->protectedNoFault, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkDeviceQueueInfo2(VulkanStream* vkStream, VkStructureType rootType,
                                          VkDeviceQueueInfo2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDeviceQueueCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkDeviceQueueCreateFlags));
    *ptr += sizeof(VkDeviceQueueCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->queueFamilyIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->queueIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkProtectedSubmitInfo(VulkanStream* vkStream, VkStructureType rootType,
                                             VkProtectedSubmitInfo* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->protectedSubmit, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkSamplerYcbcrConversionCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkSamplerYcbcrConversionCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkFormat*)&forUnmarshaling->format, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy((VkSamplerYcbcrModelConversion*)&forUnmarshaling->ycbcrModel, *ptr,
           sizeof(VkSamplerYcbcrModelConversion));
    *ptr += sizeof(VkSamplerYcbcrModelConversion);
    memcpy((VkSamplerYcbcrRange*)&forUnmarshaling->ycbcrRange, *ptr, sizeof(VkSamplerYcbcrRange));
    *ptr += sizeof(VkSamplerYcbcrRange);
    reservedunmarshal_VkComponentMapping(vkStream, rootType,
                                         (VkComponentMapping*)(&forUnmarshaling->components), ptr);
    memcpy((VkChromaLocation*)&forUnmarshaling->xChromaOffset, *ptr, sizeof(VkChromaLocation));
    *ptr += sizeof(VkChromaLocation);
    memcpy((VkChromaLocation*)&forUnmarshaling->yChromaOffset, *ptr, sizeof(VkChromaLocation));
    *ptr += sizeof(VkChromaLocation);
    memcpy((VkFilter*)&forUnmarshaling->chromaFilter, *ptr, sizeof(VkFilter));
    *ptr += sizeof(VkFilter);
    memcpy((VkBool32*)&forUnmarshaling->forceExplicitReconstruction, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkSamplerYcbcrConversionInfo(VulkanStream* vkStream,
                                                    VkStructureType rootType,
                                                    VkSamplerYcbcrConversionInfo* forUnmarshaling,
                                                    uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkSamplerYcbcrConversion*)&forUnmarshaling->conversion =
        (VkSamplerYcbcrConversion)unbox_VkSamplerYcbcrConversion(
            (VkSamplerYcbcrConversion)(*&cgen_var_0));
}

void reservedunmarshal_VkBindImagePlaneMemoryInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                  VkBindImagePlaneMemoryInfo* forUnmarshaling,
                                                  uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkImageAspectFlagBits*)&forUnmarshaling->planeAspect, *ptr,
           sizeof(VkImageAspectFlagBits));
    *ptr += sizeof(VkImageAspectFlagBits);
}

void reservedunmarshal_VkImagePlaneMemoryRequirementsInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkImagePlaneMemoryRequirementsInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkImageAspectFlagBits*)&forUnmarshaling->planeAspect, *ptr,
           sizeof(VkImageAspectFlagBits));
    *ptr += sizeof(VkImageAspectFlagBits);
}

void reservedunmarshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceSamplerYcbcrConversionFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->samplerYcbcrConversion, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkSamplerYcbcrConversionImageFormatProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkSamplerYcbcrConversionImageFormatProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->combinedImageSamplerDescriptorCount, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkDescriptorUpdateTemplateEntry(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDescriptorUpdateTemplateEntry* forUnmarshaling, uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->dstBinding, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->dstArrayElement, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->descriptorCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkDescriptorType*)&forUnmarshaling->descriptorType, *ptr, sizeof(VkDescriptorType));
    *ptr += sizeof(VkDescriptorType);
    memcpy((size_t*)&forUnmarshaling->offset, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->offset);
    *ptr += 8;
    memcpy((size_t*)&forUnmarshaling->stride, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->stride);
    *ptr += 8;
}

void reservedunmarshal_VkDescriptorUpdateTemplateCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDescriptorUpdateTemplateCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDescriptorUpdateTemplateCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkDescriptorUpdateTemplateCreateFlags));
    *ptr += sizeof(VkDescriptorUpdateTemplateCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->descriptorUpdateEntryCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pDescriptorUpdateEntries,
                    forUnmarshaling->descriptorUpdateEntryCount *
                        sizeof(const VkDescriptorUpdateTemplateEntry));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->descriptorUpdateEntryCount; ++i) {
        reservedunmarshal_VkDescriptorUpdateTemplateEntry(
            vkStream, rootType,
            (VkDescriptorUpdateTemplateEntry*)(forUnmarshaling->pDescriptorUpdateEntries + i), ptr);
    }
    memcpy((VkDescriptorUpdateTemplateType*)&forUnmarshaling->templateType, *ptr,
           sizeof(VkDescriptorUpdateTemplateType));
    *ptr += sizeof(VkDescriptorUpdateTemplateType);
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkDescriptorSetLayout*)&forUnmarshaling->descriptorSetLayout =
        (VkDescriptorSetLayout)unbox_VkDescriptorSetLayout((VkDescriptorSetLayout)(*&cgen_var_0));
    memcpy((VkPipelineBindPoint*)&forUnmarshaling->pipelineBindPoint, *ptr,
           sizeof(VkPipelineBindPoint));
    *ptr += sizeof(VkPipelineBindPoint);
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkPipelineLayout*)&forUnmarshaling->pipelineLayout =
        (VkPipelineLayout)unbox_VkPipelineLayout((VkPipelineLayout)(*&cgen_var_1));
    memcpy((uint32_t*)&forUnmarshaling->set, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkExternalMemoryProperties(VulkanStream* vkStream, VkStructureType rootType,
                                                  VkExternalMemoryProperties* forUnmarshaling,
                                                  uint8_t** ptr) {
    memcpy((VkExternalMemoryFeatureFlags*)&forUnmarshaling->externalMemoryFeatures, *ptr,
           sizeof(VkExternalMemoryFeatureFlags));
    *ptr += sizeof(VkExternalMemoryFeatureFlags);
    memcpy((VkExternalMemoryHandleTypeFlags*)&forUnmarshaling->exportFromImportedHandleTypes, *ptr,
           sizeof(VkExternalMemoryHandleTypeFlags));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlags);
    memcpy((VkExternalMemoryHandleTypeFlags*)&forUnmarshaling->compatibleHandleTypes, *ptr,
           sizeof(VkExternalMemoryHandleTypeFlags));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlags);
}

void reservedunmarshal_VkPhysicalDeviceExternalImageFormatInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceExternalImageFormatInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkExternalMemoryHandleTypeFlagBits*)&forUnmarshaling->handleType, *ptr,
           sizeof(VkExternalMemoryHandleTypeFlagBits));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlagBits);
}

void reservedunmarshal_VkExternalImageFormatProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkExternalImageFormatProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkExternalMemoryProperties(
        vkStream, rootType,
        (VkExternalMemoryProperties*)(&forUnmarshaling->externalMemoryProperties), ptr);
}

void reservedunmarshal_VkPhysicalDeviceExternalBufferInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceExternalBufferInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBufferCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkBufferCreateFlags));
    *ptr += sizeof(VkBufferCreateFlags);
    memcpy((VkBufferUsageFlags*)&forUnmarshaling->usage, *ptr, sizeof(VkBufferUsageFlags));
    *ptr += sizeof(VkBufferUsageFlags);
    memcpy((VkExternalMemoryHandleTypeFlagBits*)&forUnmarshaling->handleType, *ptr,
           sizeof(VkExternalMemoryHandleTypeFlagBits));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlagBits);
}

void reservedunmarshal_VkExternalBufferProperties(VulkanStream* vkStream, VkStructureType rootType,
                                                  VkExternalBufferProperties* forUnmarshaling,
                                                  uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkExternalMemoryProperties(
        vkStream, rootType,
        (VkExternalMemoryProperties*)(&forUnmarshaling->externalMemoryProperties), ptr);
}

void reservedunmarshal_VkPhysicalDeviceIDProperties(VulkanStream* vkStream,
                                                    VkStructureType rootType,
                                                    VkPhysicalDeviceIDProperties* forUnmarshaling,
                                                    uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint8_t*)forUnmarshaling->deviceUUID, *ptr, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
    memcpy((uint8_t*)forUnmarshaling->driverUUID, *ptr, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
    memcpy((uint8_t*)forUnmarshaling->deviceLUID, *ptr, VK_LUID_SIZE * sizeof(uint8_t));
    *ptr += VK_LUID_SIZE * sizeof(uint8_t);
    memcpy((uint32_t*)&forUnmarshaling->deviceNodeMask, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkBool32*)&forUnmarshaling->deviceLUIDValid, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkExternalMemoryImageCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkExternalMemoryImageCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkExternalMemoryHandleTypeFlags*)&forUnmarshaling->handleTypes, *ptr,
           sizeof(VkExternalMemoryHandleTypeFlags));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlags);
}

void reservedunmarshal_VkExternalMemoryBufferCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkExternalMemoryBufferCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkExternalMemoryHandleTypeFlags*)&forUnmarshaling->handleTypes, *ptr,
           sizeof(VkExternalMemoryHandleTypeFlags));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlags);
}

void reservedunmarshal_VkExportMemoryAllocateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                  VkExportMemoryAllocateInfo* forUnmarshaling,
                                                  uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkExternalMemoryHandleTypeFlags*)&forUnmarshaling->handleTypes, *ptr,
           sizeof(VkExternalMemoryHandleTypeFlags));
    *ptr += sizeof(VkExternalMemoryHandleTypeFlags);
}

void reservedunmarshal_VkPhysicalDeviceExternalFenceInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceExternalFenceInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkExternalFenceHandleTypeFlagBits*)&forUnmarshaling->handleType, *ptr,
           sizeof(VkExternalFenceHandleTypeFlagBits));
    *ptr += sizeof(VkExternalFenceHandleTypeFlagBits);
}

void reservedunmarshal_VkExternalFenceProperties(VulkanStream* vkStream, VkStructureType rootType,
                                                 VkExternalFenceProperties* forUnmarshaling,
                                                 uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkExternalFenceHandleTypeFlags*)&forUnmarshaling->exportFromImportedHandleTypes, *ptr,
           sizeof(VkExternalFenceHandleTypeFlags));
    *ptr += sizeof(VkExternalFenceHandleTypeFlags);
    memcpy((VkExternalFenceHandleTypeFlags*)&forUnmarshaling->compatibleHandleTypes, *ptr,
           sizeof(VkExternalFenceHandleTypeFlags));
    *ptr += sizeof(VkExternalFenceHandleTypeFlags);
    memcpy((VkExternalFenceFeatureFlags*)&forUnmarshaling->externalFenceFeatures, *ptr,
           sizeof(VkExternalFenceFeatureFlags));
    *ptr += sizeof(VkExternalFenceFeatureFlags);
}

void reservedunmarshal_VkExportFenceCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                               VkExportFenceCreateInfo* forUnmarshaling,
                                               uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkExternalFenceHandleTypeFlags*)&forUnmarshaling->handleTypes, *ptr,
           sizeof(VkExternalFenceHandleTypeFlags));
    *ptr += sizeof(VkExternalFenceHandleTypeFlags);
}

void reservedunmarshal_VkExportSemaphoreCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                   VkExportSemaphoreCreateInfo* forUnmarshaling,
                                                   uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkExternalSemaphoreHandleTypeFlags*)&forUnmarshaling->handleTypes, *ptr,
           sizeof(VkExternalSemaphoreHandleTypeFlags));
    *ptr += sizeof(VkExternalSemaphoreHandleTypeFlags);
}

void reservedunmarshal_VkPhysicalDeviceExternalSemaphoreInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceExternalSemaphoreInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkExternalSemaphoreHandleTypeFlagBits*)&forUnmarshaling->handleType, *ptr,
           sizeof(VkExternalSemaphoreHandleTypeFlagBits));
    *ptr += sizeof(VkExternalSemaphoreHandleTypeFlagBits);
}

void reservedunmarshal_VkExternalSemaphoreProperties(VulkanStream* vkStream,
                                                     VkStructureType rootType,
                                                     VkExternalSemaphoreProperties* forUnmarshaling,
                                                     uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkExternalSemaphoreHandleTypeFlags*)&forUnmarshaling->exportFromImportedHandleTypes,
           *ptr, sizeof(VkExternalSemaphoreHandleTypeFlags));
    *ptr += sizeof(VkExternalSemaphoreHandleTypeFlags);
    memcpy((VkExternalSemaphoreHandleTypeFlags*)&forUnmarshaling->compatibleHandleTypes, *ptr,
           sizeof(VkExternalSemaphoreHandleTypeFlags));
    *ptr += sizeof(VkExternalSemaphoreHandleTypeFlags);
    memcpy((VkExternalSemaphoreFeatureFlags*)&forUnmarshaling->externalSemaphoreFeatures, *ptr,
           sizeof(VkExternalSemaphoreFeatureFlags));
    *ptr += sizeof(VkExternalSemaphoreFeatureFlags);
}

void reservedunmarshal_VkPhysicalDeviceMaintenance3Properties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceMaintenance3Properties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->maxPerSetDescriptors, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkDeviceSize*)&forUnmarshaling->maxMemoryAllocationSize, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkDescriptorSetLayoutSupport(VulkanStream* vkStream,
                                                    VkStructureType rootType,
                                                    VkDescriptorSetLayoutSupport* forUnmarshaling,
                                                    uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->supported, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceShaderDrawParametersFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceShaderDrawParametersFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->shaderDrawParameters, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_VERSION_1_2
void reservedunmarshal_VkPhysicalDeviceVulkan11Features(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceVulkan11Features* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->storageBuffer16BitAccess, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->uniformAndStorageBuffer16BitAccess, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->storagePushConstant16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->storageInputOutput16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->multiview, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->multiviewGeometryShader, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->multiviewTessellationShader, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->variablePointersStorageBuffer, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->variablePointers, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->protectedMemory, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->samplerYcbcrConversion, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDrawParameters, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceVulkan11Properties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceVulkan11Properties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint8_t*)forUnmarshaling->deviceUUID, *ptr, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
    memcpy((uint8_t*)forUnmarshaling->driverUUID, *ptr, VK_UUID_SIZE * sizeof(uint8_t));
    *ptr += VK_UUID_SIZE * sizeof(uint8_t);
    memcpy((uint8_t*)forUnmarshaling->deviceLUID, *ptr, VK_LUID_SIZE * sizeof(uint8_t));
    *ptr += VK_LUID_SIZE * sizeof(uint8_t);
    memcpy((uint32_t*)&forUnmarshaling->deviceNodeMask, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkBool32*)&forUnmarshaling->deviceLUIDValid, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((uint32_t*)&forUnmarshaling->subgroupSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkShaderStageFlags*)&forUnmarshaling->subgroupSupportedStages, *ptr,
           sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    memcpy((VkSubgroupFeatureFlags*)&forUnmarshaling->subgroupSupportedOperations, *ptr,
           sizeof(VkSubgroupFeatureFlags));
    *ptr += sizeof(VkSubgroupFeatureFlags);
    memcpy((VkBool32*)&forUnmarshaling->subgroupQuadOperationsInAllStages, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkPointClippingBehavior*)&forUnmarshaling->pointClippingBehavior, *ptr,
           sizeof(VkPointClippingBehavior));
    *ptr += sizeof(VkPointClippingBehavior);
    memcpy((uint32_t*)&forUnmarshaling->maxMultiviewViewCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxMultiviewInstanceIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkBool32*)&forUnmarshaling->protectedNoFault, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((uint32_t*)&forUnmarshaling->maxPerSetDescriptors, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkDeviceSize*)&forUnmarshaling->maxMemoryAllocationSize, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkPhysicalDeviceVulkan12Features(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceVulkan12Features* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->samplerMirrorClampToEdge, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->drawIndirectCount, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->storageBuffer8BitAccess, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->uniformAndStorageBuffer8BitAccess, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->storagePushConstant8, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderBufferInt64Atomics, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderSharedInt64Atomics, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderFloat16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderInt8, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorIndexing, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderInputAttachmentArrayDynamicIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderUniformTexelBufferArrayDynamicIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageTexelBufferArrayDynamicIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderUniformBufferArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderSampledImageArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageBufferArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageImageArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderInputAttachmentArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderUniformTexelBufferArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageTexelBufferArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingUniformBufferUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingSampledImageUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingStorageImageUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingStorageBufferUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingUniformTexelBufferUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingStorageTexelBufferUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingUpdateUnusedWhilePending, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingPartiallyBound, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingVariableDescriptorCount, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->runtimeDescriptorArray, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->samplerFilterMinmax, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->scalarBlockLayout, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->imagelessFramebuffer, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->uniformBufferStandardLayout, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderSubgroupExtendedTypes, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->separateDepthStencilLayouts, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->hostQueryReset, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->timelineSemaphore, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->bufferDeviceAddress, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->bufferDeviceAddressCaptureReplay, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->bufferDeviceAddressMultiDevice, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->vulkanMemoryModel, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->vulkanMemoryModelDeviceScope, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->vulkanMemoryModelAvailabilityVisibilityChains, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderOutputViewportIndex, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderOutputLayer, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->subgroupBroadcastDynamicId, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkConformanceVersion(VulkanStream* vkStream, VkStructureType rootType,
                                            VkConformanceVersion* forUnmarshaling, uint8_t** ptr) {
    memcpy((uint8_t*)&forUnmarshaling->major, *ptr, sizeof(uint8_t));
    *ptr += sizeof(uint8_t);
    memcpy((uint8_t*)&forUnmarshaling->minor, *ptr, sizeof(uint8_t));
    *ptr += sizeof(uint8_t);
    memcpy((uint8_t*)&forUnmarshaling->subminor, *ptr, sizeof(uint8_t));
    *ptr += sizeof(uint8_t);
    memcpy((uint8_t*)&forUnmarshaling->patch, *ptr, sizeof(uint8_t));
    *ptr += sizeof(uint8_t);
}

void reservedunmarshal_VkPhysicalDeviceVulkan12Properties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceVulkan12Properties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDriverId*)&forUnmarshaling->driverID, *ptr, sizeof(VkDriverId));
    *ptr += sizeof(VkDriverId);
    memcpy((char*)forUnmarshaling->driverName, *ptr, VK_MAX_DRIVER_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_DRIVER_NAME_SIZE * sizeof(char);
    memcpy((char*)forUnmarshaling->driverInfo, *ptr, VK_MAX_DRIVER_INFO_SIZE * sizeof(char));
    *ptr += VK_MAX_DRIVER_INFO_SIZE * sizeof(char);
    reservedunmarshal_VkConformanceVersion(
        vkStream, rootType, (VkConformanceVersion*)(&forUnmarshaling->conformanceVersion), ptr);
    memcpy((VkShaderFloatControlsIndependence*)&forUnmarshaling->denormBehaviorIndependence, *ptr,
           sizeof(VkShaderFloatControlsIndependence));
    *ptr += sizeof(VkShaderFloatControlsIndependence);
    memcpy((VkShaderFloatControlsIndependence*)&forUnmarshaling->roundingModeIndependence, *ptr,
           sizeof(VkShaderFloatControlsIndependence));
    *ptr += sizeof(VkShaderFloatControlsIndependence);
    memcpy((VkBool32*)&forUnmarshaling->shaderSignedZeroInfNanPreserveFloat16, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderSignedZeroInfNanPreserveFloat32, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderSignedZeroInfNanPreserveFloat64, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDenormPreserveFloat16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDenormPreserveFloat32, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDenormPreserveFloat64, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDenormFlushToZeroFloat16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDenormFlushToZeroFloat32, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDenormFlushToZeroFloat64, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderRoundingModeRTEFloat16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderRoundingModeRTEFloat32, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderRoundingModeRTEFloat64, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderRoundingModeRTZFloat16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderRoundingModeRTZFloat32, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderRoundingModeRTZFloat64, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((uint32_t*)&forUnmarshaling->maxUpdateAfterBindDescriptorsInAllPools, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkBool32*)&forUnmarshaling->shaderUniformBufferArrayNonUniformIndexingNative, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderSampledImageArrayNonUniformIndexingNative, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageBufferArrayNonUniformIndexingNative, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageImageArrayNonUniformIndexingNative, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderInputAttachmentArrayNonUniformIndexingNative, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->robustBufferAccessUpdateAfterBind, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->quadDivergentImplicitLod, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindSamplers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindUniformBuffers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindStorageBuffers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindSampledImages, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindStorageImages, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindInputAttachments, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageUpdateAfterBindResources, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindSamplers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindUniformBuffers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindStorageBuffers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindSampledImages, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindStorageImages, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindInputAttachments, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkResolveModeFlags*)&forUnmarshaling->supportedDepthResolveModes, *ptr,
           sizeof(VkResolveModeFlags));
    *ptr += sizeof(VkResolveModeFlags);
    memcpy((VkResolveModeFlags*)&forUnmarshaling->supportedStencilResolveModes, *ptr,
           sizeof(VkResolveModeFlags));
    *ptr += sizeof(VkResolveModeFlags);
    memcpy((VkBool32*)&forUnmarshaling->independentResolveNone, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->independentResolve, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->filterMinmaxSingleComponentFormats, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->filterMinmaxImageComponentMapping, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((uint64_t*)&forUnmarshaling->maxTimelineSemaphoreValueDifference, *ptr,
           sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy((VkSampleCountFlags*)&forUnmarshaling->framebufferIntegerColorSampleCounts, *ptr,
           sizeof(VkSampleCountFlags));
    *ptr += sizeof(VkSampleCountFlags);
}

void reservedunmarshal_VkImageFormatListCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                   VkImageFormatListCreateInfo* forUnmarshaling,
                                                   uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->viewFormatCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pViewFormats,
                    forUnmarshaling->viewFormatCount * sizeof(const VkFormat));
    memcpy((VkFormat*)forUnmarshaling->pViewFormats, *ptr,
           forUnmarshaling->viewFormatCount * sizeof(const VkFormat));
    *ptr += forUnmarshaling->viewFormatCount * sizeof(const VkFormat);
}

void reservedunmarshal_VkAttachmentDescription2(VulkanStream* vkStream, VkStructureType rootType,
                                                VkAttachmentDescription2* forUnmarshaling,
                                                uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkAttachmentDescriptionFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkAttachmentDescriptionFlags));
    *ptr += sizeof(VkAttachmentDescriptionFlags);
    memcpy((VkFormat*)&forUnmarshaling->format, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy((VkSampleCountFlagBits*)&forUnmarshaling->samples, *ptr, sizeof(VkSampleCountFlagBits));
    *ptr += sizeof(VkSampleCountFlagBits);
    memcpy((VkAttachmentLoadOp*)&forUnmarshaling->loadOp, *ptr, sizeof(VkAttachmentLoadOp));
    *ptr += sizeof(VkAttachmentLoadOp);
    memcpy((VkAttachmentStoreOp*)&forUnmarshaling->storeOp, *ptr, sizeof(VkAttachmentStoreOp));
    *ptr += sizeof(VkAttachmentStoreOp);
    memcpy((VkAttachmentLoadOp*)&forUnmarshaling->stencilLoadOp, *ptr, sizeof(VkAttachmentLoadOp));
    *ptr += sizeof(VkAttachmentLoadOp);
    memcpy((VkAttachmentStoreOp*)&forUnmarshaling->stencilStoreOp, *ptr,
           sizeof(VkAttachmentStoreOp));
    *ptr += sizeof(VkAttachmentStoreOp);
    memcpy((VkImageLayout*)&forUnmarshaling->initialLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((VkImageLayout*)&forUnmarshaling->finalLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedunmarshal_VkAttachmentReference2(VulkanStream* vkStream, VkStructureType rootType,
                                              VkAttachmentReference2* forUnmarshaling,
                                              uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->attachment, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkImageLayout*)&forUnmarshaling->layout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((VkImageAspectFlags*)&forUnmarshaling->aspectMask, *ptr, sizeof(VkImageAspectFlags));
    *ptr += sizeof(VkImageAspectFlags);
}

void reservedunmarshal_VkSubpassDescription2(VulkanStream* vkStream, VkStructureType rootType,
                                             VkSubpassDescription2* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkSubpassDescriptionFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkSubpassDescriptionFlags));
    *ptr += sizeof(VkSubpassDescriptionFlags);
    memcpy((VkPipelineBindPoint*)&forUnmarshaling->pipelineBindPoint, *ptr,
           sizeof(VkPipelineBindPoint));
    *ptr += sizeof(VkPipelineBindPoint);
    memcpy((uint32_t*)&forUnmarshaling->viewMask, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->inputAttachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pInputAttachments,
                    forUnmarshaling->inputAttachmentCount * sizeof(const VkAttachmentReference2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->inputAttachmentCount; ++i) {
        reservedunmarshal_VkAttachmentReference2(
            vkStream, rootType, (VkAttachmentReference2*)(forUnmarshaling->pInputAttachments + i),
            ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->colorAttachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pColorAttachments,
                    forUnmarshaling->colorAttachmentCount * sizeof(const VkAttachmentReference2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->colorAttachmentCount; ++i) {
        reservedunmarshal_VkAttachmentReference2(
            vkStream, rootType, (VkAttachmentReference2*)(forUnmarshaling->pColorAttachments + i),
            ptr);
    }
    // WARNING PTR CHECK
    memcpy((VkAttachmentReference2**)&forUnmarshaling->pResolveAttachments, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pResolveAttachments);
    *ptr += 8;
    if (forUnmarshaling->pResolveAttachments) {
        vkStream->alloc(
            (void**)&forUnmarshaling->pResolveAttachments,
            forUnmarshaling->colorAttachmentCount * sizeof(const VkAttachmentReference2));
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->colorAttachmentCount; ++i) {
            reservedunmarshal_VkAttachmentReference2(
                vkStream, rootType,
                (VkAttachmentReference2*)(forUnmarshaling->pResolveAttachments + i), ptr);
        }
    }
    // WARNING PTR CHECK
    memcpy((VkAttachmentReference2**)&forUnmarshaling->pDepthStencilAttachment, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pDepthStencilAttachment);
    *ptr += 8;
    if (forUnmarshaling->pDepthStencilAttachment) {
        vkStream->alloc((void**)&forUnmarshaling->pDepthStencilAttachment,
                        sizeof(const VkAttachmentReference2));
        reservedunmarshal_VkAttachmentReference2(
            vkStream, rootType, (VkAttachmentReference2*)(forUnmarshaling->pDepthStencilAttachment),
            ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->preserveAttachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pPreserveAttachments,
                    forUnmarshaling->preserveAttachmentCount * sizeof(const uint32_t));
    memcpy((uint32_t*)forUnmarshaling->pPreserveAttachments, *ptr,
           forUnmarshaling->preserveAttachmentCount * sizeof(const uint32_t));
    *ptr += forUnmarshaling->preserveAttachmentCount * sizeof(const uint32_t);
}

void reservedunmarshal_VkSubpassDependency2(VulkanStream* vkStream, VkStructureType rootType,
                                            VkSubpassDependency2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->srcSubpass, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->dstSubpass, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkPipelineStageFlags*)&forUnmarshaling->srcStageMask, *ptr,
           sizeof(VkPipelineStageFlags));
    *ptr += sizeof(VkPipelineStageFlags);
    memcpy((VkPipelineStageFlags*)&forUnmarshaling->dstStageMask, *ptr,
           sizeof(VkPipelineStageFlags));
    *ptr += sizeof(VkPipelineStageFlags);
    memcpy((VkAccessFlags*)&forUnmarshaling->srcAccessMask, *ptr, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy((VkAccessFlags*)&forUnmarshaling->dstAccessMask, *ptr, sizeof(VkAccessFlags));
    *ptr += sizeof(VkAccessFlags);
    memcpy((VkDependencyFlags*)&forUnmarshaling->dependencyFlags, *ptr, sizeof(VkDependencyFlags));
    *ptr += sizeof(VkDependencyFlags);
    memcpy((int32_t*)&forUnmarshaling->viewOffset, *ptr, sizeof(int32_t));
    *ptr += sizeof(int32_t);
}

void reservedunmarshal_VkRenderPassCreateInfo2(VulkanStream* vkStream, VkStructureType rootType,
                                               VkRenderPassCreateInfo2* forUnmarshaling,
                                               uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkRenderPassCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkRenderPassCreateFlags));
    *ptr += sizeof(VkRenderPassCreateFlags);
    memcpy((uint32_t*)&forUnmarshaling->attachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pAttachments,
                    forUnmarshaling->attachmentCount * sizeof(const VkAttachmentDescription2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->attachmentCount; ++i) {
        reservedunmarshal_VkAttachmentDescription2(
            vkStream, rootType, (VkAttachmentDescription2*)(forUnmarshaling->pAttachments + i),
            ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->subpassCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pSubpasses,
                    forUnmarshaling->subpassCount * sizeof(const VkSubpassDescription2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->subpassCount; ++i) {
        reservedunmarshal_VkSubpassDescription2(
            vkStream, rootType, (VkSubpassDescription2*)(forUnmarshaling->pSubpasses + i), ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->dependencyCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pDependencies,
                    forUnmarshaling->dependencyCount * sizeof(const VkSubpassDependency2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->dependencyCount; ++i) {
        reservedunmarshal_VkSubpassDependency2(
            vkStream, rootType, (VkSubpassDependency2*)(forUnmarshaling->pDependencies + i), ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->correlatedViewMaskCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pCorrelatedViewMasks,
                    forUnmarshaling->correlatedViewMaskCount * sizeof(const uint32_t));
    memcpy((uint32_t*)forUnmarshaling->pCorrelatedViewMasks, *ptr,
           forUnmarshaling->correlatedViewMaskCount * sizeof(const uint32_t));
    *ptr += forUnmarshaling->correlatedViewMaskCount * sizeof(const uint32_t);
}

void reservedunmarshal_VkSubpassBeginInfo(VulkanStream* vkStream, VkStructureType rootType,
                                          VkSubpassBeginInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkSubpassContents*)&forUnmarshaling->contents, *ptr, sizeof(VkSubpassContents));
    *ptr += sizeof(VkSubpassContents);
}

void reservedunmarshal_VkSubpassEndInfo(VulkanStream* vkStream, VkStructureType rootType,
                                        VkSubpassEndInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
}

void reservedunmarshal_VkPhysicalDevice8BitStorageFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDevice8BitStorageFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->storageBuffer8BitAccess, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->uniformAndStorageBuffer8BitAccess, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->storagePushConstant8, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceDriverProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceDriverProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDriverId*)&forUnmarshaling->driverID, *ptr, sizeof(VkDriverId));
    *ptr += sizeof(VkDriverId);
    memcpy((char*)forUnmarshaling->driverName, *ptr, VK_MAX_DRIVER_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_DRIVER_NAME_SIZE * sizeof(char);
    memcpy((char*)forUnmarshaling->driverInfo, *ptr, VK_MAX_DRIVER_INFO_SIZE * sizeof(char));
    *ptr += VK_MAX_DRIVER_INFO_SIZE * sizeof(char);
    reservedunmarshal_VkConformanceVersion(
        vkStream, rootType, (VkConformanceVersion*)(&forUnmarshaling->conformanceVersion), ptr);
}

void reservedunmarshal_VkPhysicalDeviceShaderAtomicInt64Features(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceShaderAtomicInt64Features* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->shaderBufferInt64Atomics, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderSharedInt64Atomics, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceShaderFloat16Int8Features(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceShaderFloat16Int8Features* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->shaderFloat16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderInt8, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceFloatControlsProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceFloatControlsProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkShaderFloatControlsIndependence*)&forUnmarshaling->denormBehaviorIndependence, *ptr,
           sizeof(VkShaderFloatControlsIndependence));
    *ptr += sizeof(VkShaderFloatControlsIndependence);
    memcpy((VkShaderFloatControlsIndependence*)&forUnmarshaling->roundingModeIndependence, *ptr,
           sizeof(VkShaderFloatControlsIndependence));
    *ptr += sizeof(VkShaderFloatControlsIndependence);
    memcpy((VkBool32*)&forUnmarshaling->shaderSignedZeroInfNanPreserveFloat16, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderSignedZeroInfNanPreserveFloat32, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderSignedZeroInfNanPreserveFloat64, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDenormPreserveFloat16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDenormPreserveFloat32, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDenormPreserveFloat64, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDenormFlushToZeroFloat16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDenormFlushToZeroFloat32, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDenormFlushToZeroFloat64, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderRoundingModeRTEFloat16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderRoundingModeRTEFloat32, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderRoundingModeRTEFloat64, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderRoundingModeRTZFloat16, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderRoundingModeRTZFloat32, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderRoundingModeRTZFloat64, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDescriptorSetLayoutBindingFlagsCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->bindingCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    memcpy((VkDescriptorBindingFlags**)&forUnmarshaling->pBindingFlags, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pBindingFlags);
    *ptr += 8;
    if (forUnmarshaling->pBindingFlags) {
        vkStream->alloc((void**)&forUnmarshaling->pBindingFlags,
                        forUnmarshaling->bindingCount * sizeof(const VkDescriptorBindingFlags));
        memcpy((VkDescriptorBindingFlags*)forUnmarshaling->pBindingFlags, *ptr,
               forUnmarshaling->bindingCount * sizeof(const VkDescriptorBindingFlags));
        *ptr += forUnmarshaling->bindingCount * sizeof(const VkDescriptorBindingFlags);
    }
}

void reservedunmarshal_VkPhysicalDeviceDescriptorIndexingFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceDescriptorIndexingFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->shaderInputAttachmentArrayDynamicIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderUniformTexelBufferArrayDynamicIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageTexelBufferArrayDynamicIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderUniformBufferArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderSampledImageArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageBufferArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageImageArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderInputAttachmentArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderUniformTexelBufferArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageTexelBufferArrayNonUniformIndexing, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingUniformBufferUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingSampledImageUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingStorageImageUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingStorageBufferUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingUniformTexelBufferUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingStorageTexelBufferUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingUpdateUnusedWhilePending, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingPartiallyBound, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingVariableDescriptorCount, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->runtimeDescriptorArray, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceDescriptorIndexingProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceDescriptorIndexingProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->maxUpdateAfterBindDescriptorsInAllPools, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkBool32*)&forUnmarshaling->shaderUniformBufferArrayNonUniformIndexingNative, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderSampledImageArrayNonUniformIndexingNative, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageBufferArrayNonUniformIndexingNative, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderStorageImageArrayNonUniformIndexingNative, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderInputAttachmentArrayNonUniformIndexingNative, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->robustBufferAccessUpdateAfterBind, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->quadDivergentImplicitLod, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindSamplers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindUniformBuffers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindStorageBuffers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindSampledImages, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindStorageImages, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindInputAttachments, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageUpdateAfterBindResources, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindSamplers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindUniformBuffers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindUniformBuffersDynamic, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindStorageBuffers, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindStorageBuffersDynamic, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindSampledImages, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindStorageImages, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindInputAttachments, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDescriptorSetVariableDescriptorCountAllocateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->descriptorSetCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pDescriptorCounts,
                    forUnmarshaling->descriptorSetCount * sizeof(const uint32_t));
    memcpy((uint32_t*)forUnmarshaling->pDescriptorCounts, *ptr,
           forUnmarshaling->descriptorSetCount * sizeof(const uint32_t));
    *ptr += forUnmarshaling->descriptorSetCount * sizeof(const uint32_t);
}

void reservedunmarshal_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDescriptorSetVariableDescriptorCountLayoutSupport* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->maxVariableDescriptorCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkSubpassDescriptionDepthStencilResolve(
    VulkanStream* vkStream, VkStructureType rootType,
    VkSubpassDescriptionDepthStencilResolve* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkResolveModeFlagBits*)&forUnmarshaling->depthResolveMode, *ptr,
           sizeof(VkResolveModeFlagBits));
    *ptr += sizeof(VkResolveModeFlagBits);
    memcpy((VkResolveModeFlagBits*)&forUnmarshaling->stencilResolveMode, *ptr,
           sizeof(VkResolveModeFlagBits));
    *ptr += sizeof(VkResolveModeFlagBits);
    // WARNING PTR CHECK
    memcpy((VkAttachmentReference2**)&forUnmarshaling->pDepthStencilResolveAttachment, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pDepthStencilResolveAttachment);
    *ptr += 8;
    if (forUnmarshaling->pDepthStencilResolveAttachment) {
        vkStream->alloc((void**)&forUnmarshaling->pDepthStencilResolveAttachment,
                        sizeof(const VkAttachmentReference2));
        reservedunmarshal_VkAttachmentReference2(
            vkStream, rootType,
            (VkAttachmentReference2*)(forUnmarshaling->pDepthStencilResolveAttachment), ptr);
    }
}

void reservedunmarshal_VkPhysicalDeviceDepthStencilResolveProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceDepthStencilResolveProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkResolveModeFlags*)&forUnmarshaling->supportedDepthResolveModes, *ptr,
           sizeof(VkResolveModeFlags));
    *ptr += sizeof(VkResolveModeFlags);
    memcpy((VkResolveModeFlags*)&forUnmarshaling->supportedStencilResolveModes, *ptr,
           sizeof(VkResolveModeFlags));
    *ptr += sizeof(VkResolveModeFlags);
    memcpy((VkBool32*)&forUnmarshaling->independentResolveNone, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->independentResolve, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceScalarBlockLayoutFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceScalarBlockLayoutFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->scalarBlockLayout, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkImageStencilUsageCreateInfo(VulkanStream* vkStream,
                                                     VkStructureType rootType,
                                                     VkImageStencilUsageCreateInfo* forUnmarshaling,
                                                     uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkImageUsageFlags*)&forUnmarshaling->stencilUsage, *ptr, sizeof(VkImageUsageFlags));
    *ptr += sizeof(VkImageUsageFlags);
}

void reservedunmarshal_VkSamplerReductionModeCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkSamplerReductionModeCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkSamplerReductionMode*)&forUnmarshaling->reductionMode, *ptr,
           sizeof(VkSamplerReductionMode));
    *ptr += sizeof(VkSamplerReductionMode);
}

void reservedunmarshal_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceSamplerFilterMinmaxProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->filterMinmaxSingleComponentFormats, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->filterMinmaxImageComponentMapping, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceVulkanMemoryModelFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceVulkanMemoryModelFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->vulkanMemoryModel, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->vulkanMemoryModelDeviceScope, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->vulkanMemoryModelAvailabilityVisibilityChains, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceImagelessFramebufferFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceImagelessFramebufferFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->imagelessFramebuffer, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkFramebufferAttachmentImageInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkFramebufferAttachmentImageInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkImageCreateFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkImageCreateFlags));
    *ptr += sizeof(VkImageCreateFlags);
    memcpy((VkImageUsageFlags*)&forUnmarshaling->usage, *ptr, sizeof(VkImageUsageFlags));
    *ptr += sizeof(VkImageUsageFlags);
    memcpy((uint32_t*)&forUnmarshaling->width, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->height, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->layerCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->viewFormatCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pViewFormats,
                    forUnmarshaling->viewFormatCount * sizeof(const VkFormat));
    memcpy((VkFormat*)forUnmarshaling->pViewFormats, *ptr,
           forUnmarshaling->viewFormatCount * sizeof(const VkFormat));
    *ptr += forUnmarshaling->viewFormatCount * sizeof(const VkFormat);
}

void reservedunmarshal_VkFramebufferAttachmentsCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkFramebufferAttachmentsCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->attachmentImageInfoCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc(
        (void**)&forUnmarshaling->pAttachmentImageInfos,
        forUnmarshaling->attachmentImageInfoCount * sizeof(const VkFramebufferAttachmentImageInfo));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->attachmentImageInfoCount; ++i) {
        reservedunmarshal_VkFramebufferAttachmentImageInfo(
            vkStream, rootType,
            (VkFramebufferAttachmentImageInfo*)(forUnmarshaling->pAttachmentImageInfos + i), ptr);
    }
}

void reservedunmarshal_VkRenderPassAttachmentBeginInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkRenderPassAttachmentBeginInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->attachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pAttachments,
                    forUnmarshaling->attachmentCount * sizeof(const VkImageView));
    if (forUnmarshaling->attachmentCount) {
        uint8_t* cgen_var_0_ptr = (uint8_t*)(*ptr);
        *ptr += 8 * forUnmarshaling->attachmentCount;
        if (forUnmarshaling) {
            for (uint32_t k = 0; k < forUnmarshaling->attachmentCount; ++k) {
                uint64_t tmpval;
                memcpy(&tmpval, cgen_var_0_ptr + k * 8, sizeof(uint64_t));
                *(((VkImageView*)forUnmarshaling->pAttachments) + k) =
                    (VkImageView)unbox_VkImageView((VkImageView)tmpval);
            }
        }
    }
}

void reservedunmarshal_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->uniformBufferStandardLayout, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->shaderSubgroupExtendedTypes, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->separateDepthStencilLayouts, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkAttachmentReferenceStencilLayout(
    VulkanStream* vkStream, VkStructureType rootType,
    VkAttachmentReferenceStencilLayout* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkImageLayout*)&forUnmarshaling->stencilLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedunmarshal_VkAttachmentDescriptionStencilLayout(
    VulkanStream* vkStream, VkStructureType rootType,
    VkAttachmentDescriptionStencilLayout* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkImageLayout*)&forUnmarshaling->stencilInitialLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((VkImageLayout*)&forUnmarshaling->stencilFinalLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedunmarshal_VkPhysicalDeviceHostQueryResetFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceHostQueryResetFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->hostQueryReset, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceTimelineSemaphoreFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceTimelineSemaphoreFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->timelineSemaphore, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceTimelineSemaphoreProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceTimelineSemaphoreProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint64_t*)&forUnmarshaling->maxTimelineSemaphoreValueDifference, *ptr,
           sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedunmarshal_VkSemaphoreTypeCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                 VkSemaphoreTypeCreateInfo* forUnmarshaling,
                                                 uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkSemaphoreType*)&forUnmarshaling->semaphoreType, *ptr, sizeof(VkSemaphoreType));
    *ptr += sizeof(VkSemaphoreType);
    memcpy((uint64_t*)&forUnmarshaling->initialValue, *ptr, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedunmarshal_VkTimelineSemaphoreSubmitInfo(VulkanStream* vkStream,
                                                     VkStructureType rootType,
                                                     VkTimelineSemaphoreSubmitInfo* forUnmarshaling,
                                                     uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->waitSemaphoreValueCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    memcpy((uint64_t**)&forUnmarshaling->pWaitSemaphoreValues, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pWaitSemaphoreValues);
    *ptr += 8;
    if (forUnmarshaling->pWaitSemaphoreValues) {
        vkStream->alloc((void**)&forUnmarshaling->pWaitSemaphoreValues,
                        forUnmarshaling->waitSemaphoreValueCount * sizeof(const uint64_t));
        memcpy((uint64_t*)forUnmarshaling->pWaitSemaphoreValues, *ptr,
               forUnmarshaling->waitSemaphoreValueCount * sizeof(const uint64_t));
        *ptr += forUnmarshaling->waitSemaphoreValueCount * sizeof(const uint64_t);
    }
    memcpy((uint32_t*)&forUnmarshaling->signalSemaphoreValueCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    memcpy((uint64_t**)&forUnmarshaling->pSignalSemaphoreValues, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pSignalSemaphoreValues);
    *ptr += 8;
    if (forUnmarshaling->pSignalSemaphoreValues) {
        vkStream->alloc((void**)&forUnmarshaling->pSignalSemaphoreValues,
                        forUnmarshaling->signalSemaphoreValueCount * sizeof(const uint64_t));
        memcpy((uint64_t*)forUnmarshaling->pSignalSemaphoreValues, *ptr,
               forUnmarshaling->signalSemaphoreValueCount * sizeof(const uint64_t));
        *ptr += forUnmarshaling->signalSemaphoreValueCount * sizeof(const uint64_t);
    }
}

void reservedunmarshal_VkSemaphoreWaitInfo(VulkanStream* vkStream, VkStructureType rootType,
                                           VkSemaphoreWaitInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkSemaphoreWaitFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkSemaphoreWaitFlags));
    *ptr += sizeof(VkSemaphoreWaitFlags);
    memcpy((uint32_t*)&forUnmarshaling->semaphoreCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pSemaphores,
                    forUnmarshaling->semaphoreCount * sizeof(const VkSemaphore));
    if (forUnmarshaling->semaphoreCount) {
        uint8_t* cgen_var_0_ptr = (uint8_t*)(*ptr);
        *ptr += 8 * forUnmarshaling->semaphoreCount;
        if (forUnmarshaling) {
            for (uint32_t k = 0; k < forUnmarshaling->semaphoreCount; ++k) {
                uint64_t tmpval;
                memcpy(&tmpval, cgen_var_0_ptr + k * 8, sizeof(uint64_t));
                *(((VkSemaphore*)forUnmarshaling->pSemaphores) + k) =
                    (VkSemaphore)unbox_VkSemaphore((VkSemaphore)tmpval);
            }
        }
    }
    vkStream->alloc((void**)&forUnmarshaling->pValues,
                    forUnmarshaling->semaphoreCount * sizeof(const uint64_t));
    memcpy((uint64_t*)forUnmarshaling->pValues, *ptr,
           forUnmarshaling->semaphoreCount * sizeof(const uint64_t));
    *ptr += forUnmarshaling->semaphoreCount * sizeof(const uint64_t);
}

void reservedunmarshal_VkSemaphoreSignalInfo(VulkanStream* vkStream, VkStructureType rootType,
                                             VkSemaphoreSignalInfo* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkSemaphore*)&forUnmarshaling->semaphore =
        (VkSemaphore)unbox_VkSemaphore((VkSemaphore)(*&cgen_var_0));
    memcpy((uint64_t*)&forUnmarshaling->value, *ptr, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedunmarshal_VkPhysicalDeviceBufferDeviceAddressFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceBufferDeviceAddressFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->bufferDeviceAddress, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->bufferDeviceAddressCaptureReplay, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->bufferDeviceAddressMultiDevice, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkBufferDeviceAddressInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                 VkBufferDeviceAddressInfo* forUnmarshaling,
                                                 uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkBuffer*)&forUnmarshaling->buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
}

void reservedunmarshal_VkBufferOpaqueCaptureAddressCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkBufferOpaqueCaptureAddressCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint64_t*)&forUnmarshaling->opaqueCaptureAddress, *ptr, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedunmarshal_VkMemoryOpaqueCaptureAddressAllocateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkMemoryOpaqueCaptureAddressAllocateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint64_t*)&forUnmarshaling->opaqueCaptureAddress, *ptr, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedunmarshal_VkDeviceMemoryOpaqueCaptureAddressInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDeviceMemoryOpaqueCaptureAddressInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkDeviceMemory*)&forUnmarshaling->memory =
        (VkDeviceMemory)unbox_VkDeviceMemory((VkDeviceMemory)(*&cgen_var_0));
}

#endif
#ifdef VK_VERSION_1_3
void reservedunmarshal_VkPhysicalDeviceVulkan13Features(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceVulkan13Features* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->robustImageAccess, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->inlineUniformBlock, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingInlineUniformBlockUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->pipelineCreationCacheControl, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->privateData, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderDemoteToHelperInvocation, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderTerminateInvocation, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->subgroupSizeControl, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->computeFullSubgroups, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->synchronization2, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->textureCompressionASTC_HDR, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderZeroInitializeWorkgroupMemory, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->dynamicRendering, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->shaderIntegerDotProduct, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->maintenance4, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceVulkan13Properties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceVulkan13Properties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->minSubgroupSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxSubgroupSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxComputeWorkgroupSubgroups, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkShaderStageFlags*)&forUnmarshaling->requiredSubgroupSizeStages, *ptr,
           sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    memcpy((uint32_t*)&forUnmarshaling->maxInlineUniformBlockSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorInlineUniformBlocks, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks,
           *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetInlineUniformBlocks, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindInlineUniformBlocks, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxInlineUniformTotalSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct8BitUnsignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct8BitSignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct8BitMixedSignednessAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct4x8BitPackedUnsignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct4x8BitPackedSignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct4x8BitPackedMixedSignednessAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct16BitUnsignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct16BitSignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct16BitMixedSignednessAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct32BitUnsignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct32BitSignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct32BitMixedSignednessAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct64BitUnsignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct64BitSignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct64BitMixedSignednessAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(
        (VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated,
        *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(
        (VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating8BitSignedAccelerated,
        *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(
        (VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating16BitSignedAccelerated,
        *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(
        (VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating32BitSignedAccelerated,
        *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(
        (VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating64BitSignedAccelerated,
        *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkDeviceSize*)&forUnmarshaling->storageTexelBufferOffsetAlignmentBytes, *ptr,
           sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkBool32*)&forUnmarshaling->storageTexelBufferOffsetSingleTexelAlignment, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkDeviceSize*)&forUnmarshaling->uniformTexelBufferOffsetAlignmentBytes, *ptr,
           sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkBool32*)&forUnmarshaling->uniformTexelBufferOffsetSingleTexelAlignment, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkDeviceSize*)&forUnmarshaling->maxBufferSize, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkPipelineCreationFeedback(VulkanStream* vkStream, VkStructureType rootType,
                                                  VkPipelineCreationFeedback* forUnmarshaling,
                                                  uint8_t** ptr) {
    memcpy((VkPipelineCreationFeedbackFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineCreationFeedbackFlags));
    *ptr += sizeof(VkPipelineCreationFeedbackFlags);
    memcpy((uint64_t*)&forUnmarshaling->duration, *ptr, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedunmarshal_VkPipelineCreationFeedbackCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineCreationFeedbackCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    vkStream->alloc((void**)&forUnmarshaling->pPipelineCreationFeedback,
                    sizeof(VkPipelineCreationFeedback));
    reservedunmarshal_VkPipelineCreationFeedback(
        vkStream, rootType,
        (VkPipelineCreationFeedback*)(forUnmarshaling->pPipelineCreationFeedback), ptr);
    memcpy((uint32_t*)&forUnmarshaling->pipelineStageCreationFeedbackCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc(
        (void**)&forUnmarshaling->pPipelineStageCreationFeedbacks,
        forUnmarshaling->pipelineStageCreationFeedbackCount * sizeof(VkPipelineCreationFeedback));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->pipelineStageCreationFeedbackCount; ++i) {
        reservedunmarshal_VkPipelineCreationFeedback(
            vkStream, rootType,
            (VkPipelineCreationFeedback*)(forUnmarshaling->pPipelineStageCreationFeedbacks + i),
            ptr);
    }
}

void reservedunmarshal_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceShaderTerminateInvocationFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->shaderTerminateInvocation, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceToolProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceToolProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((char*)forUnmarshaling->name, *ptr, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
    memcpy((char*)forUnmarshaling->version, *ptr, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
    memcpy((VkToolPurposeFlags*)&forUnmarshaling->purposes, *ptr, sizeof(VkToolPurposeFlags));
    *ptr += sizeof(VkToolPurposeFlags);
    memcpy((char*)forUnmarshaling->description, *ptr, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy((char*)forUnmarshaling->layer, *ptr, VK_MAX_EXTENSION_NAME_SIZE * sizeof(char));
    *ptr += VK_MAX_EXTENSION_NAME_SIZE * sizeof(char);
}

void reservedunmarshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->shaderDemoteToHelperInvocation, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDevicePrivateDataFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDevicePrivateDataFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->privateData, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkDevicePrivateDataCreateInfo(VulkanStream* vkStream,
                                                     VkStructureType rootType,
                                                     VkDevicePrivateDataCreateInfo* forUnmarshaling,
                                                     uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->privateDataSlotRequestCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkPrivateDataSlotCreateInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                   VkPrivateDataSlotCreateInfo* forUnmarshaling,
                                                   uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPrivateDataSlotCreateFlags*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPrivateDataSlotCreateFlags));
    *ptr += sizeof(VkPrivateDataSlotCreateFlags);
}

void reservedunmarshal_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDevicePipelineCreationCacheControlFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->pipelineCreationCacheControl, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkMemoryBarrier2(VulkanStream* vkStream, VkStructureType rootType,
                                        VkMemoryBarrier2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineStageFlags2*)&forUnmarshaling->srcStageMask, *ptr,
           sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy((VkAccessFlags2*)&forUnmarshaling->srcAccessMask, *ptr, sizeof(VkAccessFlags2));
    *ptr += sizeof(VkAccessFlags2);
    memcpy((VkPipelineStageFlags2*)&forUnmarshaling->dstStageMask, *ptr,
           sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy((VkAccessFlags2*)&forUnmarshaling->dstAccessMask, *ptr, sizeof(VkAccessFlags2));
    *ptr += sizeof(VkAccessFlags2);
}

void reservedunmarshal_VkBufferMemoryBarrier2(VulkanStream* vkStream, VkStructureType rootType,
                                              VkBufferMemoryBarrier2* forUnmarshaling,
                                              uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineStageFlags2*)&forUnmarshaling->srcStageMask, *ptr,
           sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy((VkAccessFlags2*)&forUnmarshaling->srcAccessMask, *ptr, sizeof(VkAccessFlags2));
    *ptr += sizeof(VkAccessFlags2);
    memcpy((VkPipelineStageFlags2*)&forUnmarshaling->dstStageMask, *ptr,
           sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy((VkAccessFlags2*)&forUnmarshaling->dstAccessMask, *ptr, sizeof(VkAccessFlags2));
    *ptr += sizeof(VkAccessFlags2);
    memcpy((uint32_t*)&forUnmarshaling->srcQueueFamilyIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->dstQueueFamilyIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkBuffer*)&forUnmarshaling->buffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
    memcpy((VkDeviceSize*)&forUnmarshaling->offset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->size, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkImageMemoryBarrier2(VulkanStream* vkStream, VkStructureType rootType,
                                             VkImageMemoryBarrier2* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineStageFlags2*)&forUnmarshaling->srcStageMask, *ptr,
           sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy((VkAccessFlags2*)&forUnmarshaling->srcAccessMask, *ptr, sizeof(VkAccessFlags2));
    *ptr += sizeof(VkAccessFlags2);
    memcpy((VkPipelineStageFlags2*)&forUnmarshaling->dstStageMask, *ptr,
           sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy((VkAccessFlags2*)&forUnmarshaling->dstAccessMask, *ptr, sizeof(VkAccessFlags2));
    *ptr += sizeof(VkAccessFlags2);
    memcpy((VkImageLayout*)&forUnmarshaling->oldLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((VkImageLayout*)&forUnmarshaling->newLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((uint32_t*)&forUnmarshaling->srcQueueFamilyIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->dstQueueFamilyIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->image = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
    reservedunmarshal_VkImageSubresourceRange(
        vkStream, rootType, (VkImageSubresourceRange*)(&forUnmarshaling->subresourceRange), ptr);
}

void reservedunmarshal_VkDependencyInfo(VulkanStream* vkStream, VkStructureType rootType,
                                        VkDependencyInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDependencyFlags*)&forUnmarshaling->dependencyFlags, *ptr, sizeof(VkDependencyFlags));
    *ptr += sizeof(VkDependencyFlags);
    memcpy((uint32_t*)&forUnmarshaling->memoryBarrierCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pMemoryBarriers,
                    forUnmarshaling->memoryBarrierCount * sizeof(const VkMemoryBarrier2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->memoryBarrierCount; ++i) {
        reservedunmarshal_VkMemoryBarrier2(
            vkStream, rootType, (VkMemoryBarrier2*)(forUnmarshaling->pMemoryBarriers + i), ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->bufferMemoryBarrierCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc(
        (void**)&forUnmarshaling->pBufferMemoryBarriers,
        forUnmarshaling->bufferMemoryBarrierCount * sizeof(const VkBufferMemoryBarrier2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->bufferMemoryBarrierCount; ++i) {
        reservedunmarshal_VkBufferMemoryBarrier2(
            vkStream, rootType,
            (VkBufferMemoryBarrier2*)(forUnmarshaling->pBufferMemoryBarriers + i), ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->imageMemoryBarrierCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pImageMemoryBarriers,
                    forUnmarshaling->imageMemoryBarrierCount * sizeof(const VkImageMemoryBarrier2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->imageMemoryBarrierCount; ++i) {
        reservedunmarshal_VkImageMemoryBarrier2(
            vkStream, rootType, (VkImageMemoryBarrier2*)(forUnmarshaling->pImageMemoryBarriers + i),
            ptr);
    }
}

void reservedunmarshal_VkSemaphoreSubmitInfo(VulkanStream* vkStream, VkStructureType rootType,
                                             VkSemaphoreSubmitInfo* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkSemaphore*)&forUnmarshaling->semaphore =
        (VkSemaphore)unbox_VkSemaphore((VkSemaphore)(*&cgen_var_0));
    memcpy((uint64_t*)&forUnmarshaling->value, *ptr, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy((VkPipelineStageFlags2*)&forUnmarshaling->stageMask, *ptr,
           sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    memcpy((uint32_t*)&forUnmarshaling->deviceIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkCommandBufferSubmitInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                 VkCommandBufferSubmitInfo* forUnmarshaling,
                                                 uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkCommandBuffer*)&forUnmarshaling->commandBuffer =
        (VkCommandBuffer)unbox_VkCommandBuffer((VkCommandBuffer)(*&cgen_var_0));
    memcpy((uint32_t*)&forUnmarshaling->deviceMask, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkSubmitInfo2(VulkanStream* vkStream, VkStructureType rootType,
                                     VkSubmitInfo2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkSubmitFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkSubmitFlags));
    *ptr += sizeof(VkSubmitFlags);
    memcpy((uint32_t*)&forUnmarshaling->waitSemaphoreInfoCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pWaitSemaphoreInfos,
                    forUnmarshaling->waitSemaphoreInfoCount * sizeof(const VkSemaphoreSubmitInfo));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->waitSemaphoreInfoCount; ++i) {
        reservedunmarshal_VkSemaphoreSubmitInfo(
            vkStream, rootType, (VkSemaphoreSubmitInfo*)(forUnmarshaling->pWaitSemaphoreInfos + i),
            ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->commandBufferInfoCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc(
        (void**)&forUnmarshaling->pCommandBufferInfos,
        forUnmarshaling->commandBufferInfoCount * sizeof(const VkCommandBufferSubmitInfo));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->commandBufferInfoCount; ++i) {
        reservedunmarshal_VkCommandBufferSubmitInfo(
            vkStream, rootType,
            (VkCommandBufferSubmitInfo*)(forUnmarshaling->pCommandBufferInfos + i), ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->signalSemaphoreInfoCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc(
        (void**)&forUnmarshaling->pSignalSemaphoreInfos,
        forUnmarshaling->signalSemaphoreInfoCount * sizeof(const VkSemaphoreSubmitInfo));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->signalSemaphoreInfoCount; ++i) {
        reservedunmarshal_VkSemaphoreSubmitInfo(
            vkStream, rootType,
            (VkSemaphoreSubmitInfo*)(forUnmarshaling->pSignalSemaphoreInfos + i), ptr);
    }
}

void reservedunmarshal_VkPhysicalDeviceSynchronization2Features(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceSynchronization2Features* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->synchronization2, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->shaderZeroInitializeWorkgroupMemory, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceImageRobustnessFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceImageRobustnessFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->robustImageAccess, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkBufferCopy2(VulkanStream* vkStream, VkStructureType rootType,
                                     VkBufferCopy2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDeviceSize*)&forUnmarshaling->srcOffset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->dstOffset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkDeviceSize*)&forUnmarshaling->size, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkCopyBufferInfo2(VulkanStream* vkStream, VkStructureType rootType,
                                         VkCopyBufferInfo2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkBuffer*)&forUnmarshaling->srcBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkBuffer*)&forUnmarshaling->dstBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_1));
    memcpy((uint32_t*)&forUnmarshaling->regionCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pRegions,
                    forUnmarshaling->regionCount * sizeof(const VkBufferCopy2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i) {
        reservedunmarshal_VkBufferCopy2(vkStream, rootType,
                                        (VkBufferCopy2*)(forUnmarshaling->pRegions + i), ptr);
    }
}

void reservedunmarshal_VkImageCopy2(VulkanStream* vkStream, VkStructureType rootType,
                                    VkImageCopy2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->srcSubresource), ptr);
    reservedunmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->srcOffset),
                                 ptr);
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->dstSubresource), ptr);
    reservedunmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->dstOffset),
                                 ptr);
    reservedunmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->extent), ptr);
}

void reservedunmarshal_VkCopyImageInfo2(VulkanStream* vkStream, VkStructureType rootType,
                                        VkCopyImageInfo2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->srcImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
    memcpy((VkImageLayout*)&forUnmarshaling->srcImageLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->dstImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_1));
    memcpy((VkImageLayout*)&forUnmarshaling->dstImageLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((uint32_t*)&forUnmarshaling->regionCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pRegions,
                    forUnmarshaling->regionCount * sizeof(const VkImageCopy2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i) {
        reservedunmarshal_VkImageCopy2(vkStream, rootType,
                                       (VkImageCopy2*)(forUnmarshaling->pRegions + i), ptr);
    }
}

void reservedunmarshal_VkBufferImageCopy2(VulkanStream* vkStream, VkStructureType rootType,
                                          VkBufferImageCopy2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDeviceSize*)&forUnmarshaling->bufferOffset, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((uint32_t*)&forUnmarshaling->bufferRowLength, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->bufferImageHeight, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->imageSubresource), ptr);
    reservedunmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->imageOffset),
                                 ptr);
    reservedunmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->imageExtent),
                                 ptr);
}

void reservedunmarshal_VkCopyBufferToImageInfo2(VulkanStream* vkStream, VkStructureType rootType,
                                                VkCopyBufferToImageInfo2* forUnmarshaling,
                                                uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkBuffer*)&forUnmarshaling->srcBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_0));
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->dstImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_1));
    memcpy((VkImageLayout*)&forUnmarshaling->dstImageLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((uint32_t*)&forUnmarshaling->regionCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pRegions,
                    forUnmarshaling->regionCount * sizeof(const VkBufferImageCopy2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i) {
        reservedunmarshal_VkBufferImageCopy2(
            vkStream, rootType, (VkBufferImageCopy2*)(forUnmarshaling->pRegions + i), ptr);
    }
}

void reservedunmarshal_VkCopyImageToBufferInfo2(VulkanStream* vkStream, VkStructureType rootType,
                                                VkCopyImageToBufferInfo2* forUnmarshaling,
                                                uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->srcImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
    memcpy((VkImageLayout*)&forUnmarshaling->srcImageLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkBuffer*)&forUnmarshaling->dstBuffer = (VkBuffer)unbox_VkBuffer((VkBuffer)(*&cgen_var_1));
    memcpy((uint32_t*)&forUnmarshaling->regionCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pRegions,
                    forUnmarshaling->regionCount * sizeof(const VkBufferImageCopy2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i) {
        reservedunmarshal_VkBufferImageCopy2(
            vkStream, rootType, (VkBufferImageCopy2*)(forUnmarshaling->pRegions + i), ptr);
    }
}

void reservedunmarshal_VkImageBlit2(VulkanStream* vkStream, VkStructureType rootType,
                                    VkImageBlit2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->srcSubresource), ptr);
    for (uint32_t i = 0; i < (uint32_t)2; ++i) {
        reservedunmarshal_VkOffset3D(vkStream, rootType,
                                     (VkOffset3D*)(forUnmarshaling->srcOffsets + i), ptr);
    }
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->dstSubresource), ptr);
    for (uint32_t i = 0; i < (uint32_t)2; ++i) {
        reservedunmarshal_VkOffset3D(vkStream, rootType,
                                     (VkOffset3D*)(forUnmarshaling->dstOffsets + i), ptr);
    }
}

void reservedunmarshal_VkBlitImageInfo2(VulkanStream* vkStream, VkStructureType rootType,
                                        VkBlitImageInfo2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->srcImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
    memcpy((VkImageLayout*)&forUnmarshaling->srcImageLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->dstImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_1));
    memcpy((VkImageLayout*)&forUnmarshaling->dstImageLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((uint32_t*)&forUnmarshaling->regionCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pRegions,
                    forUnmarshaling->regionCount * sizeof(const VkImageBlit2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i) {
        reservedunmarshal_VkImageBlit2(vkStream, rootType,
                                       (VkImageBlit2*)(forUnmarshaling->pRegions + i), ptr);
    }
    memcpy((VkFilter*)&forUnmarshaling->filter, *ptr, sizeof(VkFilter));
    *ptr += sizeof(VkFilter);
}

void reservedunmarshal_VkImageResolve2(VulkanStream* vkStream, VkStructureType rootType,
                                       VkImageResolve2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->srcSubresource), ptr);
    reservedunmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->srcOffset),
                                 ptr);
    reservedunmarshal_VkImageSubresourceLayers(
        vkStream, rootType, (VkImageSubresourceLayers*)(&forUnmarshaling->dstSubresource), ptr);
    reservedunmarshal_VkOffset3D(vkStream, rootType, (VkOffset3D*)(&forUnmarshaling->dstOffset),
                                 ptr);
    reservedunmarshal_VkExtent3D(vkStream, rootType, (VkExtent3D*)(&forUnmarshaling->extent), ptr);
}

void reservedunmarshal_VkResolveImageInfo2(VulkanStream* vkStream, VkStructureType rootType,
                                           VkResolveImageInfo2* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->srcImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_0));
    memcpy((VkImageLayout*)&forUnmarshaling->srcImageLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImage*)&forUnmarshaling->dstImage = (VkImage)unbox_VkImage((VkImage)(*&cgen_var_1));
    memcpy((VkImageLayout*)&forUnmarshaling->dstImageLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((uint32_t*)&forUnmarshaling->regionCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pRegions,
                    forUnmarshaling->regionCount * sizeof(const VkImageResolve2));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->regionCount; ++i) {
        reservedunmarshal_VkImageResolve2(vkStream, rootType,
                                          (VkImageResolve2*)(forUnmarshaling->pRegions + i), ptr);
    }
}

void reservedunmarshal_VkPhysicalDeviceSubgroupSizeControlFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceSubgroupSizeControlFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->subgroupSizeControl, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->computeFullSubgroups, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceSubgroupSizeControlProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceSubgroupSizeControlProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->minSubgroupSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxSubgroupSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxComputeWorkgroupSubgroups, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkShaderStageFlags*)&forUnmarshaling->requiredSubgroupSizeStages, *ptr,
           sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
}

void reservedunmarshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->requiredSubgroupSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkPhysicalDeviceInlineUniformBlockFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceInlineUniformBlockFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->inlineUniformBlock, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->descriptorBindingInlineUniformBlockUpdateAfterBind, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceInlineUniformBlockProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceInlineUniformBlockProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->maxInlineUniformBlockSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorInlineUniformBlocks, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxPerStageDescriptorUpdateAfterBindInlineUniformBlocks,
           *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetInlineUniformBlocks, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxDescriptorSetUpdateAfterBindInlineUniformBlocks, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkWriteDescriptorSetInlineUniformBlock(
    VulkanStream* vkStream, VkStructureType rootType,
    VkWriteDescriptorSetInlineUniformBlock* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->dataSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pData,
                    forUnmarshaling->dataSize * sizeof(const uint8_t));
    memcpy((void*)forUnmarshaling->pData, *ptr, forUnmarshaling->dataSize * sizeof(const uint8_t));
    *ptr += forUnmarshaling->dataSize * sizeof(const uint8_t);
}

void reservedunmarshal_VkDescriptorPoolInlineUniformBlockCreateInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDescriptorPoolInlineUniformBlockCreateInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->maxInlineUniformBlockBindings, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceTextureCompressionASTCHDRFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->textureCompressionASTC_HDR, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkRenderingAttachmentInfo(VulkanStream* vkStream, VkStructureType rootType,
                                                 VkRenderingAttachmentInfo* forUnmarshaling,
                                                 uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImageView*)&forUnmarshaling->imageView =
        (VkImageView)unbox_VkImageView((VkImageView)(*&cgen_var_0));
    memcpy((VkImageLayout*)&forUnmarshaling->imageLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((VkResolveModeFlagBits*)&forUnmarshaling->resolveMode, *ptr,
           sizeof(VkResolveModeFlagBits));
    *ptr += sizeof(VkResolveModeFlagBits);
    uint64_t cgen_var_1;
    memcpy((uint64_t*)&cgen_var_1, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImageView*)&forUnmarshaling->resolveImageView =
        (VkImageView)unbox_VkImageView((VkImageView)(*&cgen_var_1));
    memcpy((VkImageLayout*)&forUnmarshaling->resolveImageLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    memcpy((VkAttachmentLoadOp*)&forUnmarshaling->loadOp, *ptr, sizeof(VkAttachmentLoadOp));
    *ptr += sizeof(VkAttachmentLoadOp);
    memcpy((VkAttachmentStoreOp*)&forUnmarshaling->storeOp, *ptr, sizeof(VkAttachmentStoreOp));
    *ptr += sizeof(VkAttachmentStoreOp);
    reservedunmarshal_VkClearValue(vkStream, rootType,
                                   (VkClearValue*)(&forUnmarshaling->clearValue), ptr);
}

void reservedunmarshal_VkRenderingInfo(VulkanStream* vkStream, VkStructureType rootType,
                                       VkRenderingInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkRenderingFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkRenderingFlags));
    *ptr += sizeof(VkRenderingFlags);
    reservedunmarshal_VkRect2D(vkStream, rootType, (VkRect2D*)(&forUnmarshaling->renderArea), ptr);
    memcpy((uint32_t*)&forUnmarshaling->layerCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->viewMask, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->colorAttachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc(
        (void**)&forUnmarshaling->pColorAttachments,
        forUnmarshaling->colorAttachmentCount * sizeof(const VkRenderingAttachmentInfo));
    for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->colorAttachmentCount; ++i) {
        reservedunmarshal_VkRenderingAttachmentInfo(
            vkStream, rootType,
            (VkRenderingAttachmentInfo*)(forUnmarshaling->pColorAttachments + i), ptr);
    }
    // WARNING PTR CHECK
    memcpy((VkRenderingAttachmentInfo**)&forUnmarshaling->pDepthAttachment, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pDepthAttachment);
    *ptr += 8;
    if (forUnmarshaling->pDepthAttachment) {
        vkStream->alloc((void**)&forUnmarshaling->pDepthAttachment,
                        sizeof(const VkRenderingAttachmentInfo));
        reservedunmarshal_VkRenderingAttachmentInfo(
            vkStream, rootType, (VkRenderingAttachmentInfo*)(forUnmarshaling->pDepthAttachment),
            ptr);
    }
    // WARNING PTR CHECK
    memcpy((VkRenderingAttachmentInfo**)&forUnmarshaling->pStencilAttachment, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pStencilAttachment);
    *ptr += 8;
    if (forUnmarshaling->pStencilAttachment) {
        vkStream->alloc((void**)&forUnmarshaling->pStencilAttachment,
                        sizeof(const VkRenderingAttachmentInfo));
        reservedunmarshal_VkRenderingAttachmentInfo(
            vkStream, rootType, (VkRenderingAttachmentInfo*)(forUnmarshaling->pStencilAttachment),
            ptr);
    }
}

void reservedunmarshal_VkPipelineRenderingCreateInfo(VulkanStream* vkStream,
                                                     VkStructureType rootType,
                                                     VkPipelineRenderingCreateInfo* forUnmarshaling,
                                                     uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->viewMask, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->colorAttachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    memcpy((VkFormat**)&forUnmarshaling->pColorAttachmentFormats, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pColorAttachmentFormats);
    *ptr += 8;
    if (forUnmarshaling->pColorAttachmentFormats) {
        vkStream->alloc((void**)&forUnmarshaling->pColorAttachmentFormats,
                        forUnmarshaling->colorAttachmentCount * sizeof(const VkFormat));
        memcpy((VkFormat*)forUnmarshaling->pColorAttachmentFormats, *ptr,
               forUnmarshaling->colorAttachmentCount * sizeof(const VkFormat));
        *ptr += forUnmarshaling->colorAttachmentCount * sizeof(const VkFormat);
    }
    memcpy((VkFormat*)&forUnmarshaling->depthAttachmentFormat, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy((VkFormat*)&forUnmarshaling->stencilAttachmentFormat, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
}

void reservedunmarshal_VkPhysicalDeviceDynamicRenderingFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceDynamicRenderingFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->dynamicRendering, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkCommandBufferInheritanceRenderingInfo(
    VulkanStream* vkStream, VkStructureType rootType,
    VkCommandBufferInheritanceRenderingInfo* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkRenderingFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkRenderingFlags));
    *ptr += sizeof(VkRenderingFlags);
    memcpy((uint32_t*)&forUnmarshaling->viewMask, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->colorAttachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pColorAttachmentFormats,
                    forUnmarshaling->colorAttachmentCount * sizeof(const VkFormat));
    memcpy((VkFormat*)forUnmarshaling->pColorAttachmentFormats, *ptr,
           forUnmarshaling->colorAttachmentCount * sizeof(const VkFormat));
    *ptr += forUnmarshaling->colorAttachmentCount * sizeof(const VkFormat);
    memcpy((VkFormat*)&forUnmarshaling->depthAttachmentFormat, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy((VkFormat*)&forUnmarshaling->stencilAttachmentFormat, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
    memcpy((VkSampleCountFlagBits*)&forUnmarshaling->rasterizationSamples, *ptr,
           sizeof(VkSampleCountFlagBits));
    *ptr += sizeof(VkSampleCountFlagBits);
}

void reservedunmarshal_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceShaderIntegerDotProductFeatures* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->shaderIntegerDotProduct, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceShaderIntegerDotProductProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceShaderIntegerDotProductProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct8BitUnsignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct8BitSignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct8BitMixedSignednessAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct4x8BitPackedUnsignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct4x8BitPackedSignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct4x8BitPackedMixedSignednessAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct16BitUnsignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct16BitSignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct16BitMixedSignednessAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct32BitUnsignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct32BitSignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct32BitMixedSignednessAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct64BitUnsignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct64BitSignedAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->integerDotProduct64BitMixedSignednessAccelerated, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(
        (VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating8BitUnsignedAccelerated,
        *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(
        (VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating8BitSignedAccelerated,
        *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating8BitMixedSignednessAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating4x8BitPackedUnsignedAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating4x8BitPackedSignedAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating4x8BitPackedMixedSignednessAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating16BitUnsignedAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(
        (VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating16BitSignedAccelerated,
        *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating16BitMixedSignednessAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating32BitUnsignedAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(
        (VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating32BitSignedAccelerated,
        *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating32BitMixedSignednessAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating64BitUnsignedAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy(
        (VkBool32*)&forUnmarshaling->integerDotProductAccumulatingSaturating64BitSignedAccelerated,
        *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling
               ->integerDotProductAccumulatingSaturating64BitMixedSignednessAccelerated,
           *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceTexelBufferAlignmentProperties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceTexelBufferAlignmentProperties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDeviceSize*)&forUnmarshaling->storageTexelBufferOffsetAlignmentBytes, *ptr,
           sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkBool32*)&forUnmarshaling->storageTexelBufferOffsetSingleTexelAlignment, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkDeviceSize*)&forUnmarshaling->uniformTexelBufferOffsetAlignmentBytes, *ptr,
           sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkBool32*)&forUnmarshaling->uniformTexelBufferOffsetSingleTexelAlignment, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkFormatProperties3(VulkanStream* vkStream, VkStructureType rootType,
                                           VkFormatProperties3* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkFormatFeatureFlags2*)&forUnmarshaling->linearTilingFeatures, *ptr,
           sizeof(VkFormatFeatureFlags2));
    *ptr += sizeof(VkFormatFeatureFlags2);
    memcpy((VkFormatFeatureFlags2*)&forUnmarshaling->optimalTilingFeatures, *ptr,
           sizeof(VkFormatFeatureFlags2));
    *ptr += sizeof(VkFormatFeatureFlags2);
    memcpy((VkFormatFeatureFlags2*)&forUnmarshaling->bufferFeatures, *ptr,
           sizeof(VkFormatFeatureFlags2));
    *ptr += sizeof(VkFormatFeatureFlags2);
}

void reservedunmarshal_VkPhysicalDeviceMaintenance4Features(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceMaintenance4Features* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->maintenance4, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceMaintenance4Properties(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceMaintenance4Properties* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDeviceSize*)&forUnmarshaling->maxBufferSize, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
}

void reservedunmarshal_VkDeviceBufferMemoryRequirements(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDeviceBufferMemoryRequirements* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    vkStream->alloc((void**)&forUnmarshaling->pCreateInfo, sizeof(const VkBufferCreateInfo));
    reservedunmarshal_VkBufferCreateInfo(vkStream, rootType,
                                         (VkBufferCreateInfo*)(forUnmarshaling->pCreateInfo), ptr);
}

void reservedunmarshal_VkDeviceImageMemoryRequirements(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDeviceImageMemoryRequirements* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    vkStream->alloc((void**)&forUnmarshaling->pCreateInfo, sizeof(const VkImageCreateInfo));
    reservedunmarshal_VkImageCreateInfo(vkStream, rootType,
                                        (VkImageCreateInfo*)(forUnmarshaling->pCreateInfo), ptr);
    memcpy((VkImageAspectFlagBits*)&forUnmarshaling->planeAspect, *ptr,
           sizeof(VkImageAspectFlagBits));
    *ptr += sizeof(VkImageAspectFlagBits);
}

#endif
#ifdef VK_KHR_surface
#endif
#ifdef VK_KHR_swapchain
#endif
#ifdef VK_KHR_xcb_surface
#endif
#ifdef VK_KHR_android_surface
#endif
#ifdef VK_KHR_win32_surface
#endif
#ifdef VK_KHR_dynamic_rendering
void reservedunmarshal_VkRenderingFragmentShadingRateAttachmentInfoKHR(
    VulkanStream* vkStream, VkStructureType rootType,
    VkRenderingFragmentShadingRateAttachmentInfoKHR* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImageView*)&forUnmarshaling->imageView =
        (VkImageView)unbox_VkImageView((VkImageView)(*&cgen_var_0));
    memcpy((VkImageLayout*)&forUnmarshaling->imageLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
    reservedunmarshal_VkExtent2D(
        vkStream, rootType, (VkExtent2D*)(&forUnmarshaling->shadingRateAttachmentTexelSize), ptr);
}

void reservedunmarshal_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkRenderingFragmentDensityMapAttachmentInfoEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkImageView*)&forUnmarshaling->imageView =
        (VkImageView)unbox_VkImageView((VkImageView)(*&cgen_var_0));
    memcpy((VkImageLayout*)&forUnmarshaling->imageLayout, *ptr, sizeof(VkImageLayout));
    *ptr += sizeof(VkImageLayout);
}

void reservedunmarshal_VkAttachmentSampleCountInfoAMD(
    VulkanStream* vkStream, VkStructureType rootType,
    VkAttachmentSampleCountInfoAMD* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->colorAttachmentCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    memcpy((VkSampleCountFlagBits**)&forUnmarshaling->pColorAttachmentSamples, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pColorAttachmentSamples);
    *ptr += 8;
    if (forUnmarshaling->pColorAttachmentSamples) {
        vkStream->alloc(
            (void**)&forUnmarshaling->pColorAttachmentSamples,
            forUnmarshaling->colorAttachmentCount * sizeof(const VkSampleCountFlagBits));
        memcpy((VkSampleCountFlagBits*)forUnmarshaling->pColorAttachmentSamples, *ptr,
               forUnmarshaling->colorAttachmentCount * sizeof(const VkSampleCountFlagBits));
        *ptr += forUnmarshaling->colorAttachmentCount * sizeof(const VkSampleCountFlagBits);
    }
    memcpy((VkSampleCountFlagBits*)&forUnmarshaling->depthStencilAttachmentSamples, *ptr,
           sizeof(VkSampleCountFlagBits));
    *ptr += sizeof(VkSampleCountFlagBits);
}

void reservedunmarshal_VkMultiviewPerViewAttributesInfoNVX(
    VulkanStream* vkStream, VkStructureType rootType,
    VkMultiviewPerViewAttributesInfoNVX* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->perViewAttributes, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->perViewAttributesPositionXOnly, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_KHR_get_physical_device_properties2
#endif
#ifdef VK_KHR_maintenance1
#endif
#ifdef VK_KHR_external_memory_capabilities
#endif
#ifdef VK_KHR_external_memory
#endif
#ifdef VK_KHR_external_memory_win32
#endif
#ifdef VK_KHR_external_memory_fd
#endif
#ifdef VK_KHR_external_semaphore_capabilities
#endif
#ifdef VK_KHR_external_semaphore
#endif
#ifdef VK_KHR_external_semaphore_win32
#endif
#ifdef VK_KHR_external_semaphore_fd
void reservedunmarshal_VkImportSemaphoreFdInfoKHR(VulkanStream* vkStream, VkStructureType rootType,
                                                  VkImportSemaphoreFdInfoKHR* forUnmarshaling,
                                                  uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkSemaphore*)&forUnmarshaling->semaphore =
        (VkSemaphore)unbox_VkSemaphore((VkSemaphore)(*&cgen_var_0));
    memcpy((VkSemaphoreImportFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkSemaphoreImportFlags));
    *ptr += sizeof(VkSemaphoreImportFlags);
    memcpy((VkExternalSemaphoreHandleTypeFlagBits*)&forUnmarshaling->handleType, *ptr,
           sizeof(VkExternalSemaphoreHandleTypeFlagBits));
    *ptr += sizeof(VkExternalSemaphoreHandleTypeFlagBits);
    memcpy((int*)&forUnmarshaling->fd, *ptr, sizeof(int));
    *ptr += sizeof(int);
}

void reservedunmarshal_VkSemaphoreGetFdInfoKHR(VulkanStream* vkStream, VkStructureType rootType,
                                               VkSemaphoreGetFdInfoKHR* forUnmarshaling,
                                               uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkSemaphore*)&forUnmarshaling->semaphore =
        (VkSemaphore)unbox_VkSemaphore((VkSemaphore)(*&cgen_var_0));
    memcpy((VkExternalSemaphoreHandleTypeFlagBits*)&forUnmarshaling->handleType, *ptr,
           sizeof(VkExternalSemaphoreHandleTypeFlagBits));
    *ptr += sizeof(VkExternalSemaphoreHandleTypeFlagBits);
}

#endif
#ifdef VK_KHR_shader_float16_int8
#endif
#ifdef VK_KHR_incremental_present
void reservedunmarshal_VkRectLayerKHR(VulkanStream* vkStream, VkStructureType rootType,
                                      VkRectLayerKHR* forUnmarshaling, uint8_t** ptr) {
    reservedunmarshal_VkOffset2D(vkStream, rootType, (VkOffset2D*)(&forUnmarshaling->offset), ptr);
    reservedunmarshal_VkExtent2D(vkStream, rootType, (VkExtent2D*)(&forUnmarshaling->extent), ptr);
    memcpy((uint32_t*)&forUnmarshaling->layer, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkPresentRegionKHR(VulkanStream* vkStream, VkStructureType rootType,
                                          VkPresentRegionKHR* forUnmarshaling, uint8_t** ptr) {
    memcpy((uint32_t*)&forUnmarshaling->rectangleCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    memcpy((VkRectLayerKHR**)&forUnmarshaling->pRectangles, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pRectangles);
    *ptr += 8;
    if (forUnmarshaling->pRectangles) {
        vkStream->alloc((void**)&forUnmarshaling->pRectangles,
                        forUnmarshaling->rectangleCount * sizeof(const VkRectLayerKHR));
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->rectangleCount; ++i) {
            reservedunmarshal_VkRectLayerKHR(
                vkStream, rootType, (VkRectLayerKHR*)(forUnmarshaling->pRectangles + i), ptr);
        }
    }
}

void reservedunmarshal_VkPresentRegionsKHR(VulkanStream* vkStream, VkStructureType rootType,
                                           VkPresentRegionsKHR* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->swapchainCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    memcpy((VkPresentRegionKHR**)&forUnmarshaling->pRegions, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pRegions);
    *ptr += 8;
    if (forUnmarshaling->pRegions) {
        vkStream->alloc((void**)&forUnmarshaling->pRegions,
                        forUnmarshaling->swapchainCount * sizeof(const VkPresentRegionKHR));
        for (uint32_t i = 0; i < (uint32_t)forUnmarshaling->swapchainCount; ++i) {
            reservedunmarshal_VkPresentRegionKHR(
                vkStream, rootType, (VkPresentRegionKHR*)(forUnmarshaling->pRegions + i), ptr);
        }
    }
}

#endif
#ifdef VK_KHR_descriptor_update_template
#endif
#ifdef VK_KHR_imageless_framebuffer
#endif
#ifdef VK_KHR_create_renderpass2
#endif
#ifdef VK_KHR_external_fence_capabilities
#endif
#ifdef VK_KHR_external_fence
#endif
#ifdef VK_KHR_external_fence_fd
void reservedunmarshal_VkImportFenceFdInfoKHR(VulkanStream* vkStream, VkStructureType rootType,
                                              VkImportFenceFdInfoKHR* forUnmarshaling,
                                              uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkFence*)&forUnmarshaling->fence = (VkFence)unbox_VkFence((VkFence)(*&cgen_var_0));
    memcpy((VkFenceImportFlags*)&forUnmarshaling->flags, *ptr, sizeof(VkFenceImportFlags));
    *ptr += sizeof(VkFenceImportFlags);
    memcpy((VkExternalFenceHandleTypeFlagBits*)&forUnmarshaling->handleType, *ptr,
           sizeof(VkExternalFenceHandleTypeFlagBits));
    *ptr += sizeof(VkExternalFenceHandleTypeFlagBits);
    memcpy((int*)&forUnmarshaling->fd, *ptr, sizeof(int));
    *ptr += sizeof(int);
}

void reservedunmarshal_VkFenceGetFdInfoKHR(VulkanStream* vkStream, VkStructureType rootType,
                                           VkFenceGetFdInfoKHR* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkFence*)&forUnmarshaling->fence = (VkFence)unbox_VkFence((VkFence)(*&cgen_var_0));
    memcpy((VkExternalFenceHandleTypeFlagBits*)&forUnmarshaling->handleType, *ptr,
           sizeof(VkExternalFenceHandleTypeFlagBits));
    *ptr += sizeof(VkExternalFenceHandleTypeFlagBits);
}

#endif
#ifdef VK_KHR_maintenance2
#endif
#ifdef VK_KHR_dedicated_allocation
#endif
#ifdef VK_KHR_storage_buffer_storage_class
#endif
#ifdef VK_KHR_get_memory_requirements2
#endif
#ifdef VK_KHR_image_format_list
#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
#endif
#ifdef VK_KHR_bind_memory2
#endif
#ifdef VK_KHR_maintenance3
#endif
#ifdef VK_KHR_shader_subgroup_extended_types
#endif
#ifdef VK_KHR_vulkan_memory_model
#endif
#ifdef VK_KHR_shader_terminate_invocation
#endif
#ifdef VK_KHR_buffer_device_address
#endif
#ifdef VK_KHR_pipeline_executable_properties
void reservedunmarshal_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->pipelineExecutableInfo, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPipelineInfoKHR(VulkanStream* vkStream, VkStructureType rootType,
                                         VkPipelineInfoKHR* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkPipeline*)&forUnmarshaling->pipeline =
        (VkPipeline)unbox_VkPipeline((VkPipeline)(*&cgen_var_0));
}

void reservedunmarshal_VkPipelineExecutablePropertiesKHR(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineExecutablePropertiesKHR* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkShaderStageFlags*)&forUnmarshaling->stages, *ptr, sizeof(VkShaderStageFlags));
    *ptr += sizeof(VkShaderStageFlags);
    memcpy((char*)forUnmarshaling->name, *ptr, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy((char*)forUnmarshaling->description, *ptr, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy((uint32_t*)&forUnmarshaling->subgroupSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkPipelineExecutableInfoKHR(VulkanStream* vkStream, VkStructureType rootType,
                                                   VkPipelineExecutableInfoKHR* forUnmarshaling,
                                                   uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkPipeline*)&forUnmarshaling->pipeline =
        (VkPipeline)unbox_VkPipeline((VkPipeline)(*&cgen_var_0));
    memcpy((uint32_t*)&forUnmarshaling->executableIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkPipelineExecutableStatisticValueKHR(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineExecutableStatisticValueKHR* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkBool32*)&forUnmarshaling->b32, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPipelineExecutableStatisticKHR(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineExecutableStatisticKHR* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((char*)forUnmarshaling->name, *ptr, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy((char*)forUnmarshaling->description, *ptr, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy((VkPipelineExecutableStatisticFormatKHR*)&forUnmarshaling->format, *ptr,
           sizeof(VkPipelineExecutableStatisticFormatKHR));
    *ptr += sizeof(VkPipelineExecutableStatisticFormatKHR);
    reservedunmarshal_VkPipelineExecutableStatisticValueKHR(
        vkStream, rootType, (VkPipelineExecutableStatisticValueKHR*)(&forUnmarshaling->value), ptr);
}

void reservedunmarshal_VkPipelineExecutableInternalRepresentationKHR(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineExecutableInternalRepresentationKHR* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((char*)forUnmarshaling->name, *ptr, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy((char*)forUnmarshaling->description, *ptr, VK_MAX_DESCRIPTION_SIZE * sizeof(char));
    *ptr += VK_MAX_DESCRIPTION_SIZE * sizeof(char);
    memcpy((VkBool32*)&forUnmarshaling->isText, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((size_t*)&forUnmarshaling->dataSize, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->dataSize);
    *ptr += 8;
    // WARNING PTR CHECK
    memcpy((void**)&forUnmarshaling->pData, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pData);
    *ptr += 8;
    if (forUnmarshaling->pData) {
        vkStream->alloc((void**)&forUnmarshaling->pData,
                        forUnmarshaling->dataSize * sizeof(uint8_t));
        memcpy((void*)forUnmarshaling->pData, *ptr, forUnmarshaling->dataSize * sizeof(uint8_t));
        *ptr += forUnmarshaling->dataSize * sizeof(uint8_t);
    }
}

#endif
#ifdef VK_KHR_shader_integer_dot_product
#endif
#ifdef VK_KHR_shader_non_semantic_info
#endif
#ifdef VK_KHR_synchronization2
void reservedunmarshal_VkQueueFamilyCheckpointProperties2NV(
    VulkanStream* vkStream, VkStructureType rootType,
    VkQueueFamilyCheckpointProperties2NV* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineStageFlags2*)&forUnmarshaling->checkpointExecutionStageMask, *ptr,
           sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
}

void reservedunmarshal_VkCheckpointData2NV(VulkanStream* vkStream, VkStructureType rootType,
                                           VkCheckpointData2NV* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineStageFlags2*)&forUnmarshaling->stage, *ptr, sizeof(VkPipelineStageFlags2));
    *ptr += sizeof(VkPipelineStageFlags2);
    // WARNING PTR CHECK
    memcpy((void**)&forUnmarshaling->pCheckpointMarker, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pCheckpointMarker);
    *ptr += 8;
    if (forUnmarshaling->pCheckpointMarker) {
        vkStream->alloc((void**)&forUnmarshaling->pCheckpointMarker, sizeof(uint8_t));
        memcpy((void*)forUnmarshaling->pCheckpointMarker, *ptr, sizeof(uint8_t));
        *ptr += sizeof(uint8_t);
    }
}

#endif
#ifdef VK_KHR_zero_initialize_workgroup_memory
#endif
#ifdef VK_KHR_copy_commands2
#endif
#ifdef VK_KHR_format_feature_flags2
#endif
#ifdef VK_KHR_maintenance4
#endif
#ifdef VK_ANDROID_native_buffer
void reservedunmarshal_VkNativeBufferUsage2ANDROID(VulkanStream* vkStream, VkStructureType rootType,
                                                   VkNativeBufferUsage2ANDROID* forUnmarshaling,
                                                   uint8_t** ptr) {
    memcpy((uint64_t*)&forUnmarshaling->consumer, *ptr, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy((uint64_t*)&forUnmarshaling->producer, *ptr, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

void reservedunmarshal_VkNativeBufferANDROID(VulkanStream* vkStream, VkStructureType rootType,
                                             VkNativeBufferANDROID* forUnmarshaling,
                                             uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    // WARNING PTR CHECK
    memcpy((uint32_t**)&forUnmarshaling->handle, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->handle);
    *ptr += 8;
    if (forUnmarshaling->handle) {
        vkStream->alloc((void**)&forUnmarshaling->handle, sizeof(const uint32_t));
        memcpy((uint32_t*)forUnmarshaling->handle, *ptr, sizeof(const uint32_t));
        *ptr += sizeof(const uint32_t);
    }
    memcpy((int*)&forUnmarshaling->stride, *ptr, sizeof(int));
    *ptr += sizeof(int);
    memcpy((int*)&forUnmarshaling->format, *ptr, sizeof(int));
    *ptr += sizeof(int);
    memcpy((int*)&forUnmarshaling->usage, *ptr, sizeof(int));
    *ptr += sizeof(int);
    reservedunmarshal_VkNativeBufferUsage2ANDROID(
        vkStream, rootType, (VkNativeBufferUsage2ANDROID*)(&forUnmarshaling->usage2), ptr);
}

void reservedunmarshal_VkSwapchainImageCreateInfoANDROID(
    VulkanStream* vkStream, VkStructureType rootType,
    VkSwapchainImageCreateInfoANDROID* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkSwapchainImageUsageFlagsANDROID*)&forUnmarshaling->usage, *ptr,
           sizeof(VkSwapchainImageUsageFlagsANDROID));
    *ptr += sizeof(VkSwapchainImageUsageFlagsANDROID);
}

void reservedunmarshal_VkPhysicalDevicePresentationPropertiesANDROID(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDevicePresentationPropertiesANDROID* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->sharedImage, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_transform_feedback
void reservedunmarshal_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceTransformFeedbackFeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->transformFeedback, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->geometryStreams, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceTransformFeedbackPropertiesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->maxTransformFeedbackStreams, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTransformFeedbackBuffers, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkDeviceSize*)&forUnmarshaling->maxTransformFeedbackBufferSize, *ptr,
           sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((uint32_t*)&forUnmarshaling->maxTransformFeedbackStreamDataSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTransformFeedbackBufferDataSize, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->maxTransformFeedbackBufferDataStride, *ptr,
           sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((VkBool32*)&forUnmarshaling->transformFeedbackQueries, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->transformFeedbackStreamsLinesTriangles, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->transformFeedbackRasterizationStreamSelect, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->transformFeedbackDraw, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPipelineRasterizationStateStreamCreateInfoEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineRasterizationStateStreamCreateInfoEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPipelineRasterizationStateStreamCreateFlagsEXT*)&forUnmarshaling->flags, *ptr,
           sizeof(VkPipelineRasterizationStateStreamCreateFlagsEXT));
    *ptr += sizeof(VkPipelineRasterizationStateStreamCreateFlagsEXT);
    memcpy((uint32_t*)&forUnmarshaling->rasterizationStream, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

#endif
#ifdef VK_AMD_gpu_shader_half_float
#endif
#ifdef VK_EXT_texture_compression_astc_hdr
#endif
#ifdef VK_EXT_swapchain_colorspace
#endif
#ifdef VK_EXT_queue_family_foreign
#endif
#ifdef VK_EXT_debug_utils
#endif
#ifdef VK_ANDROID_external_memory_android_hardware_buffer
#endif
#ifdef VK_EXT_inline_uniform_block
#endif
#ifdef VK_EXT_shader_stencil_export
#endif
#ifdef VK_EXT_pipeline_creation_feedback
#endif
#ifdef VK_NV_shader_subgroup_partitioned
#endif
#ifdef VK_EXT_metal_surface
#endif
#ifdef VK_EXT_subgroup_size_control
#endif
#ifdef VK_EXT_tooling_info
#endif
#ifdef VK_EXT_provoking_vertex
void reservedunmarshal_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceProvokingVertexFeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->provokingVertexLast, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->transformFeedbackPreservesProvokingVertex, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceProvokingVertexPropertiesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->provokingVertexModePerPipeline, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->transformFeedbackPreservesTriangleFanProvokingVertex, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkProvokingVertexModeEXT*)&forUnmarshaling->provokingVertexMode, *ptr,
           sizeof(VkProvokingVertexModeEXT));
    *ptr += sizeof(VkProvokingVertexModeEXT);
}

#endif
#ifdef VK_EXT_line_rasterization
void reservedunmarshal_VkPhysicalDeviceLineRasterizationFeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceLineRasterizationFeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->rectangularLines, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->bresenhamLines, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->smoothLines, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->stippledRectangularLines, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->stippledBresenhamLines, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->stippledSmoothLines, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkPhysicalDeviceLineRasterizationPropertiesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceLineRasterizationPropertiesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->lineSubPixelPrecisionBits, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkPipelineRasterizationLineStateCreateInfoEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPipelineRasterizationLineStateCreateInfoEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkLineRasterizationModeEXT*)&forUnmarshaling->lineRasterizationMode, *ptr,
           sizeof(VkLineRasterizationModeEXT));
    *ptr += sizeof(VkLineRasterizationModeEXT);
    memcpy((VkBool32*)&forUnmarshaling->stippledLineEnable, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((uint32_t*)&forUnmarshaling->lineStippleFactor, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint16_t*)&forUnmarshaling->lineStipplePattern, *ptr, sizeof(uint16_t));
    *ptr += sizeof(uint16_t);
}

#endif
#ifdef VK_EXT_index_type_uint8
void reservedunmarshal_VkPhysicalDeviceIndexTypeUint8FeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceIndexTypeUint8FeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->indexTypeUint8, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_extended_dynamic_state
void reservedunmarshal_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->extendedDynamicState, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_swapchain_maintenance1
void reservedunmarshal_VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->swapchainMaintenance1, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkSwapchainPresentFenceInfoEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkSwapchainPresentFenceInfoEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->swapchainCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pFences,
                    forUnmarshaling->swapchainCount * sizeof(const VkFence));
    if (forUnmarshaling->swapchainCount) {
        uint8_t* cgen_var_0_ptr = (uint8_t*)(*ptr);
        *ptr += 8 * forUnmarshaling->swapchainCount;
        if (forUnmarshaling) {
            for (uint32_t k = 0; k < forUnmarshaling->swapchainCount; ++k) {
                uint64_t tmpval;
                memcpy(&tmpval, cgen_var_0_ptr + k * 8, sizeof(uint64_t));
                *(((VkFence*)forUnmarshaling->pFences) + k) =
                    (VkFence)unbox_VkFence((VkFence)tmpval);
            }
        }
    }
}

void reservedunmarshal_VkSwapchainPresentModesCreateInfoEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkSwapchainPresentModesCreateInfoEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->presentModeCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pPresentModes,
                    forUnmarshaling->presentModeCount * sizeof(const VkPresentModeKHR));
    memcpy((VkPresentModeKHR*)forUnmarshaling->pPresentModes, *ptr,
           forUnmarshaling->presentModeCount * sizeof(const VkPresentModeKHR));
    *ptr += forUnmarshaling->presentModeCount * sizeof(const VkPresentModeKHR);
}

void reservedunmarshal_VkSwapchainPresentModeInfoEXT(VulkanStream* vkStream,
                                                     VkStructureType rootType,
                                                     VkSwapchainPresentModeInfoEXT* forUnmarshaling,
                                                     uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->swapchainCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pPresentModes,
                    forUnmarshaling->swapchainCount * sizeof(const VkPresentModeKHR));
    memcpy((VkPresentModeKHR*)forUnmarshaling->pPresentModes, *ptr,
           forUnmarshaling->swapchainCount * sizeof(const VkPresentModeKHR));
    *ptr += forUnmarshaling->swapchainCount * sizeof(const VkPresentModeKHR);
}

void reservedunmarshal_VkSwapchainPresentScalingCreateInfoEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkSwapchainPresentScalingCreateInfoEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkPresentScalingFlagsEXT*)&forUnmarshaling->scalingBehavior, *ptr,
           sizeof(VkPresentScalingFlagsEXT));
    *ptr += sizeof(VkPresentScalingFlagsEXT);
    memcpy((VkPresentGravityFlagsEXT*)&forUnmarshaling->presentGravityX, *ptr,
           sizeof(VkPresentGravityFlagsEXT));
    *ptr += sizeof(VkPresentGravityFlagsEXT);
    memcpy((VkPresentGravityFlagsEXT*)&forUnmarshaling->presentGravityY, *ptr,
           sizeof(VkPresentGravityFlagsEXT));
    *ptr += sizeof(VkPresentGravityFlagsEXT);
}

void reservedunmarshal_VkReleaseSwapchainImagesInfoEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkReleaseSwapchainImagesInfoEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    uint64_t cgen_var_0;
    memcpy((uint64_t*)&cgen_var_0, *ptr, 1 * 8);
    *ptr += 1 * 8;
    *(VkSwapchainKHR*)&forUnmarshaling->swapchain =
        (VkSwapchainKHR)unbox_VkSwapchainKHR((VkSwapchainKHR)(*&cgen_var_0));
    memcpy((uint32_t*)&forUnmarshaling->imageIndexCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    vkStream->alloc((void**)&forUnmarshaling->pImageIndices,
                    forUnmarshaling->imageIndexCount * sizeof(const uint32_t));
    memcpy((uint32_t*)forUnmarshaling->pImageIndices, *ptr,
           forUnmarshaling->imageIndexCount * sizeof(const uint32_t));
    *ptr += forUnmarshaling->imageIndexCount * sizeof(const uint32_t);
}

#endif
#ifdef VK_EXT_shader_demote_to_helper_invocation
#endif
#ifdef VK_EXT_texel_buffer_alignment
void reservedunmarshal_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->texelBufferAlignment, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_device_memory_report
void reservedunmarshal_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->deviceMemoryReport, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkDeviceMemoryReportCallbackDataEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDeviceMemoryReportCallbackDataEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDeviceMemoryReportFlagsEXT*)&forUnmarshaling->flags, *ptr,
           sizeof(VkDeviceMemoryReportFlagsEXT));
    *ptr += sizeof(VkDeviceMemoryReportFlagsEXT);
    memcpy((VkDeviceMemoryReportEventTypeEXT*)&forUnmarshaling->type, *ptr,
           sizeof(VkDeviceMemoryReportEventTypeEXT));
    *ptr += sizeof(VkDeviceMemoryReportEventTypeEXT);
    memcpy((uint64_t*)&forUnmarshaling->memoryObjectId, *ptr, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy((VkDeviceSize*)&forUnmarshaling->size, *ptr, sizeof(VkDeviceSize));
    *ptr += sizeof(VkDeviceSize);
    memcpy((VkObjectType*)&forUnmarshaling->objectType, *ptr, sizeof(VkObjectType));
    *ptr += sizeof(VkObjectType);
    memcpy((uint64_t*)&forUnmarshaling->objectHandle, *ptr, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
    memcpy((uint32_t*)&forUnmarshaling->heapIndex, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkDeviceDeviceMemoryReportCreateInfoEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkDeviceDeviceMemoryReportCreateInfoEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkDeviceMemoryReportFlagsEXT*)&forUnmarshaling->flags, *ptr,
           sizeof(VkDeviceMemoryReportFlagsEXT));
    *ptr += sizeof(VkDeviceMemoryReportFlagsEXT);
    memcpy((PFN_vkDeviceMemoryReportCallbackEXT*)&forUnmarshaling->pfnUserCallback, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pfnUserCallback);
    *ptr += 8;
    vkStream->alloc((void**)&forUnmarshaling->pUserData, sizeof(uint8_t));
    memcpy((void*)forUnmarshaling->pUserData, *ptr, sizeof(uint8_t));
    *ptr += sizeof(uint8_t);
}

#endif
#ifdef VK_EXT_custom_border_color
void reservedunmarshal_VkSamplerCustomBorderColorCreateInfoEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkSamplerCustomBorderColorCreateInfoEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkClearColorValue(
        vkStream, rootType, (VkClearColorValue*)(&forUnmarshaling->customBorderColor), ptr);
    memcpy((VkFormat*)&forUnmarshaling->format, *ptr, sizeof(VkFormat));
    *ptr += sizeof(VkFormat);
}

void reservedunmarshal_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceCustomBorderColorPropertiesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->maxCustomBorderColorSamplers, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceCustomBorderColorFeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->customBorderColors, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->customBorderColorWithoutFormat, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_private_data
#endif
#ifdef VK_EXT_pipeline_creation_cache_control
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
void reservedunmarshal_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->ycbcr2plane444Formats, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_image_robustness
#endif
#ifdef VK_EXT_image_compression_control
void reservedunmarshal_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceImageCompressionControlFeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->imageCompressionControl, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

void reservedunmarshal_VkImageCompressionControlEXT(VulkanStream* vkStream,
                                                    VkStructureType rootType,
                                                    VkImageCompressionControlEXT* forUnmarshaling,
                                                    uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkImageCompressionFlagsEXT*)&forUnmarshaling->flags, *ptr,
           sizeof(VkImageCompressionFlagsEXT));
    *ptr += sizeof(VkImageCompressionFlagsEXT);
    memcpy((uint32_t*)&forUnmarshaling->compressionControlPlaneCount, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    // WARNING PTR CHECK
    memcpy((VkImageCompressionFixedRateFlagsEXT**)&forUnmarshaling->pFixedRateFlags, (*ptr), 8);
    android::base::Stream::fromBe64((uint8_t*)&forUnmarshaling->pFixedRateFlags);
    *ptr += 8;
    if (forUnmarshaling->pFixedRateFlags) {
        vkStream->alloc((void**)&forUnmarshaling->pFixedRateFlags,
                        forUnmarshaling->compressionControlPlaneCount *
                            sizeof(VkImageCompressionFixedRateFlagsEXT));
        memcpy((VkImageCompressionFixedRateFlagsEXT*)forUnmarshaling->pFixedRateFlags, *ptr,
               forUnmarshaling->compressionControlPlaneCount *
                   sizeof(VkImageCompressionFixedRateFlagsEXT));
        *ptr += forUnmarshaling->compressionControlPlaneCount *
                sizeof(VkImageCompressionFixedRateFlagsEXT);
    }
}

void reservedunmarshal_VkSubresourceLayout2EXT(VulkanStream* vkStream, VkStructureType rootType,
                                               VkSubresourceLayout2EXT* forUnmarshaling,
                                               uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkSubresourceLayout(
        vkStream, rootType, (VkSubresourceLayout*)(&forUnmarshaling->subresourceLayout), ptr);
}

void reservedunmarshal_VkImageSubresource2EXT(VulkanStream* vkStream, VkStructureType rootType,
                                              VkImageSubresource2EXT* forUnmarshaling,
                                              uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    reservedunmarshal_VkImageSubresource(
        vkStream, rootType, (VkImageSubresource*)(&forUnmarshaling->imageSubresource), ptr);
}

void reservedunmarshal_VkImageCompressionPropertiesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkImageCompressionPropertiesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkImageCompressionFlagsEXT*)&forUnmarshaling->imageCompressionFlags, *ptr,
           sizeof(VkImageCompressionFlagsEXT));
    *ptr += sizeof(VkImageCompressionFlagsEXT);
    memcpy((VkImageCompressionFixedRateFlagsEXT*)&forUnmarshaling->imageCompressionFixedRateFlags,
           *ptr, sizeof(VkImageCompressionFixedRateFlagsEXT));
    *ptr += sizeof(VkImageCompressionFixedRateFlagsEXT);
}

#endif
#ifdef VK_EXT_4444_formats
void reservedunmarshal_VkPhysicalDevice4444FormatsFeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDevice4444FormatsFeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->formatA4R4G4B4, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->formatA4B4G4R4, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_primitive_topology_list_restart
void reservedunmarshal_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->primitiveTopologyListRestart, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->primitiveTopologyPatchListRestart, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_EXT_extended_dynamic_state2
void reservedunmarshal_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->extendedDynamicState2, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->extendedDynamicState2LogicOp, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
    memcpy((VkBool32*)&forUnmarshaling->extendedDynamicState2PatchControlPoints, *ptr,
           sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
#ifdef VK_GOOGLE_gfxstream
void reservedunmarshal_VkImportColorBufferGOOGLE(VulkanStream* vkStream, VkStructureType rootType,
                                                 VkImportColorBufferGOOGLE* forUnmarshaling,
                                                 uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    forUnmarshaling->sType = VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->colorBuffer, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkImportBufferGOOGLE(VulkanStream* vkStream, VkStructureType rootType,
                                            VkImportBufferGOOGLE* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    forUnmarshaling->sType = VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->buffer, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
}

void reservedunmarshal_VkCreateBlobGOOGLE(VulkanStream* vkStream, VkStructureType rootType,
                                          VkCreateBlobGOOGLE* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    forUnmarshaling->sType = VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE;
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((uint32_t*)&forUnmarshaling->blobMem, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint32_t*)&forUnmarshaling->blobFlags, *ptr, sizeof(uint32_t));
    *ptr += sizeof(uint32_t);
    memcpy((uint64_t*)&forUnmarshaling->blobId, *ptr, sizeof(uint64_t));
    *ptr += sizeof(uint64_t);
}

#endif
#ifdef VK_EXT_load_store_op_none
#endif
#ifdef VK_EXT_image_compression_control_swapchain
void reservedunmarshal_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    VulkanStream* vkStream, VkStructureType rootType,
    VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* forUnmarshaling, uint8_t** ptr) {
    memcpy((VkStructureType*)&forUnmarshaling->sType, *ptr, sizeof(VkStructureType));
    *ptr += sizeof(VkStructureType);
    if (rootType == VK_STRUCTURE_TYPE_MAX_ENUM) {
        rootType = forUnmarshaling->sType;
    }
    uint32_t pNext_size;
    memcpy((uint32_t*)&pNext_size, *ptr, sizeof(uint32_t));
    android::base::Stream::fromBe32((uint8_t*)&pNext_size);
    *ptr += sizeof(uint32_t);
    forUnmarshaling->pNext = nullptr;
    if (pNext_size) {
        vkStream->alloc((void**)&forUnmarshaling->pNext, sizeof(VkStructureType));
        memcpy((void*)forUnmarshaling->pNext, *ptr, sizeof(VkStructureType));
        *ptr += sizeof(VkStructureType);
        VkStructureType extType = *(VkStructureType*)(forUnmarshaling->pNext);
        vkStream->alloc((void**)&forUnmarshaling->pNext,
                        goldfish_vk_extension_struct_size_with_stream_features(
                            vkStream->getFeatureBits(), rootType, forUnmarshaling->pNext));
        *(VkStructureType*)forUnmarshaling->pNext = extType;
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)(forUnmarshaling->pNext),
                                           ptr);
    }
    memcpy((VkBool32*)&forUnmarshaling->imageCompressionControlSwapchain, *ptr, sizeof(VkBool32));
    *ptr += sizeof(VkBool32);
}

#endif
void reservedunmarshal_extension_struct(VulkanStream* vkStream, VkStructureType rootType,
                                        void* structExtension_out, uint8_t** ptr) {
    VkInstanceCreateInfo* structAccess = (VkInstanceCreateInfo*)(structExtension_out);
    uint32_t currExtSize = goldfish_vk_extension_struct_size_with_stream_features(
        vkStream->getFeatureBits(), rootType, structExtension_out);
    if (!currExtSize && structExtension_out) {
        // unknown struct extension; skip and call on its pNext field
        reservedunmarshal_extension_struct(vkStream, rootType, (void*)structAccess->pNext, ptr);
        return;
    } else {
        // known or null extension struct
        if (!currExtSize) {
            // exit if this was a null extension struct (size == 0 in this branch)
            return;
        }
    }
    if (!structExtension_out) {
        return;
    }
    uint32_t structType = (uint32_t)goldfish_vk_struct_type(structExtension_out);
    switch (structType) {
#ifdef VK_VERSION_1_0
        case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO: {
            reservedunmarshal_VkShaderModuleCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkShaderModuleCreateInfo*>(structExtension_out), ptr);
            break;
        }
#endif
#ifdef VK_VERSION_1_1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceSubgroupProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceSubgroupProperties*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES: {
            reservedunmarshal_VkPhysicalDevice16BitStorageFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDevice16BitStorageFeatures*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS: {
            reservedunmarshal_VkMemoryDedicatedRequirements(
                vkStream, rootType,
                reinterpret_cast<VkMemoryDedicatedRequirements*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO: {
            reservedunmarshal_VkMemoryDedicatedAllocateInfo(
                vkStream, rootType,
                reinterpret_cast<VkMemoryDedicatedAllocateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO: {
            reservedunmarshal_VkMemoryAllocateFlagsInfo(
                vkStream, rootType,
                reinterpret_cast<VkMemoryAllocateFlagsInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: {
            reservedunmarshal_VkDeviceGroupRenderPassBeginInfo(
                vkStream, rootType,
                reinterpret_cast<VkDeviceGroupRenderPassBeginInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO: {
            reservedunmarshal_VkDeviceGroupCommandBufferBeginInfo(
                vkStream, rootType,
                reinterpret_cast<VkDeviceGroupCommandBufferBeginInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO: {
            reservedunmarshal_VkDeviceGroupSubmitInfo(
                vkStream, rootType, reinterpret_cast<VkDeviceGroupSubmitInfo*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO: {
            reservedunmarshal_VkDeviceGroupBindSparseInfo(
                vkStream, rootType,
                reinterpret_cast<VkDeviceGroupBindSparseInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: {
            reservedunmarshal_VkBindBufferMemoryDeviceGroupInfo(
                vkStream, rootType,
                reinterpret_cast<VkBindBufferMemoryDeviceGroupInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: {
            reservedunmarshal_VkBindImageMemoryDeviceGroupInfo(
                vkStream, rootType,
                reinterpret_cast<VkBindImageMemoryDeviceGroupInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO: {
            reservedunmarshal_VkDeviceGroupDeviceCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkDeviceGroupDeviceCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: {
            reservedunmarshal_VkPhysicalDeviceFeatures2(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceFeatures2*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES: {
            reservedunmarshal_VkPhysicalDevicePointClippingProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDevicePointClippingProperties*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO: {
            reservedunmarshal_VkRenderPassInputAttachmentAspectCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkRenderPassInputAttachmentAspectCreateInfo*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO: {
            reservedunmarshal_VkImageViewUsageCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkImageViewUsageCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO: {
            reservedunmarshal_VkPipelineTessellationDomainOriginStateCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkPipelineTessellationDomainOriginStateCreateInfo*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO: {
            reservedunmarshal_VkRenderPassMultiviewCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkRenderPassMultiviewCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceMultiviewFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceMultiviewFeatures*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceMultiviewProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceMultiviewProperties*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceVariablePointersFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceVariablePointersFeatures*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceProtectedMemoryFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceProtectedMemoryFeatures*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceProtectedMemoryProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceProtectedMemoryProperties*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO: {
            reservedunmarshal_VkProtectedSubmitInfo(
                vkStream, rootType, reinterpret_cast<VkProtectedSubmitInfo*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO: {
            reservedunmarshal_VkSamplerYcbcrConversionInfo(
                vkStream, rootType,
                reinterpret_cast<VkSamplerYcbcrConversionInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO: {
            reservedunmarshal_VkBindImagePlaneMemoryInfo(
                vkStream, rootType,
                reinterpret_cast<VkBindImagePlaneMemoryInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: {
            reservedunmarshal_VkImagePlaneMemoryRequirementsInfo(
                vkStream, rootType,
                reinterpret_cast<VkImagePlaneMemoryRequirementsInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceSamplerYcbcrConversionFeatures*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES: {
            reservedunmarshal_VkSamplerYcbcrConversionImageFormatProperties(
                vkStream, rootType,
                reinterpret_cast<VkSamplerYcbcrConversionImageFormatProperties*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO: {
            reservedunmarshal_VkPhysicalDeviceExternalImageFormatInfo(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceExternalImageFormatInfo*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES: {
            reservedunmarshal_VkExternalImageFormatProperties(
                vkStream, rootType,
                reinterpret_cast<VkExternalImageFormatProperties*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceIDProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceIDProperties*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO: {
            reservedunmarshal_VkExternalMemoryImageCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkExternalMemoryImageCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO: {
            reservedunmarshal_VkExternalMemoryBufferCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkExternalMemoryBufferCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO: {
            reservedunmarshal_VkExportMemoryAllocateInfo(
                vkStream, rootType,
                reinterpret_cast<VkExportMemoryAllocateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO: {
            reservedunmarshal_VkExportFenceCreateInfo(
                vkStream, rootType, reinterpret_cast<VkExportFenceCreateInfo*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO: {
            reservedunmarshal_VkExportSemaphoreCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkExportSemaphoreCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceMaintenance3Properties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceMaintenance3Properties*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceShaderDrawParametersFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceShaderDrawParametersFeatures*>(
                    structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_VERSION_1_2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceVulkan11Features(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceVulkan11Features*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceVulkan11Properties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceVulkan11Properties*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceVulkan12Features(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceVulkan12Features*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceVulkan12Properties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceVulkan12Properties*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO: {
            reservedunmarshal_VkImageFormatListCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkImageFormatListCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: {
            reservedunmarshal_VkPhysicalDevice8BitStorageFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDevice8BitStorageFeatures*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceDriverProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceDriverProperties*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceShaderAtomicInt64Features(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceShaderAtomicInt64Features*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceShaderFloat16Int8Features(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceShaderFloat16Int8Features*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceFloatControlsProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceFloatControlsProperties*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO: {
            reservedunmarshal_VkDescriptorSetLayoutBindingFlagsCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkDescriptorSetLayoutBindingFlagsCreateInfo*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceDescriptorIndexingFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceDescriptorIndexingFeatures*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceDescriptorIndexingProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceDescriptorIndexingProperties*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO: {
            reservedunmarshal_VkDescriptorSetVariableDescriptorCountAllocateInfo(
                vkStream, rootType,
                reinterpret_cast<VkDescriptorSetVariableDescriptorCountAllocateInfo*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT: {
            reservedunmarshal_VkDescriptorSetVariableDescriptorCountLayoutSupport(
                vkStream, rootType,
                reinterpret_cast<VkDescriptorSetVariableDescriptorCountLayoutSupport*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE: {
            reservedunmarshal_VkSubpassDescriptionDepthStencilResolve(
                vkStream, rootType,
                reinterpret_cast<VkSubpassDescriptionDepthStencilResolve*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceDepthStencilResolveProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceDepthStencilResolveProperties*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceScalarBlockLayoutFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceScalarBlockLayoutFeatures*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO: {
            reservedunmarshal_VkImageStencilUsageCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkImageStencilUsageCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO: {
            reservedunmarshal_VkSamplerReductionModeCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkSamplerReductionModeCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceSamplerFilterMinmaxProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceSamplerFilterMinmaxProperties*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceVulkanMemoryModelFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceVulkanMemoryModelFeatures*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceImagelessFramebufferFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceImagelessFramebufferFeatures*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: {
            reservedunmarshal_VkFramebufferAttachmentsCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkFramebufferAttachmentsCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO: {
            reservedunmarshal_VkRenderPassAttachmentBeginInfo(
                vkStream, rootType,
                reinterpret_cast<VkRenderPassAttachmentBeginInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceUniformBufferStandardLayoutFeatures*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT: {
            reservedunmarshal_VkAttachmentReferenceStencilLayout(
                vkStream, rootType,
                reinterpret_cast<VkAttachmentReferenceStencilLayout*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: {
            reservedunmarshal_VkAttachmentDescriptionStencilLayout(
                vkStream, rootType,
                reinterpret_cast<VkAttachmentDescriptionStencilLayout*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceHostQueryResetFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceHostQueryResetFeatures*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceTimelineSemaphoreFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreFeatures*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceTimelineSemaphoreProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceTimelineSemaphoreProperties*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO: {
            reservedunmarshal_VkSemaphoreTypeCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkSemaphoreTypeCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO: {
            reservedunmarshal_VkTimelineSemaphoreSubmitInfo(
                vkStream, rootType,
                reinterpret_cast<VkTimelineSemaphoreSubmitInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceBufferDeviceAddressFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceBufferDeviceAddressFeatures*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO: {
            reservedunmarshal_VkBufferOpaqueCaptureAddressCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkBufferOpaqueCaptureAddressCreateInfo*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO: {
            reservedunmarshal_VkMemoryOpaqueCaptureAddressAllocateInfo(
                vkStream, rootType,
                reinterpret_cast<VkMemoryOpaqueCaptureAddressAllocateInfo*>(structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_VERSION_1_3
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceVulkan13Features(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceVulkan13Features*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceVulkan13Properties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceVulkan13Properties*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO: {
            reservedunmarshal_VkPipelineCreationFeedbackCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkPipelineCreationFeedbackCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceShaderTerminateInvocationFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceShaderTerminateInvocationFeatures*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES: {
            reservedunmarshal_VkPhysicalDevicePrivateDataFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDevicePrivateDataFeatures*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO: {
            reservedunmarshal_VkDevicePrivateDataCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkDevicePrivateDataCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES: {
            reservedunmarshal_VkPhysicalDevicePipelineCreationCacheControlFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDevicePipelineCreationCacheControlFeatures*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2: {
            reservedunmarshal_VkMemoryBarrier2(
                vkStream, rootType, reinterpret_cast<VkMemoryBarrier2*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceSynchronization2Features(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceSynchronization2Features*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceImageRobustnessFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceImageRobustnessFeatures*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceSubgroupSizeControlFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlFeatures*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceSubgroupSizeControlProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceSubgroupSizeControlProperties*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO: {
            reservedunmarshal_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkPipelineShaderStageRequiredSubgroupSizeCreateInfo*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceInlineUniformBlockFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceInlineUniformBlockFeatures*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceInlineUniformBlockProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceInlineUniformBlockProperties*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK: {
            reservedunmarshal_VkWriteDescriptorSetInlineUniformBlock(
                vkStream, rootType,
                reinterpret_cast<VkWriteDescriptorSetInlineUniformBlock*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO: {
            reservedunmarshal_VkDescriptorPoolInlineUniformBlockCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkDescriptorPoolInlineUniformBlockCreateInfo*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceTextureCompressionASTCHDRFeatures*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO: {
            reservedunmarshal_VkPipelineRenderingCreateInfo(
                vkStream, rootType,
                reinterpret_cast<VkPipelineRenderingCreateInfo*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceDynamicRenderingFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceDynamicRenderingFeatures*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO: {
            reservedunmarshal_VkCommandBufferInheritanceRenderingInfo(
                vkStream, rootType,
                reinterpret_cast<VkCommandBufferInheritanceRenderingInfo*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceShaderIntegerDotProductFeatures(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductFeatures*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceShaderIntegerDotProductProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceShaderIntegerDotProductProperties*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceTexelBufferAlignmentProperties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentProperties*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3: {
            reservedunmarshal_VkFormatProperties3(
                vkStream, rootType, reinterpret_cast<VkFormatProperties3*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES: {
            reservedunmarshal_VkPhysicalDeviceMaintenance4Features(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceMaintenance4Features*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES: {
            reservedunmarshal_VkPhysicalDeviceMaintenance4Properties(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceMaintenance4Properties*>(structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_KHR_dynamic_rendering
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: {
            reservedunmarshal_VkRenderingFragmentShadingRateAttachmentInfoKHR(
                vkStream, rootType,
                reinterpret_cast<VkRenderingFragmentShadingRateAttachmentInfoKHR*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT: {
            reservedunmarshal_VkRenderingFragmentDensityMapAttachmentInfoEXT(
                vkStream, rootType,
                reinterpret_cast<VkRenderingFragmentDensityMapAttachmentInfoEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD: {
            reservedunmarshal_VkAttachmentSampleCountInfoAMD(
                vkStream, rootType,
                reinterpret_cast<VkAttachmentSampleCountInfoAMD*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX: {
            reservedunmarshal_VkMultiviewPerViewAttributesInfoNVX(
                vkStream, rootType,
                reinterpret_cast<VkMultiviewPerViewAttributesInfoNVX*>(structExtension_out), ptr);
            break;
        }
#endif
#ifdef VK_KHR_incremental_present
        case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR: {
            reservedunmarshal_VkPresentRegionsKHR(
                vkStream, rootType, reinterpret_cast<VkPresentRegionsKHR*>(structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_KHR_pipeline_executable_properties
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR: {
            reservedunmarshal_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR*>(
                    structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_KHR_synchronization2
        case VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV: {
            reservedunmarshal_VkQueueFamilyCheckpointProperties2NV(
                vkStream, rootType,
                reinterpret_cast<VkQueueFamilyCheckpointProperties2NV*>(structExtension_out), ptr);
            break;
        }
#endif
#ifdef VK_ANDROID_native_buffer
        case VK_STRUCTURE_TYPE_NATIVE_BUFFER_ANDROID: {
            reservedunmarshal_VkNativeBufferANDROID(
                vkStream, rootType, reinterpret_cast<VkNativeBufferANDROID*>(structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_transform_feedback
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceTransformFeedbackFeaturesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT: {
            reservedunmarshal_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceTransformFeedbackPropertiesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT: {
            reservedunmarshal_VkPipelineRasterizationStateStreamCreateInfoEXT(
                vkStream, rootType,
                reinterpret_cast<VkPipelineRasterizationStateStreamCreateInfoEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_provoking_vertex
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDeviceProvokingVertexFeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceProvokingVertexFeaturesEXT*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT: {
            reservedunmarshal_VkPhysicalDeviceProvokingVertexPropertiesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceProvokingVertexPropertiesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT: {
            reservedunmarshal_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
                vkStream, rootType,
                reinterpret_cast<VkPipelineRasterizationProvokingVertexStateCreateInfoEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_line_rasterization
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDeviceLineRasterizationFeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceLineRasterizationFeaturesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES_EXT: {
            reservedunmarshal_VkPhysicalDeviceLineRasterizationPropertiesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceLineRasterizationPropertiesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO_EXT: {
            reservedunmarshal_VkPipelineRasterizationLineStateCreateInfoEXT(
                vkStream, rootType,
                reinterpret_cast<VkPipelineRasterizationLineStateCreateInfoEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_index_type_uint8
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDeviceIndexTypeUint8FeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceIndexTypeUint8FeaturesEXT*>(structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceExtendedDynamicStateFeaturesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_swapchain_maintenance1
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT: {
            reservedunmarshal_VkSwapchainPresentFenceInfoEXT(
                vkStream, rootType,
                reinterpret_cast<VkSwapchainPresentFenceInfoEXT*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT: {
            reservedunmarshal_VkSwapchainPresentModesCreateInfoEXT(
                vkStream, rootType,
                reinterpret_cast<VkSwapchainPresentModesCreateInfoEXT*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT: {
            reservedunmarshal_VkSwapchainPresentModeInfoEXT(
                vkStream, rootType,
                reinterpret_cast<VkSwapchainPresentModeInfoEXT*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT: {
            reservedunmarshal_VkSwapchainPresentScalingCreateInfoEXT(
                vkStream, rootType,
                reinterpret_cast<VkSwapchainPresentScalingCreateInfoEXT*>(structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_texel_buffer_alignment
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_device_memory_report
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceDeviceMemoryReportFeaturesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT: {
            reservedunmarshal_VkDeviceDeviceMemoryReportCreateInfoEXT(
                vkStream, rootType,
                reinterpret_cast<VkDeviceDeviceMemoryReportCreateInfoEXT*>(structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_custom_border_color
        case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT: {
            reservedunmarshal_VkSamplerCustomBorderColorCreateInfoEXT(
                vkStream, rootType,
                reinterpret_cast<VkSamplerCustomBorderColorCreateInfoEXT*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT: {
            reservedunmarshal_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceCustomBorderColorPropertiesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceCustomBorderColorFeaturesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceImageCompressionControlFeaturesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT: {
            reservedunmarshal_VkImageCompressionControlEXT(
                vkStream, rootType,
                reinterpret_cast<VkImageCompressionControlEXT*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT: {
            reservedunmarshal_VkImageCompressionPropertiesEXT(
                vkStream, rootType,
                reinterpret_cast<VkImageCompressionPropertiesEXT*>(structExtension_out), ptr);
            break;
        }
#endif
#ifdef VK_EXT_4444_formats
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDevice4444FormatsFeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDevice4444FormatsFeaturesEXT*>(structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_primitive_topology_list_restart
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_extended_dynamic_state2
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceExtendedDynamicState2FeaturesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_GOOGLE_gfxstream
        case VK_STRUCTURE_TYPE_IMPORT_COLOR_BUFFER_GOOGLE: {
            reservedunmarshal_VkImportColorBufferGOOGLE(
                vkStream, rootType,
                reinterpret_cast<VkImportColorBufferGOOGLE*>(structExtension_out), ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_IMPORT_BUFFER_GOOGLE: {
            reservedunmarshal_VkImportBufferGOOGLE(
                vkStream, rootType, reinterpret_cast<VkImportBufferGOOGLE*>(structExtension_out),
                ptr);
            break;
        }
        case VK_STRUCTURE_TYPE_CREATE_BLOB_GOOGLE: {
            reservedunmarshal_VkCreateBlobGOOGLE(
                vkStream, rootType, reinterpret_cast<VkCreateBlobGOOGLE*>(structExtension_out),
                ptr);
            break;
        }
#endif
#ifdef VK_EXT_image_compression_control_swapchain
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT: {
            reservedunmarshal_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
                vkStream, rootType,
                reinterpret_cast<VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT*>(
                    structExtension_out),
                ptr);
            break;
        }
#endif
        default: {
            // fatal; the switch is only taken if the extension struct is known
            abort();
        }
    }
}

}  // namespace vk
}  // namespace gfxstream
