/* gitg-avatar-cache.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from gitg-avatar-cache.vala, do not modify */

/*
 * This file is part of gitg
 *
 * Copyright (C) 2013 - Jesse van den Kieboom
 *
 * gitg is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * gitg is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with gitg. If not, see <http://www.gnu.org/licenses/>.
 */

#include "libgitg.h"
#include <gee.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gio/gio.h>
#include "libgitg/gitg-platform-support.h"

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GITG_AVATAR_CACHE_0_PROPERTY,
	GITG_AVATAR_CACHE_NUM_PROPERTIES
};
static GParamSpec* gitg_avatar_cache_properties[GITG_AVATAR_CACHE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _GitgAvatarCacheLoadData GitgAvatarCacheLoadData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GitgAvatarCacheReadAvatarFromFileData GitgAvatarCacheReadAvatarFromFileData;
typedef struct _GitgAvatarCacheReadAvatarData GitgAvatarCacheReadAvatarData;

struct _GitgAvatarCachePrivate {
	GeeHashMap* d_cache;
};

struct _GitgAvatarCacheLoadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgAvatarCache* self;
	gchar* email;
	gint size;
	GCancellable* cancellable;
	GdkPixbuf* result;
	gchar* id;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* ckey;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GeeHashMap* _tmp10_;
	const gchar* _tmp11_;
	GeeHashMap* _tmp12_;
	const gchar* _tmp13_;
	gpointer _tmp14_;
	gchar* gravatar;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	GFile* gfile;
	const gchar* _tmp21_;
	GFile* _tmp22_;
	GdkPixbuf* pixbuf;
	const gchar* _tmp23_;
	GFile* _tmp24_;
	GdkPixbuf* _tmp25_;
	GeeHashMap* _tmp26_;
	const gchar* _tmp27_;
	GdkPixbuf* _tmp28_;
};

struct _GitgAvatarCacheReadAvatarFromFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgAvatarCache* self;
	gchar* id;
	GFile* file;
	gint size;
	GCancellable* cancellable;
	GdkPixbuf* result;
	GInputStream* stream;
	GInputStream* _tmp0_;
	GInputStream* _tmp1_;
	GInputStream* _tmp2_;
	GError* e;
	gchar* _tmp3_;
	gchar* _tmp4_;
	GError* _tmp5_;
	const gchar* _tmp6_;
	guint8* buffer;
	guint8* _tmp7_;
	gint buffer_length1;
	gint _buffer_size_;
	GdkPixbufLoader* loader;
	GdkPixbufLoader* _tmp8_;
	GdkPixbufLoader* _tmp9_;
	GInputStream* _tmp10_;
	guint8* _tmp11_;
	gint _tmp11__length1;
	GdkPixbufLoader* _tmp12_;
	GdkPixbuf* _tmp13_;
	GError* _inner_error0_;
};

struct _GitgAvatarCacheReadAvatarData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GitgAvatarCache* self;
	gchar* id;
	GInputStream* stream;
	guint8* buffer;
	gint buffer_length1;
	GdkPixbufLoader* loader;
	GCancellable* cancellable;
	GdkPixbuf* result;
	gssize n;
	gssize _tmp0_;
	GdkPixbuf* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	GError* _inner_error0_;
};

static gint GitgAvatarCache_private_offset;
static gpointer gitg_avatar_cache_parent_class = NULL;
static GitgAvatarCache* gitg_avatar_cache_s_instance;
static GitgAvatarCache* gitg_avatar_cache_s_instance = NULL;

static GitgAvatarCache* gitg_avatar_cache_new (void);
static GitgAvatarCache* gitg_avatar_cache_construct (GType object_type);
static void gitg_avatar_cache_load_data_free (gpointer _data);
static gboolean gitg_avatar_cache_load_co (GitgAvatarCacheLoadData* _data_);
static void gitg_avatar_cache_read_avatar_from_file (GitgAvatarCache* self,
                                              const gchar* id,
                                              GFile* file,
                                              gint size,
                                              GCancellable* cancellable,
                                              GAsyncReadyCallback _callback_,
                                              gpointer _user_data_);
static GdkPixbuf* gitg_avatar_cache_read_avatar_from_file_finish (GitgAvatarCache* self,
                                                           GAsyncResult* _res_);
static void gitg_avatar_cache_load_ready (GObject* source_object,
                                   GAsyncResult* _res_,
                                   gpointer _user_data_);
static void gitg_avatar_cache_read_avatar_from_file_data_free (gpointer _data);
static gboolean gitg_avatar_cache_read_avatar_from_file_co (GitgAvatarCacheReadAvatarFromFileData* _data_);
static void gitg_avatar_cache_read_avatar_from_file_ready (GObject* source_object,
                                                    GAsyncResult* _res_,
                                                    gpointer _user_data_);
static void gitg_avatar_cache_read_avatar (GitgAvatarCache* self,
                                    const gchar* id,
                                    GInputStream* stream,
                                    guint8* buffer,
                                    gint buffer_length1,
                                    GdkPixbufLoader* loader,
                                    GCancellable* cancellable,
                                    GAsyncReadyCallback _callback_,
                                    gpointer _user_data_);
static GdkPixbuf* gitg_avatar_cache_read_avatar_finish (GitgAvatarCache* self,
                                                 GAsyncResult* _res_);
static void gitg_avatar_cache_read_avatar_data_free (gpointer _data);
static gboolean gitg_avatar_cache_read_avatar_co (GitgAvatarCacheReadAvatarData* _data_);
static void gitg_avatar_cache_read_avatar_ready (GObject* source_object,
                                          GAsyncResult* _res_,
                                          gpointer _user_data_);
static GObject * gitg_avatar_cache_constructor (GType type,
                                         guint n_construct_properties,
                                         GObjectConstructParam * construct_properties);
static void gitg_avatar_cache_finalize (GObject * obj);
static GType gitg_avatar_cache_get_type_once (void);

static inline gpointer
gitg_avatar_cache_get_instance_private (GitgAvatarCache* self)
{
	return G_STRUCT_MEMBER_P (self, GitgAvatarCache_private_offset);
}

static GitgAvatarCache*
gitg_avatar_cache_construct (GType object_type)
{
	GitgAvatarCache * self = NULL;
	self = (GitgAvatarCache*) g_object_new (object_type, NULL);
	return self;
}

static GitgAvatarCache*
gitg_avatar_cache_new (void)
{
	return gitg_avatar_cache_construct (GITG_TYPE_AVATAR_CACHE);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GitgAvatarCache*
gitg_avatar_cache_default (void)
{
	GitgAvatarCache* _tmp0_;
	GitgAvatarCache* _tmp2_;
	GitgAvatarCache* _tmp3_;
	GitgAvatarCache* result;
	_tmp0_ = gitg_avatar_cache_s_instance;
	if (_tmp0_ == NULL) {
		GitgAvatarCache* _tmp1_;
		_tmp1_ = gitg_avatar_cache_new ();
		_g_object_unref0 (gitg_avatar_cache_s_instance);
		gitg_avatar_cache_s_instance = _tmp1_;
	}
	_tmp2_ = gitg_avatar_cache_s_instance;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static void
gitg_avatar_cache_load_data_free (gpointer _data)
{
	GitgAvatarCacheLoadData* _data_;
	_data_ = _data;
	_g_free0 (_data_->email);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgAvatarCacheLoadData, _data_);
}

void
gitg_avatar_cache_load (GitgAvatarCache* self,
                        const gchar* email,
                        gint size,
                        GCancellable* cancellable,
                        GAsyncReadyCallback _callback_,
                        gpointer _user_data_)
{
	GitgAvatarCacheLoadData* _data_;
	GitgAvatarCache* _tmp0_;
	gchar* _tmp1_;
	GCancellable* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (email != NULL);
	_data_ = g_slice_new0 (GitgAvatarCacheLoadData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_avatar_cache_load_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (email);
	_g_free0 (_data_->email);
	_data_->email = _tmp1_;
	_data_->size = size;
	_tmp2_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp2_;
	gitg_avatar_cache_load_co (_data_);
}

GdkPixbuf*
gitg_avatar_cache_load_finish (GitgAvatarCache* self,
                               GAsyncResult* _res_)
{
	GdkPixbuf* result;
	GitgAvatarCacheLoadData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
gitg_avatar_cache_load_ready (GObject* source_object,
                              GAsyncResult* _res_,
                              gpointer _user_data_)
{
	GitgAvatarCacheLoadData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_avatar_cache_load_co (_data_);
}

static gboolean
gitg_avatar_cache_load_co (GitgAvatarCacheLoadData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = g_utf8_strdown (_data_->email, (gssize) -1);
	_data_->_tmp1_ = _data_->_tmp0_;
	_data_->_tmp2_ = g_compute_checksum_for_string (G_CHECKSUM_MD5, _data_->_tmp1_, (gsize) -1);
	_data_->_tmp3_ = _data_->_tmp2_;
	_g_free0 (_data_->_tmp1_);
	_data_->id = _data_->_tmp3_;
	_data_->_tmp4_ = _data_->id;
	_data_->_tmp5_ = string_to_string (_data_->_tmp4_);
	_data_->_tmp6_ = g_strdup_printf ("%i", _data_->size);
	_data_->_tmp7_ = _data_->_tmp6_;
	_data_->_tmp8_ = g_strconcat (_data_->_tmp5_, " ", _data_->_tmp7_, NULL);
	_data_->_tmp9_ = _data_->_tmp8_;
	_g_free0 (_data_->_tmp7_);
	_data_->ckey = _data_->_tmp9_;
	_data_->_tmp10_ = _data_->self->priv->d_cache;
	_data_->_tmp11_ = _data_->ckey;
	if (gee_abstract_map_has_key ((GeeAbstractMap*) _data_->_tmp10_, _data_->_tmp11_)) {
		_data_->_tmp12_ = _data_->self->priv->d_cache;
		_data_->_tmp13_ = _data_->ckey;
		_data_->_tmp14_ = gee_abstract_map_get ((GeeAbstractMap*) _data_->_tmp12_, _data_->_tmp13_);
		_data_->result = (GdkPixbuf*) _data_->_tmp14_;
		_g_free0 (_data_->ckey);
		_g_free0 (_data_->id);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp15_ = _data_->id;
	_data_->_tmp16_ = string_to_string (_data_->_tmp15_);
	_data_->_tmp17_ = g_strdup_printf ("%i", _data_->size);
	_data_->_tmp18_ = _data_->_tmp17_;
	_data_->_tmp19_ = g_strconcat ("https://www.gravatar.com/avatar/", _data_->_tmp16_, "?d=404&s=", _data_->_tmp18_, NULL);
	_data_->_tmp20_ = _data_->_tmp19_;
	_g_free0 (_data_->_tmp18_);
	_data_->gravatar = _data_->_tmp20_;
	_data_->_tmp21_ = _data_->gravatar;
	_data_->_tmp22_ = g_file_new_for_uri (_data_->_tmp21_);
	_data_->gfile = _data_->_tmp22_;
	_data_->_tmp23_ = _data_->id;
	_data_->_tmp24_ = _data_->gfile;
	_data_->_state_ = 1;
	gitg_avatar_cache_read_avatar_from_file (_data_->self, _data_->_tmp23_, _data_->_tmp24_, _data_->size, _data_->cancellable, gitg_avatar_cache_load_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp25_ = gitg_avatar_cache_read_avatar_from_file_finish (_data_->self, _data_->_res_);
	_data_->pixbuf = _data_->_tmp25_;
	_data_->_tmp26_ = _data_->self->priv->d_cache;
	_data_->_tmp27_ = _data_->ckey;
	_data_->_tmp28_ = _data_->pixbuf;
	gee_abstract_map_set ((GeeAbstractMap*) _data_->_tmp26_, _data_->_tmp27_, _data_->_tmp28_);
	_data_->result = _data_->pixbuf;
	_g_object_unref0 (_data_->gfile);
	_g_free0 (_data_->gravatar);
	_g_free0 (_data_->ckey);
	_g_free0 (_data_->id);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_avatar_cache_read_avatar_from_file_data_free (gpointer _data)
{
	GitgAvatarCacheReadAvatarFromFileData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->file);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgAvatarCacheReadAvatarFromFileData, _data_);
}

static void
gitg_avatar_cache_read_avatar_from_file (GitgAvatarCache* self,
                                         const gchar* id,
                                         GFile* file,
                                         gint size,
                                         GCancellable* cancellable,
                                         GAsyncReadyCallback _callback_,
                                         gpointer _user_data_)
{
	GitgAvatarCacheReadAvatarFromFileData* _data_;
	GitgAvatarCache* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	GCancellable* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (file != NULL);
	_data_ = g_slice_new0 (GitgAvatarCacheReadAvatarFromFileData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_avatar_cache_read_avatar_from_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (file);
	_g_object_unref0 (_data_->file);
	_data_->file = _tmp2_;
	_data_->size = size;
	_tmp3_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp3_;
	gitg_avatar_cache_read_avatar_from_file_co (_data_);
}

static GdkPixbuf*
gitg_avatar_cache_read_avatar_from_file_finish (GitgAvatarCache* self,
                                                GAsyncResult* _res_)
{
	GdkPixbuf* result;
	GitgAvatarCacheReadAvatarFromFileData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
gitg_avatar_cache_read_avatar_from_file_ready (GObject* source_object,
                                               GAsyncResult* _res_,
                                               gpointer _user_data_)
{
	GitgAvatarCacheReadAvatarFromFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_avatar_cache_read_avatar_from_file_co (_data_);
}

static gboolean
gitg_avatar_cache_read_avatar_from_file_co (GitgAvatarCacheReadAvatarFromFileData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		gitg_platform_support_http_get (_data_->file, _data_->cancellable, gitg_avatar_cache_read_avatar_from_file_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = gitg_platform_support_http_get_finish (_data_->_res_, &_data_->_inner_error0_);
		_data_->_tmp0_ = _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->stream);
		_data_->stream = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error0_;
		_data_->_inner_error0_ = NULL;
		_data_->_tmp3_ = g_file_get_path (_data_->file);
		_data_->_tmp4_ = _data_->_tmp3_;
		_data_->_tmp5_ = _data_->e;
		_data_->_tmp6_ = _data_->_tmp5_->message;
		g_debug ("gitg-avatar-cache.vala:78: Can not retrieve avatar from %s: %s", _data_->_tmp4_, _data_->_tmp6_);
		_g_free0 (_data_->_tmp4_);
		_data_->result = NULL;
		_g_error_free0 (_data_->e);
		_g_object_unref0 (_data_->stream);
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		_g_object_unref0 (_data_->stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = g_new0 (guint8, 4096);
	_data_->buffer = _data_->_tmp7_;
	_data_->buffer_length1 = 4096;
	_data_->_buffer_size_ = _data_->buffer_length1;
	_data_->_tmp8_ = gdk_pixbuf_loader_new ();
	_data_->loader = _data_->_tmp8_;
	_data_->_tmp9_ = _data_->loader;
	gdk_pixbuf_loader_set_size (_data_->_tmp9_, _data_->size, _data_->size);
	_data_->_tmp10_ = _data_->stream;
	_data_->_tmp11_ = _data_->buffer;
	_data_->_tmp11__length1 = _data_->buffer_length1;
	_data_->_tmp12_ = _data_->loader;
	_data_->_state_ = 2;
	gitg_avatar_cache_read_avatar (_data_->self, _data_->id, _data_->_tmp10_, _data_->_tmp11_, (gint) _data_->_tmp11__length1, _data_->_tmp12_, _data_->cancellable, gitg_avatar_cache_read_avatar_from_file_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp13_ = gitg_avatar_cache_read_avatar_finish (_data_->self, _data_->_res_);
	_data_->result = _data_->_tmp13_;
	_g_object_unref0 (_data_->loader);
	_data_->buffer = (g_free (_data_->buffer), NULL);
	_g_object_unref0 (_data_->stream);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
gitg_avatar_cache_read_avatar_data_free (gpointer _data)
{
	GitgAvatarCacheReadAvatarData* _data_;
	_data_ = _data;
	_g_free0 (_data_->id);
	_g_object_unref0 (_data_->stream);
	_g_object_unref0 (_data_->loader);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GitgAvatarCacheReadAvatarData, _data_);
}

static void
gitg_avatar_cache_read_avatar (GitgAvatarCache* self,
                               const gchar* id,
                               GInputStream* stream,
                               guint8* buffer,
                               gint buffer_length1,
                               GdkPixbufLoader* loader,
                               GCancellable* cancellable,
                               GAsyncReadyCallback _callback_,
                               gpointer _user_data_)
{
	GitgAvatarCacheReadAvatarData* _data_;
	GitgAvatarCache* _tmp0_;
	gchar* _tmp1_;
	GInputStream* _tmp2_;
	GdkPixbufLoader* _tmp3_;
	GCancellable* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	g_return_if_fail (stream != NULL);
	g_return_if_fail (loader != NULL);
	_data_ = g_slice_new0 (GitgAvatarCacheReadAvatarData);
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, gitg_avatar_cache_read_avatar_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (id);
	_g_free0 (_data_->id);
	_data_->id = _tmp1_;
	_tmp2_ = _g_object_ref0 (stream);
	_g_object_unref0 (_data_->stream);
	_data_->stream = _tmp2_;
	_data_->buffer = buffer;
	_data_->buffer_length1 = buffer_length1;
	_tmp3_ = _g_object_ref0 (loader);
	_g_object_unref0 (_data_->loader);
	_data_->loader = _tmp3_;
	_tmp4_ = _g_object_ref0 (cancellable);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	gitg_avatar_cache_read_avatar_co (_data_);
}

static GdkPixbuf*
gitg_avatar_cache_read_avatar_finish (GitgAvatarCache* self,
                                      GAsyncResult* _res_)
{
	GdkPixbuf* result;
	GitgAvatarCacheReadAvatarData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	if (NULL == _data_) {
		return NULL;
	}
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static void
gitg_avatar_cache_read_avatar_ready (GObject* source_object,
                                     GAsyncResult* _res_,
                                     gpointer _user_data_)
{
	GitgAvatarCacheReadAvatarData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	gitg_avatar_cache_read_avatar_co (_data_);
}

static gboolean
gitg_avatar_cache_read_avatar_co (GitgAvatarCacheReadAvatarData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_input_stream_read_async (_data_->stream, _data_->buffer, (gsize) _data_->buffer_length1, G_PRIORITY_LOW, _data_->cancellable, gitg_avatar_cache_read_avatar_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp0_ = g_input_stream_read_finish (_data_->stream, _data_->_res_, &_data_->_inner_error0_);
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->n = _data_->_tmp0_;
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_data_->_inner_error0_);
		_data_->result = NULL;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
		g_clear_error (&_data_->_inner_error0_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	if (_data_->n != ((gssize) 0)) {
		{
			gdk_pixbuf_loader_write (_data_->loader, _data_->buffer + 0, (gsize) (((gint) _data_->n) - 0), &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			_data_->result = NULL;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally1:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_state_ = 2;
		gitg_avatar_cache_read_avatar (_data_->self, _data_->id, _data_->stream, _data_->buffer, (gint) _data_->buffer_length1, _data_->loader, _data_->cancellable, gitg_avatar_cache_read_avatar_ready, _data_);
		return FALSE;
		_state_2:
		_data_->_tmp1_ = gitg_avatar_cache_read_avatar_finish (_data_->self, _data_->_res_);
		_data_->result = _data_->_tmp1_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	} else {
		{
			gdk_pixbuf_loader_close (_data_->loader, &_data_->_inner_error0_);
			if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			g_clear_error (&_data_->_inner_error0_);
			_data_->result = NULL;
			g_task_return_pointer (_data_->_async_result, _data_, NULL);
			if (_data_->_state_ != 0) {
				while (!g_task_get_completed (_data_->_async_result)) {
					g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
				}
			}
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error0_->message, g_quark_to_string (_data_->_inner_error0_->domain), _data_->_inner_error0_->code);
			g_clear_error (&_data_->_inner_error0_);
			g_object_unref (_data_->_async_result);
			return FALSE;
		}
		_data_->_tmp2_ = gdk_pixbuf_loader_get_pixbuf (_data_->loader);
		_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
		_data_->result = _data_->_tmp3_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (!g_task_get_completed (_data_->_async_result)) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
}

static GObject *
gitg_avatar_cache_constructor (GType type,
                               guint n_construct_properties,
                               GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	GitgAvatarCache * self;
	GeeHashMap* _tmp0_;
	parent_class = G_OBJECT_CLASS (gitg_avatar_cache_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_AVATAR_CACHE, GitgAvatarCache);
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, gdk_pixbuf_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (self->priv->d_cache);
	self->priv->d_cache = _tmp0_;
	return obj;
}

static void
gitg_avatar_cache_class_init (GitgAvatarCacheClass * klass,
                              gpointer klass_data)
{
	gitg_avatar_cache_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GitgAvatarCache_private_offset);
	G_OBJECT_CLASS (klass)->constructor = gitg_avatar_cache_constructor;
	G_OBJECT_CLASS (klass)->finalize = gitg_avatar_cache_finalize;
}

static void
gitg_avatar_cache_instance_init (GitgAvatarCache * self,
                                 gpointer klass)
{
	self->priv = gitg_avatar_cache_get_instance_private (self);
}

static void
gitg_avatar_cache_finalize (GObject * obj)
{
	GitgAvatarCache * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GITG_TYPE_AVATAR_CACHE, GitgAvatarCache);
	_g_object_unref0 (self->priv->d_cache);
	G_OBJECT_CLASS (gitg_avatar_cache_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
gitg_avatar_cache_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GitgAvatarCacheClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gitg_avatar_cache_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GitgAvatarCache), 0, (GInstanceInitFunc) gitg_avatar_cache_instance_init, NULL };
	GType gitg_avatar_cache_type_id;
	gitg_avatar_cache_type_id = g_type_register_static (G_TYPE_OBJECT, "GitgAvatarCache", &g_define_type_info, 0);
	GitgAvatarCache_private_offset = g_type_add_instance_private (gitg_avatar_cache_type_id, sizeof (GitgAvatarCachePrivate));
	return gitg_avatar_cache_type_id;
}

GType
gitg_avatar_cache_get_type (void)
{
	static gsize gitg_avatar_cache_type_id__once = 0;
	if (g_once_init_enter (&gitg_avatar_cache_type_id__once)) {
		GType gitg_avatar_cache_type_id;
		gitg_avatar_cache_type_id = gitg_avatar_cache_get_type_once ();
		g_once_init_leave (&gitg_avatar_cache_type_id__once, gitg_avatar_cache_type_id);
	}
	return gitg_avatar_cache_type_id__once;
}

