/* grid.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from grid.vala, do not modify */

/*
   This file is part of GNOME 2048.

   Copyright (C) 2014-2015 Juan R. García Blanco <juanrgar@gmail.com>
   Copyright (C) 2016-2019 Arnaud Bonatti <arnaud.bonatti@gmail.com>

   GNOME 2048 is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   GNOME 2048 is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with GNOME 2048.  If not, see <https://www.gnu.org/licenses/>.
*/

#include <glib-object.h>
#include <glib.h>
#include <gee.h>
#include <math.h>
#include <float.h>
#include <stdlib.h>
#include <string.h>
#include <errno.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_GRID (grid_get_type ())
#define GRID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GRID, Grid))
#define GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GRID, GridClass))
#define IS_GRID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GRID))
#define IS_GRID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GRID))
#define GRID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GRID, GridClass))

typedef struct _Grid Grid;
typedef struct _GridClass GridClass;
typedef struct _GridPrivate GridPrivate;
enum  {
	GRID_0_PROPERTY,
	GRID_ROWS_PROPERTY,
	GRID_COLS_PROPERTY,
	GRID_TARGET_VALUE_PROPERTY,
	GRID_TARGET_VALUE_SIMPLE_PROPERTY,
	GRID_TARGET_VALUE_REACHED_PROPERTY,
	GRID_NUM_PROPERTIES
};
static GParamSpec* grid_properties[GRID_NUM_PROPERTIES];

#define TYPE_TILE (tile_get_type ())
typedef struct _Tile Tile;

#define TYPE_GRID_POSITION (grid_position_get_type ())
typedef struct _GridPosition GridPosition;
typedef enum  {
	MOVE_REQUEST_UP,
	MOVE_REQUEST_RIGHT,
	MOVE_REQUEST_DOWN,
	MOVE_REQUEST_LEFT
} MoveRequest;

#define TYPE_MOVE_REQUEST (move_request_get_type ())

#define TYPE_TILE_MOVEMENT (tile_movement_get_type ())
typedef struct _TileMovement TileMovement;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Grid {
	GObject parent_instance;
	GridPrivate * priv;
	guint8* _grid;
	gint _grid_length1;
	gint _grid_length2;
};

struct _GridClass {
	GObjectClass parent_class;
};

struct _GridPrivate {
	guint8 _rows;
	guint8 _cols;
	guint _target_value;
	guint _target_value_simple;
	gboolean _target_value_reached;
};

struct _GridPosition {
	gint8 row;
	gint8 col;
};

struct _Tile {
	GridPosition pos;
	guint8 val;
};

struct _TileMovement {
	GridPosition from;
	GridPosition to;
};

static gint Grid_private_offset;
static gpointer grid_parent_class = NULL;

VALA_EXTERN GType grid_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Grid, g_object_unref)
VALA_EXTERN Grid* grid_new (guint8 rows,
                guint8 cols);
VALA_EXTERN Grid* grid_construct (GType object_type,
                      guint8 rows,
                      guint8 cols);
VALA_EXTERN GType tile_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType grid_position_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GridPosition* grid_position_dup (const GridPosition* self);
VALA_EXTERN void grid_position_free (GridPosition* self);
VALA_EXTERN Tile* tile_dup (const Tile* self);
VALA_EXTERN void tile_free (Tile* self);
VALA_EXTERN void grid_new_tile (Grid* self,
                    Tile* tile);
VALA_EXTERN gboolean _grid_grid_is_full (guint8** grid,
                             gint* grid_length1,
                             gint* grid_length2);
static inline void _grid_generate_random_position (guint8 rows,
                                     guint8 cols,
                                     GridPosition* pos);
VALA_EXTERN guint8 grid_get_rows (Grid* self);
VALA_EXTERN guint8 grid_get_cols (Grid* self);
VALA_EXTERN GType move_request_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType tile_movement_get_type (void) G_GNUC_CONST ;
VALA_EXTERN TileMovement* tile_movement_dup (const TileMovement* self);
VALA_EXTERN void tile_movement_free (TileMovement* self);
VALA_EXTERN void grid_move (Grid* self,
                MoveRequest request,
                GeeLinkedList** to_move,
                GeeLinkedList** to_hide,
                GeeLinkedList** to_show);
static void _grid_move_down (gint8 cols,
                      gint8 rows,
                      guint8* max_changed,
                      guint8** grid,
                      gint* grid_length1,
                      gint* grid_length2,
                      GeeLinkedList** to_move,
                      GeeLinkedList** to_hide,
                      GeeLinkedList** to_show);
static void _grid_move_up (gint8 cols,
                    gint8 rows,
                    guint8* max_changed,
                    guint8** grid,
                    gint* grid_length1,
                    gint* grid_length2,
                    GeeLinkedList** to_move,
                    GeeLinkedList** to_hide,
                    GeeLinkedList** to_show);
static void _grid_move_left (gint8 cols,
                      gint8 rows,
                      guint8* max_changed,
                      guint8** grid,
                      gint* grid_length1,
                      gint* grid_length2,
                      GeeLinkedList** to_move,
                      GeeLinkedList** to_hide,
                      GeeLinkedList** to_show);
static void _grid_move_right (gint8 cols,
                       gint8 rows,
                       guint8* max_changed,
                       guint8** grid,
                       gint* grid_length1,
                       gint* grid_length2,
                       GeeLinkedList** to_move,
                       GeeLinkedList** to_hide,
                       GeeLinkedList** to_show);
VALA_EXTERN guint grid_get_target_value (Grid* self);
static void grid_set_target_value_simple (Grid* self,
                                   guint value);
VALA_EXTERN void grid_set_target_value_reached (Grid* self,
                                    gboolean value);
static void _grid_move_to_match (GeeLinkedList** to_hide,
                          GeeLinkedList** to_show,
                          GridPosition* cur,
                          GridPosition* free,
                          GridPosition* match,
                          guint8** grid,
                          gint* grid_length1,
                          gint* grid_length2,
                          guint8* val,
                          guint8* max_changed);
static void _grid_move_to_end (GeeLinkedList** to_move,
                        GridPosition* cur,
                        GridPosition* free,
                        guint8** grid,
                        gint* grid_length1,
                        gint* grid_length2,
                        guint8* val);
VALA_EXTERN gchar* grid_position_to_string (GridPosition *self);
VALA_EXTERN gboolean grid_is_finished (Grid* self);
VALA_EXTERN void grid_clear (Grid* self);
static void _grid_clear (guint8** grid,
                  gint* grid_length1,
                  gint* grid_length2);
VALA_EXTERN glong grid_get_score (Grid* self);
static glong _grid_get_score (guint8** grid,
                       gint* grid_length1,
                       gint* grid_length2);
static inline glong _grid_calculate_score_value (guint8 tile_value);
VALA_EXTERN Grid* grid_clone (Grid* self);
static guint8* _vala_array_dup1 (guint8* self,
                          gssize length);
VALA_EXTERN guint8 grid_get (Grid* self,
                 guint8 row,
                 guint8 col);
VALA_EXTERN gboolean grid_is_disallowed_grid_size (guint8* rows,
                                       guint8* cols);
VALA_EXTERN gchar* grid_save (Grid* self);
static void _grid_convert_to_string (guint8** grid,
                              gint* grid_length1,
                              gint* grid_length2,
                              gchar** ret_string);
VALA_EXTERN gchar* grid_to_string (Grid* self);
VALA_EXTERN gboolean grid_load (Grid* self,
                    gchar** content);
static gboolean _grid_load_from_string (gchar** content,
                                 guint8** grid,
                                 gint* grid_length1,
                                 gint* grid_length2);
static guint8* _vala_array_dup2 (guint8* self,
                          gssize length);
static inline void _grid_parse_line (const gchar* line,
                       gchar*** tokens,
                       gint* tokens_length1);
static inline gboolean _grid_convert_tile_number (guint64* number_64,
                                    guint8* number);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static gchar** _vala_array_dup3 (gchar** self,
                          gssize length);
VALA_EXTERN void grid_save_game (Grid* self,
                     const gchar* path);
VALA_EXTERN gboolean grid_restore_game (Grid* self,
                            const gchar* path);
static void grid_set_rows (Grid* self,
                    guint8 value);
static void grid_set_cols (Grid* self,
                    guint8 value);
VALA_EXTERN void grid_set_target_value (Grid* self,
                            guint value);
VALA_EXTERN guint grid_get_target_value_simple (Grid* self);
VALA_EXTERN gboolean grid_get_target_value_reached (Grid* self);
static GObject * grid_constructor (GType type,
                            guint n_construct_properties,
                            GObjectConstructParam * construct_properties);
static void grid_finalize (GObject * obj);
static GType grid_get_type_once (void);
static void _vala_grid_get_property (GObject * object,
                              guint property_id,
                              GValue * value,
                              GParamSpec * pspec);
static void _vala_grid_set_property (GObject * object,
                              guint property_id,
                              const GValue * value,
                              GParamSpec * pspec);
VALA_EXTERN gchar* move_request_debug_string (MoveRequest request);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
grid_get_instance_private (Grid* self)
{
	return G_STRUCT_MEMBER_P (self, Grid_private_offset);
}

Grid*
grid_construct (GType object_type,
                guint8 rows,
                guint8 cols)
{
	Grid * self = NULL;
	self = (Grid*) g_object_new (object_type, "rows", rows, "cols", cols, NULL);
	return self;
}

Grid*
grid_new (guint8 rows,
          guint8 cols)
{
	return grid_construct (TYPE_GRID, rows, cols);
}

void
grid_new_tile (Grid* self,
               Tile* tile)
{
	Tile _vala_tile = {0};
	gboolean _tmp0_;
	GridPosition pos = {0};
	GridPosition _tmp1_ = {0};
	guint8* _tmp10_;
	gint _tmp10__length1;
	gint _tmp10__length2;
	GridPosition _tmp11_;
	GridPosition _tmp12_;
	GridPosition _tmp13_;
	Tile _tmp14_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = _grid_grid_is_full (&self->_grid, (gint*) (&self->_grid_length1), (gint*) (&self->_grid_length2));
	if (_tmp0_) {
		g_assert_not_reached ();
	}
	_tmp1_.row = (gint8) 0;
	_tmp1_.col = (gint8) 0;
	pos = _tmp1_;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			guint8 _tmp7_;
			guint8 _tmp8_;
			GridPosition _tmp9_ = {0};
			if (!_tmp2_) {
				guint8* _tmp3_;
				gint _tmp3__length1;
				gint _tmp3__length2;
				GridPosition _tmp4_;
				GridPosition _tmp5_;
				guint8 _tmp6_;
				_tmp3_ = self->_grid;
				_tmp3__length1 = self->_grid_length1;
				_tmp3__length2 = self->_grid_length2;
				_tmp4_ = pos;
				_tmp5_ = pos;
				_tmp6_ = _tmp3_[(_tmp4_.row * _tmp3__length2) + _tmp5_.col];
				if (!(((gint) _tmp6_) != 0)) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp7_ = self->priv->_rows;
			_tmp8_ = self->priv->_cols;
			_grid_generate_random_position (_tmp7_, _tmp8_, &_tmp9_);
			pos = _tmp9_;
		}
	}
	_tmp10_ = self->_grid;
	_tmp10__length1 = self->_grid_length1;
	_tmp10__length2 = self->_grid_length2;
	_tmp11_ = pos;
	_tmp12_ = pos;
	_tmp10_[(_tmp11_.row * _tmp10__length2) + _tmp12_.col] = (guint8) 1;
	_tmp13_ = pos;
	_tmp14_.pos = _tmp13_;
	_tmp14_.val = (guint8) 1;
	_vala_tile = _tmp14_;
	if (tile) {
		*tile = _vala_tile;
	}
}

static inline void
_grid_generate_random_position (guint8 rows,
                                guint8 cols,
                                GridPosition* pos)
{
	GridPosition _vala_pos = {0};
	GridPosition _tmp0_ = {0};
	_tmp0_.row = (gint8) g_random_int_range ((gint32) 0, (gint32) rows);
	_tmp0_.col = (gint8) g_random_int_range ((gint32) 0, (gint32) cols);
	_vala_pos = _tmp0_;
	if (pos) {
		*pos = _vala_pos;
	}
}

inline void
grid_move (Grid* self,
           MoveRequest request,
           GeeLinkedList** to_move,
           GeeLinkedList** to_hide,
           GeeLinkedList** to_show)
{
	guint8 max_changed = 0U;
	guint _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (*to_move != NULL);
	g_return_if_fail (*to_hide != NULL);
	g_return_if_fail (*to_show != NULL);
	gee_abstract_collection_clear ((GeeAbstractCollection*) (*to_move));
	gee_abstract_collection_clear ((GeeAbstractCollection*) (*to_hide));
	gee_abstract_collection_clear ((GeeAbstractCollection*) (*to_show));
	max_changed = (guint8) 0;
	switch (request) {
		case MOVE_REQUEST_DOWN:
		{
			_grid_move_down ((gint8) self->priv->_cols, (gint8) self->priv->_rows, &max_changed, &self->_grid, (gint*) (&self->_grid_length1), (gint*) (&self->_grid_length2), to_move, to_hide, to_show);
			break;
		}
		case MOVE_REQUEST_UP:
		{
			_grid_move_up ((gint8) self->priv->_cols, (gint8) self->priv->_rows, &max_changed, &self->_grid, (gint*) (&self->_grid_length1), (gint*) (&self->_grid_length2), to_move, to_hide, to_show);
			break;
		}
		case MOVE_REQUEST_LEFT:
		{
			_grid_move_left ((gint8) self->priv->_cols, (gint8) self->priv->_rows, &max_changed, &self->_grid, (gint*) (&self->_grid_length1), (gint*) (&self->_grid_length2), to_move, to_hide, to_show);
			break;
		}
		case MOVE_REQUEST_RIGHT:
		{
			_grid_move_right ((gint8) self->priv->_cols, (gint8) self->priv->_rows, &max_changed, &self->_grid, (gint*) (&self->_grid_length1), (gint*) (&self->_grid_length2), to_move, to_hide, to_show);
			break;
		}
		default:
		break;
	}
	_tmp0_ = self->priv->_target_value;
	if (pow ((gdouble) 2, (gdouble) max_changed) >= ((gdouble) _tmp0_)) {
		grid_set_target_value_simple (self, (guint) max_changed);
		grid_set_target_value_reached (self, TRUE);
	}
}

static void
_grid_move_down (gint8 cols,
                 gint8 rows,
                 guint8* max_changed,
                 guint8** grid,
                 gint* grid_length1,
                 gint* grid_length2,
                 GeeLinkedList** to_move,
                 GeeLinkedList** to_hide,
                 GeeLinkedList** to_show)
{
	g_return_if_fail (*to_move != NULL);
	g_return_if_fail (*to_hide != NULL);
	g_return_if_fail (*to_show != NULL);
	{
		gint8 i = 0;
		i = (gint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GridPosition free = {0};
				GridPosition _tmp2_ = {0};
				if (!_tmp0_) {
					gint8 _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < cols)) {
					break;
				}
				_tmp2_.row = rows;
				_tmp2_.col = i;
				free = _tmp2_;
				{
					gint8 j = 0;
					j = (gint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint8 row = 0;
							GridPosition cur = {0};
							GridPosition _tmp5_ = {0};
							guint8 val = 0U;
							GridPosition _tmp6_;
							GridPosition _tmp7_;
							guint8 _tmp8_;
							GridPosition match = {0};
							GridPosition _tmp10_ = {0};
							gboolean has_match = FALSE;
							if (!_tmp3_) {
								gint8 _tmp4_;
								_tmp4_ = j;
								j = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(j < rows)) {
								break;
							}
							row = (gint8) ((rows - j) - 1);
							_tmp5_.row = row;
							_tmp5_.col = i;
							cur = _tmp5_;
							_tmp6_ = cur;
							_tmp7_ = cur;
							_tmp8_ = (*grid)[(_tmp6_.row * (*grid_length2)) + _tmp7_.col];
							val = _tmp8_;
							if (((gint) val) == 0) {
								GridPosition _tmp9_;
								_tmp9_ = free;
								if (_tmp9_.row == rows) {
									free.row = row;
								}
								continue;
							}
							_tmp10_.row = (gint8) 0;
							_tmp10_.col = (gint8) 0;
							match = _tmp10_;
							has_match = FALSE;
							{
								gint8 k = 0;
								k = (gint8) (row - 1);
								{
									gboolean _tmp11_ = FALSE;
									_tmp11_ = TRUE;
									while (TRUE) {
										guint8 k_val = 0U;
										GridPosition _tmp13_;
										guint8 _tmp14_;
										if (!_tmp11_) {
											gint8 _tmp12_;
											_tmp12_ = k;
											k = _tmp12_ - 1;
										}
										_tmp11_ = FALSE;
										if (!(((gint) k) >= 0)) {
											break;
										}
										_tmp13_ = cur;
										_tmp14_ = (*grid)[(k * (*grid_length2)) + _tmp13_.col];
										k_val = _tmp14_;
										if (((gint) k_val) != 0) {
											if (k_val == val) {
												GridPosition _tmp15_;
												GridPosition _tmp16_ = {0};
												has_match = TRUE;
												_tmp15_ = cur;
												_tmp16_.row = k;
												_tmp16_.col = _tmp15_.col;
												match = _tmp16_;
											}
											break;
										}
									}
								}
							}
							if (has_match) {
								GridPosition _tmp17_;
								gint8 _tmp18_;
								_tmp17_ = free;
								if (_tmp17_.row == rows) {
									free.row = row;
								}
								_grid_move_to_match (to_hide, to_show, &cur, &free, &match, grid, (gint*) (grid_length1), (gint*) (grid_length2), &val, max_changed);
								_tmp18_ = free.row;
								free.row = _tmp18_ - 1;
							} else {
								GridPosition _tmp19_;
								_tmp19_ = free;
								if (_tmp19_.row != rows) {
									gint8 _tmp20_;
									_grid_move_to_end (to_move, &cur, &free, grid, (gint*) (grid_length1), (gint*) (grid_length2), &val);
									_tmp20_ = free.row;
									free.row = _tmp20_ - 1;
								}
							}
						}
					}
				}
			}
		}
	}
}

static void
_grid_move_up (gint8 cols,
               gint8 rows,
               guint8* max_changed,
               guint8** grid,
               gint* grid_length1,
               gint* grid_length2,
               GeeLinkedList** to_move,
               GeeLinkedList** to_hide,
               GeeLinkedList** to_show)
{
	g_return_if_fail (*to_move != NULL);
	g_return_if_fail (*to_hide != NULL);
	g_return_if_fail (*to_show != NULL);
	{
		gint8 i = 0;
		i = (gint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GridPosition free = {0};
				GridPosition _tmp2_ = {0};
				if (!_tmp0_) {
					gint8 _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < cols)) {
					break;
				}
				_tmp2_.row = (gint8) -1;
				_tmp2_.col = i;
				free = _tmp2_;
				{
					gint8 j = 0;
					j = (gint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint8 row = 0;
							GridPosition cur = {0};
							GridPosition _tmp5_ = {0};
							guint8 val = 0U;
							GridPosition _tmp6_;
							GridPosition _tmp7_;
							guint8 _tmp8_;
							GridPosition match = {0};
							GridPosition _tmp10_ = {0};
							gboolean has_match = FALSE;
							if (!_tmp3_) {
								gint8 _tmp4_;
								_tmp4_ = j;
								j = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(j < rows)) {
								break;
							}
							row = j;
							_tmp5_.row = row;
							_tmp5_.col = i;
							cur = _tmp5_;
							_tmp6_ = cur;
							_tmp7_ = cur;
							_tmp8_ = (*grid)[(_tmp6_.row * (*grid_length2)) + _tmp7_.col];
							val = _tmp8_;
							if (((gint) val) == 0) {
								GridPosition _tmp9_;
								_tmp9_ = free;
								if (((gint) _tmp9_.row) == -1) {
									free.row = row;
								}
								continue;
							}
							_tmp10_.row = (gint8) 0;
							_tmp10_.col = (gint8) 0;
							match = _tmp10_;
							has_match = FALSE;
							{
								gint8 k = 0;
								k = (gint8) (row + 1);
								{
									gboolean _tmp11_ = FALSE;
									_tmp11_ = TRUE;
									while (TRUE) {
										guint8 k_val = 0U;
										GridPosition _tmp13_;
										guint8 _tmp14_;
										if (!_tmp11_) {
											gint8 _tmp12_;
											_tmp12_ = k;
											k = _tmp12_ + 1;
										}
										_tmp11_ = FALSE;
										if (!(k < rows)) {
											break;
										}
										_tmp13_ = cur;
										_tmp14_ = (*grid)[(k * (*grid_length2)) + _tmp13_.col];
										k_val = _tmp14_;
										if (((gint) k_val) != 0) {
											if (k_val == val) {
												GridPosition _tmp15_;
												GridPosition _tmp16_ = {0};
												has_match = TRUE;
												_tmp15_ = cur;
												_tmp16_.row = k;
												_tmp16_.col = _tmp15_.col;
												match = _tmp16_;
											}
											break;
										}
									}
								}
							}
							if (has_match) {
								GridPosition _tmp17_;
								gint8 _tmp18_;
								_tmp17_ = free;
								if (((gint) _tmp17_.row) == -1) {
									free.row = row;
								}
								_grid_move_to_match (to_hide, to_show, &cur, &free, &match, grid, (gint*) (grid_length1), (gint*) (grid_length2), &val, max_changed);
								_tmp18_ = free.row;
								free.row = _tmp18_ + 1;
							} else {
								GridPosition _tmp19_;
								_tmp19_ = free;
								if (((gint) _tmp19_.row) != -1) {
									gint8 _tmp20_;
									_grid_move_to_end (to_move, &cur, &free, grid, (gint*) (grid_length1), (gint*) (grid_length2), &val);
									_tmp20_ = free.row;
									free.row = _tmp20_ + 1;
								}
							}
						}
					}
				}
			}
		}
	}
}

static void
_grid_move_left (gint8 cols,
                 gint8 rows,
                 guint8* max_changed,
                 guint8** grid,
                 gint* grid_length1,
                 gint* grid_length2,
                 GeeLinkedList** to_move,
                 GeeLinkedList** to_hide,
                 GeeLinkedList** to_show)
{
	g_return_if_fail (*to_move != NULL);
	g_return_if_fail (*to_hide != NULL);
	g_return_if_fail (*to_show != NULL);
	{
		gint8 i = 0;
		i = (gint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GridPosition free = {0};
				GridPosition _tmp2_ = {0};
				if (!_tmp0_) {
					gint8 _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				_tmp2_.row = i;
				_tmp2_.col = (gint8) -1;
				free = _tmp2_;
				{
					gint8 j = 0;
					j = (gint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint8 col = 0;
							GridPosition cur = {0};
							GridPosition _tmp5_ = {0};
							guint8 val = 0U;
							GridPosition _tmp6_;
							GridPosition _tmp7_;
							guint8 _tmp8_;
							GridPosition match = {0};
							GridPosition _tmp10_ = {0};
							gboolean has_match = FALSE;
							if (!_tmp3_) {
								gint8 _tmp4_;
								_tmp4_ = j;
								j = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							col = j;
							_tmp5_.row = i;
							_tmp5_.col = col;
							cur = _tmp5_;
							_tmp6_ = cur;
							_tmp7_ = cur;
							_tmp8_ = (*grid)[(_tmp6_.row * (*grid_length2)) + _tmp7_.col];
							val = _tmp8_;
							if (((gint) val) == 0) {
								GridPosition _tmp9_;
								_tmp9_ = free;
								if (((gint) _tmp9_.col) == -1) {
									free.col = col;
								}
								continue;
							}
							_tmp10_.row = (gint8) 0;
							_tmp10_.col = (gint8) 0;
							match = _tmp10_;
							has_match = FALSE;
							{
								gint8 k = 0;
								k = (gint8) (col + 1);
								{
									gboolean _tmp11_ = FALSE;
									_tmp11_ = TRUE;
									while (TRUE) {
										guint8 k_val = 0U;
										GridPosition _tmp13_;
										guint8 _tmp14_;
										if (!_tmp11_) {
											gint8 _tmp12_;
											_tmp12_ = k;
											k = _tmp12_ + 1;
										}
										_tmp11_ = FALSE;
										if (!(k < cols)) {
											break;
										}
										_tmp13_ = cur;
										_tmp14_ = (*grid)[(_tmp13_.row * (*grid_length2)) + k];
										k_val = _tmp14_;
										if (((gint) k_val) != 0) {
											if (k_val == val) {
												GridPosition _tmp15_;
												GridPosition _tmp16_ = {0};
												has_match = TRUE;
												_tmp15_ = cur;
												_tmp16_.row = _tmp15_.row;
												_tmp16_.col = k;
												match = _tmp16_;
											}
											break;
										}
									}
								}
							}
							if (has_match) {
								GridPosition _tmp17_;
								gint8 _tmp18_;
								_tmp17_ = free;
								if (((gint) _tmp17_.col) == -1) {
									free.col = col;
								}
								_grid_move_to_match (to_hide, to_show, &cur, &free, &match, grid, (gint*) (grid_length1), (gint*) (grid_length2), &val, max_changed);
								_tmp18_ = free.col;
								free.col = _tmp18_ + 1;
							} else {
								GridPosition _tmp19_;
								_tmp19_ = free;
								if (((gint) _tmp19_.col) != -1) {
									gint8 _tmp20_;
									_grid_move_to_end (to_move, &cur, &free, grid, (gint*) (grid_length1), (gint*) (grid_length2), &val);
									_tmp20_ = free.col;
									free.col = _tmp20_ + 1;
								}
							}
						}
					}
				}
			}
		}
	}
}

static void
_grid_move_right (gint8 cols,
                  gint8 rows,
                  guint8* max_changed,
                  guint8** grid,
                  gint* grid_length1,
                  gint* grid_length2,
                  GeeLinkedList** to_move,
                  GeeLinkedList** to_hide,
                  GeeLinkedList** to_show)
{
	g_return_if_fail (*to_move != NULL);
	g_return_if_fail (*to_hide != NULL);
	g_return_if_fail (*to_show != NULL);
	{
		gint8 i = 0;
		i = (gint8) 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GridPosition free = {0};
				GridPosition _tmp2_ = {0};
				if (!_tmp0_) {
					gint8 _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				_tmp2_.row = i;
				_tmp2_.col = cols;
				free = _tmp2_;
				{
					gint8 j = 0;
					j = (gint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							gint8 col = 0;
							GridPosition cur = {0};
							GridPosition _tmp5_ = {0};
							guint8 val = 0U;
							GridPosition _tmp6_;
							GridPosition _tmp7_;
							guint8 _tmp8_;
							GridPosition match = {0};
							GridPosition _tmp10_ = {0};
							gboolean has_match = FALSE;
							if (!_tmp3_) {
								gint8 _tmp4_;
								_tmp4_ = j;
								j = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							col = (gint8) ((cols - j) - 1);
							_tmp5_.row = i;
							_tmp5_.col = col;
							cur = _tmp5_;
							_tmp6_ = cur;
							_tmp7_ = cur;
							_tmp8_ = (*grid)[(_tmp6_.row * (*grid_length2)) + _tmp7_.col];
							val = _tmp8_;
							if (((gint) val) == 0) {
								GridPosition _tmp9_;
								_tmp9_ = free;
								if (_tmp9_.col == cols) {
									free.col = col;
								}
								continue;
							}
							_tmp10_.row = (gint8) 0;
							_tmp10_.col = (gint8) 0;
							match = _tmp10_;
							has_match = FALSE;
							{
								gint8 k = 0;
								k = (gint8) (col - 1);
								{
									gboolean _tmp11_ = FALSE;
									_tmp11_ = TRUE;
									while (TRUE) {
										guint8 k_val = 0U;
										GridPosition _tmp13_;
										guint8 _tmp14_;
										if (!_tmp11_) {
											gint8 _tmp12_;
											_tmp12_ = k;
											k = _tmp12_ - 1;
										}
										_tmp11_ = FALSE;
										if (!(((gint) k) >= 0)) {
											break;
										}
										_tmp13_ = cur;
										_tmp14_ = (*grid)[(_tmp13_.row * (*grid_length2)) + k];
										k_val = _tmp14_;
										if (((gint) k_val) != 0) {
											if (k_val == val) {
												GridPosition _tmp15_;
												GridPosition _tmp16_ = {0};
												has_match = TRUE;
												_tmp15_ = cur;
												_tmp16_.row = _tmp15_.row;
												_tmp16_.col = k;
												match = _tmp16_;
											}
											break;
										}
									}
								}
							}
							if (has_match) {
								GridPosition _tmp17_;
								gint8 _tmp18_;
								_tmp17_ = free;
								if (_tmp17_.col == cols) {
									free.col = col;
								}
								_grid_move_to_match (to_hide, to_show, &cur, &free, &match, grid, (gint*) (grid_length1), (gint*) (grid_length2), &val, max_changed);
								_tmp18_ = free.col;
								free.col = _tmp18_ - 1;
							} else {
								GridPosition _tmp19_;
								_tmp19_ = free;
								if (_tmp19_.col != cols) {
									gint8 _tmp20_;
									_grid_move_to_end (to_move, &cur, &free, grid, (gint*) (grid_length1), (gint*) (grid_length2), &val);
									_tmp20_ = free.col;
									free.col = _tmp20_ - 1;
								}
							}
						}
					}
				}
			}
		}
	}
}

static void
_grid_move_to_match (GeeLinkedList** to_hide,
                     GeeLinkedList** to_show,
                     GridPosition* cur,
                     GridPosition* free,
                     GridPosition* match,
                     guint8** grid,
                     gint* grid_length1,
                     gint* grid_length2,
                     guint8* val,
                     guint8* max_changed)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	TileMovement mov = {0};
	GridPosition _tmp4_;
	GridPosition _tmp5_;
	TileMovement _tmp6_ = {0};
	TileMovement _tmp7_;
	GridPosition _tmp8_;
	GridPosition _tmp9_;
	TileMovement _tmp10_ = {0};
	TileMovement _tmp11_;
	guint8 _tmp12_;
	Tile tile = {0};
	GridPosition _tmp13_;
	Tile _tmp14_ = {0};
	Tile _tmp15_;
	GridPosition _tmp16_;
	GridPosition _tmp17_;
	GridPosition _tmp18_;
	GridPosition _tmp19_;
	GridPosition _tmp20_;
	GridPosition _tmp21_;
	g_return_if_fail (*to_hide != NULL);
	g_return_if_fail (*to_show != NULL);
	g_return_if_fail (cur != NULL);
	g_return_if_fail (free != NULL);
	g_return_if_fail (match != NULL);
	_tmp0_ = grid_position_to_string (match);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strconcat ("matching tile found at ", _tmp1_, NULL);
	_tmp3_ = _tmp2_;
	g_debug ("grid.vala:354: %s", _tmp3_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp4_ = *cur;
	_tmp5_ = *free;
	_tmp6_.from = _tmp4_;
	_tmp6_.to = _tmp5_;
	mov = _tmp6_;
	_tmp7_ = mov;
	gee_abstract_collection_add ((GeeAbstractCollection*) (*to_hide), &_tmp7_);
	_tmp8_ = *match;
	_tmp9_ = *free;
	_tmp10_.from = _tmp8_;
	_tmp10_.to = _tmp9_;
	mov = _tmp10_;
	_tmp11_ = mov;
	gee_abstract_collection_add ((GeeAbstractCollection*) (*to_hide), &_tmp11_);
	_tmp12_ = *val;
	*val = _tmp12_ + 1;
	_tmp13_ = *free;
	_tmp14_.pos = _tmp13_;
	_tmp14_.val = *val;
	tile = _tmp14_;
	_tmp15_ = tile;
	gee_abstract_collection_add ((GeeAbstractCollection*) (*to_show), &_tmp15_);
	_tmp16_ = *cur;
	_tmp17_ = *cur;
	(*grid)[(_tmp16_.row * (*grid_length2)) + _tmp17_.col] = (guint8) 0;
	_tmp18_ = *match;
	_tmp19_ = *match;
	(*grid)[(_tmp18_.row * (*grid_length2)) + _tmp19_.col] = (guint8) 0;
	_tmp20_ = *free;
	_tmp21_ = *free;
	(*grid)[(_tmp20_.row * (*grid_length2)) + _tmp21_.col] = *val;
	if ((*max_changed) < (*val)) {
		*max_changed = *val;
	}
}

static void
_grid_move_to_end (GeeLinkedList** to_move,
                   GridPosition* cur,
                   GridPosition* free,
                   guint8** grid,
                   gint* grid_length1,
                   gint* grid_length2,
                   guint8* val)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	TileMovement mov = {0};
	GridPosition _tmp6_;
	GridPosition _tmp7_;
	TileMovement _tmp8_ = {0};
	TileMovement _tmp9_;
	GridPosition _tmp10_;
	GridPosition _tmp11_;
	GridPosition _tmp12_;
	GridPosition _tmp13_;
	g_return_if_fail (*to_move != NULL);
	g_return_if_fail (cur != NULL);
	g_return_if_fail (free != NULL);
	_tmp0_ = grid_position_to_string (cur);
	_tmp1_ = _tmp0_;
	_tmp2_ = grid_position_to_string (free);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("moving ", _tmp1_, " to ", _tmp3_, NULL);
	_tmp5_ = _tmp4_;
	g_debug ("grid.vala:378: %s", _tmp5_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	_tmp6_ = *cur;
	_tmp7_ = *free;
	_tmp8_.from = _tmp6_;
	_tmp8_.to = _tmp7_;
	mov = _tmp8_;
	_tmp9_ = mov;
	gee_abstract_collection_add ((GeeAbstractCollection*) (*to_move), &_tmp9_);
	_tmp10_ = *cur;
	_tmp11_ = *cur;
	(*grid)[(_tmp10_.row * (*grid_length2)) + _tmp11_.col] = (guint8) 0;
	_tmp12_ = *free;
	_tmp13_ = *free;
	(*grid)[(_tmp12_.row * (*grid_length2)) + _tmp13_.col] = *val;
}

gboolean
grid_is_finished (Grid* self)
{
	gboolean _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = _grid_grid_is_full (&self->_grid, (gint*) (&self->_grid_length1), (gint*) (&self->_grid_length2));
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				if (!_tmp1_) {
					guint8 _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < self->priv->_rows)) {
					break;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp3_ = FALSE;
						_tmp3_ = TRUE;
						while (TRUE) {
							guint8 val = 0U;
							guint8* _tmp5_;
							gint _tmp5__length1;
							gint _tmp5__length2;
							guint8 _tmp6_;
							gboolean _tmp7_ = FALSE;
							gboolean _tmp10_ = FALSE;
							if (!_tmp3_) {
								guint8 _tmp4_;
								_tmp4_ = j;
								j = _tmp4_ + 1;
							}
							_tmp3_ = FALSE;
							if (!(j < self->priv->_cols)) {
								break;
							}
							_tmp5_ = self->_grid;
							_tmp5__length1 = self->_grid_length1;
							_tmp5__length2 = self->_grid_length2;
							_tmp6_ = _tmp5_[(i * _tmp5__length2) + j];
							val = _tmp6_;
							if (((gint) i) < (self->priv->_rows - 1)) {
								guint8* _tmp8_;
								gint _tmp8__length1;
								gint _tmp8__length2;
								guint8 _tmp9_;
								_tmp8_ = self->_grid;
								_tmp8__length1 = self->_grid_length1;
								_tmp8__length2 = self->_grid_length2;
								_tmp9_ = _tmp8_[((i + 1) * _tmp8__length2) + j];
								_tmp7_ = val == _tmp9_;
							} else {
								_tmp7_ = FALSE;
							}
							if (_tmp7_) {
								result = FALSE;
								return result;
							}
							if (((gint) j) < (self->priv->_cols - 1)) {
								guint8* _tmp11_;
								gint _tmp11__length1;
								gint _tmp11__length2;
								guint8 _tmp12_;
								_tmp11_ = self->_grid;
								_tmp11__length1 = self->_grid_length1;
								_tmp11__length2 = self->_grid_length2;
								_tmp12_ = _tmp11_[(i * _tmp11__length2) + (j + 1)];
								_tmp10_ = val == _tmp12_;
							} else {
								_tmp10_ = FALSE;
							}
							if (_tmp10_) {
								result = FALSE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}

gboolean
_grid_grid_is_full (guint8** grid,
                    gint* grid_length1,
                    gint* grid_length2)
{
	guint rows = 0U;
	gint _tmp0_;
	guint cols = 0U;
	gint _tmp1_;
	gboolean result;
	_tmp0_ = *grid_length1;
	rows = (guint) _tmp0_;
	_tmp1_ = *grid_length2;
	cols = (guint) _tmp1_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							guint8 _tmp6_;
							if (!_tmp4_) {
								guint _tmp5_;
								_tmp5_ = j;
								j = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							_tmp6_ = (*grid)[(i * (*grid_length2)) + j];
							if (((gint) _tmp6_) == 0) {
								result = FALSE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = TRUE;
	return result;
}

void
grid_clear (Grid* self)
{
	g_return_if_fail (self != NULL);
	_grid_clear (&self->_grid, (gint*) (&self->_grid_length1), (gint*) (&self->_grid_length2));
}

static void
_grid_clear (guint8** grid,
             gint* grid_length1,
             gint* grid_length2)
{
	guint rows = 0U;
	gint _tmp0_;
	guint cols = 0U;
	gint _tmp1_;
	_tmp0_ = *grid_length1;
	rows = (guint) _tmp0_;
	_tmp1_ = *grid_length2;
	cols = (guint) _tmp1_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							if (!_tmp4_) {
								guint _tmp5_;
								_tmp5_ = j;
								j = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							(*grid)[(i * (*grid_length2)) + j] = (guint8) 0;
						}
					}
				}
			}
		}
	}
}

glong
grid_get_score (Grid* self)
{
	glong _tmp0_;
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	_tmp0_ = _grid_get_score (&self->_grid, (gint*) (&self->_grid_length1), (gint*) (&self->_grid_length2));
	result = _tmp0_;
	return result;
}

static glong
_grid_get_score (guint8** grid,
                 gint* grid_length1,
                 gint* grid_length2)
{
	glong score = 0L;
	guint rows = 0U;
	gint _tmp0_;
	guint cols = 0U;
	gint _tmp1_;
	glong result;
	score = (glong) 0;
	_tmp0_ = *grid_length1;
	rows = (guint) _tmp0_;
	_tmp1_ = *grid_length2;
	cols = (guint) _tmp1_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							guint8 _tmp6_;
							if (!_tmp4_) {
								guint _tmp5_;
								_tmp5_ = j;
								j = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							_tmp6_ = (*grid)[(i * (*grid_length2)) + j];
							score += _grid_calculate_score_value (_tmp6_);
						}
					}
				}
			}
		}
	}
	result = score;
	return result;
}

static inline glong
_grid_calculate_score_value (guint8 tile_value)
{
	glong result;
	if (((gint) tile_value) < 2) {
		result = (glong) 0;
		return result;
	}
	result = (glong) (pow ((gdouble) 2, (gdouble) tile_value) * (tile_value - 1));
	return result;
}

static guint8*
_vala_array_dup1 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

Grid*
grid_clone (Grid* self)
{
	Grid* grid = NULL;
	Grid* _tmp0_;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	Grid* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = grid_new (self->priv->_rows, self->priv->_cols);
	grid = _tmp0_;
	_tmp1_ = self->_grid;
	_tmp1__length1 = self->_grid_length1;
	_tmp1__length2 = self->_grid_length2;
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _tmp1__length1 * _tmp1__length2) : _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	_tmp2__length2 = _tmp1__length2;
	grid->_grid = (g_free (grid->_grid), NULL);
	grid->_grid = _tmp2_;
	grid->_grid_length1 = _tmp2__length1;
	grid->_grid_length2 = _tmp2__length2;
	grid->priv->_target_value = self->priv->_target_value;
	grid->priv->_target_value_reached = self->priv->_target_value_reached;
	result = grid;
	return result;
}

guint8
grid_get (Grid* self,
          guint8 row,
          guint8 col)
{
	gboolean _tmp0_ = FALSE;
	guint8* _tmp1_;
	gint _tmp1__length1;
	gint _tmp1__length2;
	guint8 _tmp2_;
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	if (row >= self->priv->_rows) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = col >= self->priv->_cols;
	}
	if (_tmp0_) {
		result = (guint8) 0;
		return result;
	}
	_tmp1_ = self->_grid;
	_tmp1__length1 = self->_grid_length1;
	_tmp1__length2 = self->_grid_length2;
	_tmp2_ = _tmp1_[(row * _tmp1__length2) + col];
	result = _tmp2_;
	return result;
}

gboolean
grid_is_disallowed_grid_size (guint8* rows,
                              guint8* cols)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean result;
	_vala_return_val_if_fail (((gint) (*rows)) >= 1, "rows >= 1", FALSE);
	_vala_return_val_if_fail (((gint) (*rows)) <= 9, "rows <= 9", FALSE);
	_vala_return_val_if_fail (((gint) (*cols)) >= 1, "cols >= 1", FALSE);
	_vala_return_val_if_fail (((gint) (*cols)) <= 9, "cols <= 9", FALSE);
	if (((gint) (*rows)) == 1) {
		_tmp2_ = ((gint) (*cols)) == 1;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp3_ = FALSE;
		if (((gint) (*rows)) == 1) {
			_tmp3_ = ((gint) (*cols)) == 2;
		} else {
			_tmp3_ = FALSE;
		}
		_tmp1_ = _tmp3_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gboolean _tmp4_ = FALSE;
		if (((gint) (*rows)) == 2) {
			_tmp4_ = ((gint) (*cols)) == 1;
		} else {
			_tmp4_ = FALSE;
		}
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}

gchar*
grid_save (Grid* self)
{
	gchar* ret_string = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	glong _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup_printf ("%hhu", self->priv->_rows);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%hhu", self->priv->_cols);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp1_, " ", _tmp3_, "\n", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	ret_string = _tmp5_;
	_grid_convert_to_string (&self->_grid, (gint*) (&self->_grid_length1), (gint*) (&self->_grid_length2), &ret_string);
	_tmp6_ = ret_string;
	_tmp7_ = _grid_get_score (&self->_grid, (gint*) (&self->_grid_length1), (gint*) (&self->_grid_length2));
	_tmp8_ = g_strdup_printf ("%li", _tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_strconcat (_tmp6_, _tmp9_, NULL);
	_g_free0 (ret_string);
	ret_string = _tmp10_;
	_g_free0 (_tmp9_);
	_tmp11_ = ret_string;
	_tmp12_ = g_strconcat (_tmp11_, "\n", NULL);
	_g_free0 (ret_string);
	ret_string = _tmp12_;
	result = ret_string;
	return result;
}

gchar*
grid_to_string (Grid* self)
{
	gchar* ret_string = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup ("\n");
	ret_string = _tmp0_;
	_grid_convert_to_string (&self->_grid, (gint*) (&self->_grid_length1), (gint*) (&self->_grid_length2), &ret_string);
	result = ret_string;
	return result;
}

static void
_grid_convert_to_string (guint8** grid,
                         gint* grid_length1,
                         gint* grid_length2,
                         gchar** ret_string)
{
	guint rows = 0U;
	gint _tmp0_;
	guint cols = 0U;
	gint _tmp1_;
	g_return_if_fail (*ret_string != NULL);
	_tmp0_ = *grid_length1;
	rows = (guint) _tmp0_;
	_tmp1_ = *grid_length2;
	cols = (guint) _tmp1_;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				if (!_tmp2_) {
					guint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				{
					guint j = 0U;
					j = (guint) 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							guint64 val = 0ULL;
							guint8 _tmp6_;
							const gchar* _tmp8_ = NULL;
							gchar* _tmp9_;
							gchar* _tmp10_;
							gchar* _tmp11_;
							if (!_tmp4_) {
								guint _tmp5_;
								_tmp5_ = j;
								j = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							_tmp6_ = (*grid)[(i * (*grid_length2)) + j];
							if (((gint) _tmp6_) == 0) {
								val = (guint64) 0;
							} else {
								guint8 _tmp7_;
								_tmp7_ = (*grid)[(i * (*grid_length2)) + j];
								val = (guint64) pow ((gdouble) 2, (gdouble) _tmp7_);
							}
							if (j == (cols - 1)) {
								_tmp8_ = "\n";
							} else {
								_tmp8_ = " ";
							}
							_tmp9_ = g_strdup_printf ("%llu%s", val, _tmp8_);
							_tmp10_ = _tmp9_;
							_tmp11_ = g_strconcat (*ret_string, _tmp10_, NULL);
							_g_free0 (*ret_string);
							*ret_string = _tmp11_;
							_g_free0 (_tmp10_);
						}
					}
				}
			}
		}
	}
}

static guint8*
_vala_array_dup2 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

gboolean
grid_load (Grid* self,
           gchar** content)
{
	guint8* grid = NULL;
	guint8* _tmp0_;
	gint grid_length1;
	gint grid_length2;
	gboolean _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	gint _tmp2__length2;
	gint _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp4__length2;
	gint _tmp5_;
	guint8* _tmp6_;
	gint _tmp6__length1;
	gint _tmp6__length2;
	guint8* _tmp7_;
	gint _tmp7__length1;
	gint _tmp7__length2;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (*content != NULL, FALSE);
	_tmp0_ = g_new0 (guint8, 1 * 0);
	grid = _tmp0_;
	grid_length1 = 1;
	grid_length2 = 0;
	_tmp1_ = _grid_load_from_string (content, &grid, (gint*) (&grid_length1), (gint*) (&grid_length2));
	if (!_tmp1_) {
		result = FALSE;
		grid = (g_free (grid), NULL);
		return result;
	}
	_tmp2_ = grid;
	_tmp2__length1 = grid_length1;
	_tmp2__length2 = grid_length2;
	_tmp3_ = _tmp2__length1;
	self->priv->_rows = (guint8) _tmp3_;
	_tmp4_ = grid;
	_tmp4__length1 = grid_length1;
	_tmp4__length2 = grid_length2;
	_tmp5_ = _tmp4__length2;
	self->priv->_cols = (guint8) _tmp5_;
	_tmp6_ = grid;
	_tmp6__length1 = grid_length1;
	_tmp6__length2 = grid_length2;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup2 (_tmp6_, _tmp6__length1 * _tmp6__length2) : _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	_tmp7__length2 = _tmp6__length2;
	self->_grid = (g_free (self->_grid), NULL);
	self->_grid = _tmp7_;
	self->_grid_length1 = _tmp7__length1;
	self->_grid_length2 = _tmp7__length2;
	result = TRUE;
	grid = (g_free (grid), NULL);
	return result;
}

static gboolean
uint64_try_parse (const gchar* str,
                  guint64* _result_,
                  const gchar** unparsed,
                  guint _base)
{
	guint64 _vala__result_ = 0ULL;
	const gchar* _vala_unparsed = NULL;
	gchar* endptr = NULL;
	gchar* _tmp0_ = NULL;
	guint64 _tmp1_;
	gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	gboolean result;
	g_return_val_if_fail (str != NULL, FALSE);
	errno = 0;
	_tmp1_ = g_ascii_strtoull (str, &_tmp0_, _base);
	endptr = _tmp0_;
	_vala__result_ = _tmp1_;
	_tmp2_ = endptr;
	_tmp3_ = strlen (str);
	_tmp4_ = _tmp3_;
	if (_tmp2_ == (((gchar*) str) + _tmp4_)) {
		gboolean _tmp5_ = FALSE;
		_vala_unparsed = "";
		if (errno != ERANGE) {
			_tmp5_ = errno != EINVAL;
		} else {
			_tmp5_ = FALSE;
		}
		result = _tmp5_;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	} else {
		gchar* _tmp6_;
		_tmp6_ = endptr;
		_vala_unparsed = (const gchar*) _tmp6_;
		result = FALSE;
		if (_result_) {
			*_result_ = _vala__result_;
		}
		if (unparsed) {
			*unparsed = _vala_unparsed;
		}
		return result;
	}
}

static gboolean
_grid_load_from_string (gchar** content,
                        guint8** grid,
                        gint* grid_length1,
                        gint* grid_length2)
{
	gchar** lines = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint lines_length1;
	gint _lines_size_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** tokens = NULL;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp7_;
	gint _tmp7__length1;
	guint64 number_64 = 0ULL;
	gchar** _tmp8_;
	gint _tmp8__length1;
	const gchar* _tmp9_;
	guint64 _tmp10_ = 0ULL;
	gboolean _tmp11_;
	gboolean _tmp12_ = FALSE;
	guint8 rows = 0U;
	gchar** _tmp13_;
	gint _tmp13__length1;
	const gchar* _tmp14_;
	guint64 _tmp15_ = 0ULL;
	gboolean _tmp16_;
	gboolean _tmp17_ = FALSE;
	guint8 cols = 0U;
	gboolean _tmp18_;
	gchar** _tmp19_;
	gint _tmp19__length1;
	guint8* _tmp20_;
	gboolean result;
	g_return_val_if_fail (*content != NULL, FALSE);
	_tmp1_ = _tmp0_ = g_strsplit (*content, "\n", 0);
	lines = _tmp1_;
	lines_length1 = _vala_array_length (_tmp0_);
	_lines_size_ = lines_length1;
	_tmp2_ = lines;
	_tmp2__length1 = lines_length1;
	if (_tmp2__length1 < 4) {
		result = FALSE;
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp3_ = lines;
	_tmp3__length1 = lines_length1;
	_tmp4_ = _tmp3_[0];
	_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, " ", 0);
	tokens = _tmp6_;
	tokens_length1 = _vala_array_length (_tmp5_);
	_tokens_size_ = tokens_length1;
	_tmp7_ = tokens;
	_tmp7__length1 = tokens_length1;
	if (_tmp7__length1 != 2) {
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp8_ = tokens;
	_tmp8__length1 = tokens_length1;
	_tmp9_ = _tmp8_[0];
	_tmp11_ = uint64_try_parse (_tmp9_, &_tmp10_, NULL, (guint) 0);
	number_64 = _tmp10_;
	if (!_tmp11_) {
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	if (number_64 == ((guint64) 0)) {
		_tmp12_ = TRUE;
	} else {
		_tmp12_ = number_64 > ((guint64) 9);
	}
	if (_tmp12_) {
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	rows = (guint8) number_64;
	_tmp13_ = tokens;
	_tmp13__length1 = tokens_length1;
	_tmp14_ = _tmp13_[1];
	_tmp16_ = uint64_try_parse (_tmp14_, &_tmp15_, NULL, (guint) 0);
	number_64 = _tmp15_;
	if (!_tmp16_) {
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	if (number_64 == ((guint64) 0)) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = number_64 > ((guint64) 9);
	}
	if (_tmp17_) {
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	cols = (guint8) number_64;
	_tmp18_ = grid_is_disallowed_grid_size (&rows, &cols);
	if (_tmp18_) {
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp19_ = lines;
	_tmp19__length1 = lines_length1;
	if (_tmp19__length1 < (rows + 2)) {
		result = FALSE;
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	_tmp20_ = g_new0 (guint8, rows * cols);
	*grid = (g_free (*grid), NULL);
	*grid = _tmp20_;
	*grid_length1 = rows;
	*grid_length2 = cols;
	{
		guint8 i = 0U;
		i = (guint8) 0;
		{
			gboolean _tmp21_ = FALSE;
			_tmp21_ = TRUE;
			while (TRUE) {
				gchar** _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				gchar** _tmp25_ = NULL;
				gint _tmp26_ = 0;
				gchar** _tmp27_;
				gint _tmp27__length1;
				if (!_tmp21_) {
					guint8 _tmp22_;
					_tmp22_ = i;
					i = _tmp22_ + 1;
				}
				_tmp21_ = FALSE;
				if (!(i < rows)) {
					break;
				}
				_tmp23_ = lines;
				_tmp23__length1 = lines_length1;
				_tmp24_ = _tmp23_[i + 1];
				_grid_parse_line (_tmp24_, &_tmp25_, &_tmp26_);
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				tokens = _tmp25_;
				tokens_length1 = _tmp26_;
				_tokens_size_ = tokens_length1;
				_tmp27_ = tokens;
				_tmp27__length1 = tokens_length1;
				if (_tmp27__length1 != ((gint) cols)) {
					result = FALSE;
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				{
					guint8 j = 0U;
					j = (guint8) 0;
					{
						gboolean _tmp28_ = FALSE;
						_tmp28_ = TRUE;
						while (TRUE) {
							gchar** _tmp30_;
							gint _tmp30__length1;
							const gchar* _tmp31_;
							guint64 _tmp32_ = 0ULL;
							gboolean _tmp33_;
							guint8 number = 0U;
							guint8 _tmp34_ = 0U;
							gboolean _tmp35_;
							if (!_tmp28_) {
								guint8 _tmp29_;
								_tmp29_ = j;
								j = _tmp29_ + 1;
							}
							_tmp28_ = FALSE;
							if (!(j < cols)) {
								break;
							}
							_tmp30_ = tokens;
							_tmp30__length1 = tokens_length1;
							_tmp31_ = _tmp30_[j];
							_tmp33_ = uint64_try_parse (_tmp31_, &_tmp32_, NULL, (guint) 0);
							number_64 = _tmp32_;
							if (!_tmp33_) {
								result = FALSE;
								tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
								lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
								return result;
							}
							_tmp35_ = _grid_convert_tile_number (&number_64, &_tmp34_);
							number = _tmp34_;
							if (!_tmp35_) {
								result = FALSE;
								tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
								lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
								return result;
							}
							(*grid)[(i * (*grid_length2)) + j] = number;
						}
					}
				}
			}
		}
	}
	result = TRUE;
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static gchar**
_vala_array_dup3 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static inline void
_grid_parse_line (const gchar* line,
                  gchar*** tokens,
                  gint* tokens_length1)
{
	gchar** _vala_tokens = NULL;
	gint _vala_tokens_length1 = 0;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tokens = NULL;
	gchar** _tmp2_;
	gint _tokens_length1;
	gint __tokens_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gchar** _tmp8_;
	gint _tmp8__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	g_return_if_fail (line != NULL);
	_tmp1_ = _tmp0_ = g_strsplit (line, " ", 0);
	_vala_tokens = (_vala_array_free (_vala_tokens, _vala_tokens_length1, (GDestroyNotify) g_free), NULL);
	_vala_tokens = _tmp1_;
	_vala_tokens_length1 = _vala_array_length (_tmp0_);
	_tmp2_ = g_new0 (gchar*, 0 + 1);
	_tokens = _tmp2_;
	_tokens_length1 = 0;
	__tokens_size_ = _tokens_length1;
	_tmp3_ = _vala_tokens;
	_tmp3__length1 = _vala_tokens_length1;
	{
		gchar** token_collection = NULL;
		gint token_collection_length1 = 0;
		gint _token_collection_size_ = 0;
		gint token_it = 0;
		token_collection = _tmp3_;
		token_collection_length1 = _tmp3__length1;
		for (token_it = 0; token_it < token_collection_length1; token_it = token_it + 1) {
			gchar* _tmp4_;
			gchar* token = NULL;
			_tmp4_ = g_strdup (token_collection[token_it]);
			token = _tmp4_;
			{
				const gchar* _tmp5_;
				_tmp5_ = token;
				if (g_strcmp0 (_tmp5_, "") != 0) {
					const gchar* _tmp6_;
					gchar* _tmp7_;
					_tmp6_ = token;
					_tmp7_ = g_strdup (_tmp6_);
					_vala_array_add1 (&_tokens, &_tokens_length1, &__tokens_size_, _tmp7_);
				}
				_g_free0 (token);
			}
		}
	}
	_tmp8_ = _tokens;
	_tmp8__length1 = _tokens_length1;
	_tmp9_ = (_tmp8_ != NULL) ? _vala_array_dup3 (_tmp8_, _tmp8__length1) : _tmp8_;
	_tmp9__length1 = _tmp8__length1;
	_vala_tokens = (_vala_array_free (_vala_tokens, _vala_tokens_length1, (GDestroyNotify) g_free), NULL);
	_vala_tokens = _tmp9_;
	_vala_tokens_length1 = _tmp9__length1;
	_tokens = (_vala_array_free (_tokens, _tokens_length1, (GDestroyNotify) g_free), NULL);
	if (tokens) {
		*tokens = _vala_tokens;
	} else {
		_vala_tokens = (_vala_array_free (_vala_tokens, _vala_tokens_length1, (GDestroyNotify) g_free), NULL);
	}
	if (tokens_length1) {
		*tokens_length1 = _vala_tokens_length1;
	}
}

static inline gboolean
_grid_convert_tile_number (guint64* number_64,
                           guint8* number)
{
	guint8 _vala_number = 0U;
	gboolean result;
	if ((*number_64) == ((guint64) 0)) {
		_vala_number = (guint8) 0;
		result = TRUE;
		if (number) {
			*number = _vala_number;
		}
		return result;
	}
	{
		gboolean _tmp0_ = FALSE;
		_vala_number = (guint8) 1;
		_tmp0_ = TRUE;
		while (TRUE) {
			if (!_tmp0_) {
				guint8 _tmp1_;
				_tmp1_ = _vala_number;
				_vala_number = _tmp1_ + 1;
			}
			_tmp0_ = FALSE;
			if (!(((gint) _vala_number) <= 81)) {
				break;
			}
			if ((*number_64) == ((guint64) pow ((gdouble) 2, (gdouble) _vala_number))) {
				result = TRUE;
				if (number) {
					*number = _vala_number;
				}
				return result;
			}
		}
	}
	result = FALSE;
	if (number) {
		*number = _vala_number;
	}
	return result;
}

void
grid_save_game (Grid* self,
                const gchar* path)
{
	gchar* contents = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (path != NULL);
	_tmp0_ = grid_save (self);
	contents = _tmp0_;
	{
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = g_path_get_dirname (path);
		_tmp2_ = _tmp1_;
		g_mkdir_with_parents (_tmp2_, 0775);
		_g_free0 (_tmp2_);
		g_file_set_contents (path, contents, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (contents);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
		g_debug ("grid.vala:640: game saved successfully");
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("grid.vala:643: Failed to save game: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (contents);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (contents);
}

gboolean
grid_restore_game (Grid* self,
                   const gchar* path)
{
	gchar* content = NULL;
	gboolean _tmp3_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (path != NULL, FALSE);
	{
		gchar* _tmp0_ = NULL;
		g_file_get_contents (path, &_tmp0_, NULL, &_inner_error0_);
		_g_free0 (content);
		content = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp1_ = FALSE;
			if (_inner_error0_->domain == G_FILE_ERROR) {
				goto __catch0_g_file_error;
			}
			_g_free0 (content);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp1_;
		}
	}
	goto __finally0;
	__catch0_g_file_error:
	{
		g_clear_error (&_inner_error0_);
		result = FALSE;
		_g_free0 (content);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp2_ = FALSE;
		_g_free0 (content);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp2_;
	}
	_tmp3_ = grid_load (self, &content);
	if (_tmp3_) {
		result = TRUE;
		_g_free0 (content);
		return result;
	}
	g_warning ("grid.vala:657: Failed to restore game from saved file");
	result = FALSE;
	_g_free0 (content);
	return result;
}

guint8
grid_get_rows (Grid* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_rows;
	return result;
}

static void
grid_set_rows (Grid* self,
               guint8 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_rows = value;
}

guint8
grid_get_cols (Grid* self)
{
	guint8 result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_cols;
	return result;
}

static void
grid_set_cols (Grid* self,
               guint8 value)
{
	g_return_if_fail (self != NULL);
	self->priv->_cols = value;
}

guint
grid_get_target_value (Grid* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_target_value;
	return result;
}

void
grid_set_target_value (Grid* self,
                       guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_target_value = value;
}

guint
grid_get_target_value_simple (Grid* self)
{
	guint result;
	g_return_val_if_fail (self != NULL, 0U);
	result = self->priv->_target_value_simple;
	return result;
}

static void
grid_set_target_value_simple (Grid* self,
                              guint value)
{
	g_return_if_fail (self != NULL);
	self->priv->_target_value_simple = value;
}

gboolean
grid_get_target_value_reached (Grid* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_target_value_reached;
	return result;
}

void
grid_set_target_value_reached (Grid* self,
                               gboolean value)
{
	g_return_if_fail (self != NULL);
	self->priv->_target_value_reached = value;
}

static GObject *
grid_constructor (GType type,
                  guint n_construct_properties,
                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	Grid * self;
	gboolean _tmp0_ = FALSE;
	guint8 _tmp1_;
	guint8 _tmp3_;
	guint8 _tmp4_;
	guint8* _tmp5_;
	parent_class = G_OBJECT_CLASS (grid_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GRID, Grid);
	_tmp1_ = self->priv->_rows;
	if (((gint) _tmp1_) < 1) {
		_tmp0_ = TRUE;
	} else {
		guint8 _tmp2_;
		_tmp2_ = self->priv->_cols;
		_tmp0_ = ((gint) _tmp2_) < 1;
	}
	if (_tmp0_) {
		g_assert_not_reached ();
	}
	_tmp3_ = self->priv->_rows;
	_tmp4_ = self->priv->_cols;
	_tmp5_ = g_new0 (guint8, _tmp3_ * _tmp4_);
	self->_grid = (g_free (self->_grid), NULL);
	self->_grid = _tmp5_;
	self->_grid_length1 = _tmp3_;
	self->_grid_length2 = _tmp4_;
	_grid_clear (&self->_grid, (gint*) (&self->_grid_length1), (gint*) (&self->_grid_length2));
	return obj;
}

static void
grid_class_init (GridClass * klass,
                 gpointer klass_data)
{
	grid_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &Grid_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_grid_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_grid_set_property;
	G_OBJECT_CLASS (klass)->constructor = grid_constructor;
	G_OBJECT_CLASS (klass)->finalize = grid_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_ROWS_PROPERTY, grid_properties[GRID_ROWS_PROPERTY] = g_param_spec_uchar ("rows", "rows", "rows", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_COLS_PROPERTY, grid_properties[GRID_COLS_PROPERTY] = g_param_spec_uchar ("cols", "cols", "cols", 0, G_MAXUINT8, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_TARGET_VALUE_PROPERTY, grid_properties[GRID_TARGET_VALUE_PROPERTY] = g_param_spec_uint ("target-value", "target-value", "target-value", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_TARGET_VALUE_SIMPLE_PROPERTY, grid_properties[GRID_TARGET_VALUE_SIMPLE_PROPERTY] = g_param_spec_uint ("target-value-simple", "target-value-simple", "target-value-simple", 0, G_MAXUINT, (guint) 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_EXPLICIT_NOTIFY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRID_TARGET_VALUE_REACHED_PROPERTY, grid_properties[GRID_TARGET_VALUE_REACHED_PROPERTY] = g_param_spec_boolean ("target-value-reached", "target-value-reached", "target-value-reached", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_EXPLICIT_NOTIFY));
}

static void
grid_instance_init (Grid * self,
                    gpointer klass)
{
	self->priv = grid_get_instance_private (self);
	self->priv->_target_value = (guint) 0;
	self->priv->_target_value_simple = (guint) 0;
	self->priv->_target_value_reached = FALSE;
}

static void
grid_finalize (GObject * obj)
{
	Grid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_GRID, Grid);
	self->_grid = (g_free (self->_grid), NULL);
	G_OBJECT_CLASS (grid_parent_class)->finalize (obj);
}

static GType
grid_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GridClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) grid_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Grid), 0, (GInstanceInitFunc) grid_instance_init, NULL };
	GType grid_type_id;
	grid_type_id = g_type_register_static (G_TYPE_OBJECT, "Grid", &g_define_type_info, 0);
	Grid_private_offset = g_type_add_instance_private (grid_type_id, sizeof (GridPrivate));
	return grid_type_id;
}

GType
grid_get_type (void)
{
	static volatile gsize grid_type_id__once = 0;
	if (g_once_init_enter (&grid_type_id__once)) {
		GType grid_type_id;
		grid_type_id = grid_get_type_once ();
		g_once_init_leave (&grid_type_id__once, grid_type_id);
	}
	return grid_type_id__once;
}

static void
_vala_grid_get_property (GObject * object,
                         guint property_id,
                         GValue * value,
                         GParamSpec * pspec)
{
	Grid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GRID, Grid);
	switch (property_id) {
		case GRID_ROWS_PROPERTY:
		g_value_set_uchar (value, grid_get_rows (self));
		break;
		case GRID_COLS_PROPERTY:
		g_value_set_uchar (value, grid_get_cols (self));
		break;
		case GRID_TARGET_VALUE_PROPERTY:
		g_value_set_uint (value, grid_get_target_value (self));
		break;
		case GRID_TARGET_VALUE_SIMPLE_PROPERTY:
		g_value_set_uint (value, grid_get_target_value_simple (self));
		break;
		case GRID_TARGET_VALUE_REACHED_PROPERTY:
		g_value_set_boolean (value, grid_get_target_value_reached (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_grid_set_property (GObject * object,
                         guint property_id,
                         const GValue * value,
                         GParamSpec * pspec)
{
	Grid * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_GRID, Grid);
	switch (property_id) {
		case GRID_ROWS_PROPERTY:
		grid_set_rows (self, g_value_get_uchar (value));
		break;
		case GRID_COLS_PROPERTY:
		grid_set_cols (self, g_value_get_uchar (value));
		break;
		case GRID_TARGET_VALUE_PROPERTY:
		grid_set_target_value (self, g_value_get_uint (value));
		break;
		case GRID_TARGET_VALUE_SIMPLE_PROPERTY:
		grid_set_target_value_simple (self, g_value_get_uint (value));
		break;
		case GRID_TARGET_VALUE_REACHED_PROPERTY:
		grid_set_target_value_reached (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

gchar*
grid_position_to_string (GridPosition *self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	_tmp0_ = g_strdup_printf ("%hhi", (*self).row);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%hhi", (*self).col);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat ("(", _tmp1_, ",", _tmp3_, ")", NULL);
	_tmp5_ = _tmp4_;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp5_;
	return result;
}

GridPosition*
grid_position_dup (const GridPosition* self)
{
	GridPosition* dup;
	dup = g_new0 (GridPosition, 1);
	memcpy (dup, self, sizeof (GridPosition));
	return dup;
}

void
grid_position_free (GridPosition* self)
{
	g_free (self);
}

static GType
grid_position_get_type_once (void)
{
	GType grid_position_type_id;
	grid_position_type_id = g_boxed_type_register_static ("GridPosition", (GBoxedCopyFunc) grid_position_dup, (GBoxedFreeFunc) grid_position_free);
	return grid_position_type_id;
}

GType
grid_position_get_type (void)
{
	static volatile gsize grid_position_type_id__once = 0;
	if (g_once_init_enter (&grid_position_type_id__once)) {
		GType grid_position_type_id;
		grid_position_type_id = grid_position_get_type_once ();
		g_once_init_leave (&grid_position_type_id__once, grid_position_type_id);
	}
	return grid_position_type_id__once;
}

TileMovement*
tile_movement_dup (const TileMovement* self)
{
	TileMovement* dup;
	dup = g_new0 (TileMovement, 1);
	memcpy (dup, self, sizeof (TileMovement));
	return dup;
}

void
tile_movement_free (TileMovement* self)
{
	g_free (self);
}

static GType
tile_movement_get_type_once (void)
{
	GType tile_movement_type_id;
	tile_movement_type_id = g_boxed_type_register_static ("TileMovement", (GBoxedCopyFunc) tile_movement_dup, (GBoxedFreeFunc) tile_movement_free);
	return tile_movement_type_id;
}

GType
tile_movement_get_type (void)
{
	static volatile gsize tile_movement_type_id__once = 0;
	if (g_once_init_enter (&tile_movement_type_id__once)) {
		GType tile_movement_type_id;
		tile_movement_type_id = tile_movement_get_type_once ();
		g_once_init_leave (&tile_movement_type_id__once, tile_movement_type_id);
	}
	return tile_movement_type_id__once;
}

Tile*
tile_dup (const Tile* self)
{
	Tile* dup;
	dup = g_new0 (Tile, 1);
	memcpy (dup, self, sizeof (Tile));
	return dup;
}

void
tile_free (Tile* self)
{
	g_free (self);
}

static GType
tile_get_type_once (void)
{
	GType tile_type_id;
	tile_type_id = g_boxed_type_register_static ("Tile", (GBoxedCopyFunc) tile_dup, (GBoxedFreeFunc) tile_free);
	return tile_type_id;
}

GType
tile_get_type (void)
{
	static volatile gsize tile_type_id__once = 0;
	if (g_once_init_enter (&tile_type_id__once)) {
		GType tile_type_id;
		tile_type_id = tile_get_type_once ();
		g_once_init_leave (&tile_type_id__once, tile_type_id);
	}
	return tile_type_id__once;
}

gchar*
move_request_debug_string (MoveRequest request)
{
	gchar* result;
	switch (request) {
		case MOVE_REQUEST_UP:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup ("move up");
			result = _tmp0_;
			return result;
		}
		case MOVE_REQUEST_RIGHT:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup ("move right");
			result = _tmp1_;
			return result;
		}
		case MOVE_REQUEST_DOWN:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup ("move down");
			result = _tmp2_;
			return result;
		}
		case MOVE_REQUEST_LEFT:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup ("move left");
			result = _tmp3_;
			return result;
		}
		default:
		{
			g_assert_not_reached ();
		}
	}
}

static GType
move_request_get_type_once (void)
{
	static const GEnumValue values[] = {{MOVE_REQUEST_UP, "MOVE_REQUEST_UP", "up"}, {MOVE_REQUEST_RIGHT, "MOVE_REQUEST_RIGHT", "right"}, {MOVE_REQUEST_DOWN, "MOVE_REQUEST_DOWN", "down"}, {MOVE_REQUEST_LEFT, "MOVE_REQUEST_LEFT", "left"}, {0, NULL, NULL}};
	GType move_request_type_id;
	move_request_type_id = g_enum_register_static ("MoveRequest", values);
	return move_request_type_id;
}

GType
move_request_get_type (void)
{
	static volatile gsize move_request_type_id__once = 0;
	if (g_once_init_enter (&move_request_type_id__once)) {
		GType move_request_type_id;
		move_request_type_id = move_request_get_type_once ();
		g_once_init_leave (&move_request_type_id__once, move_request_type_id);
	}
	return move_request_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

