/* dreamcast-header.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from dreamcast-header.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include "gnome-games.h"
#include "games-dreamcast-plugin.h"

#define GAMES_DREAMCAST_HEADER_HEADER_OFFSET ((gsize) 0x10)
#define GAMES_DREAMCAST_HEADER_HEADER_SIZE ((gsize) 0x100)
#define GAMES_DREAMCAST_HEADER_MAGIC_OFFSET ((gsize) 0x0)
#define GAMES_DREAMCAST_HEADER_MAGIC_VALUE "SEGA SEGAKATANA"
#define GAMES_DREAMCAST_HEADER_PRODUCT_NUMBER_OFFSET ((gsize) 0x40)
#define GAMES_DREAMCAST_HEADER_PRODUCT_NUMBER_SIZE ((gsize) 0xa)
#define GAMES_DREAMCAST_HEADER_AREAS_OFFSET ((gsize) 0x30)
#define GAMES_DREAMCAST_HEADER_AREAS_SIZE ((gsize) 0x8)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_DREAMCAST_HEADER (games_dreamcast_header_get_type ())
#define GAMES_DREAMCAST_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_DREAMCAST_HEADER, GamesDreamcastHeader))
#define GAMES_DREAMCAST_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_DREAMCAST_HEADER, GamesDreamcastHeaderClass))
#define GAMES_IS_DREAMCAST_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_DREAMCAST_HEADER))
#define GAMES_IS_DREAMCAST_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_DREAMCAST_HEADER))
#define GAMES_DREAMCAST_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_DREAMCAST_HEADER, GamesDreamcastHeaderClass))

typedef struct _GamesDreamcastHeader GamesDreamcastHeader;
typedef struct _GamesDreamcastHeaderClass GamesDreamcastHeaderClass;
typedef struct _GamesDreamcastHeaderPrivate GamesDreamcastHeaderPrivate;
enum  {
	GAMES_DREAMCAST_HEADER_0_PROPERTY,
	GAMES_DREAMCAST_HEADER_NUM_PROPERTIES
};
static GParamSpec* games_dreamcast_header_properties[GAMES_DREAMCAST_HEADER_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))

#define GAMES_TYPE_DREAMCAST_ERROR (games_dreamcast_error_get_type ())

struct _GamesDreamcastHeader {
	GObject parent_instance;
	GamesDreamcastHeaderPrivate * priv;
};

struct _GamesDreamcastHeaderClass {
	GObjectClass parent_class;
};

struct _GamesDreamcastHeaderPrivate {
	GFile* file;
	gsize* header_offset;
};

typedef enum  {
	GAMES_DREAMCAST_ERROR_INVALID_GDI,
	GAMES_DREAMCAST_ERROR_INVALID_FILE_TYPE,
	GAMES_DREAMCAST_ERROR_INVALID_HEADER
} GamesDreamcastError;
#define GAMES_DREAMCAST_ERROR games_dreamcast_error_quark ()

static gint GamesDreamcastHeader_private_offset;
static gpointer games_dreamcast_header_parent_class = NULL;
static GType games_dreamcast_header_type_id = 0;

GType games_dreamcast_header_register_type (GTypeModule * module);
VALA_EXTERN GType games_dreamcast_header_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GamesDreamcastHeader* games_dreamcast_header_new (GFile* file);
VALA_EXTERN GamesDreamcastHeader* games_dreamcast_header_construct (GType object_type,
                                                        GFile* file);
VALA_EXTERN void games_dreamcast_header_check_validity (GamesDreamcastHeader* self,
                                            GError** error);
static gsize games_dreamcast_header_get_header_offset (GamesDreamcastHeader* self,
                                                GError** error);
VALA_EXTERN gchar* games_dreamcast_header_get_product_number (GamesDreamcastHeader* self,
                                                  GError** error);
VALA_EXTERN gchar* games_dreamcast_header_get_areas (GamesDreamcastHeader* self,
                                         GError** error);
static gboolean games_dreamcast_header_lookup_header_offset (GamesDreamcastHeader* self,
                                                      gsize offset,
                                                      GError** error);
static gsize* _size_t_dup (gsize* self);
VALA_EXTERN GQuark games_dreamcast_error_quark (void);
VALA_EXTERN GType games_dreamcast_error_get_type (void) G_GNUC_CONST ;
static void games_dreamcast_header_finalize (GObject * obj);

static inline gpointer
games_dreamcast_header_get_instance_private (GamesDreamcastHeader* self)
{
	return G_STRUCT_MEMBER_P (self, GamesDreamcastHeader_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GamesDreamcastHeader*
games_dreamcast_header_construct (GType object_type,
                                  GFile* file)
{
	GamesDreamcastHeader * self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesDreamcastHeader*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp0_;
	return self;
}

GamesDreamcastHeader*
games_dreamcast_header_new (GFile* file)
{
	return games_dreamcast_header_construct (GAMES_TYPE_DREAMCAST_HEADER, file);
}

void
games_dreamcast_header_check_validity (GamesDreamcastHeader* self,
                                       GError** error)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	games_dreamcast_header_get_header_offset (self, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

gchar*
games_dreamcast_header_get_product_number (GamesDreamcastHeader* self,
                                           GError** error)
{
	GamesStringInputStream* stream = NULL;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	gchar* product_number = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	_tmp2_ = games_string_input_stream_read_string_for_size (stream, GAMES_DREAMCAST_HEADER_PRODUCT_NUMBER_OFFSET, GAMES_DREAMCAST_HEADER_PRODUCT_NUMBER_SIZE, &_inner_error0_);
	product_number = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		return NULL;
	}
	_tmp3_ = string_strip (product_number);
	result = _tmp3_;
	_g_free0 (product_number);
	_g_object_unref0 (stream);
	return result;
}

gchar*
games_dreamcast_header_get_areas (GamesDreamcastHeader* self,
                                  GError** error)
{
	GamesStringInputStream* stream = NULL;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	gchar* areas = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	_tmp2_ = games_string_input_stream_read_string_for_size (stream, GAMES_DREAMCAST_HEADER_AREAS_OFFSET, GAMES_DREAMCAST_HEADER_AREAS_SIZE, &_inner_error0_);
	areas = _tmp2_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		return NULL;
	}
	_tmp3_ = string_strip (areas);
	result = _tmp3_;
	_g_free0 (areas);
	_g_object_unref0 (stream);
	return result;
}

static gsize*
_size_t_dup (gsize* self)
{
	gsize* dup;
	dup = g_new0 (gsize, 1);
	memcpy (dup, self, sizeof (gsize));
	return dup;
}

static gpointer
__size_t_dup0 (gpointer self)
{
	return self ? _size_t_dup (self) : NULL;
}

static gsize
games_dreamcast_header_get_header_offset (GamesDreamcastHeader* self,
                                          GError** error)
{
	gsize* _tmp0_;
	gboolean _tmp2_ = FALSE;
	gchar* path = NULL;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gsize* header_offsets = NULL;
	const gchar* _tmp9_;
	gint _tmp10_ = 0;
	gsize* _tmp11_;
	gint header_offsets_length1;
	gint _header_offsets_size_;
	gsize* _tmp12_;
	gint _tmp12__length1;
	GError* _tmp17_;
	gsize _tmp18_ = 0UL;
	GError* _inner_error0_ = NULL;
	gsize result;
	g_return_val_if_fail (self != NULL, 0UL);
	_tmp0_ = self->priv->header_offset;
	if (_tmp0_ != NULL) {
		gsize* _tmp1_;
		_tmp1_ = self->priv->header_offset;
		result = *_tmp1_;
		return result;
	}
	_tmp2_ = games_dreamcast_header_lookup_header_offset (self, GAMES_DREAMCAST_HEADER_HEADER_OFFSET, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gsize _tmp3_ = 0UL;
		g_propagate_error (error, _inner_error0_);
		return _tmp3_;
	}
	if (_tmp2_) {
		gsize _tmp4_;
		gsize* _tmp5_;
		gsize* _tmp6_;
		_tmp4_ = GAMES_DREAMCAST_HEADER_HEADER_OFFSET;
		_tmp5_ = __size_t_dup0 (&_tmp4_);
		_g_free0 (self->priv->header_offset);
		self->priv->header_offset = _tmp5_;
		_tmp6_ = self->priv->header_offset;
		result = *_tmp6_;
		return result;
	}
	_tmp7_ = self->priv->file;
	_tmp8_ = g_file_get_path (_tmp7_);
	path = _tmp8_;
	_tmp9_ = path;
	_tmp11_ = games_grep_get_offsets (_tmp9_, GAMES_DREAMCAST_HEADER_MAGIC_VALUE, &_tmp10_);
	header_offsets = _tmp11_;
	header_offsets_length1 = _tmp10_;
	_header_offsets_size_ = header_offsets_length1;
	_tmp12_ = header_offsets;
	_tmp12__length1 = header_offsets_length1;
	{
		gsize* offset_collection = NULL;
		gint offset_collection_length1 = 0;
		gint _offset_collection_size_ = 0;
		gint offset_it = 0;
		offset_collection = _tmp12_;
		offset_collection_length1 = _tmp12__length1;
		for (offset_it = 0; offset_it < offset_collection_length1; offset_it = offset_it + 1) {
			gsize offset = 0UL;
			offset = offset_collection[offset_it];
			{
				gboolean _tmp13_ = FALSE;
				_tmp13_ = games_dreamcast_header_lookup_header_offset (self, offset, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					gsize _tmp14_ = 0UL;
					g_propagate_error (error, _inner_error0_);
					header_offsets = (g_free (header_offsets), NULL);
					_g_free0 (path);
					return _tmp14_;
				}
				if (_tmp13_) {
					gsize* _tmp15_;
					gsize* _tmp16_;
					_tmp15_ = __size_t_dup0 (&offset);
					_g_free0 (self->priv->header_offset);
					self->priv->header_offset = _tmp15_;
					_tmp16_ = self->priv->header_offset;
					result = *_tmp16_;
					header_offsets = (g_free (header_offsets), NULL);
					_g_free0 (path);
					return result;
				}
			}
		}
	}
	_tmp17_ = g_error_new_literal (GAMES_DREAMCAST_ERROR, GAMES_DREAMCAST_ERROR_INVALID_HEADER, "The file doesn’t have a Dreamcast header.");
	_inner_error0_ = _tmp17_;
	g_propagate_error (error, _inner_error0_);
	header_offsets = (g_free (header_offsets), NULL);
	_g_free0 (path);
	return _tmp18_;
}

static gboolean
games_dreamcast_header_lookup_header_offset (GamesDreamcastHeader* self,
                                             gsize offset,
                                             GError** error)
{
	GamesStringInputStream* stream = NULL;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	gboolean _tmp2_ = FALSE;
	GamesStringInputStream* _tmp3_;
	gchar* header = NULL;
	GamesStringInputStream* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp8_ = FALSE;
	const gchar* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	_tmp3_ = stream;
	_tmp2_ = games_string_input_stream_has_string (_tmp3_, offset + GAMES_DREAMCAST_HEADER_MAGIC_OFFSET, GAMES_DREAMCAST_HEADER_MAGIC_VALUE, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp4_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		return _tmp4_;
	}
	if (!_tmp2_) {
		result = FALSE;
		_g_object_unref0 (stream);
		return result;
	}
	_tmp5_ = stream;
	_tmp6_ = games_string_input_stream_read_string_for_size (_tmp5_, offset, GAMES_DREAMCAST_HEADER_HEADER_SIZE, &_inner_error0_);
	header = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp7_ = FALSE;
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (stream);
		return _tmp7_;
	}
	_tmp9_ = header;
	_tmp10_ = strlen (_tmp9_);
	_tmp11_ = _tmp10_;
	if (((gsize) _tmp11_) == GAMES_DREAMCAST_HEADER_HEADER_SIZE) {
		const gchar* _tmp12_;
		_tmp12_ = header;
		_tmp8_ = g_str_is_ascii (_tmp12_);
	} else {
		_tmp8_ = FALSE;
	}
	result = _tmp8_;
	_g_free0 (header);
	_g_object_unref0 (stream);
	return result;
}

static void
games_dreamcast_header_class_init (GamesDreamcastHeaderClass * klass,
                                   gpointer klass_data)
{
	games_dreamcast_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GamesDreamcastHeader_private_offset);
	G_OBJECT_CLASS (klass)->finalize = games_dreamcast_header_finalize;
}

static void
games_dreamcast_header_instance_init (GamesDreamcastHeader * self,
                                      gpointer klass)
{
	self->priv = games_dreamcast_header_get_instance_private (self);
}

static void
games_dreamcast_header_finalize (GObject * obj)
{
	GamesDreamcastHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_DREAMCAST_HEADER, GamesDreamcastHeader);
	_g_object_unref0 (self->priv->file);
	_g_free0 (self->priv->header_offset);
	G_OBJECT_CLASS (games_dreamcast_header_parent_class)->finalize (obj);
}

GType
games_dreamcast_header_get_type (void)
{
	return games_dreamcast_header_type_id;
}

GType
games_dreamcast_header_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesDreamcastHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_dreamcast_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesDreamcastHeader), 0, (GInstanceInitFunc) games_dreamcast_header_instance_init, NULL };
	games_dreamcast_header_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesDreamcastHeader", &g_define_type_info, 0);
	GamesDreamcastHeader_private_offset = sizeof (GamesDreamcastHeaderPrivate);
	return games_dreamcast_header_type_id;
}

