/* game-cube-plugin.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from game-cube-plugin.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib-object.h>
#include "gnome-games.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include "games-game-cube-plugin.h"

#define GAMES_GAME_CUBE_PLUGIN_MIME_TYPE "application/x-gamecube-rom"
#define GAMES_GAME_CUBE_PLUGIN_PLATFORM_ID "GameCube"
#define GAMES_GAME_CUBE_PLUGIN_PLATFORM_NAME _ ("Nintendo GameCube")
#define GAMES_GAME_CUBE_PLUGIN_PLATFORM_UID_PREFIX "game-cube"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define GAMES_TYPE_GAME_CUBE_PLUGIN (games_game_cube_plugin_get_type ())
#define GAMES_GAME_CUBE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_CUBE_PLUGIN, GamesGameCubePlugin))
#define GAMES_GAME_CUBE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_CUBE_PLUGIN, GamesGameCubePluginClass))
#define GAMES_IS_GAME_CUBE_PLUGIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_CUBE_PLUGIN))
#define GAMES_IS_GAME_CUBE_PLUGIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_CUBE_PLUGIN))
#define GAMES_GAME_CUBE_PLUGIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_CUBE_PLUGIN, GamesGameCubePluginClass))

typedef struct _GamesGameCubePlugin GamesGameCubePlugin;
typedef struct _GamesGameCubePluginClass GamesGameCubePluginClass;
typedef struct _GamesGameCubePluginPrivate GamesGameCubePluginPrivate;
enum  {
	GAMES_GAME_CUBE_PLUGIN_0_PROPERTY,
	GAMES_GAME_CUBE_PLUGIN_NUM_PROPERTIES
};
static GParamSpec* games_game_cube_plugin_properties[GAMES_GAME_CUBE_PLUGIN_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define GAMES_TYPE_GAME_CUBE_HEADER (games_game_cube_header_get_type ())
#define GAMES_GAME_CUBE_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_GAME_CUBE_HEADER, GamesGameCubeHeader))
#define GAMES_GAME_CUBE_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_GAME_CUBE_HEADER, GamesGameCubeHeaderClass))
#define GAMES_IS_GAME_CUBE_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_GAME_CUBE_HEADER))
#define GAMES_IS_GAME_CUBE_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_GAME_CUBE_HEADER))
#define GAMES_GAME_CUBE_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_GAME_CUBE_HEADER, GamesGameCubeHeaderClass))

typedef struct _GamesGameCubeHeader GamesGameCubeHeader;
typedef struct _GamesGameCubeHeaderClass GamesGameCubeHeaderClass;
#define _g_free0(var) (var = (g_free (var), NULL))

struct _GamesGameCubePlugin {
	GObject parent_instance;
	GamesGameCubePluginPrivate * priv;
};

struct _GamesGameCubePluginClass {
	GObjectClass parent_class;
};

static gpointer games_game_cube_plugin_parent_class = NULL;
static GamesRetroPlatform* games_game_cube_plugin_platform;
static GamesRetroPlatform* games_game_cube_plugin_platform = NULL;
static GamesPluginIface * games_game_cube_plugin_games_plugin_parent_iface = NULL;
static GType games_game_cube_plugin_type_id = 0;

GType games_game_cube_plugin_register_type (GTypeModule * module);
VALA_EXTERN GType games_game_cube_plugin_get_type (void) G_GNUC_CONST ;
static GamesPlatform** games_game_cube_plugin_real_get_platforms (GamesPlugin* base,
                                                           gint* result_length1);
static gchar** games_game_cube_plugin_real_get_mime_types (GamesPlugin* base,
                                                    gint* result_length1);
static GamesUriGameFactory** games_game_cube_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                                          gint* result_length1);
static GamesGame* games_game_cube_plugin_game_for_uri (GamesUri* uri,
                                                GError** error);
static GamesGame* _games_game_cube_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                             gpointer self,
                                                                                             GError** error);
static GamesRunnerFactory** games_game_cube_plugin_real_get_runner_factories (GamesPlugin* base,
                                                                       gint* result_length1);
GType games_game_cube_header_register_type (GTypeModule * module);
VALA_EXTERN GType games_game_cube_header_get_type (void) G_GNUC_CONST ;
static gchar* games_game_cube_plugin_get_uid (GamesGameCubeHeader* header,
                                       GError** error);
VALA_EXTERN gchar* games_game_cube_header_get_game_id (GamesGameCubeHeader* self,
                                           GError** error);
VALA_EXTERN GamesGameCubeHeader* games_game_cube_header_new (GFile* file);
VALA_EXTERN GamesGameCubeHeader* games_game_cube_header_construct (GType object_type,
                                                       GFile* file);
VALA_EXTERN void games_game_cube_header_check_validity (GamesGameCubeHeader* self,
                                            GError** error);
VALA_EXTERN GamesGameCubePlugin* games_game_cube_plugin_new (void);
VALA_EXTERN GamesGameCubePlugin* games_game_cube_plugin_construct (GType object_type);
static void games_game_cube_plugin_finalize (GObject * obj);
GType games_game_cube_header_register_type (GTypeModule * module);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GamesPlatform**
games_game_cube_plugin_real_get_platforms (GamesPlugin* base,
                                           gint* result_length1)
{
	GamesGameCubePlugin * self;
	GamesRetroPlatform* _tmp0_;
	GamesPlatform* _tmp1_;
	GamesPlatform** _tmp2_;
	GamesPlatform** _tmp3_;
	gint _tmp3__length1;
	GamesPlatform** result;
	self = (GamesGameCubePlugin*) base;
	_tmp0_ = games_game_cube_plugin_platform;
	_tmp1_ = _g_object_ref0 ((GamesPlatform*) _tmp0_);
	_tmp2_ = g_new0 (GamesPlatform*, 1 + 1);
	_tmp2_[0] = _tmp1_;
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp3__length1;
	}
	result = _tmp3_;
	return result;
}

static gchar**
games_game_cube_plugin_real_get_mime_types (GamesPlugin* base,
                                            gint* result_length1)
{
	GamesGameCubePlugin * self;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** result;
	self = (GamesGameCubePlugin*) base;
	_tmp0_ = g_strdup (GAMES_GAME_CUBE_PLUGIN_MIME_TYPE);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static GamesGame*
_games_game_cube_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri (GamesUri* uri,
                                                                                  gpointer self,
                                                                                  GError** error)
{
	GamesGame* result;
	result = games_game_cube_plugin_game_for_uri (uri, error);
	return result;
}

static GamesUriGameFactory**
games_game_cube_plugin_real_get_uri_game_factories (GamesPlugin* base,
                                                    gint* result_length1)
{
	GamesGameCubePlugin * self;
	GamesGenericGameUriAdapter* game_uri_adapter = NULL;
	GamesGenericGameUriAdapter* _tmp0_;
	GamesGenericUriGameFactory* factory = NULL;
	GamesGenericUriGameFactory* _tmp1_;
	GamesUriGameFactory* _tmp2_;
	GamesUriGameFactory** _tmp3_;
	GamesUriGameFactory** _tmp4_;
	gint _tmp4__length1;
	GamesUriGameFactory** result;
	self = (GamesGameCubePlugin*) base;
	_tmp0_ = games_generic_game_uri_adapter_new (_games_game_cube_plugin_game_for_uri_games_generic_game_uri_adapter_game_for_uri, NULL, NULL);
	game_uri_adapter = _tmp0_;
	_tmp1_ = games_generic_uri_game_factory_new ((GamesGameUriAdapter*) game_uri_adapter);
	factory = _tmp1_;
	games_generic_uri_game_factory_add_mime_type (factory, GAMES_GAME_CUBE_PLUGIN_MIME_TYPE);
	_tmp2_ = _g_object_ref0 ((GamesUriGameFactory*) factory);
	_tmp3_ = g_new0 (GamesUriGameFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	_g_object_unref0 (game_uri_adapter);
	return result;
}

static GamesRunnerFactory**
games_game_cube_plugin_real_get_runner_factories (GamesPlugin* base,
                                                  gint* result_length1)
{
	GamesGameCubePlugin * self;
	GamesRetroRunnerFactory* factory = NULL;
	GamesRetroPlatform* _tmp0_;
	GamesRetroRunnerFactory* _tmp1_;
	GamesRunnerFactory* _tmp2_;
	GamesRunnerFactory** _tmp3_;
	GamesRunnerFactory** _tmp4_;
	gint _tmp4__length1;
	GamesRunnerFactory** result;
	self = (GamesGameCubePlugin*) base;
	_tmp0_ = games_game_cube_plugin_platform;
	_tmp1_ = games_retro_runner_factory_new (_tmp0_);
	factory = _tmp1_;
	_tmp2_ = _g_object_ref0 ((GamesRunnerFactory*) factory);
	_tmp3_ = g_new0 (GamesRunnerFactory*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	_g_object_unref0 (factory);
	return result;
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static gchar*
games_game_cube_plugin_get_uid (GamesGameCubeHeader* header,
                                GError** error)
{
	gchar* game_id = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (header != NULL, NULL);
	_tmp0_ = games_game_cube_header_get_game_id (header, &_inner_error0_);
	game_id = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return NULL;
	}
	_tmp1_ = string_to_string (GAMES_GAME_CUBE_PLUGIN_PLATFORM_UID_PREFIX);
	_tmp2_ = string_to_string (game_id);
	_tmp3_ = g_strconcat (_tmp1_, "-", _tmp2_, NULL);
	_tmp4_ = _tmp3_;
	_tmp5_ = g_utf8_strdown (_tmp4_, (gssize) -1);
	_tmp6_ = _tmp5_;
	_g_free0 (_tmp4_);
	result = _tmp6_;
	_g_free0 (game_id);
	return result;
}

static GamesGame*
games_game_cube_plugin_game_for_uri (GamesUri* uri,
                                     GError** error)
{
	GFile* file = NULL;
	GFile* _tmp0_;
	GamesGameCubeHeader* header = NULL;
	GFile* _tmp1_;
	GamesGameCubeHeader* _tmp2_;
	GamesGameCubeHeader* _tmp3_;
	gchar* _tmp4_ = NULL;
	GamesGameCubeHeader* _tmp5_;
	gchar* _tmp6_;
	GamesUid* uid = NULL;
	GamesUid* _tmp7_;
	GamesFilenameTitle* title = NULL;
	GamesFilenameTitle* _tmp8_;
	GamesGriloMedia* media = NULL;
	GamesFilenameTitle* _tmp9_;
	GamesGriloMedia* _tmp10_;
	GamesCompositeCover* cover = NULL;
	GamesLocalCover* _tmp11_;
	GamesGriloMedia* _tmp12_;
	GamesUid* _tmp13_;
	GamesGriloCover* _tmp14_;
	GamesCover** _tmp15_;
	GamesCover** _tmp16_;
	gint _tmp16__length1;
	GamesCompositeCover* _tmp17_;
	GamesCompositeCover* _tmp18_;
	GamesGame* game = NULL;
	GamesUid* _tmp19_;
	GamesFilenameTitle* _tmp20_;
	GamesRetroPlatform* _tmp21_;
	GamesGame* _tmp22_;
	GamesGame* _tmp23_;
	GamesCompositeCover* _tmp24_;
	GError* _inner_error0_ = NULL;
	GamesGame* result;
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = games_uri_to_file (uri);
	file = _tmp0_;
	_tmp1_ = file;
	_tmp2_ = games_game_cube_header_new (_tmp1_);
	header = _tmp2_;
	_tmp3_ = header;
	games_game_cube_header_check_validity (_tmp3_, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (header);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp5_ = header;
	_tmp6_ = games_game_cube_plugin_get_uid (_tmp5_, &_inner_error0_);
	_tmp4_ = _tmp6_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		_g_object_unref0 (header);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp7_ = games_uid_new (_tmp4_);
	uid = _tmp7_;
	_tmp8_ = games_filename_title_new (uri);
	title = _tmp8_;
	_tmp9_ = title;
	_tmp10_ = games_grilo_media_new ((GamesTitle*) _tmp9_, GAMES_GAME_CUBE_PLUGIN_MIME_TYPE);
	media = _tmp10_;
	_tmp11_ = games_local_cover_new (uri);
	_tmp12_ = media;
	_tmp13_ = uid;
	_tmp14_ = games_grilo_cover_new (_tmp12_, _tmp13_);
	_tmp15_ = g_new0 (GamesCover*, 2 + 1);
	_tmp15_[0] = (GamesCover*) _tmp11_;
	_tmp15_[1] = (GamesCover*) _tmp14_;
	_tmp16_ = _tmp15_;
	_tmp16__length1 = 2;
	_tmp17_ = games_composite_cover_new (_tmp16_, 2);
	_tmp18_ = _tmp17_;
	_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp18_;
	_tmp19_ = uid;
	_tmp20_ = title;
	_tmp21_ = games_game_cube_plugin_platform;
	_tmp22_ = games_game_new (_tmp19_, uri, (GamesTitle*) _tmp20_, (GamesPlatform*) _tmp21_);
	game = _tmp22_;
	_tmp23_ = game;
	_tmp24_ = cover;
	games_game_set_cover (_tmp23_, (GamesCover*) _tmp24_);
	result = game;
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_free0 (_tmp4_);
	_g_object_unref0 (header);
	_g_object_unref0 (file);
	return result;
}

GamesGameCubePlugin*
games_game_cube_plugin_construct (GType object_type)
{
	GamesGameCubePlugin * self = NULL;
	self = (GamesGameCubePlugin*) g_object_new (object_type, NULL);
	return self;
}

GamesGameCubePlugin*
games_game_cube_plugin_new (void)
{
	return games_game_cube_plugin_construct (GAMES_TYPE_GAME_CUBE_PLUGIN);
}

static void
games_game_cube_plugin_class_init (GamesGameCubePluginClass * klass,
                                   gpointer klass_data)
{
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	GamesRetroPlatform* _tmp3_;
	games_game_cube_plugin_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = games_game_cube_plugin_finalize;
	_tmp0_ = g_strdup (GAMES_GAME_CUBE_PLUGIN_MIME_TYPE);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	_tmp3_ = games_retro_platform_new (GAMES_GAME_CUBE_PLUGIN_PLATFORM_ID, GAMES_GAME_CUBE_PLUGIN_PLATFORM_NAME, _tmp2_, 1, GAMES_GAME_CUBE_PLUGIN_PLATFORM_UID_PREFIX);
	_g_object_unref0 (games_game_cube_plugin_platform);
	games_game_cube_plugin_platform = _tmp3_;
	_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
}

static void
games_game_cube_plugin_games_plugin_interface_init (GamesPluginIface * iface,
                                                    gpointer iface_data)
{
	games_game_cube_plugin_games_plugin_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_platforms = (GamesPlatform** (*) (GamesPlugin*, gint*)) games_game_cube_plugin_real_get_platforms;
	iface->get_mime_types = (gchar** (*) (GamesPlugin*, gint*)) games_game_cube_plugin_real_get_mime_types;
	iface->get_uri_game_factories = (GamesUriGameFactory** (*) (GamesPlugin*, gint*)) games_game_cube_plugin_real_get_uri_game_factories;
	iface->get_runner_factories = (GamesRunnerFactory** (*) (GamesPlugin*, gint*)) games_game_cube_plugin_real_get_runner_factories;
}

static void
games_game_cube_plugin_instance_init (GamesGameCubePlugin * self,
                                      gpointer klass)
{
}

static void
games_game_cube_plugin_finalize (GObject * obj)
{
	GamesGameCubePlugin * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_GAME_CUBE_PLUGIN, GamesGameCubePlugin);
	G_OBJECT_CLASS (games_game_cube_plugin_parent_class)->finalize (obj);
}

GType
games_game_cube_plugin_get_type (void)
{
	return games_game_cube_plugin_type_id;
}

GType
games_game_cube_plugin_register_type (GTypeModule * module)
{
	static const GTypeInfo g_define_type_info = { sizeof (GamesGameCubePluginClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_game_cube_plugin_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesGameCubePlugin), 0, (GInstanceInitFunc) games_game_cube_plugin_instance_init, NULL };
	static const GInterfaceInfo games_plugin_info = { (GInterfaceInitFunc) games_game_cube_plugin_games_plugin_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_game_cube_plugin_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesGameCubePlugin", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_game_cube_plugin_type_id, GAMES_TYPE_PLUGIN, &games_plugin_info);
	return games_game_cube_plugin_type_id;
}

GType
register_games_plugin (GTypeModule* module)
{
	GType result;
	g_return_val_if_fail (module != NULL, 0UL);
	games_game_cube_header_register_type (module);
	games_game_cube_plugin_register_type (module);
	result = GAMES_TYPE_GAME_CUBE_PLUGIN;
	return result;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

