/* curve_fitting.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from curve_fitting.vala, do not modify */

/* SPDX-License-Identifier: GPL-3.0-or-later*/

#include "graphs.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <glib-object.h>
#include <adwaita.h>
#include <gtk/gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	GRAPHS_FITTING_PARAMETER_0_PROPERTY,
	GRAPHS_FITTING_PARAMETER_NAME_PROPERTY,
	GRAPHS_FITTING_PARAMETER_INITIAL_PROPERTY,
	GRAPHS_FITTING_PARAMETER_LOWER_BOUND_PROPERTY,
	GRAPHS_FITTING_PARAMETER_UPPER_BOUND_PROPERTY,
	GRAPHS_FITTING_PARAMETER_NUM_PROPERTIES
};
static GParamSpec* graphs_fitting_parameter_properties[GRAPHS_FITTING_PARAMETER_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	GRAPHS_CURVE_FITTING_DIALOG_0_PROPERTY,
	GRAPHS_CURVE_FITTING_DIALOG_CUSTOM_EQUATION_PROPERTY,
	GRAPHS_CURVE_FITTING_DIALOG_FITTING_PARAMS_BOX_PROPERTY,
	GRAPHS_CURVE_FITTING_DIALOG_TEXT_VIEW_PROPERTY,
	GRAPHS_CURVE_FITTING_DIALOG_APPLICATION_PROPERTY,
	GRAPHS_CURVE_FITTING_DIALOG_SETTINGS_PROPERTY,
	GRAPHS_CURVE_FITTING_DIALOG_EQUATION_STRING_PROPERTY,
	GRAPHS_CURVE_FITTING_DIALOG_CANVAS_PROPERTY,
	GRAPHS_CURVE_FITTING_DIALOG_NUM_PROPERTIES
};
static GParamSpec* graphs_curve_fitting_dialog_properties[GRAPHS_CURVE_FITTING_DIALOG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	GRAPHS_CURVE_FITTING_DIALOG_EQUATION_CHANGE_SIGNAL,
	GRAPHS_CURVE_FITTING_DIALOG_FIT_CURVE_REQUEST_SIGNAL,
	GRAPHS_CURVE_FITTING_DIALOG_ADD_FIT_REQUEST_SIGNAL,
	GRAPHS_CURVE_FITTING_DIALOG_NUM_SIGNALS
};
static guint graphs_curve_fitting_dialog_signals[GRAPHS_CURVE_FITTING_DIALOG_NUM_SIGNALS] = {0};
enum  {
	GRAPHS_FITTING_PARAMETER_BOX_0_PROPERTY,
	GRAPHS_FITTING_PARAMETER_BOX_INITIAL_PROPERTY,
	GRAPHS_FITTING_PARAMETER_BOX_UPPER_BOUND_PROPERTY,
	GRAPHS_FITTING_PARAMETER_BOX_LOWER_BOUND_PROPERTY,
	GRAPHS_FITTING_PARAMETER_BOX_NUM_PROPERTIES
};
static GParamSpec* graphs_fitting_parameter_box_properties[GRAPHS_FITTING_PARAMETER_BOX_NUM_PROPERTIES];

struct _GraphsFittingParameterPrivate {
	gchar* _name;
	gdouble _initial;
	gchar* _lower_bound;
	gchar* _upper_bound;
};

struct _GraphsCurveFittingDialogPrivate {
	AdwComboRow* _equation;
	AdwEntryRow* _custom_equation;
	GtkBox* _fitting_params_box;
	GtkTextView* _text_view;
	AdwToastOverlay* _toast_overlay;
	GraphsApplication* _application;
	GSettings* _settings;
	gchar* _equation_string;
};

struct _GraphsFittingParameterBoxPrivate {
	GtkLabel* _label;
	AdwEntryRow* _initial;
	AdwEntryRow* _upper_bound;
	AdwEntryRow* _lower_bound;
};

static gint GraphsFittingParameter_private_offset;
static gpointer graphs_fitting_parameter_parent_class = NULL;
static gint GraphsCurveFittingDialog_private_offset;
static gpointer graphs_curve_fitting_dialog_parent_class = NULL;
static gint GraphsFittingParameterBox_private_offset;
static gpointer graphs_fitting_parameter_box_parent_class = NULL;

static void graphs_fitting_parameter_finalize (GObject * obj);
static GType graphs_fitting_parameter_get_type_once (void);
static void _vala_graphs_fitting_parameter_get_property (GObject * object,
                                                  guint property_id,
                                                  GValue * value,
                                                  GParamSpec * pspec);
static void _vala_graphs_fitting_parameter_set_property (GObject * object,
                                                  guint property_id,
                                                  const GValue * value,
                                                  GParamSpec * pspec);
static void graphs_curve_fitting_dialog_set_settings (GraphsCurveFittingDialog* self,
                                               GSettings* value);
static void graphs_curve_fitting_dialog_emit_fit_curve_request (GraphsCurveFittingDialog* self);
static void _graphs_curve_fitting_dialog_emit_fit_curve_request_g_object_notify (GObject* _sender,
                                                                          GParamSpec* pspec,
                                                                          gpointer self);
static void __lambda21_ (GraphsCurveFittingDialog* self);
static void ___lambda21__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static AdwComboRow* graphs_curve_fitting_dialog_get_equation (GraphsCurveFittingDialog* self);
static void graphs_curve_fitting_dialog_set_equation (GraphsCurveFittingDialog* self);
static void _graphs_curve_fitting_dialog_set_equation_g_object_notify (GObject* _sender,
                                                                GParamSpec* pspec,
                                                                gpointer self);
static void __lambda22_ (GraphsCurveFittingDialog* self);
static void ___lambda22__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void graphs_curve_fitting_dialog_emit_add_fit_request (GraphsCurveFittingDialog* self);
static void _graphs_curve_fitting_dialog_emit_add_fit_request_gtk_button_clicked (GtkButton* _sender,
                                                                           gpointer self);
static AdwToastOverlay* graphs_curve_fitting_dialog_get_toast_overlay (GraphsCurveFittingDialog* self);
static void g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data);
static void graphs_curve_fitting_dialog_finalize (GObject * obj);
static GType graphs_curve_fitting_dialog_get_type_once (void);
static void _vala_graphs_curve_fitting_dialog_get_property (GObject * object,
                                                     guint property_id,
                                                     GValue * value,
                                                     GParamSpec * pspec);
static void _vala_graphs_curve_fitting_dialog_set_property (GObject * object,
                                                     guint property_id,
                                                     const GValue * value,
                                                     GParamSpec * pspec);
static GtkLabel* graphs_fitting_parameter_box_get_label (GraphsFittingParameterBox* self);
static void graphs_fitting_parameter_box_finalize (GObject * obj);
static GType graphs_fitting_parameter_box_get_type_once (void);
static void _vala_graphs_fitting_parameter_box_get_property (GObject * object,
                                                      guint property_id,
                                                      GValue * value,
                                                      GParamSpec * pspec);

const gchar* GRAPHS_EQUATIONS[7] = {"a*x+b", "a*x²+b*x+c", "a*exp(b*x)", "a*x^b", "a*log(x)+b", "L/(1+exp(-k*(x-b)))", "a*exp(-(x-mu)²/(2*s²))"};

static inline gpointer
graphs_fitting_parameter_get_instance_private (GraphsFittingParameter* self)
{
	return G_STRUCT_MEMBER_P (self, GraphsFittingParameter_private_offset);
}

GraphsFittingParameter*
graphs_fitting_parameter_construct (GType object_type)
{
	GraphsFittingParameter * self = NULL;
	self = (GraphsFittingParameter*) g_object_new (object_type, NULL);
	return self;
}

GraphsFittingParameter*
graphs_fitting_parameter_new (void)
{
	return graphs_fitting_parameter_construct (GRAPHS_TYPE_FITTING_PARAMETER);
}

const gchar*
graphs_fitting_parameter_get_name (GraphsFittingParameter* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

void
graphs_fitting_parameter_set_name (GraphsFittingParameter* self,
                                   const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_fitting_parameter_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_fitting_parameter_properties[GRAPHS_FITTING_PARAMETER_NAME_PROPERTY]);
	}
}

gdouble
graphs_fitting_parameter_get_initial (GraphsFittingParameter* self)
{
	gdouble result;
	g_return_val_if_fail (self != NULL, 0.0);
	result = self->priv->_initial;
	return result;
}

void
graphs_fitting_parameter_set_initial (GraphsFittingParameter* self,
                                      gdouble value)
{
	gdouble old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_fitting_parameter_get_initial (self);
	if (old_value != value) {
		self->priv->_initial = value;
		g_object_notify_by_pspec ((GObject *) self, graphs_fitting_parameter_properties[GRAPHS_FITTING_PARAMETER_INITIAL_PROPERTY]);
	}
}

const gchar*
graphs_fitting_parameter_get_lower_bound (GraphsFittingParameter* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lower_bound;
	result = _tmp0_;
	return result;
}

void
graphs_fitting_parameter_set_lower_bound (GraphsFittingParameter* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_fitting_parameter_get_lower_bound (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_lower_bound);
		self->priv->_lower_bound = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_fitting_parameter_properties[GRAPHS_FITTING_PARAMETER_LOWER_BOUND_PROPERTY]);
	}
}

const gchar*
graphs_fitting_parameter_get_upper_bound (GraphsFittingParameter* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_upper_bound;
	result = _tmp0_;
	return result;
}

void
graphs_fitting_parameter_set_upper_bound (GraphsFittingParameter* self,
                                          const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_fitting_parameter_get_upper_bound (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_upper_bound);
		self->priv->_upper_bound = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_fitting_parameter_properties[GRAPHS_FITTING_PARAMETER_UPPER_BOUND_PROPERTY]);
	}
}

static void
graphs_fitting_parameter_class_init (GraphsFittingParameterClass * klass,
                                     gpointer klass_data)
{
	graphs_fitting_parameter_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraphsFittingParameter_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_graphs_fitting_parameter_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_graphs_fitting_parameter_set_property;
	G_OBJECT_CLASS (klass)->finalize = graphs_fitting_parameter_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_FITTING_PARAMETER_NAME_PROPERTY, graphs_fitting_parameter_properties[GRAPHS_FITTING_PARAMETER_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_FITTING_PARAMETER_INITIAL_PROPERTY, graphs_fitting_parameter_properties[GRAPHS_FITTING_PARAMETER_INITIAL_PROPERTY] = g_param_spec_double ("initial", "initial", "initial", -G_MAXDOUBLE, G_MAXDOUBLE, 0.0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_FITTING_PARAMETER_LOWER_BOUND_PROPERTY, graphs_fitting_parameter_properties[GRAPHS_FITTING_PARAMETER_LOWER_BOUND_PROPERTY] = g_param_spec_string ("lower-bound", "lower-bound", "lower-bound", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_FITTING_PARAMETER_UPPER_BOUND_PROPERTY, graphs_fitting_parameter_properties[GRAPHS_FITTING_PARAMETER_UPPER_BOUND_PROPERTY] = g_param_spec_string ("upper-bound", "upper-bound", "upper-bound", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}

static void
graphs_fitting_parameter_instance_init (GraphsFittingParameter * self,
                                        gpointer klass)
{
	self->priv = graphs_fitting_parameter_get_instance_private (self);
}

static void
graphs_fitting_parameter_finalize (GObject * obj)
{
	GraphsFittingParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAPHS_TYPE_FITTING_PARAMETER, GraphsFittingParameter);
	_g_free0 (self->priv->_name);
	_g_free0 (self->priv->_lower_bound);
	_g_free0 (self->priv->_upper_bound);
	G_OBJECT_CLASS (graphs_fitting_parameter_parent_class)->finalize (obj);
}

static GType
graphs_fitting_parameter_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraphsFittingParameterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graphs_fitting_parameter_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraphsFittingParameter), 0, (GInstanceInitFunc) graphs_fitting_parameter_instance_init, NULL };
	GType graphs_fitting_parameter_type_id;
	graphs_fitting_parameter_type_id = g_type_register_static (G_TYPE_OBJECT, "GraphsFittingParameter", &g_define_type_info, 0);
	GraphsFittingParameter_private_offset = g_type_add_instance_private (graphs_fitting_parameter_type_id, sizeof (GraphsFittingParameterPrivate));
	return graphs_fitting_parameter_type_id;
}

GType
graphs_fitting_parameter_get_type (void)
{
	static volatile gsize graphs_fitting_parameter_type_id__once = 0;
	if (g_once_init_enter (&graphs_fitting_parameter_type_id__once)) {
		GType graphs_fitting_parameter_type_id;
		graphs_fitting_parameter_type_id = graphs_fitting_parameter_get_type_once ();
		g_once_init_leave (&graphs_fitting_parameter_type_id__once, graphs_fitting_parameter_type_id);
	}
	return graphs_fitting_parameter_type_id__once;
}

static void
_vala_graphs_fitting_parameter_get_property (GObject * object,
                                             guint property_id,
                                             GValue * value,
                                             GParamSpec * pspec)
{
	GraphsFittingParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_FITTING_PARAMETER, GraphsFittingParameter);
	switch (property_id) {
		case GRAPHS_FITTING_PARAMETER_NAME_PROPERTY:
		g_value_set_string (value, graphs_fitting_parameter_get_name (self));
		break;
		case GRAPHS_FITTING_PARAMETER_INITIAL_PROPERTY:
		g_value_set_double (value, graphs_fitting_parameter_get_initial (self));
		break;
		case GRAPHS_FITTING_PARAMETER_LOWER_BOUND_PROPERTY:
		g_value_set_string (value, graphs_fitting_parameter_get_lower_bound (self));
		break;
		case GRAPHS_FITTING_PARAMETER_UPPER_BOUND_PROPERTY:
		g_value_set_string (value, graphs_fitting_parameter_get_upper_bound (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_graphs_fitting_parameter_set_property (GObject * object,
                                             guint property_id,
                                             const GValue * value,
                                             GParamSpec * pspec)
{
	GraphsFittingParameter * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_FITTING_PARAMETER, GraphsFittingParameter);
	switch (property_id) {
		case GRAPHS_FITTING_PARAMETER_NAME_PROPERTY:
		graphs_fitting_parameter_set_name (self, g_value_get_string (value));
		break;
		case GRAPHS_FITTING_PARAMETER_INITIAL_PROPERTY:
		graphs_fitting_parameter_set_initial (self, g_value_get_double (value));
		break;
		case GRAPHS_FITTING_PARAMETER_LOWER_BOUND_PROPERTY:
		graphs_fitting_parameter_set_lower_bound (self, g_value_get_string (value));
		break;
		case GRAPHS_FITTING_PARAMETER_UPPER_BOUND_PROPERTY:
		graphs_fitting_parameter_set_upper_bound (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
graphs_curve_fitting_dialog_get_instance_private (GraphsCurveFittingDialog* self)
{
	return G_STRUCT_MEMBER_P (self, GraphsCurveFittingDialog_private_offset);
}

static void
_graphs_curve_fitting_dialog_emit_fit_curve_request_g_object_notify (GObject* _sender,
                                                                     GParamSpec* pspec,
                                                                     gpointer self)
{
	graphs_curve_fitting_dialog_emit_fit_curve_request ((GraphsCurveFittingDialog*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda21_ (GraphsCurveFittingDialog* self)
{
	gboolean visible = FALSE;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	GraphsFittingParameterBox* entry = NULL;
	GtkBox* _tmp4_;
	GtkWidget* _tmp5_;
	GraphsFittingParameterBox* _tmp6_;
	graphs_curve_fitting_dialog_emit_fit_curve_request (self);
	_tmp0_ = self->priv->_settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "optimization");
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strcmp0 (_tmp2_, "lm") != 0;
	_g_free0 (_tmp2_);
	visible = _tmp3_;
	_tmp4_ = self->priv->_fitting_params_box;
	_tmp5_ = gtk_widget_get_first_child ((GtkWidget*) _tmp4_);
	_tmp6_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GRAPHS_TYPE_FITTING_PARAMETER_BOX, GraphsFittingParameterBox));
	entry = _tmp6_;
	while (TRUE) {
		GraphsFittingParameterBox* _tmp7_;
		GraphsFittingParameterBox* _tmp8_;
		GraphsFittingParameterBox* _tmp9_;
		GtkWidget* _tmp10_;
		GraphsFittingParameterBox* _tmp11_;
		_tmp7_ = entry;
		if (!(_tmp7_ != NULL)) {
			break;
		}
		_tmp8_ = entry;
		graphs_fitting_parameter_box_set_bounds_visible (_tmp8_, visible);
		_tmp9_ = entry;
		_tmp10_ = gtk_widget_get_next_sibling ((GtkWidget*) _tmp9_);
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GRAPHS_TYPE_FITTING_PARAMETER_BOX, GraphsFittingParameterBox));
		_g_object_unref0 (entry);
		entry = _tmp11_;
	}
	_g_object_unref0 (entry);
}

static void
___lambda21__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda21_ ((GraphsCurveFittingDialog*) self);
}

static void
_graphs_curve_fitting_dialog_set_equation_g_object_notify (GObject* _sender,
                                                           GParamSpec* pspec,
                                                           gpointer self)
{
	graphs_curve_fitting_dialog_set_equation ((GraphsCurveFittingDialog*) self);
}

static void
__lambda22_ (GraphsCurveFittingDialog* self)
{
	gboolean success = FALSE;
	AdwEntryRow* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	_tmp0_ = self->priv->_custom_equation;
	_tmp1_ = gtk_editable_get_text ((GtkEditable*) _tmp0_);
	g_signal_emit (self, graphs_curve_fitting_dialog_signals[GRAPHS_CURVE_FITTING_DIALOG_EQUATION_CHANGE_SIGNAL], 0, _tmp1_, &_tmp2_);
	success = _tmp2_;
	if (success) {
		AdwEntryRow* _tmp3_;
		AdwComboRow* _tmp4_;
		_tmp3_ = self->priv->_custom_equation;
		gtk_widget_remove_css_class ((GtkWidget*) _tmp3_, "error");
		_tmp4_ = self->priv->_equation;
		if (adw_combo_row_get_selected (_tmp4_) == ((guint) 7)) {
			GSettings* _tmp5_;
			AdwEntryRow* _tmp6_;
			const gchar* _tmp7_;
			_tmp5_ = self->priv->_settings;
			_tmp6_ = self->priv->_custom_equation;
			_tmp7_ = gtk_editable_get_text ((GtkEditable*) _tmp6_);
			g_settings_set_string (_tmp5_, "custom-equation", _tmp7_);
		}
	} else {
		AdwEntryRow* _tmp8_;
		_tmp8_ = self->priv->_custom_equation;
		gtk_widget_add_css_class ((GtkWidget*) _tmp8_, "error");
	}
}

static void
___lambda22__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda22_ ((GraphsCurveFittingDialog*) self);
}

void
graphs_curve_fitting_dialog_setup (GraphsCurveFittingDialog* self)
{
	GraphsApplication* _tmp0_;
	GSettings* _tmp1_;
	GSettings* _tmp2_;
	GSimpleActionGroup* action_map = NULL;
	GSimpleActionGroup* _tmp3_;
	GAction* confidence_action = NULL;
	GSettings* _tmp4_;
	GAction* _tmp5_;
	GAction* optimization_action = NULL;
	GSettings* _tmp6_;
	GAction* _tmp7_;
	AdwComboRow* _tmp8_;
	GSettings* _tmp9_;
	AdwComboRow* _tmp10_;
	AdwEntryRow* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_application;
	_tmp1_ = graphs_application_get_settings_child (_tmp0_, "curve-fitting");
	_tmp2_ = _tmp1_;
	graphs_curve_fitting_dialog_set_settings (self, _tmp2_);
	_g_object_unref0 (_tmp2_);
	_tmp3_ = g_simple_action_group_new ();
	action_map = _tmp3_;
	_tmp4_ = self->priv->_settings;
	_tmp5_ = g_settings_create_action (_tmp4_, "confidence");
	confidence_action = _tmp5_;
	_tmp6_ = self->priv->_settings;
	_tmp7_ = g_settings_create_action (_tmp6_, "optimization");
	optimization_action = _tmp7_;
	g_signal_connect_object ((GObject*) confidence_action, "notify", (GCallback) _graphs_curve_fitting_dialog_emit_fit_curve_request_g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) optimization_action, "notify", (GCallback) ___lambda21__g_object_notify, self, 0);
	g_action_map_add_action ((GActionMap*) action_map, confidence_action);
	g_action_map_add_action ((GActionMap*) action_map, optimization_action);
	gtk_widget_insert_action_group ((GtkWidget*) self, "win", (GActionGroup*) action_map);
	_tmp8_ = self->priv->_equation;
	_tmp9_ = self->priv->_settings;
	adw_combo_row_set_selected (_tmp8_, (guint) g_settings_get_enum (_tmp9_, "equation"));
	_tmp10_ = self->priv->_equation;
	g_signal_connect_object ((GObject*) _tmp10_, "notify::selected", (GCallback) _graphs_curve_fitting_dialog_set_equation_g_object_notify, self, 0);
	_tmp11_ = self->priv->_custom_equation;
	g_signal_connect_object ((GObject*) _tmp11_, "notify::text", (GCallback) ___lambda22__g_object_notify, self, 0);
	graphs_curve_fitting_dialog_set_equation (self);
	_g_object_unref0 (optimization_action);
	_g_object_unref0 (confidence_action);
	_g_object_unref0 (action_map);
}

static void
graphs_curve_fitting_dialog_emit_fit_curve_request (GraphsCurveFittingDialog* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, graphs_curve_fitting_dialog_signals[GRAPHS_CURVE_FITTING_DIALOG_FIT_CURVE_REQUEST_SIGNAL], 0);
}

static const gchar*
string_to_string (const gchar* self)
{
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}

static void
graphs_curve_fitting_dialog_set_equation (GraphsCurveFittingDialog* self)
{
	gint selected = 0;
	AdwComboRow* _tmp0_;
	GSettings* _tmp1_;
	gchar* equation = NULL;
	AdwEntryRow* _tmp17_;
	const gchar* _tmp18_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_equation;
	selected = (gint) adw_combo_row_get_selected (_tmp0_);
	_tmp1_ = self->priv->_settings;
	if (g_settings_get_enum (_tmp1_, "equation") != selected) {
		GSettings* _tmp2_;
		_tmp2_ = self->priv->_settings;
		g_settings_set_enum (_tmp2_, "equation", selected);
	}
	if (selected != 7) {
		const gchar* _tmp3_;
		gchar* _tmp4_;
		AdwComboRow* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		AdwEntryRow* _tmp10_;
		_tmp3_ = GRAPHS_EQUATIONS[selected];
		_tmp4_ = g_strdup (_tmp3_);
		_g_free0 (equation);
		equation = _tmp4_;
		_tmp5_ = self->priv->_equation;
		_tmp6_ = equation;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat ("Y=", _tmp7_, NULL);
		_tmp9_ = _tmp8_;
		adw_action_row_set_subtitle ((AdwActionRow*) _tmp5_, _tmp9_);
		_g_free0 (_tmp9_);
		_tmp10_ = self->priv->_custom_equation;
		gtk_widget_set_visible ((GtkWidget*) _tmp10_, FALSE);
	} else {
		GSettings* _tmp11_;
		gchar* _tmp12_;
		AdwComboRow* _tmp13_;
		GSettings* _tmp14_;
		const gchar* _tmp15_;
		AdwEntryRow* _tmp16_;
		_tmp11_ = self->priv->_settings;
		_tmp12_ = g_settings_get_string (_tmp11_, "custom-equation");
		_g_free0 (equation);
		equation = _tmp12_;
		_tmp13_ = self->priv->_equation;
		adw_action_row_set_subtitle ((AdwActionRow*) _tmp13_, "");
		_tmp14_ = self->priv->_settings;
		_tmp15_ = equation;
		g_settings_set_string (_tmp14_, "custom-equation", _tmp15_);
		_tmp16_ = self->priv->_custom_equation;
		gtk_widget_set_visible ((GtkWidget*) _tmp16_, TRUE);
	}
	_tmp17_ = self->priv->_custom_equation;
	_tmp18_ = equation;
	gtk_editable_set_text ((GtkEditable*) _tmp17_, _tmp18_);
	_g_free0 (equation);
}

static void
graphs_curve_fitting_dialog_emit_add_fit_request (GraphsCurveFittingDialog* self)
{
	g_return_if_fail (self != NULL);
	g_signal_emit (self, graphs_curve_fitting_dialog_signals[GRAPHS_CURVE_FITTING_DIALOG_ADD_FIT_REQUEST_SIGNAL], 0);
}

static void
_graphs_curve_fitting_dialog_emit_add_fit_request_gtk_button_clicked (GtkButton* _sender,
                                                                      gpointer self)
{
	graphs_curve_fitting_dialog_emit_add_fit_request ((GraphsCurveFittingDialog*) self);
}

GraphsCurveFittingDialog*
graphs_curve_fitting_dialog_construct (GType object_type)
{
	GraphsCurveFittingDialog * self = NULL;
	self = (GraphsCurveFittingDialog*) g_object_new (object_type, NULL);
	return self;
}

GraphsCurveFittingDialog*
graphs_curve_fitting_dialog_new (void)
{
	return graphs_curve_fitting_dialog_construct (GRAPHS_TYPE_CURVE_FITTING_DIALOG);
}

static AdwComboRow*
graphs_curve_fitting_dialog_get_equation (GraphsCurveFittingDialog* self)
{
	AdwComboRow* result;
	AdwComboRow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation;
	result = _tmp0_;
	return result;
}

AdwEntryRow*
graphs_curve_fitting_dialog_get_custom_equation (GraphsCurveFittingDialog* self)
{
	AdwEntryRow* result;
	AdwEntryRow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_custom_equation;
	result = _tmp0_;
	return result;
}

GtkBox*
graphs_curve_fitting_dialog_get_fitting_params_box (GraphsCurveFittingDialog* self)
{
	GtkBox* result;
	GtkBox* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_fitting_params_box;
	result = _tmp0_;
	return result;
}

GtkTextView*
graphs_curve_fitting_dialog_get_text_view (GraphsCurveFittingDialog* self)
{
	GtkTextView* result;
	GtkTextView* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_text_view;
	result = _tmp0_;
	return result;
}

static AdwToastOverlay*
graphs_curve_fitting_dialog_get_toast_overlay (GraphsCurveFittingDialog* self)
{
	AdwToastOverlay* result;
	AdwToastOverlay* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_toast_overlay;
	result = _tmp0_;
	return result;
}

GraphsApplication*
graphs_curve_fitting_dialog_get_application (GraphsCurveFittingDialog* self)
{
	GraphsApplication* result;
	GraphsApplication* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_application;
	result = _tmp0_;
	return result;
}

void
graphs_curve_fitting_dialog_set_application (GraphsCurveFittingDialog* self,
                                             GraphsApplication* value)
{
	GraphsApplication* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_curve_fitting_dialog_get_application (self);
	if (old_value != value) {
		GraphsApplication* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_application);
		self->priv->_application = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_curve_fitting_dialog_properties[GRAPHS_CURVE_FITTING_DIALOG_APPLICATION_PROPERTY]);
	}
}

GSettings*
graphs_curve_fitting_dialog_get_settings (GraphsCurveFittingDialog* self)
{
	GSettings* result;
	GSettings* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_settings;
	result = _tmp0_;
	return result;
}

static void
graphs_curve_fitting_dialog_set_settings (GraphsCurveFittingDialog* self,
                                          GSettings* value)
{
	GSettings* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_curve_fitting_dialog_get_settings (self);
	if (old_value != value) {
		GSettings* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_settings);
		self->priv->_settings = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_curve_fitting_dialog_properties[GRAPHS_CURVE_FITTING_DIALOG_SETTINGS_PROPERTY]);
	}
}

const gchar*
graphs_curve_fitting_dialog_get_equation_string (GraphsCurveFittingDialog* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_equation_string;
	result = _tmp0_;
	return result;
}

void
graphs_curve_fitting_dialog_set_equation_string (GraphsCurveFittingDialog* self,
                                                 const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = graphs_curve_fitting_dialog_get_equation_string (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_equation_string);
		self->priv->_equation_string = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, graphs_curve_fitting_dialog_properties[GRAPHS_CURVE_FITTING_DIALOG_EQUATION_STRING_PROPERTY]);
	}
}

GraphsCanvas*
graphs_curve_fitting_dialog_get_canvas (GraphsCurveFittingDialog* self)
{
	GraphsCanvas* result;
	AdwToastOverlay* _tmp0_;
	GtkWidget* _tmp1_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_toast_overlay;
	_tmp1_ = adw_toast_overlay_get_child (_tmp0_);
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GRAPHS_TYPE_CANVAS, GraphsCanvas);
	return result;
}

void
graphs_curve_fitting_dialog_set_canvas (GraphsCurveFittingDialog* self,
                                        GraphsCanvas* value)
{
	AdwToastOverlay* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_toast_overlay;
	adw_toast_overlay_set_child (_tmp0_, (GtkWidget*) value);
	g_object_notify_by_pspec ((GObject *) self, graphs_curve_fitting_dialog_properties[GRAPHS_CURVE_FITTING_DIALOG_CANVAS_PROPERTY]);
}

static void
g_cclosure_user_marshal_BOOLEAN__STRING (GClosure * closure,
                                         GValue * return_value,
                                         guint n_param_values,
                                         const GValue * param_values,
                                         gpointer invocation_hint,
                                         gpointer marshal_data)
{
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING) (gpointer data1, const char* arg_1, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__STRING) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), data2);
	g_value_set_boolean (return_value, v_return);
}

static void
graphs_curve_fitting_dialog_class_init (GraphsCurveFittingDialogClass * klass,
                                        gpointer klass_data)
{
	graphs_curve_fitting_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraphsCurveFittingDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_graphs_curve_fitting_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_graphs_curve_fitting_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = graphs_curve_fitting_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_CURVE_FITTING_DIALOG_CUSTOM_EQUATION_PROPERTY, graphs_curve_fitting_dialog_properties[GRAPHS_CURVE_FITTING_DIALOG_CUSTOM_EQUATION_PROPERTY] = g_param_spec_object ("custom-equation", "custom-equation", "custom-equation", adw_entry_row_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_CURVE_FITTING_DIALOG_FITTING_PARAMS_BOX_PROPERTY, graphs_curve_fitting_dialog_properties[GRAPHS_CURVE_FITTING_DIALOG_FITTING_PARAMS_BOX_PROPERTY] = g_param_spec_object ("fitting-params-box", "fitting-params-box", "fitting-params-box", gtk_box_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_CURVE_FITTING_DIALOG_TEXT_VIEW_PROPERTY, graphs_curve_fitting_dialog_properties[GRAPHS_CURVE_FITTING_DIALOG_TEXT_VIEW_PROPERTY] = g_param_spec_object ("text-view", "text-view", "text-view", gtk_text_view_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_CURVE_FITTING_DIALOG_APPLICATION_PROPERTY, graphs_curve_fitting_dialog_properties[GRAPHS_CURVE_FITTING_DIALOG_APPLICATION_PROPERTY] = g_param_spec_object ("application", "application", "application", GRAPHS_TYPE_APPLICATION, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_CURVE_FITTING_DIALOG_SETTINGS_PROPERTY, graphs_curve_fitting_dialog_properties[GRAPHS_CURVE_FITTING_DIALOG_SETTINGS_PROPERTY] = g_param_spec_object ("settings", "settings", "settings", g_settings_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_CURVE_FITTING_DIALOG_EQUATION_STRING_PROPERTY, graphs_curve_fitting_dialog_properties[GRAPHS_CURVE_FITTING_DIALOG_EQUATION_STRING_PROPERTY] = g_param_spec_string ("equation-string", "equation-string", "equation-string", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_CURVE_FITTING_DIALOG_CANVAS_PROPERTY, graphs_curve_fitting_dialog_properties[GRAPHS_CURVE_FITTING_DIALOG_CANVAS_PROPERTY] = g_param_spec_object ("canvas", "canvas", "canvas", GRAPHS_TYPE_CANVAS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/se/sjoerd/Graphs/ui/curve-fitting.ui");
	graphs_curve_fitting_dialog_signals[GRAPHS_CURVE_FITTING_DIALOG_EQUATION_CHANGE_SIGNAL] = g_signal_new ("equation-change", GRAPHS_TYPE_CURVE_FITTING_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING, G_TYPE_BOOLEAN, 1, G_TYPE_STRING);
	graphs_curve_fitting_dialog_signals[GRAPHS_CURVE_FITTING_DIALOG_FIT_CURVE_REQUEST_SIGNAL] = g_signal_new ("fit-curve-request", GRAPHS_TYPE_CURVE_FITTING_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	graphs_curve_fitting_dialog_signals[GRAPHS_CURVE_FITTING_DIALOG_ADD_FIT_REQUEST_SIGNAL] = g_signal_new ("add-fit-request", GRAPHS_TYPE_CURVE_FITTING_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "equation", FALSE, GraphsCurveFittingDialog_private_offset + G_STRUCT_OFFSET (GraphsCurveFittingDialogPrivate, _equation));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "custom_equation", FALSE, GraphsCurveFittingDialog_private_offset + G_STRUCT_OFFSET (GraphsCurveFittingDialogPrivate, _custom_equation));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "fitting_params_box", FALSE, GraphsCurveFittingDialog_private_offset + G_STRUCT_OFFSET (GraphsCurveFittingDialogPrivate, _fitting_params_box));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "text_view", FALSE, GraphsCurveFittingDialog_private_offset + G_STRUCT_OFFSET (GraphsCurveFittingDialogPrivate, _text_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "toast_overlay", FALSE, GraphsCurveFittingDialog_private_offset + G_STRUCT_OFFSET (GraphsCurveFittingDialogPrivate, _toast_overlay));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "emit_add_fit_request", G_CALLBACK(_graphs_curve_fitting_dialog_emit_add_fit_request_gtk_button_clicked));
}

static void
graphs_curve_fitting_dialog_instance_init (GraphsCurveFittingDialog * self,
                                           gpointer klass)
{
	self->priv = graphs_curve_fitting_dialog_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
graphs_curve_fitting_dialog_finalize (GObject * obj)
{
	GraphsCurveFittingDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAPHS_TYPE_CURVE_FITTING_DIALOG, GraphsCurveFittingDialog);
	_g_object_unref0 (self->priv->_application);
	_g_object_unref0 (self->priv->_settings);
	_g_free0 (self->priv->_equation_string);
	G_OBJECT_CLASS (graphs_curve_fitting_dialog_parent_class)->finalize (obj);
}

/**
     * Curve fitting dialog.
     */
static GType
graphs_curve_fitting_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraphsCurveFittingDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graphs_curve_fitting_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraphsCurveFittingDialog), 0, (GInstanceInitFunc) graphs_curve_fitting_dialog_instance_init, NULL };
	GType graphs_curve_fitting_dialog_type_id;
	graphs_curve_fitting_dialog_type_id = g_type_register_static (adw_dialog_get_type (), "GraphsCurveFittingDialog", &g_define_type_info, 0);
	GraphsCurveFittingDialog_private_offset = g_type_add_instance_private (graphs_curve_fitting_dialog_type_id, sizeof (GraphsCurveFittingDialogPrivate));
	return graphs_curve_fitting_dialog_type_id;
}

GType
graphs_curve_fitting_dialog_get_type (void)
{
	static volatile gsize graphs_curve_fitting_dialog_type_id__once = 0;
	if (g_once_init_enter (&graphs_curve_fitting_dialog_type_id__once)) {
		GType graphs_curve_fitting_dialog_type_id;
		graphs_curve_fitting_dialog_type_id = graphs_curve_fitting_dialog_get_type_once ();
		g_once_init_leave (&graphs_curve_fitting_dialog_type_id__once, graphs_curve_fitting_dialog_type_id);
	}
	return graphs_curve_fitting_dialog_type_id__once;
}

static void
_vala_graphs_curve_fitting_dialog_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec)
{
	GraphsCurveFittingDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_CURVE_FITTING_DIALOG, GraphsCurveFittingDialog);
	switch (property_id) {
		case GRAPHS_CURVE_FITTING_DIALOG_CUSTOM_EQUATION_PROPERTY:
		g_value_set_object (value, graphs_curve_fitting_dialog_get_custom_equation (self));
		break;
		case GRAPHS_CURVE_FITTING_DIALOG_FITTING_PARAMS_BOX_PROPERTY:
		g_value_set_object (value, graphs_curve_fitting_dialog_get_fitting_params_box (self));
		break;
		case GRAPHS_CURVE_FITTING_DIALOG_TEXT_VIEW_PROPERTY:
		g_value_set_object (value, graphs_curve_fitting_dialog_get_text_view (self));
		break;
		case GRAPHS_CURVE_FITTING_DIALOG_APPLICATION_PROPERTY:
		g_value_set_object (value, graphs_curve_fitting_dialog_get_application (self));
		break;
		case GRAPHS_CURVE_FITTING_DIALOG_SETTINGS_PROPERTY:
		g_value_set_object (value, graphs_curve_fitting_dialog_get_settings (self));
		break;
		case GRAPHS_CURVE_FITTING_DIALOG_EQUATION_STRING_PROPERTY:
		g_value_set_string (value, graphs_curve_fitting_dialog_get_equation_string (self));
		break;
		case GRAPHS_CURVE_FITTING_DIALOG_CANVAS_PROPERTY:
		g_value_set_object (value, graphs_curve_fitting_dialog_get_canvas (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_graphs_curve_fitting_dialog_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec)
{
	GraphsCurveFittingDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_CURVE_FITTING_DIALOG, GraphsCurveFittingDialog);
	switch (property_id) {
		case GRAPHS_CURVE_FITTING_DIALOG_APPLICATION_PROPERTY:
		graphs_curve_fitting_dialog_set_application (self, g_value_get_object (value));
		break;
		case GRAPHS_CURVE_FITTING_DIALOG_SETTINGS_PROPERTY:
		graphs_curve_fitting_dialog_set_settings (self, g_value_get_object (value));
		break;
		case GRAPHS_CURVE_FITTING_DIALOG_EQUATION_STRING_PROPERTY:
		graphs_curve_fitting_dialog_set_equation_string (self, g_value_get_string (value));
		break;
		case GRAPHS_CURVE_FITTING_DIALOG_CANVAS_PROPERTY:
		graphs_curve_fitting_dialog_set_canvas (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
graphs_fitting_parameter_box_get_instance_private (GraphsFittingParameterBox* self)
{
	return G_STRUCT_MEMBER_P (self, GraphsFittingParameterBox_private_offset);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

GraphsFittingParameterBox*
graphs_fitting_parameter_box_construct (GType object_type,
                                        GraphsFittingParameter* param)
{
	GraphsFittingParameterBox * self = NULL;
	gchar* msg = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GtkLabel* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	AdwEntryRow* _tmp7_;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	g_return_val_if_fail (param != NULL, NULL);
	self = (GraphsFittingParameterBox*) g_object_new (object_type, NULL);
	_tmp0_ = graphs_fitting_parameter_get_name (param);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf (_ ("Fitting Parameters for %s"), _tmp1_);
	msg = _tmp2_;
	_tmp3_ = self->priv->_label;
	_tmp4_ = string_to_string (msg);
	_tmp5_ = g_strconcat ("<b> ", _tmp4_, ": </b>", NULL);
	_tmp6_ = _tmp5_;
	gtk_label_set_markup (_tmp3_, _tmp6_);
	_g_free0 (_tmp6_);
	_tmp7_ = self->priv->_initial;
	_tmp8_ = graphs_fitting_parameter_get_initial (param);
	_tmp9_ = _tmp8_;
	_tmp10_ = double_to_string (_tmp9_);
	_tmp11_ = _tmp10_;
	gtk_editable_set_text ((GtkEditable*) _tmp7_, _tmp11_);
	_g_free0 (_tmp11_);
	_g_free0 (msg);
	return self;
}

GraphsFittingParameterBox*
graphs_fitting_parameter_box_new (GraphsFittingParameter* param)
{
	return graphs_fitting_parameter_box_construct (GRAPHS_TYPE_FITTING_PARAMETER_BOX, param);
}

void
graphs_fitting_parameter_box_set_bounds_visible (GraphsFittingParameterBox* self,
                                                 gboolean visible)
{
	AdwEntryRow* _tmp0_;
	AdwEntryRow* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_upper_bound;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, visible);
	_tmp1_ = self->priv->_lower_bound;
	gtk_widget_set_visible ((GtkWidget*) _tmp1_, visible);
}

static GtkLabel*
graphs_fitting_parameter_box_get_label (GraphsFittingParameterBox* self)
{
	GtkLabel* result;
	GtkLabel* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_label;
	result = _tmp0_;
	return result;
}

AdwEntryRow*
graphs_fitting_parameter_box_get_initial (GraphsFittingParameterBox* self)
{
	AdwEntryRow* result;
	AdwEntryRow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_initial;
	result = _tmp0_;
	return result;
}

AdwEntryRow*
graphs_fitting_parameter_box_get_upper_bound (GraphsFittingParameterBox* self)
{
	AdwEntryRow* result;
	AdwEntryRow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_upper_bound;
	result = _tmp0_;
	return result;
}

AdwEntryRow*
graphs_fitting_parameter_box_get_lower_bound (GraphsFittingParameterBox* self)
{
	AdwEntryRow* result;
	AdwEntryRow* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_lower_bound;
	result = _tmp0_;
	return result;
}

static void
graphs_fitting_parameter_box_class_init (GraphsFittingParameterBoxClass * klass,
                                         gpointer klass_data)
{
	graphs_fitting_parameter_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &GraphsFittingParameterBox_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_graphs_fitting_parameter_box_get_property;
	G_OBJECT_CLASS (klass)->finalize = graphs_fitting_parameter_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_FITTING_PARAMETER_BOX_INITIAL_PROPERTY, graphs_fitting_parameter_box_properties[GRAPHS_FITTING_PARAMETER_BOX_INITIAL_PROPERTY] = g_param_spec_object ("initial", "initial", "initial", adw_entry_row_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_FITTING_PARAMETER_BOX_UPPER_BOUND_PROPERTY, graphs_fitting_parameter_box_properties[GRAPHS_FITTING_PARAMETER_BOX_UPPER_BOUND_PROPERTY] = g_param_spec_object ("upper-bound", "upper-bound", "upper-bound", adw_entry_row_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GRAPHS_FITTING_PARAMETER_BOX_LOWER_BOUND_PROPERTY, graphs_fitting_parameter_box_properties[GRAPHS_FITTING_PARAMETER_BOX_LOWER_BOUND_PROPERTY] = g_param_spec_object ("lower-bound", "lower-bound", "lower-bound", adw_entry_row_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/se/sjoerd/Graphs/ui/fitting-parameters.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "label", FALSE, GraphsFittingParameterBox_private_offset + G_STRUCT_OFFSET (GraphsFittingParameterBoxPrivate, _label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "initial", FALSE, GraphsFittingParameterBox_private_offset + G_STRUCT_OFFSET (GraphsFittingParameterBoxPrivate, _initial));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "upper_bound", FALSE, GraphsFittingParameterBox_private_offset + G_STRUCT_OFFSET (GraphsFittingParameterBoxPrivate, _upper_bound));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "lower_bound", FALSE, GraphsFittingParameterBox_private_offset + G_STRUCT_OFFSET (GraphsFittingParameterBoxPrivate, _lower_bound));
}

static void
graphs_fitting_parameter_box_instance_init (GraphsFittingParameterBox * self,
                                            gpointer klass)
{
	self->priv = graphs_fitting_parameter_box_get_instance_private (self);
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
graphs_fitting_parameter_box_finalize (GObject * obj)
{
	GraphsFittingParameterBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GRAPHS_TYPE_FITTING_PARAMETER_BOX, GraphsFittingParameterBox);
	G_OBJECT_CLASS (graphs_fitting_parameter_box_parent_class)->finalize (obj);
}

static GType
graphs_fitting_parameter_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (GraphsFittingParameterBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) graphs_fitting_parameter_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GraphsFittingParameterBox), 0, (GInstanceInitFunc) graphs_fitting_parameter_box_instance_init, NULL };
	GType graphs_fitting_parameter_box_type_id;
	graphs_fitting_parameter_box_type_id = g_type_register_static (gtk_box_get_type (), "GraphsFittingParameterBox", &g_define_type_info, 0);
	GraphsFittingParameterBox_private_offset = g_type_add_instance_private (graphs_fitting_parameter_box_type_id, sizeof (GraphsFittingParameterBoxPrivate));
	return graphs_fitting_parameter_box_type_id;
}

GType
graphs_fitting_parameter_box_get_type (void)
{
	static volatile gsize graphs_fitting_parameter_box_type_id__once = 0;
	if (g_once_init_enter (&graphs_fitting_parameter_box_type_id__once)) {
		GType graphs_fitting_parameter_box_type_id;
		graphs_fitting_parameter_box_type_id = graphs_fitting_parameter_box_get_type_once ();
		g_once_init_leave (&graphs_fitting_parameter_box_type_id__once, graphs_fitting_parameter_box_type_id);
	}
	return graphs_fitting_parameter_box_type_id__once;
}

static void
_vala_graphs_fitting_parameter_box_get_property (GObject * object,
                                                 guint property_id,
                                                 GValue * value,
                                                 GParamSpec * pspec)
{
	GraphsFittingParameterBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GRAPHS_TYPE_FITTING_PARAMETER_BOX, GraphsFittingParameterBox);
	switch (property_id) {
		case GRAPHS_FITTING_PARAMETER_BOX_INITIAL_PROPERTY:
		g_value_set_object (value, graphs_fitting_parameter_box_get_initial (self));
		break;
		case GRAPHS_FITTING_PARAMETER_BOX_UPPER_BOUND_PROPERTY:
		g_value_set_object (value, graphs_fitting_parameter_box_get_upper_bound (self));
		break;
		case GRAPHS_FITTING_PARAMETER_BOX_LOWER_BOUND_PROPERTY:
		g_value_set_object (value, graphs_fitting_parameter_box_get_lower_bound (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

