{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- Represents the target of an ongoing DND operation.
-- 
-- Possible drop sites get informed about the status of the ongoing drag
-- operation with events of type @GDK_DRAG_ENTER@, @GDK_DRAG_LEAVE@,
-- @GDK_DRAG_MOTION@ and @GDK_DROP_START@. The @GdkDrop@ object can be obtained
-- from these t'GI.Gdk.Objects.Event.Event' types using 'GI.Gdk.Objects.DNDEvent.dNDEventGetDrop'.
-- 
-- The actual data transfer is initiated from the target side via an async
-- read, using one of the @GdkDrop@ methods for this purpose:
-- 'GI.Gdk.Objects.Drop.dropReadAsync' or 'GI.Gdk.Objects.Drop.dropReadValueAsync'.
-- 
-- GTK provides a higher level abstraction based on top of these functions,
-- and so they are not normally needed in GTK applications. See the
-- \"Drag and Drop\" section of the GTK documentation for more information.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gdk.Objects.Drop
    ( 

-- * Exported types
    Drop(..)                                ,
    IsDrop                                  ,
    toDrop                                  ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [bindProperty]("GI.GObject.Objects.Object#g:method:bindProperty"), [bindPropertyFull]("GI.GObject.Objects.Object#g:method:bindPropertyFull"), [finish]("GI.Gdk.Objects.Drop#g:method:finish"), [forceFloating]("GI.GObject.Objects.Object#g:method:forceFloating"), [freezeNotify]("GI.GObject.Objects.Object#g:method:freezeNotify"), [getv]("GI.GObject.Objects.Object#g:method:getv"), [isFloating]("GI.GObject.Objects.Object#g:method:isFloating"), [notify]("GI.GObject.Objects.Object#g:method:notify"), [notifyByPspec]("GI.GObject.Objects.Object#g:method:notifyByPspec"), [readAsync]("GI.Gdk.Objects.Drop#g:method:readAsync"), [readFinish]("GI.Gdk.Objects.Drop#g:method:readFinish"), [readValueAsync]("GI.Gdk.Objects.Drop#g:method:readValueAsync"), [readValueFinish]("GI.Gdk.Objects.Drop#g:method:readValueFinish"), [ref]("GI.GObject.Objects.Object#g:method:ref"), [refSink]("GI.GObject.Objects.Object#g:method:refSink"), [runDispose]("GI.GObject.Objects.Object#g:method:runDispose"), [status]("GI.Gdk.Objects.Drop#g:method:status"), [stealData]("GI.GObject.Objects.Object#g:method:stealData"), [stealQdata]("GI.GObject.Objects.Object#g:method:stealQdata"), [thawNotify]("GI.GObject.Objects.Object#g:method:thawNotify"), [unref]("GI.GObject.Objects.Object#g:method:unref"), [watchClosure]("GI.GObject.Objects.Object#g:method:watchClosure").
-- 
-- ==== Getters
-- [getActions]("GI.Gdk.Objects.Drop#g:method:getActions"), [getData]("GI.GObject.Objects.Object#g:method:getData"), [getDevice]("GI.Gdk.Objects.Drop#g:method:getDevice"), [getDisplay]("GI.Gdk.Objects.Drop#g:method:getDisplay"), [getDrag]("GI.Gdk.Objects.Drop#g:method:getDrag"), [getFormats]("GI.Gdk.Objects.Drop#g:method:getFormats"), [getProperty]("GI.GObject.Objects.Object#g:method:getProperty"), [getQdata]("GI.GObject.Objects.Object#g:method:getQdata"), [getSurface]("GI.Gdk.Objects.Drop#g:method:getSurface").
-- 
-- ==== Setters
-- [setData]("GI.GObject.Objects.Object#g:method:setData"), [setDataFull]("GI.GObject.Objects.Object#g:method:setDataFull"), [setProperty]("GI.GObject.Objects.Object#g:method:setProperty").

#if defined(ENABLE_OVERLOADING)
    ResolveDropMethod                       ,
#endif

-- ** finish #method:finish#

#if defined(ENABLE_OVERLOADING)
    DropFinishMethodInfo                    ,
#endif
    dropFinish                              ,


-- ** getActions #method:getActions#

#if defined(ENABLE_OVERLOADING)
    DropGetActionsMethodInfo                ,
#endif
    dropGetActions                          ,


-- ** getDevice #method:getDevice#

#if defined(ENABLE_OVERLOADING)
    DropGetDeviceMethodInfo                 ,
#endif
    dropGetDevice                           ,


-- ** getDisplay #method:getDisplay#

#if defined(ENABLE_OVERLOADING)
    DropGetDisplayMethodInfo                ,
#endif
    dropGetDisplay                          ,


-- ** getDrag #method:getDrag#

#if defined(ENABLE_OVERLOADING)
    DropGetDragMethodInfo                   ,
#endif
    dropGetDrag                             ,


-- ** getFormats #method:getFormats#

#if defined(ENABLE_OVERLOADING)
    DropGetFormatsMethodInfo                ,
#endif
    dropGetFormats                          ,


-- ** getSurface #method:getSurface#

#if defined(ENABLE_OVERLOADING)
    DropGetSurfaceMethodInfo                ,
#endif
    dropGetSurface                          ,


-- ** readAsync #method:readAsync#

#if defined(ENABLE_OVERLOADING)
    DropReadAsyncMethodInfo                 ,
#endif
    dropReadAsync                           ,


-- ** readFinish #method:readFinish#

#if defined(ENABLE_OVERLOADING)
    DropReadFinishMethodInfo                ,
#endif
    dropReadFinish                          ,


-- ** readValueAsync #method:readValueAsync#

#if defined(ENABLE_OVERLOADING)
    DropReadValueAsyncMethodInfo            ,
#endif
    dropReadValueAsync                      ,


-- ** readValueFinish #method:readValueFinish#

#if defined(ENABLE_OVERLOADING)
    DropReadValueFinishMethodInfo           ,
#endif
    dropReadValueFinish                     ,


-- ** status #method:status#

#if defined(ENABLE_OVERLOADING)
    DropStatusMethodInfo                    ,
#endif
    dropStatus                              ,




 -- * Properties


-- ** actions #attr:actions#
-- | The possible actions for this drop

#if defined(ENABLE_OVERLOADING)
    DropActionsPropertyInfo                 ,
#endif
    constructDropActions                    ,
#if defined(ENABLE_OVERLOADING)
    dropActions                             ,
#endif
    getDropActions                          ,


-- ** device #attr:device#
-- | The @GdkDevice@ performing the drop

#if defined(ENABLE_OVERLOADING)
    DropDevicePropertyInfo                  ,
#endif
    constructDropDevice                     ,
#if defined(ENABLE_OVERLOADING)
    dropDevice                              ,
#endif
    getDropDevice                           ,


-- ** display #attr:display#
-- | The @GdkDisplay@ that the drop belongs to.

#if defined(ENABLE_OVERLOADING)
    DropDisplayPropertyInfo                 ,
#endif
#if defined(ENABLE_OVERLOADING)
    dropDisplay                             ,
#endif
    getDropDisplay                          ,


-- ** drag #attr:drag#
-- | The @GdkDrag@ that initiated this drop

#if defined(ENABLE_OVERLOADING)
    DropDragPropertyInfo                    ,
#endif
    constructDropDrag                       ,
#if defined(ENABLE_OVERLOADING)
    dropDrag                                ,
#endif
    getDropDrag                             ,


-- ** formats #attr:formats#
-- | The possible formats that the drop can provide its data in.

#if defined(ENABLE_OVERLOADING)
    DropFormatsPropertyInfo                 ,
#endif
    constructDropFormats                    ,
#if defined(ENABLE_OVERLOADING)
    dropFormats                             ,
#endif
    getDropFormats                          ,


-- ** surface #attr:surface#
-- | The @GdkSurface@ the drop happens on

#if defined(ENABLE_OVERLOADING)
    DropSurfacePropertyInfo                 ,
#endif
    constructDropSurface                    ,
#if defined(ENABLE_OVERLOADING)
    dropSurface                             ,
#endif
    getDropSurface                          ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Enums as Cairo.Enums
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.Cairo.Structs.Region as Cairo.Region
import qualified GI.Cairo.Structs.Surface as Cairo.Surface
import qualified GI.GLib.Callbacks as GLib.Callbacks
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.GLib.Structs.String as GLib.String
import qualified GI.GObject.Objects.Object as GObject.Object
import qualified GI.Gdk.Callbacks as Gdk.Callbacks
import {-# SOURCE #-} qualified GI.Gdk.Enums as Gdk.Enums
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Interfaces.Paintable as Gdk.Paintable
import {-# SOURCE #-} qualified GI.Gdk.Objects.AppLaunchContext as Gdk.AppLaunchContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CairoContext as Gdk.CairoContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.CicpParams as Gdk.CicpParams
import {-# SOURCE #-} qualified GI.Gdk.Objects.Clipboard as Gdk.Clipboard
import {-# SOURCE #-} qualified GI.Gdk.Objects.ContentProvider as Gdk.ContentProvider
import {-# SOURCE #-} qualified GI.Gdk.Objects.Cursor as Gdk.Cursor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.DeviceTool as Gdk.DeviceTool
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.Drag as Gdk.Drag
import {-# SOURCE #-} qualified GI.Gdk.Objects.DrawContext as Gdk.DrawContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Event as Gdk.Event
import {-# SOURCE #-} qualified GI.Gdk.Objects.FrameClock as Gdk.FrameClock
import {-# SOURCE #-} qualified GI.Gdk.Objects.GLContext as Gdk.GLContext
import {-# SOURCE #-} qualified GI.Gdk.Objects.Monitor as Gdk.Monitor
import {-# SOURCE #-} qualified GI.Gdk.Objects.Seat as Gdk.Seat
import {-# SOURCE #-} qualified GI.Gdk.Objects.Snapshot as Gdk.Snapshot
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Objects.Texture as Gdk.Texture
import {-# SOURCE #-} qualified GI.Gdk.Objects.VulkanContext as Gdk.VulkanContext
import {-# SOURCE #-} qualified GI.Gdk.Structs.ColorState as Gdk.ColorState
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.DmabufFormats as Gdk.DmabufFormats
import {-# SOURCE #-} qualified GI.Gdk.Structs.EventSequence as Gdk.EventSequence
import {-# SOURCE #-} qualified GI.Gdk.Structs.FrameTimings as Gdk.FrameTimings
import {-# SOURCE #-} qualified GI.Gdk.Structs.KeymapKey as Gdk.KeymapKey
import {-# SOURCE #-} qualified GI.Gdk.Structs.Rectangle as Gdk.Rectangle
import {-# SOURCE #-} qualified GI.Gdk.Structs.TimeCoord as Gdk.TimeCoord
import qualified GI.GdkPixbuf.Objects.Pixbuf as GdkPixbuf.Pixbuf
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Interfaces.File as Gio.File
import qualified GI.Gio.Interfaces.Icon as Gio.Icon
import qualified GI.Gio.Interfaces.ListModel as Gio.ListModel
import qualified GI.Gio.Interfaces.LoadableIcon as Gio.LoadableIcon
import qualified GI.Gio.Objects.AppLaunchContext as Gio.AppLaunchContext
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream
import qualified GI.Gio.Objects.OutputStream as Gio.OutputStream
import qualified GI.Pango.Enums as Pango.Enums

#else
import qualified GI.GObject.Objects.Object as GObject.Object
import {-# SOURCE #-} qualified GI.Gdk.Flags as Gdk.Flags
import {-# SOURCE #-} qualified GI.Gdk.Objects.Device as Gdk.Device
import {-# SOURCE #-} qualified GI.Gdk.Objects.Display as Gdk.Display
import {-# SOURCE #-} qualified GI.Gdk.Objects.Drag as Gdk.Drag
import {-# SOURCE #-} qualified GI.Gdk.Objects.Surface as Gdk.Surface
import {-# SOURCE #-} qualified GI.Gdk.Structs.ContentFormats as Gdk.ContentFormats
import qualified GI.Gio.Callbacks as Gio.Callbacks
import qualified GI.Gio.Interfaces.AsyncResult as Gio.AsyncResult
import qualified GI.Gio.Objects.Cancellable as Gio.Cancellable
import qualified GI.Gio.Objects.InputStream as Gio.InputStream

#endif

-- | Memory-managed wrapper type.
newtype Drop = Drop (SP.ManagedPtr Drop)
    deriving (Eq)

instance SP.ManagedPtrNewtype Drop where
    toManagedPtr (Drop p) = p

foreign import ccall "gdk_drop_get_type"
    c_gdk_drop_get_type :: IO B.Types.GType

instance B.Types.TypedObject Drop where
    glibType = c_gdk_drop_get_type

instance B.Types.GObject Drop

-- | Type class for types which can be safely cast to t'Drop', for instance with `toDrop`.
class (SP.GObject o, O.IsDescendantOf Drop o) => IsDrop o
instance (SP.GObject o, O.IsDescendantOf Drop o) => IsDrop o

instance O.HasParentTypes Drop
type instance O.ParentTypes Drop = '[GObject.Object.Object]

-- | Cast to t'Drop', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toDrop :: (MIO.MonadIO m, IsDrop o) => o -> m Drop
toDrop = MIO.liftIO . B.ManagedPtr.unsafeCastTo Drop

-- | Convert t'Drop' to and from t'Data.GI.Base.GValue.GValue'. See 'Data.GI.Base.GValue.toGValue' and 'Data.GI.Base.GValue.fromGValue'.
instance B.GValue.IsGValue (Maybe Drop) where
    gvalueGType_ = c_gdk_drop_get_type
    gvalueSet_ gv P.Nothing = B.GValue.set_object gv (FP.nullPtr :: FP.Ptr Drop)
    gvalueSet_ gv (P.Just obj) = B.ManagedPtr.withManagedPtr obj (B.GValue.set_object gv)
    gvalueGet_ gv = do
        ptr <- B.GValue.get_object gv :: IO (FP.Ptr Drop)
        if ptr /= FP.nullPtr
        then P.Just <$> B.ManagedPtr.newObject Drop ptr
        else return P.Nothing
        
    

#if defined(ENABLE_OVERLOADING)
type family ResolveDropMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveDropMethod "bindProperty" o = GObject.Object.ObjectBindPropertyMethodInfo
    ResolveDropMethod "bindPropertyFull" o = GObject.Object.ObjectBindPropertyFullMethodInfo
    ResolveDropMethod "finish" o = DropFinishMethodInfo
    ResolveDropMethod "forceFloating" o = GObject.Object.ObjectForceFloatingMethodInfo
    ResolveDropMethod "freezeNotify" o = GObject.Object.ObjectFreezeNotifyMethodInfo
    ResolveDropMethod "getv" o = GObject.Object.ObjectGetvMethodInfo
    ResolveDropMethod "isFloating" o = GObject.Object.ObjectIsFloatingMethodInfo
    ResolveDropMethod "notify" o = GObject.Object.ObjectNotifyMethodInfo
    ResolveDropMethod "notifyByPspec" o = GObject.Object.ObjectNotifyByPspecMethodInfo
    ResolveDropMethod "readAsync" o = DropReadAsyncMethodInfo
    ResolveDropMethod "readFinish" o = DropReadFinishMethodInfo
    ResolveDropMethod "readValueAsync" o = DropReadValueAsyncMethodInfo
    ResolveDropMethod "readValueFinish" o = DropReadValueFinishMethodInfo
    ResolveDropMethod "ref" o = GObject.Object.ObjectRefMethodInfo
    ResolveDropMethod "refSink" o = GObject.Object.ObjectRefSinkMethodInfo
    ResolveDropMethod "runDispose" o = GObject.Object.ObjectRunDisposeMethodInfo
    ResolveDropMethod "status" o = DropStatusMethodInfo
    ResolveDropMethod "stealData" o = GObject.Object.ObjectStealDataMethodInfo
    ResolveDropMethod "stealQdata" o = GObject.Object.ObjectStealQdataMethodInfo
    ResolveDropMethod "thawNotify" o = GObject.Object.ObjectThawNotifyMethodInfo
    ResolveDropMethod "unref" o = GObject.Object.ObjectUnrefMethodInfo
    ResolveDropMethod "watchClosure" o = GObject.Object.ObjectWatchClosureMethodInfo
    ResolveDropMethod "getActions" o = DropGetActionsMethodInfo
    ResolveDropMethod "getData" o = GObject.Object.ObjectGetDataMethodInfo
    ResolveDropMethod "getDevice" o = DropGetDeviceMethodInfo
    ResolveDropMethod "getDisplay" o = DropGetDisplayMethodInfo
    ResolveDropMethod "getDrag" o = DropGetDragMethodInfo
    ResolveDropMethod "getFormats" o = DropGetFormatsMethodInfo
    ResolveDropMethod "getProperty" o = GObject.Object.ObjectGetPropertyMethodInfo
    ResolveDropMethod "getQdata" o = GObject.Object.ObjectGetQdataMethodInfo
    ResolveDropMethod "getSurface" o = DropGetSurfaceMethodInfo
    ResolveDropMethod "setData" o = GObject.Object.ObjectSetDataMethodInfo
    ResolveDropMethod "setDataFull" o = GObject.Object.ObjectSetDataFullMethodInfo
    ResolveDropMethod "setProperty" o = GObject.Object.ObjectSetPropertyMethodInfo
    ResolveDropMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveDropMethod t Drop, O.OverloadedMethod info Drop p) => OL.IsLabel t (Drop -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveDropMethod t Drop, O.OverloadedMethod info Drop p, R.HasField t Drop p) => R.HasField t Drop p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveDropMethod t Drop, O.OverloadedMethodInfo info Drop) => OL.IsLabel t (O.MethodProxy info Drop) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- VVV Prop "actions"
   -- Type: TInterface (Name {namespace = "Gdk", name = "DragAction"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@actions@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drop #actions
-- @
getDropActions :: (MonadIO m, IsDrop o) => o -> m [Gdk.Flags.DragAction]
getDropActions obj = MIO.liftIO $ B.Properties.getObjectPropertyFlags obj "actions"

-- | Construct a t'GValueConstruct' with valid value for the “@actions@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropActions :: (IsDrop o, MIO.MonadIO m) => [Gdk.Flags.DragAction] -> m (GValueConstruct o)
constructDropActions val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyFlags "actions" val

#if defined(ENABLE_OVERLOADING)
data DropActionsPropertyInfo
instance AttrInfo DropActionsPropertyInfo where
    type AttrAllowedOps DropActionsPropertyInfo = '[ 'AttrConstruct, 'AttrGet]
    type AttrBaseTypeConstraint DropActionsPropertyInfo = IsDrop
    type AttrSetTypeConstraint DropActionsPropertyInfo = (~) [Gdk.Flags.DragAction]
    type AttrTransferTypeConstraint DropActionsPropertyInfo = (~) [Gdk.Flags.DragAction]
    type AttrTransferType DropActionsPropertyInfo = [Gdk.Flags.DragAction]
    type AttrGetType DropActionsPropertyInfo = [Gdk.Flags.DragAction]
    type AttrLabel DropActionsPropertyInfo = "actions"
    type AttrOrigin DropActionsPropertyInfo = Drop
    attrGet = getDropActions
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDropActions
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.actions"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#g:attr:actions"
        })
#endif

-- VVV Prop "device"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Device"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@device@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drop #device
-- @
getDropDevice :: (MonadIO m, IsDrop o) => o -> m Gdk.Device.Device
getDropDevice obj = MIO.liftIO $ checkUnexpectedNothing "getDropDevice" $ B.Properties.getObjectPropertyObject obj "device" Gdk.Device.Device

-- | Construct a t'GValueConstruct' with valid value for the “@device@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropDevice :: (IsDrop o, MIO.MonadIO m, Gdk.Device.IsDevice a) => a -> m (GValueConstruct o)
constructDropDevice val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "device" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DropDevicePropertyInfo
instance AttrInfo DropDevicePropertyInfo where
    type AttrAllowedOps DropDevicePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DropDevicePropertyInfo = IsDrop
    type AttrSetTypeConstraint DropDevicePropertyInfo = Gdk.Device.IsDevice
    type AttrTransferTypeConstraint DropDevicePropertyInfo = Gdk.Device.IsDevice
    type AttrTransferType DropDevicePropertyInfo = Gdk.Device.Device
    type AttrGetType DropDevicePropertyInfo = Gdk.Device.Device
    type AttrLabel DropDevicePropertyInfo = "device"
    type AttrOrigin DropDevicePropertyInfo = Drop
    attrGet = getDropDevice
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Device.Device v
    attrConstruct = constructDropDevice
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.device"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#g:attr:device"
        })
#endif

-- VVV Prop "display"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Display"})
   -- Flags: [PropertyReadable]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@display@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drop #display
-- @
getDropDisplay :: (MonadIO m, IsDrop o) => o -> m Gdk.Display.Display
getDropDisplay obj = MIO.liftIO $ checkUnexpectedNothing "getDropDisplay" $ B.Properties.getObjectPropertyObject obj "display" Gdk.Display.Display

#if defined(ENABLE_OVERLOADING)
data DropDisplayPropertyInfo
instance AttrInfo DropDisplayPropertyInfo where
    type AttrAllowedOps DropDisplayPropertyInfo = '[ 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DropDisplayPropertyInfo = IsDrop
    type AttrSetTypeConstraint DropDisplayPropertyInfo = (~) ()
    type AttrTransferTypeConstraint DropDisplayPropertyInfo = (~) ()
    type AttrTransferType DropDisplayPropertyInfo = ()
    type AttrGetType DropDisplayPropertyInfo = Gdk.Display.Display
    type AttrLabel DropDisplayPropertyInfo = "display"
    type AttrOrigin DropDisplayPropertyInfo = Drop
    attrGet = getDropDisplay
    attrSet = undefined
    attrTransfer _ = undefined
    attrConstruct = undefined
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.display"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#g:attr:display"
        })
#endif

-- VVV Prop "drag"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Drag"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just True,Nothing)

-- | Get the value of the “@drag@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drop #drag
-- @
getDropDrag :: (MonadIO m, IsDrop o) => o -> m (Maybe Gdk.Drag.Drag)
getDropDrag obj = MIO.liftIO $ B.Properties.getObjectPropertyObject obj "drag" Gdk.Drag.Drag

-- | Construct a t'GValueConstruct' with valid value for the “@drag@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropDrag :: (IsDrop o, MIO.MonadIO m, Gdk.Drag.IsDrag a) => a -> m (GValueConstruct o)
constructDropDrag val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "drag" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DropDragPropertyInfo
instance AttrInfo DropDragPropertyInfo where
    type AttrAllowedOps DropDragPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DropDragPropertyInfo = IsDrop
    type AttrSetTypeConstraint DropDragPropertyInfo = Gdk.Drag.IsDrag
    type AttrTransferTypeConstraint DropDragPropertyInfo = Gdk.Drag.IsDrag
    type AttrTransferType DropDragPropertyInfo = Gdk.Drag.Drag
    type AttrGetType DropDragPropertyInfo = (Maybe Gdk.Drag.Drag)
    type AttrLabel DropDragPropertyInfo = "drag"
    type AttrOrigin DropDragPropertyInfo = Drop
    attrGet = getDropDrag
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Drag.Drag v
    attrConstruct = constructDropDrag
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.drag"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#g:attr:drag"
        })
#endif

-- VVV Prop "formats"
   -- Type: TInterface (Name {namespace = "Gdk", name = "ContentFormats"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@formats@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drop #formats
-- @
getDropFormats :: (MonadIO m, IsDrop o) => o -> m Gdk.ContentFormats.ContentFormats
getDropFormats obj = MIO.liftIO $ checkUnexpectedNothing "getDropFormats" $ B.Properties.getObjectPropertyBoxed obj "formats" Gdk.ContentFormats.ContentFormats

-- | Construct a t'GValueConstruct' with valid value for the “@formats@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropFormats :: (IsDrop o, MIO.MonadIO m) => Gdk.ContentFormats.ContentFormats -> m (GValueConstruct o)
constructDropFormats val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyBoxed "formats" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DropFormatsPropertyInfo
instance AttrInfo DropFormatsPropertyInfo where
    type AttrAllowedOps DropFormatsPropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DropFormatsPropertyInfo = IsDrop
    type AttrSetTypeConstraint DropFormatsPropertyInfo = (~) Gdk.ContentFormats.ContentFormats
    type AttrTransferTypeConstraint DropFormatsPropertyInfo = (~) Gdk.ContentFormats.ContentFormats
    type AttrTransferType DropFormatsPropertyInfo = Gdk.ContentFormats.ContentFormats
    type AttrGetType DropFormatsPropertyInfo = Gdk.ContentFormats.ContentFormats
    type AttrLabel DropFormatsPropertyInfo = "formats"
    type AttrOrigin DropFormatsPropertyInfo = Drop
    attrGet = getDropFormats
    attrSet = undefined
    attrTransfer _ v = do
        return v
    attrConstruct = constructDropFormats
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.formats"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#g:attr:formats"
        })
#endif

-- VVV Prop "surface"
   -- Type: TInterface (Name {namespace = "Gdk", name = "Surface"})
   -- Flags: [PropertyReadable,PropertyWritable,PropertyConstructOnly]
   -- Nullable: (Just False,Nothing)

-- | Get the value of the “@surface@” property.
-- When <https://github.com/haskell-gi/haskell-gi/wiki/Overloading overloading> is enabled, this is equivalent to
-- 
-- @
-- 'Data.GI.Base.Attributes.get' drop #surface
-- @
getDropSurface :: (MonadIO m, IsDrop o) => o -> m Gdk.Surface.Surface
getDropSurface obj = MIO.liftIO $ checkUnexpectedNothing "getDropSurface" $ B.Properties.getObjectPropertyObject obj "surface" Gdk.Surface.Surface

-- | Construct a t'GValueConstruct' with valid value for the “@surface@” property. This is rarely needed directly, but it is used by `Data.GI.Base.Constructible.new`.
constructDropSurface :: (IsDrop o, MIO.MonadIO m, Gdk.Surface.IsSurface a) => a -> m (GValueConstruct o)
constructDropSurface val = MIO.liftIO $ do
    MIO.liftIO $ B.Properties.constructObjectPropertyObject "surface" (P.Just val)

#if defined(ENABLE_OVERLOADING)
data DropSurfacePropertyInfo
instance AttrInfo DropSurfacePropertyInfo where
    type AttrAllowedOps DropSurfacePropertyInfo = '[ 'AttrConstruct, 'AttrGet, 'AttrClear]
    type AttrBaseTypeConstraint DropSurfacePropertyInfo = IsDrop
    type AttrSetTypeConstraint DropSurfacePropertyInfo = Gdk.Surface.IsSurface
    type AttrTransferTypeConstraint DropSurfacePropertyInfo = Gdk.Surface.IsSurface
    type AttrTransferType DropSurfacePropertyInfo = Gdk.Surface.Surface
    type AttrGetType DropSurfacePropertyInfo = Gdk.Surface.Surface
    type AttrLabel DropSurfacePropertyInfo = "surface"
    type AttrOrigin DropSurfacePropertyInfo = Drop
    attrGet = getDropSurface
    attrSet = undefined
    attrTransfer _ v = do
        unsafeCastTo Gdk.Surface.Surface v
    attrConstruct = constructDropSurface
    attrClear = undefined
    dbgAttrInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.surface"
        , O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#g:attr:surface"
        })
#endif

#if defined(ENABLE_OVERLOADING)
instance O.HasAttributeList Drop
type instance O.AttributeList Drop = DropAttributeList
type DropAttributeList = ('[ '("actions", DropActionsPropertyInfo), '("device", DropDevicePropertyInfo), '("display", DropDisplayPropertyInfo), '("drag", DropDragPropertyInfo), '("formats", DropFormatsPropertyInfo), '("surface", DropSurfacePropertyInfo)] :: [(Symbol, DK.Type)])
#endif

#if defined(ENABLE_OVERLOADING)
dropActions :: AttrLabelProxy "actions"
dropActions = AttrLabelProxy

dropDevice :: AttrLabelProxy "device"
dropDevice = AttrLabelProxy

dropDisplay :: AttrLabelProxy "display"
dropDisplay = AttrLabelProxy

dropDrag :: AttrLabelProxy "drag"
dropDrag = AttrLabelProxy

dropFormats :: AttrLabelProxy "formats"
dropFormats = AttrLabelProxy

dropSurface :: AttrLabelProxy "surface"
dropSurface = AttrLabelProxy

#endif

#if defined(ENABLE_OVERLOADING)
type instance O.SignalList Drop = DropSignalList
type DropSignalList = ('[ '("notify", GObject.Object.ObjectNotifySignalInfo)] :: [(Symbol, DK.Type)])

#endif

-- method Drop::finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrop`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "action"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "the action performed by the destination or `GDK_ACTION_NONE` if the\n  drop failed"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drop_finish" gdk_drop_finish :: 
    Ptr Drop ->                             -- self : TInterface (Name {namespace = "Gdk", name = "Drop"})
    CUInt ->                                -- action : TInterface (Name {namespace = "Gdk", name = "DragAction"})
    IO ()

-- | Ends the drag operation after a drop.
-- 
-- The /@action@/ must be a single action selected from the actions
-- available via 'GI.Gdk.Objects.Drop.dropGetActions'.
dropFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrop a) =>
    a
    -- ^ /@self@/: a @GdkDrop@
    -> [Gdk.Flags.DragAction]
    -- ^ /@action@/: the action performed by the destination or @GDK_ACTION_NONE@ if the
    --   drop failed
    -> m ()
dropFinish self action = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let action' = gflagsToWord action
    gdk_drop_finish self' action'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data DropFinishMethodInfo
instance (signature ~ ([Gdk.Flags.DragAction] -> m ()), MonadIO m, IsDrop a) => O.OverloadedMethod DropFinishMethodInfo a signature where
    overloadedMethod = dropFinish

instance O.OverloadedMethodInfo DropFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.dropFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#v:dropFinish"
        })


#endif

-- method Drop::get_actions
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrop`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "DragAction" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drop_get_actions" gdk_drop_get_actions :: 
    Ptr Drop ->                             -- self : TInterface (Name {namespace = "Gdk", name = "Drop"})
    IO CUInt

-- | Returns the possible actions for this @GdkDrop@.
-- 
-- If this value contains multiple actions - i.e.
-- t'GI.Gdk.Flags.DragAction'.@/is_unique/@() returns false for the result -
-- 'GI.Gdk.Objects.Drop.dropFinish' must choose the action to use when
-- accepting the drop. This will only happen if you passed
-- @GDK_ACTION_ASK@ as one of the possible actions in
-- 'GI.Gdk.Objects.Drop.dropStatus'. @GDK_ACTION_ASK@ itself will not
-- be included in the actions returned by this function.
-- 
-- This value may change over the lifetime of the t'GI.Gdk.Objects.Drop.Drop'
-- both as a response to source side actions as well as to calls to
-- 'GI.Gdk.Objects.Drop.dropStatus' or 'GI.Gdk.Objects.Drop.dropFinish'. The source
-- side will not change this value anymore once a drop has started.
dropGetActions ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrop a) =>
    a
    -- ^ /@self@/: a @GdkDrop@
    -> m [Gdk.Flags.DragAction]
    -- ^ __Returns:__ The possible @GdkDragActions@
dropGetActions self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_drop_get_actions self'
    let result' = wordToGFlags result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data DropGetActionsMethodInfo
instance (signature ~ (m [Gdk.Flags.DragAction]), MonadIO m, IsDrop a) => O.OverloadedMethod DropGetActionsMethodInfo a signature where
    overloadedMethod = dropGetActions

instance O.OverloadedMethodInfo DropGetActionsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.dropGetActions",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#v:dropGetActions"
        })


#endif

-- method Drop::get_device
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrop`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Device" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drop_get_device" gdk_drop_get_device :: 
    Ptr Drop ->                             -- self : TInterface (Name {namespace = "Gdk", name = "Drop"})
    IO (Ptr Gdk.Device.Device)

-- | Returns the @GdkDevice@ performing the drop.
dropGetDevice ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrop a) =>
    a
    -- ^ /@self@/: a @GdkDrop@
    -> m Gdk.Device.Device
    -- ^ __Returns:__ The @GdkDevice@ performing the drop.
dropGetDevice self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_drop_get_device self'
    checkUnexpectedReturnNULL "dropGetDevice" result
    result' <- (newObject Gdk.Device.Device) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data DropGetDeviceMethodInfo
instance (signature ~ (m Gdk.Device.Device), MonadIO m, IsDrop a) => O.OverloadedMethod DropGetDeviceMethodInfo a signature where
    overloadedMethod = dropGetDevice

instance O.OverloadedMethodInfo DropGetDeviceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.dropGetDevice",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#v:dropGetDevice"
        })


#endif

-- method Drop::get_display
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrop`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Display" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drop_get_display" gdk_drop_get_display :: 
    Ptr Drop ->                             -- self : TInterface (Name {namespace = "Gdk", name = "Drop"})
    IO (Ptr Gdk.Display.Display)

-- | Gets the @GdkDisplay@ that /@self@/ was created for.
dropGetDisplay ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrop a) =>
    a
    -- ^ /@self@/: a @GdkDrop@
    -> m Gdk.Display.Display
    -- ^ __Returns:__ a @GdkDisplay@
dropGetDisplay self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_drop_get_display self'
    checkUnexpectedReturnNULL "dropGetDisplay" result
    result' <- (newObject Gdk.Display.Display) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data DropGetDisplayMethodInfo
instance (signature ~ (m Gdk.Display.Display), MonadIO m, IsDrop a) => O.OverloadedMethod DropGetDisplayMethodInfo a signature where
    overloadedMethod = dropGetDisplay

instance O.OverloadedMethodInfo DropGetDisplayMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.dropGetDisplay",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#v:dropGetDisplay"
        })


#endif

-- method Drop::get_drag
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrop`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Drag" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drop_get_drag" gdk_drop_get_drag :: 
    Ptr Drop ->                             -- self : TInterface (Name {namespace = "Gdk", name = "Drop"})
    IO (Ptr Gdk.Drag.Drag)

-- | If this is an in-app drag-and-drop operation, returns the @GdkDrag@
-- that corresponds to this drop.
-- 
-- If it is not, @NULL@ is returned.
dropGetDrag ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrop a) =>
    a
    -- ^ /@self@/: a @GdkDrop@
    -> m (Maybe Gdk.Drag.Drag)
    -- ^ __Returns:__ the corresponding @GdkDrag@
dropGetDrag self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_drop_get_drag self'
    maybeResult <- convertIfNonNull result $ \result' -> do
        result'' <- (newObject Gdk.Drag.Drag) result'
        return result''
    touchManagedPtr self
    return maybeResult

#if defined(ENABLE_OVERLOADING)
data DropGetDragMethodInfo
instance (signature ~ (m (Maybe Gdk.Drag.Drag)), MonadIO m, IsDrop a) => O.OverloadedMethod DropGetDragMethodInfo a signature where
    overloadedMethod = dropGetDrag

instance O.OverloadedMethodInfo DropGetDragMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.dropGetDrag",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#v:dropGetDrag"
        })


#endif

-- method Drop::get_formats
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrop`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just
--               (TInterface Name { namespace = "Gdk" , name = "ContentFormats" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drop_get_formats" gdk_drop_get_formats :: 
    Ptr Drop ->                             -- self : TInterface (Name {namespace = "Gdk", name = "Drop"})
    IO (Ptr Gdk.ContentFormats.ContentFormats)

-- | Returns the @GdkContentFormats@ that the drop offers the data
-- to be read in.
dropGetFormats ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrop a) =>
    a
    -- ^ /@self@/: a @GdkDrop@
    -> m Gdk.ContentFormats.ContentFormats
    -- ^ __Returns:__ The possible @GdkContentFormats@
dropGetFormats self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_drop_get_formats self'
    checkUnexpectedReturnNULL "dropGetFormats" result
    result' <- (newBoxed Gdk.ContentFormats.ContentFormats) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data DropGetFormatsMethodInfo
instance (signature ~ (m Gdk.ContentFormats.ContentFormats), MonadIO m, IsDrop a) => O.OverloadedMethod DropGetFormatsMethodInfo a signature where
    overloadedMethod = dropGetFormats

instance O.OverloadedMethodInfo DropGetFormatsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.dropGetFormats",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#v:dropGetFormats"
        })


#endif

-- method Drop::get_surface
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrop`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gdk" , name = "Surface" })
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drop_get_surface" gdk_drop_get_surface :: 
    Ptr Drop ->                             -- self : TInterface (Name {namespace = "Gdk", name = "Drop"})
    IO (Ptr Gdk.Surface.Surface)

-- | Returns the @GdkSurface@ performing the drop.
dropGetSurface ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrop a) =>
    a
    -- ^ /@self@/: a @GdkDrop@
    -> m Gdk.Surface.Surface
    -- ^ __Returns:__ The @GdkSurface@ performing the drop.
dropGetSurface self = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result <- gdk_drop_get_surface self'
    checkUnexpectedReturnNULL "dropGetSurface" result
    result' <- (newObject Gdk.Surface.Surface) result
    touchManagedPtr self
    return result'

#if defined(ENABLE_OVERLOADING)
data DropGetSurfaceMethodInfo
instance (signature ~ (m Gdk.Surface.Surface), MonadIO m, IsDrop a) => O.OverloadedMethod DropGetSurfaceMethodInfo a signature where
    overloadedMethod = dropGetSurface

instance O.OverloadedMethodInfo DropGetSurfaceMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.dropGetSurface",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#v:dropGetSurface"
        })


#endif

-- method Drop::read_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrop`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "mime_types"
--           , argType = TCArray True (-1) (-1) (TBasicType TUTF8)
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "\n  pointer to an array of mime types"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the I/O priority for the read operation"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "optional `GCancellable` object"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a `GAsyncReadyCallback` to call when\n  the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to @callback"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drop_read_async" gdk_drop_read_async :: 
    Ptr Drop ->                             -- self : TInterface (Name {namespace = "Gdk", name = "Drop"})
    Ptr CString ->                          -- mime_types : TCArray True (-1) (-1) (TBasicType TUTF8)
    Int32 ->                                -- io_priority : TBasicType TInt
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronously read the dropped data from a @GdkDrop@
-- in a format that complies with one of the mime types.
dropReadAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrop a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@self@/: a @GdkDrop@
    -> [T.Text]
    -- ^ /@mimeTypes@/: 
    --   pointer to an array of mime types
    -> Int32
    -- ^ /@ioPriority@/: the I\/O priority for the read operation
    -> Maybe (b)
    -- ^ /@cancellable@/: optional @GCancellable@ object
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: a @GAsyncReadyCallback@ to call when
    --   the request is satisfied
    -> m ()
dropReadAsync self mimeTypes ioPriority cancellable callback = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    mimeTypes' <- packZeroTerminatedUTF8CArray mimeTypes
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    gdk_drop_read_async self' mimeTypes' ioPriority maybeCancellable maybeCallback userData
    touchManagedPtr self
    whenJust cancellable touchManagedPtr
    mapZeroTerminatedCArray freeMem mimeTypes'
    freeMem mimeTypes'
    return ()

#if defined(ENABLE_OVERLOADING)
data DropReadAsyncMethodInfo
instance (signature ~ ([T.Text] -> Int32 -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsDrop a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod DropReadAsyncMethodInfo a signature where
    overloadedMethod = dropReadAsync

instance O.OverloadedMethodInfo DropReadAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.dropReadAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#v:dropReadAsync"
        })


#endif

-- method Drop::read_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrop`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GAsyncResult`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "out_mime_type"
--           , argType = TBasicType TUTF8
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "return location for the used mime type"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Gio" , name = "InputStream" })
-- throws : True
-- Skip return : False

foreign import ccall "gdk_drop_read_finish" gdk_drop_read_finish :: 
    Ptr Drop ->                             -- self : TInterface (Name {namespace = "Gdk", name = "Drop"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr CString ->                          -- out_mime_type : TBasicType TUTF8
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr Gio.InputStream.InputStream)

-- | Finishes an async drop read operation.
-- 
-- Note that you must not use blocking read calls on the returned stream
-- in the GTK thread, since some platforms might require communication with
-- GTK to complete the data transfer. You can use async APIs such as
-- 'GI.Gio.Objects.InputStream.inputStreamReadBytesAsync'.
-- 
-- See 'GI.Gdk.Objects.Drop.dropReadAsync'.
dropReadFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrop a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@self@/: a @GdkDrop@
    -> b
    -- ^ /@result@/: a @GAsyncResult@
    -> m ((Maybe Gio.InputStream.InputStream, T.Text))
    -- ^ __Returns:__ the @GInputStream@ /(Can throw 'Data.GI.Base.GError.GError')/
dropReadFinish self result_ = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result_' <- unsafeManagedPtrCastPtr result_
    outMimeType <- callocMem :: IO (Ptr CString)
    onException (do
        result <- propagateGError $ gdk_drop_read_finish self' result_' outMimeType
        maybeResult <- convertIfNonNull result $ \result' -> do
            result'' <- (wrapObject Gio.InputStream.InputStream) result'
            return result''
        outMimeType' <- peek outMimeType
        outMimeType'' <- cstringToText outMimeType'
        touchManagedPtr self
        touchManagedPtr result_
        freeMem outMimeType
        return (maybeResult, outMimeType'')
     ) (do
        freeMem outMimeType
     )

#if defined(ENABLE_OVERLOADING)
data DropReadFinishMethodInfo
instance (signature ~ (b -> m ((Maybe Gio.InputStream.InputStream, T.Text))), MonadIO m, IsDrop a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod DropReadFinishMethodInfo a signature where
    overloadedMethod = dropReadFinish

instance O.OverloadedMethodInfo DropReadFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.dropReadFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#v:dropReadFinish"
        })


#endif

-- method Drop::read_value_async
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrop`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "type"
--           , argType = TBasicType TGType
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GType` to read" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "io_priority"
--           , argType = TBasicType TInt
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the I/O priority of the request."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "cancellable"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "Cancellable" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "optional `GCancellable` object, %NULL to ignore."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "callback"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncReadyCallback" }
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "callback to call when the request is satisfied"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeAsync
--           , argClosure = 5
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "user_data"
--           , argType = TBasicType TPtr
--           , direction = DirectionIn
--           , mayBeNull = True
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the data to pass to callback function"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drop_read_value_async" gdk_drop_read_value_async :: 
    Ptr Drop ->                             -- self : TInterface (Name {namespace = "Gdk", name = "Drop"})
    CGType ->                               -- type : TBasicType TGType
    Int32 ->                                -- io_priority : TBasicType TInt
    Ptr Gio.Cancellable.Cancellable ->      -- cancellable : TInterface (Name {namespace = "Gio", name = "Cancellable"})
    FunPtr Gio.Callbacks.C_AsyncReadyCallback -> -- callback : TInterface (Name {namespace = "Gio", name = "AsyncReadyCallback"})
    Ptr () ->                               -- user_data : TBasicType TPtr
    IO ()

-- | Asynchronously request the drag operation\'s contents converted
-- to the given /@type@/.
-- 
-- For local drag-and-drop operations that are available in the given
-- @GType@, the value will be copied directly. Otherwise, GDK will
-- try to use 'GI.Gdk.Functions.contentDeserializeAsync' to convert the data.
dropReadValueAsync ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrop a, Gio.Cancellable.IsCancellable b) =>
    a
    -- ^ /@self@/: a @GdkDrop@
    -> GType
    -- ^ /@type@/: a @GType@ to read
    -> Int32
    -- ^ /@ioPriority@/: the I\/O priority of the request.
    -> Maybe (b)
    -- ^ /@cancellable@/: optional @GCancellable@ object, 'P.Nothing' to ignore.
    -> Maybe (Gio.Callbacks.AsyncReadyCallback)
    -- ^ /@callback@/: callback to call when the request is satisfied
    -> m ()
dropReadValueAsync self type_ ioPriority cancellable callback = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let type_' = gtypeToCGType type_
    maybeCancellable <- case cancellable of
        Nothing -> return FP.nullPtr
        Just jCancellable -> do
            jCancellable' <- unsafeManagedPtrCastPtr jCancellable
            return jCancellable'
    maybeCallback <- case callback of
        Nothing -> return FP.nullFunPtr
        Just jCallback -> do
            ptrcallback <- callocMem :: IO (Ptr (FunPtr Gio.Callbacks.C_AsyncReadyCallback))
            jCallback' <- Gio.Callbacks.mk_AsyncReadyCallback (Gio.Callbacks.wrap_AsyncReadyCallback (Just ptrcallback) (Gio.Callbacks.drop_closures_AsyncReadyCallback jCallback))
            poke ptrcallback jCallback'
            return jCallback'
    let userData = nullPtr
    gdk_drop_read_value_async self' type_' ioPriority maybeCancellable maybeCallback userData
    touchManagedPtr self
    whenJust cancellable touchManagedPtr
    return ()

#if defined(ENABLE_OVERLOADING)
data DropReadValueAsyncMethodInfo
instance (signature ~ (GType -> Int32 -> Maybe (b) -> Maybe (Gio.Callbacks.AsyncReadyCallback) -> m ()), MonadIO m, IsDrop a, Gio.Cancellable.IsCancellable b) => O.OverloadedMethod DropReadValueAsyncMethodInfo a signature where
    overloadedMethod = dropReadValueAsync

instance O.OverloadedMethodInfo DropReadValueAsyncMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.dropReadValueAsync",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#v:dropReadValueAsync"
        })


#endif

-- method Drop::read_value_finish
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrop`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "result"
--           , argType =
--               TInterface Name { namespace = "Gio" , name = "AsyncResult" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GAsyncResult`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just TGValue
-- throws : True
-- Skip return : False

foreign import ccall "gdk_drop_read_value_finish" gdk_drop_read_value_finish :: 
    Ptr Drop ->                             -- self : TInterface (Name {namespace = "Gdk", name = "Drop"})
    Ptr Gio.AsyncResult.AsyncResult ->      -- result : TInterface (Name {namespace = "Gio", name = "AsyncResult"})
    Ptr (Ptr GError) ->                     -- error
    IO (Ptr GValue)

-- | Finishes an async drop read.
-- 
-- See 'GI.Gdk.Objects.Drop.dropReadValueAsync'.
dropReadValueFinish ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrop a, Gio.AsyncResult.IsAsyncResult b) =>
    a
    -- ^ /@self@/: a @GdkDrop@
    -> b
    -- ^ /@result@/: a @GAsyncResult@
    -> m GValue
    -- ^ __Returns:__ a @GValue@ containing the result. /(Can throw 'Data.GI.Base.GError.GError')/
dropReadValueFinish self result_ = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    result_' <- unsafeManagedPtrCastPtr result_
    onException (do
        result <- propagateGError $ gdk_drop_read_value_finish self' result_'
        checkUnexpectedReturnNULL "dropReadValueFinish" result
        result' <- B.GValue.newGValueFromPtr result
        touchManagedPtr self
        touchManagedPtr result_
        return result'
     ) (do
        return ()
     )

#if defined(ENABLE_OVERLOADING)
data DropReadValueFinishMethodInfo
instance (signature ~ (b -> m GValue), MonadIO m, IsDrop a, Gio.AsyncResult.IsAsyncResult b) => O.OverloadedMethod DropReadValueFinishMethodInfo a signature where
    overloadedMethod = dropReadValueFinish

instance O.OverloadedMethodInfo DropReadValueFinishMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.dropReadValueFinish",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#v:dropReadValueFinish"
        })


#endif

-- method Drop::status
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "self"
--           , argType = TInterface Name { namespace = "Gdk" , name = "Drop" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GdkDrop`" , sinceVersion = Nothing }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "actions"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "Supported actions of the destination, or `GDK_ACTION_NONE` to\n   indicate that a drop will not be accepted"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "preferred"
--           , argType =
--               TInterface Name { namespace = "Gdk" , name = "DragAction" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "A unique action that's a member of @actions indicating the\n   preferred action"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Nothing
-- throws : False
-- Skip return : False

foreign import ccall "gdk_drop_status" gdk_drop_status :: 
    Ptr Drop ->                             -- self : TInterface (Name {namespace = "Gdk", name = "Drop"})
    CUInt ->                                -- actions : TInterface (Name {namespace = "Gdk", name = "DragAction"})
    CUInt ->                                -- preferred : TInterface (Name {namespace = "Gdk", name = "DragAction"})
    IO ()

-- | Selects all actions that are potentially supported by the destination.
-- 
-- When calling this function, do not restrict the passed in actions to
-- the ones provided by 'GI.Gdk.Objects.Drop.dropGetActions'. Those actions may
-- change in the future, even depending on the actions you provide here.
-- 
-- The /@preferred@/ action is a hint to the drag-and-drop mechanism about which
-- action to use when multiple actions are possible.
-- 
-- This function should be called by drag destinations in response to
-- @GDK_DRAG_ENTER@ or @GDK_DRAG_MOTION@ events. If the destination does
-- not yet know the exact actions it supports, it should set any possible
-- actions first and then later call this function again.
dropStatus ::
    (B.CallStack.HasCallStack, MonadIO m, IsDrop a) =>
    a
    -- ^ /@self@/: a @GdkDrop@
    -> [Gdk.Flags.DragAction]
    -- ^ /@actions@/: Supported actions of the destination, or @GDK_ACTION_NONE@ to
    --    indicate that a drop will not be accepted
    -> [Gdk.Flags.DragAction]
    -- ^ /@preferred@/: A unique action that\'s a member of /@actions@/ indicating the
    --    preferred action
    -> m ()
dropStatus self actions preferred = liftIO $ do
    self' <- unsafeManagedPtrCastPtr self
    let actions' = gflagsToWord actions
    let preferred' = gflagsToWord preferred
    gdk_drop_status self' actions' preferred'
    touchManagedPtr self
    return ()

#if defined(ENABLE_OVERLOADING)
data DropStatusMethodInfo
instance (signature ~ ([Gdk.Flags.DragAction] -> [Gdk.Flags.DragAction] -> m ()), MonadIO m, IsDrop a) => O.OverloadedMethod DropStatusMethodInfo a signature where
    overloadedMethod = dropStatus

instance O.OverloadedMethodInfo DropStatusMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gdk.Objects.Drop.dropStatus",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gdk-4.0.9/docs/GI-Gdk-Objects-Drop.html#v:dropStatus"
        })


#endif


