{-# LANGUAGE TypeApplications #-}


-- | Copyright  : Will Thompson and Iñaki García Etxebarria
-- License    : LGPL-2.1
-- Maintainer : Iñaki García Etxebarria
-- 
-- A render node for a linear gradient.

#if (MIN_VERSION_haskell_gi_overloading(1,0,0) && !defined(__HADDOCK_VERSION__))
#define ENABLE_OVERLOADING
#endif

module GI.Gsk.Objects.LinearGradientNode
    ( 

-- * Exported types
    LinearGradientNode(..)                  ,
    IsLinearGradientNode                    ,
    toLinearGradientNode                    ,


 -- * Methods
-- | 
-- 
--  === __Click to display all available methods, including inherited ones__
-- ==== Methods
-- [draw]("GI.Gsk.Objects.RenderNode#g:method:draw"), [ref]("GI.Gsk.Objects.RenderNode#g:method:ref"), [serialize]("GI.Gsk.Objects.RenderNode#g:method:serialize"), [unref]("GI.Gsk.Objects.RenderNode#g:method:unref"), [writeToFile]("GI.Gsk.Objects.RenderNode#g:method:writeToFile").
-- 
-- ==== Getters
-- [getBounds]("GI.Gsk.Objects.RenderNode#g:method:getBounds"), [getColorStops]("GI.Gsk.Objects.LinearGradientNode#g:method:getColorStops"), [getEnd]("GI.Gsk.Objects.LinearGradientNode#g:method:getEnd"), [getNColorStops]("GI.Gsk.Objects.LinearGradientNode#g:method:getNColorStops"), [getNodeType]("GI.Gsk.Objects.RenderNode#g:method:getNodeType"), [getOpaqueRect]("GI.Gsk.Objects.RenderNode#g:method:getOpaqueRect"), [getStart]("GI.Gsk.Objects.LinearGradientNode#g:method:getStart").
-- 
-- ==== Setters
-- /None/.

#if defined(ENABLE_OVERLOADING)
    ResolveLinearGradientNodeMethod         ,
#endif

-- ** getColorStops #method:getColorStops#

#if defined(ENABLE_OVERLOADING)
    LinearGradientNodeGetColorStopsMethodInfo,
#endif
    linearGradientNodeGetColorStops         ,


-- ** getEnd #method:getEnd#

#if defined(ENABLE_OVERLOADING)
    LinearGradientNodeGetEndMethodInfo      ,
#endif
    linearGradientNodeGetEnd                ,


-- ** getNColorStops #method:getNColorStops#

#if defined(ENABLE_OVERLOADING)
    LinearGradientNodeGetNColorStopsMethodInfo,
#endif
    linearGradientNodeGetNColorStops        ,


-- ** getStart #method:getStart#

#if defined(ENABLE_OVERLOADING)
    LinearGradientNodeGetStartMethodInfo    ,
#endif
    linearGradientNodeGetStart              ,


-- ** new #method:new#

    linearGradientNodeNew                   ,




    ) where

import Data.GI.Base.ShortPrelude
import qualified Data.GI.Base.ShortPrelude as SP
import qualified Data.GI.Base.Overloading as O
import qualified Prelude as P

import qualified Data.GI.Base.Attributes as GI.Attributes
import qualified Data.GI.Base.BasicTypes as B.Types
import qualified Data.GI.Base.ManagedPtr as B.ManagedPtr
import qualified Data.GI.Base.GArray as B.GArray
import qualified Data.GI.Base.GClosure as B.GClosure
import qualified Data.GI.Base.GError as B.GError
import qualified Data.GI.Base.GHashTable as B.GHT
import qualified Data.GI.Base.GVariant as B.GVariant
import qualified Data.GI.Base.GValue as B.GValue
import qualified Data.GI.Base.GParamSpec as B.GParamSpec
import qualified Data.GI.Base.CallStack as B.CallStack
import qualified Data.GI.Base.Properties as B.Properties
import qualified Data.GI.Base.Signals as B.Signals
import qualified Control.Monad.IO.Class as MIO
import qualified Data.Coerce as Coerce
import qualified Data.Text as T
import qualified Data.Kind as DK
import qualified Data.ByteString.Char8 as B
import qualified Data.Map as Map
import qualified Foreign.Ptr as FP
import qualified GHC.OverloadedLabels as OL
import qualified GHC.Records as R
import qualified Data.Word as DW
import qualified Data.Int as DI
import qualified System.Posix.Types as SPT
import qualified Foreign.C.Types as FCT

-- Workaround for https://gitlab.haskell.org/ghc/ghc/-/issues/23392
#if MIN_VERSION_base(4,18,0)
import qualified GI.Cairo.Structs.Context as Cairo.Context
import qualified GI.GLib.Structs.Bytes as GLib.Bytes
import qualified GI.Gdk.Structs.RGBA as Gdk.RGBA
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import qualified GI.Gsk.Callbacks as Gsk.Callbacks
import {-# SOURCE #-} qualified GI.Gsk.Enums as Gsk.Enums
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop

#else
import qualified GI.Graphene.Structs.Point as Graphene.Point
import qualified GI.Graphene.Structs.Rect as Graphene.Rect
import {-# SOURCE #-} qualified GI.Gsk.Objects.RenderNode as Gsk.RenderNode
import {-# SOURCE #-} qualified GI.Gsk.Structs.ColorStop as Gsk.ColorStop

#endif

-- | Memory-managed wrapper type.
newtype LinearGradientNode = LinearGradientNode (SP.ManagedPtr LinearGradientNode)
    deriving (Eq)

instance SP.ManagedPtrNewtype LinearGradientNode where
    toManagedPtr (LinearGradientNode p) = p

foreign import ccall "gsk_linear_gradient_node_get_type"
    c_gsk_linear_gradient_node_get_type :: IO B.Types.GType

instance B.Types.TypedObject LinearGradientNode where
    glibType = c_gsk_linear_gradient_node_get_type

-- | Type class for types which can be safely cast to t'LinearGradientNode', for instance with `toLinearGradientNode`.
class (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf LinearGradientNode o) => IsLinearGradientNode o
instance (SP.BoxedPtr o, SP.TypedObject o, O.IsDescendantOf LinearGradientNode o) => IsLinearGradientNode o

instance O.HasParentTypes LinearGradientNode
type instance O.ParentTypes LinearGradientNode = '[Gsk.RenderNode.RenderNode]

-- | Cast to t'LinearGradientNode', for types for which this is known to be safe. For general casts, use 'Data.GI.Base.ManagedPtr.castTo'.
toLinearGradientNode :: (MIO.MonadIO m, IsLinearGradientNode o) => o -> m LinearGradientNode
toLinearGradientNode = MIO.liftIO . B.ManagedPtr.unsafeCastTo LinearGradientNode

--- XXX Missing getter and/or setter, so no GValue instance could be generated.
#if defined(ENABLE_OVERLOADING)
type family ResolveLinearGradientNodeMethod (t :: Symbol) (o :: DK.Type) :: DK.Type where
    ResolveLinearGradientNodeMethod "draw" o = Gsk.RenderNode.RenderNodeDrawMethodInfo
    ResolveLinearGradientNodeMethod "ref" o = Gsk.RenderNode.RenderNodeRefMethodInfo
    ResolveLinearGradientNodeMethod "serialize" o = Gsk.RenderNode.RenderNodeSerializeMethodInfo
    ResolveLinearGradientNodeMethod "unref" o = Gsk.RenderNode.RenderNodeUnrefMethodInfo
    ResolveLinearGradientNodeMethod "writeToFile" o = Gsk.RenderNode.RenderNodeWriteToFileMethodInfo
    ResolveLinearGradientNodeMethod "getBounds" o = Gsk.RenderNode.RenderNodeGetBoundsMethodInfo
    ResolveLinearGradientNodeMethod "getColorStops" o = LinearGradientNodeGetColorStopsMethodInfo
    ResolveLinearGradientNodeMethod "getEnd" o = LinearGradientNodeGetEndMethodInfo
    ResolveLinearGradientNodeMethod "getNColorStops" o = LinearGradientNodeGetNColorStopsMethodInfo
    ResolveLinearGradientNodeMethod "getNodeType" o = Gsk.RenderNode.RenderNodeGetNodeTypeMethodInfo
    ResolveLinearGradientNodeMethod "getOpaqueRect" o = Gsk.RenderNode.RenderNodeGetOpaqueRectMethodInfo
    ResolveLinearGradientNodeMethod "getStart" o = LinearGradientNodeGetStartMethodInfo
    ResolveLinearGradientNodeMethod l o = O.MethodResolutionFailed l o

instance (info ~ ResolveLinearGradientNodeMethod t LinearGradientNode, O.OverloadedMethod info LinearGradientNode p) => OL.IsLabel t (LinearGradientNode -> p) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.overloadedMethod @info
#else
    fromLabel _ = O.overloadedMethod @info
#endif

#if MIN_VERSION_base(4,13,0)
instance (info ~ ResolveLinearGradientNodeMethod t LinearGradientNode, O.OverloadedMethod info LinearGradientNode p, R.HasField t LinearGradientNode p) => R.HasField t LinearGradientNode p where
    getField = O.overloadedMethod @info

#endif

instance (info ~ ResolveLinearGradientNodeMethod t LinearGradientNode, O.OverloadedMethodInfo info LinearGradientNode) => OL.IsLabel t (O.MethodProxy info LinearGradientNode) where
#if MIN_VERSION_base(4,10,0)
    fromLabel = O.MethodProxy
#else
    fromLabel _ = O.MethodProxy
#endif

#endif

-- XXX Wrapping a foreign struct/union with no known destructor or size, leak?
instance BoxedPtr LinearGradientNode where
    boxedPtrCopy = return
    boxedPtrFree = \_x -> return ()


-- method LinearGradientNode::new
-- method type : Constructor
-- Args: [ Arg
--           { argCName = "bounds"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Rect" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the rectangle to render the linear gradient into"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "start"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the point at which the linear gradient will begin"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "end"
--           , argType =
--               TInterface Name { namespace = "Graphene" , name = "Point" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the point at which the linear gradient will finish"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "color_stops"
--           , argType =
--               TCArray
--                 False
--                 (-1)
--                 4
--                 (TInterface Name { namespace = "Gsk" , name = "ColorStop" })
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just
--                       "a pointer to an array of\n  `GskColorStop` defining the gradient. The offsets of all color stops\n  must be increasing. The first stop's offset must be >= 0 and the last\n  stop's offset must be <= 1."
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_color_stops"
--           , argType = TBasicType TSize
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "the number of elements in @color_stops"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_color_stops"
--              , argType = TBasicType TSize
--              , direction = DirectionIn
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText = Just "the number of elements in @color_stops"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferNothing
--              }
--          ]
-- returnType: Just
--               (TInterface
--                  Name { namespace = "Gsk" , name = "LinearGradientNode" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_linear_gradient_node_new" gsk_linear_gradient_node_new :: 
    Ptr Graphene.Rect.Rect ->               -- bounds : TInterface (Name {namespace = "Graphene", name = "Rect"})
    Ptr Graphene.Point.Point ->             -- start : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Graphene.Point.Point ->             -- end : TInterface (Name {namespace = "Graphene", name = "Point"})
    Ptr Gsk.ColorStop.ColorStop ->          -- color_stops : TCArray False (-1) 4 (TInterface (Name {namespace = "Gsk", name = "ColorStop"}))
    FCT.CSize ->                            -- n_color_stops : TBasicType TSize
    IO (Ptr LinearGradientNode)

-- | Creates a @GskRenderNode@ that will create a linear gradient from the given
-- points and color stops, and render that into the area given by /@bounds@/.
linearGradientNodeNew ::
    (B.CallStack.HasCallStack, MonadIO m) =>
    Graphene.Rect.Rect
    -- ^ /@bounds@/: the rectangle to render the linear gradient into
    -> Graphene.Point.Point
    -- ^ /@start@/: the point at which the linear gradient will begin
    -> Graphene.Point.Point
    -- ^ /@end@/: the point at which the linear gradient will finish
    -> [Gsk.ColorStop.ColorStop]
    -- ^ /@colorStops@/: a pointer to an array of
    --   @GskColorStop@ defining the gradient. The offsets of all color stops
    --   must be increasing. The first stop\'s offset must be >= 0 and the last
    --   stop\'s offset must be \<= 1.
    -> m LinearGradientNode
    -- ^ __Returns:__ A new @GskRenderNode@
linearGradientNodeNew bounds start end colorStops = liftIO $ do
    let nColorStops = fromIntegral $ P.length colorStops
    bounds' <- unsafeManagedPtrGetPtr bounds
    start' <- unsafeManagedPtrGetPtr start
    end' <- unsafeManagedPtrGetPtr end
    colorStops' <- mapM unsafeManagedPtrGetPtr colorStops
    colorStops'' <- packBlockArray 20 colorStops'
    result <- gsk_linear_gradient_node_new bounds' start' end' colorStops'' nColorStops
    checkUnexpectedReturnNULL "linearGradientNodeNew" result
    result' <- (wrapPtr LinearGradientNode) result
    touchManagedPtr bounds
    touchManagedPtr start
    touchManagedPtr end
    mapM_ touchManagedPtr colorStops
    freeMem colorStops''
    return result'

#if defined(ENABLE_OVERLOADING)
#endif

-- method LinearGradientNode::get_color_stops
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "LinearGradientNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a linear gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       , Arg
--           { argCName = "n_stops"
--           , argType = TBasicType TSize
--           , direction = DirectionOut
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText =
--                     Just "the number of color stops in the returned array"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferEverything
--           }
--       ]
-- Lengths: [ Arg
--              { argCName = "n_stops"
--              , argType = TBasicType TSize
--              , direction = DirectionOut
--              , mayBeNull = False
--              , argDoc =
--                  Documentation
--                    { rawDocText =
--                        Just "the number of color stops in the returned array"
--                    , sinceVersion = Nothing
--                    }
--              , argScope = ScopeTypeInvalid
--              , argClosure = -1
--              , argDestroy = -1
--              , argCallerAllocates = False
--              , argCallbackUserData = False
--              , transfer = TransferEverything
--              }
--          ]
-- returnType: Just
--               (TCArray
--                  False
--                  (-1)
--                  1
--                  (TInterface Name { namespace = "Gsk" , name = "ColorStop" }))
-- throws : False
-- Skip return : False

foreign import ccall "gsk_linear_gradient_node_get_color_stops" gsk_linear_gradient_node_get_color_stops :: 
    Ptr LinearGradientNode ->               -- node : TInterface (Name {namespace = "Gsk", name = "LinearGradientNode"})
    Ptr FCT.CSize ->                        -- n_stops : TBasicType TSize
    IO (Ptr Gsk.ColorStop.ColorStop)

-- | Retrieves the color stops in the gradient.
linearGradientNodeGetColorStops ::
    (B.CallStack.HasCallStack, MonadIO m, IsLinearGradientNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a linear gradient
    -> m [Gsk.ColorStop.ColorStop]
    -- ^ __Returns:__ the color stops in the gradient
linearGradientNodeGetColorStops node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    nStops <- allocMem :: IO (Ptr FCT.CSize)
    result <- gsk_linear_gradient_node_get_color_stops node' nStops
    nStops' <- peek nStops
    checkUnexpectedReturnNULL "linearGradientNodeGetColorStops" result
    result' <- (unpackBlockArrayWithLength 20 nStops') result
    result'' <- mapM (newPtr Gsk.ColorStop.ColorStop) result'
    touchManagedPtr node
    freeMem nStops
    return result''

#if defined(ENABLE_OVERLOADING)
data LinearGradientNodeGetColorStopsMethodInfo
instance (signature ~ (m [Gsk.ColorStop.ColorStop]), MonadIO m, IsLinearGradientNode a) => O.OverloadedMethod LinearGradientNodeGetColorStopsMethodInfo a signature where
    overloadedMethod = linearGradientNodeGetColorStops

instance O.OverloadedMethodInfo LinearGradientNodeGetColorStopsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.LinearGradientNode.linearGradientNodeGetColorStops",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-LinearGradientNode.html#v:linearGradientNodeGetColorStops"
        })


#endif

-- method LinearGradientNode::get_end
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "LinearGradientNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a linear gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Point" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_linear_gradient_node_get_end" gsk_linear_gradient_node_get_end :: 
    Ptr LinearGradientNode ->               -- node : TInterface (Name {namespace = "Gsk", name = "LinearGradientNode"})
    IO (Ptr Graphene.Point.Point)

-- | Retrieves the final point of the linear gradient.
linearGradientNodeGetEnd ::
    (B.CallStack.HasCallStack, MonadIO m, IsLinearGradientNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a linear gradient
    -> m Graphene.Point.Point
    -- ^ __Returns:__ the final point
linearGradientNodeGetEnd node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_linear_gradient_node_get_end node'
    checkUnexpectedReturnNULL "linearGradientNodeGetEnd" result
    result' <- (newBoxed Graphene.Point.Point) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data LinearGradientNodeGetEndMethodInfo
instance (signature ~ (m Graphene.Point.Point), MonadIO m, IsLinearGradientNode a) => O.OverloadedMethod LinearGradientNodeGetEndMethodInfo a signature where
    overloadedMethod = linearGradientNodeGetEnd

instance O.OverloadedMethodInfo LinearGradientNodeGetEndMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.LinearGradientNode.linearGradientNodeGetEnd",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-LinearGradientNode.html#v:linearGradientNodeGetEnd"
        })


#endif

-- method LinearGradientNode::get_n_color_stops
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "LinearGradientNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a linear gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TBasicType TSize)
-- throws : False
-- Skip return : False

foreign import ccall "gsk_linear_gradient_node_get_n_color_stops" gsk_linear_gradient_node_get_n_color_stops :: 
    Ptr LinearGradientNode ->               -- node : TInterface (Name {namespace = "Gsk", name = "LinearGradientNode"})
    IO FCT.CSize

-- | Retrieves the number of color stops in the gradient.
linearGradientNodeGetNColorStops ::
    (B.CallStack.HasCallStack, MonadIO m, IsLinearGradientNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a linear gradient
    -> m FCT.CSize
    -- ^ __Returns:__ the number of color stops
linearGradientNodeGetNColorStops node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_linear_gradient_node_get_n_color_stops node'
    touchManagedPtr node
    return result

#if defined(ENABLE_OVERLOADING)
data LinearGradientNodeGetNColorStopsMethodInfo
instance (signature ~ (m FCT.CSize), MonadIO m, IsLinearGradientNode a) => O.OverloadedMethod LinearGradientNodeGetNColorStopsMethodInfo a signature where
    overloadedMethod = linearGradientNodeGetNColorStops

instance O.OverloadedMethodInfo LinearGradientNodeGetNColorStopsMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.LinearGradientNode.linearGradientNodeGetNColorStops",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-LinearGradientNode.html#v:linearGradientNodeGetNColorStops"
        })


#endif

-- method LinearGradientNode::get_start
-- method type : OrdinaryMethod
-- Args: [ Arg
--           { argCName = "node"
--           , argType =
--               TInterface Name { namespace = "Gsk" , name = "LinearGradientNode" }
--           , direction = DirectionIn
--           , mayBeNull = False
--           , argDoc =
--               Documentation
--                 { rawDocText = Just "a `GskRenderNode` for a linear gradient"
--                 , sinceVersion = Nothing
--                 }
--           , argScope = ScopeTypeInvalid
--           , argClosure = -1
--           , argDestroy = -1
--           , argCallerAllocates = False
--           , argCallbackUserData = False
--           , transfer = TransferNothing
--           }
--       ]
-- Lengths: []
-- returnType: Just (TInterface Name { namespace = "Graphene" , name = "Point" })
-- throws : False
-- Skip return : False

foreign import ccall "gsk_linear_gradient_node_get_start" gsk_linear_gradient_node_get_start :: 
    Ptr LinearGradientNode ->               -- node : TInterface (Name {namespace = "Gsk", name = "LinearGradientNode"})
    IO (Ptr Graphene.Point.Point)

-- | Retrieves the initial point of the linear gradient.
linearGradientNodeGetStart ::
    (B.CallStack.HasCallStack, MonadIO m, IsLinearGradientNode a) =>
    a
    -- ^ /@node@/: a @GskRenderNode@ for a linear gradient
    -> m Graphene.Point.Point
    -- ^ __Returns:__ the initial point
linearGradientNodeGetStart node = liftIO $ do
    node' <- unsafeManagedPtrCastPtr node
    result <- gsk_linear_gradient_node_get_start node'
    checkUnexpectedReturnNULL "linearGradientNodeGetStart" result
    result' <- (newBoxed Graphene.Point.Point) result
    touchManagedPtr node
    return result'

#if defined(ENABLE_OVERLOADING)
data LinearGradientNodeGetStartMethodInfo
instance (signature ~ (m Graphene.Point.Point), MonadIO m, IsLinearGradientNode a) => O.OverloadedMethod LinearGradientNodeGetStartMethodInfo a signature where
    overloadedMethod = linearGradientNodeGetStart

instance O.OverloadedMethodInfo LinearGradientNodeGetStartMethodInfo a where
    overloadedMethodInfo = P.Just (O.ResolvedSymbolInfo {
        O.resolvedSymbolName = "GI.Gsk.Objects.LinearGradientNode.linearGradientNodeGetStart",
        O.resolvedSymbolURL = "https://hackage.haskell.org/package/gi-gsk-4.0.8/docs/GI-Gsk-Objects-LinearGradientNode.html#v:linearGradientNodeGetStart"
        })


#endif


