#define XERR
#include "modules.ih"

void Modules::compile()
{
    Process process{ Process::NONE, Process::NO_PATH};  
            // { "", Process::NONE };

    for (Data const &data: d_modules)
    {
        if (data.idx == -1)             // skip external modules
            continue;

        pushDir(data.subdir);

        string objFile{ d_location };

        if (not objFile.empty())        // use the ../tmp/o subdir
            objFile += to_string(data.idx);

        objFile += fs::path{d_interface_cc}.replace_extension(".o").string();

        if (younger(d_interface_cc, objFile))
        {
            imsg << data.subdir << ":\n";
            compile(process, objFile);
        }
       
        popDir();
    }
}

