#ifndef SBK_KCOLORCOMBOWRAPPER_H
#define SBK_KCOLORCOMBOWRAPPER_H

// Workaround to access protected functions
#ifndef protected
#  define protected public
#endif

#include <kcolorcombo.h>

#include <sbkpython.h>

#include <array>
namespace Shiboken { struct AutoDecRef; class GilState; }

namespace PySide { class DynamicQMetaObject; }

class KColorComboWrapper : public KColorCombo
{
public:
    KColorComboWrapper(::QWidget * parent = nullptr);
    KColorComboWrapper(const KColorComboWrapper &) = delete;
    KColorComboWrapper& operator=(const KColorComboWrapper &) = delete;
    KColorComboWrapper(KColorComboWrapper &&) = delete;
    KColorComboWrapper& operator=(KColorComboWrapper &&) = delete;
    ~KColorComboWrapper() override;

    void actionEvent(::QActionEvent * event) override;
    void changeEvent(::QEvent * e) override;
    void childEvent(::QChildEvent * event) override;
    void closeEvent(::QCloseEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent(::QContextMenuEvent * e) override;
    void customEvent(::QEvent * event) override;
    int devType() const override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent(::QDragEnterEvent * event) override;
    void dragLeaveEvent(::QDragLeaveEvent * event) override;
    void dragMoveEvent(::QDragMoveEvent * event) override;
    void dropEvent(::QDropEvent * event) override;
    void enterEvent(::QEnterEvent * event) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    void focusInEvent(::QFocusEvent * e) override;
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent(::QFocusEvent * e) override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent(::QHideEvent * e) override;
    void hidePopup() override;
    void initPainter(::QPainter * painter) const override;
    void initStyleOption(::QStyleOptionComboBox * option) const override;
    void inputMethodEvent(::QInputMethodEvent * arg__1) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery arg__1) const override;
    void keyPressEvent(::QKeyEvent * e) override;
    void keyReleaseEvent(::QKeyEvent * e) override;
    void leaveEvent(::QEvent * event) override;
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent(::QMouseEvent * event) override;
    void mouseMoveEvent(::QMouseEvent * event) override;
    void mousePressEvent(::QMouseEvent * e) override;
    void mouseReleaseEvent(::QMouseEvent * e) override;
    void moveEvent(::QMoveEvent * event) override;
    bool nativeEvent(const ::QByteArray & eventType, void * message, ::qintptr * result) override;
    ::QPaintEngine * paintEngine() const override;
    void paintEvent(::QPaintEvent * event) override;
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void resizeEvent(::QResizeEvent * e) override;
    void setModel(::QAbstractItemModel * model) override;
    void setVisible(bool visible) override;
    ::QPainter * sharedPainter() const override;
    void showEvent(::QShowEvent * e) override;
    void showPopup() override;
    ::QSize sizeHint() const override;
    void tabletEvent(::QTabletEvent * event) override;
    void timerEvent(::QTimerEvent * event) override;
    void wheelEvent(::QWheelEvent * e) override;

    const ::QMetaObject * metaObject() const override;
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();

    void resetPyMethodCache();

private:
    mutable std::array<PyObject *, 51> m_PyMethodCache = {nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr};
};

#endif // SBK_KCOLORCOMBOWRAPPER_H
