/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef ULTIMA8_CONVERT_U8_CONVERTUSECODEREGRET_H
#define ULTIMA8_CONVERT_U8_CONVERTUSECODEREGRET_H

#include "ultima/ultima8/convert/convert_usecode.h"
#include "ultima/ultima8/convert/crusader/convert_usecode_crusader.h"

namespace Ultima {
namespace Ultima8 {

class ConvertUsecodeRegret : public ConvertUsecode {
public:
	const char* const *intrinsics() override  { return _intrinsics;  };
	const char* const *event_names() override { return ConvertUsecodeCrusader::_event_names; };

private:
	static const char* const _intrinsics[512];
};

const char* const ConvertUsecodeRegret::_intrinsics[] = {
	// 0000
	"World::I_getAlertActive()",
	"Item::getFrame(void)",
	"Item::setFrame(uint16)",
	"Item::getMapNum(void)",
	"Item::getStatus(void)",
	"Item::orStatus(sint16)",
	"Item::equip(sint16)",
	"Item::isEntirelyOnScreen()",
	"Item::isNpc(void)",
	"Item::getZ(void)",
	"World::I_gameDifficulty()",
	"Item::getQLo(void)",
	"Item::destroy(void)",
	"Actor::I_getUnkByte()", // same as field 0x63 in No Remorse
	"Item::getX(void)",
	"Item::getY(void)",
	// 0010
	"Item::playSfxCru()",
	"Item::getShape(void)",
	"Item::I_explode()",
	"UCMachine::I_rndRange()",
	"Item::legalCreateAtCoords(uint16,uint16,uint16,uint16,uint16)",
	"Item::andStatus(void)",
	"World::I_getControlledNPCNum()",
	"Actor::I_getDir()",
	"Actor::I_getLastAnimSet()",
	"Item::I_fireWeapon()",
	"Item::create(uint16,uint16)",
	"Item::popToCoords(uint16,uint16,uint8)",
	"Actor::I_setDead()",
	"Item::push(void)",
	"Item::I_getEtherealTop()",
	"Item::getQLo(void)",
	// 0020
	"Item::setQLo(sint16)",
	"Item::getQHi(void)",
	"Item::setQHi(sint16)",
	"Item::I_getClosestDirectionInRange()",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::getCY(void)",
	"Item::getCX(void)",
	"SpriteProcess::I_createSprite()",
	"Item::setNpcNum(sint16)",
	"AudioProcess::I_playSFXCru()",
	"Item::setShape()",
	"Item::pop(void)",
	"AudioProcess::I_stopSFXCru()",
	"Item::isCompletelyOn(uint16)",
	"Item::popToContainer(uint16)",
	"Actor::I_getHp()",
	// 0030
	"Actor::I_getMana()",
	"Item::getFamily(void)",
	"Actor::destroyContents(void)",
	"AudioProcess::I_setVolumeForItemSFX(uint16,uint16,byte)",
	"Item::getDirToItem(uint16)",
	"AudioProcess::I_isSfxPlayingForObject(Item *,uint sfxno)",
	"Item::I_getRangeIfVisible()",
	"AudioProcess::I_playSFXCru()",
	"Item::andStatus(void)",
	"Kernel::resetRef(uint16,ProcessType)",
	"Item::touch(void)",
	"Egg::getEggId(void)",
	"MainActor::I_addItemCru()",
	"Actor::I_getMap()",
	"Item::callEvent11(sint16)",
	"CameraProcess::I_somethingAboutCameraUpdate()",
	// 0040
	"AudioProcess::I_stopSFXCru()",
	"Item::isOn(uint16)",
	"Item::getQHi(void)",
	"Item::isOn(uint16)",
	"Item::getQHi(void)",
	"Item::isOn(uint16)",
	"Item::getQHi(void)",
	"Item::isOn(uint16)",
	"Item::getQHi(void)",
	"Item::isOn(uint16)",
	"Item::getQHi(void)",
	"Item::isOn(uint16)",
	"Item::getQHi(void)",
	"Actor::I_getCurrentActivityNo()",
	"Actor::isDead(void)",
	"Actor::I_clrInCombat()",
	// 0050
	"Actor::I_setDefaultActivity0()",
	"Actor::I_setDefaultActivity1()",
	"Actor::I_setDefaultActivity2()",
	"Actor::I_setActivity()",
	"World::I_setControlledNPCNum()",
	"Item::I_receiveHit()",
	"Game::I_isReleaseBuild()",
	"MainActor::I_setMana()",
	"Item::use(void)",
	"Item::setUnkEggType(sint16)",
	"MusicProcess::I_playMusic()",
	"Item::getSurfaceWeight(void)",
	"Item::I_isCentreOn()",
	"Item::setFrame(uint16)",
	"Actor::I_getLastAnimSet()",
	"Ultima8Engine::I_setAvatarInStasis()",
	// 0060
	"Actor::I_isBusy()",
	"Actor::I_getField0x13Flag2()",
	"Actor::I_doAnim()",
	"Item::legalCreateAtPoint(uint16,uint16,WorldPoint&)",
	"Item::getPoint(WorldPoint&)",
	"Item::legalMoveToPoint(WorldPoint&,uint16,uint16)",
	"Item::fall(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Kernel::getNumProcesses(uint16,ProcessType)",
	"Item::getCY(void)",
	"U8Engine::I_isCfgAnimationOff()",
	"ResetKeyboardState()",
	"MusicProcess::I_pauseMusic()",
	"MovieGump::I_playMovieCutsceneRegret()",
	"MusicProcess::I_unpauseMusic()",
	"Item::isInNpc(void)",
	// 0070
	"Ultima8Engine::I_setCruStasis()",
	"Ultima8Engine::I_clrCruStasis()",
	"PaletteFaderProcess::I_jumpToColor()",
	"PaletteFaderProcess::I_fadeToGamePal()",
	"Actor::isDead(void)",
	"Item::getNpcNum(void)",
	"IntrinsicReturn0",
	"Game::I_isViolenceEnabled()",
	"Item::unequip(sint16)",
	"Item::andStatus(void)",
	"Item::move(uint16,uint16,uint8)",
	"Ultima8Engine::I_getCrusaderTeleporting()",
	"Ultima8Engine::I_setCrusaderTeleporting()",
	"Ultima8Engine::I_clrCrusaderTeleporting()",
	"Actor::I_turnToward()",
	"PaletteFaderProcess::I_fadeToBlack()",
	// 0080
	"MainActor::I_clrKeycards()",
	"MusicProcess::I_stopMusic()",
	"PaletteFaderProcess::I_jumpToAllBlack()",
	"I_setUnkFlagA4()",
	"I_clearUnkFlagA4()",
	"MainActor::I_switchMap(int16)",
	"teleportToEgg(sint16,int,uint8)",
	"PaletteFaderProcess::I_fadeToGamePal()",
	"Actor::I_clrImmortal()",
	"Actor::I_setActivity()",
	"Item::getQuality(void)",
	"Item::setQuality(sint16)",
	"MainActor::I_getMaxEnergy()",
	"CameraProcess::I_moveTo(x,y,z)",
	"Actor::I_setImmortal()",
	"Camera::getX(void)",
	// 0090
	"Camera::getY(void)",
	"Item::setMapNum(sint16)",
	"Item::getNpcNum(void)",
	"Item::shoot(WorldPoint&,sint16,sint16)",
	"CameraProcess::I_setCenterOn()",
	"Item::enterFastArea(void)",
	"Item::setBroken()",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::getNpcNum(void)",
	"Ultima8Engine::I_moveKeyDownRecently()",
	"teleportToEgg(sint16,uint8)",
	"Actor::I_createActor()",
	"Actor::I_clrInCombat()",
	"PaletteFaderProcess::I_jumpToGreyScale()",
	"PaletteFaderProcess::I_jumpToNormalPalette()",
	"CruStatusGump::I_showStatusGump()",
	// 00A0
	"Item::andStatus(void)",
	"Item::getUnkEggType(void)",
	"Egg::setEggXRange(uint16)",
	"Item::setFrame(uint16)",
	"Item::overlaps(uint16)",
	"Item::isOn(uint16)",
	"Item::getQHi(void)",
	"Actor::I_getLastAnimSet()",
	"Item::getCY(void)",
	"CurrentMap::I_canExistAt()", // Equivalent to Intrinsic00BB() in Remorse
	"Item::isOn(uint16)",
	"Actor::isDead(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::I_inFastArea()",
	"Item::getQHi(void)",
	"Item::andStatus(void)",
	// 00B0
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::andStatus(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::andStatus(void)",
	"Item::getDirToCoords(uint16,uint16)",
	"MainActor::I_removeItem(uint16)",
	"I_updateInventoryUI()",
	"Item::getNpcNum(void)",
	"Item::getCY(void)",
	"Item::isOn(uint16)",
	"Item::getFootpad(sint16&,sint16&,sint16&)",
	"Actor::isDead(void)",
	"Actor::I_createActorCru()",
	"Actor::I_setActivity()",
	"KeypadGump::I_showKeypad()",
	"Item::andStatus(void)",
	// 00C0
	"ComputerGump::I_readComputer()",
	"UCMachine::I_numToStr()",
	"IntrinsicReturn0",
	"Actor::I_getDir()",
	"Item::getQHi(void)",
	"Item::setQuality(sint16)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Actor::I_addHp()",
	"CruHealerProcess::I_create()",
	"Item::callEvent0A(sint16)",
	"Item::setBroken()",
	"Item::isOn(uint16)",
	"Actor::I_teleport()",
	"Item::I_getDirFromTo16()",
	"Item::getQHi(void)",
	"Item::isOn(uint16)",
	// 00D0
	"Actor::I_isInCombat()",
	"Actor::I_getNPCDataField0x4()",
	"Actor::I_setCombatTactic()",
	"Actor::I_setDead())",
	"CameraProcess::I_getCameraY()",
	"Actor::I_getEquip()",
	"Actor::I_setEquip()",
	"Actor::I_getDefaultActivity0()",
	"Actor::I_getDefaultActivity1()",
	"Actor::I_getDefaultActivity2()",
	"Actor::I_getLastAnimSet()",
	"Actor::I_isFalling()",
	"Item::getQLo(void)",
	"Item::getQHi(void)",
	"Item::getNpcNum(void)",
	"Item::I_setField0x81()",
	// 00E0
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Actor::I_setDead()",
	"Item::getQLo(void)",
	"Item::getCY(void)",
	"Item::getNpcNum(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::getNpcNum(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::getNpcNum(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::getNpcNum(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::getNpcNum(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::getNpcNum(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	// 00F0
	"Item::getNpcNum(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::getNpcNum(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::getNpcNum(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::getNpcNum(void)",
	"Item::andStatus(void)",
	"Actor::I_setDead()",
	"Item::getQLo(void)",
	"Actor::I_setDead()",
	"Dtable::I_getMaxHPForNPC()",
	"Actor::I_setHP()",
	"Item::getQLo(void)",
	"BatteryChargerProcess::I_create()",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	// 0100
	"Item::andStatus(void)",
	"Item::isOn(uint16)",
	"Actor::isDead(void)",
	"Actor::I_setActivity()",
	"Item::getQHi(void)",
	"Actor::I_getLastAnimSet()",
	"Actor::I_setDead()",
	"Item::getQLo(void)",
	"Item::isOn(uint16)",
	"Item::getQHi(void)",
	"Item::isOn(uint16)",
	"Item::getQHi(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::getNpcNum(void)",
	"Item::getCY(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	// 0110
	"Item::isOn(uint16)",
	"MainActor::I_hasKeycard()",
	"IntrinsicReturn0",
	"Actor::isDead(void)",
	"Actor::I_clrImmortal()",
	"UCMachine::I_numToStr()",
	"Item::getQHi(void)",
	"Actor::I_setActivity()",
	"Item::andStatus(void)",
	"Item::getNpcNum(void)",
	"Item::andStatus(void)",
	"Item::getNpcNum(void)",
	"Item::I_isCrusTypeNPC()",
	"Item::andStatus(void)",
	"Item::getNpcNum(void)",
	"Item::AvatarStoleSomehting(uint16)",
	// 0120
	"Item::andStatus(void)",
	"Item::getNpcNum(void)",
	"Item::getQ(void)",
	"Item::setQ(uint)",
	"Item::andStatus(void)",
	"Item::getNpcNum(void)",
	"Item::andStatus(void)",
	"Item::getNpcNum(void)",
	"Item::andStatus(void)",
	"Item::getNpcNum(void)",
	"Item::andStatus(void)",
	"Item::getNpcNum(void)",
	"Item::andStatus(void)",
	"Item::getNpcNum(void)",
	"Actor::I_getDir()",
	"Item::andStatus(void)",
	// 0130
	"Item::getNpcNum(void)",
	"Intrinsic0131()",
	"Item::andStatus(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::andStatus(void)",
	"Camera::getY(void)",
	"Camera::getZ(void)",
	"CruStatusGump::I_hideStatusGump()",
	"Actor::I_clrInCombat()",
	"Item::getTypeFlagCrusader(sint16)",
	"Item::getNpcNum(void)",
	"Item::hurl(sint16,sint16,sint16,sint16)",
	"Item::getCY(void)",
	"Item::getCZ(void)",
	"Item::setFrame(uint16)",
	"AudioProcess::I_playAmbientSFX()",
	// 0140
	"AudioProcess::I_isSFXPlaying()",
	"World::I_clrAlertActiveRegret()",
	"PaletteFaderProcess::I_fadeToGivenColor()",
	"Actor::isDead(void)",
	"Actor::I_setDead()",
	"Game::I_playCredits()",
	"PaletteFaderProcess::I_jumpToAllGrey()",
	"Item::I_getFamilyOfType()",
	"Item::getNpcNum(void)",
	"Item::getQLo(void)",
	"Item::andStatus(void)",
	"Ultima8Engine::getCurrentTimerTick()",
	"World::I_setAlertActiveRegret()",
	"Ultima8Engine::I_getAvatarInStasis()",
	"MainActor::I_addItemCru()",
	"Egg::getEggXRange(void)",
	// 0150
	"Actor::I_clrInCombat()",
	"PaletteFaderProcess::I_jumpToColor()",
	"Item::setFrame(uint16)",
	"UCMachine::I_numToStr()",
	"Actor::I_getDir()",
	"UCMachine::I_numToStr()",
	"Item::isOn(uint16)",
	"Actor::I_getDir()",
	"Actor::I_setDead()",
	"Item::getQHi(void)",
	"Item::getQLo(void)",
	"UCMachine::I_numToStr()",
	"Actor::I_getDir()",
	"Intrinsic015D()",
	0
};


} // End of namespace Ultima8
} // End of namespace Ultima

#endif
