/* XmlString.c generated by valac 0.56.14, the Vala compiler
 * generated from XmlString.vala, do not modify */

/*
    Copyright (C) 2014 2015 Johan Mattsson

    This library is free software; you can redistribute it and/or modify 
    it under the terms of the GNU Lesser General Public License as 
    published by the Free Software Foundation; either version 3 of the 
    License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful, but 
    WITHOUT ANY WARRANTY; without even the implied warranty of 
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU 
    Lesser General Public License for more details.
*/

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <assert.h>
#include "xmlbird.h"

#define B_TYPE_XML_STRING (b_xml_string_get_type ())
#define B_XML_STRING(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), B_TYPE_XML_STRING, BXmlString))
#define B_XML_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), B_TYPE_XML_STRING, BXmlStringClass))
#define B_IS_XML_STRING(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), B_TYPE_XML_STRING))
#define B_IS_XML_STRING_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), B_TYPE_XML_STRING))
#define B_XML_STRING_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), B_TYPE_XML_STRING, BXmlStringClass))

typedef struct _BXmlString BXmlString;
typedef struct _BXmlStringClass BXmlStringClass;
typedef struct _BXmlStringPrivate BXmlStringPrivate;
enum  {
	B_XML_STRING_0_PROPERTY,
	B_XML_STRING_NUM_PROPERTIES
};
static GParamSpec* b_xml_string_properties[B_XML_STRING_NUM_PROPERTIES];

struct _BXmlString {
	GObject parent_instance;
	BXmlStringPrivate * priv;
	gint length;
	gchar* data;
};

struct _BXmlStringClass {
	GObjectClass parent_class;
};

static gpointer b_xml_string_parent_class = NULL;

VALA_EXTERN GType b_xml_string_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BXmlString* b_xml_string_new (gchar* data,
                              gint length);
VALA_EXTERN BXmlString* b_xml_string_construct (GType object_type,
                                    gchar* data,
                                    gint length);
VALA_EXTERN BXmlString* b_xml_string_new_empty (void);
VALA_EXTERN BXmlString* b_xml_string_construct_empty (GType object_type);
VALA_EXTERN gint b_xml_string_find_next_tag_separator (BXmlString* self,
                                           gint start);
VALA_EXTERN gboolean b_xml_string_get_next_ascii_char (BXmlString* self,
                                           gint* index,
                                           gunichar* c);
VALA_EXTERN gint b_xml_string_index_of (BXmlString* self,
                            const gchar* needle,
                            gint offset);
VALA_EXTERN gboolean b_xml_string_has_prefix (BXmlString* self,
                                  const gchar* prefix);
VALA_EXTERN gboolean b_xml_string_has_suffix (BXmlString* self,
                                  const gchar* suffix);
VALA_EXTERN gboolean b_xml_string_get_next_char (BXmlString* self,
                                     gint* index,
                                     gunichar* c);
VALA_EXTERN BXmlString* b_xml_string_substring (BXmlString* self,
                                    gint offset,
                                    gint len);
VALA_EXTERN gchar* b_xml_string_to_string (BXmlString* self);
static void b_xml_string_finalize (GObject * obj);
static GType b_xml_string_get_type_once (void);

BXmlString*
b_xml_string_construct (GType object_type,
                        gchar* data,
                        gint length)
{
	BXmlString * self = NULL;
	self = (BXmlString*) g_object_new (object_type, NULL);
	self->data = data;
	self->length = length;
	return self;
}

BXmlString*
b_xml_string_new (gchar* data,
                  gint length)
{
	return b_xml_string_construct (B_TYPE_XML_STRING, data, length);
}

BXmlString*
b_xml_string_construct_empty (GType object_type)
{
	BXmlString * self = NULL;
	self = (BXmlString*) g_object_new (object_type, NULL);
	self->data = "";
	self->length = 0;
	return self;
}

BXmlString*
b_xml_string_new_empty (void)
{
	return b_xml_string_construct_empty (B_TYPE_XML_STRING);
}

gint
b_xml_string_find_next_tag_separator (BXmlString* self,
                                      gint start)
{
	gint index = 0;
	gint previous_index = 0;
	gunichar c = 0U;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	index = start;
	previous_index = start;
	while (TRUE) {
		gunichar _tmp0_ = 0U;
		gboolean _tmp1_;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		previous_index = index;
		_tmp1_ = b_xml_string_get_next_ascii_char (self, &index, &_tmp0_);
		c = _tmp0_;
		if (!_tmp1_) {
			break;
		}
		if (c == ((gunichar) ' ')) {
			_tmp6_ = TRUE;
		} else {
			_tmp6_ = c == ((gunichar) '\t');
		}
		if (_tmp6_) {
			_tmp5_ = TRUE;
		} else {
			_tmp5_ = c == ((gunichar) '\n');
		}
		if (_tmp5_) {
			_tmp4_ = TRUE;
		} else {
			_tmp4_ = c == ((gunichar) '\r');
		}
		if (_tmp4_) {
			_tmp3_ = TRUE;
		} else {
			_tmp3_ = c == ((gunichar) '>');
		}
		if (_tmp3_) {
			_tmp2_ = TRUE;
		} else {
			_tmp2_ = c == ((gunichar) '/');
		}
		if (_tmp2_) {
			result = previous_index;
			return result;
		}
	}
	result = -1;
	return result;
}

gint
b_xml_string_index_of (BXmlString* self,
                       const gchar* needle,
                       gint offset)
{
	gint len = 0;
	gint needle_len = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* needle_data = NULL;
	gchar* haystack = NULL;
	gchar* _tmp2_;
	gboolean _tmp3_ = FALSE;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (needle != NULL, 0);
	len = self->length;
	_tmp0_ = strlen (needle);
	_tmp1_ = _tmp0_;
	needle_len = _tmp1_;
	needle_data = (gchar*) needle;
	_tmp2_ = self->data;
	haystack = _tmp2_ + offset;
	if (needle_len == 0) {
		_tmp3_ = TRUE;
	} else {
		_tmp3_ = offset > self->length;
	}
	if (_tmp3_) {
		result = -1;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gchar* _tmp6_;
				gchar _tmp7_;
				if (!_tmp4_) {
					gint _tmp5_;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				if (!(i < len)) {
					break;
				}
				_tmp6_ = haystack;
				_tmp7_ = _tmp6_[i];
				if (_tmp7_ == '\0') {
					result = -1;
					return result;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp8_ = FALSE;
						_tmp8_ = TRUE;
						while (TRUE) {
							gboolean _tmp10_ = FALSE;
							gchar* _tmp11_;
							gchar _tmp12_;
							gchar* _tmp13_;
							gchar _tmp14_;
							if (!_tmp8_) {
								gint _tmp9_;
								_tmp9_ = j;
								j = _tmp9_ + 1;
							}
							_tmp8_ = FALSE;
							if (j <= needle_len) {
								_tmp10_ = (i + j) < len;
							} else {
								_tmp10_ = FALSE;
							}
							if (!_tmp10_) {
								break;
							}
							if (j == needle_len) {
								result = offset + i;
								return result;
							}
							_tmp11_ = needle_data;
							_tmp12_ = _tmp11_[j];
							_tmp13_ = haystack;
							_tmp14_ = _tmp13_[i + j];
							if (_tmp12_ != _tmp14_) {
								break;
							}
						}
					}
				}
			}
		}
	}
	result = -1;
	return result;
}

gboolean
b_xml_string_has_prefix (BXmlString* self,
                         const gchar* prefix)
{
	const gchar* s = NULL;
	gchar* _tmp0_;
	gboolean p = FALSE;
	const gchar* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (prefix != NULL, FALSE);
	_tmp0_ = self->data;
	s = (const gchar*) _tmp0_;
	_tmp1_ = s;
	p = g_str_has_prefix (_tmp1_, prefix);
	if (!p) {
		result = FALSE;
		return result;
	}
	_tmp2_ = strlen (prefix);
	_tmp3_ = _tmp2_;
	result = self->length > _tmp3_;
	return result;
}

gboolean
b_xml_string_has_suffix (BXmlString* self,
                         const gchar* suffix)
{
	gint suffix_length = 0;
	gint _tmp0_;
	gint _tmp1_;
	gchar* _tmp2_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (suffix != NULL, FALSE);
	_tmp0_ = strlen (suffix);
	_tmp1_ = _tmp0_;
	suffix_length = _tmp1_;
	if (self->length < suffix_length) {
		result = FALSE;
		return result;
	}
	_tmp2_ = self->data;
	result = strncmp ((const gchar*) ((_tmp2_ + self->length) - suffix_length), suffix, (gsize) suffix_length) == 0;
	return result;
}

static gboolean
string_get_next_char (const gchar* self,
                      gint* index,
                      gunichar* c)
{
	gunichar _vala_c = 0U;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_c = g_utf8_get_char (((gchar*) self) + (*index));
	if (_vala_c != ((gunichar) 0)) {
		gchar* _tmp0_;
		_tmp0_ = g_utf8_next_char (((gchar*) self) + (*index));
		*index = (gint) (_tmp0_ - ((gchar*) self));
		result = TRUE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	} else {
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
}

gboolean
b_xml_string_get_next_char (BXmlString* self,
                            gint* index,
                            gunichar* c)
{
	gunichar _vala_c = 0U;
	const gchar* s = NULL;
	const gchar* n = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gunichar _tmp3_ = 0U;
	gboolean _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->data;
	n = (const gchar*) _tmp0_;
	if ((*index) >= self->length) {
		_vala_c = (gunichar) '\0';
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	_tmp1_ = n;
	s = (const gchar*) _tmp1_;
	_tmp2_ = s;
	_tmp4_ = string_get_next_char (_tmp2_, index, &_tmp3_);
	_vala_c = _tmp3_;
	result = _tmp4_;
	if (c) {
		*c = _vala_c;
	}
	return result;
}

gboolean
b_xml_string_get_next_ascii_char (BXmlString* self,
                                  gint* index,
                                  gunichar* c)
{
	gunichar _vala_c = 0U;
	static const gchar first_bit = (gchar) (1 << 7);
	gint i = 0;
	gchar* d = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar _tmp2_;
	gunichar _tmp9_ = 0U;
	gboolean _tmp10_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	i = *index;
	_tmp0_ = self->data;
	d = _tmp0_;
	if ((*index) >= self->length) {
		_vala_c = (gunichar) '\0';
		result = FALSE;
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	_tmp1_ = d;
	_tmp2_ = _tmp1_[i];
	if (((gint) (_tmp2_ & first_bit)) == 0) {
		gchar* _tmp3_;
		gchar _tmp4_;
		gint _tmp5_;
		_tmp3_ = d;
		_tmp4_ = _tmp3_[i];
		_vala_c = (gunichar) _tmp4_;
		_tmp5_ = *index;
		*index = _tmp5_ + 1;
		result = _vala_c != ((gunichar) '\0');
		if (c) {
			*c = _vala_c;
		}
		return result;
	}
	while (TRUE) {
		gchar* _tmp6_;
		gchar _tmp7_;
		gint _tmp8_;
		_tmp6_ = d;
		_tmp7_ = _tmp6_[i];
		if (!(((gint) (_tmp7_ & first_bit)) != 0)) {
			break;
		}
		_tmp8_ = i;
		i = _tmp8_ + 1;
	}
	*index = i;
	_tmp10_ = b_xml_string_get_next_char (self, index, &_tmp9_);
	_vala_c = _tmp9_;
	result = _tmp10_;
	if (c) {
		*c = _vala_c;
	}
	return result;
}

BXmlString*
b_xml_string_substring (BXmlString* self,
                        gint offset,
                        gint len)
{
	gchar* _tmp2_;
	BXmlString* _tmp3_;
	BXmlString* result;
	g_return_val_if_fail (self != NULL, NULL);
	assert (offset >= 0);
	assert (offset < self->length);
	if (len == -1) {
		gchar* _tmp0_;
		BXmlString* _tmp1_;
		_tmp0_ = self->data;
		_tmp1_ = b_xml_string_new (_tmp0_ + offset, self->length - offset);
		result = _tmp1_;
		return result;
	}
	assert ((len + offset) < self->length);
	_tmp2_ = self->data;
	_tmp3_ = b_xml_string_new (_tmp2_ + offset, len);
	result = _tmp3_;
	return result;
}

gchar*
b_xml_string_to_string (BXmlString* self)
{
	const gchar* s = NULL;
	gchar* _tmp0_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->data;
	s = (const gchar*) _tmp0_;
	if (self->length == 0) {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("");
		result = _tmp1_;
		return result;
	}
	_tmp2_ = s;
	_tmp3_ = g_strndup (_tmp2_, (gsize) self->length);
	result = _tmp3_;
	return result;
}

static void
b_xml_string_class_init (BXmlStringClass * klass,
                         gpointer klass_data)
{
	b_xml_string_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = b_xml_string_finalize;
}

static void
b_xml_string_instance_init (BXmlString * self,
                            gpointer klass)
{
}

static void
b_xml_string_finalize (GObject * obj)
{
	BXmlString * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, B_TYPE_XML_STRING, BXmlString);
	G_OBJECT_CLASS (b_xml_string_parent_class)->finalize (obj);
}

/** 
 * Representation of a string in the XmlParser. This class adds reference 
 * counting and copies a pointer to the string instead of the data. It is 
 * faster if the string is big.
 */
static GType
b_xml_string_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BXmlStringClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) b_xml_string_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BXmlString), 0, (GInstanceInitFunc) b_xml_string_instance_init, NULL };
	GType b_xml_string_type_id;
	b_xml_string_type_id = g_type_register_static (G_TYPE_OBJECT, "BXmlString", &g_define_type_info, 0);
	return b_xml_string_type_id;
}

GType
b_xml_string_get_type (void)
{
	static volatile gsize b_xml_string_type_id__once = 0;
	if (g_once_init_enter (&b_xml_string_type_id__once)) {
		GType b_xml_string_type_id;
		b_xml_string_type_id = b_xml_string_get_type_once ();
		g_once_init_leave (&b_xml_string_type_id__once, b_xml_string_type_id);
	}
	return b_xml_string_type_id__once;
}

