// Copyright (C) 2018 The Android Open Source Project
// Copyright (C) 2018 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Autogenerated module goldfish_vk_deepcopy_guest
//
// (header) generated by ../mesa-25.2.7/src/gfxstream/codegen/scripts/genvk.py -registry ../mesa-25.2.7/src/vulkan/registry/vk.xml -registryGfxstream ../mesa-25.2.7/src/gfxstream/codegen/xml/vk_gfxstream.xml cereal -o /build/mesa/src/build/src/gfxstream/guest/vulkan_enc/host/vulkan/cereal
//
// Please do not modify directly;
// re-run mesa3d/src/gfxstream/codegen/generate-gfxstream-vulkan.sh,
// or directly from Python by defining:
// VULKAN_REGISTRY_XML_DIR : Directory containing vk.xml
// VULKAN_REGISTRY_SCRIPTS_DIR : Directory containing genvk.py
// CEREAL_OUTPUT_DIR: Where to put the generated sources.
//
// python3 $VULKAN_REGISTRY_SCRIPTS_DIR/genvk.py -registry $VULKAN_REGISTRY_XML_DIR/vk.xml cereal -o $CEREAL_OUTPUT_DIR
//
#pragma once
#include <vulkan/vulkan.h>
#include "vulkan_gfxstream.h"
#include "vk_android_native_buffer_gfxstream.h"

#include "vk_platform_compat.h"

#include "goldfish_vk_private_defs.h"
#include "BumpPool.h"
using gfxstream::aemu::Allocator;
using gfxstream::aemu::BumpPool;
// Stuff we are not going to use but if included,
// will cause compile errors. These are Android Vulkan
// required extensions, but the approach will be to
// implement them completely on the guest side.
#undef VK_KHR_android_surface
#undef VK_ANDROID_external_memory_android_hardware_buffer


namespace gfxstream {
namespace vk {

#ifdef VK_VERSION_1_0
void deepcopy_VkExtent2D(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExtent2D* from,
    VkExtent2D* to);

void deepcopy_VkExtent3D(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExtent3D* from,
    VkExtent3D* to);

void deepcopy_VkOffset2D(
    Allocator* alloc,
    VkStructureType rootType,
    const VkOffset2D* from,
    VkOffset2D* to);

void deepcopy_VkOffset3D(
    Allocator* alloc,
    VkStructureType rootType,
    const VkOffset3D* from,
    VkOffset3D* to);

void deepcopy_VkRect2D(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRect2D* from,
    VkRect2D* to);

void deepcopy_VkBaseInStructure(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBaseInStructure* from,
    VkBaseInStructure* to);

void deepcopy_VkBaseOutStructure(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBaseOutStructure* from,
    VkBaseOutStructure* to);

void deepcopy_VkBufferMemoryBarrier(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferMemoryBarrier* from,
    VkBufferMemoryBarrier* to);

void deepcopy_VkDispatchIndirectCommand(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDispatchIndirectCommand* from,
    VkDispatchIndirectCommand* to);

void deepcopy_VkDrawIndexedIndirectCommand(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDrawIndexedIndirectCommand* from,
    VkDrawIndexedIndirectCommand* to);

void deepcopy_VkDrawIndirectCommand(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDrawIndirectCommand* from,
    VkDrawIndirectCommand* to);

void deepcopy_VkImageSubresourceRange(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageSubresourceRange* from,
    VkImageSubresourceRange* to);

void deepcopy_VkImageMemoryBarrier(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageMemoryBarrier* from,
    VkImageMemoryBarrier* to);

void deepcopy_VkMemoryBarrier(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryBarrier* from,
    VkMemoryBarrier* to);

void deepcopy_VkPipelineCacheHeaderVersionOne(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineCacheHeaderVersionOne* from,
    VkPipelineCacheHeaderVersionOne* to);

void deepcopy_VkAllocationCallbacks(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAllocationCallbacks* from,
    VkAllocationCallbacks* to);

void deepcopy_VkApplicationInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkApplicationInfo* from,
    VkApplicationInfo* to);

void deepcopy_VkFormatProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFormatProperties* from,
    VkFormatProperties* to);

void deepcopy_VkImageFormatProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageFormatProperties* from,
    VkImageFormatProperties* to);

void deepcopy_VkInstanceCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkInstanceCreateInfo* from,
    VkInstanceCreateInfo* to);

void deepcopy_VkMemoryHeap(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryHeap* from,
    VkMemoryHeap* to);

void deepcopy_VkMemoryType(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryType* from,
    VkMemoryType* to);

void deepcopy_VkPhysicalDeviceFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures* from,
    VkPhysicalDeviceFeatures* to);

void deepcopy_VkPhysicalDeviceLimits(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceLimits* from,
    VkPhysicalDeviceLimits* to);

void deepcopy_VkPhysicalDeviceMemoryProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties* from,
    VkPhysicalDeviceMemoryProperties* to);

void deepcopy_VkPhysicalDeviceSparseProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseProperties* from,
    VkPhysicalDeviceSparseProperties* to);

void deepcopy_VkPhysicalDeviceProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties* from,
    VkPhysicalDeviceProperties* to);

void deepcopy_VkQueueFamilyProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkQueueFamilyProperties* from,
    VkQueueFamilyProperties* to);

void deepcopy_VkDeviceQueueCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceQueueCreateInfo* from,
    VkDeviceQueueCreateInfo* to);

void deepcopy_VkDeviceCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceCreateInfo* from,
    VkDeviceCreateInfo* to);

void deepcopy_VkExtensionProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExtensionProperties* from,
    VkExtensionProperties* to);

void deepcopy_VkLayerProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkLayerProperties* from,
    VkLayerProperties* to);

void deepcopy_VkSubmitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubmitInfo* from,
    VkSubmitInfo* to);

void deepcopy_VkMappedMemoryRange(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMappedMemoryRange* from,
    VkMappedMemoryRange* to);

void deepcopy_VkMemoryAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryAllocateInfo* from,
    VkMemoryAllocateInfo* to);

void deepcopy_VkMemoryRequirements(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryRequirements* from,
    VkMemoryRequirements* to);

void deepcopy_VkSparseMemoryBind(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseMemoryBind* from,
    VkSparseMemoryBind* to);

void deepcopy_VkSparseBufferMemoryBindInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseBufferMemoryBindInfo* from,
    VkSparseBufferMemoryBindInfo* to);

void deepcopy_VkSparseImageOpaqueMemoryBindInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageOpaqueMemoryBindInfo* from,
    VkSparseImageOpaqueMemoryBindInfo* to);

void deepcopy_VkImageSubresource(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageSubresource* from,
    VkImageSubresource* to);

void deepcopy_VkSparseImageMemoryBind(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageMemoryBind* from,
    VkSparseImageMemoryBind* to);

void deepcopy_VkSparseImageMemoryBindInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageMemoryBindInfo* from,
    VkSparseImageMemoryBindInfo* to);

void deepcopy_VkBindSparseInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindSparseInfo* from,
    VkBindSparseInfo* to);

void deepcopy_VkSparseImageFormatProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageFormatProperties* from,
    VkSparseImageFormatProperties* to);

void deepcopy_VkSparseImageMemoryRequirements(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements* from,
    VkSparseImageMemoryRequirements* to);

void deepcopy_VkFenceCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFenceCreateInfo* from,
    VkFenceCreateInfo* to);

void deepcopy_VkSemaphoreCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSemaphoreCreateInfo* from,
    VkSemaphoreCreateInfo* to);

void deepcopy_VkEventCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkEventCreateInfo* from,
    VkEventCreateInfo* to);

void deepcopy_VkQueryPoolCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkQueryPoolCreateInfo* from,
    VkQueryPoolCreateInfo* to);

void deepcopy_VkBufferCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferCreateInfo* from,
    VkBufferCreateInfo* to);

void deepcopy_VkBufferViewCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferViewCreateInfo* from,
    VkBufferViewCreateInfo* to);

void deepcopy_VkImageCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageCreateInfo* from,
    VkImageCreateInfo* to);

void deepcopy_VkSubresourceLayout(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubresourceLayout* from,
    VkSubresourceLayout* to);

void deepcopy_VkComponentMapping(
    Allocator* alloc,
    VkStructureType rootType,
    const VkComponentMapping* from,
    VkComponentMapping* to);

void deepcopy_VkImageViewCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageViewCreateInfo* from,
    VkImageViewCreateInfo* to);

void deepcopy_VkShaderModuleCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkShaderModuleCreateInfo* from,
    VkShaderModuleCreateInfo* to);

void deepcopy_VkPipelineCacheCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineCacheCreateInfo* from,
    VkPipelineCacheCreateInfo* to);

void deepcopy_VkSpecializationMapEntry(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSpecializationMapEntry* from,
    VkSpecializationMapEntry* to);

void deepcopy_VkSpecializationInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSpecializationInfo* from,
    VkSpecializationInfo* to);

void deepcopy_VkPipelineShaderStageCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineShaderStageCreateInfo* from,
    VkPipelineShaderStageCreateInfo* to);

void deepcopy_VkComputePipelineCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkComputePipelineCreateInfo* from,
    VkComputePipelineCreateInfo* to);

void deepcopy_VkVertexInputBindingDescription(
    Allocator* alloc,
    VkStructureType rootType,
    const VkVertexInputBindingDescription* from,
    VkVertexInputBindingDescription* to);

void deepcopy_VkVertexInputAttributeDescription(
    Allocator* alloc,
    VkStructureType rootType,
    const VkVertexInputAttributeDescription* from,
    VkVertexInputAttributeDescription* to);

void deepcopy_VkPipelineVertexInputStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineVertexInputStateCreateInfo* from,
    VkPipelineVertexInputStateCreateInfo* to);

void deepcopy_VkPipelineInputAssemblyStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineInputAssemblyStateCreateInfo* from,
    VkPipelineInputAssemblyStateCreateInfo* to);

void deepcopy_VkPipelineTessellationStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineTessellationStateCreateInfo* from,
    VkPipelineTessellationStateCreateInfo* to);

void deepcopy_VkViewport(
    Allocator* alloc,
    VkStructureType rootType,
    const VkViewport* from,
    VkViewport* to);

void deepcopy_VkPipelineViewportStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineViewportStateCreateInfo* from,
    VkPipelineViewportStateCreateInfo* to);

void deepcopy_VkPipelineRasterizationStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRasterizationStateCreateInfo* from,
    VkPipelineRasterizationStateCreateInfo* to);

void deepcopy_VkPipelineMultisampleStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineMultisampleStateCreateInfo* from,
    VkPipelineMultisampleStateCreateInfo* to);

void deepcopy_VkStencilOpState(
    Allocator* alloc,
    VkStructureType rootType,
    const VkStencilOpState* from,
    VkStencilOpState* to);

void deepcopy_VkPipelineDepthStencilStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineDepthStencilStateCreateInfo* from,
    VkPipelineDepthStencilStateCreateInfo* to);

void deepcopy_VkPipelineColorBlendAttachmentState(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineColorBlendAttachmentState* from,
    VkPipelineColorBlendAttachmentState* to);

void deepcopy_VkPipelineColorBlendStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineColorBlendStateCreateInfo* from,
    VkPipelineColorBlendStateCreateInfo* to);

void deepcopy_VkPipelineDynamicStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineDynamicStateCreateInfo* from,
    VkPipelineDynamicStateCreateInfo* to);

void deepcopy_VkGraphicsPipelineCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkGraphicsPipelineCreateInfo* from,
    VkGraphicsPipelineCreateInfo* to);

void deepcopy_VkPushConstantRange(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPushConstantRange* from,
    VkPushConstantRange* to);

void deepcopy_VkPipelineLayoutCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineLayoutCreateInfo* from,
    VkPipelineLayoutCreateInfo* to);

void deepcopy_VkSamplerCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSamplerCreateInfo* from,
    VkSamplerCreateInfo* to);

void deepcopy_VkCopyDescriptorSet(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyDescriptorSet* from,
    VkCopyDescriptorSet* to);

void deepcopy_VkDescriptorBufferInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorBufferInfo* from,
    VkDescriptorBufferInfo* to);

void deepcopy_VkDescriptorImageInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorImageInfo* from,
    VkDescriptorImageInfo* to);

void deepcopy_VkDescriptorPoolSize(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorPoolSize* from,
    VkDescriptorPoolSize* to);

void deepcopy_VkDescriptorPoolCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorPoolCreateInfo* from,
    VkDescriptorPoolCreateInfo* to);

void deepcopy_VkDescriptorSetAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetAllocateInfo* from,
    VkDescriptorSetAllocateInfo* to);

void deepcopy_VkDescriptorSetLayoutBinding(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBinding* from,
    VkDescriptorSetLayoutBinding* to);

void deepcopy_VkDescriptorSetLayoutCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetLayoutCreateInfo* from,
    VkDescriptorSetLayoutCreateInfo* to);

void deepcopy_VkWriteDescriptorSet(
    Allocator* alloc,
    VkStructureType rootType,
    const VkWriteDescriptorSet* from,
    VkWriteDescriptorSet* to);

void deepcopy_VkAttachmentDescription(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAttachmentDescription* from,
    VkAttachmentDescription* to);

void deepcopy_VkAttachmentReference(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAttachmentReference* from,
    VkAttachmentReference* to);

void deepcopy_VkFramebufferCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFramebufferCreateInfo* from,
    VkFramebufferCreateInfo* to);

void deepcopy_VkSubpassDescription(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassDescription* from,
    VkSubpassDescription* to);

void deepcopy_VkSubpassDependency(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassDependency* from,
    VkSubpassDependency* to);

void deepcopy_VkRenderPassCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassCreateInfo* from,
    VkRenderPassCreateInfo* to);

void deepcopy_VkCommandPoolCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCommandPoolCreateInfo* from,
    VkCommandPoolCreateInfo* to);

void deepcopy_VkCommandBufferAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCommandBufferAllocateInfo* from,
    VkCommandBufferAllocateInfo* to);

void deepcopy_VkCommandBufferInheritanceInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCommandBufferInheritanceInfo* from,
    VkCommandBufferInheritanceInfo* to);

void deepcopy_VkCommandBufferBeginInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCommandBufferBeginInfo* from,
    VkCommandBufferBeginInfo* to);

void deepcopy_VkBufferCopy(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferCopy* from,
    VkBufferCopy* to);

void deepcopy_VkImageSubresourceLayers(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageSubresourceLayers* from,
    VkImageSubresourceLayers* to);

void deepcopy_VkBufferImageCopy(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferImageCopy* from,
    VkBufferImageCopy* to);

void deepcopy_VkClearColorValue(
    Allocator* alloc,
    VkStructureType rootType,
    const VkClearColorValue* from,
    VkClearColorValue* to);

void deepcopy_VkClearDepthStencilValue(
    Allocator* alloc,
    VkStructureType rootType,
    const VkClearDepthStencilValue* from,
    VkClearDepthStencilValue* to);

void deepcopy_VkClearValue(
    Allocator* alloc,
    VkStructureType rootType,
    const VkClearValue* from,
    VkClearValue* to);

void deepcopy_VkClearAttachment(
    Allocator* alloc,
    VkStructureType rootType,
    const VkClearAttachment* from,
    VkClearAttachment* to);

void deepcopy_VkClearRect(
    Allocator* alloc,
    VkStructureType rootType,
    const VkClearRect* from,
    VkClearRect* to);

void deepcopy_VkImageBlit(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageBlit* from,
    VkImageBlit* to);

void deepcopy_VkImageCopy(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageCopy* from,
    VkImageCopy* to);

void deepcopy_VkImageResolve(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageResolve* from,
    VkImageResolve* to);

void deepcopy_VkRenderPassBeginInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassBeginInfo* from,
    VkRenderPassBeginInfo* to);

#endif
#ifdef VK_VERSION_1_1
void deepcopy_VkPhysicalDeviceSubgroupProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupProperties* from,
    VkPhysicalDeviceSubgroupProperties* to);

void deepcopy_VkBindBufferMemoryInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindBufferMemoryInfo* from,
    VkBindBufferMemoryInfo* to);

void deepcopy_VkBindImageMemoryInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindImageMemoryInfo* from,
    VkBindImageMemoryInfo* to);

void deepcopy_VkPhysicalDevice16BitStorageFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevice16BitStorageFeatures* from,
    VkPhysicalDevice16BitStorageFeatures* to);

void deepcopy_VkMemoryDedicatedRequirements(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryDedicatedRequirements* from,
    VkMemoryDedicatedRequirements* to);

void deepcopy_VkMemoryDedicatedAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryDedicatedAllocateInfo* from,
    VkMemoryDedicatedAllocateInfo* to);

void deepcopy_VkMemoryAllocateFlagsInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryAllocateFlagsInfo* from,
    VkMemoryAllocateFlagsInfo* to);

void deepcopy_VkDeviceGroupRenderPassBeginInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceGroupRenderPassBeginInfo* from,
    VkDeviceGroupRenderPassBeginInfo* to);

void deepcopy_VkDeviceGroupCommandBufferBeginInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceGroupCommandBufferBeginInfo* from,
    VkDeviceGroupCommandBufferBeginInfo* to);

void deepcopy_VkDeviceGroupSubmitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceGroupSubmitInfo* from,
    VkDeviceGroupSubmitInfo* to);

void deepcopy_VkDeviceGroupBindSparseInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceGroupBindSparseInfo* from,
    VkDeviceGroupBindSparseInfo* to);

void deepcopy_VkBindBufferMemoryDeviceGroupInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindBufferMemoryDeviceGroupInfo* from,
    VkBindBufferMemoryDeviceGroupInfo* to);

void deepcopy_VkBindImageMemoryDeviceGroupInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindImageMemoryDeviceGroupInfo* from,
    VkBindImageMemoryDeviceGroupInfo* to);

void deepcopy_VkPhysicalDeviceGroupProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceGroupProperties* from,
    VkPhysicalDeviceGroupProperties* to);

void deepcopy_VkDeviceGroupDeviceCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceGroupDeviceCreateInfo* from,
    VkDeviceGroupDeviceCreateInfo* to);

void deepcopy_VkBufferMemoryRequirementsInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferMemoryRequirementsInfo2* from,
    VkBufferMemoryRequirementsInfo2* to);

void deepcopy_VkImageMemoryRequirementsInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageMemoryRequirementsInfo2* from,
    VkImageMemoryRequirementsInfo2* to);

void deepcopy_VkImageSparseMemoryRequirementsInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageSparseMemoryRequirementsInfo2* from,
    VkImageSparseMemoryRequirementsInfo2* to);

void deepcopy_VkMemoryRequirements2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryRequirements2* from,
    VkMemoryRequirements2* to);

void deepcopy_VkSparseImageMemoryRequirements2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageMemoryRequirements2* from,
    VkSparseImageMemoryRequirements2* to);

void deepcopy_VkPhysicalDeviceFeatures2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceFeatures2* from,
    VkPhysicalDeviceFeatures2* to);

void deepcopy_VkPhysicalDeviceProperties2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceProperties2* from,
    VkPhysicalDeviceProperties2* to);

void deepcopy_VkFormatProperties2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFormatProperties2* from,
    VkFormatProperties2* to);

void deepcopy_VkImageFormatProperties2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageFormatProperties2* from,
    VkImageFormatProperties2* to);

void deepcopy_VkPhysicalDeviceImageFormatInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceImageFormatInfo2* from,
    VkPhysicalDeviceImageFormatInfo2* to);

void deepcopy_VkQueueFamilyProperties2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkQueueFamilyProperties2* from,
    VkQueueFamilyProperties2* to);

void deepcopy_VkPhysicalDeviceMemoryProperties2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryProperties2* from,
    VkPhysicalDeviceMemoryProperties2* to);

void deepcopy_VkSparseImageFormatProperties2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSparseImageFormatProperties2* from,
    VkSparseImageFormatProperties2* to);

void deepcopy_VkPhysicalDeviceSparseImageFormatInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSparseImageFormatInfo2* from,
    VkPhysicalDeviceSparseImageFormatInfo2* to);

void deepcopy_VkPhysicalDevicePointClippingProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePointClippingProperties* from,
    VkPhysicalDevicePointClippingProperties* to);

void deepcopy_VkInputAttachmentAspectReference(
    Allocator* alloc,
    VkStructureType rootType,
    const VkInputAttachmentAspectReference* from,
    VkInputAttachmentAspectReference* to);

void deepcopy_VkRenderPassInputAttachmentAspectCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassInputAttachmentAspectCreateInfo* from,
    VkRenderPassInputAttachmentAspectCreateInfo* to);

void deepcopy_VkImageViewUsageCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageViewUsageCreateInfo* from,
    VkImageViewUsageCreateInfo* to);

void deepcopy_VkPipelineTessellationDomainOriginStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineTessellationDomainOriginStateCreateInfo* from,
    VkPipelineTessellationDomainOriginStateCreateInfo* to);

void deepcopy_VkRenderPassMultiviewCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassMultiviewCreateInfo* from,
    VkRenderPassMultiviewCreateInfo* to);

void deepcopy_VkPhysicalDeviceMultiviewFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewFeatures* from,
    VkPhysicalDeviceMultiviewFeatures* to);

void deepcopy_VkPhysicalDeviceMultiviewProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMultiviewProperties* from,
    VkPhysicalDeviceMultiviewProperties* to);

void deepcopy_VkPhysicalDeviceVariablePointersFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVariablePointersFeatures* from,
    VkPhysicalDeviceVariablePointersFeatures* to);

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceVariablePointersFeatures, deepcopy_VkPhysicalDeviceVariablePointerFeatures)

void deepcopy_VkPhysicalDeviceProtectedMemoryFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryFeatures* from,
    VkPhysicalDeviceProtectedMemoryFeatures* to);

void deepcopy_VkPhysicalDeviceProtectedMemoryProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceProtectedMemoryProperties* from,
    VkPhysicalDeviceProtectedMemoryProperties* to);

void deepcopy_VkDeviceQueueInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceQueueInfo2* from,
    VkDeviceQueueInfo2* to);

void deepcopy_VkProtectedSubmitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkProtectedSubmitInfo* from,
    VkProtectedSubmitInfo* to);

void deepcopy_VkSamplerYcbcrConversionCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionCreateInfo* from,
    VkSamplerYcbcrConversionCreateInfo* to);

void deepcopy_VkSamplerYcbcrConversionInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionInfo* from,
    VkSamplerYcbcrConversionInfo* to);

void deepcopy_VkBindImagePlaneMemoryInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindImagePlaneMemoryInfo* from,
    VkBindImagePlaneMemoryInfo* to);

void deepcopy_VkImagePlaneMemoryRequirementsInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImagePlaneMemoryRequirementsInfo* from,
    VkImagePlaneMemoryRequirementsInfo* to);

void deepcopy_VkPhysicalDeviceSamplerYcbcrConversionFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerYcbcrConversionFeatures* from,
    VkPhysicalDeviceSamplerYcbcrConversionFeatures* to);

void deepcopy_VkSamplerYcbcrConversionImageFormatProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSamplerYcbcrConversionImageFormatProperties* from,
    VkSamplerYcbcrConversionImageFormatProperties* to);

void deepcopy_VkDescriptorUpdateTemplateEntry(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateEntry* from,
    VkDescriptorUpdateTemplateEntry* to);

void deepcopy_VkDescriptorUpdateTemplateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorUpdateTemplateCreateInfo* from,
    VkDescriptorUpdateTemplateCreateInfo* to);

void deepcopy_VkExternalMemoryProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalMemoryProperties* from,
    VkExternalMemoryProperties* to);

void deepcopy_VkPhysicalDeviceExternalImageFormatInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalImageFormatInfo* from,
    VkPhysicalDeviceExternalImageFormatInfo* to);

void deepcopy_VkExternalImageFormatProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalImageFormatProperties* from,
    VkExternalImageFormatProperties* to);

void deepcopy_VkPhysicalDeviceExternalBufferInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalBufferInfo* from,
    VkPhysicalDeviceExternalBufferInfo* to);

void deepcopy_VkExternalBufferProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalBufferProperties* from,
    VkExternalBufferProperties* to);

void deepcopy_VkPhysicalDeviceIDProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceIDProperties* from,
    VkPhysicalDeviceIDProperties* to);

void deepcopy_VkExternalMemoryImageCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalMemoryImageCreateInfo* from,
    VkExternalMemoryImageCreateInfo* to);

void deepcopy_VkExternalMemoryBufferCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalMemoryBufferCreateInfo* from,
    VkExternalMemoryBufferCreateInfo* to);

void deepcopy_VkExportMemoryAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExportMemoryAllocateInfo* from,
    VkExportMemoryAllocateInfo* to);

void deepcopy_VkPhysicalDeviceExternalFenceInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalFenceInfo* from,
    VkPhysicalDeviceExternalFenceInfo* to);

void deepcopy_VkExternalFenceProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalFenceProperties* from,
    VkExternalFenceProperties* to);

void deepcopy_VkExportFenceCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExportFenceCreateInfo* from,
    VkExportFenceCreateInfo* to);

void deepcopy_VkExportSemaphoreCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExportSemaphoreCreateInfo* from,
    VkExportSemaphoreCreateInfo* to);

void deepcopy_VkPhysicalDeviceExternalSemaphoreInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceExternalSemaphoreInfo* from,
    VkPhysicalDeviceExternalSemaphoreInfo* to);

void deepcopy_VkExternalSemaphoreProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkExternalSemaphoreProperties* from,
    VkExternalSemaphoreProperties* to);

void deepcopy_VkPhysicalDeviceMaintenance3Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance3Properties* from,
    VkPhysicalDeviceMaintenance3Properties* to);

void deepcopy_VkDescriptorSetLayoutSupport(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetLayoutSupport* from,
    VkDescriptorSetLayoutSupport* to);

void deepcopy_VkPhysicalDeviceShaderDrawParametersFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDrawParametersFeatures* from,
    VkPhysicalDeviceShaderDrawParametersFeatures* to);

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceShaderDrawParametersFeatures, deepcopy_VkPhysicalDeviceShaderDrawParameterFeatures)

#endif
#ifdef VK_VERSION_1_2
void deepcopy_VkPhysicalDeviceVulkan11Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Features* from,
    VkPhysicalDeviceVulkan11Features* to);

void deepcopy_VkPhysicalDeviceVulkan11Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan11Properties* from,
    VkPhysicalDeviceVulkan11Properties* to);

void deepcopy_VkPhysicalDeviceVulkan12Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Features* from,
    VkPhysicalDeviceVulkan12Features* to);

void deepcopy_VkConformanceVersion(
    Allocator* alloc,
    VkStructureType rootType,
    const VkConformanceVersion* from,
    VkConformanceVersion* to);

void deepcopy_VkPhysicalDeviceVulkan12Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan12Properties* from,
    VkPhysicalDeviceVulkan12Properties* to);

void deepcopy_VkImageFormatListCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageFormatListCreateInfo* from,
    VkImageFormatListCreateInfo* to);

void deepcopy_VkAttachmentDescription2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAttachmentDescription2* from,
    VkAttachmentDescription2* to);

void deepcopy_VkAttachmentReference2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAttachmentReference2* from,
    VkAttachmentReference2* to);

void deepcopy_VkSubpassDescription2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassDescription2* from,
    VkSubpassDescription2* to);

void deepcopy_VkSubpassDependency2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassDependency2* from,
    VkSubpassDependency2* to);

void deepcopy_VkRenderPassCreateInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassCreateInfo2* from,
    VkRenderPassCreateInfo2* to);

void deepcopy_VkSubpassBeginInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassBeginInfo* from,
    VkSubpassBeginInfo* to);

void deepcopy_VkSubpassEndInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassEndInfo* from,
    VkSubpassEndInfo* to);

void deepcopy_VkPhysicalDevice8BitStorageFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevice8BitStorageFeatures* from,
    VkPhysicalDevice8BitStorageFeatures* to);

void deepcopy_VkPhysicalDeviceDriverProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDriverProperties* from,
    VkPhysicalDeviceDriverProperties* to);

void deepcopy_VkPhysicalDeviceShaderAtomicInt64Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderAtomicInt64Features* from,
    VkPhysicalDeviceShaderAtomicInt64Features* to);

void deepcopy_VkPhysicalDeviceShaderFloat16Int8Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloat16Int8Features* from,
    VkPhysicalDeviceShaderFloat16Int8Features* to);

void deepcopy_VkPhysicalDeviceFloatControlsProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceFloatControlsProperties* from,
    VkPhysicalDeviceFloatControlsProperties* to);

void deepcopy_VkDescriptorSetLayoutBindingFlagsCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetLayoutBindingFlagsCreateInfo* from,
    VkDescriptorSetLayoutBindingFlagsCreateInfo* to);

void deepcopy_VkPhysicalDeviceDescriptorIndexingFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingFeatures* from,
    VkPhysicalDeviceDescriptorIndexingFeatures* to);

void deepcopy_VkPhysicalDeviceDescriptorIndexingProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDescriptorIndexingProperties* from,
    VkPhysicalDeviceDescriptorIndexingProperties* to);

void deepcopy_VkDescriptorSetVariableDescriptorCountAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountAllocateInfo* from,
    VkDescriptorSetVariableDescriptorCountAllocateInfo* to);

void deepcopy_VkDescriptorSetVariableDescriptorCountLayoutSupport(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorSetVariableDescriptorCountLayoutSupport* from,
    VkDescriptorSetVariableDescriptorCountLayoutSupport* to);

void deepcopy_VkSubpassDescriptionDepthStencilResolve(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubpassDescriptionDepthStencilResolve* from,
    VkSubpassDescriptionDepthStencilResolve* to);

void deepcopy_VkPhysicalDeviceDepthStencilResolveProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthStencilResolveProperties* from,
    VkPhysicalDeviceDepthStencilResolveProperties* to);

void deepcopy_VkPhysicalDeviceScalarBlockLayoutFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceScalarBlockLayoutFeatures* from,
    VkPhysicalDeviceScalarBlockLayoutFeatures* to);

void deepcopy_VkImageStencilUsageCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageStencilUsageCreateInfo* from,
    VkImageStencilUsageCreateInfo* to);

void deepcopy_VkSamplerReductionModeCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSamplerReductionModeCreateInfo* from,
    VkSamplerReductionModeCreateInfo* to);

void deepcopy_VkPhysicalDeviceSamplerFilterMinmaxProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSamplerFilterMinmaxProperties* from,
    VkPhysicalDeviceSamplerFilterMinmaxProperties* to);

void deepcopy_VkPhysicalDeviceVulkanMemoryModelFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkanMemoryModelFeatures* from,
    VkPhysicalDeviceVulkanMemoryModelFeatures* to);

void deepcopy_VkPhysicalDeviceImagelessFramebufferFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceImagelessFramebufferFeatures* from,
    VkPhysicalDeviceImagelessFramebufferFeatures* to);

void deepcopy_VkFramebufferAttachmentImageInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFramebufferAttachmentImageInfo* from,
    VkFramebufferAttachmentImageInfo* to);

void deepcopy_VkFramebufferAttachmentsCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFramebufferAttachmentsCreateInfo* from,
    VkFramebufferAttachmentsCreateInfo* to);

void deepcopy_VkRenderPassAttachmentBeginInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassAttachmentBeginInfo* from,
    VkRenderPassAttachmentBeginInfo* to);

void deepcopy_VkPhysicalDeviceUniformBufferStandardLayoutFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceUniformBufferStandardLayoutFeatures* from,
    VkPhysicalDeviceUniformBufferStandardLayoutFeatures* to);

void deepcopy_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* from,
    VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures* to);

void deepcopy_VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* from,
    VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures* to);

void deepcopy_VkAttachmentReferenceStencilLayout(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAttachmentReferenceStencilLayout* from,
    VkAttachmentReferenceStencilLayout* to);

void deepcopy_VkAttachmentDescriptionStencilLayout(
    Allocator* alloc,
    VkStructureType rootType,
    const VkAttachmentDescriptionStencilLayout* from,
    VkAttachmentDescriptionStencilLayout* to);

void deepcopy_VkPhysicalDeviceHostQueryResetFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceHostQueryResetFeatures* from,
    VkPhysicalDeviceHostQueryResetFeatures* to);

void deepcopy_VkPhysicalDeviceTimelineSemaphoreFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreFeatures* from,
    VkPhysicalDeviceTimelineSemaphoreFeatures* to);

void deepcopy_VkPhysicalDeviceTimelineSemaphoreProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTimelineSemaphoreProperties* from,
    VkPhysicalDeviceTimelineSemaphoreProperties* to);

void deepcopy_VkSemaphoreTypeCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSemaphoreTypeCreateInfo* from,
    VkSemaphoreTypeCreateInfo* to);

void deepcopy_VkTimelineSemaphoreSubmitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkTimelineSemaphoreSubmitInfo* from,
    VkTimelineSemaphoreSubmitInfo* to);

void deepcopy_VkSemaphoreWaitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSemaphoreWaitInfo* from,
    VkSemaphoreWaitInfo* to);

void deepcopy_VkSemaphoreSignalInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSemaphoreSignalInfo* from,
    VkSemaphoreSignalInfo* to);

void deepcopy_VkPhysicalDeviceBufferDeviceAddressFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceBufferDeviceAddressFeatures* from,
    VkPhysicalDeviceBufferDeviceAddressFeatures* to);

void deepcopy_VkBufferDeviceAddressInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferDeviceAddressInfo* from,
    VkBufferDeviceAddressInfo* to);

void deepcopy_VkBufferOpaqueCaptureAddressCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferOpaqueCaptureAddressCreateInfo* from,
    VkBufferOpaqueCaptureAddressCreateInfo* to);

void deepcopy_VkMemoryOpaqueCaptureAddressAllocateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryOpaqueCaptureAddressAllocateInfo* from,
    VkMemoryOpaqueCaptureAddressAllocateInfo* to);

void deepcopy_VkDeviceMemoryOpaqueCaptureAddressInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceMemoryOpaqueCaptureAddressInfo* from,
    VkDeviceMemoryOpaqueCaptureAddressInfo* to);

#endif
#ifdef VK_VERSION_1_3
void deepcopy_VkPhysicalDeviceVulkan13Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Features* from,
    VkPhysicalDeviceVulkan13Features* to);

void deepcopy_VkPhysicalDeviceVulkan13Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan13Properties* from,
    VkPhysicalDeviceVulkan13Properties* to);

void deepcopy_VkPipelineCreationFeedback(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineCreationFeedback* from,
    VkPipelineCreationFeedback* to);

void deepcopy_VkPipelineCreationFeedbackCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineCreationFeedbackCreateInfo* from,
    VkPipelineCreationFeedbackCreateInfo* to);

void deepcopy_VkPhysicalDeviceShaderTerminateInvocationFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderTerminateInvocationFeatures* from,
    VkPhysicalDeviceShaderTerminateInvocationFeatures* to);

void deepcopy_VkPhysicalDeviceToolProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceToolProperties* from,
    VkPhysicalDeviceToolProperties* to);

void deepcopy_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* from,
    VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures* to);

void deepcopy_VkPhysicalDevicePrivateDataFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePrivateDataFeatures* from,
    VkPhysicalDevicePrivateDataFeatures* to);

void deepcopy_VkDevicePrivateDataCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDevicePrivateDataCreateInfo* from,
    VkDevicePrivateDataCreateInfo* to);

void deepcopy_VkPrivateDataSlotCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPrivateDataSlotCreateInfo* from,
    VkPrivateDataSlotCreateInfo* to);

void deepcopy_VkPhysicalDevicePipelineCreationCacheControlFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineCreationCacheControlFeatures* from,
    VkPhysicalDevicePipelineCreationCacheControlFeatures* to);

void deepcopy_VkMemoryBarrier2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryBarrier2* from,
    VkMemoryBarrier2* to);

void deepcopy_VkBufferMemoryBarrier2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferMemoryBarrier2* from,
    VkBufferMemoryBarrier2* to);

void deepcopy_VkImageMemoryBarrier2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageMemoryBarrier2* from,
    VkImageMemoryBarrier2* to);

void deepcopy_VkDependencyInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDependencyInfo* from,
    VkDependencyInfo* to);

void deepcopy_VkSemaphoreSubmitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSemaphoreSubmitInfo* from,
    VkSemaphoreSubmitInfo* to);

void deepcopy_VkCommandBufferSubmitInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCommandBufferSubmitInfo* from,
    VkCommandBufferSubmitInfo* to);

void deepcopy_VkSubmitInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubmitInfo2* from,
    VkSubmitInfo2* to);

void deepcopy_VkPhysicalDeviceSynchronization2Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSynchronization2Features* from,
    VkPhysicalDeviceSynchronization2Features* to);

void deepcopy_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* from,
    VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures* to);

void deepcopy_VkPhysicalDeviceImageRobustnessFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceImageRobustnessFeatures* from,
    VkPhysicalDeviceImageRobustnessFeatures* to);

void deepcopy_VkBufferCopy2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferCopy2* from,
    VkBufferCopy2* to);

void deepcopy_VkCopyBufferInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyBufferInfo2* from,
    VkCopyBufferInfo2* to);

void deepcopy_VkImageCopy2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageCopy2* from,
    VkImageCopy2* to);

void deepcopy_VkCopyImageInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyImageInfo2* from,
    VkCopyImageInfo2* to);

void deepcopy_VkBufferImageCopy2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferImageCopy2* from,
    VkBufferImageCopy2* to);

void deepcopy_VkCopyBufferToImageInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyBufferToImageInfo2* from,
    VkCopyBufferToImageInfo2* to);

void deepcopy_VkCopyImageToBufferInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyImageToBufferInfo2* from,
    VkCopyImageToBufferInfo2* to);

void deepcopy_VkImageBlit2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageBlit2* from,
    VkImageBlit2* to);

void deepcopy_VkBlitImageInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBlitImageInfo2* from,
    VkBlitImageInfo2* to);

void deepcopy_VkImageResolve2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageResolve2* from,
    VkImageResolve2* to);

void deepcopy_VkResolveImageInfo2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkResolveImageInfo2* from,
    VkResolveImageInfo2* to);

void deepcopy_VkPhysicalDeviceSubgroupSizeControlFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlFeatures* from,
    VkPhysicalDeviceSubgroupSizeControlFeatures* to);

void deepcopy_VkPhysicalDeviceSubgroupSizeControlProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceSubgroupSizeControlProperties* from,
    VkPhysicalDeviceSubgroupSizeControlProperties* to);

void deepcopy_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* from,
    VkPipelineShaderStageRequiredSubgroupSizeCreateInfo* to);

void deepcopy_VkPhysicalDeviceInlineUniformBlockFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockFeatures* from,
    VkPhysicalDeviceInlineUniformBlockFeatures* to);

void deepcopy_VkPhysicalDeviceInlineUniformBlockProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceInlineUniformBlockProperties* from,
    VkPhysicalDeviceInlineUniformBlockProperties* to);

void deepcopy_VkWriteDescriptorSetInlineUniformBlock(
    Allocator* alloc,
    VkStructureType rootType,
    const VkWriteDescriptorSetInlineUniformBlock* from,
    VkWriteDescriptorSetInlineUniformBlock* to);

void deepcopy_VkDescriptorPoolInlineUniformBlockCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDescriptorPoolInlineUniformBlockCreateInfo* from,
    VkDescriptorPoolInlineUniformBlockCreateInfo* to);

void deepcopy_VkPhysicalDeviceTextureCompressionASTCHDRFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTextureCompressionASTCHDRFeatures* from,
    VkPhysicalDeviceTextureCompressionASTCHDRFeatures* to);

void deepcopy_VkRenderingAttachmentInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderingAttachmentInfo* from,
    VkRenderingAttachmentInfo* to);

void deepcopy_VkRenderingInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderingInfo* from,
    VkRenderingInfo* to);

void deepcopy_VkPipelineRenderingCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRenderingCreateInfo* from,
    VkPipelineRenderingCreateInfo* to);

void deepcopy_VkPhysicalDeviceDynamicRenderingFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingFeatures* from,
    VkPhysicalDeviceDynamicRenderingFeatures* to);

void deepcopy_VkCommandBufferInheritanceRenderingInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCommandBufferInheritanceRenderingInfo* from,
    VkCommandBufferInheritanceRenderingInfo* to);

void deepcopy_VkPhysicalDeviceShaderIntegerDotProductFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductFeatures* from,
    VkPhysicalDeviceShaderIntegerDotProductFeatures* to);

void deepcopy_VkPhysicalDeviceShaderIntegerDotProductProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderIntegerDotProductProperties* from,
    VkPhysicalDeviceShaderIntegerDotProductProperties* to);

void deepcopy_VkPhysicalDeviceTexelBufferAlignmentProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentProperties* from,
    VkPhysicalDeviceTexelBufferAlignmentProperties* to);

void deepcopy_VkFormatProperties3(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFormatProperties3* from,
    VkFormatProperties3* to);

void deepcopy_VkPhysicalDeviceMaintenance4Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Features* from,
    VkPhysicalDeviceMaintenance4Features* to);

void deepcopy_VkPhysicalDeviceMaintenance4Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance4Properties* from,
    VkPhysicalDeviceMaintenance4Properties* to);

void deepcopy_VkDeviceBufferMemoryRequirements(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceBufferMemoryRequirements* from,
    VkDeviceBufferMemoryRequirements* to);

void deepcopy_VkDeviceImageMemoryRequirements(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceImageMemoryRequirements* from,
    VkDeviceImageMemoryRequirements* to);

#endif
#ifdef VK_VERSION_1_4
void deepcopy_VkPhysicalDeviceVulkan14Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Features* from,
    VkPhysicalDeviceVulkan14Features* to);

void deepcopy_VkPhysicalDeviceVulkan14Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVulkan14Properties* from,
    VkPhysicalDeviceVulkan14Properties* to);

void deepcopy_VkDeviceQueueGlobalPriorityCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceQueueGlobalPriorityCreateInfo* from,
    VkDeviceQueueGlobalPriorityCreateInfo* to);

void deepcopy_VkPhysicalDeviceGlobalPriorityQueryFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceGlobalPriorityQueryFeatures* from,
    VkPhysicalDeviceGlobalPriorityQueryFeatures* to);

void deepcopy_VkQueueFamilyGlobalPriorityProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkQueueFamilyGlobalPriorityProperties* from,
    VkQueueFamilyGlobalPriorityProperties* to);

void deepcopy_VkPhysicalDeviceShaderSubgroupRotateFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderSubgroupRotateFeatures* from,
    VkPhysicalDeviceShaderSubgroupRotateFeatures* to);

void deepcopy_VkPhysicalDeviceShaderFloatControls2Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderFloatControls2Features* from,
    VkPhysicalDeviceShaderFloatControls2Features* to);

void deepcopy_VkPhysicalDeviceShaderExpectAssumeFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceShaderExpectAssumeFeatures* from,
    VkPhysicalDeviceShaderExpectAssumeFeatures* to);

void deepcopy_VkPhysicalDeviceLineRasterizationFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationFeatures* from,
    VkPhysicalDeviceLineRasterizationFeatures* to);

void deepcopy_VkPhysicalDeviceLineRasterizationProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceLineRasterizationProperties* from,
    VkPhysicalDeviceLineRasterizationProperties* to);

void deepcopy_VkPipelineRasterizationLineStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRasterizationLineStateCreateInfo* from,
    VkPipelineRasterizationLineStateCreateInfo* to);

void deepcopy_VkPhysicalDeviceVertexAttributeDivisorProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorProperties* from,
    VkPhysicalDeviceVertexAttributeDivisorProperties* to);

void deepcopy_VkVertexInputBindingDivisorDescription(
    Allocator* alloc,
    VkStructureType rootType,
    const VkVertexInputBindingDivisorDescription* from,
    VkVertexInputBindingDivisorDescription* to);

void deepcopy_VkPipelineVertexInputDivisorStateCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineVertexInputDivisorStateCreateInfo* from,
    VkPipelineVertexInputDivisorStateCreateInfo* to);

void deepcopy_VkPhysicalDeviceVertexAttributeDivisorFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorFeatures* from,
    VkPhysicalDeviceVertexAttributeDivisorFeatures* to);

void deepcopy_VkPhysicalDeviceIndexTypeUint8Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceIndexTypeUint8Features* from,
    VkPhysicalDeviceIndexTypeUint8Features* to);

void deepcopy_VkMemoryMapInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryMapInfo* from,
    VkMemoryMapInfo* to);

void deepcopy_VkMemoryUnmapInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryUnmapInfo* from,
    VkMemoryUnmapInfo* to);

void deepcopy_VkPhysicalDeviceMaintenance5Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Features* from,
    VkPhysicalDeviceMaintenance5Features* to);

void deepcopy_VkPhysicalDeviceMaintenance5Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance5Properties* from,
    VkPhysicalDeviceMaintenance5Properties* to);

void deepcopy_VkRenderingAreaInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderingAreaInfo* from,
    VkRenderingAreaInfo* to);

void deepcopy_VkImageSubresource2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageSubresource2* from,
    VkImageSubresource2* to);

void deepcopy_VkDeviceImageSubresourceInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceImageSubresourceInfo* from,
    VkDeviceImageSubresourceInfo* to);

void deepcopy_VkSubresourceLayout2(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubresourceLayout2* from,
    VkSubresourceLayout2* to);

void deepcopy_VkPipelineCreateFlags2CreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineCreateFlags2CreateInfo* from,
    VkPipelineCreateFlags2CreateInfo* to);

void deepcopy_VkBufferUsageFlags2CreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBufferUsageFlags2CreateInfo* from,
    VkBufferUsageFlags2CreateInfo* to);

void deepcopy_VkPhysicalDevicePushDescriptorProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePushDescriptorProperties* from,
    VkPhysicalDevicePushDescriptorProperties* to);

void deepcopy_VkPhysicalDeviceDynamicRenderingLocalReadFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDynamicRenderingLocalReadFeatures* from,
    VkPhysicalDeviceDynamicRenderingLocalReadFeatures* to);

void deepcopy_VkRenderingAttachmentLocationInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderingAttachmentLocationInfo* from,
    VkRenderingAttachmentLocationInfo* to);

void deepcopy_VkRenderingInputAttachmentIndexInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderingInputAttachmentIndexInfo* from,
    VkRenderingInputAttachmentIndexInfo* to);

void deepcopy_VkPhysicalDeviceMaintenance6Features(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Features* from,
    VkPhysicalDeviceMaintenance6Features* to);

void deepcopy_VkPhysicalDeviceMaintenance6Properties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMaintenance6Properties* from,
    VkPhysicalDeviceMaintenance6Properties* to);

void deepcopy_VkBindMemoryStatus(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindMemoryStatus* from,
    VkBindMemoryStatus* to);

void deepcopy_VkBindDescriptorSetsInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkBindDescriptorSetsInfo* from,
    VkBindDescriptorSetsInfo* to);

void deepcopy_VkPushConstantsInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPushConstantsInfo* from,
    VkPushConstantsInfo* to);

void deepcopy_VkPushDescriptorSetInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPushDescriptorSetInfo* from,
    VkPushDescriptorSetInfo* to);

void deepcopy_VkPushDescriptorSetWithTemplateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPushDescriptorSetWithTemplateInfo* from,
    VkPushDescriptorSetWithTemplateInfo* to);

void deepcopy_VkPhysicalDevicePipelineProtectedAccessFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineProtectedAccessFeatures* from,
    VkPhysicalDevicePipelineProtectedAccessFeatures* to);

void deepcopy_VkPhysicalDevicePipelineRobustnessFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessFeatures* from,
    VkPhysicalDevicePipelineRobustnessFeatures* to);

void deepcopy_VkPhysicalDevicePipelineRobustnessProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineRobustnessProperties* from,
    VkPhysicalDevicePipelineRobustnessProperties* to);

void deepcopy_VkPipelineRobustnessCreateInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRobustnessCreateInfo* from,
    VkPipelineRobustnessCreateInfo* to);

void deepcopy_VkPhysicalDeviceHostImageCopyFeatures(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyFeatures* from,
    VkPhysicalDeviceHostImageCopyFeatures* to);

void deepcopy_VkPhysicalDeviceHostImageCopyProperties(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceHostImageCopyProperties* from,
    VkPhysicalDeviceHostImageCopyProperties* to);

void deepcopy_VkMemoryToImageCopy(
    Allocator* alloc,
    VkStructureType rootType,
    const VkMemoryToImageCopy* from,
    VkMemoryToImageCopy* to);

void deepcopy_VkImageToMemoryCopy(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageToMemoryCopy* from,
    VkImageToMemoryCopy* to);

void deepcopy_VkCopyMemoryToImageInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyMemoryToImageInfo* from,
    VkCopyMemoryToImageInfo* to);

void deepcopy_VkCopyImageToMemoryInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyImageToMemoryInfo* from,
    VkCopyImageToMemoryInfo* to);

void deepcopy_VkCopyImageToImageInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCopyImageToImageInfo* from,
    VkCopyImageToImageInfo* to);

void deepcopy_VkHostImageLayoutTransitionInfo(
    Allocator* alloc,
    VkStructureType rootType,
    const VkHostImageLayoutTransitionInfo* from,
    VkHostImageLayoutTransitionInfo* to);

void deepcopy_VkSubresourceHostMemcpySize(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSubresourceHostMemcpySize* from,
    VkSubresourceHostMemcpySize* to);

void deepcopy_VkHostImageCopyDevicePerformanceQuery(
    Allocator* alloc,
    VkStructureType rootType,
    const VkHostImageCopyDevicePerformanceQuery* from,
    VkHostImageCopyDevicePerformanceQuery* to);

#endif
#ifdef VK_KHR_dynamic_rendering
DEFINE_ALIAS_FUNCTION(deepcopy_VkRenderingInfo, deepcopy_VkRenderingInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkRenderingAttachmentInfo, deepcopy_VkRenderingAttachmentInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPipelineRenderingCreateInfo, deepcopy_VkPipelineRenderingCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceDynamicRenderingFeatures, deepcopy_VkPhysicalDeviceDynamicRenderingFeaturesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkCommandBufferInheritanceRenderingInfo, deepcopy_VkCommandBufferInheritanceRenderingInfoKHR)

#endif
#ifdef VK_KHR_multiview
DEFINE_ALIAS_FUNCTION(deepcopy_VkRenderPassMultiviewCreateInfo, deepcopy_VkRenderPassMultiviewCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceMultiviewFeatures, deepcopy_VkPhysicalDeviceMultiviewFeaturesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceMultiviewProperties, deepcopy_VkPhysicalDeviceMultiviewPropertiesKHR)

#endif
#ifdef VK_KHR_get_physical_device_properties2
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceFeatures2, deepcopy_VkPhysicalDeviceFeatures2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceProperties2, deepcopy_VkPhysicalDeviceProperties2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkFormatProperties2, deepcopy_VkFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkImageFormatProperties2, deepcopy_VkImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceImageFormatInfo2, deepcopy_VkPhysicalDeviceImageFormatInfo2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkQueueFamilyProperties2, deepcopy_VkQueueFamilyProperties2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceMemoryProperties2, deepcopy_VkPhysicalDeviceMemoryProperties2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkSparseImageFormatProperties2, deepcopy_VkSparseImageFormatProperties2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceSparseImageFormatInfo2, deepcopy_VkPhysicalDeviceSparseImageFormatInfo2KHR)

#endif
#ifdef VK_KHR_external_memory_capabilities
DEFINE_ALIAS_FUNCTION(deepcopy_VkExternalMemoryProperties, deepcopy_VkExternalMemoryPropertiesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceExternalImageFormatInfo, deepcopy_VkPhysicalDeviceExternalImageFormatInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkExternalImageFormatProperties, deepcopy_VkExternalImageFormatPropertiesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceExternalBufferInfo, deepcopy_VkPhysicalDeviceExternalBufferInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkExternalBufferProperties, deepcopy_VkExternalBufferPropertiesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceIDProperties, deepcopy_VkPhysicalDeviceIDPropertiesKHR)

#endif
#ifdef VK_KHR_external_memory
DEFINE_ALIAS_FUNCTION(deepcopy_VkExternalMemoryImageCreateInfo, deepcopy_VkExternalMemoryImageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkExternalMemoryBufferCreateInfo, deepcopy_VkExternalMemoryBufferCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkExportMemoryAllocateInfo, deepcopy_VkExportMemoryAllocateInfoKHR)

#endif
#ifdef VK_KHR_external_semaphore_capabilities
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceExternalSemaphoreInfo, deepcopy_VkPhysicalDeviceExternalSemaphoreInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkExternalSemaphoreProperties, deepcopy_VkExternalSemaphorePropertiesKHR)

#endif
#ifdef VK_KHR_external_semaphore
DEFINE_ALIAS_FUNCTION(deepcopy_VkExportSemaphoreCreateInfo, deepcopy_VkExportSemaphoreCreateInfoKHR)

#endif
#ifdef VK_KHR_external_semaphore_fd
void deepcopy_VkImportSemaphoreFdInfoKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImportSemaphoreFdInfoKHR* from,
    VkImportSemaphoreFdInfoKHR* to);

void deepcopy_VkSemaphoreGetFdInfoKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSemaphoreGetFdInfoKHR* from,
    VkSemaphoreGetFdInfoKHR* to);

#endif
#ifdef VK_KHR_shader_float16_int8
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceShaderFloat16Int8Features, deepcopy_VkPhysicalDeviceShaderFloat16Int8FeaturesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceShaderFloat16Int8Features, deepcopy_VkPhysicalDeviceFloat16Int8FeaturesKHR)

#endif
#ifdef VK_KHR_incremental_present
void deepcopy_VkRectLayerKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRectLayerKHR* from,
    VkRectLayerKHR* to);

void deepcopy_VkPresentRegionKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPresentRegionKHR* from,
    VkPresentRegionKHR* to);

void deepcopy_VkPresentRegionsKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPresentRegionsKHR* from,
    VkPresentRegionsKHR* to);

#endif
#ifdef VK_KHR_descriptor_update_template
DEFINE_ALIAS_FUNCTION(deepcopy_VkDescriptorUpdateTemplateEntry, deepcopy_VkDescriptorUpdateTemplateEntryKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkDescriptorUpdateTemplateCreateInfo, deepcopy_VkDescriptorUpdateTemplateCreateInfoKHR)

#endif
#ifdef VK_KHR_imageless_framebuffer
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceImagelessFramebufferFeatures, deepcopy_VkPhysicalDeviceImagelessFramebufferFeaturesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkFramebufferAttachmentsCreateInfo, deepcopy_VkFramebufferAttachmentsCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkFramebufferAttachmentImageInfo, deepcopy_VkFramebufferAttachmentImageInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkRenderPassAttachmentBeginInfo, deepcopy_VkRenderPassAttachmentBeginInfoKHR)

#endif
#ifdef VK_KHR_create_renderpass2
DEFINE_ALIAS_FUNCTION(deepcopy_VkRenderPassCreateInfo2, deepcopy_VkRenderPassCreateInfo2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkAttachmentDescription2, deepcopy_VkAttachmentDescription2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkAttachmentReference2, deepcopy_VkAttachmentReference2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkSubpassDescription2, deepcopy_VkSubpassDescription2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkSubpassDependency2, deepcopy_VkSubpassDependency2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkSubpassBeginInfo, deepcopy_VkSubpassBeginInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkSubpassEndInfo, deepcopy_VkSubpassEndInfoKHR)

#endif
#ifdef VK_KHR_external_fence_capabilities
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceExternalFenceInfo, deepcopy_VkPhysicalDeviceExternalFenceInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkExternalFenceProperties, deepcopy_VkExternalFencePropertiesKHR)

#endif
#ifdef VK_KHR_external_fence
DEFINE_ALIAS_FUNCTION(deepcopy_VkExportFenceCreateInfo, deepcopy_VkExportFenceCreateInfoKHR)

#endif
#ifdef VK_KHR_external_fence_fd
void deepcopy_VkImportFenceFdInfoKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImportFenceFdInfoKHR* from,
    VkImportFenceFdInfoKHR* to);

void deepcopy_VkFenceGetFdInfoKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkFenceGetFdInfoKHR* from,
    VkFenceGetFdInfoKHR* to);

#endif
#ifdef VK_KHR_maintenance2
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDevicePointClippingProperties, deepcopy_VkPhysicalDevicePointClippingPropertiesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkRenderPassInputAttachmentAspectCreateInfo, deepcopy_VkRenderPassInputAttachmentAspectCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkInputAttachmentAspectReference, deepcopy_VkInputAttachmentAspectReferenceKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkImageViewUsageCreateInfo, deepcopy_VkImageViewUsageCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPipelineTessellationDomainOriginStateCreateInfo, deepcopy_VkPipelineTessellationDomainOriginStateCreateInfoKHR)

#endif
#ifdef VK_KHR_dedicated_allocation
DEFINE_ALIAS_FUNCTION(deepcopy_VkMemoryDedicatedRequirements, deepcopy_VkMemoryDedicatedRequirementsKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkMemoryDedicatedAllocateInfo, deepcopy_VkMemoryDedicatedAllocateInfoKHR)

#endif
#ifdef VK_KHR_get_memory_requirements2
DEFINE_ALIAS_FUNCTION(deepcopy_VkBufferMemoryRequirementsInfo2, deepcopy_VkBufferMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkImageMemoryRequirementsInfo2, deepcopy_VkImageMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkImageSparseMemoryRequirementsInfo2, deepcopy_VkImageSparseMemoryRequirementsInfo2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkMemoryRequirements2, deepcopy_VkMemoryRequirements2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkSparseImageMemoryRequirements2, deepcopy_VkSparseImageMemoryRequirements2KHR)

#endif
#ifdef VK_KHR_image_format_list
DEFINE_ALIAS_FUNCTION(deepcopy_VkImageFormatListCreateInfo, deepcopy_VkImageFormatListCreateInfoKHR)

#endif
#ifdef VK_KHR_sampler_ycbcr_conversion
DEFINE_ALIAS_FUNCTION(deepcopy_VkSamplerYcbcrConversionCreateInfo, deepcopy_VkSamplerYcbcrConversionCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkSamplerYcbcrConversionInfo, deepcopy_VkSamplerYcbcrConversionInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkBindImagePlaneMemoryInfo, deepcopy_VkBindImagePlaneMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkImagePlaneMemoryRequirementsInfo, deepcopy_VkImagePlaneMemoryRequirementsInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceSamplerYcbcrConversionFeatures, deepcopy_VkPhysicalDeviceSamplerYcbcrConversionFeaturesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkSamplerYcbcrConversionImageFormatProperties, deepcopy_VkSamplerYcbcrConversionImageFormatPropertiesKHR)

#endif
#ifdef VK_KHR_bind_memory2
DEFINE_ALIAS_FUNCTION(deepcopy_VkBindBufferMemoryInfo, deepcopy_VkBindBufferMemoryInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkBindImageMemoryInfo, deepcopy_VkBindImageMemoryInfoKHR)

#endif
#ifdef VK_KHR_maintenance3
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceMaintenance3Properties, deepcopy_VkPhysicalDeviceMaintenance3PropertiesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkDescriptorSetLayoutSupport, deepcopy_VkDescriptorSetLayoutSupportKHR)

#endif
#ifdef VK_KHR_shader_subgroup_extended_types
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures, deepcopy_VkPhysicalDeviceShaderSubgroupExtendedTypesFeaturesKHR)

#endif
#ifdef VK_KHR_global_priority
DEFINE_ALIAS_FUNCTION(deepcopy_VkDeviceQueueGlobalPriorityCreateInfo, deepcopy_VkDeviceQueueGlobalPriorityCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceGlobalPriorityQueryFeatures, deepcopy_VkPhysicalDeviceGlobalPriorityQueryFeaturesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkQueueFamilyGlobalPriorityProperties, deepcopy_VkQueueFamilyGlobalPriorityPropertiesKHR)

#endif
#ifdef VK_KHR_vulkan_memory_model
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceVulkanMemoryModelFeatures, deepcopy_VkPhysicalDeviceVulkanMemoryModelFeaturesKHR)

#endif
#ifdef VK_KHR_shader_terminate_invocation
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceShaderTerminateInvocationFeatures, deepcopy_VkPhysicalDeviceShaderTerminateInvocationFeaturesKHR)

#endif
#ifdef VK_KHR_buffer_device_address
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceBufferDeviceAddressFeatures, deepcopy_VkPhysicalDeviceBufferDeviceAddressFeaturesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkBufferDeviceAddressInfo, deepcopy_VkBufferDeviceAddressInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkBufferOpaqueCaptureAddressCreateInfo, deepcopy_VkBufferOpaqueCaptureAddressCreateInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkMemoryOpaqueCaptureAddressAllocateInfo, deepcopy_VkMemoryOpaqueCaptureAddressAllocateInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkDeviceMemoryOpaqueCaptureAddressInfo, deepcopy_VkDeviceMemoryOpaqueCaptureAddressInfoKHR)

#endif
#ifdef VK_KHR_pipeline_executable_properties
void deepcopy_VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* from,
    VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR* to);

void deepcopy_VkPipelineInfoKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineInfoKHR* from,
    VkPipelineInfoKHR* to);

void deepcopy_VkPipelineExecutablePropertiesKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineExecutablePropertiesKHR* from,
    VkPipelineExecutablePropertiesKHR* to);

void deepcopy_VkPipelineExecutableInfoKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineExecutableInfoKHR* from,
    VkPipelineExecutableInfoKHR* to);

void deepcopy_VkPipelineExecutableStatisticValueKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticValueKHR* from,
    VkPipelineExecutableStatisticValueKHR* to);

void deepcopy_VkPipelineExecutableStatisticKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineExecutableStatisticKHR* from,
    VkPipelineExecutableStatisticKHR* to);

void deepcopy_VkPipelineExecutableInternalRepresentationKHR(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineExecutableInternalRepresentationKHR* from,
    VkPipelineExecutableInternalRepresentationKHR* to);

#endif
#ifdef VK_KHR_shader_integer_dot_product
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceShaderIntegerDotProductFeatures, deepcopy_VkPhysicalDeviceShaderIntegerDotProductFeaturesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceShaderIntegerDotProductProperties, deepcopy_VkPhysicalDeviceShaderIntegerDotProductPropertiesKHR)

#endif
#ifdef VK_KHR_synchronization2
DEFINE_ALIAS_FUNCTION(deepcopy_VkMemoryBarrier2, deepcopy_VkMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkBufferMemoryBarrier2, deepcopy_VkBufferMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkImageMemoryBarrier2, deepcopy_VkImageMemoryBarrier2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkDependencyInfo, deepcopy_VkDependencyInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkSubmitInfo2, deepcopy_VkSubmitInfo2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkSemaphoreSubmitInfo, deepcopy_VkSemaphoreSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkCommandBufferSubmitInfo, deepcopy_VkCommandBufferSubmitInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceSynchronization2Features, deepcopy_VkPhysicalDeviceSynchronization2FeaturesKHR)

#endif
#ifdef VK_KHR_zero_initialize_workgroup_memory
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures, deepcopy_VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeaturesKHR)

#endif
#ifdef VK_KHR_copy_commands2
DEFINE_ALIAS_FUNCTION(deepcopy_VkCopyBufferInfo2, deepcopy_VkCopyBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkCopyImageInfo2, deepcopy_VkCopyImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkCopyBufferToImageInfo2, deepcopy_VkCopyBufferToImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkCopyImageToBufferInfo2, deepcopy_VkCopyImageToBufferInfo2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkBlitImageInfo2, deepcopy_VkBlitImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkResolveImageInfo2, deepcopy_VkResolveImageInfo2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkBufferCopy2, deepcopy_VkBufferCopy2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkImageCopy2, deepcopy_VkImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkImageBlit2, deepcopy_VkImageBlit2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkBufferImageCopy2, deepcopy_VkBufferImageCopy2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkImageResolve2, deepcopy_VkImageResolve2KHR)

#endif
#ifdef VK_KHR_format_feature_flags2
DEFINE_ALIAS_FUNCTION(deepcopy_VkFormatProperties3, deepcopy_VkFormatProperties3KHR)

#endif
#ifdef VK_KHR_maintenance4
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceMaintenance4Features, deepcopy_VkPhysicalDeviceMaintenance4FeaturesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceMaintenance4Properties, deepcopy_VkPhysicalDeviceMaintenance4PropertiesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkDeviceBufferMemoryRequirements, deepcopy_VkDeviceBufferMemoryRequirementsKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkDeviceImageMemoryRequirements, deepcopy_VkDeviceImageMemoryRequirementsKHR)

#endif
#ifdef VK_KHR_maintenance5
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceMaintenance5Features, deepcopy_VkPhysicalDeviceMaintenance5FeaturesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceMaintenance5Properties, deepcopy_VkPhysicalDeviceMaintenance5PropertiesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkRenderingAreaInfo, deepcopy_VkRenderingAreaInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkDeviceImageSubresourceInfo, deepcopy_VkDeviceImageSubresourceInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkImageSubresource2, deepcopy_VkImageSubresource2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkSubresourceLayout2, deepcopy_VkSubresourceLayout2KHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPipelineCreateFlags2CreateInfo, deepcopy_VkPipelineCreateFlags2CreateInfoKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkBufferUsageFlags2CreateInfo, deepcopy_VkBufferUsageFlags2CreateInfoKHR)

#endif
#ifdef VK_KHR_line_rasterization
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceLineRasterizationFeatures, deepcopy_VkPhysicalDeviceLineRasterizationFeaturesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceLineRasterizationProperties, deepcopy_VkPhysicalDeviceLineRasterizationPropertiesKHR)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPipelineRasterizationLineStateCreateInfo, deepcopy_VkPipelineRasterizationLineStateCreateInfoKHR)

#endif
#ifdef VK_ANDROID_native_buffer
void deepcopy_VkNativeBufferUsage2ANDROID(
    Allocator* alloc,
    VkStructureType rootType,
    const VkNativeBufferUsage2ANDROID* from,
    VkNativeBufferUsage2ANDROID* to);

void deepcopy_VkNativeBufferANDROID(
    Allocator* alloc,
    VkStructureType rootType,
    const VkNativeBufferANDROID* from,
    VkNativeBufferANDROID* to);

void deepcopy_VkSwapchainImageCreateInfoANDROID(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSwapchainImageCreateInfoANDROID* from,
    VkSwapchainImageCreateInfoANDROID* to);

void deepcopy_VkPhysicalDevicePresentationPropertiesANDROID(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePresentationPropertiesANDROID* from,
    VkPhysicalDevicePresentationPropertiesANDROID* to);

#endif
#ifdef VK_EXT_transform_feedback
void deepcopy_VkPhysicalDeviceTransformFeedbackFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackFeaturesEXT* from,
    VkPhysicalDeviceTransformFeedbackFeaturesEXT* to);

void deepcopy_VkPhysicalDeviceTransformFeedbackPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTransformFeedbackPropertiesEXT* from,
    VkPhysicalDeviceTransformFeedbackPropertiesEXT* to);

void deepcopy_VkPipelineRasterizationStateStreamCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRasterizationStateStreamCreateInfoEXT* from,
    VkPipelineRasterizationStateStreamCreateInfoEXT* to);

#endif
#ifdef VK_EXT_texture_compression_astc_hdr
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceTextureCompressionASTCHDRFeatures, deepcopy_VkPhysicalDeviceTextureCompressionASTCHDRFeaturesEXT)

#endif
#ifdef VK_EXT_depth_clip_enable
void deepcopy_VkPhysicalDeviceDepthClipEnableFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDepthClipEnableFeaturesEXT* from,
    VkPhysicalDeviceDepthClipEnableFeaturesEXT* to);

void deepcopy_VkPipelineRasterizationDepthClipStateCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRasterizationDepthClipStateCreateInfoEXT* from,
    VkPipelineRasterizationDepthClipStateCreateInfoEXT* to);

#endif
#ifdef VK_EXT_inline_uniform_block
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceInlineUniformBlockFeatures, deepcopy_VkPhysicalDeviceInlineUniformBlockFeaturesEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceInlineUniformBlockProperties, deepcopy_VkPhysicalDeviceInlineUniformBlockPropertiesEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkWriteDescriptorSetInlineUniformBlock, deepcopy_VkWriteDescriptorSetInlineUniformBlockEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkDescriptorPoolInlineUniformBlockCreateInfo, deepcopy_VkDescriptorPoolInlineUniformBlockCreateInfoEXT)

#endif
#ifdef VK_EXT_image_drm_format_modifier
void deepcopy_VkDrmFormatModifierPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesEXT* from,
    VkDrmFormatModifierPropertiesEXT* to);

void deepcopy_VkDrmFormatModifierPropertiesListEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesListEXT* from,
    VkDrmFormatModifierPropertiesListEXT* to);

void deepcopy_VkPhysicalDeviceImageDrmFormatModifierInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceImageDrmFormatModifierInfoEXT* from,
    VkPhysicalDeviceImageDrmFormatModifierInfoEXT* to);

void deepcopy_VkImageDrmFormatModifierListCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageDrmFormatModifierListCreateInfoEXT* from,
    VkImageDrmFormatModifierListCreateInfoEXT* to);

void deepcopy_VkImageDrmFormatModifierExplicitCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageDrmFormatModifierExplicitCreateInfoEXT* from,
    VkImageDrmFormatModifierExplicitCreateInfoEXT* to);

void deepcopy_VkImageDrmFormatModifierPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageDrmFormatModifierPropertiesEXT* from,
    VkImageDrmFormatModifierPropertiesEXT* to);

void deepcopy_VkDrmFormatModifierProperties2EXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDrmFormatModifierProperties2EXT* from,
    VkDrmFormatModifierProperties2EXT* to);

void deepcopy_VkDrmFormatModifierPropertiesList2EXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDrmFormatModifierPropertiesList2EXT* from,
    VkDrmFormatModifierPropertiesList2EXT* to);

#endif
#ifdef VK_EXT_vertex_attribute_divisor
void deepcopy_VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* from,
    VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT* to);

DEFINE_ALIAS_FUNCTION(deepcopy_VkVertexInputBindingDivisorDescription, deepcopy_VkVertexInputBindingDivisorDescriptionEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPipelineVertexInputDivisorStateCreateInfo, deepcopy_VkPipelineVertexInputDivisorStateCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceVertexAttributeDivisorFeatures, deepcopy_VkPhysicalDeviceVertexAttributeDivisorFeaturesEXT)

#endif
#ifdef VK_EXT_pipeline_creation_feedback
DEFINE_ALIAS_FUNCTION(deepcopy_VkPipelineCreationFeedbackCreateInfo, deepcopy_VkPipelineCreationFeedbackCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPipelineCreationFeedback, deepcopy_VkPipelineCreationFeedbackEXT)

#endif
#ifdef VK_EXT_fragment_density_map
void deepcopy_VkPhysicalDeviceFragmentDensityMapFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapFeaturesEXT* from,
    VkPhysicalDeviceFragmentDensityMapFeaturesEXT* to);

void deepcopy_VkPhysicalDeviceFragmentDensityMapPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceFragmentDensityMapPropertiesEXT* from,
    VkPhysicalDeviceFragmentDensityMapPropertiesEXT* to);

void deepcopy_VkRenderPassFragmentDensityMapCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderPassFragmentDensityMapCreateInfoEXT* from,
    VkRenderPassFragmentDensityMapCreateInfoEXT* to);

void deepcopy_VkRenderingFragmentDensityMapAttachmentInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkRenderingFragmentDensityMapAttachmentInfoEXT* from,
    VkRenderingFragmentDensityMapAttachmentInfoEXT* to);

#endif
#ifdef VK_EXT_scalar_block_layout
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceScalarBlockLayoutFeatures, deepcopy_VkPhysicalDeviceScalarBlockLayoutFeaturesEXT)

#endif
#ifdef VK_EXT_subgroup_size_control
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceSubgroupSizeControlFeatures, deepcopy_VkPhysicalDeviceSubgroupSizeControlFeaturesEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceSubgroupSizeControlProperties, deepcopy_VkPhysicalDeviceSubgroupSizeControlPropertiesEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPipelineShaderStageRequiredSubgroupSizeCreateInfo, deepcopy_VkPipelineShaderStageRequiredSubgroupSizeCreateInfoEXT)

#endif
#ifdef VK_EXT_memory_budget
void deepcopy_VkPhysicalDeviceMemoryBudgetPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceMemoryBudgetPropertiesEXT* from,
    VkPhysicalDeviceMemoryBudgetPropertiesEXT* to);

#endif
#ifdef VK_EXT_tooling_info
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceToolProperties, deepcopy_VkPhysicalDeviceToolPropertiesEXT)

#endif
#ifdef VK_EXT_provoking_vertex
void deepcopy_VkPhysicalDeviceProvokingVertexFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexFeaturesEXT* from,
    VkPhysicalDeviceProvokingVertexFeaturesEXT* to);

void deepcopy_VkPhysicalDeviceProvokingVertexPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceProvokingVertexPropertiesEXT* from,
    VkPhysicalDeviceProvokingVertexPropertiesEXT* to);

void deepcopy_VkPipelineRasterizationProvokingVertexStateCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* from,
    VkPipelineRasterizationProvokingVertexStateCreateInfoEXT* to);

#endif
#ifdef VK_EXT_line_rasterization
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceLineRasterizationFeatures, deepcopy_VkPhysicalDeviceLineRasterizationFeaturesEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceLineRasterizationProperties, deepcopy_VkPhysicalDeviceLineRasterizationPropertiesEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPipelineRasterizationLineStateCreateInfo, deepcopy_VkPipelineRasterizationLineStateCreateInfoEXT)

#endif
#ifdef VK_EXT_index_type_uint8
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceIndexTypeUint8Features, deepcopy_VkPhysicalDeviceIndexTypeUint8FeaturesEXT)

#endif
#ifdef VK_EXT_extended_dynamic_state
void deepcopy_VkPhysicalDeviceExtendedDynamicStateFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* from,
    VkPhysicalDeviceExtendedDynamicStateFeaturesEXT* to);

#endif
#ifdef VK_EXT_host_image_copy
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceHostImageCopyFeatures, deepcopy_VkPhysicalDeviceHostImageCopyFeaturesEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceHostImageCopyProperties, deepcopy_VkPhysicalDeviceHostImageCopyPropertiesEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkMemoryToImageCopy, deepcopy_VkMemoryToImageCopyEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkImageToMemoryCopy, deepcopy_VkImageToMemoryCopyEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkCopyMemoryToImageInfo, deepcopy_VkCopyMemoryToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkCopyImageToMemoryInfo, deepcopy_VkCopyImageToMemoryInfoEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkCopyImageToImageInfo, deepcopy_VkCopyImageToImageInfoEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkHostImageLayoutTransitionInfo, deepcopy_VkHostImageLayoutTransitionInfoEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkSubresourceHostMemcpySize, deepcopy_VkSubresourceHostMemcpySizeEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkHostImageCopyDevicePerformanceQuery, deepcopy_VkHostImageCopyDevicePerformanceQueryEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkSubresourceLayout2, deepcopy_VkSubresourceLayout2EXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkImageSubresource2, deepcopy_VkImageSubresource2EXT)

#endif
#ifdef VK_EXT_shader_demote_to_helper_invocation
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures, deepcopy_VkPhysicalDeviceShaderDemoteToHelperInvocationFeaturesEXT)

#endif
#ifdef VK_EXT_texel_buffer_alignment
void deepcopy_VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* from,
    VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT* to);

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceTexelBufferAlignmentProperties, deepcopy_VkPhysicalDeviceTexelBufferAlignmentPropertiesEXT)

#endif
#ifdef VK_EXT_device_memory_report
void deepcopy_VkPhysicalDeviceDeviceMemoryReportFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* from,
    VkPhysicalDeviceDeviceMemoryReportFeaturesEXT* to);

void deepcopy_VkDeviceMemoryReportCallbackDataEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceMemoryReportCallbackDataEXT* from,
    VkDeviceMemoryReportCallbackDataEXT* to);

void deepcopy_VkDeviceDeviceMemoryReportCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkDeviceDeviceMemoryReportCreateInfoEXT* from,
    VkDeviceDeviceMemoryReportCreateInfoEXT* to);

#endif
#ifdef VK_EXT_robustness2
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceRobustness2FeaturesKHR, deepcopy_VkPhysicalDeviceRobustness2FeaturesEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceRobustness2PropertiesKHR, deepcopy_VkPhysicalDeviceRobustness2PropertiesEXT)

#endif
#ifdef VK_EXT_custom_border_color
void deepcopy_VkSamplerCustomBorderColorCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkSamplerCustomBorderColorCreateInfoEXT* from,
    VkSamplerCustomBorderColorCreateInfoEXT* to);

void deepcopy_VkPhysicalDeviceCustomBorderColorPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorPropertiesEXT* from,
    VkPhysicalDeviceCustomBorderColorPropertiesEXT* to);

void deepcopy_VkPhysicalDeviceCustomBorderColorFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceCustomBorderColorFeaturesEXT* from,
    VkPhysicalDeviceCustomBorderColorFeaturesEXT* to);

#endif
#ifdef VK_EXT_private_data
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDevicePrivateDataFeatures, deepcopy_VkPhysicalDevicePrivateDataFeaturesEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkDevicePrivateDataCreateInfo, deepcopy_VkDevicePrivateDataCreateInfoEXT)

DEFINE_ALIAS_FUNCTION(deepcopy_VkPrivateDataSlotCreateInfo, deepcopy_VkPrivateDataSlotCreateInfoEXT)

#endif
#ifdef VK_EXT_pipeline_creation_cache_control
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDevicePipelineCreationCacheControlFeatures, deepcopy_VkPhysicalDevicePipelineCreationCacheControlFeaturesEXT)

#endif
#ifdef VK_EXT_graphics_pipeline_library
void deepcopy_VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* from,
    VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT* to);

void deepcopy_VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* from,
    VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT* to);

void deepcopy_VkGraphicsPipelineLibraryCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkGraphicsPipelineLibraryCreateInfoEXT* from,
    VkGraphicsPipelineLibraryCreateInfoEXT* to);

#endif
#ifdef VK_EXT_ycbcr_2plane_444_formats
void deepcopy_VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* from,
    VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT* to);

#endif
#ifdef VK_EXT_image_robustness
DEFINE_ALIAS_FUNCTION(deepcopy_VkPhysicalDeviceImageRobustnessFeatures, deepcopy_VkPhysicalDeviceImageRobustnessFeaturesEXT)

#endif
#ifdef VK_EXT_image_compression_control
void deepcopy_VkPhysicalDeviceImageCompressionControlFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlFeaturesEXT* from,
    VkPhysicalDeviceImageCompressionControlFeaturesEXT* to);

void deepcopy_VkImageCompressionControlEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageCompressionControlEXT* from,
    VkImageCompressionControlEXT* to);

void deepcopy_VkImageCompressionPropertiesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImageCompressionPropertiesEXT* from,
    VkImageCompressionPropertiesEXT* to);

#endif
#ifdef VK_EXT_4444_formats
void deepcopy_VkPhysicalDevice4444FormatsFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevice4444FormatsFeaturesEXT* from,
    VkPhysicalDevice4444FormatsFeaturesEXT* to);

#endif
#ifdef VK_EXT_primitive_topology_list_restart
void deepcopy_VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* from,
    VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT* to);

#endif
#ifdef VK_EXT_extended_dynamic_state2
void deepcopy_VkPhysicalDeviceExtendedDynamicState2FeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* from,
    VkPhysicalDeviceExtendedDynamicState2FeaturesEXT* to);

#endif
#ifdef VK_EXT_color_write_enable
void deepcopy_VkPhysicalDeviceColorWriteEnableFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceColorWriteEnableFeaturesEXT* from,
    VkPhysicalDeviceColorWriteEnableFeaturesEXT* to);

void deepcopy_VkPipelineColorWriteCreateInfoEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPipelineColorWriteCreateInfoEXT* from,
    VkPipelineColorWriteCreateInfoEXT* to);

#endif
#ifdef VK_GOOGLE_gfxstream
void deepcopy_VkImportColorBufferGOOGLE(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImportColorBufferGOOGLE* from,
    VkImportColorBufferGOOGLE* to);

void deepcopy_VkImportBufferGOOGLE(
    Allocator* alloc,
    VkStructureType rootType,
    const VkImportBufferGOOGLE* from,
    VkImportBufferGOOGLE* to);

void deepcopy_VkCreateBlobGOOGLE(
    Allocator* alloc,
    VkStructureType rootType,
    const VkCreateBlobGOOGLE* from,
    VkCreateBlobGOOGLE* to);

#endif
#ifdef VK_EXT_image_compression_control_swapchain
void deepcopy_VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT(
    Allocator* alloc,
    VkStructureType rootType,
    const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* from,
    VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT* to);

#endif
}  // namespace vk
}  // namespace gfxstream
