/* NodeGroup.c generated by valac 0.56.18, the Vala compiler
 * generated from NodeGroup.vala, do not modify */

/*
* Copyright (c) 2018 (https://github.com/phase1geo/Minder)
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU General Public
* License as published by the Free Software Foundation; either
* version 2 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*
* Authored by: Trevor Williams <phase1geo@gmail.com>
*/

#include <glib-object.h>
#include <glib.h>
#include <float.h>
#include <math.h>
#include <string.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <gtk/gtk.h>
#include <libxml/tree.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_NODE_POINT (node_point_get_type ())
typedef struct _NodePoint NodePoint;
typedef enum  {
	GROUP_MODE_NONE = 0,
	GROUP_MODE_SELECTED
} GroupMode;

#define TYPE_GROUP_MODE (group_mode_get_type ())

#define TYPE_NODE_GROUP (node_group_get_type ())
#define NODE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE_GROUP, NodeGroup))
#define NODE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE_GROUP, NodeGroupClass))
#define IS_NODE_GROUP(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE_GROUP))
#define IS_NODE_GROUP_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE_GROUP))
#define NODE_GROUP_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE_GROUP, NodeGroupClass))

typedef struct _NodeGroup NodeGroup;
typedef struct _NodeGroupClass NodeGroupClass;
typedef struct _NodeGroupPrivate NodeGroupPrivate;

#define TYPE_NODE (node_get_type ())
#define NODE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_NODE, Node))
#define NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_NODE, NodeClass))
#define IS_NODE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_NODE))
#define IS_NODE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_NODE))
#define NODE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_NODE, NodeClass))

typedef struct _Node Node;
typedef struct _NodeClass NodeClass;
enum  {
	NODE_GROUP_0_PROPERTY,
	NODE_GROUP_MODE_PROPERTY,
	NODE_GROUP_COLOR_PROPERTY,
	NODE_GROUP_NOTE_PROPERTY,
	NODE_GROUP_NODES_PROPERTY,
	NODE_GROUP_NUM_PROPERTIES
};
static GParamSpec* node_group_properties[NODE_GROUP_NUM_PROPERTIES];
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_DRAW_AREA (draw_area_get_type ())
#define DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DRAW_AREA, DrawArea))
#define DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DRAW_AREA, DrawAreaClass))
#define IS_DRAW_AREA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DRAW_AREA))
#define IS_DRAW_AREA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DRAW_AREA))
#define DRAW_AREA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DRAW_AREA, DrawAreaClass))

typedef struct _DrawArea DrawArea;
typedef struct _DrawAreaClass DrawAreaClass;

#define TYPE_THEME (theme_get_type ())
#define THEME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THEME, Theme))
#define THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THEME, ThemeClass))
#define IS_THEME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THEME))
#define IS_THEME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THEME))
#define THEME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THEME, ThemeClass))

typedef struct _Theme Theme;
typedef struct _ThemeClass ThemeClass;
#define __vala_GdkRGBA_free0(var) ((var == NULL) ? NULL : (var = (_vala_GdkRGBA_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef enum  {
	SEARCH_OPTIONS_NODES,
	SEARCH_OPTIONS_CONNECTIONS,
	SEARCH_OPTIONS_CALLOUTS,
	SEARCH_OPTIONS_GROUPS,
	SEARCH_OPTIONS_TITLES,
	SEARCH_OPTIONS_NOTES,
	SEARCH_OPTIONS_FOLDED,
	SEARCH_OPTIONS_UNFOLDED,
	SEARCH_OPTIONS_TASKS,
	SEARCH_OPTIONS_NONTASKS,
	SEARCH_OPTIONS_NUM
} SearchOptions;

#define TYPE_SEARCH_OPTIONS (search_options_get_type ())
typedef enum  {
	NODE_SIDE_LEFT = 1,
	NODE_SIDE_TOP = 2,
	NODE_SIDE_RIGHT = 4,
	NODE_SIDE_BOTTOM = 8
} NodeSide;

#define TYPE_NODE_SIDE (node_side_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _NodePoint {
	gdouble x;
	gdouble y;
};

struct _NodeGroup {
	GObject parent_instance;
	NodeGroupPrivate * priv;
};

struct _NodeGroupClass {
	GObjectClass parent_class;
};

struct _NodeGroupPrivate {
	GArray* _nodes;
	GroupMode _mode;
	GdkRGBA _color;
	gchar* _note;
};

static gint NodeGroup_private_offset;
static gpointer node_group_parent_class = NULL;

VALA_EXTERN GType node_point_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NodePoint* node_point_dup (const NodePoint* self);
VALA_EXTERN void node_point_free (NodePoint* self);
VALA_EXTERN void node_point_init (NodePoint *self,
                      gdouble x,
                      gdouble y);
VALA_EXTERN GType group_mode_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType node_group_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (NodeGroup, g_object_unref)
VALA_EXTERN GType node_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Node, g_object_unref)
VALA_EXTERN GType draw_area_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DrawArea, g_object_unref)
VALA_EXTERN NodeGroup* node_group_new (DrawArea* da,
                           Node* node);
VALA_EXTERN NodeGroup* node_group_construct (GType object_type,
                                 DrawArea* da,
                                 Node* node);
VALA_EXTERN GdkRGBA* node_get_link_color (Node* self);
static GdkRGBA* _vala_GdkRGBA_copy (GdkRGBA* self);
VALA_EXTERN GType theme_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Theme, g_object_unref)
VALA_EXTERN Theme* draw_area_get_theme (DrawArea* self);
VALA_EXTERN GdkRGBA* theme_get_color (Theme* self,
                          const gchar* name);
static void _vala_GdkRGBA_free (GdkRGBA* self);
VALA_EXTERN void node_group_set_color (NodeGroup* self,
                           GdkRGBA * value);
static void _g_object_unref0_ (gpointer var);
static void _vala_Node_free_function_content_of (gpointer data);
VALA_EXTERN void node_group_add_node (NodeGroup* self,
                          Node* node);
VALA_EXTERN NodeGroup* node_group_new_array (DrawArea* da,
                                 GArray* nodes);
VALA_EXTERN NodeGroup* node_group_construct_array (GType object_type,
                                       DrawArea* da,
                                       GArray* nodes);
VALA_EXTERN NodeGroup* node_group_new_copy (NodeGroup* group);
VALA_EXTERN NodeGroup* node_group_construct_copy (GType object_type,
                                      NodeGroup* group);
VALA_EXTERN void node_group_get_color (NodeGroup* self,
                           GdkRGBA * result);
VALA_EXTERN NodeGroup* node_group_new_from_xml (DrawArea* da,
                                    xmlNode* n);
VALA_EXTERN NodeGroup* node_group_construct_from_xml (GType object_type,
                                          DrawArea* da,
                                          xmlNode* n);
VALA_EXTERN void node_group_load (NodeGroup* self,
                      DrawArea* da,
                      xmlNode* g);
VALA_EXTERN gboolean node_is_descendant_of (Node* self,
                                Node* node);
VALA_EXTERN void node_set_group (Node* self,
                     gboolean value);
VALA_EXTERN gboolean node_group_remove_node (NodeGroup* self,
                                 Node* node);
VALA_EXTERN void node_group_merge (NodeGroup* self,
                       NodeGroup* other);
VALA_EXTERN gboolean node_group_is_within (NodeGroup* self,
                               gdouble x,
                               gdouble y);
static void _node_point_free0_ (gpointer var);
static void _vala_NodePoint_free_function_content_of (gpointer data);
VALA_EXTERN void node_group_get_tree_points (Node* origin,
                                 Node* node,
                                 GArray* points);
VALA_EXTERN void node_group_get_convex_hull (GArray* points,
                                 GArray* hull);
VALA_EXTERN void node_group_get_match_items (NodeGroup* self,
                                 const gchar* tabname,
                                 const gchar* pattern,
                                 gboolean* search_opts,
                                 gint search_opts_length1,
                                 GtkListStore** matches);
VALA_EXTERN gchar* utils_rootname (const gchar* filename);
VALA_EXTERN GType search_options_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gchar* utils_match_string (const gchar* pattern,
                           const gchar* value);
VALA_EXTERN const gchar* node_group_get_note (NodeGroup* self);
VALA_EXTERN xmlNode* node_group_save (NodeGroup* self);
VALA_EXTERN gchar* utils_color_from_rgba (GdkRGBA* rgba);
VALA_EXTERN gint node_id (Node* self);
static void node_group_load_node (NodeGroup* self,
                           DrawArea* da,
                           xmlNode* n);
static void node_group_load_note (NodeGroup* self,
                           xmlNode* n);
VALA_EXTERN Node* draw_area_get_node (DrawArea* self,
                          GArray* nodes,
                          gint id);
VALA_EXTERN GArray* draw_area_get_nodes (DrawArea* self);
VALA_EXTERN void node_group_set_note (NodeGroup* self,
                          const gchar* value);
VALA_EXTERN void node_group_draw (NodeGroup* self,
                      cairo_t* ctx,
                      Theme* theme,
                      gboolean exporting);
VALA_EXTERN GroupMode node_group_get_mode (NodeGroup* self);
VALA_EXTERN gdouble node_get_alpha (Node* self);
static void node_group_draw_cloud (cairo_t* ctx,
                            GdkRGBA* color,
                            gboolean selected,
                            gdouble alpha,
                            GArray* points);
VALA_EXTERN void node_group_draw_tree (cairo_t* ctx,
                           Node* node,
                           Theme* theme);
VALA_EXTERN void utils_set_context_color_with_alpha (cairo_t* ctx,
                                         GdkRGBA* color,
                                         gdouble alpha);
VALA_EXTERN void node_group_add_node_points (GArray* points,
                                 Node* node,
                                 gint pad);
VALA_EXTERN gdouble node_get_posx (Node* self);
VALA_EXTERN gdouble node_get_posy (Node* self);
VALA_EXTERN gdouble node_get_width (Node* self);
VALA_EXTERN gdouble node_get_height (Node* self);
VALA_EXTERN gboolean node_get_folded (Node* self);
VALA_EXTERN void node_fold_bbox (Node* self,
                     gdouble* x,
                     gdouble* y,
                     gdouble* w,
                     gdouble* h);
VALA_EXTERN GType node_side_get_type (void) G_GNUC_CONST ;
VALA_EXTERN NodeSide node_get_side (Node* self);
VALA_EXTERN Node* node_folded_ancestor (Node* self);
VALA_EXTERN gint node_groups_between (Node* self,
                          Node* node);
VALA_EXTERN GArray* node_children (Node* self);
VALA_EXTERN gint node_group_calc_orientation (NodePoint* p,
                                  NodePoint* q,
                                  NodePoint* r);
VALA_EXTERN void node_group_set_mode (NodeGroup* self,
                          GroupMode value);
static gboolean _gdk_rgba_equal (const GdkRGBA * s1,
                          const GdkRGBA * s2);
VALA_EXTERN GArray* node_group_get_nodes (NodeGroup* self);
static void node_group_finalize (GObject * obj);
static GType node_group_get_type_once (void);
static void _vala_node_group_get_property (GObject * object,
                                    guint property_id,
                                    GValue * value,
                                    GParamSpec * pspec);
static void _vala_node_group_set_property (GObject * object,
                                    guint property_id,
                                    const GValue * value,
                                    GParamSpec * pspec);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

void
node_point_init (NodePoint *self,
                 gdouble x,
                 gdouble y)
{
	memset (self, 0, sizeof (NodePoint));
	(*self).x = x;
	(*self).y = y;
}

NodePoint*
node_point_dup (const NodePoint* self)
{
	NodePoint* dup;
	dup = g_new0 (NodePoint, 1);
	memcpy (dup, self, sizeof (NodePoint));
	return dup;
}

void
node_point_free (NodePoint* self)
{
	g_free (self);
}

static GType
node_point_get_type_once (void)
{
	GType node_point_type_id;
	node_point_type_id = g_boxed_type_register_static ("NodePoint", (GBoxedCopyFunc) node_point_dup, (GBoxedFreeFunc) node_point_free);
	return node_point_type_id;
}

GType
node_point_get_type (void)
{
	static volatile gsize node_point_type_id__once = 0;
	if (g_once_init_enter (&node_point_type_id__once)) {
		GType node_point_type_id;
		node_point_type_id = node_point_get_type_once ();
		g_once_init_leave (&node_point_type_id__once, node_point_type_id);
	}
	return node_point_type_id__once;
}

static GType
group_mode_get_type_once (void)
{
	static const GEnumValue values[] = {{GROUP_MODE_NONE, "GROUP_MODE_NONE", "none"}, {GROUP_MODE_SELECTED, "GROUP_MODE_SELECTED", "selected"}, {0, NULL, NULL}};
	GType group_mode_type_id;
	group_mode_type_id = g_enum_register_static ("GroupMode", values);
	return group_mode_type_id;
}

GType
group_mode_get_type (void)
{
	static volatile gsize group_mode_type_id__once = 0;
	if (g_once_init_enter (&group_mode_type_id__once)) {
		GType group_mode_type_id;
		group_mode_type_id = group_mode_get_type_once ();
		g_once_init_leave (&group_mode_type_id__once, group_mode_type_id);
	}
	return group_mode_type_id__once;
}

static inline gpointer
node_group_get_instance_private (NodeGroup* self)
{
	return G_STRUCT_MEMBER_P (self, NodeGroup_private_offset);
}

static GdkRGBA*
_vala_GdkRGBA_copy (GdkRGBA* self)
{
	return g_boxed_copy (gdk_rgba_get_type (), self);
}

static gpointer
__vala_GdkRGBA_copy0 (gpointer self)
{
	return self ? _vala_GdkRGBA_copy (self) : NULL;
}

static void
_vala_GdkRGBA_free (GdkRGBA* self)
{
	g_boxed_free (gdk_rgba_get_type (), self);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static void
_vala_Node_free_function_content_of (gpointer data)
{
	Node* self;
	self = *((Node**) data);
	_g_object_unref0_ (self);
}

NodeGroup*
node_group_construct (GType object_type,
                      DrawArea* da,
                      Node* node)
{
	NodeGroup * self = NULL;
	GdkRGBA* _tmp0_ = NULL;
	GdkRGBA* _tmp1_;
	GdkRGBA* _tmp2_;
	GdkRGBA* _tmp3_;
	GdkRGBA _tmp7_;
	GArray* _tmp8_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (node != NULL, NULL);
	self = (NodeGroup*) g_object_new (object_type, NULL);
	_tmp1_ = node_get_link_color (node);
	_tmp2_ = _tmp1_;
	_tmp3_ = __vala_GdkRGBA_copy0 (_tmp2_);
	_tmp0_ = _tmp3_;
	if (_tmp0_ == NULL) {
		Theme* _tmp4_;
		Theme* _tmp5_;
		GdkRGBA* _tmp6_;
		_tmp4_ = draw_area_get_theme (da);
		_tmp5_ = _tmp4_;
		_tmp6_ = theme_get_color (_tmp5_, "root_background");
		__vala_GdkRGBA_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
	}
	_tmp7_ = *_tmp0_;
	node_group_set_color (self, &_tmp7_);
	_tmp8_ = g_array_new (TRUE, TRUE, sizeof (Node*));
	g_array_set_clear_func (_tmp8_, (GDestroyNotify) _vala_Node_free_function_content_of);
	_g_array_unref0 (self->priv->_nodes);
	self->priv->_nodes = _tmp8_;
	node_group_add_node (self, node);
	__vala_GdkRGBA_free0 (_tmp0_);
	return self;
}

NodeGroup*
node_group_new (DrawArea* da,
                Node* node)
{
	return node_group_construct (TYPE_NODE_GROUP, da, node);
}

NodeGroup*
node_group_construct_array (GType object_type,
                            DrawArea* da,
                            GArray* nodes)
{
	NodeGroup * self = NULL;
	GdkRGBA* _tmp0_ = NULL;
	Node* _tmp1_;
	GdkRGBA* _tmp2_;
	GdkRGBA* _tmp3_;
	GdkRGBA* _tmp4_;
	GdkRGBA _tmp8_;
	GArray* _tmp9_;
	g_return_val_if_fail (da != NULL, NULL);
	g_return_val_if_fail (nodes != NULL, NULL);
	self = (NodeGroup*) g_object_new (object_type, NULL);
	_tmp1_ = g_array_index (nodes, Node*, (guint) 0);
	_tmp2_ = node_get_link_color (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = __vala_GdkRGBA_copy0 (_tmp3_);
	_tmp0_ = _tmp4_;
	if (_tmp0_ == NULL) {
		Theme* _tmp5_;
		Theme* _tmp6_;
		GdkRGBA* _tmp7_;
		_tmp5_ = draw_area_get_theme (da);
		_tmp6_ = _tmp5_;
		_tmp7_ = theme_get_color (_tmp6_, "root_background");
		__vala_GdkRGBA_free0 (_tmp0_);
		_tmp0_ = _tmp7_;
		_g_object_unref0 (_tmp6_);
	}
	_tmp8_ = *_tmp0_;
	node_group_set_color (self, &_tmp8_);
	_tmp9_ = g_array_new (TRUE, TRUE, sizeof (Node*));
	g_array_set_clear_func (_tmp9_, (GDestroyNotify) _vala_Node_free_function_content_of);
	_g_array_unref0 (self->priv->_nodes);
	self->priv->_nodes = _tmp9_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp10_ = FALSE;
			_tmp10_ = TRUE;
			while (TRUE) {
				Node* _tmp12_;
				if (!_tmp10_) {
					gint _tmp11_;
					_tmp11_ = i;
					i = _tmp11_ + 1;
				}
				_tmp10_ = FALSE;
				if (!(((guint) i) < nodes->len)) {
					break;
				}
				_tmp12_ = g_array_index (nodes, Node*, (guint) i);
				node_group_add_node (self, _tmp12_);
			}
		}
	}
	__vala_GdkRGBA_free0 (_tmp0_);
	return self;
}

NodeGroup*
node_group_new_array (DrawArea* da,
                      GArray* nodes)
{
	return node_group_construct_array (TYPE_NODE_GROUP, da, nodes);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

NodeGroup*
node_group_construct_copy (GType object_type,
                           NodeGroup* group)
{
	NodeGroup * self = NULL;
	GdkRGBA _tmp0_;
	GArray* _tmp1_;
	g_return_val_if_fail (group != NULL, NULL);
	self = (NodeGroup*) g_object_new (object_type, NULL);
	_tmp0_ = group->priv->_color;
	node_group_set_color (self, &_tmp0_);
	_tmp1_ = g_array_new (TRUE, TRUE, sizeof (Node*));
	g_array_set_clear_func (_tmp1_, (GDestroyNotify) _vala_Node_free_function_content_of);
	_g_array_unref0 (self->priv->_nodes);
	self->priv->_nodes = _tmp1_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				GArray* _tmp4_;
				GArray* _tmp5_;
				GArray* _tmp6_;
				Node* _tmp7_;
				Node* _tmp8_;
				if (!_tmp2_) {
					gint _tmp3_;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = group->priv->_nodes;
				if (!(((guint) i) < _tmp4_->len)) {
					break;
				}
				_tmp5_ = self->priv->_nodes;
				_tmp6_ = group->priv->_nodes;
				_tmp7_ = g_array_index (_tmp6_, Node*, (guint) i);
				_tmp8_ = _g_object_ref0 (_tmp7_);
				g_array_append_val (_tmp5_, _tmp8_);
			}
		}
	}
	return self;
}

NodeGroup*
node_group_new_copy (NodeGroup* group)
{
	return node_group_construct_copy (TYPE_NODE_GROUP, group);
}

NodeGroup*
node_group_construct_from_xml (GType object_type,
                               DrawArea* da,
                               xmlNode* n)
{
	NodeGroup * self = NULL;
	GArray* _tmp0_;
	g_return_val_if_fail (da != NULL, NULL);
	self = (NodeGroup*) g_object_new (object_type, NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (Node*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_Node_free_function_content_of);
	_g_array_unref0 (self->priv->_nodes);
	self->priv->_nodes = _tmp0_;
	node_group_load (self, da, n);
	return self;
}

NodeGroup*
node_group_new_from_xml (DrawArea* da,
                         xmlNode* n)
{
	return node_group_construct_from_xml (TYPE_NODE_GROUP, da, n);
}

static gpointer
vala_g_array_remove_index (GArray* self,
                           guint index)
{
	gpointer g = NULL;
	gpointer* _tmp0_;
	gint _tmp0__length1;
	gpointer _tmp1_;
	gpointer result;
	g_return_val_if_fail (self != NULL, NULL);
	_vala_assert (self->len > index, "length > index");
	_tmp0_ = self->data;
	_tmp0__length1 = self->len;
	_tmp1_ = _tmp0_[index];
	_tmp0_[index] = NULL;
	g = _tmp1_;
	g_array_remove_index (self, index);
	result = g;
	return result;
}

void
node_group_add_node (NodeGroup* self,
                     Node* node)
{
	GArray* _tmp13_;
	Node* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (node != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				Node* n = NULL;
				GArray* _tmp3_;
				Node* _tmp4_;
				Node* _tmp5_;
				Node* _tmp6_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_nodes;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_nodes;
				_tmp4_ = g_array_index (_tmp3_, Node*, (guint) i);
				_tmp5_ = _g_object_ref0 (_tmp4_);
				n = _tmp5_;
				_tmp6_ = n;
				if (node_is_descendant_of (_tmp6_, node)) {
					GArray* _tmp7_;
					Node* _tmp8_;
					GArray* _tmp9_;
					Node* _tmp10_;
					Node* _tmp11_;
					_tmp7_ = self->priv->_nodes;
					_tmp8_ = g_array_index (_tmp7_, Node*, (guint) i);
					node_set_group (_tmp8_, FALSE);
					_tmp9_ = self->priv->_nodes;
					_tmp10_ = vala_g_array_remove_index (_tmp9_, (guint) i);
					_tmp11_ = _tmp10_;
					_g_object_unref0 (_tmp11_);
				} else {
					Node* _tmp12_;
					_tmp12_ = n;
					if (node_is_descendant_of (node, _tmp12_)) {
						_g_object_unref0 (n);
						return;
					}
				}
				_g_object_unref0 (n);
			}
		}
	}
	node_set_group (node, TRUE);
	_tmp13_ = self->priv->_nodes;
	_tmp14_ = _g_object_ref0 (node);
	g_array_append_val (_tmp13_, _tmp14_);
}

gboolean
node_group_remove_node (NodeGroup* self,
                        Node* node)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (node != NULL, FALSE);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Node* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = self->priv->_nodes;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = self->priv->_nodes;
				_tmp4_ = g_array_index (_tmp3_, Node*, (guint) i);
				if (_tmp4_ == node) {
					GArray* _tmp5_;
					Node* _tmp6_;
					Node* _tmp7_;
					node_set_group (node, FALSE);
					_tmp5_ = self->priv->_nodes;
					_tmp6_ = vala_g_array_remove_index (_tmp5_, (guint) i);
					_tmp7_ = _tmp6_;
					_g_object_unref0 (_tmp7_);
					result = TRUE;
					return result;
				}
			}
		}
	}
	result = FALSE;
	return result;
}

void
node_group_merge (NodeGroup* self,
                  NodeGroup* other)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (other != NULL);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				GArray* _tmp2_;
				GArray* _tmp3_;
				Node* _tmp4_;
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = other->priv->_nodes;
				if (!(((guint) i) < _tmp2_->len)) {
					break;
				}
				_tmp3_ = other->priv->_nodes;
				_tmp4_ = g_array_index (_tmp3_, Node*, (guint) i);
				node_group_add_node (self, _tmp4_);
			}
		}
	}
}

static void
_node_point_free0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (node_point_free (var), NULL));
}

static void
_vala_NodePoint_free_function_content_of (gpointer data)
{
	NodePoint* self;
	self = *((NodePoint**) data);
	_node_point_free0_ (self);
}

static gpointer
_node_point_dup0 (gpointer self)
{
	return self ? node_point_dup (self) : NULL;
}

gboolean
node_group_is_within (NodeGroup* self,
                      gdouble x,
                      gdouble y)
{
	NodePoint cursor = {0};
	GArray* points = NULL;
	GArray* _tmp0_;
	GArray* hull = NULL;
	GArray* _tmp1_;
	GArray* _tmp2_;
	NodePoint _tmp3_;
	NodePoint* _tmp4_;
	GArray* _tmp13_;
	GArray* _tmp14_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	node_point_init (&cursor, x, y);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (NodePoint*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_NodePoint_free_function_content_of);
	points = _tmp0_;
	_tmp1_ = g_array_new (TRUE, TRUE, sizeof (NodePoint*));
	g_array_set_clear_func (_tmp1_, (GDestroyNotify) _vala_NodePoint_free_function_content_of);
	hull = _tmp1_;
	_tmp2_ = points;
	_tmp3_ = cursor;
	_tmp4_ = _node_point_dup0 (&_tmp3_);
	g_array_append_val (_tmp2_, _tmp4_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GArray* _tmp7_;
				GArray* _tmp8_;
				Node* _tmp9_;
				GArray* _tmp10_;
				Node* _tmp11_;
				GArray* _tmp12_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = self->priv->_nodes;
				if (!(((guint) i) < _tmp7_->len)) {
					break;
				}
				_tmp8_ = self->priv->_nodes;
				_tmp9_ = g_array_index (_tmp8_, Node*, (guint) i);
				_tmp10_ = self->priv->_nodes;
				_tmp11_ = g_array_index (_tmp10_, Node*, (guint) i);
				_tmp12_ = points;
				node_group_get_tree_points (_tmp9_, _tmp11_, _tmp12_);
			}
		}
	}
	_tmp13_ = points;
	_tmp14_ = hull;
	node_group_get_convex_hull (_tmp13_, _tmp14_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp15_ = FALSE;
			_tmp15_ = TRUE;
			while (TRUE) {
				GArray* _tmp17_;
				gboolean _tmp18_ = FALSE;
				NodePoint _tmp19_;
				GArray* _tmp20_;
				if (!_tmp15_) {
					gint _tmp16_;
					_tmp16_ = i;
					i = _tmp16_ + 1;
				}
				_tmp15_ = FALSE;
				_tmp17_ = hull;
				if (!(((guint) i) < _tmp17_->len)) {
					break;
				}
				_tmp19_ = cursor;
				_tmp20_ = hull;
				if (_tmp19_.x == (*g_array_index (_tmp20_, NodePoint*, (guint) i)).x) {
					NodePoint _tmp21_;
					GArray* _tmp22_;
					_tmp21_ = cursor;
					_tmp22_ = hull;
					_tmp18_ = _tmp21_.y == (*g_array_index (_tmp22_, NodePoint*, (guint) i)).y;
				} else {
					_tmp18_ = FALSE;
				}
				if (_tmp18_) {
					result = FALSE;
					_g_array_unref0 (hull);
					_g_array_unref0 (points);
					return result;
				}
			}
		}
	}
	result = TRUE;
	_g_array_unref0 (hull);
	_g_array_unref0 (points);
	return result;
}

void
node_group_get_match_items (NodeGroup* self,
                            const gchar* tabname,
                            const gchar* pattern,
                            gboolean* search_opts,
                            gint search_opts_length1,
                            GtkListStore** matches)
{
	gchar* tab = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (tabname != NULL);
	g_return_if_fail (pattern != NULL);
	g_return_if_fail (*matches != NULL);
	_tmp0_ = utils_rootname (tabname);
	tab = _tmp0_;
	_tmp1_ = search_opts[SEARCH_OPTIONS_NOTES];
	if (_tmp1_) {
		gchar* str = NULL;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp2_ = self->priv->_note;
		_tmp3_ = utils_match_string (pattern, _tmp2_);
		str = _tmp3_;
		_tmp4_ = str;
		_tmp5_ = strlen (_tmp4_);
		_tmp6_ = _tmp5_;
		if (_tmp6_ > 0) {
			GtkTreeIter it = {0};
			GtkTreeIter _tmp7_ = {0};
			GtkTreeIter _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			const gchar* _tmp11_;
			const gchar* _tmp12_;
			gtk_list_store_append (*matches, &_tmp7_);
			it = _tmp7_;
			_tmp8_ = it;
			_tmp9_ = g_strdup_printf ("<b><i>%s:</i></b>", _ ("Group Note"));
			_tmp10_ = _tmp9_;
			_tmp11_ = str;
			_tmp12_ = tab;
			gtk_list_store_set (*matches, &_tmp8_, 0, _tmp10_, 1, _tmp11_, 2, NULL, 3, NULL, 4, NULL, 5, self, 6, tabname, 7, _tmp12_, -1, -1);
			_g_free0 (_tmp10_);
		}
		_g_free0 (str);
	}
	_g_free0 (tab);
}

xmlNode*
node_group_save (NodeGroup* self)
{
	xmlNode* g = NULL;
	xmlNode* _tmp0_;
	xmlNode* _tmp1_;
	GdkRGBA _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	xmlNode* _tmp16_;
	const gchar* _tmp17_;
	xmlNode* _tmp18_;
	xmlNode* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = xmlNewNode (NULL, (xmlChar*) "group");
	g = _tmp0_;
	_tmp1_ = g;
	_tmp2_ = self->priv->_color;
	_tmp3_ = utils_color_from_rgba (&_tmp2_);
	_tmp4_ = _tmp3_;
	xmlSetProp (_tmp1_, (xmlChar*) "color", (xmlChar*) _tmp4_);
	_g_free0 (_tmp4_);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp5_ = FALSE;
			_tmp5_ = TRUE;
			while (TRUE) {
				GArray* _tmp7_;
				xmlNode* n = NULL;
				xmlNode* _tmp8_;
				xmlNode* _tmp9_;
				GArray* _tmp10_;
				Node* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				xmlNode* _tmp14_;
				xmlNode* _tmp15_;
				if (!_tmp5_) {
					gint _tmp6_;
					_tmp6_ = i;
					i = _tmp6_ + 1;
				}
				_tmp5_ = FALSE;
				_tmp7_ = self->priv->_nodes;
				if (!(((guint) i) < _tmp7_->len)) {
					break;
				}
				_tmp8_ = xmlNewNode (NULL, (xmlChar*) "node");
				n = _tmp8_;
				_tmp9_ = n;
				_tmp10_ = self->priv->_nodes;
				_tmp11_ = g_array_index (_tmp10_, Node*, (guint) i);
				_tmp12_ = g_strdup_printf ("%i", node_id (_tmp11_));
				_tmp13_ = _tmp12_;
				xmlSetProp (_tmp9_, (xmlChar*) "id", (xmlChar*) _tmp13_);
				_g_free0 (_tmp13_);
				_tmp14_ = g;
				_tmp15_ = n;
				xmlAddChild (_tmp14_, _tmp15_);
			}
		}
	}
	_tmp16_ = g;
	_tmp17_ = self->priv->_note;
	xmlNewTextChild (_tmp16_, NULL, (xmlChar*) "groupnote", (xmlChar*) _tmp17_);
	_tmp18_ = g;
	result = _tmp18_;
	return result;
}

void
node_group_load (NodeGroup* self,
                 DrawArea* da,
                 xmlNode* g)
{
	gchar* c = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = (gchar*) xmlGetProp (g, (xmlChar*) "color");
	c = _tmp0_;
	_tmp1_ = c;
	if (_tmp1_ != NULL) {
		GdkRGBA clr = {0};
		GdkRGBA _tmp2_ = {0};
		const gchar* _tmp3_;
		GdkRGBA _tmp4_;
		_tmp2_.red = 1.0;
		_tmp2_.green = 1.0;
		_tmp2_.blue = 1.0;
		_tmp2_.alpha = 1.0;
		clr = _tmp2_;
		_tmp3_ = c;
		gdk_rgba_parse (&clr, _tmp3_);
		_tmp4_ = clr;
		node_group_set_color (self, &_tmp4_);
	}
	{
		xmlNode* it = NULL;
		xmlNode* _tmp5_;
		_tmp5_ = g->children;
		it = _tmp5_;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				xmlNode* _tmp9_;
				xmlNode* _tmp10_;
				if (!_tmp6_) {
					xmlNode* _tmp7_;
					xmlNode* _tmp8_;
					_tmp7_ = it;
					_tmp8_ = _tmp7_->next;
					it = _tmp8_;
				}
				_tmp6_ = FALSE;
				_tmp9_ = it;
				if (!(_tmp9_ != NULL)) {
					break;
				}
				_tmp10_ = it;
				if (_tmp10_->type == XML_ELEMENT_NODE) {
					xmlNode* _tmp11_;
					const gchar* _tmp12_;
					const gchar* _tmp13_;
					GQuark _tmp15_ = 0U;
					static GQuark _tmp14_label0 = 0;
					static GQuark _tmp14_label1 = 0;
					_tmp11_ = it;
					_tmp12_ = _tmp11_->name;
					_tmp13_ = _tmp12_;
					_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
					if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("node")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp16_;
								_tmp16_ = it;
								node_group_load_node (self, da, _tmp16_);
								break;
							}
						}
					} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("groupnote")))) {
						switch (0) {
							default:
							{
								xmlNode* _tmp17_;
								_tmp17_ = it;
								node_group_load_note (self, _tmp17_);
								break;
							}
						}
					}
				}
			}
		}
	}
	_g_free0 (c);
}

static void
node_group_load_node (NodeGroup* self,
                      DrawArea* da,
                      xmlNode* n)
{
	gchar* i = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (da != NULL);
	_tmp0_ = (gchar*) xmlGetProp (n, (xmlChar*) "id");
	i = _tmp0_;
	_tmp1_ = i;
	if (_tmp1_ != NULL) {
		gint id = 0;
		const gchar* _tmp2_;
		Node* node = NULL;
		GArray* _tmp3_;
		GArray* _tmp4_;
		Node* _tmp5_;
		Node* _tmp6_;
		Node* _tmp7_;
		_tmp2_ = i;
		id = atoi (_tmp2_);
		_tmp3_ = draw_area_get_nodes (da);
		_tmp4_ = _tmp3_;
		_tmp5_ = draw_area_get_node (da, _tmp4_, id);
		_tmp6_ = _tmp5_;
		_g_array_unref0 (_tmp4_);
		node = _tmp6_;
		_tmp7_ = node;
		if (_tmp7_ != NULL) {
			Node* _tmp8_;
			GArray* _tmp9_;
			Node* _tmp10_;
			Node* _tmp11_;
			_tmp8_ = node;
			node_set_group (_tmp8_, TRUE);
			_tmp9_ = self->priv->_nodes;
			_tmp10_ = node;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			g_array_append_val (_tmp9_, _tmp11_);
		}
		_g_object_unref0 (node);
	}
	_g_free0 (i);
}

static void
node_group_load_note (NodeGroup* self,
                      xmlNode* n)
{
	gboolean _tmp0_ = FALSE;
	xmlNode* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = n->children;
	if (_tmp1_ != NULL) {
		xmlNode* _tmp2_;
		_tmp2_ = n->children;
		_tmp0_ = _tmp2_->type == XML_TEXT_NODE;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		xmlNode* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = n->children;
		_tmp4_ = (gchar*) xmlNodeGetContent (_tmp3_);
		_tmp5_ = _tmp4_;
		node_group_set_note (self, _tmp5_);
		_g_free0 (_tmp5_);
	}
}

void
node_group_draw (NodeGroup* self,
                 cairo_t* ctx,
                 Theme* theme,
                 gboolean exporting)
{
	GArray* points = NULL;
	GArray* _tmp0_;
	gboolean _tmp1_ = FALSE;
	GroupMode _tmp2_;
	gboolean selected = FALSE;
	gdouble alpha = 0.0;
	GdkRGBA* _tmp20_ = NULL;
	GArray* _tmp24_;
	GdkRGBA _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (NodePoint*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_NodePoint_free_function_content_of);
	points = _tmp0_;
	_tmp2_ = self->priv->_mode;
	if (_tmp2_ == GROUP_MODE_SELECTED) {
		_tmp1_ = !exporting;
	} else {
		_tmp1_ = FALSE;
	}
	selected = _tmp1_;
	alpha = 0.0;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				GArray* _tmp5_;
				GArray* _tmp6_;
				Node* _tmp7_;
				GArray* _tmp8_;
				Node* _tmp9_;
				GArray* _tmp10_;
				gdouble _tmp11_ = 0.0;
				GArray* _tmp12_;
				Node* _tmp13_;
				gdouble _tmp14_;
				gdouble _tmp15_;
				if (!_tmp3_) {
					gint _tmp4_;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = self->priv->_nodes;
				if (!(((guint) i) < _tmp5_->len)) {
					break;
				}
				_tmp6_ = self->priv->_nodes;
				_tmp7_ = g_array_index (_tmp6_, Node*, (guint) i);
				_tmp8_ = self->priv->_nodes;
				_tmp9_ = g_array_index (_tmp8_, Node*, (guint) i);
				_tmp10_ = points;
				node_group_get_tree_points (_tmp7_, _tmp9_, _tmp10_);
				_tmp12_ = self->priv->_nodes;
				_tmp13_ = g_array_index (_tmp12_, Node*, (guint) i);
				_tmp14_ = node_get_alpha (_tmp13_);
				_tmp15_ = _tmp14_;
				if (_tmp15_ > alpha) {
					GArray* _tmp16_;
					Node* _tmp17_;
					gdouble _tmp18_;
					gdouble _tmp19_;
					_tmp16_ = self->priv->_nodes;
					_tmp17_ = g_array_index (_tmp16_, Node*, (guint) i);
					_tmp18_ = node_get_alpha (_tmp17_);
					_tmp19_ = _tmp18_;
					_tmp11_ = _tmp19_;
				} else {
					_tmp11_ = alpha;
				}
				alpha = _tmp11_;
			}
		}
	}
	if (selected) {
		GdkRGBA* _tmp21_;
		_tmp21_ = theme_get_color (theme, "nodesel_background");
		__vala_GdkRGBA_free0 (_tmp20_);
		_tmp20_ = _tmp21_;
	} else {
		GdkRGBA _tmp22_;
		GdkRGBA* _tmp23_;
		_tmp22_ = self->priv->_color;
		_tmp23_ = __vala_GdkRGBA_copy0 (&_tmp22_);
		__vala_GdkRGBA_free0 (_tmp20_);
		_tmp20_ = _tmp23_;
	}
	_tmp24_ = points;
	_tmp25_ = *_tmp20_;
	node_group_draw_cloud (ctx, &_tmp25_, selected, alpha, _tmp24_);
	__vala_GdkRGBA_free0 (_tmp20_);
	_g_array_unref0 (points);
}

void
node_group_draw_tree (cairo_t* ctx,
                      Node* node,
                      Theme* theme)
{
	GArray* points = NULL;
	GArray* _tmp0_;
	GdkRGBA* _tmp1_;
	GdkRGBA* _tmp2_;
	gdouble _tmp3_;
	gdouble _tmp4_;
	GdkRGBA _tmp5_;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (theme != NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (NodePoint*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_NodePoint_free_function_content_of);
	points = _tmp0_;
	node_group_get_tree_points (node, node, points);
	_tmp1_ = node_get_link_color (node);
	_tmp2_ = _tmp1_;
	_tmp3_ = node_get_alpha (node);
	_tmp4_ = _tmp3_;
	_tmp5_ = *_tmp2_;
	node_group_draw_cloud (ctx, &_tmp5_, FALSE, _tmp4_, points);
	_g_array_unref0 (points);
}

static void
node_group_draw_cloud (cairo_t* ctx,
                       GdkRGBA* color,
                       gboolean selected,
                       gdouble alpha,
                       GArray* points)
{
	GArray* hull = NULL;
	GArray* _tmp0_;
	GArray* _tmp1_;
	GArray* _tmp2_;
	GdkRGBA _tmp3_;
	GArray* _tmp4_;
	GArray* _tmp5_;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (color != NULL);
	g_return_if_fail (points != NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (NodePoint*));
	g_array_set_clear_func (_tmp0_, (GDestroyNotify) _vala_NodePoint_free_function_content_of);
	hull = _tmp0_;
	_tmp1_ = hull;
	node_group_get_convex_hull (points, _tmp1_);
	_tmp2_ = hull;
	if (_tmp2_->len == ((guint) 0)) {
		_g_array_unref0 (hull);
		return;
	}
	_tmp3_ = *color;
	utils_set_context_color_with_alpha (ctx, &_tmp3_, alpha * 0.3);
	_tmp4_ = hull;
	_tmp5_ = hull;
	cairo_move_to (ctx, (*g_array_index (_tmp4_, NodePoint*, (guint) 0)).x, (*g_array_index (_tmp5_, NodePoint*, (guint) 0)).y);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				GArray* _tmp8_;
				GArray* _tmp9_;
				GArray* _tmp10_;
				if (!_tmp6_) {
					gint _tmp7_;
					_tmp7_ = i;
					i = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = hull;
				if (!(((guint) i) < _tmp8_->len)) {
					break;
				}
				_tmp9_ = hull;
				_tmp10_ = hull;
				cairo_line_to (ctx, (*g_array_index (_tmp9_, NodePoint*, (guint) i)).x, (*g_array_index (_tmp10_, NodePoint*, (guint) i)).y);
			}
		}
	}
	cairo_close_path (ctx);
	if (selected) {
		GdkRGBA _tmp11_;
		cairo_fill_preserve (ctx);
		_tmp11_ = *color;
		utils_set_context_color_with_alpha (ctx, &_tmp11_, alpha);
		cairo_stroke (ctx);
	} else {
		cairo_fill (ctx);
	}
	_g_array_unref0 (hull);
}

void
node_group_add_node_points (GArray* points,
                            Node* node,
                            gint pad)
{
	gdouble x1 = 0.0;
	gdouble _tmp0_;
	gdouble _tmp1_;
	gdouble y1 = 0.0;
	gdouble _tmp2_;
	gdouble _tmp3_;
	gdouble x2 = 0.0;
	gdouble _tmp4_;
	gdouble _tmp5_;
	gdouble _tmp6_;
	gdouble _tmp7_;
	gdouble y2 = 0.0;
	gdouble _tmp8_;
	gdouble _tmp9_;
	gdouble _tmp10_;
	gdouble _tmp11_;
	gboolean _tmp12_;
	gboolean _tmp13_;
	NodePoint _tmp20_ = {0};
	NodePoint* _tmp21_;
	NodePoint _tmp22_ = {0};
	NodePoint* _tmp23_;
	NodePoint _tmp24_ = {0};
	NodePoint* _tmp25_;
	NodePoint _tmp26_ = {0};
	NodePoint* _tmp27_;
	g_return_if_fail (points != NULL);
	g_return_if_fail (node != NULL);
	_tmp0_ = node_get_posx (node);
	_tmp1_ = _tmp0_;
	x1 = _tmp1_ - pad;
	_tmp2_ = node_get_posy (node);
	_tmp3_ = _tmp2_;
	y1 = _tmp3_ - pad;
	_tmp4_ = node_get_posx (node);
	_tmp5_ = _tmp4_;
	_tmp6_ = node_get_width (node);
	_tmp7_ = _tmp6_;
	x2 = (_tmp5_ + _tmp7_) + pad;
	_tmp8_ = node_get_posy (node);
	_tmp9_ = _tmp8_;
	_tmp10_ = node_get_height (node);
	_tmp11_ = _tmp10_;
	y2 = (_tmp9_ + _tmp11_) + pad;
	_tmp12_ = node_get_folded (node);
	_tmp13_ = _tmp12_;
	if (_tmp13_) {
		gdouble fx = 0.0;
		gdouble fy = 0.0;
		gdouble fw = 0.0;
		gdouble fh = 0.0;
		gdouble _tmp14_ = 0.0;
		gdouble _tmp15_ = 0.0;
		gdouble _tmp16_ = 0.0;
		gdouble _tmp17_ = 0.0;
		NodeSide _tmp18_;
		NodeSide _tmp19_;
		node_fold_bbox (node, &_tmp14_, &_tmp15_, &_tmp16_, &_tmp17_);
		fx = _tmp14_;
		fy = _tmp15_;
		fw = _tmp16_;
		fh = _tmp17_;
		_tmp18_ = node_get_side (node);
		_tmp19_ = _tmp18_;
		switch (_tmp19_) {
			case NODE_SIDE_LEFT:
			{
				x1 = fx - pad;
				break;
			}
			case NODE_SIDE_RIGHT:
			{
				x2 = (fx + fw) + pad;
				break;
			}
			case NODE_SIDE_TOP:
			{
				y1 = fy - pad;
				break;
			}
			case NODE_SIDE_BOTTOM:
			{
				y2 = (fy + fh) + pad;
				break;
			}
			default:
			break;
		}
	}
	node_point_init (&_tmp20_, x1, y1);
	_tmp21_ = _node_point_dup0 (&_tmp20_);
	g_array_append_val (points, _tmp21_);
	node_point_init (&_tmp22_, x2, y1);
	_tmp23_ = _node_point_dup0 (&_tmp22_);
	g_array_append_val (points, _tmp23_);
	node_point_init (&_tmp24_, x1, y2);
	_tmp25_ = _node_point_dup0 (&_tmp24_);
	g_array_append_val (points, _tmp25_);
	node_point_init (&_tmp26_, x2, y2);
	_tmp27_ = _node_point_dup0 (&_tmp26_);
	g_array_append_val (points, _tmp27_);
}

void
node_group_get_tree_points (Node* origin,
                            Node* node,
                            GArray* points)
{
	Node* _tmp0_;
	Node* _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (origin != NULL);
	g_return_if_fail (node != NULL);
	g_return_if_fail (points != NULL);
	_tmp0_ = node_folded_ancestor (node);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_ == NULL;
	_g_object_unref0 (_tmp1_);
	if (_tmp2_) {
		gint pad = 0;
		pad = node_groups_between (node, origin) * 5;
		node_group_add_node_points (points, node, pad);
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					GArray* _tmp5_;
					GArray* _tmp6_;
					gboolean _tmp7_;
					GArray* _tmp8_;
					GArray* _tmp9_;
					Node* _tmp10_;
					if (!_tmp3_) {
						gint _tmp4_;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = node_children (node);
					_tmp6_ = _tmp5_;
					_tmp7_ = !(((guint) i) < _tmp6_->len);
					_g_array_unref0 (_tmp6_);
					if (_tmp7_) {
						break;
					}
					_tmp8_ = node_children (node);
					_tmp9_ = _tmp8_;
					_tmp10_ = g_array_index (_tmp9_, Node*, (guint) i);
					node_group_get_tree_points (origin, _tmp10_, points);
					_g_array_unref0 (_tmp9_);
				}
			}
		}
	}
}

void
node_group_get_convex_hull (GArray* points,
                            GArray* hull)
{
	gint n = 0;
	gint l = 0;
	gint p = 0;
	g_return_if_fail (points != NULL);
	g_return_if_fail (hull != NULL);
	n = (gint) points->len;
	if (n == 0) {
		return;
	}
	l = 0;
	{
		gint i = 0;
		i = 1;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				if (!_tmp0_) {
					gint _tmp1_;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				if (!(i < n)) {
					break;
				}
				if ((*g_array_index (points, NodePoint*, (guint) i)).x < (*g_array_index (points, NodePoint*, (guint) l)).x) {
					l = i;
				}
			}
		}
	}
	p = l;
	{
		gboolean _tmp2_ = FALSE;
		_tmp2_ = TRUE;
		while (TRUE) {
			NodePoint* _tmp3_;
			gint q = 0;
			if (!_tmp2_) {
				if (!(p != l)) {
					break;
				}
			}
			_tmp2_ = FALSE;
			_tmp3_ = _node_point_dup0 (g_array_index (points, NodePoint*, (guint) p));
			g_array_append_val (hull, _tmp3_);
			q = (p + 1) % n;
			{
				gint i = 0;
				i = 0;
				{
					gboolean _tmp4_ = FALSE;
					_tmp4_ = TRUE;
					while (TRUE) {
						NodePoint _tmp6_;
						NodePoint _tmp7_;
						NodePoint _tmp8_;
						if (!_tmp4_) {
							gint _tmp5_;
							_tmp5_ = i;
							i = _tmp5_ + 1;
						}
						_tmp4_ = FALSE;
						if (!(i < n)) {
							break;
						}
						_tmp6_ = *g_array_index (points, NodePoint*, (guint) p);
						_tmp7_ = *g_array_index (points, NodePoint*, (guint) i);
						_tmp8_ = *g_array_index (points, NodePoint*, (guint) q);
						if (node_group_calc_orientation (&_tmp6_, &_tmp7_, &_tmp8_) == 2) {
							q = i;
						}
					}
				}
			}
			p = q;
		}
	}
}

gint
node_group_calc_orientation (NodePoint* p,
                             NodePoint* q,
                             NodePoint* r)
{
	gdouble val = 0.0;
	NodePoint _tmp0_;
	NodePoint _tmp1_;
	NodePoint _tmp2_;
	NodePoint _tmp3_;
	NodePoint _tmp4_;
	NodePoint _tmp5_;
	NodePoint _tmp6_;
	NodePoint _tmp7_;
	gint _tmp8_ = 0;
	gint result;
	g_return_val_if_fail (p != NULL, 0);
	g_return_val_if_fail (q != NULL, 0);
	g_return_val_if_fail (r != NULL, 0);
	_tmp0_ = *q;
	_tmp1_ = *p;
	_tmp2_ = *r;
	_tmp3_ = *q;
	_tmp4_ = *q;
	_tmp5_ = *p;
	_tmp6_ = *r;
	_tmp7_ = *q;
	val = ((_tmp0_.y - _tmp1_.y) * (_tmp2_.x - _tmp3_.x)) - ((_tmp4_.x - _tmp5_.x) * (_tmp6_.y - _tmp7_.y));
	if (val == ((gdouble) 0)) {
		result = 0;
		return result;
	}
	if (val > ((gdouble) 0)) {
		_tmp8_ = 1;
	} else {
		_tmp8_ = 2;
	}
	result = _tmp8_;
	return result;
}

GroupMode
node_group_get_mode (NodeGroup* self)
{
	GroupMode result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_mode;
	return result;
}

void
node_group_set_mode (NodeGroup* self,
                     GroupMode value)
{
	GroupMode old_value;
	g_return_if_fail (self != NULL);
	old_value = node_group_get_mode (self);
	if (old_value != value) {
		self->priv->_mode = value;
		g_object_notify_by_pspec ((GObject *) self, node_group_properties[NODE_GROUP_MODE_PROPERTY]);
	}
}

void
node_group_get_color (NodeGroup* self,
                      GdkRGBA * result)
{
	GdkRGBA _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_color;
	*result = _tmp0_;
	return;
}

static gboolean
_gdk_rgba_equal (const GdkRGBA * s1,
                 const GdkRGBA * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	if (s1->red != s2->red) {
		return FALSE;
	}
	if (s1->green != s2->green) {
		return FALSE;
	}
	if (s1->blue != s2->blue) {
		return FALSE;
	}
	if (s1->alpha != s2->alpha) {
		return FALSE;
	}
	return TRUE;
}

void
node_group_set_color (NodeGroup* self,
                      GdkRGBA * value)
{
	GdkRGBA old_value;
	g_return_if_fail (self != NULL);
	node_group_get_color (self, &old_value);
	if (_gdk_rgba_equal (value, &old_value) != TRUE) {
		GdkRGBA _tmp0_;
		_tmp0_ = *value;
		self->priv->_color = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, node_group_properties[NODE_GROUP_COLOR_PROPERTY]);
	}
}

const gchar*
node_group_get_note (NodeGroup* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_note;
	result = _tmp0_;
	return result;
}

void
node_group_set_note (NodeGroup* self,
                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = node_group_get_note (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_note);
		self->priv->_note = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, node_group_properties[NODE_GROUP_NOTE_PROPERTY]);
	}
}

GArray*
node_group_get_nodes (NodeGroup* self)
{
	GArray* result;
	GArray* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_nodes;
	result = _tmp0_;
	return result;
}

static void
node_group_class_init (NodeGroupClass * klass,
                       gpointer klass_data)
{
	node_group_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &NodeGroup_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_node_group_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_node_group_set_property;
	G_OBJECT_CLASS (klass)->finalize = node_group_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), NODE_GROUP_MODE_PROPERTY, node_group_properties[NODE_GROUP_MODE_PROPERTY] = g_param_spec_enum ("mode", "mode", "mode", TYPE_GROUP_MODE, GROUP_MODE_NONE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NODE_GROUP_COLOR_PROPERTY, node_group_properties[NODE_GROUP_COLOR_PROPERTY] = g_param_spec_boxed ("color", "color", "color", gdk_rgba_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NODE_GROUP_NOTE_PROPERTY, node_group_properties[NODE_GROUP_NOTE_PROPERTY] = g_param_spec_string ("note", "note", "note", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), NODE_GROUP_NODES_PROPERTY, node_group_properties[NODE_GROUP_NODES_PROPERTY] = g_param_spec_boxed ("nodes", "nodes", "nodes", G_TYPE_ARRAY, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
node_group_instance_init (NodeGroup * self,
                          gpointer klass)
{
	gchar* _tmp0_;
	self->priv = node_group_get_instance_private (self);
	self->priv->_mode = GROUP_MODE_NONE;
	_tmp0_ = g_strdup ("");
	self->priv->_note = _tmp0_;
}

static void
node_group_finalize (GObject * obj)
{
	NodeGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_NODE_GROUP, NodeGroup);
	_g_array_unref0 (self->priv->_nodes);
	_g_free0 (self->priv->_note);
	G_OBJECT_CLASS (node_group_parent_class)->finalize (obj);
}

static GType
node_group_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (NodeGroupClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) node_group_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (NodeGroup), 0, (GInstanceInitFunc) node_group_instance_init, NULL };
	GType node_group_type_id;
	node_group_type_id = g_type_register_static (G_TYPE_OBJECT, "NodeGroup", &g_define_type_info, 0);
	NodeGroup_private_offset = g_type_add_instance_private (node_group_type_id, sizeof (NodeGroupPrivate));
	return node_group_type_id;
}

GType
node_group_get_type (void)
{
	static volatile gsize node_group_type_id__once = 0;
	if (g_once_init_enter (&node_group_type_id__once)) {
		GType node_group_type_id;
		node_group_type_id = node_group_get_type_once ();
		g_once_init_leave (&node_group_type_id__once, node_group_type_id);
	}
	return node_group_type_id__once;
}

static void
_vala_node_group_get_property (GObject * object,
                               guint property_id,
                               GValue * value,
                               GParamSpec * pspec)
{
	NodeGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NODE_GROUP, NodeGroup);
	switch (property_id) {
		case NODE_GROUP_MODE_PROPERTY:
		g_value_set_enum (value, node_group_get_mode (self));
		break;
		case NODE_GROUP_COLOR_PROPERTY:
		{
			GdkRGBA boxed;
			node_group_get_color (self, &boxed);
			g_value_set_boxed (value, &boxed);
		}
		break;
		case NODE_GROUP_NOTE_PROPERTY:
		g_value_set_string (value, node_group_get_note (self));
		break;
		case NODE_GROUP_NODES_PROPERTY:
		g_value_set_boxed (value, node_group_get_nodes (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_node_group_set_property (GObject * object,
                               guint property_id,
                               const GValue * value,
                               GParamSpec * pspec)
{
	NodeGroup * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_NODE_GROUP, NodeGroup);
	switch (property_id) {
		case NODE_GROUP_MODE_PROPERTY:
		node_group_set_mode (self, g_value_get_enum (value));
		break;
		case NODE_GROUP_COLOR_PROPERTY:
		node_group_set_color (self, g_value_get_boxed (value));
		break;
		case NODE_GROUP_NOTE_PROPERTY:
		node_group_set_note (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

