/* A Bison parser, made by GNU Bison 3.8.2.  */

/* Bison implementation for Yacc-like parsers in C

   Copyright (C) 1984, 1989-1990, 2000-2015, 2018-2021 Free Software Foundation,
   Inc.

   This program is free software: you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation, either version 3 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program.  If not, see <https://www.gnu.org/licenses/>.  */

/* As a special exception, you may create a larger work that contains
   part or all of the Bison parser skeleton and distribute that work
   under terms of your choice, so long as that work isn't itself a
   parser generator using the skeleton or a modified version thereof
   as a parser skeleton.  Alternatively, if you modify or redistribute
   the parser skeleton itself, you may (at your option) remove this
   special exception, which will cause the skeleton and the resulting
   Bison output files to be licensed under the GNU General Public
   License without this special exception.

   This special exception was added by the Free Software Foundation in
   version 2.2 of Bison.  */

/* C LALR(1) parser skeleton written by Richard Stallman, by
   simplifying the original so-called "semantic" parser.  */

/* DO NOT RELY ON FEATURES THAT ARE NOT DOCUMENTED in the manual,
   especially those whose name start with YY_ or yy_.  They are
   private implementation details that can be changed or removed.  */

/* All symbols defined below should begin with yy or YY, to avoid
   infringing on user name space.  This should be done even for local
   variables, as they might otherwise be expanded by user macros.
   There are some unavoidable exceptions within include files to
   define necessary library symbols; they are noted "INFRINGES ON
   USER NAME SPACE" below.  */

/* Identify Bison output, and Bison version.  */
#define YYBISON 30802

/* Bison version string.  */
#define YYBISON_VERSION "3.8.2"

/* Skeleton name.  */
#define YYSKELETON_NAME "yacc.c"

/* Pure parsers.  */
#define YYPURE 0

/* Push parsers.  */
#define YYPUSH 0

/* Pull parsers.  */
#define YYPULL 1




/* First part of user prologue.  */
#line 11 "bpf_parser.y"


#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <signal.h>
#include <stdint.h>
#include <errno.h>
#include <libgen.h>
#include <linux/filter.h>

#include "bpf.h"
#include "str.h"
#include "xmalloc.h"
#include "bpf_parser.tab.h"
#include "built_in.h"
#include "die.h"
#include "cpp.h"

static int curr_instr = 0;

static struct sock_filter out[BPF_MAXINSNS];

static char *labels[BPF_MAXINSNS];
static char *labels_jt[BPF_MAXINSNS];
static char *labels_jf[BPF_MAXINSNS];
static char *labels_k[BPF_MAXINSNS];

#define YYERROR_VERBOSE		0
#define YYDEBUG			0
#define YYLTYPE_IS_TRIVIAL	1

extern FILE *yyin;
extern int yylex(void);
extern void yyerror(const char *);
extern int yylineno;
extern char *yytext;

static inline void check_max_instr(void)
{
	if (curr_instr >= BPF_MAXINSNS)
		panic("Exceeded maximal number of instructions!\n");
}

static inline void set_curr_instr(uint16_t code, uint8_t jt, uint8_t jf, uint32_t k)
{
	check_max_instr();

	out[curr_instr].code = code;
	out[curr_instr].jt = jt;
	out[curr_instr].jf = jf;
	out[curr_instr].k = k;

	curr_instr++;
}

static inline void set_curr_label(char *label)
{
	check_max_instr();

	labels[curr_instr] = label;
}

#define JTL		1
#define JFL		2
#define JKL		3

static inline void set_jmp_label(char *label, int which)
{
	check_max_instr();

	switch (which) {
	case JTL:
		labels_jt[curr_instr] = label;
		break;
	case JFL:
		labels_jf[curr_instr] = label;
		break;
	case JKL:
		labels_k[curr_instr] = label;
		break;
	default:
		bug();
	}
}

static int find_intr_offset_or_panic(char *label_to_search)
{
	int i, max = curr_instr, ret = -ENOENT;

	bug_on(!label_to_search);

	for (i = 0; i < max; ++i) {
		if (labels[i] != NULL) {
			/* Both are \0-terminated! */
			if (!strcmp(label_to_search, labels[i])) {
				ret = i;
				break;
			}
		}
	}

	if (ret == -ENOENT)
		panic("No such label!\n");

	return ret;
}


#line 181 "bpfc/bpf_parser.tab.c"

# ifndef YY_CAST
#  ifdef __cplusplus
#   define YY_CAST(Type, Val) static_cast<Type> (Val)
#   define YY_REINTERPRET_CAST(Type, Val) reinterpret_cast<Type> (Val)
#  else
#   define YY_CAST(Type, Val) ((Type) (Val))
#   define YY_REINTERPRET_CAST(Type, Val) ((Type) (Val))
#  endif
# endif
# ifndef YY_NULLPTR
#  if defined __cplusplus
#   if 201103L <= __cplusplus
#    define YY_NULLPTR nullptr
#   else
#    define YY_NULLPTR 0
#   endif
#  else
#   define YY_NULLPTR ((void*)0)
#  endif
# endif

#include "bpf_parser.tab.h"
/* Symbol kind.  */
enum yysymbol_kind_t
{
  YYSYMBOL_YYEMPTY = -2,
  YYSYMBOL_YYEOF = 0,                      /* "end of file"  */
  YYSYMBOL_YYerror = 1,                    /* error  */
  YYSYMBOL_YYUNDEF = 2,                    /* "invalid token"  */
  YYSYMBOL_OP_LDB = 3,                     /* OP_LDB  */
  YYSYMBOL_OP_LDH = 4,                     /* OP_LDH  */
  YYSYMBOL_OP_LD = 5,                      /* OP_LD  */
  YYSYMBOL_OP_LDX = 6,                     /* OP_LDX  */
  YYSYMBOL_OP_ST = 7,                      /* OP_ST  */
  YYSYMBOL_OP_STX = 8,                     /* OP_STX  */
  YYSYMBOL_OP_JMP = 9,                     /* OP_JMP  */
  YYSYMBOL_OP_JEQ = 10,                    /* OP_JEQ  */
  YYSYMBOL_OP_JGT = 11,                    /* OP_JGT  */
  YYSYMBOL_OP_JGE = 12,                    /* OP_JGE  */
  YYSYMBOL_OP_JSET = 13,                   /* OP_JSET  */
  YYSYMBOL_OP_ADD = 14,                    /* OP_ADD  */
  YYSYMBOL_OP_SUB = 15,                    /* OP_SUB  */
  YYSYMBOL_OP_MUL = 16,                    /* OP_MUL  */
  YYSYMBOL_OP_DIV = 17,                    /* OP_DIV  */
  YYSYMBOL_OP_AND = 18,                    /* OP_AND  */
  YYSYMBOL_OP_OR = 19,                     /* OP_OR  */
  YYSYMBOL_OP_XOR = 20,                    /* OP_XOR  */
  YYSYMBOL_OP_LSH = 21,                    /* OP_LSH  */
  YYSYMBOL_OP_RSH = 22,                    /* OP_RSH  */
  YYSYMBOL_OP_RET = 23,                    /* OP_RET  */
  YYSYMBOL_OP_TAX = 24,                    /* OP_TAX  */
  YYSYMBOL_OP_TXA = 25,                    /* OP_TXA  */
  YYSYMBOL_OP_LDXB = 26,                   /* OP_LDXB  */
  YYSYMBOL_OP_MOD = 27,                    /* OP_MOD  */
  YYSYMBOL_OP_NEG = 28,                    /* OP_NEG  */
  YYSYMBOL_OP_JNEQ = 29,                   /* OP_JNEQ  */
  YYSYMBOL_OP_JLT = 30,                    /* OP_JLT  */
  YYSYMBOL_OP_JLE = 31,                    /* OP_JLE  */
  YYSYMBOL_OP_LDI = 32,                    /* OP_LDI  */
  YYSYMBOL_OP_LDXI = 33,                   /* OP_LDXI  */
  YYSYMBOL_K_PKT_LEN = 34,                 /* K_PKT_LEN  */
  YYSYMBOL_K_PROTO = 35,                   /* K_PROTO  */
  YYSYMBOL_K_TYPE = 36,                    /* K_TYPE  */
  YYSYMBOL_K_NLATTR = 37,                  /* K_NLATTR  */
  YYSYMBOL_K_NLATTR_NEST = 38,             /* K_NLATTR_NEST  */
  YYSYMBOL_K_MARK = 39,                    /* K_MARK  */
  YYSYMBOL_K_QUEUE = 40,                   /* K_QUEUE  */
  YYSYMBOL_K_HATYPE = 41,                  /* K_HATYPE  */
  YYSYMBOL_K_RXHASH = 42,                  /* K_RXHASH  */
  YYSYMBOL_K_CPU = 43,                     /* K_CPU  */
  YYSYMBOL_K_IFIDX = 44,                   /* K_IFIDX  */
  YYSYMBOL_K_VLANT = 45,                   /* K_VLANT  */
  YYSYMBOL_K_VLANP = 46,                   /* K_VLANP  */
  YYSYMBOL_K_POFF = 47,                    /* K_POFF  */
  YYSYMBOL_48_ = 48,                       /* ':'  */
  YYSYMBOL_49_ = 49,                       /* ','  */
  YYSYMBOL_50_ = 50,                       /* '['  */
  YYSYMBOL_51_ = 51,                       /* ']'  */
  YYSYMBOL_52_ = 52,                       /* '('  */
  YYSYMBOL_53_ = 53,                       /* ')'  */
  YYSYMBOL_54_x_ = 54,                     /* 'x'  */
  YYSYMBOL_55_a_ = 55,                     /* 'a'  */
  YYSYMBOL_56_ = 56,                       /* '+'  */
  YYSYMBOL_57_M_ = 57,                     /* 'M'  */
  YYSYMBOL_58_ = 58,                       /* '*'  */
  YYSYMBOL_59_ = 59,                       /* '&'  */
  YYSYMBOL_60_ = 60,                       /* '#'  */
  YYSYMBOL_61_ = 61,                       /* '%'  */
  YYSYMBOL_number = 62,                    /* number  */
  YYSYMBOL_label = 63,                     /* label  */
  YYSYMBOL_YYACCEPT = 64,                  /* $accept  */
  YYSYMBOL_prog = 65,                      /* prog  */
  YYSYMBOL_line = 66,                      /* line  */
  YYSYMBOL_labelled_instr = 67,            /* labelled_instr  */
  YYSYMBOL_instr = 68,                     /* instr  */
  YYSYMBOL_labelled = 69,                  /* labelled  */
  YYSYMBOL_ldb = 70,                       /* ldb  */
  YYSYMBOL_ldh = 71,                       /* ldh  */
  YYSYMBOL_ldi = 72,                       /* ldi  */
  YYSYMBOL_ld = 73,                        /* ld  */
  YYSYMBOL_ldxi = 74,                      /* ldxi  */
  YYSYMBOL_ldx = 75,                       /* ldx  */
  YYSYMBOL_st = 76,                        /* st  */
  YYSYMBOL_stx = 77,                       /* stx  */
  YYSYMBOL_jmp = 78,                       /* jmp  */
  YYSYMBOL_jeq = 79,                       /* jeq  */
  YYSYMBOL_jneq = 80,                      /* jneq  */
  YYSYMBOL_jlt = 81,                       /* jlt  */
  YYSYMBOL_jle = 82,                       /* jle  */
  YYSYMBOL_jgt = 83,                       /* jgt  */
  YYSYMBOL_jge = 84,                       /* jge  */
  YYSYMBOL_jset = 85,                      /* jset  */
  YYSYMBOL_add = 86,                       /* add  */
  YYSYMBOL_sub = 87,                       /* sub  */
  YYSYMBOL_mul = 88,                       /* mul  */
  YYSYMBOL_div = 89,                       /* div  */
  YYSYMBOL_mod = 90,                       /* mod  */
  YYSYMBOL_neg = 91,                       /* neg  */
  YYSYMBOL_and = 92,                       /* and  */
  YYSYMBOL_or = 93,                        /* or  */
  YYSYMBOL_xor = 94,                       /* xor  */
  YYSYMBOL_lsh = 95,                       /* lsh  */
  YYSYMBOL_rsh = 96,                       /* rsh  */
  YYSYMBOL_ret = 97,                       /* ret  */
  YYSYMBOL_tax = 98,                       /* tax  */
  YYSYMBOL_txa = 99                        /* txa  */
};
typedef enum yysymbol_kind_t yysymbol_kind_t;




#ifdef short
# undef short
#endif

/* On compilers that do not define __PTRDIFF_MAX__ etc., make sure
   <limits.h> and (if available) <stdint.h> are included
   so that the code can choose integer types of a good width.  */

#ifndef __PTRDIFF_MAX__
# include <limits.h> /* INFRINGES ON USER NAME SPACE */
# if defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stdint.h> /* INFRINGES ON USER NAME SPACE */
#  define YY_STDINT_H
# endif
#endif

/* Narrow types that promote to a signed type and that can represent a
   signed or unsigned integer of at least N bits.  In tables they can
   save space and decrease cache pressure.  Promoting to a signed type
   helps avoid bugs in integer arithmetic.  */

#ifdef __INT_LEAST8_MAX__
typedef __INT_LEAST8_TYPE__ yytype_int8;
#elif defined YY_STDINT_H
typedef int_least8_t yytype_int8;
#else
typedef signed char yytype_int8;
#endif

#ifdef __INT_LEAST16_MAX__
typedef __INT_LEAST16_TYPE__ yytype_int16;
#elif defined YY_STDINT_H
typedef int_least16_t yytype_int16;
#else
typedef short yytype_int16;
#endif

/* Work around bug in HP-UX 11.23, which defines these macros
   incorrectly for preprocessor constants.  This workaround can likely
   be removed in 2023, as HPE has promised support for HP-UX 11.23
   (aka HP-UX 11i v2) only through the end of 2022; see Table 2 of
   <https://h20195.www2.hpe.com/V2/getpdf.aspx/4AA4-7673ENW.pdf>.  */
#ifdef __hpux
# undef UINT_LEAST8_MAX
# undef UINT_LEAST16_MAX
# define UINT_LEAST8_MAX 255
# define UINT_LEAST16_MAX 65535
#endif

#if defined __UINT_LEAST8_MAX__ && __UINT_LEAST8_MAX__ <= __INT_MAX__
typedef __UINT_LEAST8_TYPE__ yytype_uint8;
#elif (!defined __UINT_LEAST8_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST8_MAX <= INT_MAX)
typedef uint_least8_t yytype_uint8;
#elif !defined __UINT_LEAST8_MAX__ && UCHAR_MAX <= INT_MAX
typedef unsigned char yytype_uint8;
#else
typedef short yytype_uint8;
#endif

#if defined __UINT_LEAST16_MAX__ && __UINT_LEAST16_MAX__ <= __INT_MAX__
typedef __UINT_LEAST16_TYPE__ yytype_uint16;
#elif (!defined __UINT_LEAST16_MAX__ && defined YY_STDINT_H \
       && UINT_LEAST16_MAX <= INT_MAX)
typedef uint_least16_t yytype_uint16;
#elif !defined __UINT_LEAST16_MAX__ && USHRT_MAX <= INT_MAX
typedef unsigned short yytype_uint16;
#else
typedef int yytype_uint16;
#endif

#ifndef YYPTRDIFF_T
# if defined __PTRDIFF_TYPE__ && defined __PTRDIFF_MAX__
#  define YYPTRDIFF_T __PTRDIFF_TYPE__
#  define YYPTRDIFF_MAXIMUM __PTRDIFF_MAX__
# elif defined PTRDIFF_MAX
#  ifndef ptrdiff_t
#   include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  endif
#  define YYPTRDIFF_T ptrdiff_t
#  define YYPTRDIFF_MAXIMUM PTRDIFF_MAX
# else
#  define YYPTRDIFF_T long
#  define YYPTRDIFF_MAXIMUM LONG_MAX
# endif
#endif

#ifndef YYSIZE_T
# ifdef __SIZE_TYPE__
#  define YYSIZE_T __SIZE_TYPE__
# elif defined size_t
#  define YYSIZE_T size_t
# elif defined __STDC_VERSION__ && 199901 <= __STDC_VERSION__
#  include <stddef.h> /* INFRINGES ON USER NAME SPACE */
#  define YYSIZE_T size_t
# else
#  define YYSIZE_T unsigned
# endif
#endif

#define YYSIZE_MAXIMUM                                  \
  YY_CAST (YYPTRDIFF_T,                                 \
           (YYPTRDIFF_MAXIMUM < YY_CAST (YYSIZE_T, -1)  \
            ? YYPTRDIFF_MAXIMUM                         \
            : YY_CAST (YYSIZE_T, -1)))

#define YYSIZEOF(X) YY_CAST (YYPTRDIFF_T, sizeof (X))


/* Stored state numbers (used for stacks). */
typedef yytype_int16 yy_state_t;

/* State numbers in computations.  */
typedef int yy_state_fast_t;

#ifndef YY_
# if defined YYENABLE_NLS && YYENABLE_NLS
#  if ENABLE_NLS
#   include <libintl.h> /* INFRINGES ON USER NAME SPACE */
#   define YY_(Msgid) dgettext ("bison-runtime", Msgid)
#  endif
# endif
# ifndef YY_
#  define YY_(Msgid) Msgid
# endif
#endif


#ifndef YY_ATTRIBUTE_PURE
# if defined __GNUC__ && 2 < __GNUC__ + (96 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_PURE __attribute__ ((__pure__))
# else
#  define YY_ATTRIBUTE_PURE
# endif
#endif

#ifndef YY_ATTRIBUTE_UNUSED
# if defined __GNUC__ && 2 < __GNUC__ + (7 <= __GNUC_MINOR__)
#  define YY_ATTRIBUTE_UNUSED __attribute__ ((__unused__))
# else
#  define YY_ATTRIBUTE_UNUSED
# endif
#endif

/* Suppress unused-variable warnings by "using" E.  */
#if ! defined lint || defined __GNUC__
# define YY_USE(E) ((void) (E))
#else
# define YY_USE(E) /* empty */
#endif

/* Suppress an incorrect diagnostic about yylval being uninitialized.  */
#if defined __GNUC__ && ! defined __ICC && 406 <= __GNUC__ * 100 + __GNUC_MINOR__
# if __GNUC__ * 100 + __GNUC_MINOR__ < 407
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")
# else
#  define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN                           \
    _Pragma ("GCC diagnostic push")                                     \
    _Pragma ("GCC diagnostic ignored \"-Wuninitialized\"")              \
    _Pragma ("GCC diagnostic ignored \"-Wmaybe-uninitialized\"")
# endif
# define YY_IGNORE_MAYBE_UNINITIALIZED_END      \
    _Pragma ("GCC diagnostic pop")
#else
# define YY_INITIAL_VALUE(Value) Value
#endif
#ifndef YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
# define YY_IGNORE_MAYBE_UNINITIALIZED_END
#endif
#ifndef YY_INITIAL_VALUE
# define YY_INITIAL_VALUE(Value) /* Nothing. */
#endif

#if defined __cplusplus && defined __GNUC__ && ! defined __ICC && 6 <= __GNUC__
# define YY_IGNORE_USELESS_CAST_BEGIN                          \
    _Pragma ("GCC diagnostic push")                            \
    _Pragma ("GCC diagnostic ignored \"-Wuseless-cast\"")
# define YY_IGNORE_USELESS_CAST_END            \
    _Pragma ("GCC diagnostic pop")
#endif
#ifndef YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_BEGIN
# define YY_IGNORE_USELESS_CAST_END
#endif


#define YY_ASSERT(E) ((void) (0 && (E)))

#if !defined yyoverflow

/* The parser invokes alloca or malloc; define the necessary symbols.  */

# ifdef YYSTACK_USE_ALLOCA
#  if YYSTACK_USE_ALLOCA
#   ifdef __GNUC__
#    define YYSTACK_ALLOC __builtin_alloca
#   elif defined __BUILTIN_VA_ARG_INCR
#    include <alloca.h> /* INFRINGES ON USER NAME SPACE */
#   elif defined _AIX
#    define YYSTACK_ALLOC __alloca
#   elif defined _MSC_VER
#    include <malloc.h> /* INFRINGES ON USER NAME SPACE */
#    define alloca _alloca
#   else
#    define YYSTACK_ALLOC alloca
#    if ! defined _ALLOCA_H && ! defined EXIT_SUCCESS
#     include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
      /* Use EXIT_SUCCESS as a witness for stdlib.h.  */
#     ifndef EXIT_SUCCESS
#      define EXIT_SUCCESS 0
#     endif
#    endif
#   endif
#  endif
# endif

# ifdef YYSTACK_ALLOC
   /* Pacify GCC's 'empty if-body' warning.  */
#  define YYSTACK_FREE(Ptr) do { /* empty */; } while (0)
#  ifndef YYSTACK_ALLOC_MAXIMUM
    /* The OS might guarantee only one guard page at the bottom of the stack,
       and a page size can be as small as 4096 bytes.  So we cannot safely
       invoke alloca (N) if N exceeds 4096.  Use a slightly smaller number
       to allow for a few compiler-allocated temporary stack slots.  */
#   define YYSTACK_ALLOC_MAXIMUM 4032 /* reasonable circa 2006 */
#  endif
# else
#  define YYSTACK_ALLOC YYMALLOC
#  define YYSTACK_FREE YYFREE
#  ifndef YYSTACK_ALLOC_MAXIMUM
#   define YYSTACK_ALLOC_MAXIMUM YYSIZE_MAXIMUM
#  endif
#  if (defined __cplusplus && ! defined EXIT_SUCCESS \
       && ! ((defined YYMALLOC || defined malloc) \
             && (defined YYFREE || defined free)))
#   include <stdlib.h> /* INFRINGES ON USER NAME SPACE */
#   ifndef EXIT_SUCCESS
#    define EXIT_SUCCESS 0
#   endif
#  endif
#  ifndef YYMALLOC
#   define YYMALLOC malloc
#   if ! defined malloc && ! defined EXIT_SUCCESS
void *malloc (YYSIZE_T); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
#  ifndef YYFREE
#   define YYFREE free
#   if ! defined free && ! defined EXIT_SUCCESS
void free (void *); /* INFRINGES ON USER NAME SPACE */
#   endif
#  endif
# endif
#endif /* !defined yyoverflow */

#if (! defined yyoverflow \
     && (! defined __cplusplus \
         || (defined YYSTYPE_IS_TRIVIAL && YYSTYPE_IS_TRIVIAL)))

/* A type that is properly aligned for any stack member.  */
union yyalloc
{
  yy_state_t yyss_alloc;
  YYSTYPE yyvs_alloc;
};

/* The size of the maximum gap between one aligned stack and the next.  */
# define YYSTACK_GAP_MAXIMUM (YYSIZEOF (union yyalloc) - 1)

/* The size of an array large to enough to hold all stacks, each with
   N elements.  */
# define YYSTACK_BYTES(N) \
     ((N) * (YYSIZEOF (yy_state_t) + YYSIZEOF (YYSTYPE)) \
      + YYSTACK_GAP_MAXIMUM)

# define YYCOPY_NEEDED 1

/* Relocate STACK from its old location to the new one.  The
   local variables YYSIZE and YYSTACKSIZE give the old and new number of
   elements in the stack, and YYPTR gives the new location of the
   stack.  Advance YYPTR to a properly aligned location for the next
   stack.  */
# define YYSTACK_RELOCATE(Stack_alloc, Stack)                           \
    do                                                                  \
      {                                                                 \
        YYPTRDIFF_T yynewbytes;                                         \
        YYCOPY (&yyptr->Stack_alloc, Stack, yysize);                    \
        Stack = &yyptr->Stack_alloc;                                    \
        yynewbytes = yystacksize * YYSIZEOF (*Stack) + YYSTACK_GAP_MAXIMUM; \
        yyptr += yynewbytes / YYSIZEOF (*yyptr);                        \
      }                                                                 \
    while (0)

#endif

#if defined YYCOPY_NEEDED && YYCOPY_NEEDED
/* Copy COUNT objects from SRC to DST.  The source and destination do
   not overlap.  */
# ifndef YYCOPY
#  if defined __GNUC__ && 1 < __GNUC__
#   define YYCOPY(Dst, Src, Count) \
      __builtin_memcpy (Dst, Src, YY_CAST (YYSIZE_T, (Count)) * sizeof (*(Src)))
#  else
#   define YYCOPY(Dst, Src, Count)              \
      do                                        \
        {                                       \
          YYPTRDIFF_T yyi;                      \
          for (yyi = 0; yyi < (Count); yyi++)   \
            (Dst)[yyi] = (Src)[yyi];            \
        }                                       \
      while (0)
#  endif
# endif
#endif /* !YYCOPY_NEEDED */

/* YYFINAL -- State number of the termination state.  */
#define YYFINAL  181
/* YYLAST -- Last index in YYTABLE.  */
#define YYLAST   388

/* YYNTOKENS -- Number of terminals.  */
#define YYNTOKENS  64
/* YYNNTS -- Number of nonterminals.  */
#define YYNNTS  36
/* YYNRULES -- Number of rules.  */
#define YYNRULES  171
/* YYNSTATES -- Number of states.  */
#define YYNSTATES  352

/* YYMAXUTOK -- Last valid token kind.  */
#define YYMAXUTOK   304


/* YYTRANSLATE(TOKEN-NUM) -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex, with out-of-bounds checking.  */
#define YYTRANSLATE(YYX)                                \
  (0 <= (YYX) && (YYX) <= YYMAXUTOK                     \
   ? YY_CAST (yysymbol_kind_t, yytranslate[YYX])        \
   : YYSYMBOL_YYUNDEF)

/* YYTRANSLATE[TOKEN-NUM] -- Symbol number corresponding to TOKEN-NUM
   as returned by yylex.  */
static const yytype_int8 yytranslate[] =
{
       0,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,    60,     2,    61,    59,     2,
      52,    53,    58,    56,    49,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,    48,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,    57,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,    50,     2,    51,     2,     2,     2,    55,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
      54,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     1,     2,     3,     4,
       5,     6,     7,     8,     9,    10,    11,    12,    13,    14,
      15,    16,    17,    18,    19,    20,    21,    22,    23,    24,
      25,    26,    27,    28,    29,    30,    31,    32,    33,    34,
      35,    36,    37,    38,    39,    40,    41,    42,    43,    44,
      45,    46,    47,    62,    63
};

#if YYDEBUG
/* YYRLINE[YYN] -- Source line where rule number YYN was defined.  */
static const yytype_int16 yyrline[] =
{
       0,   144,   144,   145,   149,   150,   154,   158,   159,   160,
     161,   162,   163,   164,   165,   166,   167,   168,   169,   170,
     171,   172,   173,   174,   175,   176,   177,   178,   179,   180,
     181,   182,   183,   184,   185,   186,   187,   191,   195,   197,
     199,   201,   204,   207,   210,   213,   216,   219,   222,   225,
     228,   231,   234,   237,   243,   245,   247,   249,   252,   255,
     258,   261,   264,   267,   270,   273,   276,   279,   282,   285,
     291,   293,   298,   300,   302,   305,   308,   311,   314,   317,
     320,   323,   326,   329,   332,   335,   338,   341,   343,   345,
     347,   352,   354,   359,   361,   363,   365,   370,   378,   383,
     388,   394,   398,   402,   406,   409,   412,   418,   421,   424,
     430,   433,   436,   442,   445,   448,   454,   458,   462,   466,
     469,   472,   478,   482,   486,   490,   493,   496,   502,   506,
     510,   514,   517,   520,   526,   528,   530,   535,   537,   539,
     544,   546,   548,   553,   555,   557,   562,   564,   566,   571,
     576,   578,   580,   585,   587,   589,   594,   596,   598,   603,
     605,   607,   612,   614,   616,   621,   623,   625,   627,   629,
     634,   639
};
#endif

/** Accessing symbol of state STATE.  */
#define YY_ACCESSING_SYMBOL(State) YY_CAST (yysymbol_kind_t, yystos[State])

#if YYDEBUG || 0
/* The user-facing name of the symbol whose (internal) number is
   YYSYMBOL.  No bounds checking.  */
static const char *yysymbol_name (yysymbol_kind_t yysymbol) YY_ATTRIBUTE_UNUSED;

/* YYTNAME[SYMBOL-NUM] -- String name of the symbol SYMBOL-NUM.
   First, the terminals, then, starting at YYNTOKENS, nonterminals.  */
static const char *const yytname[] =
{
  "\"end of file\"", "error", "\"invalid token\"", "OP_LDB", "OP_LDH",
  "OP_LD", "OP_LDX", "OP_ST", "OP_STX", "OP_JMP", "OP_JEQ", "OP_JGT",
  "OP_JGE", "OP_JSET", "OP_ADD", "OP_SUB", "OP_MUL", "OP_DIV", "OP_AND",
  "OP_OR", "OP_XOR", "OP_LSH", "OP_RSH", "OP_RET", "OP_TAX", "OP_TXA",
  "OP_LDXB", "OP_MOD", "OP_NEG", "OP_JNEQ", "OP_JLT", "OP_JLE", "OP_LDI",
  "OP_LDXI", "K_PKT_LEN", "K_PROTO", "K_TYPE", "K_NLATTR", "K_NLATTR_NEST",
  "K_MARK", "K_QUEUE", "K_HATYPE", "K_RXHASH", "K_CPU", "K_IFIDX",
  "K_VLANT", "K_VLANP", "K_POFF", "':'", "','", "'['", "']'", "'('", "')'",
  "'x'", "'a'", "'+'", "'M'", "'*'", "'&'", "'#'", "'%'", "number",
  "label", "$accept", "prog", "line", "labelled_instr", "instr",
  "labelled", "ldb", "ldh", "ldi", "ld", "ldxi", "ldx", "st", "stx", "jmp",
  "jeq", "jneq", "jlt", "jle", "jgt", "jge", "jset", "add", "sub", "mul",
  "div", "mod", "neg", "and", "or", "xor", "lsh", "rsh", "ret", "tax",
  "txa", YY_NULLPTR
};

static const char *
yysymbol_name (yysymbol_kind_t yysymbol)
{
  return yytname[yysymbol];
}
#endif

#define YYPACT_NINF (-54)

#define yypact_value_is_default(Yyn) \
  ((Yyn) == YYPACT_NINF)

#define YYTABLE_NINF (-1)

#define yytable_value_is_error(Yyn) \
  0

/* YYPACT[STATE-NUM] -- Index in YYTABLE of the portion describing
   STATE-NUM.  */
static const yytype_int16 yypact[] =
{
      61,    60,   124,     1,   123,   -23,    -3,   -13,    59,   118,
     121,   130,   132,   134,   142,   144,   146,   154,   156,   158,
     166,    57,   -54,   -54,    47,   168,   -54,   170,   178,   180,
      -7,    96,    14,     0,   -54,   -54,   -54,   122,   -54,   -54,
     -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,
     -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,
     -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,
     -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,
     -54,    -5,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,
     -54,   -54,   -54,   -54,   -54,    -2,   -54,   -54,   -54,   -54,
     -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,
      54,    64,   111,   -54,    71,   114,    65,    72,   127,   -54,
     138,   135,   145,   140,   139,   155,   162,   151,   167,   174,
     163,   179,   -54,   173,   182,   -54,   175,   188,   -54,   181,
     190,   -54,   183,   192,   -54,   185,   194,   -54,   187,   196,
     -54,   189,   198,   -54,   191,   200,   -54,   193,   202,   -54,
     -54,   195,   -53,   201,   -54,   199,   204,   211,   203,   208,
     214,   205,   210,   217,   206,   215,   209,   -54,   212,   -54,
     -54,   -54,   -54,   -54,   216,   219,   224,   220,   223,   227,
     225,   226,   228,   221,   -54,   222,   -54,   218,   229,   230,
     231,   233,   236,   232,   237,   238,   234,   239,   240,   235,
     241,   244,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,
     -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,
     -54,   -54,   -54,   247,   -54,   -54,   242,   251,   252,   243,
     253,   254,   245,   255,   258,   -54,   -54,   248,   256,   -54,
     249,   257,   -54,   259,   260,   -54,   263,   264,   246,   266,
     267,   270,   261,   262,   271,   265,   268,   273,   269,   272,
     274,   275,   276,   277,   -54,   278,   279,   -54,   280,   281,
     -54,   282,   283,   285,   286,   289,   287,   296,   288,   -54,
     -54,   290,   -54,   -54,   291,   284,   302,   292,   304,   307,
     294,   309,   310,   297,   312,   313,   301,   -54,   -54,   -54,
     -54,   -54,   -54,   -54,   314,   -54,   315,   -54,   316,   317,
     -54,   306,   308,   -54,   311,   318,   -54,   319,   320,   -54,
     321,   322,   324,   -54,   -54,   -54,   250,   -54,   -54,   -54,
     -54,   -54,   -54,   -54,   -54,   305,   325,   326,   323,   327,
     -54,   -54
};

/* YYDEFACT[STATE-NUM] -- Default reduction number in state STATE-NUM.
   Performed when YYTABLE does not specify something else to do.  Zero
   means the default is an error.  */
static const yytype_uint8 yydefact[] =
{
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   170,   171,     0,     0,   149,     0,     0,     0,
       0,     0,     0,     0,     2,     5,     4,     0,     7,     8,
      10,     9,    12,    11,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    34,    35,    36,    41,    42,
      44,    45,    46,    47,    48,    49,    50,    43,    51,    52,
      53,     0,    57,    58,    60,    61,    62,    63,    64,    65,
      66,    59,    67,    68,    69,     0,    73,    74,    75,    77,
      78,    79,    80,    81,    82,    83,    76,    84,    85,    86,
       0,     0,     0,    94,     0,     0,     0,     0,     0,   100,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   135,     0,     0,   138,     0,     0,   141,     0,
       0,   144,     0,     0,   151,     0,     0,   154,     0,     0,
     157,     0,     0,   160,     0,     0,   163,     0,     0,   167,
     165,     0,     0,     0,   147,     0,     0,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,    71,     0,    92,
      37,     1,     3,     6,     0,     0,     0,     0,     0,     0,
       0,     0,     0,     0,    72,     0,    93,     0,     0,     0,
       0,     0,     0,     0,     0,     0,     0,     0,     0,     0,
       0,     0,   134,   136,   137,   139,   140,   142,   143,   145,
     150,   152,   153,   155,   156,   158,   159,   161,   162,   164,
     169,   168,   166,     0,   146,   148,     0,     0,     0,     0,
       0,     0,     0,     0,     0,    70,    91,     0,     0,    40,
       0,     0,    56,     0,     0,    90,     0,     0,     0,     0,
       0,   105,     0,     0,   120,     0,     0,   126,     0,     0,
     132,     0,     0,     0,   108,     0,     0,   111,     0,     0,
     114,     0,     0,     0,     0,     0,     0,     0,     0,    87,
      95,     0,    98,    99,     0,   104,   106,     0,   119,   121,
       0,   125,   127,     0,   131,   133,     0,   107,   109,   110,
     112,   113,   115,    38,     0,    54,     0,    88,     0,     0,
     102,     0,     0,   117,     0,     0,   123,     0,     0,   129,
       0,     0,     0,    39,    55,    89,     0,   101,   103,   116,
     118,   122,   124,   128,   130,     0,     0,     0,     0,     0,
      97,    96
};

/* YYPGOTO[NTERM-NUM].  */
static const yytype_int16 yypgoto[] =
{
     -54,   -54,   293,   -54,   300,   -54,   -54,   -54,   -54,   -54,
     -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,
     -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,   -54,
     -54,   -54,   -54,   -54,   -54,   -54
};

/* YYDEFGOTO[NTERM-NUM].  */
static const yytype_int8 yydefgoto[] =
{
       0,    33,    34,    35,    36,    37,    38,    39,    40,    41,
      42,    43,    44,    45,    46,    47,    48,    49,    50,    51,
      52,    53,    54,    55,    56,    57,    58,    59,    60,    61,
      62,    63,    64,    65,    66,    67
};

/* YYTABLE[YYPACT[STATE-NUM]] -- What to do in state STATE-NUM.  If
   positive, shift that token.  If negative, reduce the rule whose
   number is the opposite.  If YYTABLE_NINF, syntax error.  */
static const yytype_int16 yytable[] =
{
     181,   231,   232,     1,     2,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,   117,    96,    97,    98,    99,   100,
     101,   102,   103,   104,   105,   106,   107,   108,   109,   184,
     119,   110,   187,   176,   118,   177,   185,   186,   111,   188,
     189,   112,   180,    32,     1,     2,     3,     4,     5,     6,
       7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
      17,    18,    19,    20,    21,    22,    23,    24,    25,    26,
      27,    28,    29,    30,    31,    68,    69,    70,    71,    72,
      73,    74,    75,    76,    77,    78,    79,    80,   190,   163,
      81,   159,   160,   120,   193,   191,   192,   161,   162,   121,
     122,   195,   198,   197,    32,     1,     2,     3,     4,     5,
       6,     7,     8,     9,    10,    11,    12,    13,    14,    15,
      16,    17,    18,    19,    20,    21,    22,    23,    24,    25,
      26,    27,    28,    29,    30,    31,   178,   113,   179,    82,
      83,    84,    85,    86,    87,    88,    89,    90,    91,    92,
      93,    94,   123,   194,    95,   126,   196,   199,   124,   125,
     114,   127,   128,   115,   129,   116,   132,   200,   135,   203,
     130,   131,   133,   134,   136,   137,   138,   201,   141,   202,
     144,   204,   139,   140,   142,   143,   145,   146,   147,   205,
     150,   206,   153,   207,   148,   149,   151,   152,   154,   155,
     156,   208,   164,   209,   167,   210,   157,   158,   165,   166,
     168,   169,   170,   211,   173,   212,   213,   214,   171,   172,
     174,   175,   215,   216,   217,   218,   219,   220,   221,   222,
     223,   224,   225,   226,   227,   228,   229,   230,   235,   233,
     236,   234,   238,   239,   241,   237,   242,   240,   243,   244,
     258,   245,   247,   248,   246,   249,   250,   251,   252,   255,
     254,   253,   262,   256,   257,   263,   265,   266,   268,   269,
     271,   259,   260,   272,   261,   264,   291,   267,   270,   273,
     275,   276,   278,   279,   281,   274,   277,   282,   280,   346,
     283,   285,   284,   286,   289,   290,   288,   292,   293,   294,
     297,   287,   300,   303,   295,   296,   182,   306,   298,     0,
       0,   299,   301,   321,     0,   302,   313,   183,   304,   305,
     315,   307,   308,   309,   310,   311,   312,   317,   314,   316,
     318,   322,   319,   324,   320,   323,   325,   326,   327,   328,
     329,   330,   331,   332,   347,   333,   334,   335,   336,   337,
       0,   338,     0,     0,   339,   345,   350,     0,     0,     0,
     351,   340,   341,   342,   343,   344,     0,   348,   349
};

static const yytype_int8 yycheck[] =
{
       0,    54,    55,     3,     4,     5,     6,     7,     8,     9,
      10,    11,    12,    13,    14,    15,    16,    17,    18,    19,
      20,    21,    22,    23,    24,    25,    26,    27,    28,    29,
      30,    31,    32,    33,    57,    34,    35,    36,    37,    38,
      39,    40,    41,    42,    43,    44,    45,    46,    47,    54,
      63,    50,    54,    60,    57,    62,    61,    62,    57,    61,
      62,    60,    48,    63,     3,     4,     5,     6,     7,     8,
       9,    10,    11,    12,    13,    14,    15,    16,    17,    18,
      19,    20,    21,    22,    23,    24,    25,    26,    27,    28,
      29,    30,    31,    32,    33,    35,    36,    37,    38,    39,
      40,    41,    42,    43,    44,    45,    46,    47,    54,    62,
      50,    54,    55,    54,    50,    61,    62,    60,    61,    60,
      61,    50,    50,    58,    63,     3,     4,     5,     6,     7,
       8,     9,    10,    11,    12,    13,    14,    15,    16,    17,
      18,    19,    20,    21,    22,    23,    24,    25,    26,    27,
      28,    29,    30,    31,    32,    33,    60,    34,    62,    35,
      36,    37,    38,    39,    40,    41,    42,    43,    44,    45,
      46,    47,    54,    62,    50,    54,    62,    50,    60,    61,
      57,    60,    61,    60,    54,    62,    54,    49,    54,    49,
      60,    61,    60,    61,    60,    61,    54,    62,    54,    54,
      54,    62,    60,    61,    60,    61,    60,    61,    54,    54,
      54,    49,    54,    62,    60,    61,    60,    61,    60,    61,
      54,    54,    54,    49,    54,    62,    60,    61,    60,    61,
      60,    61,    54,    54,    54,    62,    54,    62,    60,    61,
      60,    61,    54,    62,    54,    62,    54,    62,    54,    62,
      54,    62,    54,    62,    54,    62,    54,    62,    54,    58,
      49,    62,    54,    49,    54,    62,    49,    62,    62,    54,
      52,    62,    56,    54,    62,    51,    56,    54,    51,    51,
      54,    56,    49,    62,    62,    49,    49,    49,    49,    49,
      49,    62,    62,    49,    63,    63,    50,    63,    63,    52,
      49,    49,    49,    49,    49,    63,    63,    49,    63,    59,
      62,    62,    56,    56,    51,    51,    56,    51,    51,    49,
      49,    62,    49,    49,    63,    63,    33,    50,    63,    -1,
      -1,    63,    63,    49,    -1,    63,    51,    37,    63,    63,
      51,    63,    63,    63,    63,    63,    63,    51,    62,    62,
      62,    49,    62,    49,    63,    63,    49,    63,    49,    49,
      63,    49,    49,    62,    59,    51,    51,    51,    51,    63,
      -1,    63,    -1,    -1,    63,    51,    53,    -1,    -1,    -1,
      53,    63,    63,    63,    63,    63,    -1,    62,    62
};

/* YYSTOS[STATE-NUM] -- The symbol kind of the accessing symbol of
   state STATE-NUM.  */
static const yytype_int8 yystos[] =
{
       0,     3,     4,     5,     6,     7,     8,     9,    10,    11,
      12,    13,    14,    15,    16,    17,    18,    19,    20,    21,
      22,    23,    24,    25,    26,    27,    28,    29,    30,    31,
      32,    33,    63,    65,    66,    67,    68,    69,    70,    71,
      72,    73,    74,    75,    76,    77,    78,    79,    80,    81,
      82,    83,    84,    85,    86,    87,    88,    89,    90,    91,
      92,    93,    94,    95,    96,    97,    98,    99,    35,    36,
      37,    38,    39,    40,    41,    42,    43,    44,    45,    46,
      47,    50,    35,    36,    37,    38,    39,    40,    41,    42,
      43,    44,    45,    46,    47,    50,    34,    35,    36,    37,
      38,    39,    40,    41,    42,    43,    44,    45,    46,    47,
      50,    57,    60,    34,    57,    60,    62,    57,    57,    63,
      54,    60,    61,    54,    60,    61,    54,    60,    61,    54,
      60,    61,    54,    60,    61,    54,    60,    61,    54,    60,
      61,    54,    60,    61,    54,    60,    61,    54,    60,    61,
      54,    60,    61,    54,    60,    61,    54,    60,    61,    54,
      55,    60,    61,    62,    54,    60,    61,    54,    60,    61,
      54,    60,    61,    54,    60,    61,    60,    62,    60,    62,
      48,     0,    66,    68,    54,    61,    62,    54,    61,    62,
      54,    61,    62,    50,    62,    50,    62,    58,    50,    50,
      49,    62,    54,    49,    62,    54,    49,    62,    54,    49,
      62,    54,    62,    54,    62,    54,    62,    54,    62,    54,
      62,    54,    62,    54,    62,    54,    62,    54,    62,    54,
      62,    54,    55,    58,    62,    54,    49,    62,    54,    49,
      62,    54,    49,    62,    54,    62,    62,    56,    54,    51,
      56,    54,    51,    56,    54,    51,    62,    62,    52,    62,
      62,    63,    49,    49,    63,    49,    49,    63,    49,    49,
      63,    49,    49,    52,    63,    49,    49,    63,    49,    49,
      63,    49,    49,    62,    56,    62,    56,    62,    56,    51,
      51,    50,    51,    51,    49,    63,    63,    49,    63,    63,
      49,    63,    63,    49,    63,    63,    50,    63,    63,    63,
      63,    63,    63,    51,    62,    51,    62,    51,    62,    62,
      63,    49,    49,    63,    49,    49,    63,    49,    49,    63,
      49,    49,    62,    51,    51,    51,    51,    63,    63,    63,
      63,    63,    63,    63,    63,    51,    59,    59,    62,    62,
      53,    53
};

/* YYR1[RULE-NUM] -- Symbol kind of the left-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr1[] =
{
       0,    64,    65,    65,    66,    66,    67,    68,    68,    68,
      68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
      68,    68,    68,    68,    68,    68,    68,    68,    68,    68,
      68,    68,    68,    68,    68,    68,    68,    69,    70,    70,
      70,    70,    70,    70,    70,    70,    70,    70,    70,    70,
      70,    70,    70,    70,    71,    71,    71,    71,    71,    71,
      71,    71,    71,    71,    71,    71,    71,    71,    71,    71,
      72,    72,    73,    73,    73,    73,    73,    73,    73,    73,
      73,    73,    73,    73,    73,    73,    73,    73,    73,    73,
      73,    74,    74,    75,    75,    75,    75,    75,    76,    77,
      78,    79,    79,    79,    79,    79,    79,    80,    80,    80,
      81,    81,    81,    82,    82,    82,    83,    83,    83,    83,
      83,    83,    84,    84,    84,    84,    84,    84,    85,    85,
      85,    85,    85,    85,    86,    86,    86,    87,    87,    87,
      88,    88,    88,    89,    89,    89,    90,    90,    90,    91,
      92,    92,    92,    93,    93,    93,    94,    94,    94,    95,
      95,    95,    96,    96,    96,    97,    97,    97,    97,    97,
      98,    99
};

/* YYR2[RULE-NUM] -- Number of symbols on the right-hand side of rule RULE-NUM.  */
static const yytype_int8 yyr2[] =
{
       0,     2,     1,     2,     1,     1,     2,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
       1,     1,     1,     1,     1,     1,     1,     2,     6,     7,
       4,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     6,     7,     4,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
       3,     2,     3,     2,     2,     2,     2,     2,     2,     2,
       2,     2,     2,     2,     2,     2,     2,     5,     6,     7,
       4,     3,     2,     3,     2,     5,    10,    10,     5,     5,
       2,     7,     6,     7,     5,     4,     5,     5,     4,     5,
       5,     4,     5,     5,     4,     5,     7,     6,     7,     5,
       4,     5,     7,     6,     7,     5,     4,     5,     7,     6,
       7,     5,     4,     5,     3,     2,     3,     3,     2,     3,
       3,     2,     3,     3,     2,     3,     3,     2,     3,     1,
       3,     2,     3,     3,     2,     3,     3,     2,     3,     3,
       2,     3,     3,     2,     3,     2,     3,     2,     3,     3,
       1,     1
};


enum { YYENOMEM = -2 };

#define yyerrok         (yyerrstatus = 0)
#define yyclearin       (yychar = YYEMPTY)

#define YYACCEPT        goto yyacceptlab
#define YYABORT         goto yyabortlab
#define YYERROR         goto yyerrorlab
#define YYNOMEM         goto yyexhaustedlab


#define YYRECOVERING()  (!!yyerrstatus)

#define YYBACKUP(Token, Value)                                    \
  do                                                              \
    if (yychar == YYEMPTY)                                        \
      {                                                           \
        yychar = (Token);                                         \
        yylval = (Value);                                         \
        YYPOPSTACK (yylen);                                       \
        yystate = *yyssp;                                         \
        goto yybackup;                                            \
      }                                                           \
    else                                                          \
      {                                                           \
        yyerror (YY_("syntax error: cannot back up")); \
        YYERROR;                                                  \
      }                                                           \
  while (0)

/* Backward compatibility with an undocumented macro.
   Use YYerror or YYUNDEF. */
#define YYERRCODE YYUNDEF


/* Enable debugging if requested.  */
#if YYDEBUG

# ifndef YYFPRINTF
#  include <stdio.h> /* INFRINGES ON USER NAME SPACE */
#  define YYFPRINTF fprintf
# endif

# define YYDPRINTF(Args)                        \
do {                                            \
  if (yydebug)                                  \
    YYFPRINTF Args;                             \
} while (0)




# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)                    \
do {                                                                      \
  if (yydebug)                                                            \
    {                                                                     \
      YYFPRINTF (stderr, "%s ", Title);                                   \
      yy_symbol_print (stderr,                                            \
                  Kind, Value); \
      YYFPRINTF (stderr, "\n");                                           \
    }                                                                     \
} while (0)


/*-----------------------------------.
| Print this symbol's value on YYO.  |
`-----------------------------------*/

static void
yy_symbol_value_print (FILE *yyo,
                       yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  FILE *yyoutput = yyo;
  YY_USE (yyoutput);
  if (!yyvaluep)
    return;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/*---------------------------.
| Print this symbol on YYO.  |
`---------------------------*/

static void
yy_symbol_print (FILE *yyo,
                 yysymbol_kind_t yykind, YYSTYPE const * const yyvaluep)
{
  YYFPRINTF (yyo, "%s %s (",
             yykind < YYNTOKENS ? "token" : "nterm", yysymbol_name (yykind));

  yy_symbol_value_print (yyo, yykind, yyvaluep);
  YYFPRINTF (yyo, ")");
}

/*------------------------------------------------------------------.
| yy_stack_print -- Print the state stack from its BOTTOM up to its |
| TOP (included).                                                   |
`------------------------------------------------------------------*/

static void
yy_stack_print (yy_state_t *yybottom, yy_state_t *yytop)
{
  YYFPRINTF (stderr, "Stack now");
  for (; yybottom <= yytop; yybottom++)
    {
      int yybot = *yybottom;
      YYFPRINTF (stderr, " %d", yybot);
    }
  YYFPRINTF (stderr, "\n");
}

# define YY_STACK_PRINT(Bottom, Top)                            \
do {                                                            \
  if (yydebug)                                                  \
    yy_stack_print ((Bottom), (Top));                           \
} while (0)


/*------------------------------------------------.
| Report that the YYRULE is going to be reduced.  |
`------------------------------------------------*/

static void
yy_reduce_print (yy_state_t *yyssp, YYSTYPE *yyvsp,
                 int yyrule)
{
  int yylno = yyrline[yyrule];
  int yynrhs = yyr2[yyrule];
  int yyi;
  YYFPRINTF (stderr, "Reducing stack by rule %d (line %d):\n",
             yyrule - 1, yylno);
  /* The symbols being reduced.  */
  for (yyi = 0; yyi < yynrhs; yyi++)
    {
      YYFPRINTF (stderr, "   $%d = ", yyi + 1);
      yy_symbol_print (stderr,
                       YY_ACCESSING_SYMBOL (+yyssp[yyi + 1 - yynrhs]),
                       &yyvsp[(yyi + 1) - (yynrhs)]);
      YYFPRINTF (stderr, "\n");
    }
}

# define YY_REDUCE_PRINT(Rule)          \
do {                                    \
  if (yydebug)                          \
    yy_reduce_print (yyssp, yyvsp, Rule); \
} while (0)

/* Nonzero means print parse trace.  It is left uninitialized so that
   multiple parsers can coexist.  */
int yydebug;
#else /* !YYDEBUG */
# define YYDPRINTF(Args) ((void) 0)
# define YY_SYMBOL_PRINT(Title, Kind, Value, Location)
# define YY_STACK_PRINT(Bottom, Top)
# define YY_REDUCE_PRINT(Rule)
#endif /* !YYDEBUG */


/* YYINITDEPTH -- initial size of the parser's stacks.  */
#ifndef YYINITDEPTH
# define YYINITDEPTH 200
#endif

/* YYMAXDEPTH -- maximum size the stacks can grow to (effective only
   if the built-in stack extension method is used).

   Do not make this value too large; the results are undefined if
   YYSTACK_ALLOC_MAXIMUM < YYSTACK_BYTES (YYMAXDEPTH)
   evaluated with infinite-precision integer arithmetic.  */

#ifndef YYMAXDEPTH
# define YYMAXDEPTH 10000
#endif






/*-----------------------------------------------.
| Release the memory associated to this symbol.  |
`-----------------------------------------------*/

static void
yydestruct (const char *yymsg,
            yysymbol_kind_t yykind, YYSTYPE *yyvaluep)
{
  YY_USE (yyvaluep);
  if (!yymsg)
    yymsg = "Deleting";
  YY_SYMBOL_PRINT (yymsg, yykind, yyvaluep, yylocationp);

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  YY_USE (yykind);
  YY_IGNORE_MAYBE_UNINITIALIZED_END
}


/* Lookahead token kind.  */
int yychar;

/* The semantic value of the lookahead symbol.  */
YYSTYPE yylval;
/* Number of syntax errors so far.  */
int yynerrs;




/*----------.
| yyparse.  |
`----------*/

int
yyparse (void)
{
    yy_state_fast_t yystate = 0;
    /* Number of tokens to shift before error messages enabled.  */
    int yyerrstatus = 0;

    /* Refer to the stacks through separate pointers, to allow yyoverflow
       to reallocate them elsewhere.  */

    /* Their size.  */
    YYPTRDIFF_T yystacksize = YYINITDEPTH;

    /* The state stack: array, bottom, top.  */
    yy_state_t yyssa[YYINITDEPTH];
    yy_state_t *yyss = yyssa;
    yy_state_t *yyssp = yyss;

    /* The semantic value stack: array, bottom, top.  */
    YYSTYPE yyvsa[YYINITDEPTH];
    YYSTYPE *yyvs = yyvsa;
    YYSTYPE *yyvsp = yyvs;

  int yyn;
  /* The return value of yyparse.  */
  int yyresult;
  /* Lookahead symbol kind.  */
  yysymbol_kind_t yytoken = YYSYMBOL_YYEMPTY;
  /* The variables used to return semantic value and location from the
     action routines.  */
  YYSTYPE yyval;



#define YYPOPSTACK(N)   (yyvsp -= (N), yyssp -= (N))

  /* The number of symbols on the RHS of the reduced rule.
     Keep to zero when no symbol should be popped.  */
  int yylen = 0;

  YYDPRINTF ((stderr, "Starting parse\n"));

  yychar = YYEMPTY; /* Cause a token to be read.  */

  goto yysetstate;


/*------------------------------------------------------------.
| yynewstate -- push a new state, which is found in yystate.  |
`------------------------------------------------------------*/
yynewstate:
  /* In all cases, when you get here, the value and location stacks
     have just been pushed.  So pushing a state here evens the stacks.  */
  yyssp++;


/*--------------------------------------------------------------------.
| yysetstate -- set current state (the top of the stack) to yystate.  |
`--------------------------------------------------------------------*/
yysetstate:
  YYDPRINTF ((stderr, "Entering state %d\n", yystate));
  YY_ASSERT (0 <= yystate && yystate < YYNSTATES);
  YY_IGNORE_USELESS_CAST_BEGIN
  *yyssp = YY_CAST (yy_state_t, yystate);
  YY_IGNORE_USELESS_CAST_END
  YY_STACK_PRINT (yyss, yyssp);

  if (yyss + yystacksize - 1 <= yyssp)
#if !defined yyoverflow && !defined YYSTACK_RELOCATE
    YYNOMEM;
#else
    {
      /* Get the current used size of the three stacks, in elements.  */
      YYPTRDIFF_T yysize = yyssp - yyss + 1;

# if defined yyoverflow
      {
        /* Give user a chance to reallocate the stack.  Use copies of
           these so that the &'s don't force the real ones into
           memory.  */
        yy_state_t *yyss1 = yyss;
        YYSTYPE *yyvs1 = yyvs;

        /* Each stack pointer address is followed by the size of the
           data in use in that stack, in bytes.  This used to be a
           conditional around just the two extra args, but that might
           be undefined if yyoverflow is a macro.  */
        yyoverflow (YY_("memory exhausted"),
                    &yyss1, yysize * YYSIZEOF (*yyssp),
                    &yyvs1, yysize * YYSIZEOF (*yyvsp),
                    &yystacksize);
        yyss = yyss1;
        yyvs = yyvs1;
      }
# else /* defined YYSTACK_RELOCATE */
      /* Extend the stack our own way.  */
      if (YYMAXDEPTH <= yystacksize)
        YYNOMEM;
      yystacksize *= 2;
      if (YYMAXDEPTH < yystacksize)
        yystacksize = YYMAXDEPTH;

      {
        yy_state_t *yyss1 = yyss;
        union yyalloc *yyptr =
          YY_CAST (union yyalloc *,
                   YYSTACK_ALLOC (YY_CAST (YYSIZE_T, YYSTACK_BYTES (yystacksize))));
        if (! yyptr)
          YYNOMEM;
        YYSTACK_RELOCATE (yyss_alloc, yyss);
        YYSTACK_RELOCATE (yyvs_alloc, yyvs);
#  undef YYSTACK_RELOCATE
        if (yyss1 != yyssa)
          YYSTACK_FREE (yyss1);
      }
# endif

      yyssp = yyss + yysize - 1;
      yyvsp = yyvs + yysize - 1;

      YY_IGNORE_USELESS_CAST_BEGIN
      YYDPRINTF ((stderr, "Stack size increased to %ld\n",
                  YY_CAST (long, yystacksize)));
      YY_IGNORE_USELESS_CAST_END

      if (yyss + yystacksize - 1 <= yyssp)
        YYABORT;
    }
#endif /* !defined yyoverflow && !defined YYSTACK_RELOCATE */


  if (yystate == YYFINAL)
    YYACCEPT;

  goto yybackup;


/*-----------.
| yybackup.  |
`-----------*/
yybackup:
  /* Do appropriate processing given the current state.  Read a
     lookahead token if we need one and don't already have one.  */

  /* First try to decide what to do without reference to lookahead token.  */
  yyn = yypact[yystate];
  if (yypact_value_is_default (yyn))
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* YYCHAR is either empty, or end-of-input, or a valid lookahead.  */
  if (yychar == YYEMPTY)
    {
      YYDPRINTF ((stderr, "Reading a token\n"));
      yychar = yylex ();
    }

  if (yychar <= YYEOF)
    {
      yychar = YYEOF;
      yytoken = YYSYMBOL_YYEOF;
      YYDPRINTF ((stderr, "Now at end of input.\n"));
    }
  else if (yychar == YYerror)
    {
      /* The scanner already issued an error message, process directly
         to error recovery.  But do not keep the error token as
         lookahead, it is too special and may lead us to an endless
         loop in error recovery. */
      yychar = YYUNDEF;
      yytoken = YYSYMBOL_YYerror;
      goto yyerrlab1;
    }
  else
    {
      yytoken = YYTRANSLATE (yychar);
      YY_SYMBOL_PRINT ("Next token is", yytoken, &yylval, &yylloc);
    }

  /* If the proper action on seeing token YYTOKEN is to reduce or to
     detect an error, take that action.  */
  yyn += yytoken;
  if (yyn < 0 || YYLAST < yyn || yycheck[yyn] != yytoken)
    goto yydefault;
  yyn = yytable[yyn];
  if (yyn <= 0)
    {
      if (yytable_value_is_error (yyn))
        goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }

  /* Count tokens shifted since error; after three, turn off error
     status.  */
  if (yyerrstatus)
    yyerrstatus--;

  /* Shift the lookahead token.  */
  YY_SYMBOL_PRINT ("Shifting", yytoken, &yylval, &yylloc);
  yystate = yyn;
  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END

  /* Discard the shifted token.  */
  yychar = YYEMPTY;
  goto yynewstate;


/*-----------------------------------------------------------.
| yydefault -- do the default action for the current state.  |
`-----------------------------------------------------------*/
yydefault:
  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;
  goto yyreduce;


/*-----------------------------.
| yyreduce -- do a reduction.  |
`-----------------------------*/
yyreduce:
  /* yyn is the number of a rule to reduce with.  */
  yylen = yyr2[yyn];

  /* If YYLEN is nonzero, implement the default value of the action:
     '$$ = $1'.

     Otherwise, the following line sets YYVAL to garbage.
     This behavior is undocumented and Bison
     users should not rely upon it.  Assigning to YYVAL
     unconditionally makes the parser a bit smaller, and it avoids a
     GCC warning that YYVAL may be used uninitialized.  */
  yyval = yyvsp[1-yylen];


  YY_REDUCE_PRINT (yyn);
  switch (yyn)
    {
  case 37: /* labelled: label ':'  */
#line 191 "bpf_parser.y"
                    { set_curr_label((yyvsp[-1].label)); }
#line 1508 "bpfc/bpf_parser.tab.c"
    break;

  case 38: /* ldb: OP_LDB '[' 'x' '+' number ']'  */
#line 195 "bpf_parser.y"
                                        {
		set_curr_instr(BPF_LD | BPF_B | BPF_IND, 0, 0, (yyvsp[-1].number)); }
#line 1515 "bpfc/bpf_parser.tab.c"
    break;

  case 39: /* ldb: OP_LDB '[' '%' 'x' '+' number ']'  */
#line 197 "bpf_parser.y"
                                            {
		set_curr_instr(BPF_LD | BPF_B | BPF_IND, 0, 0, (yyvsp[-1].number)); }
#line 1522 "bpfc/bpf_parser.tab.c"
    break;

  case 40: /* ldb: OP_LDB '[' number ']'  */
#line 199 "bpf_parser.y"
                                {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0, (yyvsp[-1].number)); }
#line 1529 "bpfc/bpf_parser.tab.c"
    break;

  case 41: /* ldb: OP_LDB K_PROTO  */
#line 201 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_PROTOCOL); }
#line 1537 "bpfc/bpf_parser.tab.c"
    break;

  case 42: /* ldb: OP_LDB K_TYPE  */
#line 204 "bpf_parser.y"
                        {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_PKTTYPE); }
#line 1545 "bpfc/bpf_parser.tab.c"
    break;

  case 43: /* ldb: OP_LDB K_IFIDX  */
#line 207 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_IFINDEX); }
#line 1553 "bpfc/bpf_parser.tab.c"
    break;

  case 44: /* ldb: OP_LDB K_NLATTR  */
#line 210 "bpf_parser.y"
                          {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_NLATTR); }
#line 1561 "bpfc/bpf_parser.tab.c"
    break;

  case 45: /* ldb: OP_LDB K_NLATTR_NEST  */
#line 213 "bpf_parser.y"
                               {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_NLATTR_NEST); }
#line 1569 "bpfc/bpf_parser.tab.c"
    break;

  case 46: /* ldb: OP_LDB K_MARK  */
#line 216 "bpf_parser.y"
                        {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_MARK); }
#line 1577 "bpfc/bpf_parser.tab.c"
    break;

  case 47: /* ldb: OP_LDB K_QUEUE  */
#line 219 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_QUEUE); }
#line 1585 "bpfc/bpf_parser.tab.c"
    break;

  case 48: /* ldb: OP_LDB K_HATYPE  */
#line 222 "bpf_parser.y"
                          {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_HATYPE); }
#line 1593 "bpfc/bpf_parser.tab.c"
    break;

  case 49: /* ldb: OP_LDB K_RXHASH  */
#line 225 "bpf_parser.y"
                          {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_RXHASH); }
#line 1601 "bpfc/bpf_parser.tab.c"
    break;

  case 50: /* ldb: OP_LDB K_CPU  */
#line 228 "bpf_parser.y"
                       {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_CPU); }
#line 1609 "bpfc/bpf_parser.tab.c"
    break;

  case 51: /* ldb: OP_LDB K_VLANT  */
#line 231 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_VLAN_TAG); }
#line 1617 "bpfc/bpf_parser.tab.c"
    break;

  case 52: /* ldb: OP_LDB K_VLANP  */
#line 234 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_VLAN_TAG_PRESENT); }
#line 1625 "bpfc/bpf_parser.tab.c"
    break;

  case 53: /* ldb: OP_LDB K_POFF  */
#line 237 "bpf_parser.y"
                        {
		set_curr_instr(BPF_LD | BPF_B | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_PAY_OFFSET); }
#line 1633 "bpfc/bpf_parser.tab.c"
    break;

  case 54: /* ldh: OP_LDH '[' 'x' '+' number ']'  */
#line 243 "bpf_parser.y"
                                        {
		set_curr_instr(BPF_LD | BPF_H | BPF_IND, 0, 0, (yyvsp[-1].number)); }
#line 1640 "bpfc/bpf_parser.tab.c"
    break;

  case 55: /* ldh: OP_LDH '[' '%' 'x' '+' number ']'  */
#line 245 "bpf_parser.y"
                                            {
		set_curr_instr(BPF_LD | BPF_H | BPF_IND, 0, 0, (yyvsp[-1].number)); }
#line 1647 "bpfc/bpf_parser.tab.c"
    break;

  case 56: /* ldh: OP_LDH '[' number ']'  */
#line 247 "bpf_parser.y"
                                {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0, (yyvsp[-1].number)); }
#line 1654 "bpfc/bpf_parser.tab.c"
    break;

  case 57: /* ldh: OP_LDH K_PROTO  */
#line 249 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_PROTOCOL); }
#line 1662 "bpfc/bpf_parser.tab.c"
    break;

  case 58: /* ldh: OP_LDH K_TYPE  */
#line 252 "bpf_parser.y"
                        {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_PKTTYPE); }
#line 1670 "bpfc/bpf_parser.tab.c"
    break;

  case 59: /* ldh: OP_LDH K_IFIDX  */
#line 255 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_IFINDEX); }
#line 1678 "bpfc/bpf_parser.tab.c"
    break;

  case 60: /* ldh: OP_LDH K_NLATTR  */
#line 258 "bpf_parser.y"
                          {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_NLATTR); }
#line 1686 "bpfc/bpf_parser.tab.c"
    break;

  case 61: /* ldh: OP_LDH K_NLATTR_NEST  */
#line 261 "bpf_parser.y"
                               {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_NLATTR_NEST); }
#line 1694 "bpfc/bpf_parser.tab.c"
    break;

  case 62: /* ldh: OP_LDH K_MARK  */
#line 264 "bpf_parser.y"
                        {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_MARK); }
#line 1702 "bpfc/bpf_parser.tab.c"
    break;

  case 63: /* ldh: OP_LDH K_QUEUE  */
#line 267 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_QUEUE); }
#line 1710 "bpfc/bpf_parser.tab.c"
    break;

  case 64: /* ldh: OP_LDH K_HATYPE  */
#line 270 "bpf_parser.y"
                          {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_HATYPE); }
#line 1718 "bpfc/bpf_parser.tab.c"
    break;

  case 65: /* ldh: OP_LDH K_RXHASH  */
#line 273 "bpf_parser.y"
                          {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_RXHASH); }
#line 1726 "bpfc/bpf_parser.tab.c"
    break;

  case 66: /* ldh: OP_LDH K_CPU  */
#line 276 "bpf_parser.y"
                       {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_CPU); }
#line 1734 "bpfc/bpf_parser.tab.c"
    break;

  case 67: /* ldh: OP_LDH K_VLANT  */
#line 279 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_VLAN_TAG); }
#line 1742 "bpfc/bpf_parser.tab.c"
    break;

  case 68: /* ldh: OP_LDH K_VLANP  */
#line 282 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_VLAN_TAG_PRESENT); }
#line 1750 "bpfc/bpf_parser.tab.c"
    break;

  case 69: /* ldh: OP_LDH K_POFF  */
#line 285 "bpf_parser.y"
                        {
		set_curr_instr(BPF_LD | BPF_H | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_PAY_OFFSET); }
#line 1758 "bpfc/bpf_parser.tab.c"
    break;

  case 70: /* ldi: OP_LDI '#' number  */
#line 291 "bpf_parser.y"
                            {
		set_curr_instr(BPF_LD | BPF_IMM, 0, 0, (yyvsp[0].number)); }
#line 1765 "bpfc/bpf_parser.tab.c"
    break;

  case 71: /* ldi: OP_LDI number  */
#line 293 "bpf_parser.y"
                        {
		set_curr_instr(BPF_LD | BPF_IMM, 0, 0, (yyvsp[0].number)); }
#line 1772 "bpfc/bpf_parser.tab.c"
    break;

  case 72: /* ld: OP_LD '#' number  */
#line 298 "bpf_parser.y"
                           {
		set_curr_instr(BPF_LD | BPF_IMM, 0, 0, (yyvsp[0].number)); }
#line 1779 "bpfc/bpf_parser.tab.c"
    break;

  case 73: /* ld: OP_LD K_PKT_LEN  */
#line 300 "bpf_parser.y"
                          {
		set_curr_instr(BPF_LD | BPF_W | BPF_LEN, 0, 0, 0); }
#line 1786 "bpfc/bpf_parser.tab.c"
    break;

  case 74: /* ld: OP_LD K_PROTO  */
#line 302 "bpf_parser.y"
                        {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_PROTOCOL); }
#line 1794 "bpfc/bpf_parser.tab.c"
    break;

  case 75: /* ld: OP_LD K_TYPE  */
#line 305 "bpf_parser.y"
                       {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_PKTTYPE); }
#line 1802 "bpfc/bpf_parser.tab.c"
    break;

  case 76: /* ld: OP_LD K_IFIDX  */
#line 308 "bpf_parser.y"
                        {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_IFINDEX); }
#line 1810 "bpfc/bpf_parser.tab.c"
    break;

  case 77: /* ld: OP_LD K_NLATTR  */
#line 311 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_NLATTR); }
#line 1818 "bpfc/bpf_parser.tab.c"
    break;

  case 78: /* ld: OP_LD K_NLATTR_NEST  */
#line 314 "bpf_parser.y"
                              {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_NLATTR_NEST); }
#line 1826 "bpfc/bpf_parser.tab.c"
    break;

  case 79: /* ld: OP_LD K_MARK  */
#line 317 "bpf_parser.y"
                       {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_MARK); }
#line 1834 "bpfc/bpf_parser.tab.c"
    break;

  case 80: /* ld: OP_LD K_QUEUE  */
#line 320 "bpf_parser.y"
                        {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_QUEUE); }
#line 1842 "bpfc/bpf_parser.tab.c"
    break;

  case 81: /* ld: OP_LD K_HATYPE  */
#line 323 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_HATYPE); }
#line 1850 "bpfc/bpf_parser.tab.c"
    break;

  case 82: /* ld: OP_LD K_RXHASH  */
#line 326 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_RXHASH); }
#line 1858 "bpfc/bpf_parser.tab.c"
    break;

  case 83: /* ld: OP_LD K_CPU  */
#line 329 "bpf_parser.y"
                      {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_CPU); }
#line 1866 "bpfc/bpf_parser.tab.c"
    break;

  case 84: /* ld: OP_LD K_VLANT  */
#line 332 "bpf_parser.y"
                        {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_VLAN_TAG); }
#line 1874 "bpfc/bpf_parser.tab.c"
    break;

  case 85: /* ld: OP_LD K_VLANP  */
#line 335 "bpf_parser.y"
                        {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_VLAN_TAG_PRESENT); }
#line 1882 "bpfc/bpf_parser.tab.c"
    break;

  case 86: /* ld: OP_LD K_POFF  */
#line 338 "bpf_parser.y"
                       {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0,
			       SKF_AD_OFF + SKF_AD_PAY_OFFSET); }
#line 1890 "bpfc/bpf_parser.tab.c"
    break;

  case 87: /* ld: OP_LD 'M' '[' number ']'  */
#line 341 "bpf_parser.y"
                                   {
		set_curr_instr(BPF_LD | BPF_MEM, 0, 0, (yyvsp[-1].number)); }
#line 1897 "bpfc/bpf_parser.tab.c"
    break;

  case 88: /* ld: OP_LD '[' 'x' '+' number ']'  */
#line 343 "bpf_parser.y"
                                       {
		set_curr_instr(BPF_LD | BPF_W | BPF_IND, 0, 0, (yyvsp[-1].number)); }
#line 1904 "bpfc/bpf_parser.tab.c"
    break;

  case 89: /* ld: OP_LD '[' '%' 'x' '+' number ']'  */
#line 345 "bpf_parser.y"
                                           {
		set_curr_instr(BPF_LD | BPF_W | BPF_IND, 0, 0, (yyvsp[-1].number)); }
#line 1911 "bpfc/bpf_parser.tab.c"
    break;

  case 90: /* ld: OP_LD '[' number ']'  */
#line 347 "bpf_parser.y"
                               {
		set_curr_instr(BPF_LD | BPF_W | BPF_ABS, 0, 0, (yyvsp[-1].number)); }
#line 1918 "bpfc/bpf_parser.tab.c"
    break;

  case 91: /* ldxi: OP_LDXI '#' number  */
#line 352 "bpf_parser.y"
                             {
		set_curr_instr(BPF_LDX | BPF_IMM, 0, 0, (yyvsp[0].number)); }
#line 1925 "bpfc/bpf_parser.tab.c"
    break;

  case 92: /* ldxi: OP_LDXI number  */
#line 354 "bpf_parser.y"
                         {
		set_curr_instr(BPF_LDX | BPF_IMM, 0, 0, (yyvsp[0].number)); }
#line 1932 "bpfc/bpf_parser.tab.c"
    break;

  case 93: /* ldx: OP_LDX '#' number  */
#line 359 "bpf_parser.y"
                            {
		set_curr_instr(BPF_LDX | BPF_IMM, 0, 0, (yyvsp[0].number)); }
#line 1939 "bpfc/bpf_parser.tab.c"
    break;

  case 94: /* ldx: OP_LDX K_PKT_LEN  */
#line 361 "bpf_parser.y"
                           {
		set_curr_instr(BPF_LDX | BPF_W | BPF_LEN, 0, 0, 0); }
#line 1946 "bpfc/bpf_parser.tab.c"
    break;

  case 95: /* ldx: OP_LDX 'M' '[' number ']'  */
#line 363 "bpf_parser.y"
                                    {
		set_curr_instr(BPF_LDX | BPF_MEM, 0, 0, (yyvsp[-1].number)); }
#line 1953 "bpfc/bpf_parser.tab.c"
    break;

  case 96: /* ldx: OP_LDXB number '*' '(' '[' number ']' '&' number ')'  */
#line 365 "bpf_parser.y"
                                                               {
		if ((yyvsp[-8].number) != 4 || (yyvsp[-1].number) != 0xf) {
			panic("ldxb offset not supported!\n");
		} else {
			set_curr_instr(BPF_LDX | BPF_MSH | BPF_B, 0, 0, (yyvsp[-4].number)); } }
#line 1963 "bpfc/bpf_parser.tab.c"
    break;

  case 97: /* ldx: OP_LDX number '*' '(' '[' number ']' '&' number ')'  */
#line 370 "bpf_parser.y"
                                                              {
		if ((yyvsp[-8].number) != 4 || (yyvsp[-1].number) != 0xf) {
			panic("ldxb offset not supported!\n");
		} else {
			set_curr_instr(BPF_LDX | BPF_MSH | BPF_B, 0, 0, (yyvsp[-4].number)); } }
#line 1973 "bpfc/bpf_parser.tab.c"
    break;

  case 98: /* st: OP_ST 'M' '[' number ']'  */
#line 378 "bpf_parser.y"
                                   {
		set_curr_instr(BPF_ST, 0, 0, (yyvsp[-1].number)); }
#line 1980 "bpfc/bpf_parser.tab.c"
    break;

  case 99: /* stx: OP_STX 'M' '[' number ']'  */
#line 383 "bpf_parser.y"
                                    {
		set_curr_instr(BPF_STX, 0, 0, (yyvsp[-1].number)); }
#line 1987 "bpfc/bpf_parser.tab.c"
    break;

  case 100: /* jmp: OP_JMP label  */
#line 388 "bpf_parser.y"
                       {
		set_jmp_label((yyvsp[0].label), JKL);
		set_curr_instr(BPF_JMP | BPF_JA, 0, 0, 0); }
#line 1995 "bpfc/bpf_parser.tab.c"
    break;

  case 101: /* jeq: OP_JEQ '#' number ',' label ',' label  */
#line 394 "bpf_parser.y"
                                                {
		set_jmp_label((yyvsp[-2].label), JTL);
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JEQ | BPF_K, 0, 0, (yyvsp[-4].number)); }
#line 2004 "bpfc/bpf_parser.tab.c"
    break;

  case 102: /* jeq: OP_JEQ 'x' ',' label ',' label  */
#line 398 "bpf_parser.y"
                                         {
		set_jmp_label((yyvsp[-2].label), JTL);
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JEQ | BPF_X, 0, 0, 0); }
#line 2013 "bpfc/bpf_parser.tab.c"
    break;

  case 103: /* jeq: OP_JEQ '%' 'x' ',' label ',' label  */
#line 402 "bpf_parser.y"
                                             {
		set_jmp_label((yyvsp[-2].label), JTL);
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JEQ | BPF_X, 0, 0, 0); }
#line 2022 "bpfc/bpf_parser.tab.c"
    break;

  case 104: /* jeq: OP_JEQ '#' number ',' label  */
#line 406 "bpf_parser.y"
                                      {
		set_jmp_label((yyvsp[0].label), JTL);
		set_curr_instr(BPF_JMP | BPF_JEQ | BPF_K, 0, 0, (yyvsp[-2].number)); }
#line 2030 "bpfc/bpf_parser.tab.c"
    break;

  case 105: /* jeq: OP_JEQ 'x' ',' label  */
#line 409 "bpf_parser.y"
                               {
		set_jmp_label((yyvsp[0].label), JTL);
		set_curr_instr(BPF_JMP | BPF_JEQ | BPF_X, 0, 0, 0); }
#line 2038 "bpfc/bpf_parser.tab.c"
    break;

  case 106: /* jeq: OP_JEQ '%' 'x' ',' label  */
#line 412 "bpf_parser.y"
                                   {
		set_jmp_label((yyvsp[0].label), JTL);
		set_curr_instr(BPF_JMP | BPF_JEQ | BPF_X, 0, 0, 0); }
#line 2046 "bpfc/bpf_parser.tab.c"
    break;

  case 107: /* jneq: OP_JNEQ '#' number ',' label  */
#line 418 "bpf_parser.y"
                                       {
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JEQ | BPF_K, 0, 0, (yyvsp[-2].number)); }
#line 2054 "bpfc/bpf_parser.tab.c"
    break;

  case 108: /* jneq: OP_JNEQ 'x' ',' label  */
#line 421 "bpf_parser.y"
                                {
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JEQ | BPF_X, 0, 0, 0); }
#line 2062 "bpfc/bpf_parser.tab.c"
    break;

  case 109: /* jneq: OP_JNEQ '%' 'x' ',' label  */
#line 424 "bpf_parser.y"
                                    {
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JEQ | BPF_X, 0, 0, 0); }
#line 2070 "bpfc/bpf_parser.tab.c"
    break;

  case 110: /* jlt: OP_JLT '#' number ',' label  */
#line 430 "bpf_parser.y"
                                      {
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JGE | BPF_K, 0, 0, (yyvsp[-2].number)); }
#line 2078 "bpfc/bpf_parser.tab.c"
    break;

  case 111: /* jlt: OP_JLT 'x' ',' label  */
#line 433 "bpf_parser.y"
                               {
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JGE | BPF_X, 0, 0, 0); }
#line 2086 "bpfc/bpf_parser.tab.c"
    break;

  case 112: /* jlt: OP_JLT '%' 'x' ',' label  */
#line 436 "bpf_parser.y"
                                   {
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JGE | BPF_X, 0, 0, 0); }
#line 2094 "bpfc/bpf_parser.tab.c"
    break;

  case 113: /* jle: OP_JLE '#' number ',' label  */
#line 442 "bpf_parser.y"
                                      {
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JGT | BPF_K, 0, 0, (yyvsp[-2].number)); }
#line 2102 "bpfc/bpf_parser.tab.c"
    break;

  case 114: /* jle: OP_JLE 'x' ',' label  */
#line 445 "bpf_parser.y"
                               {
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JGT | BPF_X, 0, 0, 0); }
#line 2110 "bpfc/bpf_parser.tab.c"
    break;

  case 115: /* jle: OP_JLE '%' 'x' ',' label  */
#line 448 "bpf_parser.y"
                                   {
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JGT | BPF_X, 0, 0, 0); }
#line 2118 "bpfc/bpf_parser.tab.c"
    break;

  case 116: /* jgt: OP_JGT '#' number ',' label ',' label  */
#line 454 "bpf_parser.y"
                                                {
		set_jmp_label((yyvsp[-2].label), JTL);
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JGT | BPF_K, 0, 0, (yyvsp[-4].number)); }
#line 2127 "bpfc/bpf_parser.tab.c"
    break;

  case 117: /* jgt: OP_JGT 'x' ',' label ',' label  */
#line 458 "bpf_parser.y"
                                         {
		set_jmp_label((yyvsp[-2].label), JTL);
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JGT | BPF_X, 0, 0, 0); }
#line 2136 "bpfc/bpf_parser.tab.c"
    break;

  case 118: /* jgt: OP_JGT '%' 'x' ',' label ',' label  */
#line 462 "bpf_parser.y"
                                             {
		set_jmp_label((yyvsp[-2].label), JTL);
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JGT | BPF_X, 0, 0, 0); }
#line 2145 "bpfc/bpf_parser.tab.c"
    break;

  case 119: /* jgt: OP_JGT '#' number ',' label  */
#line 466 "bpf_parser.y"
                                      {
		set_jmp_label((yyvsp[0].label), JTL);
		set_curr_instr(BPF_JMP | BPF_JGT | BPF_K, 0, 0, (yyvsp[-2].number)); }
#line 2153 "bpfc/bpf_parser.tab.c"
    break;

  case 120: /* jgt: OP_JGT 'x' ',' label  */
#line 469 "bpf_parser.y"
                               {
		set_jmp_label((yyvsp[0].label), JTL);
		set_curr_instr(BPF_JMP | BPF_JGT | BPF_X, 0, 0, 0); }
#line 2161 "bpfc/bpf_parser.tab.c"
    break;

  case 121: /* jgt: OP_JGT '%' 'x' ',' label  */
#line 472 "bpf_parser.y"
                                   {
		set_jmp_label((yyvsp[0].label), JTL);
		set_curr_instr(BPF_JMP | BPF_JGT | BPF_X, 0, 0, 0); }
#line 2169 "bpfc/bpf_parser.tab.c"
    break;

  case 122: /* jge: OP_JGE '#' number ',' label ',' label  */
#line 478 "bpf_parser.y"
                                                {
		set_jmp_label((yyvsp[-2].label), JTL);
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JGE | BPF_K, 0, 0, (yyvsp[-4].number)); }
#line 2178 "bpfc/bpf_parser.tab.c"
    break;

  case 123: /* jge: OP_JGE 'x' ',' label ',' label  */
#line 482 "bpf_parser.y"
                                         {
		set_jmp_label((yyvsp[-2].label), JTL);
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JGE | BPF_X, 0, 0, 0); }
#line 2187 "bpfc/bpf_parser.tab.c"
    break;

  case 124: /* jge: OP_JGE '%' 'x' ',' label ',' label  */
#line 486 "bpf_parser.y"
                                             {
		set_jmp_label((yyvsp[-2].label), JTL);
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JGE | BPF_X, 0, 0, 0); }
#line 2196 "bpfc/bpf_parser.tab.c"
    break;

  case 125: /* jge: OP_JGE '#' number ',' label  */
#line 490 "bpf_parser.y"
                                      {
		set_jmp_label((yyvsp[0].label), JTL);
		set_curr_instr(BPF_JMP | BPF_JGE | BPF_K, 0, 0, (yyvsp[-2].number)); }
#line 2204 "bpfc/bpf_parser.tab.c"
    break;

  case 126: /* jge: OP_JGE 'x' ',' label  */
#line 493 "bpf_parser.y"
                               {
		set_jmp_label((yyvsp[0].label), JTL);
		set_curr_instr(BPF_JMP | BPF_JGE | BPF_X, 0, 0, 0); }
#line 2212 "bpfc/bpf_parser.tab.c"
    break;

  case 127: /* jge: OP_JGE '%' 'x' ',' label  */
#line 496 "bpf_parser.y"
                                   {
		set_jmp_label((yyvsp[0].label), JTL);
		set_curr_instr(BPF_JMP | BPF_JGE | BPF_X, 0, 0, 0); }
#line 2220 "bpfc/bpf_parser.tab.c"
    break;

  case 128: /* jset: OP_JSET '#' number ',' label ',' label  */
#line 502 "bpf_parser.y"
                                                 {
		set_jmp_label((yyvsp[-2].label), JTL);
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JSET | BPF_K, 0, 0, (yyvsp[-4].number)); }
#line 2229 "bpfc/bpf_parser.tab.c"
    break;

  case 129: /* jset: OP_JSET 'x' ',' label ',' label  */
#line 506 "bpf_parser.y"
                                          {
		set_jmp_label((yyvsp[-2].label), JTL);
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JSET | BPF_X, 0, 0, 0); }
#line 2238 "bpfc/bpf_parser.tab.c"
    break;

  case 130: /* jset: OP_JSET '%' 'x' ',' label ',' label  */
#line 510 "bpf_parser.y"
                                              {
		set_jmp_label((yyvsp[-2].label), JTL);
		set_jmp_label((yyvsp[0].label), JFL);
		set_curr_instr(BPF_JMP | BPF_JSET | BPF_X, 0, 0, 0); }
#line 2247 "bpfc/bpf_parser.tab.c"
    break;

  case 131: /* jset: OP_JSET '#' number ',' label  */
#line 514 "bpf_parser.y"
                                       {
		set_jmp_label((yyvsp[0].label), JTL);
		set_curr_instr(BPF_JMP | BPF_JSET | BPF_K, 0, 0, (yyvsp[-2].number)); }
#line 2255 "bpfc/bpf_parser.tab.c"
    break;

  case 132: /* jset: OP_JSET 'x' ',' label  */
#line 517 "bpf_parser.y"
                                {
		set_jmp_label((yyvsp[0].label), JTL);
		set_curr_instr(BPF_JMP | BPF_JSET | BPF_X, 0, 0, 0); }
#line 2263 "bpfc/bpf_parser.tab.c"
    break;

  case 133: /* jset: OP_JSET '%' 'x' ',' label  */
#line 520 "bpf_parser.y"
                                    {
		set_jmp_label((yyvsp[0].label), JTL);
		set_curr_instr(BPF_JMP | BPF_JSET | BPF_X, 0, 0, 0); }
#line 2271 "bpfc/bpf_parser.tab.c"
    break;

  case 134: /* add: OP_ADD '#' number  */
#line 526 "bpf_parser.y"
                            {
		set_curr_instr(BPF_ALU | BPF_ADD | BPF_K, 0, 0, (yyvsp[0].number)); }
#line 2278 "bpfc/bpf_parser.tab.c"
    break;

  case 135: /* add: OP_ADD 'x'  */
#line 528 "bpf_parser.y"
                     {
		set_curr_instr(BPF_ALU | BPF_ADD | BPF_X, 0, 0, 0); }
#line 2285 "bpfc/bpf_parser.tab.c"
    break;

  case 136: /* add: OP_ADD '%' 'x'  */
#line 530 "bpf_parser.y"
                         {
		set_curr_instr(BPF_ALU | BPF_ADD | BPF_X, 0, 0, 0); }
#line 2292 "bpfc/bpf_parser.tab.c"
    break;

  case 137: /* sub: OP_SUB '#' number  */
#line 535 "bpf_parser.y"
                            {
		set_curr_instr(BPF_ALU | BPF_SUB | BPF_K, 0, 0, (yyvsp[0].number)); }
#line 2299 "bpfc/bpf_parser.tab.c"
    break;

  case 138: /* sub: OP_SUB 'x'  */
#line 537 "bpf_parser.y"
                     {
		set_curr_instr(BPF_ALU | BPF_SUB | BPF_X, 0, 0, 0); }
#line 2306 "bpfc/bpf_parser.tab.c"
    break;

  case 139: /* sub: OP_SUB '%' 'x'  */
#line 539 "bpf_parser.y"
                         {
		set_curr_instr(BPF_ALU | BPF_SUB | BPF_X, 0, 0, 0); }
#line 2313 "bpfc/bpf_parser.tab.c"
    break;

  case 140: /* mul: OP_MUL '#' number  */
#line 544 "bpf_parser.y"
                            {
		set_curr_instr(BPF_ALU | BPF_MUL | BPF_K, 0, 0, (yyvsp[0].number)); }
#line 2320 "bpfc/bpf_parser.tab.c"
    break;

  case 141: /* mul: OP_MUL 'x'  */
#line 546 "bpf_parser.y"
                     {
		set_curr_instr(BPF_ALU | BPF_MUL | BPF_X, 0, 0, 0); }
#line 2327 "bpfc/bpf_parser.tab.c"
    break;

  case 142: /* mul: OP_MUL '%' 'x'  */
#line 548 "bpf_parser.y"
                         {
		set_curr_instr(BPF_ALU | BPF_MUL | BPF_X, 0, 0, 0); }
#line 2334 "bpfc/bpf_parser.tab.c"
    break;

  case 143: /* div: OP_DIV '#' number  */
#line 553 "bpf_parser.y"
                            {
		set_curr_instr(BPF_ALU | BPF_DIV | BPF_K, 0, 0, (yyvsp[0].number)); }
#line 2341 "bpfc/bpf_parser.tab.c"
    break;

  case 144: /* div: OP_DIV 'x'  */
#line 555 "bpf_parser.y"
                     {
		set_curr_instr(BPF_ALU | BPF_DIV | BPF_X, 0, 0, 0); }
#line 2348 "bpfc/bpf_parser.tab.c"
    break;

  case 145: /* div: OP_DIV '%' 'x'  */
#line 557 "bpf_parser.y"
                         {
		set_curr_instr(BPF_ALU | BPF_DIV | BPF_X, 0, 0, 0); }
#line 2355 "bpfc/bpf_parser.tab.c"
    break;

  case 146: /* mod: OP_MOD '#' number  */
#line 562 "bpf_parser.y"
                            {
		set_curr_instr(BPF_ALU | BPF_MOD | BPF_K, 0, 0, (yyvsp[0].number)); }
#line 2362 "bpfc/bpf_parser.tab.c"
    break;

  case 147: /* mod: OP_MOD 'x'  */
#line 564 "bpf_parser.y"
                     {
		set_curr_instr(BPF_ALU | BPF_MOD | BPF_X, 0, 0, 0); }
#line 2369 "bpfc/bpf_parser.tab.c"
    break;

  case 148: /* mod: OP_MOD '%' 'x'  */
#line 566 "bpf_parser.y"
                         {
		set_curr_instr(BPF_ALU | BPF_MOD | BPF_X, 0, 0, 0); }
#line 2376 "bpfc/bpf_parser.tab.c"
    break;

  case 149: /* neg: OP_NEG  */
#line 571 "bpf_parser.y"
                 {
		set_curr_instr(BPF_ALU | BPF_NEG, 0, 0, 0); }
#line 2383 "bpfc/bpf_parser.tab.c"
    break;

  case 150: /* and: OP_AND '#' number  */
#line 576 "bpf_parser.y"
                            {
		set_curr_instr(BPF_ALU | BPF_AND | BPF_K, 0, 0, (yyvsp[0].number)); }
#line 2390 "bpfc/bpf_parser.tab.c"
    break;

  case 151: /* and: OP_AND 'x'  */
#line 578 "bpf_parser.y"
                     {
		set_curr_instr(BPF_ALU | BPF_AND | BPF_X, 0, 0, 0); }
#line 2397 "bpfc/bpf_parser.tab.c"
    break;

  case 152: /* and: OP_AND '%' 'x'  */
#line 580 "bpf_parser.y"
                         {
		set_curr_instr(BPF_ALU | BPF_AND | BPF_X, 0, 0, 0); }
#line 2404 "bpfc/bpf_parser.tab.c"
    break;

  case 153: /* or: OP_OR '#' number  */
#line 585 "bpf_parser.y"
                           {
		set_curr_instr(BPF_ALU | BPF_OR | BPF_K, 0, 0, (yyvsp[0].number)); }
#line 2411 "bpfc/bpf_parser.tab.c"
    break;

  case 154: /* or: OP_OR 'x'  */
#line 587 "bpf_parser.y"
                    {
		set_curr_instr(BPF_ALU | BPF_OR | BPF_X, 0, 0, 0); }
#line 2418 "bpfc/bpf_parser.tab.c"
    break;

  case 155: /* or: OP_OR '%' 'x'  */
#line 589 "bpf_parser.y"
                        {
		set_curr_instr(BPF_ALU | BPF_OR | BPF_X, 0, 0, 0); }
#line 2425 "bpfc/bpf_parser.tab.c"
    break;

  case 156: /* xor: OP_XOR '#' number  */
#line 594 "bpf_parser.y"
                            {
		set_curr_instr(BPF_ALU | BPF_XOR | BPF_K, 0, 0, (yyvsp[0].number)); }
#line 2432 "bpfc/bpf_parser.tab.c"
    break;

  case 157: /* xor: OP_XOR 'x'  */
#line 596 "bpf_parser.y"
                     {
		set_curr_instr(BPF_ALU | BPF_XOR | BPF_X, 0, 0, 0); }
#line 2439 "bpfc/bpf_parser.tab.c"
    break;

  case 158: /* xor: OP_XOR '%' 'x'  */
#line 598 "bpf_parser.y"
                         {
		set_curr_instr(BPF_ALU | BPF_XOR | BPF_X, 0, 0, 0); }
#line 2446 "bpfc/bpf_parser.tab.c"
    break;

  case 159: /* lsh: OP_LSH '#' number  */
#line 603 "bpf_parser.y"
                            {
		set_curr_instr(BPF_ALU | BPF_LSH | BPF_K, 0, 0, (yyvsp[0].number)); }
#line 2453 "bpfc/bpf_parser.tab.c"
    break;

  case 160: /* lsh: OP_LSH 'x'  */
#line 605 "bpf_parser.y"
                     {
		set_curr_instr(BPF_ALU | BPF_LSH | BPF_X, 0, 0, 0); }
#line 2460 "bpfc/bpf_parser.tab.c"
    break;

  case 161: /* lsh: OP_LSH '%' 'x'  */
#line 607 "bpf_parser.y"
                         {
		set_curr_instr(BPF_ALU | BPF_LSH | BPF_X, 0, 0, 0); }
#line 2467 "bpfc/bpf_parser.tab.c"
    break;

  case 162: /* rsh: OP_RSH '#' number  */
#line 612 "bpf_parser.y"
                            {
		set_curr_instr(BPF_ALU | BPF_RSH | BPF_K, 0, 0, (yyvsp[0].number)); }
#line 2474 "bpfc/bpf_parser.tab.c"
    break;

  case 163: /* rsh: OP_RSH 'x'  */
#line 614 "bpf_parser.y"
                     {
		set_curr_instr(BPF_ALU | BPF_RSH | BPF_X, 0, 0, 0); }
#line 2481 "bpfc/bpf_parser.tab.c"
    break;

  case 164: /* rsh: OP_RSH '%' 'x'  */
#line 616 "bpf_parser.y"
                         {
		set_curr_instr(BPF_ALU | BPF_RSH | BPF_X, 0, 0, 0); }
#line 2488 "bpfc/bpf_parser.tab.c"
    break;

  case 165: /* ret: OP_RET 'a'  */
#line 621 "bpf_parser.y"
                     {
		set_curr_instr(BPF_RET | BPF_A, 0, 0, 0); }
#line 2495 "bpfc/bpf_parser.tab.c"
    break;

  case 166: /* ret: OP_RET '%' 'a'  */
#line 623 "bpf_parser.y"
                         {
		set_curr_instr(BPF_RET | BPF_A, 0, 0, 0); }
#line 2502 "bpfc/bpf_parser.tab.c"
    break;

  case 167: /* ret: OP_RET 'x'  */
#line 625 "bpf_parser.y"
                     {
		set_curr_instr(BPF_RET | BPF_X, 0, 0, 0); }
#line 2509 "bpfc/bpf_parser.tab.c"
    break;

  case 168: /* ret: OP_RET '%' 'x'  */
#line 627 "bpf_parser.y"
                         {
		set_curr_instr(BPF_RET | BPF_X, 0, 0, 0); }
#line 2516 "bpfc/bpf_parser.tab.c"
    break;

  case 169: /* ret: OP_RET '#' number  */
#line 629 "bpf_parser.y"
                            {
		set_curr_instr(BPF_RET | BPF_K, 0, 0, (yyvsp[0].number)); }
#line 2523 "bpfc/bpf_parser.tab.c"
    break;

  case 170: /* tax: OP_TAX  */
#line 634 "bpf_parser.y"
                 {
		set_curr_instr(BPF_MISC | BPF_TAX, 0, 0, 0); }
#line 2530 "bpfc/bpf_parser.tab.c"
    break;

  case 171: /* txa: OP_TXA  */
#line 639 "bpf_parser.y"
                 {
		set_curr_instr(BPF_MISC | BPF_TXA, 0, 0, 0); }
#line 2537 "bpfc/bpf_parser.tab.c"
    break;


#line 2541 "bpfc/bpf_parser.tab.c"

      default: break;
    }
  /* User semantic actions sometimes alter yychar, and that requires
     that yytoken be updated with the new translation.  We take the
     approach of translating immediately before every use of yytoken.
     One alternative is translating here after every semantic action,
     but that translation would be missed if the semantic action invokes
     YYABORT, YYACCEPT, or YYERROR immediately after altering yychar or
     if it invokes YYBACKUP.  In the case of YYABORT or YYACCEPT, an
     incorrect destructor might then be invoked immediately.  In the
     case of YYERROR or YYBACKUP, subsequent parser actions might lead
     to an incorrect destructor call or verbose syntax error message
     before the lookahead is translated.  */
  YY_SYMBOL_PRINT ("-> $$ =", YY_CAST (yysymbol_kind_t, yyr1[yyn]), &yyval, &yyloc);

  YYPOPSTACK (yylen);
  yylen = 0;

  *++yyvsp = yyval;

  /* Now 'shift' the result of the reduction.  Determine what state
     that goes to, based on the state we popped back to and the rule
     number reduced by.  */
  {
    const int yylhs = yyr1[yyn] - YYNTOKENS;
    const int yyi = yypgoto[yylhs] + *yyssp;
    yystate = (0 <= yyi && yyi <= YYLAST && yycheck[yyi] == *yyssp
               ? yytable[yyi]
               : yydefgoto[yylhs]);
  }

  goto yynewstate;


/*--------------------------------------.
| yyerrlab -- here on detecting error.  |
`--------------------------------------*/
yyerrlab:
  /* Make sure we have latest lookahead translation.  See comments at
     user semantic actions for why this is necessary.  */
  yytoken = yychar == YYEMPTY ? YYSYMBOL_YYEMPTY : YYTRANSLATE (yychar);
  /* If not already recovering from an error, report this error.  */
  if (!yyerrstatus)
    {
      ++yynerrs;
      yyerror (YY_("syntax error"));
    }

  if (yyerrstatus == 3)
    {
      /* If just tried and failed to reuse lookahead token after an
         error, discard it.  */

      if (yychar <= YYEOF)
        {
          /* Return failure if at end of input.  */
          if (yychar == YYEOF)
            YYABORT;
        }
      else
        {
          yydestruct ("Error: discarding",
                      yytoken, &yylval);
          yychar = YYEMPTY;
        }
    }

  /* Else will try to reuse lookahead token after shifting the error
     token.  */
  goto yyerrlab1;


/*---------------------------------------------------.
| yyerrorlab -- error raised explicitly by YYERROR.  |
`---------------------------------------------------*/
yyerrorlab:
  /* Pacify compilers when the user code never invokes YYERROR and the
     label yyerrorlab therefore never appears in user code.  */
  if (0)
    YYERROR;
  ++yynerrs;

  /* Do not reclaim the symbols of the rule whose action triggered
     this YYERROR.  */
  YYPOPSTACK (yylen);
  yylen = 0;
  YY_STACK_PRINT (yyss, yyssp);
  yystate = *yyssp;
  goto yyerrlab1;


/*-------------------------------------------------------------.
| yyerrlab1 -- common code for both syntax error and YYERROR.  |
`-------------------------------------------------------------*/
yyerrlab1:
  yyerrstatus = 3;      /* Each real token shifted decrements this.  */

  /* Pop stack until we find a state that shifts the error token.  */
  for (;;)
    {
      yyn = yypact[yystate];
      if (!yypact_value_is_default (yyn))
        {
          yyn += YYSYMBOL_YYerror;
          if (0 <= yyn && yyn <= YYLAST && yycheck[yyn] == YYSYMBOL_YYerror)
            {
              yyn = yytable[yyn];
              if (0 < yyn)
                break;
            }
        }

      /* Pop the current state because it cannot handle the error token.  */
      if (yyssp == yyss)
        YYABORT;


      yydestruct ("Error: popping",
                  YY_ACCESSING_SYMBOL (yystate), yyvsp);
      YYPOPSTACK (1);
      yystate = *yyssp;
      YY_STACK_PRINT (yyss, yyssp);
    }

  YY_IGNORE_MAYBE_UNINITIALIZED_BEGIN
  *++yyvsp = yylval;
  YY_IGNORE_MAYBE_UNINITIALIZED_END


  /* Shift the error token.  */
  YY_SYMBOL_PRINT ("Shifting", YY_ACCESSING_SYMBOL (yyn), yyvsp, yylsp);

  yystate = yyn;
  goto yynewstate;


/*-------------------------------------.
| yyacceptlab -- YYACCEPT comes here.  |
`-------------------------------------*/
yyacceptlab:
  yyresult = 0;
  goto yyreturnlab;


/*-----------------------------------.
| yyabortlab -- YYABORT comes here.  |
`-----------------------------------*/
yyabortlab:
  yyresult = 1;
  goto yyreturnlab;


/*-----------------------------------------------------------.
| yyexhaustedlab -- YYNOMEM (memory exhaustion) comes here.  |
`-----------------------------------------------------------*/
yyexhaustedlab:
  yyerror (YY_("memory exhausted"));
  yyresult = 2;
  goto yyreturnlab;


/*----------------------------------------------------------.
| yyreturnlab -- parsing is finished, clean up and return.  |
`----------------------------------------------------------*/
yyreturnlab:
  if (yychar != YYEMPTY)
    {
      /* Make sure we have latest lookahead translation.  See comments at
         user semantic actions for why this is necessary.  */
      yytoken = YYTRANSLATE (yychar);
      yydestruct ("Cleanup: discarding lookahead",
                  yytoken, &yylval);
    }
  /* Do not reclaim the symbols of the rule whose action triggered
     this YYABORT or YYACCEPT.  */
  YYPOPSTACK (yylen);
  YY_STACK_PRINT (yyss, yyssp);
  while (yyssp != yyss)
    {
      yydestruct ("Cleanup: popping",
                  YY_ACCESSING_SYMBOL (+*yyssp), yyvsp);
      YYPOPSTACK (1);
    }
#ifndef yyoverflow
  if (yyss != yyssa)
    YYSTACK_FREE (yyss);
#endif

  return yyresult;
}

#line 643 "bpf_parser.y"


static void stage_1_inline(void)
{
	yyparse();
}

static void stage_2_label_reduce(void)
{
	int i, max = curr_instr, off;

	/* 1. reduce k jumps */
	for (i = 0; i < max; ++i) {
		if (labels_k[i] != NULL) {
			off = find_intr_offset_or_panic(labels_k[i]);
			out[i].k = (uint32_t) (off - i - 1);
		}
	}

	/* 1. reduce jt jumps */
	for (i = 0; i < max; ++i) {
		if (labels_jt[i] != NULL) {
			off = find_intr_offset_or_panic(labels_jt[i]);
			out[i].jt = (uint8_t) (off - i -1);
		}
	}

	/* 1. reduce jf jumps */
	for (i = 0; i < max; ++i) {
		if (labels_jf[i] != NULL) {
			off = find_intr_offset_or_panic(labels_jf[i]);
			out[i].jf = (uint8_t) (off - i - 1);
		}
	}
}

static void pretty_printer_c(const struct sock_fprog *prog)
{
	int i;

	for (i = 0; i < prog->len; ++i) {
		printf("{ 0x%x, %u, %u, 0x%08x },\n",
		       prog->filter[i].code, prog->filter[i].jt,
		       prog->filter[i].jf, prog->filter[i].k);
	}
}

static void pretty_printer_xt_bpf(const struct sock_fprog *prog)
{
	int i;

	printf("%d,", prog->len);
	for (i = 0; i < prog->len; ++i) {
		printf("%u %u %u %u,",
		       prog->filter[i].code, prog->filter[i].jt,
		       prog->filter[i].jf, prog->filter[i].k);
	}

	fflush(stdout);
}

static void pretty_printer_tcpdump(const struct sock_fprog *prog)
{
	int i;

	for (i = 0; i < prog->len; ++i) {
		printf("%u %u %u %u\n",
		       prog->filter[i].code, prog->filter[i].jt,
		       prog->filter[i].jf, prog->filter[i].k);
	}
}

static void pretty_printer(const struct sock_fprog *prog, int format)
{
	switch (format) {
	case 0:
		pretty_printer_c(prog);
		break;
	case 1:
		pretty_printer_xt_bpf(prog);
		break;
	case 2:
		pretty_printer_tcpdump(prog);
		break;
	default:
		bug();
	}
}

int compile_filter(char *file, bool verbose, int bypass, int format,
		   bool invoke_cpp, char *const cpp_argv[])
{
	int i;
	struct sock_fprog res;
	char tmp_file[128];
	int ret = 0;

	memset(tmp_file, 0, sizeof(tmp_file));

	if (invoke_cpp) {
		ret = cpp_exec(file, tmp_file, sizeof(tmp_file), cpp_argv);
		if (ret) {
			fprintf(stderr, "Failed to invoke C preprocessor!\n");
			goto exit;
		}

		file = tmp_file;
	}

	if (!strncmp("-", file, strlen("-")))
		yyin = stdin;
	else
		yyin = fopen(file, "r");
	if (!yyin)
		panic("Cannot open file!\n");

	memset(out, 0, sizeof(out));
	memset(labels, 0, sizeof(labels));
	memset(labels_jf, 0, sizeof(labels_jf));
	memset(labels_jt, 0, sizeof(labels_jt));
	memset(labels_k, 0, sizeof(labels_k));

	stage_1_inline();
	stage_2_label_reduce();

	res.filter = out;
	res.len = curr_instr;

	if (verbose) {
		printf("Generated program:\n");
		bpf_dump_all(&res);
	}

	if (!bypass) {
		if (verbose) {
			printf("Validating: ");
			fflush(stdout);
		}

		if (__bpf_validate(&res) == 0) {
			if (verbose)
				printf("Semantic error! BPF validation failed!\n");
			else {
				printf("Semantic error! BPF validation failed! "
				       "Try -V for debugging output!\n");
				ret = 1;
				goto exit;
			}
		} else if (verbose) {
			printf("is runnable!\n");
		}
	}

	if (verbose)
		printf("Result:\n");

	pretty_printer(&res, format);

	for (i = 0; i < res.len; ++i) {
		free(labels[i]);
		free(labels_jt[i]);
		free(labels_jf[i]);
		free(labels_k[i]);
	}

	if (yyin && yyin != stdin)
		fclose(yyin);

exit:
	if (invoke_cpp)
		unlink(tmp_file);

	return ret;
}

void yyerror(const char *err)
{
	panic("Syntax error at line %d: %s! %s!\n",
	      yylineno, yytext, err);
}
