/* Category.c generated by valac 0.56.18, the Vala compiler
 * generated from Category.vala, do not modify */

/*
 * Copyright 2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib-object.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SLINGSHOT_BACKEND_CATEGORY_0_PROPERTY,
	SLINGSHOT_BACKEND_CATEGORY_NAME_PROPERTY,
	SLINGSHOT_BACKEND_CATEGORY_OTHER_CATEGORY_PROPERTY,
	SLINGSHOT_BACKEND_CATEGORY_APPS_PROPERTY,
	SLINGSHOT_BACKEND_CATEGORY_NUM_PROPERTIES
};
static GParamSpec* slingshot_backend_category_properties[SLINGSHOT_BACKEND_CATEGORY_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

struct _SlingshotBackendCategoryPrivate {
	gchar* _name;
	gboolean _other_category;
	GeeArrayList* _apps;
};

static gint SlingshotBackendCategory_private_offset;
static gpointer slingshot_backend_category_parent_class = NULL;

static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void slingshot_backend_category_set_apps (SlingshotBackendCategory* self,
                                          GeeArrayList* value);
static void slingshot_backend_category_finalize (GObject * obj);
static GType slingshot_backend_category_get_type_once (void);
static void _vala_slingshot_backend_category_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_slingshot_backend_category_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
slingshot_backend_category_get_instance_private (SlingshotBackendCategory* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotBackendCategory_private_offset);
}

SlingshotBackendCategory*
slingshot_backend_category_construct (GType object_type,
                                      const gchar* name,
                                      gboolean other)
{
	SlingshotBackendCategory * self = NULL;
	g_return_val_if_fail (name != NULL, NULL);
	self = (SlingshotBackendCategory*) g_object_new (object_type, "name", name, "other-category", other, NULL);
	return self;
}

SlingshotBackendCategory*
slingshot_backend_category_new (const gchar* name,
                                gboolean other)
{
	return slingshot_backend_category_construct (SLINGSHOT_BACKEND_TYPE_CATEGORY, name, other);
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

gboolean
slingshot_backend_category_add_app_if_matches (SlingshotBackendCategory* self,
                                               GDesktopAppInfo* app)
{
	const gchar* _tmp0_;
	gchar** _tmp1_;
	gint _tmp1__length1;
	gchar* categories = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gboolean found_inclusion_category = FALSE;
	const gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gboolean _tmp29_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (app != NULL, FALSE);
	_tmp0_ = g_app_info_get_id ((GAppInfo*) app);
	_tmp1_ = self->excluded_applications;
	_tmp1__length1 = self->excluded_applications_length1;
	if (_vala_string_array_contains (_tmp1_, _tmp1__length1, _tmp0_)) {
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = g_app_info_get_name ((GAppInfo*) app);
		_tmp3_ = self->priv->_name;
		g_debug ("Category.vala:39: Excluding %s from %s because it's in the excluded ap" \
"plications list", _tmp2_, _tmp3_);
		result = FALSE;
		return result;
	}
	_tmp4_ = g_desktop_app_info_get_categories (app);
	_tmp5_ = g_strdup (_tmp4_);
	categories = _tmp5_;
	_tmp6_ = categories;
	if (_tmp6_ == NULL) {
		gboolean _tmp7_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp7_ = self->priv->_other_category;
		if (_tmp7_) {
			const gchar* _tmp8_;
			GeeArrayList* _tmp9_;
			SlingshotBackendApp* _tmp10_;
			SlingshotBackendApp* _tmp11_;
			_tmp8_ = g_app_info_get_name ((GAppInfo*) app);
			g_debug ("Category.vala:47: Including %s in Other because it has no categories", _tmp8_);
			_tmp9_ = self->priv->_apps;
			_tmp10_ = slingshot_backend_app_new (app);
			_tmp11_ = _tmp10_;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp9_, _tmp11_);
			_g_object_unref0 (_tmp11_);
			result = TRUE;
			_g_free0 (categories);
			return result;
		}
		_tmp12_ = g_app_info_get_name ((GAppInfo*) app);
		_tmp13_ = self->priv->_name;
		g_debug ("Category.vala:52: Excluding %s from %s because it has no categories", _tmp12_, _tmp13_);
		result = FALSE;
		_g_free0 (categories);
		return result;
	}
	found_inclusion_category = FALSE;
	_tmp14_ = categories;
	_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, ";", 0);
	{
		gchar** category_collection = NULL;
		gint category_collection_length1 = 0;
		gint _category_collection_size_ = 0;
		gint category_it = 0;
		category_collection = _tmp16_;
		category_collection_length1 = _vala_array_length (_tmp15_);
		for (category_it = 0; category_it < category_collection_length1; category_it = category_it + 1) {
			const gchar* category = NULL;
			category = category_collection[category_it];
			{
				const gchar* _tmp17_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				const gchar* _tmp22_;
				gchar** _tmp23_;
				gint _tmp23__length1;
				_tmp17_ = category;
				_tmp18_ = self->excluded_categories;
				_tmp18__length1 = self->excluded_categories_length1;
				if (_vala_string_array_contains (_tmp18_, _tmp18__length1, _tmp17_)) {
					const gchar* _tmp19_;
					const gchar* _tmp20_;
					const gchar* _tmp21_;
					_tmp19_ = g_app_info_get_name ((GAppInfo*) app);
					_tmp20_ = self->priv->_name;
					_tmp21_ = category;
					g_debug ("Category.vala:59: Excluding %s from %s because it has an excluded cate" \
"gory (%s)", _tmp19_, _tmp20_, _tmp21_);
					result = FALSE;
					category_collection = (_vala_array_free (category_collection, category_collection_length1, (GDestroyNotify) g_free), NULL);
					_g_free0 (categories);
					return result;
				}
				_tmp22_ = category;
				_tmp23_ = self->included_categories;
				_tmp23__length1 = self->included_categories_length1;
				if (_vala_string_array_contains (_tmp23_, _tmp23__length1, _tmp22_)) {
					found_inclusion_category = TRUE;
				}
			}
		}
		category_collection = (_vala_array_free (category_collection, category_collection_length1, (GDestroyNotify) g_free), NULL);
	}
	if (found_inclusion_category) {
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		GeeArrayList* _tmp26_;
		SlingshotBackendApp* _tmp27_;
		SlingshotBackendApp* _tmp28_;
		_tmp24_ = g_app_info_get_name ((GAppInfo*) app);
		_tmp25_ = self->priv->_name;
		g_debug ("Category.vala:69: Including %s in %s because it has an included catego" \
"ry", _tmp24_, _tmp25_);
		_tmp26_ = self->priv->_apps;
		_tmp27_ = slingshot_backend_app_new (app);
		_tmp28_ = _tmp27_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp26_, _tmp28_);
		_g_object_unref0 (_tmp28_);
		result = TRUE;
		_g_free0 (categories);
		return result;
	}
	_tmp29_ = self->priv->_other_category;
	if (_tmp29_) {
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		GeeArrayList* _tmp32_;
		SlingshotBackendApp* _tmp33_;
		SlingshotBackendApp* _tmp34_;
		_tmp30_ = g_app_info_get_name ((GAppInfo*) app);
		_tmp31_ = self->priv->_name;
		g_debug ("Category.vala:75: Including %s in %s because there wasn't a better mat" \
"ch", _tmp30_, _tmp31_);
		_tmp32_ = self->priv->_apps;
		_tmp33_ = slingshot_backend_app_new (app);
		_tmp34_ = _tmp33_;
		gee_abstract_collection_add ((GeeAbstractCollection*) _tmp32_, _tmp34_);
		_g_object_unref0 (_tmp34_);
		result = TRUE;
		_g_free0 (categories);
		return result;
	}
	_tmp35_ = g_app_info_get_name ((GAppInfo*) app);
	_tmp36_ = self->priv->_name;
	g_debug ("Category.vala:80: Excluded %s from %s because it didn't match any rule" \
"s", _tmp35_, _tmp36_);
	result = FALSE;
	_g_free0 (categories);
	return result;
}

const gchar*
slingshot_backend_category_get_name (SlingshotBackendCategory* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_name;
	result = _tmp0_;
	return result;
}

static void
slingshot_backend_category_set_name (SlingshotBackendCategory* self,
                                     const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_category_get_name (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_name);
		self->priv->_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_category_properties[SLINGSHOT_BACKEND_CATEGORY_NAME_PROPERTY]);
	}
}

gboolean
slingshot_backend_category_get_other_category (SlingshotBackendCategory* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_other_category;
	return result;
}

static void
slingshot_backend_category_set_other_category (SlingshotBackendCategory* self,
                                               gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_category_get_other_category (self);
	if (old_value != value) {
		self->priv->_other_category = value;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_category_properties[SLINGSHOT_BACKEND_CATEGORY_OTHER_CATEGORY_PROPERTY]);
	}
}

GeeArrayList*
slingshot_backend_category_get_apps (SlingshotBackendCategory* self)
{
	GeeArrayList* result;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_apps;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
slingshot_backend_category_set_apps (SlingshotBackendCategory* self,
                                     GeeArrayList* value)
{
	GeeArrayList* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_category_get_apps (self);
	if (old_value != value) {
		GeeArrayList* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_apps);
		self->priv->_apps = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_category_properties[SLINGSHOT_BACKEND_CATEGORY_APPS_PROPERTY]);
	}
}

static void
slingshot_backend_category_class_init (SlingshotBackendCategoryClass * klass,
                                       gpointer klass_data)
{
	slingshot_backend_category_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotBackendCategory_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_backend_category_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_backend_category_set_property;
	G_OBJECT_CLASS (klass)->finalize = slingshot_backend_category_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_CATEGORY_NAME_PROPERTY, slingshot_backend_category_properties[SLINGSHOT_BACKEND_CATEGORY_NAME_PROPERTY] = g_param_spec_string ("name", "name", "name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_CATEGORY_OTHER_CATEGORY_PROPERTY, slingshot_backend_category_properties[SLINGSHOT_BACKEND_CATEGORY_OTHER_CATEGORY_PROPERTY] = g_param_spec_boolean ("other-category", "other-category", "other-category", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_CATEGORY_APPS_PROPERTY, slingshot_backend_category_properties[SLINGSHOT_BACKEND_CATEGORY_APPS_PROPERTY] = g_param_spec_object ("apps", "apps", "apps", GEE_TYPE_ARRAY_LIST, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
slingshot_backend_category_instance_init (SlingshotBackendCategory * self,
                                          gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = slingshot_backend_category_get_instance_private (self);
	_tmp0_ = gee_array_list_new (SLINGSHOT_BACKEND_TYPE_APP, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->priv->_apps = _tmp0_;
}

static void
slingshot_backend_category_finalize (GObject * obj)
{
	SlingshotBackendCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_CATEGORY, SlingshotBackendCategory);
	_g_free0 (self->priv->_name);
	self->included_categories = (_vala_array_free (self->included_categories, self->included_categories_length1, (GDestroyNotify) g_free), NULL);
	self->excluded_categories = (_vala_array_free (self->excluded_categories, self->excluded_categories_length1, (GDestroyNotify) g_free), NULL);
	self->excluded_applications = (_vala_array_free (self->excluded_applications, self->excluded_applications_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->_apps);
	G_OBJECT_CLASS (slingshot_backend_category_parent_class)->finalize (obj);
}

static GType
slingshot_backend_category_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotBackendCategoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_backend_category_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotBackendCategory), 0, (GInstanceInitFunc) slingshot_backend_category_instance_init, NULL };
	GType slingshot_backend_category_type_id;
	slingshot_backend_category_type_id = g_type_register_static (G_TYPE_OBJECT, "SlingshotBackendCategory", &g_define_type_info, 0);
	SlingshotBackendCategory_private_offset = g_type_add_instance_private (slingshot_backend_category_type_id, sizeof (SlingshotBackendCategoryPrivate));
	return slingshot_backend_category_type_id;
}

GType
slingshot_backend_category_get_type (void)
{
	static volatile gsize slingshot_backend_category_type_id__once = 0;
	if (g_once_init_enter (&slingshot_backend_category_type_id__once)) {
		GType slingshot_backend_category_type_id;
		slingshot_backend_category_type_id = slingshot_backend_category_get_type_once ();
		g_once_init_leave (&slingshot_backend_category_type_id__once, slingshot_backend_category_type_id);
	}
	return slingshot_backend_category_type_id__once;
}

static void
_vala_slingshot_backend_category_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	SlingshotBackendCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_CATEGORY, SlingshotBackendCategory);
	switch (property_id) {
		case SLINGSHOT_BACKEND_CATEGORY_NAME_PROPERTY:
		g_value_set_string (value, slingshot_backend_category_get_name (self));
		break;
		case SLINGSHOT_BACKEND_CATEGORY_OTHER_CATEGORY_PROPERTY:
		g_value_set_boolean (value, slingshot_backend_category_get_other_category (self));
		break;
		case SLINGSHOT_BACKEND_CATEGORY_APPS_PROPERTY:
		g_value_set_object (value, slingshot_backend_category_get_apps (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_backend_category_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	SlingshotBackendCategory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_CATEGORY, SlingshotBackendCategory);
	switch (property_id) {
		case SLINGSHOT_BACKEND_CATEGORY_NAME_PROPERTY:
		slingshot_backend_category_set_name (self, g_value_get_string (value));
		break;
		case SLINGSHOT_BACKEND_CATEGORY_OTHER_CATEGORY_PROPERTY:
		slingshot_backend_category_set_other_category (self, g_value_get_boolean (value));
		break;
		case SLINGSHOT_BACKEND_CATEGORY_APPS_PROPERTY:
		slingshot_backend_category_set_apps (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

