/* Dock.c generated by valac 0.56.18, the Vala compiler
 * generated from Dock.vala, do not modify */

/*
 * SPDX-License-Identifier: LGPL-3.0-or-later
 * SPDX-FileCopyrightText: 2023 elementary, Inc. (https://elementary.io)
 */

#include "slingshot.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <glib-object.h>

#define SLINGSHOT_BACKEND_DOCK_DBUS_NAME "io.elementary.dock"
#define SLINGSHOT_BACKEND_DOCK_DBUS_PATH "/io/elementary/dock"
#define SLINGSHOT_BACKEND_DOCK_RECONNECT_TIMEOUT 5000U
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef GDBusProxy DockDBusProxy;
typedef GDBusProxyClass DockDBusProxyClass;
#define _g_free0(var) (var = (g_free (var), NULL))
enum  {
	SLINGSHOT_BACKEND_DOCK_0_PROPERTY,
	SLINGSHOT_BACKEND_DOCK_DBUS_PROPERTY,
	SLINGSHOT_BACKEND_DOCK_NUM_PROPERTIES
};
static GParamSpec* slingshot_backend_dock_properties[SLINGSHOT_BACKEND_DOCK_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _SlingshotBackendDockPrivate {
	DockDBus* _dbus;
};

static gint SlingshotBackendDock_private_offset;
static gpointer slingshot_backend_dock_parent_class = NULL;
static GOnce slingshot_backend_dock_instance;
static GOnce slingshot_backend_dock_instance = G_ONCE_INIT;

static GType dock_dbus_get_type_once (void);
static void dock_dbus_proxy_g_signal (GDBusProxy* proxy,
                               const gchar* sender_name,
                               const gchar* signal_name,
                               GVariant* parameters);
static void dock_dbus_proxy_add_launcher (DockDBus* self,
                                   const gchar* app_id,
                                   GError** error);
static void dock_dbus_proxy_remove_launcher (DockDBus* self,
                                      const gchar* app_id,
                                      GError** error);
static gchar** dock_dbus_proxy_list_launchers (DockDBus* self,
                                        gint* result_length1,
                                        GError** error);
static void dock_dbus_proxy_dock_dbus_interface_init (DockDBusIface* iface);
static void _dbus_dock_dbus_add_launcher (DockDBus* self,
                                   GVariant* _parameters_,
                                   GDBusMethodInvocation* invocation);
static void _dbus_dock_dbus_remove_launcher (DockDBus* self,
                                      GVariant* _parameters_,
                                      GDBusMethodInvocation* invocation);
static void _dbus_dock_dbus_list_launchers (DockDBus* self,
                                     GVariant* _parameters_,
                                     GDBusMethodInvocation* invocation);
static void dock_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                           const gchar* sender,
                                           const gchar* object_path,
                                           const gchar* interface_name,
                                           const gchar* method_name,
                                           GVariant* parameters,
                                           GDBusMethodInvocation* invocation,
                                           gpointer user_data);
static GVariant* dock_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                                 const gchar* sender,
                                                 const gchar* object_path,
                                                 const gchar* interface_name,
                                                 const gchar* property_name,
                                                 GError** error,
                                                 gpointer user_data);
static gboolean dock_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                                const gchar* sender,
                                                const gchar* object_path,
                                                const gchar* interface_name,
                                                const gchar* property_name,
                                                GVariant* value,
                                                GError** error,
                                                gpointer user_data);
static void _dock_dbus_unregister_object (gpointer user_data);
static SlingshotBackendDock* __lambda30_ (void);
static SlingshotBackendDock* slingshot_backend_dock_new (void);
static SlingshotBackendDock* slingshot_backend_dock_construct (GType object_type);
static gpointer ___lambda30__gthread_func (gpointer self);
static void slingshot_backend_dock_try_connect (SlingshotBackendDock* self);
static void __lambda31_ (SlingshotBackendDock* self,
                  GObject* obj,
                  GAsyncResult* res);
static void slingshot_backend_dock_set_dbus (SlingshotBackendDock* self,
                                      DockDBus* value);
static gboolean ___lambda32_ (SlingshotBackendDock* self);
static gboolean ____lambda32__gsource_func (gpointer self);
static void ___lambda31__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void slingshot_backend_dock_name_vanished_callback (SlingshotBackendDock* self,
                                                    GDBusConnection* connection,
                                                    const gchar* name);
static GObject * slingshot_backend_dock_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
static void _slingshot_backend_dock___lambda33_ (SlingshotBackendDock* self);
static void __slingshot_backend_dock___lambda33__gbus_name_appeared_callback (GDBusConnection* connection,
                                                                       const gchar* name,
                                                                       const gchar* name_owner,
                                                                       gpointer self);
static void _slingshot_backend_dock_name_vanished_callback_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                                 const gchar* name,
                                                                                 gpointer self);
static void slingshot_backend_dock_finalize (GObject * obj);
static GType slingshot_backend_dock_get_type_once (void);
static void _vala_slingshot_backend_dock_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_slingshot_backend_dock_set_property (GObject * object,
                                                guint property_id,
                                                const GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);

static const GDBusArgInfo _dock_dbus_dbus_arg_info_add_launcher_app_id = {-1, "app_id", "s", NULL};
static const GDBusArgInfo * const _dock_dbus_dbus_arg_info_add_launcher_in[] = {&_dock_dbus_dbus_arg_info_add_launcher_app_id, NULL};
static const GDBusArgInfo * const _dock_dbus_dbus_arg_info_add_launcher_out[] = {NULL};
static const GDBusMethodInfo _dock_dbus_dbus_method_info_add_launcher = {-1, "AddLauncher", (GDBusArgInfo **) (&_dock_dbus_dbus_arg_info_add_launcher_in), (GDBusArgInfo **) (&_dock_dbus_dbus_arg_info_add_launcher_out), NULL};
static const GDBusArgInfo _dock_dbus_dbus_arg_info_remove_launcher_app_id = {-1, "app_id", "s", NULL};
static const GDBusArgInfo * const _dock_dbus_dbus_arg_info_remove_launcher_in[] = {&_dock_dbus_dbus_arg_info_remove_launcher_app_id, NULL};
static const GDBusArgInfo * const _dock_dbus_dbus_arg_info_remove_launcher_out[] = {NULL};
static const GDBusMethodInfo _dock_dbus_dbus_method_info_remove_launcher = {-1, "RemoveLauncher", (GDBusArgInfo **) (&_dock_dbus_dbus_arg_info_remove_launcher_in), (GDBusArgInfo **) (&_dock_dbus_dbus_arg_info_remove_launcher_out), NULL};
static const GDBusArgInfo _dock_dbus_dbus_arg_info_list_launchers_result = {-1, "result", "as", NULL};
static const GDBusArgInfo * const _dock_dbus_dbus_arg_info_list_launchers_in[] = {NULL};
static const GDBusArgInfo * const _dock_dbus_dbus_arg_info_list_launchers_out[] = {&_dock_dbus_dbus_arg_info_list_launchers_result, NULL};
static const GDBusMethodInfo _dock_dbus_dbus_method_info_list_launchers = {-1, "ListLaunchers", (GDBusArgInfo **) (&_dock_dbus_dbus_arg_info_list_launchers_in), (GDBusArgInfo **) (&_dock_dbus_dbus_arg_info_list_launchers_out), NULL};
static const GDBusMethodInfo * const _dock_dbus_dbus_method_info[] = {&_dock_dbus_dbus_method_info_add_launcher, &_dock_dbus_dbus_method_info_remove_launcher, &_dock_dbus_dbus_method_info_list_launchers, NULL};
static const GDBusSignalInfo * const _dock_dbus_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _dock_dbus_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _dock_dbus_dbus_interface_info = {-1, "io.elementary.dock.items", (GDBusMethodInfo **) (&_dock_dbus_dbus_method_info), (GDBusSignalInfo **) (&_dock_dbus_dbus_signal_info), (GDBusPropertyInfo **) (&_dock_dbus_dbus_property_info), NULL};
static const GDBusInterfaceVTable _dock_dbus_dbus_interface_vtable = {dock_dbus_dbus_interface_method_call, dock_dbus_dbus_interface_get_property, dock_dbus_dbus_interface_set_property};

void
dock_dbus_add_launcher (DockDBus* self,
                        const gchar* app_id,
                        GError** error)
{
	DockDBusIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = DOCK_DBUS_GET_INTERFACE (self);
	if (_iface_->add_launcher) {
		_iface_->add_launcher (self, app_id, error);
	}
}

void
dock_dbus_remove_launcher (DockDBus* self,
                           const gchar* app_id,
                           GError** error)
{
	DockDBusIface* _iface_;
	g_return_if_fail (self != NULL);
	_iface_ = DOCK_DBUS_GET_INTERFACE (self);
	if (_iface_->remove_launcher) {
		_iface_->remove_launcher (self, app_id, error);
	}
}

gchar**
dock_dbus_list_launchers (DockDBus* self,
                          gint* result_length1,
                          GError** error)
{
	DockDBusIface* _iface_;
	g_return_val_if_fail (self != NULL, NULL);
	_iface_ = DOCK_DBUS_GET_INTERFACE (self);
	if (_iface_->list_launchers) {
		return _iface_->list_launchers (self, result_length1, error);
	}
	return NULL;
}

static void
dock_dbus_default_init (DockDBusIface * iface,
                        gpointer iface_data)
{
}

static GType
dock_dbus_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DockDBusIface), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) dock_dbus_default_init, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	GType dock_dbus_type_id;
	dock_dbus_type_id = g_type_register_static (G_TYPE_INTERFACE, "DockDBus", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (dock_dbus_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (dock_dbus_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) dock_dbus_proxy_get_type);
	g_type_set_qdata (dock_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "io.elementary.dock.items");
	g_type_set_qdata (dock_dbus_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_dock_dbus_dbus_interface_info));
	g_type_set_qdata (dock_dbus_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) dock_dbus_register_object);
	return dock_dbus_type_id;
}

GType
dock_dbus_get_type (void)
{
	static volatile gsize dock_dbus_type_id__once = 0;
	if (g_once_init_enter (&dock_dbus_type_id__once)) {
		GType dock_dbus_type_id;
		dock_dbus_type_id = dock_dbus_get_type_once ();
		g_once_init_leave (&dock_dbus_type_id__once, dock_dbus_type_id);
	}
	return dock_dbus_type_id__once;
}

G_DEFINE_TYPE_EXTENDED (DockDBusProxy, dock_dbus_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (TYPE_DOCK_DBUS, dock_dbus_proxy_dock_dbus_interface_init) )
static void
dock_dbus_proxy_class_init (DockDBusProxyClass* klass)
{
	G_DBUS_PROXY_CLASS (klass)->g_signal = dock_dbus_proxy_g_signal;
}

static void
dock_dbus_proxy_g_signal (GDBusProxy* proxy,
                          const gchar* sender_name,
                          const gchar* signal_name,
                          GVariant* parameters)
{
}

static void
dock_dbus_proxy_init (DockDBusProxy* self)
{
	g_dbus_proxy_set_interface_info (G_DBUS_PROXY (self), (GDBusInterfaceInfo *) (&_dock_dbus_dbus_interface_info));
}

static void
dock_dbus_proxy_add_launcher (DockDBus* self,
                              const gchar* app_id,
                              GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "io.elementary.dock.items", "AddLauncher");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static void
dock_dbus_proxy_remove_launcher (DockDBus* self,
                                 const gchar* app_id,
                                 GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "io.elementary.dock.items", "RemoveLauncher");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string (app_id));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}

static gchar**
dock_dbus_proxy_list_launchers (DockDBus* self,
                                gint* result_length1,
                                GError** error)
{
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	GVariant *_reply;
	GVariantIter _reply_iter;
	gchar** _result = NULL;
	gint _result_length1;
	GVariant* _tmp13_;
	gchar** _tmp14_;
	gint _tmp14__length;
	gint _tmp14__size;
	gint _tmp14__length1;
	GVariantIter _tmp15_;
	GVariant* _tmp16_;
	G_DBUS_ERROR;
	G_IO_ERROR;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "io.elementary.dock.items", "ListLaunchers");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return NULL;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return NULL;
	}
	_reply = g_dbus_message_get_body (_reply_message);
	g_variant_iter_init (&_reply_iter, _reply);
	_result_length1 = 0;
	_tmp13_ = g_variant_iter_next_value (&_reply_iter);
	_tmp14_ = g_new (gchar*, 5);
	_tmp14__length = 0;
	_tmp14__size = 4;
	_tmp14__length1 = 0;
	g_variant_iter_init (&_tmp15_, _tmp13_);
	for (; (_tmp16_ = g_variant_iter_next_value (&_tmp15_)) != NULL; _tmp14__length1++) {
		if (_tmp14__size == _tmp14__length) {
			_tmp14__size = 2 * _tmp14__size;
			_tmp14_ = g_renew (gchar*, _tmp14_, _tmp14__size + 1);
		}
		_tmp14_[_tmp14__length++] = g_variant_dup_string (_tmp16_, NULL);
		g_variant_unref (_tmp16_);
	}
	_result_length1 = _tmp14__length1;
	_tmp14_[_tmp14__length] = NULL;
	_result = _tmp14_;
	g_variant_unref (_tmp13_);
	*result_length1 = _result_length1;
	g_object_unref (_reply_message);
	return _result;
}

static void
dock_dbus_proxy_dock_dbus_interface_init (DockDBusIface* iface)
{
	iface->add_launcher = dock_dbus_proxy_add_launcher;
	iface->remove_launcher = dock_dbus_proxy_remove_launcher;
	iface->list_launchers = dock_dbus_proxy_list_launchers;
}

static void
_dbus_dock_dbus_add_launcher (DockDBus* self,
                              GVariant* _parameters_,
                              GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* app_id = NULL;
	GVariant* _tmp17_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp17_ = g_variant_iter_next_value (&_arguments_iter);
	app_id = g_variant_dup_string (_tmp17_, NULL);
	g_variant_unref (_tmp17_);
	dock_dbus_add_launcher (self, app_id, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (app_id);
	;
}

static void
_dbus_dock_dbus_remove_launcher (DockDBus* self,
                                 GVariant* _parameters_,
                                 GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* app_id = NULL;
	GVariant* _tmp18_;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp18_ = g_variant_iter_next_value (&_arguments_iter);
	app_id = g_variant_dup_string (_tmp18_, NULL);
	g_variant_unref (_tmp18_);
	dock_dbus_remove_launcher (self, app_id, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		goto _error;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
	_error:
	_g_free0 (app_id);
	;
}

static void
_dbus_dock_dbus_list_launchers (DockDBus* self,
                                GVariant* _parameters_,
                                GDBusMethodInvocation* invocation)
{
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message = NULL;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gchar** result;
	gint result_length1 = 0;
	gchar** _tmp19_;
	GVariantBuilder _tmp20_;
	gint _tmp21_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	result = dock_dbus_list_launchers (self, &result_length1, &error);
	if (error) {
		g_dbus_method_invocation_take_error (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp19_ = result;
	g_variant_builder_init (&_tmp20_, G_VARIANT_TYPE ("as"));
	for (_tmp21_ = 0; _tmp21_ < result_length1; _tmp21_++) {
		g_variant_builder_add_value (&_tmp20_, g_variant_new_string (*_tmp19_));
		_tmp19_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp20_));
	result = (_vala_array_free (result, result_length1, (GDestroyNotify) g_free), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}

static void
dock_dbus_dbus_interface_method_call (GDBusConnection* connection,
                                      const gchar* sender,
                                      const gchar* object_path,
                                      const gchar* interface_name,
                                      const gchar* method_name,
                                      GVariant* parameters,
                                      GDBusMethodInvocation* invocation,
                                      gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "AddLauncher") == 0) {
		_dbus_dock_dbus_add_launcher (object, parameters, invocation);
	} else if (strcmp (method_name, "RemoveLauncher") == 0) {
		_dbus_dock_dbus_remove_launcher (object, parameters, invocation);
	} else if (strcmp (method_name, "ListLaunchers") == 0) {
		_dbus_dock_dbus_list_launchers (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}

static GVariant*
dock_dbus_dbus_interface_get_property (GDBusConnection* connection,
                                       const gchar* sender,
                                       const gchar* object_path,
                                       const gchar* interface_name,
                                       const gchar* property_name,
                                       GError** error,
                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}

static gboolean
dock_dbus_dbus_interface_set_property (GDBusConnection* connection,
                                       const gchar* sender,
                                       const gchar* object_path,
                                       const gchar* interface_name,
                                       const gchar* property_name,
                                       GVariant* value,
                                       GError** error,
                                       gpointer user_data)
{
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}

guint
dock_dbus_register_object (gpointer object,
                           GDBusConnection* connection,
                           const gchar* path,
                           GError** error)
{
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_dock_dbus_dbus_interface_info), &_dock_dbus_dbus_interface_vtable, data, _dock_dbus_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}

static void
_dock_dbus_unregister_object (gpointer user_data)
{
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}

static inline gpointer
slingshot_backend_dock_get_instance_private (SlingshotBackendDock* self)
{
	return G_STRUCT_MEMBER_P (self, SlingshotBackendDock_private_offset);
}

static SlingshotBackendDock*
__lambda30_ (void)
{
	SlingshotBackendDock* _tmp0_;
	SlingshotBackendDock* result;
	_tmp0_ = slingshot_backend_dock_new ();
	result = _tmp0_;
	return result;
}

static gpointer
___lambda30__gthread_func (gpointer self)
{
	gpointer result;
	result = __lambda30_ ();
	return result;
}

SlingshotBackendDock*
slingshot_backend_dock_get_default (void)
{
	gconstpointer _tmp0_;
	SlingshotBackendDock* result;
	_tmp0_ = g_once (&slingshot_backend_dock_instance, ___lambda30__gthread_func, NULL);
	result = (SlingshotBackendDock*) _tmp0_;
	return result;
}

static SlingshotBackendDock*
slingshot_backend_dock_construct (GType object_type)
{
	SlingshotBackendDock * self = NULL;
	self = (SlingshotBackendDock*) g_object_new (object_type, NULL);
	return self;
}

static SlingshotBackendDock*
slingshot_backend_dock_new (void)
{
	return slingshot_backend_dock_construct (SLINGSHOT_BACKEND_TYPE_DOCK);
}

static gboolean
___lambda32_ (SlingshotBackendDock* self)
{
	gboolean result;
	slingshot_backend_dock_try_connect (self);
	result = FALSE;
	return result;
}

static gboolean
____lambda32__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda32_ ((SlingshotBackendDock*) self);
	return result;
}

static void
__lambda31_ (SlingshotBackendDock* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		DockDBus* _tmp0_ = NULL;
		DockDBus* _tmp1_;
		DockDBus* _tmp2_;
		_tmp1_ = g_async_result_get_source_object (res);
		_tmp2_ = (DockDBus*) g_async_initable_new_finish ((GAsyncInitable *) _tmp1_, res, &_inner_error0_);
		g_object_unref (_tmp1_);
		_tmp0_ = (DockDBus*) _tmp2_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		slingshot_backend_dock_set_dbus (self, _tmp0_);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Dock.vala:41: %s", _tmp4_);
		g_timeout_add_full (G_PRIORITY_DEFAULT, SLINGSHOT_BACKEND_DOCK_RECONNECT_TIMEOUT, ____lambda32__gsource_func, g_object_ref (self), g_object_unref);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda31__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda31_ ((SlingshotBackendDock*) self, source_object, res);
	g_object_unref (self);
}

static void
slingshot_backend_dock_try_connect (SlingshotBackendDock* self)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_async_initable_new_async (TYPE_DOCK_DBUS_PROXY, 0, NULL, ___lambda31__gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", SLINGSHOT_BACKEND_DOCK_DBUS_NAME, "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", SLINGSHOT_BACKEND_DOCK_DBUS_PATH, "g-interface-name", "io.elementary.dock.items", NULL);
}

static void
slingshot_backend_dock_name_vanished_callback (SlingshotBackendDock* self,
                                               GDBusConnection* connection,
                                               const gchar* name)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (connection != NULL);
	g_return_if_fail (name != NULL);
	slingshot_backend_dock_set_dbus (self, NULL);
}

DockDBus*
slingshot_backend_dock_get_dbus (SlingshotBackendDock* self)
{
	DockDBus* result;
	DockDBus* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_dbus;
	result = _tmp0_;
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
slingshot_backend_dock_set_dbus (SlingshotBackendDock* self,
                                 DockDBus* value)
{
	DockDBus* old_value;
	g_return_if_fail (self != NULL);
	old_value = slingshot_backend_dock_get_dbus (self);
	if (old_value != value) {
		DockDBus* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_dbus);
		self->priv->_dbus = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, slingshot_backend_dock_properties[SLINGSHOT_BACKEND_DOCK_DBUS_PROPERTY]);
	}
}

static void
_slingshot_backend_dock___lambda33_ (SlingshotBackendDock* self)
{
	slingshot_backend_dock_try_connect (self);
}

static void
__slingshot_backend_dock___lambda33__gbus_name_appeared_callback (GDBusConnection* connection,
                                                                  const gchar* name,
                                                                  const gchar* name_owner,
                                                                  gpointer self)
{
	_slingshot_backend_dock___lambda33_ ((SlingshotBackendDock*) self);
}

static void
_slingshot_backend_dock_name_vanished_callback_gbus_name_vanished_callback (GDBusConnection* connection,
                                                                            const gchar* name,
                                                                            gpointer self)
{
	slingshot_backend_dock_name_vanished_callback ((SlingshotBackendDock*) self, connection, name);
}

static GObject *
slingshot_backend_dock_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SlingshotBackendDock * self;
	parent_class = G_OBJECT_CLASS (slingshot_backend_dock_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_DOCK, SlingshotBackendDock);
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, SLINGSHOT_BACKEND_DOCK_DBUS_NAME, G_BUS_NAME_WATCHER_FLAGS_AUTO_START, (GClosure*) ((__slingshot_backend_dock___lambda33__gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) __slingshot_backend_dock___lambda33__gbus_name_appeared_callback, g_object_ref (self), (GClosureNotify) g_object_unref)), (GClosure*) ((_slingshot_backend_dock_name_vanished_callback_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _slingshot_backend_dock_name_vanished_callback_gbus_name_vanished_callback, g_object_ref (self), (GClosureNotify) g_object_unref)));
	return obj;
}

static void
slingshot_backend_dock_class_init (SlingshotBackendDockClass * klass,
                                   gpointer klass_data)
{
	slingshot_backend_dock_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SlingshotBackendDock_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_slingshot_backend_dock_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_slingshot_backend_dock_set_property;
	G_OBJECT_CLASS (klass)->constructor = slingshot_backend_dock_constructor;
	G_OBJECT_CLASS (klass)->finalize = slingshot_backend_dock_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SLINGSHOT_BACKEND_DOCK_DBUS_PROPERTY, slingshot_backend_dock_properties[SLINGSHOT_BACKEND_DOCK_DBUS_PROPERTY] = g_param_spec_object ("dbus", "dbus", "dbus", TYPE_DOCK_DBUS, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
slingshot_backend_dock_instance_init (SlingshotBackendDock * self,
                                      gpointer klass)
{
	self->priv = slingshot_backend_dock_get_instance_private (self);
	self->priv->_dbus = NULL;
}

static void
slingshot_backend_dock_finalize (GObject * obj)
{
	SlingshotBackendDock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SLINGSHOT_BACKEND_TYPE_DOCK, SlingshotBackendDock);
	_g_object_unref0 (self->priv->_dbus);
	G_OBJECT_CLASS (slingshot_backend_dock_parent_class)->finalize (obj);
}

static GType
slingshot_backend_dock_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SlingshotBackendDockClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) slingshot_backend_dock_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SlingshotBackendDock), 0, (GInstanceInitFunc) slingshot_backend_dock_instance_init, NULL };
	GType slingshot_backend_dock_type_id;
	slingshot_backend_dock_type_id = g_type_register_static (G_TYPE_OBJECT, "SlingshotBackendDock", &g_define_type_info, 0);
	SlingshotBackendDock_private_offset = g_type_add_instance_private (slingshot_backend_dock_type_id, sizeof (SlingshotBackendDockPrivate));
	return slingshot_backend_dock_type_id;
}

GType
slingshot_backend_dock_get_type (void)
{
	static volatile gsize slingshot_backend_dock_type_id__once = 0;
	if (g_once_init_enter (&slingshot_backend_dock_type_id__once)) {
		GType slingshot_backend_dock_type_id;
		slingshot_backend_dock_type_id = slingshot_backend_dock_get_type_once ();
		g_once_init_leave (&slingshot_backend_dock_type_id__once, slingshot_backend_dock_type_id);
	}
	return slingshot_backend_dock_type_id__once;
}

static void
_vala_slingshot_backend_dock_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SlingshotBackendDock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_DOCK, SlingshotBackendDock);
	switch (property_id) {
		case SLINGSHOT_BACKEND_DOCK_DBUS_PROPERTY:
		g_value_set_object (value, slingshot_backend_dock_get_dbus (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_slingshot_backend_dock_set_property (GObject * object,
                                           guint property_id,
                                           const GValue * value,
                                           GParamSpec * pspec)
{
	SlingshotBackendDock * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SLINGSHOT_BACKEND_TYPE_DOCK, SlingshotBackendDock);
	switch (property_id) {
		case SLINGSHOT_BACKEND_DOCK_DBUS_PROPERTY:
		slingshot_backend_dock_set_dbus (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

