/* CommentToggler.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from CommentToggler.vala, do not modify */

/*-
 * Copyright (c) 2018 elementary LLC. (https://elementary.io)
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: David Hewitt <davidmhewitt@gmail.com>
 */

#include "codecore.h"
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <gobject/gvaluecollector.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

typedef enum  {
	SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_NONE,
	SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_LINE,
	SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_BLOCK
} ScratchCommentTogglerCommentType;

#define SCRATCH_COMMENT_TOGGLER_TYPE_COMMENT_TYPE (scratch_comment_toggler_comment_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_GtkTextIter_free0(var) ((var == NULL) ? NULL : (var = (_vala_GtkTextIter_free (var), NULL)))
typedef struct _ScratchParamSpecCommentToggler ScratchParamSpecCommentToggler;

struct _ScratchParamSpecCommentToggler {
	GParamSpec parent_instance;
};

static gpointer scratch_comment_toggler_parent_class = NULL;

static GType scratch_comment_toggler_comment_type_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
static ScratchCommentTogglerCommentType scratch_comment_toggler_get_comment_tags_for_lang (GtkSourceLanguage* lang,
                                                                                    ScratchCommentTogglerCommentType type,
                                                                                    gchar** start,
                                                                                    gchar** end);
static ScratchCommentTogglerCommentType scratch_comment_toggler_lines_already_commented (GtkSourceBuffer* buffer,
                                                                                  GtkTextIter* start,
                                                                                  GtkTextIter* end,
                                                                                  guint num_lines,
                                                                                  GtkSourceLanguage* lang);
static void scratch_comment_toggler_remove_comments (GtkSourceBuffer* buffer,
                                              GtkTextIter* start,
                                              GtkTextIter* end,
                                              guint num_lines,
                                              ScratchCommentTogglerCommentType type,
                                              const gchar* start_tag,
                                              const gchar* end_tag);
static void _vala_GtkTextIter_free (GtkTextIter* self);
static void scratch_comment_toggler_add_comments (GtkSourceBuffer* buffer,
                                           GtkTextIter* start,
                                           GtkTextIter* end,
                                           guint num_lines,
                                           ScratchCommentTogglerCommentType type,
                                           const gchar* start_tag,
                                           const gchar* end_tag,
                                           gboolean select);
static void scratch_comment_toggler_finalize (ScratchCommentToggler * obj);
static GType scratch_comment_toggler_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

 G_GNUC_NO_INLINE static GType
scratch_comment_toggler_comment_type_get_type_once (void)
{
	static const GEnumValue values[] = {{SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_NONE, "SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_NONE", "none"}, {SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_LINE, "SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_LINE", "line"}, {SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_BLOCK, "SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_BLOCK", "block"}, {0, NULL, NULL}};
	GType scratch_comment_toggler_comment_type_type_id;
	scratch_comment_toggler_comment_type_type_id = g_enum_register_static ("ScratchCommentTogglerCommentType", values);
	return scratch_comment_toggler_comment_type_type_id;
}

static GType
scratch_comment_toggler_comment_type_get_type (void)
{
	static gsize scratch_comment_toggler_comment_type_type_id__once = 0;
	if (g_once_init_enter (&scratch_comment_toggler_comment_type_type_id__once)) {
		GType scratch_comment_toggler_comment_type_type_id;
		scratch_comment_toggler_comment_type_type_id = scratch_comment_toggler_comment_type_get_type_once ();
		g_once_init_leave (&scratch_comment_toggler_comment_type_type_id__once, scratch_comment_toggler_comment_type_type_id);
	}
	return scratch_comment_toggler_comment_type_type_id__once;
}

static ScratchCommentTogglerCommentType
scratch_comment_toggler_get_comment_tags_for_lang (GtkSourceLanguage* lang,
                                                   ScratchCommentTogglerCommentType type,
                                                   gchar** start,
                                                   gchar** end)
{
	gchar* _vala_start = NULL;
	gchar* _vala_end = NULL;
	ScratchCommentTogglerCommentType result;
	g_return_val_if_fail (lang != NULL, 0);
	_g_free0 (_vala_start);
	_vala_start = NULL;
	_g_free0 (_vala_end);
	_vala_end = NULL;
	if (type == SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_BLOCK) {
		const gchar* _tmp0_;
		gchar* _tmp1_;
		const gchar* _tmp2_;
		gchar* _tmp3_;
		gboolean _tmp4_ = FALSE;
		const gchar* _tmp5_;
		_tmp0_ = gtk_source_language_get_metadata (lang, "block-comment-start");
		_tmp1_ = g_strdup (_tmp0_);
		_g_free0 (_vala_start);
		_vala_start = _tmp1_;
		_tmp2_ = gtk_source_language_get_metadata (lang, "block-comment-end");
		_tmp3_ = g_strdup (_tmp2_);
		_g_free0 (_vala_end);
		_vala_end = _tmp3_;
		_tmp5_ = _vala_start;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			_tmp6_ = _vala_end;
			_tmp4_ = _tmp6_ != NULL;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			result = SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_BLOCK;
			if (start) {
				*start = _vala_start;
			} else {
				_g_free0 (_vala_start);
			}
			if (end) {
				*end = _vala_end;
			} else {
				_g_free0 (_vala_end);
			}
			return result;
		} else {
			const gchar* _tmp7_;
			gchar* _tmp8_;
			const gchar* _tmp9_;
			_tmp7_ = gtk_source_language_get_metadata (lang, "line-comment-start");
			_tmp8_ = g_strdup (_tmp7_);
			_g_free0 (_vala_start);
			_vala_start = _tmp8_;
			_tmp9_ = _vala_start;
			if (_tmp9_ != NULL) {
				result = SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_LINE;
				if (start) {
					*start = _vala_start;
				} else {
					_g_free0 (_vala_start);
				}
				if (end) {
					*end = _vala_end;
				} else {
					_g_free0 (_vala_end);
				}
				return result;
			} else {
				result = SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_NONE;
				if (start) {
					*start = _vala_start;
				} else {
					_g_free0 (_vala_start);
				}
				if (end) {
					*end = _vala_end;
				} else {
					_g_free0 (_vala_end);
				}
				return result;
			}
		}
	} else {
		if (type == SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_LINE) {
			const gchar* _tmp10_;
			gchar* _tmp11_;
			const gchar* _tmp12_;
			_tmp10_ = gtk_source_language_get_metadata (lang, "line-comment-start");
			_tmp11_ = g_strdup (_tmp10_);
			_g_free0 (_vala_start);
			_vala_start = _tmp11_;
			_tmp12_ = _vala_start;
			if (_tmp12_ != NULL) {
				result = SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_LINE;
				if (start) {
					*start = _vala_start;
				} else {
					_g_free0 (_vala_start);
				}
				if (end) {
					*end = _vala_end;
				} else {
					_g_free0 (_vala_end);
				}
				return result;
			} else {
				const gchar* _tmp13_;
				gchar* _tmp14_;
				const gchar* _tmp15_;
				gchar* _tmp16_;
				gboolean _tmp17_ = FALSE;
				const gchar* _tmp18_;
				_tmp13_ = gtk_source_language_get_metadata (lang, "block-comment-start");
				_tmp14_ = g_strdup (_tmp13_);
				_g_free0 (_vala_start);
				_vala_start = _tmp14_;
				_tmp15_ = gtk_source_language_get_metadata (lang, "block-comment-end");
				_tmp16_ = g_strdup (_tmp15_);
				_g_free0 (_vala_end);
				_vala_end = _tmp16_;
				_tmp18_ = _vala_start;
				if (_tmp18_ != NULL) {
					const gchar* _tmp19_;
					_tmp19_ = _vala_end;
					_tmp17_ = _tmp19_ != NULL;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					result = SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_BLOCK;
					if (start) {
						*start = _vala_start;
					} else {
						_g_free0 (_vala_start);
					}
					if (end) {
						*end = _vala_end;
					} else {
						_g_free0 (_vala_end);
					}
					return result;
				} else {
					result = SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_NONE;
					if (start) {
						*start = _vala_start;
					} else {
						_g_free0 (_vala_start);
					}
					if (end) {
						*end = _vala_end;
					} else {
						_g_free0 (_vala_end);
					}
					return result;
				}
			}
		}
	}
	result = SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_NONE;
	if (start) {
		*start = _vala_start;
	} else {
		_g_free0 (_vala_start);
	}
	if (end) {
		*end = _vala_end;
	} else {
		_g_free0 (_vala_end);
	}
	return result;
}

gboolean
scratch_comment_toggler_language_has_comments (GtkSourceLanguage* lang)
{
	ScratchCommentTogglerCommentType type = 0;
	gboolean result;
	if (lang == NULL) {
		result = FALSE;
		return result;
	}
	type = scratch_comment_toggler_get_comment_tags_for_lang (lang, SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_LINE, NULL, NULL);
	result = type != SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_NONE;
	return result;
}

static gchar*
string_chomp (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchomp (_result_);
	result = _result_;
	return result;
}

static gchar*
string_chug (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strchug (_result_);
	result = _result_;
	return result;
}

static ScratchCommentTogglerCommentType
scratch_comment_toggler_lines_already_commented (GtkSourceBuffer* buffer,
                                                 GtkTextIter* start,
                                                 GtkTextIter* end,
                                                 guint num_lines,
                                                 GtkSourceLanguage* lang)
{
	gchar* start_tag = NULL;
	gchar* end_tag = NULL;
	ScratchCommentTogglerCommentType type = 0;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	ScratchCommentTogglerCommentType _tmp2_;
	gchar* selection = NULL;
	GtkTextIter _tmp3_;
	GtkTextIter _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp17_ = NULL;
	gchar* _tmp18_ = NULL;
	ScratchCommentTogglerCommentType _tmp19_;
	ScratchCommentTogglerCommentType result;
	g_return_val_if_fail (buffer != NULL, 0);
	g_return_val_if_fail (start != NULL, 0);
	g_return_val_if_fail (end != NULL, 0);
	g_return_val_if_fail (lang != NULL, 0);
	_tmp2_ = scratch_comment_toggler_get_comment_tags_for_lang (lang, SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_BLOCK, &_tmp0_, &_tmp1_);
	_g_free0 (start_tag);
	start_tag = _tmp0_;
	_g_free0 (end_tag);
	end_tag = _tmp1_;
	type = _tmp2_;
	_tmp3_ = *start;
	_tmp4_ = *end;
	_tmp5_ = gtk_text_buffer_get_slice ((GtkTextBuffer*) buffer, &_tmp3_, &_tmp4_, TRUE);
	selection = _tmp5_;
	if (type == SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_BLOCK) {
		gchar* regex_string = NULL;
		gchar* _tmp6_;
		const gchar* _tmp7_;
		const gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		const gchar* _tmp15_;
		const gchar* _tmp16_;
		_tmp6_ = g_strdup ("^\\s*(?:%s)+[\\s\\S]*(?:%s)+$");
		regex_string = _tmp6_;
		_tmp7_ = regex_string;
		_tmp8_ = start_tag;
		_tmp9_ = g_regex_escape_string (_tmp8_, -1);
		_tmp10_ = _tmp9_;
		_tmp11_ = end_tag;
		_tmp12_ = g_regex_escape_string (_tmp11_, -1);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_strdup_printf (_tmp7_, _tmp10_, _tmp13_);
		_g_free0 (regex_string);
		regex_string = _tmp14_;
		_g_free0 (_tmp13_);
		_g_free0 (_tmp10_);
		_tmp15_ = regex_string;
		_tmp16_ = selection;
		if (g_regex_match_simple (_tmp15_, _tmp16_, 0, 0)) {
			result = SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_BLOCK;
			_g_free0 (regex_string);
			_g_free0 (selection);
			_g_free0 (end_tag);
			_g_free0 (start_tag);
			return result;
		}
		_g_free0 (regex_string);
	}
	_tmp19_ = scratch_comment_toggler_get_comment_tags_for_lang (lang, SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_LINE, &_tmp17_, &_tmp18_);
	_g_free0 (start_tag);
	start_tag = _tmp17_;
	_g_free0 (end_tag);
	end_tag = _tmp18_;
	type = _tmp19_;
	if (type == SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_LINE) {
		gchar* regex_string = NULL;
		gchar* _tmp20_;
		const gchar* _tmp21_;
		const gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar** lines = NULL;
		const gchar* _tmp26_;
		gchar** _tmp27_;
		gchar** _tmp28_;
		gint lines_length1;
		gint _lines_size_;
		gchar** _tmp29_;
		gint _tmp29__length1;
		gchar** _tmp30_;
		gint _tmp30__length1;
		_tmp20_ = g_strdup ("^\\s*(?:%s)+.*$");
		regex_string = _tmp20_;
		_tmp21_ = regex_string;
		_tmp22_ = start_tag;
		_tmp23_ = g_regex_escape_string (_tmp22_, -1);
		_tmp24_ = _tmp23_;
		_tmp25_ = g_strdup_printf (_tmp21_, _tmp24_);
		_g_free0 (regex_string);
		regex_string = _tmp25_;
		_g_free0 (_tmp24_);
		_tmp26_ = selection;
		_tmp28_ = _tmp27_ = g_regex_split_simple ("[\\r\\n]", _tmp26_, 0, 0);
		lines = _tmp28_;
		lines_length1 = _vala_array_length (_tmp27_);
		_lines_size_ = lines_length1;
		_tmp29_ = lines;
		_tmp29__length1 = lines_length1;
		if (((guint) _tmp29__length1) != num_lines) {
			g_warning ("CommentToggler.vala:104: Line number mismatch when trying to detect co" \
"mments");
			result = SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_NONE;
			lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
			_g_free0 (regex_string);
			_g_free0 (selection);
			_g_free0 (end_tag);
			_g_free0 (start_tag);
			return result;
		}
		_tmp30_ = lines;
		_tmp30__length1 = lines_length1;
		{
			gchar** line_collection = NULL;
			gint line_collection_length1 = 0;
			gint _line_collection_size_ = 0;
			gint line_it = 0;
			line_collection = _tmp30_;
			line_collection_length1 = _tmp30__length1;
			for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
				gchar* _tmp31_;
				gchar* line = NULL;
				_tmp31_ = g_strdup (line_collection[line_it]);
				line = _tmp31_;
				{
					gboolean empty_line = FALSE;
					const gchar* _tmp32_;
					gchar* _tmp33_;
					gchar* _tmp34_;
					gchar* _tmp35_;
					gchar* _tmp36_;
					gboolean _tmp37_;
					gboolean _tmp38_ = FALSE;
					const gchar* _tmp39_;
					const gchar* _tmp40_;
					_tmp32_ = line;
					_tmp33_ = string_chomp (_tmp32_);
					_tmp34_ = _tmp33_;
					_tmp35_ = string_chug (_tmp34_);
					_tmp36_ = _tmp35_;
					_tmp37_ = g_strcmp0 (_tmp36_, "") == 0;
					_g_free0 (_tmp36_);
					_g_free0 (_tmp34_);
					empty_line = _tmp37_;
					_tmp39_ = regex_string;
					_tmp40_ = line;
					if (!g_regex_match_simple (_tmp39_, _tmp40_, 0, 0)) {
						_tmp38_ = !empty_line;
					} else {
						_tmp38_ = FALSE;
					}
					if (_tmp38_) {
						result = SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_NONE;
						_g_free0 (line);
						lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (regex_string);
						_g_free0 (selection);
						_g_free0 (end_tag);
						_g_free0 (start_tag);
						return result;
					}
					_g_free0 (line);
				}
			}
		}
		result = SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_LINE;
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (regex_string);
		_g_free0 (selection);
		_g_free0 (end_tag);
		_g_free0 (start_tag);
		return result;
	}
	result = SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_NONE;
	_g_free0 (selection);
	_g_free0 (end_tag);
	_g_free0 (start_tag);
	return result;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static void
_vala_GtkTextIter_free (GtkTextIter* self)
{
	g_boxed_free (gtk_text_iter_get_type (), self);
}

static void
scratch_comment_toggler_remove_comments (GtkSourceBuffer* buffer,
                                         GtkTextIter* start,
                                         GtkTextIter* end,
                                         guint num_lines,
                                         ScratchCommentTogglerCommentType type,
                                         const gchar* start_tag,
                                         const gchar* end_tag)
{
	GtkTextMark* imark = NULL;
	GtkTextIter _tmp0_;
	GtkTextMark* _tmp1_;
	GtkTextMark* _tmp2_;
	gint lines_processed = 0;
	GtkTextIter iter = {0};
	GtkTextIter _tmp3_;
	GtkTextIter head_iter = {0};
	GtkTextIter _tmp4_;
	GtkTextMark* _tmp62_;
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) buffer);
	_tmp0_ = *start;
	_tmp1_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) buffer, "iter", &_tmp0_, FALSE);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	imark = _tmp2_;
	lines_processed = 0;
	_tmp3_ = *start;
	iter = _tmp3_;
	_tmp4_ = *start;
	head_iter = _tmp4_;
	while (TRUE) {
		GtkTextMark* _tmp5_;
		GtkTextIter _tmp6_ = {0};
		GtkTextMark* _tmp7_;
		GtkTextIter _tmp8_ = {0};
		GtkTextIter* end_line_iter = NULL;
		GtkTextIter* _tmp9_;
		GtkTextIter* _tmp10_;
		gchar* line_text = NULL;
		GtkTextIter* _tmp11_;
		GtkTextIter _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		const gchar* _tmp17_;
		GtkTextMark* _tmp56_;
		GtkTextIter _tmp57_ = {0};
		gint _tmp58_;
		GtkTextIter _tmp59_;
		GtkTextMark* _tmp60_;
		GtkTextMark* _tmp61_;
		if (!(((guint) lines_processed) < num_lines)) {
			break;
		}
		_tmp5_ = imark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) buffer, &_tmp6_, _tmp5_);
		iter = _tmp6_;
		_tmp7_ = imark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) buffer, &_tmp8_, _tmp7_);
		head_iter = _tmp8_;
		gtk_text_iter_forward_char (&head_iter);
		_tmp9_ = gtk_text_iter_copy (&iter);
		end_line_iter = _tmp9_;
		_tmp10_ = end_line_iter;
		gtk_text_iter_forward_to_line_end (_tmp10_);
		_tmp11_ = end_line_iter;
		_tmp12_ = *_tmp11_;
		_tmp13_ = gtk_text_iter_get_slice (&iter, &_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = string_strip (_tmp14_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		line_text = _tmp16_;
		_tmp17_ = line_text;
		if (g_strcmp0 (_tmp17_, "") != 0) {
			while (TRUE) {
				GtkTextIter _tmp18_;
				GtkTextIter _tmp19_;
				gchar* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				gchar* _tmp23_;
				gboolean _tmp24_;
				if (!(!gtk_text_iter_ends_line (&iter))) {
					break;
				}
				_tmp18_ = iter;
				_tmp19_ = head_iter;
				_tmp20_ = gtk_text_buffer_get_slice ((GtkTextBuffer*) buffer, &_tmp18_, &_tmp19_, TRUE);
				_tmp21_ = _tmp20_;
				_tmp22_ = string_chomp (_tmp21_);
				_tmp23_ = _tmp22_;
				_tmp24_ = g_strcmp0 (_tmp23_, "") != 0;
				_g_free0 (_tmp23_);
				_g_free0 (_tmp21_);
				if (_tmp24_) {
					break;
				}
				gtk_text_iter_forward_char (&iter);
				gtk_text_iter_forward_char (&head_iter);
			}
			if (!gtk_text_iter_ends_line (&iter)) {
				gint _tmp25_;
				gint _tmp26_;
				GtkTextIter _tmp27_;
				GtkTextIter _tmp28_;
				gchar* _tmp29_;
				gchar* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				gboolean _tmp33_;
				_tmp25_ = strlen (start_tag);
				_tmp26_ = _tmp25_;
				gtk_text_iter_forward_chars (&head_iter, _tmp26_);
				_tmp27_ = iter;
				_tmp28_ = head_iter;
				_tmp29_ = gtk_text_buffer_get_slice ((GtkTextBuffer*) buffer, &_tmp27_, &_tmp28_, TRUE);
				_tmp30_ = _tmp29_;
				_tmp31_ = g_strconcat (start_tag, " ", NULL);
				_tmp32_ = _tmp31_;
				_tmp33_ = g_strcmp0 (_tmp30_, _tmp32_) == 0;
				_g_free0 (_tmp32_);
				_g_free0 (_tmp30_);
				if (_tmp33_) {
					gtk_text_buffer_delete ((GtkTextBuffer*) buffer, &iter, &head_iter);
				} else {
					GtkTextIter _tmp34_;
					GtkTextIter _tmp35_;
					gchar* _tmp36_;
					gchar* _tmp37_;
					gboolean _tmp38_;
					gtk_text_iter_backward_char (&head_iter);
					_tmp34_ = iter;
					_tmp35_ = head_iter;
					_tmp36_ = gtk_text_buffer_get_slice ((GtkTextBuffer*) buffer, &_tmp34_, &_tmp35_, TRUE);
					_tmp37_ = _tmp36_;
					_tmp38_ = g_strcmp0 (_tmp37_, start_tag) == 0;
					_g_free0 (_tmp37_);
					if (_tmp38_) {
						gtk_text_buffer_delete ((GtkTextBuffer*) buffer, &iter, &head_iter);
					}
				}
				if (type == SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_BLOCK) {
					GtkTextMark* _tmp39_;
					GtkTextIter _tmp40_ = {0};
					GtkTextIter _tmp41_;
					_tmp39_ = imark;
					gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) buffer, &_tmp40_, _tmp39_);
					iter = _tmp40_;
					gtk_text_iter_forward_to_line_end (&iter);
					_tmp41_ = iter;
					head_iter = _tmp41_;
					gtk_text_iter_backward_char (&head_iter);
					while (TRUE) {
						GtkTextIter _tmp42_;
						GtkTextIter _tmp43_;
						gchar* _tmp44_;
						gchar* _tmp45_;
						gchar* _tmp46_;
						gchar* _tmp47_;
						gboolean _tmp48_;
						if (!(!gtk_text_iter_starts_line (&iter))) {
							break;
						}
						_tmp42_ = head_iter;
						_tmp43_ = iter;
						_tmp44_ = gtk_text_buffer_get_slice ((GtkTextBuffer*) buffer, &_tmp42_, &_tmp43_, TRUE);
						_tmp45_ = _tmp44_;
						_tmp46_ = string_chomp (_tmp45_);
						_tmp47_ = _tmp46_;
						_tmp48_ = g_strcmp0 (_tmp47_, "") != 0;
						_g_free0 (_tmp47_);
						_g_free0 (_tmp45_);
						if (_tmp48_) {
							break;
						}
						gtk_text_iter_backward_char (&iter);
						gtk_text_iter_backward_char (&head_iter);
					}
					if (!gtk_text_iter_starts_line (&iter)) {
						gint _tmp49_;
						gint _tmp50_;
						GtkTextIter _tmp51_;
						GtkTextIter _tmp52_;
						gchar* _tmp53_;
						gchar* _tmp54_;
						gboolean _tmp55_;
						_tmp49_ = strlen (end_tag);
						_tmp50_ = _tmp49_;
						gtk_text_iter_backward_chars (&head_iter, _tmp50_ - 1);
						_tmp51_ = head_iter;
						_tmp52_ = iter;
						_tmp53_ = gtk_text_buffer_get_slice ((GtkTextBuffer*) buffer, &_tmp51_, &_tmp52_, TRUE);
						_tmp54_ = _tmp53_;
						_tmp55_ = g_strcmp0 (_tmp54_, end_tag) == 0;
						_g_free0 (_tmp54_);
						if (_tmp55_) {
							gtk_text_buffer_delete ((GtkTextBuffer*) buffer, &head_iter, &iter);
						}
					}
				}
			}
		}
		_tmp56_ = imark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) buffer, &_tmp57_, _tmp56_);
		iter = _tmp57_;
		gtk_text_iter_forward_line (&iter);
		_tmp58_ = lines_processed;
		lines_processed = _tmp58_ + 1;
		_tmp59_ = iter;
		_tmp60_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) buffer, "iter", &_tmp59_, FALSE);
		_tmp61_ = _g_object_ref0 (_tmp60_);
		_g_object_unref0 (imark);
		imark = _tmp61_;
		_g_free0 (line_text);
		__vala_GtkTextIter_free0 (end_line_iter);
	}
	_tmp62_ = imark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) buffer, _tmp62_);
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) buffer);
	_g_object_unref0 (imark);
}

static void
scratch_comment_toggler_add_comments (GtkSourceBuffer* buffer,
                                      GtkTextIter* start,
                                      GtkTextIter* end,
                                      guint num_lines,
                                      ScratchCommentTogglerCommentType type,
                                      const gchar* start_tag,
                                      const gchar* end_tag,
                                      gboolean select)
{
	GtkTextMark* smark = NULL;
	GtkTextIter _tmp0_;
	GtkTextMark* _tmp1_;
	GtkTextMark* _tmp2_;
	GtkTextMark* imark = NULL;
	GtkTextIter _tmp3_;
	GtkTextMark* _tmp4_;
	GtkTextMark* _tmp5_;
	GtkTextMark* emark = NULL;
	GtkTextIter _tmp6_;
	GtkTextMark* _tmp7_;
	GtkTextMark* _tmp8_;
	GtkTextIter iter = {0};
	GtkTextMark* _tmp9_;
	GtkTextIter _tmp10_ = {0};
	gchar* formatted_start_tag = NULL;
	gchar* _tmp11_;
	gint min_indent = 0;
	GtkTextMark* _tmp31_;
	GtkTextIter _tmp32_ = {0};
	GtkTextMark* _tmp33_;
	GtkTextIter _tmp34_;
	GtkTextMark* _tmp35_;
	GtkTextMark* _tmp36_;
	GtkTextMark* _tmp61_;
	GtkTextMark* _tmp62_;
	GtkTextMark* _tmp63_;
	g_return_if_fail (buffer != NULL);
	g_return_if_fail (start != NULL);
	g_return_if_fail (end != NULL);
	gtk_text_buffer_begin_user_action ((GtkTextBuffer*) buffer);
	_tmp0_ = *start;
	_tmp1_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) buffer, "start", &_tmp0_, FALSE);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	smark = _tmp2_;
	_tmp3_ = *start;
	_tmp4_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) buffer, "iter", &_tmp3_, FALSE);
	_tmp5_ = _g_object_ref0 (_tmp4_);
	imark = _tmp5_;
	_tmp6_ = *end;
	_tmp7_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) buffer, "end", &_tmp6_, FALSE);
	_tmp8_ = _g_object_ref0 (_tmp7_);
	emark = _tmp8_;
	_tmp9_ = imark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) buffer, &_tmp10_, _tmp9_);
	iter = _tmp10_;
	_tmp11_ = g_strdup (start_tag);
	formatted_start_tag = _tmp11_;
	if (type == SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_LINE) {
		const gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp12_ = formatted_start_tag;
		_tmp13_ = g_strconcat (_tmp12_, " ", NULL);
		_g_free0 (formatted_start_tag);
		formatted_start_tag = _tmp13_;
	}
	min_indent = G_MAXINT;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp14_ = FALSE;
			_tmp14_ = TRUE;
			while (TRUE) {
				gint cur_indent = 0;
				GtkTextMark* _tmp25_;
				GtkTextIter _tmp26_ = {0};
				GtkTextMark* _tmp27_;
				GtkTextIter _tmp28_;
				GtkTextMark* _tmp29_;
				GtkTextMark* _tmp30_;
				if (!_tmp14_) {
					gint _tmp15_;
					_tmp15_ = i;
					i = _tmp15_ + 1;
				}
				_tmp14_ = FALSE;
				if (!(((guint) i) < num_lines)) {
					break;
				}
				cur_indent = 0;
				if (!gtk_text_iter_ends_line (&iter)) {
					GtkTextIter head_iter = {0};
					GtkTextIter _tmp16_;
					_tmp16_ = iter;
					head_iter = _tmp16_;
					gtk_text_iter_forward_char (&head_iter);
					while (TRUE) {
						GtkTextIter _tmp17_;
						GtkTextIter _tmp18_;
						gchar* _tmp19_;
						gchar* _tmp20_;
						gchar* _tmp21_;
						gchar* _tmp22_;
						gboolean _tmp23_;
						gint _tmp24_;
						_tmp17_ = iter;
						_tmp18_ = head_iter;
						_tmp19_ = gtk_text_buffer_get_slice ((GtkTextBuffer*) buffer, &_tmp17_, &_tmp18_, TRUE);
						_tmp20_ = _tmp19_;
						_tmp21_ = string_chomp (_tmp20_);
						_tmp22_ = _tmp21_;
						_tmp23_ = !(g_strcmp0 (_tmp22_, "") == 0);
						_g_free0 (_tmp22_);
						_g_free0 (_tmp20_);
						if (_tmp23_) {
							break;
						}
						_tmp24_ = cur_indent;
						cur_indent = _tmp24_ + 1;
						if (cur_indent > min_indent) {
							break;
						}
						gtk_text_iter_forward_char (&iter);
						gtk_text_iter_forward_char (&head_iter);
					}
					if (cur_indent < min_indent) {
						min_indent = cur_indent;
					}
				}
				_tmp25_ = imark;
				gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) buffer, &_tmp26_, _tmp25_);
				iter = _tmp26_;
				gtk_text_iter_forward_line (&iter);
				_tmp27_ = imark;
				gtk_text_buffer_delete_mark ((GtkTextBuffer*) buffer, _tmp27_);
				_tmp28_ = iter;
				_tmp29_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) buffer, "iter", &_tmp28_, FALSE);
				_tmp30_ = _g_object_ref0 (_tmp29_);
				_g_object_unref0 (imark);
				imark = _tmp30_;
			}
		}
	}
	_tmp31_ = smark;
	gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) buffer, &_tmp32_, _tmp31_);
	iter = _tmp32_;
	_tmp33_ = imark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) buffer, _tmp33_);
	_tmp34_ = iter;
	_tmp35_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) buffer, "iter", &_tmp34_, FALSE);
	_tmp36_ = _g_object_ref0 (_tmp35_);
	_g_object_unref0 (imark);
	imark = _tmp36_;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp37_ = FALSE;
			_tmp37_ = TRUE;
			while (TRUE) {
				GtkTextMark* _tmp49_;
				GtkTextIter _tmp50_ = {0};
				GtkTextMark* _tmp51_;
				GtkTextIter _tmp52_;
				GtkTextMark* _tmp53_;
				GtkTextMark* _tmp54_;
				if (!_tmp37_) {
					gint _tmp38_;
					_tmp38_ = i;
					i = _tmp38_ + 1;
				}
				_tmp37_ = FALSE;
				if (!(((guint) i) < num_lines)) {
					break;
				}
				if (!gtk_text_iter_ends_line (&iter)) {
					GtkTextIter* copy_iter = NULL;
					GtkTextIter* _tmp39_;
					GtkTextIter* _tmp40_;
					gchar* line_text = NULL;
					GtkTextIter* _tmp41_;
					GtkTextIter _tmp42_;
					gchar* _tmp43_;
					gchar* _tmp44_;
					gchar* _tmp45_;
					gchar* _tmp46_;
					const gchar* _tmp47_;
					_tmp39_ = gtk_text_iter_copy (&iter);
					copy_iter = _tmp39_;
					_tmp40_ = copy_iter;
					gtk_text_iter_forward_to_line_end (_tmp40_);
					_tmp41_ = copy_iter;
					_tmp42_ = *_tmp41_;
					_tmp43_ = gtk_text_iter_get_slice (&iter, &_tmp42_);
					_tmp44_ = _tmp43_;
					_tmp45_ = string_strip (_tmp44_);
					_tmp46_ = _tmp45_;
					_g_free0 (_tmp44_);
					line_text = _tmp46_;
					_tmp47_ = line_text;
					if (g_strcmp0 (_tmp47_, "") != 0) {
						const gchar* _tmp48_;
						gtk_text_iter_forward_chars (&iter, min_indent);
						_tmp48_ = formatted_start_tag;
						gtk_text_buffer_insert ((GtkTextBuffer*) buffer, &iter, _tmp48_, -1);
						if (type == SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_BLOCK) {
							gtk_text_iter_forward_to_line_end (&iter);
							gtk_text_buffer_insert ((GtkTextBuffer*) buffer, &iter, end_tag, -1);
						}
					}
					_g_free0 (line_text);
					__vala_GtkTextIter_free0 (copy_iter);
				}
				_tmp49_ = imark;
				gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) buffer, &_tmp50_, _tmp49_);
				iter = _tmp50_;
				gtk_text_iter_forward_line (&iter);
				_tmp51_ = imark;
				gtk_text_buffer_delete_mark ((GtkTextBuffer*) buffer, _tmp51_);
				_tmp52_ = iter;
				_tmp53_ = gtk_text_buffer_create_mark ((GtkTextBuffer*) buffer, "iter", &_tmp52_, FALSE);
				_tmp54_ = _g_object_ref0 (_tmp53_);
				_g_object_unref0 (imark);
				imark = _tmp54_;
			}
		}
	}
	if (select) {
		GtkTextIter new_start = {0};
		GtkTextIter new_end = {0};
		GtkTextMark* _tmp55_;
		GtkTextIter _tmp56_ = {0};
		GtkTextMark* _tmp57_;
		GtkTextIter _tmp58_ = {0};
		GtkTextIter _tmp59_;
		GtkTextIter _tmp60_;
		_tmp55_ = smark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) buffer, &_tmp56_, _tmp55_);
		new_start = _tmp56_;
		_tmp57_ = emark;
		gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) buffer, &_tmp58_, _tmp57_);
		new_end = _tmp58_;
		if (!gtk_text_iter_starts_line (&new_start)) {
			gtk_text_iter_set_line_offset (&new_start, 0);
		}
		_tmp59_ = new_start;
		_tmp60_ = new_end;
		gtk_text_buffer_select_range ((GtkTextBuffer*) buffer, &_tmp59_, &_tmp60_);
	}
	gtk_text_buffer_end_user_action ((GtkTextBuffer*) buffer);
	_tmp61_ = imark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) buffer, _tmp61_);
	_tmp62_ = smark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) buffer, _tmp62_);
	_tmp63_ = emark;
	gtk_text_buffer_delete_mark ((GtkTextBuffer*) buffer, _tmp63_);
	_g_free0 (formatted_start_tag);
	_g_object_unref0 (emark);
	_g_object_unref0 (imark);
	_g_object_unref0 (smark);
}

void
scratch_comment_toggler_toggle_comment (GtkSourceBuffer* buffer)
{
	if (buffer != NULL) {
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		gboolean sel = FALSE;
		GtkTextIter _tmp0_ = {0};
		GtkTextIter _tmp1_ = {0};
		gboolean _tmp2_;
		gint num_lines = 0;
		gchar* start_tag = NULL;
		gchar* end_tag = NULL;
		GtkSourceLanguage* lang = NULL;
		GtkSourceLanguage* _tmp6_;
		GtkSourceLanguage* _tmp7_;
		ScratchCommentTogglerCommentType lines_commented = 0;
		GtkTextIter _tmp8_;
		GtkTextIter _tmp9_;
		GtkSourceLanguage* _tmp10_;
		_tmp2_ = gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) buffer, &_tmp0_, &_tmp1_);
		start = _tmp0_;
		end = _tmp1_;
		sel = _tmp2_;
		num_lines = 0;
		if (!sel) {
			GtkTextMark* _tmp3_;
			GtkTextIter _tmp4_ = {0};
			GtkTextIter _tmp5_;
			_tmp3_ = gtk_text_buffer_get_insert ((GtkTextBuffer*) buffer);
			gtk_text_buffer_get_iter_at_mark ((GtkTextBuffer*) buffer, &_tmp4_, _tmp3_);
			start = _tmp4_;
			gtk_text_iter_set_line_offset (&start, 0);
			_tmp5_ = start;
			end = _tmp5_;
			gtk_text_iter_forward_to_line_end (&end);
			num_lines = 1;
		} else {
			gtk_text_iter_set_line_offset (&start, 0);
			if (gtk_text_iter_starts_line (&end)) {
				gtk_text_iter_backward_char (&end);
			} else {
				if (!gtk_text_iter_ends_line (&end)) {
					gtk_text_iter_forward_to_line_end (&end);
				}
			}
			num_lines = (gtk_text_iter_get_line (&end) - gtk_text_iter_get_line (&start)) + 1;
		}
		_tmp6_ = gtk_source_buffer_get_language (buffer);
		_tmp7_ = _g_object_ref0 (_tmp6_);
		lang = _tmp7_;
		_tmp8_ = start;
		_tmp9_ = end;
		_tmp10_ = lang;
		lines_commented = scratch_comment_toggler_lines_already_commented (buffer, &_tmp8_, &_tmp9_, (guint) num_lines, _tmp10_);
		if (lines_commented != SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_NONE) {
			ScratchCommentTogglerCommentType existing_comment_tags = 0;
			GtkSourceLanguage* _tmp11_;
			gchar* _tmp12_ = NULL;
			gchar* _tmp13_ = NULL;
			ScratchCommentTogglerCommentType _tmp14_;
			_tmp11_ = lang;
			_tmp14_ = scratch_comment_toggler_get_comment_tags_for_lang (_tmp11_, lines_commented, &_tmp12_, &_tmp13_);
			_g_free0 (start_tag);
			start_tag = _tmp12_;
			_g_free0 (end_tag);
			end_tag = _tmp13_;
			existing_comment_tags = _tmp14_;
			if (lines_commented == existing_comment_tags) {
				GtkTextIter _tmp15_;
				GtkTextIter _tmp16_;
				const gchar* _tmp17_;
				const gchar* _tmp18_;
				_tmp15_ = start;
				_tmp16_ = end;
				_tmp17_ = start_tag;
				_tmp18_ = end_tag;
				scratch_comment_toggler_remove_comments (buffer, &_tmp15_, &_tmp16_, (guint) num_lines, lines_commented, _tmp17_, _tmp18_);
			}
		} else {
			ScratchCommentTogglerCommentType type = 0;
			GtkSourceLanguage* _tmp19_;
			gchar* _tmp20_ = NULL;
			gchar* _tmp21_ = NULL;
			ScratchCommentTogglerCommentType _tmp22_;
			_tmp19_ = lang;
			_tmp22_ = scratch_comment_toggler_get_comment_tags_for_lang (_tmp19_, SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_LINE, &_tmp20_, &_tmp21_);
			_g_free0 (start_tag);
			start_tag = _tmp20_;
			_g_free0 (end_tag);
			end_tag = _tmp21_;
			type = _tmp22_;
			if (type != SCRATCH_COMMENT_TOGGLER_COMMENT_TYPE_NONE) {
				GtkTextIter _tmp23_;
				GtkTextIter _tmp24_;
				const gchar* _tmp25_;
				const gchar* _tmp26_;
				_tmp23_ = start;
				_tmp24_ = end;
				_tmp25_ = start_tag;
				_tmp26_ = end_tag;
				scratch_comment_toggler_add_comments (buffer, &_tmp23_, &_tmp24_, (guint) num_lines, type, _tmp25_, _tmp26_, sel);
			}
		}
		_g_object_unref0 (lang);
		_g_free0 (end_tag);
		_g_free0 (start_tag);
	}
}

ScratchCommentToggler*
scratch_comment_toggler_construct (GType object_type)
{
	ScratchCommentToggler* self = NULL;
	self = (ScratchCommentToggler*) g_type_create_instance (object_type);
	return self;
}

ScratchCommentToggler*
scratch_comment_toggler_new (void)
{
	return scratch_comment_toggler_construct (SCRATCH_TYPE_COMMENT_TOGGLER);
}

static void
scratch_value_comment_toggler_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
scratch_value_comment_toggler_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		scratch_comment_toggler_unref (value->data[0].v_pointer);
	}
}

static void
scratch_value_comment_toggler_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = scratch_comment_toggler_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
scratch_value_comment_toggler_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
scratch_value_comment_toggler_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ScratchCommentToggler * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = scratch_comment_toggler_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
scratch_value_comment_toggler_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	ScratchCommentToggler ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = scratch_comment_toggler_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
scratch_param_spec_comment_toggler (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	ScratchParamSpecCommentToggler* spec;
	g_return_val_if_fail (g_type_is_a (object_type, SCRATCH_TYPE_COMMENT_TOGGLER), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
scratch_value_get_comment_toggler (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SCRATCH_TYPE_COMMENT_TOGGLER), NULL);
	return value->data[0].v_pointer;
}

void
scratch_value_set_comment_toggler (GValue* value,
                                   gpointer v_object)
{
	ScratchCommentToggler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SCRATCH_TYPE_COMMENT_TOGGLER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SCRATCH_TYPE_COMMENT_TOGGLER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		scratch_comment_toggler_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scratch_comment_toggler_unref (old);
	}
}

void
scratch_value_take_comment_toggler (GValue* value,
                                    gpointer v_object)
{
	ScratchCommentToggler * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, SCRATCH_TYPE_COMMENT_TOGGLER));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, SCRATCH_TYPE_COMMENT_TOGGLER));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		scratch_comment_toggler_unref (old);
	}
}

static void
scratch_comment_toggler_class_init (ScratchCommentTogglerClass * klass,
                                    gpointer klass_data)
{
	scratch_comment_toggler_parent_class = g_type_class_peek_parent (klass);
	((ScratchCommentTogglerClass *) klass)->finalize = scratch_comment_toggler_finalize;
}

static void
scratch_comment_toggler_instance_init (ScratchCommentToggler * self,
                                       gpointer klass)
{
	self->ref_count = 1;
}

static void
scratch_comment_toggler_finalize (ScratchCommentToggler * obj)
{
	ScratchCommentToggler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_TYPE_COMMENT_TOGGLER, ScratchCommentToggler);
	g_signal_handlers_destroy (self);
}

 G_GNUC_NO_INLINE static GType
scratch_comment_toggler_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { scratch_value_comment_toggler_init, scratch_value_comment_toggler_free_value, scratch_value_comment_toggler_copy_value, scratch_value_comment_toggler_peek_pointer, "p", scratch_value_comment_toggler_collect_value, "p", scratch_value_comment_toggler_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ScratchCommentTogglerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_comment_toggler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchCommentToggler), 0, (GInstanceInitFunc) scratch_comment_toggler_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType scratch_comment_toggler_type_id;
	scratch_comment_toggler_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ScratchCommentToggler", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return scratch_comment_toggler_type_id;
}

GType
scratch_comment_toggler_get_type (void)
{
	static gsize scratch_comment_toggler_type_id__once = 0;
	if (g_once_init_enter (&scratch_comment_toggler_type_id__once)) {
		GType scratch_comment_toggler_type_id;
		scratch_comment_toggler_type_id = scratch_comment_toggler_get_type_once ();
		g_once_init_leave (&scratch_comment_toggler_type_id__once, scratch_comment_toggler_type_id);
	}
	return scratch_comment_toggler_type_id__once;
}

gpointer
scratch_comment_toggler_ref (gpointer instance)
{
	ScratchCommentToggler * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
scratch_comment_toggler_unref (gpointer instance)
{
	ScratchCommentToggler * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		SCRATCH_COMMENT_TOGGLER_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

