/* HeaderBar.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from HeaderBar.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-3.0-or-later
 * SPDX-FileCopyrightText: 2017–2023 elementary, Inc. <https://elementary.io>
 *                         2013 Mario Guerriero <mefrio.g@gmail.com>
 */

#include "codecore.h"
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <granite.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <handy.h>

#define SCRATCH_HEADER_BAR_STYLE_SCHEME_HIGH_CONTRAST "classic"
#define SCRATCH_HEADER_BAR_STYLE_SCHEME_LIGHT "elementary-light"
#define SCRATCH_HEADER_BAR_STYLE_SCHEME_DARK "elementary-dark"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	SCRATCH_HEADER_BAR_0_PROPERTY,
	SCRATCH_HEADER_BAR_TEMPLATES_BUTTON_PROPERTY,
	SCRATCH_HEADER_BAR_FIND_BUTTON_PROPERTY,
	SCRATCH_HEADER_BAR_OUTLINE_BUTTON_PROPERTY,
	SCRATCH_HEADER_BAR_SIDEBAR_BUTTON_PROPERTY,
	SCRATCH_HEADER_BAR_TERMINAL_BUTTON_PROPERTY,
	SCRATCH_HEADER_BAR_NUM_PROPERTIES
};
static GParamSpec* scratch_header_bar_properties[SCRATCH_HEADER_BAR_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block46Data Block46Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _ScratchHeaderBarPrivate {
	GtkButton* _templates_button;
	GtkToggleButton* _find_button;
	GtkToggleButton* _outline_button;
	GtkToggleButton* _sidebar_button;
	GtkToggleButton* _terminal_button;
};

struct _Block46Data {
	int _ref_count_;
	ScratchHeaderBar* self;
	GtkApplication* app_instance;
	GtkButton* save_button;
	GtkButton* zoom_default_button;
	GtkSettings* gtk_settings;
};

static gint ScratchHeaderBar_private_offset;
static gpointer scratch_header_bar_parent_class = NULL;

static void scratch_header_bar_style_color_button (ScratchHeaderBar* self,
                                            GtkWidget* color_button,
                                            const gchar* style_id);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      gssize stack_length,
                                      const gchar* needle);
static void scratch_header_bar_on_share_menu_changed (ScratchHeaderBar* self);
static void scratch_header_bar_set_templates_button (ScratchHeaderBar* self,
                                              GtkButton* value);
static void scratch_header_bar_set_find_button (ScratchHeaderBar* self,
                                         GtkToggleButton* value);
static void scratch_header_bar_set_outline_button (ScratchHeaderBar* self,
                                            GtkToggleButton* value);
static void scratch_header_bar_set_sidebar_button (ScratchHeaderBar* self,
                                            GtkToggleButton* value);
static void scratch_header_bar_set_terminal_button (ScratchHeaderBar* self,
                                             GtkToggleButton* value);
static GObject * scratch_header_bar_constructor (GType type,
                                          guint n_construct_properties,
                                          GObjectConstructParam * construct_properties);
static Block46Data* block46_data_ref (Block46Data* _data46_);
static void block46_data_unref (void * _userdata_);
static void _scratch_header_bar_on_share_menu_changed_g_menu_model_items_changed (GMenuModel* _sender,
                                                                           gint position,
                                                                           gint removed,
                                                                           gint added,
                                                                           gpointer self);
static void _scratch_header_bar___lambda60_ (Block46Data* _data46_);
static void __scratch_header_bar___lambda60__gtk_widget_realize (GtkWidget* _sender,
                                                          gpointer self);
static void _scratch_header_bar___lambda61_ (Block46Data* _data46_);
static void __scratch_header_bar___lambda61__g_settings_changed (GSettings* _sender,
                                                          const gchar* key,
                                                          gpointer self);
static void _scratch_header_bar___lambda62_ (Block46Data* _data46_);
static void __scratch_header_bar___lambda62__g_settings_changed (GSettings* _sender,
                                                          const gchar* key,
                                                          gpointer self);
static void _scratch_header_bar___lambda63_ (Block46Data* _data46_);
static void __scratch_header_bar___lambda63__gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static void _scratch_header_bar___lambda64_ (Block46Data* _data46_);
static void __scratch_header_bar___lambda64__gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static void _scratch_header_bar___lambda65_ (Block46Data* _data46_);
static void __scratch_header_bar___lambda65__gtk_button_clicked (GtkButton* _sender,
                                                          gpointer self);
static void scratch_header_bar_finalize (GObject * obj);
static GType scratch_header_bar_get_type_once (void);
static void _vala_scratch_header_bar_get_property (GObject * object,
                                            guint property_id,
                                            GValue * value,
                                            GParamSpec * pspec);
static void _vala_scratch_header_bar_set_property (GObject * object,
                                            guint property_id,
                                            const GValue * value,
                                            GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static inline gpointer
scratch_header_bar_get_instance_private (ScratchHeaderBar* self)
{
	return G_STRUCT_MEMBER_P (self, ScratchHeaderBar_private_offset);
}

ScratchHeaderBar*
scratch_header_bar_construct (GType object_type)
{
	ScratchHeaderBar * self = NULL;
	self = (ScratchHeaderBar*) g_object_new (object_type, "has-subtitle", FALSE, "show-close-button", TRUE, NULL);
	return self;
}

ScratchHeaderBar*
scratch_header_bar_new (void)
{
	return scratch_header_bar_construct (SCRATCH_TYPE_HEADER_BAR);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static gboolean
_vala_string_array_contains (gchar* * stack,
                             gssize stack_length,
                             const gchar* needle)
{
	gssize i;
	for (i = 0; i < stack_length; i++) {
		if (g_strcmp0 (stack[i], needle) == 0) {
			return TRUE;
		}
	}
	return FALSE;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
scratch_header_bar_style_color_button (ScratchHeaderBar* self,
                                       GtkWidget* color_button,
                                       const gchar* style_id)
{
	gchar* background = NULL;
	gchar* _tmp0_;
	gchar* foreground = NULL;
	gchar* _tmp1_;
	GtkSourceStyleSchemeManager* sssm = NULL;
	GtkSourceStyleSchemeManager* _tmp2_;
	GtkSourceStyleSchemeManager* _tmp3_;
	GtkSourceStyleSchemeManager* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* style_css = NULL;
	const gchar* _tmp40_;
	const gchar* _tmp41_;
	gchar* _tmp42_;
	GtkCssProvider* css_provider = NULL;
	GtkCssProvider* _tmp43_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp46_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (color_button != NULL);
	g_return_if_fail (style_id != NULL);
	_tmp0_ = g_strdup ("#FFF");
	background = _tmp0_;
	_tmp1_ = g_strdup ("#333");
	foreground = _tmp1_;
	_tmp2_ = gtk_source_style_scheme_manager_get_default ();
	_tmp3_ = _g_object_ref0 (_tmp2_);
	sssm = _tmp3_;
	_tmp4_ = sssm;
	_tmp5_ = gtk_source_style_scheme_manager_get_scheme_ids (_tmp4_);
	_tmp5__length1 = _vala_array_length (_tmp5_);
	_tmp6_ = _tmp5_;
	_tmp6__length1 = _tmp5__length1;
	if (_vala_string_array_contains (_tmp6_, _tmp6__length1, style_id)) {
		GtkSourceStyleScheme* scheme = NULL;
		GtkSourceStyleSchemeManager* _tmp7_;
		GtkSourceStyleScheme* _tmp8_;
		GtkSourceStyleScheme* _tmp9_;
		GtkSourceStyleScheme* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		GtkSourceStyle* background_style = NULL;
		GtkSourceStyleScheme* _tmp13_;
		GtkSourceStyle* _tmp14_;
		GtkSourceStyle* _tmp15_;
		GtkSourceStyle* foreground_style = NULL;
		GtkSourceStyleScheme* _tmp16_;
		GtkSourceStyle* _tmp17_;
		GtkSourceStyle* _tmp18_;
		gboolean _tmp19_ = FALSE;
		gboolean _tmp20_ = FALSE;
		GtkSourceStyle* _tmp21_;
		gboolean _tmp32_ = FALSE;
		GtkSourceStyle* _tmp33_;
		_tmp7_ = sssm;
		_tmp8_ = gtk_source_style_scheme_manager_get_scheme (_tmp7_, style_id);
		_tmp9_ = _g_object_ref0 (_tmp8_);
		scheme = _tmp9_;
		_tmp10_ = scheme;
		_tmp11_ = gtk_source_style_scheme_get_name (_tmp10_);
		_tmp12_ = _tmp11_;
		gtk_widget_set_tooltip_text (color_button, _tmp12_);
		_tmp13_ = scheme;
		_tmp14_ = gtk_source_style_scheme_get_style (_tmp13_, "background-pattern");
		_tmp15_ = _g_object_ref0 (_tmp14_);
		background_style = _tmp15_;
		_tmp16_ = scheme;
		_tmp17_ = gtk_source_style_scheme_get_style (_tmp16_, "text");
		_tmp18_ = _g_object_ref0 (_tmp17_);
		foreground_style = _tmp18_;
		_tmp21_ = background_style;
		if (_tmp21_ != NULL) {
			GtkSourceStyle* _tmp22_;
			gboolean _tmp23_;
			gboolean _tmp24_;
			_tmp22_ = background_style;
			g_object_get (_tmp22_, "background-set", &_tmp23_, NULL);
			_tmp24_ = _tmp23_;
			_tmp20_ = _tmp24_;
		} else {
			_tmp20_ = FALSE;
		}
		if (_tmp20_) {
			GtkSourceStyle* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			gchar* _tmp28_;
			_tmp25_ = background_style;
			g_object_get (_tmp25_, "background", &_tmp26_, NULL);
			_tmp27_ = _tmp26_;
			_tmp28_ = _tmp27_;
			_tmp19_ = !string_contains (_tmp28_, "rgba");
			_g_free0 (_tmp28_);
		} else {
			_tmp19_ = FALSE;
		}
		if (_tmp19_) {
			GtkSourceStyle* _tmp29_;
			gchar* _tmp30_;
			gchar* _tmp31_;
			_tmp29_ = background_style;
			g_object_get (_tmp29_, "background", &_tmp30_, NULL);
			_tmp31_ = _tmp30_;
			_g_free0 (background);
			background = _tmp31_;
		}
		_tmp33_ = foreground_style;
		if (_tmp33_ != NULL) {
			GtkSourceStyle* _tmp34_;
			gboolean _tmp35_;
			gboolean _tmp36_;
			_tmp34_ = foreground_style;
			g_object_get (_tmp34_, "foreground-set", &_tmp35_, NULL);
			_tmp36_ = _tmp35_;
			_tmp32_ = _tmp36_;
		} else {
			_tmp32_ = FALSE;
		}
		if (_tmp32_) {
			GtkSourceStyle* _tmp37_;
			gchar* _tmp38_;
			gchar* _tmp39_;
			_tmp37_ = foreground_style;
			g_object_get (_tmp37_, "foreground", &_tmp38_, NULL);
			_tmp39_ = _tmp38_;
			_g_free0 (foreground);
			foreground = _tmp39_;
		}
		_g_object_unref0 (foreground_style);
		_g_object_unref0 (background_style);
		_g_object_unref0 (scheme);
	}
	_tmp40_ = background;
	_tmp41_ = foreground;
	_tmp42_ = g_strdup_printf ("\n" \
"            .color-button radio {\n" \
"                background-color: %s;\n" \
"                color: %s;\n" \
"                padding: 10px;\n" \
"                -gtk-icon-shadow: none;\n" \
"            }\n" \
"        ", _tmp40_, _tmp41_);
	style_css = _tmp42_;
	_tmp43_ = gtk_css_provider_new ();
	css_provider = _tmp43_;
	{
		gtk_css_provider_load_from_data (css_provider, style_css, (gssize) -1, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp44_;
		const gchar* _tmp45_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp44_ = e;
		_tmp45_ = _tmp44_->message;
		g_critical ("HeaderBar.vala:358: Unable to style color button: %s", _tmp45_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (css_provider);
		_g_free0 (style_css);
		_g_object_unref0 (sssm);
		_g_free0 (foreground);
		_g_free0 (background);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp46_ = gtk_widget_get_style_context (color_button);
	style_context = _tmp46_;
	gtk_style_context_add_class (style_context, GRANITE_STYLE_CLASS_COLOR_BUTTON);
	gtk_style_context_add_provider (style_context, (GtkStyleProvider*) css_provider, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (css_provider);
	_g_free0 (style_css);
	_g_object_unref0 (sssm);
	_g_free0 (foreground);
	_g_free0 (background);
}

static void
scratch_header_bar_on_share_menu_changed (ScratchHeaderBar* self)
{
	GMenu* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->share_menu;
	if (g_menu_model_get_n_items ((GMenuModel*) _tmp0_) > 0) {
		GtkMenuButton* _tmp1_;
		GtkMenuButton* _tmp2_;
		GtkMenuButton* _tmp3_;
		_tmp1_ = self->share_menu_button;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp1_, FALSE);
		_tmp2_ = self->share_menu_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp2_, TRUE);
		_tmp3_ = self->share_menu_button;
		gtk_widget_show_all ((GtkWidget*) _tmp3_);
	} else {
		GtkMenuButton* _tmp4_;
		GtkMenuButton* _tmp5_;
		GtkMenuButton* _tmp6_;
		_tmp4_ = self->share_menu_button;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp4_, TRUE);
		_tmp5_ = self->share_menu_button;
		gtk_widget_set_visible ((GtkWidget*) _tmp5_, FALSE);
		_tmp6_ = self->share_menu_button;
		gtk_widget_hide ((GtkWidget*) _tmp6_);
	}
}

void
scratch_header_bar_document_available (ScratchHeaderBar* self,
                                       gboolean has_document)
{
	g_return_if_fail (self != NULL);
	if (has_document) {
		CodeFormatBar* _tmp0_;
		CodeFormatBar* _tmp1_;
		_tmp0_ = self->format_bar;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp0_, FALSE);
		_tmp1_ = self->format_bar;
		gtk_widget_show_all ((GtkWidget*) _tmp1_);
	} else {
		CodeFormatBar* _tmp2_;
		CodeFormatBar* _tmp3_;
		_tmp2_ = self->format_bar;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp2_, TRUE);
		_tmp3_ = self->format_bar;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
	}
}

void
scratch_header_bar_set_document_focus (ScratchHeaderBar* self,
                                       ScratchServicesDocument* doc)
{
	CodeFormatBar* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (doc != NULL);
	_tmp0_ = self->format_bar;
	code_format_bar_set_document (_tmp0_, doc);
}

GtkButton*
scratch_header_bar_get_templates_button (ScratchHeaderBar* self)
{
	GtkButton* result;
	GtkButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_templates_button;
	result = _tmp0_;
	return result;
}

static void
scratch_header_bar_set_templates_button (ScratchHeaderBar* self,
                                         GtkButton* value)
{
	GtkButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_header_bar_get_templates_button (self);
	if (old_value != value) {
		GtkButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_templates_button);
		self->priv->_templates_button = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_header_bar_properties[SCRATCH_HEADER_BAR_TEMPLATES_BUTTON_PROPERTY]);
	}
}

GtkToggleButton*
scratch_header_bar_get_find_button (ScratchHeaderBar* self)
{
	GtkToggleButton* result;
	GtkToggleButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_find_button;
	result = _tmp0_;
	return result;
}

static void
scratch_header_bar_set_find_button (ScratchHeaderBar* self,
                                    GtkToggleButton* value)
{
	GtkToggleButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_header_bar_get_find_button (self);
	if (old_value != value) {
		GtkToggleButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_find_button);
		self->priv->_find_button = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_header_bar_properties[SCRATCH_HEADER_BAR_FIND_BUTTON_PROPERTY]);
	}
}

GtkToggleButton*
scratch_header_bar_get_outline_button (ScratchHeaderBar* self)
{
	GtkToggleButton* result;
	GtkToggleButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_outline_button;
	result = _tmp0_;
	return result;
}

static void
scratch_header_bar_set_outline_button (ScratchHeaderBar* self,
                                       GtkToggleButton* value)
{
	GtkToggleButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_header_bar_get_outline_button (self);
	if (old_value != value) {
		GtkToggleButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_outline_button);
		self->priv->_outline_button = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_header_bar_properties[SCRATCH_HEADER_BAR_OUTLINE_BUTTON_PROPERTY]);
	}
}

GtkToggleButton*
scratch_header_bar_get_sidebar_button (ScratchHeaderBar* self)
{
	GtkToggleButton* result;
	GtkToggleButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_sidebar_button;
	result = _tmp0_;
	return result;
}

static void
scratch_header_bar_set_sidebar_button (ScratchHeaderBar* self,
                                       GtkToggleButton* value)
{
	GtkToggleButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_header_bar_get_sidebar_button (self);
	if (old_value != value) {
		GtkToggleButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_sidebar_button);
		self->priv->_sidebar_button = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_header_bar_properties[SCRATCH_HEADER_BAR_SIDEBAR_BUTTON_PROPERTY]);
	}
}

GtkToggleButton*
scratch_header_bar_get_terminal_button (ScratchHeaderBar* self)
{
	GtkToggleButton* result;
	GtkToggleButton* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_terminal_button;
	result = _tmp0_;
	return result;
}

static void
scratch_header_bar_set_terminal_button (ScratchHeaderBar* self,
                                        GtkToggleButton* value)
{
	GtkToggleButton* old_value;
	g_return_if_fail (self != NULL);
	old_value = scratch_header_bar_get_terminal_button (self);
	if (old_value != value) {
		GtkToggleButton* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_terminal_button);
		self->priv->_terminal_button = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, scratch_header_bar_properties[SCRATCH_HEADER_BAR_TERMINAL_BUTTON_PROPERTY]);
	}
}

static Block46Data*
block46_data_ref (Block46Data* _data46_)
{
	g_atomic_int_inc (&_data46_->_ref_count_);
	return _data46_;
}

static void
block46_data_unref (void * _userdata_)
{
	Block46Data* _data46_;
	_data46_ = (Block46Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data46_->_ref_count_)) {
		ScratchHeaderBar* self;
		self = _data46_->self;
		_g_object_unref0 (_data46_->gtk_settings);
		_g_object_unref0 (_data46_->zoom_default_button);
		_g_object_unref0 (_data46_->save_button);
		_g_object_unref0 (_data46_->app_instance);
		_g_object_unref0 (self);
		g_slice_free (Block46Data, _data46_);
	}
}

static void
_scratch_header_bar_on_share_menu_changed_g_menu_model_items_changed (GMenuModel* _sender,
                                                                      gint position,
                                                                      gint removed,
                                                                      gint added,
                                                                      gpointer self)
{
	scratch_header_bar_on_share_menu_changed ((ScratchHeaderBar*) self);
}

static void
_scratch_header_bar___lambda60_ (Block46Data* _data46_)
{
	ScratchHeaderBar* self;
	GtkButton* _tmp0_;
	GSettings* _tmp1_;
	self = _data46_->self;
	_tmp0_ = _data46_->save_button;
	_tmp1_ = scratch_settings;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, !g_settings_get_boolean (_tmp1_, "autosave"));
}

static void
__scratch_header_bar___lambda60__gtk_widget_realize (GtkWidget* _sender,
                                                     gpointer self)
{
	_scratch_header_bar___lambda60_ (self);
}

static void
_scratch_header_bar___lambda61_ (Block46Data* _data46_)
{
	ScratchHeaderBar* self;
	GtkButton* _tmp0_;
	GSettings* _tmp1_;
	self = _data46_->self;
	_tmp0_ = _data46_->save_button;
	_tmp1_ = scratch_settings;
	gtk_widget_set_visible ((GtkWidget*) _tmp0_, !g_settings_get_boolean (_tmp1_, "autosave"));
}

static void
__scratch_header_bar___lambda61__g_settings_changed (GSettings* _sender,
                                                     const gchar* key,
                                                     gpointer self)
{
	_scratch_header_bar___lambda61_ (self);
}

static void
_scratch_header_bar___lambda62_ (Block46Data* _data46_)
{
	ScratchHeaderBar* self;
	ScratchMainWindow* active_window = NULL;
	GtkApplication* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	ScratchMainWindow* _tmp3_;
	ScratchMainWindow* _tmp4_;
	self = _data46_->self;
	_tmp0_ = _data46_->app_instance;
	_tmp1_ = gtk_application_get_active_window (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, SCRATCH_TYPE_MAIN_WINDOW, ScratchMainWindow));
	active_window = _tmp3_;
	_tmp4_ = active_window;
	if (_tmp4_ != NULL) {
		GtkButton* _tmp5_;
		ScratchMainWindow* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp5_ = _data46_->zoom_default_button;
		_tmp6_ = active_window;
		_tmp7_ = g_strdup_printf ("%.0f%%", scratch_main_window_get_current_font_size (_tmp6_) * 10);
		_tmp8_ = _tmp7_;
		gtk_button_set_label (_tmp5_, _tmp8_);
		_g_free0 (_tmp8_);
	}
	_g_object_unref0 (active_window);
}

static void
__scratch_header_bar___lambda62__g_settings_changed (GSettings* _sender,
                                                     const gchar* key,
                                                     gpointer self)
{
	_scratch_header_bar___lambda62_ (self);
}

static void
_scratch_header_bar___lambda63_ (Block46Data* _data46_)
{
	ScratchHeaderBar* self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkSettings* _tmp2_;
	self = _data46_->self;
	_tmp0_ = scratch_settings;
	g_settings_set_boolean (_tmp0_, "prefer-dark-style", TRUE);
	_tmp1_ = scratch_settings;
	g_settings_set_string (_tmp1_, "style-scheme", SCRATCH_HEADER_BAR_STYLE_SCHEME_DARK);
	_tmp2_ = _data46_->gtk_settings;
	g_object_set (_tmp2_, "gtk-application-prefer-dark-theme", TRUE, NULL);
}

static void
__scratch_header_bar___lambda63__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	_scratch_header_bar___lambda63_ (self);
}

static void
_scratch_header_bar___lambda64_ (Block46Data* _data46_)
{
	ScratchHeaderBar* self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkSettings* _tmp2_;
	self = _data46_->self;
	_tmp0_ = scratch_settings;
	g_settings_set_boolean (_tmp0_, "prefer-dark-style", FALSE);
	_tmp1_ = scratch_settings;
	g_settings_set_string (_tmp1_, "style-scheme", SCRATCH_HEADER_BAR_STYLE_SCHEME_LIGHT);
	_tmp2_ = _data46_->gtk_settings;
	g_object_set (_tmp2_, "gtk-application-prefer-dark-theme", FALSE, NULL);
}

static void
__scratch_header_bar___lambda64__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	_scratch_header_bar___lambda64_ (self);
}

static void
_scratch_header_bar___lambda65_ (Block46Data* _data46_)
{
	ScratchHeaderBar* self;
	GSettings* _tmp0_;
	GSettings* _tmp1_;
	GtkSettings* _tmp2_;
	self = _data46_->self;
	_tmp0_ = scratch_settings;
	g_settings_set_boolean (_tmp0_, "prefer-dark-style", FALSE);
	_tmp1_ = scratch_settings;
	g_settings_set_string (_tmp1_, "style-scheme", SCRATCH_HEADER_BAR_STYLE_SCHEME_HIGH_CONTRAST);
	_tmp2_ = _data46_->gtk_settings;
	g_object_set (_tmp2_, "gtk-application-prefer-dark-theme", FALSE, NULL);
}

static void
__scratch_header_bar___lambda65__gtk_button_clicked (GtkButton* _sender,
                                                     gpointer self)
{
	_scratch_header_bar___lambda65_ (self);
}

static GObject *
scratch_header_bar_constructor (GType type,
                                guint n_construct_properties,
                                GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	ScratchHeaderBar * self;
	Block46Data* _data46_;
	GApplication* _tmp0_;
	GtkApplication* _tmp1_;
	GtkButton* open_button = NULL;
	gchar* _tmp2_;
	GtkButton* _tmp3_ = NULL;
	GtkButton* _tmp4_;
	GtkApplication* _tmp5_;
	GtkButton* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	gchar** _tmp9_;
	gchar** _tmp10_;
	gchar** _tmp11_;
	gint _tmp11__length1;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	GtkButton* _tmp15_ = NULL;
	GtkButton* _tmp16_;
	GtkButton* _tmp17_;
	gchar* _tmp18_;
	GtkButton* _tmp19_ = NULL;
	GtkButton* _tmp20_;
	GtkApplication* _tmp21_;
	GtkButton* _tmp22_;
	const gchar* _tmp23_;
	const gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	gchar* _tmp28_;
	gchar* _tmp29_;
	GtkButton* save_as_button = NULL;
	gchar* _tmp30_;
	GtkButton* _tmp31_ = NULL;
	GtkButton* _tmp32_;
	GtkApplication* _tmp33_;
	GtkButton* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	gchar** _tmp37_;
	gchar** _tmp38_;
	gchar** _tmp39_;
	gint _tmp39__length1;
	gchar* _tmp40_;
	gchar* _tmp41_;
	GtkButton* revert_button = NULL;
	gchar* _tmp42_;
	GtkButton* _tmp43_ = NULL;
	GtkButton* _tmp44_;
	GtkApplication* _tmp45_;
	GtkButton* _tmp46_;
	const gchar* _tmp47_;
	const gchar* _tmp48_;
	gchar** _tmp49_;
	gchar** _tmp50_;
	gchar** _tmp51_;
	gint _tmp51__length1;
	gchar* _tmp52_;
	gchar* _tmp53_;
	GMenu* _tmp54_;
	GtkImage* _tmp55_;
	GMenu* _tmp56_;
	GMenuModel* _tmp57_;
	gchar* _tmp58_;
	GtkMenuButton* _tmp59_ = NULL;
	GtkButton* zoom_out_button = NULL;
	gchar* _tmp60_;
	GtkButton* _tmp61_ = NULL;
	GtkButton* _tmp62_;
	GtkApplication* _tmp63_;
	GtkButton* _tmp64_;
	const gchar* _tmp65_;
	const gchar* _tmp66_;
	gchar** _tmp67_;
	gchar** _tmp68_;
	gchar** _tmp69_;
	gint _tmp69__length1;
	gchar* _tmp70_;
	gchar* _tmp71_;
	gchar* _tmp72_;
	GtkButton* _tmp73_ = NULL;
	GtkButton* _tmp74_;
	GtkApplication* _tmp75_;
	GtkButton* _tmp76_;
	const gchar* _tmp77_;
	const gchar* _tmp78_;
	gchar** _tmp79_;
	gchar** _tmp80_;
	gchar** _tmp81_;
	gint _tmp81__length1;
	gchar* _tmp82_;
	gchar* _tmp83_;
	GtkButton* zoom_in_button = NULL;
	gchar* _tmp84_;
	GtkButton* _tmp85_ = NULL;
	GtkButton* _tmp86_;
	GtkApplication* _tmp87_;
	GtkButton* _tmp88_;
	const gchar* _tmp89_;
	const gchar* _tmp90_;
	gchar** _tmp91_;
	gchar** _tmp92_;
	gchar** _tmp93_;
	gint _tmp93__length1;
	gchar* _tmp94_;
	gchar* _tmp95_;
	GtkBox* font_size_box = NULL;
	GtkBox* _tmp96_ = NULL;
	GtkBox* _tmp97_;
	GtkStyleContext* _tmp98_;
	GtkBox* _tmp99_;
	GtkButton* _tmp100_;
	GtkBox* _tmp101_;
	GtkButton* _tmp102_;
	GtkBox* _tmp103_;
	GtkButton* _tmp104_;
	gchar* _tmp105_;
	GtkImage* _tmp106_;
	GtkToggleButton* _tmp107_ = NULL;
	GtkToggleButton* _tmp108_;
	GtkToggleButton* _tmp109_;
	GtkApplication* _tmp110_;
	gchar** _tmp111_;
	gchar** _tmp112_;
	gchar** _tmp113_;
	gint _tmp113__length1;
	gchar* _tmp114_;
	gchar* _tmp115_;
	GtkButton* search_button = NULL;
	gchar* _tmp116_;
	GVariant* _tmp117_;
	GtkButton* _tmp118_ = NULL;
	GtkButton* _tmp119_;
	GtkApplication* _tmp120_;
	GtkButton* _tmp121_;
	const gchar* _tmp122_;
	const gchar* _tmp123_;
	gchar* _tmp124_;
	gchar* _tmp125_;
	gchar** _tmp126_;
	gchar** _tmp127_;
	gchar** _tmp128_;
	gint _tmp128__length1;
	gchar* _tmp129_;
	gchar* _tmp130_;
	GtkBox* find_box = NULL;
	GtkBox* _tmp131_ = NULL;
	GtkBox* _tmp132_;
	GtkStyleContext* _tmp133_;
	GtkBox* _tmp134_;
	GtkToggleButton* _tmp135_;
	GtkBox* _tmp136_;
	GtkButton* _tmp137_;
	GraniteSwitchModelButton* follow_system_switchmodelbutton = NULL;
	GraniteSwitchModelButton* _tmp138_ = NULL;
	GtkRadioButton* color_button_none = NULL;
	GtkRadioButton* _tmp139_;
	GtkRadioButton* color_button_white = NULL;
	GtkRadioButton* _tmp140_;
	GtkRadioButton* _tmp141_ = NULL;
	GtkRadioButton* _tmp142_;
	GtkRadioButton* color_button_light = NULL;
	GtkRadioButton* _tmp143_;
	GtkRadioButton* _tmp144_ = NULL;
	GtkRadioButton* _tmp145_;
	GtkRadioButton* color_button_dark = NULL;
	GtkRadioButton* _tmp146_;
	GtkRadioButton* _tmp147_ = NULL;
	GtkRadioButton* _tmp148_;
	GtkBox* color_box = NULL;
	GtkBox* _tmp149_ = NULL;
	GtkBox* _tmp150_;
	GtkRadioButton* _tmp151_;
	GtkBox* _tmp152_;
	GtkRadioButton* _tmp153_;
	GtkBox* _tmp154_;
	GtkRadioButton* _tmp155_;
	GtkRevealer* color_revealer = NULL;
	GtkRevealer* _tmp156_;
	GtkRevealer* _tmp157_;
	GtkBox* _tmp158_;
	GtkSeparator* menu_separator = NULL;
	GtkSeparator* _tmp159_ = NULL;
	gchar* _tmp160_;
	GtkImage* _tmp161_;
	GtkToggleButton* _tmp162_ = NULL;
	GtkToggleButton* _tmp163_;
	gchar* _tmp164_;
	GtkImage* _tmp165_;
	GtkToggleButton* _tmp166_ = NULL;
	GtkToggleButton* _tmp167_;
	GtkToggleButton* _tmp168_;
	GtkApplication* _tmp169_;
	GtkToggleButton* _tmp170_;
	const gchar* _tmp171_;
	const gchar* _tmp172_;
	gchar** _tmp173_;
	gchar** _tmp174_;
	gchar** _tmp175_;
	gint _tmp175__length1;
	gchar* _tmp176_;
	gchar* _tmp177_;
	gchar* _tmp178_;
	GtkImage* _tmp179_;
	GtkToggleButton* _tmp180_ = NULL;
	GtkToggleButton* _tmp181_;
	GtkBox* panels_box = NULL;
	GtkBox* _tmp182_ = NULL;
	GtkBox* _tmp183_;
	GtkStyleContext* _tmp184_;
	GtkBox* _tmp185_;
	GtkToggleButton* _tmp186_;
	GtkBox* _tmp187_;
	GtkToggleButton* _tmp188_;
	GtkBox* _tmp189_;
	GtkToggleButton* _tmp190_;
	GtkModelButton* preferences_menuitem = NULL;
	gchar* _tmp191_;
	gchar* _tmp192_;
	GtkModelButton* _tmp193_ = NULL;
	GtkBox* menu_box = NULL;
	GtkBox* _tmp194_ = NULL;
	GtkBox* _tmp195_;
	GtkBox* _tmp196_;
	GtkBox* _tmp197_;
	GtkBox* _tmp198_;
	GtkBox* _tmp199_;
	GtkSeparator* _tmp200_;
	GtkSeparator* _tmp201_;
	GtkBox* _tmp202_;
	GraniteSwitchModelButton* _tmp203_;
	GtkBox* _tmp204_;
	GtkRevealer* _tmp205_;
	GtkBox* _tmp206_;
	GtkBox* _tmp207_;
	GtkBox* _tmp208_;
	GtkSeparator* _tmp209_;
	GtkBox* _tmp210_;
	GtkModelButton* _tmp211_;
	GtkBox* _tmp212_;
	GtkPopover* menu = NULL;
	GtkPopover* _tmp213_;
	GtkPopover* _tmp214_;
	GtkBox* _tmp215_;
	GtkMenuButton* app_menu = NULL;
	GtkImage* _tmp216_;
	GtkPopover* _tmp217_;
	GtkPopover* _tmp218_;
	gchar* _tmp219_;
	GtkMenuButton* _tmp220_ = NULL;
	CodeFormatBar* _tmp221_ = NULL;
	CodeFormatBar* _tmp222_;
	GtkButton* _tmp223_;
	GtkButton* _tmp224_;
	GtkButton* _tmp225_;
	GtkButton* _tmp226_;
	GtkButton* _tmp227_;
	GtkMenuButton* _tmp228_;
	GtkMenuButton* _tmp229_;
	GMenu* _tmp230_;
	GSettings* _tmp231_;
	GSettings* _tmp232_;
	GraniteSwitchModelButton* _tmp233_;
	GtkRevealer* _tmp234_;
	GSettings* _tmp235_;
	GraniteSwitchModelButton* _tmp236_;
	GtkSettings* _tmp237_;
	GtkSettings* _tmp238_;
	GSettings* _tmp239_;
	gchar* _tmp240_;
	gchar* _tmp241_;
	GQuark _tmp243_ = 0U;
	static GQuark _tmp242_label0 = 0;
	static GQuark _tmp242_label1 = 0;
	static GQuark _tmp242_label2 = 0;
	GtkRadioButton* _tmp248_;
	GtkRadioButton* _tmp249_;
	GtkRadioButton* _tmp250_;
	parent_class = G_OBJECT_CLASS (scratch_header_bar_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_TYPE_HEADER_BAR, ScratchHeaderBar);
	_data46_ = g_slice_new0 (Block46Data);
	_data46_->_ref_count_ = 1;
	_data46_->self = g_object_ref (self);
	_tmp0_ = g_application_get_default ();
	_tmp1_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_application_get_type (), GtkApplication));
	_data46_->app_instance = _tmp1_;
	_tmp2_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_OPEN);
	_tmp3_ = (GtkButton*) gtk_button_new_from_icon_name ("document-open", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp3_, _tmp2_);
	_g_free0 (_tmp2_);
	g_object_ref_sink (_tmp3_);
	open_button = _tmp3_;
	_tmp4_ = open_button;
	_tmp5_ = _data46_->app_instance;
	_tmp6_ = open_button;
	_tmp7_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp6_);
	_tmp8_ = _tmp7_;
	_tmp10_ = _tmp9_ = gtk_application_get_accels_for_action (_tmp5_, _tmp8_);
	_tmp11_ = _tmp10_;
	_tmp11__length1 = _vala_array_length (_tmp9_);
	_tmp12_ = granite_markup_accel_tooltip (_tmp11_, (gint) _vala_array_length (_tmp9_), _ ("Open a file"));
	_tmp13_ = _tmp12_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp4_, _tmp13_);
	_g_free0 (_tmp13_);
	_tmp11_ = (_vala_array_free (_tmp11_, _tmp11__length1, (GDestroyNotify) g_free), NULL);
	_tmp14_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_TEMPLATES);
	_tmp15_ = (GtkButton*) gtk_button_new_from_icon_name ("text-x-generic-template", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp15_, _tmp14_);
	_g_free0 (_tmp14_);
	g_object_ref_sink (_tmp15_);
	_tmp16_ = _tmp15_;
	scratch_header_bar_set_templates_button (self, _tmp16_);
	_g_object_unref0 (_tmp16_);
	_tmp17_ = self->priv->_templates_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp17_, _ ("Project templates"));
	_tmp18_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_SAVE);
	_tmp19_ = (GtkButton*) gtk_button_new_from_icon_name ("document-save", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp19_, _tmp18_);
	_g_free0 (_tmp18_);
	g_object_ref_sink (_tmp19_);
	_data46_->save_button = _tmp19_;
	_tmp20_ = _data46_->save_button;
	_tmp21_ = _data46_->app_instance;
	_tmp22_ = _data46_->save_button;
	_tmp23_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp22_);
	_tmp24_ = _tmp23_;
	_tmp26_ = _tmp25_ = gtk_application_get_accels_for_action (_tmp21_, _tmp24_);
	_tmp27_ = _tmp26_;
	_tmp27__length1 = _vala_array_length (_tmp25_);
	_tmp28_ = granite_markup_accel_tooltip (_tmp27_, (gint) _vala_array_length (_tmp25_), _ ("Save this file"));
	_tmp29_ = _tmp28_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp20_, _tmp29_);
	_g_free0 (_tmp29_);
	_tmp27_ = (_vala_array_free (_tmp27_, _tmp27__length1, (GDestroyNotify) g_free), NULL);
	_tmp30_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_SAVE_AS);
	_tmp31_ = (GtkButton*) gtk_button_new_from_icon_name ("document-save-as", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp31_, _tmp30_);
	_g_free0 (_tmp30_);
	g_object_ref_sink (_tmp31_);
	save_as_button = _tmp31_;
	_tmp32_ = save_as_button;
	_tmp33_ = _data46_->app_instance;
	_tmp34_ = save_as_button;
	_tmp35_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp34_);
	_tmp36_ = _tmp35_;
	_tmp38_ = _tmp37_ = gtk_application_get_accels_for_action (_tmp33_, _tmp36_);
	_tmp39_ = _tmp38_;
	_tmp39__length1 = _vala_array_length (_tmp37_);
	_tmp40_ = granite_markup_accel_tooltip (_tmp39_, (gint) _vala_array_length (_tmp37_), _ ("Save this file with a different name"));
	_tmp41_ = _tmp40_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp32_, _tmp41_);
	_g_free0 (_tmp41_);
	_tmp39_ = (_vala_array_free (_tmp39_, _tmp39__length1, (GDestroyNotify) g_free), NULL);
	_tmp42_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_REVERT);
	_tmp43_ = (GtkButton*) gtk_button_new_from_icon_name ("document-revert", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp43_, _tmp42_);
	_g_free0 (_tmp42_);
	g_object_ref_sink (_tmp43_);
	revert_button = _tmp43_;
	_tmp44_ = revert_button;
	_tmp45_ = _data46_->app_instance;
	_tmp46_ = revert_button;
	_tmp47_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp46_);
	_tmp48_ = _tmp47_;
	_tmp50_ = _tmp49_ = gtk_application_get_accels_for_action (_tmp45_, _tmp48_);
	_tmp51_ = _tmp50_;
	_tmp51__length1 = _vala_array_length (_tmp49_);
	_tmp52_ = granite_markup_accel_tooltip (_tmp51_, (gint) _vala_array_length (_tmp49_), _ ("Restore this file"));
	_tmp53_ = _tmp52_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp44_, _tmp53_);
	_g_free0 (_tmp53_);
	_tmp51_ = (_vala_array_free (_tmp51_, _tmp51__length1, (GDestroyNotify) g_free), NULL);
	_tmp54_ = g_menu_new ();
	_g_object_unref0 (self->share_menu);
	self->share_menu = _tmp54_;
	_tmp55_ = (GtkImage*) gtk_image_new_from_icon_name ("document-export", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp55_);
	_tmp56_ = self->share_menu;
	_tmp57_ = _g_object_ref0 ((GMenuModel*) _tmp56_);
	_tmp58_ = g_strdup (_ ("Share"));
	_tmp59_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp59_, (GtkWidget*) _tmp55_);
	_g_object_unref0 (_tmp55_);
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp59_, TRUE);
	gtk_menu_button_set_menu_model (_tmp59_, _tmp57_);
	_g_object_unref0 (_tmp57_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp59_, _tmp58_);
	_g_free0 (_tmp58_);
	g_object_ref_sink (_tmp59_);
	_g_object_unref0 (self->share_menu_button);
	self->share_menu_button = _tmp59_;
	_tmp60_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_ZOOM_OUT);
	_tmp61_ = (GtkButton*) gtk_button_new_from_icon_name ("zoom-out-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp61_, _tmp60_);
	_g_free0 (_tmp60_);
	g_object_ref_sink (_tmp61_);
	zoom_out_button = _tmp61_;
	_tmp62_ = zoom_out_button;
	_tmp63_ = _data46_->app_instance;
	_tmp64_ = zoom_out_button;
	_tmp65_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp64_);
	_tmp66_ = _tmp65_;
	_tmp68_ = _tmp67_ = gtk_application_get_accels_for_action (_tmp63_, _tmp66_);
	_tmp69_ = _tmp68_;
	_tmp69__length1 = _vala_array_length (_tmp67_);
	_tmp70_ = granite_markup_accel_tooltip (_tmp69_, (gint) _vala_array_length (_tmp67_), _ ("Zoom Out"));
	_tmp71_ = _tmp70_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp62_, _tmp71_);
	_g_free0 (_tmp71_);
	_tmp69_ = (_vala_array_free (_tmp69_, _tmp69__length1, (GDestroyNotify) g_free), NULL);
	_tmp72_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_ZOOM_DEFAULT);
	_tmp73_ = (GtkButton*) gtk_button_new_with_label ("100%");
	gtk_actionable_set_action_name ((GtkActionable*) _tmp73_, _tmp72_);
	_g_free0 (_tmp72_);
	g_object_ref_sink (_tmp73_);
	_data46_->zoom_default_button = _tmp73_;
	_tmp74_ = _data46_->zoom_default_button;
	_tmp75_ = _data46_->app_instance;
	_tmp76_ = _data46_->zoom_default_button;
	_tmp77_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp76_);
	_tmp78_ = _tmp77_;
	_tmp80_ = _tmp79_ = gtk_application_get_accels_for_action (_tmp75_, _tmp78_);
	_tmp81_ = _tmp80_;
	_tmp81__length1 = _vala_array_length (_tmp79_);
	_tmp82_ = granite_markup_accel_tooltip (_tmp81_, (gint) _vala_array_length (_tmp79_), _ ("Zoom 1:1"));
	_tmp83_ = _tmp82_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp74_, _tmp83_);
	_g_free0 (_tmp83_);
	_tmp81_ = (_vala_array_free (_tmp81_, _tmp81__length1, (GDestroyNotify) g_free), NULL);
	_tmp84_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_ZOOM_IN);
	_tmp85_ = (GtkButton*) gtk_button_new_from_icon_name ("zoom-in-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp85_, _tmp84_);
	_g_free0 (_tmp84_);
	g_object_ref_sink (_tmp85_);
	zoom_in_button = _tmp85_;
	_tmp86_ = zoom_in_button;
	_tmp87_ = _data46_->app_instance;
	_tmp88_ = zoom_in_button;
	_tmp89_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp88_);
	_tmp90_ = _tmp89_;
	_tmp92_ = _tmp91_ = gtk_application_get_accels_for_action (_tmp87_, _tmp90_);
	_tmp93_ = _tmp92_;
	_tmp93__length1 = _vala_array_length (_tmp91_);
	_tmp94_ = granite_markup_accel_tooltip (_tmp93_, (gint) _vala_array_length (_tmp91_), _ ("Zoom In"));
	_tmp95_ = _tmp94_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp86_, _tmp95_);
	_g_free0 (_tmp95_);
	_tmp93_ = (_vala_array_free (_tmp93_, _tmp93__length1, (GDestroyNotify) g_free), NULL);
	_tmp96_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_set_homogeneous (_tmp96_, TRUE);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp96_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp96_, 12);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp96_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp96_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp96_, 12);
	g_object_ref_sink (_tmp96_);
	font_size_box = _tmp96_;
	_tmp97_ = font_size_box;
	_tmp98_ = gtk_widget_get_style_context ((GtkWidget*) _tmp97_);
	gtk_style_context_add_class (_tmp98_, GTK_STYLE_CLASS_LINKED);
	_tmp99_ = font_size_box;
	_tmp100_ = zoom_out_button;
	gtk_container_add ((GtkContainer*) _tmp99_, (GtkWidget*) _tmp100_);
	_tmp101_ = font_size_box;
	_tmp102_ = _data46_->zoom_default_button;
	gtk_container_add ((GtkContainer*) _tmp101_, (GtkWidget*) _tmp102_);
	_tmp103_ = font_size_box;
	_tmp104_ = zoom_in_button;
	gtk_container_add ((GtkContainer*) _tmp103_, (GtkWidget*) _tmp104_);
	_tmp105_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_TOGGLE_SHOW_FIND);
	_tmp106_ = (GtkImage*) gtk_image_new_from_icon_name ("edit-find-on-page-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp106_);
	_tmp107_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp107_, _tmp105_);
	_g_free0 (_tmp105_);
	gtk_button_set_image ((GtkButton*) _tmp107_, (GtkWidget*) _tmp106_);
	_g_object_unref0 (_tmp106_);
	g_object_ref_sink (_tmp107_);
	_tmp108_ = _tmp107_;
	scratch_header_bar_set_find_button (self, _tmp108_);
	_g_object_unref0 (_tmp108_);
	_tmp109_ = self->priv->_find_button;
	_tmp110_ = _data46_->app_instance;
	_tmp112_ = _tmp111_ = gtk_application_get_accels_for_action (_tmp110_, SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_FIND "::");
	_tmp113_ = _tmp112_;
	_tmp113__length1 = _vala_array_length (_tmp111_);
	_tmp114_ = granite_markup_accel_tooltip (_tmp113_, (gint) _vala_array_length (_tmp111_), _ ("Find on Page…"));
	_tmp115_ = _tmp114_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp109_, _tmp115_);
	_g_free0 (_tmp115_);
	_tmp113_ = (_vala_array_free (_tmp113_, _tmp113__length1, (GDestroyNotify) g_free), NULL);
	_tmp116_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_FIND_GLOBAL);
	_tmp117_ = g_variant_new_string ("");
	g_variant_ref_sink (_tmp117_);
	_tmp118_ = (GtkButton*) gtk_button_new_from_icon_name ("edit-find-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	gtk_actionable_set_action_name ((GtkActionable*) _tmp118_, _tmp116_);
	_g_free0 (_tmp116_);
	g_object_set ((GtkActionable*) _tmp118_, "action-target", _tmp117_, NULL);
	_g_variant_unref0 (_tmp117_);
	g_object_ref_sink (_tmp118_);
	search_button = _tmp118_;
	_tmp119_ = search_button;
	_tmp120_ = _data46_->app_instance;
	_tmp121_ = search_button;
	_tmp122_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp121_);
	_tmp123_ = _tmp122_;
	_tmp124_ = g_strconcat (_tmp123_, "::", NULL);
	_tmp125_ = _tmp124_;
	_tmp127_ = _tmp126_ = gtk_application_get_accels_for_action (_tmp120_, _tmp125_);
	_tmp128_ = _tmp127_;
	_tmp128__length1 = _vala_array_length (_tmp126_);
	_tmp129_ = granite_markup_accel_tooltip (_tmp128_, (gint) _vala_array_length (_tmp126_), _ ("Find in Project…"));
	_tmp130_ = _tmp129_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp119_, _tmp130_);
	_g_free0 (_tmp130_);
	_tmp128_ = (_vala_array_free (_tmp128_, _tmp128__length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (_tmp125_);
	_tmp131_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp131_, TRUE);
	gtk_box_set_homogeneous (_tmp131_, TRUE);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp131_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp131_, 12);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp131_, 12);
	g_object_ref_sink (_tmp131_);
	find_box = _tmp131_;
	_tmp132_ = find_box;
	_tmp133_ = gtk_widget_get_style_context ((GtkWidget*) _tmp132_);
	gtk_style_context_add_class (_tmp133_, GTK_STYLE_CLASS_LINKED);
	_tmp134_ = find_box;
	_tmp135_ = self->priv->_find_button;
	gtk_container_add ((GtkContainer*) _tmp134_, (GtkWidget*) _tmp135_);
	_tmp136_ = find_box;
	_tmp137_ = search_button;
	gtk_container_add ((GtkContainer*) _tmp136_, (GtkWidget*) _tmp137_);
	_tmp138_ = granite_switch_model_button_new (_ ("Follow System Style"));
	gtk_widget_set_margin_top ((GtkWidget*) _tmp138_, 3);
	g_object_ref_sink (_tmp138_);
	follow_system_switchmodelbutton = _tmp138_;
	_tmp139_ = (GtkRadioButton*) gtk_radio_button_new (NULL);
	g_object_ref_sink (_tmp139_);
	color_button_none = _tmp139_;
	_tmp140_ = color_button_none;
	_tmp141_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp140_);
	gtk_widget_set_halign ((GtkWidget*) _tmp141_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp141_);
	color_button_white = _tmp141_;
	_tmp142_ = color_button_white;
	scratch_header_bar_style_color_button (self, (GtkWidget*) _tmp142_, SCRATCH_HEADER_BAR_STYLE_SCHEME_HIGH_CONTRAST);
	_tmp143_ = color_button_none;
	_tmp144_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp143_);
	gtk_widget_set_halign ((GtkWidget*) _tmp144_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp144_);
	color_button_light = _tmp144_;
	_tmp145_ = color_button_light;
	scratch_header_bar_style_color_button (self, (GtkWidget*) _tmp145_, SCRATCH_HEADER_BAR_STYLE_SCHEME_LIGHT);
	_tmp146_ = color_button_none;
	_tmp147_ = (GtkRadioButton*) gtk_radio_button_new_from_widget (_tmp146_);
	gtk_widget_set_halign ((GtkWidget*) _tmp147_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp147_);
	color_button_dark = _tmp147_;
	_tmp148_ = color_button_dark;
	scratch_header_bar_style_color_button (self, (GtkWidget*) _tmp148_, SCRATCH_HEADER_BAR_STYLE_SCHEME_DARK);
	_tmp149_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 3);
	gtk_box_set_homogeneous (_tmp149_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp149_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp149_, 6);
	g_object_ref_sink (_tmp149_);
	color_box = _tmp149_;
	_tmp150_ = color_box;
	_tmp151_ = color_button_white;
	gtk_container_add ((GtkContainer*) _tmp150_, (GtkWidget*) _tmp151_);
	_tmp152_ = color_box;
	_tmp153_ = color_button_light;
	gtk_container_add ((GtkContainer*) _tmp152_, (GtkWidget*) _tmp153_);
	_tmp154_ = color_box;
	_tmp155_ = color_button_dark;
	gtk_container_add ((GtkContainer*) _tmp154_, (GtkWidget*) _tmp155_);
	_tmp156_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_ref_sink (_tmp156_);
	color_revealer = _tmp156_;
	_tmp157_ = color_revealer;
	_tmp158_ = color_box;
	gtk_container_add ((GtkContainer*) _tmp157_, (GtkWidget*) _tmp158_);
	_tmp159_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp159_, 3);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp159_, 3);
	g_object_ref_sink (_tmp159_);
	menu_separator = _tmp159_;
	_tmp160_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_TOGGLE_SIDEBAR);
	_tmp161_ = (GtkImage*) gtk_image_new_from_icon_name ("panel-left-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp161_);
	_tmp162_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp162_, _tmp160_);
	_g_free0 (_tmp160_);
	gtk_button_set_image ((GtkButton*) _tmp162_, (GtkWidget*) _tmp161_);
	_g_object_unref0 (_tmp161_);
	g_object_ref_sink (_tmp162_);
	_tmp163_ = _tmp162_;
	scratch_header_bar_set_sidebar_button (self, _tmp163_);
	_g_object_unref0 (_tmp163_);
	_tmp164_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_TOGGLE_TERMINAL);
	_tmp165_ = (GtkImage*) gtk_image_new_from_icon_name ("panel-bottom-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp165_);
	_tmp166_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp166_, _tmp164_);
	_g_free0 (_tmp164_);
	gtk_button_set_image ((GtkButton*) _tmp166_, (GtkWidget*) _tmp165_);
	_g_object_unref0 (_tmp165_);
	g_object_ref_sink (_tmp166_);
	_tmp167_ = _tmp166_;
	scratch_header_bar_set_terminal_button (self, _tmp167_);
	_g_object_unref0 (_tmp167_);
	_tmp168_ = self->priv->_terminal_button;
	_tmp169_ = _data46_->app_instance;
	_tmp170_ = self->priv->_terminal_button;
	_tmp171_ = gtk_actionable_get_action_name ((GtkActionable*) _tmp170_);
	_tmp172_ = _tmp171_;
	_tmp174_ = _tmp173_ = gtk_application_get_accels_for_action (_tmp169_, _tmp172_);
	_tmp175_ = _tmp174_;
	_tmp175__length1 = _vala_array_length (_tmp173_);
	_tmp176_ = granite_markup_accel_tooltip (_tmp175_, (gint) _vala_array_length (_tmp173_), _ ("Show Terminal"));
	_tmp177_ = _tmp176_;
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp168_, _tmp177_);
	_g_free0 (_tmp177_);
	_tmp175_ = (_vala_array_free (_tmp175_, _tmp175__length1, (GDestroyNotify) g_free), NULL);
	_tmp178_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_TOGGLE_OUTLINE);
	_tmp179_ = (GtkImage*) gtk_image_new_from_icon_name ("panel-right-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp179_);
	_tmp180_ = (GtkToggleButton*) gtk_toggle_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp180_, _tmp178_);
	_g_free0 (_tmp178_);
	gtk_button_set_image ((GtkButton*) _tmp180_, (GtkWidget*) _tmp179_);
	_g_object_unref0 (_tmp179_);
	g_object_ref_sink (_tmp180_);
	_tmp181_ = _tmp180_;
	scratch_header_bar_set_outline_button (self, _tmp181_);
	_g_object_unref0 (_tmp181_);
	_tmp182_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	gtk_box_set_homogeneous (_tmp182_, TRUE);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp182_, 6);
	gtk_widget_set_margin_end ((GtkWidget*) _tmp182_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp182_, 6);
	gtk_widget_set_margin_start ((GtkWidget*) _tmp182_, 12);
	g_object_ref_sink (_tmp182_);
	panels_box = _tmp182_;
	_tmp183_ = panels_box;
	_tmp184_ = gtk_widget_get_style_context ((GtkWidget*) _tmp183_);
	gtk_style_context_add_class (_tmp184_, GTK_STYLE_CLASS_LINKED);
	_tmp185_ = panels_box;
	_tmp186_ = self->priv->_sidebar_button;
	gtk_container_add ((GtkContainer*) _tmp185_, (GtkWidget*) _tmp186_);
	_tmp187_ = panels_box;
	_tmp188_ = self->priv->_terminal_button;
	gtk_container_add ((GtkContainer*) _tmp187_, (GtkWidget*) _tmp188_);
	_tmp189_ = panels_box;
	_tmp190_ = self->priv->_outline_button;
	gtk_container_add ((GtkContainer*) _tmp189_, (GtkWidget*) _tmp190_);
	_tmp191_ = g_strdup (SCRATCH_MAIN_WINDOW_ACTION_PREFIX SCRATCH_MAIN_WINDOW_ACTION_PREFERENCES);
	_tmp192_ = g_strdup (_ ("Preferences"));
	_tmp193_ = (GtkModelButton*) gtk_model_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp193_, _tmp191_);
	_g_free0 (_tmp191_);
	g_object_set (_tmp193_, "text", _tmp192_, NULL);
	_g_free0 (_tmp192_);
	g_object_ref_sink (_tmp193_);
	preferences_menuitem = _tmp193_;
	_tmp194_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp194_, 3);
	g_object_ref_sink (_tmp194_);
	menu_box = _tmp194_;
	_tmp195_ = menu_box;
	_tmp196_ = font_size_box;
	gtk_container_add ((GtkContainer*) _tmp195_, (GtkWidget*) _tmp196_);
	_tmp197_ = menu_box;
	_tmp198_ = find_box;
	gtk_container_add ((GtkContainer*) _tmp197_, (GtkWidget*) _tmp198_);
	_tmp199_ = menu_box;
	_tmp200_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	g_object_ref_sink (_tmp200_);
	_tmp201_ = _tmp200_;
	gtk_container_add ((GtkContainer*) _tmp199_, (GtkWidget*) _tmp201_);
	_g_object_unref0 (_tmp201_);
	_tmp202_ = menu_box;
	_tmp203_ = follow_system_switchmodelbutton;
	gtk_container_add ((GtkContainer*) _tmp202_, (GtkWidget*) _tmp203_);
	_tmp204_ = menu_box;
	_tmp205_ = color_revealer;
	gtk_container_add ((GtkContainer*) _tmp204_, (GtkWidget*) _tmp205_);
	_tmp206_ = menu_box;
	_tmp207_ = panels_box;
	gtk_container_add ((GtkContainer*) _tmp206_, (GtkWidget*) _tmp207_);
	_tmp208_ = menu_box;
	_tmp209_ = menu_separator;
	gtk_container_add ((GtkContainer*) _tmp208_, (GtkWidget*) _tmp209_);
	_tmp210_ = menu_box;
	_tmp211_ = preferences_menuitem;
	gtk_container_add ((GtkContainer*) _tmp210_, (GtkWidget*) _tmp211_);
	_tmp212_ = menu_box;
	gtk_widget_show_all ((GtkWidget*) _tmp212_);
	_tmp213_ = (GtkPopover*) gtk_popover_new (NULL);
	g_object_ref_sink (_tmp213_);
	menu = _tmp213_;
	_tmp214_ = menu;
	_tmp215_ = menu_box;
	gtk_container_add ((GtkContainer*) _tmp214_, (GtkWidget*) _tmp215_);
	_tmp216_ = (GtkImage*) gtk_image_new_from_icon_name ("open-menu", (GtkIconSize) GTK_ICON_SIZE_LARGE_TOOLBAR);
	g_object_ref_sink (_tmp216_);
	_tmp217_ = menu;
	_tmp218_ = _g_object_ref0 (_tmp217_);
	_tmp219_ = g_strdup (_ ("Menu"));
	_tmp220_ = (GtkMenuButton*) gtk_menu_button_new ();
	gtk_button_set_image ((GtkButton*) _tmp220_, (GtkWidget*) _tmp216_);
	_g_object_unref0 (_tmp216_);
	gtk_menu_button_set_popover (_tmp220_, _tmp218_);
	_g_object_unref0 (_tmp218_);
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp220_, _tmp219_);
	_g_free0 (_tmp219_);
	g_object_ref_sink (_tmp220_);
	app_menu = _tmp220_;
	_tmp221_ = code_format_bar_new ();
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp221_, TRUE);
	gtk_widget_set_valign ((GtkWidget*) _tmp221_, GTK_ALIGN_CENTER);
	g_object_ref_sink (_tmp221_);
	_g_object_unref0 (self->format_bar);
	self->format_bar = _tmp221_;
	_tmp222_ = self->format_bar;
	hdy_header_bar_set_custom_title ((HdyHeaderBar*) self, (GtkWidget*) _tmp222_);
	_tmp223_ = open_button;
	hdy_header_bar_pack_start ((HdyHeaderBar*) self, (GtkWidget*) _tmp223_);
	_tmp224_ = self->priv->_templates_button;
	hdy_header_bar_pack_start ((HdyHeaderBar*) self, (GtkWidget*) _tmp224_);
	_tmp225_ = _data46_->save_button;
	hdy_header_bar_pack_start ((HdyHeaderBar*) self, (GtkWidget*) _tmp225_);
	_tmp226_ = save_as_button;
	hdy_header_bar_pack_start ((HdyHeaderBar*) self, (GtkWidget*) _tmp226_);
	_tmp227_ = revert_button;
	hdy_header_bar_pack_start ((HdyHeaderBar*) self, (GtkWidget*) _tmp227_);
	_tmp228_ = app_menu;
	hdy_header_bar_pack_end ((HdyHeaderBar*) self, (GtkWidget*) _tmp228_);
	_tmp229_ = self->share_menu_button;
	hdy_header_bar_pack_end ((HdyHeaderBar*) self, (GtkWidget*) _tmp229_);
	_tmp230_ = self->share_menu;
	g_signal_connect_object ((GMenuModel*) _tmp230_, "items-changed", (GCallback) _scratch_header_bar_on_share_menu_changed_g_menu_model_items_changed, self, 0);
	g_signal_connect_data ((GtkWidget*) self, "realize", (GCallback) __scratch_header_bar___lambda60__gtk_widget_realize, block46_data_ref (_data46_), (GClosureNotify) block46_data_unref, 0);
	_tmp231_ = scratch_settings;
	g_signal_connect_data (_tmp231_, "changed::autosave", (GCallback) __scratch_header_bar___lambda61__g_settings_changed, block46_data_ref (_data46_), (GClosureNotify) block46_data_unref, 0);
	_tmp232_ = scratch_settings;
	g_signal_connect_data (_tmp232_, "changed::font", (GCallback) __scratch_header_bar___lambda62__g_settings_changed, block46_data_ref (_data46_), (GClosureNotify) block46_data_unref, 0);
	_tmp233_ = follow_system_switchmodelbutton;
	_tmp234_ = color_revealer;
	g_object_bind_property_with_closures ((GObject*) _tmp233_, "active", (GObject*) _tmp234_, "reveal-child", G_BINDING_SYNC_CREATE | G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp235_ = scratch_settings;
	_tmp236_ = follow_system_switchmodelbutton;
	g_settings_bind (_tmp235_, "follow-system-style", (GObject*) _tmp236_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp237_ = gtk_settings_get_default ();
	_tmp238_ = _g_object_ref0 (_tmp237_);
	_data46_->gtk_settings = _tmp238_;
	_tmp239_ = scratch_settings;
	_tmp240_ = g_settings_get_string (_tmp239_, "style-scheme");
	_tmp241_ = _tmp240_;
	_tmp243_ = (NULL == _tmp241_) ? 0 : g_quark_from_string (_tmp241_);
	g_free (_tmp241_);
	if (_tmp243_ == ((0 != _tmp242_label0) ? _tmp242_label0 : (_tmp242_label0 = g_quark_from_static_string (SCRATCH_HEADER_BAR_STYLE_SCHEME_HIGH_CONTRAST)))) {
		switch (0) {
			default:
			{
				GtkRadioButton* _tmp244_;
				_tmp244_ = color_button_white;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp244_, TRUE);
				break;
			}
		}
	} else if (_tmp243_ == ((0 != _tmp242_label1) ? _tmp242_label1 : (_tmp242_label1 = g_quark_from_static_string (SCRATCH_HEADER_BAR_STYLE_SCHEME_LIGHT)))) {
		switch (0) {
			default:
			{
				GtkRadioButton* _tmp245_;
				_tmp245_ = color_button_light;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp245_, TRUE);
				break;
			}
		}
	} else if (_tmp243_ == ((0 != _tmp242_label2) ? _tmp242_label2 : (_tmp242_label2 = g_quark_from_static_string (SCRATCH_HEADER_BAR_STYLE_SCHEME_DARK)))) {
		switch (0) {
			default:
			{
				GtkRadioButton* _tmp246_;
				_tmp246_ = color_button_dark;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp246_, TRUE);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				GtkRadioButton* _tmp247_;
				_tmp247_ = color_button_none;
				gtk_toggle_button_set_active ((GtkToggleButton*) _tmp247_, TRUE);
			}
		}
	}
	_tmp248_ = color_button_dark;
	g_signal_connect_data ((GtkButton*) _tmp248_, "clicked", (GCallback) __scratch_header_bar___lambda63__gtk_button_clicked, block46_data_ref (_data46_), (GClosureNotify) block46_data_unref, 0);
	_tmp249_ = color_button_light;
	g_signal_connect_data ((GtkButton*) _tmp249_, "clicked", (GCallback) __scratch_header_bar___lambda64__gtk_button_clicked, block46_data_ref (_data46_), (GClosureNotify) block46_data_unref, 0);
	_tmp250_ = color_button_white;
	g_signal_connect_data ((GtkButton*) _tmp250_, "clicked", (GCallback) __scratch_header_bar___lambda65__gtk_button_clicked, block46_data_ref (_data46_), (GClosureNotify) block46_data_unref, 0);
	_g_object_unref0 (app_menu);
	_g_object_unref0 (menu);
	_g_object_unref0 (menu_box);
	_g_object_unref0 (preferences_menuitem);
	_g_object_unref0 (panels_box);
	_g_object_unref0 (menu_separator);
	_g_object_unref0 (color_revealer);
	_g_object_unref0 (color_box);
	_g_object_unref0 (color_button_dark);
	_g_object_unref0 (color_button_light);
	_g_object_unref0 (color_button_white);
	_g_object_unref0 (color_button_none);
	_g_object_unref0 (follow_system_switchmodelbutton);
	_g_object_unref0 (find_box);
	_g_object_unref0 (search_button);
	_g_object_unref0 (font_size_box);
	_g_object_unref0 (zoom_in_button);
	_g_object_unref0 (zoom_out_button);
	_g_object_unref0 (revert_button);
	_g_object_unref0 (save_as_button);
	_g_object_unref0 (open_button);
	block46_data_unref (_data46_);
	_data46_ = NULL;
	return obj;
}

static void
scratch_header_bar_class_init (ScratchHeaderBarClass * klass,
                               gpointer klass_data)
{
	scratch_header_bar_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &ScratchHeaderBar_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_scratch_header_bar_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_scratch_header_bar_set_property;
	G_OBJECT_CLASS (klass)->constructor = scratch_header_bar_constructor;
	G_OBJECT_CLASS (klass)->finalize = scratch_header_bar_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_HEADER_BAR_TEMPLATES_BUTTON_PROPERTY, scratch_header_bar_properties[SCRATCH_HEADER_BAR_TEMPLATES_BUTTON_PROPERTY] = g_param_spec_object ("templates-button", "templates-button", "templates-button", gtk_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_HEADER_BAR_FIND_BUTTON_PROPERTY, scratch_header_bar_properties[SCRATCH_HEADER_BAR_FIND_BUTTON_PROPERTY] = g_param_spec_object ("find-button", "find-button", "find-button", gtk_toggle_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_HEADER_BAR_OUTLINE_BUTTON_PROPERTY, scratch_header_bar_properties[SCRATCH_HEADER_BAR_OUTLINE_BUTTON_PROPERTY] = g_param_spec_object ("outline-button", "outline-button", "outline-button", gtk_toggle_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_HEADER_BAR_SIDEBAR_BUTTON_PROPERTY, scratch_header_bar_properties[SCRATCH_HEADER_BAR_SIDEBAR_BUTTON_PROPERTY] = g_param_spec_object ("sidebar-button", "sidebar-button", "sidebar-button", gtk_toggle_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SCRATCH_HEADER_BAR_TERMINAL_BUTTON_PROPERTY, scratch_header_bar_properties[SCRATCH_HEADER_BAR_TERMINAL_BUTTON_PROPERTY] = g_param_spec_object ("terminal-button", "terminal-button", "terminal-button", gtk_toggle_button_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
scratch_header_bar_instance_init (ScratchHeaderBar * self,
                                  gpointer klass)
{
	self->priv = scratch_header_bar_get_instance_private (self);
}

static void
scratch_header_bar_finalize (GObject * obj)
{
	ScratchHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SCRATCH_TYPE_HEADER_BAR, ScratchHeaderBar);
	_g_object_unref0 (self->format_bar);
	_g_object_unref0 (self->share_menu);
	_g_object_unref0 (self->share_menu_button);
	_g_object_unref0 (self->priv->_templates_button);
	_g_object_unref0 (self->priv->_find_button);
	_g_object_unref0 (self->priv->_outline_button);
	_g_object_unref0 (self->priv->_sidebar_button);
	_g_object_unref0 (self->priv->_terminal_button);
	G_OBJECT_CLASS (scratch_header_bar_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
scratch_header_bar_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ScratchHeaderBarClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) scratch_header_bar_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ScratchHeaderBar), 0, (GInstanceInitFunc) scratch_header_bar_instance_init, NULL };
	GType scratch_header_bar_type_id;
	scratch_header_bar_type_id = g_type_register_static (hdy_header_bar_get_type (), "ScratchHeaderBar", &g_define_type_info, 0);
	ScratchHeaderBar_private_offset = g_type_add_instance_private (scratch_header_bar_type_id, sizeof (ScratchHeaderBarPrivate));
	return scratch_header_bar_type_id;
}

GType
scratch_header_bar_get_type (void)
{
	static gsize scratch_header_bar_type_id__once = 0;
	if (g_once_init_enter (&scratch_header_bar_type_id__once)) {
		GType scratch_header_bar_type_id;
		scratch_header_bar_type_id = scratch_header_bar_get_type_once ();
		g_once_init_leave (&scratch_header_bar_type_id__once, scratch_header_bar_type_id);
	}
	return scratch_header_bar_type_id__once;
}

static void
_vala_scratch_header_bar_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec)
{
	ScratchHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_TYPE_HEADER_BAR, ScratchHeaderBar);
	switch (property_id) {
		case SCRATCH_HEADER_BAR_TEMPLATES_BUTTON_PROPERTY:
		g_value_set_object (value, scratch_header_bar_get_templates_button (self));
		break;
		case SCRATCH_HEADER_BAR_FIND_BUTTON_PROPERTY:
		g_value_set_object (value, scratch_header_bar_get_find_button (self));
		break;
		case SCRATCH_HEADER_BAR_OUTLINE_BUTTON_PROPERTY:
		g_value_set_object (value, scratch_header_bar_get_outline_button (self));
		break;
		case SCRATCH_HEADER_BAR_SIDEBAR_BUTTON_PROPERTY:
		g_value_set_object (value, scratch_header_bar_get_sidebar_button (self));
		break;
		case SCRATCH_HEADER_BAR_TERMINAL_BUTTON_PROPERTY:
		g_value_set_object (value, scratch_header_bar_get_terminal_button (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_scratch_header_bar_set_property (GObject * object,
                                       guint property_id,
                                       const GValue * value,
                                       GParamSpec * pspec)
{
	ScratchHeaderBar * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SCRATCH_TYPE_HEADER_BAR, ScratchHeaderBar);
	switch (property_id) {
		case SCRATCH_HEADER_BAR_TEMPLATES_BUTTON_PROPERTY:
		scratch_header_bar_set_templates_button (self, g_value_get_object (value));
		break;
		case SCRATCH_HEADER_BAR_FIND_BUTTON_PROPERTY:
		scratch_header_bar_set_find_button (self, g_value_get_object (value));
		break;
		case SCRATCH_HEADER_BAR_OUTLINE_BUTTON_PROPERTY:
		scratch_header_bar_set_outline_button (self, g_value_get_object (value));
		break;
		case SCRATCH_HEADER_BAR_SIDEBAR_BUTTON_PROPERTY:
		scratch_header_bar_set_sidebar_button (self, g_value_get_object (value));
		break;
		case SCRATCH_HEADER_BAR_TERMINAL_BUTTON_PROPERTY:
		scratch_header_bar_set_terminal_button (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

