/* FileConflictDialog.c generated by valac 0.56.18, the Vala compiler
 * generated from FileConflictDialog.vala, do not modify */

/* Copyright 2018-2021 elementary, Inc. (https://elementary.io)
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation, Inc.,; either version 2 of
 * the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this program; if not, write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301, USA.
 */

#include "pantheon-files-core.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gtk/gtk.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <granite.h>
#include <float.h>
#include <math.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	FILES_FILE_CONFLICT_DIALOG_0_PROPERTY,
	FILES_FILE_CONFLICT_DIALOG_NEW_NAME_PROPERTY,
	FILES_FILE_CONFLICT_DIALOG_APPLY_TO_ALL_PROPERTY,
	FILES_FILE_CONFLICT_DIALOG_NUM_PROPERTIES
};
static GParamSpec* files_file_conflict_dialog_properties[FILES_FILE_CONFLICT_DIALOG_NUM_PROPERTIES];
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block13Data Block13Data;

struct _FilesFileConflictDialogPrivate {
	gchar* conflict_name;
	GtkEntry* rename_entry;
	GtkButton* replace_button;
	GtkButton* keep_newest_button;
	GtkCheckButton* apply_all_checkbutton;
	FilesFile* source;
	FilesFile* destination;
	FilesFile* dest_dir;
	GtkImage* source_image;
	GtkLabel* source_size_label;
	GtkLabel* source_type_label;
	GtkLabel* source_time_label;
	GtkImage* destination_image;
	GtkLabel* destination_size_label;
	GtkLabel* destination_type_label;
	GtkLabel* destination_time_label;
};

struct _Block13Data {
	int _ref_count_;
	FilesFileConflictDialog* self;
	GtkExpander* expander;
	GtkButton* rename_button;
};

static gint FilesFileConflictDialog_private_offset;
static gpointer files_file_conflict_dialog_parent_class = NULL;

static void __lambda40_ (FilesFileConflictDialog* self);
static void ___lambda40__files_thumbnailer_finished (FilesThumbnailer* _sender,
                                              guint request,
                                              gpointer self);
static void files_file_conflict_dialog_file_list_ready_cb (FilesFileConflictDialog* self,
                                                    GList* files);
static void _files_file_conflict_dialog_file_list_ready_cb_filescallwhenreadycall_when_ready_func (GList* files,
                                                                                            gpointer self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static void __lambda41_ (FilesFileConflictDialog* self);
static void ___lambda41__files_file_changed (FilesFile* _sender,
                                      gpointer self);
static void __lambda42_ (FilesFileConflictDialog* self);
static void ___lambda42__files_file_changed (FilesFile* _sender,
                                      gpointer self);
static GObject * files_file_conflict_dialog_constructor (GType type,
                                                  guint n_construct_properties,
                                                  GObjectConstructParam * construct_properties);
static Block13Data* block13_data_ref (Block13Data* _data13_);
static void block13_data_unref (void * _userdata_);
static void _files_file_conflict_dialog___lambda43_ (Block13Data* _data13_);
static void __files_file_conflict_dialog___lambda43__gtk_expander_activate (GtkExpander* _sender,
                                                                     gpointer self);
static void _files_file_conflict_dialog___lambda44_ (Block13Data* _data13_);
static void __files_file_conflict_dialog___lambda44__gtk_editable_changed (GtkEditable* _sender,
                                                                    gpointer self);
static void _files_file_conflict_dialog___lambda45_ (FilesFileConflictDialog* self);
static void __files_file_conflict_dialog___lambda45__gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self);
static void _files_file_conflict_dialog___lambda46_ (Block13Data* _data13_);
static void __files_file_conflict_dialog___lambda46__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                         gpointer self);
static void files_file_conflict_dialog_finalize (GObject * obj);
static GType files_file_conflict_dialog_get_type_once (void);
static void _vala_files_file_conflict_dialog_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);

static inline gpointer
files_file_conflict_dialog_get_instance_private (FilesFileConflictDialog* self)
{
	return G_STRUCT_MEMBER_P (self, FilesFileConflictDialog_private_offset);
}

 G_GNUC_NO_INLINE static GType
files_file_conflict_dialog_response_type_get_type_once (void)
{
	static const GEnumValue values[] = {{FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_SKIP, "FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_SKIP", "skip"}, {FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_RENAME, "FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_RENAME", "rename"}, {FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_REPLACE, "FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_REPLACE", "replace"}, {FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_NEWEST, "FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_NEWEST", "newest"}, {0, NULL, NULL}};
	GType files_file_conflict_dialog_response_type_type_id;
	files_file_conflict_dialog_response_type_type_id = g_enum_register_static ("FilesFileConflictDialogResponseType", values);
	return files_file_conflict_dialog_response_type_type_id;
}

GType
files_file_conflict_dialog_response_type_get_type (void)
{
	static volatile gsize files_file_conflict_dialog_response_type_type_id__once = 0;
	if (g_once_init_enter (&files_file_conflict_dialog_response_type_type_id__once)) {
		GType files_file_conflict_dialog_response_type_type_id;
		files_file_conflict_dialog_response_type_type_id = files_file_conflict_dialog_response_type_get_type_once ();
		g_once_init_leave (&files_file_conflict_dialog_response_type_type_id__once, files_file_conflict_dialog_response_type_type_id);
	}
	return files_file_conflict_dialog_response_type_type_id__once;
}

static void
__lambda40_ (FilesFileConflictDialog* self)
{
	GtkImage* _tmp0_;
	FilesFile* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	_tmp0_ = self->priv->destination_image;
	_tmp1_ = self->priv->destination;
	_tmp2_ = files_file_get_icon_pixbuf (_tmp1_, 64, gtk_widget_get_scale_factor ((GtkWidget*) self), FILES_FILE_ICON_FLAGS_USE_THUMBNAILS);
	_tmp3_ = _tmp2_;
	g_object_set (_tmp0_, "gicon", (GIcon*) _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
}

static void
___lambda40__files_thumbnailer_finished (FilesThumbnailer* _sender,
                                         guint request,
                                         gpointer self)
{
	__lambda40_ ((FilesFileConflictDialog*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_files_file_conflict_dialog_file_list_ready_cb_filescallwhenreadycall_when_ready_func (GList* files,
                                                                                       gpointer self)
{
	files_file_conflict_dialog_file_list_ready_cb ((FilesFileConflictDialog*) self, files);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

FilesFileConflictDialog*
files_file_conflict_dialog_construct (GType object_type,
                                      GtkWindow* parent,
                                      GFile* _source,
                                      GFile* _destination,
                                      GFile* _dest_dir)
{
	FilesFileConflictDialog * self = NULL;
	FilesFile* _tmp0_;
	FilesFile* _tmp1_;
	FilesFile* _tmp2_;
	FilesThumbnailer* thumbnailer = NULL;
	FilesThumbnailer* _tmp3_;
	FilesFile* _tmp4_;
	GtkLabel* _tmp5_;
	FilesFile* _tmp6_;
	const gchar* _tmp7_;
	GtkLabel* _tmp8_;
	FilesFile* _tmp9_;
	const gchar* _tmp10_;
	FilesFile* _tmp11_;
	GList* files = NULL;
	FilesFile* _tmp12_;
	FilesFile* _tmp13_;
	FilesFile* _tmp14_;
	FilesFile* _tmp15_;
	FilesFile* _tmp16_;
	FilesFile* _tmp17_;
	FilesCallWhenReady* _tmp18_;
	FilesCallWhenReady* _tmp19_;
	g_return_val_if_fail (parent != NULL, NULL);
	g_return_val_if_fail (_source != NULL, NULL);
	g_return_val_if_fail (_destination != NULL, NULL);
	g_return_val_if_fail (_dest_dir != NULL, NULL);
	self = (FilesFileConflictDialog*) g_object_new (object_type, "title", _ ("File conflict"), "transient-for", parent, "resizable", FALSE, NULL);
	_tmp0_ = files_file_get (_source);
	_g_object_unref0 (self->priv->source);
	self->priv->source = _tmp0_;
	_tmp1_ = files_file_get (_destination);
	_g_object_unref0 (self->priv->destination);
	self->priv->destination = _tmp1_;
	_tmp2_ = self->priv->destination;
	files_file_query_update (_tmp2_);
	_tmp3_ = files_thumbnailer_get ();
	thumbnailer = _tmp3_;
	g_signal_connect_object (thumbnailer, "finished", (GCallback) ___lambda40__files_thumbnailer_finished, self, 0);
	_tmp4_ = self->priv->destination;
	files_thumbnailer_queue_file (thumbnailer, _tmp4_, NULL);
	_tmp5_ = self->priv->destination_size_label;
	_tmp6_ = self->priv->destination;
	_tmp7_ = _tmp6_->format_size;
	gtk_label_set_label (_tmp5_, _tmp7_);
	_tmp8_ = self->priv->destination_time_label;
	_tmp9_ = self->priv->destination;
	_tmp10_ = _tmp9_->formated_modified;
	gtk_label_set_label (_tmp8_, _tmp10_);
	_tmp11_ = files_file_get (_dest_dir);
	_g_object_unref0 (self->priv->dest_dir);
	self->priv->dest_dir = _tmp11_;
	files = NULL;
	_tmp12_ = self->priv->source;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	files = g_list_prepend (files, _tmp13_);
	_tmp14_ = self->priv->destination;
	_tmp15_ = _g_object_ref0 (_tmp14_);
	files = g_list_prepend (files, _tmp15_);
	_tmp16_ = self->priv->dest_dir;
	_tmp17_ = _g_object_ref0 (_tmp16_);
	files = g_list_prepend (files, _tmp17_);
	_tmp18_ = files_call_when_ready_new (files, _files_file_conflict_dialog_file_list_ready_cb_filescallwhenreadycall_when_ready_func, self);
	_tmp19_ = _tmp18_;
	_g_object_unref0 (_tmp19_);
	(files == NULL) ? NULL : (files = (_g_list_free__g_object_unref0_ (files), NULL));
	_g_object_unref0 (thumbnailer);
	return self;
}

FilesFileConflictDialog*
files_file_conflict_dialog_new (GtkWindow* parent,
                                GFile* _source,
                                GFile* _destination,
                                GFile* _dest_dir)
{
	return files_file_conflict_dialog_construct (FILES_TYPE_FILE_CONFLICT_DIALOG, parent, _source, _destination, _dest_dir);
}

static void
__lambda41_ (FilesFileConflictDialog* self)
{
	GtkImage* _tmp0_;
	FilesFile* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	_tmp0_ = self->priv->source_image;
	_tmp1_ = self->priv->source;
	_tmp2_ = files_file_get_icon_pixbuf (_tmp1_, 64, gtk_widget_get_scale_factor ((GtkWidget*) self), FILES_FILE_ICON_FLAGS_USE_THUMBNAILS);
	_tmp3_ = _tmp2_;
	g_object_set (_tmp0_, "gicon", (GIcon*) _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
}

static void
___lambda41__files_file_changed (FilesFile* _sender,
                                 gpointer self)
{
	__lambda41_ ((FilesFileConflictDialog*) self);
}

static void
__lambda42_ (FilesFileConflictDialog* self)
{
	GtkImage* _tmp0_;
	FilesFile* _tmp1_;
	GdkPixbuf* _tmp2_;
	GdkPixbuf* _tmp3_;
	_tmp0_ = self->priv->destination_image;
	_tmp1_ = self->priv->destination;
	_tmp2_ = files_file_get_icon_pixbuf (_tmp1_, 64, gtk_widget_get_scale_factor ((GtkWidget*) self), FILES_FILE_ICON_FLAGS_USE_THUMBNAILS);
	_tmp3_ = _tmp2_;
	g_object_set (_tmp0_, "gicon", (GIcon*) _tmp3_, NULL);
	_g_object_unref0 (_tmp3_);
}

static void
___lambda42__files_file_changed (FilesFile* _sender,
                                 gpointer self)
{
	__lambda42_ ((FilesFileConflictDialog*) self);
}

static void
files_file_conflict_dialog_file_list_ready_cb (FilesFileConflictDialog* self,
                                               GList* files)
{
	const gchar* src_ftype = NULL;
	FilesFile* _tmp0_;
	const gchar* _tmp1_;
	const gchar* dest_ftype = NULL;
	FilesFile* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp8_;
	gboolean should_show_type = FALSE;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* dest_name = NULL;
	FilesFile* _tmp14_;
	const gchar* _tmp15_;
	const gchar* dest_dir_name = NULL;
	FilesFile* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* message_extra = NULL;
	gchar* message = NULL;
	FilesFile* _tmp20_;
	GtkLabel* _tmp62_;
	GtkLabel* _tmp63_;
	const gchar* _tmp64_;
	const gchar* _tmp65_;
	gchar* _tmp66_;
	gchar* _tmp67_;
	GtkImage* _tmp68_;
	FilesFile* _tmp69_;
	GdkPixbuf* _tmp70_;
	GdkPixbuf* _tmp71_;
	GtkLabel* _tmp72_;
	FilesFile* _tmp73_;
	const gchar* _tmp74_;
	GtkLabel* _tmp75_;
	FilesFile* _tmp76_;
	const gchar* _tmp77_;
	gboolean _tmp78_ = FALSE;
	gboolean _tmp84_ = FALSE;
	GtkEntry* _tmp90_;
	const gchar* _tmp91_;
	gboolean _tmp92_ = FALSE;
	FilesFile* _tmp93_;
	FilesFile* _tmp96_;
	FilesFile* _tmp97_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->source;
	_tmp1_ = files_file_get_ftype (_tmp0_);
	src_ftype = _tmp1_;
	_tmp2_ = self->priv->destination;
	_tmp3_ = files_file_get_ftype (_tmp2_);
	dest_ftype = _tmp3_;
	_tmp4_ = src_ftype;
	if (_tmp4_ == NULL) {
		FilesFile* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->source;
		_tmp6_ = files_file_get_uri (_tmp5_);
		_tmp7_ = _tmp6_;
		g_critical ("FileConflictDialog.vala:277: Could not determine file type of source f" \
"ile: %s", _tmp7_);
	}
	_tmp8_ = dest_ftype;
	if (_tmp8_ == NULL) {
		FilesFile* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp9_ = self->priv->destination;
		_tmp10_ = files_file_get_uri (_tmp9_);
		_tmp11_ = _tmp10_;
		g_critical ("FileConflictDialog.vala:281: Could not determine file type of source f" \
"ile: %s", _tmp11_);
	}
	_tmp12_ = src_ftype;
	_tmp13_ = dest_ftype;
	should_show_type = g_strcmp0 (_tmp12_, _tmp13_) != 0;
	_tmp14_ = self->priv->destination;
	_tmp15_ = files_file_get_display_name (_tmp14_);
	dest_name = _tmp15_;
	_tmp16_ = self->priv->dest_dir;
	_tmp17_ = files_file_get_display_name (_tmp16_);
	dest_dir_name = _tmp17_;
	_tmp18_ = dest_name;
	_tmp19_ = g_strdup (_tmp18_);
	_g_free0 (self->priv->conflict_name);
	self->priv->conflict_name = _tmp19_;
	_tmp20_ = self->priv->destination;
	if (_tmp20_->is_directory) {
		FilesFile* _tmp21_;
		_tmp21_ = self->priv->source;
		if (_tmp21_->is_directory) {
			GtkLabel* _tmp22_;
			GtkLabel* _tmp23_;
			const gchar* _tmp24_;
			gchar* _tmp25_;
			gchar* _tmp26_;
			gchar* _tmp27_;
			FilesFile* _tmp28_;
			FilesFile* _tmp29_;
			_tmp22_ = granite_message_dialog_get_primary_label ((GraniteMessageDialog*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = dest_name;
			_tmp25_ = g_strdup_printf (_ ("Merge folder \"%s\"?"), _tmp24_);
			_tmp26_ = _tmp25_;
			gtk_label_set_label (_tmp23_, _tmp26_);
			_g_free0 (_tmp26_);
			_tmp27_ = g_strdup (_ ("Merging will ask for confirmation before replacing any files in the fo" \
"lder that conflict with the files being copied."));
			_g_free0 (message_extra);
			message_extra = _tmp27_;
			_tmp28_ = self->priv->source;
			_tmp29_ = self->priv->destination;
			if (_tmp28_->modified > _tmp29_->modified) {
				const gchar* _tmp30_;
				gchar* _tmp31_;
				_tmp30_ = dest_dir_name;
				_tmp31_ = g_strdup_printf (_ ("An older folder with the same name already exists in \"%s\"."), _tmp30_);
				_g_free0 (message);
				message = _tmp31_;
			} else {
				FilesFile* _tmp32_;
				FilesFile* _tmp33_;
				_tmp32_ = self->priv->source;
				_tmp33_ = self->priv->destination;
				if (_tmp32_->modified < _tmp33_->modified) {
					const gchar* _tmp34_;
					gchar* _tmp35_;
					_tmp34_ = dest_dir_name;
					_tmp35_ = g_strdup_printf (_ ("A newer folder with the same name already exists in \"%s\"."), _tmp34_);
					_g_free0 (message);
					message = _tmp35_;
				} else {
					const gchar* _tmp36_;
					gchar* _tmp37_;
					_tmp36_ = dest_dir_name;
					_tmp37_ = g_strdup_printf (_ ("Another folder with the same name already exists in \"%s\"."), _tmp36_);
					_g_free0 (message);
					message = _tmp37_;
				}
			}
		} else {
			GtkLabel* _tmp38_;
			GtkLabel* _tmp39_;
			const gchar* _tmp40_;
			gchar* _tmp41_;
			gchar* _tmp42_;
			gchar* _tmp43_;
			const gchar* _tmp44_;
			gchar* _tmp45_;
			_tmp38_ = granite_message_dialog_get_primary_label ((GraniteMessageDialog*) self);
			_tmp39_ = _tmp38_;
			_tmp40_ = dest_name;
			_tmp41_ = g_strdup_printf (_ ("Replace folder \"%s\"?"), _tmp40_);
			_tmp42_ = _tmp41_;
			gtk_label_set_label (_tmp39_, _tmp42_);
			_g_free0 (_tmp42_);
			_tmp43_ = g_strdup (_ ("Replacing it will remove all files in the folder."));
			_g_free0 (message_extra);
			message_extra = _tmp43_;
			_tmp44_ = dest_dir_name;
			_tmp45_ = g_strdup_printf (_ ("A folder with the same name already exists in \"%s\"."), _tmp44_);
			_g_free0 (message);
			message = _tmp45_;
		}
	} else {
		GtkLabel* _tmp46_;
		GtkLabel* _tmp47_;
		const gchar* _tmp48_;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gchar* _tmp51_;
		FilesFile* _tmp52_;
		FilesFile* _tmp53_;
		_tmp46_ = granite_message_dialog_get_primary_label ((GraniteMessageDialog*) self);
		_tmp47_ = _tmp46_;
		_tmp48_ = dest_name;
		_tmp49_ = g_strdup_printf (_ ("Replace file \"%s\"?"), _tmp48_);
		_tmp50_ = _tmp49_;
		gtk_label_set_label (_tmp47_, _tmp50_);
		_g_free0 (_tmp50_);
		_tmp51_ = g_strdup (_ ("Replacing it will overwrite its content."));
		_g_free0 (message_extra);
		message_extra = _tmp51_;
		_tmp52_ = self->priv->source;
		_tmp53_ = self->priv->destination;
		if (_tmp52_->modified > _tmp53_->modified) {
			const gchar* _tmp54_;
			gchar* _tmp55_;
			_tmp54_ = dest_dir_name;
			_tmp55_ = g_strdup_printf (_ ("An older file with the same name already exists in \"%s\"."), _tmp54_);
			_g_free0 (message);
			message = _tmp55_;
		} else {
			FilesFile* _tmp56_;
			FilesFile* _tmp57_;
			_tmp56_ = self->priv->source;
			_tmp57_ = self->priv->destination;
			if (_tmp56_->modified < _tmp57_->modified) {
				const gchar* _tmp58_;
				gchar* _tmp59_;
				_tmp58_ = dest_dir_name;
				_tmp59_ = g_strdup_printf (_ ("A newer file with the same name already exists in \"%s\"."), _tmp58_);
				_g_free0 (message);
				message = _tmp59_;
			} else {
				const gchar* _tmp60_;
				gchar* _tmp61_;
				_tmp60_ = dest_dir_name;
				_tmp61_ = g_strdup_printf (_ ("Another file with the same name already exists in \"%s\"."), _tmp60_);
				_g_free0 (message);
				message = _tmp61_;
			}
		}
	}
	_tmp62_ = granite_message_dialog_get_secondary_label ((GraniteMessageDialog*) self);
	_tmp63_ = _tmp62_;
	_tmp64_ = message;
	_tmp65_ = message_extra;
	_tmp66_ = g_strdup_printf ("%s %s", _tmp64_, _tmp65_);
	_tmp67_ = _tmp66_;
	gtk_label_set_label (_tmp63_, _tmp67_);
	_g_free0 (_tmp67_);
	_tmp68_ = self->priv->source_image;
	_tmp69_ = self->priv->source;
	_tmp70_ = files_file_get_icon_pixbuf (_tmp69_, 64, gtk_widget_get_scale_factor ((GtkWidget*) self), FILES_FILE_ICON_FLAGS_USE_THUMBNAILS);
	_tmp71_ = _tmp70_;
	g_object_set (_tmp68_, "gicon", (GIcon*) _tmp71_, NULL);
	_g_object_unref0 (_tmp71_);
	_tmp72_ = self->priv->source_size_label;
	_tmp73_ = self->priv->source;
	_tmp74_ = _tmp73_->format_size;
	gtk_label_set_label (_tmp72_, _tmp74_);
	_tmp75_ = self->priv->source_time_label;
	_tmp76_ = self->priv->source;
	_tmp77_ = _tmp76_->formated_modified;
	gtk_label_set_label (_tmp75_, _tmp77_);
	if (should_show_type) {
		const gchar* _tmp79_;
		_tmp79_ = src_ftype;
		_tmp78_ = _tmp79_ != NULL;
	} else {
		_tmp78_ = FALSE;
	}
	if (_tmp78_) {
		GtkLabel* _tmp80_;
		const gchar* _tmp81_;
		_tmp80_ = self->priv->source_type_label;
		_tmp81_ = src_ftype;
		gtk_label_set_label (_tmp80_, _tmp81_);
	} else {
		GtkLabel* _tmp82_;
		GtkLabel* _tmp83_;
		_tmp82_ = self->priv->source_type_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp82_, FALSE);
		_tmp83_ = self->priv->source_type_label;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp83_, TRUE);
	}
	if (should_show_type) {
		const gchar* _tmp85_;
		_tmp85_ = dest_ftype;
		_tmp84_ = _tmp85_ != NULL;
	} else {
		_tmp84_ = FALSE;
	}
	if (_tmp84_) {
		GtkLabel* _tmp86_;
		const gchar* _tmp87_;
		_tmp86_ = self->priv->destination_type_label;
		_tmp87_ = dest_ftype;
		gtk_label_set_label (_tmp86_, _tmp87_);
	} else {
		GtkLabel* _tmp88_;
		GtkLabel* _tmp89_;
		_tmp88_ = self->priv->destination_type_label;
		gtk_widget_set_visible ((GtkWidget*) _tmp88_, FALSE);
		_tmp89_ = self->priv->destination_type_label;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp89_, TRUE);
	}
	_tmp90_ = self->priv->rename_entry;
	_tmp91_ = self->priv->conflict_name;
	gtk_entry_set_text (_tmp90_, _tmp91_);
	_tmp93_ = self->priv->source;
	if (_tmp93_->is_directory) {
		FilesFile* _tmp94_;
		_tmp94_ = self->priv->destination;
		_tmp92_ = _tmp94_->is_directory;
	} else {
		_tmp92_ = FALSE;
	}
	if (_tmp92_) {
		GtkButton* _tmp95_;
		_tmp95_ = self->priv->replace_button;
		gtk_button_set_label (_tmp95_, _ ("Merge"));
	}
	_tmp96_ = self->priv->source;
	g_signal_connect_object (_tmp96_, "changed", (GCallback) ___lambda41__files_file_changed, self, 0);
	_tmp97_ = self->priv->destination;
	g_signal_connect_object (_tmp97_, "changed", (GCallback) ___lambda42__files_file_changed, self, 0);
	_g_free0 (message);
	_g_free0 (message_extra);
}

gchar*
files_file_conflict_dialog_get_new_name (FilesFileConflictDialog* self)
{
	gchar* result;
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->rename_entry;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
files_file_conflict_dialog_get_apply_to_all (FilesFileConflictDialog* self)
{
	gboolean result;
	GtkCheckButton* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->apply_all_checkbutton;
	_tmp1_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static Block13Data*
block13_data_ref (Block13Data* _data13_)
{
	g_atomic_int_inc (&_data13_->_ref_count_);
	return _data13_;
}

static void
block13_data_unref (void * _userdata_)
{
	Block13Data* _data13_;
	_data13_ = (Block13Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data13_->_ref_count_)) {
		FilesFileConflictDialog* self;
		self = _data13_->self;
		_g_object_unref0 (_data13_->rename_button);
		_g_object_unref0 (_data13_->expander);
		_g_object_unref0 (self);
		g_slice_free (Block13Data, _data13_);
	}
}

static void
_files_file_conflict_dialog___lambda43_ (Block13Data* _data13_)
{
	FilesFileConflictDialog* self;
	gboolean _tmp0_ = FALSE;
	GtkExpander* _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp3_;
	self = _data13_->self;
	_tmp1_ = _data13_->expander;
	_tmp2_ = gtk_expander_get_expanded (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		GtkEntry* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = self->priv->rename_entry;
		_tmp5_ = gtk_entry_get_text (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->conflict_name;
		_tmp0_ = g_strcmp0 (_tmp6_, _tmp7_) == 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkEntry* _tmp8_;
		gint start_offset = 0;
		gint end_offset = 0;
		const gchar* _tmp9_;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		GtkEntry* _tmp12_;
		_tmp8_ = self->priv->rename_entry;
		gtk_widget_grab_focus ((GtkWidget*) _tmp8_);
		_tmp9_ = self->priv->conflict_name;
		files_file_utils_get_rename_region (_tmp9_, &_tmp10_, &_tmp11_, FALSE);
		start_offset = _tmp10_;
		end_offset = _tmp11_;
		_tmp12_ = self->priv->rename_entry;
		gtk_editable_select_region ((GtkEditable*) _tmp12_, start_offset, end_offset);
	}
}

static void
__files_file_conflict_dialog___lambda43__gtk_expander_activate (GtkExpander* _sender,
                                                                gpointer self)
{
	_files_file_conflict_dialog___lambda43_ (self);
}

static void
_files_file_conflict_dialog___lambda44_ (Block13Data* _data13_)
{
	FilesFileConflictDialog* self;
	gboolean _tmp0_ = FALSE;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	self = _data13_->self;
	_tmp1_ = self->priv->rename_entry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	_tmp3_ = _tmp2_;
	if (g_strcmp0 (_tmp3_, "") != 0) {
		GtkEntry* _tmp4_;
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp4_ = self->priv->rename_entry;
		_tmp5_ = gtk_entry_get_text (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = self->priv->conflict_name;
		_tmp0_ = g_strcmp0 (_tmp6_, _tmp7_) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkButton* _tmp8_;
		GtkButton* _tmp9_;
		GtkCheckButton* _tmp10_;
		_tmp8_ = self->priv->replace_button;
		gtk_widget_hide ((GtkWidget*) _tmp8_);
		_tmp9_ = _data13_->rename_button;
		gtk_widget_show ((GtkWidget*) _tmp9_);
		_tmp10_ = self->priv->apply_all_checkbutton;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp10_, FALSE);
		gtk_dialog_set_default_response ((GtkDialog*) self, (gint) FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_RENAME);
	} else {
		GtkButton* _tmp11_;
		GtkButton* _tmp12_;
		GtkCheckButton* _tmp13_;
		_tmp11_ = self->priv->replace_button;
		gtk_widget_show ((GtkWidget*) _tmp11_);
		_tmp12_ = _data13_->rename_button;
		gtk_widget_hide ((GtkWidget*) _tmp12_);
		_tmp13_ = self->priv->apply_all_checkbutton;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp13_, TRUE);
		gtk_dialog_set_default_response ((GtkDialog*) self, (gint) FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_REPLACE);
	}
}

static void
__files_file_conflict_dialog___lambda44__gtk_editable_changed (GtkEditable* _sender,
                                                               gpointer self)
{
	_files_file_conflict_dialog___lambda44_ (self);
}

static void
_files_file_conflict_dialog___lambda45_ (FilesFileConflictDialog* self)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	GtkEntry* _tmp2_;
	gint start_offset = 0;
	gint end_offset = 0;
	const gchar* _tmp3_;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkEntry* _tmp6_;
	_tmp0_ = self->priv->rename_entry;
	_tmp1_ = self->priv->conflict_name;
	gtk_entry_set_text (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->rename_entry;
	gtk_widget_grab_focus ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->conflict_name;
	files_file_utils_get_rename_region (_tmp3_, &_tmp4_, &_tmp5_, FALSE);
	start_offset = _tmp4_;
	end_offset = _tmp5_;
	_tmp6_ = self->priv->rename_entry;
	gtk_editable_select_region ((GtkEditable*) _tmp6_, start_offset, end_offset);
}

static void
__files_file_conflict_dialog___lambda45__gtk_button_clicked (GtkButton* _sender,
                                                             gpointer self)
{
	_files_file_conflict_dialog___lambda45_ ((FilesFileConflictDialog*) self);
}

static void
_files_file_conflict_dialog___lambda46_ (Block13Data* _data13_)
{
	FilesFileConflictDialog* self;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GtkCheckButton* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	self = _data13_->self;
	_tmp2_ = self->priv->apply_all_checkbutton;
	_tmp3_ = gtk_toggle_button_get_active ((GtkToggleButton*) _tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		GtkEntry* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		_tmp5_ = self->priv->rename_entry;
		_tmp6_ = gtk_entry_get_text (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp1_ = g_strcmp0 (_tmp7_, "") == 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		GtkEntry* _tmp8_;
		const gchar* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		_tmp8_ = self->priv->rename_entry;
		_tmp9_ = gtk_entry_get_text (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp11_ = self->priv->conflict_name;
		_tmp0_ = g_strcmp0 (_tmp10_, _tmp11_) != 0;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkButton* _tmp12_;
		GtkButton* _tmp13_;
		_tmp12_ = self->priv->replace_button;
		gtk_widget_hide ((GtkWidget*) _tmp12_);
		_tmp13_ = _data13_->rename_button;
		gtk_widget_show ((GtkWidget*) _tmp13_);
	} else {
		GtkButton* _tmp14_;
		GtkButton* _tmp15_;
		_tmp14_ = _data13_->rename_button;
		gtk_widget_hide ((GtkWidget*) _tmp14_);
		_tmp15_ = self->priv->replace_button;
		gtk_widget_show ((GtkWidget*) _tmp15_);
	}
}

static void
__files_file_conflict_dialog___lambda46__gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                    gpointer self)
{
	_files_file_conflict_dialog___lambda46_ (self);
}

static GObject *
files_file_conflict_dialog_constructor (GType type,
                                        guint n_construct_properties,
                                        GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	FilesFileConflictDialog * self;
	Block13Data* _data13_;
	GThemedIcon* _tmp0_;
	GThemedIcon* _tmp1_;
	GtkImage* _tmp2_ = NULL;
	GraniteHeaderLabel* destination_label = NULL;
	GraniteHeaderLabel* _tmp3_;
	GtkLabel* destination_size_title_label = NULL;
	GtkLabel* _tmp4_ = NULL;
	GtkLabel* _tmp5_ = NULL;
	GtkLabel* destination_type_title_label = NULL;
	GtkLabel* _tmp6_ = NULL;
	GtkLabel* _tmp7_ = NULL;
	GtkLabel* destination_time_title_label = NULL;
	GtkLabel* _tmp8_ = NULL;
	GtkLabel* _tmp9_ = NULL;
	GtkImage* _tmp10_ = NULL;
	GraniteHeaderLabel* source_label = NULL;
	GraniteHeaderLabel* _tmp11_;
	GtkLabel* source_size_title_label = NULL;
	GtkLabel* _tmp12_ = NULL;
	GtkLabel* _tmp13_ = NULL;
	GtkLabel* source_type_title_label = NULL;
	GtkLabel* _tmp14_ = NULL;
	GtkLabel* _tmp15_ = NULL;
	GtkLabel* source_time_title_label = NULL;
	GtkLabel* _tmp16_ = NULL;
	GtkLabel* _tmp17_ = NULL;
	GtkEntry* _tmp18_ = NULL;
	GtkButton* reset_button = NULL;
	GtkButton* _tmp19_;
	GtkBox* expander_box = NULL;
	GtkBox* _tmp20_ = NULL;
	GtkBox* _tmp21_;
	GtkEntry* _tmp22_;
	GtkBox* _tmp23_;
	GtkButton* _tmp24_;
	GtkBox* _tmp25_;
	GtkWidget* _tmp26_;
	GtkExpander* _tmp27_ = NULL;
	GtkCheckButton* _tmp28_;
	GtkWidget* _tmp29_;
	GtkButton* _tmp30_;
	GtkWidget* _tmp31_;
	GtkButton* _tmp32_;
	GtkButton* _tmp33_;
	GtkWidget* _tmp34_;
	GtkButton* _tmp35_;
	GtkButton* _tmp36_;
	GtkStyleContext* _tmp37_;
	GtkGrid* comparison_grid = NULL;
	GtkGrid* _tmp38_ = NULL;
	GtkGrid* _tmp39_;
	GraniteHeaderLabel* _tmp40_;
	GtkGrid* _tmp41_;
	GtkImage* _tmp42_;
	GtkGrid* _tmp43_;
	GtkLabel* _tmp44_;
	GtkGrid* _tmp45_;
	GtkLabel* _tmp46_;
	GtkGrid* _tmp47_;
	GtkLabel* _tmp48_;
	GtkGrid* _tmp49_;
	GtkLabel* _tmp50_;
	GtkGrid* _tmp51_;
	GtkLabel* _tmp52_;
	GtkGrid* _tmp53_;
	GtkLabel* _tmp54_;
	GtkGrid* _tmp55_;
	GraniteHeaderLabel* _tmp56_;
	GtkGrid* _tmp57_;
	GtkImage* _tmp58_;
	GtkGrid* _tmp59_;
	GtkLabel* _tmp60_;
	GtkGrid* _tmp61_;
	GtkLabel* _tmp62_;
	GtkGrid* _tmp63_;
	GtkLabel* _tmp64_;
	GtkGrid* _tmp65_;
	GtkLabel* _tmp66_;
	GtkGrid* _tmp67_;
	GtkLabel* _tmp68_;
	GtkGrid* _tmp69_;
	GtkLabel* _tmp70_;
	GtkBox* box = NULL;
	GtkBox* _tmp71_;
	GtkBox* _tmp72_;
	GtkGrid* _tmp73_;
	GtkBox* _tmp74_;
	GtkExpander* _tmp75_;
	GtkBox* _tmp76_;
	GtkCheckButton* _tmp77_;
	GtkBox* _tmp78_;
	GtkBin* _tmp79_;
	GtkBin* _tmp80_;
	GtkBox* _tmp81_;
	GtkLabel* _tmp82_;
	GtkLabel* _tmp83_;
	GtkLabel* _tmp84_;
	GtkLabel* _tmp85_;
	GtkExpander* _tmp86_;
	GtkEntry* _tmp87_;
	GtkButton* _tmp88_;
	GtkCheckButton* _tmp89_;
	GtkExpander* _tmp90_;
	GtkCheckButton* _tmp91_;
	GtkButton* _tmp92_;
	GtkCheckButton* _tmp93_;
	parent_class = G_OBJECT_CLASS (files_file_conflict_dialog_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_FILE_CONFLICT_DIALOG, FilesFileConflictDialog);
	_data13_ = g_slice_new0 (Block13Data);
	_data13_->_ref_count_ = 1;
	_data13_->self = g_object_ref (self);
	_tmp0_ = (GThemedIcon*) g_themed_icon_new ("dialog-warning");
	_tmp1_ = _tmp0_;
	granite_message_dialog_set_image_icon ((GraniteMessageDialog*) self, (GIcon*) _tmp1_);
	_g_object_unref0 (_tmp1_);
	_tmp2_ = (GtkImage*) gtk_image_new ();
	gtk_image_set_pixel_size (_tmp2_, 64);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->destination_image);
	self->priv->destination_image = _tmp2_;
	_tmp3_ = granite_header_label_new (_ ("Original file"));
	g_object_ref_sink (_tmp3_);
	destination_label = _tmp3_;
	_tmp4_ = (GtkLabel*) gtk_label_new (_ ("Size:"));
	gtk_widget_set_valign ((GtkWidget*) _tmp4_, GTK_ALIGN_END);
	gtk_label_set_xalign (_tmp4_, (gfloat) 1);
	g_object_ref_sink (_tmp4_);
	destination_size_title_label = _tmp4_;
	_tmp5_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_valign ((GtkWidget*) _tmp5_, GTK_ALIGN_END);
	gtk_label_set_xalign (_tmp5_, (gfloat) 0);
	g_object_ref_sink (_tmp5_);
	_g_object_unref0 (self->priv->destination_size_label);
	self->priv->destination_size_label = _tmp5_;
	_tmp6_ = (GtkLabel*) gtk_label_new (_ ("Type:"));
	gtk_label_set_xalign (_tmp6_, (gfloat) 1);
	g_object_ref_sink (_tmp6_);
	destination_type_title_label = _tmp6_;
	_tmp7_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_xalign (_tmp7_, (gfloat) 0);
	g_object_ref_sink (_tmp7_);
	_g_object_unref0 (self->priv->destination_type_label);
	self->priv->destination_type_label = _tmp7_;
	_tmp8_ = (GtkLabel*) gtk_label_new (_ ("Last modified:"));
	gtk_widget_set_valign ((GtkWidget*) _tmp8_, GTK_ALIGN_START);
	gtk_label_set_xalign (_tmp8_, (gfloat) 1);
	g_object_ref_sink (_tmp8_);
	destination_time_title_label = _tmp8_;
	_tmp9_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_valign ((GtkWidget*) _tmp9_, GTK_ALIGN_START);
	gtk_label_set_xalign (_tmp9_, (gfloat) 0);
	g_object_ref_sink (_tmp9_);
	_g_object_unref0 (self->priv->destination_time_label);
	self->priv->destination_time_label = _tmp9_;
	_tmp10_ = (GtkImage*) gtk_image_new ();
	gtk_image_set_pixel_size (_tmp10_, 64);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->source_image);
	self->priv->source_image = _tmp10_;
	_tmp11_ = granite_header_label_new (_ ("Replace with"));
	g_object_ref_sink (_tmp11_);
	source_label = _tmp11_;
	_tmp12_ = (GtkLabel*) gtk_label_new (_ ("Size:"));
	gtk_widget_set_valign ((GtkWidget*) _tmp12_, GTK_ALIGN_END);
	gtk_label_set_xalign (_tmp12_, (gfloat) 1);
	g_object_ref_sink (_tmp12_);
	source_size_title_label = _tmp12_;
	_tmp13_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_valign ((GtkWidget*) _tmp13_, GTK_ALIGN_END);
	gtk_label_set_xalign (_tmp13_, (gfloat) 0);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->priv->source_size_label);
	self->priv->source_size_label = _tmp13_;
	_tmp14_ = (GtkLabel*) gtk_label_new (_ ("Type:"));
	gtk_label_set_xalign (_tmp14_, (gfloat) 1);
	g_object_ref_sink (_tmp14_);
	source_type_title_label = _tmp14_;
	_tmp15_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_label_set_xalign (_tmp15_, (gfloat) 0);
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->source_type_label);
	self->priv->source_type_label = _tmp15_;
	_tmp16_ = (GtkLabel*) gtk_label_new (_ ("Last modified:"));
	gtk_widget_set_valign ((GtkWidget*) _tmp16_, GTK_ALIGN_START);
	gtk_label_set_xalign (_tmp16_, (gfloat) 1);
	g_object_ref_sink (_tmp16_);
	source_time_title_label = _tmp16_;
	_tmp17_ = (GtkLabel*) gtk_label_new (NULL);
	gtk_widget_set_valign ((GtkWidget*) _tmp17_, GTK_ALIGN_START);
	gtk_label_set_xalign (_tmp17_, (gfloat) 0);
	g_object_ref_sink (_tmp17_);
	_g_object_unref0 (self->priv->source_time_label);
	self->priv->source_time_label = _tmp17_;
	_tmp18_ = (GtkEntry*) gtk_entry_new ();
	gtk_widget_set_hexpand ((GtkWidget*) _tmp18_, TRUE);
	g_object_ref_sink (_tmp18_);
	_g_object_unref0 (self->priv->rename_entry);
	self->priv->rename_entry = _tmp18_;
	_tmp19_ = (GtkButton*) gtk_button_new_with_label (_ ("Reset"));
	g_object_ref_sink (_tmp19_);
	reset_button = _tmp19_;
	_tmp20_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp20_, 6);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp20_, 6);
	g_object_ref_sink (_tmp20_);
	expander_box = _tmp20_;
	_tmp21_ = expander_box;
	_tmp22_ = self->priv->rename_entry;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = expander_box;
	_tmp24_ = reset_button;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = expander_box;
	_tmp26_ = _g_object_ref0 ((GtkWidget*) _tmp25_);
	_tmp27_ = (GtkExpander*) gtk_expander_new_with_mnemonic (_ ("_Select a new name for the destination"));
	g_object_set ((GtkContainer*) _tmp27_, "child", _tmp26_, NULL);
	_g_object_unref0 (_tmp26_);
	g_object_ref_sink (_tmp27_);
	_data13_->expander = _tmp27_;
	_tmp28_ = (GtkCheckButton*) gtk_check_button_new_with_label (_ ("Apply this action to all files"));
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->priv->apply_all_checkbutton);
	self->priv->apply_all_checkbutton = _tmp28_;
	gtk_dialog_add_button ((GtkDialog*) self, _ ("_Skip"), (gint) FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_SKIP);
	_tmp29_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Re_name"), (gint) FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_RENAME);
	_tmp30_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp29_, gtk_button_get_type (), GtkButton));
	_data13_->rename_button = _tmp30_;
	_tmp31_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Keep Newest"), (gint) FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_NEWEST);
	_tmp32_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp31_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->keep_newest_button);
	self->priv->keep_newest_button = _tmp32_;
	_tmp33_ = self->priv->keep_newest_button;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp33_, _ ("Skip if original was modified more recently"));
	gtk_dialog_add_button ((GtkDialog*) self, _ ("Cancel"), (gint) GTK_RESPONSE_CANCEL);
	_tmp34_ = gtk_dialog_add_button ((GtkDialog*) self, _ ("Replace"), (gint) FILES_FILE_CONFLICT_DIALOG_RESPONSE_TYPE_REPLACE);
	_tmp35_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp34_, gtk_button_get_type (), GtkButton));
	_g_object_unref0 (self->priv->replace_button);
	self->priv->replace_button = _tmp35_;
	_tmp36_ = self->priv->replace_button;
	_tmp37_ = gtk_widget_get_style_context ((GtkWidget*) _tmp36_);
	gtk_style_context_add_class (_tmp37_, GTK_STYLE_CLASS_DESTRUCTIVE_ACTION);
	_tmp38_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp38_, 6);
	gtk_grid_set_row_spacing (_tmp38_, 0);
	g_object_ref_sink (_tmp38_);
	comparison_grid = _tmp38_;
	_tmp39_ = comparison_grid;
	_tmp40_ = destination_label;
	gtk_grid_attach (_tmp39_, (GtkWidget*) _tmp40_, 0, 0, 3, 1);
	_tmp41_ = comparison_grid;
	_tmp42_ = self->priv->destination_image;
	gtk_grid_attach (_tmp41_, (GtkWidget*) _tmp42_, 0, 1, 1, 3);
	_tmp43_ = comparison_grid;
	_tmp44_ = destination_size_title_label;
	gtk_grid_attach (_tmp43_, (GtkWidget*) _tmp44_, 1, 1, 1, 1);
	_tmp45_ = comparison_grid;
	_tmp46_ = self->priv->destination_size_label;
	gtk_grid_attach (_tmp45_, (GtkWidget*) _tmp46_, 2, 1, 1, 1);
	_tmp47_ = comparison_grid;
	_tmp48_ = destination_type_title_label;
	gtk_grid_attach (_tmp47_, (GtkWidget*) _tmp48_, 1, 2, 1, 1);
	_tmp49_ = comparison_grid;
	_tmp50_ = self->priv->destination_type_label;
	gtk_grid_attach (_tmp49_, (GtkWidget*) _tmp50_, 2, 2, 1, 1);
	_tmp51_ = comparison_grid;
	_tmp52_ = destination_time_title_label;
	gtk_grid_attach (_tmp51_, (GtkWidget*) _tmp52_, 1, 3, 1, 1);
	_tmp53_ = comparison_grid;
	_tmp54_ = self->priv->destination_time_label;
	gtk_grid_attach (_tmp53_, (GtkWidget*) _tmp54_, 2, 3, 1, 1);
	_tmp55_ = comparison_grid;
	_tmp56_ = source_label;
	gtk_grid_attach (_tmp55_, (GtkWidget*) _tmp56_, 0, 4, 3, 1);
	_tmp57_ = comparison_grid;
	_tmp58_ = self->priv->source_image;
	gtk_grid_attach (_tmp57_, (GtkWidget*) _tmp58_, 0, 5, 1, 3);
	_tmp59_ = comparison_grid;
	_tmp60_ = source_size_title_label;
	gtk_grid_attach (_tmp59_, (GtkWidget*) _tmp60_, 1, 5, 1, 1);
	_tmp61_ = comparison_grid;
	_tmp62_ = self->priv->source_size_label;
	gtk_grid_attach (_tmp61_, (GtkWidget*) _tmp62_, 2, 5, 1, 1);
	_tmp63_ = comparison_grid;
	_tmp64_ = source_type_title_label;
	gtk_grid_attach (_tmp63_, (GtkWidget*) _tmp64_, 1, 6, 1, 1);
	_tmp65_ = comparison_grid;
	_tmp66_ = self->priv->source_type_label;
	gtk_grid_attach (_tmp65_, (GtkWidget*) _tmp66_, 2, 6, 1, 1);
	_tmp67_ = comparison_grid;
	_tmp68_ = source_time_title_label;
	gtk_grid_attach (_tmp67_, (GtkWidget*) _tmp68_, 1, 7, 1, 1);
	_tmp69_ = comparison_grid;
	_tmp70_ = self->priv->source_time_label;
	gtk_grid_attach (_tmp69_, (GtkWidget*) _tmp70_, 2, 7, 1, 1);
	_tmp71_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp71_);
	box = _tmp71_;
	_tmp72_ = box;
	_tmp73_ = comparison_grid;
	gtk_container_add ((GtkContainer*) _tmp72_, (GtkWidget*) _tmp73_);
	_tmp74_ = box;
	_tmp75_ = _data13_->expander;
	gtk_container_add ((GtkContainer*) _tmp74_, (GtkWidget*) _tmp75_);
	_tmp76_ = box;
	_tmp77_ = self->priv->apply_all_checkbutton;
	gtk_container_add ((GtkContainer*) _tmp76_, (GtkWidget*) _tmp77_);
	_tmp78_ = box;
	gtk_widget_show_all ((GtkWidget*) _tmp78_);
	_tmp79_ = granite_message_dialog_get_custom_bin ((GraniteMessageDialog*) self);
	_tmp80_ = _tmp79_;
	_tmp81_ = box;
	g_object_set ((GtkContainer*) _tmp80_, "child", (GtkWidget*) _tmp81_, NULL);
	_tmp82_ = self->priv->source_type_label;
	_tmp83_ = source_type_title_label;
	g_object_bind_property_with_closures ((GObject*) _tmp82_, "visible", (GObject*) _tmp83_, "visible", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp84_ = self->priv->destination_type_label;
	_tmp85_ = destination_type_title_label;
	g_object_bind_property_with_closures ((GObject*) _tmp84_, "visible", (GObject*) _tmp85_, "visible", G_BINDING_DEFAULT, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp86_ = _data13_->expander;
	g_signal_connect_data (_tmp86_, "activate", (GCallback) __files_file_conflict_dialog___lambda43__gtk_expander_activate, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	_tmp87_ = self->priv->rename_entry;
	g_signal_connect_data ((GtkEditable*) _tmp87_, "changed", (GCallback) __files_file_conflict_dialog___lambda44__gtk_editable_changed, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	_tmp88_ = reset_button;
	g_signal_connect_object (_tmp88_, "clicked", (GCallback) __files_file_conflict_dialog___lambda45__gtk_button_clicked, self, 0);
	_tmp89_ = self->priv->apply_all_checkbutton;
	_tmp90_ = _data13_->expander;
	g_object_bind_property_with_closures ((GObject*) _tmp89_, "active", (GObject*) _tmp90_, "sensitive", G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp91_ = self->priv->apply_all_checkbutton;
	_tmp92_ = _data13_->rename_button;
	g_object_bind_property_with_closures ((GObject*) _tmp91_, "active", (GObject*) _tmp92_, "sensitive", G_BINDING_INVERT_BOOLEAN, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp93_ = self->priv->apply_all_checkbutton;
	g_signal_connect_data ((GtkToggleButton*) _tmp93_, "toggled", (GCallback) __files_file_conflict_dialog___lambda46__gtk_toggle_button_toggled, block13_data_ref (_data13_), (GClosureNotify) block13_data_unref, 0);
	_g_object_unref0 (box);
	_g_object_unref0 (comparison_grid);
	_g_object_unref0 (expander_box);
	_g_object_unref0 (reset_button);
	_g_object_unref0 (source_time_title_label);
	_g_object_unref0 (source_type_title_label);
	_g_object_unref0 (source_size_title_label);
	_g_object_unref0 (source_label);
	_g_object_unref0 (destination_time_title_label);
	_g_object_unref0 (destination_type_title_label);
	_g_object_unref0 (destination_size_title_label);
	_g_object_unref0 (destination_label);
	block13_data_unref (_data13_);
	_data13_ = NULL;
	return obj;
}

static void
files_file_conflict_dialog_class_init (FilesFileConflictDialogClass * klass,
                                       gpointer klass_data)
{
	files_file_conflict_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FilesFileConflictDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_files_file_conflict_dialog_get_property;
	G_OBJECT_CLASS (klass)->constructor = files_file_conflict_dialog_constructor;
	G_OBJECT_CLASS (klass)->finalize = files_file_conflict_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_CONFLICT_DIALOG_NEW_NAME_PROPERTY, files_file_conflict_dialog_properties[FILES_FILE_CONFLICT_DIALOG_NEW_NAME_PROPERTY] = g_param_spec_string ("new-name", "new-name", "new-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), FILES_FILE_CONFLICT_DIALOG_APPLY_TO_ALL_PROPERTY, files_file_conflict_dialog_properties[FILES_FILE_CONFLICT_DIALOG_APPLY_TO_ALL_PROPERTY] = g_param_spec_boolean ("apply-to-all", "apply-to-all", "apply-to-all", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
files_file_conflict_dialog_instance_init (FilesFileConflictDialog * self,
                                          gpointer klass)
{
	self->priv = files_file_conflict_dialog_get_instance_private (self);
}

static void
files_file_conflict_dialog_finalize (GObject * obj)
{
	FilesFileConflictDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, FILES_TYPE_FILE_CONFLICT_DIALOG, FilesFileConflictDialog);
	_g_free0 (self->priv->conflict_name);
	_g_object_unref0 (self->priv->rename_entry);
	_g_object_unref0 (self->priv->replace_button);
	_g_object_unref0 (self->priv->keep_newest_button);
	_g_object_unref0 (self->priv->apply_all_checkbutton);
	_g_object_unref0 (self->priv->source);
	_g_object_unref0 (self->priv->destination);
	_g_object_unref0 (self->priv->dest_dir);
	_g_object_unref0 (self->priv->source_image);
	_g_object_unref0 (self->priv->source_size_label);
	_g_object_unref0 (self->priv->source_type_label);
	_g_object_unref0 (self->priv->source_time_label);
	_g_object_unref0 (self->priv->destination_image);
	_g_object_unref0 (self->priv->destination_size_label);
	_g_object_unref0 (self->priv->destination_type_label);
	_g_object_unref0 (self->priv->destination_time_label);
	G_OBJECT_CLASS (files_file_conflict_dialog_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
files_file_conflict_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FilesFileConflictDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) files_file_conflict_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FilesFileConflictDialog), 0, (GInstanceInitFunc) files_file_conflict_dialog_instance_init, NULL };
	GType files_file_conflict_dialog_type_id;
	files_file_conflict_dialog_type_id = g_type_register_static (GRANITE_TYPE_MESSAGE_DIALOG, "FilesFileConflictDialog", &g_define_type_info, 0);
	FilesFileConflictDialog_private_offset = g_type_add_instance_private (files_file_conflict_dialog_type_id, sizeof (FilesFileConflictDialogPrivate));
	return files_file_conflict_dialog_type_id;
}

GType
files_file_conflict_dialog_get_type (void)
{
	static volatile gsize files_file_conflict_dialog_type_id__once = 0;
	if (g_once_init_enter (&files_file_conflict_dialog_type_id__once)) {
		GType files_file_conflict_dialog_type_id;
		files_file_conflict_dialog_type_id = files_file_conflict_dialog_get_type_once ();
		g_once_init_leave (&files_file_conflict_dialog_type_id__once, files_file_conflict_dialog_type_id);
	}
	return files_file_conflict_dialog_type_id__once;
}

static void
_vala_files_file_conflict_dialog_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	FilesFileConflictDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, FILES_TYPE_FILE_CONFLICT_DIALOG, FilesFileConflictDialog);
	switch (property_id) {
		case FILES_FILE_CONFLICT_DIALOG_NEW_NAME_PROPERTY:
		g_value_take_string (value, files_file_conflict_dialog_get_new_name (self));
		break;
		case FILES_FILE_CONFLICT_DIALOG_APPLY_TO_ALL_PROPERTY:
		g_value_set_boolean (value, files_file_conflict_dialog_get_apply_to_all (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

