/* BookmarkRow.c generated by valac 0.56.18, the Vala compiler
 * generated from BookmarkRow.vala, do not modify */

/* BookmarkRow.vala
 *
 * Copyright 2020 elementary LLC. <https://elementary.io>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 * Authors: Jeremy Wootten <jeremywootten@gmail.com>
 */

#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <glib-object.h>
#include <glib.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <pango/pango.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIDEBAR_TYPE_BOOKMARK_ROW (sidebar_bookmark_row_get_type ())
#define SIDEBAR_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow))
#define SIDEBAR_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))
#define SIDEBAR_IS_BOOKMARK_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_IS_BOOKMARK_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_BOOKMARK_ROW))
#define SIDEBAR_BOOKMARK_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRowClass))

typedef struct _SidebarBookmarkRow SidebarBookmarkRow;
typedef struct _SidebarBookmarkRowClass SidebarBookmarkRowClass;
typedef struct _SidebarBookmarkRowPrivate SidebarBookmarkRowPrivate;
enum  {
	SIDEBAR_BOOKMARK_ROW_0_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_LIST_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_GICON_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_URI_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_CUSTOM_NAME_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_DISPLAY_NAME_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_ID_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_PINNED_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_PERMANENT_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_CAN_INSERT_BEFORE_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_CAN_INSERT_AFTER_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_MENU_MODEL_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_ACTION_GROUP_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_ACTION_GROUP_NAMESPACE_PROPERTY,
	SIDEBAR_BOOKMARK_ROW_NUM_PROPERTIES
};
static GParamSpec* sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _marlin_file_operations_common_job_unref0(var) ((var == NULL) ? NULL : (var = (marlin_file_operations_common_job_unref (var), NULL)))
#define _g_rand_free0(var) ((var == NULL) ? NULL : (var = (g_rand_free (var), NULL)))

struct _SidebarBookmarkRow {
	GtkListBoxRow parent_instance;
	SidebarBookmarkRowPrivate * priv;
	GtkGrid* content_grid;
	GtkGrid* icon_label_grid;
	GtkStack* label_stack;
	GtkEntry* editable;
	GtkLabel* label;
	GtkRevealer* drop_revealer;
	FilesFile* target_file;
};

struct _SidebarBookmarkRowClass {
	GtkListBoxRowClass parent_class;
	gboolean (*on_key_press_event) (SidebarBookmarkRow* self, guint keyval, guint keycode, GdkModifierType state);
	void (*on_button_release_event) (SidebarBookmarkRow* self, gint n_press, gdouble x, gdouble y);
	void (*popup_context_menu) (SidebarBookmarkRow* self);
};

struct _SidebarBookmarkRowPrivate {
	SidebarSidebarListInterface* _list;
	GIcon* _gicon;
	gchar* _uri;
	gchar* _custom_name;
	guint32 _id;
	gboolean _pinned;
	gboolean _permanent;
	gboolean _can_insert_before;
	gboolean _can_insert_after;
	GMenuModel* _menu_model;
	GActionGroup* _action_group;
	gchar* _action_group_namespace;
	GtkImage* icon;
	GList* drop_file_list;
	GdkDragAction* current_suggested_action;
	GtkEventControllerKey* key_controller;
	GtkGestureMultiPress* button_controller;
	GSimpleAction* empty_all_trash_action;
	gchar* drop_text;
	gboolean drop_occurred;
	gboolean valid;
};

static gint SidebarBookmarkRow_private_offset;
static gpointer sidebar_bookmark_row_parent_class = NULL;
static GtkTargetEntry* sidebar_bookmark_row_source_targets;
static gint sidebar_bookmark_row_source_targets_length1;
static GtkTargetEntry* sidebar_bookmark_row_source_targets = NULL;
static gint sidebar_bookmark_row_source_targets_length1 = 0;
static gint _sidebar_bookmark_row_source_targets_size_ = 0;
static GtkTargetEntry* sidebar_bookmark_row_dest_targets;
static gint sidebar_bookmark_row_dest_targets_length1;
static GtkTargetEntry* sidebar_bookmark_row_dest_targets = NULL;
static gint sidebar_bookmark_row_dest_targets_length1 = 0;
static gint _sidebar_bookmark_row_dest_targets_size_ = 0;
static GdkAtom sidebar_bookmark_row_text_data_atom;
static GdkAtom sidebar_bookmark_row_text_data_atom = 0U;
static SidebarSidebarItemInterfaceIface * sidebar_bookmark_row_sidebar_sidebar_item_interface_parent_iface = NULL;

VALA_EXTERN GType sidebar_bookmark_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarBookmarkRow, g_object_unref)
VALA_EXTERN gboolean sidebar_bookmark_row_on_key_press_event (SidebarBookmarkRow* self,
                                                  guint keyval,
                                                  guint keycode,
                                                  GdkModifierType state);
VALA_EXTERN void sidebar_bookmark_row_on_button_release_event (SidebarBookmarkRow* self,
                                                   gint n_press,
                                                   gdouble x,
                                                   gdouble y);
VALA_EXTERN void sidebar_bookmark_row_popup_context_menu (SidebarBookmarkRow* self);
static void _g_object_unref0_ (gpointer var);
static inline void _g_list_free__g_object_unref0_ (GList* self);
static GdkDragAction* _gdk_drag_action_dup (GdkDragAction* self);
VALA_EXTERN SidebarBookmarkRow* sidebar_bookmark_row_new (const gchar* _custom_name,
                                              const gchar* uri,
                                              GIcon* gicon,
                                              SidebarSidebarListInterface* list,
                                              gboolean pinned,
                                              gboolean permanent);
VALA_EXTERN SidebarBookmarkRow* sidebar_bookmark_row_construct (GType object_type,
                                                    const gchar* _custom_name,
                                                    const gchar* uri,
                                                    GIcon* gicon,
                                                    SidebarSidebarListInterface* list,
                                                    gboolean pinned,
                                                    gboolean permanent);
static void sidebar_bookmark_row_real_update_plugin_data (SidebarSidebarItemInterface* base,
                                                   FilesSidebarPluginItem* item);
static void sidebar_bookmark_row_rename (SidebarBookmarkRow* self);
VALA_EXTERN const gchar* sidebar_bookmark_row_get_display_name (SidebarBookmarkRow* self);
VALA_EXTERN void sidebar_bookmark_row_cancel_rename (SidebarBookmarkRow* self);
static void sidebar_bookmark_row_real_destroy_bookmark (SidebarSidebarItemInterface* base);
static gboolean sidebar_bookmark_row_real_on_key_press_event (SidebarBookmarkRow* self,
                                                       guint keyval,
                                                       guint keycode,
                                                       GdkModifierType state);
static void sidebar_bookmark_row_real_on_button_release_event (SidebarBookmarkRow* self,
                                                        gint n_press,
                                                        gdouble x,
                                                        gdouble y);
static void sidebar_bookmark_row_real_popup_context_menu (SidebarBookmarkRow* self);
static void sidebar_bookmark_row_real_add_extra_menu_items (SidebarSidebarItemInterface* base,
                                                     GMenu* menu);
static void sidebar_bookmark_row_set_up_drag (SidebarBookmarkRow* self);
static void __lambda154_ (SidebarBookmarkRow* self,
                   GdkDragContext* ctx);
static void ___lambda154__gtk_widget_drag_begin (GtkWidget* _sender,
                                          GdkDragContext* context,
                                          gpointer self);
static void __lambda155_ (SidebarBookmarkRow* self,
                   GdkDragContext* ctx,
                   GtkSelectionData* sel_data,
                   guint info,
                   guint time);
static guint8* _vala_array_dup3 (guint8* self,
                          gssize length);
static void ___lambda155__gtk_widget_drag_data_get (GtkWidget* _sender,
                                             GdkDragContext* context,
                                             GtkSelectionData* selection_data,
                                             guint info,
                                             guint time_,
                                             gpointer self);
static void __lambda156_ (SidebarBookmarkRow* self,
                   GdkDragContext* ctx);
static void sidebar_bookmark_row_reset_drag_drop (SidebarBookmarkRow* self);
static void ___lambda156__gtk_widget_drag_end (GtkWidget* _sender,
                                        GdkDragContext* context,
                                        gpointer self);
static void sidebar_bookmark_row_set_up_drop (SidebarBookmarkRow* self);
static void __lambda157_ (SidebarBookmarkRow* self,
                   GdkDragContext* ctx,
                   gint x,
                   gint y,
                   GtkSelectionData* sel_data,
                   guint info,
                   guint time);
static gboolean sidebar_bookmark_row_process_dropped_row (SidebarBookmarkRow* self,
                                                   const gchar* drop_text,
                                                   gboolean dropped_between);
static gboolean sidebar_bookmark_row_process_dropped_uris (SidebarBookmarkRow* self,
                                                    GdkDragAction selected_action,
                                                    GdkDragAction possible_actions,
                                                    GList* drop_file_list,
                                                    gboolean dropped_between);
static void ___lambda157__gtk_widget_drag_data_received (GtkWidget* _sender,
                                                  GdkDragContext* context,
                                                  gint x,
                                                  gint y,
                                                  GtkSelectionData* selection_data,
                                                  guint info,
                                                  guint time_,
                                                  gpointer self);
static gboolean __lambda158_ (SidebarBookmarkRow* self,
                       GdkDragContext* ctx,
                       gint x,
                       gint y,
                       guint time);
VALA_EXTERN gboolean sidebar_bookmark_row_reveal_drop_target (SidebarBookmarkRow* self,
                                                  gboolean reveal);
static gboolean _gdk_drag_action_equal (const GdkDragAction * s1,
                                 const GdkDragAction * s2);
VALA_EXTERN void sidebar_bookmark_row_highlight (SidebarBookmarkRow* self,
                                     gboolean show);
static gboolean ___lambda158__gtk_widget_drag_motion (GtkWidget* _sender,
                                               GdkDragContext* context,
                                               gint x,
                                               gint y,
                                               guint time_,
                                               gpointer self);
static void __lambda159_ (SidebarBookmarkRow* self);
static void ___lambda159__gtk_widget_drag_leave (GtkWidget* _sender,
                                          GdkDragContext* context,
                                          guint time_,
                                          gpointer self);
static gboolean __lambda160_ (SidebarBookmarkRow* self,
                       GdkDragContext* ctx,
                       gint x,
                       gint y,
                       guint time);
static gboolean ___lambda160__gtk_widget_drag_drop (GtkWidget* _sender,
                                             GdkDragContext* context,
                                             gint x,
                                             gint y,
                                             guint time_,
                                             gpointer self);
VALA_EXTERN GtkWindow* files_get_active_window (void);
static GObject * sidebar_bookmark_row_constructor (GType type,
                                            guint n_construct_properties,
                                            GObjectConstructParam * construct_properties);
static void _sidebar_bookmark_row____lambda161_ (SidebarBookmarkRow* self);
static void __sidebar_bookmark_row____lambda161__gtk_entry_activate (GtkEntry* _sender,
                                                              gpointer self);
static gboolean _sidebar_bookmark_row____lambda162_ (SidebarBookmarkRow* self);
static gboolean __sidebar_bookmark_row____lambda162__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                          GdkEventFocus* event,
                                                                          gpointer self);
static gboolean _sidebar_bookmark_row_on_key_press_event_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                                        guint keyval,
                                                                                        guint keycode,
                                                                                        GdkModifierType state,
                                                                                        gpointer self);
static void _sidebar_bookmark_row_on_button_release_event_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                                     gint n_press,
                                                                                     gdouble x,
                                                                                     gdouble y,
                                                                                     gpointer self);
static void _sidebar_bookmark_row___lambda163_ (SidebarBookmarkRow* self);
static void __sidebar_bookmark_row___lambda163__g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void _sidebar_bookmark_row___lambda164_ (SidebarBookmarkRow* self);
static void __sidebar_bookmark_row___lambda164__g_object_notify (GObject* _sender,
                                                          GParamSpec* pspec,
                                                          gpointer self);
static void _sidebar_bookmark_row___lambda165_ (SidebarBookmarkRow* self);
static void __sidebar_bookmark_row___lambda165__g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void _sidebar_bookmark_row___lambda166_ (SidebarBookmarkRow* self);
static void __sidebar_bookmark_row___lambda166__g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void _sidebar_bookmark_row___lambda167_ (SidebarBookmarkRow* self);
static void __sidebar_bookmark_row___lambda167__g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void _sidebar_bookmark_row_rename_g_simple_action_activate (GSimpleAction* _sender,
                                                            GVariant* parameter,
                                                            gpointer self);
static void _sidebar_bookmark_row___lambda168_ (SidebarBookmarkRow* self);
static void __sidebar_bookmark_row___lambda168__g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void _sidebar_bookmark_row___lambda169_ (SidebarBookmarkRow* self);
static void __sidebar_bookmark_row___lambda169__g_simple_action_activate (GSimpleAction* _sender,
                                                                   GVariant* parameter,
                                                                   gpointer self);
static void sidebar_bookmark_row_finalize (GObject * obj);
static GType sidebar_bookmark_row_get_type_once (void);
static void _vala_sidebar_bookmark_row_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_sidebar_bookmark_row_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static void _vala_clear_GMutex (GMutex * mutex);
static void _vala_clear_GRecMutex (GRecMutex * mutex);
static void _vala_clear_GRWLock (GRWLock * mutex);
static void _vala_clear_GCond (GCond * mutex);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sidebar_bookmark_row_get_instance_private (SidebarBookmarkRow* self)
{
	return G_STRUCT_MEMBER_P (self, SidebarBookmarkRow_private_offset);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static inline void
_g_list_free__g_object_unref0_ (GList* self)
{
	g_list_free_full (self, (GDestroyNotify) _g_object_unref0_);
}

static GdkDragAction*
_gdk_drag_action_dup (GdkDragAction* self)
{
	GdkDragAction* dup;
	dup = g_new0 (GdkDragAction, 1);
	memcpy (dup, self, sizeof (GdkDragAction));
	return dup;
}

static gpointer
__gdk_drag_action_dup0 (gpointer self)
{
	return self ? _gdk_drag_action_dup (self) : NULL;
}

SidebarBookmarkRow*
sidebar_bookmark_row_construct (GType object_type,
                                const gchar* _custom_name,
                                const gchar* uri,
                                GIcon* gicon,
                                SidebarSidebarListInterface* list,
                                gboolean pinned,
                                gboolean permanent)
{
	SidebarBookmarkRow * self = NULL;
	g_return_val_if_fail (_custom_name != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (gicon != NULL, NULL);
	g_return_val_if_fail (list != NULL, NULL);
	self = (SidebarBookmarkRow*) g_object_new (object_type, "custom-name", _custom_name, "uri", uri, "gicon", gicon, "list", list, "hexpand", TRUE, "pinned", pinned, "permanent", permanent, NULL);
	return self;
}

SidebarBookmarkRow*
sidebar_bookmark_row_new (const gchar* _custom_name,
                          const gchar* uri,
                          GIcon* gicon,
                          SidebarSidebarListInterface* list,
                          gboolean pinned,
                          gboolean permanent)
{
	return sidebar_bookmark_row_construct (SIDEBAR_TYPE_BOOKMARK_ROW, _custom_name, uri, gicon, list, pinned, permanent);
}

static void
sidebar_bookmark_row_real_update_plugin_data (SidebarSidebarItemInterface* base,
                                              FilesSidebarPluginItem* item)
{
	SidebarBookmarkRow * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GIcon* _tmp4_;
	GIcon* _tmp5_;
	GMenuModel* _tmp6_;
	GMenuModel* _tmp7_;
	GActionGroup* _tmp8_;
	GActionGroup* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	self = (SidebarBookmarkRow*) base;
	g_return_if_fail (item != NULL);
	_tmp0_ = files_sidebar_plugin_item_get_name (item);
	_tmp1_ = _tmp0_;
	sidebar_sidebar_item_interface_set_custom_name ((SidebarSidebarItemInterface*) self, _tmp1_);
	_tmp2_ = files_sidebar_plugin_item_get_uri (item);
	_tmp3_ = _tmp2_;
	sidebar_sidebar_item_interface_set_uri ((SidebarSidebarItemInterface*) self, _tmp3_);
	_tmp4_ = files_sidebar_plugin_item_get_icon (item);
	_tmp5_ = _tmp4_;
	sidebar_sidebar_item_interface_update_icon ((SidebarSidebarItemInterface*) self, _tmp5_);
	_tmp6_ = files_sidebar_plugin_item_get_menu_model (item);
	_tmp7_ = _tmp6_;
	sidebar_sidebar_item_interface_set_menu_model ((SidebarSidebarItemInterface*) self, _tmp7_);
	_tmp8_ = files_sidebar_plugin_item_get_action_group (item);
	_tmp9_ = _tmp8_;
	sidebar_sidebar_item_interface_set_action_group ((SidebarSidebarItemInterface*) self, _tmp9_);
	_tmp10_ = files_sidebar_plugin_item_get_action_group_namespace (item);
	_tmp11_ = _tmp10_;
	sidebar_sidebar_item_interface_set_action_group_namespace ((SidebarSidebarItemInterface*) self, _tmp11_);
}

static void
sidebar_bookmark_row_rename (SidebarBookmarkRow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = sidebar_sidebar_item_interface_get_pinned ((SidebarSidebarItemInterface*) self);
	_tmp1_ = _tmp0_;
	if (!_tmp1_) {
		GtkEntry* _tmp2_;
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		GtkStack* _tmp5_;
		GtkEntry* _tmp6_;
		_tmp2_ = self->editable;
		_tmp3_ = sidebar_bookmark_row_get_display_name (self);
		_tmp4_ = _tmp3_;
		gtk_entry_set_text (_tmp2_, _tmp4_);
		_tmp5_ = self->label_stack;
		gtk_stack_set_visible_child_name (_tmp5_, "editable");
		_tmp6_ = self->editable;
		gtk_widget_grab_focus ((GtkWidget*) _tmp6_);
	}
}

void
sidebar_bookmark_row_cancel_rename (SidebarBookmarkRow* self)
{
	GtkStack* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->label_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "label");
	gtk_widget_grab_focus ((GtkWidget*) self);
}

static void
sidebar_bookmark_row_real_destroy_bookmark (SidebarSidebarItemInterface* base)
{
	SidebarBookmarkRow * self;
	GeeHashMap* _tmp0_;
	guint32 _tmp1_;
	guint32 _tmp2_;
	self = (SidebarBookmarkRow*) base;
	self->priv->valid = FALSE;
	g_mutex_lock (&sidebar_sidebar_item_interface_item_map_lock);
	_tmp0_ = sidebar_sidebar_item_interface_item_id_map;
	_tmp1_ = sidebar_sidebar_item_interface_get_id ((SidebarSidebarItemInterface*) self);
	_tmp2_ = _tmp1_;
	gee_abstract_map_unset ((GeeAbstractMap*) _tmp0_, (gpointer) ((guintptr) _tmp2_), NULL);
	g_mutex_unlock (&sidebar_sidebar_item_interface_item_map_lock);
	GTK_WIDGET_CLASS (sidebar_bookmark_row_parent_class)->destroy ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_list_box_row_get_type (), GtkListBoxRow));
}

static gboolean
sidebar_bookmark_row_real_on_key_press_event (SidebarBookmarkRow* self,
                                              guint keyval,
                                              guint keycode,
                                              GdkModifierType state)
{
	gboolean result;
	switch (keyval) {
		case GDK_KEY_Escape:
		{
			sidebar_bookmark_row_cancel_rename (self);
			result = TRUE;
			return result;
		}
		case GDK_KEY_Menu:
		{
			sidebar_bookmark_row_popup_context_menu (self);
			result = TRUE;
			return result;
		}
		default:
		{
			break;
		}
	}
	result = FALSE;
	return result;
}

gboolean
sidebar_bookmark_row_on_key_press_event (SidebarBookmarkRow* self,
                                         guint keyval,
                                         guint keycode,
                                         GdkModifierType state)
{
	SidebarBookmarkRowClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = SIDEBAR_BOOKMARK_ROW_GET_CLASS (self);
	if (_klass_->on_key_press_event) {
		return _klass_->on_key_press_event (self, keyval, keycode, state);
	}
	return FALSE;
}

static void
sidebar_bookmark_row_real_on_button_release_event (SidebarBookmarkRow* self,
                                                   gint n_press,
                                                   gdouble x,
                                                   gdouble y)
{
	GtkStack* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	GdkModifierType state = 0U;
	GdkModifierType _tmp3_ = 0U;
	GdkModifierType mods = 0U;
	gboolean control_pressed = FALSE;
	gboolean other_mod_pressed = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean only_control_pressed = FALSE;
	GtkGestureMultiPress* _tmp5_;
	if (!self->priv->valid) {
		return;
	}
	_tmp0_ = self->label_stack;
	_tmp1_ = gtk_stack_get_visible_child_name (_tmp0_);
	_tmp2_ = _tmp1_;
	if (g_strcmp0 (_tmp2_, "editable") == 0) {
		return;
	}
	gtk_get_current_event_state (&_tmp3_);
	state = _tmp3_;
	mods = state & gtk_accelerator_get_default_mod_mask ();
	control_pressed = (mods & GDK_CONTROL_MASK) != 0;
	other_mod_pressed = ((mods & (~GDK_SHIFT_MASK)) & (~GDK_CONTROL_MASK)) != 0;
	if (control_pressed) {
		_tmp4_ = !other_mod_pressed;
	} else {
		_tmp4_ = FALSE;
	}
	only_control_pressed = _tmp4_;
	_tmp5_ = self->priv->button_controller;
	switch (gtk_gesture_single_get_current_button ((GtkGestureSingle*) _tmp5_)) {
		case GDK_BUTTON_PRIMARY:
		{
			if (only_control_pressed) {
				sidebar_sidebar_item_interface_activated ((SidebarSidebarItemInterface*) self, FILES_OPEN_FLAG_NEW_TAB);
			}
			break;
		}
		case GDK_BUTTON_SECONDARY:
		{
			sidebar_bookmark_row_popup_context_menu (self);
			break;
		}
		case GDK_BUTTON_MIDDLE:
		{
			sidebar_sidebar_item_interface_activated ((SidebarSidebarItemInterface*) self, FILES_OPEN_FLAG_NEW_TAB);
			break;
		}
		default:
		{
			break;
		}
	}
}

void
sidebar_bookmark_row_on_button_release_event (SidebarBookmarkRow* self,
                                              gint n_press,
                                              gdouble x,
                                              gdouble y)
{
	SidebarBookmarkRowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SIDEBAR_BOOKMARK_ROW_GET_CLASS (self);
	if (_klass_->on_button_release_event) {
		_klass_->on_button_release_event (self, n_press, x, y);
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
sidebar_bookmark_row_real_popup_context_menu (SidebarBookmarkRow* self)
{
	GMenu* open_section = NULL;
	GMenu* _tmp0_;
	GMenu* _tmp1_;
	GMenu* _tmp2_;
	GMenu* glib_menu = NULL;
	GMenu* _tmp3_;
	GMenu* _tmp4_;
	GMenu* _tmp5_;
	GMenu* _tmp6_;
	GMenu* _tmp7_;
	GtkMenu* popupmenu = NULL;
	GMenu* _tmp8_;
	GtkWidget* _tmp9_;
	GtkMenu* _tmp10_ = NULL;
	GMenuModel* _tmp11_;
	GMenuModel* _tmp12_;
	GtkMenu* _tmp21_;
	_tmp0_ = g_menu_new ();
	open_section = _tmp0_;
	_tmp1_ = open_section;
	g_menu_append (_tmp1_, _ ("Open in New _Tab"), "bookmark.open-tab");
	_tmp2_ = open_section;
	g_menu_append (_tmp2_, _ ("Open in New _Window"), "bookmark.open-window");
	_tmp3_ = g_menu_new ();
	glib_menu = _tmp3_;
	_tmp4_ = glib_menu;
	g_menu_append (_tmp4_, _ ("Open"), "bookmark.open");
	_tmp5_ = glib_menu;
	_tmp6_ = open_section;
	g_menu_append_section (_tmp5_, NULL, (GMenuModel*) _tmp6_);
	_tmp7_ = glib_menu;
	sidebar_sidebar_item_interface_add_extra_menu_items ((SidebarSidebarItemInterface*) self, _tmp7_);
	_tmp8_ = glib_menu;
	_tmp9_ = _g_object_ref0 ((GtkWidget*) self);
	_tmp10_ = (GtkMenu*) gtk_menu_new_from_model ((GMenuModel*) _tmp8_);
	g_object_set (_tmp10_, "attach-widget", _tmp9_, NULL);
	_g_object_unref0 (_tmp9_);
	g_object_ref_sink (_tmp10_);
	popupmenu = _tmp10_;
	_tmp11_ = sidebar_sidebar_item_interface_get_menu_model ((SidebarSidebarItemInterface*) self);
	_tmp12_ = _tmp11_;
	if (_tmp12_ != NULL) {
		GtkMenu* _tmp13_;
		const gchar* _tmp14_;
		const gchar* _tmp15_;
		GActionGroup* _tmp16_;
		GActionGroup* _tmp17_;
		GMenu* _tmp18_;
		GMenuModel* _tmp19_;
		GMenuModel* _tmp20_;
		_tmp13_ = popupmenu;
		_tmp14_ = sidebar_sidebar_item_interface_get_action_group_namespace ((SidebarSidebarItemInterface*) self);
		_tmp15_ = _tmp14_;
		_tmp16_ = sidebar_sidebar_item_interface_get_action_group ((SidebarSidebarItemInterface*) self);
		_tmp17_ = _tmp16_;
		gtk_widget_insert_action_group ((GtkWidget*) _tmp13_, _tmp15_, _tmp17_);
		_tmp18_ = glib_menu;
		_tmp19_ = sidebar_sidebar_item_interface_get_menu_model ((SidebarSidebarItemInterface*) self);
		_tmp20_ = _tmp19_;
		g_menu_append_section (_tmp18_, NULL, _tmp20_);
	}
	_tmp21_ = popupmenu;
	gtk_menu_popup_at_pointer (_tmp21_, NULL);
	_g_object_unref0 (popupmenu);
	_g_object_unref0 (glib_menu);
	_g_object_unref0 (open_section);
}

void
sidebar_bookmark_row_popup_context_menu (SidebarBookmarkRow* self)
{
	SidebarBookmarkRowClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = SIDEBAR_BOOKMARK_ROW_GET_CLASS (self);
	if (_klass_->popup_context_menu) {
		_klass_->popup_context_menu (self);
	}
}

static void
sidebar_bookmark_row_real_add_extra_menu_items (SidebarSidebarItemInterface* base,
                                                GMenu* menu)
{
	SidebarBookmarkRow * self;
	GMenu* menu_section = NULL;
	GMenu* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	GMenu* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gboolean _tmp12_;
	self = (SidebarBookmarkRow*) base;
	g_return_if_fail (menu != NULL);
	_tmp0_ = g_menu_new ();
	menu_section = _tmp0_;
	_tmp1_ = sidebar_sidebar_item_interface_get_permanent ((SidebarSidebarItemInterface*) self);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		GMenu* _tmp3_;
		_tmp3_ = menu_section;
		g_menu_append (_tmp3_, _ ("Remove"), "bookmark.remove");
	}
	_tmp4_ = sidebar_sidebar_item_interface_get_pinned ((SidebarSidebarItemInterface*) self);
	_tmp5_ = _tmp4_;
	if (!_tmp5_) {
		GMenu* _tmp6_;
		_tmp6_ = menu_section;
		g_menu_append (_tmp6_, _ ("Rename"), "bookmark.rename");
	}
	_tmp7_ = menu_section;
	g_menu_append_section (menu, NULL, (GMenuModel*) _tmp7_);
	_tmp8_ = sidebar_sidebar_item_interface_get_uri ((SidebarSidebarItemInterface*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = g_uri_parse_scheme (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_strcmp0 (_tmp11_, "trash") == 0;
	_g_free0 (_tmp11_);
	if (_tmp12_) {
		GVolumeMonitor* volume_monitor = NULL;
		GVolumeMonitor* _tmp13_;
		gint mounts_with_trash = 0;
		GVolumeMonitor* _tmp14_;
		GList* _tmp15_;
		const gchar* _tmp19_ = NULL;
		gchar* text = NULL;
		gchar* _tmp20_;
		GMenu* trash_section = NULL;
		GMenu* _tmp21_;
		GMenu* _tmp22_;
		const gchar* _tmp23_;
		GMenu* _tmp24_;
		GSimpleAction* _tmp25_;
		FilesTrashMonitor* _tmp26_;
		gboolean _tmp27_;
		gboolean _tmp28_;
		_tmp13_ = g_volume_monitor_get ();
		volume_monitor = _tmp13_;
		mounts_with_trash = 0;
		_tmp14_ = volume_monitor;
		_tmp15_ = g_volume_monitor_get_mounts (_tmp14_);
		{
			GList* mount_collection = NULL;
			GList* mount_it = NULL;
			mount_collection = _tmp15_;
			for (mount_it = mount_collection; mount_it != NULL; mount_it = mount_it->next) {
				GMount* _tmp16_;
				GMount* mount = NULL;
				_tmp16_ = _g_object_ref0 ((GMount*) mount_it->data);
				mount = _tmp16_;
				{
					GMount* _tmp17_;
					_tmp17_ = mount;
					if (marlin_file_operations_mount_has_trash (_tmp17_)) {
						gint _tmp18_;
						_tmp18_ = mounts_with_trash;
						mounts_with_trash = _tmp18_ + 1;
					}
					_g_object_unref0 (mount);
				}
			}
			(mount_collection == NULL) ? NULL : (mount_collection = (_g_list_free__g_object_unref0_ (mount_collection), NULL));
		}
		if (mounts_with_trash > 0) {
			_tmp19_ = _ ("Permanently Delete All Trash");
		} else {
			_tmp19_ = _ ("Permanently Delete Trash");
		}
		_tmp20_ = g_strdup (_tmp19_);
		text = _tmp20_;
		_tmp21_ = g_menu_new ();
		trash_section = _tmp21_;
		_tmp22_ = trash_section;
		_tmp23_ = text;
		g_menu_append (_tmp22_, _tmp23_, "bookmark.empty-all-trash");
		_tmp24_ = trash_section;
		g_menu_append_section (menu, NULL, (GMenuModel*) _tmp24_);
		_tmp25_ = self->priv->empty_all_trash_action;
		_tmp26_ = files_trash_monitor_get_default ();
		_tmp27_ = files_trash_monitor_get_is_empty (_tmp26_);
		_tmp28_ = _tmp27_;
		g_simple_action_set_enabled (_tmp25_, !_tmp28_);
		_g_object_unref0 (trash_section);
		_g_free0 (text);
		_g_object_unref0 (volume_monitor);
	}
	_g_object_unref0 (menu_section);
}

static void
__lambda154_ (SidebarBookmarkRow* self,
              GdkDragContext* ctx)
{
	GtkAllocation alloc = {0};
	GtkAllocation _tmp0_ = {0};
	cairo_surface_t* surface = NULL;
	GtkAllocation _tmp1_;
	GtkAllocation _tmp2_;
	cairo_surface_t* _tmp3_;
	cairo_t* cr = NULL;
	cairo_t* _tmp4_;
	gboolean _tmp5_ = FALSE;
	cairo_surface_t* surface2 = NULL;
	GtkAllocation _tmp6_;
	GtkAllocation _tmp7_;
	cairo_surface_t* _tmp8_;
	cairo_t* cr2 = NULL;
	cairo_t* _tmp9_;
	cairo_surface_t* _tmp10_;
	GdkDevice* device = NULL;
	GdkDevice* _tmp11_;
	GdkDevice* _tmp12_;
	gint x = 0;
	gint y = 0;
	GdkModifierType mask = 0U;
	GdkWindow* _tmp13_;
	gint _tmp14_ = 0;
	gint _tmp15_ = 0;
	GdkModifierType _tmp16_ = 0U;
	g_return_if_fail (ctx != NULL);
	gtk_widget_get_allocation ((GtkWidget*) self, &_tmp0_);
	alloc = _tmp0_;
	_tmp1_ = alloc;
	_tmp2_ = alloc;
	_tmp3_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp1_.width, _tmp2_.height);
	surface = _tmp3_;
	_tmp4_ = cairo_create (surface);
	cr = _tmp4_;
	g_signal_emit_by_name ((GtkWidget*) self, "draw", cr, &_tmp5_);
	_tmp6_ = alloc;
	_tmp7_ = alloc;
	_tmp8_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, _tmp6_.width, _tmp7_.height);
	surface2 = _tmp8_;
	_tmp9_ = cairo_create (surface2);
	cr2 = _tmp9_;
	_tmp10_ = cairo_get_target (cr);
	cairo_set_source_surface (cr2, _tmp10_, (gdouble) 0, (gdouble) 1);
	cairo_set_operator (cr2, CAIRO_OPERATOR_OVER);
	cairo_paint_with_alpha (cr2, 0.5);
	_tmp11_ = gtk_get_current_event_device ();
	_tmp12_ = _g_object_ref0 (_tmp11_);
	device = _tmp12_;
	_tmp13_ = gtk_widget_get_window ((GtkWidget*) self);
	gdk_window_get_device_position (_tmp13_, device, &_tmp14_, &_tmp15_, &_tmp16_);
	x = _tmp14_;
	y = _tmp15_;
	mask = _tmp16_;
	cairo_surface_set_device_offset (surface2, (gdouble) (-x), (gdouble) 0);
	gtk_drag_set_icon_surface (ctx, surface2);
	_g_object_unref0 (device);
	_cairo_destroy0 (cr2);
	_cairo_surface_destroy0 (surface2);
	_cairo_destroy0 (cr);
	_cairo_surface_destroy0 (surface);
}

static void
___lambda154__gtk_widget_drag_begin (GtkWidget* _sender,
                                     GdkDragContext* context,
                                     gpointer self)
{
	__lambda154_ ((SidebarBookmarkRow*) self, context);
}

static guint8*
string_get_data (const gchar* self,
                 gint* result_length1)
{
	guint8* result;
	guint8* res = NULL;
	gint res_length1;
	gint _res_size_;
	gint _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint _tmp2__length1;
	g_return_val_if_fail (self != NULL, NULL);
	res = (guint8*) self;
	res_length1 = -1;
	_res_size_ = res_length1;
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	res_length1 = (gint) _tmp1_;
	_tmp2_ = res;
	_tmp2__length1 = res_length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static guint8*
_vala_array_dup3 (guint8* self,
                  gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (guint8));
	}
	return NULL;
}

static void
__lambda155_ (SidebarBookmarkRow* self,
              GdkDragContext* ctx,
              GtkSelectionData* sel_data,
              guint info,
              guint time)
{
	guint8* data = NULL;
	guint32 _tmp0_;
	guint32 _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	guint8* _tmp4_;
	gint _tmp4__length1;
	gint _tmp5_ = 0;
	guint8* _tmp6_;
	gint _tmp6__length1;
	guint8* _tmp7_;
	gint _tmp7__length1;
	guint8* _tmp8_;
	gint _tmp8__length1;
	gint data_length1;
	gint _data_size_;
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (sel_data != NULL);
	_tmp0_ = sidebar_sidebar_item_interface_get_id ((SidebarSidebarItemInterface*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_strdup_printf ("%u", _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = string_get_data (_tmp3_, &_tmp5_);
	_tmp4__length1 = _tmp5_;
	_tmp6_ = _tmp4_;
	_tmp6__length1 = _tmp4__length1;
	_tmp7_ = (_tmp6_ != NULL) ? _vala_array_dup3 (_tmp6_, _tmp6__length1) : _tmp6_;
	_tmp7__length1 = _tmp6__length1;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = _tmp7__length1;
	_g_free0 (_tmp3_);
	data = _tmp8_;
	data_length1 = _tmp8__length1;
	_data_size_ = data_length1;
	gtk_selection_data_set (sel_data, sidebar_bookmark_row_text_data_atom, 8, data, (gint) data_length1);
	data = (g_free (data), NULL);
}

static void
___lambda155__gtk_widget_drag_data_get (GtkWidget* _sender,
                                        GdkDragContext* context,
                                        GtkSelectionData* selection_data,
                                        guint info,
                                        guint time_,
                                        gpointer self)
{
	__lambda155_ ((SidebarBookmarkRow*) self, context, selection_data, info, time_);
}

static void
__lambda156_ (SidebarBookmarkRow* self,
              GdkDragContext* ctx)
{
	g_return_if_fail (ctx != NULL);
	sidebar_bookmark_row_reset_drag_drop (self);
}

static void
___lambda156__gtk_widget_drag_end (GtkWidget* _sender,
                                   GdkDragContext* context,
                                   gpointer self)
{
	__lambda156_ ((SidebarBookmarkRow*) self, context);
}

static void
sidebar_bookmark_row_set_up_drag (SidebarBookmarkRow* self)
{
	gboolean _tmp0_;
	gboolean _tmp1_;
	GtkTargetEntry* _tmp2_;
	gint _tmp2__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = sidebar_sidebar_item_interface_get_pinned ((SidebarSidebarItemInterface*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		return;
	}
	_tmp2_ = sidebar_bookmark_row_source_targets;
	_tmp2__length1 = sidebar_bookmark_row_source_targets_length1;
	gtk_drag_source_set ((GtkWidget*) self, GDK_BUTTON1_MASK, _tmp2_, (gint) _tmp2__length1, GDK_ACTION_MOVE);
	g_signal_connect_object ((GtkWidget*) self, "drag-begin", (GCallback) ___lambda154__gtk_widget_drag_begin, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-get", (GCallback) ___lambda155__gtk_widget_drag_data_get, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-end", (GCallback) ___lambda156__gtk_widget_drag_end, self, 0);
}

static void
__lambda157_ (SidebarBookmarkRow* self,
              GdkDragContext* ctx,
              gint x,
              gint y,
              GtkSelectionData* sel_data,
              guint info,
              guint time)
{
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (sel_data != NULL);
	_g_free0 (self->priv->drop_text);
	self->priv->drop_text = NULL;
	switch (info) {
		case FILES_TARGET_TYPE_BOOKMARK_ROW:
		{
			gchar* _tmp0_;
			_tmp0_ = gtk_selection_data_get_text (sel_data);
			_g_free0 (self->priv->drop_text);
			self->priv->drop_text = _tmp0_;
			break;
		}
		case FILES_TARGET_TYPE_TEXT_URI_LIST:
		{
			gchar* _tmp1_ = NULL;
			gboolean _tmp2_;
			_tmp2_ = files_dnd_handler_selection_data_is_uri_list (sel_data, info, &_tmp1_);
			_g_free0 (self->priv->drop_text);
			self->priv->drop_text = _tmp1_;
			if (!_tmp2_) {
				g_warning ("BookmarkRow.vala:443: sel data not uri list");
				_g_free0 (self->priv->drop_text);
				self->priv->drop_text = NULL;
			} else {
				const gchar* _tmp3_;
				GList* _tmp4_;
				_tmp3_ = self->priv->drop_text;
				_tmp4_ = files_file_utils_files_from_uris (_tmp3_);
				(self->priv->drop_file_list == NULL) ? NULL : (self->priv->drop_file_list = (_g_list_free__g_object_unref0_ (self->priv->drop_file_list), NULL));
				self->priv->drop_file_list = _tmp4_;
			}
			break;
		}
		default:
		{
			return;
		}
	}
	if (self->priv->drop_occurred) {
		gboolean success = FALSE;
		success = FALSE;
		switch (info) {
			case FILES_TARGET_TYPE_BOOKMARK_ROW:
			{
				const gchar* _tmp5_;
				GtkRevealer* _tmp6_;
				gboolean _tmp7_;
				gboolean _tmp8_;
				_tmp5_ = self->priv->drop_text;
				_tmp6_ = self->drop_revealer;
				_tmp7_ = gtk_revealer_get_child_revealed (_tmp6_);
				_tmp8_ = _tmp7_;
				success = sidebar_bookmark_row_process_dropped_row (self, _tmp5_, _tmp8_);
				break;
			}
			case FILES_TARGET_TYPE_TEXT_URI_LIST:
			{
				GList* _tmp9_;
				GtkRevealer* _tmp10_;
				gboolean _tmp11_;
				gboolean _tmp12_;
				_tmp9_ = self->priv->drop_file_list;
				_tmp10_ = self->drop_revealer;
				_tmp11_ = gtk_revealer_get_child_revealed (_tmp10_);
				_tmp12_ = _tmp11_;
				success = sidebar_bookmark_row_process_dropped_uris (self, gdk_drag_context_get_selected_action (ctx), gdk_drag_context_get_actions (ctx), _tmp9_, _tmp12_);
				break;
			}
			default:
			break;
		}
		gtk_drag_finish (ctx, success, FALSE, (guint32) time);
		sidebar_bookmark_row_reset_drag_drop (self);
	}
}

static void
___lambda157__gtk_widget_drag_data_received (GtkWidget* _sender,
                                             GdkDragContext* context,
                                             gint x,
                                             gint y,
                                             GtkSelectionData* selection_data,
                                             guint info,
                                             guint time_,
                                             gpointer self)
{
	__lambda157_ ((SidebarBookmarkRow*) self, context, x, y, selection_data, info, time_);
}

static gboolean
_gdk_drag_action_equal (const GdkDragAction * s1,
                        const GdkDragAction * s2)
{
	if (s1 == s2) {
		return TRUE;
	}
	if (s1 == NULL) {
		return FALSE;
	}
	if (s2 == NULL) {
		return FALSE;
	}
	return (*s1) == (*s2);
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gboolean
__lambda158_ (SidebarBookmarkRow* self,
              GdkDragContext* ctx,
              gint x,
              gint y,
              guint time)
{
	GdkAtom target = (GdkAtom) 0U;
	const gchar* _tmp0_;
	gint pos = 0;
	SidebarBookmarkRow* previous_item = NULL;
	SidebarSidebarListInterface* _tmp1_;
	SidebarSidebarListInterface* _tmp2_;
	SidebarSidebarItemInterface* _tmp3_;
	SidebarBookmarkRow* next_item = NULL;
	SidebarSidebarListInterface* _tmp4_;
	SidebarSidebarListInterface* _tmp5_;
	SidebarSidebarItemInterface* _tmp6_;
	SidebarBookmarkRow* _tmp7_;
	gint row_height = 0;
	GtkGrid* _tmp9_;
	gboolean reveal = FALSE;
	GdkDragAction _tmp10_;
	GdkDragAction* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	GQuark _tmp15_ = 0U;
	static GQuark _tmp14_label0 = 0;
	static GQuark _tmp14_label1 = 0;
	GdkDragAction* _tmp60_;
	gboolean result;
	g_return_val_if_fail (ctx != NULL, FALSE);
	target = gtk_drag_dest_find_target ((GtkWidget*) self, ctx, NULL);
	_tmp0_ = self->priv->drop_text;
	if (_tmp0_ == NULL) {
		if (target != GDK_NONE) {
			gtk_drag_get_data ((GtkWidget*) self, ctx, target, (guint32) time);
		}
		result = TRUE;
		return result;
	}
	pos = sidebar_sidebar_item_interface_get_index ((SidebarSidebarItemInterface*) self);
	_tmp1_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = sidebar_sidebar_list_interface_get_item_at_index (_tmp2_, pos - 1);
	previous_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow);
	_tmp4_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = sidebar_sidebar_list_interface_get_item_at_index (_tmp5_, pos + 1);
	next_item = G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow);
	_tmp7_ = previous_item;
	if (_tmp7_ != NULL) {
		SidebarBookmarkRow* _tmp8_;
		_tmp8_ = previous_item;
		sidebar_bookmark_row_reveal_drop_target (_tmp8_, FALSE);
	}
	_tmp9_ = self->icon_label_grid;
	row_height = gtk_widget_get_allocated_height ((GtkWidget*) _tmp9_);
	reveal = FALSE;
	_tmp10_ = GDK_ACTION_DEFAULT;
	_tmp11_ = __gdk_drag_action_dup0 (&_tmp10_);
	_g_free0 (self->priv->current_suggested_action);
	self->priv->current_suggested_action = _tmp11_;
	_tmp12_ = gdk_atom_name (target);
	_tmp13_ = _tmp12_;
	_tmp15_ = (NULL == _tmp13_) ? 0 : g_quark_from_string (_tmp13_);
	g_free (_tmp13_);
	if (_tmp15_ == ((0 != _tmp14_label0) ? _tmp14_label0 : (_tmp14_label0 = g_quark_from_static_string ("text/plain")))) {
		switch (0) {
			default:
			{
				gboolean _tmp16_ = FALSE;
				gboolean _tmp17_ = FALSE;
				gboolean _tmp18_;
				gboolean _tmp19_;
				_tmp18_ = sidebar_sidebar_item_interface_get_can_insert_after ((SidebarSidebarItemInterface*) self);
				_tmp19_ = _tmp18_;
				if (_tmp19_) {
					gboolean _tmp20_ = FALSE;
					SidebarBookmarkRow* _tmp21_;
					_tmp21_ = next_item;
					if (_tmp21_ == NULL) {
						_tmp20_ = TRUE;
					} else {
						SidebarBookmarkRow* _tmp22_;
						gboolean _tmp23_;
						gboolean _tmp24_;
						_tmp22_ = next_item;
						_tmp23_ = sidebar_sidebar_item_interface_get_can_insert_before ((SidebarSidebarItemInterface*) _tmp22_);
						_tmp24_ = _tmp23_;
						_tmp20_ = _tmp24_;
					}
					_tmp17_ = _tmp20_;
				} else {
					_tmp17_ = FALSE;
				}
				if (_tmp17_) {
					_tmp16_ = y > (row_height / 2);
				} else {
					_tmp16_ = FALSE;
				}
				reveal = _tmp16_;
				break;
			}
		}
	} else if (_tmp15_ == ((0 != _tmp14_label1) ? _tmp14_label1 : (_tmp14_label1 = g_quark_from_static_string ("text/uri-list")))) {
		switch (0) {
			default:
			{
				gboolean _tmp25_ = FALSE;
				gboolean _tmp26_ = FALSE;
				gboolean _tmp27_;
				gboolean _tmp28_;
				gboolean _tmp34_ = FALSE;
				gboolean _tmp35_ = FALSE;
				FilesFile* _tmp36_;
				_tmp27_ = sidebar_sidebar_item_interface_get_can_insert_after ((SidebarSidebarItemInterface*) self);
				_tmp28_ = _tmp27_;
				if (_tmp28_) {
					gboolean _tmp29_ = FALSE;
					SidebarBookmarkRow* _tmp30_;
					_tmp30_ = next_item;
					if (_tmp30_ == NULL) {
						_tmp29_ = TRUE;
					} else {
						SidebarBookmarkRow* _tmp31_;
						gboolean _tmp32_;
						gboolean _tmp33_;
						_tmp31_ = next_item;
						_tmp32_ = sidebar_sidebar_item_interface_get_can_insert_before ((SidebarSidebarItemInterface*) _tmp31_);
						_tmp33_ = _tmp32_;
						_tmp29_ = _tmp33_;
					}
					_tmp26_ = _tmp29_;
				} else {
					_tmp26_ = FALSE;
				}
				if (_tmp26_) {
					_tmp25_ = y > (row_height - 1);
				} else {
					_tmp25_ = FALSE;
				}
				reveal = _tmp25_;
				_tmp36_ = self->target_file;
				if (_tmp36_ != NULL) {
					_tmp35_ = !reveal;
				} else {
					_tmp35_ = FALSE;
				}
				if (_tmp35_) {
					GList* _tmp37_;
					_tmp37_ = self->priv->drop_file_list;
					_tmp34_ = _tmp37_ != NULL;
				} else {
					_tmp34_ = FALSE;
				}
				if (_tmp34_) {
					FilesFile* _tmp38_;
					GList* _tmp39_;
					GdkDragAction _tmp40_ = 0U;
					GdkDragAction _tmp41_;
					GdkDragAction* _tmp42_;
					GdkDragAction* _tmp43_;
					GdkDragAction _tmp44_;
					_tmp38_ = self->target_file;
					_tmp39_ = self->priv->drop_file_list;
					files_dnd_handler_file_accepts_drop (_tmp38_, _tmp39_, gdk_drag_context_get_selected_action (ctx), gdk_drag_context_get_actions (ctx), &_tmp40_);
					_g_free0 (self->priv->current_suggested_action);
					_tmp41_ = _tmp40_;
					_tmp42_ = __gdk_drag_action_dup0 (&_tmp41_);
					self->priv->current_suggested_action = _tmp42_;
					_tmp43_ = self->priv->current_suggested_action;
					_tmp44_ = GDK_ACTION_DEFAULT;
					if (_gdk_drag_action_equal (_tmp43_, &_tmp44_) != TRUE) {
						sidebar_bookmark_row_highlight (self, TRUE);
					}
				} else {
					sidebar_bookmark_row_highlight (self, FALSE);
				}
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				break;
			}
		}
	}
	if (sidebar_bookmark_row_reveal_drop_target (self, reveal)) {
		GdkDragAction _tmp45_;
		GdkDragAction* _tmp46_;
		gboolean _tmp47_ = FALSE;
		gboolean _tmp48_ = FALSE;
		gchar* _tmp49_;
		gchar* _tmp50_;
		gboolean _tmp51_;
		_tmp45_ = GDK_ACTION_LINK;
		_tmp46_ = __gdk_drag_action_dup0 (&_tmp45_);
		_g_free0 (self->priv->current_suggested_action);
		self->priv->current_suggested_action = _tmp46_;
		_tmp49_ = gdk_atom_name (target);
		_tmp50_ = _tmp49_;
		_tmp51_ = g_strcmp0 (_tmp50_, "text/uri-list") == 0;
		_g_free0 (_tmp50_);
		if (_tmp51_) {
			const gchar* _tmp52_;
			_tmp52_ = self->priv->drop_text;
			_tmp48_ = _tmp52_ != NULL;
		} else {
			_tmp48_ = FALSE;
		}
		if (_tmp48_) {
			SidebarSidebarListInterface* _tmp53_;
			SidebarSidebarListInterface* _tmp54_;
			const gchar* _tmp55_;
			gchar* _tmp56_;
			gchar* _tmp57_;
			_tmp53_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
			_tmp54_ = _tmp53_;
			_tmp55_ = self->priv->drop_text;
			_tmp56_ = string_strip (_tmp55_);
			_tmp57_ = _tmp56_;
			_tmp47_ = sidebar_sidebar_list_interface_has_uri (_tmp54_, _tmp57_, NULL);
			_g_free0 (_tmp57_);
		} else {
			_tmp47_ = FALSE;
		}
		if (_tmp47_) {
			GdkDragAction _tmp58_;
			GdkDragAction* _tmp59_;
			_tmp58_ = GDK_ACTION_DEFAULT;
			_tmp59_ = __gdk_drag_action_dup0 (&_tmp58_);
			_g_free0 (self->priv->current_suggested_action);
			self->priv->current_suggested_action = _tmp59_;
			reveal = FALSE;
		}
	}
	_tmp60_ = self->priv->current_suggested_action;
	gdk_drag_status (ctx, *_tmp60_, (guint32) time);
	result = TRUE;
	_g_object_unref0 (next_item);
	_g_object_unref0 (previous_item);
	return result;
}

static gboolean
___lambda158__gtk_widget_drag_motion (GtkWidget* _sender,
                                      GdkDragContext* context,
                                      gint x,
                                      gint y,
                                      guint time_,
                                      gpointer self)
{
	gboolean result;
	result = __lambda158_ ((SidebarBookmarkRow*) self, context, x, y, time_);
	return result;
}

static void
__lambda159_ (SidebarBookmarkRow* self)
{
	sidebar_bookmark_row_reset_drag_drop (self);
}

static void
___lambda159__gtk_widget_drag_leave (GtkWidget* _sender,
                                     GdkDragContext* context,
                                     guint time_,
                                     gpointer self)
{
	__lambda159_ ((SidebarBookmarkRow*) self);
}

static gboolean
__lambda160_ (SidebarBookmarkRow* self,
              GdkDragContext* ctx,
              gint x,
              gint y,
              guint time)
{
	GdkAtom target = (GdkAtom) 0U;
	gboolean result;
	g_return_val_if_fail (ctx != NULL, FALSE);
	target = gtk_drag_dest_find_target ((GtkWidget*) self, ctx, NULL);
	if (target != GDK_NONE) {
		self->priv->drop_occurred = TRUE;
		gtk_drag_get_data ((GtkWidget*) self, ctx, target, (guint32) time);
	} else {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

static gboolean
___lambda160__gtk_widget_drag_drop (GtkWidget* _sender,
                                    GdkDragContext* context,
                                    gint x,
                                    gint y,
                                    guint time_,
                                    gpointer self)
{
	gboolean result;
	result = __lambda160_ ((SidebarBookmarkRow*) self, context, x, y, time_);
	return result;
}

static void
sidebar_bookmark_row_set_up_drop (SidebarBookmarkRow* self)
{
	GtkSeparator* drop_revealer_child = NULL;
	GtkSeparator* _tmp0_ = NULL;
	GtkWidget* _tmp1_;
	GtkRevealer* _tmp2_ = NULL;
	GtkRevealer* _tmp3_;
	GtkGrid* _tmp4_;
	GtkRevealer* _tmp5_;
	GtkTargetEntry* _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkSeparator*) gtk_separator_new (GTK_ORIENTATION_HORIZONTAL);
	gtk_widget_set_margin_top ((GtkWidget*) _tmp0_, 12);
	gtk_widget_set_margin_bottom ((GtkWidget*) _tmp0_, 0);
	g_object_ref_sink (_tmp0_);
	drop_revealer_child = _tmp0_;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) drop_revealer_child);
	_tmp2_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp2_, "child", _tmp1_, NULL);
	_g_object_unref0 (_tmp1_);
	gtk_revealer_set_transition_type (_tmp2_, GTK_REVEALER_TRANSITION_TYPE_SLIDE_UP);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->drop_revealer);
	self->drop_revealer = _tmp2_;
	_tmp3_ = self->drop_revealer;
	gtk_widget_show_all ((GtkWidget*) _tmp3_);
	_tmp4_ = self->content_grid;
	_tmp5_ = self->drop_revealer;
	gtk_grid_attach (_tmp4_, (GtkWidget*) _tmp5_, 0, 1, 1, 1);
	_tmp6_ = sidebar_bookmark_row_dest_targets;
	_tmp6__length1 = sidebar_bookmark_row_dest_targets_length1;
	gtk_drag_dest_set ((GtkWidget*) self, GTK_DEST_DEFAULT_MOTION | GTK_DEST_DEFAULT_HIGHLIGHT, _tmp6_, (gint) _tmp6__length1, ((GDK_ACTION_MOVE | GDK_ACTION_COPY) | GDK_ACTION_LINK) | GDK_ACTION_ASK);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-received", (GCallback) ___lambda157__gtk_widget_drag_data_received, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-motion", (GCallback) ___lambda158__gtk_widget_drag_motion, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-leave", (GCallback) ___lambda159__gtk_widget_drag_leave, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-drop", (GCallback) ___lambda160__gtk_widget_drag_drop, self, 0);
	_g_object_unref0 (drop_revealer_child);
}

void
sidebar_bookmark_row_highlight (SidebarBookmarkRow* self,
                                gboolean show)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (show) {
		GtkStyleContext* _tmp1_;
		_tmp1_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp0_ = !gtk_style_context_has_class (_tmp1_, GTK_STYLE_CLASS_HIGHLIGHT);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GtkStyleContext* _tmp2_;
		_tmp2_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp2_, GTK_STYLE_CLASS_HIGHLIGHT);
	} else {
		gboolean _tmp3_ = FALSE;
		if (!show) {
			GtkStyleContext* _tmp4_;
			_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
			_tmp3_ = gtk_style_context_has_class (_tmp4_, GTK_STYLE_CLASS_HIGHLIGHT);
		} else {
			_tmp3_ = FALSE;
		}
		if (_tmp3_) {
			GtkStyleContext* _tmp5_;
			_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
			gtk_style_context_remove_class (_tmp5_, GTK_STYLE_CLASS_HIGHLIGHT);
		}
	}
}

static void
sidebar_bookmark_row_reset_drag_drop (SidebarBookmarkRow* self)
{
	GdkDragAction _tmp0_;
	GdkDragAction* _tmp1_;
	g_return_if_fail (self != NULL);
	(self->priv->drop_file_list == NULL) ? NULL : (self->priv->drop_file_list = (_g_list_free__g_object_unref0_ (self->priv->drop_file_list), NULL));
	self->priv->drop_file_list = NULL;
	_g_free0 (self->priv->drop_text);
	self->priv->drop_text = NULL;
	self->priv->drop_occurred = FALSE;
	_tmp0_ = GDK_ACTION_DEFAULT;
	_tmp1_ = __gdk_drag_action_dup0 (&_tmp0_);
	_g_free0 (self->priv->current_suggested_action);
	self->priv->current_suggested_action = _tmp1_;
	sidebar_bookmark_row_reveal_drop_target (self, FALSE);
	sidebar_bookmark_row_highlight (self, FALSE);
}

static guint
uint_parse (const gchar* str,
            guint _base)
{
	guint result;
	g_return_val_if_fail (str != NULL, 0U);
	result = (guint) strtoul (str, NULL, (gint) _base);
	return result;
}

static gboolean
sidebar_bookmark_row_process_dropped_row (SidebarBookmarkRow* self,
                                          const gchar* drop_text,
                                          gboolean dropped_between)
{
	guint32 id = 0U;
	SidebarSidebarItemInterface* item = NULL;
	SidebarSidebarItemInterface* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	SidebarSidebarItemInterface* _tmp3_;
	SidebarSidebarListInterface* _tmp9_;
	SidebarSidebarListInterface* _tmp10_;
	SidebarSidebarItemInterface* _tmp11_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (drop_text != NULL, FALSE);
	id = (guint32) uint_parse (drop_text, (guint) 0);
	_tmp0_ = sidebar_sidebar_item_interface_get_item (id);
	item = _tmp0_;
	_tmp3_ = item;
	if (_tmp3_ == NULL) {
		_tmp2_ = TRUE;
	} else {
		_tmp2_ = !dropped_between;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		SidebarSidebarItemInterface* _tmp4_;
		SidebarSidebarListInterface* _tmp5_;
		SidebarSidebarListInterface* _tmp6_;
		SidebarSidebarListInterface* _tmp7_;
		SidebarSidebarListInterface* _tmp8_;
		_tmp4_ = item;
		_tmp5_ = sidebar_sidebar_item_interface_get_list (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp6_ != _tmp8_;
	}
	if (_tmp1_) {
		result = FALSE;
		_g_object_unref0 (item);
		return result;
	}
	_tmp9_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
	_tmp10_ = _tmp9_;
	_tmp11_ = item;
	sidebar_sidebar_list_interface_move_item_after (_tmp10_, _tmp11_, sidebar_sidebar_item_interface_get_index ((SidebarSidebarItemInterface*) self));
	result = TRUE;
	_g_object_unref0 (item);
	return result;
}

static gboolean
sidebar_bookmark_row_process_dropped_uris (SidebarBookmarkRow* self,
                                           GdkDragAction selected_action,
                                           GdkDragAction possible_actions,
                                           GList* drop_file_list,
                                           gboolean dropped_between)
{
	gboolean _tmp0_ = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	if (dropped_between) {
		GList* _tmp1_;
		_tmp1_ = drop_file_list->next;
		_tmp0_ = _tmp1_ == NULL;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint pos = 0;
		gint _tmp2_;
		SidebarSidebarListInterface* _tmp3_;
		SidebarSidebarListInterface* _tmp4_;
		gconstpointer _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gboolean _tmp8_;
		pos = sidebar_sidebar_item_interface_get_index ((SidebarSidebarItemInterface*) self);
		_tmp2_ = pos;
		pos = _tmp2_ + 1;
		_tmp3_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = drop_file_list->data;
		_tmp6_ = g_file_get_uri ((GFile*) _tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = sidebar_sidebar_list_interface_add_favorite (_tmp4_, _tmp7_, "", pos);
		_g_free0 (_tmp7_);
		result = _tmp8_;
		return result;
	} else {
		FilesDndHandler* dnd_handler = NULL;
		FilesDndHandler* _tmp9_;
		GdkDragAction real_action = 0U;
		FilesDndHandler* _tmp17_;
		FilesFile* _tmp18_;
		_tmp9_ = files_dnd_handler_new ();
		dnd_handler = _tmp9_;
		real_action = selected_action;
		if (real_action == GDK_ACTION_ASK) {
			GdkDragAction actions = 0U;
			const gchar* _tmp10_;
			const gchar* _tmp11_;
			FilesDndHandler* _tmp12_;
			GtkWindow* _tmp13_;
			GtkApplicationWindow* _tmp14_;
			GdkDragAction* _tmp15_;
			GdkDragAction* _tmp16_;
			actions = possible_actions;
			_tmp10_ = sidebar_sidebar_item_interface_get_uri ((SidebarSidebarItemInterface*) self);
			_tmp11_ = _tmp10_;
			if (g_str_has_prefix (_tmp11_, "trash://")) {
				actions &= GDK_ACTION_MOVE;
			}
			_tmp12_ = dnd_handler;
			_tmp13_ = files_get_active_window ();
			_tmp14_ = G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_application_window_get_type (), GtkApplicationWindow);
			_tmp15_ = files_dnd_handler_drag_drop_action_ask (_tmp12_, (GtkWidget*) self, _tmp14_, actions);
			_tmp16_ = _tmp15_;
			real_action = *_tmp16_;
			_g_free0 (_tmp16_);
			_g_object_unref0 (_tmp14_);
		}
		if (real_action == 0) {
			result = FALSE;
			_g_object_unref0 (dnd_handler);
			return result;
		}
		_tmp17_ = dnd_handler;
		_tmp18_ = self->target_file;
		files_dnd_handler_dnd_perform (_tmp17_, (GtkWidget*) self, _tmp18_, drop_file_list, real_action);
		result = TRUE;
		_g_object_unref0 (dnd_handler);
		return result;
	}
}

gboolean
sidebar_bookmark_row_reveal_drop_target (SidebarBookmarkRow* self,
                                         gboolean reveal)
{
	SidebarSidebarListInterface* _tmp0_;
	SidebarSidebarListInterface* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
	_tmp1_ = _tmp0_;
	if (sidebar_sidebar_list_interface_is_drop_target (_tmp1_)) {
		GtkRevealer* _tmp2_;
		_tmp2_ = self->drop_revealer;
		gtk_revealer_set_reveal_child (_tmp2_, reveal);
		result = reveal;
		return result;
	} else {
		result = FALSE;
		return result;
	}
}

static SidebarSidebarListInterface*
sidebar_bookmark_row_real_get_list (SidebarSidebarItemInterface* base)
{
	SidebarSidebarListInterface* result;
	SidebarBookmarkRow* self;
	SidebarSidebarListInterface* _tmp0_;
	self = (SidebarBookmarkRow*) base;
	_tmp0_ = self->priv->_list;
	result = _tmp0_;
	return result;
}

static void
sidebar_bookmark_row_real_set_list (SidebarSidebarItemInterface* base,
                                    SidebarSidebarListInterface* value)
{
	SidebarBookmarkRow* self;
	SidebarSidebarListInterface* old_value;
	self = (SidebarBookmarkRow*) base;
	old_value = sidebar_bookmark_row_real_get_list (base);
	if (old_value != value) {
		SidebarSidebarListInterface* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_list);
		self->priv->_list = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_LIST_PROPERTY]);
	}
}

static GIcon*
sidebar_bookmark_row_real_get_gicon (SidebarSidebarItemInterface* base)
{
	GIcon* result;
	SidebarBookmarkRow* self;
	GIcon* _tmp0_;
	self = (SidebarBookmarkRow*) base;
	_tmp0_ = self->priv->_gicon;
	result = _tmp0_;
	return result;
}

static void
sidebar_bookmark_row_real_set_gicon (SidebarSidebarItemInterface* base,
                                     GIcon* value)
{
	SidebarBookmarkRow* self;
	GIcon* old_value;
	self = (SidebarBookmarkRow*) base;
	old_value = sidebar_bookmark_row_real_get_gicon (base);
	if (old_value != value) {
		GIcon* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_gicon);
		self->priv->_gicon = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_GICON_PROPERTY]);
	}
}

static const gchar*
sidebar_bookmark_row_real_get_uri (SidebarSidebarItemInterface* base)
{
	const gchar* result;
	SidebarBookmarkRow* self;
	const gchar* _tmp0_;
	self = (SidebarBookmarkRow*) base;
	_tmp0_ = self->priv->_uri;
	result = _tmp0_;
	return result;
}

static void
sidebar_bookmark_row_real_set_uri (SidebarSidebarItemInterface* base,
                                   const gchar* value)
{
	SidebarBookmarkRow* self;
	gchar* old_value;
	self = (SidebarBookmarkRow*) base;
	old_value = sidebar_bookmark_row_real_get_uri (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_uri);
		self->priv->_uri = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_URI_PROPERTY]);
	}
}

static const gchar*
sidebar_bookmark_row_real_get_custom_name (SidebarSidebarItemInterface* base)
{
	const gchar* result;
	SidebarBookmarkRow* self;
	const gchar* _tmp0_;
	self = (SidebarBookmarkRow*) base;
	_tmp0_ = self->priv->_custom_name;
	result = _tmp0_;
	return result;
}

static void
sidebar_bookmark_row_real_set_custom_name (SidebarSidebarItemInterface* base,
                                           const gchar* value)
{
	SidebarBookmarkRow* self;
	gchar* old_value;
	self = (SidebarBookmarkRow*) base;
	old_value = sidebar_bookmark_row_real_get_custom_name (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_custom_name);
		self->priv->_custom_name = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_CUSTOM_NAME_PROPERTY]);
	}
}

const gchar*
sidebar_bookmark_row_get_display_name (SidebarBookmarkRow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = string_strip (_tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp3_, "") != 0;
	_g_free0 (_tmp3_);
	if (_tmp4_) {
		const gchar* _tmp5_;
		const gchar* _tmp6_;
		_tmp5_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) self);
		_tmp6_ = _tmp5_;
		result = _tmp6_;
		return result;
	} else {
		FilesFile* _tmp7_;
		const gchar* _tmp8_;
		_tmp7_ = self->target_file;
		_tmp8_ = files_file_get_display_name (_tmp7_);
		result = _tmp8_;
		return result;
	}
}

static guint32
sidebar_bookmark_row_real_get_id (SidebarSidebarItemInterface* base)
{
	guint32 result;
	SidebarBookmarkRow* self;
	self = (SidebarBookmarkRow*) base;
	result = self->priv->_id;
	return result;
}

static void
sidebar_bookmark_row_real_set_id (SidebarSidebarItemInterface* base,
                                  guint32 value)
{
	SidebarBookmarkRow* self;
	guint32 old_value;
	self = (SidebarBookmarkRow*) base;
	old_value = sidebar_bookmark_row_real_get_id (base);
	if (old_value != value) {
		self->priv->_id = value;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_ID_PROPERTY]);
	}
}

static gboolean
sidebar_bookmark_row_real_get_pinned (SidebarSidebarItemInterface* base)
{
	gboolean result;
	SidebarBookmarkRow* self;
	self = (SidebarBookmarkRow*) base;
	result = self->priv->_pinned;
	return result;
}

static void
sidebar_bookmark_row_real_set_pinned (SidebarSidebarItemInterface* base,
                                      gboolean value)
{
	SidebarBookmarkRow* self;
	gboolean old_value;
	self = (SidebarBookmarkRow*) base;
	old_value = sidebar_bookmark_row_real_get_pinned (base);
	if (old_value != value) {
		self->priv->_pinned = value;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_PINNED_PROPERTY]);
	}
}

static gboolean
sidebar_bookmark_row_real_get_permanent (SidebarSidebarItemInterface* base)
{
	gboolean result;
	SidebarBookmarkRow* self;
	self = (SidebarBookmarkRow*) base;
	result = self->priv->_permanent;
	return result;
}

static void
sidebar_bookmark_row_real_set_permanent (SidebarSidebarItemInterface* base,
                                         gboolean value)
{
	SidebarBookmarkRow* self;
	gboolean old_value;
	self = (SidebarBookmarkRow*) base;
	old_value = sidebar_bookmark_row_real_get_permanent (base);
	if (old_value != value) {
		self->priv->_permanent = value;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_PERMANENT_PROPERTY]);
	}
}

static gboolean
sidebar_bookmark_row_real_get_can_insert_before (SidebarSidebarItemInterface* base)
{
	gboolean result;
	SidebarBookmarkRow* self;
	self = (SidebarBookmarkRow*) base;
	result = self->priv->_can_insert_before;
	return result;
}

static void
sidebar_bookmark_row_real_set_can_insert_before (SidebarSidebarItemInterface* base,
                                                 gboolean value)
{
	SidebarBookmarkRow* self;
	gboolean old_value;
	self = (SidebarBookmarkRow*) base;
	old_value = sidebar_bookmark_row_real_get_can_insert_before (base);
	if (old_value != value) {
		self->priv->_can_insert_before = value;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_CAN_INSERT_BEFORE_PROPERTY]);
	}
}

static gboolean
sidebar_bookmark_row_real_get_can_insert_after (SidebarSidebarItemInterface* base)
{
	gboolean result;
	SidebarBookmarkRow* self;
	self = (SidebarBookmarkRow*) base;
	result = self->priv->_can_insert_after;
	return result;
}

static void
sidebar_bookmark_row_real_set_can_insert_after (SidebarSidebarItemInterface* base,
                                                gboolean value)
{
	SidebarBookmarkRow* self;
	gboolean old_value;
	self = (SidebarBookmarkRow*) base;
	old_value = sidebar_bookmark_row_real_get_can_insert_after (base);
	if (old_value != value) {
		self->priv->_can_insert_after = value;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_CAN_INSERT_AFTER_PROPERTY]);
	}
}

static GMenuModel*
sidebar_bookmark_row_real_get_menu_model (SidebarSidebarItemInterface* base)
{
	GMenuModel* result;
	SidebarBookmarkRow* self;
	GMenuModel* _tmp0_;
	self = (SidebarBookmarkRow*) base;
	_tmp0_ = self->priv->_menu_model;
	result = _tmp0_;
	return result;
}

static void
sidebar_bookmark_row_real_set_menu_model (SidebarSidebarItemInterface* base,
                                          GMenuModel* value)
{
	SidebarBookmarkRow* self;
	GMenuModel* old_value;
	self = (SidebarBookmarkRow*) base;
	old_value = sidebar_bookmark_row_real_get_menu_model (base);
	if (old_value != value) {
		GMenuModel* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_menu_model);
		self->priv->_menu_model = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_MENU_MODEL_PROPERTY]);
	}
}

static GActionGroup*
sidebar_bookmark_row_real_get_action_group (SidebarSidebarItemInterface* base)
{
	GActionGroup* result;
	SidebarBookmarkRow* self;
	GActionGroup* _tmp0_;
	self = (SidebarBookmarkRow*) base;
	_tmp0_ = self->priv->_action_group;
	result = _tmp0_;
	return result;
}

static void
sidebar_bookmark_row_real_set_action_group (SidebarSidebarItemInterface* base,
                                            GActionGroup* value)
{
	SidebarBookmarkRow* self;
	GActionGroup* old_value;
	self = (SidebarBookmarkRow*) base;
	old_value = sidebar_bookmark_row_real_get_action_group (base);
	if (old_value != value) {
		GActionGroup* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_action_group);
		self->priv->_action_group = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_ACTION_GROUP_PROPERTY]);
	}
}

static const gchar*
sidebar_bookmark_row_real_get_action_group_namespace (SidebarSidebarItemInterface* base)
{
	const gchar* result;
	SidebarBookmarkRow* self;
	const gchar* _tmp0_;
	self = (SidebarBookmarkRow*) base;
	_tmp0_ = self->priv->_action_group_namespace;
	result = _tmp0_;
	return result;
}

static void
sidebar_bookmark_row_real_set_action_group_namespace (SidebarSidebarItemInterface* base,
                                                      const gchar* value)
{
	SidebarBookmarkRow* self;
	gchar* old_value;
	self = (SidebarBookmarkRow*) base;
	old_value = sidebar_bookmark_row_real_get_action_group_namespace (base);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_action_group_namespace);
		self->priv->_action_group_namespace = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_ACTION_GROUP_NAMESPACE_PROPERTY]);
	}
}

static void
_sidebar_bookmark_row____lambda161_ (SidebarBookmarkRow* self)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GtkEntry* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GtkStack* _tmp14_;
	_tmp0_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = self->editable;
	_tmp3_ = gtk_entry_get_text (_tmp2_);
	_tmp4_ = _tmp3_;
	if (g_strcmp0 (_tmp1_, _tmp4_) != 0) {
		GtkEntry* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		SidebarSidebarListInterface* _tmp8_;
		SidebarSidebarListInterface* _tmp9_;
		const gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		const gchar* _tmp13_;
		_tmp5_ = self->editable;
		_tmp6_ = gtk_entry_get_text (_tmp5_);
		_tmp7_ = _tmp6_;
		sidebar_sidebar_item_interface_set_custom_name ((SidebarSidebarItemInterface*) self, _tmp7_);
		_tmp8_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
		_tmp9_ = _tmp8_;
		_tmp10_ = sidebar_sidebar_item_interface_get_uri ((SidebarSidebarItemInterface*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) self);
		_tmp13_ = _tmp12_;
		sidebar_sidebar_list_interface_rename_bookmark_by_uri (_tmp9_, _tmp11_, _tmp13_);
	}
	_tmp14_ = self->label_stack;
	gtk_stack_set_visible_child_name (_tmp14_, "label");
}

static void
__sidebar_bookmark_row____lambda161__gtk_entry_activate (GtkEntry* _sender,
                                                         gpointer self)
{
	_sidebar_bookmark_row____lambda161_ ((SidebarBookmarkRow*) self);
}

static gboolean
_sidebar_bookmark_row____lambda162_ (SidebarBookmarkRow* self)
{
	GtkStack* _tmp0_;
	_tmp0_ = self->label_stack;
	gtk_stack_set_visible_child_name (_tmp0_, "label");
}

static gboolean
__sidebar_bookmark_row____lambda162__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                                 GdkEventFocus* event,
                                                                 gpointer self)
{
	gboolean result;
	result = _sidebar_bookmark_row____lambda162_ ((SidebarBookmarkRow*) self);
	return result;
}

static gboolean
_sidebar_bookmark_row_on_key_press_event_gtk_event_controller_key_key_pressed (GtkEventControllerKey* _sender,
                                                                               guint keyval,
                                                                               guint keycode,
                                                                               GdkModifierType state,
                                                                               gpointer self)
{
	gboolean result;
	result = sidebar_bookmark_row_on_key_press_event ((SidebarBookmarkRow*) self, keyval, keycode, state);
	return result;
}

static void
_sidebar_bookmark_row_on_button_release_event_gtk_gesture_multi_press_released (GtkGestureMultiPress* _sender,
                                                                                gint n_press,
                                                                                gdouble x,
                                                                                gdouble y,
                                                                                gpointer self)
{
	sidebar_bookmark_row_on_button_release_event ((SidebarBookmarkRow*) self, n_press, x, y);
}

static void
_sidebar_bookmark_row___lambda163_ (SidebarBookmarkRow* self)
{
	GtkImage* _tmp0_;
	GIcon* _tmp1_;
	GIcon* _tmp2_;
	_tmp0_ = self->priv->icon;
	_tmp1_ = sidebar_sidebar_item_interface_get_gicon ((SidebarSidebarItemInterface*) self);
	_tmp2_ = _tmp1_;
	gtk_image_set_from_gicon (_tmp0_, _tmp2_, (GtkIconSize) GTK_ICON_SIZE_MENU);
}

static void
__sidebar_bookmark_row___lambda163__g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	_sidebar_bookmark_row___lambda163_ ((SidebarBookmarkRow*) self);
}

static void
_sidebar_bookmark_row___lambda164_ (SidebarBookmarkRow* self)
{
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	_tmp0_ = self->label;
	_tmp1_ = sidebar_bookmark_row_get_display_name (self);
	_tmp2_ = _tmp1_;
	gtk_label_set_label (_tmp0_, _tmp2_);
}

static void
__sidebar_bookmark_row___lambda164__g_object_notify (GObject* _sender,
                                                     GParamSpec* pspec,
                                                     gpointer self)
{
	_sidebar_bookmark_row___lambda164_ ((SidebarBookmarkRow*) self);
}

static void
_sidebar_bookmark_row___lambda165_ (SidebarBookmarkRow* self)
{
	sidebar_sidebar_item_interface_activated ((SidebarSidebarItemInterface*) self, FILES_OPEN_FLAG_DEFAULT);
}

static void
__sidebar_bookmark_row___lambda165__g_simple_action_activate (GSimpleAction* _sender,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	_sidebar_bookmark_row___lambda165_ ((SidebarBookmarkRow*) self);
}

static void
_sidebar_bookmark_row___lambda166_ (SidebarBookmarkRow* self)
{
	sidebar_sidebar_item_interface_activated ((SidebarSidebarItemInterface*) self, FILES_OPEN_FLAG_NEW_TAB);
}

static void
__sidebar_bookmark_row___lambda166__g_simple_action_activate (GSimpleAction* _sender,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	_sidebar_bookmark_row___lambda166_ ((SidebarBookmarkRow*) self);
}

static void
_sidebar_bookmark_row___lambda167_ (SidebarBookmarkRow* self)
{
	sidebar_sidebar_item_interface_activated ((SidebarSidebarItemInterface*) self, FILES_OPEN_FLAG_NEW_WINDOW);
}

static void
__sidebar_bookmark_row___lambda167__g_simple_action_activate (GSimpleAction* _sender,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	_sidebar_bookmark_row___lambda167_ ((SidebarBookmarkRow*) self);
}

static void
_sidebar_bookmark_row_rename_g_simple_action_activate (GSimpleAction* _sender,
                                                       GVariant* parameter,
                                                       gpointer self)
{
	sidebar_bookmark_row_rename ((SidebarBookmarkRow*) self);
}

static void
_sidebar_bookmark_row___lambda168_ (SidebarBookmarkRow* self)
{
	SidebarSidebarListInterface* _tmp0_;
	SidebarSidebarListInterface* _tmp1_;
	guint32 _tmp2_;
	guint32 _tmp3_;
	_tmp0_ = sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = sidebar_sidebar_item_interface_get_id ((SidebarSidebarItemInterface*) self);
	_tmp3_ = _tmp2_;
	sidebar_sidebar_list_interface_remove_item_by_id (_tmp1_, _tmp3_);
}

static void
__sidebar_bookmark_row___lambda168__g_simple_action_activate (GSimpleAction* _sender,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	_sidebar_bookmark_row___lambda168_ ((SidebarBookmarkRow*) self);
}

static void
_sidebar_bookmark_row___lambda169_ (SidebarBookmarkRow* self)
{
	GtkWidget* _tmp0_;
	FilesFileOperationsEmptyTrashJob* _tmp1_;
	FilesFileOperationsEmptyTrashJob* _tmp2_;
	_tmp0_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp1_ = marlin_file_operations_empty_trash_job_new (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_window_get_type (), GtkWindow), NULL);
	_tmp2_ = _tmp1_;
	marlin_file_operations_empty_trash_job_empty_trash (_tmp2_, NULL, NULL);
	_marlin_file_operations_common_job_unref0 (_tmp2_);
}

static void
__sidebar_bookmark_row___lambda169__g_simple_action_activate (GSimpleAction* _sender,
                                                              GVariant* parameter,
                                                              gpointer self)
{
	_sidebar_bookmark_row___lambda169_ ((SidebarBookmarkRow*) self);
}

static GObject *
sidebar_bookmark_row_constructor (GType type,
                                  guint n_construct_properties,
                                  GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SidebarBookmarkRow * self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	FilesFile* _tmp2_;
	FilesFile* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeHashMap* _tmp8_;
	guint32 _tmp9_;
	guint32 _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	GtkLabel* _tmp13_ = NULL;
	GtkStack* _tmp14_ = NULL;
	GtkStack* _tmp15_;
	GtkLabel* _tmp16_;
	gboolean _tmp17_;
	gboolean _tmp18_;
	GtkStack* _tmp24_;
	GIcon* _tmp25_;
	GIcon* _tmp26_;
	GtkImage* _tmp27_;
	GtkGrid* _tmp28_ = NULL;
	GtkGrid* _tmp29_;
	GtkImage* _tmp30_;
	GtkGrid* _tmp31_;
	GtkStack* _tmp32_;
	GtkGrid* _tmp33_;
	GtkGrid* _tmp34_;
	GtkGrid* _tmp35_;
	GtkGrid* _tmp36_;
	GtkEventControllerKey* _tmp37_ = NULL;
	GtkEventControllerKey* _tmp38_;
	GtkGestureMultiPress* _tmp39_ = NULL;
	GtkGestureMultiPress* _tmp40_;
	GSimpleAction* open_action = NULL;
	GSimpleAction* _tmp41_;
	GSimpleAction* _tmp42_;
	GSimpleAction* open_tab_action = NULL;
	GSimpleAction* _tmp43_;
	GSimpleAction* _tmp44_;
	GSimpleAction* open_window_action = NULL;
	GSimpleAction* _tmp45_;
	GSimpleAction* _tmp46_;
	GSimpleAction* rename_action = NULL;
	GSimpleAction* _tmp47_;
	GSimpleAction* _tmp48_;
	GSimpleAction* remove_action = NULL;
	GSimpleAction* _tmp49_;
	GSimpleAction* _tmp50_;
	GSimpleAction* _tmp51_;
	GSimpleAction* _tmp52_;
	GSimpleActionGroup* action_group = NULL;
	GSimpleActionGroup* _tmp53_;
	GSimpleActionGroup* _tmp54_;
	GSimpleAction* _tmp55_;
	GSimpleActionGroup* _tmp56_;
	GSimpleAction* _tmp57_;
	GSimpleActionGroup* _tmp58_;
	GSimpleAction* _tmp59_;
	GSimpleActionGroup* _tmp60_;
	GSimpleAction* _tmp61_;
	GSimpleActionGroup* _tmp62_;
	GSimpleAction* _tmp63_;
	GSimpleActionGroup* _tmp64_;
	GSimpleAction* _tmp65_;
	GSimpleActionGroup* _tmp66_;
	GApplication* _tmp67_;
	gchar* _tmp68_;
	gchar** _tmp69_;
	gchar** _tmp70_;
	gint _tmp70__length1;
	parent_class = G_OBJECT_CLASS (sidebar_bookmark_row_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow);
	_tmp0_ = sidebar_sidebar_item_interface_get_uri ((SidebarSidebarItemInterface*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = files_file_get_by_uri (_tmp1_);
	_g_object_unref0 (self->target_file);
	self->target_file = _tmp2_;
	_tmp3_ = self->target_file;
	files_file_ensure_query_info (_tmp3_);
	_tmp4_ = sidebar_sidebar_item_interface_get_uri ((SidebarSidebarItemInterface*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = files_file_utils_sanitize_path (_tmp5_, NULL, FALSE);
	_tmp7_ = _tmp6_;
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp7_);
	_g_free0 (_tmp7_);
	gtk_list_box_row_set_selectable ((GtkListBoxRow*) self, TRUE);
	sidebar_sidebar_item_interface_set_id ((SidebarSidebarItemInterface*) self, sidebar_sidebar_item_interface_get_next_item_id ());
	g_mutex_lock (&sidebar_sidebar_item_interface_item_map_lock);
	_tmp8_ = sidebar_sidebar_item_interface_item_id_map;
	_tmp9_ = sidebar_sidebar_item_interface_get_id ((SidebarSidebarItemInterface*) self);
	_tmp10_ = _tmp9_;
	gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, (gpointer) ((guintptr) _tmp10_), (SidebarSidebarItemInterface*) self);
	g_mutex_unlock (&sidebar_sidebar_item_interface_item_map_lock);
	_tmp11_ = sidebar_bookmark_row_get_display_name (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = (GtkLabel*) gtk_label_new (_tmp12_);
	gtk_label_set_xalign (_tmp13_, 0.0f);
	gtk_widget_set_halign ((GtkWidget*) _tmp13_, GTK_ALIGN_START);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp13_, TRUE);
	gtk_label_set_ellipsize (_tmp13_, PANGO_ELLIPSIZE_END);
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->label);
	self->label = _tmp13_;
	_tmp14_ = (GtkStack*) gtk_stack_new ();
	gtk_stack_set_hhomogeneous (_tmp14_, FALSE);
	gtk_stack_set_vhomogeneous (_tmp14_, FALSE);
	g_object_ref_sink (_tmp14_);
	_g_object_unref0 (self->label_stack);
	self->label_stack = _tmp14_;
	_tmp15_ = self->label_stack;
	_tmp16_ = self->label;
	gtk_stack_add_named (_tmp15_, (GtkWidget*) _tmp16_, "label");
	_tmp17_ = sidebar_sidebar_item_interface_get_pinned ((SidebarSidebarItemInterface*) self);
	_tmp18_ = _tmp17_;
	if (!_tmp18_) {
		GtkEntry* _tmp19_;
		GtkStack* _tmp20_;
		GtkEntry* _tmp21_;
		GtkEntry* _tmp22_;
		GtkEntry* _tmp23_;
		_tmp19_ = (GtkEntry*) gtk_entry_new ();
		g_object_ref_sink (_tmp19_);
		_g_object_unref0 (self->editable);
		self->editable = _tmp19_;
		_tmp20_ = self->label_stack;
		_tmp21_ = self->editable;
		gtk_stack_add_named (_tmp20_, (GtkWidget*) _tmp21_, "editable");
		_tmp22_ = self->editable;
		g_signal_connect_object (_tmp22_, "activate", (GCallback) __sidebar_bookmark_row____lambda161__gtk_entry_activate, self, 0);
		_tmp23_ = self->editable;
		g_signal_connect_object ((GtkWidget*) _tmp23_, "focus-out-event", (GCallback) __sidebar_bookmark_row____lambda162__gtk_widget_focus_out_event, self, 0);
	}
	_tmp24_ = self->label_stack;
	gtk_stack_set_visible_child_name (_tmp24_, "label");
	_tmp25_ = sidebar_sidebar_item_interface_get_gicon ((SidebarSidebarItemInterface*) self);
	_tmp26_ = _tmp25_;
	_tmp27_ = (GtkImage*) gtk_image_new_from_gicon (_tmp26_, (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp27_);
	_g_object_unref0 (self->priv->icon);
	self->priv->icon = _tmp27_;
	_tmp28_ = (GtkGrid*) gtk_grid_new ();
	gtk_grid_set_column_spacing (_tmp28_, 6);
	g_object_ref_sink (_tmp28_);
	_g_object_unref0 (self->icon_label_grid);
	self->icon_label_grid = _tmp28_;
	_tmp29_ = self->icon_label_grid;
	_tmp30_ = self->priv->icon;
	gtk_grid_attach (_tmp29_, (GtkWidget*) _tmp30_, 0, 0, 1, 2);
	_tmp31_ = self->icon_label_grid;
	_tmp32_ = self->label_stack;
	gtk_container_add ((GtkContainer*) _tmp31_, (GtkWidget*) _tmp32_);
	_tmp33_ = (GtkGrid*) gtk_grid_new ();
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->content_grid);
	self->content_grid = _tmp33_;
	_tmp34_ = self->content_grid;
	_tmp35_ = self->icon_label_grid;
	gtk_grid_attach (_tmp34_, (GtkWidget*) _tmp35_, 0, 0, 1, 1);
	_tmp36_ = self->content_grid;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp36_);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp37_ = (GtkEventControllerKey*) gtk_event_controller_key_new ((GtkWidget*) self);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp37_, GTK_PHASE_BUBBLE);
	_g_object_unref0 (self->priv->key_controller);
	self->priv->key_controller = _tmp37_;
	_tmp38_ = self->priv->key_controller;
	g_signal_connect_object (_tmp38_, "key-pressed", (GCallback) _sidebar_bookmark_row_on_key_press_event_gtk_event_controller_key_key_pressed, self, 0);
	_tmp39_ = (GtkGestureMultiPress*) gtk_gesture_multi_press_new ((GtkWidget*) self);
	gtk_event_controller_set_propagation_phase ((GtkEventController*) _tmp39_, GTK_PHASE_BUBBLE);
	gtk_gesture_single_set_button ((GtkGestureSingle*) _tmp39_, (guint) 0);
	_g_object_unref0 (self->priv->button_controller);
	self->priv->button_controller = _tmp39_;
	_tmp40_ = self->priv->button_controller;
	g_signal_connect_object (_tmp40_, "released", (GCallback) _sidebar_bookmark_row_on_button_release_event_gtk_gesture_multi_press_released, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::gicon", (GCallback) __sidebar_bookmark_row___lambda163__g_object_notify, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::custom-name", (GCallback) __sidebar_bookmark_row___lambda164__g_object_notify, self, 0);
	sidebar_bookmark_row_set_up_drag (self);
	sidebar_bookmark_row_set_up_drop (self);
	_tmp41_ = g_simple_action_new ("open", NULL);
	open_action = _tmp41_;
	_tmp42_ = open_action;
	g_signal_connect_object (_tmp42_, "activate", (GCallback) __sidebar_bookmark_row___lambda165__g_simple_action_activate, self, 0);
	_tmp43_ = g_simple_action_new ("open-tab", NULL);
	open_tab_action = _tmp43_;
	_tmp44_ = open_tab_action;
	g_signal_connect_object (_tmp44_, "activate", (GCallback) __sidebar_bookmark_row___lambda166__g_simple_action_activate, self, 0);
	_tmp45_ = g_simple_action_new ("open-window", NULL);
	open_window_action = _tmp45_;
	_tmp46_ = open_window_action;
	g_signal_connect_object (_tmp46_, "activate", (GCallback) __sidebar_bookmark_row___lambda167__g_simple_action_activate, self, 0);
	_tmp47_ = g_simple_action_new ("rename", NULL);
	rename_action = _tmp47_;
	_tmp48_ = rename_action;
	g_signal_connect_object (_tmp48_, "activate", (GCallback) _sidebar_bookmark_row_rename_g_simple_action_activate, self, 0);
	_tmp49_ = g_simple_action_new ("remove", NULL);
	remove_action = _tmp49_;
	_tmp50_ = remove_action;
	g_signal_connect_object (_tmp50_, "activate", (GCallback) __sidebar_bookmark_row___lambda168__g_simple_action_activate, self, 0);
	_tmp51_ = g_simple_action_new ("empty-all-trash", NULL);
	_g_object_unref0 (self->priv->empty_all_trash_action);
	self->priv->empty_all_trash_action = _tmp51_;
	_tmp52_ = self->priv->empty_all_trash_action;
	g_signal_connect_object (_tmp52_, "activate", (GCallback) __sidebar_bookmark_row___lambda169__g_simple_action_activate, self, 0);
	_tmp53_ = g_simple_action_group_new ();
	action_group = _tmp53_;
	_tmp54_ = action_group;
	_tmp55_ = open_action;
	g_action_map_add_action ((GActionMap*) _tmp54_, (GAction*) _tmp55_);
	_tmp56_ = action_group;
	_tmp57_ = open_tab_action;
	g_action_map_add_action ((GActionMap*) _tmp56_, (GAction*) _tmp57_);
	_tmp58_ = action_group;
	_tmp59_ = open_window_action;
	g_action_map_add_action ((GActionMap*) _tmp58_, (GAction*) _tmp59_);
	_tmp60_ = action_group;
	_tmp61_ = rename_action;
	g_action_map_add_action ((GActionMap*) _tmp60_, (GAction*) _tmp61_);
	_tmp62_ = action_group;
	_tmp63_ = remove_action;
	g_action_map_add_action ((GActionMap*) _tmp62_, (GAction*) _tmp63_);
	_tmp64_ = action_group;
	_tmp65_ = self->priv->empty_all_trash_action;
	g_action_map_add_action ((GActionMap*) _tmp64_, (GAction*) _tmp65_);
	_tmp66_ = action_group;
	gtk_widget_insert_action_group ((GtkWidget*) self, "bookmark", (GActionGroup*) _tmp66_);
	_tmp67_ = g_application_get_default ();
	_tmp68_ = g_strdup ("F2");
	_tmp69_ = g_new0 (gchar*, 1 + 1);
	_tmp69_[0] = _tmp68_;
	_tmp70_ = _tmp69_;
	_tmp70__length1 = 1;
	gtk_application_set_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp67_, gtk_application_get_type (), GtkApplication), "bookmark.rename", _tmp70_);
	_tmp70_ = (_vala_array_free (_tmp70_, _tmp70__length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (action_group);
	_g_object_unref0 (remove_action);
	_g_object_unref0 (rename_action);
	_g_object_unref0 (open_window_action);
	_g_object_unref0 (open_tab_action);
	_g_object_unref0 (open_action);
	return obj;
}

static void
sidebar_bookmark_row_class_init (SidebarBookmarkRowClass * klass,
                                 gpointer klass_data)
{
	GtkTargetEntry _tmp0_ = {0};
	GtkTargetEntry* _tmp1_;
	GtkTargetEntry _tmp2_ = {0};
	GtkTargetEntry _tmp3_ = {0};
	GtkTargetEntry* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	GRand* _tmp7_;
	GRand* _tmp8_;
	GeeHashMap* _tmp9_;
	sidebar_bookmark_row_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SidebarBookmarkRow_private_offset);
	((SidebarBookmarkRowClass *) klass)->on_key_press_event = (gboolean (*) (SidebarBookmarkRow*, guint, guint, GdkModifierType)) sidebar_bookmark_row_real_on_key_press_event;
	((SidebarBookmarkRowClass *) klass)->on_button_release_event = (void (*) (SidebarBookmarkRow*, gint, gdouble, gdouble)) sidebar_bookmark_row_real_on_button_release_event;
	((SidebarBookmarkRowClass *) klass)->popup_context_menu = (void (*) (SidebarBookmarkRow*)) sidebar_bookmark_row_real_popup_context_menu;
	G_OBJECT_CLASS (klass)->get_property = _vala_sidebar_bookmark_row_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sidebar_bookmark_row_set_property;
	G_OBJECT_CLASS (klass)->constructor = sidebar_bookmark_row_constructor;
	G_OBJECT_CLASS (klass)->finalize = sidebar_bookmark_row_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_ROW_LIST_PROPERTY, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_LIST_PROPERTY] = g_param_spec_object ("list", "list", "list", SIDEBAR_TYPE_SIDEBAR_LIST_INTERFACE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_ROW_GICON_PROPERTY, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_GICON_PROPERTY] = g_param_spec_object ("gicon", "gicon", "gicon", g_icon_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_ROW_URI_PROPERTY, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_URI_PROPERTY] = g_param_spec_string ("uri", "uri", "uri", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_ROW_CUSTOM_NAME_PROPERTY, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_CUSTOM_NAME_PROPERTY] = g_param_spec_string ("custom-name", "custom-name", "custom-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_ROW_DISPLAY_NAME_PROPERTY, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_DISPLAY_NAME_PROPERTY] = g_param_spec_string ("display-name", "display-name", "display-name", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_ROW_ID_PROPERTY, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_ID_PROPERTY] = g_param_spec_uint ("id", "id", "id", 0, G_MAXUINT, 0U, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_ROW_PINNED_PROPERTY, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_PINNED_PROPERTY] = g_param_spec_boolean ("pinned", "pinned", "pinned", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_ROW_PERMANENT_PROPERTY, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_PERMANENT_PROPERTY] = g_param_spec_boolean ("permanent", "permanent", "permanent", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_ROW_CAN_INSERT_BEFORE_PROPERTY, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_CAN_INSERT_BEFORE_PROPERTY] = g_param_spec_boolean ("can-insert-before", "can-insert-before", "can-insert-before", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_ROW_CAN_INSERT_AFTER_PROPERTY, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_CAN_INSERT_AFTER_PROPERTY] = g_param_spec_boolean ("can-insert-after", "can-insert-after", "can-insert-after", TRUE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_ROW_MENU_MODEL_PROPERTY, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_MENU_MODEL_PROPERTY] = g_param_spec_object ("menu-model", "menu-model", "menu-model", g_menu_model_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_ROW_ACTION_GROUP_PROPERTY, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_ACTION_GROUP_PROPERTY] = g_param_spec_object ("action-group", "action-group", "action-group", g_action_group_get_type (), G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_BOOKMARK_ROW_ACTION_GROUP_NAMESPACE_PROPERTY, sidebar_bookmark_row_properties[SIDEBAR_BOOKMARK_ROW_ACTION_GROUP_NAMESPACE_PROPERTY] = g_param_spec_string ("action-group-namespace", "action-group-namespace", "action-group-namespace", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	memset (&_tmp0_, 0, sizeof (GtkTargetEntry));
	_tmp0_.target = "text/plain";
	_tmp0_.flags = (guint) GTK_TARGET_SAME_APP;
	_tmp0_.info = (guint) FILES_TARGET_TYPE_BOOKMARK_ROW;
	_tmp1_ = g_new0 (GtkTargetEntry, 1);
	_tmp1_[0] = _tmp0_;
	sidebar_bookmark_row_source_targets = _tmp1_;
	sidebar_bookmark_row_source_targets_length1 = 1;
	_sidebar_bookmark_row_source_targets_size_ = sidebar_bookmark_row_source_targets_length1;
	memset (&_tmp2_, 0, sizeof (GtkTargetEntry));
	_tmp2_.target = "text/uri-list";
	_tmp2_.flags = (guint) GTK_TARGET_SAME_APP;
	_tmp2_.info = (guint) FILES_TARGET_TYPE_TEXT_URI_LIST;
	memset (&_tmp3_, 0, sizeof (GtkTargetEntry));
	_tmp3_.target = "text/plain";
	_tmp3_.flags = (guint) GTK_TARGET_SAME_APP;
	_tmp3_.info = (guint) FILES_TARGET_TYPE_BOOKMARK_ROW;
	_tmp4_ = g_new0 (GtkTargetEntry, 2);
	_tmp4_[0] = _tmp2_;
	_tmp4_[1] = _tmp3_;
	sidebar_bookmark_row_dest_targets = _tmp4_;
	sidebar_bookmark_row_dest_targets_length1 = 2;
	_sidebar_bookmark_row_dest_targets_size_ = sidebar_bookmark_row_dest_targets_length1;
	sidebar_bookmark_row_text_data_atom = gdk_atom_intern_static_string ("text/plain");
	_tmp5_ = g_strdup_printf ("%" G_GINT64_FORMAT, g_get_real_time ());
	_tmp6_ = _tmp5_;
	_tmp7_ = g_rand_new_with_seed ((guint32) atoi (_tmp6_));
	_tmp8_ = _tmp7_;
	sidebar_sidebar_item_interface_row_id = g_rand_int (_tmp8_);
	_g_rand_free0 (_tmp8_);
	_g_free0 (_tmp6_);
	_vala_clear_GMutex (&sidebar_sidebar_item_interface_item_map_lock);
	g_mutex_init (&sidebar_sidebar_item_interface_item_map_lock);
	_tmp9_ = gee_hash_map_new (G_TYPE_UINT, NULL, NULL, SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	_g_object_unref0 (sidebar_sidebar_item_interface_item_id_map);
	sidebar_sidebar_item_interface_item_id_map = _tmp9_;
}

static void
sidebar_bookmark_row_sidebar_sidebar_item_interface_interface_init (SidebarSidebarItemInterfaceIface * iface,
                                                                    gpointer iface_data)
{
	sidebar_bookmark_row_sidebar_sidebar_item_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->update_plugin_data = (void (*) (SidebarSidebarItemInterface*, FilesSidebarPluginItem*)) sidebar_bookmark_row_real_update_plugin_data;
	iface->destroy_bookmark = (void (*) (SidebarSidebarItemInterface*)) sidebar_bookmark_row_real_destroy_bookmark;
	iface->add_extra_menu_items = (void (*) (SidebarSidebarItemInterface*, GMenu*)) sidebar_bookmark_row_real_add_extra_menu_items;
	iface->get_index = (gint (*) (SidebarSidebarItemInterface*)) gtk_list_box_row_get_index;
	iface->get_list = sidebar_bookmark_row_real_get_list;
	iface->set_list = sidebar_bookmark_row_real_set_list;
	iface->get_gicon = sidebar_bookmark_row_real_get_gicon;
	iface->set_gicon = sidebar_bookmark_row_real_set_gicon;
	iface->get_uri = sidebar_bookmark_row_real_get_uri;
	iface->set_uri = sidebar_bookmark_row_real_set_uri;
	iface->get_custom_name = sidebar_bookmark_row_real_get_custom_name;
	iface->set_custom_name = sidebar_bookmark_row_real_set_custom_name;
	iface->get_id = sidebar_bookmark_row_real_get_id;
	iface->set_id = sidebar_bookmark_row_real_set_id;
	iface->get_pinned = sidebar_bookmark_row_real_get_pinned;
	iface->set_pinned = sidebar_bookmark_row_real_set_pinned;
	iface->get_permanent = sidebar_bookmark_row_real_get_permanent;
	iface->set_permanent = sidebar_bookmark_row_real_set_permanent;
	iface->get_can_insert_before = sidebar_bookmark_row_real_get_can_insert_before;
	iface->set_can_insert_before = sidebar_bookmark_row_real_set_can_insert_before;
	iface->get_can_insert_after = sidebar_bookmark_row_real_get_can_insert_after;
	iface->set_can_insert_after = sidebar_bookmark_row_real_set_can_insert_after;
	iface->get_menu_model = sidebar_bookmark_row_real_get_menu_model;
	iface->set_menu_model = sidebar_bookmark_row_real_set_menu_model;
	iface->get_action_group = sidebar_bookmark_row_real_get_action_group;
	iface->set_action_group = sidebar_bookmark_row_real_set_action_group;
	iface->get_action_group_namespace = sidebar_bookmark_row_real_get_action_group_namespace;
	iface->set_action_group_namespace = sidebar_bookmark_row_real_set_action_group_namespace;
}

static void
sidebar_bookmark_row_instance_init (SidebarBookmarkRow * self,
                                    gpointer klass)
{
	gchar* _tmp0_;
	GdkDragAction _tmp1_;
	GdkDragAction* _tmp2_;
	self->priv = sidebar_bookmark_row_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->_custom_name = _tmp0_;
	self->priv->_can_insert_before = TRUE;
	self->priv->_can_insert_after = TRUE;
	self->priv->_menu_model = NULL;
	self->priv->_action_group = NULL;
	self->priv->_action_group_namespace = NULL;
	self->priv->drop_file_list = NULL;
	_tmp1_ = GDK_ACTION_DEFAULT;
	_tmp2_ = __gdk_drag_action_dup0 (&_tmp1_);
	self->priv->current_suggested_action = _tmp2_;
	self->priv->drop_text = NULL;
	self->priv->drop_occurred = FALSE;
	self->priv->valid = TRUE;
}

static void
sidebar_bookmark_row_finalize (GObject * obj)
{
	SidebarBookmarkRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow);
	_g_object_unref0 (self->priv->_list);
	_g_object_unref0 (self->priv->_gicon);
	_g_free0 (self->priv->_uri);
	_g_free0 (self->priv->_custom_name);
	_g_object_unref0 (self->priv->_menu_model);
	_g_object_unref0 (self->priv->_action_group);
	_g_free0 (self->priv->_action_group_namespace);
	_g_object_unref0 (self->content_grid);
	_g_object_unref0 (self->icon_label_grid);
	_g_object_unref0 (self->label_stack);
	_g_object_unref0 (self->editable);
	_g_object_unref0 (self->label);
	_g_object_unref0 (self->drop_revealer);
	_g_object_unref0 (self->priv->icon);
	_g_object_unref0 (self->target_file);
	(self->priv->drop_file_list == NULL) ? NULL : (self->priv->drop_file_list = (_g_list_free__g_object_unref0_ (self->priv->drop_file_list), NULL));
	_g_free0 (self->priv->current_suggested_action);
	_g_object_unref0 (self->priv->key_controller);
	_g_object_unref0 (self->priv->button_controller);
	_g_object_unref0 (self->priv->empty_all_trash_action);
	_g_free0 (self->priv->drop_text);
	G_OBJECT_CLASS (sidebar_bookmark_row_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
sidebar_bookmark_row_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarBookmarkRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_bookmark_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarBookmarkRow), 0, (GInstanceInitFunc) sidebar_bookmark_row_instance_init, NULL };
	static const GInterfaceInfo sidebar_sidebar_item_interface_info = { (GInterfaceInitFunc) sidebar_bookmark_row_sidebar_sidebar_item_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType sidebar_bookmark_row_type_id;
	sidebar_bookmark_row_type_id = g_type_register_static (gtk_list_box_row_get_type (), "SidebarBookmarkRow", &g_define_type_info, 0);
	g_type_add_interface_static (sidebar_bookmark_row_type_id, SIDEBAR_TYPE_SIDEBAR_ITEM_INTERFACE, &sidebar_sidebar_item_interface_info);
	SidebarBookmarkRow_private_offset = g_type_add_instance_private (sidebar_bookmark_row_type_id, sizeof (SidebarBookmarkRowPrivate));
	return sidebar_bookmark_row_type_id;
}

GType
sidebar_bookmark_row_get_type (void)
{
	static volatile gsize sidebar_bookmark_row_type_id__once = 0;
	if (g_once_init_enter (&sidebar_bookmark_row_type_id__once)) {
		GType sidebar_bookmark_row_type_id;
		sidebar_bookmark_row_type_id = sidebar_bookmark_row_get_type_once ();
		g_once_init_leave (&sidebar_bookmark_row_type_id__once, sidebar_bookmark_row_type_id);
	}
	return sidebar_bookmark_row_type_id__once;
}

static void
_vala_sidebar_bookmark_row_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	SidebarBookmarkRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow);
	switch (property_id) {
		case SIDEBAR_BOOKMARK_ROW_LIST_PROPERTY:
		g_value_set_object (value, sidebar_sidebar_item_interface_get_list ((SidebarSidebarItemInterface*) self));
		break;
		case SIDEBAR_BOOKMARK_ROW_GICON_PROPERTY:
		g_value_set_object (value, sidebar_sidebar_item_interface_get_gicon ((SidebarSidebarItemInterface*) self));
		break;
		case SIDEBAR_BOOKMARK_ROW_URI_PROPERTY:
		g_value_set_string (value, sidebar_sidebar_item_interface_get_uri ((SidebarSidebarItemInterface*) self));
		break;
		case SIDEBAR_BOOKMARK_ROW_CUSTOM_NAME_PROPERTY:
		g_value_set_string (value, sidebar_sidebar_item_interface_get_custom_name ((SidebarSidebarItemInterface*) self));
		break;
		case SIDEBAR_BOOKMARK_ROW_DISPLAY_NAME_PROPERTY:
		g_value_set_string (value, sidebar_bookmark_row_get_display_name (self));
		break;
		case SIDEBAR_BOOKMARK_ROW_ID_PROPERTY:
		g_value_set_uint (value, sidebar_sidebar_item_interface_get_id ((SidebarSidebarItemInterface*) self));
		break;
		case SIDEBAR_BOOKMARK_ROW_PINNED_PROPERTY:
		g_value_set_boolean (value, sidebar_sidebar_item_interface_get_pinned ((SidebarSidebarItemInterface*) self));
		break;
		case SIDEBAR_BOOKMARK_ROW_PERMANENT_PROPERTY:
		g_value_set_boolean (value, sidebar_sidebar_item_interface_get_permanent ((SidebarSidebarItemInterface*) self));
		break;
		case SIDEBAR_BOOKMARK_ROW_CAN_INSERT_BEFORE_PROPERTY:
		g_value_set_boolean (value, sidebar_sidebar_item_interface_get_can_insert_before ((SidebarSidebarItemInterface*) self));
		break;
		case SIDEBAR_BOOKMARK_ROW_CAN_INSERT_AFTER_PROPERTY:
		g_value_set_boolean (value, sidebar_sidebar_item_interface_get_can_insert_after ((SidebarSidebarItemInterface*) self));
		break;
		case SIDEBAR_BOOKMARK_ROW_MENU_MODEL_PROPERTY:
		g_value_set_object (value, sidebar_sidebar_item_interface_get_menu_model ((SidebarSidebarItemInterface*) self));
		break;
		case SIDEBAR_BOOKMARK_ROW_ACTION_GROUP_PROPERTY:
		g_value_set_object (value, sidebar_sidebar_item_interface_get_action_group ((SidebarSidebarItemInterface*) self));
		break;
		case SIDEBAR_BOOKMARK_ROW_ACTION_GROUP_NAMESPACE_PROPERTY:
		g_value_set_string (value, sidebar_sidebar_item_interface_get_action_group_namespace ((SidebarSidebarItemInterface*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sidebar_bookmark_row_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	SidebarBookmarkRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_BOOKMARK_ROW, SidebarBookmarkRow);
	switch (property_id) {
		case SIDEBAR_BOOKMARK_ROW_LIST_PROPERTY:
		sidebar_sidebar_item_interface_set_list ((SidebarSidebarItemInterface*) self, g_value_get_object (value));
		break;
		case SIDEBAR_BOOKMARK_ROW_GICON_PROPERTY:
		sidebar_sidebar_item_interface_set_gicon ((SidebarSidebarItemInterface*) self, g_value_get_object (value));
		break;
		case SIDEBAR_BOOKMARK_ROW_URI_PROPERTY:
		sidebar_sidebar_item_interface_set_uri ((SidebarSidebarItemInterface*) self, g_value_get_string (value));
		break;
		case SIDEBAR_BOOKMARK_ROW_CUSTOM_NAME_PROPERTY:
		sidebar_sidebar_item_interface_set_custom_name ((SidebarSidebarItemInterface*) self, g_value_get_string (value));
		break;
		case SIDEBAR_BOOKMARK_ROW_ID_PROPERTY:
		sidebar_sidebar_item_interface_set_id ((SidebarSidebarItemInterface*) self, g_value_get_uint (value));
		break;
		case SIDEBAR_BOOKMARK_ROW_PINNED_PROPERTY:
		sidebar_sidebar_item_interface_set_pinned ((SidebarSidebarItemInterface*) self, g_value_get_boolean (value));
		break;
		case SIDEBAR_BOOKMARK_ROW_PERMANENT_PROPERTY:
		sidebar_sidebar_item_interface_set_permanent ((SidebarSidebarItemInterface*) self, g_value_get_boolean (value));
		break;
		case SIDEBAR_BOOKMARK_ROW_CAN_INSERT_BEFORE_PROPERTY:
		sidebar_sidebar_item_interface_set_can_insert_before ((SidebarSidebarItemInterface*) self, g_value_get_boolean (value));
		break;
		case SIDEBAR_BOOKMARK_ROW_CAN_INSERT_AFTER_PROPERTY:
		sidebar_sidebar_item_interface_set_can_insert_after ((SidebarSidebarItemInterface*) self, g_value_get_boolean (value));
		break;
		case SIDEBAR_BOOKMARK_ROW_MENU_MODEL_PROPERTY:
		sidebar_sidebar_item_interface_set_menu_model ((SidebarSidebarItemInterface*) self, g_value_get_object (value));
		break;
		case SIDEBAR_BOOKMARK_ROW_ACTION_GROUP_PROPERTY:
		sidebar_sidebar_item_interface_set_action_group ((SidebarSidebarItemInterface*) self, g_value_get_object (value));
		break;
		case SIDEBAR_BOOKMARK_ROW_ACTION_GROUP_NAMESPACE_PROPERTY:
		sidebar_sidebar_item_interface_set_action_group_namespace ((SidebarSidebarItemInterface*) self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static void
_vala_clear_GMutex (GMutex * mutex)
{
	GMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GMutex))) {
		g_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GMutex));
	}
}

static void
_vala_clear_GRecMutex (GRecMutex * mutex)
{
	GRecMutex zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRecMutex))) {
		g_rec_mutex_clear (mutex);
		memset (mutex, 0, sizeof (GRecMutex));
	}
}

static void
_vala_clear_GRWLock (GRWLock * mutex)
{
	GRWLock zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GRWLock))) {
		g_rw_lock_clear (mutex);
		memset (mutex, 0, sizeof (GRWLock));
	}
}

static void
_vala_clear_GCond (GCond * mutex)
{
	GCond zero_mutex = { 0 };
	if (memcmp (mutex, &zero_mutex, sizeof (GCond))) {
		g_cond_clear (mutex);
		memset (mutex, 0, sizeof (GCond));
	}
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

