/* SidebarWindow.c generated by valac 0.56.18, the Vala compiler
 * generated from SidebarWindow.vala, do not modify */

/*
 * SPDX-License-Identifier: GPL-2.0+
 * SPDX-FileCopyrightText: 2020-2023 elementary, Inc. (https://elementary.io)
 *
 * Authors : Jeremy Wootten <jeremywootten@gmail.com>
 */

#include <gtk/gtk.h>
#include "pantheon-files-core.h"
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <granite.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define SIDEBAR_TYPE_SIDEBAR_WINDOW (sidebar_sidebar_window_get_type ())
#define SIDEBAR_SIDEBAR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_SIDEBAR_WINDOW, SidebarSidebarWindow))
#define SIDEBAR_SIDEBAR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_SIDEBAR_WINDOW, SidebarSidebarWindowClass))
#define SIDEBAR_IS_SIDEBAR_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_SIDEBAR_WINDOW))
#define SIDEBAR_IS_SIDEBAR_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_SIDEBAR_WINDOW))
#define SIDEBAR_SIDEBAR_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_SIDEBAR_WINDOW, SidebarSidebarWindowClass))

typedef struct _SidebarSidebarWindow SidebarSidebarWindow;
typedef struct _SidebarSidebarWindowClass SidebarSidebarWindowClass;
typedef struct _SidebarSidebarWindowPrivate SidebarSidebarWindowPrivate;

#define SIDEBAR_TYPE_BOOKMARK_LIST_BOX (sidebar_bookmark_list_box_get_type ())
#define SIDEBAR_BOOKMARK_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_BOOKMARK_LIST_BOX, SidebarBookmarkListBox))
#define SIDEBAR_BOOKMARK_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_BOOKMARK_LIST_BOX, SidebarBookmarkListBoxClass))
#define SIDEBAR_IS_BOOKMARK_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_BOOKMARK_LIST_BOX))
#define SIDEBAR_IS_BOOKMARK_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_BOOKMARK_LIST_BOX))
#define SIDEBAR_BOOKMARK_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_BOOKMARK_LIST_BOX, SidebarBookmarkListBoxClass))

typedef struct _SidebarBookmarkListBox SidebarBookmarkListBox;
typedef struct _SidebarBookmarkListBoxClass SidebarBookmarkListBoxClass;

#define SIDEBAR_TYPE_DEVICE_LIST_BOX (sidebar_device_list_box_get_type ())
#define SIDEBAR_DEVICE_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_DEVICE_LIST_BOX, SidebarDeviceListBox))
#define SIDEBAR_DEVICE_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_DEVICE_LIST_BOX, SidebarDeviceListBoxClass))
#define SIDEBAR_IS_DEVICE_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_DEVICE_LIST_BOX))
#define SIDEBAR_IS_DEVICE_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_DEVICE_LIST_BOX))
#define SIDEBAR_DEVICE_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_DEVICE_LIST_BOX, SidebarDeviceListBoxClass))

typedef struct _SidebarDeviceListBox SidebarDeviceListBox;
typedef struct _SidebarDeviceListBoxClass SidebarDeviceListBoxClass;

#define SIDEBAR_TYPE_NETWORK_LIST_BOX (sidebar_network_list_box_get_type ())
#define SIDEBAR_NETWORK_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_TYPE_NETWORK_LIST_BOX, SidebarNetworkListBox))
#define SIDEBAR_NETWORK_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_TYPE_NETWORK_LIST_BOX, SidebarNetworkListBoxClass))
#define SIDEBAR_IS_NETWORK_LIST_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_TYPE_NETWORK_LIST_BOX))
#define SIDEBAR_IS_NETWORK_LIST_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_TYPE_NETWORK_LIST_BOX))
#define SIDEBAR_NETWORK_LIST_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_TYPE_NETWORK_LIST_BOX, SidebarNetworkListBoxClass))

typedef struct _SidebarNetworkListBox SidebarNetworkListBox;
typedef struct _SidebarNetworkListBoxClass SidebarNetworkListBoxClass;
enum  {
	SIDEBAR_SIDEBAR_WINDOW_0_PROPERTY,
	SIDEBAR_SIDEBAR_WINDOW_HAS_FOCUS_PROPERTY,
	SIDEBAR_SIDEBAR_WINDOW_NUM_PROPERTIES
};
static GParamSpec* sidebar_sidebar_window_properties[SIDEBAR_SIDEBAR_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block65Data Block65Data;

#define SIDEBAR_SIDEBAR_WINDOW_TYPE_SIDEBAR_EXPANDER (sidebar_sidebar_window_sidebar_expander_get_type ())
#define SIDEBAR_SIDEBAR_WINDOW_SIDEBAR_EXPANDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), SIDEBAR_SIDEBAR_WINDOW_TYPE_SIDEBAR_EXPANDER, SidebarSidebarWindowSidebarExpander))
#define SIDEBAR_SIDEBAR_WINDOW_SIDEBAR_EXPANDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), SIDEBAR_SIDEBAR_WINDOW_TYPE_SIDEBAR_EXPANDER, SidebarSidebarWindowSidebarExpanderClass))
#define SIDEBAR_SIDEBAR_WINDOW_IS_SIDEBAR_EXPANDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), SIDEBAR_SIDEBAR_WINDOW_TYPE_SIDEBAR_EXPANDER))
#define SIDEBAR_SIDEBAR_WINDOW_IS_SIDEBAR_EXPANDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), SIDEBAR_SIDEBAR_WINDOW_TYPE_SIDEBAR_EXPANDER))
#define SIDEBAR_SIDEBAR_WINDOW_SIDEBAR_EXPANDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), SIDEBAR_SIDEBAR_WINDOW_TYPE_SIDEBAR_EXPANDER, SidebarSidebarWindowSidebarExpanderClass))

typedef struct _SidebarSidebarWindowSidebarExpander SidebarSidebarWindowSidebarExpander;
typedef struct _SidebarSidebarWindowSidebarExpanderClass SidebarSidebarWindowSidebarExpanderClass;
typedef struct _SidebarSidebarWindowSidebarExpanderPrivate SidebarSidebarWindowSidebarExpanderPrivate;
enum  {
	SIDEBAR_SIDEBAR_WINDOW_SIDEBAR_EXPANDER_0_PROPERTY,
	SIDEBAR_SIDEBAR_WINDOW_SIDEBAR_EXPANDER_EXPANDER_LABEL_PROPERTY,
	SIDEBAR_SIDEBAR_WINDOW_SIDEBAR_EXPANDER_NUM_PROPERTIES
};
static GParamSpec* sidebar_sidebar_window_sidebar_expander_properties[SIDEBAR_SIDEBAR_WINDOW_SIDEBAR_EXPANDER_NUM_PROPERTIES];
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _SidebarSidebarWindow {
	GtkBox parent_instance;
	SidebarSidebarWindowPrivate * priv;
	gboolean ejecting_or_unmounting;
};

struct _SidebarSidebarWindowClass {
	GtkBoxClass parent_class;
};

struct _SidebarSidebarWindowPrivate {
	GtkScrolledWindow* scrolled_window;
	SidebarBookmarkListBox* bookmark_listbox;
	SidebarDeviceListBox* device_listbox;
	SidebarNetworkListBox* network_listbox;
	gchar* selected_uri;
	gboolean loading;
	guint sync_timeout_id;
	guint reload_timeout_id;
};

struct _Block65Data {
	int _ref_count_;
	SidebarSidebarWindow* self;
	gchar* location;
};

struct _SidebarSidebarWindowSidebarExpander {
	GtkToggleButton parent_instance;
	SidebarSidebarWindowSidebarExpanderPrivate * priv;
};

struct _SidebarSidebarWindowSidebarExpanderClass {
	GtkToggleButtonClass parent_class;
};

struct _SidebarSidebarWindowSidebarExpanderPrivate {
	gchar* _expander_label;
};

static gint SidebarSidebarWindow_private_offset;
static gpointer sidebar_sidebar_window_parent_class = NULL;
static gint SidebarSidebarWindowSidebarExpander_private_offset;
static gpointer sidebar_sidebar_window_sidebar_expander_parent_class = NULL;
static GtkCssProvider* sidebar_sidebar_window_sidebar_expander_expander_provider;
static GtkCssProvider* sidebar_sidebar_window_sidebar_expander_expander_provider = NULL;
VALA_EXTERN GSettings* files_app_settings;
static FilesSidebarInterfaceIface * sidebar_sidebar_window_files_sidebar_interface_parent_iface = NULL;

VALA_EXTERN GType sidebar_sidebar_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarSidebarWindow, g_object_unref)
VALA_EXTERN GType sidebar_bookmark_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarBookmarkListBox, g_object_unref)
VALA_EXTERN GType sidebar_device_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarDeviceListBox, g_object_unref)
VALA_EXTERN GType sidebar_network_list_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarNetworkListBox, g_object_unref)
static void sidebar_sidebar_window_refresh (SidebarSidebarWindow* self,
                                     gboolean bookmarks,
                                     gboolean devices,
                                     gboolean network);
static guint32 sidebar_sidebar_window_real_add_plugin_item (FilesSidebarInterface* base,
                                                     FilesSidebarPluginItem* plugin_item,
                                                     FilesPlaceType category);
static gboolean sidebar_sidebar_window_real_update_plugin_item (FilesSidebarInterface* base,
                                                         FilesSidebarPluginItem* item,
                                                         guint32 item_id);
static void sidebar_sidebar_window_real_sync_uri (FilesSidebarInterface* base,
                                           const gchar* location);
static Block65Data* block65_data_ref (Block65Data* _data65_);
static void block65_data_unref (void * _userdata_);
static gboolean __lambda187_ (Block65Data* _data65_);
static gboolean ___lambda187__gsource_func (gpointer self);
static void sidebar_sidebar_window_real_reload (FilesSidebarInterface* base);
static gboolean __lambda188_ (SidebarSidebarWindow* self);
static gboolean ___lambda188__gsource_func (gpointer self);
static void sidebar_sidebar_window_real_add_favorite_uri (FilesSidebarInterface* base,
                                                   const gchar* uri,
                                                   const gchar* custom_name);
static gboolean sidebar_sidebar_window_real_has_favorite_uri (FilesSidebarInterface* base,
                                                       const gchar* uri);
static void sidebar_sidebar_window_real_on_free_space_change (FilesSidebarInterface* base);
static void sidebar_sidebar_window_real_focus (FilesSidebarInterface* base);
VALA_EXTERN SidebarSidebarWindow* sidebar_sidebar_window_new (void);
VALA_EXTERN SidebarSidebarWindow* sidebar_sidebar_window_construct (GType object_type);
VALA_EXTERN gboolean sidebar_sidebar_window_get_has_focus (SidebarSidebarWindow* self);
static GType sidebar_sidebar_window_sidebar_expander_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SidebarSidebarWindowSidebarExpander, g_object_unref)
static SidebarSidebarWindowSidebarExpander* sidebar_sidebar_window_sidebar_expander_new (const gchar* label);
static SidebarSidebarWindowSidebarExpander* sidebar_sidebar_window_sidebar_expander_construct (GType object_type,
                                                                                        const gchar* label);
static const gchar* sidebar_sidebar_window_sidebar_expander_get_expander_label (SidebarSidebarWindowSidebarExpander* self);
static void sidebar_sidebar_window_sidebar_expander_set_expander_label (SidebarSidebarWindowSidebarExpander* self,
                                                                 const gchar* value);
static GObject * sidebar_sidebar_window_sidebar_expander_constructor (GType type,
                                                               guint n_construct_properties,
                                                               GObjectConstructParam * construct_properties);
static void sidebar_sidebar_window_sidebar_expander_finalize (GObject * obj);
static GType sidebar_sidebar_window_sidebar_expander_get_type_once (void);
static void _vala_sidebar_sidebar_window_sidebar_expander_get_property (GObject * object,
                                                                 guint property_id,
                                                                 GValue * value,
                                                                 GParamSpec * pspec);
static void _vala_sidebar_sidebar_window_sidebar_expander_set_property (GObject * object,
                                                                 guint property_id,
                                                                 const GValue * value,
                                                                 GParamSpec * pspec);
static GObject * sidebar_sidebar_window_constructor (GType type,
                                              guint n_construct_properties,
                                              GObjectConstructParam * construct_properties);
VALA_EXTERN SidebarBookmarkListBox* sidebar_bookmark_list_box_new (FilesSidebarInterface* sidebar);
VALA_EXTERN SidebarBookmarkListBox* sidebar_bookmark_list_box_construct (GType object_type,
                                                             FilesSidebarInterface* sidebar);
VALA_EXTERN SidebarDeviceListBox* sidebar_device_list_box_new (FilesSidebarInterface* sidebar);
VALA_EXTERN SidebarDeviceListBox* sidebar_device_list_box_construct (GType object_type,
                                                         FilesSidebarInterface* sidebar);
VALA_EXTERN SidebarNetworkListBox* sidebar_network_list_box_new (FilesSidebarInterface* sidebar);
VALA_EXTERN SidebarNetworkListBox* sidebar_network_list_box_construct (GType object_type,
                                                           FilesSidebarInterface* sidebar);
VALA_EXTERN gboolean files_is_admin (void);
static GVariant* _variant_new21 (const gchar* value);
static void sidebar_sidebar_window_finalize (GObject * obj);
static GType sidebar_sidebar_window_get_type_once (void);
static void _vala_sidebar_sidebar_window_get_property (GObject * object,
                                                guint property_id,
                                                GValue * value,
                                                GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
sidebar_sidebar_window_get_instance_private (SidebarSidebarWindow* self)
{
	return G_STRUCT_MEMBER_P (self, SidebarSidebarWindow_private_offset);
}

static void
sidebar_sidebar_window_refresh (SidebarSidebarWindow* self,
                                gboolean bookmarks,
                                gboolean devices,
                                gboolean network)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	if (self->priv->loading) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = self->priv->reload_timeout_id > ((guint) 0);
	}
	if (_tmp0_) {
		return;
	}
	self->priv->loading = TRUE;
	if (bookmarks) {
		SidebarBookmarkListBox* _tmp1_;
		_tmp1_ = self->priv->bookmark_listbox;
		sidebar_sidebar_list_interface_refresh ((SidebarSidebarListInterface*) _tmp1_);
	}
	if (devices) {
		SidebarDeviceListBox* _tmp2_;
		_tmp2_ = self->priv->device_listbox;
		sidebar_sidebar_list_interface_refresh ((SidebarSidebarListInterface*) _tmp2_);
	}
	if (network) {
		SidebarNetworkListBox* _tmp3_;
		_tmp3_ = self->priv->network_listbox;
		sidebar_sidebar_list_interface_refresh ((SidebarSidebarListInterface*) _tmp3_);
	}
	self->priv->loading = FALSE;
}

static guint32
sidebar_sidebar_window_real_add_plugin_item (FilesSidebarInterface* base,
                                             FilesSidebarPluginItem* plugin_item,
                                             FilesPlaceType category)
{
	SidebarSidebarWindow * self;
	guint32 id = 0U;
	guint32 result;
	self = (SidebarSidebarWindow*) base;
	g_return_val_if_fail (plugin_item != NULL, 0U);
	id = (guint32) 0;
	switch (category) {
		case FILES_PLACE_TYPE_BOOKMARKS_CATEGORY:
		{
			SidebarBookmarkListBox* _tmp0_;
			_tmp0_ = self->priv->bookmark_listbox;
			id = sidebar_sidebar_list_interface_add_plugin_item ((SidebarSidebarListInterface*) _tmp0_, plugin_item);
			break;
		}
		case FILES_PLACE_TYPE_STORAGE_CATEGORY:
		{
			SidebarDeviceListBox* _tmp1_;
			_tmp1_ = self->priv->device_listbox;
			id = sidebar_sidebar_list_interface_add_plugin_item ((SidebarSidebarListInterface*) _tmp1_, plugin_item);
			break;
		}
		case FILES_PLACE_TYPE_NETWORK_CATEGORY:
		{
			SidebarNetworkListBox* _tmp2_;
			_tmp2_ = self->priv->network_listbox;
			id = sidebar_sidebar_list_interface_add_plugin_item ((SidebarSidebarListInterface*) _tmp2_, plugin_item);
			break;
		}
		default:
		{
			break;
		}
	}
	result = id;
	return result;
}

static gboolean
sidebar_sidebar_window_real_update_plugin_item (FilesSidebarInterface* base,
                                                FilesSidebarPluginItem* item,
                                                guint32 item_id)
{
	SidebarSidebarWindow * self;
	SidebarSidebarItemInterface* row = NULL;
	SidebarSidebarItemInterface* _tmp0_;
	SidebarSidebarItemInterface* _tmp1_;
	SidebarSidebarItemInterface* _tmp2_;
	gboolean result;
	self = (SidebarSidebarWindow*) base;
	g_return_val_if_fail (item != NULL, FALSE);
	if (item_id == ((guint32) 0)) {
		result = FALSE;
		return result;
	}
	_tmp0_ = sidebar_sidebar_item_interface_get_item (item_id);
	row = _tmp0_;
	_tmp1_ = row;
	if (_tmp1_ == NULL) {
		result = FALSE;
		_g_object_unref0 (row);
		return result;
	}
	_tmp2_ = row;
	sidebar_sidebar_item_interface_update_plugin_data (_tmp2_, item);
	result = TRUE;
	_g_object_unref0 (row);
	return result;
}

static Block65Data*
block65_data_ref (Block65Data* _data65_)
{
	g_atomic_int_inc (&_data65_->_ref_count_);
	return _data65_;
}

static void
block65_data_unref (void * _userdata_)
{
	Block65Data* _data65_;
	_data65_ = (Block65Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data65_->_ref_count_)) {
		SidebarSidebarWindow* self;
		self = _data65_->self;
		_g_free0 (_data65_->location);
		_g_object_unref0 (self);
		g_slice_free (Block65Data, _data65_);
	}
}

static gboolean
__lambda187_ (Block65Data* _data65_)
{
	SidebarSidebarWindow* self;
	SidebarBookmarkListBox* _tmp0_;
	SidebarDeviceListBox* _tmp1_;
	SidebarNetworkListBox* _tmp2_;
	gboolean result;
	self = _data65_->self;
	if (self->priv->loading) {
		result = G_SOURCE_CONTINUE;
		return result;
	}
	self->priv->sync_timeout_id = (guint) 0;
	_tmp0_ = self->priv->bookmark_listbox;
	sidebar_sidebar_list_interface_select_uri ((SidebarSidebarListInterface*) _tmp0_, _data65_->location);
	_tmp1_ = self->priv->device_listbox;
	sidebar_sidebar_list_interface_select_uri ((SidebarSidebarListInterface*) _tmp1_, _data65_->location);
	_tmp2_ = self->priv->network_listbox;
	sidebar_sidebar_list_interface_select_uri ((SidebarSidebarListInterface*) _tmp2_, _data65_->location);
	result = G_SOURCE_REMOVE;
	return result;
}

static gboolean
___lambda187__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda187_ (self);
	return result;
}

static void
sidebar_sidebar_window_real_sync_uri (FilesSidebarInterface* base,
                                      const gchar* location)
{
	SidebarSidebarWindow * self;
	Block65Data* _data65_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	self = (SidebarSidebarWindow*) base;
	g_return_if_fail (location != NULL);
	_data65_ = g_slice_new0 (Block65Data);
	_data65_->_ref_count_ = 1;
	_data65_->self = g_object_ref (self);
	_tmp0_ = g_strdup (location);
	_g_free0 (_data65_->location);
	_data65_->location = _tmp0_;
	if (self->priv->sync_timeout_id > ((guint) 0)) {
		g_source_remove (self->priv->sync_timeout_id);
	}
	_tmp1_ = g_strdup (_data65_->location);
	_g_free0 (self->priv->selected_uri);
	self->priv->selected_uri = _tmp1_;
	self->priv->sync_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda187__gsource_func, block65_data_ref (_data65_), block65_data_unref);
	block65_data_unref (_data65_);
	_data65_ = NULL;
}

static gboolean
__lambda188_ (SidebarSidebarWindow* self)
{
	FilesPluginManager* _tmp0_;
	const gchar* _tmp1_;
	gboolean result;
	self->priv->reload_timeout_id = (guint) 0;
	sidebar_sidebar_window_refresh (self, TRUE, TRUE, TRUE);
	_tmp0_ = plugins;
	files_plugin_manager_update_sidebar (_tmp0_, (GtkWidget*) self);
	_tmp1_ = self->priv->selected_uri;
	files_sidebar_interface_sync_uri ((FilesSidebarInterface*) self, _tmp1_);
	result = FALSE;
	return result;
}

static gboolean
___lambda188__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda188_ ((SidebarSidebarWindow*) self);
	return result;
}

static void
sidebar_sidebar_window_real_reload (FilesSidebarInterface* base)
{
	SidebarSidebarWindow * self;
	self = (SidebarSidebarWindow*) base;
	if (self->priv->reload_timeout_id > ((guint) 0)) {
		return;
	}
	self->priv->reload_timeout_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 300, ___lambda188__gsource_func, g_object_ref (self), g_object_unref);
}

static void
sidebar_sidebar_window_real_add_favorite_uri (FilesSidebarInterface* base,
                                              const gchar* uri,
                                              const gchar* custom_name)
{
	SidebarSidebarWindow * self;
	SidebarBookmarkListBox* _tmp0_;
	self = (SidebarSidebarWindow*) base;
	g_return_if_fail (uri != NULL);
	g_return_if_fail (custom_name != NULL);
	_tmp0_ = self->priv->bookmark_listbox;
	sidebar_sidebar_list_interface_add_favorite ((SidebarSidebarListInterface*) _tmp0_, uri, custom_name, 0);
}

static gboolean
sidebar_sidebar_window_real_has_favorite_uri (FilesSidebarInterface* base,
                                              const gchar* uri)
{
	SidebarSidebarWindow * self;
	SidebarBookmarkListBox* _tmp0_;
	gboolean result;
	self = (SidebarSidebarWindow*) base;
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = self->priv->bookmark_listbox;
	result = sidebar_sidebar_list_interface_has_uri ((SidebarSidebarListInterface*) _tmp0_, uri, NULL);
	return result;
}

static void
sidebar_sidebar_window_real_on_free_space_change (FilesSidebarInterface* base)
{
	SidebarSidebarWindow * self;
	SidebarDeviceListBox* _tmp0_;
	self = (SidebarSidebarWindow*) base;
	_tmp0_ = self->priv->device_listbox;
	sidebar_sidebar_list_interface_refresh_info ((SidebarSidebarListInterface*) _tmp0_);
}

static void
sidebar_sidebar_window_real_focus (FilesSidebarInterface* base)
{
	SidebarSidebarWindow * self;
	SidebarBookmarkListBox* _tmp0_;
	self = (SidebarSidebarWindow*) base;
	_tmp0_ = self->priv->bookmark_listbox;
	sidebar_sidebar_list_interface_focus ((SidebarSidebarListInterface*) _tmp0_);
}

SidebarSidebarWindow*
sidebar_sidebar_window_construct (GType object_type)
{
	SidebarSidebarWindow * self = NULL;
	self = (SidebarSidebarWindow*) g_object_new (object_type, NULL);
	return self;
}

SidebarSidebarWindow*
sidebar_sidebar_window_new (void)
{
	return sidebar_sidebar_window_construct (SIDEBAR_TYPE_SIDEBAR_WINDOW);
}

gboolean
sidebar_sidebar_window_get_has_focus (SidebarSidebarWindow* self)
{
	gboolean result;
	SidebarBookmarkListBox* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->bookmark_listbox;
	g_object_get ((GtkWidget*) _tmp0_, "has-focus", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

static inline gpointer
sidebar_sidebar_window_sidebar_expander_get_instance_private (SidebarSidebarWindowSidebarExpander* self)
{
	return G_STRUCT_MEMBER_P (self, SidebarSidebarWindowSidebarExpander_private_offset);
}

static SidebarSidebarWindowSidebarExpander*
sidebar_sidebar_window_sidebar_expander_construct (GType object_type,
                                                   const gchar* label)
{
	SidebarSidebarWindowSidebarExpander * self = NULL;
	g_return_val_if_fail (label != NULL, NULL);
	self = (SidebarSidebarWindowSidebarExpander*) g_object_new (object_type, "expander-label", label, NULL);
	return self;
}

static SidebarSidebarWindowSidebarExpander*
sidebar_sidebar_window_sidebar_expander_new (const gchar* label)
{
	return sidebar_sidebar_window_sidebar_expander_construct (SIDEBAR_SIDEBAR_WINDOW_TYPE_SIDEBAR_EXPANDER, label);
}

static const gchar*
sidebar_sidebar_window_sidebar_expander_get_expander_label (SidebarSidebarWindowSidebarExpander* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_expander_label;
	result = _tmp0_;
	return result;
}

static void
sidebar_sidebar_window_sidebar_expander_set_expander_label (SidebarSidebarWindowSidebarExpander* self,
                                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = sidebar_sidebar_window_sidebar_expander_get_expander_label (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_expander_label);
		self->priv->_expander_label = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, sidebar_sidebar_window_sidebar_expander_properties[SIDEBAR_SIDEBAR_WINDOW_SIDEBAR_EXPANDER_EXPANDER_LABEL_PROPERTY]);
	}
}

static GObject *
sidebar_sidebar_window_sidebar_expander_constructor (GType type,
                                                     guint n_construct_properties,
                                                     GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SidebarSidebarWindowSidebarExpander * self;
	GtkLabel* title = NULL;
	const gchar* _tmp0_;
	GtkLabel* _tmp1_ = NULL;
	GtkSpinner* arrow = NULL;
	GtkSpinner* _tmp2_;
	GtkStyleContext* arrow_style_context = NULL;
	GtkSpinner* _tmp3_;
	GtkStyleContext* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkStyleContext* _tmp6_;
	GtkCssProvider* _tmp7_;
	GtkBox* box = NULL;
	GtkBox* _tmp8_;
	GtkBox* _tmp9_;
	GtkLabel* _tmp10_;
	GtkBox* _tmp11_;
	GtkSpinner* _tmp12_;
	GtkBox* _tmp13_;
	GtkStyleContext* style_context = NULL;
	GtkStyleContext* _tmp14_;
	GtkStyleContext* _tmp15_;
	GtkStyleContext* _tmp16_;
	GtkStyleContext* _tmp17_;
	GtkCssProvider* _tmp18_;
	parent_class = G_OBJECT_CLASS (sidebar_sidebar_window_sidebar_expander_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_SIDEBAR_WINDOW_TYPE_SIDEBAR_EXPANDER, SidebarSidebarWindowSidebarExpander);
	_tmp0_ = self->priv->_expander_label;
	_tmp1_ = (GtkLabel*) gtk_label_new (_tmp0_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp1_, TRUE);
	gtk_label_set_xalign (_tmp1_, (gfloat) 0);
	g_object_ref_sink (_tmp1_);
	title = _tmp1_;
	_tmp2_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp2_);
	arrow = _tmp2_;
	_tmp3_ = arrow;
	_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) _tmp3_);
	arrow_style_context = _tmp4_;
	_tmp5_ = arrow_style_context;
	gtk_style_context_add_class (_tmp5_, GTK_STYLE_CLASS_ARROW);
	_tmp6_ = arrow_style_context;
	_tmp7_ = sidebar_sidebar_window_sidebar_expander_expander_provider;
	gtk_style_context_add_provider (_tmp6_, (GtkStyleProvider*) _tmp7_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_tmp8_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp8_);
	box = _tmp8_;
	_tmp9_ = box;
	_tmp10_ = title;
	gtk_container_add ((GtkContainer*) _tmp9_, (GtkWidget*) _tmp10_);
	_tmp11_ = box;
	_tmp12_ = arrow;
	gtk_container_add ((GtkContainer*) _tmp11_, (GtkWidget*) _tmp12_);
	_tmp13_ = box;
	g_object_set ((GtkContainer*) self, "child", (GtkWidget*) _tmp13_, NULL);
	_tmp14_ = gtk_widget_get_style_context ((GtkWidget*) self);
	style_context = _tmp14_;
	_tmp15_ = style_context;
	gtk_style_context_add_class (_tmp15_, GRANITE_STYLE_CLASS_H4_LABEL);
	_tmp16_ = style_context;
	gtk_style_context_add_class (_tmp16_, GTK_STYLE_CLASS_EXPANDER);
	_tmp17_ = style_context;
	_tmp18_ = sidebar_sidebar_window_sidebar_expander_expander_provider;
	gtk_style_context_add_provider (_tmp17_, (GtkStyleProvider*) _tmp18_, (guint) GTK_STYLE_PROVIDER_PRIORITY_APPLICATION);
	_g_object_unref0 (box);
	_g_object_unref0 (arrow);
	_g_object_unref0 (title);
	return obj;
}

static void
sidebar_sidebar_window_sidebar_expander_class_init (SidebarSidebarWindowSidebarExpanderClass * klass,
                                                    gpointer klass_data)
{
	GtkCssProvider* _tmp0_;
	GtkCssProvider* _tmp1_;
	sidebar_sidebar_window_sidebar_expander_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SidebarSidebarWindowSidebarExpander_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sidebar_sidebar_window_sidebar_expander_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_sidebar_sidebar_window_sidebar_expander_set_property;
	G_OBJECT_CLASS (klass)->constructor = sidebar_sidebar_window_sidebar_expander_constructor;
	G_OBJECT_CLASS (klass)->finalize = sidebar_sidebar_window_sidebar_expander_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_SIDEBAR_WINDOW_SIDEBAR_EXPANDER_EXPANDER_LABEL_PROPERTY, sidebar_sidebar_window_sidebar_expander_properties[SIDEBAR_SIDEBAR_WINDOW_SIDEBAR_EXPANDER_EXPANDER_LABEL_PROPERTY] = g_param_spec_string ("expander-label", "expander-label", "expander-label", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT_ONLY));
	_tmp0_ = gtk_css_provider_new ();
	_g_object_unref0 (sidebar_sidebar_window_sidebar_expander_expander_provider);
	sidebar_sidebar_window_sidebar_expander_expander_provider = _tmp0_;
	_tmp1_ = sidebar_sidebar_window_sidebar_expander_expander_provider;
	gtk_css_provider_load_from_resource (_tmp1_, "/io/elementary/files/SidebarExpander.css");
}

static void
sidebar_sidebar_window_sidebar_expander_instance_init (SidebarSidebarWindowSidebarExpander * self,
                                                       gpointer klass)
{
	self->priv = sidebar_sidebar_window_sidebar_expander_get_instance_private (self);
}

static void
sidebar_sidebar_window_sidebar_expander_finalize (GObject * obj)
{
	SidebarSidebarWindowSidebarExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_SIDEBAR_WINDOW_TYPE_SIDEBAR_EXPANDER, SidebarSidebarWindowSidebarExpander);
	_g_free0 (self->priv->_expander_label);
	G_OBJECT_CLASS (sidebar_sidebar_window_sidebar_expander_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
sidebar_sidebar_window_sidebar_expander_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarSidebarWindowSidebarExpanderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_sidebar_window_sidebar_expander_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarSidebarWindowSidebarExpander), 0, (GInstanceInitFunc) sidebar_sidebar_window_sidebar_expander_instance_init, NULL };
	GType sidebar_sidebar_window_sidebar_expander_type_id;
	sidebar_sidebar_window_sidebar_expander_type_id = g_type_register_static (gtk_toggle_button_get_type (), "SidebarSidebarWindowSidebarExpander", &g_define_type_info, 0);
	SidebarSidebarWindowSidebarExpander_private_offset = g_type_add_instance_private (sidebar_sidebar_window_sidebar_expander_type_id, sizeof (SidebarSidebarWindowSidebarExpanderPrivate));
	return sidebar_sidebar_window_sidebar_expander_type_id;
}

static GType
sidebar_sidebar_window_sidebar_expander_get_type (void)
{
	static volatile gsize sidebar_sidebar_window_sidebar_expander_type_id__once = 0;
	if (g_once_init_enter (&sidebar_sidebar_window_sidebar_expander_type_id__once)) {
		GType sidebar_sidebar_window_sidebar_expander_type_id;
		sidebar_sidebar_window_sidebar_expander_type_id = sidebar_sidebar_window_sidebar_expander_get_type_once ();
		g_once_init_leave (&sidebar_sidebar_window_sidebar_expander_type_id__once, sidebar_sidebar_window_sidebar_expander_type_id);
	}
	return sidebar_sidebar_window_sidebar_expander_type_id__once;
}

static void
_vala_sidebar_sidebar_window_sidebar_expander_get_property (GObject * object,
                                                            guint property_id,
                                                            GValue * value,
                                                            GParamSpec * pspec)
{
	SidebarSidebarWindowSidebarExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_SIDEBAR_WINDOW_TYPE_SIDEBAR_EXPANDER, SidebarSidebarWindowSidebarExpander);
	switch (property_id) {
		case SIDEBAR_SIDEBAR_WINDOW_SIDEBAR_EXPANDER_EXPANDER_LABEL_PROPERTY:
		g_value_set_string (value, sidebar_sidebar_window_sidebar_expander_get_expander_label (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_sidebar_sidebar_window_sidebar_expander_set_property (GObject * object,
                                                            guint property_id,
                                                            const GValue * value,
                                                            GParamSpec * pspec)
{
	SidebarSidebarWindowSidebarExpander * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_SIDEBAR_WINDOW_TYPE_SIDEBAR_EXPANDER, SidebarSidebarWindowSidebarExpander);
	switch (property_id) {
		case SIDEBAR_SIDEBAR_WINDOW_SIDEBAR_EXPANDER_EXPANDER_LABEL_PROPERTY:
		sidebar_sidebar_window_sidebar_expander_set_expander_label (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static GVariant*
_variant_new21 (const gchar* value)
{
	return g_variant_ref_sink (g_variant_new_string (value));
}

static GObject *
sidebar_sidebar_window_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	SidebarSidebarWindow * self;
	SidebarBookmarkListBox* _tmp0_;
	SidebarDeviceListBox* _tmp1_;
	SidebarNetworkListBox* _tmp2_;
	SidebarSidebarWindowSidebarExpander* bookmark_expander = NULL;
	gchar* _tmp3_;
	SidebarSidebarWindowSidebarExpander* _tmp4_ = NULL;
	GtkRevealer* bookmark_revealer = NULL;
	SidebarBookmarkListBox* _tmp5_;
	GtkWidget* _tmp6_;
	GtkRevealer* _tmp7_ = NULL;
	SidebarSidebarWindowSidebarExpander* device_expander = NULL;
	gchar* _tmp8_;
	SidebarSidebarWindowSidebarExpander* _tmp9_ = NULL;
	GtkRevealer* device_revealer = NULL;
	SidebarDeviceListBox* _tmp10_;
	GtkWidget* _tmp11_;
	GtkRevealer* _tmp12_ = NULL;
	SidebarSidebarWindowSidebarExpander* network_expander = NULL;
	gchar* _tmp13_;
	SidebarSidebarWindowSidebarExpander* _tmp14_ = NULL;
	GtkRevealer* network_revealer = NULL;
	SidebarNetworkListBox* _tmp15_;
	GtkWidget* _tmp16_;
	GtkRevealer* _tmp17_ = NULL;
	GtkBox* bookmarklists_box = NULL;
	GtkBox* _tmp18_ = NULL;
	GtkBox* _tmp19_;
	SidebarSidebarWindowSidebarExpander* _tmp20_;
	GtkBox* _tmp21_;
	GtkRevealer* _tmp22_;
	GtkBox* _tmp23_;
	SidebarSidebarWindowSidebarExpander* _tmp24_;
	GtkBox* _tmp25_;
	GtkRevealer* _tmp26_;
	GtkBox* _tmp27_;
	SidebarSidebarWindowSidebarExpander* _tmp28_;
	GtkBox* _tmp29_;
	GtkRevealer* _tmp30_;
	GtkBox* _tmp31_;
	GtkWidget* _tmp32_;
	GtkScrolledWindow* _tmp33_ = NULL;
	GtkBox* connect_server_box = NULL;
	GtkBox* _tmp34_;
	GtkBox* _tmp35_;
	GtkImage* _tmp36_;
	GtkImage* _tmp37_;
	GtkBox* _tmp38_;
	GtkLabel* _tmp39_;
	GtkLabel* _tmp40_;
	GtkButton* connect_server_button = NULL;
	gchar* _tmp41_;
	GVariant* _tmp42_;
	GtkBox* _tmp43_;
	GtkWidget* _tmp44_;
	GApplication* _tmp45_;
	gchar** _tmp46_;
	gchar** _tmp47_;
	gchar** _tmp48_;
	gint _tmp48__length1;
	gchar* _tmp49_;
	GtkButton* _tmp50_ = NULL;
	GtkButton* _tmp51_;
	GtkActionBar* action_bar = NULL;
	GtkActionBar* _tmp52_;
	GtkActionBar* _tmp53_;
	GtkStyleContext* _tmp54_;
	GtkActionBar* _tmp55_;
	GtkButton* _tmp56_;
	GSettings* _tmp57_;
	GtkStyleContext* _tmp58_;
	GtkScrolledWindow* _tmp59_;
	FilesPluginManager* _tmp61_;
	GSettings* _tmp62_;
	SidebarSidebarWindowSidebarExpander* _tmp63_;
	GSettings* _tmp64_;
	SidebarSidebarWindowSidebarExpander* _tmp65_;
	GSettings* _tmp66_;
	SidebarSidebarWindowSidebarExpander* _tmp67_;
	SidebarSidebarWindowSidebarExpander* _tmp68_;
	GtkRevealer* _tmp69_;
	SidebarSidebarWindowSidebarExpander* _tmp70_;
	GtkRevealer* _tmp71_;
	SidebarSidebarWindowSidebarExpander* _tmp72_;
	GtkRevealer* _tmp73_;
	parent_class = G_OBJECT_CLASS (sidebar_sidebar_window_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_SIDEBAR_WINDOW, SidebarSidebarWindow);
	_tmp0_ = sidebar_bookmark_list_box_new ((FilesSidebarInterface*) self);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->bookmark_listbox);
	self->priv->bookmark_listbox = _tmp0_;
	_tmp1_ = sidebar_device_list_box_new ((FilesSidebarInterface*) self);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->device_listbox);
	self->priv->device_listbox = _tmp1_;
	_tmp2_ = sidebar_network_list_box_new ((FilesSidebarInterface*) self);
	g_object_ref_sink (_tmp2_);
	_g_object_unref0 (self->priv->network_listbox);
	self->priv->network_listbox = _tmp2_;
	_tmp3_ = g_strdup (_ ("Common places plus saved folders and files"));
	_tmp4_ = sidebar_sidebar_window_sidebar_expander_new (_ ("Bookmarks"));
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp4_, _tmp3_);
	_g_free0 (_tmp3_);
	g_object_ref_sink (_tmp4_);
	bookmark_expander = _tmp4_;
	_tmp5_ = self->priv->bookmark_listbox;
	_tmp6_ = _g_object_ref0 ((GtkWidget*) _tmp5_);
	_tmp7_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp7_, "child", _tmp6_, NULL);
	_g_object_unref0 (_tmp6_);
	g_object_ref_sink (_tmp7_);
	bookmark_revealer = _tmp7_;
	_tmp8_ = g_strdup (_ ("Internal and connected storage devices"));
	_tmp9_ = sidebar_sidebar_window_sidebar_expander_new (_ ("Storage"));
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp9_, _tmp8_);
	_g_free0 (_tmp8_);
	g_object_ref_sink (_tmp9_);
	device_expander = _tmp9_;
	_tmp10_ = self->priv->device_listbox;
	_tmp11_ = _g_object_ref0 ((GtkWidget*) _tmp10_);
	_tmp12_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp12_, "child", _tmp11_, NULL);
	_g_object_unref0 (_tmp11_);
	g_object_ref_sink (_tmp12_);
	device_revealer = _tmp12_;
	_tmp13_ = g_strdup (_ ("Devices and places available via a network"));
	_tmp14_ = sidebar_sidebar_window_sidebar_expander_new (_ ("Network"));
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp14_, _tmp13_);
	_g_free0 (_tmp13_);
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp14_, files_is_admin ());
	g_object_ref_sink (_tmp14_);
	network_expander = _tmp14_;
	_tmp15_ = self->priv->network_listbox;
	_tmp16_ = _g_object_ref0 ((GtkWidget*) _tmp15_);
	_tmp17_ = (GtkRevealer*) gtk_revealer_new ();
	g_object_set ((GtkContainer*) _tmp17_, "child", _tmp16_, NULL);
	_g_object_unref0 (_tmp16_);
	g_object_ref_sink (_tmp17_);
	network_revealer = _tmp17_;
	_tmp18_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
	gtk_widget_set_vexpand ((GtkWidget*) _tmp18_, TRUE);
	g_object_ref_sink (_tmp18_);
	bookmarklists_box = _tmp18_;
	_tmp19_ = bookmarklists_box;
	_tmp20_ = bookmark_expander;
	gtk_container_add ((GtkContainer*) _tmp19_, (GtkWidget*) _tmp20_);
	_tmp21_ = bookmarklists_box;
	_tmp22_ = bookmark_revealer;
	gtk_container_add ((GtkContainer*) _tmp21_, (GtkWidget*) _tmp22_);
	_tmp23_ = bookmarklists_box;
	_tmp24_ = device_expander;
	gtk_container_add ((GtkContainer*) _tmp23_, (GtkWidget*) _tmp24_);
	_tmp25_ = bookmarklists_box;
	_tmp26_ = device_revealer;
	gtk_container_add ((GtkContainer*) _tmp25_, (GtkWidget*) _tmp26_);
	_tmp27_ = bookmarklists_box;
	_tmp28_ = network_expander;
	gtk_container_add ((GtkContainer*) _tmp27_, (GtkWidget*) _tmp28_);
	_tmp29_ = bookmarklists_box;
	_tmp30_ = network_revealer;
	gtk_container_add ((GtkContainer*) _tmp29_, (GtkWidget*) _tmp30_);
	_tmp31_ = bookmarklists_box;
	_tmp32_ = _g_object_ref0 ((GtkWidget*) _tmp31_);
	_tmp33_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_set ((GtkContainer*) _tmp33_, "child", _tmp32_, NULL);
	_g_object_unref0 (_tmp32_);
	g_object_set (_tmp33_, "hscrollbar-policy", GTK_POLICY_NEVER, NULL);
	g_object_ref_sink (_tmp33_);
	_g_object_unref0 (self->priv->scrolled_window);
	self->priv->scrolled_window = _tmp33_;
	_tmp34_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 0);
	g_object_ref_sink (_tmp34_);
	connect_server_box = _tmp34_;
	_tmp35_ = connect_server_box;
	_tmp36_ = (GtkImage*) gtk_image_new_from_icon_name ("network-server-symbolic", (GtkIconSize) GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp36_);
	_tmp37_ = _tmp36_;
	gtk_container_add ((GtkContainer*) _tmp35_, (GtkWidget*) _tmp37_);
	_g_object_unref0 (_tmp37_);
	_tmp38_ = connect_server_box;
	_tmp39_ = (GtkLabel*) gtk_label_new (_ ("Connect Server…"));
	g_object_ref_sink (_tmp39_);
	_tmp40_ = _tmp39_;
	gtk_container_add ((GtkContainer*) _tmp38_, (GtkWidget*) _tmp40_);
	_g_object_unref0 (_tmp40_);
	_tmp41_ = g_strdup ("win.go-to");
	_tmp42_ = _variant_new21 ("SERVER");
	_tmp43_ = connect_server_box;
	_tmp44_ = _g_object_ref0 ((GtkWidget*) _tmp43_);
	_tmp45_ = g_application_get_default ();
	_tmp47_ = _tmp46_ = gtk_application_get_accels_for_action (G_TYPE_CHECK_INSTANCE_CAST (_tmp45_, gtk_application_get_type (), GtkApplication), "win.go-to::SERVER");
	_tmp48_ = _tmp47_;
	_tmp48__length1 = _vala_array_length (_tmp46_);
	_tmp49_ = granite_markup_accel_tooltip (_tmp48_, (gint) _vala_array_length (_tmp46_), NULL);
	_tmp50_ = (GtkButton*) gtk_button_new ();
	gtk_actionable_set_action_name ((GtkActionable*) _tmp50_, _tmp41_);
	_g_free0 (_tmp41_);
	g_object_set ((GtkActionable*) _tmp50_, "action-target", _tmp42_, NULL);
	_g_variant_unref0 (_tmp42_);
	g_object_set ((GtkContainer*) _tmp50_, "child", _tmp44_, NULL);
	_g_object_unref0 (_tmp44_);
	gtk_widget_set_hexpand ((GtkWidget*) _tmp50_, TRUE);
	gtk_widget_set_tooltip_markup ((GtkWidget*) _tmp50_, _tmp49_);
	_g_free0 (_tmp49_);
	g_object_ref_sink (_tmp50_);
	_tmp51_ = _tmp50_;
	_tmp48_ = (_vala_array_free (_tmp48_, _tmp48__length1, (GDestroyNotify) g_free), NULL);
	connect_server_button = _tmp51_;
	_tmp52_ = (GtkActionBar*) gtk_action_bar_new ();
	g_object_ref_sink (_tmp52_);
	action_bar = _tmp52_;
	_tmp53_ = action_bar;
	_tmp54_ = gtk_widget_get_style_context ((GtkWidget*) _tmp53_);
	gtk_style_context_add_class (_tmp54_, GTK_STYLE_CLASS_FLAT);
	_tmp55_ = action_bar;
	_tmp56_ = connect_server_button;
	gtk_container_add ((GtkContainer*) _tmp55_, (GtkWidget*) _tmp56_);
	gtk_orientable_set_orientation ((GtkOrientable*) self, GTK_ORIENTATION_VERTICAL);
	_tmp57_ = files_app_settings;
	g_object_set ((GtkWidget*) self, "width-request", g_settings_get_int (_tmp57_, "minimum-sidebar-width"), NULL);
	_tmp58_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp58_, GTK_STYLE_CLASS_SIDEBAR);
	_tmp59_ = self->priv->scrolled_window;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp59_);
	if (!files_is_admin ()) {
		GtkActionBar* _tmp60_;
		_tmp60_ = action_bar;
		gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp60_);
	}
	_tmp61_ = plugins;
	files_plugin_manager_sidebar_loaded (_tmp61_, (GtkWidget*) self);
	files_sidebar_interface_reload ((FilesSidebarInterface*) self);
	gtk_widget_show_all ((GtkWidget*) self);
	_tmp62_ = files_app_settings;
	_tmp63_ = bookmark_expander;
	g_settings_bind (_tmp62_, "sidebar-cat-personal-expander", (GObject*) _tmp63_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp64_ = files_app_settings;
	_tmp65_ = device_expander;
	g_settings_bind (_tmp64_, "sidebar-cat-devices-expander", (GObject*) _tmp65_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp66_ = files_app_settings;
	_tmp67_ = network_expander;
	g_settings_bind (_tmp66_, "sidebar-cat-network-expander", (GObject*) _tmp67_, "active", G_SETTINGS_BIND_DEFAULT);
	_tmp68_ = bookmark_expander;
	_tmp69_ = bookmark_revealer;
	g_object_bind_property_with_closures ((GObject*) _tmp68_, "active", (GObject*) _tmp69_, "reveal-child", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp70_ = device_expander;
	_tmp71_ = device_revealer;
	g_object_bind_property_with_closures ((GObject*) _tmp70_, "active", (GObject*) _tmp71_, "reveal-child", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_tmp72_ = network_expander;
	_tmp73_ = network_revealer;
	g_object_bind_property_with_closures ((GObject*) _tmp72_, "active", (GObject*) _tmp73_, "reveal-child", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (action_bar);
	_g_object_unref0 (connect_server_button);
	_g_object_unref0 (connect_server_box);
	_g_object_unref0 (bookmarklists_box);
	_g_object_unref0 (network_revealer);
	_g_object_unref0 (network_expander);
	_g_object_unref0 (device_revealer);
	_g_object_unref0 (device_expander);
	_g_object_unref0 (bookmark_revealer);
	_g_object_unref0 (bookmark_expander);
	return obj;
}

static void
sidebar_sidebar_window_class_init (SidebarSidebarWindowClass * klass,
                                   gpointer klass_data)
{
	sidebar_sidebar_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &SidebarSidebarWindow_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_sidebar_sidebar_window_get_property;
	G_OBJECT_CLASS (klass)->constructor = sidebar_sidebar_window_constructor;
	G_OBJECT_CLASS (klass)->finalize = sidebar_sidebar_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), SIDEBAR_SIDEBAR_WINDOW_HAS_FOCUS_PROPERTY, sidebar_sidebar_window_properties[SIDEBAR_SIDEBAR_WINDOW_HAS_FOCUS_PROPERTY] = g_param_spec_boolean ("has-focus", "has-focus", "has-focus", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
sidebar_sidebar_window_files_sidebar_interface_interface_init (FilesSidebarInterfaceIface * iface,
                                                               gpointer iface_data)
{
	sidebar_sidebar_window_files_sidebar_interface_parent_iface = g_type_interface_peek_parent (iface);
	iface->add_plugin_item = (guint32 (*) (FilesSidebarInterface*, FilesSidebarPluginItem*, FilesPlaceType)) sidebar_sidebar_window_real_add_plugin_item;
	iface->update_plugin_item = (gboolean (*) (FilesSidebarInterface*, FilesSidebarPluginItem*, guint32)) sidebar_sidebar_window_real_update_plugin_item;
	iface->sync_uri = (void (*) (FilesSidebarInterface*, const gchar*)) sidebar_sidebar_window_real_sync_uri;
	iface->reload = (void (*) (FilesSidebarInterface*)) sidebar_sidebar_window_real_reload;
	iface->add_favorite_uri = (void (*) (FilesSidebarInterface*, const gchar*, const gchar*)) sidebar_sidebar_window_real_add_favorite_uri;
	iface->has_favorite_uri = (gboolean (*) (FilesSidebarInterface*, const gchar*)) sidebar_sidebar_window_real_has_favorite_uri;
	iface->on_free_space_change = (void (*) (FilesSidebarInterface*)) sidebar_sidebar_window_real_on_free_space_change;
	iface->focus = (void (*) (FilesSidebarInterface*)) sidebar_sidebar_window_real_focus;
}

static void
sidebar_sidebar_window_instance_init (SidebarSidebarWindow * self,
                                      gpointer klass)
{
	gchar* _tmp0_;
	self->priv = sidebar_sidebar_window_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->selected_uri = _tmp0_;
	self->priv->loading = FALSE;
	self->ejecting_or_unmounting = FALSE;
	self->priv->sync_timeout_id = (guint) 0;
	self->priv->reload_timeout_id = (guint) 0;
}

static void
sidebar_sidebar_window_finalize (GObject * obj)
{
	SidebarSidebarWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SIDEBAR_TYPE_SIDEBAR_WINDOW, SidebarSidebarWindow);
	_g_object_unref0 (self->priv->scrolled_window);
	_g_object_unref0 (self->priv->bookmark_listbox);
	_g_object_unref0 (self->priv->device_listbox);
	_g_object_unref0 (self->priv->network_listbox);
	_g_free0 (self->priv->selected_uri);
	G_OBJECT_CLASS (sidebar_sidebar_window_parent_class)->finalize (obj);
}

 G_GNUC_NO_INLINE static GType
sidebar_sidebar_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SidebarSidebarWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) sidebar_sidebar_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SidebarSidebarWindow), 0, (GInstanceInitFunc) sidebar_sidebar_window_instance_init, NULL };
	static const GInterfaceInfo files_sidebar_interface_info = { (GInterfaceInitFunc) sidebar_sidebar_window_files_sidebar_interface_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	GType sidebar_sidebar_window_type_id;
	sidebar_sidebar_window_type_id = g_type_register_static (gtk_box_get_type (), "SidebarSidebarWindow", &g_define_type_info, 0);
	g_type_add_interface_static (sidebar_sidebar_window_type_id, FILES_TYPE_SIDEBAR_INTERFACE, &files_sidebar_interface_info);
	SidebarSidebarWindow_private_offset = g_type_add_instance_private (sidebar_sidebar_window_type_id, sizeof (SidebarSidebarWindowPrivate));
	return sidebar_sidebar_window_type_id;
}

GType
sidebar_sidebar_window_get_type (void)
{
	static volatile gsize sidebar_sidebar_window_type_id__once = 0;
	if (g_once_init_enter (&sidebar_sidebar_window_type_id__once)) {
		GType sidebar_sidebar_window_type_id;
		sidebar_sidebar_window_type_id = sidebar_sidebar_window_get_type_once ();
		g_once_init_leave (&sidebar_sidebar_window_type_id__once, sidebar_sidebar_window_type_id);
	}
	return sidebar_sidebar_window_type_id__once;
}

static void
_vala_sidebar_sidebar_window_get_property (GObject * object,
                                           guint property_id,
                                           GValue * value,
                                           GParamSpec * pspec)
{
	SidebarSidebarWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, SIDEBAR_TYPE_SIDEBAR_WINDOW, SidebarSidebarWindow);
	switch (property_id) {
		case SIDEBAR_SIDEBAR_WINDOW_HAS_FOCUS_PROPERTY:
		g_value_set_boolean (value, sidebar_sidebar_window_get_has_focus (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

