/* BatchImport.c generated by valac 0.56.18, the Vala compiler
 * generated from BatchImport.vala, do not modify */

/*
* Copyright (c) 2009-2013 Yorba Foundation
*
* This program is free software; you can redistribute it and/or
* modify it under the terms of the GNU Lesser General Public
* License as published by the Free Software Foundation; either
* version 2.1 of the License, or (at your option) any later version.
*
* This program is distributed in the hope that it will be useful,
* but WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
* You should have received a copy of the GNU General Public
* License along with this program; if not, write to the
* Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
* Boston, MA 02110-1301 USA
*/

#include "io.elementary.photos.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <glib/gi18n-lib.h>
#include <gio/gio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>
#include <gee.h>
#include <float.h>
#include <math.h>

#define BATCH_IMPORT_WORK_SNIFFER_THROBBER_MSEC 125
#define BATCH_IMPORT_READY_SOURCES_COUNT_OVERFLOW 10
#define BATCH_IMPORT_DISPLAY_QUEUE_TIMER_MSEC 125
#define BATCH_IMPORT_DISPLAY_QUEUE_HYSTERESIS_OVERFLOW ((3 * 1000) / BATCH_IMPORT_DISPLAY_QUEUE_TIMER_MSEC)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _ParamSpecBatchImportJob ParamSpecBatchImportJob;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _batch_import_job_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_job_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
typedef struct _ParamSpecBatchImportRoll ParamSpecBatchImportRoll;
typedef struct _ParamSpecBatchImportResult ParamSpecBatchImportResult;
#define _batch_import_result_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_result_unref (var), NULL)))
typedef struct _ParamSpecImportManifest ParamSpecImportManifest;

#define TYPE_PREPARED_FILE (prepared_file_get_type ())
#define PREPARED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREPARED_FILE, PreparedFile))
#define PREPARED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREPARED_FILE, PreparedFileClass))
#define IS_PREPARED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREPARED_FILE))
#define IS_PREPARED_FILE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREPARED_FILE))
#define PREPARED_FILE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREPARED_FILE, PreparedFileClass))

typedef struct _PreparedFile PreparedFile;
typedef struct _PreparedFileClass PreparedFileClass;

#define TYPE_COMPLETED_IMPORT_OBJECT (completed_import_object_get_type ())
#define COMPLETED_IMPORT_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETED_IMPORT_OBJECT, CompletedImportObject))
#define COMPLETED_IMPORT_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETED_IMPORT_OBJECT, CompletedImportObjectClass))
#define IS_COMPLETED_IMPORT_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETED_IMPORT_OBJECT))
#define IS_COMPLETED_IMPORT_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETED_IMPORT_OBJECT))
#define COMPLETED_IMPORT_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETED_IMPORT_OBJECT, CompletedImportObjectClass))

typedef struct _CompletedImportObject CompletedImportObject;
typedef struct _CompletedImportObjectClass CompletedImportObjectClass;
enum  {
	BATCH_IMPORT_0_PROPERTY,
	BATCH_IMPORT_NUM_PROPERTIES
};
static GParamSpec* batch_import_properties[BATCH_IMPORT_NUM_PROPERTIES];
#define _batch_import_roll_unref0(var) ((var == NULL) ? NULL : (var = (batch_import_roll_unref (var), NULL)))
#define _import_manifest_unref0(var) ((var == NULL) ? NULL : (var = (import_manifest_unref (var), NULL)))

#define TYPE_BACKGROUND_IMPORT_JOB (background_import_job_get_type ())
#define BACKGROUND_IMPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_IMPORT_JOB, BackgroundImportJob))
#define BACKGROUND_IMPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_IMPORT_JOB, BackgroundImportJobClass))
#define IS_BACKGROUND_IMPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_IMPORT_JOB))
#define IS_BACKGROUND_IMPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_IMPORT_JOB))
#define BACKGROUND_IMPORT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_IMPORT_JOB, BackgroundImportJobClass))

typedef struct _BackgroundImportJob BackgroundImportJob;
typedef struct _BackgroundImportJobClass BackgroundImportJobClass;
typedef struct _BackgroundImportJobPrivate BackgroundImportJobPrivate;

#define TYPE_WORK_SNIFFER (work_sniffer_get_type ())
#define WORK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORK_SNIFFER, WorkSniffer))
#define WORK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORK_SNIFFER, WorkSnifferClass))
#define IS_WORK_SNIFFER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORK_SNIFFER))
#define IS_WORK_SNIFFER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORK_SNIFFER))
#define WORK_SNIFFER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORK_SNIFFER, WorkSnifferClass))

typedef struct _WorkSniffer WorkSniffer;
typedef struct _WorkSnifferClass WorkSnifferClass;
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
typedef struct _WorkSnifferPrivate WorkSnifferPrivate;

#define TYPE_FILE_TO_PREPARE (file_to_prepare_get_type ())
#define FILE_TO_PREPARE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_TO_PREPARE, FileToPrepare))
#define FILE_TO_PREPARE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_TO_PREPARE, FileToPrepareClass))
#define IS_FILE_TO_PREPARE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_TO_PREPARE))
#define IS_FILE_TO_PREPARE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_TO_PREPARE))
#define FILE_TO_PREPARE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_TO_PREPARE, FileToPrepareClass))

typedef struct _FileToPrepare FileToPrepare;
typedef struct _FileToPrepareClass FileToPrepareClass;

#define TYPE_PREPARE_FILES_JOB (prepare_files_job_get_type ())
#define PREPARE_FILES_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREPARE_FILES_JOB, PrepareFilesJob))
#define PREPARE_FILES_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREPARE_FILES_JOB, PrepareFilesJobClass))
#define IS_PREPARE_FILES_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREPARE_FILES_JOB))
#define IS_PREPARE_FILES_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREPARE_FILES_JOB))
#define PREPARE_FILES_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREPARE_FILES_JOB, PrepareFilesJobClass))

typedef struct _PrepareFilesJob PrepareFilesJob;
typedef struct _PrepareFilesJobClass PrepareFilesJobClass;

#define TYPE_THUMBNAIL_WRITER_JOB (thumbnail_writer_job_get_type ())
#define THUMBNAIL_WRITER_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_WRITER_JOB, ThumbnailWriterJob))
#define THUMBNAIL_WRITER_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_WRITER_JOB, ThumbnailWriterJobClass))
#define IS_THUMBNAIL_WRITER_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_WRITER_JOB))
#define IS_THUMBNAIL_WRITER_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_WRITER_JOB))
#define THUMBNAIL_WRITER_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_WRITER_JOB, ThumbnailWriterJobClass))

typedef struct _ThumbnailWriterJob ThumbnailWriterJob;
typedef struct _ThumbnailWriterJobClass ThumbnailWriterJobClass;
#define _completed_import_object_unref0(var) ((var == NULL) ? NULL : (var = (completed_import_object_unref (var), NULL)))

#define TYPE_PREPARED_FILE_IMPORT_JOB (prepared_file_import_job_get_type ())
#define PREPARED_FILE_IMPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREPARED_FILE_IMPORT_JOB, PreparedFileImportJob))
#define PREPARED_FILE_IMPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREPARED_FILE_IMPORT_JOB, PreparedFileImportJobClass))
#define IS_PREPARED_FILE_IMPORT_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREPARED_FILE_IMPORT_JOB))
#define IS_PREPARED_FILE_IMPORT_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREPARED_FILE_IMPORT_JOB))
#define PREPARED_FILE_IMPORT_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREPARED_FILE_IMPORT_JOB, PreparedFileImportJobClass))

typedef struct _PreparedFileImportJob PreparedFileImportJob;
typedef struct _PreparedFileImportJobClass PreparedFileImportJobClass;
#define _prepared_file_unref0(var) ((var == NULL) ? NULL : (var = (prepared_file_unref (var), NULL)))
typedef struct _PreparedFilePrivate PreparedFilePrivate;

#define TYPE_PREPARED_FILE_CLUSTER (prepared_file_cluster_get_type ())
#define PREPARED_FILE_CLUSTER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREPARED_FILE_CLUSTER, PreparedFileCluster))
#define PREPARED_FILE_CLUSTER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREPARED_FILE_CLUSTER, PreparedFileClusterClass))
#define IS_PREPARED_FILE_CLUSTER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREPARED_FILE_CLUSTER))
#define IS_PREPARED_FILE_CLUSTER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREPARED_FILE_CLUSTER))
#define PREPARED_FILE_CLUSTER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREPARED_FILE_CLUSTER, PreparedFileClusterClass))

typedef struct _PreparedFileCluster PreparedFileCluster;
typedef struct _PreparedFileClusterClass PreparedFileClusterClass;
typedef struct _PreparedFileClusterPrivate PreparedFileClusterPrivate;
#define _notification_object_unref0(var) ((var == NULL) ? NULL : (var = (notification_object_unref (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))
#define _source_holding_tank_unref0(var) ((var == NULL) ? NULL : (var = (source_holding_tank_unref (var), NULL)))
typedef struct _BatchImportProcessPreparedFilesData BatchImportProcessPreparedFilesData;
typedef struct _PrepareFilesJobPrivate PrepareFilesJobPrivate;
typedef struct _PreparedFileImportJobPrivate PreparedFileImportJobPrivate;

#define TYPE_READY_FOR_IMPORT (ready_for_import_get_type ())
#define READY_FOR_IMPORT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_READY_FOR_IMPORT, ReadyForImport))
#define READY_FOR_IMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_READY_FOR_IMPORT, ReadyForImportClass))
#define IS_READY_FOR_IMPORT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_READY_FOR_IMPORT))
#define IS_READY_FOR_IMPORT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_READY_FOR_IMPORT))
#define READY_FOR_IMPORT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_READY_FOR_IMPORT, ReadyForImportClass))

typedef struct _ReadyForImport ReadyForImport;
typedef struct _ReadyForImportClass ReadyForImportClass;
typedef struct _ReadyForImportPrivate ReadyForImportPrivate;
#define _backing_photo_row_unref0(var) ((var == NULL) ? NULL : (var = (backing_photo_row_unref (var), NULL)))
#define _thumbnails_unref0(var) ((var == NULL) ? NULL : (var = (thumbnails_unref (var), NULL)))
typedef struct _ThumbnailWriterJobPrivate ThumbnailWriterJobPrivate;
typedef struct _CompletedImportObjectPrivate CompletedImportObjectPrivate;
#define _media_collection_registry_unref0(var) ((var == NULL) ? NULL : (var = (media_collection_registry_unref (var), NULL)))
enum  {
	BATCH_IMPORT_STARTING_SIGNAL,
	BATCH_IMPORT_PREPARING_SIGNAL,
	BATCH_IMPORT_PROGRESS_SIGNAL,
	BATCH_IMPORT_IMPORTED_SIGNAL,
	BATCH_IMPORT_FATAL_ERROR_SIGNAL,
	BATCH_IMPORT_IMPORT_JOB_FAILED_SIGNAL,
	BATCH_IMPORT_IMPORT_COMPLETE_SIGNAL,
	BATCH_IMPORT_NUM_SIGNALS
};
static guint batch_import_signals[BATCH_IMPORT_NUM_SIGNALS] = {0};
enum  {
	DUPLICATED_FILE_0_PROPERTY,
	DUPLICATED_FILE_NUM_PROPERTIES
};
static GParamSpec* duplicated_file_properties[DUPLICATED_FILE_NUM_PROPERTIES];
#define _video_id_free0(var) ((var == NULL) ? NULL : (var = (video_id_free (var), NULL)))
#define _photo_id_free0(var) ((var == NULL) ? NULL : (var = (photo_id_free (var), NULL)))
typedef struct _FileToPreparePrivate FileToPreparePrivate;
#define _file_to_prepare_unref0(var) ((var == NULL) ? NULL : (var = (file_to_prepare_unref (var), NULL)))
typedef struct _ParamSpecFileToPrepare ParamSpecFileToPrepare;
#define _photo_file_format_properties_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_format_properties_unref (var), NULL)))
typedef struct _ParamSpecPreparedFile ParamSpecPreparedFile;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))
#define _media_metadata_unref0(var) ((var == NULL) ? NULL : (var = (media_metadata_unref (var), NULL)))
#define _photo_file_adapter_unref0(var) ((var == NULL) ? NULL : (var = (photo_file_adapter_unref (var), NULL)))
#define _photo_import_params_unref0(var) ((var == NULL) ? NULL : (var = (photo_import_params_unref (var), NULL)))
#define _video_import_params_unref0(var) ((var == NULL) ? NULL : (var = (video_import_params_unref (var), NULL)))
typedef struct _ParamSpecReadyForImport ParamSpecReadyForImport;
#define _ready_for_import_unref0(var) ((var == NULL) ? NULL : (var = (ready_for_import_unref (var), NULL)))
typedef struct _ParamSpecCompletedImportObject ParamSpecCompletedImportObject;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _ParamSpecBatchImportJob {
	GParamSpec parent_instance;
};

struct _FileImportJobPrivate {
	GFile* file_or_dir;
	gboolean copy_to_library;
	FileImportJob* associated;
};

struct _ParamSpecBatchImportRoll {
	GParamSpec parent_instance;
};

struct _ParamSpecBatchImportResult {
	GParamSpec parent_instance;
};

struct _ParamSpecImportManifest {
	GParamSpec parent_instance;
};

struct _BatchImportPrivate {
	GeeIterable* jobs;
	BatchImportRoll* import_roll;
	gchar* name;
	guint64 completed_bytes;
	guint64 total_bytes;
	BatchImportImportReporter reporter;
	gpointer reporter_target;
	ImportManifest* manifest;
	gboolean scheduled;
	gboolean completed;
	gint file_imports_to_perform;
	gint file_imports_completed;
	GCancellable* cancellable;
	gint64 last_preparing_ms;
	GeeHashSet* skipset;
	GeeHashMap* imported_full_md5_table;
	guint throbber_id;
	gint max_outstanding_import_jobs;
	gboolean untrash_duplicates;
	gboolean mark_duplicates_online;
	GSettings* file_settings;
	GeeList* ready_files;
	GeeList* ready_thumbnails;
	GeeList* display_imported_queue;
	GeeList* ready_sources;
};

struct _BackgroundImportJob {
	BackgroundJob parent_instance;
	BackgroundImportJobPrivate * priv;
	ImportResult abort_flag;
	GeeList* failed;
};

struct _BackgroundImportJobClass {
	BackgroundJobClass parent_class;
};

struct _WorkSniffer {
	BackgroundImportJob parent_instance;
	WorkSnifferPrivate * priv;
	GeeList* files_to_prepare;
	guint64 total_bytes;
};

struct _WorkSnifferClass {
	BackgroundImportJobClass parent_class;
};

struct _PreparedFile {
	GTypeInstance parent_instance;
	volatile int ref_count;
	PreparedFilePrivate * priv;
	BatchImportJob* job;
	ImportResult result;
	GFile* file;
	GFile* associated_file;
	gchar* source_id;
	gchar* dest_id;
	gboolean copy_to_library;
	gchar* exif_md5;
	gchar* thumbnail_md5;
	gchar* full_md5;
	PhotoFileFormat file_format;
	guint64 filesize;
	gboolean is_video;
};

struct _PreparedFileClass {
	GTypeClass parent_class;
	void (*finalize) (PreparedFile *self);
};

struct _PreparedFileCluster {
	InterlockedNotificationObject parent_instance;
	PreparedFileClusterPrivate * priv;
	GeeArrayList* list;
};

struct _PreparedFileClusterClass {
	InterlockedNotificationObjectClass parent_class;
};

struct _BatchImportProcessPreparedFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BatchImport* self;
	GeeList* list;
	GeeList* _prepared_file_list;
	gint _prepared_file_size;
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	gint _prepared_file_index;
	gint _tmp3_;
	gint _tmp4_;
	PreparedFile* prepared_file;
	GeeList* _tmp5_;
	gpointer _tmp6_;
	BatchImportResult* import_result;
	LibraryPhotoSourceCollectionState photo_state;
	LibraryPhoto* photo;
	LibraryPhotoSourceCollection* _tmp7_;
	PreparedFile* _tmp8_;
	GFile* _tmp9_;
	LibraryPhotoSourceCollectionState _tmp10_;
	LibraryPhoto* _tmp11_;
	LibraryPhoto* _tmp12_;
	PreparedFile* _tmp13_;
	BatchImportJob* _tmp14_;
	PreparedFile* _tmp15_;
	GFile* _tmp16_;
	PreparedFile* _tmp17_;
	GFile* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	PreparedFile* _tmp21_;
	GFile* _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	LibraryPhoto* _tmp25_;
	GFile* _tmp26_;
	GFile* _tmp27_;
	DuplicatedFile* _tmp28_;
	DuplicatedFile* _tmp29_;
	BatchImportResult* _tmp30_;
	LibraryPhoto* _tmp31_;
	GEnumValue* _tmp32_;
	BatchImportResult* _tmp33_;
	BatchImportResult* _tmp34_;
	VideoSourceCollectionState video_state;
	Video* video;
	VideoSourceCollection* _tmp35_;
	PreparedFile* _tmp36_;
	GFile* _tmp37_;
	VideoSourceCollectionState _tmp38_;
	Video* _tmp39_;
	Video* _tmp40_;
	PreparedFile* _tmp41_;
	BatchImportJob* _tmp42_;
	PreparedFile* _tmp43_;
	GFile* _tmp44_;
	PreparedFile* _tmp45_;
	GFile* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	PreparedFile* _tmp49_;
	GFile* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	Video* _tmp53_;
	GFile* _tmp54_;
	GFile* _tmp55_;
	DuplicatedFile* _tmp56_;
	DuplicatedFile* _tmp57_;
	BatchImportResult* _tmp58_;
	Video* _tmp59_;
	GEnumValue* _tmp60_;
	BatchImportResult* _tmp61_;
	BatchImportResult* _tmp62_;
	gboolean _tmp63_;
	PreparedFile* _tmp64_;
	PreparedFile* _tmp65_;
	GFile* _tmp66_;
	PreparedFile* _tmp67_;
	const gchar* _tmp68_;
	VideoID* duplicate_ids;
	VideoTable* _tmp69_;
	VideoTable* _tmp70_;
	PreparedFile* _tmp71_;
	GFile* _tmp72_;
	PreparedFile* _tmp73_;
	const gchar* _tmp74_;
	gint _tmp75_;
	VideoID* _tmp76_;
	VideoID* _tmp77_;
	gint _tmp77__length1;
	gint duplicate_ids_length1;
	gint _duplicate_ids_size_;
	VideoID* _tmp78_;
	gint _tmp78__length1;
	DuplicatedFile* duplicated_file;
	VideoID* _tmp79_;
	gint _tmp79__length1;
	VideoID _tmp80_;
	DuplicatedFile* _tmp81_;
	ImportResult result_code;
	Video* dupe_video;
	VideoSourceCollection* _tmp82_;
	MediaSourceHoldingTank* _tmp83_;
	MediaSourceHoldingTank* _tmp84_;
	PreparedFile* _tmp85_;
	GFile* _tmp86_;
	MediaSource* _tmp87_;
	Video* _tmp88_;
	Video* _tmp89_;
	VideoSourceCollection* _tmp90_;
	MediaSourceHoldingTank* _tmp91_;
	MediaSourceHoldingTank* _tmp92_;
	PreparedFile* _tmp93_;
	const gchar* _tmp94_;
	MediaSource* _tmp95_;
	Video* _tmp96_;
	PreparedFile* _tmp97_;
	GFile* _tmp98_;
	gchar* _tmp99_;
	gchar* _tmp100_;
	Video* _tmp101_;
	PreparedFile* _tmp102_;
	GFile* _tmp103_;
	Video* _tmp104_;
	ImportManifest* _tmp105_;
	GeeList* _tmp106_;
	Video* _tmp107_;
	Video* _tmp108_;
	PreparedFile* _tmp109_;
	BatchImportJob* _tmp110_;
	PreparedFile* _tmp111_;
	GFile* _tmp112_;
	PreparedFile* _tmp113_;
	GFile* _tmp114_;
	gchar* _tmp115_;
	gchar* _tmp116_;
	PreparedFile* _tmp117_;
	GFile* _tmp118_;
	gchar* _tmp119_;
	gchar* _tmp120_;
	DuplicatedFile* _tmp121_;
	BatchImportResult* _tmp122_;
	ImportManifest* _tmp123_;
	BatchImportResult* _tmp124_;
	PreparedFile* _tmp125_;
	GFile* _tmp126_;
	GFile* _tmp127_;
	gboolean _tmp128_;
	PreparedFile* _tmp129_;
	BatchImportJob* _tmp130_;
	PreparedFile* _tmp131_;
	GFile* _tmp132_;
	PreparedFile* _tmp133_;
	GFile* _tmp134_;
	gchar* _tmp135_;
	gchar* _tmp136_;
	PreparedFile* _tmp137_;
	GFile* _tmp138_;
	gchar* _tmp139_;
	gchar* _tmp140_;
	PreparedFile* _tmp141_;
	GFile* _tmp142_;
	GFile* _tmp143_;
	DuplicatedFile* _tmp144_;
	DuplicatedFile* _tmp145_;
	BatchImportResult* _tmp146_;
	PreparedFile* _tmp147_;
	GFile* _tmp148_;
	PreparedFile* _tmp149_;
	const gchar* _tmp150_;
	PreparedFile* _tmp151_;
	LibraryPhotoSourceCollection* _tmp152_;
	PreparedFile* _tmp153_;
	GFile* _tmp154_;
	LibraryPhoto* _tmp155_;
	gboolean _tmp156_;
	LibraryPhoto* _tmp157_;
	PreparedFile* _tmp158_;
	const gchar* _tmp159_;
	LibraryPhotoSourceCollection* _tmp160_;
	PreparedFile* _tmp161_;
	const gchar* _tmp162_;
	LibraryPhoto* _tmp163_;
	LibraryPhoto* _tmp164_;
	PreparedFile* _tmp165_;
	GFile* _tmp166_;
	gchar* _tmp167_;
	gchar* _tmp168_;
	LibraryPhoto* _tmp169_;
	PreparedFile* _tmp170_;
	GFile* _tmp171_;
	LibraryPhoto* _tmp172_;
	LibraryPhoto* _tmp173_;
	gboolean _tmp174_;
	LibraryPhoto* _tmp175_;
	LibraryPhotoSourceCollection* _tmp176_;
	PreparedFile* _tmp177_;
	GFile* _tmp178_;
	LibraryPhoto* _tmp179_;
	gboolean _tmp180_;
	LibraryPhoto* _tmp181_;
	PreparedFile* _tmp182_;
	const gchar* _tmp183_;
	LibraryPhotoSourceCollection* _tmp184_;
	PreparedFile* _tmp185_;
	const gchar* _tmp186_;
	LibraryPhoto* _tmp187_;
	LibraryPhoto* _tmp188_;
	PreparedFile* _tmp189_;
	GFile* _tmp190_;
	gchar* _tmp191_;
	gchar* _tmp192_;
	LibraryPhoto* _tmp193_;
	PreparedFile* _tmp194_;
	GFile* _tmp195_;
	LibraryPhoto* _tmp196_;
	LibraryPhoto* _tmp197_;
	PreparedFile* _tmp198_;
	BatchImportJob* _tmp199_;
	PreparedFile* _tmp200_;
	GFile* _tmp201_;
	PreparedFile* _tmp202_;
	GFile* _tmp203_;
	gchar* _tmp204_;
	gchar* _tmp205_;
	PreparedFile* _tmp206_;
	GFile* _tmp207_;
	gchar* _tmp208_;
	gchar* _tmp209_;
	BatchImportResult* _tmp210_;
	ImportManifest* _tmp211_;
	GeeList* _tmp212_;
	LibraryPhoto* _tmp213_;
	ImportManifest* _tmp214_;
	BatchImportResult* _tmp215_;
	LibraryPhoto* _tmp216_;
	PreparedFile* _tmp217_;
	GFile* _tmp218_;
	gchar* _tmp219_;
	gchar* _tmp220_;
	PhotoID* photo_ids;
	PhotoTable* _tmp221_;
	PhotoTable* _tmp222_;
	PreparedFile* _tmp223_;
	GFile* _tmp224_;
	PreparedFile* _tmp225_;
	const gchar* _tmp226_;
	PreparedFile* _tmp227_;
	gint _tmp228_;
	PhotoID* _tmp229_;
	PhotoID* _tmp230_;
	gint _tmp230__length1;
	gint photo_ids_length1;
	gint _photo_ids_size_;
	PhotoID* _tmp231_;
	gint _tmp231__length1;
	DuplicatedFile* _vala1_duplicated_file;
	PhotoID* _tmp232_;
	gint _tmp232__length1;
	PhotoID _tmp233_;
	DuplicatedFile* _tmp234_;
	PreparedFile* _tmp235_;
	BatchImportJob* _tmp236_;
	PreparedFile* _tmp237_;
	GFile* _tmp238_;
	PreparedFile* _tmp239_;
	GFile* _tmp240_;
	gchar* _tmp241_;
	gchar* _tmp242_;
	PreparedFile* _tmp243_;
	GFile* _tmp244_;
	gchar* _tmp245_;
	gchar* _tmp246_;
	DuplicatedFile* _tmp247_;
	BatchImportResult* _tmp248_;
	BatchImportResult* _tmp249_;
	BatchImportResult* _tmp250_;
	GeeList* _tmp251_;
	PreparedFile* _tmp252_;
};

struct _PrepareFilesJob {
	BackgroundImportJob parent_instance;
	PrepareFilesJobPrivate * priv;
	gint prepared_files;
};

struct _PrepareFilesJobClass {
	BackgroundImportJobClass parent_class;
};

struct _PreparedFileImportJob {
	BackgroundJob parent_instance;
	PreparedFileImportJobPrivate * priv;
	PreparedFile* not_ready;
	ReadyForImport* ready;
	BatchImportResult* failed;
};

struct _PreparedFileImportJobClass {
	BackgroundJobClass parent_class;
};

struct _ReadyForImport {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ReadyForImportPrivate * priv;
	GFile* final_file;
	PreparedFile* prepared_file;
	PhotoImportParams* photo_import_params;
	VideoImportParams* video_import_params;
	BatchImportResult* batch_result;
	gboolean is_video;
};

struct _ReadyForImportClass {
	GTypeClass parent_class;
	void (*finalize) (ReadyForImport *self);
};

struct _ThumbnailWriterJob {
	BackgroundImportJob parent_instance;
	ThumbnailWriterJobPrivate * priv;
	CompletedImportObject* completed_import_source;
};

struct _ThumbnailWriterJobClass {
	BackgroundImportJobClass parent_class;
};

struct _CompletedImportObject {
	GTypeInstance parent_instance;
	volatile int ref_count;
	CompletedImportObjectPrivate * priv;
	Thumbnails* thumbnails;
	BatchImportResult* batch_result;
	MediaSource* source;
	BatchImportJob* original_job;
	GdkPixbuf* user_preview;
};

struct _CompletedImportObjectClass {
	GTypeClass parent_class;
	void (*finalize) (CompletedImportObject *self);
};

struct _DuplicatedFilePrivate {
	VideoID* video_id;
	PhotoID* photo_id;
	GFile* file;
};

struct _FileToPrepare {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FileToPreparePrivate * priv;
	BatchImportJob* job;
	GFile* file;
	gboolean copy_to_library;
	FileToPrepare* associated;
};

struct _FileToPrepareClass {
	GTypeClass parent_class;
	void (*finalize) (FileToPrepare *self);
};

struct _ParamSpecFileToPrepare {
	GParamSpec parent_instance;
};

struct _WorkSnifferPrivate {
	GeeIterable* jobs;
	GeeHashSet* skipset;
};

struct _ParamSpecPreparedFile {
	GParamSpec parent_instance;
};

struct _PrepareFilesJobPrivate {
	GeeList* files_to_prepare;
	NotificationCallback notification;
	gpointer notification_target;
	GFile* library_dir;
	gint import_file_count;
	gint fail_every;
	gint skip_every;
};

struct _ParamSpecReadyForImport {
	GParamSpec parent_instance;
};

struct _PreparedFileImportJobPrivate {
	ImportID import_id;
};

struct _ParamSpecCompletedImportObject {
	GParamSpec parent_instance;
};

static gpointer batch_import_job_parent_class = NULL;
static gint FileImportJob_private_offset;
static gpointer file_import_job_parent_class = NULL;
static gpointer batch_import_roll_parent_class = NULL;
static gpointer batch_import_result_parent_class = NULL;
static gpointer import_manifest_parent_class = NULL;
static gint BatchImport_private_offset;
static gpointer batch_import_parent_class = NULL;
static Workers* batch_import_feeder_workers;
static Workers* batch_import_feeder_workers = NULL;
static Workers* batch_import_import_workers;
static Workers* batch_import_import_workers = NULL;
static gint DuplicatedFile_private_offset;
static gpointer duplicated_file_parent_class = NULL;
static gpointer background_import_job_parent_class = NULL;
static gpointer file_to_prepare_parent_class = NULL;
static gint WorkSniffer_private_offset;
static gpointer work_sniffer_parent_class = NULL;
static gpointer prepared_file_parent_class = NULL;
static gpointer prepared_file_cluster_parent_class = NULL;
static gint PrepareFilesJob_private_offset;
static gpointer prepare_files_job_parent_class = NULL;
static gpointer ready_for_import_parent_class = NULL;
static gint PreparedFileImportJob_private_offset;
static gpointer prepared_file_import_job_parent_class = NULL;
static gpointer completed_import_object_parent_class = NULL;
static gpointer thumbnail_writer_job_parent_class = NULL;

static gchar* batch_import_job_real_get_dest_identifier (BatchImportJob* self);
static gchar* batch_import_job_real_get_source_identifier (BatchImportJob* self);
static gboolean batch_import_job_real_is_directory (BatchImportJob* self);
static gchar* batch_import_job_real_get_basename (BatchImportJob* self);
static gchar* batch_import_job_real_get_path (BatchImportJob* self);
static DuplicatedFile* batch_import_job_real_get_duplicated_file (BatchImportJob* self);
static void batch_import_job_real_set_associated (BatchImportJob* self,
                                           BatchImportJob* associated);
static gboolean batch_import_job_real_determine_file_size (BatchImportJob* self,
                                                    guint64* filesize,
                                                    GFile** file_or_dir);
static gboolean batch_import_job_real_prepare (BatchImportJob* self,
                                        GFile** file_to_import,
                                        gboolean* copy_to_library,
                                        GError** error);
static gboolean batch_import_job_real_complete (BatchImportJob* self,
                                         MediaSource* source,
                                         BatchImportRoll* import_roll,
                                         GError** error);
static gint64 batch_import_job_real_get_exposure_time_override (BatchImportJob* self);
static void batch_import_job_finalize (BatchImportJob * obj);
static GType batch_import_job_get_type_once (void);
static gchar* file_import_job_real_get_dest_identifier (BatchImportJob* base);
static gchar* file_import_job_real_get_source_identifier (BatchImportJob* base);
static gboolean file_import_job_real_is_directory (BatchImportJob* base);
static gchar* file_import_job_real_get_basename (BatchImportJob* base);
static gchar* file_import_job_real_get_path (BatchImportJob* base);
static void file_import_job_real_set_associated (BatchImportJob* base,
                                          BatchImportJob* associated);
static gboolean file_import_job_real_determine_file_size (BatchImportJob* base,
                                                   guint64* filesize,
                                                   GFile** file);
static gboolean file_import_job_real_prepare (BatchImportJob* base,
                                       GFile** file_to_import,
                                       gboolean* copy,
                                       GError** error);
static void file_import_job_finalize (BatchImportJob * obj);
static GType file_import_job_get_type_once (void);
static void batch_import_roll_finalize (BatchImportRoll * obj);
static GType batch_import_roll_get_type_once (void);
static void batch_import_result_finalize (BatchImportResult * obj);
static GType batch_import_result_get_type_once (void);
static void import_manifest_finalize (ImportManifest * obj);
static GType import_manifest_get_type_once (void);
VALA_EXTERN gpointer prepared_file_ref (gpointer instance);
VALA_EXTERN void prepared_file_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_prepared_file (const gchar* name,
                                      const gchar* nick,
                                      const gchar* blurb,
                                      GType object_type,
                                      GParamFlags flags);
VALA_EXTERN void value_set_prepared_file (GValue* value,
                              gpointer v_object);
VALA_EXTERN void value_take_prepared_file (GValue* value,
                               gpointer v_object);
VALA_EXTERN gpointer value_get_prepared_file (const GValue* value);
VALA_EXTERN GType prepared_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer completed_import_object_ref (gpointer instance);
VALA_EXTERN void completed_import_object_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_completed_import_object (const gchar* name,
                                                const gchar* nick,
                                                const gchar* blurb,
                                                GType object_type,
                                                GParamFlags flags);
VALA_EXTERN void value_set_completed_import_object (GValue* value,
                                        gpointer v_object);
VALA_EXTERN void value_take_completed_import_object (GValue* value,
                                         gpointer v_object);
VALA_EXTERN gpointer value_get_completed_import_object (const GValue* value);
VALA_EXTERN GType completed_import_object_get_type (void) G_GNUC_CONST ;
static void _batch_import_user_halt_photos_application_exiting (PhotosApplication* _sender,
                                                         gboolean panicked,
                                                         gpointer self);
static guint _file_hash_gee_hash_data_func (gconstpointer v,
                                     gpointer self);
static gboolean _file_equal_gee_equal_data_func (gconstpointer a,
                                          gconstpointer b,
                                          gpointer self);
static gboolean batch_import_display_imported_timer (BatchImport* self);
static gboolean _batch_import_display_imported_timer_gsource_func (gpointer self);
static void batch_import_log_status (BatchImport* self,
                              const gchar* where);
static gboolean batch_import_report_failure (BatchImport* self,
                                      BatchImportResult* import_result);
static void batch_import_report_progress (BatchImport* self,
                                   guint64 increment_of_progress);
VALA_EXTERN GType background_import_job_get_type (void) G_GNUC_CONST ;
static gboolean batch_import_report_failures (BatchImport* self,
                                       BackgroundImportJob* background_job);
static void batch_import_report_completed (BatchImport* self,
                                    const gchar* where);
static void batch_import_flush_ready_sources (BatchImport* self);
static void batch_import_file_import_complete (BatchImport* self);
static void batch_import_on_work_sniffed_out (BatchImport* self,
                                       BackgroundJob* j);
static void _batch_import_on_work_sniffed_out_completion_callback (BackgroundJob* job,
                                                            gpointer self);
static void batch_import_on_sniffer_cancelled (BatchImport* self,
                                        BackgroundJob* j);
static void _batch_import_on_sniffer_cancelled_cancellation_callback (BackgroundJob* job,
                                                               gpointer self);
VALA_EXTERN WorkSniffer* work_sniffer_new (BatchImport* owner,
                               GeeIterable* jobs,
                               CompletionCallback callback,
                               gpointer callback_target,
                               GCancellable* cancellable,
                               CancellationCallback cancellation,
                               gpointer cancellation_target,
                               GeeHashSet* skipset);
VALA_EXTERN WorkSniffer* work_sniffer_construct (GType object_type,
                                     BatchImport* owner,
                                     GeeIterable* jobs,
                                     CompletionCallback callback,
                                     gpointer callback_target,
                                     GCancellable* cancellable,
                                     CancellationCallback cancellation,
                                     gpointer cancellation_target,
                                     GeeHashSet* skipset);
VALA_EXTERN GType work_sniffer_get_type (void) G_GNUC_CONST ;
static gboolean batch_import_on_sniffer_working (BatchImport* self);
static gboolean _batch_import_on_sniffer_working_gsource_func (gpointer self);
VALA_EXTERN gpointer file_to_prepare_ref (gpointer instance);
VALA_EXTERN void file_to_prepare_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_file_to_prepare (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_file_to_prepare (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_file_to_prepare (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_file_to_prepare (const GValue* value);
VALA_EXTERN GType file_to_prepare_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GType prepare_files_job_get_type (void) G_GNUC_CONST ;
static void batch_import_on_file_prepared (BatchImport* self,
                                    BackgroundJob* j,
                                    NotificationObject* user);
static void _batch_import_on_file_prepared_notification_callback (BackgroundJob* job,
                                                           NotificationObject* user,
                                                           gpointer self);
static void batch_import_on_files_prepared (BatchImport* self,
                                     BackgroundJob* j);
static void _batch_import_on_files_prepared_completion_callback (BackgroundJob* job,
                                                          gpointer self);
static void batch_import_on_file_prepare_cancelled (BatchImport* self,
                                             BackgroundJob* j);
static void _batch_import_on_file_prepare_cancelled_cancellation_callback (BackgroundJob* job,
                                                                    gpointer self);
VALA_EXTERN PrepareFilesJob* prepare_files_job_new (BatchImport* owner,
                                        GeeList* files_to_prepare,
                                        NotificationCallback notification,
                                        gpointer notification_target,
                                        CompletionCallback callback,
                                        gpointer callback_target,
                                        GCancellable* cancellable,
                                        CancellationCallback cancellation,
                                        gpointer cancellation_target);
VALA_EXTERN PrepareFilesJob* prepare_files_job_construct (GType object_type,
                                              BatchImport* owner,
                                              GeeList* files_to_prepare,
                                              NotificationCallback notification,
                                              gpointer notification_target,
                                              CompletionCallback callback,
                                              gpointer callback_target,
                                              GCancellable* cancellable,
                                              CancellationCallback cancellation,
                                              gpointer cancellation_target);
static void batch_import_flush_import_jobs (BatchImport* self);
static void batch_import_on_thumbnail_writer_completed (BatchImport* self,
                                                 BackgroundJob* j);
static void _batch_import_on_thumbnail_writer_completed_completion_callback (BackgroundJob* job,
                                                                      gpointer self);
static void batch_import_on_thumbnail_writer_cancelled (BatchImport* self,
                                                 BackgroundJob* j);
static void _batch_import_on_thumbnail_writer_cancelled_cancellation_callback (BackgroundJob* job,
                                                                        gpointer self);
VALA_EXTERN ThumbnailWriterJob* thumbnail_writer_job_new (BatchImport* owner,
                                              CompletedImportObject* completed_import_source,
                                              CompletionCallback callback,
                                              gpointer callback_target,
                                              GCancellable* cancellable,
                                              CancellationCallback cancel_callback,
                                              gpointer cancel_callback_target);
VALA_EXTERN ThumbnailWriterJob* thumbnail_writer_job_construct (GType object_type,
                                                    BatchImport* owner,
                                                    CompletedImportObject* completed_import_source,
                                                    CompletionCallback callback,
                                                    gpointer callback_target,
                                                    GCancellable* cancellable,
                                                    CancellationCallback cancel_callback,
                                                    gpointer cancel_callback_target);
VALA_EXTERN GType thumbnail_writer_job_get_type (void) G_GNUC_CONST ;
static void batch_import_on_import_files_completed (BatchImport* self,
                                             BackgroundJob* j);
static void _batch_import_on_import_files_completed_completion_callback (BackgroundJob* job,
                                                                  gpointer self);
static void batch_import_on_import_files_cancelled (BatchImport* self,
                                             BackgroundJob* j);
static void _batch_import_on_import_files_cancelled_cancellation_callback (BackgroundJob* job,
                                                                    gpointer self);
VALA_EXTERN PreparedFileImportJob* prepared_file_import_job_new (BatchImport* owner,
                                                     PreparedFile* prepared_file,
                                                     ImportID* import_id,
                                                     CompletionCallback callback,
                                                     gpointer callback_target,
                                                     GCancellable* cancellable,
                                                     CancellationCallback cancellation,
                                                     gpointer cancellation_target);
VALA_EXTERN PreparedFileImportJob* prepared_file_import_job_construct (GType object_type,
                                                           BatchImport* owner,
                                                           PreparedFile* prepared_file,
                                                           ImportID* import_id,
                                                           CompletionCallback callback,
                                                           gpointer callback_target,
                                                           GCancellable* cancellable,
                                                           CancellationCallback cancellation,
                                                           gpointer cancellation_target);
VALA_EXTERN GType prepared_file_import_job_get_type (void) G_GNUC_CONST ;
static GFile* batch_import_get_in_current_import (BatchImport* self,
                                           PreparedFile* prepared_file);
VALA_EXTERN GType prepared_file_cluster_get_type (void) G_GNUC_CONST ;
static void batch_import_process_prepared_files (BatchImport* self,
                                          GeeList* list,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void batch_import_process_prepared_files_finish (BatchImport* self,
                                                 GAsyncResult* _res_);
static void batch_import_process_prepared_files_data_free (gpointer _data);
static gboolean batch_import_process_prepared_files_co (BatchImportProcessPreparedFilesData* _data_);
static gboolean _batch_import_process_prepared_files_co_gsource_func (gpointer self);
static void batch_import_done_preparing_files (BatchImport* self,
                                        BackgroundJob* j,
                                        const gchar* caller);
VALA_EXTERN gpointer ready_for_import_ref (gpointer instance);
VALA_EXTERN void ready_for_import_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_ready_for_import (const gchar* name,
                                         const gchar* nick,
                                         const gchar* blurb,
                                         GType object_type,
                                         GParamFlags flags);
VALA_EXTERN void value_set_ready_for_import (GValue* value,
                                 gpointer v_object);
VALA_EXTERN void value_take_ready_for_import (GValue* value,
                                  gpointer v_object);
VALA_EXTERN gpointer value_get_ready_for_import (const GValue* value);
VALA_EXTERN GType ready_for_import_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Thumbnails* ready_for_import_get_thumbnails (ReadyForImport* self);
VALA_EXTERN CompletedImportObject* completed_import_object_new (MediaSource* source,
                                                    Thumbnails* thumbnails,
                                                    BatchImportJob* original_job,
                                                    BatchImportResult* import_result);
VALA_EXTERN CompletedImportObject* completed_import_object_construct (GType object_type,
                                                          MediaSource* source,
                                                          Thumbnails* thumbnails,
                                                          BatchImportJob* original_job,
                                                          BatchImportResult* import_result);
VALA_EXTERN BatchImportResult* ready_for_import_abort (ReadyForImport* self);
static void g_cclosure_user_marshal_VOID__UINT64_UINT64 (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__ENUM_STRING (GClosure * closure,
                                                GValue * return_value,
                                                guint n_param_values,
                                                const GValue * param_values,
                                                gpointer invocation_hint,
                                                gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BATCH_IMPORT_RESULT (GClosure * closure,
                                                        GValue * return_value,
                                                        guint n_param_values,
                                                        const GValue * param_values,
                                                        gpointer invocation_hint,
                                                        gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__IMPORT_MANIFEST_BATCH_IMPORT_ROLL (GClosure * closure,
                                                                      GValue * return_value,
                                                                      guint n_param_values,
                                                                      const GValue * param_values,
                                                                      gpointer invocation_hint,
                                                                      gpointer marshal_data);
static GObject * batch_import_constructor (GType type,
                                    guint n_construct_properties,
                                    GObjectConstructParam * construct_properties);
static void batch_import_finalize (GObject * obj);
static GType batch_import_get_type_once (void);
static DuplicatedFile* duplicated_file_new (void);
static DuplicatedFile* duplicated_file_construct (GType object_type);
static void duplicated_file_finalize (GObject * obj);
static GType duplicated_file_get_type_once (void);
VALA_EXTERN BackgroundImportJob* background_import_job_construct (GType object_type,
                                                      BatchImport* owner,
                                                      CompletionCallback callback,
                                                      gpointer callback_target,
                                                      GCancellable* cancellable,
                                                      CancellationCallback cancellation,
                                                      gpointer cancellation_target);
VALA_EXTERN ImportResult background_import_job_abort_check (BackgroundImportJob* self);
VALA_EXTERN void background_import_job_abort (BackgroundImportJob* self,
                                  ImportResult _result_);
VALA_EXTERN void background_import_job_report_failure (BackgroundImportJob* self,
                                           BatchImportJob* job,
                                           GFile* file,
                                           const gchar* src_identifier,
                                           const gchar* dest_identifier,
                                           ImportResult _result_);
VALA_EXTERN void background_import_job_report_error (BackgroundImportJob* self,
                                         BatchImportJob* job,
                                         GFile* file,
                                         const gchar* src_identifier,
                                         const gchar* dest_identifier,
                                         GError* err,
                                         ImportResult default_result);
static void background_import_job_finalize (BackgroundJob * obj);
static GType background_import_job_get_type_once (void);
VALA_EXTERN FileToPrepare* file_to_prepare_new (BatchImportJob* job,
                                    GFile* file,
                                    gboolean copy_to_library);
VALA_EXTERN FileToPrepare* file_to_prepare_construct (GType object_type,
                                          BatchImportJob* job,
                                          GFile* file,
                                          gboolean copy_to_library);
VALA_EXTERN void file_to_prepare_set_associated (FileToPrepare* self,
                                     FileToPrepare* a);
VALA_EXTERN gchar* file_to_prepare_get_parent_path (FileToPrepare* self);
VALA_EXTERN gchar* file_to_prepare_get_path (FileToPrepare* self);
VALA_EXTERN gchar* file_to_prepare_get_basename (FileToPrepare* self);
VALA_EXTERN gboolean file_to_prepare_is_directory (FileToPrepare* self);
static void file_to_prepare_finalize (FileToPrepare * obj);
static GType file_to_prepare_get_type_once (void);
static void work_sniffer_real_execute (BackgroundJob* base);
static void work_sniffer_sniff_job (WorkSniffer* self,
                             BatchImportJob* job,
                             GError** error);
static gint __lambda16_ (WorkSniffer* self,
                  FileToPrepare* a,
                  FileToPrepare* b);
static gint ___lambda16__gcompare_data_func (gconstpointer a,
                                      gconstpointer b,
                                      gpointer self);
static gboolean work_sniffer_is_paired (WorkSniffer* self,
                                 FileToPrepare* raw,
                                 FileToPrepare* maybe_paired);
VALA_EXTERN void work_sniffer_search_dir (WorkSniffer* self,
                              BatchImportJob* job,
                              GFile* dir,
                              gboolean copy_to_library,
                              GError** error);
static void work_sniffer_finalize (BackgroundJob * obj);
static GType work_sniffer_get_type_once (void);
VALA_EXTERN PreparedFile* prepared_file_new (BatchImportJob* job,
                                 GFile* file,
                                 GFile* associated_file,
                                 const gchar* source_id,
                                 const gchar* dest_id,
                                 gboolean copy_to_library,
                                 const gchar* exif_md5,
                                 const gchar* thumbnail_md5,
                                 const gchar* full_md5,
                                 PhotoFileFormat file_format,
                                 guint64 filesize,
                                 gboolean is_video);
VALA_EXTERN PreparedFile* prepared_file_construct (GType object_type,
                                       BatchImportJob* job,
                                       GFile* file,
                                       GFile* associated_file,
                                       const gchar* source_id,
                                       const gchar* dest_id,
                                       gboolean copy_to_library,
                                       const gchar* exif_md5,
                                       const gchar* thumbnail_md5,
                                       const gchar* full_md5,
                                       PhotoFileFormat file_format,
                                       guint64 filesize,
                                       gboolean is_video);
static void prepared_file_finalize (PreparedFile * obj);
static GType prepared_file_get_type_once (void);
VALA_EXTERN PreparedFileCluster* prepared_file_cluster_new (GeeArrayList* list);
VALA_EXTERN PreparedFileCluster* prepared_file_cluster_construct (GType object_type,
                                                      GeeArrayList* list);
static void prepared_file_cluster_finalize (NotificationObject * obj);
static GType prepared_file_cluster_get_type_once (void);
VALA_EXTERN GFile* app_dirs_get_import_dir (void);
static gint prepare_files_job_get_test_variable (const gchar* name);
static void prepare_files_job_real_execute (BackgroundJob* base);
static gboolean prepare_files_job_create_file (PrepareFilesJob* self,
                                        BatchImportJob* job,
                                        GFile** file,
                                        gboolean* copy_to_library);
static ImportResult prepare_files_job_prepare_file (PrepareFilesJob* self,
                                             BatchImportJob* job,
                                             GFile* file,
                                             GFile* associated_file,
                                             gboolean copy_to_library,
                                             PreparedFile** prepared_file);
static void prepare_files_job_finalize (BackgroundJob * obj);
static GType prepare_files_job_get_type_once (void);
VALA_EXTERN ReadyForImport* ready_for_import_new (GFile* final_file,
                                      PreparedFile* prepared_file,
                                      PhotoImportParams* photo_import_params,
                                      VideoImportParams* video_import_params,
                                      BatchImportResult* batch_result);
VALA_EXTERN ReadyForImport* ready_for_import_construct (GType object_type,
                                            GFile* final_file,
                                            PreparedFile* prepared_file,
                                            PhotoImportParams* photo_import_params,
                                            VideoImportParams* video_import_params,
                                            BatchImportResult* batch_result);
static void ready_for_import_finalize (ReadyForImport * obj);
static GType ready_for_import_get_type_once (void);
static void prepared_file_import_job_real_execute (BackgroundJob* base);
VALA_EXTERN GFile* library_files_duplicate (GFile* src,
                                GFileProgressCallback progress_callback,
                                gpointer progress_callback_target,
                                gboolean blacklist,
                                GError** error);
static void prepared_file_import_job_finalize (BackgroundJob * obj);
static GType prepared_file_import_job_get_type_once (void);
static void completed_import_object_finalize (CompletedImportObject * obj);
static GType completed_import_object_get_type_once (void);
static void thumbnail_writer_job_real_execute (BackgroundJob* base);
static void thumbnail_writer_job_finalize (BackgroundJob * obj);
static GType thumbnail_writer_job_get_type_once (void);

gchar*
import_result_to_string (ImportResult self)
{
	gchar* result;
	switch (self) {
		case IMPORT_RESULT_SUCCESS:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("Success"));
			result = _tmp0_;
			return result;
		}
		case IMPORT_RESULT_FILE_ERROR:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("File error"));
			result = _tmp1_;
			return result;
		}
		case IMPORT_RESULT_DECODE_ERROR:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("Unable to decode file"));
			result = _tmp2_;
			return result;
		}
		case IMPORT_RESULT_DATABASE_ERROR:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("Database error"));
			result = _tmp3_;
			return result;
		}
		case IMPORT_RESULT_USER_ABORT:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup (_ ("User aborted import"));
			result = _tmp4_;
			return result;
		}
		case IMPORT_RESULT_NOT_A_FILE:
		{
			gchar* _tmp5_;
			_tmp5_ = g_strdup (_ ("Not a file"));
			result = _tmp5_;
			return result;
		}
		case IMPORT_RESULT_PHOTO_EXISTS:
		{
			gchar* _tmp6_;
			_tmp6_ = g_strdup (_ ("File already exists in database"));
			result = _tmp6_;
			return result;
		}
		case IMPORT_RESULT_UNSUPPORTED_FORMAT:
		{
			gchar* _tmp7_;
			_tmp7_ = g_strdup (_ ("Unsupported file format"));
			result = _tmp7_;
			return result;
		}
		case IMPORT_RESULT_NOT_AN_IMAGE:
		{
			gchar* _tmp8_;
			_tmp8_ = g_strdup (_ ("Not an image file"));
			result = _tmp8_;
			return result;
		}
		case IMPORT_RESULT_DISK_FAILURE:
		{
			gchar* _tmp9_;
			_tmp9_ = g_strdup (_ ("Disk failure"));
			result = _tmp9_;
			return result;
		}
		case IMPORT_RESULT_DISK_FULL:
		{
			gchar* _tmp10_;
			_tmp10_ = g_strdup (_ ("Disk full"));
			result = _tmp10_;
			return result;
		}
		case IMPORT_RESULT_CAMERA_ERROR:
		{
			gchar* _tmp11_;
			_tmp11_ = g_strdup (_ ("Camera error"));
			result = _tmp11_;
			return result;
		}
		case IMPORT_RESULT_FILE_WRITE_ERROR:
		{
			gchar* _tmp12_;
			_tmp12_ = g_strdup (_ ("File write error"));
			result = _tmp12_;
			return result;
		}
		case IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE:
		{
			gchar* _tmp13_;
			_tmp13_ = g_strdup (_ ("Corrupt image file"));
			result = _tmp13_;
			return result;
		}
		default:
		{
			gchar* _tmp14_;
			_tmp14_ = g_strdup_printf (_ ("Imported failed (%d)"), (gint) self);
			result = _tmp14_;
			return result;
		}
	}
}

gboolean
import_result_is_abort (ImportResult self)
{
	gboolean result;
	switch (self) {
		case IMPORT_RESULT_DISK_FULL:
		case IMPORT_RESULT_DISK_FAILURE:
		case IMPORT_RESULT_USER_ABORT:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

gboolean
import_result_is_nonuser_abort (ImportResult self)
{
	gboolean result;
	switch (self) {
		case IMPORT_RESULT_DISK_FULL:
		case IMPORT_RESULT_DISK_FAILURE:
		{
			result = TRUE;
			return result;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

ImportResult
import_result_convert_error (GError* err,
                             ImportResult default_result)
{
	ImportResult result;
	g_return_val_if_fail (err != NULL, 0);
	if (err->domain == G_FILE_ERROR) {
		GError* ferr = NULL;
		GError* _tmp0_;
		GError* _tmp1_;
		_tmp0_ = _g_error_copy0 ((GError*) err);
		ferr = _tmp0_;
		_tmp1_ = ferr;
		if (g_error_matches (_tmp1_, G_FILE_ERROR, G_FILE_ERROR_NOSPC)) {
			result = IMPORT_RESULT_DISK_FULL;
			_g_error_free0 (ferr);
			return result;
		} else {
			GError* _tmp2_;
			_tmp2_ = ferr;
			if (g_error_matches (_tmp2_, G_FILE_ERROR, G_FILE_ERROR_IO)) {
				result = IMPORT_RESULT_DISK_FAILURE;
				_g_error_free0 (ferr);
				return result;
			} else {
				GError* _tmp3_;
				_tmp3_ = ferr;
				if (g_error_matches (_tmp3_, G_FILE_ERROR, G_FILE_ERROR_ISDIR)) {
					result = IMPORT_RESULT_NOT_A_FILE;
					_g_error_free0 (ferr);
					return result;
				} else {
					GError* _tmp4_;
					_tmp4_ = ferr;
					if (g_error_matches (_tmp4_, G_FILE_ERROR, G_FILE_ERROR_ACCES)) {
						result = IMPORT_RESULT_FILE_WRITE_ERROR;
						_g_error_free0 (ferr);
						return result;
					} else {
						GError* _tmp5_;
						_tmp5_ = ferr;
						if (g_error_matches (_tmp5_, G_FILE_ERROR, G_FILE_ERROR_PERM)) {
							result = IMPORT_RESULT_FILE_WRITE_ERROR;
							_g_error_free0 (ferr);
							return result;
						} else {
							result = IMPORT_RESULT_FILE_ERROR;
							_g_error_free0 (ferr);
							return result;
						}
					}
				}
			}
		}
		_g_error_free0 (ferr);
	} else {
		if (err->domain == G_IO_ERROR) {
			GError* ioerr = NULL;
			GError* _tmp6_;
			GError* _tmp7_;
			_tmp6_ = _g_error_copy0 ((GError*) err);
			ioerr = _tmp6_;
			_tmp7_ = ioerr;
			if (g_error_matches (_tmp7_, G_IO_ERROR, G_IO_ERROR_NO_SPACE)) {
				result = IMPORT_RESULT_DISK_FULL;
				_g_error_free0 (ioerr);
				return result;
			} else {
				GError* _tmp8_;
				_tmp8_ = ioerr;
				if (g_error_matches (_tmp8_, G_IO_ERROR, G_IO_ERROR_FAILED)) {
					result = IMPORT_RESULT_DISK_FAILURE;
					_g_error_free0 (ioerr);
					return result;
				} else {
					GError* _tmp9_;
					_tmp9_ = ioerr;
					if (g_error_matches (_tmp9_, G_IO_ERROR, G_IO_ERROR_IS_DIRECTORY)) {
						result = IMPORT_RESULT_NOT_A_FILE;
						_g_error_free0 (ioerr);
						return result;
					} else {
						GError* _tmp10_;
						_tmp10_ = ioerr;
						if (g_error_matches (_tmp10_, G_IO_ERROR, G_IO_ERROR_CANCELLED)) {
							result = IMPORT_RESULT_USER_ABORT;
							_g_error_free0 (ioerr);
							return result;
						} else {
							GError* _tmp11_;
							_tmp11_ = ioerr;
							if (g_error_matches (_tmp11_, G_IO_ERROR, G_IO_ERROR_READ_ONLY)) {
								result = IMPORT_RESULT_FILE_WRITE_ERROR;
								_g_error_free0 (ioerr);
								return result;
							} else {
								GError* _tmp12_;
								_tmp12_ = ioerr;
								if (g_error_matches (_tmp12_, G_IO_ERROR, G_IO_ERROR_PERMISSION_DENIED)) {
									result = IMPORT_RESULT_FILE_WRITE_ERROR;
									_g_error_free0 (ioerr);
									return result;
								} else {
									result = IMPORT_RESULT_FILE_ERROR;
									_g_error_free0 (ioerr);
									return result;
								}
							}
						}
					}
				}
			}
			_g_error_free0 (ioerr);
		} else {
			if (err->domain == GPHOTO_ERROR) {
				result = IMPORT_RESULT_CAMERA_ERROR;
				return result;
			} else {
				if (err->domain == GDK_PIXBUF_ERROR) {
					GError* pixbuferr = NULL;
					GError* _tmp13_;
					GError* _tmp14_;
					_tmp13_ = _g_error_copy0 ((GError*) err);
					pixbuferr = _tmp13_;
					_tmp14_ = pixbuferr;
					if (g_error_matches (_tmp14_, GDK_PIXBUF_ERROR, GDK_PIXBUF_ERROR_CORRUPT_IMAGE)) {
						result = IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE;
						_g_error_free0 (pixbuferr);
						return result;
					} else {
						GError* _tmp15_;
						_tmp15_ = pixbuferr;
						if (g_error_matches (_tmp15_, GDK_PIXBUF_ERROR, GDK_PIXBUF_ERROR_INSUFFICIENT_MEMORY)) {
							result = default_result;
							_g_error_free0 (pixbuferr);
							return result;
						} else {
							GError* _tmp16_;
							_tmp16_ = pixbuferr;
							if (g_error_matches (_tmp16_, GDK_PIXBUF_ERROR, GDK_PIXBUF_ERROR_BAD_OPTION)) {
								result = default_result;
								_g_error_free0 (pixbuferr);
								return result;
							} else {
								GError* _tmp17_;
								_tmp17_ = pixbuferr;
								if (g_error_matches (_tmp17_, GDK_PIXBUF_ERROR, GDK_PIXBUF_ERROR_UNKNOWN_TYPE)) {
									result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
									_g_error_free0 (pixbuferr);
									return result;
								} else {
									GError* _tmp18_;
									_tmp18_ = pixbuferr;
									if (g_error_matches (_tmp18_, GDK_PIXBUF_ERROR, GDK_PIXBUF_ERROR_UNSUPPORTED_OPERATION)) {
										result = default_result;
										_g_error_free0 (pixbuferr);
										return result;
									} else {
										GError* _tmp19_;
										_tmp19_ = pixbuferr;
										if (g_error_matches (_tmp19_, GDK_PIXBUF_ERROR, GDK_PIXBUF_ERROR_FAILED)) {
											result = default_result;
											_g_error_free0 (pixbuferr);
											return result;
										} else {
											result = default_result;
											_g_error_free0 (pixbuferr);
											return result;
										}
									}
								}
							}
						}
					}
					_g_error_free0 (pixbuferr);
				}
			}
		}
	}
	result = default_result;
	return result;
}

static GType
import_result_get_type_once (void)
{
	static const GEnumValue values[] = {{IMPORT_RESULT_SUCCESS, "IMPORT_RESULT_SUCCESS", "success"}, {IMPORT_RESULT_FILE_ERROR, "IMPORT_RESULT_FILE_ERROR", "file-error"}, {IMPORT_RESULT_DECODE_ERROR, "IMPORT_RESULT_DECODE_ERROR", "decode-error"}, {IMPORT_RESULT_DATABASE_ERROR, "IMPORT_RESULT_DATABASE_ERROR", "database-error"}, {IMPORT_RESULT_USER_ABORT, "IMPORT_RESULT_USER_ABORT", "user-abort"}, {IMPORT_RESULT_NOT_A_FILE, "IMPORT_RESULT_NOT_A_FILE", "not-a-file"}, {IMPORT_RESULT_PHOTO_EXISTS, "IMPORT_RESULT_PHOTO_EXISTS", "photo-exists"}, {IMPORT_RESULT_UNSUPPORTED_FORMAT, "IMPORT_RESULT_UNSUPPORTED_FORMAT", "unsupported-format"}, {IMPORT_RESULT_NOT_AN_IMAGE, "IMPORT_RESULT_NOT_AN_IMAGE", "not-an-image"}, {IMPORT_RESULT_DISK_FAILURE, "IMPORT_RESULT_DISK_FAILURE", "disk-failure"}, {IMPORT_RESULT_DISK_FULL, "IMPORT_RESULT_DISK_FULL", "disk-full"}, {IMPORT_RESULT_CAMERA_ERROR, "IMPORT_RESULT_CAMERA_ERROR", "camera-error"}, {IMPORT_RESULT_FILE_WRITE_ERROR, "IMPORT_RESULT_FILE_WRITE_ERROR", "file-write-error"}, {IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE, "IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE", "pixbuf-corrupt-image"}, {0, NULL, NULL}};
	GType import_result_type_id;
	import_result_type_id = g_enum_register_static ("ImportResult", values);
	return import_result_type_id;
}

GType
import_result_get_type (void)
{
	static volatile gsize import_result_type_id__once = 0;
	if (g_once_init_enter (&import_result_type_id__once)) {
		GType import_result_type_id;
		import_result_type_id = import_result_get_type_once ();
		g_once_init_leave (&import_result_type_id__once, import_result_type_id);
	}
	return import_result_type_id__once;
}

static gchar*
batch_import_job_real_get_dest_identifier (BatchImportJob* self)
{
	g_critical ("Type `%s' does not implement abstract method `batch_import_job_get_dest_identifier'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
batch_import_job_get_dest_identifier (BatchImportJob* self)
{
	BatchImportJobClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BATCH_IMPORT_JOB_GET_CLASS (self);
	if (_klass_->get_dest_identifier) {
		return _klass_->get_dest_identifier (self);
	}
	return NULL;
}

static gchar*
batch_import_job_real_get_source_identifier (BatchImportJob* self)
{
	g_critical ("Type `%s' does not implement abstract method `batch_import_job_get_source_identifier'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
batch_import_job_get_source_identifier (BatchImportJob* self)
{
	BatchImportJobClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BATCH_IMPORT_JOB_GET_CLASS (self);
	if (_klass_->get_source_identifier) {
		return _klass_->get_source_identifier (self);
	}
	return NULL;
}

static gboolean
batch_import_job_real_is_directory (BatchImportJob* self)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `batch_import_job_is_directory'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
batch_import_job_is_directory (BatchImportJob* self)
{
	BatchImportJobClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BATCH_IMPORT_JOB_GET_CLASS (self);
	if (_klass_->is_directory) {
		return _klass_->is_directory (self);
	}
	return FALSE;
}

static gchar*
batch_import_job_real_get_basename (BatchImportJob* self)
{
	g_critical ("Type `%s' does not implement abstract method `batch_import_job_get_basename'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
batch_import_job_get_basename (BatchImportJob* self)
{
	BatchImportJobClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BATCH_IMPORT_JOB_GET_CLASS (self);
	if (_klass_->get_basename) {
		return _klass_->get_basename (self);
	}
	return NULL;
}

static gchar*
batch_import_job_real_get_path (BatchImportJob* self)
{
	g_critical ("Type `%s' does not implement abstract method `batch_import_job_get_path'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
batch_import_job_get_path (BatchImportJob* self)
{
	BatchImportJobClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BATCH_IMPORT_JOB_GET_CLASS (self);
	if (_klass_->get_path) {
		return _klass_->get_path (self);
	}
	return NULL;
}

static DuplicatedFile*
batch_import_job_real_get_duplicated_file (BatchImportJob* self)
{
	DuplicatedFile* result;
	result = NULL;
	return result;
}

DuplicatedFile*
batch_import_job_get_duplicated_file (BatchImportJob* self)
{
	BatchImportJobClass* _klass_;
	g_return_val_if_fail (self != NULL, NULL);
	_klass_ = BATCH_IMPORT_JOB_GET_CLASS (self);
	if (_klass_->get_duplicated_file) {
		return _klass_->get_duplicated_file (self);
	}
	return NULL;
}

static void
batch_import_job_real_set_associated (BatchImportJob* self,
                                      BatchImportJob* associated)
{
	g_critical ("Type `%s' does not implement abstract method `batch_import_job_set_associated'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
batch_import_job_set_associated (BatchImportJob* self,
                                 BatchImportJob* associated)
{
	BatchImportJobClass* _klass_;
	g_return_if_fail (self != NULL);
	_klass_ = BATCH_IMPORT_JOB_GET_CLASS (self);
	if (_klass_->set_associated) {
		_klass_->set_associated (self, associated);
	}
}

static gboolean
batch_import_job_real_determine_file_size (BatchImportJob* self,
                                           guint64* filesize,
                                           GFile** file_or_dir)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `batch_import_job_determine_file_size'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
batch_import_job_determine_file_size (BatchImportJob* self,
                                      guint64* filesize,
                                      GFile** file_or_dir)
{
	BatchImportJobClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BATCH_IMPORT_JOB_GET_CLASS (self);
	if (_klass_->determine_file_size) {
		return _klass_->determine_file_size (self, filesize, file_or_dir);
	}
	return FALSE;
}

static gboolean
batch_import_job_real_prepare (BatchImportJob* self,
                               GFile** file_to_import,
                               gboolean* copy_to_library,
                               GError** error)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `batch_import_job_prepare'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
batch_import_job_prepare (BatchImportJob* self,
                          GFile** file_to_import,
                          gboolean* copy_to_library,
                          GError** error)
{
	BatchImportJobClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BATCH_IMPORT_JOB_GET_CLASS (self);
	if (_klass_->prepare) {
		return _klass_->prepare (self, file_to_import, copy_to_library, error);
	}
	return FALSE;
}

static gboolean
batch_import_job_real_complete (BatchImportJob* self,
                                MediaSource* source,
                                BatchImportRoll* import_roll,
                                GError** error)
{
	gboolean result;
	g_return_val_if_fail (source != NULL, FALSE);
	g_return_val_if_fail (import_roll != NULL, FALSE);
	result = FALSE;
	return result;
}

gboolean
batch_import_job_complete (BatchImportJob* self,
                           MediaSource* source,
                           BatchImportRoll* import_roll,
                           GError** error)
{
	BatchImportJobClass* _klass_;
	g_return_val_if_fail (self != NULL, FALSE);
	_klass_ = BATCH_IMPORT_JOB_GET_CLASS (self);
	if (_klass_->complete) {
		return _klass_->complete (self, source, import_roll, error);
	}
	return FALSE;
}

static gint64
batch_import_job_real_get_exposure_time_override (BatchImportJob* self)
{
	gint64 result;
	result = (gint64) 0;
	return result;
}

gint64
batch_import_job_get_exposure_time_override (BatchImportJob* self)
{
	BatchImportJobClass* _klass_;
	g_return_val_if_fail (self != NULL, 0LL);
	_klass_ = BATCH_IMPORT_JOB_GET_CLASS (self);
	if (_klass_->get_exposure_time_override) {
		return _klass_->get_exposure_time_override (self);
	}
	return -1LL;
}

BatchImportJob*
batch_import_job_construct (GType object_type)
{
	BatchImportJob* self = NULL;
	self = (BatchImportJob*) g_type_create_instance (object_type);
	return self;
}

static void
value_batch_import_job_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_batch_import_job_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		batch_import_job_unref (value->data[0].v_pointer);
	}
}

static void
value_batch_import_job_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = batch_import_job_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_batch_import_job_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_batch_import_job_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BatchImportJob * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = batch_import_job_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_batch_import_job_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	BatchImportJob ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = batch_import_job_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_batch_import_job (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecBatchImportJob* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BATCH_IMPORT_JOB), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_batch_import_job (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BATCH_IMPORT_JOB), NULL);
	return value->data[0].v_pointer;
}

void
value_set_batch_import_job (GValue* value,
                            gpointer v_object)
{
	BatchImportJob * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BATCH_IMPORT_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BATCH_IMPORT_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		batch_import_job_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		batch_import_job_unref (old);
	}
}

void
value_take_batch_import_job (GValue* value,
                             gpointer v_object)
{
	BatchImportJob * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BATCH_IMPORT_JOB));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BATCH_IMPORT_JOB));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		batch_import_job_unref (old);
	}
}

static void
batch_import_job_class_init (BatchImportJobClass * klass,
                             gpointer klass_data)
{
	batch_import_job_parent_class = g_type_class_peek_parent (klass);
	((BatchImportJobClass *) klass)->finalize = batch_import_job_finalize;
	((BatchImportJobClass *) klass)->get_dest_identifier = (gchar* (*) (BatchImportJob*)) batch_import_job_real_get_dest_identifier;
	((BatchImportJobClass *) klass)->get_source_identifier = (gchar* (*) (BatchImportJob*)) batch_import_job_real_get_source_identifier;
	((BatchImportJobClass *) klass)->is_directory = (gboolean (*) (BatchImportJob*)) batch_import_job_real_is_directory;
	((BatchImportJobClass *) klass)->get_basename = (gchar* (*) (BatchImportJob*)) batch_import_job_real_get_basename;
	((BatchImportJobClass *) klass)->get_path = (gchar* (*) (BatchImportJob*)) batch_import_job_real_get_path;
	((BatchImportJobClass *) klass)->get_duplicated_file = (DuplicatedFile* (*) (BatchImportJob*)) batch_import_job_real_get_duplicated_file;
	((BatchImportJobClass *) klass)->set_associated = (void (*) (BatchImportJob*, BatchImportJob*)) batch_import_job_real_set_associated;
	((BatchImportJobClass *) klass)->determine_file_size = (gboolean (*) (BatchImportJob*, guint64*, GFile**)) batch_import_job_real_determine_file_size;
	((BatchImportJobClass *) klass)->prepare = (gboolean (*) (BatchImportJob*, GFile**, gboolean*, GError**)) batch_import_job_real_prepare;
	((BatchImportJobClass *) klass)->complete = (gboolean (*) (BatchImportJob*, MediaSource*, BatchImportRoll*, GError**)) batch_import_job_real_complete;
	((BatchImportJobClass *) klass)->get_exposure_time_override = (gint64 (*) (BatchImportJob*)) batch_import_job_real_get_exposure_time_override;
}

static void
batch_import_job_instance_init (BatchImportJob * self,
                                gpointer klass)
{
	self->ref_count = 1;
}

static void
batch_import_job_finalize (BatchImportJob * obj)
{
	BatchImportJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BATCH_IMPORT_JOB, BatchImportJob);
	g_signal_handlers_destroy (self);
}

static GType
batch_import_job_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_batch_import_job_init, value_batch_import_job_free_value, value_batch_import_job_copy_value, value_batch_import_job_peek_pointer, "p", value_batch_import_job_collect_value, "p", value_batch_import_job_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BatchImportJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) batch_import_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BatchImportJob), 0, (GInstanceInitFunc) batch_import_job_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType batch_import_job_type_id;
	batch_import_job_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BatchImportJob", &g_define_type_info, &g_define_type_fundamental_info, G_TYPE_FLAG_ABSTRACT);
	return batch_import_job_type_id;
}

GType
batch_import_job_get_type (void)
{
	static volatile gsize batch_import_job_type_id__once = 0;
	if (g_once_init_enter (&batch_import_job_type_id__once)) {
		GType batch_import_job_type_id;
		batch_import_job_type_id = batch_import_job_get_type_once ();
		g_once_init_leave (&batch_import_job_type_id__once, batch_import_job_type_id);
	}
	return batch_import_job_type_id__once;
}

gpointer
batch_import_job_ref (gpointer instance)
{
	BatchImportJob * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
batch_import_job_unref (gpointer instance)
{
	BatchImportJob * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BATCH_IMPORT_JOB_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
file_import_job_get_instance_private (FileImportJob* self)
{
	return G_STRUCT_MEMBER_P (self, FileImportJob_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FileImportJob*
file_import_job_construct (GType object_type,
                           GFile* file_or_dir,
                           gboolean copy_to_library)
{
	FileImportJob* self = NULL;
	GFile* _tmp0_;
	g_return_val_if_fail (file_or_dir != NULL, NULL);
	self = (FileImportJob*) batch_import_job_construct (object_type);
	_tmp0_ = _g_object_ref0 (file_or_dir);
	_g_object_unref0 (self->priv->file_or_dir);
	self->priv->file_or_dir = _tmp0_;
	self->priv->copy_to_library = copy_to_library;
	return self;
}

FileImportJob*
file_import_job_new (GFile* file_or_dir,
                     gboolean copy_to_library)
{
	return file_import_job_construct (TYPE_FILE_IMPORT_JOB, file_or_dir, copy_to_library);
}

static gchar*
file_import_job_real_get_dest_identifier (BatchImportJob* base)
{
	FileImportJob * self;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FileImportJob*) base;
	_tmp0_ = self->priv->file_or_dir;
	_tmp1_ = g_file_get_path (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
file_import_job_real_get_source_identifier (BatchImportJob* base)
{
	FileImportJob * self;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FileImportJob*) base;
	_tmp0_ = self->priv->file_or_dir;
	_tmp1_ = g_file_get_path (_tmp0_);
	result = _tmp1_;
	return result;
}

static gboolean
file_import_job_real_is_directory (BatchImportJob* base)
{
	FileImportJob * self;
	GFile* _tmp0_;
	gboolean result;
	self = (FileImportJob*) base;
	_tmp0_ = self->priv->file_or_dir;
	result = query_is_directory (_tmp0_);
	return result;
}

static gchar*
file_import_job_real_get_basename (BatchImportJob* base)
{
	FileImportJob * self;
	GFile* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	self = (FileImportJob*) base;
	_tmp0_ = self->priv->file_or_dir;
	_tmp1_ = g_file_get_basename (_tmp0_);
	result = _tmp1_;
	return result;
}

static gchar*
file_import_job_real_get_path (BatchImportJob* base)
{
	FileImportJob * self;
	gchar* _tmp0_ = NULL;
	gchar* result;
	self = (FileImportJob*) base;
	if (batch_import_job_is_directory ((BatchImportJob*) self)) {
		GFile* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->file_or_dir;
		_tmp2_ = g_file_get_path (_tmp1_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp2_;
	} else {
		GFile* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		gchar* _tmp6_;
		_tmp3_ = self->priv->file_or_dir;
		_tmp4_ = g_file_get_parent (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_file_get_path (_tmp5_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp6_;
		_g_object_unref0 (_tmp5_);
	}
	result = _tmp0_;
	return result;
}

static gpointer
_batch_import_job_ref0 (gpointer self)
{
	return self ? batch_import_job_ref (self) : NULL;
}

static void
file_import_job_real_set_associated (BatchImportJob* base,
                                     BatchImportJob* associated)
{
	FileImportJob * self;
	FileImportJob* _tmp0_;
	self = (FileImportJob*) base;
	g_return_if_fail (associated != NULL);
	_tmp0_ = _batch_import_job_ref0 (IS_FILE_IMPORT_JOB (associated) ? ((FileImportJob*) associated) : NULL);
	_batch_import_job_unref0 (self->priv->associated);
	self->priv->associated = _tmp0_;
}

static gboolean
file_import_job_real_determine_file_size (BatchImportJob* base,
                                          guint64* filesize,
                                          GFile** file)
{
	FileImportJob * self;
	guint64 _vala_filesize = 0ULL;
	GFile* _vala_file = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean result;
	self = (FileImportJob*) base;
	_vala_filesize = (guint64) 0;
	_tmp0_ = self->priv->file_or_dir;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_vala_file);
	_vala_file = _tmp1_;
	result = FALSE;
	if (filesize) {
		*filesize = _vala_filesize;
	}
	if (file) {
		*file = _vala_file;
	} else {
		_g_object_unref0 (_vala_file);
	}
	return result;
}

static gboolean
file_import_job_real_prepare (BatchImportJob* base,
                              GFile** file_to_import,
                              gboolean* copy,
                              GError** error)
{
	FileImportJob * self;
	GFile* _vala_file_to_import = NULL;
	gboolean _vala_copy = FALSE;
	GFile* _tmp0_;
	GFile* _tmp1_;
	gboolean result;
	self = (FileImportJob*) base;
	_tmp0_ = self->priv->file_or_dir;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_vala_file_to_import);
	_vala_file_to_import = _tmp1_;
	_vala_copy = self->priv->copy_to_library;
	result = TRUE;
	if (file_to_import) {
		*file_to_import = _vala_file_to_import;
	} else {
		_g_object_unref0 (_vala_file_to_import);
	}
	if (copy) {
		*copy = _vala_copy;
	}
	return result;
}

GFile*
file_import_job_get_file (FileImportJob* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file_or_dir;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	result = _tmp1_;
	return result;
}

static void
file_import_job_class_init (FileImportJobClass * klass,
                            gpointer klass_data)
{
	file_import_job_parent_class = g_type_class_peek_parent (klass);
	((BatchImportJobClass *) klass)->finalize = file_import_job_finalize;
	g_type_class_adjust_private_offset (klass, &FileImportJob_private_offset);
	((BatchImportJobClass *) klass)->get_dest_identifier = (gchar* (*) (BatchImportJob*)) file_import_job_real_get_dest_identifier;
	((BatchImportJobClass *) klass)->get_source_identifier = (gchar* (*) (BatchImportJob*)) file_import_job_real_get_source_identifier;
	((BatchImportJobClass *) klass)->is_directory = (gboolean (*) (BatchImportJob*)) file_import_job_real_is_directory;
	((BatchImportJobClass *) klass)->get_basename = (gchar* (*) (BatchImportJob*)) file_import_job_real_get_basename;
	((BatchImportJobClass *) klass)->get_path = (gchar* (*) (BatchImportJob*)) file_import_job_real_get_path;
	((BatchImportJobClass *) klass)->set_associated = (void (*) (BatchImportJob*, BatchImportJob*)) file_import_job_real_set_associated;
	((BatchImportJobClass *) klass)->determine_file_size = (gboolean (*) (BatchImportJob*, guint64*, GFile**)) file_import_job_real_determine_file_size;
	((BatchImportJobClass *) klass)->prepare = (gboolean (*) (BatchImportJob*, GFile**, gboolean*, GError**)) file_import_job_real_prepare;
}

static void
file_import_job_instance_init (FileImportJob * self,
                               gpointer klass)
{
	self->priv = file_import_job_get_instance_private (self);
	self->priv->associated = NULL;
}

static void
file_import_job_finalize (BatchImportJob * obj)
{
	FileImportJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_IMPORT_JOB, FileImportJob);
	_g_object_unref0 (self->priv->file_or_dir);
	_batch_import_job_unref0 (self->priv->associated);
	BATCH_IMPORT_JOB_CLASS (file_import_job_parent_class)->finalize (obj);
}

static GType
file_import_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FileImportJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_import_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileImportJob), 0, (GInstanceInitFunc) file_import_job_instance_init, NULL };
	GType file_import_job_type_id;
	file_import_job_type_id = g_type_register_static (TYPE_BATCH_IMPORT_JOB, "FileImportJob", &g_define_type_info, 0);
	FileImportJob_private_offset = g_type_add_instance_private (file_import_job_type_id, sizeof (FileImportJobPrivate));
	return file_import_job_type_id;
}

GType
file_import_job_get_type (void)
{
	static volatile gsize file_import_job_type_id__once = 0;
	if (g_once_init_enter (&file_import_job_type_id__once)) {
		GType file_import_job_type_id;
		file_import_job_type_id = file_import_job_get_type_once ();
		g_once_init_leave (&file_import_job_type_id__once, file_import_job_type_id);
	}
	return file_import_job_type_id__once;
}

BatchImportRoll*
batch_import_roll_construct (GType object_type)
{
	BatchImportRoll* self = NULL;
	ImportID _tmp0_ = {0};
	self = (BatchImportRoll*) g_type_create_instance (object_type);
	import_id_generate (&_tmp0_);
	self->import_id = _tmp0_;
	return self;
}

BatchImportRoll*
batch_import_roll_new (void)
{
	return batch_import_roll_construct (TYPE_BATCH_IMPORT_ROLL);
}

static void
value_batch_import_roll_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_batch_import_roll_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		batch_import_roll_unref (value->data[0].v_pointer);
	}
}

static void
value_batch_import_roll_copy_value (const GValue* src_value,
                                    GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = batch_import_roll_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_batch_import_roll_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_batch_import_roll_collect_value (GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BatchImportRoll * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = batch_import_roll_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_batch_import_roll_lcopy_value (const GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	BatchImportRoll ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = batch_import_roll_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_batch_import_roll (const gchar* name,
                              const gchar* nick,
                              const gchar* blurb,
                              GType object_type,
                              GParamFlags flags)
{
	ParamSpecBatchImportRoll* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BATCH_IMPORT_ROLL), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_batch_import_roll (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BATCH_IMPORT_ROLL), NULL);
	return value->data[0].v_pointer;
}

void
value_set_batch_import_roll (GValue* value,
                             gpointer v_object)
{
	BatchImportRoll * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BATCH_IMPORT_ROLL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BATCH_IMPORT_ROLL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		batch_import_roll_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		batch_import_roll_unref (old);
	}
}

void
value_take_batch_import_roll (GValue* value,
                              gpointer v_object)
{
	BatchImportRoll * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BATCH_IMPORT_ROLL));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BATCH_IMPORT_ROLL));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		batch_import_roll_unref (old);
	}
}

static void
batch_import_roll_class_init (BatchImportRollClass * klass,
                              gpointer klass_data)
{
	batch_import_roll_parent_class = g_type_class_peek_parent (klass);
	((BatchImportRollClass *) klass)->finalize = batch_import_roll_finalize;
}

static void
batch_import_roll_instance_init (BatchImportRoll * self,
                                 gpointer klass)
{
	ViewCollection* _tmp0_;
	_tmp0_ = view_collection_new ("BatchImportRoll generated events");
	self->generated_events = _tmp0_;
	self->ref_count = 1;
}

static void
batch_import_roll_finalize (BatchImportRoll * obj)
{
	BatchImportRoll * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BATCH_IMPORT_ROLL, BatchImportRoll);
	g_signal_handlers_destroy (self);
	_data_collection_unref0 (self->generated_events);
}

static GType
batch_import_roll_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_batch_import_roll_init, value_batch_import_roll_free_value, value_batch_import_roll_copy_value, value_batch_import_roll_peek_pointer, "p", value_batch_import_roll_collect_value, "p", value_batch_import_roll_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BatchImportRollClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) batch_import_roll_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BatchImportRoll), 0, (GInstanceInitFunc) batch_import_roll_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType batch_import_roll_type_id;
	batch_import_roll_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BatchImportRoll", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return batch_import_roll_type_id;
}

GType
batch_import_roll_get_type (void)
{
	static volatile gsize batch_import_roll_type_id__once = 0;
	if (g_once_init_enter (&batch_import_roll_type_id__once)) {
		GType batch_import_roll_type_id;
		batch_import_roll_type_id = batch_import_roll_get_type_once ();
		g_once_init_leave (&batch_import_roll_type_id__once, batch_import_roll_type_id);
	}
	return batch_import_roll_type_id__once;
}

gpointer
batch_import_roll_ref (gpointer instance)
{
	BatchImportRoll * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
batch_import_roll_unref (gpointer instance)
{
	BatchImportRoll * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BATCH_IMPORT_ROLL_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

BatchImportResult*
batch_import_result_construct (GType object_type,
                               BatchImportJob* job,
                               GFile* file,
                               const gchar* src_identifier,
                               const gchar* dest_identifier,
                               DuplicatedFile* duplicate_of,
                               ImportResult _result_)
{
	BatchImportResult* self = NULL;
	BatchImportJob* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	DuplicatedFile* _tmp4_;
	g_return_val_if_fail (job != NULL, NULL);
	g_return_val_if_fail (src_identifier != NULL, NULL);
	g_return_val_if_fail (dest_identifier != NULL, NULL);
	self = (BatchImportResult*) g_type_create_instance (object_type);
	_tmp0_ = _batch_import_job_ref0 (job);
	_batch_import_job_unref0 (self->job);
	self->job = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp1_;
	_tmp2_ = g_strdup (src_identifier);
	_g_free0 (self->src_identifier);
	self->src_identifier = _tmp2_;
	_tmp3_ = g_strdup (dest_identifier);
	_g_free0 (self->dest_identifier);
	self->dest_identifier = _tmp3_;
	_tmp4_ = _g_object_ref0 (duplicate_of);
	_g_object_unref0 (self->duplicate_of);
	self->duplicate_of = _tmp4_;
	self->result = _result_;
	return self;
}

BatchImportResult*
batch_import_result_new (BatchImportJob* job,
                         GFile* file,
                         const gchar* src_identifier,
                         const gchar* dest_identifier,
                         DuplicatedFile* duplicate_of,
                         ImportResult _result_)
{
	return batch_import_result_construct (TYPE_BATCH_IMPORT_RESULT, job, file, src_identifier, dest_identifier, duplicate_of, _result_);
}

BatchImportResult*
batch_import_result_construct_from_error (GType object_type,
                                          BatchImportJob* job,
                                          GFile* file,
                                          const gchar* src_identifier,
                                          const gchar* dest_identifier,
                                          GError* err,
                                          ImportResult default_result)
{
	BatchImportResult* self = NULL;
	BatchImportJob* _tmp0_;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	g_return_val_if_fail (job != NULL, NULL);
	g_return_val_if_fail (src_identifier != NULL, NULL);
	g_return_val_if_fail (dest_identifier != NULL, NULL);
	g_return_val_if_fail (err != NULL, NULL);
	self = (BatchImportResult*) g_type_create_instance (object_type);
	_tmp0_ = _batch_import_job_ref0 (job);
	_batch_import_job_unref0 (self->job);
	self->job = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp1_;
	_tmp2_ = g_strdup (src_identifier);
	_g_free0 (self->src_identifier);
	self->src_identifier = _tmp2_;
	_tmp3_ = g_strdup (dest_identifier);
	_g_free0 (self->dest_identifier);
	self->dest_identifier = _tmp3_;
	self->result = import_result_convert_error (err, default_result);
	_tmp4_ = err->message;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 (self->errmsg);
	self->errmsg = _tmp5_;
	return self;
}

BatchImportResult*
batch_import_result_new_from_error (BatchImportJob* job,
                                    GFile* file,
                                    const gchar* src_identifier,
                                    const gchar* dest_identifier,
                                    GError* err,
                                    ImportResult default_result)
{
	return batch_import_result_construct_from_error (TYPE_BATCH_IMPORT_RESULT, job, file, src_identifier, dest_identifier, err, default_result);
}

static void
value_batch_import_result_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_batch_import_result_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		batch_import_result_unref (value->data[0].v_pointer);
	}
}

static void
value_batch_import_result_copy_value (const GValue* src_value,
                                      GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = batch_import_result_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_batch_import_result_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_batch_import_result_collect_value (GValue* value,
                                         guint n_collect_values,
                                         GTypeCValue* collect_values,
                                         guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		BatchImportResult * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = batch_import_result_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_batch_import_result_lcopy_value (const GValue* value,
                                       guint n_collect_values,
                                       GTypeCValue* collect_values,
                                       guint collect_flags)
{
	BatchImportResult ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = batch_import_result_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_batch_import_result (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags)
{
	ParamSpecBatchImportResult* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_BATCH_IMPORT_RESULT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_batch_import_result (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BATCH_IMPORT_RESULT), NULL);
	return value->data[0].v_pointer;
}

void
value_set_batch_import_result (GValue* value,
                               gpointer v_object)
{
	BatchImportResult * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BATCH_IMPORT_RESULT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BATCH_IMPORT_RESULT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		batch_import_result_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		batch_import_result_unref (old);
	}
}

void
value_take_batch_import_result (GValue* value,
                                gpointer v_object)
{
	BatchImportResult * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_BATCH_IMPORT_RESULT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_BATCH_IMPORT_RESULT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		batch_import_result_unref (old);
	}
}

static void
batch_import_result_class_init (BatchImportResultClass * klass,
                                gpointer klass_data)
{
	batch_import_result_parent_class = g_type_class_peek_parent (klass);
	((BatchImportResultClass *) klass)->finalize = batch_import_result_finalize;
}

static void
batch_import_result_instance_init (BatchImportResult * self,
                                   gpointer klass)
{
	self->errmsg = NULL;
	self->ref_count = 1;
}

static void
batch_import_result_finalize (BatchImportResult * obj)
{
	BatchImportResult * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BATCH_IMPORT_RESULT, BatchImportResult);
	g_signal_handlers_destroy (self);
	_batch_import_job_unref0 (self->job);
	_g_object_unref0 (self->file);
	_g_free0 (self->src_identifier);
	_g_free0 (self->dest_identifier);
	_g_free0 (self->errmsg);
	_g_object_unref0 (self->duplicate_of);
}

static GType
batch_import_result_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_batch_import_result_init, value_batch_import_result_free_value, value_batch_import_result_copy_value, value_batch_import_result_peek_pointer, "p", value_batch_import_result_collect_value, "p", value_batch_import_result_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (BatchImportResultClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) batch_import_result_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BatchImportResult), 0, (GInstanceInitFunc) batch_import_result_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType batch_import_result_type_id;
	batch_import_result_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BatchImportResult", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return batch_import_result_type_id;
}

GType
batch_import_result_get_type (void)
{
	static volatile gsize batch_import_result_type_id__once = 0;
	if (g_once_init_enter (&batch_import_result_type_id__once)) {
		GType batch_import_result_type_id;
		batch_import_result_type_id = batch_import_result_get_type_once ();
		g_once_init_leave (&batch_import_result_type_id__once, batch_import_result_type_id);
	}
	return batch_import_result_type_id__once;
}

gpointer
batch_import_result_ref (gpointer instance)
{
	BatchImportResult * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
batch_import_result_unref (gpointer instance)
{
	BatchImportResult * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BATCH_IMPORT_RESULT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

ImportManifest*
import_manifest_construct (GType object_type,
                           GeeList* prefailed,
                           GeeList* pre_already_imported)
{
	ImportManifest* self = NULL;
	self = (ImportManifest*) g_type_create_instance (object_type);
	if (prefailed != NULL) {
		{
			GeeList* _job_list = NULL;
			gint _job_size = 0;
			GeeList* _tmp0_;
			gint _tmp1_;
			gint _tmp2_;
			gint _job_index = 0;
			_job_list = prefailed;
			_tmp0_ = _job_list;
			_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
			_tmp2_ = _tmp1_;
			_job_size = _tmp2_;
			_job_index = -1;
			while (TRUE) {
				gint _tmp3_;
				gint _tmp4_;
				BatchImportJob* job = NULL;
				GeeList* _tmp5_;
				gpointer _tmp6_;
				BatchImportResult* batch_result = NULL;
				BatchImportJob* _tmp7_;
				BatchImportJob* _tmp8_;
				gchar* _tmp9_;
				gchar* _tmp10_;
				BatchImportJob* _tmp11_;
				gchar* _tmp12_;
				gchar* _tmp13_;
				BatchImportResult* _tmp14_;
				BatchImportResult* _tmp15_;
				BatchImportResult* _tmp16_;
				_job_index = _job_index + 1;
				_tmp3_ = _job_index;
				_tmp4_ = _job_size;
				if (!(_tmp3_ < _tmp4_)) {
					break;
				}
				_tmp5_ = _job_list;
				_tmp6_ = gee_list_get (_tmp5_, _job_index);
				job = (BatchImportJob*) _tmp6_;
				_tmp7_ = job;
				_tmp8_ = job;
				_tmp9_ = batch_import_job_get_source_identifier (_tmp8_);
				_tmp10_ = _tmp9_;
				_tmp11_ = job;
				_tmp12_ = batch_import_job_get_dest_identifier (_tmp11_);
				_tmp13_ = _tmp12_;
				_tmp14_ = batch_import_result_new (_tmp7_, NULL, _tmp10_, _tmp13_, NULL, IMPORT_RESULT_FILE_ERROR);
				_tmp15_ = _tmp14_;
				_g_free0 (_tmp13_);
				_g_free0 (_tmp10_);
				batch_result = _tmp15_;
				_tmp16_ = batch_result;
				import_manifest_add_result (self, _tmp16_);
				_batch_import_result_unref0 (batch_result);
				_batch_import_job_unref0 (job);
			}
		}
	}
	if (pre_already_imported != NULL) {
		{
			GeeList* _job_list = NULL;
			gint _job_size = 0;
			GeeList* _tmp17_;
			gint _tmp18_;
			gint _tmp19_;
			gint _job_index = 0;
			_job_list = pre_already_imported;
			_tmp17_ = _job_list;
			_tmp18_ = gee_collection_get_size ((GeeCollection*) _tmp17_);
			_tmp19_ = _tmp18_;
			_job_size = _tmp19_;
			_job_index = -1;
			while (TRUE) {
				gint _tmp20_;
				gint _tmp21_;
				BatchImportJob* job = NULL;
				GeeList* _tmp22_;
				gpointer _tmp23_;
				BatchImportResult* batch_result = NULL;
				BatchImportJob* _tmp24_;
				BatchImportJob* _tmp25_;
				gchar* _tmp26_;
				gchar* _tmp27_;
				GFile* _tmp28_;
				GFile* _tmp29_;
				BatchImportJob* _tmp30_;
				gchar* _tmp31_;
				gchar* _tmp32_;
				BatchImportJob* _tmp33_;
				gchar* _tmp34_;
				gchar* _tmp35_;
				BatchImportJob* _tmp36_;
				DuplicatedFile* _tmp37_;
				DuplicatedFile* _tmp38_;
				BatchImportResult* _tmp39_;
				BatchImportResult* _tmp40_;
				BatchImportResult* _tmp41_;
				_job_index = _job_index + 1;
				_tmp20_ = _job_index;
				_tmp21_ = _job_size;
				if (!(_tmp20_ < _tmp21_)) {
					break;
				}
				_tmp22_ = _job_list;
				_tmp23_ = gee_list_get (_tmp22_, _job_index);
				job = (BatchImportJob*) _tmp23_;
				_tmp24_ = job;
				_tmp25_ = job;
				_tmp26_ = batch_import_job_get_basename (_tmp25_);
				_tmp27_ = _tmp26_;
				_tmp28_ = g_file_new_for_path (_tmp27_);
				_tmp29_ = _tmp28_;
				_tmp30_ = job;
				_tmp31_ = batch_import_job_get_source_identifier (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = job;
				_tmp34_ = batch_import_job_get_dest_identifier (_tmp33_);
				_tmp35_ = _tmp34_;
				_tmp36_ = job;
				_tmp37_ = batch_import_job_get_duplicated_file (_tmp36_);
				_tmp38_ = _tmp37_;
				_tmp39_ = batch_import_result_new (_tmp24_, _tmp29_, _tmp32_, _tmp35_, _tmp38_, IMPORT_RESULT_PHOTO_EXISTS);
				_tmp40_ = _tmp39_;
				_g_object_unref0 (_tmp38_);
				_g_free0 (_tmp35_);
				_g_free0 (_tmp32_);
				_g_object_unref0 (_tmp29_);
				_g_free0 (_tmp27_);
				batch_result = _tmp40_;
				_tmp41_ = batch_result;
				import_manifest_add_result (self, _tmp41_);
				_batch_import_result_unref0 (batch_result);
				_batch_import_job_unref0 (job);
			}
		}
	}
	return self;
}

ImportManifest*
import_manifest_new (GeeList* prefailed,
                     GeeList* pre_already_imported)
{
	return import_manifest_construct (TYPE_IMPORT_MANIFEST, prefailed, pre_already_imported);
}

void
import_manifest_add_result (ImportManifest* self,
                            BatchImportResult* batch_result)
{
	gboolean reported = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (batch_result != NULL);
	reported = TRUE;
	switch (batch_result->result) {
		case IMPORT_RESULT_SUCCESS:
		{
			GeeList* _tmp0_;
			_tmp0_ = self->success;
			gee_collection_add ((GeeCollection*) _tmp0_, batch_result);
			break;
		}
		case IMPORT_RESULT_USER_ABORT:
		{
			gboolean _tmp1_ = FALSE;
			GFile* _tmp2_;
			_tmp2_ = batch_result->file;
			if (_tmp2_ != NULL) {
				GFile* _tmp3_;
				_tmp3_ = batch_result->file;
				_tmp1_ = !query_is_directory (_tmp3_);
			} else {
				_tmp1_ = FALSE;
			}
			if (_tmp1_) {
				GeeList* _tmp4_;
				_tmp4_ = self->aborted;
				gee_collection_add ((GeeCollection*) _tmp4_, batch_result);
			} else {
				reported = FALSE;
			}
			break;
		}
		case IMPORT_RESULT_UNSUPPORTED_FORMAT:
		{
			GeeList* _tmp5_;
			_tmp5_ = self->skipped_photos;
			gee_collection_add ((GeeCollection*) _tmp5_, batch_result);
			break;
		}
		case IMPORT_RESULT_NOT_A_FILE:
		case IMPORT_RESULT_NOT_AN_IMAGE:
		{
			GeeList* _tmp6_;
			_tmp6_ = self->skipped_files;
			gee_collection_add ((GeeCollection*) _tmp6_, batch_result);
			break;
		}
		case IMPORT_RESULT_PHOTO_EXISTS:
		{
			GeeList* _tmp7_;
			_tmp7_ = self->already_imported;
			gee_collection_add ((GeeCollection*) _tmp7_, batch_result);
			break;
		}
		case IMPORT_RESULT_CAMERA_ERROR:
		{
			GeeList* _tmp8_;
			_tmp8_ = self->camera_failed;
			gee_collection_add ((GeeCollection*) _tmp8_, batch_result);
			break;
		}
		case IMPORT_RESULT_FILE_WRITE_ERROR:
		{
			GeeList* _tmp9_;
			_tmp9_ = self->write_failed;
			gee_collection_add ((GeeCollection*) _tmp9_, batch_result);
			break;
		}
		case IMPORT_RESULT_PIXBUF_CORRUPT_IMAGE:
		{
			GeeList* _tmp10_;
			_tmp10_ = self->corrupt_files;
			gee_collection_add ((GeeCollection*) _tmp10_, batch_result);
			break;
		}
		default:
		{
			GeeList* _tmp11_;
			_tmp11_ = self->failed;
			gee_collection_add ((GeeCollection*) _tmp11_, batch_result);
			break;
		}
	}
	if (reported) {
		GeeList* _tmp12_;
		_tmp12_ = self->all;
		gee_collection_add ((GeeCollection*) _tmp12_, batch_result);
	}
}

static void
value_import_manifest_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_import_manifest_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		import_manifest_unref (value->data[0].v_pointer);
	}
}

static void
value_import_manifest_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = import_manifest_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_import_manifest_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_import_manifest_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ImportManifest * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = import_manifest_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_import_manifest_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	ImportManifest ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = import_manifest_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_import_manifest (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecImportManifest* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_IMPORT_MANIFEST), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_import_manifest (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IMPORT_MANIFEST), NULL);
	return value->data[0].v_pointer;
}

void
value_set_import_manifest (GValue* value,
                           gpointer v_object)
{
	ImportManifest * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IMPORT_MANIFEST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IMPORT_MANIFEST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		import_manifest_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		import_manifest_unref (old);
	}
}

void
value_take_import_manifest (GValue* value,
                            gpointer v_object)
{
	ImportManifest * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_IMPORT_MANIFEST));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_IMPORT_MANIFEST));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		import_manifest_unref (old);
	}
}

static void
import_manifest_class_init (ImportManifestClass * klass,
                            gpointer klass_data)
{
	import_manifest_parent_class = g_type_class_peek_parent (klass);
	((ImportManifestClass *) klass)->finalize = import_manifest_finalize;
}

static void
import_manifest_instance_init (ImportManifest * self,
                               gpointer klass)
{
	GeeArrayList* _tmp0_;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp2_;
	GeeArrayList* _tmp3_;
	GeeArrayList* _tmp4_;
	GeeArrayList* _tmp5_;
	GeeArrayList* _tmp6_;
	GeeArrayList* _tmp7_;
	GeeArrayList* _tmp8_;
	GeeArrayList* _tmp9_;
	GeeArrayList* _tmp10_;
	_tmp0_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	self->imported = (GeeList*) _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_BATCH_IMPORT_RESULT, (GBoxedCopyFunc) batch_import_result_ref, (GDestroyNotify) batch_import_result_unref, NULL, NULL, NULL);
	self->success = (GeeList*) _tmp1_;
	_tmp2_ = gee_array_list_new (TYPE_BATCH_IMPORT_RESULT, (GBoxedCopyFunc) batch_import_result_ref, (GDestroyNotify) batch_import_result_unref, NULL, NULL, NULL);
	self->camera_failed = (GeeList*) _tmp2_;
	_tmp3_ = gee_array_list_new (TYPE_BATCH_IMPORT_RESULT, (GBoxedCopyFunc) batch_import_result_ref, (GDestroyNotify) batch_import_result_unref, NULL, NULL, NULL);
	self->failed = (GeeList*) _tmp3_;
	_tmp4_ = gee_array_list_new (TYPE_BATCH_IMPORT_RESULT, (GBoxedCopyFunc) batch_import_result_ref, (GDestroyNotify) batch_import_result_unref, NULL, NULL, NULL);
	self->write_failed = (GeeList*) _tmp4_;
	_tmp5_ = gee_array_list_new (TYPE_BATCH_IMPORT_RESULT, (GBoxedCopyFunc) batch_import_result_ref, (GDestroyNotify) batch_import_result_unref, NULL, NULL, NULL);
	self->skipped_photos = (GeeList*) _tmp5_;
	_tmp6_ = gee_array_list_new (TYPE_BATCH_IMPORT_RESULT, (GBoxedCopyFunc) batch_import_result_ref, (GDestroyNotify) batch_import_result_unref, NULL, NULL, NULL);
	self->skipped_files = (GeeList*) _tmp6_;
	_tmp7_ = gee_array_list_new (TYPE_BATCH_IMPORT_RESULT, (GBoxedCopyFunc) batch_import_result_ref, (GDestroyNotify) batch_import_result_unref, NULL, NULL, NULL);
	self->aborted = (GeeList*) _tmp7_;
	_tmp8_ = gee_array_list_new (TYPE_BATCH_IMPORT_RESULT, (GBoxedCopyFunc) batch_import_result_ref, (GDestroyNotify) batch_import_result_unref, NULL, NULL, NULL);
	self->already_imported = (GeeList*) _tmp8_;
	_tmp9_ = gee_array_list_new (TYPE_BATCH_IMPORT_RESULT, (GBoxedCopyFunc) batch_import_result_ref, (GDestroyNotify) batch_import_result_unref, NULL, NULL, NULL);
	self->corrupt_files = (GeeList*) _tmp9_;
	_tmp10_ = gee_array_list_new (TYPE_BATCH_IMPORT_RESULT, (GBoxedCopyFunc) batch_import_result_ref, (GDestroyNotify) batch_import_result_unref, NULL, NULL, NULL);
	self->all = (GeeList*) _tmp10_;
	self->ref_count = 1;
}

static void
import_manifest_finalize (ImportManifest * obj)
{
	ImportManifest * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_IMPORT_MANIFEST, ImportManifest);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->imported);
	_g_object_unref0 (self->success);
	_g_object_unref0 (self->camera_failed);
	_g_object_unref0 (self->failed);
	_g_object_unref0 (self->write_failed);
	_g_object_unref0 (self->skipped_photos);
	_g_object_unref0 (self->skipped_files);
	_g_object_unref0 (self->aborted);
	_g_object_unref0 (self->already_imported);
	_g_object_unref0 (self->corrupt_files);
	_g_object_unref0 (self->all);
}

static GType
import_manifest_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_import_manifest_init, value_import_manifest_free_value, value_import_manifest_copy_value, value_import_manifest_peek_pointer, "p", value_import_manifest_collect_value, "p", value_import_manifest_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ImportManifestClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) import_manifest_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ImportManifest), 0, (GInstanceInitFunc) import_manifest_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType import_manifest_type_id;
	import_manifest_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ImportManifest", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return import_manifest_type_id;
}

GType
import_manifest_get_type (void)
{
	static volatile gsize import_manifest_type_id__once = 0;
	if (g_once_init_enter (&import_manifest_type_id__once)) {
		GType import_manifest_type_id;
		import_manifest_type_id = import_manifest_get_type_once ();
		g_once_init_leave (&import_manifest_type_id__once, import_manifest_type_id);
	}
	return import_manifest_type_id__once;
}

gpointer
import_manifest_ref (gpointer instance)
{
	ImportManifest * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
import_manifest_unref (gpointer instance)
{
	ImportManifest * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		IMPORT_MANIFEST_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
batch_import_get_instance_private (BatchImport* self)
{
	return G_STRUCT_MEMBER_P (self, BatchImport_private_offset);
}

static void
_batch_import_user_halt_photos_application_exiting (PhotosApplication* _sender,
                                                    gboolean panicked,
                                                    gpointer self)
{
	batch_import_user_halt ((BatchImport*) self);
}

static gpointer
_batch_import_roll_ref0 (gpointer self)
{
	return self ? batch_import_roll_ref (self) : NULL;
}

static guint
_file_hash_gee_hash_data_func (gconstpointer v,
                               gpointer self)
{
	guint result;
	result = file_hash ((GFile*) v);
	return result;
}

static gboolean
_file_equal_gee_equal_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gboolean result;
	result = file_equal ((GFile*) a, (GFile*) b);
	return result;
}

static gboolean
_batch_import_display_imported_timer_gsource_func (gpointer self)
{
	gboolean result;
	result = batch_import_display_imported_timer ((BatchImport*) self);
	return result;
}

BatchImport*
batch_import_construct (GType object_type,
                        GeeIterable* jobs,
                        const gchar* name,
                        BatchImportImportReporter reporter,
                        gpointer reporter_target,
                        GeeArrayList* prefailed,
                        GeeArrayList* pre_already_imported,
                        GCancellable* cancellable,
                        BatchImportRoll* import_roll,
                        ImportManifest* skip_manifest)
{
	BatchImport * self = NULL;
	GeeIterable* _tmp0_;
	gchar* _tmp1_;
	ImportManifest* _tmp2_;
	GCancellable* _tmp3_ = NULL;
	GCancellable* _tmp6_;
	BatchImportRoll* _tmp7_ = NULL;
	BatchImportRoll* _tmp10_;
	GApplication* _tmp24_;
	g_return_val_if_fail (jobs != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (BatchImport*) g_object_new (object_type, NULL);
	_tmp0_ = _g_object_ref0 (jobs);
	_g_object_unref0 (self->priv->jobs);
	self->priv->jobs = _tmp0_;
	_tmp1_ = g_strdup (name);
	_g_free0 (self->priv->name);
	self->priv->name = _tmp1_;
	self->priv->reporter = reporter;
	self->priv->reporter_target = reporter_target;
	_tmp2_ = import_manifest_new ((GeeList*) prefailed, (GeeList*) pre_already_imported);
	_import_manifest_unref0 (self->priv->manifest);
	self->priv->manifest = _tmp2_;
	if (cancellable != NULL) {
		GCancellable* _tmp4_;
		_tmp4_ = _g_object_ref0 (cancellable);
		_g_object_unref0 (_tmp3_);
		_tmp3_ = _tmp4_;
	} else {
		GCancellable* _tmp5_;
		_tmp5_ = g_cancellable_new ();
		_g_object_unref0 (_tmp3_);
		_tmp3_ = _tmp5_;
	}
	_tmp6_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->cancellable);
	self->priv->cancellable = _tmp6_;
	if (import_roll != NULL) {
		BatchImportRoll* _tmp8_;
		_tmp8_ = _batch_import_roll_ref0 (import_roll);
		_batch_import_roll_unref0 (_tmp7_);
		_tmp7_ = _tmp8_;
	} else {
		BatchImportRoll* _tmp9_;
		_tmp9_ = batch_import_roll_new ();
		_batch_import_roll_unref0 (_tmp7_);
		_tmp7_ = _tmp9_;
	}
	_tmp10_ = _batch_import_roll_ref0 (_tmp7_);
	_batch_import_roll_unref0 (self->priv->import_roll);
	self->priv->import_roll = _tmp10_;
	if (skip_manifest != NULL) {
		GeeHashSet* _tmp11_;
		_tmp11_ = gee_hash_set_new (g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, _file_hash_gee_hash_data_func, NULL, NULL, _file_equal_gee_equal_data_func, NULL, NULL);
		_g_object_unref0 (self->priv->skipset);
		self->priv->skipset = _tmp11_;
		{
			GeeList* _source_list = NULL;
			GeeList* _tmp12_;
			gint _source_size = 0;
			GeeList* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
			gint _source_index = 0;
			_tmp12_ = skip_manifest->imported;
			_source_list = _tmp12_;
			_tmp13_ = _source_list;
			_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
			_tmp15_ = _tmp14_;
			_source_size = _tmp15_;
			_source_index = -1;
			while (TRUE) {
				gint _tmp16_;
				gint _tmp17_;
				MediaSource* source = NULL;
				GeeList* _tmp18_;
				gpointer _tmp19_;
				GeeHashSet* _tmp20_;
				MediaSource* _tmp21_;
				GFile* _tmp22_;
				GFile* _tmp23_;
				_source_index = _source_index + 1;
				_tmp16_ = _source_index;
				_tmp17_ = _source_size;
				if (!(_tmp16_ < _tmp17_)) {
					break;
				}
				_tmp18_ = _source_list;
				_tmp19_ = gee_list_get (_tmp18_, _source_index);
				source = (MediaSource*) _tmp19_;
				_tmp20_ = self->priv->skipset;
				_tmp21_ = source;
				_tmp22_ = media_source_get_file (_tmp21_);
				_tmp23_ = _tmp22_;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp23_);
				_g_object_unref0 (_tmp23_);
				_g_object_unref0 (source);
			}
		}
	}
	_tmp24_ = g_application_get_default ();
	g_signal_connect_object (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, PHOTOS_TYPE_APPLICATION, PhotosApplication), "exiting", (GCallback) _batch_import_user_halt_photos_application_exiting, self, 0);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BATCH_IMPORT_DISPLAY_QUEUE_TIMER_MSEC, _batch_import_display_imported_timer_gsource_func, g_object_ref (self), g_object_unref);
	_batch_import_roll_unref0 (_tmp7_);
	_g_object_unref0 (_tmp3_);
	return self;
}

BatchImport*
batch_import_new (GeeIterable* jobs,
                  const gchar* name,
                  BatchImportImportReporter reporter,
                  gpointer reporter_target,
                  GeeArrayList* prefailed,
                  GeeArrayList* pre_already_imported,
                  GCancellable* cancellable,
                  BatchImportRoll* import_roll,
                  ImportManifest* skip_manifest)
{
	return batch_import_construct (TYPE_BATCH_IMPORT, jobs, name, reporter, reporter_target, prefailed, pre_already_imported, cancellable, import_roll, skip_manifest);
}

gchar*
batch_import_get_name (BatchImport* self)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->name;
	_tmp1_ = g_strdup (_tmp0_);
	result = _tmp1_;
	return result;
}

void
batch_import_user_halt (BatchImport* self)
{
	GCancellable* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->cancellable;
	g_cancellable_cancel (_tmp0_);
}

gboolean
batch_import_get_untrash_duplicates (BatchImport* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->untrash_duplicates;
	return result;
}

void
batch_import_set_untrash_duplicates (BatchImport* self,
                                     gboolean untrash_duplicates)
{
	g_return_if_fail (self != NULL);
	self->priv->untrash_duplicates = untrash_duplicates;
}

gboolean
batch_import_get_mark_duplicates_online (BatchImport* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->mark_duplicates_online;
	return result;
}

void
batch_import_set_mark_duplicates_online (BatchImport* self,
                                         gboolean mark_duplicates_online)
{
	g_return_if_fail (self != NULL);
	self->priv->mark_duplicates_online = mark_duplicates_online;
}

static void
batch_import_log_status (BatchImport* self,
                         const gchar* where)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (where != NULL);
}

static gboolean
batch_import_report_failure (BatchImport* self,
                             BatchImportResult* import_result)
{
	gboolean proceed = FALSE;
	ImportManifest* _tmp0_;
	gboolean _tmp11_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (import_result != NULL, FALSE);
	proceed = TRUE;
	_tmp0_ = self->priv->manifest;
	import_manifest_add_result (_tmp0_, import_result);
	if (import_result->result != IMPORT_RESULT_SUCCESS) {
		gboolean _tmp1_ = FALSE;
		GFile* _tmp2_;
		g_signal_emit (self, batch_import_signals[BATCH_IMPORT_IMPORT_JOB_FAILED_SIGNAL], 0, import_result);
		_tmp2_ = import_result->file;
		if (_tmp2_ != NULL) {
			_tmp1_ = !import_result_is_abort (import_result->result);
		} else {
			_tmp1_ = FALSE;
		}
		if (_tmp1_) {
			guint64 filesize = 0ULL;
			filesize = (guint64) 0;
			{
				guint64 _tmp3_ = 0ULL;
				GFile* _tmp4_;
				_tmp4_ = import_result->file;
				_tmp3_ = query_total_file_size (_tmp4_, NULL, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
				filesize = _tmp3_;
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				GFile* _tmp5_;
				gchar* _tmp6_;
				gchar* _tmp7_;
				GError* _tmp8_;
				const gchar* _tmp9_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp5_ = import_result->file;
				_tmp6_ = g_file_get_path (_tmp5_);
				_tmp7_ = _tmp6_;
				_tmp8_ = err;
				_tmp9_ = _tmp8_->message;
				g_warning ("BatchImport.vala:577: Unable to query file size of %s: %s", _tmp7_, _tmp9_);
				_g_free0 (_tmp7_);
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				gboolean _tmp10_ = FALSE;
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return _tmp10_;
			}
			batch_import_report_progress (self, filesize);
		}
	}
	if (import_result_is_nonuser_abort (import_result->result)) {
		_tmp11_ = proceed;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		const gchar* _tmp12_;
		_tmp12_ = import_result->errmsg;
		g_signal_emit (self, batch_import_signals[BATCH_IMPORT_FATAL_ERROR_SIGNAL], 0, import_result->result, _tmp12_);
		proceed = FALSE;
	}
	result = proceed;
	return result;
}

static void
batch_import_report_progress (BatchImport* self,
                              guint64 increment_of_progress)
{
	g_return_if_fail (self != NULL);
	self->priv->completed_bytes = self->priv->completed_bytes + increment_of_progress;
	if (self->priv->completed_bytes == ((guint64) 0)) {
		gint64 now = 0LL;
		now = now_ms ();
		if ((now - self->priv->last_preparing_ms) > ((gint64) 250)) {
			self->priv->last_preparing_ms = now;
			g_signal_emit (self, batch_import_signals[BATCH_IMPORT_PREPARING_SIGNAL], 0);
		}
	} else {
		if (increment_of_progress > ((guint64) 0)) {
			gint64 now = 0LL;
			now = now_ms ();
			if ((now - self->priv->last_preparing_ms) > ((gint64) 250)) {
				self->priv->last_preparing_ms = now;
				g_signal_emit (self, batch_import_signals[BATCH_IMPORT_PROGRESS_SIGNAL], 0, self->priv->completed_bytes, self->priv->total_bytes);
			}
		}
	}
}

static gboolean
batch_import_report_failures (BatchImport* self,
                              BackgroundImportJob* background_job)
{
	gboolean proceed = FALSE;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (background_job != NULL, FALSE);
	proceed = TRUE;
	{
		GeeList* _import_result_list = NULL;
		GeeList* _tmp0_;
		gint _import_result_size = 0;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		gint _import_result_index = 0;
		_tmp0_ = background_job->failed;
		_import_result_list = _tmp0_;
		_tmp1_ = _import_result_list;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		_import_result_size = _tmp3_;
		_import_result_index = -1;
		while (TRUE) {
			gint _tmp4_;
			gint _tmp5_;
			BatchImportResult* import_result = NULL;
			GeeList* _tmp6_;
			gpointer _tmp7_;
			BatchImportResult* _tmp8_;
			_import_result_index = _import_result_index + 1;
			_tmp4_ = _import_result_index;
			_tmp5_ = _import_result_size;
			if (!(_tmp4_ < _tmp5_)) {
				break;
			}
			_tmp6_ = _import_result_list;
			_tmp7_ = gee_list_get (_tmp6_, _import_result_index);
			import_result = (BatchImportResult*) _tmp7_;
			_tmp8_ = import_result;
			if (!batch_import_report_failure (self, _tmp8_)) {
				proceed = FALSE;
			}
			_batch_import_result_unref0 (import_result);
		}
	}
	result = proceed;
	return result;
}

static void
batch_import_report_completed (BatchImport* self,
                               const gchar* where)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	BatchImportImportReporter _tmp2_;
	gpointer _tmp2__target;
	ImportManifest* _tmp6_;
	BatchImportRoll* _tmp7_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (where != NULL);
	if (self->priv->completed) {
		g_error ("BatchImport.vala:627: Attempted to complete already-completed import: " \
"%s", where);
	}
	self->priv->completed = TRUE;
	batch_import_flush_ready_sources (self);
	_tmp0_ = g_strdup_printf ("Import completed: %s", where);
	_tmp1_ = _tmp0_;
	batch_import_log_status (self, _tmp1_);
	_g_free0 (_tmp1_);
	_tmp2_ = self->priv->reporter;
	_tmp2__target = self->priv->reporter_target;
	if (_tmp2_ != NULL) {
		BatchImportImportReporter _tmp3_;
		gpointer _tmp3__target;
		ImportManifest* _tmp4_;
		BatchImportRoll* _tmp5_;
		_tmp3_ = self->priv->reporter;
		_tmp3__target = self->priv->reporter_target;
		_tmp4_ = self->priv->manifest;
		_tmp5_ = self->priv->import_roll;
		_tmp3_ (_tmp4_, _tmp5_, _tmp3__target);
	}
	_tmp6_ = self->priv->manifest;
	_tmp7_ = self->priv->import_roll;
	g_signal_emit (self, batch_import_signals[BATCH_IMPORT_IMPORT_COMPLETE_SIGNAL], 0, _tmp6_, _tmp7_);
}

static void
batch_import_file_import_complete (BatchImport* self)
{
	gint _tmp0_;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->file_imports_completed;
	self->priv->file_imports_completed = _tmp0_ + 1;
	if (self->priv->file_imports_to_perform != -1) {
		_vala_assert (self->priv->file_imports_completed <= self->priv->file_imports_to_perform, "file_imports_completed <= file_imports_to_perform");
	}
	if (self->priv->file_imports_to_perform != -1) {
		_tmp1_ = self->priv->file_imports_completed == self->priv->file_imports_to_perform;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		batch_import_report_completed (self, "completed preparing files, all outstanding imports completed");
	}
}

static void
_batch_import_on_work_sniffed_out_completion_callback (BackgroundJob* job,
                                                       gpointer self)
{
	batch_import_on_work_sniffed_out ((BatchImport*) self, job);
}

static void
_batch_import_on_sniffer_cancelled_cancellation_callback (BackgroundJob* job,
                                                          gpointer self)
{
	batch_import_on_sniffer_cancelled ((BatchImport*) self, job);
}

static gboolean
_batch_import_on_sniffer_working_gsource_func (gpointer self)
{
	gboolean result;
	result = batch_import_on_sniffer_working ((BatchImport*) self);
	return result;
}

void
batch_import_schedule (BatchImport* self)
{
	Workers* _tmp0_;
	GeeIterable* _tmp1_;
	GCancellable* _tmp2_;
	GeeHashSet* _tmp3_;
	WorkSniffer* _tmp4_;
	WorkSniffer* _tmp5_;
	g_return_if_fail (self != NULL);
	_vala_assert (self->priv->scheduled == FALSE, "scheduled == false");
	self->priv->scheduled = TRUE;
	g_signal_emit (self, batch_import_signals[BATCH_IMPORT_STARTING_SIGNAL], 0);
	_tmp0_ = batch_import_feeder_workers;
	_tmp1_ = self->priv->jobs;
	_tmp2_ = self->priv->cancellable;
	_tmp3_ = self->priv->skipset;
	_tmp4_ = work_sniffer_new (self, _tmp1_, _batch_import_on_work_sniffed_out_completion_callback, self, _tmp2_, _batch_import_on_sniffer_cancelled_cancellation_callback, self, _tmp3_);
	_tmp5_ = _tmp4_;
	workers_enqueue (_tmp0_, (BackgroundJob*) _tmp5_);
	_background_job_unref0 (_tmp5_);
	self->priv->throbber_id = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) BATCH_IMPORT_WORK_SNIFFER_THROBBER_MSEC, _batch_import_on_sniffer_working_gsource_func, g_object_ref (self), g_object_unref);
}

static gboolean
batch_import_on_sniffer_working (BatchImport* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	batch_import_report_progress (self, (guint64) 0);
	result = TRUE;
	return result;
}

static gpointer
_background_job_ref0 (gpointer self)
{
	return self ? background_job_ref (self) : NULL;
}

static void
_batch_import_on_file_prepared_notification_callback (BackgroundJob* job,
                                                      NotificationObject* user,
                                                      gpointer self)
{
	batch_import_on_file_prepared ((BatchImport*) self, job, user);
}

static void
_batch_import_on_files_prepared_completion_callback (BackgroundJob* job,
                                                     gpointer self)
{
	batch_import_on_files_prepared ((BatchImport*) self, job);
}

static void
_batch_import_on_file_prepare_cancelled_cancellation_callback (BackgroundJob* job,
                                                               gpointer self)
{
	batch_import_on_file_prepare_cancelled ((BatchImport*) self, job);
}

static void
batch_import_on_work_sniffed_out (BatchImport* self,
                                  BackgroundJob* j)
{
	WorkSniffer* sniffer = NULL;
	WorkSniffer* _tmp0_;
	gboolean _tmp1_ = FALSE;
	WorkSniffer* _tmp2_;
	WorkSniffer* _tmp7_;
	PrepareFilesJob* prepare_files_job = NULL;
	WorkSniffer* _tmp8_;
	GeeList* _tmp9_;
	GCancellable* _tmp10_;
	PrepareFilesJob* _tmp11_;
	Workers* _tmp12_;
	PrepareFilesJob* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	_vala_assert (!self->priv->completed, "!completed");
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, TYPE_WORK_SNIFFER, WorkSniffer));
	sniffer = _tmp0_;
	batch_import_log_status (self, "on_work_sniffed_out");
	_tmp2_ = sniffer;
	if (!batch_import_report_failures (self, (BackgroundImportJob*) _tmp2_)) {
		_tmp1_ = TRUE;
	} else {
		WorkSniffer* _tmp3_;
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp3_ = sniffer;
		_tmp4_ = _tmp3_->files_to_prepare;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		_tmp1_ = _tmp6_ == 0;
	}
	if (_tmp1_) {
		batch_import_report_completed (self, "work sniffed out: nothing to do");
		_background_job_unref0 (sniffer);
		return;
	}
	_tmp7_ = sniffer;
	self->priv->total_bytes = _tmp7_->total_bytes;
	_tmp8_ = sniffer;
	_tmp9_ = _tmp8_->files_to_prepare;
	_tmp10_ = self->priv->cancellable;
	_tmp11_ = prepare_files_job_new (self, _tmp9_, _batch_import_on_file_prepared_notification_callback, self, _batch_import_on_files_prepared_completion_callback, self, _tmp10_, _batch_import_on_file_prepare_cancelled_cancellation_callback, self);
	prepare_files_job = _tmp11_;
	_tmp12_ = batch_import_feeder_workers;
	_tmp13_ = prepare_files_job;
	workers_enqueue (_tmp12_, (BackgroundJob*) _tmp13_);
	if (self->priv->throbber_id > ((guint) 0)) {
		g_source_remove (self->priv->throbber_id);
		self->priv->throbber_id = (guint) 0;
	}
	_background_job_unref0 (prepare_files_job);
	_background_job_unref0 (sniffer);
}

static void
batch_import_on_sniffer_cancelled (BatchImport* self,
                                   BackgroundJob* j)
{
	WorkSniffer* sniffer = NULL;
	WorkSniffer* _tmp0_;
	WorkSniffer* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	_vala_assert (!self->priv->completed, "!completed");
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, TYPE_WORK_SNIFFER, WorkSniffer));
	sniffer = _tmp0_;
	batch_import_log_status (self, "on_sniffer_cancelled");
	_tmp1_ = sniffer;
	batch_import_report_failures (self, (BackgroundImportJob*) _tmp1_);
	batch_import_report_completed (self, "work sniffer cancelled");
	if (self->priv->throbber_id > ((guint) 0)) {
		g_source_remove (self->priv->throbber_id);
		self->priv->throbber_id = (guint) 0;
	}
	_background_job_unref0 (sniffer);
}

static void
_batch_import_on_thumbnail_writer_completed_completion_callback (BackgroundJob* job,
                                                                 gpointer self)
{
	batch_import_on_thumbnail_writer_completed ((BatchImport*) self, job);
}

static void
_batch_import_on_thumbnail_writer_cancelled_cancellation_callback (BackgroundJob* job,
                                                                   gpointer self)
{
	batch_import_on_thumbnail_writer_cancelled ((BatchImport*) self, job);
}

static void
_batch_import_on_import_files_completed_completion_callback (BackgroundJob* job,
                                                             gpointer self)
{
	batch_import_on_import_files_completed ((BatchImport*) self, job);
}

static void
_batch_import_on_import_files_cancelled_cancellation_callback (BackgroundJob* job,
                                                               gpointer self)
{
	batch_import_on_import_files_cancelled ((BatchImport*) self, job);
}

static void
batch_import_flush_import_jobs (BatchImport* self)
{
	g_return_if_fail (self != NULL);
	while (TRUE) {
		gboolean _tmp0_ = FALSE;
		GeeList* _tmp1_;
		gint _tmp2_;
		gint _tmp3_;
		Workers* _tmp5_;
		GeeList* _tmp6_;
		gpointer _tmp7_;
		CompletedImportObject* _tmp8_;
		GCancellable* _tmp9_;
		ThumbnailWriterJob* _tmp10_;
		ThumbnailWriterJob* _tmp11_;
		_tmp1_ = self->priv->ready_thumbnails;
		_tmp2_ = gee_collection_get_size ((GeeCollection*) _tmp1_);
		_tmp3_ = _tmp2_;
		if (_tmp3_ > 0) {
			Workers* _tmp4_;
			_tmp4_ = batch_import_import_workers;
			_tmp0_ = workers_get_pending_job_count (_tmp4_) < self->priv->max_outstanding_import_jobs;
		} else {
			_tmp0_ = FALSE;
		}
		if (!_tmp0_) {
			break;
		}
		_tmp5_ = batch_import_import_workers;
		_tmp6_ = self->priv->ready_thumbnails;
		_tmp7_ = gee_list_remove_at (_tmp6_, 0);
		_tmp8_ = (CompletedImportObject*) _tmp7_;
		_tmp9_ = self->priv->cancellable;
		_tmp10_ = thumbnail_writer_job_new (self, _tmp8_, _batch_import_on_thumbnail_writer_completed_completion_callback, self, _tmp9_, _batch_import_on_thumbnail_writer_cancelled_cancellation_callback, self);
		_tmp11_ = _tmp10_;
		workers_enqueue (_tmp5_, (BackgroundJob*) _tmp11_);
		_background_job_unref0 (_tmp11_);
		_completed_import_object_unref0 (_tmp8_);
	}
	while (TRUE) {
		gboolean _tmp12_ = FALSE;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		Workers* _tmp17_;
		GeeList* _tmp18_;
		gpointer _tmp19_;
		PreparedFile* _tmp20_;
		BatchImportRoll* _tmp21_;
		ImportID _tmp22_;
		GCancellable* _tmp23_;
		PreparedFileImportJob* _tmp24_;
		PreparedFileImportJob* _tmp25_;
		_tmp13_ = self->priv->ready_files;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		if (_tmp15_ > 0) {
			Workers* _tmp16_;
			_tmp16_ = batch_import_import_workers;
			_tmp12_ = workers_get_pending_job_count (_tmp16_) < self->priv->max_outstanding_import_jobs;
		} else {
			_tmp12_ = FALSE;
		}
		if (!_tmp12_) {
			break;
		}
		_tmp17_ = batch_import_import_workers;
		_tmp18_ = self->priv->ready_files;
		_tmp19_ = gee_list_remove_at (_tmp18_, 0);
		_tmp20_ = (PreparedFile*) _tmp19_;
		_tmp21_ = self->priv->import_roll;
		_tmp22_ = _tmp21_->import_id;
		_tmp23_ = self->priv->cancellable;
		_tmp24_ = prepared_file_import_job_new (self, _tmp20_, &_tmp22_, _batch_import_on_import_files_completed_completion_callback, self, _tmp23_, _batch_import_on_import_files_cancelled_cancellation_callback, self);
		_tmp25_ = _tmp24_;
		workers_enqueue (_tmp17_, (BackgroundJob*) _tmp25_);
		_background_job_unref0 (_tmp25_);
		_prepared_file_unref0 (_tmp20_);
	}
}

static GFile*
batch_import_get_in_current_import (BatchImport* self,
                                    PreparedFile* prepared_file)
{
	gboolean _tmp0_ = FALSE;
	const gchar* _tmp1_;
	const gchar* _tmp7_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (prepared_file != NULL, NULL);
	_tmp1_ = prepared_file->full_md5;
	if (_tmp1_ != NULL) {
		GeeHashMap* _tmp2_;
		const gchar* _tmp3_;
		_tmp2_ = self->priv->imported_full_md5_table;
		_tmp3_ = prepared_file->full_md5;
		_tmp0_ = gee_abstract_map_has_key ((GeeAbstractMap*) _tmp2_, _tmp3_);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GeeHashMap* _tmp4_;
		const gchar* _tmp5_;
		gpointer _tmp6_;
		_tmp4_ = self->priv->imported_full_md5_table;
		_tmp5_ = prepared_file->full_md5;
		_tmp6_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp4_, _tmp5_);
		result = (GFile*) _tmp6_;
		return result;
	}
	_tmp7_ = prepared_file->full_md5;
	if (_tmp7_ != NULL) {
		GeeHashMap* _tmp8_;
		const gchar* _tmp9_;
		GFile* _tmp10_;
		_tmp8_ = self->priv->imported_full_md5_table;
		_tmp9_ = prepared_file->full_md5;
		_tmp10_ = prepared_file->file;
		gee_abstract_map_set ((GeeAbstractMap*) _tmp8_, _tmp9_, _tmp10_);
	}
	result = NULL;
	return result;
}

static gpointer
_notification_object_ref0 (gpointer self)
{
	return self ? notification_object_ref (self) : NULL;
}

static void
batch_import_on_file_prepared (BatchImport* self,
                               BackgroundJob* j,
                               NotificationObject* user)
{
	PreparedFileCluster* cluster = NULL;
	PreparedFileCluster* _tmp0_;
	GeeArrayList* _tmp1_;
	gint _tmp2_;
	gint _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	GeeArrayList* _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	_vala_assert (!self->priv->completed, "!completed");
	_tmp0_ = _notification_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (user, TYPE_PREPARED_FILE_CLUSTER, PreparedFileCluster));
	cluster = _tmp0_;
	_tmp1_ = cluster->list;
	_tmp2_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp1_);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strdup_printf ("on_file_prepared (%d files)", _tmp3_);
	_tmp5_ = _tmp4_;
	batch_import_log_status (self, _tmp5_);
	_g_free0 (_tmp5_);
	_tmp6_ = cluster->list;
	batch_import_process_prepared_files (self, (GeeList*) _tmp6_, NULL, NULL);
	_notification_object_unref0 (cluster);
}

static void
batch_import_process_prepared_files_data_free (gpointer _data)
{
	BatchImportProcessPreparedFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->list);
	_g_object_unref0 (_data_->self);
	g_slice_free (BatchImportProcessPreparedFilesData, _data_);
}

static void
batch_import_process_prepared_files (BatchImport* self,
                                     GeeList* list,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	BatchImportProcessPreparedFilesData* _data_;
	BatchImport* _tmp0_;
	GeeList* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (list != NULL);
	_data_ = g_slice_new0 (BatchImportProcessPreparedFilesData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, batch_import_process_prepared_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = _g_object_ref0 (list);
	_g_object_unref0 (_data_->list);
	_data_->list = _tmp1_;
	batch_import_process_prepared_files_co (_data_);
}

static void
batch_import_process_prepared_files_finish (BatchImport* self,
                                            GAsyncResult* _res_)
{
	BatchImportProcessPreparedFilesData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}

static gboolean
_batch_import_process_prepared_files_co_gsource_func (gpointer self)
{
	gboolean result;
	result = batch_import_process_prepared_files_co (self);
	return result;
}

static gboolean
batch_import_process_prepared_files_co (BatchImportProcessPreparedFilesData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_prepared_file_list = _data_->list;
		_data_->_tmp0_ = _data_->_prepared_file_list;
		_data_->_tmp1_ = gee_collection_get_size ((GeeCollection*) _data_->_tmp0_);
		_data_->_tmp2_ = _data_->_tmp1_;
		_data_->_prepared_file_size = _data_->_tmp2_;
		_data_->_prepared_file_index = -1;
		while (TRUE) {
			_data_->_prepared_file_index = _data_->_prepared_file_index + 1;
			_data_->_tmp3_ = _data_->_prepared_file_index;
			_data_->_tmp4_ = _data_->_prepared_file_size;
			if (!(_data_->_tmp3_ < _data_->_tmp4_)) {
				break;
			}
			_data_->_tmp5_ = _data_->_prepared_file_list;
			_data_->_tmp6_ = gee_list_get (_data_->_tmp5_, _data_->_prepared_file_index);
			_data_->prepared_file = (PreparedFile*) _data_->_tmp6_;
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _batch_import_process_prepared_files_co_gsource_func, _data_, NULL);
			_data_->_state_ = 1;
			return FALSE;
			_state_1:
			;
			_data_->import_result = NULL;
			_data_->_tmp7_ = library_photo_global;
			_data_->_tmp8_ = _data_->prepared_file;
			_data_->_tmp9_ = _data_->_tmp8_->file;
			_data_->_tmp10_ = 0;
			_data_->_tmp11_ = library_photo_source_collection_get_state_by_file (_data_->_tmp7_, _data_->_tmp9_, &_data_->_tmp10_);
			_data_->photo_state = _data_->_tmp10_;
			_data_->photo = _data_->_tmp11_;
			_data_->_tmp12_ = _data_->photo;
			if (_data_->_tmp12_ != NULL) {
				switch (_data_->photo_state) {
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_ONLINE:
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE:
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_EDITABLE:
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_DEVELOPER:
					{
						_data_->_tmp13_ = _data_->prepared_file;
						_data_->_tmp14_ = _data_->_tmp13_->job;
						_data_->_tmp15_ = _data_->prepared_file;
						_data_->_tmp16_ = _data_->_tmp15_->file;
						_data_->_tmp17_ = _data_->prepared_file;
						_data_->_tmp18_ = _data_->_tmp17_->file;
						_data_->_tmp19_ = g_file_get_path (_data_->_tmp18_);
						_data_->_tmp20_ = _data_->_tmp19_;
						_data_->_tmp21_ = _data_->prepared_file;
						_data_->_tmp22_ = _data_->_tmp21_->file;
						_data_->_tmp23_ = g_file_get_path (_data_->_tmp22_);
						_data_->_tmp24_ = _data_->_tmp23_;
						_data_->_tmp25_ = _data_->photo;
						_data_->_tmp26_ = media_source_get_master_file ((MediaSource*) _data_->_tmp25_);
						_data_->_tmp27_ = _data_->_tmp26_;
						_data_->_tmp28_ = duplicated_file_create_from_file (_data_->_tmp27_);
						_data_->_tmp29_ = _data_->_tmp28_;
						_data_->_tmp30_ = batch_import_result_new (_data_->_tmp14_, _data_->_tmp16_, _data_->_tmp20_, _data_->_tmp24_, _data_->_tmp29_, IMPORT_RESULT_PHOTO_EXISTS);
						_batch_import_result_unref0 (_data_->import_result);
						_data_->import_result = _data_->_tmp30_;
						_g_object_unref0 (_data_->_tmp29_);
						_g_object_unref0 (_data_->_tmp27_);
						_g_free0 (_data_->_tmp24_);
						_g_free0 (_data_->_tmp20_);
						if (_data_->photo_state == LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_OFFLINE) {
							_data_->_tmp31_ = _data_->photo;
							media_source_mark_online ((MediaSource*) _data_->_tmp31_);
						}
						break;
					}
					case LIBRARY_PHOTO_SOURCE_COLLECTION_STATE_TRASH:
					{
						break;
					}
					default:
					{
						_data_->_tmp32_ = g_enum_get_value (g_type_class_ref (LIBRARY_PHOTO_SOURCE_COLLECTION_TYPE_STATE), _data_->photo_state);
						g_error ("BatchImport.vala:807: Unknown LibraryPhotoSourceCollection state: %s", (_data_->_tmp32_ != NULL) ? _data_->_tmp32_->value_name : NULL);
					}
				}
			}
			_data_->_tmp33_ = _data_->import_result;
			if (_data_->_tmp33_ != NULL) {
				_data_->_tmp34_ = _data_->import_result;
				batch_import_report_failure (_data_->self, _data_->_tmp34_);
				batch_import_file_import_complete (_data_->self);
				_g_object_unref0 (_data_->photo);
				_batch_import_result_unref0 (_data_->import_result);
				_prepared_file_unref0 (_data_->prepared_file);
				continue;
			}
			_data_->_tmp35_ = video_global;
			_data_->_tmp36_ = _data_->prepared_file;
			_data_->_tmp37_ = _data_->_tmp36_->file;
			_data_->_tmp38_ = 0;
			_data_->_tmp39_ = video_source_collection_get_state_by_file (_data_->_tmp35_, _data_->_tmp37_, &_data_->_tmp38_);
			_data_->video_state = _data_->_tmp38_;
			_data_->video = _data_->_tmp39_;
			_data_->_tmp40_ = _data_->video;
			if (_data_->_tmp40_ != NULL) {
				switch (_data_->video_state) {
					case VIDEO_SOURCE_COLLECTION_STATE_ONLINE:
					case VIDEO_SOURCE_COLLECTION_STATE_OFFLINE:
					{
						_data_->_tmp41_ = _data_->prepared_file;
						_data_->_tmp42_ = _data_->_tmp41_->job;
						_data_->_tmp43_ = _data_->prepared_file;
						_data_->_tmp44_ = _data_->_tmp43_->file;
						_data_->_tmp45_ = _data_->prepared_file;
						_data_->_tmp46_ = _data_->_tmp45_->file;
						_data_->_tmp47_ = g_file_get_path (_data_->_tmp46_);
						_data_->_tmp48_ = _data_->_tmp47_;
						_data_->_tmp49_ = _data_->prepared_file;
						_data_->_tmp50_ = _data_->_tmp49_->file;
						_data_->_tmp51_ = g_file_get_path (_data_->_tmp50_);
						_data_->_tmp52_ = _data_->_tmp51_;
						_data_->_tmp53_ = _data_->video;
						_data_->_tmp54_ = media_source_get_master_file ((MediaSource*) _data_->_tmp53_);
						_data_->_tmp55_ = _data_->_tmp54_;
						_data_->_tmp56_ = duplicated_file_create_from_file (_data_->_tmp55_);
						_data_->_tmp57_ = _data_->_tmp56_;
						_data_->_tmp58_ = batch_import_result_new (_data_->_tmp42_, _data_->_tmp44_, _data_->_tmp48_, _data_->_tmp52_, _data_->_tmp57_, IMPORT_RESULT_PHOTO_EXISTS);
						_batch_import_result_unref0 (_data_->import_result);
						_data_->import_result = _data_->_tmp58_;
						_g_object_unref0 (_data_->_tmp57_);
						_g_object_unref0 (_data_->_tmp55_);
						_g_free0 (_data_->_tmp52_);
						_g_free0 (_data_->_tmp48_);
						if (_data_->video_state == VIDEO_SOURCE_COLLECTION_STATE_OFFLINE) {
							_data_->_tmp59_ = _data_->video;
							media_source_mark_online ((MediaSource*) _data_->_tmp59_);
						}
						break;
					}
					case VIDEO_SOURCE_COLLECTION_STATE_TRASH:
					{
						break;
					}
					default:
					{
						_data_->_tmp60_ = g_enum_get_value (g_type_class_ref (VIDEO_SOURCE_COLLECTION_TYPE_STATE), _data_->video_state);
						g_error ("BatchImport.vala:838: Unknown VideoSourceCollection state: %s", (_data_->_tmp60_ != NULL) ? _data_->_tmp60_->value_name : NULL);
					}
				}
			}
			_data_->_tmp61_ = _data_->import_result;
			if (_data_->_tmp61_ != NULL) {
				_data_->_tmp62_ = _data_->import_result;
				batch_import_report_failure (_data_->self, _data_->_tmp62_);
				batch_import_file_import_complete (_data_->self);
				_g_object_unref0 (_data_->video);
				_g_object_unref0 (_data_->photo);
				_batch_import_result_unref0 (_data_->import_result);
				_prepared_file_unref0 (_data_->prepared_file);
				continue;
			}
			_data_->_tmp64_ = _data_->prepared_file;
			if (_data_->_tmp64_->is_video) {
				_data_->_tmp65_ = _data_->prepared_file;
				_data_->_tmp66_ = _data_->_tmp65_->file;
				_data_->_tmp67_ = _data_->prepared_file;
				_data_->_tmp68_ = _data_->_tmp67_->full_md5;
				_data_->_tmp63_ = video_is_duplicate (_data_->_tmp66_, _data_->_tmp68_);
			} else {
				_data_->_tmp63_ = FALSE;
			}
			if (_data_->_tmp63_) {
				_data_->_tmp69_ = video_table_get_instance ();
				_data_->_tmp70_ = _data_->_tmp69_;
				_data_->_tmp71_ = _data_->prepared_file;
				_data_->_tmp72_ = _data_->_tmp71_->file;
				_data_->_tmp73_ = _data_->prepared_file;
				_data_->_tmp74_ = _data_->_tmp73_->full_md5;
				_data_->_tmp75_ = 0;
				_data_->_tmp76_ = video_table_get_duplicate_ids (_data_->_tmp70_, _data_->_tmp72_, _data_->_tmp74_, &_data_->_tmp75_);
				_data_->_tmp77_ = _data_->_tmp76_;
				_data_->_tmp77__length1 = _data_->_tmp75_;
				_database_table_unref0 (_data_->_tmp70_);
				_data_->duplicate_ids = _data_->_tmp77_;
				_data_->duplicate_ids_length1 = _data_->_tmp77__length1;
				_data_->_duplicate_ids_size_ = _data_->duplicate_ids_length1;
				_data_->_tmp78_ = _data_->duplicate_ids;
				_data_->_tmp78__length1 = _data_->duplicate_ids_length1;
				_vala_assert (_data_->_tmp78__length1 > 0, "duplicate_ids.length > 0");
				_data_->_tmp79_ = _data_->duplicate_ids;
				_data_->_tmp79__length1 = _data_->duplicate_ids_length1;
				_data_->_tmp80_ = _data_->_tmp79_[0];
				_data_->_tmp81_ = duplicated_file_create_from_video_id (&_data_->_tmp80_);
				_data_->duplicated_file = _data_->_tmp81_;
				_data_->result_code = IMPORT_RESULT_PHOTO_EXISTS;
				if (_data_->self->priv->mark_duplicates_online) {
					_data_->_tmp82_ = video_global;
					_data_->_tmp83_ = media_source_collection_get_offline_bin ((MediaSourceCollection*) _data_->_tmp82_);
					_data_->_tmp84_ = _data_->_tmp83_;
					_data_->_tmp85_ = _data_->prepared_file;
					_data_->_tmp86_ = _data_->_tmp85_->file;
					_data_->_tmp87_ = media_source_holding_tank_fetch_by_master_file (_data_->_tmp84_, _data_->_tmp86_);
					_data_->_tmp88_ = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp87_, TYPE_VIDEO, Video);
					_source_holding_tank_unref0 (_data_->_tmp84_);
					_data_->dupe_video = _data_->_tmp88_;
					_data_->_tmp89_ = _data_->dupe_video;
					if (_data_->_tmp89_ == NULL) {
						_data_->_tmp90_ = video_global;
						_data_->_tmp91_ = media_source_collection_get_offline_bin ((MediaSourceCollection*) _data_->_tmp90_);
						_data_->_tmp92_ = _data_->_tmp91_;
						_data_->_tmp93_ = _data_->prepared_file;
						_data_->_tmp94_ = _data_->_tmp93_->full_md5;
						_data_->_tmp95_ = media_source_holding_tank_fetch_by_md5 (_data_->_tmp92_, _data_->_tmp94_);
						_g_object_unref0 (_data_->dupe_video);
						_data_->dupe_video = G_TYPE_CHECK_INSTANCE_CAST (_data_->_tmp95_, TYPE_VIDEO, Video);
						_source_holding_tank_unref0 (_data_->_tmp92_);
					}
					_data_->_tmp96_ = _data_->dupe_video;
					if (_data_->_tmp96_ != NULL) {
						_data_->_tmp97_ = _data_->prepared_file;
						_data_->_tmp98_ = _data_->_tmp97_->file;
						_data_->_tmp99_ = g_file_get_path (_data_->_tmp98_);
						_data_->_tmp100_ = _data_->_tmp99_;
						g_debug ("BatchImport.vala:868: duplicate video found offline, marking as online" \
": %s", _data_->_tmp100_);
						_g_free0 (_data_->_tmp100_);
						_data_->_tmp101_ = _data_->dupe_video;
						_data_->_tmp102_ = _data_->prepared_file;
						_data_->_tmp103_ = _data_->_tmp102_->file;
						monitorable_set_master_file ((Monitorable*) _data_->_tmp101_, _data_->_tmp103_);
						_data_->_tmp104_ = _data_->dupe_video;
						media_source_mark_online ((MediaSource*) _data_->_tmp104_);
						_g_object_unref0 (_data_->duplicated_file);
						_data_->duplicated_file = NULL;
						_data_->_tmp105_ = _data_->self->priv->manifest;
						_data_->_tmp106_ = _data_->_tmp105_->imported;
						_data_->_tmp107_ = _data_->dupe_video;
						gee_collection_add ((GeeCollection*) _data_->_tmp106_, (MediaSource*) _data_->_tmp107_);
						_data_->_tmp108_ = _data_->dupe_video;
						batch_import_report_progress (_data_->self, media_source_get_filesize ((MediaSource*) _data_->_tmp108_));
						batch_import_file_import_complete (_data_->self);
						_data_->result_code = IMPORT_RESULT_SUCCESS;
					}
					_g_object_unref0 (_data_->dupe_video);
				}
				_data_->_tmp109_ = _data_->prepared_file;
				_data_->_tmp110_ = _data_->_tmp109_->job;
				_data_->_tmp111_ = _data_->prepared_file;
				_data_->_tmp112_ = _data_->_tmp111_->file;
				_data_->_tmp113_ = _data_->prepared_file;
				_data_->_tmp114_ = _data_->_tmp113_->file;
				_data_->_tmp115_ = g_file_get_path (_data_->_tmp114_);
				_data_->_tmp116_ = _data_->_tmp115_;
				_data_->_tmp117_ = _data_->prepared_file;
				_data_->_tmp118_ = _data_->_tmp117_->file;
				_data_->_tmp119_ = g_file_get_path (_data_->_tmp118_);
				_data_->_tmp120_ = _data_->_tmp119_;
				_data_->_tmp121_ = _data_->duplicated_file;
				_data_->_tmp122_ = batch_import_result_new (_data_->_tmp110_, _data_->_tmp112_, _data_->_tmp116_, _data_->_tmp120_, _data_->_tmp121_, _data_->result_code);
				_batch_import_result_unref0 (_data_->import_result);
				_data_->import_result = _data_->_tmp122_;
				_g_free0 (_data_->_tmp120_);
				_g_free0 (_data_->_tmp116_);
				if (_data_->result_code == IMPORT_RESULT_SUCCESS) {
					_data_->_tmp123_ = _data_->self->priv->manifest;
					_data_->_tmp124_ = _data_->import_result;
					import_manifest_add_result (_data_->_tmp123_, _data_->_tmp124_);
					_g_object_unref0 (_data_->duplicated_file);
					_data_->duplicate_ids = (g_free (_data_->duplicate_ids), NULL);
					_g_object_unref0 (_data_->video);
					_g_object_unref0 (_data_->photo);
					_batch_import_result_unref0 (_data_->import_result);
					_prepared_file_unref0 (_data_->prepared_file);
					continue;
				}
				_g_object_unref0 (_data_->duplicated_file);
				_data_->duplicate_ids = (g_free (_data_->duplicate_ids), NULL);
			}
			_data_->_tmp125_ = _data_->prepared_file;
			_data_->_tmp126_ = batch_import_get_in_current_import (_data_->self, _data_->_tmp125_);
			_data_->_tmp127_ = _data_->_tmp126_;
			_data_->_tmp128_ = _data_->_tmp127_ != NULL;
			_g_object_unref0 (_data_->_tmp127_);
			if (_data_->_tmp128_) {
				_data_->_tmp129_ = _data_->prepared_file;
				_data_->_tmp130_ = _data_->_tmp129_->job;
				_data_->_tmp131_ = _data_->prepared_file;
				_data_->_tmp132_ = _data_->_tmp131_->file;
				_data_->_tmp133_ = _data_->prepared_file;
				_data_->_tmp134_ = _data_->_tmp133_->file;
				_data_->_tmp135_ = g_file_get_path (_data_->_tmp134_);
				_data_->_tmp136_ = _data_->_tmp135_;
				_data_->_tmp137_ = _data_->prepared_file;
				_data_->_tmp138_ = _data_->_tmp137_->file;
				_data_->_tmp139_ = g_file_get_path (_data_->_tmp138_);
				_data_->_tmp140_ = _data_->_tmp139_;
				_data_->_tmp141_ = _data_->prepared_file;
				_data_->_tmp142_ = batch_import_get_in_current_import (_data_->self, _data_->_tmp141_);
				_data_->_tmp143_ = _data_->_tmp142_;
				_data_->_tmp144_ = duplicated_file_create_from_file (_data_->_tmp143_);
				_data_->_tmp145_ = _data_->_tmp144_;
				_data_->_tmp146_ = batch_import_result_new (_data_->_tmp130_, _data_->_tmp132_, _data_->_tmp136_, _data_->_tmp140_, _data_->_tmp145_, IMPORT_RESULT_PHOTO_EXISTS);
				_batch_import_result_unref0 (_data_->import_result);
				_data_->import_result = _data_->_tmp146_;
				_g_object_unref0 (_data_->_tmp145_);
				_g_object_unref0 (_data_->_tmp143_);
				_g_free0 (_data_->_tmp140_);
				_g_free0 (_data_->_tmp136_);
			} else {
				_data_->_tmp147_ = _data_->prepared_file;
				_data_->_tmp148_ = _data_->_tmp147_->file;
				_data_->_tmp149_ = _data_->prepared_file;
				_data_->_tmp150_ = _data_->_tmp149_->full_md5;
				_data_->_tmp151_ = _data_->prepared_file;
				if (photo_is_duplicate (_data_->_tmp148_, NULL, _data_->_tmp150_, _data_->_tmp151_->file_format)) {
					if (_data_->self->priv->untrash_duplicates) {
						_data_->_tmp152_ = library_photo_global;
						_data_->_tmp153_ = _data_->prepared_file;
						_data_->_tmp154_ = _data_->_tmp153_->file;
						_data_->_tmp155_ = library_photo_source_collection_get_trashed_by_file (_data_->_tmp152_, _data_->_tmp154_);
						_g_object_unref0 (_data_->photo);
						_data_->photo = _data_->_tmp155_;
						_data_->_tmp157_ = _data_->photo;
						if (_data_->_tmp157_ == NULL) {
							_data_->_tmp158_ = _data_->prepared_file;
							_data_->_tmp159_ = _data_->_tmp158_->full_md5;
							_data_->_tmp156_ = _data_->_tmp159_ != NULL;
						} else {
							_data_->_tmp156_ = FALSE;
						}
						if (_data_->_tmp156_) {
							_data_->_tmp160_ = library_photo_global;
							_data_->_tmp161_ = _data_->prepared_file;
							_data_->_tmp162_ = _data_->_tmp161_->full_md5;
							_data_->_tmp163_ = library_photo_source_collection_get_trashed_by_md5 (_data_->_tmp160_, _data_->_tmp162_);
							_g_object_unref0 (_data_->photo);
							_data_->photo = _data_->_tmp163_;
						}
						_data_->_tmp164_ = _data_->photo;
						if (_data_->_tmp164_ != NULL) {
							_data_->_tmp165_ = _data_->prepared_file;
							_data_->_tmp166_ = _data_->_tmp165_->file;
							_data_->_tmp167_ = g_file_get_path (_data_->_tmp166_);
							_data_->_tmp168_ = _data_->_tmp167_;
							g_debug ("BatchImport.vala:913: duplicate linked photo found in trash, untrashin" \
"g and removing transforms for %s", _data_->_tmp168_);
							_g_free0 (_data_->_tmp168_);
							_data_->_tmp169_ = _data_->photo;
							_data_->_tmp170_ = _data_->prepared_file;
							_data_->_tmp171_ = _data_->_tmp170_->file;
							monitorable_set_master_file ((Monitorable*) _data_->_tmp169_, _data_->_tmp171_);
							_data_->_tmp172_ = _data_->photo;
							media_source_untrash ((MediaSource*) _data_->_tmp172_);
							_data_->_tmp173_ = _data_->photo;
							photo_remove_all_transformations ((Photo*) _data_->_tmp173_);
						}
					}
					_data_->_tmp175_ = _data_->photo;
					if (_data_->_tmp175_ == NULL) {
						_data_->_tmp174_ = _data_->self->priv->mark_duplicates_online;
					} else {
						_data_->_tmp174_ = FALSE;
					}
					if (_data_->_tmp174_) {
						_data_->_tmp176_ = library_photo_global;
						_data_->_tmp177_ = _data_->prepared_file;
						_data_->_tmp178_ = _data_->_tmp177_->file;
						_data_->_tmp179_ = library_photo_source_collection_get_offline_by_file (_data_->_tmp176_, _data_->_tmp178_);
						_g_object_unref0 (_data_->photo);
						_data_->photo = _data_->_tmp179_;
						_data_->_tmp181_ = _data_->photo;
						if (_data_->_tmp181_ == NULL) {
							_data_->_tmp182_ = _data_->prepared_file;
							_data_->_tmp183_ = _data_->_tmp182_->full_md5;
							_data_->_tmp180_ = _data_->_tmp183_ != NULL;
						} else {
							_data_->_tmp180_ = FALSE;
						}
						if (_data_->_tmp180_) {
							_data_->_tmp184_ = library_photo_global;
							_data_->_tmp185_ = _data_->prepared_file;
							_data_->_tmp186_ = _data_->_tmp185_->full_md5;
							_data_->_tmp187_ = library_photo_source_collection_get_offline_by_md5 (_data_->_tmp184_, _data_->_tmp186_);
							_g_object_unref0 (_data_->photo);
							_data_->photo = _data_->_tmp187_;
						}
						_data_->_tmp188_ = _data_->photo;
						if (_data_->_tmp188_ != NULL) {
							_data_->_tmp189_ = _data_->prepared_file;
							_data_->_tmp190_ = _data_->_tmp189_->file;
							_data_->_tmp191_ = g_file_get_path (_data_->_tmp190_);
							_data_->_tmp192_ = _data_->_tmp191_;
							g_debug ("BatchImport.vala:930: duplicate photo found marked offline, marking on" \
"line: %s", _data_->_tmp192_);
							_g_free0 (_data_->_tmp192_);
							_data_->_tmp193_ = _data_->photo;
							_data_->_tmp194_ = _data_->prepared_file;
							_data_->_tmp195_ = _data_->_tmp194_->file;
							monitorable_set_master_file ((Monitorable*) _data_->_tmp193_, _data_->_tmp195_);
							_data_->_tmp196_ = _data_->photo;
							media_source_mark_online ((MediaSource*) _data_->_tmp196_);
						}
					}
					_data_->_tmp197_ = _data_->photo;
					if (_data_->_tmp197_ != NULL) {
						_data_->_tmp198_ = _data_->prepared_file;
						_data_->_tmp199_ = _data_->_tmp198_->job;
						_data_->_tmp200_ = _data_->prepared_file;
						_data_->_tmp201_ = _data_->_tmp200_->file;
						_data_->_tmp202_ = _data_->prepared_file;
						_data_->_tmp203_ = _data_->_tmp202_->file;
						_data_->_tmp204_ = g_file_get_path (_data_->_tmp203_);
						_data_->_tmp205_ = _data_->_tmp204_;
						_data_->_tmp206_ = _data_->prepared_file;
						_data_->_tmp207_ = _data_->_tmp206_->file;
						_data_->_tmp208_ = g_file_get_path (_data_->_tmp207_);
						_data_->_tmp209_ = _data_->_tmp208_;
						_data_->_tmp210_ = batch_import_result_new (_data_->_tmp199_, _data_->_tmp201_, _data_->_tmp205_, _data_->_tmp209_, NULL, IMPORT_RESULT_SUCCESS);
						_batch_import_result_unref0 (_data_->import_result);
						_data_->import_result = _data_->_tmp210_;
						_g_free0 (_data_->_tmp209_);
						_g_free0 (_data_->_tmp205_);
						_data_->_tmp211_ = _data_->self->priv->manifest;
						_data_->_tmp212_ = _data_->_tmp211_->imported;
						_data_->_tmp213_ = _data_->photo;
						gee_collection_add ((GeeCollection*) _data_->_tmp212_, (MediaSource*) _data_->_tmp213_);
						_data_->_tmp214_ = _data_->self->priv->manifest;
						_data_->_tmp215_ = _data_->import_result;
						import_manifest_add_result (_data_->_tmp214_, _data_->_tmp215_);
						_data_->_tmp216_ = _data_->photo;
						batch_import_report_progress (_data_->self, media_source_get_filesize ((MediaSource*) _data_->_tmp216_));
						batch_import_file_import_complete (_data_->self);
						_g_object_unref0 (_data_->video);
						_g_object_unref0 (_data_->photo);
						_batch_import_result_unref0 (_data_->import_result);
						_prepared_file_unref0 (_data_->prepared_file);
						continue;
					}
					_data_->_tmp217_ = _data_->prepared_file;
					_data_->_tmp218_ = _data_->_tmp217_->file;
					_data_->_tmp219_ = g_file_get_path (_data_->_tmp218_);
					_data_->_tmp220_ = _data_->_tmp219_;
					g_debug ("BatchImport.vala:952: duplicate photo detected, not importing %s", _data_->_tmp220_);
					_g_free0 (_data_->_tmp220_);
					_data_->_tmp221_ = photo_table_get_instance ();
					_data_->_tmp222_ = _data_->_tmp221_;
					_data_->_tmp223_ = _data_->prepared_file;
					_data_->_tmp224_ = _data_->_tmp223_->file;
					_data_->_tmp225_ = _data_->prepared_file;
					_data_->_tmp226_ = _data_->_tmp225_->full_md5;
					_data_->_tmp227_ = _data_->prepared_file;
					_data_->_tmp228_ = 0;
					_data_->_tmp229_ = photo_table_get_duplicate_ids (_data_->_tmp222_, _data_->_tmp224_, NULL, _data_->_tmp226_, _data_->_tmp227_->file_format, &_data_->_tmp228_);
					_data_->_tmp230_ = _data_->_tmp229_;
					_data_->_tmp230__length1 = _data_->_tmp228_;
					_database_table_unref0 (_data_->_tmp222_);
					_data_->photo_ids = _data_->_tmp230_;
					_data_->photo_ids_length1 = _data_->_tmp230__length1;
					_data_->_photo_ids_size_ = _data_->photo_ids_length1;
					_data_->_tmp231_ = _data_->photo_ids;
					_data_->_tmp231__length1 = _data_->photo_ids_length1;
					_vala_assert (_data_->_tmp231__length1 > 0, "photo_ids.length > 0");
					_data_->_tmp232_ = _data_->photo_ids;
					_data_->_tmp232__length1 = _data_->photo_ids_length1;
					_data_->_tmp233_ = _data_->_tmp232_[0];
					_data_->_tmp234_ = duplicated_file_create_from_photo_id (&_data_->_tmp233_);
					_data_->_vala1_duplicated_file = _data_->_tmp234_;
					_data_->_tmp235_ = _data_->prepared_file;
					_data_->_tmp236_ = _data_->_tmp235_->job;
					_data_->_tmp237_ = _data_->prepared_file;
					_data_->_tmp238_ = _data_->_tmp237_->file;
					_data_->_tmp239_ = _data_->prepared_file;
					_data_->_tmp240_ = _data_->_tmp239_->file;
					_data_->_tmp241_ = g_file_get_path (_data_->_tmp240_);
					_data_->_tmp242_ = _data_->_tmp241_;
					_data_->_tmp243_ = _data_->prepared_file;
					_data_->_tmp244_ = _data_->_tmp243_->file;
					_data_->_tmp245_ = g_file_get_path (_data_->_tmp244_);
					_data_->_tmp246_ = _data_->_tmp245_;
					_data_->_tmp247_ = _data_->_vala1_duplicated_file;
					_data_->_tmp248_ = batch_import_result_new (_data_->_tmp236_, _data_->_tmp238_, _data_->_tmp242_, _data_->_tmp246_, _data_->_tmp247_, IMPORT_RESULT_PHOTO_EXISTS);
					_batch_import_result_unref0 (_data_->import_result);
					_data_->import_result = _data_->_tmp248_;
					_g_free0 (_data_->_tmp246_);
					_g_free0 (_data_->_tmp242_);
					_g_object_unref0 (_data_->_vala1_duplicated_file);
					_data_->photo_ids = (g_free (_data_->photo_ids), NULL);
				}
			}
			_data_->_tmp249_ = _data_->import_result;
			if (_data_->_tmp249_ != NULL) {
				_data_->_tmp250_ = _data_->import_result;
				batch_import_report_failure (_data_->self, _data_->_tmp250_);
				batch_import_file_import_complete (_data_->self);
				_g_object_unref0 (_data_->video);
				_g_object_unref0 (_data_->photo);
				_batch_import_result_unref0 (_data_->import_result);
				_prepared_file_unref0 (_data_->prepared_file);
				continue;
			}
			batch_import_report_progress (_data_->self, (guint64) 0);
			_data_->_tmp251_ = _data_->self->priv->ready_files;
			_data_->_tmp252_ = _data_->prepared_file;
			gee_collection_add ((GeeCollection*) _data_->_tmp251_, _data_->_tmp252_);
			_g_object_unref0 (_data_->video);
			_g_object_unref0 (_data_->photo);
			_batch_import_result_unref0 (_data_->import_result);
			_prepared_file_unref0 (_data_->prepared_file);
		}
	}
	batch_import_flush_import_jobs (_data_->self);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
batch_import_done_preparing_files (BatchImport* self,
                                   BackgroundJob* j,
                                   const gchar* caller)
{
	PrepareFilesJob* prepare_files_job = NULL;
	PrepareFilesJob* _tmp0_;
	PrepareFilesJob* _tmp1_;
	PrepareFilesJob* _tmp2_;
	gboolean _tmp3_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	g_return_if_fail (caller != NULL);
	_vala_assert (!self->priv->completed, "!completed");
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, TYPE_PREPARE_FILES_JOB, PrepareFilesJob));
	prepare_files_job = _tmp0_;
	_tmp1_ = prepare_files_job;
	batch_import_report_failures (self, (BackgroundImportJob*) _tmp1_);
	_tmp2_ = prepare_files_job;
	self->priv->file_imports_to_perform = _tmp2_->prepared_files;
	_vala_assert (self->priv->file_imports_to_perform >= self->priv->file_imports_completed, "file_imports_to_perform >= file_imports_completed");
	batch_import_log_status (self, caller);
	batch_import_flush_import_jobs (self);
	if (self->priv->file_imports_to_perform == 0) {
		_tmp3_ = !self->priv->completed;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		batch_import_report_completed (self, "no files prepared for import");
	} else {
		gboolean _tmp4_ = FALSE;
		if (self->priv->file_imports_completed == self->priv->file_imports_to_perform) {
			_tmp4_ = !self->priv->completed;
		} else {
			_tmp4_ = FALSE;
		}
		if (_tmp4_) {
			batch_import_report_completed (self, "completed preparing files, all outstanding imports completed");
		}
	}
	_background_job_unref0 (prepare_files_job);
}

static void
batch_import_on_files_prepared (BatchImport* self,
                                BackgroundJob* j)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	batch_import_done_preparing_files (self, j, "on_files_prepared");
}

static void
batch_import_on_file_prepare_cancelled (BatchImport* self,
                                        BackgroundJob* j)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	batch_import_done_preparing_files (self, j, "on_file_prepare_cancelled");
}

static void
batch_import_on_import_files_completed (BatchImport* self,
                                        BackgroundJob* j)
{
	PreparedFileImportJob* job = NULL;
	PreparedFileImportJob* _tmp0_;
	PreparedFileImportJob* _tmp1_;
	PreparedFile* _tmp2_;
	PreparedFileImportJob* _tmp3_;
	BatchImportResult* _tmp4_;
	PreparedFileImportJob* _tmp9_;
	ReadyForImport* _tmp10_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	_vala_assert (!self->priv->completed, "!completed");
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, TYPE_PREPARED_FILE_IMPORT_JOB, PreparedFileImportJob));
	job = _tmp0_;
	batch_import_log_status (self, "on_import_files_completed");
	_tmp1_ = job;
	_tmp2_ = _tmp1_->not_ready;
	_vala_assert (_tmp2_ == NULL, "job.not_ready == null");
	_tmp3_ = job;
	_tmp4_ = _tmp3_->failed;
	if (_tmp4_ != NULL) {
		PreparedFileImportJob* _tmp5_;
		BatchImportResult* _tmp6_;
		PreparedFileImportJob* _tmp7_;
		BatchImportResult* _tmp8_;
		_tmp5_ = job;
		_tmp6_ = _tmp5_->failed;
		_vala_assert (_tmp6_->result != IMPORT_RESULT_SUCCESS, "job.failed.result != ImportResult.SUCCESS");
		_tmp7_ = job;
		_tmp8_ = _tmp7_->failed;
		batch_import_report_failure (self, _tmp8_);
		batch_import_file_import_complete (self);
	}
	_tmp9_ = job;
	_tmp10_ = _tmp9_->ready;
	if (_tmp10_ != NULL) {
		PreparedFileImportJob* _tmp11_;
		ReadyForImport* _tmp12_;
		BatchImportResult* _tmp13_;
		Tombstone* tombstone = NULL;
		TombstoneSourceCollection* _tmp14_;
		PreparedFileImportJob* _tmp15_;
		ReadyForImport* _tmp16_;
		GFile* _tmp17_;
		Tombstone* _tmp18_;
		Tombstone* _tmp19_;
		MediaSource* source = NULL;
		PreparedFileImportJob* _tmp22_;
		ReadyForImport* _tmp23_;
		PreparedFileImportJob* _tmp76_;
		ReadyForImport* _tmp77_;
		BatchImportResult* _tmp78_;
		_tmp11_ = job;
		_tmp12_ = _tmp11_->ready;
		_tmp13_ = _tmp12_->batch_result;
		_vala_assert (_tmp13_->result == IMPORT_RESULT_SUCCESS, "job.ready.batch_result.result == ImportResult.SUCCESS");
		_tmp14_ = tombstone_global;
		_tmp15_ = job;
		_tmp16_ = _tmp15_->ready;
		_tmp17_ = _tmp16_->final_file;
		_tmp18_ = tombstone_source_collection_locate (_tmp14_, _tmp17_);
		tombstone = _tmp18_;
		_tmp19_ = tombstone;
		if (_tmp19_ != NULL) {
			TombstoneSourceCollection* _tmp20_;
			Tombstone* _tmp21_;
			_tmp20_ = tombstone_global;
			_tmp21_ = tombstone;
			tombstone_source_collection_resurrect (_tmp20_, _tmp21_);
		}
		source = NULL;
		_tmp22_ = job;
		_tmp23_ = _tmp22_->ready;
		if (_tmp23_->is_video) {
			PreparedFileImportJob* _tmp24_;
			ReadyForImport* _tmp25_;
			BatchImportResult* _tmp26_;
			PreparedFileImportJob* _tmp27_;
			ReadyForImport* _tmp28_;
			VideoImportParams* _tmp29_;
			Video* _tmp30_ = NULL;
			ImportResult _tmp31_;
			_tmp24_ = job;
			_tmp25_ = _tmp24_->ready;
			_tmp26_ = _tmp25_->batch_result;
			_tmp27_ = job;
			_tmp28_ = _tmp27_->ready;
			_tmp29_ = _tmp28_->video_import_params;
			_tmp31_ = video_import_create (_tmp29_, &_tmp30_);
			_g_object_unref0 (source);
			source = (MediaSource*) _tmp30_;
			_tmp26_->result = _tmp31_;
		} else {
			PreparedFileImportJob* _tmp32_;
			ReadyForImport* _tmp33_;
			BatchImportResult* _tmp34_;
			PreparedFileImportJob* _tmp35_;
			ReadyForImport* _tmp36_;
			PhotoImportParams* _tmp37_;
			LibraryPhoto* _tmp38_ = NULL;
			ImportResult _tmp39_;
			Photo* photo = NULL;
			MediaSource* _tmp40_;
			Photo* _tmp41_;
			PreparedFileImportJob* _tmp42_;
			ReadyForImport* _tmp43_;
			PhotoImportParams* _tmp44_;
			GFile* _tmp45_;
			Photo* _tmp67_;
			_tmp32_ = job;
			_tmp33_ = _tmp32_->ready;
			_tmp34_ = _tmp33_->batch_result;
			_tmp35_ = job;
			_tmp36_ = _tmp35_->ready;
			_tmp37_ = _tmp36_->photo_import_params;
			_tmp39_ = library_photo_import_create (_tmp37_, &_tmp38_);
			_g_object_unref0 (source);
			source = (MediaSource*) _tmp38_;
			_tmp34_->result = _tmp39_;
			_tmp40_ = source;
			_tmp41_ = _g_object_ref0 (IS_PHOTO (_tmp40_) ? ((Photo*) _tmp40_) : NULL);
			photo = _tmp41_;
			_tmp42_ = job;
			_tmp43_ = _tmp42_->ready;
			_tmp44_ = _tmp43_->photo_import_params;
			_tmp45_ = _tmp44_->final_associated_file;
			if (_tmp45_ != NULL) {
				BackingPhotoRow* bpr = NULL;
				BackingPhotoRow* _tmp46_;
				BackingPhotoRow* _tmp47_;
				BackingPhotoRow* _tmp48_;
				PreparedFileImportJob* _tmp49_;
				ReadyForImport* _tmp50_;
				PhotoImportParams* _tmp51_;
				GFile* _tmp52_;
				gchar* _tmp53_;
				MediaSource* _tmp54_;
				GFile* _tmp55_;
				GFile* _tmp56_;
				gchar* _tmp57_;
				gchar* _tmp58_;
				BackingPhotoRow* _tmp59_;
				const gchar* _tmp60_;
				_tmp46_ = backing_photo_row_new ();
				bpr = _tmp46_;
				_tmp47_ = bpr;
				_tmp47_->file_format = PHOTO_FILE_FORMAT_JFIF;
				_tmp48_ = bpr;
				_tmp49_ = job;
				_tmp50_ = _tmp49_->ready;
				_tmp51_ = _tmp50_->photo_import_params;
				_tmp52_ = _tmp51_->final_associated_file;
				_tmp53_ = g_file_get_path (_tmp52_);
				_g_free0 (_tmp48_->filepath);
				_tmp48_->filepath = _tmp53_;
				_tmp54_ = source;
				_tmp55_ = media_source_get_file ((MediaSource*) G_TYPE_CHECK_INSTANCE_CAST (_tmp54_, TYPE_PHOTO, Photo));
				_tmp56_ = _tmp55_;
				_tmp57_ = g_file_get_path (_tmp56_);
				_tmp58_ = _tmp57_;
				_tmp59_ = bpr;
				_tmp60_ = _tmp59_->filepath;
				g_debug ("BatchImport.vala:1058: Associating %s with sibling %s", _tmp58_, _tmp60_);
				_g_free0 (_tmp58_);
				_g_object_unref0 (_tmp56_);
				{
					MediaSource* _tmp61_;
					BackingPhotoRow* _tmp62_;
					_tmp61_ = source;
					_tmp62_ = bpr;
					photo_add_backing_photo_for_development (G_TYPE_CHECK_INSTANCE_CAST (_tmp61_, TYPE_PHOTO, Photo), RAW_DEVELOPER_CAMERA, _tmp62_, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					BackingPhotoRow* _tmp63_;
					const gchar* _tmp64_;
					GError* _tmp65_;
					const gchar* _tmp66_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp63_ = bpr;
					_tmp64_ = _tmp63_->filepath;
					_tmp65_ = e;
					_tmp66_ = _tmp65_->message;
					g_warning ("BatchImport.vala:1063: Unable to associate JPEG with RAW. File: %s Err" \
"or: %s", _tmp64_, _tmp66_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_backing_photo_row_unref0 (bpr);
					_g_object_unref0 (photo);
					_g_object_unref0 (source);
					_g_object_unref0 (tombstone);
					_background_job_unref0 (job);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_backing_photo_row_unref0 (bpr);
			}
			_tmp67_ = photo;
			if (photo_get_master_file_format (_tmp67_) == PHOTO_FILE_FORMAT_RAW) {
				RawDeveloper d = 0;
				GSettings* _tmp68_;
				gchar* _tmp69_;
				gchar* _tmp70_;
				RawDeveloper _tmp71_;
				gboolean _tmp72_ = FALSE;
				Photo* _tmp74_;
				Photo* _tmp75_;
				_tmp68_ = self->priv->file_settings;
				_tmp69_ = g_settings_get_string (_tmp68_, "raw-developer-default");
				_tmp70_ = _tmp69_;
				_tmp71_ = raw_developer_from_string (_tmp70_);
				_g_free0 (_tmp70_);
				d = _tmp71_;
				if (d == RAW_DEVELOPER_CAMERA) {
					Photo* _tmp73_;
					_tmp73_ = photo;
					_tmp72_ = !photo_is_raw_developer_available (_tmp73_, d);
				} else {
					_tmp72_ = FALSE;
				}
				if (_tmp72_) {
					d = RAW_DEVELOPER_EMBEDDED;
				}
				_tmp74_ = photo;
				photo_set_default_raw_developer (_tmp74_, d);
				_tmp75_ = photo;
				photo_set_raw_developer (_tmp75_, d);
			}
			_g_object_unref0 (photo);
		}
		_tmp76_ = job;
		_tmp77_ = _tmp76_->ready;
		_tmp78_ = _tmp77_->batch_result;
		if (_tmp78_->result != IMPORT_RESULT_SUCCESS) {
			PreparedFileImportJob* _tmp79_;
			ReadyForImport* _tmp80_;
			BatchImportResult* _tmp81_;
			gchar* _tmp82_;
			gchar* _tmp83_;
			PreparedFileImportJob* _tmp84_;
			ReadyForImport* _tmp85_;
			BatchImportResult* _tmp86_;
			_tmp79_ = job;
			_tmp80_ = _tmp79_->ready;
			_tmp81_ = _tmp80_->batch_result;
			_tmp82_ = import_result_to_string (_tmp81_->result);
			_tmp83_ = _tmp82_;
			g_debug ("BatchImport.vala:1080: on_import_file_completed: %s", _tmp83_);
			_g_free0 (_tmp83_);
			_tmp84_ = job;
			_tmp85_ = _tmp84_->ready;
			_tmp86_ = _tmp85_->batch_result;
			batch_import_report_failure (self, _tmp86_);
			batch_import_file_import_complete (self);
		} else {
			GeeList* _tmp87_;
			MediaSource* _tmp88_;
			PreparedFileImportJob* _tmp89_;
			ReadyForImport* _tmp90_;
			Thumbnails* _tmp91_;
			Thumbnails* _tmp92_;
			PreparedFileImportJob* _tmp93_;
			ReadyForImport* _tmp94_;
			PreparedFile* _tmp95_;
			BatchImportJob* _tmp96_;
			PreparedFileImportJob* _tmp97_;
			ReadyForImport* _tmp98_;
			BatchImportResult* _tmp99_;
			CompletedImportObject* _tmp100_;
			CompletedImportObject* _tmp101_;
			_tmp87_ = self->priv->ready_thumbnails;
			_tmp88_ = source;
			_tmp89_ = job;
			_tmp90_ = _tmp89_->ready;
			_tmp91_ = ready_for_import_get_thumbnails (_tmp90_);
			_tmp92_ = _tmp91_;
			_tmp93_ = job;
			_tmp94_ = _tmp93_->ready;
			_tmp95_ = _tmp94_->prepared_file;
			_tmp96_ = _tmp95_->job;
			_tmp97_ = job;
			_tmp98_ = _tmp97_->ready;
			_tmp99_ = _tmp98_->batch_result;
			_tmp100_ = completed_import_object_new (_tmp88_, _tmp92_, _tmp96_, _tmp99_);
			_tmp101_ = _tmp100_;
			gee_collection_add ((GeeCollection*) _tmp87_, _tmp101_);
			_completed_import_object_unref0 (_tmp101_);
			_thumbnails_unref0 (_tmp92_);
		}
		_g_object_unref0 (source);
		_g_object_unref0 (tombstone);
	}
	batch_import_flush_import_jobs (self);
	_background_job_unref0 (job);
}

static void
batch_import_on_import_files_cancelled (BatchImport* self,
                                        BackgroundJob* j)
{
	PreparedFileImportJob* job = NULL;
	PreparedFileImportJob* _tmp0_;
	PreparedFileImportJob* _tmp1_;
	PreparedFile* _tmp2_;
	PreparedFileImportJob* _tmp21_;
	BatchImportResult* _tmp22_;
	PreparedFileImportJob* _tmp25_;
	ReadyForImport* _tmp26_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	_vala_assert (!self->priv->completed, "!completed");
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, TYPE_PREPARED_FILE_IMPORT_JOB, PreparedFileImportJob));
	job = _tmp0_;
	batch_import_log_status (self, "on_import_files_cancelled");
	_tmp1_ = job;
	_tmp2_ = _tmp1_->not_ready;
	if (_tmp2_ != NULL) {
		PreparedFileImportJob* _tmp3_;
		PreparedFile* _tmp4_;
		BatchImportJob* _tmp5_;
		PreparedFileImportJob* _tmp6_;
		PreparedFile* _tmp7_;
		GFile* _tmp8_;
		PreparedFileImportJob* _tmp9_;
		PreparedFile* _tmp10_;
		GFile* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		PreparedFileImportJob* _tmp14_;
		PreparedFile* _tmp15_;
		GFile* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		BatchImportResult* _tmp19_;
		BatchImportResult* _tmp20_;
		_tmp3_ = job;
		_tmp4_ = _tmp3_->not_ready;
		_tmp5_ = _tmp4_->job;
		_tmp6_ = job;
		_tmp7_ = _tmp6_->not_ready;
		_tmp8_ = _tmp7_->file;
		_tmp9_ = job;
		_tmp10_ = _tmp9_->not_ready;
		_tmp11_ = _tmp10_->file;
		_tmp12_ = g_file_get_path (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = job;
		_tmp15_ = _tmp14_->not_ready;
		_tmp16_ = _tmp15_->file;
		_tmp17_ = g_file_get_path (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = batch_import_result_new (_tmp5_, _tmp8_, _tmp13_, _tmp18_, NULL, IMPORT_RESULT_USER_ABORT);
		_tmp20_ = _tmp19_;
		batch_import_report_failure (self, _tmp20_);
		_batch_import_result_unref0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp13_);
		batch_import_file_import_complete (self);
	}
	_tmp21_ = job;
	_tmp22_ = _tmp21_->failed;
	if (_tmp22_ != NULL) {
		PreparedFileImportJob* _tmp23_;
		BatchImportResult* _tmp24_;
		_tmp23_ = job;
		_tmp24_ = _tmp23_->failed;
		batch_import_report_failure (self, _tmp24_);
		batch_import_file_import_complete (self);
	}
	_tmp25_ = job;
	_tmp26_ = _tmp25_->ready;
	if (_tmp26_ != NULL) {
		PreparedFileImportJob* _tmp27_;
		ReadyForImport* _tmp28_;
		BatchImportResult* _tmp29_;
		BatchImportResult* _tmp30_;
		_tmp27_ = job;
		_tmp28_ = _tmp27_->ready;
		_tmp29_ = ready_for_import_abort (_tmp28_);
		_tmp30_ = _tmp29_;
		batch_import_report_failure (self, _tmp30_);
		_batch_import_result_unref0 (_tmp30_);
		batch_import_file_import_complete (self);
	}
	batch_import_flush_import_jobs (self);
	_background_job_unref0 (job);
}

static gpointer
_completed_import_object_ref0 (gpointer self)
{
	return self ? completed_import_object_ref (self) : NULL;
}

static void
batch_import_on_thumbnail_writer_completed (BatchImport* self,
                                            BackgroundJob* j)
{
	ThumbnailWriterJob* job = NULL;
	ThumbnailWriterJob* _tmp0_;
	CompletedImportObject* completed = NULL;
	ThumbnailWriterJob* _tmp1_;
	CompletedImportObject* _tmp2_;
	CompletedImportObject* _tmp3_;
	CompletedImportObject* _tmp4_;
	BatchImportResult* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	_vala_assert (!self->priv->completed, "!completed");
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, TYPE_THUMBNAIL_WRITER_JOB, ThumbnailWriterJob));
	job = _tmp0_;
	_tmp1_ = job;
	_tmp2_ = _tmp1_->completed_import_source;
	_tmp3_ = _completed_import_object_ref0 (_tmp2_);
	completed = _tmp3_;
	batch_import_log_status (self, "on_thumbnail_writer_completed");
	_tmp4_ = completed;
	_tmp5_ = _tmp4_->batch_result;
	if (_tmp5_->result != IMPORT_RESULT_SUCCESS) {
		CompletedImportObject* _tmp6_;
		MediaSource* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		CompletedImportObject* _tmp10_;
		BatchImportResult* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		CompletedImportObject* _tmp14_;
		MediaSource* _tmp15_;
		CompletedImportObject* _tmp22_;
		BatchImportResult* _tmp23_;
		_tmp6_ = completed;
		_tmp7_ = _tmp6_->source;
		_tmp8_ = data_object_to_string ((DataObject*) _tmp7_);
		_tmp9_ = _tmp8_;
		_tmp10_ = completed;
		_tmp11_ = _tmp10_->batch_result;
		_tmp12_ = import_result_to_string (_tmp11_->result);
		_tmp13_ = _tmp12_;
		g_warning ("BatchImport.vala:1136: Failed to import %s: unable to write thumbnails" \
" (%s)", _tmp9_, _tmp13_);
		_g_free0 (_tmp13_);
		_g_free0 (_tmp9_);
		_tmp14_ = completed;
		_tmp15_ = _tmp14_->source;
		if (IS_LIBRARY_PHOTO (_tmp15_)) {
			CompletedImportObject* _tmp16_;
			MediaSource* _tmp17_;
			_tmp16_ = completed;
			_tmp17_ = _tmp16_->source;
			library_photo_import_failed (IS_LIBRARY_PHOTO (_tmp17_) ? ((LibraryPhoto*) _tmp17_) : NULL);
		} else {
			CompletedImportObject* _tmp18_;
			MediaSource* _tmp19_;
			_tmp18_ = completed;
			_tmp19_ = _tmp18_->source;
			if (IS_VIDEO (_tmp19_)) {
				CompletedImportObject* _tmp20_;
				MediaSource* _tmp21_;
				_tmp20_ = completed;
				_tmp21_ = _tmp20_->source;
				video_import_failed (IS_VIDEO (_tmp21_) ? ((Video*) _tmp21_) : NULL);
			}
		}
		_tmp22_ = completed;
		_tmp23_ = _tmp22_->batch_result;
		batch_import_report_failure (self, _tmp23_);
		batch_import_file_import_complete (self);
	} else {
		ImportManifest* _tmp24_;
		GeeList* _tmp25_;
		CompletedImportObject* _tmp26_;
		MediaSource* _tmp27_;
		ImportManifest* _tmp28_;
		CompletedImportObject* _tmp29_;
		BatchImportResult* _tmp30_;
		GeeList* _tmp31_;
		CompletedImportObject* _tmp32_;
		_tmp24_ = self->priv->manifest;
		_tmp25_ = _tmp24_->imported;
		_tmp26_ = completed;
		_tmp27_ = _tmp26_->source;
		gee_collection_add ((GeeCollection*) _tmp25_, _tmp27_);
		_tmp28_ = self->priv->manifest;
		_tmp29_ = completed;
		_tmp30_ = _tmp29_->batch_result;
		import_manifest_add_result (_tmp28_, _tmp30_);
		_tmp31_ = self->priv->display_imported_queue;
		_tmp32_ = completed;
		gee_collection_add ((GeeCollection*) _tmp31_, _tmp32_);
	}
	batch_import_flush_import_jobs (self);
	_completed_import_object_unref0 (completed);
	_background_job_unref0 (job);
}

static void
batch_import_on_thumbnail_writer_cancelled (BatchImport* self,
                                            BackgroundJob* j)
{
	ThumbnailWriterJob* job = NULL;
	ThumbnailWriterJob* _tmp0_;
	CompletedImportObject* completed = NULL;
	ThumbnailWriterJob* _tmp1_;
	CompletedImportObject* _tmp2_;
	CompletedImportObject* _tmp3_;
	CompletedImportObject* _tmp4_;
	MediaSource* _tmp5_;
	CompletedImportObject* _tmp12_;
	BatchImportResult* _tmp13_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (j != NULL);
	_vala_assert (!self->priv->completed, "!completed");
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, TYPE_THUMBNAIL_WRITER_JOB, ThumbnailWriterJob));
	job = _tmp0_;
	_tmp1_ = job;
	_tmp2_ = _tmp1_->completed_import_source;
	_tmp3_ = _completed_import_object_ref0 (_tmp2_);
	completed = _tmp3_;
	batch_import_log_status (self, "on_thumbnail_writer_cancelled");
	_tmp4_ = completed;
	_tmp5_ = _tmp4_->source;
	if (IS_LIBRARY_PHOTO (_tmp5_)) {
		CompletedImportObject* _tmp6_;
		MediaSource* _tmp7_;
		_tmp6_ = completed;
		_tmp7_ = _tmp6_->source;
		library_photo_import_failed (IS_LIBRARY_PHOTO (_tmp7_) ? ((LibraryPhoto*) _tmp7_) : NULL);
	} else {
		CompletedImportObject* _tmp8_;
		MediaSource* _tmp9_;
		_tmp8_ = completed;
		_tmp9_ = _tmp8_->source;
		if (IS_VIDEO (_tmp9_)) {
			CompletedImportObject* _tmp10_;
			MediaSource* _tmp11_;
			_tmp10_ = completed;
			_tmp11_ = _tmp10_->source;
			video_import_failed (IS_VIDEO (_tmp11_) ? ((Video*) _tmp11_) : NULL);
		}
	}
	_tmp12_ = completed;
	_tmp13_ = _tmp12_->batch_result;
	batch_import_report_failure (self, _tmp13_);
	batch_import_file_import_complete (self);
	batch_import_flush_import_jobs (self);
	_completed_import_object_unref0 (completed);
	_background_job_unref0 (job);
}

static void
batch_import_flush_ready_sources (BatchImport* self)
{
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GeeList* _tmp3_;
	gint _tmp4_;
	gint _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GeeArrayList* all = NULL;
	GeeArrayList* _tmp8_;
	GeeArrayList* photos = NULL;
	GeeArrayList* _tmp9_;
	GeeArrayList* videos = NULL;
	GeeArrayList* _tmp10_;
	GeeHashMap* completion_list = NULL;
	GeeHashMap* _tmp11_;
	MediaCollectionRegistry* _tmp38_;
	MediaCollectionRegistry* _tmp39_;
	EventSourceCollection* _tmp40_;
	TagSourceCollection* _tmp41_;
	LibraryPhotoSourceCollection* _tmp42_;
	GeeArrayList* _tmp43_;
	VideoSourceCollection* _tmp44_;
	GeeArrayList* _tmp45_;
	GeeArrayList* _tmp66_;
	BatchImportRoll* _tmp67_;
	ViewCollection* _tmp68_;
	TagSourceCollection* _tmp69_;
	EventSourceCollection* _tmp70_;
	MediaCollectionRegistry* _tmp71_;
	MediaCollectionRegistry* _tmp72_;
	GeeList* _tmp73_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->ready_sources;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		return;
	}
	_tmp3_ = self->priv->ready_sources;
	_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_strdup_printf ("flush_ready_sources (%d)", _tmp5_);
	_tmp7_ = _tmp6_;
	batch_import_log_status (self, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = gee_array_list_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	all = _tmp8_;
	_tmp9_ = gee_array_list_new (TYPE_LIBRARY_PHOTO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	photos = _tmp9_;
	_tmp10_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	videos = _tmp10_;
	_tmp11_ = gee_hash_map_new (TYPE_MEDIA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_BATCH_IMPORT_JOB, (GBoxedCopyFunc) batch_import_job_ref, (GDestroyNotify) batch_import_job_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	completion_list = _tmp11_;
	{
		GeeList* _completed_list = NULL;
		GeeList* _tmp12_;
		gint _completed_size = 0;
		GeeList* _tmp13_;
		gint _tmp14_;
		gint _tmp15_;
		gint _completed_index = 0;
		_tmp12_ = self->priv->ready_sources;
		_completed_list = _tmp12_;
		_tmp13_ = _completed_list;
		_tmp14_ = gee_collection_get_size ((GeeCollection*) _tmp13_);
		_tmp15_ = _tmp14_;
		_completed_size = _tmp15_;
		_completed_index = -1;
		while (TRUE) {
			gint _tmp16_;
			gint _tmp17_;
			CompletedImportObject* completed = NULL;
			GeeList* _tmp18_;
			gpointer _tmp19_;
			GeeArrayList* _tmp20_;
			CompletedImportObject* _tmp21_;
			MediaSource* _tmp22_;
			CompletedImportObject* _tmp23_;
			MediaSource* _tmp24_;
			GeeHashMap* _tmp33_;
			CompletedImportObject* _tmp34_;
			MediaSource* _tmp35_;
			CompletedImportObject* _tmp36_;
			BatchImportJob* _tmp37_;
			_completed_index = _completed_index + 1;
			_tmp16_ = _completed_index;
			_tmp17_ = _completed_size;
			if (!(_tmp16_ < _tmp17_)) {
				break;
			}
			_tmp18_ = _completed_list;
			_tmp19_ = gee_list_get (_tmp18_, _completed_index);
			completed = (CompletedImportObject*) _tmp19_;
			_tmp20_ = all;
			_tmp21_ = completed;
			_tmp22_ = _tmp21_->source;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp20_, _tmp22_);
			_tmp23_ = completed;
			_tmp24_ = _tmp23_->source;
			if (IS_LIBRARY_PHOTO (_tmp24_)) {
				GeeArrayList* _tmp25_;
				CompletedImportObject* _tmp26_;
				MediaSource* _tmp27_;
				_tmp25_ = photos;
				_tmp26_ = completed;
				_tmp27_ = _tmp26_->source;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp25_, G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_LIBRARY_PHOTO, LibraryPhoto));
			} else {
				CompletedImportObject* _tmp28_;
				MediaSource* _tmp29_;
				_tmp28_ = completed;
				_tmp29_ = _tmp28_->source;
				if (IS_VIDEO (_tmp29_)) {
					GeeArrayList* _tmp30_;
					CompletedImportObject* _tmp31_;
					MediaSource* _tmp32_;
					_tmp30_ = videos;
					_tmp31_ = completed;
					_tmp32_ = _tmp31_->source;
					gee_abstract_collection_add ((GeeAbstractCollection*) _tmp30_, G_TYPE_CHECK_INSTANCE_CAST (_tmp32_, TYPE_VIDEO, Video));
				}
			}
			_tmp33_ = completion_list;
			_tmp34_ = completed;
			_tmp35_ = _tmp34_->source;
			_tmp36_ = completed;
			_tmp37_ = _tmp36_->original_job;
			gee_abstract_map_set ((GeeAbstractMap*) _tmp33_, _tmp35_, _tmp37_);
			_completed_import_object_unref0 (completed);
		}
	}
	_tmp38_ = media_collection_registry_get_instance ();
	_tmp39_ = _tmp38_;
	media_collection_registry_begin_transaction_on_all (_tmp39_);
	_media_collection_registry_unref0 (_tmp39_);
	_tmp40_ = event_global;
	data_collection_freeze_notifications ((DataCollection*) _tmp40_);
	_tmp41_ = tag_global;
	data_collection_freeze_notifications ((DataCollection*) _tmp41_);
	_tmp42_ = library_photo_global;
	_tmp43_ = photos;
	media_source_collection_import_many ((MediaSourceCollection*) _tmp42_, (GeeCollection*) _tmp43_);
	_tmp44_ = video_global;
	_tmp45_ = videos;
	media_source_collection_import_many ((MediaSourceCollection*) _tmp44_, (GeeCollection*) _tmp45_);
	{
		GeeIterator* _media_it = NULL;
		GeeHashMap* _tmp46_;
		GeeSet* _tmp47_;
		GeeSet* _tmp48_;
		GeeSet* _tmp49_;
		GeeIterator* _tmp50_;
		GeeIterator* _tmp51_;
		_tmp46_ = completion_list;
		_tmp47_ = gee_abstract_map_get_keys ((GeeAbstractMap*) _tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = _tmp48_;
		_tmp50_ = gee_iterable_iterator ((GeeIterable*) _tmp49_);
		_tmp51_ = _tmp50_;
		_g_object_unref0 (_tmp49_);
		_media_it = _tmp51_;
		while (TRUE) {
			GeeIterator* _tmp52_;
			MediaSource* media = NULL;
			GeeIterator* _tmp53_;
			gpointer _tmp54_;
			_tmp52_ = _media_it;
			if (!gee_iterator_next (_tmp52_)) {
				break;
			}
			_tmp53_ = _media_it;
			_tmp54_ = gee_iterator_get (_tmp53_);
			media = (MediaSource*) _tmp54_;
			{
				GeeHashMap* _tmp55_;
				MediaSource* _tmp56_;
				gpointer _tmp57_;
				BatchImportJob* _tmp58_;
				MediaSource* _tmp59_;
				BatchImportRoll* _tmp60_;
				_tmp55_ = completion_list;
				_tmp56_ = media;
				_tmp57_ = gee_abstract_map_get ((GeeAbstractMap*) _tmp55_, _tmp56_);
				_tmp58_ = (BatchImportJob*) _tmp57_;
				_tmp59_ = media;
				_tmp60_ = self->priv->import_roll;
				batch_import_job_complete (_tmp58_, _tmp59_, _tmp60_, &_inner_error0_);
				_batch_import_job_unref0 (_tmp58_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				MediaSource* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				GError* _tmp64_;
				const gchar* _tmp65_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp61_ = media;
				_tmp62_ = data_object_to_string ((DataObject*) _tmp61_);
				_tmp63_ = _tmp62_;
				_tmp64_ = err;
				_tmp65_ = _tmp64_->message;
				g_warning ("BatchImport.vala:1216: Completion error when finalizing import of %s: " \
"%s", _tmp63_, _tmp65_);
				_g_free0 (_tmp63_);
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_g_object_unref0 (media);
				_g_object_unref0 (_media_it);
				_g_object_unref0 (completion_list);
				_g_object_unref0 (videos);
				_g_object_unref0 (photos);
				_g_object_unref0 (all);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			_g_object_unref0 (media);
		}
		_g_object_unref0 (_media_it);
	}
	_tmp66_ = all;
	_tmp67_ = self->priv->import_roll;
	_tmp68_ = _tmp67_->generated_events;
	event_generate_many_events ((GeeCollection*) _tmp66_, _tmp68_);
	_tmp69_ = tag_global;
	data_collection_thaw_notifications ((DataCollection*) _tmp69_);
	_tmp70_ = event_global;
	data_collection_thaw_notifications ((DataCollection*) _tmp70_);
	_tmp71_ = media_collection_registry_get_instance ();
	_tmp72_ = _tmp71_;
	media_collection_registry_commit_transaction_on_all (_tmp72_);
	_media_collection_registry_unref0 (_tmp72_);
	_tmp73_ = self->priv->ready_sources;
	gee_collection_clear ((GeeCollection*) _tmp73_);
	_g_object_unref0 (completion_list);
	_g_object_unref0 (videos);
	_g_object_unref0 (photos);
	_g_object_unref0 (all);
}

static gboolean
batch_import_display_imported_timer (BatchImport* self)
{
	GeeList* _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
	GCancellable* _tmp3_;
	gint total = 0;
	GCancellable* _tmp7_;
	GeeList* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gboolean _tmp32_ = FALSE;
	GeeList* _tmp33_;
	gint _tmp34_;
	gint _tmp35_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->display_imported_queue;
	_tmp1_ = gee_collection_get_size ((GeeCollection*) _tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == 0) {
		result = !self->priv->completed;
		return result;
	}
	_tmp3_ = self->priv->cancellable;
	if (g_cancellable_is_cancelled (_tmp3_)) {
		GeeList* _tmp4_;
		gint _tmp5_;
		gint _tmp6_;
		_tmp4_ = self->priv->display_imported_queue;
		_tmp5_ = gee_collection_get_size ((GeeCollection*) _tmp4_);
		_tmp6_ = _tmp5_;
		g_debug ("BatchImport.vala:1238: Importing %d photos at once", _tmp6_);
	}
	batch_import_log_status (self, "display_imported_timer");
	total = 1;
	_tmp7_ = self->priv->cancellable;
	if (!g_cancellable_is_cancelled (_tmp7_)) {
		GeeList* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
		_tmp8_ = self->priv->display_imported_queue;
		_tmp9_ = gee_collection_get_size ((GeeCollection*) _tmp8_);
		_tmp10_ = _tmp9_;
		if (_tmp10_ > BATCH_IMPORT_DISPLAY_QUEUE_HYSTERESIS_OVERFLOW) {
			GeeList* _tmp11_;
			gint _tmp12_;
			gint _tmp13_;
			_tmp11_ = self->priv->display_imported_queue;
			_tmp12_ = gee_collection_get_size ((GeeCollection*) _tmp11_);
			_tmp13_ = _tmp12_;
			total = 1 << CLAMP ((_tmp13_ / BATCH_IMPORT_DISPLAY_QUEUE_HYSTERESIS_OVERFLOW) + 2, 0, 16);
		}
	} else {
		total = BATCH_IMPORT_DISPLAY_QUEUE_HYSTERESIS_OVERFLOW;
	}
	_tmp14_ = self->priv->display_imported_queue;
	_tmp15_ = gee_collection_get_size ((GeeCollection*) _tmp14_);
	_tmp16_ = _tmp15_;
	total = MIN (total, _tmp16_);
	while (TRUE) {
		gint _tmp17_;
		CompletedImportObject* completed_object = NULL;
		GeeList* _tmp18_;
		gpointer _tmp19_;
		GdkPixbuf* user_preview = NULL;
		CompletedImportObject* _tmp20_;
		GdkPixbuf* _tmp21_;
		GdkPixbuf* _tmp22_;
		CompletedImportObject* _tmp23_;
		CompletedImportObject* _tmp24_;
		GeeList* _tmp25_;
		CompletedImportObject* _tmp26_;
		CompletedImportObject* _tmp27_;
		MediaSource* _tmp28_;
		GdkPixbuf* _tmp29_;
		CompletedImportObject* _tmp30_;
		MediaSource* _tmp31_;
		_tmp17_ = total;
		total = _tmp17_ - 1;
		if (!(_tmp17_ > 0)) {
			break;
		}
		_tmp18_ = self->priv->display_imported_queue;
		_tmp19_ = gee_list_remove_at (_tmp18_, 0);
		completed_object = (CompletedImportObject*) _tmp19_;
		_tmp20_ = completed_object;
		_tmp21_ = _tmp20_->user_preview;
		_tmp22_ = _g_object_ref0 (_tmp21_);
		user_preview = _tmp22_;
		_tmp23_ = completed_object;
		_g_object_unref0 (_tmp23_->user_preview);
		_tmp23_->user_preview = NULL;
		_tmp24_ = completed_object;
		_thumbnails_unref0 (_tmp24_->thumbnails);
		_tmp24_->thumbnails = NULL;
		_tmp25_ = self->priv->ready_sources;
		_tmp26_ = completed_object;
		gee_collection_add ((GeeCollection*) _tmp25_, _tmp26_);
		_tmp27_ = completed_object;
		_tmp28_ = _tmp27_->source;
		_tmp29_ = user_preview;
		g_signal_emit (self, batch_import_signals[BATCH_IMPORT_IMPORTED_SIGNAL], 0, _tmp28_, _tmp29_, total);
		_tmp30_ = completed_object;
		_tmp31_ = _tmp30_->source;
		batch_import_report_progress (self, media_source_get_filesize (_tmp31_));
		batch_import_file_import_complete (self);
		_g_object_unref0 (user_preview);
		_completed_import_object_unref0 (completed_object);
	}
	_tmp33_ = self->priv->ready_sources;
	_tmp34_ = gee_collection_get_size ((GeeCollection*) _tmp33_);
	_tmp35_ = _tmp34_;
	if (_tmp35_ >= BATCH_IMPORT_READY_SOURCES_COUNT_OVERFLOW) {
		_tmp32_ = TRUE;
	} else {
		GCancellable* _tmp36_;
		_tmp36_ = self->priv->cancellable;
		_tmp32_ = g_cancellable_is_cancelled (_tmp36_);
	}
	if (_tmp32_) {
		batch_import_flush_ready_sources (self);
	}
	result = TRUE;
	return result;
}

static void
g_cclosure_user_marshal_VOID__UINT64_UINT64 (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__UINT64_UINT64) (gpointer data1, guint64 arg_1, guint64 arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT64_UINT64 callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT64_UINT64) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint64 (param_values + 1), g_value_get_uint64 (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT (GClosure * closure,
                                                 GValue * return_value,
                                                 guint n_param_values,
                                                 const GValue * param_values,
                                                 gpointer invocation_hint,
                                                 gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_INT) (gpointer data1, gpointer arg_1, gpointer arg_2, gint arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_INT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_int (param_values + 3), data2);
}

static void
g_cclosure_user_marshal_VOID__ENUM_STRING (GClosure * closure,
                                           GValue * return_value,
                                           guint n_param_values,
                                           const GValue * param_values,
                                           gpointer invocation_hint,
                                           gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__ENUM_STRING) (gpointer data1, gint arg_1, const char* arg_2, gpointer data2);
	register GMarshalFunc_VOID__ENUM_STRING callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__ENUM_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_enum (param_values + 1), g_value_get_string (param_values + 2), data2);
}

static void
g_cclosure_user_marshal_VOID__BATCH_IMPORT_RESULT (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BATCH_IMPORT_RESULT) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BATCH_IMPORT_RESULT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__BATCH_IMPORT_RESULT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_batch_import_result (param_values + 1), data2);
}

static void
g_cclosure_user_marshal_VOID__IMPORT_MANIFEST_BATCH_IMPORT_ROLL (GClosure * closure,
                                                                 GValue * return_value,
                                                                 guint n_param_values,
                                                                 const GValue * param_values,
                                                                 gpointer invocation_hint,
                                                                 gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__IMPORT_MANIFEST_BATCH_IMPORT_ROLL) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__IMPORT_MANIFEST_BATCH_IMPORT_ROLL callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__IMPORT_MANIFEST_BATCH_IMPORT_ROLL) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_import_manifest (param_values + 1), value_get_batch_import_roll (param_values + 2), data2);
}

static GObject *
batch_import_constructor (GType type,
                          guint n_construct_properties,
                          GObjectConstructParam * construct_properties)
{
	GObject * obj;
	GObjectClass * parent_class;
	BatchImport * self;
	GSettings* _tmp0_;
	parent_class = G_OBJECT_CLASS (batch_import_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BATCH_IMPORT, BatchImport);
	_tmp0_ = g_settings_new (GSETTINGS_CONFIGURATION_ENGINE_FILES_PREFS_SCHEMA_NAME);
	_g_object_unref0 (self->priv->file_settings);
	self->priv->file_settings = _tmp0_;
	return obj;
}

static void
batch_import_class_init (BatchImportClass * klass,
                         gpointer klass_data)
{
	Workers* _tmp0_;
	Workers* _tmp1_;
	batch_import_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BatchImport_private_offset);
	G_OBJECT_CLASS (klass)->constructor = batch_import_constructor;
	G_OBJECT_CLASS (klass)->finalize = batch_import_finalize;
	batch_import_signals[BATCH_IMPORT_STARTING_SIGNAL] = g_signal_new ("starting", TYPE_BATCH_IMPORT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	batch_import_signals[BATCH_IMPORT_PREPARING_SIGNAL] = g_signal_new ("preparing", TYPE_BATCH_IMPORT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	batch_import_signals[BATCH_IMPORT_PROGRESS_SIGNAL] = g_signal_new ("progress", TYPE_BATCH_IMPORT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT64_UINT64, G_TYPE_NONE, 2, G_TYPE_UINT64, G_TYPE_UINT64);
	batch_import_signals[BATCH_IMPORT_IMPORTED_SIGNAL] = g_signal_new ("imported", TYPE_BATCH_IMPORT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_INT, G_TYPE_NONE, 3, TYPE_MEDIA_SOURCE, gdk_pixbuf_get_type (), G_TYPE_INT);
	batch_import_signals[BATCH_IMPORT_FATAL_ERROR_SIGNAL] = g_signal_new ("fatal-error", TYPE_BATCH_IMPORT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__ENUM_STRING, G_TYPE_NONE, 2, TYPE_IMPORT_RESULT, G_TYPE_STRING);
	batch_import_signals[BATCH_IMPORT_IMPORT_JOB_FAILED_SIGNAL] = g_signal_new ("import-job-failed", TYPE_BATCH_IMPORT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BATCH_IMPORT_RESULT, G_TYPE_NONE, 1, TYPE_BATCH_IMPORT_RESULT);
	batch_import_signals[BATCH_IMPORT_IMPORT_COMPLETE_SIGNAL] = g_signal_new ("import-complete", TYPE_BATCH_IMPORT, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__IMPORT_MANIFEST_BATCH_IMPORT_ROLL, G_TYPE_NONE, 2, TYPE_IMPORT_MANIFEST, TYPE_BATCH_IMPORT_ROLL);
	_tmp0_ = workers_new (1, FALSE);
	batch_import_feeder_workers = _tmp0_;
	_tmp1_ = workers_new (workers_thread_per_cpu_minus_one (), FALSE);
	batch_import_import_workers = _tmp1_;
}

static void
batch_import_instance_init (BatchImport * self,
                            gpointer klass)
{
	GeeHashMap* _tmp0_;
	GeeLinkedList* _tmp1_;
	GeeLinkedList* _tmp2_;
	GeeLinkedList* _tmp3_;
	GeeLinkedList* _tmp4_;
	self->priv = batch_import_get_instance_private (self);
	self->priv->completed_bytes = (guint64) 0;
	self->priv->total_bytes = (guint64) 0;
	self->priv->scheduled = FALSE;
	self->priv->completed = FALSE;
	self->priv->file_imports_to_perform = -1;
	self->priv->file_imports_completed = 0;
	self->priv->cancellable = NULL;
	self->priv->last_preparing_ms = (gint64) 0;
	_tmp0_ = gee_hash_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, g_file_get_type (), (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->imported_full_md5_table = _tmp0_;
	self->priv->throbber_id = (guint) 0;
	self->priv->max_outstanding_import_jobs = workers_thread_per_cpu_minus_one ();
	self->priv->untrash_duplicates = TRUE;
	self->priv->mark_duplicates_online = TRUE;
	_tmp1_ = gee_linked_list_new (TYPE_PREPARED_FILE, (GBoxedCopyFunc) prepared_file_ref, (GDestroyNotify) prepared_file_unref, NULL, NULL, NULL);
	self->priv->ready_files = (GeeList*) _tmp1_;
	_tmp2_ = gee_linked_list_new (TYPE_COMPLETED_IMPORT_OBJECT, (GBoxedCopyFunc) completed_import_object_ref, (GDestroyNotify) completed_import_object_unref, NULL, NULL, NULL);
	self->priv->ready_thumbnails = (GeeList*) _tmp2_;
	_tmp3_ = gee_linked_list_new (TYPE_COMPLETED_IMPORT_OBJECT, (GBoxedCopyFunc) completed_import_object_ref, (GDestroyNotify) completed_import_object_unref, NULL, NULL, NULL);
	self->priv->display_imported_queue = (GeeList*) _tmp3_;
	_tmp4_ = gee_linked_list_new (TYPE_COMPLETED_IMPORT_OBJECT, (GBoxedCopyFunc) completed_import_object_ref, (GDestroyNotify) completed_import_object_unref, NULL, NULL, NULL);
	self->priv->ready_sources = (GeeList*) _tmp4_;
}

static void
batch_import_finalize (GObject * obj)
{
	BatchImport * self;
	GApplication* _tmp0_;
	guint _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BATCH_IMPORT, BatchImport);
	_tmp0_ = g_application_get_default ();
	g_signal_parse_name ("exiting", PHOTOS_TYPE_APPLICATION, &_tmp1_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, PHOTOS_TYPE_APPLICATION, PhotosApplication), G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp1_, 0, NULL, (GCallback) _batch_import_user_halt_photos_application_exiting, self);
	_g_object_unref0 (self->priv->jobs);
	_batch_import_roll_unref0 (self->priv->import_roll);
	_g_free0 (self->priv->name);
	_import_manifest_unref0 (self->priv->manifest);
	_g_object_unref0 (self->priv->cancellable);
	_g_object_unref0 (self->priv->skipset);
	_g_object_unref0 (self->priv->imported_full_md5_table);
	_g_object_unref0 (self->priv->file_settings);
	_g_object_unref0 (self->priv->ready_files);
	_g_object_unref0 (self->priv->ready_thumbnails);
	_g_object_unref0 (self->priv->display_imported_queue);
	_g_object_unref0 (self->priv->ready_sources);
	G_OBJECT_CLASS (batch_import_parent_class)->finalize (obj);
}

static GType
batch_import_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BatchImportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) batch_import_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BatchImport), 0, (GInstanceInitFunc) batch_import_instance_init, NULL };
	GType batch_import_type_id;
	batch_import_type_id = g_type_register_static (G_TYPE_OBJECT, "BatchImport", &g_define_type_info, 0);
	BatchImport_private_offset = g_type_add_instance_private (batch_import_type_id, sizeof (BatchImportPrivate));
	return batch_import_type_id;
}

GType
batch_import_get_type (void)
{
	static volatile gsize batch_import_type_id__once = 0;
	if (g_once_init_enter (&batch_import_type_id__once)) {
		GType batch_import_type_id;
		batch_import_type_id = batch_import_get_type_once ();
		g_once_init_leave (&batch_import_type_id__once, batch_import_type_id);
	}
	return batch_import_type_id__once;
}

static inline gpointer
duplicated_file_get_instance_private (DuplicatedFile* self)
{
	return G_STRUCT_MEMBER_P (self, DuplicatedFile_private_offset);
}

static DuplicatedFile*
duplicated_file_construct (GType object_type)
{
	DuplicatedFile * self = NULL;
	self = (DuplicatedFile*) g_object_new (object_type, NULL);
	_video_id_free0 (self->priv->video_id);
	self->priv->video_id = NULL;
	_photo_id_free0 (self->priv->photo_id);
	self->priv->photo_id = NULL;
	_g_object_unref0 (self->priv->file);
	self->priv->file = NULL;
	return self;
}

static DuplicatedFile*
duplicated_file_new (void)
{
	return duplicated_file_construct (TYPE_DUPLICATED_FILE);
}

static gpointer
_photo_id_dup0 (gpointer self)
{
	return self ? photo_id_dup (self) : NULL;
}

DuplicatedFile*
duplicated_file_create_from_photo_id (PhotoID* photo_id)
{
	DuplicatedFile* _result_ = NULL;
	DuplicatedFile* _tmp0_;
	PhotoID _tmp1_;
	PhotoID* _tmp2_;
	DuplicatedFile* result;
	g_return_val_if_fail (photo_id != NULL, NULL);
	_vala_assert (photo_id_is_valid (photo_id), "photo_id.is_valid ()");
	_tmp0_ = duplicated_file_new ();
	_result_ = _tmp0_;
	_tmp1_ = *photo_id;
	_tmp2_ = _photo_id_dup0 (&_tmp1_);
	_photo_id_free0 (_result_->priv->photo_id);
	_result_->priv->photo_id = _tmp2_;
	result = _result_;
	return result;
}

static gpointer
_video_id_dup0 (gpointer self)
{
	return self ? video_id_dup (self) : NULL;
}

DuplicatedFile*
duplicated_file_create_from_video_id (VideoID* video_id)
{
	DuplicatedFile* _result_ = NULL;
	DuplicatedFile* _tmp0_;
	VideoID _tmp1_;
	VideoID* _tmp2_;
	DuplicatedFile* result;
	g_return_val_if_fail (video_id != NULL, NULL);
	_vala_assert (video_id_is_valid (video_id), "video_id.is_valid ()");
	_tmp0_ = duplicated_file_new ();
	_result_ = _tmp0_;
	_tmp1_ = *video_id;
	_tmp2_ = _video_id_dup0 (&_tmp1_);
	_video_id_free0 (_result_->priv->video_id);
	_result_->priv->video_id = _tmp2_;
	result = _result_;
	return result;
}

DuplicatedFile*
duplicated_file_create_from_file (GFile* file)
{
	DuplicatedFile* _result_ = NULL;
	DuplicatedFile* _tmp0_;
	GFile* _tmp1_;
	DuplicatedFile* result;
	g_return_val_if_fail (file != NULL, NULL);
	_tmp0_ = duplicated_file_new ();
	_result_ = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (_result_->priv->file);
	_result_->priv->file = _tmp1_;
	result = _result_;
	return result;
}

GFile*
duplicated_file_get_file (DuplicatedFile* self)
{
	GFile* _tmp0_;
	GFile* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	if (_tmp0_ != NULL) {
		GFile* _tmp1_;
		GFile* _tmp2_;
		_tmp1_ = self->priv->file;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	} else {
		PhotoID* _tmp3_;
		_tmp3_ = self->priv->photo_id;
		if (_tmp3_ != NULL) {
			Photo* photo_object = NULL;
			LibraryPhotoSourceCollection* _tmp4_;
			PhotoID* _tmp5_;
			PhotoID _tmp6_;
			LibraryPhoto* _tmp7_;
			Photo* _tmp8_;
			GFile* _tmp9_;
			GFile* _tmp10_;
			GFile* _tmp11_;
			_tmp4_ = library_photo_global;
			_tmp5_ = self->priv->photo_id;
			_tmp6_ = *_tmp5_;
			_tmp7_ = library_photo_source_collection_fetch (_tmp4_, &_tmp6_);
			photo_object = G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_PHOTO, Photo);
			_tmp8_ = photo_object;
			_tmp9_ = media_source_get_master_file ((MediaSource*) _tmp8_);
			_g_object_unref0 (self->priv->file);
			self->priv->file = _tmp9_;
			_tmp10_ = self->priv->file;
			_tmp11_ = _g_object_ref0 (_tmp10_);
			result = _tmp11_;
			_g_object_unref0 (photo_object);
			return result;
		} else {
			VideoID* _tmp12_;
			_tmp12_ = self->priv->video_id;
			if (_tmp12_ != NULL) {
				Video* video_object = NULL;
				VideoSourceCollection* _tmp13_;
				VideoID* _tmp14_;
				VideoID _tmp15_;
				Video* _tmp16_;
				Video* _tmp17_;
				GFile* _tmp18_;
				GFile* _tmp19_;
				GFile* _tmp20_;
				_tmp13_ = video_global;
				_tmp14_ = self->priv->video_id;
				_tmp15_ = *_tmp14_;
				_tmp16_ = video_source_collection_fetch (_tmp13_, &_tmp15_);
				video_object = G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, TYPE_VIDEO, Video);
				_tmp17_ = video_object;
				_tmp18_ = media_source_get_master_file ((MediaSource*) _tmp17_);
				_g_object_unref0 (self->priv->file);
				self->priv->file = _tmp18_;
				_tmp19_ = self->priv->file;
				_tmp20_ = _g_object_ref0 (_tmp19_);
				result = _tmp20_;
				_g_object_unref0 (video_object);
				return result;
			} else {
				g_assert_not_reached ();
			}
		}
	}
}

static void
duplicated_file_class_init (DuplicatedFileClass * klass,
                            gpointer klass_data)
{
	duplicated_file_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &DuplicatedFile_private_offset);
	G_OBJECT_CLASS (klass)->finalize = duplicated_file_finalize;
}

static void
duplicated_file_instance_init (DuplicatedFile * self,
                               gpointer klass)
{
	self->priv = duplicated_file_get_instance_private (self);
}

static void
duplicated_file_finalize (GObject * obj)
{
	DuplicatedFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DUPLICATED_FILE, DuplicatedFile);
	_video_id_free0 (self->priv->video_id);
	_photo_id_free0 (self->priv->photo_id);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (duplicated_file_parent_class)->finalize (obj);
}

static GType
duplicated_file_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (DuplicatedFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) duplicated_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DuplicatedFile), 0, (GInstanceInitFunc) duplicated_file_instance_init, NULL };
	GType duplicated_file_type_id;
	duplicated_file_type_id = g_type_register_static (G_TYPE_OBJECT, "DuplicatedFile", &g_define_type_info, 0);
	DuplicatedFile_private_offset = g_type_add_instance_private (duplicated_file_type_id, sizeof (DuplicatedFilePrivate));
	return duplicated_file_type_id;
}

GType
duplicated_file_get_type (void)
{
	static volatile gsize duplicated_file_type_id__once = 0;
	if (g_once_init_enter (&duplicated_file_type_id__once)) {
		GType duplicated_file_type_id;
		duplicated_file_type_id = duplicated_file_get_type_once ();
		g_once_init_leave (&duplicated_file_type_id__once, duplicated_file_type_id);
	}
	return duplicated_file_type_id__once;
}

BackgroundImportJob*
background_import_job_construct (GType object_type,
                                 BatchImport* owner,
                                 CompletionCallback callback,
                                 gpointer callback_target,
                                 GCancellable* cancellable,
                                 CancellationCallback cancellation,
                                 gpointer cancellation_target)
{
	BackgroundImportJob* self = NULL;
	g_return_val_if_fail (owner != NULL, NULL);
	g_return_val_if_fail (cancellable != NULL, NULL);
	self = (BackgroundImportJob*) background_job_construct (object_type, (GObject*) owner, callback, callback_target, cancellable, cancellation, cancellation_target, NULL);
	return self;
}

ImportResult
background_import_job_abort_check (BackgroundImportJob* self)
{
	gboolean _tmp0_ = FALSE;
	ImportResult result;
	g_return_val_if_fail (self != NULL, 0);
	if (self->abort_flag == IMPORT_RESULT_SUCCESS) {
		_tmp0_ = background_job_is_cancelled ((BackgroundJob*) self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		self->abort_flag = IMPORT_RESULT_USER_ABORT;
	}
	result = self->abort_flag;
	return result;
}

void
background_import_job_abort (BackgroundImportJob* self,
                             ImportResult _result_)
{
	g_return_if_fail (self != NULL);
	if (self->abort_flag == IMPORT_RESULT_SUCCESS) {
		self->abort_flag = _result_;
	}
}

void
background_import_job_report_failure (BackgroundImportJob* self,
                                      BatchImportJob* job,
                                      GFile* file,
                                      const gchar* src_identifier,
                                      const gchar* dest_identifier,
                                      ImportResult _result_)
{
	GeeList* _tmp2_;
	BatchImportResult* _tmp3_;
	BatchImportResult* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (job != NULL);
	g_return_if_fail (src_identifier != NULL);
	g_return_if_fail (dest_identifier != NULL);
	_vala_assert (_result_ != IMPORT_RESULT_SUCCESS, "result != ImportResult.SUCCESS");
	if (import_result_is_abort (_result_)) {
		background_import_job_abort (self, _result_);
	} else {
		gchar* _tmp0_;
		gchar* _tmp1_;
		_tmp0_ = import_result_to_string (_result_);
		_tmp1_ = _tmp0_;
		g_warning ("BatchImport.vala:1399: Import failure %s: %s", src_identifier, _tmp1_);
		_g_free0 (_tmp1_);
	}
	_tmp2_ = self->failed;
	_tmp3_ = batch_import_result_new (job, file, src_identifier, dest_identifier, NULL, _result_);
	_tmp4_ = _tmp3_;
	gee_collection_add ((GeeCollection*) _tmp2_, _tmp4_);
	_batch_import_result_unref0 (_tmp4_);
}

void
background_import_job_report_error (BackgroundImportJob* self,
                                    BatchImportJob* job,
                                    GFile* file,
                                    const gchar* src_identifier,
                                    const gchar* dest_identifier,
                                    GError* err,
                                    ImportResult default_result)
{
	ImportResult _result_ = 0;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GeeList* _tmp3_;
	BatchImportResult* _tmp4_;
	BatchImportResult* _tmp5_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (job != NULL);
	g_return_if_fail (src_identifier != NULL);
	g_return_if_fail (dest_identifier != NULL);
	g_return_if_fail (err != NULL);
	_result_ = import_result_convert_error (err, default_result);
	_tmp0_ = err->message;
	_tmp1_ = import_result_to_string (_result_);
	_tmp2_ = _tmp1_;
	g_warning ("BatchImport.vala:1409: Import error %s: %s (%s)", src_identifier, _tmp0_, _tmp2_);
	_g_free0 (_tmp2_);
	if (import_result_is_abort (_result_)) {
		background_import_job_abort (self, _result_);
	}
	_tmp3_ = self->failed;
	_tmp4_ = batch_import_result_new_from_error (job, file, src_identifier, dest_identifier, err, default_result);
	_tmp5_ = _tmp4_;
	gee_collection_add ((GeeCollection*) _tmp3_, _tmp5_);
	_batch_import_result_unref0 (_tmp5_);
}

static void
background_import_job_class_init (BackgroundImportJobClass * klass,
                                  gpointer klass_data)
{
	background_import_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = background_import_job_finalize;
}

static void
background_import_job_instance_init (BackgroundImportJob * self,
                                     gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->abort_flag = IMPORT_RESULT_SUCCESS;
	_tmp0_ = gee_array_list_new (TYPE_BATCH_IMPORT_RESULT, (GBoxedCopyFunc) batch_import_result_ref, (GDestroyNotify) batch_import_result_unref, NULL, NULL, NULL);
	self->failed = (GeeList*) _tmp0_;
}

static void
background_import_job_finalize (BackgroundJob * obj)
{
	BackgroundImportJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BACKGROUND_IMPORT_JOB, BackgroundImportJob);
	_g_object_unref0 (self->failed);
	BACKGROUND_JOB_CLASS (background_import_job_parent_class)->finalize (obj);
}

static GType
background_import_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BackgroundImportJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) background_import_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BackgroundImportJob), 0, (GInstanceInitFunc) background_import_job_instance_init, NULL };
	GType background_import_job_type_id;
	background_import_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "BackgroundImportJob", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	return background_import_job_type_id;
}

GType
background_import_job_get_type (void)
{
	static volatile gsize background_import_job_type_id__once = 0;
	if (g_once_init_enter (&background_import_job_type_id__once)) {
		GType background_import_job_type_id;
		background_import_job_type_id = background_import_job_get_type_once ();
		g_once_init_leave (&background_import_job_type_id__once, background_import_job_type_id);
	}
	return background_import_job_type_id__once;
}

FileToPrepare*
file_to_prepare_construct (GType object_type,
                           BatchImportJob* job,
                           GFile* file,
                           gboolean copy_to_library)
{
	FileToPrepare* self = NULL;
	BatchImportJob* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (job != NULL, NULL);
	self = (FileToPrepare*) g_type_create_instance (object_type);
	_tmp0_ = _batch_import_job_ref0 (job);
	_batch_import_job_unref0 (self->job);
	self->job = _tmp0_;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp1_;
	self->copy_to_library = copy_to_library;
	return self;
}

FileToPrepare*
file_to_prepare_new (BatchImportJob* job,
                     GFile* file,
                     gboolean copy_to_library)
{
	return file_to_prepare_construct (TYPE_FILE_TO_PREPARE, job, file, copy_to_library);
}

static gpointer
_file_to_prepare_ref0 (gpointer self)
{
	return self ? file_to_prepare_ref (self) : NULL;
}

void
file_to_prepare_set_associated (FileToPrepare* self,
                                FileToPrepare* a)
{
	FileToPrepare* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _file_to_prepare_ref0 (a);
	_file_to_prepare_unref0 (self->associated);
	self->associated = _tmp0_;
}

gchar*
file_to_prepare_get_parent_path (FileToPrepare* self)
{
	gchar* _tmp0_ = NULL;
	GFile* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->file;
	if (_tmp1_ != NULL) {
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp4_;
		gchar* _tmp5_;
		_tmp2_ = self->file;
		_tmp3_ = g_file_get_parent (_tmp2_);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_get_path (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
	} else {
		BatchImportJob* _tmp6_;
		gchar* _tmp7_;
		_tmp6_ = self->job;
		_tmp7_ = batch_import_job_get_path (_tmp6_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp7_;
	}
	result = _tmp0_;
	return result;
}

gchar*
file_to_prepare_get_path (FileToPrepare* self)
{
	gchar* _tmp0_ = NULL;
	GFile* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->file;
	if (_tmp1_ != NULL) {
		GFile* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->file;
		_tmp3_ = g_file_get_path (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		BatchImportJob* _tmp4_;
		gchar* _tmp5_;
		gchar* _tmp6_;
		GFile* _tmp7_;
		GFile* _tmp8_;
		BatchImportJob* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GFile* _tmp12_;
		GFile* _tmp13_;
		gchar* _tmp14_;
		_tmp4_ = self->job;
		_tmp5_ = batch_import_job_get_path (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp7_ = g_file_new_for_path (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp9_ = self->job;
		_tmp10_ = batch_import_job_get_basename (_tmp9_);
		_tmp11_ = _tmp10_;
		_tmp12_ = g_file_get_child (_tmp8_, _tmp11_);
		_tmp13_ = _tmp12_;
		_tmp14_ = g_file_get_path (_tmp13_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp14_;
		_g_object_unref0 (_tmp13_);
		_g_free0 (_tmp11_);
		_g_object_unref0 (_tmp8_);
		_g_free0 (_tmp6_);
	}
	result = _tmp0_;
	return result;
}

gchar*
file_to_prepare_get_basename (FileToPrepare* self)
{
	gchar* _tmp0_ = NULL;
	GFile* _tmp1_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->file;
	if (_tmp1_ != NULL) {
		GFile* _tmp2_;
		gchar* _tmp3_;
		_tmp2_ = self->file;
		_tmp3_ = g_file_get_basename (_tmp2_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp3_;
	} else {
		BatchImportJob* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = self->job;
		_tmp5_ = batch_import_job_get_basename (_tmp4_);
		_g_free0 (_tmp0_);
		_tmp0_ = _tmp5_;
	}
	result = _tmp0_;
	return result;
}

gboolean
file_to_prepare_is_directory (FileToPrepare* self)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp1_ = self->file;
	if (_tmp1_ != NULL) {
		GFile* _tmp2_;
		_tmp2_ = self->file;
		_tmp0_ = g_file_query_file_type (_tmp2_, G_FILE_QUERY_INFO_NONE, NULL) == G_FILE_TYPE_DIRECTORY;
	} else {
		BatchImportJob* _tmp3_;
		_tmp3_ = self->job;
		_tmp0_ = batch_import_job_is_directory (_tmp3_);
	}
	result = _tmp0_;
	return result;
}

static void
value_file_to_prepare_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_file_to_prepare_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		file_to_prepare_unref (value->data[0].v_pointer);
	}
}

static void
value_file_to_prepare_copy_value (const GValue* src_value,
                                  GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = file_to_prepare_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_file_to_prepare_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_file_to_prepare_collect_value (GValue* value,
                                     guint n_collect_values,
                                     GTypeCValue* collect_values,
                                     guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FileToPrepare * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = file_to_prepare_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_file_to_prepare_lcopy_value (const GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	FileToPrepare ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = file_to_prepare_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_file_to_prepare (const gchar* name,
                            const gchar* nick,
                            const gchar* blurb,
                            GType object_type,
                            GParamFlags flags)
{
	ParamSpecFileToPrepare* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_FILE_TO_PREPARE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_file_to_prepare (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FILE_TO_PREPARE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_file_to_prepare (GValue* value,
                           gpointer v_object)
{
	FileToPrepare * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FILE_TO_PREPARE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FILE_TO_PREPARE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		file_to_prepare_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		file_to_prepare_unref (old);
	}
}

void
value_take_file_to_prepare (GValue* value,
                            gpointer v_object)
{
	FileToPrepare * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FILE_TO_PREPARE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FILE_TO_PREPARE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		file_to_prepare_unref (old);
	}
}

static void
file_to_prepare_class_init (FileToPrepareClass * klass,
                            gpointer klass_data)
{
	file_to_prepare_parent_class = g_type_class_peek_parent (klass);
	((FileToPrepareClass *) klass)->finalize = file_to_prepare_finalize;
}

static void
file_to_prepare_instance_init (FileToPrepare * self,
                               gpointer klass)
{
	self->associated = NULL;
	self->ref_count = 1;
}

static void
file_to_prepare_finalize (FileToPrepare * obj)
{
	FileToPrepare * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FILE_TO_PREPARE, FileToPrepare);
	g_signal_handlers_destroy (self);
	_batch_import_job_unref0 (self->job);
	_g_object_unref0 (self->file);
	_file_to_prepare_unref0 (self->associated);
}

static GType
file_to_prepare_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_file_to_prepare_init, value_file_to_prepare_free_value, value_file_to_prepare_copy_value, value_file_to_prepare_peek_pointer, "p", value_file_to_prepare_collect_value, "p", value_file_to_prepare_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FileToPrepareClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) file_to_prepare_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FileToPrepare), 0, (GInstanceInitFunc) file_to_prepare_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType file_to_prepare_type_id;
	file_to_prepare_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FileToPrepare", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return file_to_prepare_type_id;
}

GType
file_to_prepare_get_type (void)
{
	static volatile gsize file_to_prepare_type_id__once = 0;
	if (g_once_init_enter (&file_to_prepare_type_id__once)) {
		GType file_to_prepare_type_id;
		file_to_prepare_type_id = file_to_prepare_get_type_once ();
		g_once_init_leave (&file_to_prepare_type_id__once, file_to_prepare_type_id);
	}
	return file_to_prepare_type_id__once;
}

gpointer
file_to_prepare_ref (gpointer instance)
{
	FileToPrepare * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
file_to_prepare_unref (gpointer instance)
{
	FileToPrepare * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FILE_TO_PREPARE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
work_sniffer_get_instance_private (WorkSniffer* self)
{
	return G_STRUCT_MEMBER_P (self, WorkSniffer_private_offset);
}

WorkSniffer*
work_sniffer_construct (GType object_type,
                        BatchImport* owner,
                        GeeIterable* jobs,
                        CompletionCallback callback,
                        gpointer callback_target,
                        GCancellable* cancellable,
                        CancellationCallback cancellation,
                        gpointer cancellation_target,
                        GeeHashSet* skipset)
{
	WorkSniffer* self = NULL;
	GeeIterable* _tmp0_;
	GeeHashSet* _tmp1_;
	g_return_val_if_fail (owner != NULL, NULL);
	g_return_val_if_fail (jobs != NULL, NULL);
	g_return_val_if_fail (cancellable != NULL, NULL);
	self = (WorkSniffer*) background_import_job_construct (object_type, owner, callback, callback_target, cancellable, cancellation, cancellation_target);
	_tmp0_ = _g_object_ref0 (jobs);
	_g_object_unref0 (self->priv->jobs);
	self->priv->jobs = _tmp0_;
	_tmp1_ = _g_object_ref0 (skipset);
	_g_object_unref0 (self->priv->skipset);
	self->priv->skipset = _tmp1_;
	return self;
}

WorkSniffer*
work_sniffer_new (BatchImport* owner,
                  GeeIterable* jobs,
                  CompletionCallback callback,
                  gpointer callback_target,
                  GCancellable* cancellable,
                  CancellationCallback cancellation,
                  gpointer cancellation_target,
                  GeeHashSet* skipset)
{
	return work_sniffer_construct (TYPE_WORK_SNIFFER, owner, jobs, callback, callback_target, cancellable, cancellation, cancellation_target, skipset);
}

static gint
__lambda16_ (WorkSniffer* self,
             FileToPrepare* a,
             FileToPrepare* b)
{
	FileToPrepare* file_a = NULL;
	FileToPrepare* _tmp0_;
	FileToPrepare* file_b = NULL;
	FileToPrepare* _tmp1_;
	gchar* sa = NULL;
	gchar* _tmp2_;
	gchar* sb = NULL;
	gchar* _tmp3_;
	gint result;
	g_return_val_if_fail (a != NULL, 0);
	g_return_val_if_fail (b != NULL, 0);
	_tmp0_ = _file_to_prepare_ref0 (G_TYPE_CHECK_INSTANCE_CAST (a, TYPE_FILE_TO_PREPARE, FileToPrepare));
	file_a = _tmp0_;
	_tmp1_ = _file_to_prepare_ref0 (G_TYPE_CHECK_INSTANCE_CAST (b, TYPE_FILE_TO_PREPARE, FileToPrepare));
	file_b = _tmp1_;
	_tmp2_ = file_to_prepare_get_path (file_a);
	sa = _tmp2_;
	_tmp3_ = file_to_prepare_get_path (file_b);
	sb = _tmp3_;
	result = utf8_cs_compare (sa, sb);
	_g_free0 (sb);
	_g_free0 (sa);
	_file_to_prepare_unref0 (file_b);
	_file_to_prepare_unref0 (file_a);
	return result;
}

static gint
___lambda16__gcompare_data_func (gconstpointer a,
                                 gconstpointer b,
                                 gpointer self)
{
	gint result;
	result = __lambda16_ ((WorkSniffer*) self, (FileToPrepare*) a, (FileToPrepare*) b);
	return result;
}

static void
work_sniffer_real_execute (BackgroundJob* base)
{
	WorkSniffer * self;
	GeeList* sorted = NULL;
	GeeArrayList* _tmp21_;
	GeeList* _tmp33_;
	GError* _inner_error0_ = NULL;
	self = (WorkSniffer*) base;
	{
		GeeIterator* _job_it = NULL;
		GeeIterable* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->jobs;
		_tmp1_ = gee_iterable_iterator (_tmp0_);
		_job_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			BatchImportJob* job = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			ImportResult _result_ = 0;
			_tmp2_ = _job_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _job_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			job = (BatchImportJob*) _tmp4_;
			_result_ = background_import_job_abort_check ((BackgroundImportJob*) self);
			if (_result_ != IMPORT_RESULT_SUCCESS) {
				BatchImportJob* _tmp5_;
				BatchImportJob* _tmp6_;
				gchar* _tmp7_;
				gchar* _tmp8_;
				BatchImportJob* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				_tmp5_ = job;
				_tmp6_ = job;
				_tmp7_ = batch_import_job_get_source_identifier (_tmp6_);
				_tmp8_ = _tmp7_;
				_tmp9_ = job;
				_tmp10_ = batch_import_job_get_dest_identifier (_tmp9_);
				_tmp11_ = _tmp10_;
				background_import_job_report_failure ((BackgroundImportJob*) self, _tmp5_, NULL, _tmp8_, _tmp11_, _result_);
				_g_free0 (_tmp11_);
				_g_free0 (_tmp8_);
				_batch_import_job_unref0 (job);
				continue;
			}
			{
				BatchImportJob* _tmp12_;
				_tmp12_ = job;
				work_sniffer_sniff_job (self, _tmp12_, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				BatchImportJob* _tmp13_;
				BatchImportJob* _tmp14_;
				gchar* _tmp15_;
				gchar* _tmp16_;
				BatchImportJob* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				GError* _tmp20_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp13_ = job;
				_tmp14_ = job;
				_tmp15_ = batch_import_job_get_source_identifier (_tmp14_);
				_tmp16_ = _tmp15_;
				_tmp17_ = job;
				_tmp18_ = batch_import_job_get_dest_identifier (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = err;
				background_import_job_report_error ((BackgroundImportJob*) self, _tmp13_, NULL, _tmp16_, _tmp19_, _tmp20_, IMPORT_RESULT_FILE_ERROR);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp16_);
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				_batch_import_job_unref0 (job);
				_g_object_unref0 (_job_it);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
			if (background_job_is_cancelled ((BackgroundJob*) self)) {
				_batch_import_job_unref0 (job);
				break;
			}
			_batch_import_job_unref0 (job);
		}
		_g_object_unref0 (_job_it);
	}
	_tmp21_ = gee_array_list_new (TYPE_FILE_TO_PREPARE, (GBoxedCopyFunc) file_to_prepare_ref, (GDestroyNotify) file_to_prepare_unref, NULL, NULL, NULL);
	sorted = (GeeList*) _tmp21_;
	{
		GeeList* _ftp_list = NULL;
		GeeList* _tmp22_;
		gint _ftp_size = 0;
		GeeList* _tmp23_;
		gint _tmp24_;
		gint _tmp25_;
		gint _ftp_index = 0;
		_tmp22_ = self->files_to_prepare;
		_ftp_list = _tmp22_;
		_tmp23_ = _ftp_list;
		_tmp24_ = gee_collection_get_size ((GeeCollection*) _tmp23_);
		_tmp25_ = _tmp24_;
		_ftp_size = _tmp25_;
		_ftp_index = -1;
		while (TRUE) {
			gint _tmp26_;
			gint _tmp27_;
			FileToPrepare* ftp = NULL;
			GeeList* _tmp28_;
			gpointer _tmp29_;
			FileToPrepare* _tmp30_;
			_ftp_index = _ftp_index + 1;
			_tmp26_ = _ftp_index;
			_tmp27_ = _ftp_size;
			if (!(_tmp26_ < _tmp27_)) {
				break;
			}
			_tmp28_ = _ftp_list;
			_tmp29_ = gee_list_get (_tmp28_, _ftp_index);
			ftp = (FileToPrepare*) _tmp29_;
			_tmp30_ = ftp;
			if (!file_to_prepare_is_directory (_tmp30_)) {
				GeeList* _tmp31_;
				FileToPrepare* _tmp32_;
				_tmp31_ = sorted;
				_tmp32_ = ftp;
				gee_collection_add ((GeeCollection*) _tmp31_, _tmp32_);
			}
			_file_to_prepare_unref0 (ftp);
		}
	}
	_tmp33_ = sorted;
	gee_list_sort (_tmp33_, ___lambda16__gcompare_data_func, background_job_ref (self), background_job_unref);
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp34_ = FALSE;
			_tmp34_ = TRUE;
			while (TRUE) {
				GeeList* _tmp36_;
				gint _tmp37_;
				gint _tmp38_;
				gchar* name = NULL;
				gchar* ext = NULL;
				FileToPrepare* ftp = NULL;
				GeeList* _tmp39_;
				gpointer _tmp40_;
				FileToPrepare* _tmp41_;
				gchar* _tmp42_;
				gchar* _tmp43_;
				gchar* _tmp44_ = NULL;
				gchar* _tmp45_ = NULL;
				const gchar* _tmp46_;
				RawFileFormatProperties* _tmp47_;
				RawFileFormatProperties* _tmp48_;
				const gchar* _tmp49_;
				gboolean _tmp50_;
				if (!_tmp34_) {
					gint _tmp35_;
					i = i + 1;
					_tmp35_ = i;
				}
				_tmp34_ = FALSE;
				_tmp36_ = sorted;
				_tmp37_ = gee_collection_get_size ((GeeCollection*) _tmp36_);
				_tmp38_ = _tmp37_;
				if (!(i < _tmp38_)) {
					break;
				}
				_tmp39_ = sorted;
				_tmp40_ = gee_list_get (_tmp39_, i);
				ftp = (FileToPrepare*) _tmp40_;
				_tmp41_ = ftp;
				_tmp42_ = file_to_prepare_get_basename (_tmp41_);
				_tmp43_ = _tmp42_;
				disassemble_filename (_tmp43_, &_tmp44_, &_tmp45_);
				_g_free0 (name);
				name = _tmp44_;
				_g_free0 (ext);
				ext = _tmp45_;
				_g_free0 (_tmp43_);
				_tmp46_ = ext;
				if (is_string_empty (_tmp46_)) {
					_file_to_prepare_unref0 (ftp);
					_g_free0 (ext);
					_g_free0 (name);
					continue;
				}
				_tmp47_ = raw_file_format_properties_get_instance ();
				_tmp48_ = _tmp47_;
				_tmp49_ = ext;
				_tmp50_ = photo_file_format_properties_is_recognized_extension ((PhotoFileFormatProperties*) _tmp48_, _tmp49_);
				_photo_file_format_properties_unref0 (_tmp48_);
				if (_tmp50_) {
					gboolean _tmp51_ = FALSE;
					if (i > 0) {
						FileToPrepare* _tmp52_;
						GeeList* _tmp53_;
						gpointer _tmp54_;
						FileToPrepare* _tmp55_;
						_tmp52_ = ftp;
						_tmp53_ = sorted;
						_tmp54_ = gee_list_get (_tmp53_, i - 1);
						_tmp55_ = (FileToPrepare*) _tmp54_;
						_tmp51_ = work_sniffer_is_paired (self, _tmp52_, _tmp55_);
						_file_to_prepare_unref0 (_tmp55_);
					} else {
						_tmp51_ = FALSE;
					}
					if (_tmp51_) {
						FileToPrepare* associated_file = NULL;
						GeeList* _tmp56_;
						gpointer _tmp57_;
						GeeList* _tmp58_;
						FileToPrepare* _tmp59_;
						FileToPrepare* _tmp60_;
						FileToPrepare* _tmp61_;
						_tmp56_ = sorted;
						_tmp57_ = gee_list_get (_tmp56_, i - 1);
						associated_file = (FileToPrepare*) _tmp57_;
						_tmp58_ = self->files_to_prepare;
						_tmp59_ = associated_file;
						gee_collection_remove ((GeeCollection*) _tmp58_, _tmp59_);
						_tmp60_ = ftp;
						_tmp61_ = associated_file;
						file_to_prepare_set_associated (_tmp60_, _tmp61_);
						_file_to_prepare_unref0 (associated_file);
					} else {
						gboolean _tmp62_ = FALSE;
						GeeList* _tmp63_;
						gint _tmp64_;
						gint _tmp65_;
						_tmp63_ = sorted;
						_tmp64_ = gee_collection_get_size ((GeeCollection*) _tmp63_);
						_tmp65_ = _tmp64_;
						if (i < (_tmp65_ - 1)) {
							FileToPrepare* _tmp66_;
							GeeList* _tmp67_;
							gpointer _tmp68_;
							FileToPrepare* _tmp69_;
							_tmp66_ = ftp;
							_tmp67_ = sorted;
							_tmp68_ = gee_list_get (_tmp67_, i + 1);
							_tmp69_ = (FileToPrepare*) _tmp68_;
							_tmp62_ = work_sniffer_is_paired (self, _tmp66_, _tmp69_);
							_file_to_prepare_unref0 (_tmp69_);
						} else {
							_tmp62_ = FALSE;
						}
						if (_tmp62_) {
							FileToPrepare* associated_file = NULL;
							GeeList* _tmp70_;
							gpointer _tmp71_;
							GeeList* _tmp72_;
							FileToPrepare* _tmp73_;
							FileToPrepare* _tmp74_;
							FileToPrepare* _tmp75_;
							_tmp70_ = sorted;
							_tmp71_ = gee_list_get (_tmp70_, i + 1);
							associated_file = (FileToPrepare*) _tmp71_;
							_tmp72_ = self->files_to_prepare;
							_tmp73_ = associated_file;
							gee_collection_remove ((GeeCollection*) _tmp72_, _tmp73_);
							_tmp74_ = ftp;
							_tmp75_ = associated_file;
							file_to_prepare_set_associated (_tmp74_, _tmp75_);
							_file_to_prepare_unref0 (associated_file);
						}
					}
				}
				_file_to_prepare_unref0 (ftp);
				_g_free0 (ext);
				_g_free0 (name);
			}
		}
	}
	_g_object_unref0 (sorted);
}

static gboolean
work_sniffer_is_paired (WorkSniffer* self,
                        FileToPrepare* raw,
                        FileToPrepare* maybe_paired)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gchar* name = NULL;
	gchar* ext = NULL;
	gchar* test_name = NULL;
	gchar* test_ext = NULL;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	JfifFileFormatProperties* _tmp9_;
	JfifFileFormatProperties* _tmp10_;
	const gchar* _tmp11_;
	gboolean _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (raw != NULL, FALSE);
	g_return_val_if_fail (maybe_paired != NULL, FALSE);
	_tmp0_ = file_to_prepare_get_parent_path (raw);
	_tmp1_ = _tmp0_;
	_tmp2_ = file_to_prepare_get_parent_path (maybe_paired);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_) != 0;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	if (_tmp4_) {
		result = FALSE;
		return result;
	}
	_tmp5_ = file_to_prepare_get_basename (maybe_paired);
	_tmp6_ = _tmp5_;
	disassemble_filename (_tmp6_, &_tmp7_, &_tmp8_);
	_g_free0 (test_name);
	test_name = _tmp7_;
	_g_free0 (test_ext);
	test_ext = _tmp8_;
	_g_free0 (_tmp6_);
	_tmp9_ = jfif_file_format_properties_get_instance ();
	_tmp10_ = _tmp9_;
	_tmp11_ = test_ext;
	_tmp12_ = !photo_file_format_properties_is_recognized_extension ((PhotoFileFormatProperties*) _tmp10_, _tmp11_);
	_photo_file_format_properties_unref0 (_tmp10_);
	if (_tmp12_) {
		result = FALSE;
		_g_free0 (test_ext);
		_g_free0 (test_name);
		_g_free0 (ext);
		_g_free0 (name);
		return result;
	}
	_tmp13_ = file_to_prepare_get_basename (raw);
	_tmp14_ = _tmp13_;
	disassemble_filename (_tmp14_, &_tmp15_, &_tmp16_);
	_g_free0 (name);
	name = _tmp15_;
	_g_free0 (ext);
	ext = _tmp16_;
	_g_free0 (_tmp14_);
	_tmp17_ = name;
	_tmp18_ = test_name;
	result = g_strcmp0 (_tmp17_, _tmp18_) == 0;
	_g_free0 (test_ext);
	_g_free0 (test_name);
	_g_free0 (ext);
	_g_free0 (name);
	return result;
}

static void
work_sniffer_sniff_job (WorkSniffer* self,
                        BatchImportJob* job,
                        GError** error)
{
	guint64 size = 0ULL;
	GFile* file_or_dir = NULL;
	gboolean determined_size = FALSE;
	guint64 _tmp0_ = 0ULL;
	GFile* _tmp1_ = NULL;
	gboolean _tmp2_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (job != NULL);
	_tmp2_ = batch_import_job_determine_file_size (job, &_tmp0_, &_tmp1_);
	size = _tmp0_;
	_g_object_unref0 (file_or_dir);
	file_or_dir = _tmp1_;
	determined_size = _tmp2_;
	if (determined_size) {
		self->total_bytes = self->total_bytes + size;
	}
	if (batch_import_job_is_directory (job)) {
		GFile* dir = NULL;
		gboolean copy_to_library = FALSE;
		gboolean _tmp3_ = FALSE;
		GFile* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_;
		GFile* _tmp11_;
		_tmp6_ = batch_import_job_prepare (job, &_tmp4_, &_tmp5_, &_inner_error0_);
		_g_object_unref0 (dir);
		dir = _tmp4_;
		copy_to_library = _tmp5_;
		_tmp3_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (dir);
			_g_object_unref0 (file_or_dir);
			return;
		}
		if (!_tmp3_) {
			gchar* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			_tmp7_ = batch_import_job_get_source_identifier (job);
			_tmp8_ = _tmp7_;
			_tmp9_ = batch_import_job_get_dest_identifier (job);
			_tmp10_ = _tmp9_;
			background_import_job_report_failure ((BackgroundImportJob*) self, job, NULL, _tmp8_, _tmp10_, IMPORT_RESULT_FILE_ERROR);
			_g_free0 (_tmp10_);
			_g_free0 (_tmp8_);
			_g_object_unref0 (dir);
			_g_object_unref0 (file_or_dir);
			return;
		}
		_tmp11_ = dir;
		_vala_assert (query_is_directory (_tmp11_), "query_is_directory (dir)");
		{
			GFile* _tmp12_;
			_tmp12_ = dir;
			work_sniffer_search_dir (self, job, _tmp12_, copy_to_library, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GFile* _tmp13_;
			gchar* _tmp14_;
			gchar* _tmp15_;
			GFile* _tmp16_;
			gchar* _tmp17_;
			gchar* _tmp18_;
			GError* _tmp19_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp13_ = dir;
			_tmp14_ = batch_import_job_get_source_identifier (job);
			_tmp15_ = _tmp14_;
			_tmp16_ = dir;
			_tmp17_ = g_file_get_path (_tmp16_);
			_tmp18_ = _tmp17_;
			_tmp19_ = err;
			background_import_job_report_error ((BackgroundImportJob*) self, job, _tmp13_, _tmp15_, _tmp18_, _tmp19_, IMPORT_RESULT_FILE_ERROR);
			_g_free0 (_tmp18_);
			_g_free0 (_tmp15_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (dir);
			_g_object_unref0 (file_or_dir);
			return;
		}
		_g_object_unref0 (dir);
	} else {
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		GFile* _tmp27_;
		GeeList* _tmp31_;
		FileToPrepare* _tmp32_;
		FileToPrepare* _tmp33_;
		if (!determined_size) {
			guint64 _tmp20_ = 0ULL;
			GFile* _tmp21_;
			GCancellable* _tmp22_;
			GCancellable* _tmp23_;
			guint64 _tmp24_;
			_tmp21_ = file_or_dir;
			_tmp22_ = background_job_get_cancellable ((BackgroundJob*) self);
			_tmp23_ = _tmp22_;
			_tmp24_ = query_total_file_size (_tmp21_, _tmp23_, &_inner_error0_);
			_g_object_unref0 (_tmp23_);
			_tmp20_ = _tmp24_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (file_or_dir);
				return;
			}
			self->total_bytes = self->total_bytes + _tmp20_;
		}
		_tmp27_ = file_or_dir;
		if (_tmp27_ != NULL) {
			GeeHashSet* _tmp28_;
			_tmp28_ = self->priv->skipset;
			_tmp26_ = _tmp28_ != NULL;
		} else {
			_tmp26_ = FALSE;
		}
		if (_tmp26_) {
			GeeHashSet* _tmp29_;
			GFile* _tmp30_;
			_tmp29_ = self->priv->skipset;
			_tmp30_ = file_or_dir;
			_tmp25_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp29_, _tmp30_);
		} else {
			_tmp25_ = FALSE;
		}
		if (_tmp25_) {
			_g_object_unref0 (file_or_dir);
			return;
		}
		_tmp31_ = self->files_to_prepare;
		_tmp32_ = file_to_prepare_new (job, NULL, TRUE);
		_tmp33_ = _tmp32_;
		gee_collection_add ((GeeCollection*) _tmp31_, _tmp33_);
		_file_to_prepare_unref0 (_tmp33_);
	}
	_g_object_unref0 (file_or_dir);
}

void
work_sniffer_search_dir (WorkSniffer* self,
                         BatchImportJob* job,
                         GFile* dir,
                         gboolean copy_to_library,
                         GError** error)
{
	GFileEnumerator* enumerator = NULL;
	GFileEnumerator* _tmp0_;
	GFileInfo* info = NULL;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (job != NULL);
	g_return_if_fail (dir != NULL);
	_tmp0_ = g_file_enumerate_children (dir, "standard::*", G_FILE_QUERY_INFO_NOFOLLOW_SYMLINKS, NULL, &_inner_error0_);
	enumerator = _tmp0_;
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	info = NULL;
	while (TRUE) {
		GFileInfo* _tmp1_ = NULL;
		GFileEnumerator* _tmp2_;
		GCancellable* _tmp3_;
		GCancellable* _tmp4_;
		GFileInfo* _tmp5_;
		GFileInfo* _tmp6_;
		GFileInfo* _tmp7_;
		GFileInfo* _tmp8_;
		GFile* child = NULL;
		GFileInfo* _tmp9_;
		const gchar* _tmp10_;
		GFile* _tmp11_;
		GFileType file_type = 0;
		GFileInfo* _tmp12_;
		_tmp2_ = enumerator;
		_tmp3_ = background_job_get_cancellable ((BackgroundJob*) self);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_file_enumerator_next_file (_tmp2_, _tmp4_, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_object_unref0 (_tmp4_);
		_tmp1_ = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (info);
			_g_object_unref0 (enumerator);
			return;
		}
		_tmp7_ = _tmp1_;
		_tmp1_ = NULL;
		_g_object_unref0 (info);
		info = _tmp7_;
		_tmp8_ = info;
		if (!(_tmp8_ != NULL)) {
			_g_object_unref0 (_tmp1_);
			break;
		}
		if (background_job_is_cancelled ((BackgroundJob*) self)) {
			_g_object_unref0 (_tmp1_);
			break;
		}
		_tmp9_ = info;
		_tmp10_ = g_file_info_get_name (_tmp9_);
		_tmp11_ = g_file_get_child (dir, _tmp10_);
		child = _tmp11_;
		_tmp12_ = info;
		file_type = g_file_info_get_file_type (_tmp12_);
		if (file_type == G_FILE_TYPE_DIRECTORY) {
			GFileInfo* _tmp13_;
			const gchar* _tmp14_;
			_tmp13_ = info;
			_tmp14_ = g_file_info_get_name (_tmp13_);
			if (g_str_has_prefix (_tmp14_, ".")) {
				_g_object_unref0 (child);
				_g_object_unref0 (_tmp1_);
				continue;
			}
			{
				GFile* _tmp15_;
				_tmp15_ = child;
				work_sniffer_search_dir (self, job, _tmp15_, copy_to_library, &_inner_error0_);
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					goto __catch0_g_error;
				}
			}
			goto __finally0;
			__catch0_g_error:
			{
				GError* err = NULL;
				GFile* _tmp16_;
				GFile* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				GFile* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				GError* _tmp23_;
				err = _inner_error0_;
				_inner_error0_ = NULL;
				_tmp16_ = child;
				_tmp17_ = child;
				_tmp18_ = g_file_get_path (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp20_ = child;
				_tmp21_ = g_file_get_path (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = err;
				background_import_job_report_error ((BackgroundImportJob*) self, job, _tmp16_, _tmp19_, _tmp22_, _tmp23_, IMPORT_RESULT_FILE_ERROR);
				_g_free0 (_tmp22_);
				_g_free0 (_tmp19_);
				_g_error_free0 (err);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				g_propagate_error (error, _inner_error0_);
				_g_object_unref0 (child);
				_g_object_unref0 (_tmp1_);
				_g_object_unref0 (info);
				_g_object_unref0 (enumerator);
				return;
			}
		} else {
			if (file_type == G_FILE_TYPE_REGULAR) {
				gboolean _tmp24_ = FALSE;
				GeeHashSet* _tmp25_;
				gboolean _tmp28_ = FALSE;
				gboolean _tmp29_ = FALSE;
				GFile* _tmp30_;
				_tmp25_ = self->priv->skipset;
				if (_tmp25_ != NULL) {
					GeeHashSet* _tmp26_;
					GFile* _tmp27_;
					_tmp26_ = self->priv->skipset;
					_tmp27_ = child;
					_tmp24_ = gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp26_, _tmp27_);
				} else {
					_tmp24_ = FALSE;
				}
				if (_tmp24_) {
					_g_object_unref0 (child);
					_g_object_unref0 (_tmp1_);
					continue;
				}
				_tmp30_ = child;
				if (photo_is_file_image (_tmp30_)) {
					GFile* _tmp31_;
					_tmp31_ = child;
					_tmp29_ = photo_file_format_is_file_supported (_tmp31_);
				} else {
					_tmp29_ = FALSE;
				}
				if (_tmp29_) {
					_tmp28_ = TRUE;
				} else {
					GFile* _tmp32_;
					_tmp32_ = child;
					_tmp28_ = video_reader_is_supported_video_file (_tmp32_);
				}
				if (_tmp28_) {
					GFileInfo* _tmp33_;
					GeeList* _tmp34_;
					GFile* _tmp35_;
					FileToPrepare* _tmp36_;
					FileToPrepare* _tmp37_;
					_tmp33_ = info;
					self->total_bytes = self->total_bytes + g_file_info_get_size (_tmp33_);
					_tmp34_ = self->files_to_prepare;
					_tmp35_ = child;
					_tmp36_ = file_to_prepare_new (job, _tmp35_, copy_to_library);
					_tmp37_ = _tmp36_;
					gee_collection_add ((GeeCollection*) _tmp34_, _tmp37_);
					_file_to_prepare_unref0 (_tmp37_);
					_g_object_unref0 (child);
					_g_object_unref0 (_tmp1_);
					continue;
				}
			} else {
				GFile* _tmp38_;
				gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp38_ = child;
				_tmp39_ = g_file_get_path (_tmp38_);
				_tmp40_ = _tmp39_;
				g_warning ("BatchImport.vala:1628: Ignoring import of %s file type %d", _tmp40_, (gint) file_type);
				_g_free0 (_tmp40_);
			}
		}
		_g_object_unref0 (child);
		_g_object_unref0 (_tmp1_);
	}
	_g_object_unref0 (info);
	_g_object_unref0 (enumerator);
}

static void
work_sniffer_class_init (WorkSnifferClass * klass,
                         gpointer klass_data)
{
	work_sniffer_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = work_sniffer_finalize;
	g_type_class_adjust_private_offset (klass, &WorkSniffer_private_offset);
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) work_sniffer_real_execute;
}

static void
work_sniffer_instance_init (WorkSniffer * self,
                            gpointer klass)
{
	GeeArrayList* _tmp0_;
	self->priv = work_sniffer_get_instance_private (self);
	_tmp0_ = gee_array_list_new (TYPE_FILE_TO_PREPARE, (GBoxedCopyFunc) file_to_prepare_ref, (GDestroyNotify) file_to_prepare_unref, NULL, NULL, NULL);
	self->files_to_prepare = (GeeList*) _tmp0_;
	self->total_bytes = (guint64) 0;
}

static void
work_sniffer_finalize (BackgroundJob * obj)
{
	WorkSniffer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_WORK_SNIFFER, WorkSniffer);
	_g_object_unref0 (self->files_to_prepare);
	_g_object_unref0 (self->priv->jobs);
	_g_object_unref0 (self->priv->skipset);
	BACKGROUND_JOB_CLASS (work_sniffer_parent_class)->finalize (obj);
}

static GType
work_sniffer_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (WorkSnifferClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) work_sniffer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (WorkSniffer), 0, (GInstanceInitFunc) work_sniffer_instance_init, NULL };
	GType work_sniffer_type_id;
	work_sniffer_type_id = g_type_register_static (TYPE_BACKGROUND_IMPORT_JOB, "WorkSniffer", &g_define_type_info, 0);
	WorkSniffer_private_offset = g_type_add_instance_private (work_sniffer_type_id, sizeof (WorkSnifferPrivate));
	return work_sniffer_type_id;
}

GType
work_sniffer_get_type (void)
{
	static volatile gsize work_sniffer_type_id__once = 0;
	if (g_once_init_enter (&work_sniffer_type_id__once)) {
		GType work_sniffer_type_id;
		work_sniffer_type_id = work_sniffer_get_type_once ();
		g_once_init_leave (&work_sniffer_type_id__once, work_sniffer_type_id);
	}
	return work_sniffer_type_id__once;
}

PreparedFile*
prepared_file_construct (GType object_type,
                         BatchImportJob* job,
                         GFile* file,
                         GFile* associated_file,
                         const gchar* source_id,
                         const gchar* dest_id,
                         gboolean copy_to_library,
                         const gchar* exif_md5,
                         const gchar* thumbnail_md5,
                         const gchar* full_md5,
                         PhotoFileFormat file_format,
                         guint64 filesize,
                         gboolean is_video)
{
	PreparedFile* self = NULL;
	BatchImportJob* _tmp0_;
	GFile* _tmp1_;
	GFile* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	g_return_val_if_fail (job != NULL, NULL);
	g_return_val_if_fail (file != NULL, NULL);
	g_return_val_if_fail (source_id != NULL, NULL);
	g_return_val_if_fail (dest_id != NULL, NULL);
	self = (PreparedFile*) g_type_create_instance (object_type);
	_tmp0_ = _batch_import_job_ref0 (job);
	_batch_import_job_unref0 (self->job);
	self->job = _tmp0_;
	self->result = IMPORT_RESULT_SUCCESS;
	_tmp1_ = _g_object_ref0 (file);
	_g_object_unref0 (self->file);
	self->file = _tmp1_;
	_tmp2_ = _g_object_ref0 (associated_file);
	_g_object_unref0 (self->associated_file);
	self->associated_file = _tmp2_;
	_tmp3_ = g_strdup (source_id);
	_g_free0 (self->source_id);
	self->source_id = _tmp3_;
	_tmp4_ = g_strdup (dest_id);
	_g_free0 (self->dest_id);
	self->dest_id = _tmp4_;
	self->copy_to_library = copy_to_library;
	_tmp5_ = g_strdup (exif_md5);
	_g_free0 (self->exif_md5);
	self->exif_md5 = _tmp5_;
	_tmp6_ = g_strdup (thumbnail_md5);
	_g_free0 (self->thumbnail_md5);
	self->thumbnail_md5 = _tmp6_;
	_tmp7_ = g_strdup (full_md5);
	_g_free0 (self->full_md5);
	self->full_md5 = _tmp7_;
	self->file_format = file_format;
	self->filesize = filesize;
	self->is_video = is_video;
	return self;
}

PreparedFile*
prepared_file_new (BatchImportJob* job,
                   GFile* file,
                   GFile* associated_file,
                   const gchar* source_id,
                   const gchar* dest_id,
                   gboolean copy_to_library,
                   const gchar* exif_md5,
                   const gchar* thumbnail_md5,
                   const gchar* full_md5,
                   PhotoFileFormat file_format,
                   guint64 filesize,
                   gboolean is_video)
{
	return prepared_file_construct (TYPE_PREPARED_FILE, job, file, associated_file, source_id, dest_id, copy_to_library, exif_md5, thumbnail_md5, full_md5, file_format, filesize, is_video);
}

static void
value_prepared_file_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_prepared_file_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		prepared_file_unref (value->data[0].v_pointer);
	}
}

static void
value_prepared_file_copy_value (const GValue* src_value,
                                GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = prepared_file_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_prepared_file_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_prepared_file_collect_value (GValue* value,
                                   guint n_collect_values,
                                   GTypeCValue* collect_values,
                                   guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PreparedFile * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = prepared_file_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_prepared_file_lcopy_value (const GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	PreparedFile ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = prepared_file_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_prepared_file (const gchar* name,
                          const gchar* nick,
                          const gchar* blurb,
                          GType object_type,
                          GParamFlags flags)
{
	ParamSpecPreparedFile* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_PREPARED_FILE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_prepared_file (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PREPARED_FILE), NULL);
	return value->data[0].v_pointer;
}

void
value_set_prepared_file (GValue* value,
                         gpointer v_object)
{
	PreparedFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PREPARED_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PREPARED_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		prepared_file_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		prepared_file_unref (old);
	}
}

void
value_take_prepared_file (GValue* value,
                          gpointer v_object)
{
	PreparedFile * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_PREPARED_FILE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_PREPARED_FILE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		prepared_file_unref (old);
	}
}

static void
prepared_file_class_init (PreparedFileClass * klass,
                          gpointer klass_data)
{
	prepared_file_parent_class = g_type_class_peek_parent (klass);
	((PreparedFileClass *) klass)->finalize = prepared_file_finalize;
}

static void
prepared_file_instance_init (PreparedFile * self,
                             gpointer klass)
{
	self->associated_file = NULL;
	self->ref_count = 1;
}

static void
prepared_file_finalize (PreparedFile * obj)
{
	PreparedFile * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREPARED_FILE, PreparedFile);
	g_signal_handlers_destroy (self);
	_batch_import_job_unref0 (self->job);
	_g_object_unref0 (self->file);
	_g_object_unref0 (self->associated_file);
	_g_free0 (self->source_id);
	_g_free0 (self->dest_id);
	_g_free0 (self->exif_md5);
	_g_free0 (self->thumbnail_md5);
	_g_free0 (self->full_md5);
}

static GType
prepared_file_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_prepared_file_init, value_prepared_file_free_value, value_prepared_file_copy_value, value_prepared_file_peek_pointer, "p", value_prepared_file_collect_value, "p", value_prepared_file_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PreparedFileClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prepared_file_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreparedFile), 0, (GInstanceInitFunc) prepared_file_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType prepared_file_type_id;
	prepared_file_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PreparedFile", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return prepared_file_type_id;
}

GType
prepared_file_get_type (void)
{
	static volatile gsize prepared_file_type_id__once = 0;
	if (g_once_init_enter (&prepared_file_type_id__once)) {
		GType prepared_file_type_id;
		prepared_file_type_id = prepared_file_get_type_once ();
		g_once_init_leave (&prepared_file_type_id__once, prepared_file_type_id);
	}
	return prepared_file_type_id__once;
}

gpointer
prepared_file_ref (gpointer instance)
{
	PreparedFile * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
prepared_file_unref (gpointer instance)
{
	PreparedFile * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		PREPARED_FILE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

PreparedFileCluster*
prepared_file_cluster_construct (GType object_type,
                                 GeeArrayList* list)
{
	PreparedFileCluster* self = NULL;
	GeeArrayList* _tmp0_;
	g_return_val_if_fail (list != NULL, NULL);
	self = (PreparedFileCluster*) interlocked_notification_object_construct (object_type);
	_tmp0_ = _g_object_ref0 (list);
	_g_object_unref0 (self->list);
	self->list = _tmp0_;
	return self;
}

PreparedFileCluster*
prepared_file_cluster_new (GeeArrayList* list)
{
	return prepared_file_cluster_construct (TYPE_PREPARED_FILE_CLUSTER, list);
}

static void
prepared_file_cluster_class_init (PreparedFileClusterClass * klass,
                                  gpointer klass_data)
{
	prepared_file_cluster_parent_class = g_type_class_peek_parent (klass);
	((NotificationObjectClass *) klass)->finalize = prepared_file_cluster_finalize;
}

static void
prepared_file_cluster_instance_init (PreparedFileCluster * self,
                                     gpointer klass)
{
}

static void
prepared_file_cluster_finalize (NotificationObject * obj)
{
	PreparedFileCluster * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREPARED_FILE_CLUSTER, PreparedFileCluster);
	_g_object_unref0 (self->list);
	NOTIFICATION_OBJECT_CLASS (prepared_file_cluster_parent_class)->finalize (obj);
}

static GType
prepared_file_cluster_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PreparedFileClusterClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prepared_file_cluster_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreparedFileCluster), 0, (GInstanceInitFunc) prepared_file_cluster_instance_init, NULL };
	GType prepared_file_cluster_type_id;
	prepared_file_cluster_type_id = g_type_register_static (TYPE_INTERLOCKED_NOTIFICATION_OBJECT, "PreparedFileCluster", &g_define_type_info, 0);
	return prepared_file_cluster_type_id;
}

GType
prepared_file_cluster_get_type (void)
{
	static volatile gsize prepared_file_cluster_type_id__once = 0;
	if (g_once_init_enter (&prepared_file_cluster_type_id__once)) {
		GType prepared_file_cluster_type_id;
		prepared_file_cluster_type_id = prepared_file_cluster_get_type_once ();
		g_once_init_leave (&prepared_file_cluster_type_id__once, prepared_file_cluster_type_id);
	}
	return prepared_file_cluster_type_id__once;
}

static inline gpointer
prepare_files_job_get_instance_private (PrepareFilesJob* self)
{
	return G_STRUCT_MEMBER_P (self, PrepareFilesJob_private_offset);
}

PrepareFilesJob*
prepare_files_job_construct (GType object_type,
                             BatchImport* owner,
                             GeeList* files_to_prepare,
                             NotificationCallback notification,
                             gpointer notification_target,
                             CompletionCallback callback,
                             gpointer callback_target,
                             GCancellable* cancellable,
                             CancellationCallback cancellation,
                             gpointer cancellation_target)
{
	PrepareFilesJob* self = NULL;
	GeeList* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (owner != NULL, NULL);
	g_return_val_if_fail (files_to_prepare != NULL, NULL);
	g_return_val_if_fail (cancellable != NULL, NULL);
	self = (PrepareFilesJob*) background_import_job_construct (object_type, owner, callback, callback_target, cancellable, cancellation, cancellation_target);
	_tmp0_ = _g_object_ref0 (files_to_prepare);
	_g_object_unref0 (self->priv->files_to_prepare);
	self->priv->files_to_prepare = _tmp0_;
	self->priv->notification = notification;
	self->priv->notification_target = notification_target;
	_tmp1_ = app_dirs_get_import_dir ();
	_g_object_unref0 (self->priv->library_dir);
	self->priv->library_dir = _tmp1_;
	self->priv->fail_every = prepare_files_job_get_test_variable ("SHOTWELL_FAIL_EVERY");
	self->priv->skip_every = prepare_files_job_get_test_variable ("SHOTWELL_SKIP_EVERY");
	background_job_set_notification_priority ((BackgroundJob*) self, G_PRIORITY_LOW);
	return self;
}

PrepareFilesJob*
prepare_files_job_new (BatchImport* owner,
                       GeeList* files_to_prepare,
                       NotificationCallback notification,
                       gpointer notification_target,
                       CompletionCallback callback,
                       gpointer callback_target,
                       GCancellable* cancellable,
                       CancellationCallback cancellation,
                       gpointer cancellation_target)
{
	return prepare_files_job_construct (TYPE_PREPARE_FILES_JOB, owner, files_to_prepare, notification, notification_target, callback, callback_target, cancellable, cancellation, cancellation_target);
}

static gint
prepare_files_job_get_test_variable (const gchar* name)
{
	gchar* value = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp2_ = 0;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gint result;
	g_return_val_if_fail (name != NULL, 0);
	_tmp0_ = g_getenv (name);
	_tmp1_ = g_strdup (_tmp0_);
	value = _tmp1_;
	_tmp4_ = value;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		gint _tmp6_;
		gint _tmp7_;
		_tmp5_ = value;
		_tmp6_ = strlen (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp3_ = _tmp7_ == 0;
	}
	if (_tmp3_) {
		_tmp2_ = 0;
	} else {
		const gchar* _tmp8_;
		_tmp8_ = value;
		_tmp2_ = atoi (_tmp8_);
	}
	result = _tmp2_;
	_g_free0 (value);
	return result;
}

static void
prepare_files_job_real_execute (BackgroundJob* base)
{
	PrepareFilesJob * self;
	GTimer* timer = NULL;
	GTimer* _tmp0_;
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp1_;
	GeeArrayList* _tmp79_;
	gint _tmp80_;
	gint _tmp81_;
	self = (PrepareFilesJob*) base;
	_tmp0_ = g_timer_new ();
	timer = _tmp0_;
	_tmp1_ = gee_array_list_new (TYPE_PREPARED_FILE, (GBoxedCopyFunc) prepared_file_ref, (GDestroyNotify) prepared_file_unref, NULL, NULL, NULL);
	list = _tmp1_;
	{
		GeeList* _file_to_prepare_list = NULL;
		GeeList* _tmp2_;
		gint _file_to_prepare_size = 0;
		GeeList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _file_to_prepare_index = 0;
		_tmp2_ = self->priv->files_to_prepare;
		_file_to_prepare_list = _tmp2_;
		_tmp3_ = _file_to_prepare_list;
		_tmp4_ = gee_collection_get_size ((GeeCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_file_to_prepare_size = _tmp5_;
		_file_to_prepare_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			FileToPrepare* file_to_prepare = NULL;
			GeeList* _tmp8_;
			gpointer _tmp9_;
			ImportResult _result_ = 0;
			BatchImportJob* job = NULL;
			FileToPrepare* _tmp20_;
			BatchImportJob* _tmp21_;
			BatchImportJob* _tmp22_;
			GFile* file = NULL;
			FileToPrepare* _tmp23_;
			GFile* _tmp24_;
			GFile* _tmp25_;
			GFile* _tmp26_ = NULL;
			FileToPrepare* _tmp27_;
			FileToPrepare* _tmp28_;
			GFile* associated = NULL;
			GFile* _tmp32_;
			gboolean copy_to_library = FALSE;
			FileToPrepare* _tmp33_;
			GFile* _tmp34_;
			gboolean _tmp39_ = FALSE;
			GFile* _tmp40_;
			PreparedFile* prepared_file = NULL;
			BatchImportJob* _tmp48_;
			GFile* _tmp49_;
			GFile* _tmp50_;
			PreparedFile* _tmp51_ = NULL;
			ImportResult _tmp52_;
			gboolean _tmp64_ = FALSE;
			GeeArrayList* _tmp65_;
			gint _tmp66_;
			gint _tmp67_;
			_file_to_prepare_index = _file_to_prepare_index + 1;
			_tmp6_ = _file_to_prepare_index;
			_tmp7_ = _file_to_prepare_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _file_to_prepare_list;
			_tmp9_ = gee_list_get (_tmp8_, _file_to_prepare_index);
			file_to_prepare = (FileToPrepare*) _tmp9_;
			_result_ = background_import_job_abort_check ((BackgroundImportJob*) self);
			if (_result_ != IMPORT_RESULT_SUCCESS) {
				FileToPrepare* _tmp10_;
				BatchImportJob* _tmp11_;
				FileToPrepare* _tmp12_;
				BatchImportJob* _tmp13_;
				gchar* _tmp14_;
				gchar* _tmp15_;
				FileToPrepare* _tmp16_;
				BatchImportJob* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				_tmp10_ = file_to_prepare;
				_tmp11_ = _tmp10_->job;
				_tmp12_ = file_to_prepare;
				_tmp13_ = _tmp12_->job;
				_tmp14_ = batch_import_job_get_dest_identifier (_tmp13_);
				_tmp15_ = _tmp14_;
				_tmp16_ = file_to_prepare;
				_tmp17_ = _tmp16_->job;
				_tmp18_ = batch_import_job_get_source_identifier (_tmp17_);
				_tmp19_ = _tmp18_;
				background_import_job_report_failure ((BackgroundImportJob*) self, _tmp11_, NULL, _tmp15_, _tmp19_, _result_);
				_g_free0 (_tmp19_);
				_g_free0 (_tmp15_);
				_file_to_prepare_unref0 (file_to_prepare);
				continue;
			}
			_tmp20_ = file_to_prepare;
			_tmp21_ = _tmp20_->job;
			_tmp22_ = _batch_import_job_ref0 (_tmp21_);
			job = _tmp22_;
			_tmp23_ = file_to_prepare;
			_tmp24_ = _tmp23_->file;
			_tmp25_ = _g_object_ref0 (_tmp24_);
			file = _tmp25_;
			_tmp27_ = file_to_prepare;
			_tmp28_ = _tmp27_->associated;
			if (_tmp28_ != NULL) {
				FileToPrepare* _tmp29_;
				FileToPrepare* _tmp30_;
				GFile* _tmp31_;
				_tmp29_ = file_to_prepare;
				_tmp30_ = _tmp29_->associated;
				_tmp31_ = _tmp30_->file;
				_tmp26_ = _tmp31_;
			} else {
				_tmp26_ = NULL;
			}
			_tmp32_ = _g_object_ref0 (_tmp26_);
			associated = _tmp32_;
			_tmp33_ = file_to_prepare;
			copy_to_library = _tmp33_->copy_to_library;
			_tmp34_ = file;
			if (_tmp34_ == NULL) {
				BatchImportJob* _tmp35_;
				GFile* _tmp36_ = NULL;
				gboolean _tmp37_ = FALSE;
				gboolean _tmp38_;
				_tmp35_ = job;
				_tmp38_ = prepare_files_job_create_file (self, _tmp35_, &_tmp36_, &_tmp37_);
				_g_object_unref0 (file);
				file = _tmp36_;
				copy_to_library = _tmp37_;
				if (!_tmp38_) {
					_g_object_unref0 (associated);
					_g_object_unref0 (file);
					_batch_import_job_unref0 (job);
					_file_to_prepare_unref0 (file_to_prepare);
					continue;
				}
			}
			_tmp40_ = associated;
			if (_tmp40_ == NULL) {
				FileToPrepare* _tmp41_;
				FileToPrepare* _tmp42_;
				_tmp41_ = file_to_prepare;
				_tmp42_ = _tmp41_->associated;
				_tmp39_ = _tmp42_ != NULL;
			} else {
				_tmp39_ = FALSE;
			}
			if (_tmp39_) {
				FileToPrepare* _tmp43_;
				FileToPrepare* _tmp44_;
				BatchImportJob* _tmp45_;
				GFile* _tmp46_ = NULL;
				gboolean _tmp47_ = FALSE;
				_tmp43_ = file_to_prepare;
				_tmp44_ = _tmp43_->associated;
				_tmp45_ = _tmp44_->job;
				prepare_files_job_create_file (self, _tmp45_, &_tmp46_, &_tmp47_);
				_g_object_unref0 (associated);
				associated = _tmp46_;
				copy_to_library = _tmp47_;
			}
			_tmp48_ = job;
			_tmp49_ = file;
			_tmp50_ = associated;
			_tmp52_ = prepare_files_job_prepare_file (self, _tmp48_, _tmp49_, _tmp50_, copy_to_library, &_tmp51_);
			_prepared_file_unref0 (prepared_file);
			prepared_file = _tmp51_;
			_result_ = _tmp52_;
			if (_result_ == IMPORT_RESULT_SUCCESS) {
				gint _tmp53_;
				GeeArrayList* _tmp54_;
				PreparedFile* _tmp55_;
				_tmp53_ = self->prepared_files;
				self->prepared_files = _tmp53_ + 1;
				_tmp54_ = list;
				_tmp55_ = prepared_file;
				gee_abstract_collection_add ((GeeAbstractCollection*) _tmp54_, _tmp55_);
			} else {
				BatchImportJob* _tmp56_;
				GFile* _tmp57_;
				BatchImportJob* _tmp58_;
				gchar* _tmp59_;
				gchar* _tmp60_;
				GFile* _tmp61_;
				gchar* _tmp62_;
				gchar* _tmp63_;
				_tmp56_ = job;
				_tmp57_ = file;
				_tmp58_ = job;
				_tmp59_ = batch_import_job_get_source_identifier (_tmp58_);
				_tmp60_ = _tmp59_;
				_tmp61_ = file;
				_tmp62_ = g_file_get_path (_tmp61_);
				_tmp63_ = _tmp62_;
				background_import_job_report_failure ((BackgroundImportJob*) self, _tmp56_, _tmp57_, _tmp60_, _tmp63_, _result_);
				_g_free0 (_tmp63_);
				_g_free0 (_tmp60_);
			}
			_tmp65_ = list;
			_tmp66_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp65_);
			_tmp67_ = _tmp66_;
			if (_tmp67_ >= BATCH_IMPORT_REPORT_EVERY_N_PREPARED_FILES) {
				_tmp64_ = TRUE;
			} else {
				gboolean _tmp68_ = FALSE;
				GTimer* _tmp69_;
				_tmp69_ = timer;
				if ((g_timer_elapsed (_tmp69_, NULL) * 1000.0) > ((gdouble) BATCH_IMPORT_REPORT_PREPARED_FILES_EVERY_N_MSEC)) {
					GeeArrayList* _tmp70_;
					gint _tmp71_;
					gint _tmp72_;
					_tmp70_ = list;
					_tmp71_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp70_);
					_tmp72_ = _tmp71_;
					_tmp68_ = _tmp72_ > 0;
				} else {
					_tmp68_ = FALSE;
				}
				_tmp64_ = _tmp68_;
			}
			if (_tmp64_) {
				PreparedFileCluster* cluster = NULL;
				GeeArrayList* _tmp73_;
				PreparedFileCluster* _tmp74_;
				GeeArrayList* _tmp75_;
				NotificationCallback _tmp76_;
				gpointer _tmp76__target;
				PreparedFileCluster* _tmp77_;
				GTimer* _tmp78_;
				_tmp73_ = list;
				_tmp74_ = prepared_file_cluster_new (_tmp73_);
				cluster = _tmp74_;
				_tmp75_ = gee_array_list_new (TYPE_PREPARED_FILE, (GBoxedCopyFunc) prepared_file_ref, (GDestroyNotify) prepared_file_unref, NULL, NULL, NULL);
				_g_object_unref0 (list);
				list = _tmp75_;
				_tmp76_ = self->priv->notification;
				_tmp76__target = self->priv->notification_target;
				_tmp77_ = cluster;
				background_job_notify ((BackgroundJob*) self, _tmp76_, _tmp76__target, (NotificationObject*) _tmp77_);
				_tmp78_ = timer;
				g_timer_start (_tmp78_);
				_notification_object_unref0 (cluster);
			}
			_prepared_file_unref0 (prepared_file);
			_g_object_unref0 (associated);
			_g_object_unref0 (file);
			_batch_import_job_unref0 (job);
			_file_to_prepare_unref0 (file_to_prepare);
		}
	}
	_tmp79_ = list;
	_tmp80_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp79_);
	_tmp81_ = _tmp80_;
	if (_tmp81_ > 0) {
		ImportResult _result_ = 0;
		_result_ = background_import_job_abort_check ((BackgroundImportJob*) self);
		if (_result_ == IMPORT_RESULT_SUCCESS) {
			NotificationCallback _tmp82_;
			gpointer _tmp82__target;
			GeeArrayList* _tmp83_;
			PreparedFileCluster* _tmp84_;
			PreparedFileCluster* _tmp85_;
			_tmp82_ = self->priv->notification;
			_tmp82__target = self->priv->notification_target;
			_tmp83_ = list;
			_tmp84_ = prepared_file_cluster_new (_tmp83_);
			_tmp85_ = _tmp84_;
			background_job_notify ((BackgroundJob*) self, _tmp82_, _tmp82__target, (NotificationObject*) _tmp85_);
			_notification_object_unref0 (_tmp85_);
		} else {
			GeeArrayList* _tmp86_;
			gint _tmp87_;
			gint _tmp88_;
			GeeArrayList* _tmp89_;
			gint _tmp90_;
			gint _tmp91_;
			_tmp86_ = list;
			_tmp87_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp86_);
			_tmp88_ = _tmp87_;
			_vala_assert (self->prepared_files >= _tmp88_, "prepared_files >= list.size");
			_tmp89_ = list;
			_tmp90_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp89_);
			_tmp91_ = _tmp90_;
			self->prepared_files = self->prepared_files - _tmp91_;
			{
				GeeArrayList* _prepared_file_list = NULL;
				GeeArrayList* _tmp92_;
				gint _prepared_file_size = 0;
				GeeArrayList* _tmp93_;
				gint _tmp94_;
				gint _tmp95_;
				gint _prepared_file_index = 0;
				_tmp92_ = list;
				_prepared_file_list = _tmp92_;
				_tmp93_ = _prepared_file_list;
				_tmp94_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp93_);
				_tmp95_ = _tmp94_;
				_prepared_file_size = _tmp95_;
				_prepared_file_index = -1;
				while (TRUE) {
					gint _tmp96_;
					gint _tmp97_;
					PreparedFile* prepared_file = NULL;
					GeeArrayList* _tmp98_;
					gpointer _tmp99_;
					PreparedFile* _tmp100_;
					BatchImportJob* _tmp101_;
					PreparedFile* _tmp102_;
					GFile* _tmp103_;
					PreparedFile* _tmp104_;
					BatchImportJob* _tmp105_;
					gchar* _tmp106_;
					gchar* _tmp107_;
					PreparedFile* _tmp108_;
					GFile* _tmp109_;
					gchar* _tmp110_;
					gchar* _tmp111_;
					_prepared_file_index = _prepared_file_index + 1;
					_tmp96_ = _prepared_file_index;
					_tmp97_ = _prepared_file_size;
					if (!(_tmp96_ < _tmp97_)) {
						break;
					}
					_tmp98_ = _prepared_file_list;
					_tmp99_ = gee_abstract_list_get ((GeeAbstractList*) _tmp98_, _prepared_file_index);
					prepared_file = (PreparedFile*) _tmp99_;
					_tmp100_ = prepared_file;
					_tmp101_ = _tmp100_->job;
					_tmp102_ = prepared_file;
					_tmp103_ = _tmp102_->file;
					_tmp104_ = prepared_file;
					_tmp105_ = _tmp104_->job;
					_tmp106_ = batch_import_job_get_source_identifier (_tmp105_);
					_tmp107_ = _tmp106_;
					_tmp108_ = prepared_file;
					_tmp109_ = _tmp108_->file;
					_tmp110_ = g_file_get_path (_tmp109_);
					_tmp111_ = _tmp110_;
					background_import_job_report_failure ((BackgroundImportJob*) self, _tmp101_, _tmp103_, _tmp107_, _tmp111_, _result_);
					_g_free0 (_tmp111_);
					_g_free0 (_tmp107_);
					_prepared_file_unref0 (prepared_file);
				}
			}
		}
	}
	_g_object_unref0 (list);
	_g_timer_destroy0 (timer);
}

static gboolean
prepare_files_job_create_file (PrepareFilesJob* self,
                               BatchImportJob* job,
                               GFile** file,
                               gboolean* copy_to_library)
{
	GFile* _vala_file = NULL;
	gboolean _vala_copy_to_library = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (job != NULL, FALSE);
	{
		gboolean _tmp0_ = FALSE;
		GFile* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		gboolean _tmp3_;
		_tmp3_ = batch_import_job_prepare (job, &_tmp1_, &_tmp2_, &_inner_error0_);
		_g_object_unref0 (_vala_file);
		_vala_file = _tmp1_;
		_vala_copy_to_library = _tmp2_;
		_tmp0_ = _tmp3_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		if (!_tmp0_) {
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = batch_import_job_get_source_identifier (job);
			_tmp5_ = _tmp4_;
			_tmp6_ = batch_import_job_get_dest_identifier (job);
			_tmp7_ = _tmp6_;
			background_import_job_report_failure ((BackgroundImportJob*) self, job, NULL, _tmp5_, _tmp7_, IMPORT_RESULT_FILE_ERROR);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			result = FALSE;
			if (file) {
				*file = _vala_file;
			} else {
				_g_object_unref0 (_vala_file);
			}
			if (copy_to_library) {
				*copy_to_library = _vala_copy_to_library;
			}
			return result;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* _tmp11_;
		GError* _tmp12_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = batch_import_job_get_source_identifier (job);
		_tmp9_ = _tmp8_;
		_tmp10_ = batch_import_job_get_dest_identifier (job);
		_tmp11_ = _tmp10_;
		_tmp12_ = err;
		background_import_job_report_error ((BackgroundImportJob*) self, job, NULL, _tmp9_, _tmp11_, _tmp12_, IMPORT_RESULT_FILE_ERROR);
		_g_free0 (_tmp11_);
		_g_free0 (_tmp9_);
		result = FALSE;
		_g_error_free0 (err);
		if (file) {
			*file = _vala_file;
		} else {
			_g_object_unref0 (_vala_file);
		}
		if (copy_to_library) {
			*copy_to_library = _vala_copy_to_library;
		}
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gboolean _tmp13_ = FALSE;
		_g_object_unref0 (_vala_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp13_;
	}
	result = TRUE;
	if (file) {
		*file = _vala_file;
	} else {
		_g_object_unref0 (_vala_file);
	}
	if (copy_to_library) {
		*copy_to_library = _vala_copy_to_library;
	}
	return result;
}

static ImportResult
prepare_files_job_prepare_file (PrepareFilesJob* self,
                                BatchImportJob* job,
                                GFile* file,
                                GFile* associated_file,
                                gboolean copy_to_library,
                                PreparedFile** prepared_file)
{
	PreparedFile* _vala_prepared_file = NULL;
	gboolean is_video = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gint _tmp2_;
	gchar* exif_only_md5 = NULL;
	gchar* thumbnail_md5 = NULL;
	gchar* full_md5 = NULL;
	PhotoFileFormat file_format = 0;
	guint64 filesize = 0ULL;
	gboolean is_in_library_dir = FALSE;
	GFile* _tmp53_;
	gboolean _tmp54_ = FALSE;
	gchar* _tmp55_;
	gchar* _tmp56_;
	gchar* _tmp57_;
	gchar* _tmp58_;
	const gchar* _tmp59_;
	const gchar* _tmp60_;
	const gchar* _tmp61_;
	PreparedFile* _tmp62_;
	GError* _inner_error0_ = NULL;
	ImportResult result;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (job != NULL, 0);
	g_return_val_if_fail (file != NULL, 0);
	_prepared_file_unref0 (_vala_prepared_file);
	_vala_prepared_file = NULL;
	is_video = video_reader_is_supported_video_file (file);
	if (!is_video) {
		_tmp0_ = !photo_is_file_image (file);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		result = IMPORT_RESULT_NOT_AN_IMAGE;
		if (prepared_file) {
			*prepared_file = _vala_prepared_file;
		} else {
			_prepared_file_unref0 (_vala_prepared_file);
		}
		return result;
	}
	if (!is_video) {
		_tmp1_ = !photo_file_format_is_file_supported (file);
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
		if (prepared_file) {
			*prepared_file = _vala_prepared_file;
		} else {
			_prepared_file_unref0 (_vala_prepared_file);
		}
		return result;
	}
	_tmp2_ = self->priv->import_file_count;
	self->priv->import_file_count = _tmp2_ + 1;
	if (self->priv->fail_every > 0) {
		if ((self->priv->import_file_count % self->priv->fail_every) == 0) {
			result = IMPORT_RESULT_FILE_ERROR;
			if (prepared_file) {
				*prepared_file = _vala_prepared_file;
			} else {
				_prepared_file_unref0 (_vala_prepared_file);
			}
			return result;
		}
	}
	if (self->priv->skip_every > 0) {
		if ((self->priv->import_file_count % self->priv->skip_every) == 0) {
			result = IMPORT_RESULT_NOT_A_FILE;
			if (prepared_file) {
				*prepared_file = _vala_prepared_file;
			} else {
				_prepared_file_unref0 (_vala_prepared_file);
			}
			return result;
		}
	}
	exif_only_md5 = NULL;
	thumbnail_md5 = NULL;
	full_md5 = NULL;
	{
		gchar* _tmp3_ = NULL;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp4_ = md5_file (file, &_inner_error0_);
		_tmp3_ = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp5_ = _tmp3_;
		_tmp3_ = NULL;
		_g_free0 (full_md5);
		full_md5 = _tmp5_;
		_g_free0 (_tmp3_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		gchar* _tmp6_;
		gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		GError* _tmp10_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = g_file_get_path (file);
		_tmp7_ = _tmp6_;
		_tmp8_ = err;
		_tmp9_ = _tmp8_->message;
		g_warning ("BatchImport.vala:1831: Unable to perform MD5 checksum on file %s: %s", _tmp7_, _tmp9_);
		_g_free0 (_tmp7_);
		_tmp10_ = err;
		result = import_result_convert_error (_tmp10_, IMPORT_RESULT_FILE_ERROR);
		_g_error_free0 (err);
		_g_free0 (full_md5);
		_g_free0 (thumbnail_md5);
		_g_free0 (exif_only_md5);
		if (prepared_file) {
			*prepared_file = _vala_prepared_file;
		} else {
			_prepared_file_unref0 (_vala_prepared_file);
		}
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (full_md5);
		_g_free0 (thumbnail_md5);
		_g_free0 (exif_only_md5);
		_prepared_file_unref0 (_vala_prepared_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	file_format = photo_file_format_get_by_file_extension (file);
	if (!is_video) {
		PhotoFileReader* reader = NULL;
		gchar* _tmp13_;
		gchar* _tmp14_;
		PhotoFileReader* _tmp15_;
		PhotoFileReader* _tmp16_;
		PhotoMetadata* metadata = NULL;
		PhotoMetadata* _tmp25_;
		if (file_format == PHOTO_FILE_FORMAT_UNKNOWN) {
			gchar* _tmp11_;
			gchar* _tmp12_;
			_tmp11_ = g_file_get_path (file);
			_tmp12_ = _tmp11_;
			g_warning ("BatchImport.vala:1842: Skipping %s: unrecognized file extension", _tmp12_);
			_g_free0 (_tmp12_);
			result = IMPORT_RESULT_UNSUPPORTED_FORMAT;
			_g_free0 (full_md5);
			_g_free0 (thumbnail_md5);
			_g_free0 (exif_only_md5);
			if (prepared_file) {
				*prepared_file = _vala_prepared_file;
			} else {
				_prepared_file_unref0 (_vala_prepared_file);
			}
			return result;
		}
		_tmp13_ = g_file_get_path (file);
		_tmp14_ = _tmp13_;
		_tmp15_ = photo_file_format_create_reader (file_format, _tmp14_);
		_tmp16_ = _tmp15_;
		_g_free0 (_tmp14_);
		reader = _tmp16_;
		metadata = NULL;
		{
			PhotoMetadata* _tmp17_ = NULL;
			PhotoFileReader* _tmp18_;
			PhotoMetadata* _tmp19_;
			PhotoMetadata* _tmp20_;
			_tmp18_ = reader;
			_tmp19_ = photo_file_reader_read_metadata (_tmp18_, &_inner_error0_);
			_tmp17_ = _tmp19_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
			_tmp20_ = _tmp17_;
			_tmp17_ = NULL;
			_media_metadata_unref0 (metadata);
			metadata = _tmp20_;
			_media_metadata_unref0 (_tmp17_);
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			gchar* _tmp21_;
			gchar* _tmp22_;
			GError* _tmp23_;
			const gchar* _tmp24_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp21_ = g_file_get_path (file);
			_tmp22_ = _tmp21_;
			_tmp23_ = err;
			_tmp24_ = _tmp23_->message;
			g_warning ("BatchImport.vala:1851: Unable to read metadata for %s (%s): continuing" \
" to attempt import", _tmp22_, _tmp24_);
			_g_free0 (_tmp22_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_media_metadata_unref0 (metadata);
			_photo_file_adapter_unref0 (reader);
			_g_free0 (full_md5);
			_g_free0 (thumbnail_md5);
			_g_free0 (exif_only_md5);
			_prepared_file_unref0 (_vala_prepared_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return 0;
		}
		_tmp25_ = metadata;
		if (_tmp25_ != NULL) {
			guint8* flattened_sans_thumbnail = NULL;
			PhotoMetadata* _tmp26_;
			gint _tmp27_ = 0;
			guint8* _tmp28_;
			gint flattened_sans_thumbnail_length1;
			gint _flattened_sans_thumbnail_size_;
			gboolean _tmp29_ = FALSE;
			guint8* _tmp30_;
			gint _tmp30__length1;
			guint8* flattened_thumbnail = NULL;
			PhotoMetadata* _tmp35_;
			gint _tmp36_ = 0;
			guint8* _tmp37_;
			gint flattened_thumbnail_length1;
			gint _flattened_thumbnail_size_;
			gboolean _tmp38_ = FALSE;
			guint8* _tmp39_;
			gint _tmp39__length1;
			_tmp26_ = metadata;
			_tmp28_ = photo_metadata_flatten_exif (_tmp26_, FALSE, &_tmp27_);
			flattened_sans_thumbnail = _tmp28_;
			flattened_sans_thumbnail_length1 = _tmp27_;
			_flattened_sans_thumbnail_size_ = flattened_sans_thumbnail_length1;
			_tmp30_ = flattened_sans_thumbnail;
			_tmp30__length1 = flattened_sans_thumbnail_length1;
			if (_tmp30_ != NULL) {
				guint8* _tmp31_;
				gint _tmp31__length1;
				_tmp31_ = flattened_sans_thumbnail;
				_tmp31__length1 = flattened_sans_thumbnail_length1;
				_tmp29_ = _tmp31__length1 > 0;
			} else {
				_tmp29_ = FALSE;
			}
			if (_tmp29_) {
				guint8* _tmp32_;
				gint _tmp32__length1;
				guint8* _tmp33_;
				gint _tmp33__length1;
				gchar* _tmp34_;
				_tmp32_ = flattened_sans_thumbnail;
				_tmp32__length1 = flattened_sans_thumbnail_length1;
				_tmp33_ = flattened_sans_thumbnail;
				_tmp33__length1 = flattened_sans_thumbnail_length1;
				_tmp34_ = md5_binary (_tmp32_, (gsize) _tmp33__length1);
				_g_free0 (exif_only_md5);
				exif_only_md5 = _tmp34_;
			}
			_tmp35_ = metadata;
			_tmp37_ = photo_metadata_flatten_exif_preview (_tmp35_, &_tmp36_);
			flattened_thumbnail = _tmp37_;
			flattened_thumbnail_length1 = _tmp36_;
			_flattened_thumbnail_size_ = flattened_thumbnail_length1;
			_tmp39_ = flattened_thumbnail;
			_tmp39__length1 = flattened_thumbnail_length1;
			if (_tmp39_ != NULL) {
				guint8* _tmp40_;
				gint _tmp40__length1;
				_tmp40_ = flattened_thumbnail;
				_tmp40__length1 = flattened_thumbnail_length1;
				_tmp38_ = _tmp40__length1 > 0;
			} else {
				_tmp38_ = FALSE;
			}
			if (_tmp38_) {
				guint8* _tmp41_;
				gint _tmp41__length1;
				guint8* _tmp42_;
				gint _tmp42__length1;
				gchar* _tmp43_;
				_tmp41_ = flattened_thumbnail;
				_tmp41__length1 = flattened_thumbnail_length1;
				_tmp42_ = flattened_thumbnail;
				_tmp42__length1 = flattened_thumbnail_length1;
				_tmp43_ = md5_binary (_tmp41_, (gsize) _tmp42__length1);
				_g_free0 (thumbnail_md5);
				thumbnail_md5 = _tmp43_;
			}
			flattened_thumbnail = (g_free (flattened_thumbnail), NULL);
			flattened_sans_thumbnail = (g_free (flattened_sans_thumbnail), NULL);
		}
		_media_metadata_unref0 (metadata);
		_photo_file_adapter_unref0 (reader);
	}
	filesize = (guint64) 0;
	{
		guint64 _tmp44_ = 0ULL;
		GCancellable* _tmp45_;
		GCancellable* _tmp46_;
		guint64 _tmp47_;
		_tmp45_ = background_job_get_cancellable ((BackgroundJob*) self);
		_tmp46_ = _tmp45_;
		_tmp47_ = query_total_file_size (file, _tmp46_, &_inner_error0_);
		_g_object_unref0 (_tmp46_);
		_tmp44_ = _tmp47_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch2_g_error;
		}
		filesize = _tmp44_;
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* err = NULL;
		gchar* _tmp48_;
		gchar* _tmp49_;
		GError* _tmp50_;
		const gchar* _tmp51_;
		GError* _tmp52_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp48_ = g_file_get_path (file);
		_tmp49_ = _tmp48_;
		_tmp50_ = err;
		_tmp51_ = _tmp50_->message;
		g_warning ("BatchImport.vala:1870: Unable to query file size of %s: %s", _tmp49_, _tmp51_);
		_g_free0 (_tmp49_);
		_tmp52_ = err;
		result = import_result_convert_error (_tmp52_, IMPORT_RESULT_FILE_ERROR);
		_g_error_free0 (err);
		_g_free0 (full_md5);
		_g_free0 (thumbnail_md5);
		_g_free0 (exif_only_md5);
		if (prepared_file) {
			*prepared_file = _vala_prepared_file;
		} else {
			_prepared_file_unref0 (_vala_prepared_file);
		}
		return result;
	}
	__finally2:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (full_md5);
		_g_free0 (thumbnail_md5);
		_g_free0 (exif_only_md5);
		_prepared_file_unref0 (_vala_prepared_file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return 0;
	}
	_tmp53_ = self->priv->library_dir;
	is_in_library_dir = g_file_has_prefix (file, _tmp53_);
	if (copy_to_library) {
		_tmp54_ = !is_in_library_dir;
	} else {
		_tmp54_ = FALSE;
	}
	_tmp55_ = batch_import_job_get_source_identifier (job);
	_tmp56_ = _tmp55_;
	_tmp57_ = batch_import_job_get_dest_identifier (job);
	_tmp58_ = _tmp57_;
	_tmp59_ = exif_only_md5;
	_tmp60_ = thumbnail_md5;
	_tmp61_ = full_md5;
	_tmp62_ = prepared_file_new (job, file, associated_file, _tmp56_, _tmp58_, _tmp54_, _tmp59_, _tmp60_, _tmp61_, file_format, filesize, is_video);
	_prepared_file_unref0 (_vala_prepared_file);
	_vala_prepared_file = _tmp62_;
	_g_free0 (_tmp58_);
	_g_free0 (_tmp56_);
	result = IMPORT_RESULT_SUCCESS;
	_g_free0 (full_md5);
	_g_free0 (thumbnail_md5);
	_g_free0 (exif_only_md5);
	if (prepared_file) {
		*prepared_file = _vala_prepared_file;
	} else {
		_prepared_file_unref0 (_vala_prepared_file);
	}
	return result;
}

static void
prepare_files_job_class_init (PrepareFilesJobClass * klass,
                              gpointer klass_data)
{
	prepare_files_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = prepare_files_job_finalize;
	g_type_class_adjust_private_offset (klass, &PrepareFilesJob_private_offset);
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) prepare_files_job_real_execute;
}

static void
prepare_files_job_instance_init (PrepareFilesJob * self,
                                 gpointer klass)
{
	self->priv = prepare_files_job_get_instance_private (self);
	self->prepared_files = 0;
	self->priv->import_file_count = 0;
	self->priv->fail_every = 0;
	self->priv->skip_every = 0;
}

static void
prepare_files_job_finalize (BackgroundJob * obj)
{
	PrepareFilesJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREPARE_FILES_JOB, PrepareFilesJob);
	_g_object_unref0 (self->priv->files_to_prepare);
	_g_object_unref0 (self->priv->library_dir);
	BACKGROUND_JOB_CLASS (prepare_files_job_parent_class)->finalize (obj);
}

static GType
prepare_files_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PrepareFilesJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prepare_files_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PrepareFilesJob), 0, (GInstanceInitFunc) prepare_files_job_instance_init, NULL };
	GType prepare_files_job_type_id;
	prepare_files_job_type_id = g_type_register_static (TYPE_BACKGROUND_IMPORT_JOB, "PrepareFilesJob", &g_define_type_info, 0);
	PrepareFilesJob_private_offset = g_type_add_instance_private (prepare_files_job_type_id, sizeof (PrepareFilesJobPrivate));
	return prepare_files_job_type_id;
}

GType
prepare_files_job_get_type (void)
{
	static volatile gsize prepare_files_job_type_id__once = 0;
	if (g_once_init_enter (&prepare_files_job_type_id__once)) {
		GType prepare_files_job_type_id;
		prepare_files_job_type_id = prepare_files_job_get_type_once ();
		g_once_init_leave (&prepare_files_job_type_id__once, prepare_files_job_type_id);
	}
	return prepare_files_job_type_id__once;
}

static gpointer
_prepared_file_ref0 (gpointer self)
{
	return self ? prepared_file_ref (self) : NULL;
}

static gpointer
_batch_import_result_ref0 (gpointer self)
{
	return self ? batch_import_result_ref (self) : NULL;
}

static gpointer
_video_import_params_ref0 (gpointer self)
{
	return self ? video_import_params_ref (self) : NULL;
}

static gpointer
_photo_import_params_ref0 (gpointer self)
{
	return self ? photo_import_params_ref (self) : NULL;
}

ReadyForImport*
ready_for_import_construct (GType object_type,
                            GFile* final_file,
                            PreparedFile* prepared_file,
                            PhotoImportParams* photo_import_params,
                            VideoImportParams* video_import_params,
                            BatchImportResult* batch_result)
{
	ReadyForImport* self = NULL;
	GFile* _tmp2_;
	PreparedFile* _tmp3_;
	BatchImportResult* _tmp4_;
	VideoImportParams* _tmp5_;
	PhotoImportParams* _tmp6_;
	g_return_val_if_fail (final_file != NULL, NULL);
	g_return_val_if_fail (prepared_file != NULL, NULL);
	g_return_val_if_fail (batch_result != NULL, NULL);
	self = (ReadyForImport*) g_type_create_instance (object_type);
	if (prepared_file->is_video) {
		gboolean _tmp0_ = FALSE;
		if (video_import_params != NULL) {
			_tmp0_ = photo_import_params == NULL;
		} else {
			_tmp0_ = FALSE;
		}
		_vala_assert (_tmp0_, "(video_import_params != null) && (photo_import_params == null)");
	} else {
		gboolean _tmp1_ = FALSE;
		if (video_import_params == NULL) {
			_tmp1_ = photo_import_params != NULL;
		} else {
			_tmp1_ = FALSE;
		}
		_vala_assert (_tmp1_, "(video_import_params == null) && (photo_import_params != null)");
	}
	_tmp2_ = _g_object_ref0 (final_file);
	_g_object_unref0 (self->final_file);
	self->final_file = _tmp2_;
	_tmp3_ = _prepared_file_ref0 (prepared_file);
	_prepared_file_unref0 (self->prepared_file);
	self->prepared_file = _tmp3_;
	_tmp4_ = _batch_import_result_ref0 (batch_result);
	_batch_import_result_unref0 (self->batch_result);
	self->batch_result = _tmp4_;
	_tmp5_ = _video_import_params_ref0 (video_import_params);
	_video_import_params_unref0 (self->video_import_params);
	self->video_import_params = _tmp5_;
	_tmp6_ = _photo_import_params_ref0 (photo_import_params);
	_photo_import_params_unref0 (self->photo_import_params);
	self->photo_import_params = _tmp6_;
	self->is_video = prepared_file->is_video;
	return self;
}

ReadyForImport*
ready_for_import_new (GFile* final_file,
                      PreparedFile* prepared_file,
                      PhotoImportParams* photo_import_params,
                      VideoImportParams* video_import_params,
                      BatchImportResult* batch_result)
{
	return ready_for_import_construct (TYPE_READY_FOR_IMPORT, final_file, prepared_file, photo_import_params, video_import_params, batch_result);
}

BatchImportResult*
ready_for_import_abort (ReadyForImport* self)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	PreparedFile* _tmp14_;
	BatchImportJob* _tmp15_;
	PreparedFile* _tmp16_;
	GFile* _tmp17_;
	PreparedFile* _tmp18_;
	BatchImportJob* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	PreparedFile* _tmp22_;
	BatchImportJob* _tmp23_;
	gchar* _tmp24_;
	gchar* _tmp25_;
	BatchImportResult* _tmp26_;
	BatchImportResult* _tmp27_;
	BatchImportResult* _tmp28_;
	GError* _inner_error0_ = NULL;
	BatchImportResult* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->final_file;
	if (_tmp1_ != NULL) {
		GFile* _tmp2_;
		PreparedFile* _tmp3_;
		GFile* _tmp4_;
		_tmp2_ = self->final_file;
		_tmp3_ = self->prepared_file;
		_tmp4_ = _tmp3_->file;
		_tmp0_ = _tmp2_ != _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		GFile* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		_tmp5_ = self->final_file;
		_tmp6_ = g_file_get_path (_tmp5_);
		_tmp7_ = _tmp6_;
		g_debug ("BatchImport.vala:1914: Deleting aborted import copy %s", _tmp7_);
		_g_free0 (_tmp7_);
		{
			GFile* _tmp8_;
			_tmp8_ = self->final_file;
			g_file_delete (_tmp8_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			GFile* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			GError* _tmp12_;
			const gchar* _tmp13_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp9_ = self->final_file;
			_tmp10_ = g_file_get_path (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = err;
			_tmp13_ = _tmp12_->message;
			g_warning ("BatchImport.vala:1918: Unable to delete copy of imported file (aborted" \
" import) %s: %s", _tmp11_, _tmp13_);
			_g_free0 (_tmp11_);
			_g_error_free0 (err);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	_tmp14_ = self->prepared_file;
	_tmp15_ = _tmp14_->job;
	_tmp16_ = self->prepared_file;
	_tmp17_ = _tmp16_->file;
	_tmp18_ = self->prepared_file;
	_tmp19_ = _tmp18_->job;
	_tmp20_ = batch_import_job_get_source_identifier (_tmp19_);
	_tmp21_ = _tmp20_;
	_tmp22_ = self->prepared_file;
	_tmp23_ = _tmp22_->job;
	_tmp24_ = batch_import_job_get_dest_identifier (_tmp23_);
	_tmp25_ = _tmp24_;
	_tmp26_ = batch_import_result_new (_tmp15_, _tmp17_, _tmp21_, _tmp25_, NULL, IMPORT_RESULT_USER_ABORT);
	_batch_import_result_unref0 (self->batch_result);
	self->batch_result = _tmp26_;
	_g_free0 (_tmp25_);
	_g_free0 (_tmp21_);
	_tmp27_ = self->batch_result;
	_tmp28_ = _batch_import_result_ref0 (_tmp27_);
	result = _tmp28_;
	return result;
}

static gpointer
_thumbnails_ref0 (gpointer self)
{
	return self ? thumbnails_ref (self) : NULL;
}

Thumbnails*
ready_for_import_get_thumbnails (ReadyForImport* self)
{
	Thumbnails* _tmp0_ = NULL;
	PhotoImportParams* _tmp1_;
	Thumbnails* _tmp6_;
	Thumbnails* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->photo_import_params;
	if (_tmp1_ != NULL) {
		PhotoImportParams* _tmp2_;
		Thumbnails* _tmp3_;
		_tmp2_ = self->photo_import_params;
		_tmp3_ = _tmp2_->thumbnails;
		_tmp0_ = _tmp3_;
	} else {
		VideoImportParams* _tmp4_;
		Thumbnails* _tmp5_;
		_tmp4_ = self->video_import_params;
		_tmp5_ = _tmp4_->thumbnails;
		_tmp0_ = _tmp5_;
	}
	_tmp6_ = _thumbnails_ref0 (_tmp0_);
	result = _tmp6_;
	return result;
}

static void
value_ready_for_import_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_ready_for_import_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		ready_for_import_unref (value->data[0].v_pointer);
	}
}

static void
value_ready_for_import_copy_value (const GValue* src_value,
                                   GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = ready_for_import_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_ready_for_import_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_ready_for_import_collect_value (GValue* value,
                                      guint n_collect_values,
                                      GTypeCValue* collect_values,
                                      guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		ReadyForImport * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = ready_for_import_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_ready_for_import_lcopy_value (const GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
	ReadyForImport ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = ready_for_import_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_ready_for_import (const gchar* name,
                             const gchar* nick,
                             const gchar* blurb,
                             GType object_type,
                             GParamFlags flags)
{
	ParamSpecReadyForImport* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_READY_FOR_IMPORT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_ready_for_import (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_READY_FOR_IMPORT), NULL);
	return value->data[0].v_pointer;
}

void
value_set_ready_for_import (GValue* value,
                            gpointer v_object)
{
	ReadyForImport * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_READY_FOR_IMPORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_READY_FOR_IMPORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		ready_for_import_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ready_for_import_unref (old);
	}
}

void
value_take_ready_for_import (GValue* value,
                             gpointer v_object)
{
	ReadyForImport * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_READY_FOR_IMPORT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_READY_FOR_IMPORT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		ready_for_import_unref (old);
	}
}

static void
ready_for_import_class_init (ReadyForImportClass * klass,
                             gpointer klass_data)
{
	ready_for_import_parent_class = g_type_class_peek_parent (klass);
	((ReadyForImportClass *) klass)->finalize = ready_for_import_finalize;
}

static void
ready_for_import_instance_init (ReadyForImport * self,
                                gpointer klass)
{
	self->ref_count = 1;
}

static void
ready_for_import_finalize (ReadyForImport * obj)
{
	ReadyForImport * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_READY_FOR_IMPORT, ReadyForImport);
	g_signal_handlers_destroy (self);
	_g_object_unref0 (self->final_file);
	_prepared_file_unref0 (self->prepared_file);
	_photo_import_params_unref0 (self->photo_import_params);
	_video_import_params_unref0 (self->video_import_params);
	_batch_import_result_unref0 (self->batch_result);
}

static GType
ready_for_import_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_ready_for_import_init, value_ready_for_import_free_value, value_ready_for_import_copy_value, value_ready_for_import_peek_pointer, "p", value_ready_for_import_collect_value, "p", value_ready_for_import_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (ReadyForImportClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) ready_for_import_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ReadyForImport), 0, (GInstanceInitFunc) ready_for_import_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType ready_for_import_type_id;
	ready_for_import_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ReadyForImport", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return ready_for_import_type_id;
}

GType
ready_for_import_get_type (void)
{
	static volatile gsize ready_for_import_type_id__once = 0;
	if (g_once_init_enter (&ready_for_import_type_id__once)) {
		GType ready_for_import_type_id;
		ready_for_import_type_id = ready_for_import_get_type_once ();
		g_once_init_leave (&ready_for_import_type_id__once, ready_for_import_type_id);
	}
	return ready_for_import_type_id__once;
}

gpointer
ready_for_import_ref (gpointer instance)
{
	ReadyForImport * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
ready_for_import_unref (gpointer instance)
{
	ReadyForImport * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		READY_FOR_IMPORT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static inline gpointer
prepared_file_import_job_get_instance_private (PreparedFileImportJob* self)
{
	return G_STRUCT_MEMBER_P (self, PreparedFileImportJob_private_offset);
}

PreparedFileImportJob*
prepared_file_import_job_construct (GType object_type,
                                    BatchImport* owner,
                                    PreparedFile* prepared_file,
                                    ImportID* import_id,
                                    CompletionCallback callback,
                                    gpointer callback_target,
                                    GCancellable* cancellable,
                                    CancellationCallback cancellation,
                                    gpointer cancellation_target)
{
	PreparedFileImportJob* self = NULL;
	ImportID _tmp0_;
	PreparedFile* _tmp1_;
	g_return_val_if_fail (owner != NULL, NULL);
	g_return_val_if_fail (prepared_file != NULL, NULL);
	g_return_val_if_fail (import_id != NULL, NULL);
	g_return_val_if_fail (cancellable != NULL, NULL);
	self = (PreparedFileImportJob*) background_job_construct (object_type, (GObject*) owner, callback, callback_target, cancellable, cancellation, cancellation_target, NULL);
	_tmp0_ = *import_id;
	self->priv->import_id = _tmp0_;
	_tmp1_ = _prepared_file_ref0 (prepared_file);
	_prepared_file_unref0 (self->not_ready);
	self->not_ready = _tmp1_;
	background_job_set_completion_priority ((BackgroundJob*) self, G_PRIORITY_LOW);
	return self;
}

PreparedFileImportJob*
prepared_file_import_job_new (BatchImport* owner,
                              PreparedFile* prepared_file,
                              ImportID* import_id,
                              CompletionCallback callback,
                              gpointer callback_target,
                              GCancellable* cancellable,
                              CancellationCallback cancellation,
                              gpointer cancellation_target)
{
	return prepared_file_import_job_construct (TYPE_PREPARED_FILE_IMPORT_JOB, owner, prepared_file, import_id, callback, callback_target, cancellable, cancellation, cancellation_target);
}

static void
prepared_file_import_job_real_execute (BackgroundJob* base)
{
	PreparedFileImportJob * self;
	PreparedFile* prepared_file = NULL;
	PreparedFile* _tmp0_;
	PreparedFile* _tmp1_;
	GFile* final_file = NULL;
	PreparedFile* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFile* final_associated_file = NULL;
	PreparedFile* _tmp5_;
	GFile* _tmp6_;
	GFile* _tmp7_;
	PreparedFile* _tmp8_;
	GFile* _tmp50_;
	gchar* _tmp51_;
	gchar* _tmp52_;
	ImportResult _result_ = 0;
	VideoImportParams* video_import_params = NULL;
	PhotoImportParams* photo_import_params = NULL;
	PreparedFile* _tmp53_;
	gboolean _tmp77_ = FALSE;
	BatchImportResult* batch_result = NULL;
	PreparedFile* _tmp90_;
	BatchImportJob* _tmp91_;
	GFile* _tmp92_;
	GFile* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	GFile* _tmp96_;
	gchar* _tmp97_;
	gchar* _tmp98_;
	BatchImportResult* _tmp99_;
	BatchImportResult* _tmp100_;
	BatchImportResult* _tmp101_;
	GError* _inner_error0_ = NULL;
	self = (PreparedFileImportJob*) base;
	_tmp0_ = self->not_ready;
	_tmp1_ = _prepared_file_ref0 (_tmp0_);
	prepared_file = _tmp1_;
	_prepared_file_unref0 (self->not_ready);
	self->not_ready = NULL;
	_tmp2_ = prepared_file;
	_tmp3_ = _tmp2_->file;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	final_file = _tmp4_;
	_tmp5_ = prepared_file;
	_tmp6_ = _tmp5_->associated_file;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	final_associated_file = _tmp7_;
	_tmp8_ = prepared_file;
	if (_tmp8_->copy_to_library) {
		{
			GFile* _tmp9_ = NULL;
			PreparedFile* _tmp10_;
			GFile* _tmp11_;
			GFile* _tmp12_;
			GFile* _tmp13_;
			GFile* _tmp14_;
			GFile* _tmp28_;
			_tmp10_ = prepared_file;
			_tmp11_ = _tmp10_->file;
			_tmp12_ = library_files_duplicate (_tmp11_, NULL, NULL, TRUE, &_inner_error0_);
			_tmp9_ = _tmp12_;
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
			_tmp13_ = _tmp9_;
			_tmp9_ = NULL;
			_g_object_unref0 (final_file);
			final_file = _tmp13_;
			_tmp14_ = final_file;
			if (_tmp14_ == NULL) {
				PreparedFile* _tmp15_;
				BatchImportJob* _tmp16_;
				PreparedFile* _tmp17_;
				GFile* _tmp18_;
				PreparedFile* _tmp19_;
				GFile* _tmp20_;
				gchar* _tmp21_;
				gchar* _tmp22_;
				PreparedFile* _tmp23_;
				GFile* _tmp24_;
				gchar* _tmp25_;
				gchar* _tmp26_;
				BatchImportResult* _tmp27_;
				_tmp15_ = prepared_file;
				_tmp16_ = _tmp15_->job;
				_tmp17_ = prepared_file;
				_tmp18_ = _tmp17_->file;
				_tmp19_ = prepared_file;
				_tmp20_ = _tmp19_->file;
				_tmp21_ = g_file_get_path (_tmp20_);
				_tmp22_ = _tmp21_;
				_tmp23_ = prepared_file;
				_tmp24_ = _tmp23_->file;
				_tmp25_ = g_file_get_path (_tmp24_);
				_tmp26_ = _tmp25_;
				_tmp27_ = batch_import_result_new (_tmp16_, _tmp18_, _tmp22_, _tmp26_, NULL, IMPORT_RESULT_FILE_ERROR);
				_batch_import_result_unref0 (self->failed);
				self->failed = _tmp27_;
				_g_free0 (_tmp26_);
				_g_free0 (_tmp22_);
				_g_object_unref0 (_tmp9_);
				_g_object_unref0 (final_associated_file);
				_g_object_unref0 (final_file);
				_prepared_file_unref0 (prepared_file);
				return;
			}
			_tmp28_ = final_associated_file;
			if (_tmp28_ != NULL) {
				GFile* _tmp29_ = NULL;
				PreparedFile* _tmp30_;
				GFile* _tmp31_;
				GFile* _tmp32_;
				GFile* _tmp33_;
				_tmp30_ = prepared_file;
				_tmp31_ = _tmp30_->associated_file;
				_tmp32_ = library_files_duplicate (_tmp31_, NULL, NULL, TRUE, &_inner_error0_);
				_tmp29_ = _tmp32_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_object_unref0 (_tmp9_);
					goto __catch0_g_error;
				}
				_tmp33_ = _tmp29_;
				_tmp29_ = NULL;
				_g_object_unref0 (final_associated_file);
				final_associated_file = _tmp33_;
				_g_object_unref0 (_tmp29_);
			}
			_g_object_unref0 (_tmp9_);
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* err = NULL;
			gchar* _tmp34_ = NULL;
			GFile* _tmp35_;
			gchar* filename = NULL;
			gchar* _tmp41_;
			PreparedFile* _tmp42_;
			BatchImportJob* _tmp43_;
			PreparedFile* _tmp44_;
			GFile* _tmp45_;
			const gchar* _tmp46_;
			const gchar* _tmp47_;
			GError* _tmp48_;
			BatchImportResult* _tmp49_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp35_ = final_file;
			if (_tmp35_ != NULL) {
				GFile* _tmp36_;
				gchar* _tmp37_;
				_tmp36_ = final_file;
				_tmp37_ = g_file_get_path (_tmp36_);
				_g_free0 (_tmp34_);
				_tmp34_ = _tmp37_;
			} else {
				PreparedFile* _tmp38_;
				const gchar* _tmp39_;
				gchar* _tmp40_;
				_tmp38_ = prepared_file;
				_tmp39_ = _tmp38_->source_id;
				_tmp40_ = g_strdup (_tmp39_);
				_g_free0 (_tmp34_);
				_tmp34_ = _tmp40_;
			}
			_tmp41_ = g_strdup (_tmp34_);
			filename = _tmp41_;
			_tmp42_ = prepared_file;
			_tmp43_ = _tmp42_->job;
			_tmp44_ = prepared_file;
			_tmp45_ = _tmp44_->file;
			_tmp46_ = filename;
			_tmp47_ = filename;
			_tmp48_ = err;
			_tmp49_ = batch_import_result_new_from_error (_tmp43_, _tmp45_, _tmp46_, _tmp47_, _tmp48_, IMPORT_RESULT_FILE_ERROR);
			_batch_import_result_unref0 (self->failed);
			self->failed = _tmp49_;
			_g_free0 (filename);
			_g_free0 (_tmp34_);
			_g_error_free0 (err);
			_g_object_unref0 (final_associated_file);
			_g_object_unref0 (final_file);
			_prepared_file_unref0 (prepared_file);
			return;
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (final_associated_file);
			_g_object_unref0 (final_file);
			_prepared_file_unref0 (prepared_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp50_ = final_file;
	_tmp51_ = g_file_get_path (_tmp50_);
	_tmp52_ = _tmp51_;
	g_debug ("BatchImport.vala:1985: Importing %s", _tmp52_);
	_g_free0 (_tmp52_);
	_result_ = IMPORT_RESULT_SUCCESS;
	video_import_params = NULL;
	photo_import_params = NULL;
	_tmp53_ = prepared_file;
	if (_tmp53_->is_video) {
		GFile* _tmp54_;
		ImportID _tmp55_;
		PreparedFile* _tmp56_;
		const gchar* _tmp57_;
		Thumbnails* _tmp58_;
		Thumbnails* _tmp59_;
		PreparedFile* _tmp60_;
		BatchImportJob* _tmp61_;
		VideoImportParams* _tmp62_;
		VideoImportParams* _tmp63_;
		_tmp54_ = final_file;
		_tmp55_ = self->priv->import_id;
		_tmp56_ = prepared_file;
		_tmp57_ = _tmp56_->full_md5;
		_tmp58_ = thumbnails_new ();
		_tmp59_ = _tmp58_;
		_tmp60_ = prepared_file;
		_tmp61_ = _tmp60_->job;
		_tmp62_ = video_import_params_new (_tmp54_, &_tmp55_, _tmp57_, _tmp59_, batch_import_job_get_exposure_time_override (_tmp61_));
		_video_import_params_unref0 (video_import_params);
		video_import_params = _tmp62_;
		_thumbnails_unref0 (_tmp59_);
		_tmp63_ = video_import_params;
		_result_ = video_reader_prepare_for_import (_tmp63_);
	} else {
		GFile* _tmp64_;
		GFile* _tmp65_;
		ImportID _tmp66_;
		PreparedFile* _tmp67_;
		const gchar* _tmp68_;
		PreparedFile* _tmp69_;
		const gchar* _tmp70_;
		PreparedFile* _tmp71_;
		const gchar* _tmp72_;
		Thumbnails* _tmp73_;
		Thumbnails* _tmp74_;
		PhotoImportParams* _tmp75_;
		PhotoImportParams* _tmp76_;
		_tmp64_ = final_file;
		_tmp65_ = final_associated_file;
		_tmp66_ = self->priv->import_id;
		_tmp67_ = prepared_file;
		_tmp68_ = _tmp67_->exif_md5;
		_tmp69_ = prepared_file;
		_tmp70_ = _tmp69_->thumbnail_md5;
		_tmp71_ = prepared_file;
		_tmp72_ = _tmp71_->full_md5;
		_tmp73_ = thumbnails_new ();
		_tmp74_ = _tmp73_;
		_tmp75_ = photo_import_params_new (_tmp64_, _tmp65_, &_tmp66_, PHOTO_FILE_SNIFFER_OPTIONS_GET_ALL, _tmp68_, _tmp70_, _tmp72_, _tmp74_);
		_photo_import_params_unref0 (photo_import_params);
		photo_import_params = _tmp75_;
		_thumbnails_unref0 (_tmp74_);
		_tmp76_ = photo_import_params;
		_result_ = photo_prepare_for_import (_tmp76_);
	}
	if (_result_ != IMPORT_RESULT_SUCCESS) {
		GFile* _tmp78_;
		PreparedFile* _tmp79_;
		GFile* _tmp80_;
		_tmp78_ = final_file;
		_tmp79_ = prepared_file;
		_tmp80_ = _tmp79_->file;
		_tmp77_ = _tmp78_ != _tmp80_;
	} else {
		_tmp77_ = FALSE;
	}
	if (_tmp77_) {
		GFile* _tmp81_;
		gchar* _tmp82_;
		gchar* _tmp83_;
		_tmp81_ = final_file;
		_tmp82_ = g_file_get_path (_tmp81_);
		_tmp83_ = _tmp82_;
		g_debug ("BatchImport.vala:2005: Deleting failed imported copy %s", _tmp83_);
		_g_free0 (_tmp83_);
		{
			GFile* _tmp84_;
			_tmp84_ = final_file;
			g_file_delete (_tmp84_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch1_g_error;
			}
		}
		goto __finally1;
		__catch1_g_error:
		{
			GError* err = NULL;
			GFile* _tmp85_;
			gchar* _tmp86_;
			gchar* _tmp87_;
			GError* _tmp88_;
			const gchar* _tmp89_;
			err = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp85_ = final_file;
			_tmp86_ = g_file_get_path (_tmp85_);
			_tmp87_ = _tmp86_;
			_tmp88_ = err;
			_tmp89_ = _tmp88_->message;
			g_warning ("BatchImport.vala:2010: Unable to delete copy of imported file %s: %s", _tmp87_, _tmp89_);
			_g_free0 (_tmp87_);
			_g_error_free0 (err);
		}
		__finally1:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_photo_import_params_unref0 (photo_import_params);
			_video_import_params_unref0 (video_import_params);
			_g_object_unref0 (final_associated_file);
			_g_object_unref0 (final_file);
			_prepared_file_unref0 (prepared_file);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	_tmp90_ = prepared_file;
	_tmp91_ = _tmp90_->job;
	_tmp92_ = final_file;
	_tmp93_ = final_file;
	_tmp94_ = g_file_get_path (_tmp93_);
	_tmp95_ = _tmp94_;
	_tmp96_ = final_file;
	_tmp97_ = g_file_get_path (_tmp96_);
	_tmp98_ = _tmp97_;
	_tmp99_ = batch_import_result_new (_tmp91_, _tmp92_, _tmp95_, _tmp98_, NULL, _result_);
	_tmp100_ = _tmp99_;
	_g_free0 (_tmp98_);
	_g_free0 (_tmp95_);
	batch_result = _tmp100_;
	_tmp101_ = batch_result;
	if (_tmp101_->result != IMPORT_RESULT_SUCCESS) {
		BatchImportResult* _tmp102_;
		BatchImportResult* _tmp103_;
		_tmp102_ = batch_result;
		_tmp103_ = _batch_import_result_ref0 (_tmp102_);
		_batch_import_result_unref0 (self->failed);
		self->failed = _tmp103_;
	} else {
		GFile* _tmp104_;
		PreparedFile* _tmp105_;
		PhotoImportParams* _tmp106_;
		VideoImportParams* _tmp107_;
		BatchImportResult* _tmp108_;
		ReadyForImport* _tmp109_;
		_tmp104_ = final_file;
		_tmp105_ = prepared_file;
		_tmp106_ = photo_import_params;
		_tmp107_ = video_import_params;
		_tmp108_ = batch_result;
		_tmp109_ = ready_for_import_new (_tmp104_, _tmp105_, _tmp106_, _tmp107_, _tmp108_);
		_ready_for_import_unref0 (self->ready);
		self->ready = _tmp109_;
	}
	_batch_import_result_unref0 (batch_result);
	_photo_import_params_unref0 (photo_import_params);
	_video_import_params_unref0 (video_import_params);
	_g_object_unref0 (final_associated_file);
	_g_object_unref0 (final_file);
	_prepared_file_unref0 (prepared_file);
}

static void
prepared_file_import_job_class_init (PreparedFileImportJobClass * klass,
                                     gpointer klass_data)
{
	prepared_file_import_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = prepared_file_import_job_finalize;
	g_type_class_adjust_private_offset (klass, &PreparedFileImportJob_private_offset);
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) prepared_file_import_job_real_execute;
}

static void
prepared_file_import_job_instance_init (PreparedFileImportJob * self,
                                        gpointer klass)
{
	self->priv = prepared_file_import_job_get_instance_private (self);
	self->ready = NULL;
	self->failed = NULL;
}

static void
prepared_file_import_job_finalize (BackgroundJob * obj)
{
	PreparedFileImportJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PREPARED_FILE_IMPORT_JOB, PreparedFileImportJob);
	_prepared_file_unref0 (self->not_ready);
	_ready_for_import_unref0 (self->ready);
	_batch_import_result_unref0 (self->failed);
	BACKGROUND_JOB_CLASS (prepared_file_import_job_parent_class)->finalize (obj);
}

static GType
prepared_file_import_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PreparedFileImportJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) prepared_file_import_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PreparedFileImportJob), 0, (GInstanceInitFunc) prepared_file_import_job_instance_init, NULL };
	GType prepared_file_import_job_type_id;
	prepared_file_import_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "PreparedFileImportJob", &g_define_type_info, 0);
	PreparedFileImportJob_private_offset = g_type_add_instance_private (prepared_file_import_job_type_id, sizeof (PreparedFileImportJobPrivate));
	return prepared_file_import_job_type_id;
}

GType
prepared_file_import_job_get_type (void)
{
	static volatile gsize prepared_file_import_job_type_id__once = 0;
	if (g_once_init_enter (&prepared_file_import_job_type_id__once)) {
		GType prepared_file_import_job_type_id;
		prepared_file_import_job_type_id = prepared_file_import_job_get_type_once ();
		g_once_init_leave (&prepared_file_import_job_type_id__once, prepared_file_import_job_type_id);
	}
	return prepared_file_import_job_type_id__once;
}

CompletedImportObject*
completed_import_object_construct (GType object_type,
                                   MediaSource* source,
                                   Thumbnails* thumbnails,
                                   BatchImportJob* original_job,
                                   BatchImportResult* import_result)
{
	CompletedImportObject* self = NULL;
	Thumbnails* _tmp0_;
	BatchImportResult* _tmp1_;
	MediaSource* _tmp2_;
	BatchImportJob* _tmp3_;
	GdkPixbuf* _tmp4_;
	g_return_val_if_fail (source != NULL, NULL);
	g_return_val_if_fail (thumbnails != NULL, NULL);
	g_return_val_if_fail (original_job != NULL, NULL);
	g_return_val_if_fail (import_result != NULL, NULL);
	self = (CompletedImportObject*) g_type_create_instance (object_type);
	_tmp0_ = _thumbnails_ref0 (thumbnails);
	_thumbnails_unref0 (self->thumbnails);
	self->thumbnails = _tmp0_;
	_tmp1_ = _batch_import_result_ref0 (import_result);
	_batch_import_result_unref0 (self->batch_result);
	self->batch_result = _tmp1_;
	_tmp2_ = _g_object_ref0 (source);
	_g_object_unref0 (self->source);
	self->source = _tmp2_;
	_tmp3_ = _batch_import_job_ref0 (original_job);
	_batch_import_job_unref0 (self->original_job);
	self->original_job = _tmp3_;
	_tmp4_ = thumbnails_get (thumbnails, THUMBNAIL_CACHE_SIZE_LARGEST);
	_g_object_unref0 (self->user_preview);
	self->user_preview = _tmp4_;
	return self;
}

CompletedImportObject*
completed_import_object_new (MediaSource* source,
                             Thumbnails* thumbnails,
                             BatchImportJob* original_job,
                             BatchImportResult* import_result)
{
	return completed_import_object_construct (TYPE_COMPLETED_IMPORT_OBJECT, source, thumbnails, original_job, import_result);
}

static void
value_completed_import_object_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_completed_import_object_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		completed_import_object_unref (value->data[0].v_pointer);
	}
}

static void
value_completed_import_object_copy_value (const GValue* src_value,
                                          GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = completed_import_object_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_completed_import_object_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_completed_import_object_collect_value (GValue* value,
                                             guint n_collect_values,
                                             GTypeCValue* collect_values,
                                             guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		CompletedImportObject * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = completed_import_object_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_completed_import_object_lcopy_value (const GValue* value,
                                           guint n_collect_values,
                                           GTypeCValue* collect_values,
                                           guint collect_flags)
{
	CompletedImportObject ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = completed_import_object_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_completed_import_object (const gchar* name,
                                    const gchar* nick,
                                    const gchar* blurb,
                                    GType object_type,
                                    GParamFlags flags)
{
	ParamSpecCompletedImportObject* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_COMPLETED_IMPORT_OBJECT), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_completed_import_object (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPLETED_IMPORT_OBJECT), NULL);
	return value->data[0].v_pointer;
}

void
value_set_completed_import_object (GValue* value,
                                   gpointer v_object)
{
	CompletedImportObject * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPLETED_IMPORT_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COMPLETED_IMPORT_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		completed_import_object_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		completed_import_object_unref (old);
	}
}

void
value_take_completed_import_object (GValue* value,
                                    gpointer v_object)
{
	CompletedImportObject * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_COMPLETED_IMPORT_OBJECT));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_COMPLETED_IMPORT_OBJECT));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		completed_import_object_unref (old);
	}
}

static void
completed_import_object_class_init (CompletedImportObjectClass * klass,
                                    gpointer klass_data)
{
	completed_import_object_parent_class = g_type_class_peek_parent (klass);
	((CompletedImportObjectClass *) klass)->finalize = completed_import_object_finalize;
}

static void
completed_import_object_instance_init (CompletedImportObject * self,
                                       gpointer klass)
{
	self->ref_count = 1;
}

static void
completed_import_object_finalize (CompletedImportObject * obj)
{
	CompletedImportObject * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_COMPLETED_IMPORT_OBJECT, CompletedImportObject);
	g_signal_handlers_destroy (self);
	_thumbnails_unref0 (self->thumbnails);
	_batch_import_result_unref0 (self->batch_result);
	_g_object_unref0 (self->source);
	_batch_import_job_unref0 (self->original_job);
	_g_object_unref0 (self->user_preview);
}

static GType
completed_import_object_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_completed_import_object_init, value_completed_import_object_free_value, value_completed_import_object_copy_value, value_completed_import_object_peek_pointer, "p", value_completed_import_object_collect_value, "p", value_completed_import_object_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (CompletedImportObjectClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) completed_import_object_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (CompletedImportObject), 0, (GInstanceInitFunc) completed_import_object_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType completed_import_object_type_id;
	completed_import_object_type_id = g_type_register_fundamental (g_type_fundamental_next (), "CompletedImportObject", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return completed_import_object_type_id;
}

GType
completed_import_object_get_type (void)
{
	static volatile gsize completed_import_object_type_id__once = 0;
	if (g_once_init_enter (&completed_import_object_type_id__once)) {
		GType completed_import_object_type_id;
		completed_import_object_type_id = completed_import_object_get_type_once ();
		g_once_init_leave (&completed_import_object_type_id__once, completed_import_object_type_id);
	}
	return completed_import_object_type_id__once;
}

gpointer
completed_import_object_ref (gpointer instance)
{
	CompletedImportObject * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
completed_import_object_unref (gpointer instance)
{
	CompletedImportObject * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		COMPLETED_IMPORT_OBJECT_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

ThumbnailWriterJob*
thumbnail_writer_job_construct (GType object_type,
                                BatchImport* owner,
                                CompletedImportObject* completed_import_source,
                                CompletionCallback callback,
                                gpointer callback_target,
                                GCancellable* cancellable,
                                CancellationCallback cancel_callback,
                                gpointer cancel_callback_target)
{
	ThumbnailWriterJob* self = NULL;
	Thumbnails* _tmp0_;
	CompletedImportObject* _tmp1_;
	g_return_val_if_fail (owner != NULL, NULL);
	g_return_val_if_fail (completed_import_source != NULL, NULL);
	g_return_val_if_fail (cancellable != NULL, NULL);
	self = (ThumbnailWriterJob*) background_import_job_construct (object_type, owner, callback, callback_target, cancellable, cancel_callback, cancel_callback_target);
	_tmp0_ = completed_import_source->thumbnails;
	_vala_assert (_tmp0_ != NULL, "completed_import_source.thumbnails != null");
	_tmp1_ = _completed_import_object_ref0 (completed_import_source);
	_completed_import_object_unref0 (self->completed_import_source);
	self->completed_import_source = _tmp1_;
	background_job_set_completion_priority ((BackgroundJob*) self, G_PRIORITY_LOW);
	return self;
}

ThumbnailWriterJob*
thumbnail_writer_job_new (BatchImport* owner,
                          CompletedImportObject* completed_import_source,
                          CompletionCallback callback,
                          gpointer callback_target,
                          GCancellable* cancellable,
                          CancellationCallback cancel_callback,
                          gpointer cancel_callback_target)
{
	return thumbnail_writer_job_construct (TYPE_THUMBNAIL_WRITER_JOB, owner, completed_import_source, callback, callback_target, cancellable, cancel_callback, cancel_callback_target);
}

static void
thumbnail_writer_job_real_execute (BackgroundJob* base)
{
	ThumbnailWriterJob * self;
	CompletedImportObject* _tmp9_;
	GError* _inner_error0_ = NULL;
	self = (ThumbnailWriterJob*) base;
	{
		CompletedImportObject* _tmp0_;
		MediaSource* _tmp1_;
		CompletedImportObject* _tmp2_;
		Thumbnails* _tmp3_;
		CompletedImportObject* _tmp4_;
		BatchImportResult* _tmp5_;
		_tmp0_ = self->completed_import_source;
		_tmp1_ = _tmp0_->source;
		_tmp2_ = self->completed_import_source;
		_tmp3_ = _tmp2_->thumbnails;
		thumbnail_cache_import_thumbnails ((ThumbnailSource*) _tmp1_, _tmp3_, TRUE, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp4_ = self->completed_import_source;
		_tmp5_ = _tmp4_->batch_result;
		_tmp5_->result = IMPORT_RESULT_SUCCESS;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* err = NULL;
		CompletedImportObject* _tmp6_;
		BatchImportResult* _tmp7_;
		GError* _tmp8_;
		err = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = self->completed_import_source;
		_tmp7_ = _tmp6_->batch_result;
		_tmp8_ = err;
		_tmp7_->result = import_result_convert_error (_tmp8_, IMPORT_RESULT_FILE_ERROR);
		_g_error_free0 (err);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp9_ = self->completed_import_source;
	_thumbnails_unref0 (_tmp9_->thumbnails);
	_tmp9_->thumbnails = NULL;
}

static void
thumbnail_writer_job_class_init (ThumbnailWriterJobClass * klass,
                                 gpointer klass_data)
{
	thumbnail_writer_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = thumbnail_writer_job_finalize;
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) thumbnail_writer_job_real_execute;
}

static void
thumbnail_writer_job_instance_init (ThumbnailWriterJob * self,
                                    gpointer klass)
{
}

static void
thumbnail_writer_job_finalize (BackgroundJob * obj)
{
	ThumbnailWriterJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_THUMBNAIL_WRITER_JOB, ThumbnailWriterJob);
	_completed_import_object_unref0 (self->completed_import_source);
	BACKGROUND_JOB_CLASS (thumbnail_writer_job_parent_class)->finalize (obj);
}

static GType
thumbnail_writer_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ThumbnailWriterJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) thumbnail_writer_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ThumbnailWriterJob), 0, (GInstanceInitFunc) thumbnail_writer_job_instance_init, NULL };
	GType thumbnail_writer_job_type_id;
	thumbnail_writer_job_type_id = g_type_register_static (TYPE_BACKGROUND_IMPORT_JOB, "ThumbnailWriterJob", &g_define_type_info, 0);
	return thumbnail_writer_job_type_id;
}

GType
thumbnail_writer_job_get_type (void)
{
	static volatile gsize thumbnail_writer_job_type_id__once = 0;
	if (g_once_init_enter (&thumbnail_writer_job_type_id__once)) {
		GType thumbnail_writer_job_type_id;
		thumbnail_writer_job_type_id = thumbnail_writer_job_get_type_once ();
		g_once_init_leave (&thumbnail_writer_job_type_id__once, thumbnail_writer_job_type_id);
	}
	return thumbnail_writer_job_type_id__once;
}

