// python wrapper for vtkMaterialInterfacePieceTransactionMatrix
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkPythonArgs.h"
#include "vtkPythonOverload.h"
#include <cstddef>
#include <sstream>
#include "vtkVariant.h"
#include "vtkMaterialInterfacePieceTransactionMatrix.h"

#if defined(PYTHON_PACKAGE)
#define PYTHON_PACKAGE_SCOPE PYTHON_PACKAGE "."
#else
#define PYTHON_PACKAGE_SCOPE
#endif

extern "C" { VTK_ABI_HIDDEN void PyVTKAddFile_vtkMaterialInterfacePieceTransactionMatrix(PyObject *dict); }

static PyObject *
PyvtkMaterialInterfacePieceTransactionMatrix_Initialize(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Initialize");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransactionMatrix *op = static_cast<vtkMaterialInterfacePieceTransactionMatrix *>(vp);

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    op->Initialize(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfacePieceTransactionMatrix_Clear(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Clear");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransactionMatrix *op = static_cast<vtkMaterialInterfacePieceTransactionMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    op->Clear();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfacePieceTransactionMatrix_GetNumberOfTransactions(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "GetNumberOfTransactions");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransactionMatrix *op = static_cast<vtkMaterialInterfacePieceTransactionMatrix *>(vp);

  int temp0;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(1) &&
      ap.GetValue(temp0))
  {
    long long tempr = op->GetNumberOfTransactions(temp0);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfacePieceTransactionMatrix_PushTransaction(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "PushTransaction");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransactionMatrix *op = static_cast<vtkMaterialInterfacePieceTransactionMatrix *>(vp);

  int temp0;
  int temp1;
  vtkMaterialInterfacePieceTransaction *temp2 = nullptr;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(3) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1) &&
      ap.GetSpecialObject(temp2, "vtkMaterialInterfacePieceTransaction"))
  {
    op->PushTransaction(temp0, temp1, *temp2);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfacePieceTransactionMatrix_Broadcast(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Broadcast");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransactionMatrix *op = static_cast<vtkMaterialInterfacePieceTransactionMatrix *>(vp);

  vtkCommunicator *temp0 = nullptr;
  int temp1;
  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(2) &&
      ap.GetVTKObject(temp0, "vtkCommunicator") &&
      ap.GetValue(temp1))
  {
    op->Broadcast(temp0, temp1);

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfacePieceTransactionMatrix_Print(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Print");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransactionMatrix *op = static_cast<vtkMaterialInterfacePieceTransactionMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    op->Print();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildNone();
    }
  }

  return result;
}


static PyObject *
PyvtkMaterialInterfacePieceTransactionMatrix_Capacity(PyObject *self, PyObject *args)
{
  vtkPythonArgs ap(self, args, "Capacity");
  void *vp = ap.GetSelfSpecialPointer(self, args);
  vtkMaterialInterfacePieceTransactionMatrix *op = static_cast<vtkMaterialInterfacePieceTransactionMatrix *>(vp);

  PyObject *result = nullptr;

  if (op && ap.CheckArgCount(0))
  {
    long long tempr = op->Capacity();

    if (!ap.ErrorOccurred())
    {
      result = ap.BuildValue(tempr);
    }
  }

  return result;
}

static PyMethodDef PyvtkMaterialInterfacePieceTransactionMatrix_Methods[] = {
  {"Initialize", PyvtkMaterialInterfacePieceTransactionMatrix_Initialize, METH_VARARGS,
   "Initialize(self, nFragments:int, nProcs:int) -> None\nC++: void Initialize(int nFragments, int nProcs)\n\n"},
  {"Clear", PyvtkMaterialInterfacePieceTransactionMatrix_Clear, METH_VARARGS,
   "Clear(self) -> None\nC++: void Clear()\n\nFree allocated resources and leave the object in an\nun-initialized state.\n"},
  {"GetNumberOfTransactions", PyvtkMaterialInterfacePieceTransactionMatrix_GetNumberOfTransactions, METH_VARARGS,
   "GetNumberOfTransactions(self, procId:int) -> int\nC++: vtkIdType GetNumberOfTransactions(int procId)\n\nGet the number of transaction a given process will execute.\n"},
  {"PushTransaction", PyvtkMaterialInterfacePieceTransactionMatrix_PushTransaction, METH_VARARGS,
   "PushTransaction(self, fragmentId:int, procId:int,\n    transaction:vtkMaterialInterfacePieceTransaction) -> None\nC++: void PushTransaction(int fragmentId, int procId,\n    vtkMaterialInterfacePieceTransaction &transaction)\n\nAdd a transaction to the end of the given a proc,fragment pair's\ntransaction list.\n"},
  {"Broadcast", PyvtkMaterialInterfacePieceTransactionMatrix_Broadcast, METH_VARARGS,
   "Broadcast(self, comm:vtkCommunicator, srcProc:int) -> None\nC++: void Broadcast(vtkCommunicator *comm, int srcProc)\n\nSend the transaction matrix on srcProc to all other procs.\n"},
  {"Print", PyvtkMaterialInterfacePieceTransactionMatrix_Print, METH_VARARGS,
   "Print(self) -> None\nC++: void Print()\n\n"},
  {"Capacity", PyvtkMaterialInterfacePieceTransactionMatrix_Capacity, METH_VARARGS,
   "Capacity(self) -> int\nC++: vtkIdType Capacity()\n\nTells how much memory the matrix has allocated.\n"},
  {nullptr, nullptr, 0, nullptr}
};

#if PY_VERSION_HEX >= 0x03070000
#define pystr(x) x
#else
#define pystr(x) const_cast<char*>(x)
#endif
static PyGetSetDef PyvtkMaterialInterfacePieceTransactionMatrix_GetSets[] = {
  { nullptr, nullptr, nullptr, nullptr, nullptr }
};

static PyObject *
PyvtkMaterialInterfacePieceTransactionMatrix_vtkMaterialInterfacePieceTransactionMatrix_s1(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfacePieceTransactionMatrix");

  PyObject *result = nullptr;

  if (ap.CheckArgCount(0))
  {
    vtkMaterialInterfacePieceTransactionMatrix *op = new vtkMaterialInterfacePieceTransactionMatrix();

    result = PyVTKSpecialObject_New("vtkMaterialInterfacePieceTransactionMatrix", op);
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfacePieceTransactionMatrix_vtkMaterialInterfacePieceTransactionMatrix_s2(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfacePieceTransactionMatrix");

  int temp0;
  int temp1;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(2) &&
      ap.GetValue(temp0) &&
      ap.GetValue(temp1))
  {
    vtkMaterialInterfacePieceTransactionMatrix *op = new vtkMaterialInterfacePieceTransactionMatrix(temp0, temp1);

    result = PyVTKSpecialObject_New("vtkMaterialInterfacePieceTransactionMatrix", op);
  }

  return result;
}

static PyObject *
PyvtkMaterialInterfacePieceTransactionMatrix_vtkMaterialInterfacePieceTransactionMatrix_s3(PyObject * /*unused*/, PyObject *args)
{
  vtkPythonArgs ap(args, "vtkMaterialInterfacePieceTransactionMatrix");

  vtkMaterialInterfacePieceTransactionMatrix *temp0 = nullptr;
  PyObject *pobj0 = nullptr;
  PyObject *result = nullptr;

  if (ap.CheckArgCount(1) &&
      ap.GetSpecialObject(temp0, pobj0, "vtkMaterialInterfacePieceTransactionMatrix"))
  {
    vtkMaterialInterfacePieceTransactionMatrix *op = new vtkMaterialInterfacePieceTransactionMatrix(*temp0);

    result = PyVTKSpecialObject_New("vtkMaterialInterfacePieceTransactionMatrix", op);
  }

  Py_XDECREF(pobj0);

  return result;
}

static PyMethodDef PyvtkMaterialInterfacePieceTransactionMatrix_vtkMaterialInterfacePieceTransactionMatrix_Methods[] = {
  {"vtkMaterialInterfacePieceTransactionMatrix", PyvtkMaterialInterfacePieceTransactionMatrix_vtkMaterialInterfacePieceTransactionMatrix_s3, METH_VARARGS,
   "@W vtkMaterialInterfacePieceTransactionMatrix"},
  {nullptr, nullptr, 0, nullptr}
};

static PyObject *
PyvtkMaterialInterfacePieceTransactionMatrix_vtkMaterialInterfacePieceTransactionMatrix(PyObject *self, PyObject *args)
{
  int nargs = vtkPythonArgs::GetArgCount(args);

  switch(nargs)
  {
    case 0:
      return PyvtkMaterialInterfacePieceTransactionMatrix_vtkMaterialInterfacePieceTransactionMatrix_s1(self, args);
    case 2:
      return PyvtkMaterialInterfacePieceTransactionMatrix_vtkMaterialInterfacePieceTransactionMatrix_s2(self, args);
    case 1:
      return PyvtkMaterialInterfacePieceTransactionMatrix_vtkMaterialInterfacePieceTransactionMatrix_s3(self, args);
  }

  vtkPythonArgs::ArgCountError(nargs, "vtkMaterialInterfacePieceTransactionMatrix");
  return nullptr;
}


static const char *PyvtkMaterialInterfacePieceTransactionMatrix_Doc =

  "vtkMaterialInterfacePieceTransactionMatrix()\n    -> vtkMaterialInterfacePieceTransactionMatrix\nC++: vtkMaterialInterfacePieceTransactionMatrix()\nvtkMaterialInterfacePieceTransactionMatrix(nFragments:int, nProcs:int)\n     -> vtkMaterialInterfacePieceTransactionMatrix\nC++: vtkMaterialInterfacePieceTransactionMatrix(int nFragments,\n    int nProcs)\nvtkMaterialInterfacePieceTransactionMatrix(\n    __a:vtkMaterialInterfacePieceTransactionMatrix)\n    -> vtkMaterialInterfacePieceTransactionMatrix\nC++: vtkMaterialInterfacePieceTransactionMatrix(\n    const &vtkMaterialInterfacePieceTransactionMatrix)\n""\n"
  "vtkMaterialInterfacePieceTransactionMatrix - Container to hold  a\nsets of transactions (sends/recvs) indexed by fragment and proc,\nintended to facilitate moving fragment pieces around.\n\n"
  "Internally we have a 2D matrix. On one axis is fragment id on the\n"
  "other is proc id.\n\n"
  "Transaction are intended to execute in fragment order so that no\n"
  "deadlocks occur.\n\n";

static PyObject *
PyvtkMaterialInterfacePieceTransactionMatrix_New(PyTypeObject *, PyObject *args, PyObject *kwds)
{
  if (kwds && PyDict_Size(kwds))
  {
    PyErr_SetString(PyExc_TypeError,
                    "this function takes no keyword arguments");
    return nullptr;
  }

  return PyvtkMaterialInterfacePieceTransactionMatrix_vtkMaterialInterfacePieceTransactionMatrix(nullptr, args);
}

static void PyvtkMaterialInterfacePieceTransactionMatrix_Delete(PyObject *self)
{
  PyVTKSpecialObject *obj = (PyVTKSpecialObject *)self;
  delete static_cast<vtkMaterialInterfacePieceTransactionMatrix *>(obj->vtk_ptr);
  PyObject_Del(self);
}

static Py_hash_t PyvtkMaterialInterfacePieceTransactionMatrix_Hash(PyObject *self)
{
  return PyObject_HashNotImplemented(self);
}

#ifdef VTK_PYTHON_NEEDS_DEPRECATION_WARNING_SUPPRESSION
#pragma GCC diagnostic ignored "-Wdeprecated-declarations"
#endif

static PyTypeObject PyvtkMaterialInterfacePieceTransactionMatrix_Type = {
  PyVarObject_HEAD_INIT(&PyType_Type, 0)
  PYTHON_PACKAGE_SCOPE "vtkPVVTKExtensionsFiltersMaterialInterface.vtkMaterialInterfacePieceTransactionMatrix", // tp_name
  sizeof(PyVTKSpecialObject), // tp_basicsize
  0, // tp_itemsize
  PyvtkMaterialInterfacePieceTransactionMatrix_Delete, // tp_dealloc
#if PY_VERSION_HEX >= 0x03080000
  0, // tp_vectorcall_offset
#else
  nullptr, // tp_print
#endif
  nullptr, // tp_getattr
  nullptr, // tp_setattr
  nullptr, // tp_compare
  PyVTKSpecialObject_Repr, // tp_repr
  nullptr, // tp_as_number
  nullptr, // tp_as_sequence
  nullptr, // tp_as_mapping
  PyvtkMaterialInterfacePieceTransactionMatrix_Hash, // tp_hash
  nullptr, // tp_call
  nullptr, // tp_str
  PyObject_GenericGetAttr, // tp_getattro
  nullptr, // tp_setattro
  nullptr, // tp_as_buffer
  Py_TPFLAGS_DEFAULT, // tp_flags
  PyvtkMaterialInterfacePieceTransactionMatrix_Doc, // tp_doc
  nullptr, // tp_traverse
  nullptr, // tp_clear
  nullptr, // tp_richcompare
  0, // tp_weaklistoffset
  nullptr, // tp_iter
  nullptr, // tp_iternext
  nullptr, // tp_methods
  nullptr, // tp_members
  nullptr, // tp_getset
  nullptr, // tp_base
  nullptr, // tp_dict
  nullptr, // tp_descr_get
  nullptr, // tp_descr_set
  0, // tp_dictoffset
  nullptr, // tp_init
  nullptr, // tp_alloc
  PyvtkMaterialInterfacePieceTransactionMatrix_New, // tp_new
  PyObject_Del, // tp_free
  nullptr, // tp_is_gc
  nullptr, // tp_bases
  nullptr, // tp_mro
  nullptr, // tp_cache
  nullptr, // tp_subclasses
  nullptr, // tp_weaklist
  VTK_WRAP_PYTHON_SUPPRESS_UNINITIALIZED
};

static void *PyvtkMaterialInterfacePieceTransactionMatrix_CCopy(const void *obj)
{
  if (obj)
  {
    return new vtkMaterialInterfacePieceTransactionMatrix(*static_cast<const vtkMaterialInterfacePieceTransactionMatrix*>(obj));
  }
  return nullptr;
}

#ifndef DECLARED_PyvtkMaterialInterfacePieceTransactionMatrix_TypeNew
extern "C" { VTK_ABI_HIDDEN PyObject *PyvtkMaterialInterfacePieceTransactionMatrix_TypeNew(); }
#define DECLARED_PyvtkMaterialInterfacePieceTransactionMatrix_TypeNew
#endif

PyObject *PyvtkMaterialInterfacePieceTransactionMatrix_TypeNew()
{
  PyTypeObject *pytype = PyVTKSpecialType_Add(
    &PyvtkMaterialInterfacePieceTransactionMatrix_Type,
    PyvtkMaterialInterfacePieceTransactionMatrix_Methods,
    PyvtkMaterialInterfacePieceTransactionMatrix_GetSets,
    PyvtkMaterialInterfacePieceTransactionMatrix_vtkMaterialInterfacePieceTransactionMatrix_Methods,
    &PyvtkMaterialInterfacePieceTransactionMatrix_CCopy);

  if ((PyType_GetFlags(pytype) & Py_TPFLAGS_READY) != 0)
  {
    return (PyObject *)pytype;
  }

  PyType_Ready(pytype);
  return (PyObject *)pytype;
}

void PyVTKAddFile_vtkMaterialInterfacePieceTransactionMatrix(
  PyObject *dict)
{
  PyObject *o;
  o = PyvtkMaterialInterfacePieceTransactionMatrix_TypeNew();

  if (o && PyDict_SetItemString(dict, "vtkMaterialInterfacePieceTransactionMatrix", o) != 0)
  {
    Py_DECREF(o);
  }

}

