/* application-window.c generated by valac 0.56.17, the Vala compiler
 * generated from application-window.vala, do not modify */

/*
Peek Copyright (c) 2015-2020 by Philipp Wolfer <ph.wolfer@gmail.com>

This file is part of Peek.

This software is licensed under the GNU General Public License
(version 3 or later). See the LICENSE file in this distribution.

This file contains GPL 3 code taken from corebird, a Gtk+ linux Twitter client.
Copyright (C) 2013 Timm Bäder, https://github.com/baedert/corebird/
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include "../../application.h"
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <glib/gi18n-lib.h>
#include <cairo-gobject.h>
#include <pango/pango.h>
#include <glib/gstdio.h>

#define PEEK_UI_APPLICATION_WINDOW_SMALL_WINDOW_SIZE 400
#define PEEK_APP_ID "com.uploadedlobster.peek"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PEEK_UI_TYPE_APPLICATION_WINDOW (peek_ui_application_window_get_type ())
#define PEEK_UI_APPLICATION_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PEEK_UI_TYPE_APPLICATION_WINDOW, PeekUiApplicationWindow))
#define PEEK_UI_APPLICATION_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PEEK_UI_TYPE_APPLICATION_WINDOW, PeekUiApplicationWindowClass))
#define PEEK_UI_IS_APPLICATION_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PEEK_UI_TYPE_APPLICATION_WINDOW))
#define PEEK_UI_IS_APPLICATION_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PEEK_UI_TYPE_APPLICATION_WINDOW))
#define PEEK_UI_APPLICATION_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PEEK_UI_TYPE_APPLICATION_WINDOW, PeekUiApplicationWindowClass))

typedef struct _PeekUiApplicationWindow PeekUiApplicationWindow;
typedef struct _PeekUiApplicationWindowClass PeekUiApplicationWindowClass;
typedef struct _PeekUiApplicationWindowPrivate PeekUiApplicationWindowPrivate;
enum  {
	PEEK_UI_APPLICATION_WINDOW_0_PROPERTY,
	PEEK_UI_APPLICATION_WINDOW_RECORDER_PROPERTY,
	PEEK_UI_APPLICATION_WINDOW_OPEN_FILE_MANAGER_PROPERTY,
	PEEK_UI_APPLICATION_WINDOW_SHOW_NOTIFICATION_PROPERTY,
	PEEK_UI_APPLICATION_WINDOW_SIZE_INDICATOR_DELAY_PROPERTY,
	PEEK_UI_APPLICATION_WINDOW_RECORDING_START_DELAY_PROPERTY,
	PEEK_UI_APPLICATION_WINDOW_DEFAULT_FILE_NAME_FORMAT_PROPERTY,
	PEEK_UI_APPLICATION_WINDOW_SAVE_FOLDER_PROPERTY,
	PEEK_UI_APPLICATION_WINDOW_NUM_PROPERTIES
};
static GParamSpec* peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block3Data Block3Data;
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_region_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_region_destroy (var), NULL)))
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_builder_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_builder_unref (var), NULL)))
enum  {
	PEEK_UI_APPLICATION_WINDOW_RECORDING_FINISHED_SIGNAL,
	PEEK_UI_APPLICATION_WINDOW_NUM_SIGNALS
};
static guint peek_ui_application_window_signals[PEEK_UI_APPLICATION_WINDOW_NUM_SIGNALS] = {0};

struct _PeekUiApplicationWindow {
	GtkApplicationWindow parent_instance;
	PeekUiApplicationWindowPrivate * priv;
};

struct _PeekUiApplicationWindowClass {
	GtkApplicationWindowClass parent_class;
};

struct _PeekUiApplicationWindowPrivate {
	PeekRecordingScreenRecorder* _recorder;
	gboolean _open_file_manager;
	gboolean _show_notification;
	gint _size_indicator_delay;
	gint _recording_start_delay;
	gchar* _default_file_name_format;
	gchar* _save_folder;
	GtkHeaderBar* headerbar;
	GtkWidget* recording_view;
	GtkButton* record_button;
	GtkButton* stop_button;
	GtkPopover* pop_format;
	GtkRadioButton* gif_button;
	GtkRadioButton* apng_button;
	GtkRadioButton* webm_button;
	GtkRadioButton* mp4_button;
	GtkMenuButton* pop_format_menu;
	GtkLabel* size_indicator;
	GtkLabel* delay_indicator;
	GtkLabel* shortcut_label;
	GtkToggleButton* pop_menu_button;
	GtkPopover* pop_menu;
	guint start_recording_event_source;
	guint size_indicator_timeout;
	guint delay_indicator_timeout;
	guint time_indicator_timeout;
	gboolean is_recording;
	gboolean is_postprocessing;
	GFile* in_file;
	GFile* out_file;
	PeekRecordingRecordingArea active_recording_area;
	gchar* stop_button_label;
	GSettings* settings;
};

struct _Block3Data {
	int _ref_count_;
	PeekUiApplicationWindow* self;
	GtkLabel* title;
};

struct _Block4Data {
	int _ref_count_;
	PeekUiApplicationWindow* self;
	gint delay;
};

struct _Block5Data {
	int _ref_count_;
	Block4Data * _data4_;
	gulong hide_handler;
};

static gint PeekUiApplicationWindow_private_offset;
static gpointer peek_ui_application_window_parent_class = NULL;

VALA_EXTERN GType peek_ui_application_window_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PeekUiApplicationWindow* peek_ui_application_window_new (PeekApplication* application,
                                                         PeekRecordingScreenRecorder* recorder);
VALA_EXTERN PeekUiApplicationWindow* peek_ui_application_window_construct (GType object_type,
                                                               PeekApplication* application,
                                                               PeekRecordingScreenRecorder* recorder);
VALA_EXTERN void peek_ui_application_window_set_recorder (PeekUiApplicationWindow* self,
                                              PeekRecordingScreenRecorder* value);
VALA_EXTERN PeekRecordingScreenRecorder* peek_ui_application_window_get_recorder (PeekUiApplicationWindow* self);
static void __lambda4_ (PeekUiApplicationWindow* self);
static void peek_ui_application_window_enter_recording_state (PeekUiApplicationWindow* self);
static void ___lambda4__peek_recording_screen_recorder_recording_started (PeekRecordingScreenRecorder* _sender,
                                                                   gpointer self);
static void __lambda6_ (PeekUiApplicationWindow* self);
static void peek_ui_application_window_show_file_chooser (PeekUiApplicationWindow* self);
static void ___lambda6__peek_recording_screen_recorder_recording_postprocess_started (PeekRecordingScreenRecorder* _sender,
                                                                               gpointer self);
static void __lambda10_ (PeekUiApplicationWindow* self,
                  GFile* file);
static void peek_ui_application_window_try_save_file (PeekUiApplicationWindow* self);
static void ___lambda10__peek_recording_screen_recorder_recording_finished (PeekRecordingScreenRecorder* _sender,
                                                                     GFile* file,
                                                                     gpointer self);
static void __lambda11_ (PeekUiApplicationWindow* self,
                  GError* reason);
VALA_EXTERN GtkDialog* peek_ui_error_dialog_present_single_instance (GtkWindow* main_window,
                                                         const gchar* summary,
                                                         GError* _error_);
static void peek_ui_application_window_leave_recording_state (PeekUiApplicationWindow* self);
static void ___lambda11__peek_recording_screen_recorder_recording_aborted (PeekRecordingScreenRecorder* _sender,
                                                                    GError* reason,
                                                                    gpointer self);
static void peek_ui_application_window_toggle_recording (PeekUiApplicationWindow* self);
static void _peek_ui_application_window_toggle_recording_peek_application_toggle_recording (PeekApplication* _sender,
                                                                                     gpointer self);
static void peek_ui_application_window_prepare_start_recording (PeekUiApplicationWindow* self);
static void _peek_ui_application_window_prepare_start_recording_peek_application_start_recording (PeekApplication* _sender,
                                                                                           gpointer self);
static void peek_ui_application_window_prepare_stop_recording (PeekUiApplicationWindow* self);
static void _peek_ui_application_window_prepare_stop_recording_peek_application_stop_recording (PeekApplication* _sender,
                                                                                         gpointer self);
static void __lambda16_ (PeekUiApplicationWindow* self,
                  GParamSpec* pspec);
static void peek_ui_application_window_update_format_label (PeekUiApplicationWindow* self);
static void ___lambda16__g_object_notify (GObject* _sender,
                                   GParamSpec* pspec,
                                   gpointer self);
static void peek_ui_application_window_load_geometry (PeekUiApplicationWindow* self);
VALA_EXTERN void peek_ui_application_window_on_window_screen_changed (PeekUiApplicationWindow* self,
                                                          GdkScreen* previous_screen);
static void __lambda17_ (PeekUiApplicationWindow* self);
static void peek_ui_application_window_show_size_indicator (PeekUiApplicationWindow* self);
static void ___lambda17__gtk_widget_show (GtkWidget* _sender,
                                   gpointer self);
static void peek_ui_application_window_set_close_button_position (PeekUiApplicationWindow* self);
VALA_EXTERN void peek_ui_application_window_hide_headerbar (PeekUiApplicationWindow* self);
static gboolean peek_ui_application_window_real_configure_event (GtkWidget* base,
                                                          GdkEventConfigure* event);
VALA_EXTERN void peek_ui_application_window_get_recording_area (PeekUiApplicationWindow* self,
                                                    PeekRecordingRecordingArea* result);
static gboolean peek_ui_application_window_real_delete_event (GtkWidget* base,
                                                       GdkEventAny* event);
static void ___lambda19_ (PeekUiApplicationWindow* self,
                   PeekUiApplicationWindow* file);
static void ____lambda19__peek_ui_application_window_recording_finished (PeekUiApplicationWindow* _sender,
                                                                  gpointer self);
static GNotification* peek_ui_application_window_build_standard_notification (const gchar* message);
static void peek_ui_application_window_save_geometry (PeekUiApplicationWindow* self);
static gchar* peek_ui_application_window_get_format_name (PeekUiApplicationWindow* self,
                                                   PeekOutputFormat format);
static void peek_ui_application_window_select_format (PeekUiApplicationWindow* self,
                                               PeekOutputFormat format);
static void peek_ui_application_window_update_ui_size (PeekUiApplicationWindow* self,
                                                PeekRecordingRecordingArea* area);
static void peek_ui_application_window_update_time (PeekUiApplicationWindow* self);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static gboolean __lambda15_ (Block3Data* _data3_);
static gboolean ___lambda15__gsource_func (gpointer self);
static void _peek_ui_application_window_on_window_screen_changed_gtk_widget_screen_changed (GtkWidget* _sender,
                                                                                     GdkScreen* previous_screen,
                                                                                     gpointer self);
static gboolean peek_ui_application_window_on_window_draw (PeekUiApplicationWindow* self,
                                                    GtkWidget* widget,
                                                    cairo_t* ctx);
static void peek_ui_application_window_update_input_shape (PeekUiApplicationWindow* self);
static gboolean _peek_ui_application_window_on_window_draw_gtk_widget_draw (GtkWidget* _sender,
                                                                     cairo_t* cr,
                                                                     gpointer self);
static gboolean peek_ui_application_window_on_recording_view_draw (PeekUiApplicationWindow* self,
                                                            GtkWidget* widget,
                                                            cairo_t* ctx);
static gboolean _peek_ui_application_window_on_recording_view_draw_gtk_widget_draw (GtkWidget* _sender,
                                                                             cairo_t* cr,
                                                                             gpointer self);
static void peek_ui_application_window_on_recording_view_size_allocate (PeekUiApplicationWindow* self,
                                                                 GtkAllocation* allocation);
static void _peek_ui_application_window_on_recording_view_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                                           GtkAllocation* allocation,
                                                                                           gpointer self);
VALA_EXTERN void peek_ui_application_window_resize_recording_area (PeekUiApplicationWindow* self,
                                                       gint width,
                                                       gint height);
VALA_EXTERN gint peek_ui_application_window_get_size_indicator_delay (PeekUiApplicationWindow* self);
static gboolean _____lambda18_ (PeekUiApplicationWindow* self);
static gboolean ______lambda18__gsource_func (gpointer self);
static void peek_ui_application_window_on_format_selection_toggled (PeekUiApplicationWindow* self);
static void _peek_ui_application_window_on_format_selection_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                        gpointer self);
static void peek_ui_application_window_on_record_button_clicked (PeekUiApplicationWindow* self,
                                                          GtkButton* source);
static void _peek_ui_application_window_on_record_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self);
static void peek_ui_application_window_on_stop_button_clicked (PeekUiApplicationWindow* self,
                                                        GtkButton* source);
static void _peek_ui_application_window_on_stop_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                            gpointer self);
static void peek_ui_application_window_on_new_window_button_clicked (PeekUiApplicationWindow* self,
                                                              GtkButton* source);
static void _peek_ui_application_window_on_new_window_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                  gpointer self);
static void peek_ui_application_window_on_set_window_size_button_clicked (PeekUiApplicationWindow* self,
                                                                   GtkButton* source);
static void _peek_ui_application_window_on_set_window_size_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                       gpointer self);
static void peek_ui_application_window_on_preferences_button_clicked (PeekUiApplicationWindow* self,
                                                               GtkButton* source);
VALA_EXTERN GtkWindow* peek_ui_preferences_dialog_present_single_instance (GtkWindow* main_window);
static void _peek_ui_application_window_on_preferences_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                   gpointer self);
static void peek_ui_application_window_on_about_button_clicked (PeekUiApplicationWindow* self,
                                                         GtkButton* source);
VALA_EXTERN GtkDialog* peek_ui_about_dialog_present_single_instance (GtkWindow* main_window);
static void _peek_ui_application_window_on_about_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                             gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
VALA_EXTERN gint peek_ui_application_window_get_recording_start_delay (PeekUiApplicationWindow* self);
static gboolean ___lambda12_ (Block4Data* _data4_);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda13_ (Block5Data* _data5_);
static void peek_ui_application_window_start_recording (PeekUiApplicationWindow* self);
static void ____lambda13__gtk_widget_hide (GtkWidget* _sender,
                                    gpointer self);
static gboolean ____lambda12__gsource_func (gpointer self);
static void peek_ui_application_window_show_spinner (PeekUiApplicationWindow* self);
static gint peek_ui_application_window_get_window_width (PeekUiApplicationWindow* self);
static void peek_ui_application_window_hide_spinner (PeekUiApplicationWindow* self);
static gboolean __lambda14_ (PeekUiApplicationWindow* self);
static gboolean ___lambda14__gsource_func (gpointer self);
VALA_EXTERN void peek_ui_set_window_size_dialog_close_instance (void);
static void peek_ui_application_window_freeze_window_size (PeekUiApplicationWindow* self);
static void peek_ui_application_window_unfreeze_window_size (PeekUiApplicationWindow* self);
static void ___lambda9_ (PeekUiApplicationWindow* self,
                  GObject* obj,
                  GAsyncResult* res);
static void ____lambda9__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
VALA_EXTERN const gchar* peek_ui_application_window_get_default_file_name_format (PeekUiApplicationWindow* self);
static gchar* peek_ui_application_window_load_preferred_save_folder (PeekUiApplicationWindow* self);
static void peek_ui_application_window_save_file (PeekUiApplicationWindow* self);
static void __lambda7_ (PeekUiApplicationWindow* self,
                 GObject* obj,
                 GAsyncResult* res);
static void peek_ui_application_window_handle_saved_file (PeekUiApplicationWindow* self,
                                                   GFile* file);
static void ___lambda7__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void peek_ui_application_window_save_preferred_save_folder (PeekUiApplicationWindow* self,
                                                            GFile* out_file);
VALA_EXTERN gboolean peek_ui_application_window_get_open_file_manager (PeekUiApplicationWindow* self);
static void peek_ui_application_window_show_file_saved_notification (PeekUiApplicationWindow* self,
                                                              GFile* file);
VALA_EXTERN gboolean peek_ui_application_window_get_show_notification (PeekUiApplicationWindow* self);
VALA_EXTERN const gchar* peek_ui_application_window_get_save_folder (PeekUiApplicationWindow* self);
VALA_EXTERN void peek_ui_application_window_set_save_folder (PeekUiApplicationWindow* self,
                                                 const gchar* value);
static void peek_ui_application_window_move_close_button_left (PeekUiApplicationWindow* self);
VALA_EXTERN void peek_ui_application_window_set_open_file_manager (PeekUiApplicationWindow* self,
                                                       gboolean value);
VALA_EXTERN void peek_ui_application_window_set_show_notification (PeekUiApplicationWindow* self,
                                                       gboolean value);
VALA_EXTERN void peek_ui_application_window_set_size_indicator_delay (PeekUiApplicationWindow* self,
                                                          gint value);
VALA_EXTERN void peek_ui_application_window_set_recording_start_delay (PeekUiApplicationWindow* self,
                                                           gint value);
VALA_EXTERN void peek_ui_application_window_set_default_file_name_format (PeekUiApplicationWindow* self,
                                                              const gchar* value);
static void peek_ui_application_window_finalize (GObject * obj);
static GType peek_ui_application_window_get_type_once (void);
static void _vala_peek_ui_application_window_get_property (GObject * object,
                                                    guint property_id,
                                                    GValue * value,
                                                    GParamSpec * pspec);
static void _vala_peek_ui_application_window_set_property (GObject * object,
                                                    guint property_id,
                                                    const GValue * value,
                                                    GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
peek_ui_application_window_get_instance_private (PeekUiApplicationWindow* self)
{
	return G_STRUCT_MEMBER_P (self, PeekUiApplicationWindow_private_offset);
}

static void
__lambda4_ (PeekUiApplicationWindow* self)
{
	peek_ui_application_window_enter_recording_state (self);
}

static void
___lambda4__peek_recording_screen_recorder_recording_started (PeekRecordingScreenRecorder* _sender,
                                                              gpointer self)
{
	__lambda4_ ((PeekUiApplicationWindow*) self);
}

static void
__lambda6_ (PeekUiApplicationWindow* self)
{
	self->priv->is_postprocessing = TRUE;
	peek_ui_application_window_show_file_chooser (self);
}

static void
___lambda6__peek_recording_screen_recorder_recording_postprocess_started (PeekRecordingScreenRecorder* _sender,
                                                                          gpointer self)
{
	__lambda6_ ((PeekUiApplicationWindow*) self);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
__lambda10_ (PeekUiApplicationWindow* self,
             GFile* file)
{
	GFile* _tmp0_;
	g_return_if_fail (file != NULL);
	_tmp0_ = _g_object_ref0 (file);
	_g_object_unref0 (self->priv->in_file);
	self->priv->in_file = _tmp0_;
	peek_ui_application_window_try_save_file (self);
}

static void
___lambda10__peek_recording_screen_recorder_recording_finished (PeekRecordingScreenRecorder* _sender,
                                                                GFile* file,
                                                                gpointer self)
{
	__lambda10_ ((PeekUiApplicationWindow*) self, file);
}

static void
__lambda11_ (PeekUiApplicationWindow* self,
             GError* reason)
{
	if (reason != NULL) {
		FILE* _tmp0_;
		const gchar* _tmp1_;
		GtkDialog* _tmp2_;
		GtkDialog* _tmp3_;
		_tmp0_ = stderr;
		_tmp1_ = reason->message;
		fprintf (_tmp0_, "Recording canceled: %s\n", _tmp1_);
		_tmp2_ = peek_ui_error_dialog_present_single_instance ((GtkWindow*) self, _ ("An unexpected error occurred during recording. Recording was aborted."), reason);
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp3_);
	} else {
		FILE* _tmp4_;
		_tmp4_ = stderr;
		fprintf (_tmp4_, "Recording canceled\n");
	}
	_g_object_unref0 (self->priv->in_file);
	self->priv->in_file = NULL;
	peek_ui_application_window_leave_recording_state (self);
}

static void
___lambda11__peek_recording_screen_recorder_recording_aborted (PeekRecordingScreenRecorder* _sender,
                                                               GError* reason,
                                                               gpointer self)
{
	__lambda11_ ((PeekUiApplicationWindow*) self, reason);
}

static void
_peek_ui_application_window_toggle_recording_peek_application_toggle_recording (PeekApplication* _sender,
                                                                                gpointer self)
{
	peek_ui_application_window_toggle_recording ((PeekUiApplicationWindow*) self);
}

static void
_peek_ui_application_window_prepare_start_recording_peek_application_start_recording (PeekApplication* _sender,
                                                                                      gpointer self)
{
	peek_ui_application_window_prepare_start_recording ((PeekUiApplicationWindow*) self);
}

static void
_peek_ui_application_window_prepare_stop_recording_peek_application_stop_recording (PeekApplication* _sender,
                                                                                    gpointer self)
{
	peek_ui_application_window_prepare_stop_recording ((PeekUiApplicationWindow*) self);
}

static void
__lambda16_ (PeekUiApplicationWindow* self,
             GParamSpec* pspec)
{
	g_return_if_fail (pspec != NULL);
	peek_ui_application_window_update_format_label (self);
}

static void
___lambda16__g_object_notify (GObject* _sender,
                              GParamSpec* pspec,
                              gpointer self)
{
	__lambda16_ ((PeekUiApplicationWindow*) self, pspec);
}

static void
__lambda17_ (PeekUiApplicationWindow* self)
{
	peek_ui_application_window_show_size_indicator (self);
	peek_ui_application_window_update_format_label (self);
}

static void
___lambda17__gtk_widget_show (GtkWidget* _sender,
                              gpointer self)
{
	__lambda17_ ((PeekUiApplicationWindow*) self);
}

PeekUiApplicationWindow*
peek_ui_application_window_construct (GType object_type,
                                      PeekApplication* application,
                                      PeekRecordingScreenRecorder* recorder)
{
	PeekUiApplicationWindow * self = NULL;
	PeekRecordingScreenRecorder* _tmp0_;
	PeekRecordingScreenRecorder* _tmp1_;
	PeekRecordingScreenRecorder* _tmp2_;
	PeekRecordingScreenRecorder* _tmp3_;
	GSettings* _tmp4_;
	GSettings* _tmp5_;
	GSettings* _tmp6_;
	GSettings* _tmp7_;
	GSettings* _tmp8_;
	GSettings* _tmp9_;
	GtkSettings* _tmp10_;
	GSettings* _tmp11_;
	PeekRecordingScreenRecorder* _tmp12_;
	PeekRecordingRecordingConfig* _tmp13_;
	PeekRecordingRecordingConfig* _tmp14_;
	GSettings* _tmp15_;
	PeekRecordingScreenRecorder* _tmp16_;
	PeekRecordingRecordingConfig* _tmp17_;
	PeekRecordingRecordingConfig* _tmp18_;
	GSettings* _tmp19_;
	PeekRecordingScreenRecorder* _tmp20_;
	PeekRecordingRecordingConfig* _tmp21_;
	PeekRecordingRecordingConfig* _tmp22_;
	GSettings* _tmp23_;
	PeekRecordingScreenRecorder* _tmp24_;
	PeekRecordingRecordingConfig* _tmp25_;
	PeekRecordingRecordingConfig* _tmp26_;
	GSettings* _tmp27_;
	PeekRecordingScreenRecorder* _tmp28_;
	PeekRecordingRecordingConfig* _tmp29_;
	PeekRecordingRecordingConfig* _tmp30_;
	GSettings* _tmp31_;
	PeekRecordingScreenRecorder* _tmp32_;
	PeekRecordingRecordingConfig* _tmp33_;
	PeekRecordingRecordingConfig* _tmp34_;
	GSettings* _tmp35_;
	GSettings* _tmp36_;
	PeekRecordingScreenRecorder* _tmp37_;
	PeekRecordingRecordingConfig* _tmp38_;
	PeekRecordingRecordingConfig* _tmp39_;
	GtkButton* _tmp40_;
	const gchar* _tmp41_;
	const gchar* _tmp42_;
	gchar* _tmp43_;
	g_return_val_if_fail (application != NULL, NULL);
	g_return_val_if_fail (recorder != NULL, NULL);
	self = (PeekUiApplicationWindow*) g_object_new (object_type, "application", application, NULL);
	peek_ui_application_window_set_recorder (self, recorder);
	_tmp0_ = self->priv->_recorder;
	g_signal_connect_object (_tmp0_, "recording-started", (GCallback) ___lambda4__peek_recording_screen_recorder_recording_started, self, 0);
	_tmp1_ = self->priv->_recorder;
	g_signal_connect_object (_tmp1_, "recording-postprocess-started", (GCallback) ___lambda6__peek_recording_screen_recorder_recording_postprocess_started, self, 0);
	_tmp2_ = self->priv->_recorder;
	g_signal_connect_object (_tmp2_, "recording-finished", (GCallback) ___lambda10__peek_recording_screen_recorder_recording_finished, self, 0);
	_tmp3_ = self->priv->_recorder;
	g_signal_connect_object (_tmp3_, "recording-aborted", (GCallback) ___lambda11__peek_recording_screen_recorder_recording_aborted, self, 0);
	g_signal_connect_object (application, "toggle-recording", (GCallback) _peek_ui_application_window_toggle_recording_peek_application_toggle_recording, self, 0);
	g_signal_connect_object (application, "start-recording", (GCallback) _peek_ui_application_window_prepare_start_recording_peek_application_start_recording, self, 0);
	g_signal_connect_object (application, "stop-recording", (GCallback) _peek_ui_application_window_prepare_stop_recording_peek_application_stop_recording, self, 0);
	_tmp4_ = peek_application_get_app_settings ();
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp4_;
	_tmp5_ = self->priv->settings;
	g_settings_bind (_tmp5_, "interface-open-file-manager", (GObject*) self, "open_file_manager", G_SETTINGS_BIND_DEFAULT);
	_tmp6_ = self->priv->settings;
	g_settings_bind (_tmp6_, "interface-show-notification", (GObject*) self, "show_notification", G_SETTINGS_BIND_DEFAULT);
	_tmp7_ = self->priv->settings;
	g_settings_bind (_tmp7_, "interface-size-indicator-delay", (GObject*) self, "size_indicator_delay", G_SETTINGS_BIND_DEFAULT);
	_tmp8_ = self->priv->settings;
	g_settings_bind (_tmp8_, "interface-default-file-name-format", (GObject*) self, "default_file_name_format", G_SETTINGS_BIND_DEFAULT);
	_tmp9_ = self->priv->settings;
	_tmp10_ = gtk_widget_get_settings ((GtkWidget*) self);
	g_settings_bind (_tmp9_, "interface-prefer-dark-theme", (GObject*) _tmp10_, "gtk_application_prefer_dark_theme", G_SETTINGS_BIND_DEFAULT);
	_tmp11_ = self->priv->settings;
	_tmp12_ = self->priv->_recorder;
	_tmp13_ = peek_recording_screen_recorder_get_config (_tmp12_);
	_tmp14_ = _tmp13_;
	g_settings_bind (_tmp11_, "recording-output-format", (GObject*) _tmp14_, "output_format", G_SETTINGS_BIND_DEFAULT);
	_tmp15_ = self->priv->settings;
	_tmp16_ = self->priv->_recorder;
	_tmp17_ = peek_recording_screen_recorder_get_config (_tmp16_);
	_tmp18_ = _tmp17_;
	g_settings_bind (_tmp15_, "recording-gifski-enabled", (GObject*) _tmp18_, "gifski_enabled", G_SETTINGS_BIND_DEFAULT);
	_tmp19_ = self->priv->settings;
	_tmp20_ = self->priv->_recorder;
	_tmp21_ = peek_recording_screen_recorder_get_config (_tmp20_);
	_tmp22_ = _tmp21_;
	g_settings_bind (_tmp19_, "recording-gifski-quality", (GObject*) _tmp22_, "gifski_quality", G_SETTINGS_BIND_DEFAULT);
	_tmp23_ = self->priv->settings;
	_tmp24_ = self->priv->_recorder;
	_tmp25_ = peek_recording_screen_recorder_get_config (_tmp24_);
	_tmp26_ = _tmp25_;
	g_settings_bind (_tmp23_, "recording-framerate", (GObject*) _tmp26_, "framerate", G_SETTINGS_BIND_DEFAULT);
	_tmp27_ = self->priv->settings;
	_tmp28_ = self->priv->_recorder;
	_tmp29_ = peek_recording_screen_recorder_get_config (_tmp28_);
	_tmp30_ = _tmp29_;
	g_settings_bind (_tmp27_, "recording-downsample", (GObject*) _tmp30_, "downsample", G_SETTINGS_BIND_DEFAULT);
	_tmp31_ = self->priv->settings;
	_tmp32_ = self->priv->_recorder;
	_tmp33_ = peek_recording_screen_recorder_get_config (_tmp32_);
	_tmp34_ = _tmp33_;
	g_settings_bind (_tmp31_, "recording-capture-mouse", (GObject*) _tmp34_, "capture_mouse", G_SETTINGS_BIND_DEFAULT);
	_tmp35_ = self->priv->settings;
	g_settings_bind (_tmp35_, "recording-start-delay", (GObject*) self, "recording_start_delay", G_SETTINGS_BIND_DEFAULT);
	_tmp36_ = self->priv->settings;
	g_settings_bind (_tmp36_, "persist-save-folder", (GObject*) self, "save_folder", G_SETTINGS_BIND_DEFAULT);
	_tmp37_ = self->priv->_recorder;
	_tmp38_ = peek_recording_screen_recorder_get_config (_tmp37_);
	_tmp39_ = _tmp38_;
	g_signal_connect_object ((GObject*) _tmp39_, "notify::output-format", (GCallback) ___lambda16__g_object_notify, self, 0);
	gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	peek_ui_application_window_load_geometry (self);
	peek_ui_application_window_on_window_screen_changed (self, NULL);
	g_signal_connect_object ((GtkWidget*) self, "show", (GCallback) ___lambda17__gtk_widget_show, self, 0);
	_tmp40_ = self->priv->stop_button;
	_tmp41_ = gtk_button_get_label (_tmp40_);
	_tmp42_ = _tmp41_;
	_tmp43_ = g_strdup (_tmp42_);
	_g_free0 (self->priv->stop_button_label);
	self->priv->stop_button_label = _tmp43_;
	peek_ui_application_window_set_close_button_position (self);
	return self;
}

PeekUiApplicationWindow*
peek_ui_application_window_new (PeekApplication* application,
                                PeekRecordingScreenRecorder* recorder)
{
	return peek_ui_application_window_construct (PEEK_UI_TYPE_APPLICATION_WINDOW, application, recorder);
}

void
peek_ui_application_window_hide_headerbar (PeekUiApplicationWindow* self)
{
	GtkStyleContext* _tmp0_;
	GtkHeaderBar* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_add_class (_tmp0_, "headerbar-hidden");
	_tmp1_ = self->priv->headerbar;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
}

static gboolean
peek_ui_application_window_real_configure_event (GtkWidget* base,
                                                 GdkEventConfigure* event)
{
	PeekUiApplicationWindow * self;
	PeekRecordingScreenRecorder* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gboolean result;
	self = (PeekUiApplicationWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_recorder;
	_tmp1_ = peek_recording_screen_recorder_get_is_recording (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		PeekRecordingRecordingArea new_recording_area = {0};
		PeekRecordingRecordingArea _tmp3_ = {0};
		PeekRecordingRecordingArea _tmp4_;
		peek_ui_application_window_get_recording_area (self, &_tmp3_);
		new_recording_area = _tmp3_;
		_tmp4_ = self->priv->active_recording_area;
		if (!peek_recording_recording_area_equals (&new_recording_area, &_tmp4_)) {
			PeekRecordingScreenRecorder* _tmp5_;
			_tmp5_ = self->priv->_recorder;
			peek_recording_screen_recorder_cancel (_tmp5_);
		}
		peek_recording_recording_area_destroy (&new_recording_area);
	}
	result = GTK_WIDGET_CLASS (peek_ui_application_window_parent_class)->configure_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_application_window_get_type (), GtkApplicationWindow), event);
	return result;
}

static gchar*
bool_to_string (gboolean self)
{
	gchar* result;
	if (self) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup ("true");
		result = _tmp0_;
		return result;
	} else {
		gchar* _tmp1_;
		_tmp1_ = g_strdup ("false");
		result = _tmp1_;
		return result;
	}
}

static void
___lambda19_ (PeekUiApplicationWindow* self,
              PeekUiApplicationWindow* file)
{
	GtkApplication* _tmp0_;
	GtkApplication* _tmp1_;
	g_return_if_fail (file != NULL);
	_tmp0_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp1_ = _tmp0_;
	g_application_withdraw_notification ((GApplication*) _tmp1_, "background-rendering");
	gtk_window_close ((GtkWindow*) self);
}

static void
____lambda19__peek_ui_application_window_recording_finished (PeekUiApplicationWindow* _sender,
                                                             gpointer self)
{
	___lambda19_ ((PeekUiApplicationWindow*) self, _sender);
}

static gboolean
peek_ui_application_window_real_delete_event (GtkWidget* base,
                                              GdkEventAny* event)
{
	PeekUiApplicationWindow * self;
	PeekRecordingScreenRecorder* _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gboolean _tmp7_ = FALSE;
	PeekRecordingScreenRecorder* _tmp8_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	gboolean result;
	self = (PeekUiApplicationWindow*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = self->priv->_recorder;
	_tmp1_ = peek_recording_screen_recorder_get_is_recording (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = bool_to_string (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = bool_to_string (self->priv->is_postprocessing);
	_tmp6_ = _tmp5_;
	g_debug ("application-window.vala:233: delete_event: recorder.is_recording=%s, w" \
"indow.is_postprocessing=%s", _tmp4_, _tmp6_);
	_g_free0 (_tmp6_);
	_g_free0 (_tmp4_);
	_tmp8_ = self->priv->_recorder;
	_tmp9_ = peek_recording_screen_recorder_get_is_recording (_tmp8_);
	_tmp10_ = _tmp9_;
	if (_tmp10_) {
		_tmp7_ = TRUE;
	} else {
		_tmp7_ = self->priv->is_postprocessing;
	}
	if (_tmp7_) {
		PeekRecordingScreenRecorder* _tmp11_;
		gboolean _tmp12_;
		gboolean _tmp13_;
		g_signal_connect_object (self, "recording-finished", (GCallback) ____lambda19__peek_ui_application_window_recording_finished, self, 0);
		_tmp11_ = self->priv->_recorder;
		_tmp12_ = peek_recording_screen_recorder_get_is_recording (_tmp11_);
		_tmp13_ = _tmp12_;
		if (_tmp13_) {
			PeekRecordingScreenRecorder* _tmp14_;
			_tmp14_ = self->priv->_recorder;
			peek_recording_screen_recorder_cancel (_tmp14_);
		} else {
			GNotification* notification = NULL;
			GNotification* _tmp15_;
			GNotification* _tmp16_;
			GtkApplication* _tmp17_;
			GtkApplication* _tmp18_;
			GNotification* _tmp19_;
			_tmp15_ = peek_ui_application_window_build_standard_notification (_ ("Rendering animation…"));
			notification = _tmp15_;
			_tmp16_ = notification;
			g_notification_set_body (_tmp16_, _ ("Peek will close when rendering is finished."));
			_tmp17_ = gtk_window_get_application ((GtkWindow*) self);
			_tmp18_ = _tmp17_;
			_tmp19_ = notification;
			g_application_send_notification ((GApplication*) _tmp18_, "background-rendering", _tmp19_);
			_g_object_unref0 (notification);
		}
		gtk_widget_hide ((GtkWidget*) self);
		result = TRUE;
		return result;
	}
	if (self->priv->start_recording_event_source != ((guint) 0)) {
		g_source_remove (self->priv->start_recording_event_source);
		self->priv->start_recording_event_source = (guint) 0;
	}
	if (self->priv->size_indicator_timeout != ((guint) 0)) {
		g_source_remove (self->priv->size_indicator_timeout);
		self->priv->size_indicator_timeout = (guint) 0;
	}
	if (self->priv->delay_indicator_timeout != ((guint) 0)) {
		g_source_remove (self->priv->delay_indicator_timeout);
		self->priv->delay_indicator_timeout = (guint) 0;
	}
	if (self->priv->time_indicator_timeout != ((guint) 0)) {
		g_source_remove (self->priv->time_indicator_timeout);
		self->priv->time_indicator_timeout = (guint) 0;
	}
	peek_ui_application_window_save_geometry (self);
	result = FALSE;
	return result;
}

static gchar*
peek_ui_application_window_get_format_name (PeekUiApplicationWindow* self,
                                            PeekOutputFormat format)
{
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	switch (format) {
		case PEEK_OUTPUT_FORMAT_APNG:
		{
			gchar* _tmp0_;
			_tmp0_ = g_strdup (_ ("APNG"));
			result = _tmp0_;
			return result;
		}
		case PEEK_OUTPUT_FORMAT_GIF:
		{
			gchar* _tmp1_;
			_tmp1_ = g_strdup (_ ("GIF"));
			result = _tmp1_;
			return result;
		}
		case PEEK_OUTPUT_FORMAT_MP4:
		{
			gchar* _tmp2_;
			_tmp2_ = g_strdup (_ ("MP4"));
			result = _tmp2_;
			return result;
		}
		case PEEK_OUTPUT_FORMAT_WEBM:
		{
			gchar* _tmp3_;
			_tmp3_ = g_strdup (_ ("WebM"));
			result = _tmp3_;
			return result;
		}
		default:
		{
			gchar* _tmp4_;
			_tmp4_ = g_strdup ("");
			result = _tmp4_;
			return result;
		}
	}
}

static void
peek_ui_application_window_select_format (PeekUiApplicationWindow* self,
                                          PeekOutputFormat format)
{
	PeekRecordingScreenRecorder* _tmp0_;
	PeekRecordingRecordingConfig* _tmp1_;
	PeekRecordingRecordingConfig* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_recorder;
	_tmp1_ = peek_recording_screen_recorder_get_config (_tmp0_);
	_tmp2_ = _tmp1_;
	peek_recording_recording_config_set_output_format (_tmp2_, format);
	peek_ui_application_window_update_format_label (self);
}

static void
peek_ui_application_window_update_format_label (PeekUiApplicationWindow* self)
{
	gchar* format_name = NULL;
	PeekRecordingScreenRecorder* _tmp0_;
	PeekRecordingRecordingConfig* _tmp1_;
	PeekRecordingRecordingConfig* _tmp2_;
	PeekOutputFormat _tmp3_;
	PeekOutputFormat _tmp4_;
	gchar* _tmp5_;
	GtkButton* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	PeekRecordingRecordingArea area = {0};
	PeekRecordingRecordingArea _tmp9_ = {0};
	PeekRecordingRecordingArea _tmp10_;
	GtkPopover* _tmp11_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_recorder;
	_tmp1_ = peek_recording_screen_recorder_get_config (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = peek_recording_recording_config_get_output_format (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = peek_ui_application_window_get_format_name (self, _tmp4_);
	format_name = _tmp5_;
	_tmp6_ = self->priv->record_button;
	_tmp7_ = g_strdup_printf (_ ("Record as %s"), format_name);
	_tmp8_ = _tmp7_;
	gtk_button_set_label (_tmp6_, _tmp8_);
	_g_free0 (_tmp8_);
	peek_ui_application_window_get_recording_area (self, &_tmp9_);
	area = _tmp9_;
	_tmp10_ = area;
	peek_ui_application_window_update_ui_size (self, &_tmp10_);
	_tmp11_ = self->priv->pop_format;
	gtk_widget_hide ((GtkWidget*) _tmp11_);
	peek_recording_recording_area_destroy (&area);
	_g_free0 (format_name);
}

static Block3Data*
block3_data_ref (Block3Data* _data3_)
{
	g_atomic_int_inc (&_data3_->_ref_count_);
	return _data3_;
}

static void
block3_data_unref (void * _userdata_)
{
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
		PeekUiApplicationWindow* self;
		self = _data3_->self;
		_g_object_unref0 (_data3_->title);
		_g_object_unref0 (self);
		g_slice_free (Block3Data, _data3_);
	}
}

static gboolean
__lambda15_ (Block3Data* _data3_)
{
	PeekUiApplicationWindow* self;
	gboolean _tmp0_ = FALSE;
	GtkHeaderBar* _tmp6_;
	gboolean result;
	self = _data3_->self;
	if (self->priv->is_recording) {
		_tmp0_ = !self->priv->is_postprocessing;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint64 seconds = 0LL;
		PeekRecordingScreenRecorder* _tmp1_;
		gint64 _tmp2_;
		gint64 _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp1_ = self->priv->_recorder;
		_tmp2_ = peek_recording_screen_recorder_get_elapsed_seconds (_tmp1_);
		_tmp3_ = _tmp2_;
		seconds = _tmp3_;
		_tmp4_ = peek_utils_format_time (seconds);
		_tmp5_ = _tmp4_;
		gtk_label_set_label (_data3_->title, _tmp5_);
		_g_free0 (_tmp5_);
		result = TRUE;
		return result;
	}
	self->priv->time_indicator_timeout = (guint) 0;
	_tmp6_ = self->priv->headerbar;
	gtk_header_bar_set_custom_title (_tmp6_, NULL);
	result = FALSE;
	return result;
}

static gboolean
___lambda15__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda15_ (self);
	return result;
}

static void
peek_ui_application_window_update_time (PeekUiApplicationWindow* self)
{
	Block3Data* _data3_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	GtkLabel* _tmp2_;
	GtkLabel* _tmp3_;
	GtkHeaderBar* _tmp4_;
	g_return_if_fail (self != NULL);
	_data3_ = g_slice_new0 (Block3Data);
	_data3_->_ref_count_ = 1;
	_data3_->self = g_object_ref (self);
	_tmp0_ = peek_utils_format_time ((gint64) 0);
	_tmp1_ = _tmp0_;
	_tmp2_ = (GtkLabel*) gtk_label_new (_tmp1_);
	g_object_ref_sink (_tmp2_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	_data3_->title = _tmp3_;
	gtk_widget_show ((GtkWidget*) _data3_->title);
	_tmp4_ = self->priv->headerbar;
	gtk_header_bar_set_custom_title (_tmp4_, (GtkWidget*) _data3_->title);
	self->priv->time_indicator_timeout = g_timeout_add_full (G_PRIORITY_LOW, (guint) 500, ___lambda15__gsource_func, block3_data_ref (_data3_), block3_data_unref);
	block3_data_unref (_data3_);
	_data3_ = NULL;
}

void
peek_ui_application_window_on_window_screen_changed (PeekUiApplicationWindow* self,
                                                     GdkScreen* previous_screen)
{
	GdkScreen* screen = NULL;
	GdkScreen* _tmp0_;
	GdkScreen* _tmp1_;
	GdkVisual* visual = NULL;
	GdkScreen* _tmp2_;
	GdkVisual* _tmp3_;
	GdkVisual* _tmp4_;
	GdkVisual* _tmp5_;
	GdkVisual* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_window_get_screen ((GtkWindow*) self);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	screen = _tmp1_;
	_tmp2_ = screen;
	_tmp3_ = gdk_screen_get_rgba_visual (_tmp2_);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	visual = _tmp4_;
	_tmp5_ = visual;
	if (_tmp5_ == NULL) {
		FILE* _tmp6_;
		GdkScreen* _tmp7_;
		GdkVisual* _tmp8_;
		GdkVisual* _tmp9_;
		_tmp6_ = stderr;
		fprintf (_tmp6_, "Screen does not support alpha channels!");
		_tmp7_ = screen;
		_tmp8_ = gdk_screen_get_system_visual (_tmp7_);
		_tmp9_ = _g_object_ref0 (_tmp8_);
		_g_object_unref0 (visual);
		visual = _tmp9_;
	}
	_tmp10_ = visual;
	gtk_widget_set_visual ((GtkWidget*) self, _tmp10_);
	_g_object_unref0 (visual);
	_g_object_unref0 (screen);
}

static void
_peek_ui_application_window_on_window_screen_changed_gtk_widget_screen_changed (GtkWidget* _sender,
                                                                                GdkScreen* previous_screen,
                                                                                gpointer self)
{
	peek_ui_application_window_on_window_screen_changed ((PeekUiApplicationWindow*) self, previous_screen);
}

static gboolean
peek_ui_application_window_on_window_draw (PeekUiApplicationWindow* self,
                                           GtkWidget* widget,
                                           cairo_t* ctx)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	peek_ui_application_window_update_input_shape (self);
	result = FALSE;
	return result;
}

static gboolean
_peek_ui_application_window_on_window_draw_gtk_widget_draw (GtkWidget* _sender,
                                                            cairo_t* cr,
                                                            gpointer self)
{
	gboolean result;
	result = peek_ui_application_window_on_window_draw ((PeekUiApplicationWindow*) self, _sender, cr);
	return result;
}

static gboolean
peek_ui_application_window_on_recording_view_draw (PeekUiApplicationWindow* self,
                                                   GtkWidget* widget,
                                                   cairo_t* ctx)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (ctx != NULL, FALSE);
	cairo_set_operator (ctx, CAIRO_OPERATOR_CLEAR);
	cairo_paint (ctx);
	result = FALSE;
	return result;
}

static gboolean
_peek_ui_application_window_on_recording_view_draw_gtk_widget_draw (GtkWidget* _sender,
                                                                    cairo_t* cr,
                                                                    gpointer self)
{
	gboolean result;
	result = peek_ui_application_window_on_recording_view_draw ((PeekUiApplicationWindow*) self, _sender, cr);
	return result;
}

static void
peek_ui_application_window_on_recording_view_size_allocate (PeekUiApplicationWindow* self,
                                                            GtkAllocation* allocation)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (allocation != NULL);
	peek_ui_application_window_show_size_indicator (self);
}

static void
_peek_ui_application_window_on_recording_view_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender,
                                                                                      GtkAllocation* allocation,
                                                                                      gpointer self)
{
	peek_ui_application_window_on_recording_view_size_allocate ((PeekUiApplicationWindow*) self, allocation);
}

void
peek_ui_application_window_get_recording_area (PeekUiApplicationWindow* self,
                                               PeekRecordingRecordingArea* result)
{
	GtkWidget* _tmp0_;
	PeekRecordingRecordingArea _tmp1_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->recording_view;
	peek_recording_recording_area_create_for_widget (_tmp0_, &_tmp1_);
	*result = _tmp1_;
	return;
}

void
peek_ui_application_window_resize_recording_area (PeekUiApplicationWindow* self,
                                                  gint width,
                                                  gint height)
{
	gint window_width = 0;
	gint window_height = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	PeekRecordingRecordingArea area = {0};
	PeekRecordingRecordingArea _tmp2_ = {0};
	PeekRecordingRecordingArea _tmp3_ = {0};
	PeekRecordingRecordingArea _tmp4_;
	PeekRecordingRecordingArea _tmp5_;
	PeekRecordingRecordingArea _tmp6_;
	g_return_if_fail (self != NULL);
	if (self->priv->is_recording) {
		return;
	}
	gtk_window_get_size ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	window_width = _tmp0_;
	window_height = _tmp1_;
	peek_ui_application_window_get_recording_area (self, &_tmp2_);
	area = _tmp2_;
	memset (&_tmp3_, 0, sizeof (PeekRecordingRecordingArea));
	_tmp3_.width = width;
	_tmp3_.height = height;
	_tmp4_ = _tmp3_;
	peek_ui_application_window_update_ui_size (self, &_tmp4_);
	peek_recording_recording_area_destroy (&_tmp4_);
	_tmp5_ = area;
	_tmp6_ = area;
	gtk_window_resize ((GtkWindow*) self, width + (window_width - _tmp5_.width), height + (window_height - _tmp6_.height));
	peek_recording_recording_area_destroy (&area);
}

static gboolean
_____lambda18_ (PeekUiApplicationWindow* self)
{
	GtkLabel* _tmp0_;
	GtkLabel* _tmp1_;
	gboolean result;
	self->priv->size_indicator_timeout = (guint) 0;
	_tmp0_ = self->priv->size_indicator;
	gtk_widget_set_opacity ((GtkWidget*) _tmp0_, 0.0);
	_tmp1_ = self->priv->shortcut_label;
	gtk_widget_set_opacity ((GtkWidget*) _tmp1_, 0.0);
	peek_ui_application_window_update_input_shape (self);
	result = FALSE;
	return result;
}

static gboolean
______lambda18__gsource_func (gpointer self)
{
	gboolean result;
	result = _____lambda18_ ((PeekUiApplicationWindow*) self);
	return result;
}

static void
peek_ui_application_window_show_size_indicator (PeekUiApplicationWindow* self)
{
	g_return_if_fail (self != NULL);
	if (gtk_widget_get_realized ((GtkWidget*) self)) {
		PeekRecordingRecordingArea area = {0};
		PeekRecordingRecordingArea _tmp0_ = {0};
		PeekRecordingRecordingArea _tmp1_;
		peek_ui_application_window_update_input_shape (self);
		peek_ui_application_window_get_recording_area (self, &_tmp0_);
		area = _tmp0_;
		_tmp1_ = area;
		peek_ui_application_window_update_ui_size (self, &_tmp1_);
		if (!self->priv->is_recording) {
			GSettings* shortcut = NULL;
			GSettings* _tmp2_;
			gchar* keys = NULL;
			GSettings* _tmp3_;
			gchar* _tmp4_;
			guint accelerator_key = 0U;
			GdkModifierType accelerator_mods = 0U;
			const gchar* _tmp5_;
			guint _tmp6_ = 0U;
			GdkModifierType _tmp7_ = 0U;
			gchar* shortcut_hint = NULL;
			gchar* _tmp8_;
			GtkLabel* _tmp9_;
			const gchar* _tmp10_;
			gchar* _tmp11_;
			gchar* _tmp12_;
			GtkLabel* _tmp13_;
			GString* size_label = NULL;
			GString* _tmp14_;
			GString* _tmp15_;
			PeekRecordingRecordingArea _tmp16_;
			PeekRecordingRecordingArea _tmp17_;
			GtkLabel* _tmp18_;
			GString* _tmp19_;
			const gchar* _tmp20_;
			GtkLabel* _tmp21_;
			PeekRecordingScreenRecorder* _tmp22_;
			gboolean _tmp23_;
			gboolean _tmp24_;
			_tmp2_ = peek_application_get_app_settings ();
			shortcut = _tmp2_;
			_tmp3_ = shortcut;
			_tmp4_ = g_settings_get_string (_tmp3_, "keybinding-toggle-recording");
			keys = _tmp4_;
			_tmp5_ = keys;
			gtk_accelerator_parse (_tmp5_, &_tmp6_, &_tmp7_);
			accelerator_key = _tmp6_;
			accelerator_mods = _tmp7_;
			_tmp8_ = gtk_accelerator_get_label (accelerator_key, accelerator_mods);
			shortcut_hint = _tmp8_;
			_tmp9_ = self->priv->shortcut_label;
			_tmp10_ = shortcut_hint;
			_tmp11_ = g_strdup_printf (_ ("Start / Stop: %s"), _tmp10_);
			_tmp12_ = _tmp11_;
			gtk_label_set_text (_tmp9_, _tmp12_);
			_g_free0 (_tmp12_);
			_tmp13_ = self->priv->shortcut_label;
			gtk_widget_show ((GtkWidget*) _tmp13_);
			_tmp14_ = g_string_new ("");
			size_label = _tmp14_;
			_tmp15_ = size_label;
			_tmp16_ = area;
			_tmp17_ = area;
			g_string_printf (_tmp15_, "%i x %i", _tmp16_.width, _tmp17_.height);
			_tmp18_ = self->priv->size_indicator;
			_tmp19_ = size_label;
			_tmp20_ = _tmp19_->str;
			gtk_label_set_text (_tmp18_, _tmp20_);
			_tmp21_ = self->priv->size_indicator;
			gtk_widget_show ((GtkWidget*) _tmp21_);
			if (self->priv->size_indicator_timeout != ((guint) 0)) {
				g_source_remove (self->priv->size_indicator_timeout);
			}
			_tmp22_ = self->priv->_recorder;
			_tmp23_ = peek_recording_screen_recorder_get_is_recording (_tmp22_);
			_tmp24_ = _tmp23_;
			if (!_tmp24_) {
				GtkLabel* _tmp25_;
				GtkLabel* _tmp26_;
				gint _tmp27_;
				_tmp25_ = self->priv->shortcut_label;
				gtk_widget_set_opacity ((GtkWidget*) _tmp25_, 1.0);
				_tmp26_ = self->priv->size_indicator;
				gtk_widget_set_opacity ((GtkWidget*) _tmp26_, 1.0);
				_tmp27_ = self->priv->_size_indicator_delay;
				self->priv->size_indicator_timeout = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) _tmp27_, ______lambda18__gsource_func, g_object_ref (self), g_object_unref);
			}
			_g_string_free0 (size_label);
			_g_free0 (shortcut_hint);
			_g_free0 (keys);
			_g_object_unref0 (shortcut);
		}
		peek_recording_recording_area_destroy (&area);
	}
}

static void
peek_ui_application_window_update_ui_size (PeekUiApplicationWindow* self,
                                           PeekRecordingRecordingArea* area)
{
	PangoAttrList* attrs = NULL;
	PangoAttrList* _tmp0_;
	PeekRecordingRecordingArea _tmp1_;
	GtkLabel* _tmp10_;
	PangoAttrList* _tmp11_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (area != NULL);
	_tmp0_ = pango_attr_list_new ();
	attrs = _tmp0_;
	_tmp1_ = *area;
	if (_tmp1_.width < PEEK_UI_APPLICATION_WINDOW_SMALL_WINDOW_SIZE) {
		GtkButton* _tmp2_;
		GtkButton* _tmp3_;
		PangoAttrList* _tmp4_;
		PangoAttribute* _tmp5_;
		_tmp2_ = self->priv->record_button;
		peek_gtk_helper_hide_button_label (_tmp2_);
		_tmp3_ = self->priv->stop_button;
		peek_gtk_helper_hide_button_label (_tmp3_);
		_tmp4_ = attrs;
		_tmp5_ = pango_attr_scale_new (PANGO_SCALE_SMALL);
		pango_attr_list_insert (_tmp4_, _tmp5_);
	} else {
		GtkButton* _tmp6_;
		GtkButton* _tmp7_;
		PangoAttrList* _tmp8_;
		PangoAttribute* _tmp9_;
		_tmp6_ = self->priv->record_button;
		peek_gtk_helper_show_button_label (_tmp6_);
		_tmp7_ = self->priv->stop_button;
		peek_gtk_helper_show_button_label (_tmp7_);
		_tmp8_ = attrs;
		_tmp9_ = pango_attr_scale_new (PANGO_SCALE_LARGE);
		pango_attr_list_insert (_tmp8_, _tmp9_);
	}
	_tmp10_ = self->priv->shortcut_label;
	_tmp11_ = attrs;
	gtk_label_set_attributes (_tmp10_, _tmp11_);
	_pango_attr_list_unref0 (attrs);
}

static void
peek_ui_application_window_on_format_selection_toggled (PeekUiApplicationWindow* self)
{
	GtkRadioButton* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->gif_button;
	if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp0_)) {
		peek_ui_application_window_select_format (self, PEEK_OUTPUT_FORMAT_GIF);
	} else {
		GtkRadioButton* _tmp1_;
		_tmp1_ = self->priv->apng_button;
		if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp1_)) {
			peek_ui_application_window_select_format (self, PEEK_OUTPUT_FORMAT_APNG);
		} else {
			GtkRadioButton* _tmp2_;
			_tmp2_ = self->priv->webm_button;
			if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp2_)) {
				peek_ui_application_window_select_format (self, PEEK_OUTPUT_FORMAT_WEBM);
			} else {
				GtkRadioButton* _tmp3_;
				_tmp3_ = self->priv->mp4_button;
				if (gtk_toggle_button_get_active ((GtkToggleButton*) _tmp3_)) {
					peek_ui_application_window_select_format (self, PEEK_OUTPUT_FORMAT_MP4);
				}
			}
		}
	}
}

static void
_peek_ui_application_window_on_format_selection_toggled_gtk_toggle_button_toggled (GtkToggleButton* _sender,
                                                                                   gpointer self)
{
	peek_ui_application_window_on_format_selection_toggled ((PeekUiApplicationWindow*) self);
}

static void
peek_ui_application_window_on_record_button_clicked (PeekUiApplicationWindow* self,
                                                     GtkButton* source)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	peek_ui_application_window_prepare_start_recording (self);
}

static void
_peek_ui_application_window_on_record_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self)
{
	peek_ui_application_window_on_record_button_clicked ((PeekUiApplicationWindow*) self, _sender);
}

static void
peek_ui_application_window_on_stop_button_clicked (PeekUiApplicationWindow* self,
                                                   GtkButton* source)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	peek_ui_application_window_prepare_stop_recording (self);
}

static void
_peek_ui_application_window_on_stop_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self)
{
	peek_ui_application_window_on_stop_button_clicked ((PeekUiApplicationWindow*) self, _sender);
}

static void
peek_ui_application_window_on_new_window_button_clicked (PeekUiApplicationWindow* self,
                                                         GtkButton* source)
{
	GtkPopover* _tmp0_;
	GtkApplication* _tmp1_;
	GtkApplication* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->pop_menu;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	g_action_group_activate_action ((GActionGroup*) _tmp2_, "new-window", NULL);
}

static void
_peek_ui_application_window_on_new_window_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                             gpointer self)
{
	peek_ui_application_window_on_new_window_button_clicked ((PeekUiApplicationWindow*) self, _sender);
}

static void
peek_ui_application_window_on_set_window_size_button_clicked (PeekUiApplicationWindow* self,
                                                              GtkButton* source)
{
	GtkPopover* _tmp0_;
	GtkApplication* _tmp1_;
	GtkApplication* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->pop_menu;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	g_action_group_activate_action ((GActionGroup*) _tmp2_, "set-window-size", NULL);
}

static void
_peek_ui_application_window_on_set_window_size_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                                  gpointer self)
{
	peek_ui_application_window_on_set_window_size_button_clicked ((PeekUiApplicationWindow*) self, _sender);
}

static void
peek_ui_application_window_on_preferences_button_clicked (PeekUiApplicationWindow* self,
                                                          GtkButton* source)
{
	GtkPopover* _tmp0_;
	GtkWindow* _tmp1_;
	GtkWindow* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->pop_menu;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = peek_ui_preferences_dialog_present_single_instance ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
}

static void
_peek_ui_application_window_on_preferences_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self)
{
	peek_ui_application_window_on_preferences_button_clicked ((PeekUiApplicationWindow*) self, _sender);
}

static void
peek_ui_application_window_on_about_button_clicked (PeekUiApplicationWindow* self,
                                                    GtkButton* source)
{
	GtkPopover* _tmp0_;
	GtkDialog* _tmp1_;
	GtkDialog* _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = self->priv->pop_menu;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	_tmp1_ = peek_ui_about_dialog_present_single_instance ((GtkWindow*) self);
	_tmp2_ = _tmp1_;
	_g_object_unref0 (_tmp2_);
}

static void
_peek_ui_application_window_on_about_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                        gpointer self)
{
	peek_ui_application_window_on_about_button_clicked ((PeekUiApplicationWindow*) self, _sender);
}

static Block4Data*
block4_data_ref (Block4Data* _data4_)
{
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}

static void
block4_data_unref (void * _userdata_)
{
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		PeekUiApplicationWindow* self;
		self = _data4_->self;
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}

static Block5Data*
block5_data_ref (Block5Data* _data5_)
{
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}

static void
block5_data_unref (void * _userdata_)
{
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		PeekUiApplicationWindow* self;
		self = _data5_->_data4_->self;
		block4_data_unref (_data5_->_data4_);
		_data5_->_data4_ = NULL;
		g_slice_free (Block5Data, _data5_);
	}
}

static void
___lambda13_ (Block5Data* _data5_)
{
	Block4Data* _data4_;
	PeekUiApplicationWindow* self;
	GtkLabel* _tmp0_;
	GtkButton* _tmp1_;
	const gchar* _tmp2_;
	GtkLabel* _tmp3_;
	_data4_ = _data5_->_data4_;
	self = _data4_->self;
	_tmp0_ = self->priv->delay_indicator;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data5_->hide_handler);
	_tmp1_ = self->priv->stop_button;
	_tmp2_ = self->priv->stop_button_label;
	gtk_button_set_label (_tmp1_, _tmp2_);
	_tmp3_ = self->priv->delay_indicator;
	gtk_widget_queue_draw ((GtkWidget*) _tmp3_);
	peek_ui_application_window_start_recording (self);
}

static void
____lambda13__gtk_widget_hide (GtkWidget* _sender,
                               gpointer self)
{
	___lambda13_ (self);
}

static gboolean
___lambda12_ (Block4Data* _data4_)
{
	PeekUiApplicationWindow* self;
	gboolean result;
	self = _data4_->self;
	_data4_->delay -= 1;
	if (_data4_->delay == 0) {
		Block5Data* _data5_;
		GtkLabel* _tmp0_;
		gulong _tmp1_;
		GtkLabel* _tmp2_;
		_data5_ = g_slice_new0 (Block5Data);
		_data5_->_ref_count_ = 1;
		_data5_->_data4_ = block4_data_ref (_data4_);
		self->priv->delay_indicator_timeout = (guint) 0;
		_data5_->hide_handler = (gulong) 0;
		_tmp0_ = self->priv->delay_indicator;
		_tmp1_ = g_signal_connect_data ((GtkWidget*) _tmp0_, "hide", (GCallback) ____lambda13__gtk_widget_hide, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
		_data5_->hide_handler = _tmp1_;
		_tmp2_ = self->priv->delay_indicator;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
		result = FALSE;
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return result;
	} else {
		GtkLabel* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp3_ = self->priv->delay_indicator;
		_tmp4_ = g_strdup_printf ("%i", _data4_->delay);
		_tmp5_ = _tmp4_;
		gtk_label_set_text (_tmp3_, _tmp5_);
		_g_free0 (_tmp5_);
		result = TRUE;
		return result;
	}
}

static gboolean
____lambda12__gsource_func (gpointer self)
{
	gboolean result;
	result = ___lambda12_ (self);
	return result;
}

static void
peek_ui_application_window_prepare_start_recording (PeekUiApplicationWindow* self)
{
	Block4Data* _data4_;
	gint _tmp0_;
	g_return_if_fail (self != NULL);
	_data4_ = g_slice_new0 (Block4Data);
	_data4_->_ref_count_ = 1;
	_data4_->self = g_object_ref (self);
	if (self->priv->is_recording) {
		block4_data_unref (_data4_);
		_data4_ = NULL;
		return;
	}
	peek_ui_application_window_enter_recording_state (self);
	_tmp0_ = self->priv->_recording_start_delay;
	_data4_->delay = _tmp0_;
	if (_data4_->delay > 0) {
		GtkLabel* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		GtkLabel* _tmp4_;
		GtkLabel* _tmp5_;
		GtkLabel* _tmp6_;
		_tmp1_ = self->priv->delay_indicator;
		_tmp2_ = g_strdup_printf ("%i", _data4_->delay);
		_tmp3_ = _tmp2_;
		gtk_label_set_text (_tmp1_, _tmp3_);
		_g_free0 (_tmp3_);
		_tmp4_ = self->priv->delay_indicator;
		gtk_widget_show ((GtkWidget*) _tmp4_);
		_tmp5_ = self->priv->size_indicator;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
		_tmp6_ = self->priv->shortcut_label;
		gtk_widget_hide ((GtkWidget*) _tmp6_);
		self->priv->delay_indicator_timeout = g_timeout_add_seconds_full (G_PRIORITY_DEFAULT, (guint) 1, ____lambda12__gsource_func, block4_data_ref (_data4_), block4_data_unref);
	} else {
		peek_ui_application_window_start_recording (self);
	}
	block4_data_unref (_data4_);
	_data4_ = NULL;
}

static void
peek_ui_application_window_prepare_stop_recording (PeekUiApplicationWindow* self)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->is_recording) {
		return;
	}
	if (self->priv->delay_indicator_timeout != ((guint) 0)) {
		g_source_remove (self->priv->delay_indicator_timeout);
		self->priv->delay_indicator_timeout = (guint) 0;
		peek_ui_application_window_leave_recording_state (self);
	} else {
		if (self->priv->start_recording_event_source != ((guint) 0)) {
			g_source_remove (self->priv->start_recording_event_source);
			self->priv->start_recording_event_source = (guint) 0;
			peek_ui_application_window_leave_recording_state (self);
		} else {
			PeekRecordingScreenRecorder* _tmp0_;
			gboolean _tmp1_;
			gboolean _tmp2_;
			_tmp0_ = self->priv->_recorder;
			_tmp1_ = peek_recording_screen_recorder_get_is_recording (_tmp0_);
			_tmp2_ = _tmp1_;
			if (!_tmp2_) {
				return;
			} else {
				GtkButton* _tmp3_;
				PeekRecordingScreenRecorder* _tmp4_;
				_tmp3_ = self->priv->stop_button;
				gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, FALSE);
				peek_ui_application_window_show_spinner (self);
				_tmp4_ = self->priv->_recorder;
				peek_recording_screen_recorder_stop (_tmp4_);
			}
		}
	}
}

static void
peek_ui_application_window_show_spinner (PeekUiApplicationWindow* self)
{
	GtkBox* box = NULL;
	GtkBox* _tmp0_;
	GtkSpinner* spinner = NULL;
	GtkSpinner* _tmp1_;
	GtkSpinner* _tmp2_;
	GtkBox* _tmp3_;
	GtkSpinner* _tmp4_;
	GtkBox* _tmp8_;
	GtkHeaderBar* _tmp9_;
	GtkBox* _tmp10_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	box = _tmp0_;
	_tmp1_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp1_);
	spinner = _tmp1_;
	_tmp2_ = spinner;
	g_object_set (_tmp2_, "active", TRUE, NULL);
	_tmp3_ = box;
	_tmp4_ = spinner;
	gtk_box_pack_start (_tmp3_, (GtkWidget*) _tmp4_, FALSE, FALSE, (guint) 0);
	if (peek_ui_application_window_get_window_width (self) >= PEEK_UI_APPLICATION_WINDOW_SMALL_WINDOW_SIZE) {
		GtkLabel* label = NULL;
		GtkLabel* _tmp5_;
		GtkBox* _tmp6_;
		GtkLabel* _tmp7_;
		_tmp5_ = (GtkLabel*) gtk_label_new (_ ("Rendering…"));
		g_object_ref_sink (_tmp5_);
		label = _tmp5_;
		_tmp6_ = box;
		_tmp7_ = label;
		gtk_box_pack_start (_tmp6_, (GtkWidget*) _tmp7_, FALSE, FALSE, (guint) 0);
		_g_object_unref0 (label);
	}
	_tmp8_ = box;
	gtk_widget_show_all ((GtkWidget*) _tmp8_);
	_tmp9_ = self->priv->headerbar;
	_tmp10_ = box;
	gtk_header_bar_set_custom_title (_tmp9_, (GtkWidget*) _tmp10_);
	_g_object_unref0 (spinner);
	_g_object_unref0 (box);
}

static void
peek_ui_application_window_hide_spinner (PeekUiApplicationWindow* self)
{
	GtkHeaderBar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	gtk_header_bar_set_custom_title (_tmp0_, NULL);
}

static void
peek_ui_application_window_toggle_recording (PeekUiApplicationWindow* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->is_recording) {
		peek_ui_application_window_prepare_stop_recording (self);
	} else {
		peek_ui_application_window_prepare_start_recording (self);
	}
}

static gboolean
__lambda14_ (PeekUiApplicationWindow* self)
{
	PeekRecordingRecordingArea area = {0};
	PeekRecordingRecordingArea _tmp0_ = {0};
	PeekRecordingRecordingArea _tmp1_;
	PeekRecordingRecordingArea _tmp2_;
	PeekRecordingRecordingArea _tmp3_;
	PeekRecordingRecordingArea _tmp4_;
	PeekRecordingRecordingArea _tmp5_;
	PeekRecordingRecordingArea _tmp6_;
	PeekRecordingRecordingArea _tmp7_ = {0};
	gboolean _tmp17_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	g_source_remove (self->priv->start_recording_event_source);
	self->priv->start_recording_event_source = (guint) 0;
	peek_ui_application_window_update_time (self);
	peek_ui_application_window_get_recording_area (self, &_tmp0_);
	area = _tmp0_;
	_tmp1_ = area;
	_tmp2_ = area;
	_tmp3_ = area;
	_tmp4_ = area;
	g_debug ("application-window.vala:581: Recording area: %i, %i, %i, %i\n", _tmp1_.left, _tmp2_.top, _tmp3_.width, _tmp4_.height);
	_tmp5_ = area;
	_tmp6_ = _tmp5_;
	peek_recording_recording_area_copy (&_tmp6_, &_tmp7_);
	peek_recording_recording_area_destroy (&self->priv->active_recording_area);
	self->priv->active_recording_area = _tmp7_;
	{
		PeekRecordingScreenRecorder* _tmp8_;
		PeekRecordingRecordingArea _tmp9_;
		_tmp8_ = self->priv->_recorder;
		_tmp9_ = area;
		peek_recording_screen_recorder_record (_tmp8_, &_tmp9_, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gboolean _tmp10_ = FALSE;
			if (_inner_error0_->domain == PEEK_RECORDING_ERROR) {
				goto __catch0_peek_recording_error;
			}
			peek_recording_recording_area_destroy (&area);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp10_;
		}
		result = TRUE;
		peek_recording_recording_area_destroy (&area);
		return result;
	}
	goto __finally0;
	__catch0_peek_recording_error:
	{
		GError* e = NULL;
		FILE* _tmp11_;
		GError* _tmp12_;
		const gchar* _tmp13_;
		GError* _tmp14_;
		GtkDialog* _tmp15_;
		GtkDialog* _tmp16_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp11_ = stderr;
		_tmp12_ = e;
		_tmp13_ = _tmp12_->message;
		fprintf (_tmp11_, "Failed to initialize recorder: %s\n", _tmp13_);
		peek_ui_application_window_leave_recording_state (self);
		_tmp14_ = e;
		_tmp15_ = peek_ui_error_dialog_present_single_instance ((GtkWindow*) self, _ ("Recording could not be started due to an unexpected error."), _tmp14_);
		_tmp16_ = _tmp15_;
		_g_object_unref0 (_tmp16_);
		result = FALSE;
		_g_error_free0 (e);
		peek_recording_recording_area_destroy (&area);
		return result;
	}
	__finally0:
	peek_recording_recording_area_destroy (&area);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp17_;
}

static gboolean
___lambda14__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda14_ ((PeekUiApplicationWindow*) self);
	return result;
}

static void
peek_ui_application_window_start_recording (PeekUiApplicationWindow* self)
{
	g_return_if_fail (self != NULL);
	self->priv->start_recording_event_source = g_idle_add_full (G_PRIORITY_HIGH_IDLE, ___lambda14__gsource_func, g_object_ref (self), g_object_unref);
}

static void
peek_ui_application_window_enter_recording_state (PeekUiApplicationWindow* self)
{
	g_return_if_fail (self != NULL);
	if (!self->priv->is_recording) {
		GtkLabel* _tmp0_;
		GtkLabel* _tmp1_;
		GtkMenuButton* _tmp2_;
		GtkButton* _tmp3_;
		GtkToggleButton* _tmp4_;
		GtkButton* _tmp7_;
		GtkButton* _tmp8_;
		self->priv->is_recording = TRUE;
		_tmp0_ = self->priv->size_indicator;
		gtk_widget_set_opacity ((GtkWidget*) _tmp0_, 0.0);
		_tmp1_ = self->priv->shortcut_label;
		gtk_widget_set_opacity ((GtkWidget*) _tmp1_, 0.0);
		_tmp2_ = self->priv->pop_format_menu;
		gtk_widget_hide ((GtkWidget*) _tmp2_);
		_tmp3_ = self->priv->record_button;
		gtk_widget_hide ((GtkWidget*) _tmp3_);
		_tmp4_ = self->priv->pop_menu_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, FALSE);
		if (peek_ui_application_window_get_window_width (self) >= PEEK_UI_APPLICATION_WINDOW_SMALL_WINDOW_SIZE) {
			GtkButton* _tmp5_;
			const gchar* _tmp6_;
			_tmp5_ = self->priv->stop_button;
			_tmp6_ = self->priv->stop_button_label;
			gtk_button_set_label (_tmp5_, _tmp6_);
		}
		_tmp7_ = self->priv->stop_button;
		gtk_widget_set_sensitive ((GtkWidget*) _tmp7_, TRUE);
		_tmp8_ = self->priv->stop_button;
		gtk_widget_show ((GtkWidget*) _tmp8_);
		peek_ui_set_window_size_dialog_close_instance ();
		peek_ui_application_window_freeze_window_size (self);
		gtk_window_set_keep_above ((GtkWindow*) self, TRUE);
	}
}

static void
___lambda9_ (PeekUiApplicationWindow* self,
             GObject* obj,
             GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		gboolean delete_success = FALSE;
		GFile* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp0_ = self->priv->in_file;
		delete_success = g_file_delete_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = bool_to_string (delete_success);
		_tmp2_ = _tmp1_;
		g_debug ("application-window.vala:637: Temp file deleted: %s\n", _tmp2_);
		_g_free0 (_tmp2_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp3_;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = stderr;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		fprintf (_tmp3_, "Temp file delete error: %s\n", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		_g_object_unref0 (self->priv->in_file);
		self->priv->in_file = NULL;
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	g_signal_emit (self, peek_ui_application_window_signals[PEEK_UI_APPLICATION_WINDOW_RECORDING_FINISHED_SIGNAL], 0);
}

static void
____lambda9__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	___lambda9_ ((PeekUiApplicationWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
peek_ui_application_window_leave_recording_state (PeekUiApplicationWindow* self)
{
	GtkLabel* _tmp0_;
	GtkButton* _tmp1_;
	GtkMenuButton* _tmp2_;
	GtkButton* _tmp3_;
	GtkToggleButton* _tmp4_;
	GFile* _tmp5_;
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->out_file);
	self->priv->out_file = NULL;
	_tmp0_ = self->priv->delay_indicator;
	gtk_widget_hide ((GtkWidget*) _tmp0_);
	self->priv->is_recording = FALSE;
	self->priv->is_postprocessing = FALSE;
	_tmp1_ = self->priv->stop_button;
	gtk_widget_hide ((GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->pop_format_menu;
	gtk_widget_show ((GtkWidget*) _tmp2_);
	_tmp3_ = self->priv->record_button;
	gtk_widget_show ((GtkWidget*) _tmp3_);
	_tmp4_ = self->priv->pop_menu_button;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
	peek_ui_application_window_unfreeze_window_size (self);
	peek_ui_application_window_hide_spinner (self);
	_tmp5_ = self->priv->in_file;
	if (_tmp5_ != NULL) {
		GFile* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GFile* _tmp9_;
		_tmp6_ = self->priv->in_file;
		_tmp7_ = g_file_get_uri (_tmp6_);
		_tmp8_ = _tmp7_;
		g_debug ("application-window.vala:633: Deleting temp file %s\n", _tmp8_);
		_g_free0 (_tmp8_);
		_tmp9_ = self->priv->in_file;
		g_file_delete_async (_tmp9_, G_PRIORITY_DEFAULT, NULL, ____lambda9__gasync_ready_callback, g_object_ref (self));
	} else {
		g_signal_emit (self, peek_ui_application_window_signals[PEEK_UI_APPLICATION_WINDOW_RECORDING_FINISHED_SIGNAL], 0);
	}
}

static void
peek_ui_application_window_update_input_shape (PeekUiApplicationWindow* self)
{
	cairo_region_t* window_region = NULL;
	GtkWidget* _tmp0_;
	GtkWidget* _tmp1_;
	cairo_region_t* _tmp2_;
	cairo_region_t* recording_view_region = NULL;
	GtkWidget* _tmp3_;
	cairo_region_t* _tmp4_;
	cairo_region_t* _tmp5_;
	cairo_region_t* _tmp6_;
	GtkPopover* _tmp7_;
	gboolean _tmp8_;
	gboolean _tmp9_;
	GtkPopover* _tmp14_;
	gboolean _tmp15_;
	gboolean _tmp16_;
	cairo_region_t* _tmp21_;
	GdkScreen* _tmp22_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->recording_view;
	_tmp1_ = gtk_widget_get_toplevel (_tmp0_);
	_tmp2_ = peek_gtk_helper_create_region_from_widget (_tmp1_);
	window_region = _tmp2_;
	_tmp3_ = self->priv->recording_view;
	_tmp4_ = peek_gtk_helper_create_region_from_widget (_tmp3_);
	recording_view_region = _tmp4_;
	_tmp5_ = window_region;
	_tmp6_ = recording_view_region;
	cairo_region_subtract (_tmp5_, _tmp6_);
	_tmp7_ = self->priv->pop_format;
	_tmp8_ = gtk_widget_get_visible ((GtkWidget*) _tmp7_);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		cairo_region_t* pop_format_region = NULL;
		GtkPopover* _tmp10_;
		cairo_region_t* _tmp11_;
		cairo_region_t* _tmp12_;
		cairo_region_t* _tmp13_;
		_tmp10_ = self->priv->pop_format;
		_tmp11_ = peek_gtk_helper_create_region_from_widget ((GtkWidget*) _tmp10_);
		pop_format_region = _tmp11_;
		_tmp12_ = window_region;
		_tmp13_ = pop_format_region;
		cairo_region_union (_tmp12_, _tmp13_);
		_cairo_region_destroy0 (pop_format_region);
	}
	_tmp14_ = self->priv->pop_menu;
	_tmp15_ = gtk_widget_get_visible ((GtkWidget*) _tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		cairo_region_t* pop_menu_region = NULL;
		GtkPopover* _tmp17_;
		cairo_region_t* _tmp18_;
		cairo_region_t* _tmp19_;
		cairo_region_t* _tmp20_;
		_tmp17_ = self->priv->pop_menu;
		_tmp18_ = peek_gtk_helper_create_region_from_widget ((GtkWidget*) _tmp17_);
		pop_menu_region = _tmp18_;
		_tmp19_ = window_region;
		_tmp20_ = pop_menu_region;
		cairo_region_union (_tmp19_, _tmp20_);
		_cairo_region_destroy0 (pop_menu_region);
	}
	_tmp21_ = window_region;
	gtk_widget_input_shape_combine_region ((GtkWidget*) self, _tmp21_);
	_tmp22_ = gtk_window_get_screen ((GtkWindow*) self);
	if (!gdk_screen_is_composited (_tmp22_)) {
		gboolean _tmp23_ = FALSE;
		if (self->priv->delay_indicator_timeout == ((guint) 0)) {
			_tmp23_ = self->priv->size_indicator_timeout == ((guint) 0);
		} else {
			_tmp23_ = FALSE;
		}
		if (_tmp23_) {
			cairo_region_t* _tmp24_;
			_tmp24_ = window_region;
			gtk_widget_shape_combine_region ((GtkWidget*) self, _tmp24_);
		} else {
			gtk_widget_shape_combine_region ((GtkWidget*) self, NULL);
		}
	}
	_cairo_region_destroy0 (recording_view_region);
	_cairo_region_destroy0 (window_region);
}

static void
peek_ui_application_window_freeze_window_size (PeekUiApplicationWindow* self)
{
	gint width = 0;
	gint height = 0;
	g_return_if_fail (self != NULL);
	if (peek_desktop_integration_is_xfce ()) {
		g_debug ("application-window.vala:684: Window size freezing disabled on Xfce");
		return;
	}
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	g_debug ("application-window.vala:690: freeze_window_size w: %d, h: %d", width, height);
	gtk_widget_set_size_request ((GtkWidget*) self, width, height);
	gtk_window_set_resizable ((GtkWindow*) self, FALSE);
}

static void
peek_ui_application_window_unfreeze_window_size (PeekUiApplicationWindow* self)
{
	gint width = 0;
	gint height = 0;
	g_return_if_fail (self != NULL);
	if (peek_desktop_integration_is_xfce ()) {
		g_debug ("application-window.vala:698: Window size freezing disabled on Xfce");
		return;
	}
	width = gtk_widget_get_allocated_width ((GtkWidget*) self);
	height = gtk_widget_get_allocated_height ((GtkWidget*) self);
	g_debug ("application-window.vala:704: unfreeze_window_size w: %d, h: %d", width, height);
	gtk_widget_set_size_request ((GtkWidget*) self, 0, 0);
	gtk_window_set_default_size ((GtkWindow*) self, width, height);
	gtk_window_set_resizable ((GtkWindow*) self, TRUE);
}

static void
peek_ui_application_window_show_file_chooser (PeekUiApplicationWindow* self)
{
	GtkFileChooserDialog* chooser = NULL;
	GtkFileChooserDialog* _tmp0_;
	GtkWidget* ok_button = NULL;
	GtkFileChooserDialog* _tmp1_;
	GtkWidget* _tmp2_;
	GtkWidget* _tmp3_;
	GtkWidget* _tmp4_;
	GtkStyleContext* _tmp5_;
	GtkFileChooserDialog* _tmp6_;
	gchar* extension = NULL;
	PeekRecordingScreenRecorder* _tmp7_;
	PeekRecordingRecordingConfig* _tmp8_;
	PeekRecordingRecordingConfig* _tmp9_;
	PeekOutputFormat _tmp10_;
	PeekOutputFormat _tmp11_;
	gchar* _tmp12_;
	gchar* filename = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	GtkFileFilter* filter = NULL;
	GtkFileFilter* _tmp19_;
	GtkFileFilter* _tmp20_;
	const gchar* _tmp21_;
	gchar* _tmp22_;
	gchar* _tmp23_;
	GtkFileChooserDialog* _tmp24_;
	GtkFileFilter* _tmp25_;
	gchar* folder = NULL;
	gchar* _tmp26_;
	GtkFileChooserDialog* _tmp27_;
	const gchar* _tmp28_;
	GDateTime* now = NULL;
	GDateTime* _tmp29_;
	gchar* default_name = NULL;
	GDateTime* _tmp30_;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	GtkFileChooserDialog* _tmp33_;
	const gchar* _tmp34_;
	GtkFileChooserDialog* _tmp35_;
	const gchar* _tmp36_;
	GtkFileChooserDialog* _tmp37_;
	GtkFileChooserDialog* _tmp44_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkFileChooserDialog*) gtk_file_chooser_dialog_new (_ ("Save animation"), (GtkWindow*) self, GTK_FILE_CHOOSER_ACTION_SAVE, _ ("_Cancel"), GTK_RESPONSE_CANCEL, NULL);
	g_object_ref_sink (_tmp0_);
	chooser = _tmp0_;
	_tmp1_ = chooser;
	_tmp2_ = gtk_dialog_add_button ((GtkDialog*) _tmp1_, _ ("_Save"), (gint) GTK_RESPONSE_ACCEPT);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	ok_button = _tmp3_;
	_tmp4_ = ok_button;
	_tmp5_ = gtk_widget_get_style_context (_tmp4_);
	gtk_style_context_add_class (_tmp5_, "suggested-action");
	_tmp6_ = chooser;
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) _tmp6_, TRUE);
	_tmp7_ = self->priv->_recorder;
	_tmp8_ = peek_recording_screen_recorder_get_config (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = peek_recording_recording_config_get_output_format (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = peek_utils_get_file_extension_for_format (_tmp11_);
	extension = _tmp12_;
	_tmp13_ = self->priv->_default_file_name_format;
	_tmp14_ = g_strconcat (_tmp13_, ".", NULL);
	_tmp15_ = _tmp14_;
	_tmp16_ = extension;
	_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
	_tmp18_ = _tmp17_;
	_g_free0 (_tmp15_);
	filename = _tmp18_;
	_tmp19_ = gtk_file_filter_new ();
	g_object_ref_sink (_tmp19_);
	filter = _tmp19_;
	_tmp20_ = filter;
	_tmp21_ = extension;
	_tmp22_ = g_strconcat ("*.", _tmp21_, NULL);
	_tmp23_ = _tmp22_;
	gtk_file_filter_add_pattern (_tmp20_, _tmp23_);
	_g_free0 (_tmp23_);
	_tmp24_ = chooser;
	_tmp25_ = filter;
	gtk_file_chooser_set_filter ((GtkFileChooser*) _tmp24_, _tmp25_);
	_tmp26_ = peek_ui_application_window_load_preferred_save_folder (self);
	folder = _tmp26_;
	_tmp27_ = chooser;
	_tmp28_ = folder;
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) _tmp27_, _tmp28_);
	_tmp29_ = g_date_time_new_now_local ();
	now = _tmp29_;
	_tmp30_ = now;
	_tmp31_ = filename;
	_tmp32_ = g_date_time_format (_tmp30_, _tmp31_);
	default_name = _tmp32_;
	_tmp33_ = chooser;
	_tmp34_ = default_name;
	gtk_file_chooser_set_current_name ((GtkFileChooser*) _tmp33_, _tmp34_);
	_tmp35_ = chooser;
	_tmp36_ = g_type_name (G_TYPE_FROM_INSTANCE ((GObject*) _tmp35_));
	g_debug ("application-window.vala:742: Showing file chooser (%s)", _tmp36_);
	_tmp37_ = chooser;
	if (gtk_dialog_run ((GtkDialog*) _tmp37_) == ((gint) GTK_RESPONSE_ACCEPT)) {
		GtkFileChooserDialog* _tmp38_;
		gchar* _tmp39_;
		gchar* _tmp40_;
		GtkFileChooserDialog* _tmp41_;
		GFile* _tmp42_;
		_tmp38_ = chooser;
		_tmp39_ = gtk_file_chooser_get_uri ((GtkFileChooser*) _tmp38_);
		_tmp40_ = _tmp39_;
		g_debug ("application-window.vala:744: Selected file %s", _tmp40_);
		_g_free0 (_tmp40_);
		_tmp41_ = chooser;
		_tmp42_ = gtk_file_chooser_get_file ((GtkFileChooser*) _tmp41_);
		_g_object_unref0 (self->priv->out_file);
		self->priv->out_file = _tmp42_;
		peek_ui_application_window_try_save_file (self);
	} else {
		PeekRecordingScreenRecorder* _tmp43_;
		_tmp43_ = self->priv->_recorder;
		peek_recording_screen_recorder_cancel (_tmp43_);
		peek_ui_application_window_leave_recording_state (self);
	}
	_tmp44_ = chooser;
	g_signal_emit_by_name ((GtkDialog*) _tmp44_, "close");
	_g_free0 (default_name);
	_g_date_time_unref0 (now);
	_g_free0 (folder);
	_g_object_unref0 (filter);
	_g_free0 (filename);
	_g_free0 (extension);
	_g_object_unref0 (ok_button);
	_g_object_unref0 (chooser);
}

static void
peek_ui_application_window_try_save_file (PeekUiApplicationWindow* self)
{
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->in_file;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GFile* _tmp2_;
		_tmp2_ = self->priv->out_file;
		_tmp0_ = _tmp2_ == NULL;
	}
	if (_tmp0_) {
		return;
	}
	peek_ui_application_window_save_file (self);
}

static void
__lambda7_ (PeekUiApplicationWindow* self,
            GObject* obj,
            GAsyncResult* res)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (res != NULL);
	{
		gboolean copy_success = FALSE;
		GFile* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		_tmp0_ = self->priv->in_file;
		copy_success = g_file_copy_finish (_tmp0_, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = bool_to_string (copy_success);
		_tmp2_ = _tmp1_;
		_tmp3_ = self->priv->out_file;
		_tmp4_ = g_file_get_uri (_tmp3_);
		_tmp5_ = _tmp4_;
		g_debug ("application-window.vala:771: File saved %s: %s", _tmp2_, _tmp5_);
		_g_free0 (_tmp5_);
		_g_free0 (_tmp2_);
		if (copy_success) {
			GFile* _tmp6_;
			_tmp6_ = self->priv->out_file;
			peek_ui_application_window_handle_saved_file (self, _tmp6_);
		} else {
			gchar* message = NULL;
			GFile* _tmp7_;
			gchar* _tmp8_;
			gchar* _tmp9_;
			gchar* _tmp10_;
			gchar* _tmp11_;
			FILE* _tmp12_;
			const gchar* _tmp13_;
			const gchar* _tmp14_;
			GError* _tmp15_;
			_tmp7_ = self->priv->out_file;
			_tmp8_ = g_file_get_uri (_tmp7_);
			_tmp9_ = _tmp8_;
			_tmp10_ = g_strdup_printf ("Saving file %s failed.", _tmp9_);
			_tmp11_ = _tmp10_;
			_g_free0 (_tmp9_);
			message = _tmp11_;
			_tmp12_ = stderr;
			_tmp13_ = message;
			fprintf (_tmp12_, "%s\n", _tmp13_);
			_tmp14_ = message;
			_tmp15_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_FAILED, _tmp14_);
			_inner_error0_ = _tmp15_;
			_g_free0 (message);
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp16_;
		GError* _tmp17_;
		const gchar* _tmp18_;
		GError* _tmp19_;
		GtkDialog* _tmp20_;
		GtkDialog* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp16_ = stderr;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		fprintf (_tmp16_, "File save error: %s\n", _tmp18_);
		_tmp19_ = e;
		_tmp20_ = peek_ui_error_dialog_present_single_instance ((GtkWindow*) self, _ ("The file could not be saved to the selected location."), _tmp19_);
		_tmp21_ = _tmp20_;
		_g_object_unref0 (_tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	{
		GError* _inner_error1_ = NULL;
		peek_ui_application_window_leave_recording_state (self);
	}
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda7__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda7_ ((PeekUiApplicationWindow*) self, source_object, res);
	g_object_unref (self);
}

static void
peek_ui_application_window_save_file (PeekUiApplicationWindow* self)
{
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->in_file;
	_tmp1_ = self->priv->out_file;
	g_file_copy_async (_tmp0_, _tmp1_, G_FILE_COPY_OVERWRITE, G_PRIORITY_DEFAULT, NULL, NULL, NULL, ___lambda7__gasync_ready_callback, g_object_ref (self));
}

static void
peek_ui_application_window_handle_saved_file (PeekUiApplicationWindow* self,
                                              GFile* file)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	peek_ui_application_window_save_preferred_save_folder (self, file);
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->_open_file_manager;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		peek_desktop_integration_launch_file_manager (file);
	} else {
		peek_ui_application_window_show_file_saved_notification (self, file);
	}
}

static void
peek_ui_application_window_show_file_saved_notification (PeekUiApplicationWindow* self,
                                                         GFile* file)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
	gboolean _tmp2_;
	GString* message = NULL;
	GString* _tmp4_;
	GString* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	GNotification* notification = NULL;
	GString* _tmp8_;
	const gchar* _tmp9_;
	GNotification* _tmp10_;
	GVariant* parameter = NULL;
	gchar* _tmp11_;
	gchar* _tmp12_;
	GVariant* _tmp13_;
	GVariant* _tmp14_;
	GString* _tmp21_;
	const gchar* _tmp22_;
	GtkApplication* _tmp23_;
	GtkApplication* _tmp24_;
	GNotification* _tmp25_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (file != NULL);
	_tmp1_ = gtk_widget_get_visible ((GtkWidget*) self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		gboolean _tmp3_;
		_tmp3_ = self->priv->_show_notification;
		_tmp0_ = !_tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp4_ = g_string_new ("");
	message = _tmp4_;
	_tmp5_ = message;
	_tmp6_ = g_file_get_basename (file);
	_tmp7_ = _tmp6_;
	g_string_printf (_tmp5_, _ ("Animation saved as “%s”"), _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = message;
	_tmp9_ = _tmp8_->str;
	_tmp10_ = peek_ui_application_window_build_standard_notification (_tmp9_);
	notification = _tmp10_;
	_tmp11_ = g_file_get_uri (file);
	_tmp12_ = _tmp11_;
	_tmp13_ = g_variant_new_string (_tmp12_);
	g_variant_ref_sink (_tmp13_);
	_tmp14_ = _tmp13_;
	_g_free0 (_tmp12_);
	parameter = _tmp14_;
	if (!peek_desktop_integration_is_unity ()) {
		GNotification* _tmp15_;
		GNotification* _tmp16_;
		GVariant* _tmp17_;
		gboolean _tmp18_ = FALSE;
		_tmp15_ = notification;
		g_notification_set_body (_tmp15_, _ ("Click here to show the saved file in your file manager."));
		_tmp16_ = notification;
		_tmp17_ = parameter;
		g_notification_add_button_with_target_value (_tmp16_, _ ("Show in file manager"), "app.show-file", _tmp17_);
		if (!peek_desktop_integration_is_plasma ()) {
			_tmp18_ = !peek_desktop_integration_is_xfce ();
		} else {
			_tmp18_ = FALSE;
		}
		if (_tmp18_) {
			GNotification* _tmp19_;
			GVariant* _tmp20_;
			_tmp19_ = notification;
			_tmp20_ = parameter;
			g_notification_set_default_action_and_target_value (_tmp19_, "app.show-file", _tmp20_);
		}
	}
	_tmp21_ = message;
	_tmp22_ = _tmp21_->str;
	g_debug ("application-window.vala:839: Showing desktop notification: %s", _tmp22_);
	_tmp23_ = gtk_window_get_application ((GtkWindow*) self);
	_tmp24_ = _tmp23_;
	_tmp25_ = notification;
	g_application_send_notification ((GApplication*) _tmp24_, "peek-file-saved", _tmp25_);
	_g_variant_unref0 (parameter);
	_g_object_unref0 (notification);
	_g_string_free0 (message);
}

static GNotification*
peek_ui_application_window_build_standard_notification (const gchar* message)
{
	GNotification* notification = NULL;
	GNotification* _tmp0_;
	GNotification* result;
	g_return_val_if_fail (message != NULL, NULL);
	_tmp0_ = g_notification_new (message);
	notification = _tmp0_;
	if (!peek_desktop_integration_is_cinnamon ()) {
		GNotification* _tmp1_;
		GThemedIcon* _tmp2_;
		GThemedIcon* _tmp3_;
		_tmp1_ = notification;
		_tmp2_ = (GThemedIcon*) g_themed_icon_new (PEEK_APP_ID);
		_tmp3_ = _tmp2_;
		g_notification_set_icon (_tmp1_, (GIcon*) _tmp3_);
		_g_object_unref0 (_tmp3_);
	} else {
		GtkIconTheme* icon_theme = NULL;
		GtkIconTheme* _tmp4_;
		GtkIconTheme* _tmp5_;
		GtkIconInfo* icon_info = NULL;
		GtkIconTheme* _tmp6_;
		GtkIconInfo* _tmp7_;
		gchar* icon_path = NULL;
		GtkIconInfo* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		_tmp4_ = gtk_icon_theme_get_default ();
		_tmp5_ = _g_object_ref0 (_tmp4_);
		icon_theme = _tmp5_;
		_tmp6_ = icon_theme;
		_tmp7_ = gtk_icon_theme_lookup_icon (_tmp6_, PEEK_APP_ID, 48, 0);
		icon_info = _tmp7_;
		_tmp8_ = icon_info;
		_tmp9_ = gtk_icon_info_get_filename (_tmp8_);
		_tmp10_ = g_strdup (_tmp9_);
		icon_path = _tmp10_;
		_tmp11_ = icon_path;
		g_debug ("application-window.vala:852: Using notification icon: %s", _tmp11_);
		_tmp12_ = icon_path;
		if (_tmp12_ != NULL) {
			GFileIcon* icon = NULL;
			const gchar* _tmp13_;
			GFile* _tmp14_;
			GFile* _tmp15_;
			GFileIcon* _tmp16_;
			GFileIcon* _tmp17_;
			GNotification* _tmp18_;
			GFileIcon* _tmp19_;
			_tmp13_ = icon_path;
			_tmp14_ = g_file_new_for_path (_tmp13_);
			_tmp15_ = _tmp14_;
			_tmp16_ = (GFileIcon*) g_file_icon_new (_tmp15_);
			_tmp17_ = _tmp16_;
			_g_object_unref0 (_tmp15_);
			icon = _tmp17_;
			_tmp18_ = notification;
			_tmp19_ = icon;
			g_notification_set_icon (_tmp18_, (GIcon*) _tmp19_);
			_g_object_unref0 (icon);
		}
		_g_free0 (icon_path);
		_g_object_unref0 (icon_info);
		_g_object_unref0 (icon_theme);
	}
	result = notification;
	return result;
}

static gchar*
peek_ui_application_window_load_preferred_save_folder (PeekUiApplicationWindow* self)
{
	gchar* folder = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_save_folder;
	_tmp1_ = g_strdup (_tmp0_);
	folder = _tmp1_;
	_tmp4_ = folder;
	if (_tmp4_ == NULL) {
		_tmp3_ = TRUE;
	} else {
		const gchar* _tmp5_;
		_tmp5_ = folder;
		_tmp3_ = g_strcmp0 (_tmp5_, "") == 0;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = folder;
		_tmp2_ = !g_file_test (_tmp6_, G_FILE_TEST_IS_DIR);
	}
	if (_tmp2_) {
		gchar* _tmp7_;
		_tmp7_ = peek_desktop_integration_get_video_folder ();
		_g_free0 (folder);
		folder = _tmp7_;
	}
	result = folder;
	return result;
}

static void
peek_ui_application_window_save_preferred_save_folder (PeekUiApplicationWindow* self,
                                                       GFile* out_file)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (out_file != NULL);
	if (g_file_has_uri_scheme (out_file, "file")) {
		GFile* parent = NULL;
		GFile* _tmp0_;
		gchar* new_folder = NULL;
		GFile* _tmp1_;
		gchar* _tmp2_;
		gchar* default_folder = NULL;
		gchar* _tmp3_;
		const gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp0_ = g_file_get_parent (out_file);
		parent = _tmp0_;
		_tmp1_ = parent;
		_tmp2_ = g_file_get_path (_tmp1_);
		new_folder = _tmp2_;
		_tmp3_ = peek_desktop_integration_get_video_folder ();
		default_folder = _tmp3_;
		_tmp4_ = new_folder;
		_tmp5_ = default_folder;
		if (g_strcmp0 (_tmp4_, _tmp5_) != 0) {
			const gchar* _tmp6_;
			_tmp6_ = new_folder;
			peek_ui_application_window_set_save_folder (self, _tmp6_);
		}
		_g_free0 (default_folder);
		_g_free0 (new_folder);
		_g_object_unref0 (parent);
	}
}

static void
peek_ui_application_window_load_geometry (PeekUiApplicationWindow* self)
{
	GVariant* geom = NULL;
	GSettings* _tmp0_;
	GVariant* _tmp1_;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	GVariant* _tmp2_;
	GVariant* _tmp3_;
	GVariant* _tmp4_;
	GVariant* _tmp5_;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_value (_tmp0_, "persist-window-geometry");
	geom = _tmp1_;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	_tmp2_ = geom;
	_tmp3_ = g_variant_get_child_value (_tmp2_, (gsize) 0);
	_tmp4_ = _tmp3_;
	x = (gint) g_variant_get_int32 (_tmp4_);
	_g_variant_unref0 (_tmp4_);
	_tmp5_ = geom;
	_tmp6_ = g_variant_get_child_value (_tmp5_, (gsize) 1);
	_tmp7_ = _tmp6_;
	y = (gint) g_variant_get_int32 (_tmp7_);
	_g_variant_unref0 (_tmp7_);
	_tmp8_ = geom;
	_tmp9_ = g_variant_get_child_value (_tmp8_, (gsize) 2);
	_tmp10_ = _tmp9_;
	w = (gint) g_variant_get_int32 (_tmp10_);
	_g_variant_unref0 (_tmp10_);
	_tmp11_ = geom;
	_tmp12_ = g_variant_get_child_value (_tmp11_, (gsize) 3);
	_tmp13_ = _tmp12_;
	h = (gint) g_variant_get_int32 (_tmp13_);
	_g_variant_unref0 (_tmp13_);
	if (w == 0) {
		_tmp14_ = TRUE;
	} else {
		_tmp14_ = h == 0;
	}
	if (_tmp14_) {
		_g_variant_unref0 (geom);
		return;
	}
	if (x >= 0) {
		_tmp15_ = y >= 0;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		gtk_window_move ((GtkWindow*) self, x, y);
	}
	gtk_window_resize ((GtkWindow*) self, w, h);
	_g_variant_unref0 (geom);
}

static void
peek_ui_application_window_save_geometry (PeekUiApplicationWindow* self)
{
	GVariantBuilder* builder = NULL;
	const GVariantType* _tmp0_;
	GVariantBuilder* _tmp1_;
	gint x = 0;
	gint y = 0;
	gint w = 0;
	gint h = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GVariant* _tmp6_;
	GVariant* _tmp7_;
	GVariant* _tmp8_;
	GVariant* _tmp9_;
	GVariant* _tmp10_;
	GVariant* _tmp11_;
	GVariant* _tmp12_;
	GVariant* _tmp13_;
	GSettings* _tmp14_;
	GVariant* _tmp15_;
	GVariant* _tmp16_;
	g_return_if_fail (self != NULL);
	_tmp0_ = G_VARIANT_TYPE_TUPLE;
	_tmp1_ = g_variant_builder_new (_tmp0_);
	builder = _tmp1_;
	x = 0;
	y = 0;
	w = 0;
	h = 0;
	gtk_window_get_position ((GtkWindow*) self, &_tmp2_, &_tmp3_);
	x = _tmp2_;
	y = _tmp3_;
	gtk_window_get_size ((GtkWindow*) self, &_tmp4_, &_tmp5_);
	w = _tmp4_;
	h = _tmp5_;
	_tmp6_ = g_variant_new_int32 ((gint32) x);
	g_variant_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	g_variant_builder_add_value (builder, _tmp7_);
	_g_variant_unref0 (_tmp7_);
	_tmp8_ = g_variant_new_int32 ((gint32) y);
	g_variant_ref_sink (_tmp8_);
	_tmp9_ = _tmp8_;
	g_variant_builder_add_value (builder, _tmp9_);
	_g_variant_unref0 (_tmp9_);
	_tmp10_ = g_variant_new_int32 ((gint32) w);
	g_variant_ref_sink (_tmp10_);
	_tmp11_ = _tmp10_;
	g_variant_builder_add_value (builder, _tmp11_);
	_g_variant_unref0 (_tmp11_);
	_tmp12_ = g_variant_new_int32 ((gint32) h);
	g_variant_ref_sink (_tmp12_);
	_tmp13_ = _tmp12_;
	g_variant_builder_add_value (builder, _tmp13_);
	_g_variant_unref0 (_tmp13_);
	_tmp14_ = self->priv->settings;
	_tmp15_ = g_variant_builder_end (builder);
	g_variant_ref_sink (_tmp15_);
	_tmp16_ = _tmp15_;
	g_settings_set_value (_tmp14_, "persist-window-geometry", _tmp16_);
	_g_variant_unref0 (_tmp16_);
	_g_variant_builder_unref0 (builder);
}

static gint
peek_ui_application_window_get_window_width (PeekUiApplicationWindow* self)
{
	gint w = 0;
	gint h = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	gtk_window_get_size ((GtkWindow*) self, &_tmp0_, &_tmp1_);
	w = _tmp0_;
	h = _tmp1_;
	result = w;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static void
peek_ui_application_window_set_close_button_position (PeekUiApplicationWindow* self)
{
	GtkSettings* settings = NULL;
	GtkSettings* _tmp0_;
	GtkSettings* _tmp1_;
	gchar* _tmp2_ = NULL;
	GtkSettings* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* decoration_layout = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_settings_get_default ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	settings = _tmp1_;
	_tmp3_ = settings;
	g_object_get (_tmp3_, "gtk-decoration-layout", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	_tmp2_ = _tmp5_;
	if (_tmp2_ == NULL) {
		gchar* _tmp6_;
		_tmp6_ = g_strdup ("");
		_g_free0 (_tmp2_);
		_tmp2_ = _tmp6_;
	}
	_tmp7_ = _tmp2_;
	_tmp2_ = NULL;
	decoration_layout = _tmp7_;
	_tmp8_ = decoration_layout;
	g_debug ("application-window.vala:929: Decoration layout: %s", _tmp8_);
	_tmp9_ = decoration_layout;
	if (string_contains (_tmp9_, ":")) {
		gchar** decoration = NULL;
		const gchar* _tmp10_;
		gchar** _tmp11_;
		gchar** _tmp12_;
		gint decoration_length1;
		gint _decoration_size_;
		gchar** _tmp13_;
		gint _tmp13__length1;
		const gchar* _tmp14_;
		_tmp10_ = decoration_layout;
		_tmp12_ = _tmp11_ = g_strsplit (_tmp10_, ":", 2);
		decoration = _tmp12_;
		decoration_length1 = _vala_array_length (_tmp11_);
		_decoration_size_ = decoration_length1;
		_tmp13_ = decoration;
		_tmp13__length1 = decoration_length1;
		_tmp14_ = _tmp13_[0];
		if (string_contains (_tmp14_, "close")) {
			peek_ui_application_window_move_close_button_left (self);
		}
		decoration = (_vala_array_free (decoration, decoration_length1, (GDestroyNotify) g_free), NULL);
	}
	_g_free0 (decoration_layout);
	_g_free0 (_tmp2_);
	_g_object_unref0 (settings);
}

static void
peek_ui_application_window_move_close_button_left (PeekUiApplicationWindow* self)
{
	gchar** decoration = NULL;
	GtkHeaderBar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar** _tmp3_;
	gchar** _tmp4_;
	gint decoration_length1;
	gint _decoration_size_;
	gboolean _tmp5_ = FALSE;
	gchar** _tmp6_;
	gint _tmp6__length1;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->headerbar;
	_tmp1_ = gtk_header_bar_get_decoration_layout (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp4_ = _tmp3_ = g_strsplit (_tmp2_, ":", 2);
	decoration = _tmp4_;
	decoration_length1 = _vala_array_length (_tmp3_);
	_decoration_size_ = decoration_length1;
	_tmp6_ = decoration;
	_tmp6__length1 = decoration_length1;
	if (_tmp6__length1 == 2) {
		gchar** _tmp7_;
		gint _tmp7__length1;
		const gchar* _tmp8_;
		_tmp7_ = decoration;
		_tmp7__length1 = decoration_length1;
		_tmp8_ = _tmp7_[1];
		_tmp5_ = string_contains (_tmp8_, "close");
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		GtkHeaderBar* _tmp9_;
		gchar** _tmp10_;
		gint _tmp10__length1;
		const gchar* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		const gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		_tmp9_ = self->priv->headerbar;
		_tmp10_ = decoration;
		_tmp10__length1 = decoration_length1;
		_tmp11_ = _tmp10_[1];
		_tmp12_ = g_strconcat (_tmp11_, ":", NULL);
		_tmp13_ = _tmp12_;
		_tmp14_ = decoration;
		_tmp14__length1 = decoration_length1;
		_tmp15_ = _tmp14_[0];
		_tmp16_ = g_strconcat (_tmp13_, _tmp15_, NULL);
		_tmp17_ = _tmp16_;
		gtk_header_bar_set_decoration_layout (_tmp9_, _tmp17_);
		_g_free0 (_tmp17_);
		_g_free0 (_tmp13_);
	}
	decoration = (_vala_array_free (decoration, decoration_length1, (GDestroyNotify) g_free), NULL);
}

PeekRecordingScreenRecorder*
peek_ui_application_window_get_recorder (PeekUiApplicationWindow* self)
{
	PeekRecordingScreenRecorder* result;
	PeekRecordingScreenRecorder* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_recorder;
	result = _tmp0_;
	return result;
}

void
peek_ui_application_window_set_recorder (PeekUiApplicationWindow* self,
                                         PeekRecordingScreenRecorder* value)
{
	PeekRecordingScreenRecorder* old_value;
	g_return_if_fail (self != NULL);
	old_value = peek_ui_application_window_get_recorder (self);
	if (old_value != value) {
		PeekRecordingScreenRecorder* _tmp0_;
		_tmp0_ = _g_object_ref0 (value);
		_g_object_unref0 (self->priv->_recorder);
		self->priv->_recorder = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_RECORDER_PROPERTY]);
	}
}

gboolean
peek_ui_application_window_get_open_file_manager (PeekUiApplicationWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_open_file_manager;
	return result;
}

void
peek_ui_application_window_set_open_file_manager (PeekUiApplicationWindow* self,
                                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = peek_ui_application_window_get_open_file_manager (self);
	if (old_value != value) {
		self->priv->_open_file_manager = value;
		g_object_notify_by_pspec ((GObject *) self, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_OPEN_FILE_MANAGER_PROPERTY]);
	}
}

gboolean
peek_ui_application_window_get_show_notification (PeekUiApplicationWindow* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_show_notification;
	return result;
}

void
peek_ui_application_window_set_show_notification (PeekUiApplicationWindow* self,
                                                  gboolean value)
{
	gboolean old_value;
	g_return_if_fail (self != NULL);
	old_value = peek_ui_application_window_get_show_notification (self);
	if (old_value != value) {
		self->priv->_show_notification = value;
		g_object_notify_by_pspec ((GObject *) self, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_SHOW_NOTIFICATION_PROPERTY]);
	}
}

gint
peek_ui_application_window_get_size_indicator_delay (PeekUiApplicationWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_size_indicator_delay;
	return result;
}

void
peek_ui_application_window_set_size_indicator_delay (PeekUiApplicationWindow* self,
                                                     gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = peek_ui_application_window_get_size_indicator_delay (self);
	if (old_value != value) {
		self->priv->_size_indicator_delay = value;
		g_object_notify_by_pspec ((GObject *) self, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_SIZE_INDICATOR_DELAY_PROPERTY]);
	}
}

gint
peek_ui_application_window_get_recording_start_delay (PeekUiApplicationWindow* self)
{
	gint result;
	g_return_val_if_fail (self != NULL, 0);
	result = self->priv->_recording_start_delay;
	return result;
}

void
peek_ui_application_window_set_recording_start_delay (PeekUiApplicationWindow* self,
                                                      gint value)
{
	gint old_value;
	g_return_if_fail (self != NULL);
	old_value = peek_ui_application_window_get_recording_start_delay (self);
	if (old_value != value) {
		self->priv->_recording_start_delay = value;
		g_object_notify_by_pspec ((GObject *) self, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_RECORDING_START_DELAY_PROPERTY]);
	}
}

const gchar*
peek_ui_application_window_get_default_file_name_format (PeekUiApplicationWindow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_default_file_name_format;
	result = _tmp0_;
	return result;
}

void
peek_ui_application_window_set_default_file_name_format (PeekUiApplicationWindow* self,
                                                         const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = peek_ui_application_window_get_default_file_name_format (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_default_file_name_format);
		self->priv->_default_file_name_format = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_DEFAULT_FILE_NAME_FORMAT_PROPERTY]);
	}
}

const gchar*
peek_ui_application_window_get_save_folder (PeekUiApplicationWindow* self)
{
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_save_folder;
	result = _tmp0_;
	return result;
}

void
peek_ui_application_window_set_save_folder (PeekUiApplicationWindow* self,
                                            const gchar* value)
{
	gchar* old_value;
	g_return_if_fail (self != NULL);
	old_value = peek_ui_application_window_get_save_folder (self);
	if (g_strcmp0 (value, old_value) != 0) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (value);
		_g_free0 (self->priv->_save_folder);
		self->priv->_save_folder = _tmp0_;
		g_object_notify_by_pspec ((GObject *) self, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_SAVE_FOLDER_PROPERTY]);
	}
}

static void
peek_ui_application_window_class_init (PeekUiApplicationWindowClass * klass,
                                       gpointer klass_data)
{
	peek_ui_application_window_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PeekUiApplicationWindow_private_offset);
	((GtkWidgetClass *) klass)->configure_event = (gboolean (*) (GtkWidget*, GdkEventConfigure*)) peek_ui_application_window_real_configure_event;
	((GtkWidgetClass *) klass)->delete_event = (gboolean (*) (GtkWidget*, GdkEventAny*)) peek_ui_application_window_real_delete_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_peek_ui_application_window_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_peek_ui_application_window_set_property;
	G_OBJECT_CLASS (klass)->finalize = peek_ui_application_window_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PEEK_UI_APPLICATION_WINDOW_RECORDER_PROPERTY, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_RECORDER_PROPERTY] = g_param_spec_object ("recorder", "recorder", "recorder", PEEK_RECORDING_TYPE_SCREEN_RECORDER, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PEEK_UI_APPLICATION_WINDOW_OPEN_FILE_MANAGER_PROPERTY, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_OPEN_FILE_MANAGER_PROPERTY] = g_param_spec_boolean ("open-file-manager", "open-file-manager", "open-file-manager", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PEEK_UI_APPLICATION_WINDOW_SHOW_NOTIFICATION_PROPERTY, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_SHOW_NOTIFICATION_PROPERTY] = g_param_spec_boolean ("show-notification", "show-notification", "show-notification", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PEEK_UI_APPLICATION_WINDOW_SIZE_INDICATOR_DELAY_PROPERTY, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_SIZE_INDICATOR_DELAY_PROPERTY] = g_param_spec_int ("size-indicator-delay", "size-indicator-delay", "size-indicator-delay", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PEEK_UI_APPLICATION_WINDOW_RECORDING_START_DELAY_PROPERTY, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_RECORDING_START_DELAY_PROPERTY] = g_param_spec_int ("recording-start-delay", "recording-start-delay", "recording-start-delay", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PEEK_UI_APPLICATION_WINDOW_DEFAULT_FILE_NAME_FORMAT_PROPERTY, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_DEFAULT_FILE_NAME_FORMAT_PROPERTY] = g_param_spec_string ("default-file-name-format", "default-file-name-format", "default-file-name-format", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), PEEK_UI_APPLICATION_WINDOW_SAVE_FOLDER_PROPERTY, peek_ui_application_window_properties[PEEK_UI_APPLICATION_WINDOW_SAVE_FOLDER_PROPERTY] = g_param_spec_string ("save-folder", "save-folder", "save-folder", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/uploadedlobster/peek/application-window.ui");
	peek_ui_application_window_signals[PEEK_UI_APPLICATION_WINDOW_RECORDING_FINISHED_SIGNAL] = g_signal_new ("recording-finished", PEEK_UI_TYPE_APPLICATION_WINDOW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "headerbar", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, headerbar));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "recording_view", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, recording_view));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "record_button", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, record_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "stop_button", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, stop_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pop_format", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, pop_format));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "gif_button", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, gif_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "apng_button", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, apng_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "webm_button", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, webm_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "mp4_button", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, mp4_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pop_format_menu", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, pop_format_menu));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "size_indicator", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, size_indicator));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "delay_indicator", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, delay_indicator));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "shortcut_label", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, shortcut_label));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pop_menu_button", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, pop_menu_button));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "pop_menu", FALSE, PeekUiApplicationWindow_private_offset + G_STRUCT_OFFSET (PeekUiApplicationWindowPrivate, pop_menu));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_screen_changed", G_CALLBACK(_peek_ui_application_window_on_window_screen_changed_gtk_widget_screen_changed));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_window_draw", G_CALLBACK(_peek_ui_application_window_on_window_draw_gtk_widget_draw));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_recording_view_draw", G_CALLBACK(_peek_ui_application_window_on_recording_view_draw_gtk_widget_draw));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_recording_view_size_allocate", G_CALLBACK(_peek_ui_application_window_on_recording_view_size_allocate_gtk_widget_size_allocate));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_format_selection_toggled", G_CALLBACK(_peek_ui_application_window_on_format_selection_toggled_gtk_toggle_button_toggled));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_record_button_clicked", G_CALLBACK(_peek_ui_application_window_on_record_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_stop_button_clicked", G_CALLBACK(_peek_ui_application_window_on_stop_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_new_window_button_clicked", G_CALLBACK(_peek_ui_application_window_on_new_window_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_set_window_size_button_clicked", G_CALLBACK(_peek_ui_application_window_on_set_window_size_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_preferences_button_clicked", G_CALLBACK(_peek_ui_application_window_on_preferences_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_about_button_clicked", G_CALLBACK(_peek_ui_application_window_on_about_button_clicked_gtk_button_clicked));
}

static void
peek_ui_application_window_instance_init (PeekUiApplicationWindow * self,
                                          gpointer klass)
{
	self->priv = peek_ui_application_window_get_instance_private (self);
	self->priv->start_recording_event_source = (guint) 0;
	self->priv->size_indicator_timeout = (guint) 0;
	self->priv->delay_indicator_timeout = (guint) 0;
	self->priv->time_indicator_timeout = (guint) 0;
	self->priv->is_recording = FALSE;
	self->priv->is_postprocessing = FALSE;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
peek_ui_application_window_finalize (GObject * obj)
{
	PeekUiApplicationWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PEEK_UI_TYPE_APPLICATION_WINDOW, PeekUiApplicationWindow);
	_g_object_unref0 (self->priv->_recorder);
	_g_free0 (self->priv->_default_file_name_format);
	_g_free0 (self->priv->_save_folder);
	_g_object_unref0 (self->priv->in_file);
	_g_object_unref0 (self->priv->out_file);
	peek_recording_recording_area_destroy (&self->priv->active_recording_area);
	_g_free0 (self->priv->stop_button_label);
	_g_object_unref0 (self->priv->settings);
	G_OBJECT_CLASS (peek_ui_application_window_parent_class)->finalize (obj);
}

static GType
peek_ui_application_window_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PeekUiApplicationWindowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) peek_ui_application_window_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PeekUiApplicationWindow), 0, (GInstanceInitFunc) peek_ui_application_window_instance_init, NULL };
	GType peek_ui_application_window_type_id;
	peek_ui_application_window_type_id = g_type_register_static (gtk_application_window_get_type (), "PeekUiApplicationWindow", &g_define_type_info, 0);
	PeekUiApplicationWindow_private_offset = g_type_add_instance_private (peek_ui_application_window_type_id, sizeof (PeekUiApplicationWindowPrivate));
	return peek_ui_application_window_type_id;
}

GType
peek_ui_application_window_get_type (void)
{
	static volatile gsize peek_ui_application_window_type_id__once = 0;
	if (g_once_init_enter (&peek_ui_application_window_type_id__once)) {
		GType peek_ui_application_window_type_id;
		peek_ui_application_window_type_id = peek_ui_application_window_get_type_once ();
		g_once_init_leave (&peek_ui_application_window_type_id__once, peek_ui_application_window_type_id);
	}
	return peek_ui_application_window_type_id__once;
}

static void
_vala_peek_ui_application_window_get_property (GObject * object,
                                               guint property_id,
                                               GValue * value,
                                               GParamSpec * pspec)
{
	PeekUiApplicationWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PEEK_UI_TYPE_APPLICATION_WINDOW, PeekUiApplicationWindow);
	switch (property_id) {
		case PEEK_UI_APPLICATION_WINDOW_RECORDER_PROPERTY:
		g_value_set_object (value, peek_ui_application_window_get_recorder (self));
		break;
		case PEEK_UI_APPLICATION_WINDOW_OPEN_FILE_MANAGER_PROPERTY:
		g_value_set_boolean (value, peek_ui_application_window_get_open_file_manager (self));
		break;
		case PEEK_UI_APPLICATION_WINDOW_SHOW_NOTIFICATION_PROPERTY:
		g_value_set_boolean (value, peek_ui_application_window_get_show_notification (self));
		break;
		case PEEK_UI_APPLICATION_WINDOW_SIZE_INDICATOR_DELAY_PROPERTY:
		g_value_set_int (value, peek_ui_application_window_get_size_indicator_delay (self));
		break;
		case PEEK_UI_APPLICATION_WINDOW_RECORDING_START_DELAY_PROPERTY:
		g_value_set_int (value, peek_ui_application_window_get_recording_start_delay (self));
		break;
		case PEEK_UI_APPLICATION_WINDOW_DEFAULT_FILE_NAME_FORMAT_PROPERTY:
		g_value_set_string (value, peek_ui_application_window_get_default_file_name_format (self));
		break;
		case PEEK_UI_APPLICATION_WINDOW_SAVE_FOLDER_PROPERTY:
		g_value_set_string (value, peek_ui_application_window_get_save_folder (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_peek_ui_application_window_set_property (GObject * object,
                                               guint property_id,
                                               const GValue * value,
                                               GParamSpec * pspec)
{
	PeekUiApplicationWindow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PEEK_UI_TYPE_APPLICATION_WINDOW, PeekUiApplicationWindow);
	switch (property_id) {
		case PEEK_UI_APPLICATION_WINDOW_RECORDER_PROPERTY:
		peek_ui_application_window_set_recorder (self, g_value_get_object (value));
		break;
		case PEEK_UI_APPLICATION_WINDOW_OPEN_FILE_MANAGER_PROPERTY:
		peek_ui_application_window_set_open_file_manager (self, g_value_get_boolean (value));
		break;
		case PEEK_UI_APPLICATION_WINDOW_SHOW_NOTIFICATION_PROPERTY:
		peek_ui_application_window_set_show_notification (self, g_value_get_boolean (value));
		break;
		case PEEK_UI_APPLICATION_WINDOW_SIZE_INDICATOR_DELAY_PROPERTY:
		peek_ui_application_window_set_size_indicator_delay (self, g_value_get_int (value));
		break;
		case PEEK_UI_APPLICATION_WINDOW_RECORDING_START_DELAY_PROPERTY:
		peek_ui_application_window_set_recording_start_delay (self, g_value_get_int (value));
		break;
		case PEEK_UI_APPLICATION_WINDOW_DEFAULT_FILE_NAME_FORMAT_PROPERTY:
		peek_ui_application_window_set_default_file_name_format (self, g_value_get_string (value));
		break;
		case PEEK_UI_APPLICATION_WINDOW_SAVE_FOLDER_PROPERTY:
		peek_ui_application_window_set_save_folder (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

