/* error-dialog.c generated by valac 0.56.17, the Vala compiler
 * generated from error-dialog.vala, do not modify */

/*
Peek Copyright (c) 2017 by Philipp Wolfer <ph.wolfer@gmail.com>

This file is part of Peek.

This software is licensed under the GNU General Public License
(version 3 or later). See the LICENSE file in this distribution.
*/

#include <gtk/gtk.h>
#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include "../../application.h"
#include <gio/gio.h>

#define PEEK_ISSUE_TRACKER_URL "https://github.com/phw/peek/issues/new"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define PEEK_UI_TYPE_ERROR_DIALOG (peek_ui_error_dialog_get_type ())
#define PEEK_UI_ERROR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PEEK_UI_TYPE_ERROR_DIALOG, PeekUiErrorDialog))
#define PEEK_UI_ERROR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PEEK_UI_TYPE_ERROR_DIALOG, PeekUiErrorDialogClass))
#define PEEK_UI_IS_ERROR_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PEEK_UI_TYPE_ERROR_DIALOG))
#define PEEK_UI_IS_ERROR_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PEEK_UI_TYPE_ERROR_DIALOG))
#define PEEK_UI_ERROR_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PEEK_UI_TYPE_ERROR_DIALOG, PeekUiErrorDialogClass))

typedef struct _PeekUiErrorDialog PeekUiErrorDialog;
typedef struct _PeekUiErrorDialogClass PeekUiErrorDialogClass;
typedef struct _PeekUiErrorDialogPrivate PeekUiErrorDialogPrivate;
enum  {
	PEEK_UI_ERROR_DIALOG_0_PROPERTY,
	PEEK_UI_ERROR_DIALOG_SUMMARY_PROPERTY,
	PEEK_UI_ERROR_DIALOG_NUM_PROPERTIES
};
static GParamSpec* peek_ui_error_dialog_properties[PEEK_UI_ERROR_DIALOG_NUM_PROPERTIES];
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _Block6Data Block6Data;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))

struct _PeekUiErrorDialog {
	GtkDialog parent_instance;
	PeekUiErrorDialogPrivate * priv;
};

struct _PeekUiErrorDialogClass {
	GtkDialogClass parent_class;
};

struct _PeekUiErrorDialogPrivate {
	GtkLabel* error_summary;
	GtkTextBuffer* error_details;
	GtkExpander* error_details_container;
	GError* error;
};

struct _Block6Data {
	int _ref_count_;
	GtkWindow* main_window;
};

static gint PeekUiErrorDialog_private_offset;
static gpointer peek_ui_error_dialog_parent_class = NULL;
static PeekUiErrorDialog* peek_ui_error_dialog_instance;
static PeekUiErrorDialog* peek_ui_error_dialog_instance = NULL;

VALA_EXTERN GType peek_ui_error_dialog_get_type (void) G_GNUC_CONST ;
VALA_EXTERN GtkDialog* peek_ui_error_dialog_present_single_instance (GtkWindow* main_window,
                                                         const gchar* summary,
                                                         GError* _error_);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
VALA_EXTERN PeekUiErrorDialog* peek_ui_error_dialog_new (void);
VALA_EXTERN PeekUiErrorDialog* peek_ui_error_dialog_construct (GType object_type);
static gboolean ___lambda8_ (Block6Data* _data6_,
                      GdkEventAny* event);
static gboolean ____lambda8__gtk_widget_delete_event (GtkWidget* _sender,
                                               GdkEventAny* event,
                                               gpointer self);
VALA_EXTERN void peek_ui_error_dialog_set_summary (PeekUiErrorDialog* self,
                                       const gchar* value);
VALA_EXTERN void peek_ui_error_dialog_show_error (PeekUiErrorDialog* self,
                                      GError* _error_);
static void peek_ui_error_dialog_on_close_button_clicked (PeekUiErrorDialog* self,
                                                   GtkButton* source);
static void _peek_ui_error_dialog_on_close_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                       gpointer self);
static void peek_ui_error_dialog_on_report_issue_button_clicked (PeekUiErrorDialog* self,
                                                          GtkButton* source);
static gchar* peek_ui_error_dialog_build_issue_tracker_url (PeekUiErrorDialog* self);
static void _peek_ui_error_dialog_on_report_issue_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                              gpointer self);
static gchar* peek_ui_error_dialog_get_issue_body (PeekUiErrorDialog* self);
static gchar* peek_ui_error_dialog_get_ffmpeg_version (void);
VALA_EXTERN const gchar* peek_ui_error_dialog_get_summary (PeekUiErrorDialog* self);
static void peek_ui_error_dialog_finalize (GObject * obj);
static GType peek_ui_error_dialog_get_type_once (void);
static void _vala_peek_ui_error_dialog_get_property (GObject * object,
                                              guint property_id,
                                              GValue * value,
                                              GParamSpec * pspec);
static void _vala_peek_ui_error_dialog_set_property (GObject * object,
                                              guint property_id,
                                              const GValue * value,
                                              GParamSpec * pspec);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
peek_ui_error_dialog_get_instance_private (PeekUiErrorDialog* self)
{
	return G_STRUCT_MEMBER_P (self, PeekUiErrorDialog_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static Block6Data*
block6_data_ref (Block6Data* _data6_)
{
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}

static void
block6_data_unref (void * _userdata_)
{
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		_g_object_unref0 (_data6_->main_window);
		g_slice_free (Block6Data, _data6_);
	}
}

static gboolean
___lambda8_ (Block6Data* _data6_,
             GdkEventAny* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	_g_object_unref0 (peek_ui_error_dialog_instance);
	peek_ui_error_dialog_instance = NULL;
	gtk_window_set_keep_above (_data6_->main_window, TRUE);
	result = FALSE;
	return result;
}

static gboolean
____lambda8__gtk_widget_delete_event (GtkWidget* _sender,
                                      GdkEventAny* event,
                                      gpointer self)
{
	gboolean result;
	result = ___lambda8_ (self, event);
	return result;
}

GtkDialog*
peek_ui_error_dialog_present_single_instance (GtkWindow* main_window,
                                              const gchar* summary,
                                              GError* _error_)
{
	Block6Data* _data6_;
	GtkWindow* _tmp0_;
	PeekUiErrorDialog* _tmp1_;
	PeekUiErrorDialog* _tmp4_;
	PeekUiErrorDialog* _tmp5_;
	PeekUiErrorDialog* _tmp6_;
	PeekUiErrorDialog* _tmp7_;
	PeekUiErrorDialog* _tmp8_;
	GtkDialog* _tmp9_;
	GtkDialog* result;
	g_return_val_if_fail (main_window != NULL, NULL);
	g_return_val_if_fail (summary != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_tmp0_ = _g_object_ref0 (main_window);
	_g_object_unref0 (_data6_->main_window);
	_data6_->main_window = _tmp0_;
	_tmp1_ = peek_ui_error_dialog_instance;
	if (_tmp1_ == NULL) {
		PeekUiErrorDialog* _tmp2_;
		PeekUiErrorDialog* _tmp3_;
		_tmp2_ = peek_ui_error_dialog_new ();
		g_object_ref_sink (_tmp2_);
		_g_object_unref0 (peek_ui_error_dialog_instance);
		peek_ui_error_dialog_instance = _tmp2_;
		_tmp3_ = peek_ui_error_dialog_instance;
		g_signal_connect_data ((GtkWidget*) _tmp3_, "delete-event", (GCallback) ____lambda8__gtk_widget_delete_event, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	}
	_tmp4_ = peek_ui_error_dialog_instance;
	peek_ui_error_dialog_set_summary (_tmp4_, summary);
	_tmp5_ = peek_ui_error_dialog_instance;
	peek_ui_error_dialog_show_error (_tmp5_, _error_);
	_tmp6_ = peek_ui_error_dialog_instance;
	gtk_window_set_transient_for ((GtkWindow*) _tmp6_, _data6_->main_window);
	gtk_window_set_keep_above (_data6_->main_window, FALSE);
	_tmp7_ = peek_ui_error_dialog_instance;
	gtk_window_present ((GtkWindow*) _tmp7_);
	_tmp8_ = peek_ui_error_dialog_instance;
	_tmp9_ = _g_object_ref0 ((GtkDialog*) _tmp8_);
	result = _tmp9_;
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return result;
}

static gpointer
_g_error_copy0 (gpointer self)
{
	return self ? g_error_copy (self) : NULL;
}

void
peek_ui_error_dialog_show_error (PeekUiErrorDialog* self,
                                 GError* _error_)
{
	GError* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = _g_error_copy0 (_error_);
	_g_error_free0 (self->priv->error);
	self->priv->error = _tmp0_;
	if (_error_ != NULL) {
		GtkTextBuffer* _tmp1_;
		const gchar* _tmp2_;
		GtkExpander* _tmp3_;
		_tmp1_ = self->priv->error_details;
		_tmp2_ = _error_->message;
		g_object_set (_tmp1_, "text", _tmp2_, NULL);
		_tmp3_ = self->priv->error_details_container;
		gtk_widget_show ((GtkWidget*) _tmp3_);
	} else {
		GtkTextBuffer* _tmp4_;
		GtkExpander* _tmp5_;
		_tmp4_ = self->priv->error_details;
		g_object_set (_tmp4_, "text", "", NULL);
		_tmp5_ = self->priv->error_details_container;
		gtk_widget_hide ((GtkWidget*) _tmp5_);
	}
}

static void
peek_ui_error_dialog_on_close_button_clicked (PeekUiErrorDialog* self,
                                              GtkButton* source)
{
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	g_signal_emit_by_name ((GtkDialog*) self, "close");
}

static void
_peek_ui_error_dialog_on_close_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                  gpointer self)
{
	peek_ui_error_dialog_on_close_button_clicked ((PeekUiErrorDialog*) self, _sender);
}

static void
peek_ui_error_dialog_on_report_issue_button_clicked (PeekUiErrorDialog* self,
                                                     GtkButton* source)
{
	gchar* url = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	_tmp0_ = peek_ui_error_dialog_build_issue_tracker_url (self);
	url = _tmp0_;
	{
		gtk_show_uri_on_window ((GtkWindow*) self, url, (guint32) GDK_CURRENT_TIME, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		FILE* _tmp1_;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp1_ = stderr;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		fprintf (_tmp1_, "Error opening issue tracker URL: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (url);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (url);
}

static void
_peek_ui_error_dialog_on_report_issue_button_clicked_gtk_button_clicked (GtkButton* _sender,
                                                                         gpointer self)
{
	peek_ui_error_dialog_on_report_issue_button_clicked ((PeekUiErrorDialog*) self, _sender);
}

static gchar*
peek_ui_error_dialog_build_issue_tracker_url (PeekUiErrorDialog* self)
{
	GString* url = NULL;
	GString* _tmp0_;
	gchar* body = NULL;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	url = _tmp0_;
	g_string_append (url, PEEK_ISSUE_TRACKER_URL);
	_tmp1_ = peek_ui_error_dialog_get_issue_body (self);
	body = _tmp1_;
	_tmp2_ = g_uri_escape_string (body, NULL, TRUE);
	_tmp3_ = _tmp2_;
	g_string_append_printf (url, "?body=%s", _tmp3_);
	_g_free0 (_tmp3_);
	_tmp4_ = url->str;
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	_g_free0 (body);
	_g_string_free0 (url);
	return result;
}

static gchar*
string_strip (const gchar* self)
{
	gchar* _result_ = NULL;
	gchar* _tmp0_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_strdup (self);
	_result_ = _tmp0_;
	g_strstrip (_result_);
	result = _result_;
	return result;
}

static gchar*
peek_ui_error_dialog_get_ffmpeg_version (void)
{
	gchar** args = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
	gint args_length1;
	gint _args_size_;
	gint status = 0;
	gchar* output = NULL;
	GError* _inner_error0_ = NULL;
	gchar* result;
	_tmp0_ = g_strdup ("ffmpeg");
	_tmp1_ = g_strdup ("-version");
	_tmp2_ = g_new0 (gchar*, 2 + 1);
	_tmp2_[0] = _tmp0_;
	_tmp2_[1] = _tmp1_;
	args = _tmp2_;
	args_length1 = 2;
	_args_size_ = args_length1;
	{
		gchar* _tmp3_ = NULL;
		gint _tmp4_ = 0;
		gchar* _tmp5_;
		g_spawn_sync (NULL, args, NULL, G_SPAWN_SEARCH_PATH, NULL, NULL, &_tmp3_, NULL, &_tmp4_, &_inner_error0_);
		_g_free0 (output);
		output = _tmp3_;
		status = _tmp4_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_SPAWN_ERROR) {
				goto __catch0_g_spawn_error;
			}
			_g_free0 (output);
			args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp5_ = string_strip (output);
		result = _tmp5_;
		_g_free0 (output);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	goto __finally0;
	__catch0_g_spawn_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		GError* _tmp8_;
		const gchar* _tmp9_;
		gchar* _tmp10_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_debug ("error-dialog.vala:114: Error: %s", _tmp7_);
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		_tmp10_ = string_strip (_tmp9_);
		result = _tmp10_;
		_g_error_free0 (e);
		_g_free0 (output);
		args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
		return result;
	}
	__finally0:
	_g_free0 (output);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

static gchar*
peek_ui_error_dialog_get_issue_body (PeekUiErrorDialog* self)
{
	GString* body = NULL;
	GString* _tmp0_;
	GString* _tmp1_;
	GString* _tmp2_;
	GString* _tmp3_;
	GString* _tmp4_;
	GString* _tmp5_;
	GString* _tmp6_;
	GString* _tmp7_;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_;
	GString* _tmp10_;
	const gchar* _tmp11_ = NULL;
	GString* _tmp12_;
	GString* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	GString* _tmp16_;
	GSettings* settings = NULL;
	GSettings* _tmp17_;
	GString* _tmp18_;
	GSettings* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_ = NULL;
	GSettings* _tmp23_;
	GString* _tmp24_;
	GError* _tmp25_;
	GString* _tmp31_;
	const gchar* _tmp32_;
	gchar* _tmp33_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	body = _tmp0_;
	_tmp1_ = body;
	g_string_append_printf (_tmp1_, "<!--\n");
	_tmp2_ = body;
	g_string_append_printf (_tmp2_, "Please read the FAQs (https://github.com/phw/peek#frequently-asked-que" \
"stions) before reporting this issue.\n");
	_tmp3_ = body;
	g_string_append_printf (_tmp3_, "If the FAQs do not answer your problem, describe the issue you have wi" \
"th as much details as possible.\n");
	_tmp4_ = body;
	g_string_append_printf (_tmp4_, "-->\n\n");
	_tmp5_ = body;
	g_string_append_printf (_tmp5_, "Peek: %s\n", VERSION);
	_tmp6_ = body;
	g_string_append_printf (_tmp6_, "GTK: %i.%i.%i\n", GTK_MAJOR_VERSION, GTK_MINOR_VERSION, GTK_MICRO_VERSION);
	_tmp7_ = body;
	g_string_append_printf (_tmp7_, "GLib: %u.%u.%u\n", GLIB_MAJOR_VERSION, GLIB_MINOR_VERSION, GLIB_MICRO_VERSION);
	_tmp9_ = g_getenv ("XDG_CURRENT_DESKTOP");
	_tmp8_ = _tmp9_;
	if (_tmp8_ == NULL) {
		_tmp8_ = "Unknown";
	}
	_tmp10_ = body;
	g_string_append_printf (_tmp10_, "Desktop: %s\n", _tmp8_);
	if (peek_desktop_integration_is_wayland_backend ()) {
		_tmp11_ = "Wayland";
	} else {
		_tmp11_ = "X";
	}
	_tmp12_ = body;
	g_string_append_printf (_tmp12_, "Display server: %s\n", _tmp11_);
	_tmp13_ = body;
	_tmp14_ = peek_ui_error_dialog_get_ffmpeg_version ();
	_tmp15_ = _tmp14_;
	g_string_append_printf (_tmp13_, "FFmpeg version:\n```\n%s\n```\n", _tmp15_);
	_g_free0 (_tmp15_);
	_tmp16_ = body;
	g_string_append_printf (_tmp16_, "\n");
	_tmp17_ = peek_application_get_app_settings ();
	settings = _tmp17_;
	_tmp18_ = body;
	_tmp19_ = settings;
	_tmp20_ = g_settings_get_string (_tmp19_, "recording-output-format");
	_tmp21_ = _tmp20_;
	g_string_append_printf (_tmp18_, "Output format: %s\n", _tmp21_);
	_g_free0 (_tmp21_);
	_tmp23_ = settings;
	if (g_settings_get_boolean (_tmp23_, "recording-gifski-enabled")) {
		_tmp22_ = "true";
	} else {
		_tmp22_ = "false";
	}
	_tmp24_ = body;
	g_string_append_printf (_tmp24_, "gifski enabled: %s\n", _tmp22_);
	_tmp25_ = self->priv->error;
	if (_tmp25_ != NULL) {
		GString* _tmp26_;
		GtkTextBuffer* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_;
		_tmp26_ = body;
		_tmp27_ = self->priv->error_details;
		g_object_get (_tmp27_, "text", &_tmp28_, NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = _tmp29_;
		g_string_append_printf (_tmp26_, "\nError details:\n```\n%s\n```", _tmp30_);
		_g_free0 (_tmp30_);
	}
	_tmp31_ = body;
	_tmp32_ = _tmp31_->str;
	_tmp33_ = g_strdup (_tmp32_);
	result = _tmp33_;
	_g_object_unref0 (settings);
	_g_string_free0 (body);
	return result;
}

PeekUiErrorDialog*
peek_ui_error_dialog_construct (GType object_type)
{
	PeekUiErrorDialog * self = NULL;
	self = (PeekUiErrorDialog*) g_object_new (object_type, NULL);
	return self;
}

PeekUiErrorDialog*
peek_ui_error_dialog_new (void)
{
	return peek_ui_error_dialog_construct (PEEK_UI_TYPE_ERROR_DIALOG);
}

const gchar*
peek_ui_error_dialog_get_summary (PeekUiErrorDialog* self)
{
	const gchar* result;
	GtkLabel* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->error_summary;
	_tmp1_ = gtk_label_get_label (_tmp0_);
	_tmp2_ = _tmp1_;
	result = _tmp2_;
	return result;
}

void
peek_ui_error_dialog_set_summary (PeekUiErrorDialog* self,
                                  const gchar* value)
{
	GtkLabel* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->error_summary;
	gtk_label_set_label (_tmp0_, value);
	g_object_notify_by_pspec ((GObject *) self, peek_ui_error_dialog_properties[PEEK_UI_ERROR_DIALOG_SUMMARY_PROPERTY]);
}

static void
peek_ui_error_dialog_class_init (PeekUiErrorDialogClass * klass,
                                 gpointer klass_data)
{
	peek_ui_error_dialog_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PeekUiErrorDialog_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_peek_ui_error_dialog_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_peek_ui_error_dialog_set_property;
	G_OBJECT_CLASS (klass)->finalize = peek_ui_error_dialog_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), PEEK_UI_ERROR_DIALOG_SUMMARY_PROPERTY, peek_ui_error_dialog_properties[PEEK_UI_ERROR_DIALOG_SUMMARY_PROPERTY] = g_param_spec_string ("summary", "summary", "summary", NULL, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE | G_PARAM_WRITABLE));
	gtk_widget_class_set_template_from_resource (GTK_WIDGET_CLASS (klass), "/com/uploadedlobster/peek/error-dialog.ui");
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_summary", FALSE, PeekUiErrorDialog_private_offset + G_STRUCT_OFFSET (PeekUiErrorDialogPrivate, error_summary));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_details", FALSE, PeekUiErrorDialog_private_offset + G_STRUCT_OFFSET (PeekUiErrorDialogPrivate, error_details));
	gtk_widget_class_bind_template_child_full (GTK_WIDGET_CLASS (klass), "error_details_container", FALSE, PeekUiErrorDialog_private_offset + G_STRUCT_OFFSET (PeekUiErrorDialogPrivate, error_details_container));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_close_button_clicked", G_CALLBACK(_peek_ui_error_dialog_on_close_button_clicked_gtk_button_clicked));
	gtk_widget_class_bind_template_callback_full (GTK_WIDGET_CLASS (klass), "on_report_issue_button_clicked", G_CALLBACK(_peek_ui_error_dialog_on_report_issue_button_clicked_gtk_button_clicked));
}

static void
peek_ui_error_dialog_instance_init (PeekUiErrorDialog * self,
                                    gpointer klass)
{
	self->priv = peek_ui_error_dialog_get_instance_private (self);
	self->priv->error = NULL;
	gtk_widget_init_template (GTK_WIDGET (self));
}

static void
peek_ui_error_dialog_finalize (GObject * obj)
{
	PeekUiErrorDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PEEK_UI_TYPE_ERROR_DIALOG, PeekUiErrorDialog);
	_g_error_free0 (self->priv->error);
	G_OBJECT_CLASS (peek_ui_error_dialog_parent_class)->finalize (obj);
}

static GType
peek_ui_error_dialog_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PeekUiErrorDialogClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) peek_ui_error_dialog_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PeekUiErrorDialog), 0, (GInstanceInitFunc) peek_ui_error_dialog_instance_init, NULL };
	GType peek_ui_error_dialog_type_id;
	peek_ui_error_dialog_type_id = g_type_register_static (gtk_dialog_get_type (), "PeekUiErrorDialog", &g_define_type_info, 0);
	PeekUiErrorDialog_private_offset = g_type_add_instance_private (peek_ui_error_dialog_type_id, sizeof (PeekUiErrorDialogPrivate));
	return peek_ui_error_dialog_type_id;
}

GType
peek_ui_error_dialog_get_type (void)
{
	static volatile gsize peek_ui_error_dialog_type_id__once = 0;
	if (g_once_init_enter (&peek_ui_error_dialog_type_id__once)) {
		GType peek_ui_error_dialog_type_id;
		peek_ui_error_dialog_type_id = peek_ui_error_dialog_get_type_once ();
		g_once_init_leave (&peek_ui_error_dialog_type_id__once, peek_ui_error_dialog_type_id);
	}
	return peek_ui_error_dialog_type_id__once;
}

static void
_vala_peek_ui_error_dialog_get_property (GObject * object,
                                         guint property_id,
                                         GValue * value,
                                         GParamSpec * pspec)
{
	PeekUiErrorDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PEEK_UI_TYPE_ERROR_DIALOG, PeekUiErrorDialog);
	switch (property_id) {
		case PEEK_UI_ERROR_DIALOG_SUMMARY_PROPERTY:
		g_value_set_string (value, peek_ui_error_dialog_get_summary (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_peek_ui_error_dialog_set_property (GObject * object,
                                         guint property_id,
                                         const GValue * value,
                                         GParamSpec * pspec)
{
	PeekUiErrorDialog * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, PEEK_UI_TYPE_ERROR_DIALOG, PeekUiErrorDialog);
	switch (property_id) {
		case PEEK_UI_ERROR_DIALOG_SUMMARY_PROPERTY:
		peek_ui_error_dialog_set_summary (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

