/* VideoMonitor.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from VideoMonitor.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gee.h>

#define VIDEO_MONITOR_MAX_INTERPRETABLE_CHECKS_PER_CYCLE 5
#define MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE 100
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_MONITORABLE_UPDATES (monitorable_updates_get_type ())
#define MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdates))
#define MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))
#define IS_MONITORABLE_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE_UPDATES))
#define IS_MONITORABLE_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MONITORABLE_UPDATES))
#define MONITORABLE_UPDATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MONITORABLE_UPDATES, MonitorableUpdatesClass))

typedef struct _MonitorableUpdates MonitorableUpdates;
typedef struct _MonitorableUpdatesClass MonitorableUpdatesClass;
typedef struct _MonitorableUpdatesPrivate MonitorableUpdatesPrivate;

#define TYPE_MONITORABLE (monitorable_get_type ())
#define MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MONITORABLE, Monitorable))
#define IS_MONITORABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MONITORABLE))
#define MONITORABLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MONITORABLE, MonitorableIface))

typedef struct _Monitorable Monitorable;
typedef struct _MonitorableIface MonitorableIface;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_VIDEO_UPDATES (video_updates_get_type ())
#define VIDEO_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_UPDATES, VideoUpdates))
#define VIDEO_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_UPDATES, VideoUpdatesClass))
#define IS_VIDEO_UPDATES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_UPDATES))
#define IS_VIDEO_UPDATES_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_UPDATES))
#define VIDEO_UPDATES_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_UPDATES, VideoUpdatesClass))

typedef struct _VideoUpdates VideoUpdates;
typedef struct _VideoUpdatesClass VideoUpdatesClass;
typedef struct _VideoUpdatesPrivate VideoUpdatesPrivate;

#define TYPE_VIDEO_SOURCE (video_source_get_type ())
#define VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE, VideoSource))
#define VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE, VideoSourceClass))
#define IS_VIDEO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE))
#define IS_VIDEO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE))
#define VIDEO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE, VideoSourceClass))

typedef struct _VideoSource VideoSource;
typedef struct _VideoSourceClass VideoSourceClass;

#define TYPE_VIDEO (video_get_type ())
#define VIDEO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO, Video))
#define VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO, VideoClass))
#define IS_VIDEO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO))
#define IS_VIDEO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO))
#define VIDEO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO, VideoClass))

typedef struct _Video Video;
typedef struct _VideoClass VideoClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_MEDIA_MONITOR (media_monitor_get_type ())
#define MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_MONITOR, MediaMonitor))
#define MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_MONITOR, MediaMonitorClass))
#define IS_MEDIA_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_MONITOR))
#define IS_MEDIA_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_MONITOR))
#define MEDIA_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_MONITOR, MediaMonitorClass))

typedef struct _MediaMonitor MediaMonitor;
typedef struct _MediaMonitorClass MediaMonitorClass;
typedef struct _MediaMonitorPrivate MediaMonitorPrivate;

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;

#define TYPE_MEDIA_SOURCE_COLLECTION (media_source_collection_get_type ())
#define MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection))
#define MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))
#define IS_MEDIA_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE_COLLECTION))
#define IS_MEDIA_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE_COLLECTION))
#define MEDIA_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollectionClass))

typedef struct _MediaSourceCollection MediaSourceCollection;
typedef struct _MediaSourceCollectionClass MediaSourceCollectionClass;
typedef enum  {
	MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED,
	MEDIA_MONITOR_DISCOVERED_FILE_IGNORE,
	MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN
} MediaMonitorDiscoveredFile;

#define MEDIA_MONITOR_TYPE_DISCOVERED_FILE (media_monitor_discovered_file_get_type ())

#define TYPE_TRANSACTION_CONTROLLER (transaction_controller_get_type ())
#define TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionController))
#define TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))
#define IS_TRANSACTION_CONTROLLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TRANSACTION_CONTROLLER))
#define IS_TRANSACTION_CONTROLLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TRANSACTION_CONTROLLER))
#define TRANSACTION_CONTROLLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TRANSACTION_CONTROLLER, TransactionControllerClass))

typedef struct _TransactionController TransactionController;
typedef struct _TransactionControllerClass TransactionControllerClass;

#define TYPE_VIDEO_MONITOR (video_monitor_get_type ())
#define VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_MONITOR, VideoMonitor))
#define VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_MONITOR, VideoMonitorClass))
#define IS_VIDEO_MONITOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_MONITOR))
#define IS_VIDEO_MONITOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_MONITOR))
#define VIDEO_MONITOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_MONITOR, VideoMonitorClass))

typedef struct _VideoMonitor VideoMonitor;
typedef struct _VideoMonitorClass VideoMonitorClass;
typedef struct _VideoMonitorPrivate VideoMonitorPrivate;

#define TYPE_WORKERS (workers_get_type ())
#define WORKERS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORKERS, Workers))
#define WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORKERS, WorkersClass))
#define IS_WORKERS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORKERS))
#define IS_WORKERS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORKERS))
#define WORKERS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORKERS, WorkersClass))

typedef struct _Workers Workers;
typedef struct _WorkersClass WorkersClass;
enum  {
	VIDEO_MONITOR_0_PROPERTY,
	VIDEO_MONITOR_NUM_PROPERTIES
};
static GParamSpec* video_monitor_properties[VIDEO_MONITOR_NUM_PROPERTIES];
#define _workers_unref0(var) ((var == NULL) ? NULL : (var = (workers_unref (var), NULL)))

#define TYPE_VIDEO_SOURCE_COLLECTION (video_source_collection_get_type ())
#define VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollection))
#define VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))
#define IS_VIDEO_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_VIDEO_SOURCE_COLLECTION))
#define IS_VIDEO_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_VIDEO_SOURCE_COLLECTION))
#define VIDEO_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_VIDEO_SOURCE_COLLECTION, VideoSourceCollectionClass))

typedef struct _VideoSourceCollection VideoSourceCollection;
typedef struct _VideoSourceCollectionClass VideoSourceCollectionClass;
typedef enum  {
	VIDEO_SOURCE_COLLECTION_STATE_UNKNOWN,
	VIDEO_SOURCE_COLLECTION_STATE_ONLINE,
	VIDEO_SOURCE_COLLECTION_STATE_OFFLINE,
	VIDEO_SOURCE_COLLECTION_STATE_TRASH
} VideoSourceCollectionState;

#define VIDEO_SOURCE_COLLECTION_TYPE_STATE (video_source_collection_state_get_type ())
#define _monitorable_updates_unref0(var) ((var == NULL) ? NULL : (var = (monitorable_updates_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_BACKGROUND_JOB (background_job_get_type ())
#define BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BACKGROUND_JOB, BackgroundJob))
#define BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BACKGROUND_JOB, BackgroundJobClass))
#define IS_BACKGROUND_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BACKGROUND_JOB))
#define IS_BACKGROUND_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BACKGROUND_JOB))
#define BACKGROUND_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BACKGROUND_JOB, BackgroundJobClass))

typedef struct _BackgroundJob BackgroundJob;
typedef struct _BackgroundJobClass BackgroundJobClass;
typedef void (*CompletionCallback) (BackgroundJob* job, gpointer user_data);

#define VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB (video_monitor_video_interpretable_check_job_get_type ())
#define VIDEO_MONITOR_VIDEO_INTERPRETABLE_CHECK_JOB(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJob))
#define VIDEO_MONITOR_VIDEO_INTERPRETABLE_CHECK_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJobClass))
#define VIDEO_MONITOR_IS_VIDEO_INTERPRETABLE_CHECK_JOB(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB))
#define VIDEO_MONITOR_IS_VIDEO_INTERPRETABLE_CHECK_JOB_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB))
#define VIDEO_MONITOR_VIDEO_INTERPRETABLE_CHECK_JOB_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJobClass))

typedef struct _VideoMonitorVideoInterpretableCheckJob VideoMonitorVideoInterpretableCheckJob;
typedef struct _VideoMonitorVideoInterpretableCheckJobClass VideoMonitorVideoInterpretableCheckJobClass;
#define _background_job_unref0(var) ((var == NULL) ? NULL : (var = (background_job_unref (var), NULL)))
typedef struct _BackgroundJobPrivate BackgroundJobPrivate;
typedef enum  {
	BACKGROUND_JOB_JOB_PRIORITY_HIGHEST = 100,
	BACKGROUND_JOB_JOB_PRIORITY_HIGH = 75,
	BACKGROUND_JOB_JOB_PRIORITY_NORMAL = 50,
	BACKGROUND_JOB_JOB_PRIORITY_LOW = 25,
	BACKGROUND_JOB_JOB_PRIORITY_LOWEST = 0
} BackgroundJobJobPriority;

#define BACKGROUND_JOB_TYPE_JOB_PRIORITY (background_job_job_priority_get_type ())
typedef struct _VideoMonitorVideoInterpretableCheckJobPrivate VideoMonitorVideoInterpretableCheckJobPrivate;

#define VIDEO_TYPE_INTERPRETABLE_RESULTS (video_interpretable_results_get_type ())
#define VIDEO_INTERPRETABLE_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResults))
#define VIDEO_INTERPRETABLE_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResultsClass))
#define VIDEO_IS_INTERPRETABLE_RESULTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS))
#define VIDEO_IS_INTERPRETABLE_RESULTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), VIDEO_TYPE_INTERPRETABLE_RESULTS))
#define VIDEO_INTERPRETABLE_RESULTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), VIDEO_TYPE_INTERPRETABLE_RESULTS, VideoInterpretableResultsClass))

typedef struct _VideoInterpretableResults VideoInterpretableResults;
typedef struct _VideoInterpretableResultsClass VideoInterpretableResultsClass;
#define _video_interpretable_results_unref0(var) ((var == NULL) ? NULL : (var = (video_interpretable_results_unref (var), NULL)))
typedef void (*CancellationCallback) (BackgroundJob* job, gpointer user_data);

#define TYPE_ABSTRACT_SEMAPHORE (abstract_semaphore_get_type ())
#define ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphore))
#define ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))
#define IS_ABSTRACT_SEMAPHORE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ABSTRACT_SEMAPHORE))
#define IS_ABSTRACT_SEMAPHORE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ABSTRACT_SEMAPHORE))
#define ABSTRACT_SEMAPHORE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ABSTRACT_SEMAPHORE, AbstractSemaphoreClass))

typedef struct _AbstractSemaphore AbstractSemaphore;
typedef struct _AbstractSemaphoreClass AbstractSemaphoreClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MonitorableIface {
	GTypeInterface parent_iface;
	gboolean (*is_offline) (Monitorable* self);
	void (*mark_online) (Monitorable* self);
	void (*mark_offline) (Monitorable* self);
	void (*set_master_file) (Monitorable* self, GFile* file);
	void (*set_master_timestamp) (Monitorable* self, GFileInfo* info);
};

struct _MonitorableUpdates {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MonitorableUpdatesPrivate * priv;
	Monitorable* monitorable;
};

struct _MonitorableUpdatesClass {
	GTypeClass parent_class;
	void (*finalize) (MonitorableUpdates *self);
	gboolean (*is_in_alteration) (MonitorableUpdates* self);
	void (*set_master_file) (MonitorableUpdates* self, GFile* file);
	void (*set_master_file_info_altered) (MonitorableUpdates* self, gboolean altered);
	void (*set_master_file_info) (MonitorableUpdates* self, GFileInfo* info);
	void (*set_master_in_alteration) (MonitorableUpdates* self, gboolean in_alteration);
	void (*set_master_alterations_complete) (MonitorableUpdates* self, GFileInfo* info);
	void (*mark_offline) (MonitorableUpdates* self);
	void (*mark_online) (MonitorableUpdates* self);
	void (*reset_online_offline) (MonitorableUpdates* self);
	gboolean (*is_all_updated) (MonitorableUpdates* self);
};

struct _VideoUpdates {
	MonitorableUpdates parent_instance;
	VideoUpdatesPrivate * priv;
	Video* video;
};

struct _VideoUpdatesClass {
	MonitorableUpdatesClass parent_class;
	void (*set_check_interpretable) (VideoUpdates* self, gboolean check);
};

struct _VideoUpdatesPrivate {
	gboolean check_interpretable;
};

struct _MediaMonitor {
	GObject parent_instance;
	MediaMonitorPrivate * priv;
};

struct _MediaMonitorClass {
	GObjectClass parent_class;
	MediaSourceCollection* (*get_media_source_collection) (MediaMonitor* self);
	void (*close) (MediaMonitor* self);
	gchar* (*to_string) (MediaMonitor* self);
	MonitorableUpdates* (*create_updates) (MediaMonitor* self, Monitorable* monitorable);
	void (*on_media_source_destroyed) (MediaMonitor* self, DataSource* source);
	void (*notify_discovery_started) (MediaMonitor* self);
	MediaMonitorDiscoveredFile (*notify_file_discovered) (MediaMonitor* self, GFile* file, GFileInfo* info, Monitorable** monitorable);
	GeeCollection* (*candidates_for_unknown_file) (MediaMonitor* self, GFile* file, GFileInfo* info, MediaMonitorDiscoveredFile* _result_);
	GFile** (*get_auxilliary_backing_files) (MediaMonitor* self, Monitorable* monitorable, gint* result_length1);
	void (*update_backing_file_info) (MediaMonitor* self, Monitorable* monitorable, GFile* file, GFileInfo* info);
	void (*notify_discovery_completing) (MediaMonitor* self);
	gboolean (*is_file_represented) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_created) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_moved) (MediaMonitor* self, GFile* old_file, GFile* new_file, GFileInfo* new_file_info);
	gboolean (*notify_file_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_attributes_altered) (MediaMonitor* self, GFile* file);
	gboolean (*notify_file_alteration_completed) (MediaMonitor* self, GFile* file, GFileInfo* info);
	gboolean (*notify_file_deleted) (MediaMonitor* self, GFile* file);
	void (*process_updates) (MediaMonitor* self, GeeCollection* all_updates, TransactionController* controller, gint* op_count, GError** error);
};

struct _VideoMonitor {
	MediaMonitor parent_instance;
	VideoMonitorPrivate * priv;
};

struct _VideoMonitorClass {
	MediaMonitorClass parent_class;
};

struct _VideoMonitorPrivate {
	Workers* workers;
	guint64 background_jobs;
};

struct _BackgroundJob {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BackgroundJobPrivate * priv;
};

struct _BackgroundJobClass {
	GTypeClass parent_class;
	void (*finalize) (BackgroundJob *self);
	void (*execute) (BackgroundJob* self);
	BackgroundJobJobPriority (*get_priority) (BackgroundJob* self);
};

struct _VideoMonitorVideoInterpretableCheckJob {
	BackgroundJob parent_instance;
	VideoMonitorVideoInterpretableCheckJobPrivate * priv;
	Video* video;
	VideoInterpretableResults* results;
};

struct _VideoMonitorVideoInterpretableCheckJobClass {
	BackgroundJobClass parent_class;
};

static gint VideoUpdates_private_offset;
static gpointer video_updates_parent_class = NULL;
static gint VideoMonitor_private_offset;
static gpointer video_monitor_parent_class = NULL;
VALA_EXTERN VideoSourceCollection* video_global;
static gpointer video_monitor_video_interpretable_check_job_parent_class = NULL;

VALA_EXTERN gpointer monitorable_updates_ref (gpointer instance);
VALA_EXTERN void monitorable_updates_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_monitorable_updates (const gchar* name,
                                            const gchar* nick,
                                            const gchar* blurb,
                                            GType object_type,
                                            GParamFlags flags);
VALA_EXTERN void value_set_monitorable_updates (GValue* value,
                                    gpointer v_object);
VALA_EXTERN void value_take_monitorable_updates (GValue* value,
                                     gpointer v_object);
VALA_EXTERN gpointer value_get_monitorable_updates (const GValue* value);
VALA_EXTERN GType monitorable_updates_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MonitorableUpdates, monitorable_updates_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType monitorable_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Monitorable, g_object_unref)
VALA_EXTERN GType video_updates_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoUpdates, monitorable_updates_unref)
VALA_EXTERN GType video_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSource, g_object_unref)
VALA_EXTERN GType video_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Video, g_object_unref)
VALA_EXTERN void video_updates_set_check_interpretable (VideoUpdates* self,
                                            gboolean check);
VALA_EXTERN void monitorable_updates_mark_online (MonitorableUpdates* self);
VALA_EXTERN gboolean monitorable_updates_is_all_updated (MonitorableUpdates* self);
VALA_EXTERN VideoUpdates* video_updates_new (Video* video);
VALA_EXTERN VideoUpdates* video_updates_construct (GType object_type,
                                       Video* video);
VALA_EXTERN MonitorableUpdates* monitorable_updates_new (Monitorable* monitorable);
VALA_EXTERN MonitorableUpdates* monitorable_updates_construct (GType object_type,
                                                   Monitorable* monitorable);
static void video_updates_real_set_check_interpretable (VideoUpdates* self,
                                                 gboolean check);
static void video_updates_real_mark_online (MonitorableUpdates* base);
VALA_EXTERN gboolean video_updates_is_check_interpretable (VideoUpdates* self);
static gboolean video_updates_real_is_all_updated (MonitorableUpdates* base);
static void video_updates_finalize (MonitorableUpdates * obj);
static GType video_updates_get_type_once (void);
VALA_EXTERN GType media_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaMonitor, g_object_unref)
VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType media_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSourceCollection, data_collection_unref)
VALA_EXTERN GType media_monitor_discovered_file_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer transaction_controller_ref (gpointer instance);
VALA_EXTERN void transaction_controller_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_transaction_controller (const gchar* name,
                                               const gchar* nick,
                                               const gchar* blurb,
                                               GType object_type,
                                               GParamFlags flags);
VALA_EXTERN void value_set_transaction_controller (GValue* value,
                                       gpointer v_object);
VALA_EXTERN void value_take_transaction_controller (GValue* value,
                                        gpointer v_object);
VALA_EXTERN gpointer value_get_transaction_controller (const GValue* value);
VALA_EXTERN GType transaction_controller_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (TransactionController, transaction_controller_unref)
VALA_EXTERN GType video_monitor_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoMonitor, g_object_unref)
VALA_EXTERN gpointer workers_ref (gpointer instance);
VALA_EXTERN void workers_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_workers (const gchar* name,
                                const gchar* nick,
                                const gchar* blurb,
                                GType object_type,
                                GParamFlags flags);
VALA_EXTERN void value_set_workers (GValue* value,
                        gpointer v_object);
VALA_EXTERN void value_take_workers (GValue* value,
                         gpointer v_object);
VALA_EXTERN gpointer value_get_workers (const GValue* value);
VALA_EXTERN GType workers_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Workers, workers_unref)
VALA_EXTERN MonitorableUpdates* media_monitor_create_updates (MediaMonitor* self,
                                                  Monitorable* monitorable);
VALA_EXTERN MediaSourceCollection* media_monitor_get_media_source_collection (MediaMonitor* self);
VALA_EXTERN gboolean media_monitor_is_file_represented (MediaMonitor* self,
                                            GFile* file);
VALA_EXTERN MediaMonitorDiscoveredFile media_monitor_notify_file_discovered (MediaMonitor* self,
                                                                 GFile* file,
                                                                 GFileInfo* info,
                                                                 Monitorable** monitorable);
VALA_EXTERN GeeCollection* media_monitor_candidates_for_unknown_file (MediaMonitor* self,
                                                          GFile* file,
                                                          GFileInfo* info,
                                                          MediaMonitorDiscoveredFile* _result_);
VALA_EXTERN gboolean media_monitor_notify_file_created (MediaMonitor* self,
                                            GFile* file,
                                            GFileInfo* info);
VALA_EXTERN gboolean media_monitor_notify_file_moved (MediaMonitor* self,
                                          GFile* old_file,
                                          GFile* new_file,
                                          GFileInfo* new_file_info);
VALA_EXTERN gboolean media_monitor_notify_file_altered (MediaMonitor* self,
                                            GFile* file);
VALA_EXTERN gboolean media_monitor_notify_file_attributes_altered (MediaMonitor* self,
                                                       GFile* file);
VALA_EXTERN gboolean media_monitor_notify_file_alteration_completed (MediaMonitor* self,
                                                         GFile* file,
                                                         GFileInfo* info);
VALA_EXTERN gboolean media_monitor_notify_file_deleted (MediaMonitor* self,
                                            GFile* file);
VALA_EXTERN void media_monitor_process_updates (MediaMonitor* self,
                                    GeeCollection* all_updates,
                                    TransactionController* controller,
                                    gint* op_count,
                                    GError** error);
VALA_EXTERN Workers* workers_new (guint max_threads,
                      gboolean exclusive);
VALA_EXTERN Workers* workers_construct (GType object_type,
                            guint max_threads,
                            gboolean exclusive);
VALA_EXTERN VideoMonitor* video_monitor_new (GCancellable* cancellable);
VALA_EXTERN VideoMonitor* video_monitor_construct (GType object_type,
                                       GCancellable* cancellable);
VALA_EXTERN GType video_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoSourceCollection, data_collection_unref)
VALA_EXTERN MediaMonitor* media_monitor_construct (GType object_type,
                                       MediaSourceCollection* sources,
                                       GCancellable* cancellable);
VALA_EXTERN GeeCollection* data_collection_get_all (DataCollection* self);
VALA_EXTERN gboolean video_get_is_interpretable (Video* self);
VALA_EXTERN void video_monitor_set_check_interpretable (VideoMonitor* self,
                                            Video* video,
                                            gboolean check);
static MonitorableUpdates* video_monitor_real_create_updates (MediaMonitor* base,
                                                       Monitorable* monitorable);
static MediaSourceCollection* video_monitor_real_get_media_source_collection (MediaMonitor* base);
static gboolean video_monitor_real_is_file_represented (MediaMonitor* base,
                                                 GFile* file);
VALA_EXTERN GType video_source_collection_state_get_type (void) G_GNUC_CONST ;
static Video* video_monitor_get_state (VideoMonitor* self,
                                GFile* file,
                                VideoSourceCollectionState* state);
static MediaMonitorDiscoveredFile video_monitor_real_notify_file_discovered (MediaMonitor* base,
                                                                      GFile* file,
                                                                      GFileInfo* info,
                                                                      Monitorable** monitorable);
static GeeCollection* video_monitor_real_candidates_for_unknown_file (MediaMonitor* base,
                                                               GFile* file,
                                                               GFileInfo* info,
                                                               MediaMonitorDiscoveredFile* _result_);
VALA_EXTERN void video_source_collection_fetch_by_matching_backing (VideoSourceCollection* self,
                                                        GFileInfo* info,
                                                        GeeCollection* matching_master);
static gboolean video_monitor_real_notify_file_created (MediaMonitor* base,
                                                 GFile* file,
                                                 GFileInfo* info);
VALA_EXTERN void media_monitor_update_online (MediaMonitor* self,
                                  Monitorable* monitorable);
static gboolean video_monitor_real_notify_file_moved (MediaMonitor* base,
                                               GFile* old_file,
                                               GFile* new_file,
                                               GFileInfo* new_file_info);
VALA_EXTERN void media_monitor_update_master_file (MediaMonitor* self,
                                       Monitorable* monitorable,
                                       GFile* file);
VALA_EXTERN void media_monitor_update_offline (MediaMonitor* self,
                                   Monitorable* monitorable);
static gboolean video_monitor_real_notify_file_altered (MediaMonitor* base,
                                                 GFile* file);
static gboolean video_monitor_real_notify_file_attributes_altered (MediaMonitor* base,
                                                            GFile* file);
VALA_EXTERN void media_monitor_update_master_file_info_altered (MediaMonitor* self,
                                                    Monitorable* monitorable);
VALA_EXTERN void media_monitor_update_master_file_in_alteration (MediaMonitor* self,
                                                     Monitorable* monitorable,
                                                     gboolean in_alteration);
static gboolean video_monitor_real_notify_file_alteration_completed (MediaMonitor* base,
                                                              GFile* file,
                                                              GFileInfo* info);
VALA_EXTERN void media_monitor_update_master_file_alterations_completed (MediaMonitor* self,
                                                             Monitorable* monitorable,
                                                             GFileInfo* info);
static gboolean video_monitor_real_notify_file_deleted (MediaMonitor* base,
                                                 GFile* file);
VALA_EXTERN GeeCollection* media_monitor_get_monitorables (MediaMonitor* self);
VALA_EXTERN VideoUpdates* video_monitor_get_existing_video_updates (VideoMonitor* self,
                                                        Video* video);
VALA_EXTERN GFile* monitorable_updates_get_master_file (MonitorableUpdates* self);
VALA_EXTERN GFile* media_source_get_master_file (MediaSource* self);
VALA_EXTERN Video* video_source_collection_get_state_by_file (VideoSourceCollection* self,
                                                  GFile* file,
                                                  VideoSourceCollectionState* state);
VALA_EXTERN VideoUpdates* video_monitor_fetch_video_updates (VideoMonitor* self,
                                                 Video* video);
VALA_EXTERN MonitorableUpdates* media_monitor_fetch_updates (MediaMonitor* self,
                                                 Monitorable* monitorable);
VALA_EXTERN MonitorableUpdates* media_monitor_get_existing_updates (MediaMonitor* self,
                                                        Monitorable* monitorable);
static void video_monitor_real_process_updates (MediaMonitor* base,
                                         GeeCollection* all_updates,
                                         TransactionController* controller,
                                         gint* op_count,
                                         GError** error);
VALA_EXTERN void media_monitor_mdbg (const gchar* msg);
VALA_EXTERN void video_notify_offline_thumbs_regenerated (void);
VALA_EXTERN gpointer background_job_ref (gpointer instance);
VALA_EXTERN void background_job_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_background_job (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_background_job (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_background_job (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_background_job (const GValue* value);
VALA_EXTERN GType background_job_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (BackgroundJob, background_job_unref)
VALA_EXTERN void workers_enqueue (Workers* self,
                      BackgroundJob* job);
static void video_monitor_on_interpretable_check_complete (VideoMonitor* self,
                                                    BackgroundJob* j);
static void _video_monitor_on_interpretable_check_complete_completion_callback (BackgroundJob* job,
                                                                         gpointer self);
static VideoMonitorVideoInterpretableCheckJob* video_monitor_video_interpretable_check_job_new (Video* video,
                                                                                         CompletionCallback callback,
                                                                                         gpointer callback_target);
static VideoMonitorVideoInterpretableCheckJob* video_monitor_video_interpretable_check_job_construct (GType object_type,
                                                                                               Video* video,
                                                                                               CompletionCallback callback,
                                                                                               gpointer callback_target);
static GType video_monitor_video_interpretable_check_job_get_type (void) G_GNUC_CONST  G_GNUC_UNUSED ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoMonitorVideoInterpretableCheckJob, background_job_unref)
VALA_EXTERN GType background_job_job_priority_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gpointer video_interpretable_results_ref (gpointer instance);
VALA_EXTERN void video_interpretable_results_unref (gpointer instance);
VALA_EXTERN GParamSpec* video_param_spec_interpretable_results (const gchar* name,
                                                    const gchar* nick,
                                                    const gchar* blurb,
                                                    GType object_type,
                                                    GParamFlags flags);
VALA_EXTERN void video_value_set_interpretable_results (GValue* value,
                                            gpointer v_object);
VALA_EXTERN void video_value_take_interpretable_results (GValue* value,
                                             gpointer v_object);
VALA_EXTERN gpointer video_value_get_interpretable_results (const GValue* value);
VALA_EXTERN GType video_interpretable_results_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (VideoInterpretableResults, video_interpretable_results_unref)
VALA_EXTERN void video_interpretable_results_foreground_finish (VideoInterpretableResults* self);
VALA_EXTERN void video_notify_normal_thumbs_regenerated (void);
VALA_EXTERN void background_job_execute (BackgroundJob* self);
VALA_EXTERN gpointer abstract_semaphore_ref (gpointer instance);
VALA_EXTERN void abstract_semaphore_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_abstract_semaphore (const gchar* name,
                                           const gchar* nick,
                                           const gchar* blurb,
                                           GType object_type,
                                           GParamFlags flags);
VALA_EXTERN void value_set_abstract_semaphore (GValue* value,
                                   gpointer v_object);
VALA_EXTERN void value_take_abstract_semaphore (GValue* value,
                                    gpointer v_object);
VALA_EXTERN gpointer value_get_abstract_semaphore (const GValue* value);
VALA_EXTERN GType abstract_semaphore_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AbstractSemaphore, abstract_semaphore_unref)
VALA_EXTERN BackgroundJob* background_job_construct (GType object_type,
                                         GObject* owner,
                                         CompletionCallback callback,
                                         gpointer callback_target,
                                         GCancellable* cancellable,
                                         CancellationCallback cancellation,
                                         gpointer cancellation_target,
                                         AbstractSemaphore* completion_semaphore);
static void video_monitor_video_interpretable_check_job_real_execute (BackgroundJob* base);
VALA_EXTERN VideoInterpretableResults* video_check_is_interpretable (Video* self);
static void video_monitor_video_interpretable_check_job_finalize (BackgroundJob * obj);
static GType video_monitor_video_interpretable_check_job_get_type_once (void);
static void video_monitor_finalize (GObject * obj);
static GType video_monitor_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
video_updates_get_instance_private (VideoUpdates* self)
{
	return G_STRUCT_MEMBER_P (self, VideoUpdates_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

VideoUpdates*
video_updates_construct (GType object_type,
                         Video* video)
{
	VideoUpdates* self = NULL;
	Video* _tmp0_;
	g_return_val_if_fail (IS_VIDEO (video), NULL);
	self = (VideoUpdates*) monitorable_updates_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (video, TYPE_MONITORABLE, Monitorable));
	_tmp0_ = _g_object_ref0 (video);
	_g_object_unref0 (self->video);
	self->video = _tmp0_;
	return self;
}

VideoUpdates*
video_updates_new (Video* video)
{
	return video_updates_construct (TYPE_VIDEO_UPDATES, video);
}

static void
video_updates_real_set_check_interpretable (VideoUpdates* self,
                                            gboolean check)
{
	self->priv->check_interpretable = check;
}

void
video_updates_set_check_interpretable (VideoUpdates* self,
                                       gboolean check)
{
	VideoUpdatesClass* _klass_;
	g_return_if_fail (IS_VIDEO_UPDATES (self));
	_klass_ = VIDEO_UPDATES_GET_CLASS (self);
	if (_klass_->set_check_interpretable) {
		_klass_->set_check_interpretable (self, check);
	}
}

static void
video_updates_real_mark_online (MonitorableUpdates* base)
{
	VideoUpdates * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_UPDATES, VideoUpdates);
	MONITORABLE_UPDATES_CLASS (video_updates_parent_class)->mark_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
	video_updates_set_check_interpretable (self, TRUE);
}

gboolean
video_updates_is_check_interpretable (VideoUpdates* self)
{
	gboolean result;
	g_return_val_if_fail (IS_VIDEO_UPDATES (self), FALSE);
	result = self->priv->check_interpretable;
	return result;
}

static gboolean
video_updates_real_is_all_updated (MonitorableUpdates* base)
{
	VideoUpdates * self;
	gboolean _tmp0_ = FALSE;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_UPDATES, VideoUpdates);
	if (self->priv->check_interpretable == FALSE) {
		_tmp0_ = MONITORABLE_UPDATES_CLASS (video_updates_parent_class)->is_all_updated (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
	} else {
		_tmp0_ = FALSE;
	}
	result = _tmp0_;
	return result;
}

static void
video_updates_class_init (VideoUpdatesClass * klass,
                          gpointer klass_data)
{
	video_updates_parent_class = g_type_class_peek_parent (klass);
	((MonitorableUpdatesClass *) klass)->finalize = video_updates_finalize;
	g_type_class_adjust_private_offset (klass, &VideoUpdates_private_offset);
	((VideoUpdatesClass *) klass)->set_check_interpretable = (void (*) (VideoUpdates*, gboolean)) video_updates_real_set_check_interpretable;
	((MonitorableUpdatesClass *) klass)->mark_online = (void (*) (MonitorableUpdates*)) video_updates_real_mark_online;
	((MonitorableUpdatesClass *) klass)->is_all_updated = (gboolean (*) (MonitorableUpdates*)) video_updates_real_is_all_updated;
}

static void
video_updates_instance_init (VideoUpdates * self,
                             gpointer klass)
{
	self->priv = video_updates_get_instance_private (self);
	self->priv->check_interpretable = FALSE;
}

static void
video_updates_finalize (MonitorableUpdates * obj)
{
	VideoUpdates * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_UPDATES, VideoUpdates);
	_g_object_unref0 (self->video);
	MONITORABLE_UPDATES_CLASS (video_updates_parent_class)->finalize (obj);
}

static GType
video_updates_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoUpdatesClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_updates_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoUpdates), 0, (GInstanceInitFunc) video_updates_instance_init, NULL };
	GType video_updates_type_id;
	video_updates_type_id = g_type_register_static (TYPE_MONITORABLE_UPDATES, "VideoUpdates", &g_define_type_info, 0);
	VideoUpdates_private_offset = g_type_add_instance_private (video_updates_type_id, sizeof (VideoUpdatesPrivate));
	return video_updates_type_id;
}

GType
video_updates_get_type (void)
{
	static volatile gsize video_updates_type_id__once = 0;
	if (g_once_init_enter (&video_updates_type_id__once)) {
		GType video_updates_type_id;
		video_updates_type_id = video_updates_get_type_once ();
		g_once_init_leave (&video_updates_type_id__once, video_updates_type_id);
	}
	return video_updates_type_id__once;
}

static inline gpointer
video_monitor_get_instance_private (VideoMonitor* self)
{
	return G_STRUCT_MEMBER_P (self, VideoMonitor_private_offset);
}

VideoMonitor*
video_monitor_construct (GType object_type,
                         GCancellable* cancellable)
{
	VideoMonitor * self = NULL;
	VideoSourceCollection* _tmp0_;
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (cancellable, g_cancellable_get_type ()), NULL);
	_tmp0_ = video_global;
	self = (VideoMonitor*) media_monitor_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection), cancellable);
	{
		GeeIterator* _obj_it = NULL;
		VideoSourceCollection* _tmp1_;
		GeeCollection* _tmp2_;
		GeeCollection* _tmp3_;
		GeeIterator* _tmp4_;
		GeeIterator* _tmp5_;
		_tmp1_ = video_global;
		_tmp2_ = data_collection_get_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, TYPE_DATA_COLLECTION, DataCollection));
		_tmp3_ = _tmp2_;
		_tmp4_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp5_ = _tmp4_;
		_g_object_unref0 (_tmp3_);
		_obj_it = _tmp5_;
		while (TRUE) {
			GeeIterator* _tmp6_;
			DataObject* obj = NULL;
			GeeIterator* _tmp7_;
			gpointer _tmp8_;
			Video* video = NULL;
			DataObject* _tmp9_;
			Video* _tmp10_;
			Video* _tmp11_;
			Video* _tmp12_;
			_tmp6_ = _obj_it;
			if (!gee_iterator_next (_tmp6_)) {
				break;
			}
			_tmp7_ = _obj_it;
			_tmp8_ = gee_iterator_get (_tmp7_);
			obj = (DataObject*) _tmp8_;
			_tmp9_ = obj;
			_tmp10_ = _g_object_ref0 (IS_VIDEO (_tmp9_) ? ((Video*) _tmp9_) : NULL);
			video = _tmp10_;
			_tmp11_ = video;
			_vala_assert (_tmp11_ != NULL, "video != null");
			_tmp12_ = video;
			if (!video_get_is_interpretable (_tmp12_)) {
				Video* _tmp13_;
				_tmp13_ = video;
				video_monitor_set_check_interpretable (self, _tmp13_, TRUE);
			}
			_g_object_unref0 (video);
			_g_object_unref0 (obj);
		}
		_g_object_unref0 (_obj_it);
	}
	return self;
}

VideoMonitor*
video_monitor_new (GCancellable* cancellable)
{
	return video_monitor_construct (TYPE_VIDEO_MONITOR, cancellable);
}

static MonitorableUpdates*
video_monitor_real_create_updates (MediaMonitor* base,
                                   Monitorable* monitorable)
{
	VideoMonitor * self;
	VideoUpdates* _tmp0_;
	MonitorableUpdates* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
	g_return_val_if_fail (IS_MONITORABLE (monitorable), NULL);
	_vala_assert (IS_VIDEO (monitorable), "monitorable is Video");
	_tmp0_ = video_updates_new (G_TYPE_CHECK_INSTANCE_CAST (monitorable, TYPE_VIDEO, Video));
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates);
	return result;
}

static gpointer
_data_collection_ref0 (gpointer self)
{
	return self ? data_collection_ref (self) : NULL;
}

static MediaSourceCollection*
video_monitor_real_get_media_source_collection (MediaMonitor* base)
{
	VideoMonitor * self;
	VideoSourceCollection* _tmp0_;
	MediaSourceCollection* _tmp1_;
	MediaSourceCollection* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
	_tmp0_ = video_global;
	_tmp1_ = _data_collection_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_MEDIA_SOURCE_COLLECTION, MediaSourceCollection));
	result = _tmp1_;
	return result;
}

static gboolean
video_monitor_real_is_file_represented (MediaMonitor* base,
                                        GFile* file)
{
	VideoMonitor * self;
	VideoSourceCollectionState state = 0;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static MediaMonitorDiscoveredFile
video_monitor_real_notify_file_discovered (MediaMonitor* base,
                                           GFile* file,
                                           GFileInfo* info,
                                           Monitorable** monitorable)
{
	VideoMonitor * self;
	Monitorable* _vala_monitorable = NULL;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	MediaMonitorDiscoveredFile result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), 0);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), 0);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	video = _tmp1_;
	_tmp2_ = video;
	if (_tmp2_ == NULL) {
		_g_object_unref0 (_vala_monitorable);
		_vala_monitorable = NULL;
		result = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
		_g_object_unref0 (video);
		if (monitorable) {
			*monitorable = _vala_monitorable;
		} else {
			_g_object_unref0 (_vala_monitorable);
		}
		return result;
	}
	switch (state) {
		case VIDEO_SOURCE_COLLECTION_STATE_ONLINE:
		case VIDEO_SOURCE_COLLECTION_STATE_OFFLINE:
		{
			Video* _tmp3_;
			Monitorable* _tmp4_;
			_tmp3_ = video;
			_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MONITORABLE, Monitorable));
			_g_object_unref0 (_vala_monitorable);
			_vala_monitorable = _tmp4_;
			result = MEDIA_MONITOR_DISCOVERED_FILE_REPRESENTED;
			_g_object_unref0 (video);
			if (monitorable) {
				*monitorable = _vala_monitorable;
			} else {
				_g_object_unref0 (_vala_monitorable);
			}
			return result;
		}
		default:
		case VIDEO_SOURCE_COLLECTION_STATE_TRASH:
		{
			_g_object_unref0 (_vala_monitorable);
			_vala_monitorable = NULL;
			result = MEDIA_MONITOR_DISCOVERED_FILE_IGNORE;
			_g_object_unref0 (video);
			if (monitorable) {
				*monitorable = _vala_monitorable;
			} else {
				_g_object_unref0 (_vala_monitorable);
			}
			return result;
		}
	}
}

static GeeCollection*
video_monitor_real_candidates_for_unknown_file (MediaMonitor* base,
                                                GFile* file,
                                                GFileInfo* info,
                                                MediaMonitorDiscoveredFile* _result_)
{
	VideoMonitor * self;
	MediaMonitorDiscoveredFile _vala__result_ = 0;
	GeeCollection* matched = NULL;
	GeeArrayList* _tmp0_;
	VideoSourceCollection* _tmp1_;
	GeeCollection* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), NULL);
	_tmp0_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	matched = G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection);
	_tmp1_ = video_global;
	video_source_collection_fetch_by_matching_backing (_tmp1_, info, matched);
	_vala__result_ = MEDIA_MONITOR_DISCOVERED_FILE_UNKNOWN;
	result = matched;
	if (_result_) {
		*_result_ = _vala__result_;
	}
	return result;
}

static gboolean
video_monitor_real_notify_file_created (MediaMonitor* base,
                                        GFile* file,
                                        GFileInfo* info)
{
	VideoMonitor * self;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	Video* _tmp3_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	video = _tmp1_;
	_tmp2_ = video;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (video);
		return result;
	}
	_tmp3_ = video;
	media_monitor_update_online (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MONITORABLE, Monitorable));
	result = TRUE;
	_g_object_unref0 (video);
	return result;
}

static gboolean
video_monitor_real_notify_file_moved (MediaMonitor* base,
                                      GFile* old_file,
                                      GFile* new_file,
                                      GFileInfo* new_file_info)
{
	VideoMonitor * self;
	VideoSourceCollectionState old_state = 0;
	Video* old_video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	VideoSourceCollectionState new_state = 0;
	Video* new_video = NULL;
	VideoSourceCollectionState _tmp2_ = 0;
	Video* _tmp3_;
	gboolean _tmp4_ = FALSE;
	Video* _tmp5_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (old_file, g_file_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file, g_file_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (new_file_info, g_file_info_get_type ()), FALSE);
	_tmp1_ = video_monitor_get_state (self, old_file, &_tmp0_);
	old_state = _tmp0_;
	old_video = _tmp1_;
	_tmp3_ = video_monitor_get_state (self, new_file, &_tmp2_);
	new_state = _tmp2_;
	new_video = _tmp3_;
	_tmp5_ = old_video;
	if (_tmp5_ != NULL) {
		Video* _tmp6_;
		_tmp6_ = new_video;
		_tmp4_ = _tmp6_ == NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		Video* _tmp7_;
		_tmp7_ = old_video;
		media_monitor_update_master_file (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_MONITORABLE, Monitorable), new_file);
	} else {
		gboolean _tmp8_ = FALSE;
		Video* _tmp9_;
		_tmp9_ = old_video;
		if (_tmp9_ == NULL) {
			Video* _tmp10_;
			_tmp10_ = new_video;
			_tmp8_ = _tmp10_ != NULL;
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			Video* _tmp11_;
			_tmp11_ = new_video;
			video_monitor_set_check_interpretable (self, _tmp11_, TRUE);
		} else {
			gboolean _tmp12_ = FALSE;
			Video* _tmp13_;
			_tmp13_ = old_video;
			if (_tmp13_ == NULL) {
				Video* _tmp14_;
				_tmp14_ = new_video;
				_tmp12_ = _tmp14_ == NULL;
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				result = FALSE;
				_g_object_unref0 (new_video);
				_g_object_unref0 (old_video);
				return result;
			} else {
				gboolean _tmp15_ = FALSE;
				Video* _tmp16_;
				Video* _tmp18_;
				Video* _tmp19_;
				_tmp16_ = old_video;
				if (_tmp16_ != NULL) {
					Video* _tmp17_;
					_tmp17_ = new_video;
					_tmp15_ = _tmp17_ != NULL;
				} else {
					_tmp15_ = FALSE;
				}
				_vala_assert (_tmp15_, "old_video != null && new_video != null");
				_tmp18_ = old_video;
				media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp18_, TYPE_MONITORABLE, Monitorable));
				_tmp19_ = new_video;
				video_monitor_set_check_interpretable (self, _tmp19_, TRUE);
			}
		}
	}
	result = TRUE;
	_g_object_unref0 (new_video);
	_g_object_unref0 (old_video);
	return result;
}

static gboolean
video_monitor_real_notify_file_altered (MediaMonitor* base,
                                        GFile* file)
{
	VideoMonitor * self;
	VideoSourceCollectionState state = 0;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	gboolean _tmp3_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_ != NULL;
	_g_object_unref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

static gboolean
video_monitor_real_notify_file_attributes_altered (MediaMonitor* base,
                                                   GFile* file)
{
	VideoMonitor * self;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	Video* _tmp3_;
	Video* _tmp4_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	video = _tmp1_;
	_tmp2_ = video;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (video);
		return result;
	}
	_tmp3_ = video;
	media_monitor_update_master_file_info_altered (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MONITORABLE, Monitorable));
	_tmp4_ = video;
	media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MONITORABLE, Monitorable), TRUE);
	result = TRUE;
	_g_object_unref0 (video);
	return result;
}

static gboolean
video_monitor_real_notify_file_alteration_completed (MediaMonitor* base,
                                                     GFile* file,
                                                     GFileInfo* info)
{
	VideoMonitor * self;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	Video* _tmp3_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (info, g_file_info_get_type ()), FALSE);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	video = _tmp1_;
	_tmp2_ = video;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (video);
		return result;
	}
	_tmp3_ = video;
	media_monitor_update_master_file_alterations_completed (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MONITORABLE, Monitorable), info);
	result = TRUE;
	_g_object_unref0 (video);
	return result;
}

static gboolean
video_monitor_real_notify_file_deleted (MediaMonitor* base,
                                        GFile* file)
{
	VideoMonitor * self;
	VideoSourceCollectionState state = 0;
	Video* video = NULL;
	VideoSourceCollectionState _tmp0_ = 0;
	Video* _tmp1_;
	Video* _tmp2_;
	Video* _tmp3_;
	Video* _tmp4_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), FALSE);
	_tmp1_ = video_monitor_get_state (self, file, &_tmp0_);
	state = _tmp0_;
	video = _tmp1_;
	_tmp2_ = video;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (video);
		return result;
	}
	_tmp3_ = video;
	media_monitor_update_master_file_in_alteration (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, TYPE_MONITORABLE, Monitorable), FALSE);
	_tmp4_ = video;
	media_monitor_update_offline (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (_tmp4_, TYPE_MONITORABLE, Monitorable));
	result = TRUE;
	_g_object_unref0 (video);
	return result;
}

static Video*
video_monitor_get_state (VideoMonitor* self,
                         GFile* file,
                         VideoSourceCollectionState* state)
{
	VideoSourceCollectionState _vala_state = 0;
	GFile* real_file = NULL;
	GFile* _tmp22_ = NULL;
	GFile* _tmp23_;
	VideoSourceCollection* _tmp24_;
	VideoSourceCollectionState _tmp25_ = 0;
	Video* _tmp26_;
	Video* result;
	g_return_val_if_fail (IS_VIDEO_MONITOR (self), NULL);
	g_return_val_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (file, g_file_get_type ()), NULL);
	real_file = NULL;
	{
		GeeIterator* _monitorable_it = NULL;
		GeeCollection* _tmp0_;
		GeeCollection* _tmp1_;
		GeeIterator* _tmp2_;
		GeeIterator* _tmp3_;
		_tmp0_ = media_monitor_get_monitorables (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor));
		_tmp1_ = _tmp0_;
		_tmp2_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp3_ = _tmp2_;
		_g_object_unref0 (_tmp1_);
		_monitorable_it = _tmp3_;
		while (TRUE) {
			GeeIterator* _tmp4_;
			Monitorable* monitorable = NULL;
			GeeIterator* _tmp5_;
			gpointer _tmp6_;
			Video* video = NULL;
			Monitorable* _tmp7_;
			Video* _tmp8_;
			VideoUpdates* updates = NULL;
			Video* _tmp9_;
			VideoUpdates* _tmp10_;
			VideoUpdates* _tmp11_;
			gboolean _tmp12_ = FALSE;
			VideoUpdates* _tmp13_;
			GFile* _tmp14_;
			GFile* _tmp15_;
			gboolean _tmp16_;
			_tmp4_ = _monitorable_it;
			if (!gee_iterator_next (_tmp4_)) {
				break;
			}
			_tmp5_ = _monitorable_it;
			_tmp6_ = gee_iterator_get (_tmp5_);
			monitorable = (Monitorable*) _tmp6_;
			_tmp7_ = monitorable;
			_tmp8_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_VIDEO, Video));
			video = _tmp8_;
			_tmp9_ = video;
			_tmp10_ = video_monitor_get_existing_video_updates (self, _tmp9_);
			updates = _tmp10_;
			_tmp11_ = updates;
			if (_tmp11_ == NULL) {
				_monitorable_updates_unref0 (updates);
				_g_object_unref0 (video);
				_g_object_unref0 (monitorable);
				continue;
			}
			_tmp13_ = updates;
			_tmp14_ = monitorable_updates_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
			_tmp15_ = _tmp14_;
			_tmp16_ = _tmp15_ != NULL;
			_g_object_unref0 (_tmp15_);
			if (_tmp16_) {
				VideoUpdates* _tmp17_;
				GFile* _tmp18_;
				GFile* _tmp19_;
				_tmp17_ = updates;
				_tmp18_ = monitorable_updates_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, TYPE_MONITORABLE_UPDATES, MonitorableUpdates));
				_tmp19_ = _tmp18_;
				_tmp12_ = g_file_equal (_tmp19_, file);
				_g_object_unref0 (_tmp19_);
			} else {
				_tmp12_ = FALSE;
			}
			if (_tmp12_) {
				Video* _tmp20_;
				GFile* _tmp21_;
				_tmp20_ = video;
				_tmp21_ = media_source_get_master_file (G_TYPE_CHECK_INSTANCE_CAST (_tmp20_, TYPE_MEDIA_SOURCE, MediaSource));
				_g_object_unref0 (real_file);
				real_file = _tmp21_;
				_monitorable_updates_unref0 (updates);
				_g_object_unref0 (video);
				_g_object_unref0 (monitorable);
				break;
			}
			_monitorable_updates_unref0 (updates);
			_g_object_unref0 (video);
			_g_object_unref0 (monitorable);
		}
		_g_object_unref0 (_monitorable_it);
	}
	_tmp23_ = real_file;
	_tmp22_ = _tmp23_;
	if (_tmp22_ == NULL) {
		_tmp22_ = file;
	}
	_tmp24_ = video_global;
	_tmp26_ = video_source_collection_get_state_by_file (_tmp24_, _tmp22_, &_tmp25_);
	_vala_state = _tmp25_;
	result = _tmp26_;
	_g_object_unref0 (real_file);
	if (state) {
		*state = _vala_state;
	}
	return result;
}

VideoUpdates*
video_monitor_fetch_video_updates (VideoMonitor* self,
                                   Video* video)
{
	VideoUpdates* updates = NULL;
	MonitorableUpdates* _tmp0_;
	VideoUpdates* _tmp1_;
	VideoUpdates* result;
	g_return_val_if_fail (IS_VIDEO_MONITOR (self), NULL);
	g_return_val_if_fail (IS_VIDEO (video), NULL);
	_tmp0_ = media_monitor_fetch_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (video, TYPE_MONITORABLE, Monitorable));
	_tmp1_ = IS_VIDEO_UPDATES (_tmp0_) ? ((VideoUpdates*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_monitorable_updates_unref0 (_tmp0_);
	}
	updates = _tmp1_;
	_vala_assert (updates != NULL, "updates != null");
	result = updates;
	return result;
}

VideoUpdates*
video_monitor_get_existing_video_updates (VideoMonitor* self,
                                          Video* video)
{
	MonitorableUpdates* _tmp0_;
	VideoUpdates* _tmp1_;
	VideoUpdates* result;
	g_return_val_if_fail (IS_VIDEO_MONITOR (self), NULL);
	g_return_val_if_fail (IS_VIDEO (video), NULL);
	_tmp0_ = media_monitor_get_existing_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), G_TYPE_CHECK_INSTANCE_CAST (video, TYPE_MONITORABLE, Monitorable));
	_tmp1_ = IS_VIDEO_UPDATES (_tmp0_) ? ((VideoUpdates*) _tmp0_) : NULL;
	if (_tmp1_ == NULL) {
		_monitorable_updates_unref0 (_tmp0_);
	}
	result = _tmp1_;
	return result;
}

void
video_monitor_set_check_interpretable (VideoMonitor* self,
                                       Video* video,
                                       gboolean check)
{
	VideoUpdates* _tmp0_;
	VideoUpdates* _tmp1_;
	g_return_if_fail (IS_VIDEO_MONITOR (self));
	g_return_if_fail (IS_VIDEO (video));
	_tmp0_ = video_monitor_fetch_video_updates (self, video);
	_tmp1_ = _tmp0_;
	video_updates_set_check_interpretable (_tmp1_, check);
	_monitorable_updates_unref0 (_tmp1_);
}

static gpointer
_monitorable_updates_ref0 (gpointer self)
{
	return self ? monitorable_updates_ref (self) : NULL;
}

static void
_video_monitor_on_interpretable_check_complete_completion_callback (BackgroundJob* job,
                                                                    gpointer self)
{
	video_monitor_on_interpretable_check_complete ((VideoMonitor*) self, job);
}

static void
video_monitor_real_process_updates (MediaMonitor* base,
                                    GeeCollection* all_updates,
                                    TransactionController* controller,
                                    gint* op_count,
                                    GError** error)
{
	VideoMonitor * self;
	GeeArrayList* check = NULL;
	GeeArrayList* _tmp20_;
	GError* _inner_error0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_VIDEO_MONITOR, VideoMonitor);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (all_updates, GEE_TYPE_COLLECTION));
	g_return_if_fail (IS_TRANSACTION_CONTROLLER (controller));
	MEDIA_MONITOR_CLASS (video_monitor_parent_class)->process_updates (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_MEDIA_MONITOR, MediaMonitor), all_updates, controller, op_count, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_propagate_error (error, _inner_error0_);
		return;
	}
	check = NULL;
	{
		GeeIterator* _monitorable_updates_it = NULL;
		GeeIterator* _tmp0_;
		_tmp0_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (all_updates, GEE_TYPE_ITERABLE, GeeIterable));
		_monitorable_updates_it = _tmp0_;
		while (TRUE) {
			GeeIterator* _tmp1_;
			MonitorableUpdates* monitorable_updates = NULL;
			GeeIterator* _tmp2_;
			gpointer _tmp3_;
			gboolean _tmp4_ = FALSE;
			GeeArrayList* _tmp5_;
			VideoUpdates* updates = NULL;
			MonitorableUpdates* _tmp9_;
			VideoUpdates* _tmp10_;
			VideoUpdates* _tmp11_;
			VideoUpdates* _tmp12_;
			_tmp1_ = _monitorable_updates_it;
			if (!gee_iterator_next (_tmp1_)) {
				break;
			}
			_tmp2_ = _monitorable_updates_it;
			_tmp3_ = gee_iterator_get (_tmp2_);
			monitorable_updates = (MonitorableUpdates*) _tmp3_;
			if ((*op_count) >= MEDIA_MONITOR_MAX_OPERATIONS_PER_CYCLE) {
				_monitorable_updates_unref0 (monitorable_updates);
				break;
			}
			_tmp5_ = check;
			if (_tmp5_ != NULL) {
				GeeArrayList* _tmp6_;
				gint _tmp7_;
				gint _tmp8_;
				_tmp6_ = check;
				_tmp7_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
				_tmp8_ = _tmp7_;
				_tmp4_ = _tmp8_ >= VIDEO_MONITOR_MAX_INTERPRETABLE_CHECKS_PER_CYCLE;
			} else {
				_tmp4_ = FALSE;
			}
			if (_tmp4_) {
				_monitorable_updates_unref0 (monitorable_updates);
				break;
			}
			_tmp9_ = monitorable_updates;
			_tmp10_ = _monitorable_updates_ref0 (IS_VIDEO_UPDATES (_tmp9_) ? ((VideoUpdates*) _tmp9_) : NULL);
			updates = _tmp10_;
			_tmp11_ = updates;
			if (_tmp11_ == NULL) {
				_monitorable_updates_unref0 (updates);
				_monitorable_updates_unref0 (monitorable_updates);
				continue;
			}
			_tmp12_ = updates;
			if (video_updates_is_check_interpretable (_tmp12_)) {
				GeeArrayList* _tmp13_;
				GeeArrayList* _tmp15_;
				VideoUpdates* _tmp16_;
				Video* _tmp17_;
				VideoUpdates* _tmp18_;
				gint _tmp19_;
				_tmp13_ = check;
				if (_tmp13_ == NULL) {
					GeeArrayList* _tmp14_;
					_tmp14_ = gee_array_list_new (TYPE_VIDEO, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
					_g_object_unref0 (check);
					check = _tmp14_;
				}
				_tmp15_ = check;
				_tmp16_ = updates;
				_tmp17_ = _tmp16_->video;
				gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), _tmp17_);
				_tmp18_ = updates;
				video_updates_set_check_interpretable (_tmp18_, FALSE);
				_tmp19_ = *op_count;
				*op_count = _tmp19_ + 1;
			}
			_monitorable_updates_unref0 (updates);
			_monitorable_updates_unref0 (monitorable_updates);
		}
		_g_object_unref0 (_monitorable_updates_it);
	}
	_tmp20_ = check;
	if (_tmp20_ != NULL) {
		GeeArrayList* _tmp21_;
		gint _tmp22_;
		gint _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		GeeArrayList* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp21_ = check;
		_tmp22_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp21_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strdup_printf ("Checking interpretable for %d videos", _tmp23_);
		_tmp25_ = _tmp24_;
		media_monitor_mdbg (_tmp25_);
		_g_free0 (_tmp25_);
		video_notify_offline_thumbs_regenerated ();
		_tmp26_ = check;
		_tmp27_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_tmp28_ = _tmp27_;
		self->priv->background_jobs = self->priv->background_jobs + _tmp28_;
		{
			GeeArrayList* _video_list = NULL;
			GeeArrayList* _tmp29_;
			gint _video_size = 0;
			GeeArrayList* _tmp30_;
			gint _tmp31_;
			gint _tmp32_;
			gint _video_index = 0;
			_tmp29_ = check;
			_video_list = _tmp29_;
			_tmp30_ = _video_list;
			_tmp31_ = gee_abstract_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp30_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
			_tmp32_ = _tmp31_;
			_video_size = _tmp32_;
			_video_index = -1;
			while (TRUE) {
				gint _tmp33_;
				gint _tmp34_;
				Video* video = NULL;
				GeeArrayList* _tmp35_;
				gpointer _tmp36_;
				Workers* _tmp37_;
				Video* _tmp38_;
				VideoMonitorVideoInterpretableCheckJob* _tmp39_;
				VideoMonitorVideoInterpretableCheckJob* _tmp40_;
				_video_index = _video_index + 1;
				_tmp33_ = _video_index;
				_tmp34_ = _video_size;
				if (!(_tmp33_ < _tmp34_)) {
					break;
				}
				_tmp35_ = _video_list;
				_tmp36_ = gee_abstract_list_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ABSTRACT_LIST, GeeAbstractList), _video_index);
				video = (Video*) _tmp36_;
				_tmp37_ = self->priv->workers;
				_tmp38_ = video;
				_tmp39_ = video_monitor_video_interpretable_check_job_new (_tmp38_, _video_monitor_on_interpretable_check_complete_completion_callback, self);
				_tmp40_ = _tmp39_;
				workers_enqueue (_tmp37_, G_TYPE_CHECK_INSTANCE_CAST (_tmp40_, TYPE_BACKGROUND_JOB, BackgroundJob));
				_background_job_unref0 (_tmp40_);
				_g_object_unref0 (video);
			}
		}
	}
	_g_object_unref0 (check);
}

static gpointer
_background_job_ref0 (gpointer self)
{
	return self ? background_job_ref (self) : NULL;
}

static void
video_monitor_on_interpretable_check_complete (VideoMonitor* self,
                                               BackgroundJob* j)
{
	VideoMonitorVideoInterpretableCheckJob* job = NULL;
	VideoMonitorVideoInterpretableCheckJob* _tmp0_;
	VideoMonitorVideoInterpretableCheckJob* _tmp1_;
	VideoInterpretableResults* _tmp2_;
	guint64 _tmp3_;
	g_return_if_fail (IS_VIDEO_MONITOR (self));
	g_return_if_fail (IS_BACKGROUND_JOB (j));
	_tmp0_ = _background_job_ref0 (G_TYPE_CHECK_INSTANCE_CAST (j, VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJob));
	job = _tmp0_;
	_tmp1_ = job;
	_tmp2_ = _tmp1_->results;
	video_interpretable_results_foreground_finish (_tmp2_);
	self->priv->background_jobs = self->priv->background_jobs - 1;
	_tmp3_ = self->priv->background_jobs;
	if (self->priv->background_jobs <= ((guint64) 0)) {
		video_notify_normal_thumbs_regenerated ();
	}
	_background_job_unref0 (job);
}

static VideoMonitorVideoInterpretableCheckJob*
video_monitor_video_interpretable_check_job_construct (GType object_type,
                                                       Video* video,
                                                       CompletionCallback callback,
                                                       gpointer callback_target)
{
	VideoMonitorVideoInterpretableCheckJob* self = NULL;
	Video* _tmp0_;
	g_return_val_if_fail (IS_VIDEO (video), NULL);
	self = (VideoMonitorVideoInterpretableCheckJob*) background_job_construct (object_type, G_TYPE_CHECK_INSTANCE_CAST (video, G_TYPE_OBJECT, GObject), callback, callback_target, NULL, NULL, NULL, NULL);
	_tmp0_ = _g_object_ref0 (video);
	_g_object_unref0 (self->video);
	self->video = _tmp0_;
	return self;
}

static VideoMonitorVideoInterpretableCheckJob*
video_monitor_video_interpretable_check_job_new (Video* video,
                                                 CompletionCallback callback,
                                                 gpointer callback_target)
{
	return video_monitor_video_interpretable_check_job_construct (VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, video, callback, callback_target);
}

static void
video_monitor_video_interpretable_check_job_real_execute (BackgroundJob* base)
{
	VideoMonitorVideoInterpretableCheckJob * self;
	Video* _tmp0_;
	VideoInterpretableResults* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJob);
	_tmp0_ = self->video;
	_tmp1_ = video_check_is_interpretable (_tmp0_);
	_video_interpretable_results_unref0 (self->results);
	self->results = _tmp1_;
}

static void
video_monitor_video_interpretable_check_job_class_init (VideoMonitorVideoInterpretableCheckJobClass * klass,
                                                        gpointer klass_data)
{
	video_monitor_video_interpretable_check_job_parent_class = g_type_class_peek_parent (klass);
	((BackgroundJobClass *) klass)->finalize = video_monitor_video_interpretable_check_job_finalize;
	((BackgroundJobClass *) klass)->execute = (void (*) (BackgroundJob*)) video_monitor_video_interpretable_check_job_real_execute;
}

static void
video_monitor_video_interpretable_check_job_instance_init (VideoMonitorVideoInterpretableCheckJob * self,
                                                           gpointer klass)
{
	self->results = NULL;
}

static void
video_monitor_video_interpretable_check_job_finalize (BackgroundJob * obj)
{
	VideoMonitorVideoInterpretableCheckJob * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, VIDEO_MONITOR_TYPE_VIDEO_INTERPRETABLE_CHECK_JOB, VideoMonitorVideoInterpretableCheckJob);
	_g_object_unref0 (self->video);
	_video_interpretable_results_unref0 (self->results);
	BACKGROUND_JOB_CLASS (video_monitor_video_interpretable_check_job_parent_class)->finalize (obj);
}

static GType
video_monitor_video_interpretable_check_job_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoMonitorVideoInterpretableCheckJobClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_monitor_video_interpretable_check_job_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoMonitorVideoInterpretableCheckJob), 0, (GInstanceInitFunc) video_monitor_video_interpretable_check_job_instance_init, NULL };
	GType video_monitor_video_interpretable_check_job_type_id;
	video_monitor_video_interpretable_check_job_type_id = g_type_register_static (TYPE_BACKGROUND_JOB, "VideoMonitorVideoInterpretableCheckJob", &g_define_type_info, 0);
	return video_monitor_video_interpretable_check_job_type_id;
}

static GType
video_monitor_video_interpretable_check_job_get_type (void)
{
	static volatile gsize video_monitor_video_interpretable_check_job_type_id__once = 0;
	if (g_once_init_enter (&video_monitor_video_interpretable_check_job_type_id__once)) {
		GType video_monitor_video_interpretable_check_job_type_id;
		video_monitor_video_interpretable_check_job_type_id = video_monitor_video_interpretable_check_job_get_type_once ();
		g_once_init_leave (&video_monitor_video_interpretable_check_job_type_id__once, video_monitor_video_interpretable_check_job_type_id);
	}
	return video_monitor_video_interpretable_check_job_type_id__once;
}

static void
video_monitor_class_init (VideoMonitorClass * klass,
                          gpointer klass_data)
{
	video_monitor_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &VideoMonitor_private_offset);
	((MediaMonitorClass *) klass)->create_updates = (MonitorableUpdates* (*) (MediaMonitor*, Monitorable*)) video_monitor_real_create_updates;
	((MediaMonitorClass *) klass)->get_media_source_collection = (MediaSourceCollection* (*) (MediaMonitor*)) video_monitor_real_get_media_source_collection;
	((MediaMonitorClass *) klass)->is_file_represented = (gboolean (*) (MediaMonitor*, GFile*)) video_monitor_real_is_file_represented;
	((MediaMonitorClass *) klass)->notify_file_discovered = (MediaMonitorDiscoveredFile (*) (MediaMonitor*, GFile*, GFileInfo*, Monitorable**)) video_monitor_real_notify_file_discovered;
	((MediaMonitorClass *) klass)->candidates_for_unknown_file = (GeeCollection* (*) (MediaMonitor*, GFile*, GFileInfo*, MediaMonitorDiscoveredFile*)) video_monitor_real_candidates_for_unknown_file;
	((MediaMonitorClass *) klass)->notify_file_created = (gboolean (*) (MediaMonitor*, GFile*, GFileInfo*)) video_monitor_real_notify_file_created;
	((MediaMonitorClass *) klass)->notify_file_moved = (gboolean (*) (MediaMonitor*, GFile*, GFile*, GFileInfo*)) video_monitor_real_notify_file_moved;
	((MediaMonitorClass *) klass)->notify_file_altered = (gboolean (*) (MediaMonitor*, GFile*)) video_monitor_real_notify_file_altered;
	((MediaMonitorClass *) klass)->notify_file_attributes_altered = (gboolean (*) (MediaMonitor*, GFile*)) video_monitor_real_notify_file_attributes_altered;
	((MediaMonitorClass *) klass)->notify_file_alteration_completed = (gboolean (*) (MediaMonitor*, GFile*, GFileInfo*)) video_monitor_real_notify_file_alteration_completed;
	((MediaMonitorClass *) klass)->notify_file_deleted = (gboolean (*) (MediaMonitor*, GFile*)) video_monitor_real_notify_file_deleted;
	((MediaMonitorClass *) klass)->process_updates = (void (*) (MediaMonitor*, GeeCollection*, TransactionController*, gint*, GError**)) video_monitor_real_process_updates;
	G_OBJECT_CLASS (klass)->finalize = video_monitor_finalize;
}

static void
video_monitor_instance_init (VideoMonitor * self,
                             gpointer klass)
{
	Workers* _tmp0_;
	self->priv = video_monitor_get_instance_private (self);
	_tmp0_ = workers_new ((guint) 1, FALSE);
	self->priv->workers = _tmp0_;
	self->priv->background_jobs = (guint64) 0;
}

static void
video_monitor_finalize (GObject * obj)
{
	VideoMonitor * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_VIDEO_MONITOR, VideoMonitor);
	_workers_unref0 (self->priv->workers);
	G_OBJECT_CLASS (video_monitor_parent_class)->finalize (obj);
}

static GType
video_monitor_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (VideoMonitorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) video_monitor_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (VideoMonitor), 0, (GInstanceInitFunc) video_monitor_instance_init, NULL };
	GType video_monitor_type_id;
	video_monitor_type_id = g_type_register_static (TYPE_MEDIA_MONITOR, "VideoMonitor", &g_define_type_info, 0);
	VideoMonitor_private_offset = g_type_add_instance_private (video_monitor_type_id, sizeof (VideoMonitorPrivate));
	return video_monitor_type_id;
}

GType
video_monitor_get_type (void)
{
	static volatile gsize video_monitor_type_id__once = 0;
	if (g_once_init_enter (&video_monitor_type_id__once)) {
		GType video_monitor_type_id;
		video_monitor_type_id = video_monitor_get_type_once ();
		g_once_init_leave (&video_monitor_type_id__once, video_monitor_type_id);
	}
	return video_monitor_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

