/* ContainerSourceCollection.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from ContainerSourceCollection.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */
/* A ContainerSourceCollection is for DataSources which maintain links to one or more other*/
/* DataSources, assumed to be of a different type.  ContainerSourceCollection automates the task*/
/* of handling unlinking and relinking and maintaining backlinks.  Unlinked DataSources are*/
/* held in a holding tank, until they are either relinked or destroyed.*/
/**/
/* If the ContainerSourceCollection's DataSources are types that "evaporate" (i.e. they disappear*/
/* when they hold no items), they should use the evaporate() method, which will either destroy*/
/* the DataSource or hold it in the tank (if backlinks are outstanding).*/

#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_DATA_COLLECTION (data_collection_get_type ())
#define DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_COLLECTION, DataCollection))
#define DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_COLLECTION, DataCollectionClass))
#define IS_DATA_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_COLLECTION))
#define IS_DATA_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_COLLECTION))
#define DATA_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_COLLECTION, DataCollectionClass))

typedef struct _DataCollection DataCollection;
typedef struct _DataCollectionClass DataCollectionClass;
typedef struct _DataCollectionPrivate DataCollectionPrivate;

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_ALTERATION (alteration_get_type ())
#define ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ALTERATION, Alteration))
#define ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ALTERATION, AlterationClass))
#define IS_ALTERATION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ALTERATION))
#define IS_ALTERATION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ALTERATION))
#define ALTERATION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ALTERATION, AlterationClass))

typedef struct _Alteration Alteration;
typedef struct _AlterationClass AlterationClass;
typedef gint64 (*Comparator) (void* a, void* b, gpointer user_data);
typedef gboolean (*ComparatorPredicate) (DataObject* object, Alteration* alteration, gpointer user_data);
typedef gboolean (*ProgressMonitor) (guint64 current, guint64 total, gboolean do_event_loop, gpointer user_data);

#define TYPE_MARKER (marker_get_type ())
#define MARKER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MARKER, Marker))
#define IS_MARKER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MARKER))
#define MARKER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_MARKER, MarkerIface))

typedef struct _Marker Marker;
typedef struct _MarkerIface MarkerIface;

#define TYPE_SOURCE_COLLECTION (source_collection_get_type ())
#define SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_COLLECTION, SourceCollection))
#define SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_COLLECTION, SourceCollectionClass))
#define IS_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_COLLECTION))
#define IS_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_COLLECTION))
#define SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_COLLECTION, SourceCollectionClass))

typedef struct _SourceCollection SourceCollection;
typedef struct _SourceCollectionClass SourceCollectionClass;
typedef struct _SourceCollectionPrivate SourceCollectionPrivate;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_SOURCE_BACKLINK (source_backlink_get_type ())
#define SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SOURCE_BACKLINK, SourceBacklink))
#define SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))
#define IS_SOURCE_BACKLINK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SOURCE_BACKLINK))
#define IS_SOURCE_BACKLINK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SOURCE_BACKLINK))
#define SOURCE_BACKLINK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SOURCE_BACKLINK, SourceBacklinkClass))

typedef struct _SourceBacklink SourceBacklink;
typedef struct _SourceBacklinkClass SourceBacklinkClass;

#define TYPE_DATABASE_SOURCE_COLLECTION (database_source_collection_get_type ())
#define DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection))
#define DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))
#define IS_DATABASE_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_SOURCE_COLLECTION))
#define IS_DATABASE_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_SOURCE_COLLECTION))
#define DATABASE_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollectionClass))

typedef struct _DatabaseSourceCollection DatabaseSourceCollection;
typedef struct _DatabaseSourceCollectionClass DatabaseSourceCollectionClass;
typedef struct _DatabaseSourceCollectionPrivate DatabaseSourceCollectionPrivate;

#define TYPE_CONTAINER_SOURCE_COLLECTION (container_source_collection_get_type ())
#define CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection))
#define CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))
#define IS_CONTAINER_SOURCE_COLLECTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE_COLLECTION))
#define IS_CONTAINER_SOURCE_COLLECTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CONTAINER_SOURCE_COLLECTION))
#define CONTAINER_SOURCE_COLLECTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollectionClass))

typedef struct _ContainerSourceCollection ContainerSourceCollection;
typedef struct _ContainerSourceCollectionClass ContainerSourceCollectionClass;
typedef struct _ContainerSourceCollectionPrivate ContainerSourceCollectionPrivate;

#define TYPE_CONTAINER_SOURCE (container_source_get_type ())
#define CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CONTAINER_SOURCE, ContainerSource))
#define IS_CONTAINER_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CONTAINER_SOURCE))
#define CONTAINER_SOURCE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_CONTAINER_SOURCE, ContainerSourceIface))

typedef struct _ContainerSource ContainerSource;
typedef struct _ContainerSourceIface ContainerSourceIface;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef gint64 (*GetSourceDatabaseKey) (DataSource* source, gpointer user_data);
#define _data_collection_unref0(var) ((var == NULL) ? NULL : (var = (data_collection_unref (var), NULL)))
#define _source_backlink_unref0(var) ((var == NULL) ? NULL : (var = (source_backlink_unref (var), NULL)))

#define TYPE_TAG (tag_get_type ())
#define TAG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_TAG, Tag))
#define TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_TAG, TagClass))
#define IS_TAG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_TAG))
#define IS_TAG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_TAG))
#define TAG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_TAG, TagClass))

typedef struct _Tag Tag;
typedef struct _TagClass TagClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;
enum  {
	CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ADDED_SIGNAL,
	CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_REMOVED_SIGNAL,
	CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ALTERED_SIGNAL,
	CONTAINER_SOURCE_COLLECTION_BACKLINK_TO_CONTAINER_REMOVED_SIGNAL,
	CONTAINER_SOURCE_COLLECTION_NUM_SIGNALS
};
static guint container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_NUM_SIGNALS] = {0};
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _MarkerIface {
	GTypeInterface parent_iface;
	void (*mark) (Marker* self, DataObject* object);
	void (*unmark) (Marker* self, DataObject* object);
	gboolean (*toggle) (Marker* self, DataObject* object);
	void (*mark_many) (Marker* self, GeeCollection* list);
	void (*unmark_many) (Marker* self, GeeCollection* list);
	void (*mark_all) (Marker* self);
	gint (*get_count) (Marker* self);
	GeeCollection* (*get_all) (Marker* self);
};

struct _DataCollection {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DataCollectionPrivate * priv;
};

struct _DataCollectionClass {
	GTypeClass parent_class;
	void (*finalize) (DataCollection *self);
	gchar* (*to_string) (DataCollection* self);
	void (*notify_items_added) (DataCollection* self, GeeIterable* added);
	void (*notify_items_removed) (DataCollection* self, GeeIterable* removed);
	void (*notify_contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*notify_items_altered) (DataCollection* self, GeeMap* items);
	void (*notify_ordering_changed) (DataCollection* self);
	void (*notify_property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*notify_property_cleared) (DataCollection* self, const gchar* name);
	gboolean (*valid_type) (DataCollection* self, DataObject* object);
	void (*set_comparator) (DataCollection* self, Comparator comparator, gpointer comparator_target, ComparatorPredicate predicate, gpointer predicate_target);
	void (*reset_comparator) (DataCollection* self);
	GeeCollection* (*get_all) (DataCollection* self);
	gint (*get_count) (DataCollection* self);
	DataObject* (*get_at) (DataCollection* self, gint index);
	gint (*index_of) (DataCollection* self, DataObject* object);
	gboolean (*contains) (DataCollection* self, DataObject* object);
	gboolean (*add) (DataCollection* self, DataObject* object);
	GeeCollection* (*add_many) (DataCollection* self, GeeCollection* objects, ProgressMonitor monitor, gpointer monitor_target);
	void (*remove_marked) (DataCollection* self, Marker* m);
	void (*clear) (DataCollection* self);
	void (*close) (DataCollection* self);
	void (*notify_frozen) (DataCollection* self);
	void (*notify_thawed) (DataCollection* self);
	void (*items_added) (DataCollection* self, GeeIterable* added);
	void (*items_removed) (DataCollection* self, GeeIterable* removed);
	void (*contents_altered) (DataCollection* self, GeeIterable* added, GeeIterable* removed);
	void (*items_altered) (DataCollection* self, GeeMap* items);
	void (*ordering_changed) (DataCollection* self);
	void (*property_set) (DataCollection* self, const gchar* name, GValue* old, GValue* val);
	void (*property_cleared) (DataCollection* self, const gchar* name);
	void (*frozen) (DataCollection* self);
	void (*thawed) (DataCollection* self);
};

struct _SourceCollection {
	DataCollection parent_instance;
	SourceCollectionPrivate * priv;
};

struct _SourceCollectionClass {
	DataCollectionClass parent_class;
	gboolean (*holds_type_of_source) (SourceCollection* self, DataSource* source);
	void (*notify_items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*notify_items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*notify_item_destroyed) (SourceCollection* self, DataSource* source);
	void (*notify_items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*notify_unlinked_destroyed) (SourceCollection* self, DataSource* unlinked);
	void (*notify_backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
	gboolean (*has_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*remove_backlink) (SourceCollection* self, SourceBacklink* backlink);
	void (*items_unlinking) (SourceCollection* self, GeeCollection* unlinking);
	void (*items_relinked) (SourceCollection* self, GeeCollection* relinked);
	void (*item_destroyed) (SourceCollection* self, DataSource* source);
	void (*items_destroyed) (SourceCollection* self, GeeCollection* destroyed);
	void (*unlinked_destroyed) (SourceCollection* self, DataSource* source);
	void (*backlink_removed) (SourceCollection* self, SourceBacklink* backlink, GeeCollection* sources);
};

struct _DatabaseSourceCollection {
	SourceCollection parent_instance;
	DatabaseSourceCollectionPrivate * priv;
};

struct _DatabaseSourceCollectionClass {
	SourceCollectionClass parent_class;
};

struct _ContainerSourceIface {
	GTypeInterface parent_iface;
	gboolean (*has_links) (ContainerSource* self);
	SourceBacklink* (*get_backlink) (ContainerSource* self);
	void (*break_link) (ContainerSource* self, DataSource* source);
	void (*break_link_many) (ContainerSource* self, GeeCollection* sources);
	void (*establish_link) (ContainerSource* self, DataSource* source);
	void (*establish_link_many) (ContainerSource* self, GeeCollection* sources);
};

struct _ContainerSourceCollection {
	DatabaseSourceCollection parent_instance;
	ContainerSourceCollectionPrivate * priv;
};

struct _ContainerSourceCollectionClass {
	DatabaseSourceCollectionClass parent_class;
	void (*notify_container_contents_added) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked);
	void (*notify_container_contents_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked);
	void (*notify_container_contents_altered) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked);
	void (*notify_backlink_to_container_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources);
	GeeCollection* (*get_containers_holding_source) (ContainerSourceCollection* self, DataSource* source);
	ContainerSource* (*convert_backlink_to_container) (ContainerSourceCollection* self, SourceBacklink* backlink);
	void (*container_contents_added) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked);
	void (*container_contents_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* removed, gboolean unlinked);
	void (*container_contents_altered) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* added, gboolean relinked, GeeCollection* removed, gboolean unlinked);
	void (*backlink_to_container_removed) (ContainerSourceCollection* self, ContainerSource* container, GeeCollection* sources);
};

struct _ContainerSourceCollectionPrivate {
	GeeHashSet* attached_collections;
	gchar* backlink_name;
	GeeHashSet* holding_tank;
};

static gint ContainerSourceCollection_private_offset;
static gpointer container_source_collection_parent_class = NULL;

VALA_EXTERN gpointer data_collection_ref (gpointer instance);
VALA_EXTERN void data_collection_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_data_collection (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_data_collection (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_data_collection (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_data_collection (const GValue* value);
VALA_EXTERN GType data_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataCollection, data_collection_unref)
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN gpointer alteration_ref (gpointer instance);
VALA_EXTERN void alteration_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_alteration (const gchar* name,
                                   const gchar* nick,
                                   const gchar* blurb,
                                   GType object_type,
                                   GParamFlags flags);
VALA_EXTERN void value_set_alteration (GValue* value,
                           gpointer v_object);
VALA_EXTERN void value_take_alteration (GValue* value,
                            gpointer v_object);
VALA_EXTERN gpointer value_get_alteration (const GValue* value);
VALA_EXTERN GType alteration_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Alteration, alteration_unref)
VALA_EXTERN GType marker_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Marker, g_object_unref)
VALA_EXTERN GType source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceCollection, data_collection_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN gpointer source_backlink_ref (gpointer instance);
VALA_EXTERN void source_backlink_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_source_backlink (const gchar* name,
                                        const gchar* nick,
                                        const gchar* blurb,
                                        GType object_type,
                                        GParamFlags flags);
VALA_EXTERN void value_set_source_backlink (GValue* value,
                                gpointer v_object);
VALA_EXTERN void value_take_source_backlink (GValue* value,
                                 gpointer v_object);
VALA_EXTERN gpointer value_get_source_backlink (const GValue* value);
VALA_EXTERN GType source_backlink_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SourceBacklink, source_backlink_unref)
VALA_EXTERN GType database_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseSourceCollection, data_collection_unref)
VALA_EXTERN GType container_source_collection_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSourceCollection, data_collection_unref)
VALA_EXTERN GType container_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ContainerSource, g_object_unref)
VALA_EXTERN void source_collection_notify_backlink_removed (SourceCollection* self,
                                                SourceBacklink* backlink,
                                                GeeCollection* sources);
VALA_EXTERN void container_source_collection_notify_container_contents_added (ContainerSourceCollection* self,
                                                                  ContainerSource* container,
                                                                  GeeCollection* added,
                                                                  gboolean relinked);
VALA_EXTERN void container_source_collection_notify_container_contents_removed (ContainerSourceCollection* self,
                                                                    ContainerSource* container,
                                                                    GeeCollection* removed,
                                                                    gboolean unlinked);
VALA_EXTERN void container_source_collection_notify_container_contents_altered (ContainerSourceCollection* self,
                                                                    ContainerSource* container,
                                                                    GeeCollection* added,
                                                                    gboolean relinked,
                                                                    GeeCollection* removed,
                                                                    gboolean unlinked);
VALA_EXTERN void container_source_collection_notify_backlink_to_container_removed (ContainerSourceCollection* self,
                                                                       ContainerSource* container,
                                                                       GeeCollection* sources);
VALA_EXTERN GeeCollection* container_source_collection_get_containers_holding_source (ContainerSourceCollection* self,
                                                                          DataSource* source);
VALA_EXTERN ContainerSource* container_source_collection_convert_backlink_to_container (ContainerSourceCollection* self,
                                                                            SourceBacklink* backlink);
VALA_EXTERN void source_collection_notify_item_destroyed (SourceCollection* self,
                                              DataSource* source);
VALA_EXTERN void container_source_collection_detach_all_collections (ContainerSourceCollection* self);
VALA_EXTERN ContainerSourceCollection* container_source_collection_construct (GType object_type,
                                                                  const gchar* backlink_name,
                                                                  const gchar* name,
                                                                  GetSourceDatabaseKey source_key_func,
                                                                  gpointer source_key_func_target);
VALA_EXTERN DatabaseSourceCollection* database_source_collection_construct (GType object_type,
                                                                const gchar* name,
                                                                GetSourceDatabaseKey source_key_func,
                                                                gpointer source_key_func_target);
static void container_source_collection_real_notify_backlink_removed (SourceCollection* base,
                                                               SourceBacklink* backlink,
                                                               GeeCollection* sources);
static void container_source_collection_real_notify_container_contents_added (ContainerSourceCollection* self,
                                                                       ContainerSource* container,
                                                                       GeeCollection* added,
                                                                       gboolean relinked);
VALA_EXTERN void source_collection_relink (SourceCollection* self,
                               DataSource* source);
static void container_source_collection_real_notify_container_contents_removed (ContainerSourceCollection* self,
                                                                         ContainerSource* container,
                                                                         GeeCollection* removed,
                                                                         gboolean unlinked);
static void container_source_collection_real_notify_container_contents_altered (ContainerSourceCollection* self,
                                                                         ContainerSource* container,
                                                                         GeeCollection* added,
                                                                         gboolean relinked,
                                                                         GeeCollection* removed,
                                                                         gboolean unlinked);
static void container_source_collection_real_notify_backlink_to_container_removed (ContainerSourceCollection* self,
                                                                            ContainerSource* container,
                                                                            GeeCollection* sources);
static GeeCollection* container_source_collection_real_get_containers_holding_source (ContainerSourceCollection* self,
                                                                               DataSource* source);
static ContainerSource* container_source_collection_real_convert_backlink_to_container (ContainerSourceCollection* self,
                                                                                 SourceBacklink* backlink);
VALA_EXTERN void container_source_collection_freeze_attached_notifications (ContainerSourceCollection* self);
VALA_EXTERN void data_collection_freeze_notifications (DataCollection* self);
VALA_EXTERN void container_source_collection_thaw_attached_notifications (ContainerSourceCollection* self);
VALA_EXTERN void data_collection_thaw_notifications (DataCollection* self);
VALA_EXTERN GeeCollection* container_source_collection_get_holding_tank (ContainerSourceCollection* self);
VALA_EXTERN void container_source_collection_init_add_unlinked (ContainerSourceCollection* self,
                                                    ContainerSource* unlinked);
VALA_EXTERN void container_source_collection_init_add_many_unlinked (ContainerSourceCollection* self,
                                                         GeeCollection* unlinked);
VALA_EXTERN gboolean container_source_collection_relink_from_holding_tank (ContainerSourceCollection* self,
                                                               ContainerSource* source);
static void container_source_collection_on_contained_sources_unlinking (ContainerSourceCollection* self,
                                                                 GeeCollection* unlinking);
VALA_EXTERN void data_source_set_backlink (DataSource* self,
                               SourceBacklink* backlink);
VALA_EXTERN SourceBacklink* container_source_get_backlink (ContainerSource* self);
VALA_EXTERN void container_source_break_link_many (ContainerSource* self,
                                       GeeCollection* sources);
static void container_source_collection_on_contained_sources_relinked (ContainerSourceCollection* self,
                                                                GeeCollection* relinked);
VALA_EXTERN GeeList* data_source_get_backlinks (DataSource* self,
                                    const gchar* name);
VALA_EXTERN gchar* data_object_to_string (DataObject* self);
VALA_EXTERN gchar* source_backlink_to_string (SourceBacklink* self);
VALA_EXTERN void container_source_establish_link_many (ContainerSource* self,
                                           GeeCollection* sources);
static void container_source_collection_on_contained_source_destroyed (ContainerSourceCollection* self,
                                                                DataSource* source);
VALA_EXTERN gboolean container_source_has_links (ContainerSource* self);
VALA_EXTERN GType tag_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Tag, g_object_unref)
VALA_EXTERN gboolean data_source_destroy_orphan (DataSource* self,
                                     gboolean delete_backing);
static void container_source_collection_real_notify_item_destroyed (SourceCollection* base,
                                                             DataSource* source);
VALA_EXTERN void source_collection_remove_backlink (SourceCollection* self,
                                        SourceBacklink* backlink);
VALA_EXTERN void container_source_collection_evaporate (ContainerSourceCollection* self,
                                            ContainerSource* container);
VALA_EXTERN gboolean source_collection_has_backlink (SourceCollection* self,
                                         SourceBacklink* backlink);
VALA_EXTERN GeeCollection* source_collection_unlink_marked (SourceCollection* self,
                                                Marker* marker,
                                                ProgressMonitor monitor,
                                                gpointer monitor_target);
VALA_EXTERN Marker* data_collection_mark (DataCollection* self,
                              DataObject* object);
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN gint source_collection_destroy_marked (SourceCollection* self,
                                       Marker* marker,
                                       gboolean delete_backing,
                                       ProgressMonitor monitor,
                                       gpointer monitor_target,
                                       GeeList* not_removed);
VALA_EXTERN void container_source_collection_attach_collection (ContainerSourceCollection* self,
                                                    SourceCollection* collection);
VALA_EXTERN gchar* data_collection_to_string (DataCollection* self);
static void _container_source_collection_on_contained_sources_unlinking_source_collection_items_unlinking (SourceCollection* _sender,
                                                                                                    GeeCollection* unlinking,
                                                                                                    gpointer self);
static void _container_source_collection_on_contained_sources_relinked_source_collection_items_relinked (SourceCollection* _sender,
                                                                                                  GeeCollection* relinked,
                                                                                                  gpointer self);
static void _container_source_collection_on_contained_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                                  DataSource* source,
                                                                                                  gpointer self);
static void _container_source_collection_on_contained_source_destroyed_source_collection_unlinked_destroyed (SourceCollection* _sender,
                                                                                                      DataSource* source,
                                                                                                      gpointer self);
static void container_source_collection_real_container_contents_added (ContainerSourceCollection* self,
                                                                ContainerSource* container,
                                                                GeeCollection* added,
                                                                gboolean relinked);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN (GClosure * closure,
                                                          GValue * return_value,
                                                          guint n_param_values,
                                                          const GValue * param_values,
                                                          gpointer invocation_hint,
                                                          gpointer marshal_data);
static void container_source_collection_real_container_contents_removed (ContainerSourceCollection* self,
                                                                  ContainerSource* container,
                                                                  GeeCollection* removed,
                                                                  gboolean unlinked);
static void container_source_collection_real_container_contents_altered (ContainerSourceCollection* self,
                                                                  ContainerSource* container,
                                                                  GeeCollection* added,
                                                                  gboolean relinked,
                                                                  GeeCollection* removed,
                                                                  gboolean unlinked);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN (GClosure * closure,
                                                                         GValue * return_value,
                                                                         guint n_param_values,
                                                                         const GValue * param_values,
                                                                         gpointer invocation_hint,
                                                                         gpointer marshal_data);
static void container_source_collection_real_backlink_to_container_removed (ContainerSourceCollection* self,
                                                                     ContainerSource* container,
                                                                     GeeCollection* sources);
static void g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                                  GValue * return_value,
                                                  guint n_param_values,
                                                  const GValue * param_values,
                                                  gpointer invocation_hint,
                                                  gpointer marshal_data);
static void container_source_collection_finalize (DataCollection * obj);
static GType container_source_collection_get_type_once (void);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
container_source_collection_get_instance_private (ContainerSourceCollection* self)
{
	return G_STRUCT_MEMBER_P (self, ContainerSourceCollection_private_offset);
}

ContainerSourceCollection*
container_source_collection_construct (GType object_type,
                                       const gchar* backlink_name,
                                       const gchar* name,
                                       GetSourceDatabaseKey source_key_func,
                                       gpointer source_key_func_target)
{
	ContainerSourceCollection* self = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (backlink_name != NULL, NULL);
	g_return_val_if_fail (name != NULL, NULL);
	self = (ContainerSourceCollection*) database_source_collection_construct (object_type, name, source_key_func, source_key_func_target);
	_tmp0_ = g_strdup (backlink_name);
	_g_free0 (self->priv->backlink_name);
	self->priv->backlink_name = _tmp0_;
	return self;
}

static void
container_source_collection_real_notify_backlink_removed (SourceCollection* base,
                                                          SourceBacklink* backlink,
                                                          GeeCollection* sources)
{
	ContainerSourceCollection * self;
	ContainerSource* container = NULL;
	ContainerSource* _tmp0_;
	ContainerSource* _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection);
	g_return_if_fail (IS_SOURCE_BACKLINK (backlink));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
	SOURCE_COLLECTION_CLASS (container_source_collection_parent_class)->notify_backlink_removed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), TYPE_SOURCE_COLLECTION, SourceCollection), backlink, sources);
	_tmp0_ = container_source_collection_convert_backlink_to_container (self, backlink);
	container = _tmp0_;
	_tmp1_ = container;
	if (_tmp1_ != NULL) {
		ContainerSource* _tmp2_;
		_tmp2_ = container;
		container_source_collection_notify_backlink_to_container_removed (self, _tmp2_, sources);
	}
	_g_object_unref0 (container);
}

static void
container_source_collection_real_notify_container_contents_added (ContainerSourceCollection* self,
                                                                  ContainerSource* container,
                                                                  GeeCollection* added,
                                                                  gboolean relinked)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->holding_tank;
	if (gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), container)) {
		gboolean removed = FALSE;
		GeeHashSet* _tmp1_;
		_tmp1_ = self->priv->holding_tank;
		removed = gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), container);
		_vala_assert (removed, "removed");
		source_collection_relink (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), G_TYPE_CHECK_INSTANCE_CAST (container, TYPE_DATA_SOURCE, DataSource));
	}
	g_signal_emit (self, container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ADDED_SIGNAL], 0, container, added, relinked);
}

void
container_source_collection_notify_container_contents_added (ContainerSourceCollection* self,
                                                             ContainerSource* container,
                                                             GeeCollection* added,
                                                             gboolean relinked)
{
	ContainerSourceCollectionClass* _klass_;
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	_klass_ = CONTAINER_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_container_contents_added) {
		_klass_->notify_container_contents_added (self, container, added, relinked);
	}
}

static void
container_source_collection_real_notify_container_contents_removed (ContainerSourceCollection* self,
                                                                    ContainerSource* container,
                                                                    GeeCollection* removed,
                                                                    gboolean unlinked)
{
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
	g_signal_emit (self, container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_REMOVED_SIGNAL], 0, container, removed, unlinked);
}

void
container_source_collection_notify_container_contents_removed (ContainerSourceCollection* self,
                                                               ContainerSource* container,
                                                               GeeCollection* removed,
                                                               gboolean unlinked)
{
	ContainerSourceCollectionClass* _klass_;
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	_klass_ = CONTAINER_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_container_contents_removed) {
		_klass_->notify_container_contents_removed (self, container, removed, unlinked);
	}
}

static void
container_source_collection_real_notify_container_contents_altered (ContainerSourceCollection* self,
                                                                    ContainerSource* container,
                                                                    GeeCollection* added,
                                                                    gboolean relinked,
                                                                    GeeCollection* removed,
                                                                    gboolean unlinked)
{
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
	g_signal_emit (self, container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ALTERED_SIGNAL], 0, container, added, relinked, removed, unlinked);
}

void
container_source_collection_notify_container_contents_altered (ContainerSourceCollection* self,
                                                               ContainerSource* container,
                                                               GeeCollection* added,
                                                               gboolean relinked,
                                                               GeeCollection* removed,
                                                               gboolean unlinked)
{
	ContainerSourceCollectionClass* _klass_;
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	_klass_ = CONTAINER_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_container_contents_altered) {
		_klass_->notify_container_contents_altered (self, container, added, relinked, removed, unlinked);
	}
}

static void
container_source_collection_real_notify_backlink_to_container_removed (ContainerSourceCollection* self,
                                                                       ContainerSource* container,
                                                                       GeeCollection* sources)
{
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
	g_signal_emit (self, container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_BACKLINK_TO_CONTAINER_REMOVED_SIGNAL], 0, container, sources);
}

void
container_source_collection_notify_backlink_to_container_removed (ContainerSourceCollection* self,
                                                                  ContainerSource* container,
                                                                  GeeCollection* sources)
{
	ContainerSourceCollectionClass* _klass_;
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	_klass_ = CONTAINER_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->notify_backlink_to_container_removed) {
		_klass_->notify_backlink_to_container_removed (self, container, sources);
	}
}

static GeeCollection*
container_source_collection_real_get_containers_holding_source (ContainerSourceCollection* self,
                                                                DataSource* source)
{
	g_critical ("Type `%s' does not implement abstract method `container_source_collection_get_containers_holding_source'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

GeeCollection*
container_source_collection_get_containers_holding_source (ContainerSourceCollection* self,
                                                           DataSource* source)
{
	ContainerSourceCollectionClass* _klass_;
	g_return_val_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self), NULL);
	_klass_ = CONTAINER_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->get_containers_holding_source) {
		return _klass_->get_containers_holding_source (self, source);
	}
	return NULL;
}

static ContainerSource*
container_source_collection_real_convert_backlink_to_container (ContainerSourceCollection* self,
                                                                SourceBacklink* backlink)
{
	g_critical ("Type `%s' does not implement abstract method `container_source_collection_convert_backlink_to_container'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

ContainerSource*
container_source_collection_convert_backlink_to_container (ContainerSourceCollection* self,
                                                           SourceBacklink* backlink)
{
	ContainerSourceCollectionClass* _klass_;
	g_return_val_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self), NULL);
	_klass_ = CONTAINER_SOURCE_COLLECTION_GET_CLASS (self);
	if (_klass_->convert_backlink_to_container) {
		return _klass_->convert_backlink_to_container (self, backlink);
	}
	return NULL;
}

void
container_source_collection_freeze_attached_notifications (ContainerSourceCollection* self)
{
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->attached_collections;
		_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_collection_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SourceCollection* _tmp5_;
			_tmp2_ = _collection_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _collection_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			collection = (SourceCollection*) _tmp4_;
			_tmp5_ = collection;
			data_collection_freeze_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_COLLECTION, DataCollection));
			_data_collection_unref0 (collection);
		}
		_g_object_unref0 (_collection_it);
	}
}

void
container_source_collection_thaw_attached_notifications (ContainerSourceCollection* self)
{
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->attached_collections;
		_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_collection_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SourceCollection* _tmp5_;
			_tmp2_ = _collection_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _collection_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			collection = (SourceCollection*) _tmp4_;
			_tmp5_ = collection;
			data_collection_thaw_notifications (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DATA_COLLECTION, DataCollection));
			_data_collection_unref0 (collection);
		}
		_g_object_unref0 (_collection_it);
	}
}

GeeCollection*
container_source_collection_get_holding_tank (ContainerSourceCollection* self)
{
	GeeHashSet* _tmp0_;
	GeeSet* _tmp1_;
	GeeSet* _tmp2_;
	GeeCollection* result;
	g_return_val_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self), NULL);
	_tmp0_ = self->priv->holding_tank;
	_tmp1_ = gee_abstract_set_get_read_only_view (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_SET, GeeAbstractSet));
	_tmp2_ = _tmp1_;
	result = G_TYPE_CHECK_INSTANCE_CAST (_tmp2_, GEE_TYPE_COLLECTION, GeeCollection);
	return result;
}

void
container_source_collection_init_add_unlinked (ContainerSourceCollection* self,
                                               ContainerSource* unlinked)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	g_return_if_fail (IS_CONTAINER_SOURCE (unlinked));
	_tmp0_ = self->priv->holding_tank;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), unlinked);
}

void
container_source_collection_init_add_many_unlinked (ContainerSourceCollection* self,
                                                    GeeCollection* unlinked)
{
	GeeHashSet* _tmp0_;
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (unlinked, GEE_TYPE_COLLECTION));
	_tmp0_ = self->priv->holding_tank;
	gee_collection_add_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_COLLECTION, GeeCollection), unlinked);
}

gboolean
container_source_collection_relink_from_holding_tank (ContainerSourceCollection* self,
                                                      ContainerSource* source)
{
	GeeHashSet* _tmp0_;
	gboolean result;
	g_return_val_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self), FALSE);
	g_return_val_if_fail (IS_CONTAINER_SOURCE (source), FALSE);
	_tmp0_ = self->priv->holding_tank;
	if (!gee_abstract_collection_remove (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), source)) {
		result = FALSE;
		return result;
	}
	source_collection_relink (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_DATA_SOURCE, DataSource));
	result = TRUE;
	return result;
}

static void
container_source_collection_on_contained_sources_unlinking (ContainerSourceCollection* self,
                                                            GeeCollection* unlinking)
{
	GeeHashMultiMap* map = NULL;
	GeeHashMultiMap* _tmp0_;
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (unlinking, GEE_TYPE_COLLECTION));
	container_source_collection_freeze_attached_notifications (self);
	_tmp0_ = gee_hash_multi_map_new (TYPE_CONTAINER_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	map = _tmp0_;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (unlinking, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataSource* source = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeCollection* containers = NULL;
			DataSource* _tmp5_;
			GeeCollection* _tmp6_;
			gboolean _tmp7_ = FALSE;
			GeeCollection* _tmp8_;
			_tmp2_ = _source_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _source_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			source = (DataSource*) _tmp4_;
			_tmp5_ = source;
			_tmp6_ = container_source_collection_get_containers_holding_source (self, _tmp5_);
			containers = _tmp6_;
			_tmp8_ = containers;
			if (_tmp8_ == NULL) {
				_tmp7_ = TRUE;
			} else {
				GeeCollection* _tmp9_;
				gint _tmp10_;
				gint _tmp11_;
				_tmp9_ = containers;
				_tmp10_ = gee_collection_get_size (_tmp9_);
				_tmp11_ = _tmp10_;
				_tmp7_ = _tmp11_ == 0;
			}
			if (_tmp7_) {
				_g_object_unref0 (containers);
				_g_object_unref0 (source);
				continue;
			}
			{
				GeeIterator* _container_it = NULL;
				GeeCollection* _tmp12_;
				GeeIterator* _tmp13_;
				_tmp12_ = containers;
				_tmp13_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, GEE_TYPE_ITERABLE, GeeIterable));
				_container_it = _tmp13_;
				while (TRUE) {
					GeeIterator* _tmp14_;
					ContainerSource* container = NULL;
					GeeIterator* _tmp15_;
					gpointer _tmp16_;
					GeeHashMultiMap* _tmp17_;
					ContainerSource* _tmp18_;
					DataSource* _tmp19_;
					DataSource* _tmp20_;
					ContainerSource* _tmp21_;
					SourceBacklink* _tmp22_;
					SourceBacklink* _tmp23_;
					_tmp14_ = _container_it;
					if (!gee_iterator_next (_tmp14_)) {
						break;
					}
					_tmp15_ = _container_it;
					_tmp16_ = gee_iterator_get (_tmp15_);
					container = (ContainerSource*) _tmp16_;
					_tmp17_ = map;
					_tmp18_ = container;
					_tmp19_ = source;
					gee_multi_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp18_, _tmp19_);
					_tmp20_ = source;
					_tmp21_ = container;
					_tmp22_ = container_source_get_backlink (_tmp21_);
					_tmp23_ = _tmp22_;
					data_source_set_backlink (_tmp20_, _tmp23_);
					_source_backlink_unref0 (_tmp23_);
					_g_object_unref0 (container);
				}
				_g_object_unref0 (_container_it);
			}
			_g_object_unref0 (containers);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	{
		GeeIterator* _container_it = NULL;
		GeeHashMultiMap* _tmp24_;
		GeeSet* _tmp25_;
		GeeSet* _tmp26_;
		GeeIterator* _tmp27_;
		GeeIterator* _tmp28_;
		_tmp24_ = map;
		_tmp25_ = gee_multi_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
		_tmp26_ = _tmp25_;
		_tmp27_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp26_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp28_ = _tmp27_;
		_g_object_unref0 (_tmp26_);
		_container_it = _tmp28_;
		while (TRUE) {
			GeeIterator* _tmp29_;
			ContainerSource* container = NULL;
			GeeIterator* _tmp30_;
			gpointer _tmp31_;
			ContainerSource* _tmp32_;
			GeeHashMultiMap* _tmp33_;
			ContainerSource* _tmp34_;
			GeeCollection* _tmp35_;
			GeeCollection* _tmp36_;
			_tmp29_ = _container_it;
			if (!gee_iterator_next (_tmp29_)) {
				break;
			}
			_tmp30_ = _container_it;
			_tmp31_ = gee_iterator_get (_tmp30_);
			container = (ContainerSource*) _tmp31_;
			_tmp32_ = container;
			_tmp33_ = map;
			_tmp34_ = container;
			_tmp35_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp34_);
			_tmp36_ = _tmp35_;
			container_source_break_link_many (_tmp32_, _tmp36_);
			_g_object_unref0 (_tmp36_);
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_it);
	}
	container_source_collection_thaw_attached_notifications (self);
	_g_object_unref0 (map);
}

static void
container_source_collection_on_contained_sources_relinked (ContainerSourceCollection* self,
                                                           GeeCollection* relinked)
{
	GeeHashMultiMap* map = NULL;
	GeeHashMultiMap* _tmp0_;
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (relinked, GEE_TYPE_COLLECTION));
	container_source_collection_freeze_attached_notifications (self);
	_tmp0_ = gee_hash_multi_map_new (TYPE_CONTAINER_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, TYPE_DATA_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL);
	map = _tmp0_;
	{
		GeeIterator* _source_it = NULL;
		GeeIterator* _tmp1_;
		_tmp1_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (relinked, GEE_TYPE_ITERABLE, GeeIterable));
		_source_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			DataSource* source = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			GeeList* backlinks = NULL;
			DataSource* _tmp5_;
			const gchar* _tmp6_;
			GeeList* _tmp7_;
			gboolean _tmp8_ = FALSE;
			GeeList* _tmp9_;
			_tmp2_ = _source_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _source_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			source = (DataSource*) _tmp4_;
			_tmp5_ = source;
			_tmp6_ = self->priv->backlink_name;
			_tmp7_ = data_source_get_backlinks (_tmp5_, _tmp6_);
			backlinks = _tmp7_;
			_tmp9_ = backlinks;
			if (_tmp9_ == NULL) {
				_tmp8_ = TRUE;
			} else {
				GeeList* _tmp10_;
				gint _tmp11_;
				gint _tmp12_;
				_tmp10_ = backlinks;
				_tmp11_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp12_ = _tmp11_;
				_tmp8_ = _tmp12_ == 0;
			}
			if (_tmp8_) {
				_g_object_unref0 (backlinks);
				_g_object_unref0 (source);
				continue;
			}
			{
				GeeList* _backlink_list = NULL;
				GeeList* _tmp13_;
				gint _backlink_size = 0;
				GeeList* _tmp14_;
				gint _tmp15_;
				gint _tmp16_;
				gint _backlink_index = 0;
				_tmp13_ = backlinks;
				_backlink_list = _tmp13_;
				_tmp14_ = _backlink_list;
				_tmp15_ = gee_collection_get_size (G_TYPE_CHECK_INSTANCE_CAST (_tmp14_, GEE_TYPE_COLLECTION, GeeCollection));
				_tmp16_ = _tmp15_;
				_backlink_size = _tmp16_;
				_backlink_index = -1;
				while (TRUE) {
					gint _tmp17_;
					gint _tmp18_;
					SourceBacklink* backlink = NULL;
					GeeList* _tmp19_;
					gpointer _tmp20_;
					ContainerSource* container = NULL;
					SourceBacklink* _tmp21_;
					ContainerSource* _tmp22_;
					ContainerSource* _tmp23_;
					_backlink_index = _backlink_index + 1;
					_tmp17_ = _backlink_index;
					_tmp18_ = _backlink_size;
					if (!(_tmp17_ < _tmp18_)) {
						break;
					}
					_tmp19_ = _backlink_list;
					_tmp20_ = gee_list_get (_tmp19_, _backlink_index);
					backlink = (SourceBacklink*) _tmp20_;
					_tmp21_ = backlink;
					_tmp22_ = container_source_collection_convert_backlink_to_container (self, _tmp21_);
					container = _tmp22_;
					_tmp23_ = container;
					if (_tmp23_ != NULL) {
						GeeHashMultiMap* _tmp24_;
						ContainerSource* _tmp25_;
						DataSource* _tmp26_;
						_tmp24_ = map;
						_tmp25_ = container;
						_tmp26_ = source;
						gee_multi_map_set (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp25_, _tmp26_);
					} else {
						DataSource* _tmp27_;
						gchar* _tmp28_;
						gchar* _tmp29_;
						SourceBacklink* _tmp30_;
						gchar* _tmp31_;
						gchar* _tmp32_;
						_tmp27_ = source;
						_tmp28_ = data_object_to_string (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_DATA_OBJECT, DataObject));
						_tmp29_ = _tmp28_;
						_tmp30_ = backlink;
						_tmp31_ = source_backlink_to_string (_tmp30_);
						_tmp32_ = _tmp31_;
						g_warning ("ContainerSourceCollection.vala:162: Unable to relink %s to container b" \
"acklink %s", _tmp29_, _tmp32_);
						_g_free0 (_tmp32_);
						_g_free0 (_tmp29_);
					}
					_g_object_unref0 (container);
					_source_backlink_unref0 (backlink);
				}
			}
			_g_object_unref0 (backlinks);
			_g_object_unref0 (source);
		}
		_g_object_unref0 (_source_it);
	}
	{
		GeeIterator* _container_it = NULL;
		GeeHashMultiMap* _tmp33_;
		GeeSet* _tmp34_;
		GeeSet* _tmp35_;
		GeeIterator* _tmp36_;
		GeeIterator* _tmp37_;
		_tmp33_ = map;
		_tmp34_ = gee_multi_map_get_keys (G_TYPE_CHECK_INSTANCE_CAST (_tmp33_, GEE_TYPE_MULTI_MAP, GeeMultiMap));
		_tmp35_ = _tmp34_;
		_tmp36_ = gee_iterable_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp35_, GEE_TYPE_ITERABLE, GeeIterable));
		_tmp37_ = _tmp36_;
		_g_object_unref0 (_tmp35_);
		_container_it = _tmp37_;
		while (TRUE) {
			GeeIterator* _tmp38_;
			ContainerSource* container = NULL;
			GeeIterator* _tmp39_;
			gpointer _tmp40_;
			ContainerSource* _tmp41_;
			GeeHashMultiMap* _tmp42_;
			ContainerSource* _tmp43_;
			GeeCollection* _tmp44_;
			GeeCollection* _tmp45_;
			_tmp38_ = _container_it;
			if (!gee_iterator_next (_tmp38_)) {
				break;
			}
			_tmp39_ = _container_it;
			_tmp40_ = gee_iterator_get (_tmp39_);
			container = (ContainerSource*) _tmp40_;
			_tmp41_ = container;
			_tmp42_ = map;
			_tmp43_ = container;
			_tmp44_ = gee_multi_map_get (G_TYPE_CHECK_INSTANCE_CAST (_tmp42_, GEE_TYPE_MULTI_MAP, GeeMultiMap), _tmp43_);
			_tmp45_ = _tmp44_;
			container_source_establish_link_many (_tmp41_, _tmp45_);
			_g_object_unref0 (_tmp45_);
			_g_object_unref0 (container);
		}
		_g_object_unref0 (_container_it);
	}
	container_source_collection_thaw_attached_notifications (self);
	_g_object_unref0 (map);
}

static void
container_source_collection_on_contained_source_destroyed (ContainerSourceCollection* self,
                                                           DataSource* source)
{
	GeeIterator* iter = NULL;
	GeeHashSet* _tmp0_;
	GeeIterator* _tmp1_;
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	g_return_if_fail (IS_DATA_SOURCE (source));
	_tmp0_ = self->priv->holding_tank;
	_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
	iter = _tmp1_;
	while (TRUE) {
		GeeIterator* _tmp2_;
		ContainerSource* container = NULL;
		GeeIterator* _tmp3_;
		gpointer _tmp4_;
		gboolean _tmp5_ = FALSE;
		ContainerSource* _tmp6_;
		_tmp2_ = iter;
		if (!gee_iterator_next (_tmp2_)) {
			break;
		}
		_tmp3_ = iter;
		_tmp4_ = gee_iterator_get (_tmp3_);
		container = (ContainerSource*) _tmp4_;
		_tmp6_ = container;
		if (!container_source_has_links (_tmp6_)) {
			ContainerSource* _tmp7_;
			_tmp7_ = container;
			_tmp5_ = !IS_TAG (_tmp7_);
		} else {
			_tmp5_ = FALSE;
		}
		if (_tmp5_) {
			GeeIterator* _tmp8_;
			ContainerSource* _tmp9_;
			_tmp8_ = iter;
			gee_iterator_remove (_tmp8_);
			_tmp9_ = container;
			data_source_destroy_orphan (G_TYPE_CHECK_INSTANCE_CAST (_tmp9_, TYPE_DATA_SOURCE, DataSource), TRUE);
		}
		_g_object_unref0 (container);
	}
	_g_object_unref0 (iter);
}

static void
container_source_collection_real_notify_item_destroyed (SourceCollection* base,
                                                        DataSource* source)
{
	ContainerSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection);
	g_return_if_fail (IS_DATA_SOURCE (source));
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->attached_collections;
		_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_collection_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SourceCollection* _tmp5_;
			SourceBacklink* _tmp6_;
			SourceBacklink* _tmp7_;
			_tmp2_ = _collection_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _collection_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			collection = (SourceCollection*) _tmp4_;
			_tmp5_ = collection;
			_tmp6_ = container_source_get_backlink (G_TYPE_CHECK_INSTANCE_CAST (source, TYPE_CONTAINER_SOURCE, ContainerSource));
			_tmp7_ = _tmp6_;
			source_collection_remove_backlink (_tmp5_, _tmp7_);
			_source_backlink_unref0 (_tmp7_);
			_data_collection_unref0 (collection);
		}
		_g_object_unref0 (_collection_it);
	}
	SOURCE_COLLECTION_CLASS (container_source_collection_parent_class)->notify_item_destroyed (G_TYPE_CHECK_INSTANCE_CAST (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_SOURCE_COLLECTION, DatabaseSourceCollection), TYPE_SOURCE_COLLECTION, SourceCollection), source);
}

void
container_source_collection_evaporate (ContainerSourceCollection* self,
                                       ContainerSource* container)
{
	Marker* _tmp14_;
	Marker* _tmp15_;
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->attached_collections;
		_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_collection_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SourceCollection* _tmp5_;
			SourceBacklink* _tmp6_;
			SourceBacklink* _tmp7_;
			gboolean _tmp8_;
			_tmp2_ = _collection_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _collection_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			collection = (SourceCollection*) _tmp4_;
			_tmp5_ = collection;
			_tmp6_ = container_source_get_backlink (container);
			_tmp7_ = _tmp6_;
			_tmp8_ = source_collection_has_backlink (_tmp5_, _tmp7_);
			_source_backlink_unref0 (_tmp7_);
			if (_tmp8_) {
				Marker* _tmp9_;
				Marker* _tmp10_;
				GeeCollection* _tmp11_;
				GeeCollection* _tmp12_;
				gboolean added = FALSE;
				GeeHashSet* _tmp13_;
				_tmp9_ = data_collection_mark (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (container, TYPE_DATA_OBJECT, DataObject));
				_tmp10_ = _tmp9_;
				_tmp11_ = source_collection_unlink_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp10_, NULL, NULL);
				_tmp12_ = _tmp11_;
				_g_object_unref0 (_tmp12_);
				_g_object_unref0 (_tmp10_);
				_tmp13_ = self->priv->holding_tank;
				added = gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), container);
				_vala_assert (added, "added");
				_data_collection_unref0 (collection);
				_g_object_unref0 (_collection_it);
				return;
			}
			_data_collection_unref0 (collection);
		}
		_g_object_unref0 (_collection_it);
	}
	_tmp14_ = data_collection_mark (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection), G_TYPE_CHECK_INSTANCE_CAST (container, TYPE_DATA_OBJECT, DataObject));
	_tmp15_ = _tmp14_;
	source_collection_destroy_marked (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_SOURCE_COLLECTION, SourceCollection), _tmp15_, TRUE, NULL, NULL, NULL);
	_g_object_unref0 (_tmp15_);
}

static void
_container_source_collection_on_contained_sources_unlinking_source_collection_items_unlinking (SourceCollection* _sender,
                                                                                               GeeCollection* unlinking,
                                                                                               gpointer self)
{
	container_source_collection_on_contained_sources_unlinking ((ContainerSourceCollection*) self, unlinking);
}

static void
_container_source_collection_on_contained_sources_relinked_source_collection_items_relinked (SourceCollection* _sender,
                                                                                             GeeCollection* relinked,
                                                                                             gpointer self)
{
	container_source_collection_on_contained_sources_relinked ((ContainerSourceCollection*) self, relinked);
}

static void
_container_source_collection_on_contained_source_destroyed_source_collection_item_destroyed (SourceCollection* _sender,
                                                                                             DataSource* source,
                                                                                             gpointer self)
{
	container_source_collection_on_contained_source_destroyed ((ContainerSourceCollection*) self, source);
}

static void
_container_source_collection_on_contained_source_destroyed_source_collection_unlinked_destroyed (SourceCollection* _sender,
                                                                                                 DataSource* source,
                                                                                                 gpointer self)
{
	container_source_collection_on_contained_source_destroyed ((ContainerSourceCollection*) self, source);
}

void
container_source_collection_attach_collection (ContainerSourceCollection* self,
                                               SourceCollection* collection)
{
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp5_;
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	g_return_if_fail (IS_SOURCE_COLLECTION (collection));
	_tmp0_ = self->priv->attached_collections;
	if (gee_abstract_collection_contains (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), collection)) {
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = data_collection_to_string (G_TYPE_CHECK_INSTANCE_CAST (collection, TYPE_DATA_COLLECTION, DataCollection));
		_tmp2_ = _tmp1_;
		_tmp3_ = data_collection_to_string (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATA_COLLECTION, DataCollection));
		_tmp4_ = _tmp3_;
		g_warning ("ContainerSourceCollection.vala:215: attempted to multiple-attach '%s' " \
"to '%s'", _tmp2_, _tmp4_);
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		return;
	}
	_tmp5_ = self->priv->attached_collections;
	gee_abstract_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection), collection);
	g_signal_connect (collection, "items-unlinking", (GCallback) _container_source_collection_on_contained_sources_unlinking_source_collection_items_unlinking, self);
	g_signal_connect (collection, "items-relinked", (GCallback) _container_source_collection_on_contained_sources_relinked_source_collection_items_relinked, self);
	g_signal_connect (collection, "item-destroyed", (GCallback) _container_source_collection_on_contained_source_destroyed_source_collection_item_destroyed, self);
	g_signal_connect (collection, "unlinked-destroyed", (GCallback) _container_source_collection_on_contained_source_destroyed_source_collection_unlinked_destroyed, self);
}

void
container_source_collection_detach_all_collections (ContainerSourceCollection* self)
{
	GeeHashSet* _tmp13_;
	g_return_if_fail (IS_CONTAINER_SOURCE_COLLECTION (self));
	{
		GeeIterator* _collection_it = NULL;
		GeeHashSet* _tmp0_;
		GeeIterator* _tmp1_;
		_tmp0_ = self->priv->attached_collections;
		_tmp1_ = gee_abstract_collection_iterator (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
		_collection_it = _tmp1_;
		while (TRUE) {
			GeeIterator* _tmp2_;
			SourceCollection* collection = NULL;
			GeeIterator* _tmp3_;
			gpointer _tmp4_;
			SourceCollection* _tmp5_;
			guint _tmp6_;
			SourceCollection* _tmp7_;
			guint _tmp8_;
			SourceCollection* _tmp9_;
			guint _tmp10_;
			SourceCollection* _tmp11_;
			guint _tmp12_;
			_tmp2_ = _collection_it;
			if (!gee_iterator_next (_tmp2_)) {
				break;
			}
			_tmp3_ = _collection_it;
			_tmp4_ = gee_iterator_get (_tmp3_);
			collection = (SourceCollection*) _tmp4_;
			_tmp5_ = collection;
			g_signal_parse_name ("items-unlinking", TYPE_SOURCE_COLLECTION, &_tmp6_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp5_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp6_, 0, NULL, (GCallback) _container_source_collection_on_contained_sources_unlinking_source_collection_items_unlinking, self);
			_tmp7_ = collection;
			g_signal_parse_name ("items-relinked", TYPE_SOURCE_COLLECTION, &_tmp8_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp7_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp8_, 0, NULL, (GCallback) _container_source_collection_on_contained_sources_relinked_source_collection_items_relinked, self);
			_tmp9_ = collection;
			g_signal_parse_name ("item-destroyed", TYPE_SOURCE_COLLECTION, &_tmp10_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp9_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp10_, 0, NULL, (GCallback) _container_source_collection_on_contained_source_destroyed_source_collection_item_destroyed, self);
			_tmp11_ = collection;
			g_signal_parse_name ("unlinked-destroyed", TYPE_SOURCE_COLLECTION, &_tmp12_, NULL, FALSE);
			g_signal_handlers_disconnect_matched (_tmp11_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp12_, 0, NULL, (GCallback) _container_source_collection_on_contained_source_destroyed_source_collection_unlinked_destroyed, self);
			_data_collection_unref0 (collection);
		}
		_g_object_unref0 (_collection_it);
	}
	_tmp13_ = self->priv->attached_collections;
	gee_abstract_collection_clear (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, GEE_TYPE_ABSTRACT_COLLECTION, GeeAbstractCollection));
}

static void
container_source_collection_real_container_contents_added (ContainerSourceCollection* self,
                                                           ContainerSource* container,
                                                           GeeCollection* added,
                                                           gboolean relinked)
{
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN (GClosure * closure,
                                                     GValue * return_value,
                                                     guint n_param_values,
                                                     const GValue * param_values,
                                                     gpointer invocation_hint,
                                                     gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gpointer arg_2, gboolean arg_3, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_boolean (param_values + 3), data2);
}

static void
container_source_collection_real_container_contents_removed (ContainerSourceCollection* self,
                                                             ContainerSource* container,
                                                             GeeCollection* removed,
                                                             gboolean unlinked)
{
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
}

static void
container_source_collection_real_container_contents_altered (ContainerSourceCollection* self,
                                                             ContainerSource* container,
                                                             GeeCollection* added,
                                                             gboolean relinked,
                                                             GeeCollection* removed,
                                                             gboolean unlinked)
{
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	g_return_if_fail ((added == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (added, GEE_TYPE_COLLECTION));
	g_return_if_fail ((removed == NULL) || G_TYPE_CHECK_INSTANCE_TYPE (removed, GEE_TYPE_COLLECTION));
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN (GClosure * closure,
                                                                    GValue * return_value,
                                                                    guint n_param_values,
                                                                    const GValue * param_values,
                                                                    gpointer invocation_hint,
                                                                    gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN) (gpointer data1, gpointer arg_1, gpointer arg_2, gboolean arg_3, gpointer arg_4, gboolean arg_5, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 6);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), g_value_get_boolean (param_values + 3), g_value_get_object (param_values + 4), g_value_get_boolean (param_values + 5), data2);
}

static void
container_source_collection_real_backlink_to_container_removed (ContainerSourceCollection* self,
                                                                ContainerSource* container,
                                                                GeeCollection* sources)
{
	g_return_if_fail (IS_CONTAINER_SOURCE (container));
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (sources, GEE_TYPE_COLLECTION));
}

static void
g_cclosure_user_marshal_VOID__OBJECT_OBJECT (GClosure * closure,
                                             GValue * return_value,
                                             guint n_param_values,
                                             const GValue * param_values,
                                             gpointer invocation_hint,
                                             gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__OBJECT_OBJECT) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__OBJECT_OBJECT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__OBJECT_OBJECT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_object (param_values + 1), g_value_get_object (param_values + 2), data2);
}

static void
container_source_collection_class_init (ContainerSourceCollectionClass * klass,
                                        gpointer klass_data)
{
	container_source_collection_parent_class = g_type_class_peek_parent (klass);
	((DataCollectionClass *) klass)->finalize = container_source_collection_finalize;
	g_type_class_adjust_private_offset (klass, &ContainerSourceCollection_private_offset);
	((SourceCollectionClass *) klass)->notify_backlink_removed = (void (*) (SourceCollection*, SourceBacklink*, GeeCollection*)) container_source_collection_real_notify_backlink_removed;
	((ContainerSourceCollectionClass *) klass)->notify_container_contents_added = (void (*) (ContainerSourceCollection*, ContainerSource*, GeeCollection*, gboolean)) container_source_collection_real_notify_container_contents_added;
	((ContainerSourceCollectionClass *) klass)->notify_container_contents_removed = (void (*) (ContainerSourceCollection*, ContainerSource*, GeeCollection*, gboolean)) container_source_collection_real_notify_container_contents_removed;
	((ContainerSourceCollectionClass *) klass)->notify_container_contents_altered = (void (*) (ContainerSourceCollection*, ContainerSource*, GeeCollection*, gboolean, GeeCollection*, gboolean)) container_source_collection_real_notify_container_contents_altered;
	((ContainerSourceCollectionClass *) klass)->notify_backlink_to_container_removed = (void (*) (ContainerSourceCollection*, ContainerSource*, GeeCollection*)) container_source_collection_real_notify_backlink_to_container_removed;
	((ContainerSourceCollectionClass *) klass)->get_containers_holding_source = (GeeCollection* (*) (ContainerSourceCollection*, DataSource*)) container_source_collection_real_get_containers_holding_source;
	((ContainerSourceCollectionClass *) klass)->convert_backlink_to_container = (ContainerSource* (*) (ContainerSourceCollection*, SourceBacklink*)) container_source_collection_real_convert_backlink_to_container;
	((SourceCollectionClass *) klass)->notify_item_destroyed = (void (*) (SourceCollection*, DataSource*)) container_source_collection_real_notify_item_destroyed;
	((ContainerSourceCollectionClass *) klass)->container_contents_added = container_source_collection_real_container_contents_added;
	((ContainerSourceCollectionClass *) klass)->container_contents_removed = container_source_collection_real_container_contents_removed;
	((ContainerSourceCollectionClass *) klass)->container_contents_altered = container_source_collection_real_container_contents_altered;
	((ContainerSourceCollectionClass *) klass)->backlink_to_container_removed = container_source_collection_real_backlink_to_container_removed;
	container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ADDED_SIGNAL] = g_signal_new ("container-contents-added", TYPE_CONTAINER_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ContainerSourceCollectionClass, container_contents_added), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN, G_TYPE_NONE, 3, TYPE_CONTAINER_SOURCE, GEE_TYPE_COLLECTION, G_TYPE_BOOLEAN);
	container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_REMOVED_SIGNAL] = g_signal_new ("container-contents-removed", TYPE_CONTAINER_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ContainerSourceCollectionClass, container_contents_removed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN, G_TYPE_NONE, 3, TYPE_CONTAINER_SOURCE, GEE_TYPE_COLLECTION, G_TYPE_BOOLEAN);
	container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_CONTAINER_CONTENTS_ALTERED_SIGNAL] = g_signal_new ("container-contents-altered", TYPE_CONTAINER_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ContainerSourceCollectionClass, container_contents_altered), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT_BOOLEAN_OBJECT_BOOLEAN, G_TYPE_NONE, 5, TYPE_CONTAINER_SOURCE, GEE_TYPE_COLLECTION, G_TYPE_BOOLEAN, GEE_TYPE_COLLECTION, G_TYPE_BOOLEAN);
	container_source_collection_signals[CONTAINER_SOURCE_COLLECTION_BACKLINK_TO_CONTAINER_REMOVED_SIGNAL] = g_signal_new ("backlink-to-container-removed", TYPE_CONTAINER_SOURCE_COLLECTION, G_SIGNAL_RUN_LAST, G_STRUCT_OFFSET (ContainerSourceCollectionClass, backlink_to_container_removed), NULL, NULL, g_cclosure_user_marshal_VOID__OBJECT_OBJECT, G_TYPE_NONE, 2, TYPE_CONTAINER_SOURCE, GEE_TYPE_COLLECTION);
}

static void
container_source_collection_instance_init (ContainerSourceCollection * self,
                                           gpointer klass)
{
	GeeHashSet* _tmp0_;
	GeeHashSet* _tmp1_;
	self->priv = container_source_collection_get_instance_private (self);
	_tmp0_ = gee_hash_set_new (TYPE_SOURCE_COLLECTION, (GBoxedCopyFunc) data_collection_ref, (GDestroyNotify) data_collection_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->attached_collections = _tmp0_;
	_tmp1_ = gee_hash_set_new (TYPE_CONTAINER_SOURCE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL, NULL, NULL, NULL);
	self->priv->holding_tank = _tmp1_;
}

static void
container_source_collection_finalize (DataCollection * obj)
{
	ContainerSourceCollection * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CONTAINER_SOURCE_COLLECTION, ContainerSourceCollection);
	container_source_collection_detach_all_collections (self);
	_g_object_unref0 (self->priv->attached_collections);
	_g_free0 (self->priv->backlink_name);
	_g_object_unref0 (self->priv->holding_tank);
	DATA_COLLECTION_CLASS (container_source_collection_parent_class)->finalize (obj);
}

static GType
container_source_collection_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (ContainerSourceCollectionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) container_source_collection_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ContainerSourceCollection), 0, (GInstanceInitFunc) container_source_collection_instance_init, NULL };
	GType container_source_collection_type_id;
	container_source_collection_type_id = g_type_register_static (TYPE_DATABASE_SOURCE_COLLECTION, "ContainerSourceCollection", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	ContainerSourceCollection_private_offset = g_type_add_instance_private (container_source_collection_type_id, sizeof (ContainerSourceCollectionPrivate));
	return container_source_collection_type_id;
}

GType
container_source_collection_get_type (void)
{
	static volatile gsize container_source_collection_type_id__once = 0;
	if (g_once_init_enter (&container_source_collection_type_id__once)) {
		GType container_source_collection_type_id;
		container_source_collection_type_id = container_source_collection_get_type_once ();
		g_once_init_leave (&container_source_collection_type_id__once, container_source_collection_type_id);
	}
	return container_source_collection_type_id__once;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

