/* FaceTable.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FaceTable.vala, do not modify */

/* Copyright 2018 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <string.h>
#include <stdlib.h>
#include <gobject/gvaluecollector.h>
#include <sqlite3.h>
#include <gee.h>

#define FACE_ID_INVALID ((gint64) -1)
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_FACE_ID (face_id_get_type ())
typedef struct _FaceID FaceID;

#define TYPE_FACE_ROW (face_row_get_type ())
#define FACE_ROW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_ROW, FaceRow))
#define FACE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_ROW, FaceRowClass))
#define IS_FACE_ROW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_ROW))
#define IS_FACE_ROW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_ROW))
#define FACE_ROW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_ROW, FaceRowClass))

typedef struct _FaceRow FaceRow;
typedef struct _FaceRowClass FaceRowClass;
typedef struct _FaceRowPrivate FaceRowPrivate;

#define TYPE_PHOTO_ID (photo_id_get_type ())
typedef struct _PhotoID PhotoID;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _ParamSpecFaceRow ParamSpecFaceRow;

#define TYPE_DATABASE_TABLE (database_table_get_type ())
#define DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATABASE_TABLE, DatabaseTable))
#define DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATABASE_TABLE, DatabaseTableClass))
#define IS_DATABASE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATABASE_TABLE))
#define IS_DATABASE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATABASE_TABLE))
#define DATABASE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATABASE_TABLE, DatabaseTableClass))

typedef struct _DatabaseTable DatabaseTable;
typedef struct _DatabaseTableClass DatabaseTableClass;
typedef struct _DatabaseTablePrivate DatabaseTablePrivate;

#define TYPE_FACE_TABLE (face_table_get_type ())
#define FACE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_TABLE, FaceTable))
#define FACE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_TABLE, FaceTableClass))
#define IS_FACE_TABLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_TABLE))
#define IS_FACE_TABLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_TABLE))
#define FACE_TABLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_TABLE, FaceTableClass))

typedef struct _FaceTable FaceTable;
typedef struct _FaceTableClass FaceTableClass;
typedef struct _FaceTablePrivate FaceTablePrivate;
#define _sqlite3_finalize0(var) ((var == NULL) ? NULL : (var = (sqlite3_finalize (var), NULL)))
#define _database_table_unref0(var) ((var == NULL) ? NULL : (var = (database_table_unref (var), NULL)))

#define TYPE_DATABASE_ERROR (database_error_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _face_row_unref0(var) ((var == NULL) ? NULL : (var = (face_row_unref (var), NULL)))
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _FaceID {
	gint64 id;
};

struct _PhotoID {
	gint64 id;
};

struct _FaceRow {
	GTypeInstance parent_instance;
	volatile int ref_count;
	FaceRowPrivate * priv;
	FaceID face_id;
	gchar* name;
	gint64 time_created;
	PhotoID ref;
	gchar* vec;
};

struct _FaceRowClass {
	GTypeClass parent_class;
	void (*finalize) (FaceRow *self);
};

struct _ParamSpecFaceRow {
	GParamSpec parent_instance;
};

struct _DatabaseTable {
	GTypeInstance parent_instance;
	volatile int ref_count;
	DatabaseTablePrivate * priv;
	gchar* table_name;
};

struct _DatabaseTableClass {
	GTypeClass parent_class;
	void (*finalize) (DatabaseTable *self);
};

struct _FaceTable {
	DatabaseTable parent_instance;
	FaceTablePrivate * priv;
};

struct _FaceTableClass {
	DatabaseTableClass parent_class;
};

typedef enum  {
	DATABASE_ERROR_ERROR,
	DATABASE_ERROR_BACKING,
	DATABASE_ERROR_MEMORY,
	DATABASE_ERROR_ABORT,
	DATABASE_ERROR_LIMITS,
	DATABASE_ERROR_TYPESPEC
} DatabaseError;
#define DATABASE_ERROR database_error_quark ()

static gpointer face_row_parent_class = NULL;
static gpointer face_table_parent_class = NULL;
static FaceTable* face_table_instance;
static FaceTable* face_table_instance = NULL;
VALA_EXTERN sqlite3* database_table_db;

VALA_EXTERN GType face_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceID* face_id_dup (const FaceID* self);
VALA_EXTERN void face_id_free (FaceID* self);
VALA_EXTERN void face_id_init (FaceID *self,
                   gint64 id);
VALA_EXTERN gboolean face_id_is_invalid (FaceID *self);
VALA_EXTERN gboolean face_id_is_valid (FaceID *self);
VALA_EXTERN gpointer face_row_ref (gpointer instance);
VALA_EXTERN void face_row_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_face_row (const gchar* name,
                                 const gchar* nick,
                                 const gchar* blurb,
                                 GType object_type,
                                 GParamFlags flags);
VALA_EXTERN void value_set_face_row (GValue* value,
                         gpointer v_object);
VALA_EXTERN void value_take_face_row (GValue* value,
                          gpointer v_object);
VALA_EXTERN gpointer value_get_face_row (const GValue* value);
VALA_EXTERN GType face_row_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceRow, face_row_unref)
VALA_EXTERN GType photo_id_get_type (void) G_GNUC_CONST ;
VALA_EXTERN PhotoID* photo_id_dup (const PhotoID* self);
VALA_EXTERN void photo_id_free (PhotoID* self);
VALA_EXTERN FaceRow* face_row_new (void);
VALA_EXTERN FaceRow* face_row_construct (GType object_type);
static void face_row_finalize (FaceRow * obj);
static GType face_row_get_type_once (void);
VALA_EXTERN gpointer database_table_ref (gpointer instance);
VALA_EXTERN void database_table_unref (gpointer instance);
VALA_EXTERN GParamSpec* param_spec_database_table (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
VALA_EXTERN void value_set_database_table (GValue* value,
                               gpointer v_object);
VALA_EXTERN void value_take_database_table (GValue* value,
                                gpointer v_object);
VALA_EXTERN gpointer value_get_database_table (const GValue* value);
VALA_EXTERN GType database_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DatabaseTable, database_table_unref)
VALA_EXTERN GType face_table_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceTable, database_table_unref)
static FaceTable* face_table_new (void);
static FaceTable* face_table_construct (GType object_type);
VALA_EXTERN DatabaseTable* database_table_construct (GType object_type);
VALA_EXTERN void database_table_set_table_name (DatabaseTable* self,
                                    const gchar* table_name);
VALA_EXTERN void database_table_fatal (const gchar* op,
                           gint res);
VALA_EXTERN FaceTable* face_table_get_instance (void);
VALA_EXTERN GQuark database_error_quark (void);
VALA_EXTERN GType database_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceRow* face_table_add (FaceTable* self,
                         const gchar* name,
                         GError** error);
VALA_EXTERN gint64 now_sec (void);
VALA_EXTERN void database_table_throw_error (const gchar* method,
                                 gint res,
                                 GError** error);
VALA_EXTERN void face_table_create_from_row (FaceTable* self,
                                 FaceRow* row,
                                 FaceID* result,
                                 GError** error);
VALA_EXTERN void face_table_remove (FaceTable* self,
                        FaceID* face_id,
                        GError** error);
VALA_EXTERN void database_table_delete_by_id (DatabaseTable* self,
                                  gint64 id,
                                  GError** error);
VALA_EXTERN gchar* face_table_get_name (FaceTable* self,
                            FaceID* face_id,
                            GError** error);
VALA_EXTERN gboolean database_table_select_by_id (DatabaseTable* self,
                                      gint64 id,
                                      const gchar* columns,
                                      sqlite3_stmt** stmt);
VALA_EXTERN FaceRow* face_table_get_row (FaceTable* self,
                             FaceID* face_id,
                             GError** error);
VALA_EXTERN GeeList* face_table_get_all_rows (FaceTable* self,
                                  GError** error);
VALA_EXTERN void face_table_rename (FaceTable* self,
                        FaceID* face_id,
                        const gchar* new_name,
                        GError** error);
VALA_EXTERN void database_table_update_text_by_id_2 (DatabaseTable* self,
                                         gint64 id,
                                         const gchar* column,
                                         const gchar* text,
                                         GError** error);
VALA_EXTERN void face_table_set_reference (FaceTable* self,
                               FaceID* face_id,
                               PhotoID* photo_id,
                               GError** error);
VALA_EXTERN GeeList* face_table_get_ref_rows (FaceTable* self,
                                  GError** error);
VALA_EXTERN void photo_id_init (PhotoID *self,
                    gint64 id);
static void face_table_finalize (DatabaseTable * obj);
static GType face_table_get_type_once (void);

void
face_id_init (FaceID *self,
              gint64 id)
{
	memset (self, 0, sizeof (FaceID));
	(*self).id = id;
}

gboolean
face_id_is_invalid (FaceID *self)
{
	gboolean result;
	result = (*self).id == FACE_ID_INVALID;
	return result;
}

gboolean
face_id_is_valid (FaceID *self)
{
	gboolean result;
	result = (*self).id != FACE_ID_INVALID;
	return result;
}

FaceID*
face_id_dup (const FaceID* self)
{
	FaceID* dup;
	dup = g_new0 (FaceID, 1);
	memcpy (dup, self, sizeof (FaceID));
	return dup;
}

void
face_id_free (FaceID* self)
{
	g_free (self);
}

static GType
face_id_get_type_once (void)
{
	GType face_id_type_id;
	face_id_type_id = g_boxed_type_register_static ("FaceID", (GBoxedCopyFunc) face_id_dup, (GBoxedFreeFunc) face_id_free);
	return face_id_type_id;
}

GType
face_id_get_type (void)
{
	static volatile gsize face_id_type_id__once = 0;
	if (g_once_init_enter (&face_id_type_id__once)) {
		GType face_id_type_id;
		face_id_type_id = face_id_get_type_once ();
		g_once_init_leave (&face_id_type_id__once, face_id_type_id);
	}
	return face_id_type_id__once;
}

FaceRow*
face_row_construct (GType object_type)
{
	FaceRow* self = NULL;
	self = (FaceRow*) g_type_create_instance (object_type);
	return self;
}

FaceRow*
face_row_new (void)
{
	return face_row_construct (TYPE_FACE_ROW);
}

static void
value_face_row_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
value_face_row_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		face_row_unref (value->data[0].v_pointer);
	}
}

static void
value_face_row_copy_value (const GValue* src_value,
                           GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = face_row_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
value_face_row_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
value_face_row_collect_value (GValue* value,
                              guint n_collect_values,
                              GTypeCValue* collect_values,
                              guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		FaceRow * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = face_row_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
value_face_row_lcopy_value (const GValue* value,
                            guint n_collect_values,
                            GTypeCValue* collect_values,
                            guint collect_flags)
{
	FaceRow ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = face_row_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
param_spec_face_row (const gchar* name,
                     const gchar* nick,
                     const gchar* blurb,
                     GType object_type,
                     GParamFlags flags)
{
	ParamSpecFaceRow* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_FACE_ROW), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
value_get_face_row (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FACE_ROW), NULL);
	return value->data[0].v_pointer;
}

void
value_set_face_row (GValue* value,
                    gpointer v_object)
{
	FaceRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FACE_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FACE_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		face_row_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		face_row_unref (old);
	}
}

void
value_take_face_row (GValue* value,
                     gpointer v_object)
{
	FaceRow * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_FACE_ROW));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_FACE_ROW));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		face_row_unref (old);
	}
}

static void
face_row_class_init (FaceRowClass * klass,
                     gpointer klass_data)
{
	face_row_parent_class = g_type_class_peek_parent (klass);
	((FaceRowClass *) klass)->finalize = face_row_finalize;
}

static void
face_row_instance_init (FaceRow * self,
                        gpointer klass)
{
	self->ref_count = 1;
}

static void
face_row_finalize (FaceRow * obj)
{
	FaceRow * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FACE_ROW, FaceRow);
	g_signal_handlers_destroy (self);
	_g_free0 (self->name);
	_g_free0 (self->vec);
}

static GType
face_row_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { value_face_row_init, value_face_row_free_value, value_face_row_copy_value, value_face_row_peek_pointer, "p", value_face_row_collect_value, "p", value_face_row_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (FaceRowClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) face_row_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FaceRow), 0, (GInstanceInitFunc) face_row_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType face_row_type_id;
	face_row_type_id = g_type_register_fundamental (g_type_fundamental_next (), "FaceRow", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return face_row_type_id;
}

GType
face_row_get_type (void)
{
	static volatile gsize face_row_type_id__once = 0;
	if (g_once_init_enter (&face_row_type_id__once)) {
		GType face_row_type_id;
		face_row_type_id = face_row_get_type_once ();
		g_once_init_leave (&face_row_type_id__once, face_row_type_id);
	}
	return face_row_type_id__once;
}

gpointer
face_row_ref (gpointer instance)
{
	FaceRow * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
face_row_unref (gpointer instance)
{
	FaceRow * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		FACE_ROW_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

static FaceTable*
face_table_construct (GType object_type)
{
	FaceTable* self = NULL;
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	self = (FaceTable*) database_table_construct (object_type);
	database_table_set_table_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), "FaceTable");
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "CREATE TABLE IF NOT EXISTS " "FaceTable " "(" "id INTEGER NOT NULL PRIMARY KEY, " "name TEXT NOT NULL, " "time_created TIMESTAMP, " "ref INTEGER DEFAULT -1" ")", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	res = sqlite3_step (_tmp3_);
	if (res != SQLITE_DONE) {
		database_table_fatal ("create FaceTable", res);
	}
	_sqlite3_finalize0 (stmt);
	return self;
}

static FaceTable*
face_table_new (void)
{
	return face_table_construct (TYPE_FACE_TABLE);
}

static gpointer
_database_table_ref0 (gpointer self)
{
	return self ? database_table_ref (self) : NULL;
}

FaceTable*
face_table_get_instance (void)
{
	FaceTable* _tmp0_;
	FaceTable* _tmp2_;
	FaceTable* _tmp3_;
	FaceTable* result;
	_tmp0_ = face_table_instance;
	if (_tmp0_ == NULL) {
		FaceTable* _tmp1_;
		_tmp1_ = face_table_new ();
		_database_table_unref0 (face_table_instance);
		face_table_instance = _tmp1_;
	}
	_tmp2_ = face_table_instance;
	_tmp3_ = _database_table_ref0 (_tmp2_);
	result = _tmp3_;
	return result;
}

FaceRow*
face_table_add (FaceTable* self,
                const gchar* name,
                GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	gint64 time_created = 0LL;
	sqlite3_stmt* _tmp3_;
	gchar* _tmp4_;
	GDestroyNotify _tmp5_;
	sqlite3_stmt* _tmp6_;
	sqlite3_stmt* _tmp7_;
	FaceRow* row = NULL;
	FaceRow* _tmp8_;
	FaceRow* _tmp9_;
	sqlite3* _tmp10_;
	FaceRow* _tmp11_;
	gchar* _tmp12_;
	FaceRow* _tmp13_;
	GError* _inner_error0_ = NULL;
	FaceRow* result;
	g_return_val_if_fail (IS_FACE_TABLE (self), NULL);
	g_return_val_if_fail (name != NULL, NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO FaceTable (name, time_created) VALUES (?, ?)", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	time_created = now_sec ();
	_tmp3_ = stmt;
	_tmp4_ = g_strdup (name);
	_tmp5_ = g_free;
	res = sqlite3_bind_text (_tmp3_, 1, _tmp4_, -1, _tmp5_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp6_ = stmt;
	res = sqlite3_bind_int64 (_tmp6_, 2, time_created);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	res = sqlite3_step (_tmp7_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("FaceTable.add", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return NULL;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return NULL;
			}
		}
	}
	_tmp8_ = face_row_new ();
	row = _tmp8_;
	_tmp9_ = row;
	_tmp10_ = database_table_db;
	face_id_init (&_tmp9_->face_id, sqlite3_last_insert_rowid (_tmp10_));
	_tmp11_ = row;
	_tmp12_ = g_strdup (name);
	_g_free0 (_tmp11_->name);
	_tmp11_->name = _tmp12_;
	_tmp13_ = row;
	_tmp13_->time_created = time_created;
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
face_table_create_from_row (FaceTable* self,
                            FaceRow* row,
                            FaceID* result,
                            GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GDestroyNotify _tmp6_;
	sqlite3_stmt* _tmp7_;
	sqlite3_stmt* _tmp8_;
	sqlite3* _tmp9_;
	FaceID _tmp10_ = {0};
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_FACE_TABLE (self));
	g_return_if_fail (IS_FACE_ROW (row));
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "INSERT INTO FaceTable (name, time_created) VALUES (?, ?)", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = row->name;
	_tmp5_ = g_strdup (_tmp4_);
	_tmp6_ = g_free;
	res = sqlite3_bind_text (_tmp3_, 1, _tmp5_, -1, _tmp6_);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	res = sqlite3_bind_int64 (_tmp7_, 2, row->time_created);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp8_ = stmt;
	res = sqlite3_step (_tmp8_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("FaceTable.create_from_row", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_tmp9_ = database_table_db;
	face_id_init (&_tmp10_, sqlite3_last_insert_rowid (_tmp9_));
	*result = _tmp10_;
	_sqlite3_finalize0 (stmt);
	return;
}

void
face_table_remove (FaceTable* self,
                   FaceID* face_id,
                   GError** error)
{
	FaceID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_FACE_TABLE (self));
	g_return_if_fail (face_id != NULL);
	_tmp0_ = *face_id;
	database_table_delete_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

gchar*
face_table_get_name (FaceTable* self,
                     FaceID* face_id,
                     GError** error)
{
	sqlite3_stmt* stmt = NULL;
	FaceID _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gboolean _tmp2_;
	sqlite3_stmt* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* result;
	g_return_val_if_fail (IS_FACE_TABLE (self), NULL);
	g_return_val_if_fail (face_id != NULL, NULL);
	_tmp0_ = *face_id;
	_tmp2_ = database_table_select_by_id (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "name", &_tmp1_);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	if (!_tmp2_) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	}
	_tmp3_ = stmt;
	_tmp4_ = (const gchar*) sqlite3_column_text (_tmp3_, 0);
	_tmp5_ = g_strdup (_tmp4_);
	result = _tmp5_;
	_sqlite3_finalize0 (stmt);
	return result;
}

FaceRow*
face_table_get_row (FaceTable* self,
                    FaceID* face_id,
                    GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	FaceID _tmp4_;
	sqlite3_stmt* _tmp5_;
	FaceRow* row = NULL;
	FaceRow* _tmp6_;
	FaceRow* _tmp7_;
	FaceID _tmp8_;
	FaceRow* _tmp9_;
	sqlite3_stmt* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	FaceRow* _tmp13_;
	sqlite3_stmt* _tmp14_;
	GError* _inner_error0_ = NULL;
	FaceRow* result;
	g_return_val_if_fail (IS_FACE_TABLE (self), NULL);
	g_return_val_if_fail (face_id != NULL, NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT name, time_created FROM FaceTable WHERE id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *face_id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	res = sqlite3_step (_tmp5_);
	if (res == SQLITE_DONE) {
		result = NULL;
		_sqlite3_finalize0 (stmt);
		return result;
	} else {
		if (res != SQLITE_ROW) {
			database_table_throw_error ("FaceTable.get_row", res, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				if (_inner_error0_->domain == DATABASE_ERROR) {
					g_propagate_error (error, _inner_error0_);
					_sqlite3_finalize0 (stmt);
					return NULL;
				} else {
					_sqlite3_finalize0 (stmt);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
		}
	}
	_tmp6_ = face_row_new ();
	row = _tmp6_;
	_tmp7_ = row;
	_tmp8_ = *face_id;
	_tmp7_->face_id = _tmp8_;
	_tmp9_ = row;
	_tmp10_ = stmt;
	_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 0);
	_tmp12_ = g_strdup (_tmp11_);
	_g_free0 (_tmp9_->name);
	_tmp9_->name = _tmp12_;
	_tmp13_ = row;
	_tmp14_ = stmt;
	_tmp13_->time_created = sqlite3_column_int64 (_tmp14_, 1);
	result = row;
	_sqlite3_finalize0 (stmt);
	return result;
}

GeeList*
face_table_get_all_rows (FaceTable* self,
                         GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	GeeList* rows = NULL;
	GeeArrayList* _tmp3_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (IS_FACE_TABLE (self), NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, name, time_created FROM FaceTable", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = gee_array_list_new (TYPE_FACE_ROW, (GBoxedCopyFunc) face_row_ref, (GDestroyNotify) face_row_unref, NULL, NULL, NULL);
	rows = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_LIST, GeeList);
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp5_;
			FaceRow* row = NULL;
			FaceRow* _tmp6_;
			FaceRow* _tmp7_;
			sqlite3_stmt* _tmp8_;
			FaceRow* _tmp9_;
			sqlite3_stmt* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			FaceRow* _tmp13_;
			sqlite3_stmt* _tmp14_;
			GeeList* _tmp15_;
			FaceRow* _tmp16_;
			if (!_tmp4_) {
			}
			_tmp4_ = FALSE;
			_tmp5_ = stmt;
			res = sqlite3_step (_tmp5_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("FaceTable.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (rows);
							_sqlite3_finalize0 (stmt);
							return NULL;
						} else {
							_g_object_unref0 (rows);
							_sqlite3_finalize0 (stmt);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp6_ = face_row_new ();
			row = _tmp6_;
			_tmp7_ = row;
			_tmp8_ = stmt;
			face_id_init (&_tmp7_->face_id, sqlite3_column_int64 (_tmp8_, 0));
			_tmp9_ = row;
			_tmp10_ = stmt;
			_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 1);
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (_tmp9_->name);
			_tmp9_->name = _tmp12_;
			_tmp13_ = row;
			_tmp14_ = stmt;
			_tmp13_->time_created = sqlite3_column_int64 (_tmp14_, 2);
			_tmp15_ = rows;
			_tmp16_ = row;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp15_, GEE_TYPE_COLLECTION, GeeCollection), _tmp16_);
			_face_row_unref0 (row);
		}
	}
	result = rows;
	_sqlite3_finalize0 (stmt);
	return result;
}

void
face_table_rename (FaceTable* self,
                   FaceID* face_id,
                   const gchar* new_name,
                   GError** error)
{
	FaceID _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_FACE_TABLE (self));
	g_return_if_fail (face_id != NULL);
	g_return_if_fail (new_name != NULL);
	_tmp0_ = *face_id;
	database_table_update_text_by_id_2 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_DATABASE_TABLE, DatabaseTable), _tmp0_.id, "name", new_name, &_inner_error0_);
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		if (_inner_error0_->domain == DATABASE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			return;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
}

void
face_table_set_reference (FaceTable* self,
                          FaceID* face_id,
                          PhotoID* photo_id,
                          GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	sqlite3_stmt* _tmp3_;
	PhotoID _tmp4_;
	sqlite3_stmt* _tmp5_;
	FaceID _tmp6_;
	sqlite3_stmt* _tmp7_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (IS_FACE_TABLE (self));
	g_return_if_fail (face_id != NULL);
	g_return_if_fail (photo_id != NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "UPDATE FaceTable SET ref=? WHERE id=?", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = stmt;
	_tmp4_ = *photo_id;
	res = sqlite3_bind_int64 (_tmp3_, 1, _tmp4_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp5_ = stmt;
	_tmp6_ = *face_id;
	res = sqlite3_bind_int64 (_tmp5_, 2, _tmp6_.id);
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp7_ = stmt;
	res = sqlite3_step (_tmp7_);
	if (res != SQLITE_DONE) {
		database_table_throw_error ("FaceTable.set_reference", res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == DATABASE_ERROR) {
				g_propagate_error (error, _inner_error0_);
				_sqlite3_finalize0 (stmt);
				return;
			} else {
				_sqlite3_finalize0 (stmt);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		}
	}
	_sqlite3_finalize0 (stmt);
}

GeeList*
face_table_get_ref_rows (FaceTable* self,
                         GError** error)
{
	sqlite3_stmt* stmt = NULL;
	gint res = 0;
	sqlite3* _tmp0_;
	sqlite3_stmt* _tmp1_ = NULL;
	gint _tmp2_;
	GeeList* rows = NULL;
	GeeArrayList* _tmp3_;
	GError* _inner_error0_ = NULL;
	GeeList* result;
	g_return_val_if_fail (IS_FACE_TABLE (self), NULL);
	_tmp0_ = database_table_db;
	_tmp2_ = sqlite3_prepare_v2 (_tmp0_, "SELECT id, name, time_created, ref FROM FaceTable WHERE ref != -1", -1, &_tmp1_, NULL);
	_sqlite3_finalize0 (stmt);
	stmt = _tmp1_;
	res = _tmp2_;
	_vala_assert (res == SQLITE_OK, "res == Sqlite.OK");
	_tmp3_ = gee_array_list_new (TYPE_FACE_ROW, (GBoxedCopyFunc) face_row_ref, (GDestroyNotify) face_row_unref, NULL, NULL, NULL);
	rows = G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, GEE_TYPE_LIST, GeeList);
	{
		gboolean _tmp4_ = FALSE;
		_tmp4_ = TRUE;
		while (TRUE) {
			sqlite3_stmt* _tmp5_;
			FaceRow* row = NULL;
			FaceRow* _tmp6_;
			FaceRow* _tmp7_;
			sqlite3_stmt* _tmp8_;
			FaceRow* _tmp9_;
			sqlite3_stmt* _tmp10_;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			FaceRow* _tmp13_;
			sqlite3_stmt* _tmp14_;
			FaceRow* _tmp15_;
			sqlite3_stmt* _tmp16_;
			GeeList* _tmp17_;
			FaceRow* _tmp18_;
			if (!_tmp4_) {
			}
			_tmp4_ = FALSE;
			_tmp5_ = stmt;
			res = sqlite3_step (_tmp5_);
			if (res == SQLITE_DONE) {
				break;
			} else {
				if (res != SQLITE_ROW) {
					database_table_throw_error ("FaceTable.get_all_rows", res, &_inner_error0_);
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						if (_inner_error0_->domain == DATABASE_ERROR) {
							g_propagate_error (error, _inner_error0_);
							_g_object_unref0 (rows);
							_sqlite3_finalize0 (stmt);
							return NULL;
						} else {
							_g_object_unref0 (rows);
							_sqlite3_finalize0 (stmt);
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
							g_clear_error (&_inner_error0_);
							return NULL;
						}
					}
				}
			}
			_tmp6_ = face_row_new ();
			row = _tmp6_;
			_tmp7_ = row;
			_tmp8_ = stmt;
			face_id_init (&_tmp7_->face_id, sqlite3_column_int64 (_tmp8_, 0));
			_tmp9_ = row;
			_tmp10_ = stmt;
			_tmp11_ = (const gchar*) sqlite3_column_text (_tmp10_, 1);
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (_tmp9_->name);
			_tmp9_->name = _tmp12_;
			_tmp13_ = row;
			_tmp14_ = stmt;
			_tmp13_->time_created = sqlite3_column_int64 (_tmp14_, 2);
			_tmp15_ = row;
			_tmp16_ = stmt;
			photo_id_init (&_tmp15_->ref, sqlite3_column_int64 (_tmp16_, 3));
			_tmp17_ = rows;
			_tmp18_ = row;
			gee_collection_add (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, GEE_TYPE_COLLECTION, GeeCollection), _tmp18_);
			_face_row_unref0 (row);
		}
	}
	result = rows;
	_sqlite3_finalize0 (stmt);
	return result;
}

static void
face_table_class_init (FaceTableClass * klass,
                       gpointer klass_data)
{
	face_table_parent_class = g_type_class_peek_parent (klass);
	((DatabaseTableClass *) klass)->finalize = face_table_finalize;
}

static void
face_table_instance_init (FaceTable * self,
                          gpointer klass)
{
}

static void
face_table_finalize (DatabaseTable * obj)
{
	FaceTable * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FACE_TABLE, FaceTable);
	DATABASE_TABLE_CLASS (face_table_parent_class)->finalize (obj);
}

static GType
face_table_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FaceTableClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) face_table_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FaceTable), 0, (GInstanceInitFunc) face_table_instance_init, NULL };
	GType face_table_type_id;
	face_table_type_id = g_type_register_static (TYPE_DATABASE_TABLE, "FaceTable", &g_define_type_info, 0);
	return face_table_type_id;
}

GType
face_table_get_type (void)
{
	static volatile gsize face_table_type_id__once = 0;
	if (g_once_init_enter (&face_table_type_id__once)) {
		GType face_table_type_id;
		face_table_type_id = face_table_get_type_once ();
		g_once_init_leave (&face_table_type_id__once, face_table_type_id);
	}
	return face_table_type_id__once;
}

