/* FaceShape.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from FaceShape.vala, do not modify */

/* Copyright 2016 Software Freedom Conservancy Inc.
 *
 * This software is licensed under the GNU Lesser General Public License
 * (version 2.1 or later).  See the COPYING file in this distribution.
 */

#include <glib-object.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <cairo-gobject.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gdk/gdk.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>

#define FACE_SHAPE_SHAPE_TYPE NULL
#define FACE_SHAPE_FACE_WINDOW_MARGIN 5
#define FACE_SHAPE_LABEL_MARGIN 12
#define FACE_SHAPE_LABEL_PADDING 9
#define FACE_RECTANGLE_SHAPE_TYPE "Rectangle"
#define FACE_RECTANGLE_FACE_MIN_SIZE 8
#define FACE_RECTANGLE_NULL_SIZE 0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_FACE_SHAPE (face_shape_get_type ())
#define FACE_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_SHAPE, FaceShape))
#define FACE_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_SHAPE, FaceShapeClass))
#define IS_FACE_SHAPE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_SHAPE))
#define IS_FACE_SHAPE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_SHAPE))
#define FACE_SHAPE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_SHAPE, FaceShapeClass))

typedef struct _FaceShape FaceShape;
typedef struct _FaceShapeClass FaceShapeClass;
typedef struct _FaceShapePrivate FaceShapePrivate;

#define TYPE_DIMENSIONS (dimensions_get_type ())
typedef struct _Dimensions Dimensions;

#define EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW (editing_tools_editing_tool_window_get_type ())
#define EDITING_TOOLS_EDITING_TOOL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW, EditingToolsEditingToolWindow))
#define EDITING_TOOLS_EDITING_TOOL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW, EditingToolsEditingToolWindowClass))
#define EDITING_TOOLS_IS_EDITING_TOOL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW))
#define EDITING_TOOLS_IS_EDITING_TOOL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW))
#define EDITING_TOOLS_EDITING_TOOL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDITING_TOOLS_TYPE_EDITING_TOOL_WINDOW, EditingToolsEditingToolWindowClass))

typedef struct _EditingToolsEditingToolWindow EditingToolsEditingToolWindow;
typedef struct _EditingToolsEditingToolWindowClass EditingToolsEditingToolWindowClass;

#define FACES_TOOL_TYPE_EDITING_FACE_TOOL_WINDOW (faces_tool_editing_face_tool_window_get_type ())
#define FACES_TOOL_EDITING_FACE_TOOL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FACES_TOOL_TYPE_EDITING_FACE_TOOL_WINDOW, FacesToolEditingFaceToolWindow))
#define FACES_TOOL_EDITING_FACE_TOOL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FACES_TOOL_TYPE_EDITING_FACE_TOOL_WINDOW, FacesToolEditingFaceToolWindowClass))
#define FACES_TOOL_IS_EDITING_FACE_TOOL_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FACES_TOOL_TYPE_EDITING_FACE_TOOL_WINDOW))
#define FACES_TOOL_IS_EDITING_FACE_TOOL_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FACES_TOOL_TYPE_EDITING_FACE_TOOL_WINDOW))
#define FACES_TOOL_EDITING_FACE_TOOL_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FACES_TOOL_TYPE_EDITING_FACE_TOOL_WINDOW, FacesToolEditingFaceToolWindowClass))

typedef struct _FacesToolEditingFaceToolWindow FacesToolEditingFaceToolWindow;
typedef struct _FacesToolEditingFaceToolWindowClass FacesToolEditingFaceToolWindowClass;

#define EDITING_TOOLS_TYPE_PHOTO_CANVAS (editing_tools_photo_canvas_get_type ())
#define EDITING_TOOLS_PHOTO_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), EDITING_TOOLS_TYPE_PHOTO_CANVAS, EditingToolsPhotoCanvas))
#define EDITING_TOOLS_PHOTO_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), EDITING_TOOLS_TYPE_PHOTO_CANVAS, EditingToolsPhotoCanvasClass))
#define EDITING_TOOLS_IS_PHOTO_CANVAS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), EDITING_TOOLS_TYPE_PHOTO_CANVAS))
#define EDITING_TOOLS_IS_PHOTO_CANVAS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), EDITING_TOOLS_TYPE_PHOTO_CANVAS))
#define EDITING_TOOLS_PHOTO_CANVAS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), EDITING_TOOLS_TYPE_PHOTO_CANVAS, EditingToolsPhotoCanvasClass))

typedef struct _EditingToolsPhotoCanvas EditingToolsPhotoCanvas;
typedef struct _EditingToolsPhotoCanvasClass EditingToolsPhotoCanvasClass;

#define FACES_TOOL_TYPE_FACE_WIDGET (faces_tool_face_widget_get_type ())
#define FACES_TOOL_FACE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), FACES_TOOL_TYPE_FACE_WIDGET, FacesToolFaceWidget))
#define FACES_TOOL_FACE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), FACES_TOOL_TYPE_FACE_WIDGET, FacesToolFaceWidgetClass))
#define FACES_TOOL_IS_FACE_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), FACES_TOOL_TYPE_FACE_WIDGET))
#define FACES_TOOL_IS_FACE_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), FACES_TOOL_TYPE_FACE_WIDGET))
#define FACES_TOOL_FACE_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), FACES_TOOL_TYPE_FACE_WIDGET, FacesToolFaceWidgetClass))

typedef struct _FacesToolFaceWidget FacesToolFaceWidget;
typedef struct _FacesToolFaceWidgetClass FacesToolFaceWidgetClass;
enum  {
	FACE_SHAPE_0_PROPERTY,
	FACE_SHAPE_NUM_PROPERTIES
};
static GParamSpec* face_shape_properties[FACE_SHAPE_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _editing_tools_photo_canvas_unref0(var) ((var == NULL) ? NULL : (var = (editing_tools_photo_canvas_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))

#define TYPE_FACE_SHAPE_ERROR (face_shape_error_get_type ())

#define TYPE_FACE_RECTANGLE (face_rectangle_get_type ())
#define FACE_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FACE_RECTANGLE, FaceRectangle))
#define FACE_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FACE_RECTANGLE, FaceRectangleClass))
#define IS_FACE_RECTANGLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FACE_RECTANGLE))
#define IS_FACE_RECTANGLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FACE_RECTANGLE))
#define FACE_RECTANGLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FACE_RECTANGLE, FaceRectangleClass))

typedef struct _FaceRectangle FaceRectangle;
typedef struct _FaceRectangleClass FaceRectangleClass;
typedef struct _EditingToolsEditingToolWindowPrivate EditingToolsEditingToolWindowPrivate;
typedef struct _FacesToolEditingFaceToolWindowPrivate FacesToolEditingFaceToolWindowPrivate;
enum  {
	FACE_SHAPE_ADD_ME_REQUESTED_SIGNAL,
	FACE_SHAPE_DELETE_ME_REQUESTED_SIGNAL,
	FACE_SHAPE_NUM_SIGNALS
};
static guint face_shape_signals[FACE_SHAPE_NUM_SIGNALS] = {0};
typedef struct _FaceRectanglePrivate FaceRectanglePrivate;

#define TYPE_BOX (box_get_type ())
typedef struct _Box Box;
typedef enum  {
	BOX_LOCATION_OUTSIDE,
	BOX_LOCATION_INSIDE,
	BOX_LOCATION_TOP_SIDE,
	BOX_LOCATION_LEFT_SIDE,
	BOX_LOCATION_RIGHT_SIDE,
	BOX_LOCATION_BOTTOM_SIDE,
	BOX_LOCATION_TOP_LEFT,
	BOX_LOCATION_BOTTOM_LEFT,
	BOX_LOCATION_TOP_RIGHT,
	BOX_LOCATION_BOTTOM_RIGHT
} BoxLocation;

#define TYPE_BOX_LOCATION (box_location_get_type ())
enum  {
	FACE_RECTANGLE_0_PROPERTY,
	FACE_RECTANGLE_NUM_PROPERTIES
};
static GParamSpec* face_rectangle_properties[FACE_RECTANGLE_NUM_PROPERTIES];
#define _box_free0(var) ((var == NULL) ? NULL : (var = (box_free (var), NULL)))

#define TYPE_DATA_OBJECT (data_object_get_type ())
#define DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_OBJECT, DataObject))
#define DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_OBJECT, DataObjectClass))
#define IS_DATA_OBJECT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_OBJECT))
#define IS_DATA_OBJECT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_OBJECT))
#define DATA_OBJECT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_OBJECT, DataObjectClass))

typedef struct _DataObject DataObject;
typedef struct _DataObjectClass DataObjectClass;

#define TYPE_DATA_SOURCE (data_source_get_type ())
#define DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DATA_SOURCE, DataSource))
#define DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DATA_SOURCE, DataSourceClass))
#define IS_DATA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DATA_SOURCE))
#define IS_DATA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DATA_SOURCE))
#define DATA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DATA_SOURCE, DataSourceClass))

typedef struct _DataSource DataSource;
typedef struct _DataSourceClass DataSourceClass;

#define TYPE_THUMBNAIL_SOURCE (thumbnail_source_get_type ())
#define THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSource))
#define THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))
#define IS_THUMBNAIL_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_THUMBNAIL_SOURCE))
#define IS_THUMBNAIL_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_THUMBNAIL_SOURCE))
#define THUMBNAIL_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_THUMBNAIL_SOURCE, ThumbnailSourceClass))

typedef struct _ThumbnailSource ThumbnailSource;
typedef struct _ThumbnailSourceClass ThumbnailSourceClass;

#define TYPE_MEDIA_SOURCE (media_source_get_type ())
#define MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MEDIA_SOURCE, MediaSource))
#define MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MEDIA_SOURCE, MediaSourceClass))
#define IS_MEDIA_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MEDIA_SOURCE))
#define IS_MEDIA_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MEDIA_SOURCE))
#define MEDIA_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MEDIA_SOURCE, MediaSourceClass))

typedef struct _MediaSource MediaSource;
typedef struct _MediaSourceClass MediaSourceClass;

#define TYPE_PHOTO_SOURCE (photo_source_get_type ())
#define PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO_SOURCE, PhotoSource))
#define PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO_SOURCE, PhotoSourceClass))
#define IS_PHOTO_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO_SOURCE))
#define IS_PHOTO_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO_SOURCE))
#define PHOTO_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO_SOURCE, PhotoSourceClass))

typedef struct _PhotoSource PhotoSource;
typedef struct _PhotoSourceClass PhotoSourceClass;

#define TYPE_PHOTO (photo_get_type ())
#define PHOTO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PHOTO, Photo))
#define PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PHOTO, PhotoClass))
#define IS_PHOTO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PHOTO))
#define IS_PHOTO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PHOTO))
#define PHOTO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PHOTO, PhotoClass))

typedef struct _Photo Photo;
typedef struct _PhotoClass PhotoClass;
typedef enum  {
	ORIENTATION_MIN = 1,
	ORIENTATION_TOP_LEFT = 1,
	ORIENTATION_TOP_RIGHT = 2,
	ORIENTATION_BOTTOM_RIGHT = 3,
	ORIENTATION_BOTTOM_LEFT = 4,
	ORIENTATION_LEFT_TOP = 5,
	ORIENTATION_RIGHT_TOP = 6,
	ORIENTATION_RIGHT_BOTTOM = 7,
	ORIENTATION_LEFT_BOTTOM = 8,
	ORIENTATION_MAX = 8
} Orientation;

#define TYPE_ORIENTATION (orientation_get_type ())
typedef enum  {
	PHOTO_EXCEPTION_NONE = 0,
	PHOTO_EXCEPTION_ORIENTATION = 1 << 0,
	PHOTO_EXCEPTION_CROP = 1 << 1,
	PHOTO_EXCEPTION_REDEYE = 1 << 2,
	PHOTO_EXCEPTION_ADJUST = 1 << 3,
	PHOTO_EXCEPTION_STRAIGHTEN = 1 << 4,
	PHOTO_EXCEPTION_ALL = 0xFFFFFFFFLL
} PhotoException;

#define PHOTO_TYPE_EXCEPTION (photo_exception_get_type ())

#define TYPE_PAGE_WINDOW (page_window_get_type ())
#define PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE_WINDOW, PageWindow))
#define PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE_WINDOW, PageWindowClass))
#define IS_PAGE_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE_WINDOW))
#define IS_PAGE_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE_WINDOW))
#define PAGE_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE_WINDOW, PageWindowClass))

typedef struct _PageWindow PageWindow;
typedef struct _PageWindowClass PageWindowClass;

#define TYPE_APP_WINDOW (app_window_get_type ())
#define APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_WINDOW, AppWindow))
#define APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_WINDOW, AppWindowClass))
#define IS_APP_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_WINDOW))
#define IS_APP_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_WINDOW))
#define APP_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_WINDOW, AppWindowClass))

typedef struct _AppWindow AppWindow;
typedef struct _AppWindowClass AppWindowClass;

#define TYPE_PAGE (page_get_type ())
#define PAGE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PAGE, Page))
#define PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PAGE, PageClass))
#define IS_PAGE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PAGE))
#define IS_PAGE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PAGE))
#define PAGE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PAGE, PageClass))

typedef struct _Page Page;
typedef struct _PageClass PageClass;

#define TYPE_FULLSCREEN_WINDOW (fullscreen_window_get_type ())
#define FULLSCREEN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FULLSCREEN_WINDOW, FullscreenWindow))
#define FULLSCREEN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FULLSCREEN_WINDOW, FullscreenWindowClass))
#define IS_FULLSCREEN_WINDOW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FULLSCREEN_WINDOW))
#define IS_FULLSCREEN_WINDOW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FULLSCREEN_WINDOW))
#define FULLSCREEN_WINDOW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FULLSCREEN_WINDOW, FullscreenWindowClass))

typedef struct _FullscreenWindow FullscreenWindow;
typedef struct _FullscreenWindowClass FullscreenWindowClass;
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
typedef enum  {
	BOX_COMPLEMENTS_NONE,
	BOX_COMPLEMENTS_VERTICAL,
	BOX_COMPLEMENTS_HORIZONTAL,
	BOX_COMPLEMENTS_BOTH
} BoxComplements;

#define TYPE_BOX_COMPLEMENTS (box_complements_get_type ())
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _Dimensions {
	gint width;
	gint height;
};

struct _FaceShape {
	GObject parent_instance;
	FaceShapePrivate * priv;
	FacesToolEditingFaceToolWindow* face_window;
	GdkCursorType current_cursor_type;
	EditingToolsPhotoCanvas* canvas;
	gchar* serialized;
	gdouble* face_vec;
	gint face_vec_length1;
};

struct _FaceShapeClass {
	GObjectClass parent_class;
	gchar* (*serialize) (FaceShape* self, gboolean geometry_only);
	void (*update_face_window_position) (FaceShape* self);
	void (*prepare_ctx) (FaceShape* self, cairo_t* ctx, Dimensions* dim);
	void (*on_resized_pixbuf) (FaceShape* self, Dimensions* old_dim, GdkPixbuf* scaled);
	void (*on_motion) (FaceShape* self, gint x, gint y, GdkModifierType mask);
	void (*on_left_released) (FaceShape* self, gint x, gint y);
	gboolean (*on_left_click) (FaceShape* self, gint x, gint y);
	gboolean (*cursor_is_over) (FaceShape* self, gint x, gint y);
	gboolean (*equals) (FaceShape* self, FaceShape* face_shape);
	gdouble (*get_distance) (FaceShape* self, gint x, gint y);
	gdouble* (*get_face_vec) (FaceShape* self, gint* result_length1);
	void (*paint) (FaceShape* self);
	void (*erase) (FaceShape* self);
};

struct _FaceShapePrivate {
	gboolean editable;
	gboolean visible;
	gboolean known;
	gdouble guess;
	FacesToolFaceWidget* face_widget;
};

typedef enum  {
	FACE_SHAPE_ERROR_CANT_CREATE
} FaceShapeError;
#define FACE_SHAPE_ERROR face_shape_error_quark ()

struct _EditingToolsEditingToolWindow {
	GtkWindow parent_instance;
	EditingToolsEditingToolWindowPrivate * priv;
};

struct _EditingToolsEditingToolWindowClass {
	GtkWindowClass parent_class;
};

struct _FacesToolEditingFaceToolWindow {
	EditingToolsEditingToolWindow parent_instance;
	FacesToolEditingFaceToolWindowPrivate * priv;
	GtkEntry* entry;
};

struct _FacesToolEditingFaceToolWindowClass {
	EditingToolsEditingToolWindowClass parent_class;
};

struct _FaceRectangle {
	FaceShape parent_instance;
	FaceRectanglePrivate * priv;
};

struct _FaceRectangleClass {
	FaceShapeClass parent_class;
};

struct _Box {
	gint left;
	gint top;
	gint right;
	gint bottom;
};

struct _FaceRectanglePrivate {
	Box box;
	Box* label_box;
	BoxLocation in_manipulation;
	cairo_t* wide_black_ctx;
	cairo_t* wide_white_ctx;
	gint last_grab_x;
	gint last_grab_y;
};

static gint FaceShape_private_offset;
static gpointer face_shape_parent_class = NULL;
static gint FaceRectangle_private_offset;
static gpointer face_rectangle_parent_class = NULL;

VALA_EXTERN GType face_shape_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceShape, g_object_unref)
VALA_EXTERN GType dimensions_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Dimensions* dimensions_dup (const Dimensions* self);
VALA_EXTERN void dimensions_free (Dimensions* self);
VALA_EXTERN GType editing_tools_editing_tool_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EditingToolsEditingToolWindow, g_object_unref)
VALA_EXTERN GType faces_tool_editing_face_tool_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FacesToolEditingFaceToolWindow, g_object_unref)
VALA_EXTERN gpointer editing_tools_photo_canvas_ref (gpointer instance);
VALA_EXTERN void editing_tools_photo_canvas_unref (gpointer instance);
VALA_EXTERN GParamSpec* editing_tools_param_spec_photo_canvas (const gchar* name,
                                                   const gchar* nick,
                                                   const gchar* blurb,
                                                   GType object_type,
                                                   GParamFlags flags);
VALA_EXTERN void editing_tools_value_set_photo_canvas (GValue* value,
                                           gpointer v_object);
VALA_EXTERN void editing_tools_value_take_photo_canvas (GValue* value,
                                            gpointer v_object);
VALA_EXTERN gpointer editing_tools_value_get_photo_canvas (const GValue* value);
VALA_EXTERN GType editing_tools_photo_canvas_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (EditingToolsPhotoCanvas, editing_tools_photo_canvas_unref)
VALA_EXTERN GType faces_tool_face_widget_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FacesToolFaceWidget, g_object_unref)
VALA_EXTERN gchar* face_shape_serialize (FaceShape* self,
                             gboolean geometry_only);
VALA_EXTERN void face_shape_update_face_window_position (FaceShape* self);
VALA_EXTERN void face_shape_prepare_ctx (FaceShape* self,
                             cairo_t* ctx,
                             Dimensions* dim);
VALA_EXTERN void face_shape_on_resized_pixbuf (FaceShape* self,
                                   Dimensions* old_dim,
                                   GdkPixbuf* scaled);
VALA_EXTERN void face_shape_on_motion (FaceShape* self,
                           gint x,
                           gint y,
                           GdkModifierType mask);
VALA_EXTERN void face_shape_on_left_released (FaceShape* self,
                                  gint x,
                                  gint y);
VALA_EXTERN gboolean face_shape_on_left_click (FaceShape* self,
                                   gint x,
                                   gint y);
VALA_EXTERN gboolean face_shape_cursor_is_over (FaceShape* self,
                                    gint x,
                                    gint y);
VALA_EXTERN gboolean face_shape_equals (FaceShape* self,
                            FaceShape* face_shape);
VALA_EXTERN gdouble face_shape_get_distance (FaceShape* self,
                                 gint x,
                                 gint y);
VALA_EXTERN gdouble* face_shape_get_face_vec (FaceShape* self,
                                  gint* result_length1);
VALA_EXTERN void face_shape_paint (FaceShape* self);
VALA_EXTERN void face_shape_erase (FaceShape* self);
static void _face_shape_prepare_ctx_editing_tools_photo_canvas_new_surface (EditingToolsPhotoCanvas* _sender,
                                                                     cairo_t* ctx,
                                                                     Dimensions* dim,
                                                                     gpointer self);
VALA_EXTERN void editing_tools_photo_canvas_set_cursor (EditingToolsPhotoCanvas* self,
                                            GdkCursorType cursor_type);
VALA_EXTERN FaceShape* face_shape_construct (GType object_type,
                                 EditingToolsPhotoCanvas* canvas,
                                 gdouble* vec,
                                 gint vec_length1);
VALA_EXTERN cairo_t* editing_tools_photo_canvas_get_default_ctx (EditingToolsPhotoCanvas* self);
VALA_EXTERN void editing_tools_photo_canvas_get_surface_dim (EditingToolsPhotoCanvas* self,
                                                 Dimensions* result);
VALA_EXTERN GtkWindow* editing_tools_photo_canvas_get_container (EditingToolsPhotoCanvas* self);
VALA_EXTERN FacesToolEditingFaceToolWindow* faces_tool_editing_face_tool_window_new (GtkWindow* container);
VALA_EXTERN FacesToolEditingFaceToolWindow* faces_tool_editing_face_tool_window_construct (GType object_type,
                                                                               GtkWindow* container);
VALA_EXTERN gboolean face_shape_key_press_event (FaceShape* self,
                                     GdkEventKey* event);
static gboolean _face_shape_key_press_event_faces_tool_editing_face_tool_window_key_pressed (FacesToolEditingFaceToolWindow* _sender,
                                                                                      GdkEventKey* event,
                                                                                      gpointer self);
static gdouble* _vala_array_dup38 (gdouble* self,
                            gssize length);
VALA_EXTERN GQuark face_shape_error_quark (void);
VALA_EXTERN GType face_shape_error_get_type (void) G_GNUC_CONST ;
VALA_EXTERN FaceShape* face_shape_from_serialized (EditingToolsPhotoCanvas* canvas,
                                       const gchar* serialized,
                                       GError** error);
VALA_EXTERN GType face_rectangle_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FaceRectangle, g_object_unref)
VALA_EXTERN FaceRectangle* face_rectangle_from_serialized (EditingToolsPhotoCanvas* canvas,
                                               gchar** args,
                                               gint args_length1,
                                               GError** error);
VALA_EXTERN void face_shape_set_name (FaceShape* self,
                          const gchar* face_name);
VALA_EXTERN gchar* face_shape_get_name (FaceShape* self);
VALA_EXTERN void face_shape_set_known (FaceShape* self,
                           gboolean known);
VALA_EXTERN gboolean face_shape_get_known (FaceShape* self);
VALA_EXTERN void face_shape_set_guess (FaceShape* self,
                           gdouble guess);
VALA_EXTERN gdouble face_shape_get_guess (FaceShape* self);
VALA_EXTERN void face_shape_set_widget (FaceShape* self,
                            FacesToolFaceWidget* face_widget);
VALA_EXTERN FacesToolFaceWidget* face_shape_get_widget (FaceShape* self);
VALA_EXTERN void face_shape_hide (FaceShape* self);
VALA_EXTERN void face_shape_show (FaceShape* self);
VALA_EXTERN gboolean face_shape_is_visible (FaceShape* self);
VALA_EXTERN gboolean face_shape_is_editable (FaceShape* self);
VALA_EXTERN void face_shape_set_editable (FaceShape* self,
                              gboolean editable);
static gchar* face_shape_real_serialize (FaceShape* self,
                                  gboolean geometry_only);
static void face_shape_real_update_face_window_position (FaceShape* self);
static void face_shape_real_prepare_ctx (FaceShape* self,
                                  cairo_t* ctx,
                                  Dimensions* dim);
static void face_shape_real_on_resized_pixbuf (FaceShape* self,
                                        Dimensions* old_dim,
                                        GdkPixbuf* scaled);
static void face_shape_real_on_motion (FaceShape* self,
                                gint x,
                                gint y,
                                GdkModifierType mask);
static void face_shape_real_on_left_released (FaceShape* self,
                                       gint x,
                                       gint y);
static gboolean face_shape_real_on_left_click (FaceShape* self,
                                        gint x,
                                        gint y);
static gboolean face_shape_real_cursor_is_over (FaceShape* self,
                                         gint x,
                                         gint y);
static gboolean face_shape_real_equals (FaceShape* self,
                                 FaceShape* face_shape);
static gdouble face_shape_real_get_distance (FaceShape* self,
                                      gint x,
                                      gint y);
static gdouble* face_shape_real_get_face_vec (FaceShape* self,
                                       gint* result_length1);
static void face_shape_real_paint (FaceShape* self);
static void face_shape_real_erase (FaceShape* self);
static void face_shape_finalize (GObject * obj);
static GType face_shape_get_type_once (void);
VALA_EXTERN GType box_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Box* box_dup (const Box* self);
VALA_EXTERN void box_free (Box* self);
VALA_EXTERN GType box_location_get_type (void) G_GNUC_CONST ;
static void face_rectangle_erase_label (FaceRectangle* self);
VALA_EXTERN FaceRectangle* face_rectangle_new (EditingToolsPhotoCanvas* canvas,
                                   gint x,
                                   gint y,
                                   gint half_width,
                                   gint half_height,
                                   gdouble* vec,
                                   gint vec_length1);
VALA_EXTERN FaceRectangle* face_rectangle_construct (GType object_type,
                                         EditingToolsPhotoCanvas* canvas,
                                         gint x,
                                         gint y,
                                         gint half_width,
                                         gint half_height,
                                         gdouble* vec,
                                         gint vec_length1);
VALA_EXTERN gdouble* face_rectangle_create_empty_vec (gint* result_length1);
static gdouble* _vala_array_dup39 (gdouble* self,
                            gssize length);
VALA_EXTERN void editing_tools_photo_canvas_get_scaled_pixbuf_position (EditingToolsPhotoCanvas* self,
                                                            GdkRectangle* result);
VALA_EXTERN void box_init (Box *self,
               gint left,
               gint top,
               gint right,
               gint bottom);
VALA_EXTERN void dimensions_for_pixbuf (GdkPixbuf* pixbuf,
                            Dimensions* result);
VALA_EXTERN GdkPixbuf* editing_tools_photo_canvas_get_scaled_pixbuf (EditingToolsPhotoCanvas* self);
VALA_EXTERN GType data_object_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataObject, g_object_unref)
VALA_EXTERN GType data_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DataSource, g_object_unref)
VALA_EXTERN GType thumbnail_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (ThumbnailSource, g_object_unref)
VALA_EXTERN GType media_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MediaSource, g_object_unref)
VALA_EXTERN GType photo_source_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PhotoSource, g_object_unref)
VALA_EXTERN GType photo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Photo, g_object_unref)
VALA_EXTERN Photo* editing_tools_photo_canvas_get_photo (EditingToolsPhotoCanvas* self);
VALA_EXTERN void photo_get_raw_dimensions (Photo* self,
                               Dimensions* result);
VALA_EXTERN gboolean photo_get_raw_crop (Photo* self,
                             Box* crop);
VALA_EXTERN GType orientation_get_type (void) G_GNUC_CONST ;
VALA_EXTERN Orientation photo_get_orientation (Photo* self);
VALA_EXTERN void orientation_rotate_box (Orientation self,
                             Dimensions* space,
                             Box* box,
                             Box* result);
VALA_EXTERN void box_get_dimensions (Box *self,
                         Dimensions* result);
VALA_EXTERN GType photo_exception_get_type (void) G_GNUC_CONST ;
VALA_EXTERN gboolean photo_get_crop (Photo* self,
                         Box* crop,
                         PhotoException exceptions);
VALA_EXTERN void box_get_scaled_similar (Box *self,
                             Dimensions* original,
                             Dimensions* scaled,
                             Box* result);
VALA_EXTERN void media_source_get_dimensions (MediaSource* self,
                                  PhotoException disallowed_steps,
                                  Dimensions* result);
VALA_EXTERN gint box_get_width (Box *self);
VALA_EXTERN gint box_get_height (Box *self);
static void face_rectangle_real_update_face_window_position (FaceShape* base);
VALA_EXTERN GType page_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PageWindow, g_object_unref)
VALA_EXTERN GType app_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppWindow, g_object_unref)
VALA_EXTERN AppWindow* app_window_get_instance (void);
VALA_EXTERN GType page_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Page, g_object_unref)
VALA_EXTERN Page* page_window_get_current_page (PageWindow* self);
VALA_EXTERN GType fullscreen_window_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FullscreenWindow, g_object_unref)
VALA_EXTERN gdouble application_get_scale (void);
static void face_rectangle_real_paint (FaceShape* base);
VALA_EXTERN void editing_tools_photo_canvas_draw_box (EditingToolsPhotoCanvas* self,
                                          cairo_t* ctx,
                                          Box* box);
VALA_EXTERN void box_get_reduced (Box *self,
                      gint amount,
                      Box* result);
static void face_rectangle_paint_label (FaceRectangle* self);
static void face_rectangle_real_erase (FaceShape* base);
VALA_EXTERN void editing_tools_photo_canvas_invalidate_area (EditingToolsPhotoCanvas* self,
                                                 Box* area);
VALA_EXTERN cairo_surface_t* editing_tools_photo_canvas_get_scaled_surface (EditingToolsPhotoCanvas* self);
static gchar* face_rectangle_real_serialize (FaceShape* base,
                                      gboolean geometry_only);
VALA_EXTERN void face_rectangle_get_geometry (FaceRectangle* self,
                                  gdouble* x,
                                  gdouble* y,
                                  gdouble* half_width,
                                  gdouble* half_height);
VALA_EXTERN void orientation_derotate_box (Orientation self,
                               Dimensions* space,
                               Box* box,
                               Box* result);
static gdouble* face_rectangle_real_get_face_vec (FaceShape* base,
                                           gint* result_length1);
static gdouble* _vala_array_dup40 (gdouble* self,
                            gssize length);
static gboolean face_rectangle_real_equals (FaceShape* base,
                                     FaceShape* face_shape);
static void face_rectangle_real_prepare_ctx (FaceShape* base,
                                      cairo_t* ctx,
                                      Dimensions* dim);
VALA_EXTERN void set_source_color_from_string (cairo_t* ctx,
                                   const gchar* spec);
static gboolean face_rectangle_on_canvas_manipulation (FaceRectangle* self,
                                                gint x,
                                                gint y);
VALA_EXTERN gboolean box_equals (Box *self,
                     Box* box);
static void face_rectangle_check_resized_box (FaceRectangle* self,
                                       Box* new_box);
VALA_EXTERN void editing_tools_photo_canvas_repaint (EditingToolsPhotoCanvas* self);
VALA_EXTERN GType box_complements_get_type (void) G_GNUC_CONST ;
VALA_EXTERN BoxComplements box_resized_complements (Box *self,
                                        Box* resized,
                                        Box* horizontal,
                                        gboolean* horizontal_enlarged,
                                        Box* vertical,
                                        gboolean* vertical_enlarged);
static void face_rectangle_update_cursor (FaceRectangle* self,
                                   gint x,
                                   gint y);
VALA_EXTERN void box_get_offset (Box *self,
                     gint xofs,
                     gint yofs,
                     Box* result);
VALA_EXTERN BoxLocation box_approx_location (Box *self,
                                 gint x,
                                 gint y);
static void face_rectangle_real_on_motion (FaceShape* base,
                                    gint x,
                                    gint y,
                                    GdkModifierType mask);
static gboolean face_rectangle_real_on_left_click (FaceShape* base,
                                            gint x,
                                            gint y);
static void face_rectangle_real_on_left_released (FaceShape* base,
                                           gint x,
                                           gint y);
static void face_rectangle_real_on_resized_pixbuf (FaceShape* base,
                                            Dimensions* old_dim,
                                            GdkPixbuf* scaled);
VALA_EXTERN void photo_get_original_dimensions (Photo* self,
                                    Dimensions* result);
static gboolean face_rectangle_real_cursor_is_over (FaceShape* base,
                                             gint x,
                                             gint y);
static gdouble face_rectangle_real_get_distance (FaceShape* base,
                                          gint x,
                                          gint y);
static void face_rectangle_finalize (GObject * obj);
static GType face_rectangle_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);
static inline gpointer _vala_memdup2 (gconstpointer mem,
                        gsize byte_size);

static inline gpointer
face_shape_get_instance_private (FaceShape* self)
{
	return G_STRUCT_MEMBER_P (self, FaceShape_private_offset);
}

static void
_face_shape_prepare_ctx_editing_tools_photo_canvas_new_surface (EditingToolsPhotoCanvas* _sender,
                                                                cairo_t* ctx,
                                                                Dimensions* dim,
                                                                gpointer self)
{
	face_shape_prepare_ctx ((FaceShape*) self, ctx, dim);
}

static gpointer
_editing_tools_photo_canvas_ref0 (gpointer self)
{
	return self ? editing_tools_photo_canvas_ref (self) : NULL;
}

static gboolean
_face_shape_key_press_event_faces_tool_editing_face_tool_window_key_pressed (FacesToolEditingFaceToolWindow* _sender,
                                                                             GdkEventKey* event,
                                                                             gpointer self)
{
	gboolean result;
	result = face_shape_key_press_event ((FaceShape*) self, event);
	return result;
}

static gdouble*
_vala_array_dup38 (gdouble* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gdouble));
	}
	return NULL;
}

FaceShape*
face_shape_construct (GType object_type,
                      EditingToolsPhotoCanvas* canvas,
                      gdouble* vec,
                      gint vec_length1)
{
	FaceShape * self = NULL;
	EditingToolsPhotoCanvas* _tmp0_;
	EditingToolsPhotoCanvas* _tmp1_;
	EditingToolsPhotoCanvas* _tmp2_;
	cairo_t* _tmp3_;
	cairo_t* _tmp4_;
	EditingToolsPhotoCanvas* _tmp5_;
	Dimensions _tmp6_ = {0};
	EditingToolsPhotoCanvas* _tmp7_;
	GtkWindow* _tmp8_;
	GtkWindow* _tmp9_;
	FacesToolEditingFaceToolWindow* _tmp10_;
	FacesToolEditingFaceToolWindow* _tmp11_;
	FacesToolEditingFaceToolWindow* _tmp12_;
	FacesToolEditingFaceToolWindow* _tmp13_;
	gdouble* _tmp14_;
	gint _tmp14__length1;
	EditingToolsPhotoCanvas* _tmp15_;
	g_return_val_if_fail (EDITING_TOOLS_IS_PHOTO_CANVAS (canvas), NULL);
	self = (FaceShape*) g_object_new (object_type, NULL);
	_tmp0_ = _editing_tools_photo_canvas_ref0 (canvas);
	_editing_tools_photo_canvas_unref0 (self->canvas);
	self->canvas = _tmp0_;
	_tmp1_ = self->canvas;
	g_signal_connect_object (_tmp1_, "new-surface", (GCallback) _face_shape_prepare_ctx_editing_tools_photo_canvas_new_surface, self, 0);
	_tmp2_ = self->canvas;
	_tmp3_ = editing_tools_photo_canvas_get_default_ctx (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = self->canvas;
	editing_tools_photo_canvas_get_surface_dim (_tmp5_, &_tmp6_);
	face_shape_prepare_ctx (self, _tmp4_, &_tmp6_);
	_cairo_destroy0 (_tmp4_);
	_tmp7_ = self->canvas;
	_tmp8_ = editing_tools_photo_canvas_get_container (_tmp7_);
	_tmp9_ = _tmp8_;
	_tmp10_ = faces_tool_editing_face_tool_window_new (_tmp9_);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->face_window);
	self->face_window = _tmp10_;
	_g_object_unref0 (_tmp9_);
	_tmp11_ = self->face_window;
	g_signal_connect_object (_tmp11_, "key-pressed", (GCallback) _face_shape_key_press_event_faces_tool_editing_face_tool_window_key_pressed, self, 0);
	_tmp12_ = self->face_window;
	gtk_widget_show_all (G_TYPE_CHECK_INSTANCE_CAST (_tmp12_, gtk_widget_get_type (), GtkWidget));
	_tmp13_ = self->face_window;
	gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp13_, gtk_widget_get_type (), GtkWidget));
	_tmp14_ = (vec != NULL) ? _vala_array_dup38 (vec, vec_length1) : vec;
	_tmp14__length1 = vec_length1;
	self->face_vec = (g_free (self->face_vec), NULL);
	self->face_vec = _tmp14_;
	self->face_vec_length1 = _tmp14__length1;
	_tmp15_ = self->canvas;
	editing_tools_photo_canvas_set_cursor (_tmp15_, self->current_cursor_type);
	return self;
}

FaceShape*
face_shape_from_serialized (EditingToolsPhotoCanvas* canvas,
                            const gchar* serialized,
                            GError** error)
{
	FaceShape* face_shape = NULL;
	gchar** args = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gint args_length1;
	gint _args_size_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	GQuark _tmp5_ = 0U;
	static GQuark _tmp4_label0 = 0;
	FaceShape* _tmp9_;
	gchar* _tmp10_;
	GError* _inner_error0_ = NULL;
	FaceShape* result;
	g_return_val_if_fail (EDITING_TOOLS_IS_PHOTO_CANVAS (canvas), NULL);
	g_return_val_if_fail (serialized != NULL, NULL);
	_tmp1_ = _tmp0_ = g_strsplit (serialized, ";", 0);
	args = _tmp1_;
	args_length1 = _vala_array_length (_tmp0_);
	_args_size_ = args_length1;
	_tmp2_ = args[0];
	_tmp3_ = _tmp2_;
	_tmp5_ = (NULL == _tmp3_) ? 0 : g_quark_from_string (_tmp3_);
	if (_tmp5_ == ((0 != _tmp4_label0) ? _tmp4_label0 : (_tmp4_label0 = g_quark_from_static_string ("Rectangle")))) {
		switch (0) {
			default:
			{
				FaceRectangle* _tmp6_ = NULL;
				FaceRectangle* _tmp7_;
				FaceRectangle* _tmp8_;
				_tmp7_ = face_rectangle_from_serialized (canvas, args, (gint) args_length1, &_inner_error0_);
				_tmp6_ = _tmp7_;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					if (_inner_error0_->domain == FACE_SHAPE_ERROR) {
						g_propagate_error (error, _inner_error0_);
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (face_shape);
						return NULL;
					} else {
						args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
						_g_object_unref0 (face_shape);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
						g_clear_error (&_inner_error0_);
						return NULL;
					}
				}
				_tmp8_ = _tmp6_;
				_tmp6_ = NULL;
				_g_object_unref0 (face_shape);
				face_shape = G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_FACE_SHAPE, FaceShape);
				_g_object_unref0 (_tmp6_);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				g_assert_not_reached ();
			}
		}
	}
	_tmp9_ = face_shape;
	_tmp10_ = g_strdup (serialized);
	_g_free0 (_tmp9_->serialized);
	_tmp9_->serialized = _tmp10_;
	result = face_shape;
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	return result;
}

void
face_shape_set_name (FaceShape* self,
                     const gchar* face_name)
{
	FacesToolEditingFaceToolWindow* _tmp0_;
	GtkEntry* _tmp1_;
	g_return_if_fail (IS_FACE_SHAPE (self));
	g_return_if_fail (face_name != NULL);
	_tmp0_ = self->face_window;
	_tmp1_ = _tmp0_->entry;
	gtk_entry_set_text (_tmp1_, face_name);
}

gchar*
face_shape_get_name (FaceShape* self)
{
	gchar* face_name = NULL;
	FacesToolEditingFaceToolWindow* _tmp0_;
	GtkEntry* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_ = NULL;
	const gchar* _tmp5_;
	gchar* _tmp7_;
	gchar* result;
	g_return_val_if_fail (IS_FACE_SHAPE (self), NULL);
	_tmp0_ = self->face_window;
	_tmp1_ = _tmp0_->entry;
	_tmp2_ = gtk_entry_get_text (_tmp1_);
	_tmp3_ = g_strdup (_tmp2_);
	face_name = _tmp3_;
	_tmp5_ = face_name;
	if (g_strcmp0 (_tmp5_, "") == 0) {
		_tmp4_ = NULL;
	} else {
		const gchar* _tmp6_;
		_tmp6_ = face_name;
		_tmp4_ = _tmp6_;
	}
	_tmp7_ = g_strdup (_tmp4_);
	result = _tmp7_;
	_g_free0 (face_name);
	return result;
}

void
face_shape_set_known (FaceShape* self,
                      gboolean known)
{
	g_return_if_fail (IS_FACE_SHAPE (self));
	self->priv->known = known;
}

gboolean
face_shape_get_known (FaceShape* self)
{
	gboolean result;
	g_return_val_if_fail (IS_FACE_SHAPE (self), FALSE);
	result = self->priv->known;
	return result;
}

void
face_shape_set_guess (FaceShape* self,
                      gdouble guess)
{
	g_return_if_fail (IS_FACE_SHAPE (self));
	self->priv->guess = guess;
}

gdouble
face_shape_get_guess (FaceShape* self)
{
	gdouble result;
	g_return_val_if_fail (IS_FACE_SHAPE (self), 0.0);
	result = self->priv->guess;
	return result;
}

void
face_shape_set_widget (FaceShape* self,
                       FacesToolFaceWidget* face_widget)
{
	g_return_if_fail (IS_FACE_SHAPE (self));
	g_return_if_fail (FACES_TOOL_IS_FACE_WIDGET (face_widget));
	self->priv->face_widget = face_widget;
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

FacesToolFaceWidget*
face_shape_get_widget (FaceShape* self)
{
	FacesToolFaceWidget* _tmp0_;
	FacesToolFaceWidget* _tmp1_;
	FacesToolFaceWidget* _tmp2_;
	FacesToolFaceWidget* result;
	g_return_val_if_fail (IS_FACE_SHAPE (self), NULL);
	_tmp0_ = self->priv->face_widget;
	_vala_assert (_tmp0_ != NULL, "face_widget != null");
	_tmp1_ = self->priv->face_widget;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	result = _tmp2_;
	return result;
}

void
face_shape_hide (FaceShape* self)
{
	EditingToolsPhotoCanvas* _tmp1_;
	g_return_if_fail (IS_FACE_SHAPE (self));
	self->priv->visible = FALSE;
	face_shape_erase (self);
	if (self->priv->editable) {
		FacesToolEditingFaceToolWindow* _tmp0_;
		_tmp0_ = self->face_window;
		gtk_widget_hide (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	}
	_tmp1_ = self->canvas;
	editing_tools_photo_canvas_set_cursor (_tmp1_, GDK_LEFT_PTR);
}

void
face_shape_show (FaceShape* self)
{
	g_return_if_fail (IS_FACE_SHAPE (self));
	self->priv->visible = TRUE;
	face_shape_paint (self);
	if (self->priv->editable) {
		FacesToolEditingFaceToolWindow* _tmp0_;
		FacesToolEditingFaceToolWindow* _tmp1_;
		face_shape_update_face_window_position (self);
		_tmp0_ = self->face_window;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
		_tmp1_ = self->face_window;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
		if (!self->priv->known) {
			FacesToolEditingFaceToolWindow* _tmp2_;
			GtkEntry* _tmp3_;
			_tmp2_ = self->face_window;
			_tmp3_ = _tmp2_->entry;
			gtk_editable_select_region (G_TYPE_CHECK_INSTANCE_CAST (_tmp3_, gtk_editable_get_type (), GtkEditable), 0, -1);
		}
	}
}

gboolean
face_shape_is_visible (FaceShape* self)
{
	gboolean result;
	g_return_val_if_fail (IS_FACE_SHAPE (self), FALSE);
	result = self->priv->visible;
	return result;
}

gboolean
face_shape_is_editable (FaceShape* self)
{
	gboolean result;
	g_return_val_if_fail (IS_FACE_SHAPE (self), FALSE);
	result = self->priv->editable;
	return result;
}

void
face_shape_set_editable (FaceShape* self,
                         gboolean editable)
{
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (IS_FACE_SHAPE (self));
	if (self->priv->visible) {
		_tmp0_ = editable != face_shape_is_editable (self);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		face_shape_hide (self);
		self->priv->editable = editable;
		face_shape_show (self);
		return;
	}
	self->priv->editable = editable;
}

gboolean
face_shape_key_press_event (FaceShape* self,
                            GdkEventKey* event)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	static GQuark _tmp2_label2 = 0;
	gboolean result;
	g_return_val_if_fail (IS_FACE_SHAPE (self), FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gdk_keyval_name (event->keyval);
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("Escape")))) {
		switch (0) {
			default:
			{
				g_signal_emit (self, face_shape_signals[FACE_SHAPE_DELETE_ME_REQUESTED_SIGNAL], 0);
				break;
			}
		}
	} else if ((_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("Return")))) || (_tmp3_ == ((0 != _tmp2_label2) ? _tmp2_label2 : (_tmp2_label2 = g_quark_from_static_string ("KP_Enter"))))) {
		switch (0) {
			default:
			{
				g_signal_emit (self, face_shape_signals[FACE_SHAPE_ADD_ME_REQUESTED_SIGNAL], 0, self);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				result = FALSE;
				return result;
			}
		}
	}
	result = TRUE;
	return result;
}

static gchar*
face_shape_real_serialize (FaceShape* self,
                           gboolean geometry_only)
{
	g_critical ("Type `%s' does not implement abstract method `face_shape_serialize'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gchar*
face_shape_serialize (FaceShape* self,
                      gboolean geometry_only)
{
	FaceShapeClass* _klass_;
	g_return_val_if_fail (IS_FACE_SHAPE (self), NULL);
	_klass_ = FACE_SHAPE_GET_CLASS (self);
	if (_klass_->serialize) {
		return _klass_->serialize (self, geometry_only);
	}
	return NULL;
}

static void
face_shape_real_update_face_window_position (FaceShape* self)
{
	g_critical ("Type `%s' does not implement abstract method `face_shape_update_face_window_position'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
face_shape_update_face_window_position (FaceShape* self)
{
	FaceShapeClass* _klass_;
	g_return_if_fail (IS_FACE_SHAPE (self));
	_klass_ = FACE_SHAPE_GET_CLASS (self);
	if (_klass_->update_face_window_position) {
		_klass_->update_face_window_position (self);
	}
}

static void
face_shape_real_prepare_ctx (FaceShape* self,
                             cairo_t* ctx,
                             Dimensions* dim)
{
	g_critical ("Type `%s' does not implement abstract method `face_shape_prepare_ctx'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
face_shape_prepare_ctx (FaceShape* self,
                        cairo_t* ctx,
                        Dimensions* dim)
{
	FaceShapeClass* _klass_;
	g_return_if_fail (IS_FACE_SHAPE (self));
	_klass_ = FACE_SHAPE_GET_CLASS (self);
	if (_klass_->prepare_ctx) {
		_klass_->prepare_ctx (self, ctx, dim);
	}
}

static void
face_shape_real_on_resized_pixbuf (FaceShape* self,
                                   Dimensions* old_dim,
                                   GdkPixbuf* scaled)
{
	g_critical ("Type `%s' does not implement abstract method `face_shape_on_resized_pixbuf'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
face_shape_on_resized_pixbuf (FaceShape* self,
                              Dimensions* old_dim,
                              GdkPixbuf* scaled)
{
	FaceShapeClass* _klass_;
	g_return_if_fail (IS_FACE_SHAPE (self));
	_klass_ = FACE_SHAPE_GET_CLASS (self);
	if (_klass_->on_resized_pixbuf) {
		_klass_->on_resized_pixbuf (self, old_dim, scaled);
	}
}

static void
face_shape_real_on_motion (FaceShape* self,
                           gint x,
                           gint y,
                           GdkModifierType mask)
{
	g_critical ("Type `%s' does not implement abstract method `face_shape_on_motion'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
face_shape_on_motion (FaceShape* self,
                      gint x,
                      gint y,
                      GdkModifierType mask)
{
	FaceShapeClass* _klass_;
	g_return_if_fail (IS_FACE_SHAPE (self));
	_klass_ = FACE_SHAPE_GET_CLASS (self);
	if (_klass_->on_motion) {
		_klass_->on_motion (self, x, y, mask);
	}
}

static void
face_shape_real_on_left_released (FaceShape* self,
                                  gint x,
                                  gint y)
{
	g_critical ("Type `%s' does not implement abstract method `face_shape_on_left_released'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
face_shape_on_left_released (FaceShape* self,
                             gint x,
                             gint y)
{
	FaceShapeClass* _klass_;
	g_return_if_fail (IS_FACE_SHAPE (self));
	_klass_ = FACE_SHAPE_GET_CLASS (self);
	if (_klass_->on_left_released) {
		_klass_->on_left_released (self, x, y);
	}
}

static gboolean
face_shape_real_on_left_click (FaceShape* self,
                               gint x,
                               gint y)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `face_shape_on_left_click'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
face_shape_on_left_click (FaceShape* self,
                          gint x,
                          gint y)
{
	FaceShapeClass* _klass_;
	g_return_val_if_fail (IS_FACE_SHAPE (self), FALSE);
	_klass_ = FACE_SHAPE_GET_CLASS (self);
	if (_klass_->on_left_click) {
		return _klass_->on_left_click (self, x, y);
	}
	return FALSE;
}

static gboolean
face_shape_real_cursor_is_over (FaceShape* self,
                                gint x,
                                gint y)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `face_shape_cursor_is_over'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
face_shape_cursor_is_over (FaceShape* self,
                           gint x,
                           gint y)
{
	FaceShapeClass* _klass_;
	g_return_val_if_fail (IS_FACE_SHAPE (self), FALSE);
	_klass_ = FACE_SHAPE_GET_CLASS (self);
	if (_klass_->cursor_is_over) {
		return _klass_->cursor_is_over (self, x, y);
	}
	return FALSE;
}

static gboolean
face_shape_real_equals (FaceShape* self,
                        FaceShape* face_shape)
{
	gboolean _tmp0_ = FALSE;
	g_critical ("Type `%s' does not implement abstract method `face_shape_equals'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gboolean
face_shape_equals (FaceShape* self,
                   FaceShape* face_shape)
{
	FaceShapeClass* _klass_;
	g_return_val_if_fail (IS_FACE_SHAPE (self), FALSE);
	_klass_ = FACE_SHAPE_GET_CLASS (self);
	if (_klass_->equals) {
		return _klass_->equals (self, face_shape);
	}
	return FALSE;
}

static gdouble
face_shape_real_get_distance (FaceShape* self,
                              gint x,
                              gint y)
{
	gdouble _tmp0_ = 0.0;
	g_critical ("Type `%s' does not implement abstract method `face_shape_get_distance'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return _tmp0_;
}

gdouble
face_shape_get_distance (FaceShape* self,
                         gint x,
                         gint y)
{
	FaceShapeClass* _klass_;
	g_return_val_if_fail (IS_FACE_SHAPE (self), 0.0);
	_klass_ = FACE_SHAPE_GET_CLASS (self);
	if (_klass_->get_distance) {
		return _klass_->get_distance (self, x, y);
	}
	return -1.0;
}

static gdouble*
face_shape_real_get_face_vec (FaceShape* self,
                              gint* result_length1)
{
	g_critical ("Type `%s' does not implement abstract method `face_shape_get_face_vec'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return NULL;
}

gdouble*
face_shape_get_face_vec (FaceShape* self,
                         gint* result_length1)
{
	FaceShapeClass* _klass_;
	g_return_val_if_fail (IS_FACE_SHAPE (self), NULL);
	_klass_ = FACE_SHAPE_GET_CLASS (self);
	if (_klass_->get_face_vec) {
		return _klass_->get_face_vec (self, result_length1);
	}
	return NULL;
}

static void
face_shape_real_paint (FaceShape* self)
{
	g_critical ("Type `%s' does not implement abstract method `face_shape_paint'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
face_shape_paint (FaceShape* self)
{
	FaceShapeClass* _klass_;
	g_return_if_fail (IS_FACE_SHAPE (self));
	_klass_ = FACE_SHAPE_GET_CLASS (self);
	if (_klass_->paint) {
		_klass_->paint (self);
	}
}

static void
face_shape_real_erase (FaceShape* self)
{
	g_critical ("Type `%s' does not implement abstract method `face_shape_erase'", g_type_name (G_TYPE_FROM_INSTANCE (self)));
	return;
}

void
face_shape_erase (FaceShape* self)
{
	FaceShapeClass* _klass_;
	g_return_if_fail (IS_FACE_SHAPE (self));
	_klass_ = FACE_SHAPE_GET_CLASS (self);
	if (_klass_->erase) {
		_klass_->erase (self);
	}
}

static void
face_shape_class_init (FaceShapeClass * klass,
                       gpointer klass_data)
{
	face_shape_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FaceShape_private_offset);
	((FaceShapeClass *) klass)->serialize = (gchar* (*) (FaceShape*, gboolean)) face_shape_real_serialize;
	((FaceShapeClass *) klass)->update_face_window_position = (void (*) (FaceShape*)) face_shape_real_update_face_window_position;
	((FaceShapeClass *) klass)->prepare_ctx = (void (*) (FaceShape*, cairo_t*, Dimensions*)) face_shape_real_prepare_ctx;
	((FaceShapeClass *) klass)->on_resized_pixbuf = (void (*) (FaceShape*, Dimensions*, GdkPixbuf*)) face_shape_real_on_resized_pixbuf;
	((FaceShapeClass *) klass)->on_motion = (void (*) (FaceShape*, gint, gint, GdkModifierType)) face_shape_real_on_motion;
	((FaceShapeClass *) klass)->on_left_released = (void (*) (FaceShape*, gint, gint)) face_shape_real_on_left_released;
	((FaceShapeClass *) klass)->on_left_click = (gboolean (*) (FaceShape*, gint, gint)) face_shape_real_on_left_click;
	((FaceShapeClass *) klass)->cursor_is_over = (gboolean (*) (FaceShape*, gint, gint)) face_shape_real_cursor_is_over;
	((FaceShapeClass *) klass)->equals = (gboolean (*) (FaceShape*, FaceShape*)) face_shape_real_equals;
	((FaceShapeClass *) klass)->get_distance = (gdouble (*) (FaceShape*, gint, gint)) face_shape_real_get_distance;
	((FaceShapeClass *) klass)->get_face_vec = (gdouble* (*) (FaceShape*, gint*)) face_shape_real_get_face_vec;
	((FaceShapeClass *) klass)->paint = (void (*) (FaceShape*)) face_shape_real_paint;
	((FaceShapeClass *) klass)->erase = (void (*) (FaceShape*)) face_shape_real_erase;
	G_OBJECT_CLASS (klass)->finalize = face_shape_finalize;
	face_shape_signals[FACE_SHAPE_ADD_ME_REQUESTED_SIGNAL] = g_signal_new ("add-me-requested", TYPE_FACE_SHAPE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_FACE_SHAPE);
	face_shape_signals[FACE_SHAPE_DELETE_ME_REQUESTED_SIGNAL] = g_signal_new ("delete-me-requested", TYPE_FACE_SHAPE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}

static void
face_shape_instance_init (FaceShape * self,
                          gpointer klass)
{
	self->priv = face_shape_get_instance_private (self);
	self->current_cursor_type = GDK_BOTTOM_RIGHT_CORNER;
	self->serialized = NULL;
	self->priv->editable = TRUE;
	self->priv->visible = TRUE;
	self->priv->known = TRUE;
	self->priv->guess = 0.0;
	self->priv->face_widget = NULL;
}

static void
face_shape_finalize (GObject * obj)
{
	FaceShape * self;
	FacesToolEditingFaceToolWindow* _tmp0_;
	EditingToolsPhotoCanvas* _tmp1_;
	guint _tmp2_;
	EditingToolsPhotoCanvas* _tmp3_;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FACE_SHAPE, FaceShape);
	if (self->priv->visible) {
		face_shape_erase (self);
	}
	_tmp0_ = self->face_window;
	gtk_widget_destroy (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
	_tmp1_ = self->canvas;
	g_signal_parse_name ("new-surface", EDITING_TOOLS_TYPE_PHOTO_CANVAS, &_tmp2_, NULL, FALSE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, 0, NULL, (GCallback) _face_shape_prepare_ctx_editing_tools_photo_canvas_new_surface, self);
	_tmp3_ = self->canvas;
	editing_tools_photo_canvas_set_cursor (_tmp3_, GDK_LEFT_PTR);
	_g_object_unref0 (self->face_window);
	_editing_tools_photo_canvas_unref0 (self->canvas);
	_g_free0 (self->serialized);
	self->face_vec = (g_free (self->face_vec), NULL);
	G_OBJECT_CLASS (face_shape_parent_class)->finalize (obj);
}

static GType
face_shape_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FaceShapeClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) face_shape_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FaceShape), 0, (GInstanceInitFunc) face_shape_instance_init, NULL };
	GType face_shape_type_id;
	face_shape_type_id = g_type_register_static (G_TYPE_OBJECT, "FaceShape", &g_define_type_info, G_TYPE_FLAG_ABSTRACT);
	FaceShape_private_offset = g_type_add_instance_private (face_shape_type_id, sizeof (FaceShapePrivate));
	return face_shape_type_id;
}

GType
face_shape_get_type (void)
{
	static volatile gsize face_shape_type_id__once = 0;
	if (g_once_init_enter (&face_shape_type_id__once)) {
		GType face_shape_type_id;
		face_shape_type_id = face_shape_get_type_once ();
		g_once_init_leave (&face_shape_type_id__once, face_shape_type_id);
	}
	return face_shape_type_id__once;
}

static inline gpointer
face_rectangle_get_instance_private (FaceRectangle* self)
{
	return G_STRUCT_MEMBER_P (self, FaceRectangle_private_offset);
}

static gdouble*
_vala_array_dup39 (gdouble* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gdouble));
	}
	return NULL;
}

FaceRectangle*
face_rectangle_construct (GType object_type,
                          EditingToolsPhotoCanvas* canvas,
                          gint x,
                          gint y,
                          gint half_width,
                          gint half_height,
                          gdouble* vec,
                          gint vec_length1)
{
	FaceRectangle * self = NULL;
	gdouble* int_vec = NULL;
	gint int_vec_length1 = 0;
	gint _int_vec_size_ = 0;
	gdouble* _tmp3_;
	gint _tmp3__length1;
	GdkRectangle scaled_pixbuf_pos = {0};
	GdkRectangle _tmp4_ = {0};
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	g_return_val_if_fail (EDITING_TOOLS_IS_PHOTO_CANVAS (canvas), NULL);
	if (vec_length1 == 0) {
		gint _tmp0_ = 0;
		gdouble* _tmp1_;
		_tmp1_ = face_rectangle_create_empty_vec (&_tmp0_);
		int_vec = (g_free (int_vec), NULL);
		int_vec = _tmp1_;
		int_vec_length1 = _tmp0_;
		_int_vec_size_ = int_vec_length1;
	} else {
		gdouble* _tmp2_;
		gint _tmp2__length1;
		_tmp2_ = (vec != NULL) ? _vala_array_dup39 (vec, vec_length1) : vec;
		_tmp2__length1 = vec_length1;
		int_vec = (g_free (int_vec), NULL);
		int_vec = _tmp2_;
		int_vec_length1 = _tmp2__length1;
		_int_vec_size_ = int_vec_length1;
	}
	_tmp3_ = int_vec;
	_tmp3__length1 = int_vec_length1;
	self = (FaceRectangle*) face_shape_construct (object_type, canvas, _tmp3_, (gint) _tmp3__length1);
	editing_tools_photo_canvas_get_scaled_pixbuf_position (canvas, &_tmp4_);
	scaled_pixbuf_pos = _tmp4_;
	_tmp5_ = scaled_pixbuf_pos;
	x = x - _tmp5_.x;
	_tmp6_ = scaled_pixbuf_pos;
	y = y - _tmp6_.y;
	if (half_width == FACE_RECTANGLE_NULL_SIZE) {
		box_init (&self->priv->box, x, y, x, y);
		self->priv->in_manipulation = BOX_LOCATION_BOTTOM_RIGHT;
		self->priv->last_grab_x = x;
		self->priv->last_grab_y = y;
	} else {
		Dimensions pixbuf_dimensions = {0};
		GdkPixbuf* _tmp7_;
		GdkPixbuf* _tmp8_;
		Dimensions _tmp9_ = {0};
		Dimensions _tmp10_;
		gint right = 0;
		Dimensions _tmp11_;
		gint bottom = 0;
		Dimensions _tmp12_;
		_tmp7_ = editing_tools_photo_canvas_get_scaled_pixbuf (canvas);
		_tmp8_ = _tmp7_;
		dimensions_for_pixbuf (_tmp8_, &_tmp9_);
		_tmp10_ = _tmp9_;
		_g_object_unref0 (_tmp8_);
		pixbuf_dimensions = _tmp10_;
		_tmp11_ = pixbuf_dimensions;
		right = CLAMP (x + half_width, x, _tmp11_.width);
		_tmp12_ = pixbuf_dimensions;
		bottom = CLAMP (y + half_height, y, _tmp12_.height);
		box_init (&self->priv->box, x - half_width, y - half_height, right, bottom);
	}
	int_vec = (g_free (int_vec), NULL);
	return self;
}

FaceRectangle*
face_rectangle_new (EditingToolsPhotoCanvas* canvas,
                    gint x,
                    gint y,
                    gint half_width,
                    gint half_height,
                    gdouble* vec,
                    gint vec_length1)
{
	return face_rectangle_construct (TYPE_FACE_RECTANGLE, canvas, x, y, half_width, half_height, vec, vec_length1);
}

gdouble*
face_rectangle_create_empty_vec (gint* result_length1)
{
	gdouble* empty_vec = NULL;
	gdouble* _tmp0_;
	gint empty_vec_length1;
	gint _empty_vec_size_;
	gdouble* _tmp4_;
	gint _tmp4__length1;
	gdouble* result;
	_tmp0_ = g_new0 (gdouble, 128);
	empty_vec = _tmp0_;
	empty_vec_length1 = 128;
	_empty_vec_size_ = empty_vec_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gdouble* _tmp3_;
				gint _tmp3__length1;
				if (!_tmp1_) {
					gint _tmp2_;
					_tmp2_ = i;
					i = _tmp2_ + 1;
				}
				_tmp1_ = FALSE;
				if (!(i < 128)) {
					break;
				}
				_tmp3_ = empty_vec;
				_tmp3__length1 = empty_vec_length1;
				_tmp3_[i] = (gdouble) 0;
			}
		}
	}
	_tmp4_ = empty_vec;
	_tmp4__length1 = empty_vec_length1;
	if (result_length1) {
		*result_length1 = _tmp4__length1;
	}
	result = _tmp4_;
	return result;
}

static gdouble
double_parse (const gchar* str)
{
	gdouble result;
	g_return_val_if_fail (str != NULL, 0.0);
	result = g_ascii_strtod (str, NULL);
	return result;
}

FaceRectangle*
face_rectangle_from_serialized (EditingToolsPhotoCanvas* canvas,
                                gchar** args,
                                gint args_length1,
                                GError** error)
{
	const gchar* _tmp0_;
	Photo* photo = NULL;
	Photo* _tmp1_;
	Dimensions raw_dim = {0};
	Photo* _tmp2_;
	Dimensions _tmp3_ = {0};
	gint x = 0;
	Dimensions _tmp4_;
	const gchar* _tmp5_;
	gint y = 0;
	Dimensions _tmp6_;
	const gchar* _tmp7_;
	gint half_width = 0;
	Dimensions _tmp8_;
	const gchar* _tmp9_;
	gint half_height = 0;
	Dimensions _tmp10_;
	const gchar* _tmp11_;
	Box box = {0};
	Dimensions current_dim = {0};
	GdkPixbuf* _tmp12_;
	GdkPixbuf* _tmp13_;
	Dimensions _tmp14_ = {0};
	Dimensions _tmp15_;
	Box raw_cropped = {0};
	Photo* _tmp16_;
	Box _tmp17_ = {0};
	gboolean _tmp18_;
	GdkRectangle scaled_pixbuf_pos = {0};
	GdkRectangle _tmp52_ = {0};
	GdkRectangle _tmp53_;
	GdkRectangle _tmp54_;
	GdkRectangle _tmp55_;
	GdkRectangle _tmp56_;
	gboolean _tmp57_ = FALSE;
	gchar** vec_str = NULL;
	gint vec_str_length1 = 0;
	gint _vec_str_size_ = 0;
	gdouble* vec = NULL;
	gdouble* _tmp63_;
	gint vec_length1;
	gint _vec_size_;
	Box _tmp71_;
	Box _tmp72_;
	gdouble* _tmp73_;
	gint _tmp73__length1;
	FaceRectangle* _tmp74_;
	GError* _inner_error0_ = NULL;
	FaceRectangle* result;
	g_return_val_if_fail (EDITING_TOOLS_IS_PHOTO_CANVAS (canvas), NULL);
	_tmp0_ = args[0];
	_vala_assert (g_strcmp0 (_tmp0_, FACE_RECTANGLE_SHAPE_TYPE) == 0, "args[0] == SHAPE_TYPE");
	_tmp1_ = editing_tools_photo_canvas_get_photo (canvas);
	photo = _tmp1_;
	_tmp2_ = photo;
	photo_get_raw_dimensions (_tmp2_, &_tmp3_);
	raw_dim = _tmp3_;
	_tmp4_ = raw_dim;
	_tmp5_ = args[1];
	x = (gint) (_tmp4_.width * double_parse (_tmp5_));
	_tmp6_ = raw_dim;
	_tmp7_ = args[2];
	y = (gint) (_tmp6_.height * double_parse (_tmp7_));
	_tmp8_ = raw_dim;
	_tmp9_ = args[3];
	half_width = (gint) (_tmp8_.width * double_parse (_tmp9_));
	_tmp10_ = raw_dim;
	_tmp11_ = args[4];
	half_height = (gint) (_tmp10_.height * double_parse (_tmp11_));
	box_init (&box, x - half_width, y - half_height, x + half_width, y + half_height);
	_tmp12_ = editing_tools_photo_canvas_get_scaled_pixbuf (canvas);
	_tmp13_ = _tmp12_;
	dimensions_for_pixbuf (_tmp13_, &_tmp14_);
	_tmp15_ = _tmp14_;
	_g_object_unref0 (_tmp13_);
	current_dim = _tmp15_;
	_tmp16_ = photo;
	_tmp18_ = photo_get_raw_crop (_tmp16_, &_tmp17_);
	raw_cropped = _tmp17_;
	if (_tmp18_) {
		Box _tmp19_;
		Box _tmp20_;
		Box _tmp21_;
		Box _tmp22_;
		Box _tmp23_;
		Box _tmp24_;
		Box _tmp25_;
		Box _tmp26_;
		Box _tmp27_;
		Box _tmp28_;
		Box _tmp29_;
		Box _tmp30_;
		Box _tmp31_;
		Box _tmp32_;
		Box _tmp33_;
		Box _tmp34_;
		Photo* _tmp35_;
		Dimensions _tmp36_ = {0};
		Box _tmp37_;
		Box _tmp38_ = {0};
		Box cropped = {0};
		Photo* _tmp39_;
		Box _tmp40_ = {0};
		Dimensions _tmp41_ = {0};
		Dimensions _tmp42_;
		Box _tmp43_ = {0};
		_tmp19_ = box;
		_tmp20_ = raw_cropped;
		_tmp21_ = box;
		_tmp22_ = raw_cropped;
		box.left = CLAMP (_tmp19_.left, _tmp20_.left, _tmp21_.left) - _tmp22_.left;
		_tmp23_ = box;
		_tmp24_ = box;
		_tmp25_ = raw_cropped;
		_tmp26_ = raw_cropped;
		box.right = CLAMP (_tmp23_.right, _tmp24_.right, _tmp25_.right) - _tmp26_.left;
		_tmp27_ = box;
		_tmp28_ = raw_cropped;
		_tmp29_ = box;
		_tmp30_ = raw_cropped;
		box.top = CLAMP (_tmp27_.top, _tmp28_.top, _tmp29_.top) - _tmp30_.top;
		_tmp31_ = box;
		_tmp32_ = box;
		_tmp33_ = raw_cropped;
		_tmp34_ = raw_cropped;
		box.bottom = CLAMP (_tmp31_.bottom, _tmp32_.bottom, _tmp33_.bottom) - _tmp34_.top;
		_tmp35_ = photo;
		box_get_dimensions (&raw_cropped, &_tmp36_);
		_tmp37_ = box;
		orientation_rotate_box (photo_get_orientation (_tmp35_), &_tmp36_, &_tmp37_, &_tmp38_);
		box = _tmp38_;
		_tmp39_ = photo;
		photo_get_crop (_tmp39_, &_tmp40_, PHOTO_EXCEPTION_NONE);
		cropped = _tmp40_;
		box_get_dimensions (&cropped, &_tmp41_);
		_tmp42_ = current_dim;
		box_get_scaled_similar (&box, &_tmp41_, &_tmp42_, &_tmp43_);
		box = _tmp43_;
	} else {
		Photo* _tmp44_;
		Dimensions _tmp45_;
		Box _tmp46_;
		Box _tmp47_ = {0};
		Photo* _tmp48_;
		Dimensions _tmp49_ = {0};
		Dimensions _tmp50_;
		Box _tmp51_ = {0};
		_tmp44_ = photo;
		_tmp45_ = raw_dim;
		_tmp46_ = box;
		orientation_rotate_box (photo_get_orientation (_tmp44_), &_tmp45_, &_tmp46_, &_tmp47_);
		box = _tmp47_;
		_tmp48_ = photo;
		media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp48_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp49_);
		_tmp50_ = current_dim;
		box_get_scaled_similar (&box, &_tmp49_, &_tmp50_, &_tmp51_);
		box = _tmp51_;
	}
	editing_tools_photo_canvas_get_scaled_pixbuf_position (canvas, &_tmp52_);
	scaled_pixbuf_pos = _tmp52_;
	_tmp53_ = scaled_pixbuf_pos;
	box.left = box.left + _tmp53_.x;
	_tmp54_ = scaled_pixbuf_pos;
	box.right = box.right + _tmp54_.x;
	_tmp55_ = scaled_pixbuf_pos;
	box.top = box.top + _tmp55_.y;
	_tmp56_ = scaled_pixbuf_pos;
	box.bottom = box.bottom + _tmp56_.y;
	half_width = box_get_width (&box) / 2;
	half_height = box_get_height (&box) / 2;
	if (half_width < FACE_RECTANGLE_FACE_MIN_SIZE) {
		_tmp57_ = TRUE;
	} else {
		_tmp57_ = half_height < FACE_RECTANGLE_FACE_MIN_SIZE;
	}
	if (_tmp57_) {
		GError* _tmp58_;
		_tmp58_ = g_error_new_literal (FACE_SHAPE_ERROR, FACE_SHAPE_ERROR_CANT_CREATE, "FaceShape is out of cropped photo area");
		_inner_error0_ = _tmp58_;
		if (_inner_error0_->domain == FACE_SHAPE_ERROR) {
			g_propagate_error (error, _inner_error0_);
			_g_object_unref0 (photo);
			return NULL;
		} else {
			_g_object_unref0 (photo);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
	}
	if (args_length1 == 6) {
		const gchar* _tmp59_;
		gchar** _tmp60_;
		gchar** _tmp61_;
		_tmp59_ = args[5];
		_tmp61_ = _tmp60_ = g_strsplit (_tmp59_, ",", 0);
		vec_str = (_vala_array_free (vec_str, vec_str_length1, (GDestroyNotify) g_free), NULL);
		vec_str = _tmp61_;
		vec_str_length1 = _vala_array_length (_tmp60_);
		_vec_str_size_ = vec_str_length1;
	} else {
		gchar** _tmp62_;
		_tmp62_ = g_new0 (gchar*, 0 + 1);
		vec_str = (_vala_array_free (vec_str, vec_str_length1, (GDestroyNotify) g_free), NULL);
		vec_str = _tmp62_;
		vec_str_length1 = 0;
		_vec_str_size_ = vec_str_length1;
	}
	_tmp63_ = g_new0 (gdouble, 128);
	vec = _tmp63_;
	vec_length1 = 128;
	_vec_size_ = vec_length1;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp64_ = FALSE;
			_tmp64_ = TRUE;
			while (TRUE) {
				gchar** _tmp66_;
				gint _tmp66__length1;
				if (!_tmp64_) {
					gint _tmp65_;
					_tmp65_ = i;
					i = _tmp65_ + 1;
				}
				_tmp64_ = FALSE;
				if (!(i < 128)) {
					break;
				}
				_tmp66_ = vec_str;
				_tmp66__length1 = vec_str_length1;
				if (_tmp66__length1 > i) {
					gdouble* _tmp67_;
					gint _tmp67__length1;
					gchar** _tmp68_;
					gint _tmp68__length1;
					const gchar* _tmp69_;
					_tmp67_ = vec;
					_tmp67__length1 = vec_length1;
					_tmp68_ = vec_str;
					_tmp68__length1 = vec_str_length1;
					_tmp69_ = _tmp68_[i];
					_tmp67_[i] = double_parse (_tmp69_);
				} else {
					gdouble* _tmp70_;
					gint _tmp70__length1;
					_tmp70_ = vec;
					_tmp70__length1 = vec_length1;
					_tmp70_[i] = (gdouble) 0;
				}
			}
		}
	}
	_tmp71_ = box;
	_tmp72_ = box;
	_tmp73_ = vec;
	_tmp73__length1 = vec_length1;
	_tmp74_ = face_rectangle_new (canvas, _tmp71_.left + half_width, _tmp72_.top + half_height, half_width, half_height, _tmp73_, _tmp73__length1);
	result = _tmp74_;
	vec = (g_free (vec), NULL);
	vec_str = (_vala_array_free (vec_str, vec_str_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (photo);
	return result;
}

static void
face_rectangle_real_update_face_window_position (FaceShape* base)
{
	FaceRectangle * self;
	AppWindow* appWindow = NULL;
	AppWindow* _tmp0_;
	GtkAllocation face_window_alloc = {0};
	GdkRectangle scaled_pixbuf_pos = {0};
	EditingToolsPhotoCanvas* _tmp1_;
	GdkRectangle _tmp2_ = {0};
	gint x = 0;
	gint y = 0;
	EditingToolsPhotoCanvas* _tmp3_;
	GtkWindow* _tmp4_;
	GtkWindow* _tmp5_;
	AppWindow* _tmp6_;
	gboolean _tmp7_;
	FacesToolEditingFaceToolWindow* _tmp17_;
	GtkAllocation _tmp18_ = {0};
	gdouble scale = 0.0;
	gint left = 0;
	GdkRectangle _tmp19_;
	Box _tmp20_;
	gint width = 0;
	gint top = 0;
	GdkRectangle _tmp21_;
	Box _tmp22_;
	GtkAllocation _tmp23_;
	FacesToolEditingFaceToolWindow* _tmp24_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_RECTANGLE, FaceRectangle);
	_tmp0_ = app_window_get_instance ();
	appWindow = _tmp0_;
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	editing_tools_photo_canvas_get_scaled_pixbuf_position (_tmp1_, &_tmp2_);
	scaled_pixbuf_pos = _tmp2_;
	x = 0;
	y = 0;
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp4_ = editing_tools_photo_canvas_get_container (_tmp3_);
	_tmp5_ = _tmp4_;
	_tmp6_ = appWindow;
	_tmp7_ = _tmp5_ == G_TYPE_CHECK_INSTANCE_CAST (_tmp6_, gtk_window_get_type (), GtkWindow);
	_g_object_unref0 (_tmp5_);
	if (_tmp7_) {
		AppWindow* _tmp8_;
		Page* _tmp9_;
		Page* _tmp10_;
		GdkWindow* _tmp11_;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		_tmp8_ = appWindow;
		_tmp9_ = page_window_get_current_page (G_TYPE_CHECK_INSTANCE_CAST (_tmp8_, TYPE_PAGE_WINDOW, PageWindow));
		_tmp10_ = _tmp9_;
		_tmp11_ = gtk_widget_get_window (G_TYPE_CHECK_INSTANCE_CAST (_tmp10_, gtk_widget_get_type (), GtkWidget));
		gdk_window_get_origin (_tmp11_, &_tmp12_, &_tmp13_);
		x = _tmp12_;
		y = _tmp13_;
		_g_object_unref0 (_tmp10_);
	} else {
		EditingToolsPhotoCanvas* _tmp14_;
		GtkWindow* _tmp15_;
		GtkWindow* _tmp16_;
		_tmp14_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
		_tmp15_ = editing_tools_photo_canvas_get_container (_tmp14_);
		_tmp16_ = _tmp15_;
		_vala_assert (IS_FULLSCREEN_WINDOW (_tmp16_), "canvas.get_container() is FullscreenWindow");
		_g_object_unref0 (_tmp16_);
	}
	_tmp17_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->face_window;
	gtk_widget_get_allocation (G_TYPE_CHECK_INSTANCE_CAST (_tmp17_, gtk_widget_get_type (), GtkWidget), &_tmp18_);
	face_window_alloc = _tmp18_;
	scale = application_get_scale ();
	_tmp19_ = scaled_pixbuf_pos;
	_tmp20_ = self->priv->box;
	left = (gint) lround ((_tmp19_.x + _tmp20_.left) / scale);
	width = (gint) lround (box_get_width (&self->priv->box) / scale);
	_tmp21_ = scaled_pixbuf_pos;
	_tmp22_ = self->priv->box;
	top = (gint) lround ((_tmp21_.y + _tmp22_.bottom) / scale);
	_tmp23_ = face_window_alloc;
	x += left + ((width - _tmp23_.width) >> 1);
	y += top + FACE_SHAPE_FACE_WINDOW_MARGIN;
	_tmp24_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->face_window;
	gtk_window_move (G_TYPE_CHECK_INSTANCE_CAST (_tmp24_, gtk_window_get_type (), GtkWindow), x, y);
	_g_object_unref0 (appWindow);
}

static void
face_rectangle_real_paint (FaceShape* base)
{
	FaceRectangle * self;
	EditingToolsPhotoCanvas* _tmp0_;
	cairo_t* _tmp1_;
	Box _tmp2_;
	EditingToolsPhotoCanvas* _tmp3_;
	cairo_t* _tmp4_;
	Box _tmp5_ = {0};
	EditingToolsPhotoCanvas* _tmp6_;
	cairo_t* _tmp7_;
	Box _tmp8_ = {0};
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_RECTANGLE, FaceRectangle);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp1_ = self->priv->wide_black_ctx;
	_tmp2_ = self->priv->box;
	editing_tools_photo_canvas_draw_box (_tmp0_, _tmp1_, &_tmp2_);
	_tmp3_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp4_ = self->priv->wide_white_ctx;
	box_get_reduced (&self->priv->box, 1, &_tmp5_);
	editing_tools_photo_canvas_draw_box (_tmp3_, _tmp4_, &_tmp5_);
	_tmp6_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp7_ = self->priv->wide_white_ctx;
	box_get_reduced (&self->priv->box, 2, &_tmp8_);
	editing_tools_photo_canvas_draw_box (_tmp6_, _tmp7_, &_tmp8_);
	if (!face_shape_is_editable (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape))) {
		face_rectangle_paint_label (self);
	}
}

static void
face_rectangle_real_erase (FaceShape* base)
{
	FaceRectangle * self;
	EditingToolsPhotoCanvas* _tmp0_;
	Box _tmp1_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_RECTANGLE, FaceRectangle);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp1_ = self->priv->box;
	editing_tools_photo_canvas_invalidate_area (_tmp0_, &_tmp1_);
	if (!face_shape_is_editable (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape))) {
		face_rectangle_erase_label (self);
	}
}

static gpointer
_box_dup0 (gpointer self)
{
	return self ? box_dup (self) : NULL;
}

static void
face_rectangle_paint_label (FaceRectangle* self)
{
	cairo_t* ctx = NULL;
	EditingToolsPhotoCanvas* _tmp0_;
	cairo_t* _tmp1_;
	GdkRectangle scaled_pixbuf_pos = {0};
	EditingToolsPhotoCanvas* _tmp2_;
	GdkRectangle _tmp3_ = {0};
	cairo_text_extents_t text_extents = {0};
	gchar* _tmp4_;
	gchar* _tmp5_;
	cairo_text_extents_t _tmp6_ = {0};
	gint width = 0;
	cairo_text_extents_t _tmp7_;
	gint height = 0;
	cairo_text_extents_t _tmp8_;
	gint x = 0;
	Box _tmp9_;
	gint y = 0;
	Box _tmp10_;
	Box _tmp11_ = {0};
	Box* _tmp12_;
	GdkRectangle _tmp13_;
	GdkRectangle _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	g_return_if_fail (IS_FACE_RECTANGLE (self));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp1_ = editing_tools_photo_canvas_get_default_ctx (_tmp0_);
	ctx = _tmp1_;
	_tmp2_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	editing_tools_photo_canvas_get_scaled_pixbuf_position (_tmp2_, &_tmp3_);
	scaled_pixbuf_pos = _tmp3_;
	cairo_save (ctx);
	cairo_select_font_face (ctx, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_NORMAL);
	cairo_set_font_size (ctx, 10.0 * application_get_scale ());
	memset (&text_extents, 0, sizeof (cairo_text_extents_t));
	_tmp4_ = face_shape_get_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape));
	_tmp5_ = _tmp4_;
	cairo_text_extents (ctx, _tmp5_, &_tmp6_);
	text_extents = _tmp6_;
	_g_free0 (_tmp5_);
	_tmp7_ = text_extents;
	width = ((gint) _tmp7_.width) + FACE_SHAPE_LABEL_PADDING;
	_tmp8_ = text_extents;
	height = (gint) _tmp8_.height;
	_tmp9_ = self->priv->box;
	x = _tmp9_.left + ((box_get_width (&self->priv->box) - width) / 2);
	_tmp10_ = self->priv->box;
	y = _tmp10_.bottom + FACE_SHAPE_LABEL_MARGIN;
	box_init (&_tmp11_, x, y, x + width, (y + height) + FACE_SHAPE_LABEL_PADDING);
	_tmp12_ = _box_dup0 (&_tmp11_);
	_box_free0 (self->priv->label_box);
	self->priv->label_box = _tmp12_;
	_tmp13_ = scaled_pixbuf_pos;
	x += _tmp13_.x;
	_tmp14_ = scaled_pixbuf_pos;
	y += _tmp14_.y;
	cairo_rectangle (ctx, (gdouble) x, (gdouble) y, (gdouble) width, (gdouble) (height + FACE_SHAPE_LABEL_PADDING));
	cairo_set_source_rgba (ctx, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.6);
	cairo_fill (ctx);
	cairo_set_source_rgb (ctx, (gdouble) 1, (gdouble) 1, (gdouble) 1);
	cairo_move_to (ctx, (gdouble) (x + (FACE_SHAPE_LABEL_PADDING / 2)), (gdouble) ((y + height) + (FACE_SHAPE_LABEL_PADDING / 2)));
	_tmp15_ = face_shape_get_name (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape));
	_tmp16_ = _tmp15_;
	cairo_show_text (ctx, _tmp16_);
	_g_free0 (_tmp16_);
	cairo_restore (ctx);
	_cairo_destroy0 (ctx);
}

static void
face_rectangle_erase_label (FaceRectangle* self)
{
	Box* _tmp0_;
	GdkRectangle scaled_pixbuf_pos = {0};
	EditingToolsPhotoCanvas* _tmp1_;
	GdkRectangle _tmp2_ = {0};
	gint x = 0;
	GdkRectangle _tmp3_;
	Box* _tmp4_;
	gint y = 0;
	GdkRectangle _tmp5_;
	Box* _tmp6_;
	cairo_t* ctx = NULL;
	EditingToolsPhotoCanvas* _tmp7_;
	cairo_t* _tmp8_;
	cairo_t* _tmp9_;
	cairo_t* _tmp10_;
	cairo_t* _tmp11_;
	Box* _tmp12_;
	Box* _tmp13_;
	cairo_t* _tmp14_;
	cairo_t* _tmp15_;
	cairo_t* _tmp16_;
	EditingToolsPhotoCanvas* _tmp17_;
	cairo_surface_t* _tmp18_;
	cairo_surface_t* _tmp19_;
	GdkRectangle _tmp20_;
	GdkRectangle _tmp21_;
	cairo_t* _tmp22_;
	EditingToolsPhotoCanvas* _tmp23_;
	Box* _tmp24_;
	Box _tmp25_;
	cairo_t* _tmp26_;
	g_return_if_fail (IS_FACE_RECTANGLE (self));
	_tmp0_ = self->priv->label_box;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	editing_tools_photo_canvas_get_scaled_pixbuf_position (_tmp1_, &_tmp2_);
	scaled_pixbuf_pos = _tmp2_;
	_tmp3_ = scaled_pixbuf_pos;
	_tmp4_ = self->priv->label_box;
	x = _tmp3_.x + (*_tmp4_).left;
	_tmp5_ = scaled_pixbuf_pos;
	_tmp6_ = self->priv->label_box;
	y = _tmp5_.y + (*_tmp6_).top;
	_tmp7_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp8_ = editing_tools_photo_canvas_get_default_ctx (_tmp7_);
	ctx = _tmp8_;
	_tmp9_ = ctx;
	cairo_save (_tmp9_);
	_tmp10_ = ctx;
	cairo_set_operator (_tmp10_, CAIRO_OPERATOR_OVER);
	_tmp11_ = ctx;
	_tmp12_ = self->priv->label_box;
	_tmp13_ = self->priv->label_box;
	cairo_rectangle (_tmp11_, (gdouble) x, (gdouble) y, (gdouble) box_get_width (_tmp12_), (gdouble) box_get_height (_tmp13_));
	_tmp14_ = ctx;
	cairo_set_source_rgb (_tmp14_, 0.0, 0.0, 0.0);
	_tmp15_ = ctx;
	cairo_fill_preserve (_tmp15_);
	_tmp16_ = ctx;
	_tmp17_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp18_ = editing_tools_photo_canvas_get_scaled_surface (_tmp17_);
	_tmp19_ = _tmp18_;
	_tmp20_ = scaled_pixbuf_pos;
	_tmp21_ = scaled_pixbuf_pos;
	cairo_set_source_surface (_tmp16_, _tmp19_, (gdouble) _tmp20_.x, (gdouble) _tmp21_.y);
	_cairo_surface_destroy0 (_tmp19_);
	_tmp22_ = ctx;
	cairo_fill (_tmp22_);
	_tmp23_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp24_ = self->priv->label_box;
	_tmp25_ = *_tmp24_;
	editing_tools_photo_canvas_invalidate_area (_tmp23_, &_tmp25_);
	_box_free0 (self->priv->label_box);
	self->priv->label_box = NULL;
	_tmp26_ = ctx;
	cairo_restore (_tmp26_);
	_cairo_destroy0 (ctx);
}

static gchar*
double_to_string (gdouble self)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gint _tmp1__length1;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* result;
	_tmp0_ = g_new0 (gchar, G_ASCII_DTOSTR_BUF_SIZE);
	_tmp1_ = _tmp0_;
	_tmp1__length1 = G_ASCII_DTOSTR_BUF_SIZE;
	_tmp2_ = g_ascii_dtostr (_tmp1_, (gint) G_ASCII_DTOSTR_BUF_SIZE, self);
	_tmp3_ = g_strdup (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp1_ = (g_free (_tmp1_), NULL);
	result = _tmp4_;
	return result;
}

static gchar*
face_rectangle_real_serialize (FaceShape* base,
                               gboolean geometry_only)
{
	FaceRectangle * self;
	const gchar* _tmp0_;
	gdouble x = 0.0;
	gdouble y = 0.0;
	gdouble half_width = 0.0;
	gdouble half_height = 0.0;
	gdouble _tmp3_ = 0.0;
	gdouble _tmp4_ = 0.0;
	gdouble _tmp5_ = 0.0;
	gdouble _tmp6_ = 0.0;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	const gchar* _tmp33_;
	gchar* _tmp34_;
	gchar* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_RECTANGLE, FaceRectangle);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->serialized;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->serialized;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	face_rectangle_get_geometry (self, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	x = _tmp3_;
	y = _tmp4_;
	half_width = _tmp5_;
	half_height = _tmp6_;
	_tmp7_ = double_to_string (x);
	_tmp8_ = _tmp7_;
	_tmp9_ = double_to_string (y);
	_tmp10_ = _tmp9_;
	_tmp11_ = double_to_string (half_width);
	_tmp12_ = _tmp11_;
	_tmp13_ = double_to_string (half_height);
	_tmp14_ = _tmp13_;
	_tmp15_ = g_strdup_printf ("%s;%s;%s;%s;%s;", FACE_RECTANGLE_SHAPE_TYPE, _tmp8_, _tmp10_, _tmp12_, _tmp14_);
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->serialized);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->serialized = _tmp15_;
	_g_free0 (_tmp14_);
	_g_free0 (_tmp12_);
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	if (!geometry_only) {
		gchar* face_vec_str = NULL;
		gchar* _tmp16_;
		gdouble* _tmp17_;
		gint _tmp17__length1;
		const gchar* _tmp24_;
		gdouble* _tmp25_;
		gint _tmp25__length1;
		gdouble _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		const gchar* _tmp30_;
		const gchar* _tmp31_;
		gchar* _tmp32_;
		_tmp16_ = g_strdup ("");
		face_vec_str = _tmp16_;
		_tmp17_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->face_vec;
		_tmp17__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->face_vec_length1;
		{
			gdouble* d_collection = NULL;
			gint d_collection_length1 = 0;
			gint _d_collection_size_ = 0;
			gint d_it = 0;
			d_collection = _tmp17_ + 0;
			d_collection_length1 = -2 - 0;
			for (d_it = 0; d_it < d_collection_length1; d_it = d_it + 1) {
				gdouble d = 0.0;
				d = d_collection[d_it];
				{
					const gchar* _tmp18_;
					gchar* _tmp19_;
					gchar* _tmp20_;
					gchar* _tmp21_;
					gchar* _tmp22_;
					gchar* _tmp23_;
					_tmp18_ = face_vec_str;
					_tmp19_ = double_to_string (d);
					_tmp20_ = _tmp19_;
					_tmp21_ = g_strconcat (_tmp20_, ",", NULL);
					_tmp22_ = _tmp21_;
					_tmp23_ = g_strconcat (_tmp18_, _tmp22_, NULL);
					_g_free0 (face_vec_str);
					face_vec_str = _tmp23_;
					_g_free0 (_tmp22_);
					_g_free0 (_tmp20_);
				}
			}
		}
		_tmp24_ = face_vec_str;
		_tmp25_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->face_vec;
		_tmp25__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->face_vec_length1;
		_tmp26_ = _tmp25_[-1];
		_tmp27_ = double_to_string (_tmp26_);
		_tmp28_ = _tmp27_;
		_tmp29_ = g_strconcat (_tmp24_, _tmp28_, NULL);
		_g_free0 (face_vec_str);
		face_vec_str = _tmp29_;
		_g_free0 (_tmp28_);
		_tmp30_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->serialized;
		_tmp31_ = face_vec_str;
		_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
		_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->serialized);
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->serialized = _tmp32_;
		_g_free0 (face_vec_str);
	}
	_tmp33_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->serialized;
	_tmp34_ = g_strdup (_tmp33_);
	result = _tmp34_;
	return result;
}

void
face_rectangle_get_geometry (FaceRectangle* self,
                             gdouble* x,
                             gdouble* y,
                             gdouble* half_width,
                             gdouble* half_height)
{
	gdouble _vala_x = 0.0;
	gdouble _vala_y = 0.0;
	gdouble _vala_half_width = 0.0;
	gdouble _vala_half_height = 0.0;
	Photo* photo = NULL;
	EditingToolsPhotoCanvas* _tmp0_;
	Photo* _tmp1_;
	Dimensions raw_dim = {0};
	Photo* _tmp2_;
	Dimensions _tmp3_ = {0};
	Box temp_box = {0};
	Box _tmp4_;
	Dimensions current_dim = {0};
	EditingToolsPhotoCanvas* _tmp5_;
	GdkPixbuf* _tmp6_;
	GdkPixbuf* _tmp7_;
	Dimensions _tmp8_ = {0};
	Dimensions _tmp9_;
	Box cropped = {0};
	Photo* _tmp10_;
	Box _tmp11_ = {0};
	gboolean _tmp12_;
	Box _tmp34_;
	Dimensions _tmp35_;
	Box _tmp36_;
	Dimensions _tmp37_;
	gdouble width_left_end = 0.0;
	Box _tmp38_;
	Dimensions _tmp39_;
	gdouble width_right_end = 0.0;
	Box _tmp40_;
	Dimensions _tmp41_;
	gdouble height_top_end = 0.0;
	Box _tmp42_;
	Dimensions _tmp43_;
	gdouble height_bottom_end = 0.0;
	Box _tmp44_;
	Dimensions _tmp45_;
	g_return_if_fail (IS_FACE_RECTANGLE (self));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp1_ = editing_tools_photo_canvas_get_photo (_tmp0_);
	photo = _tmp1_;
	_tmp2_ = photo;
	photo_get_raw_dimensions (_tmp2_, &_tmp3_);
	raw_dim = _tmp3_;
	_tmp4_ = self->priv->box;
	temp_box = _tmp4_;
	_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp6_ = editing_tools_photo_canvas_get_scaled_pixbuf (_tmp5_);
	_tmp7_ = _tmp6_;
	dimensions_for_pixbuf (_tmp7_, &_tmp8_);
	_tmp9_ = _tmp8_;
	_g_object_unref0 (_tmp7_);
	current_dim = _tmp9_;
	_tmp10_ = photo;
	_tmp12_ = photo_get_crop (_tmp10_, &_tmp11_, PHOTO_EXCEPTION_NONE);
	cropped = _tmp11_;
	if (_tmp12_) {
		Dimensions _tmp13_;
		Dimensions _tmp14_ = {0};
		Box _tmp15_ = {0};
		Box raw_cropped = {0};
		Photo* _tmp16_;
		Box _tmp17_ = {0};
		Photo* _tmp18_;
		Dimensions _tmp19_ = {0};
		Box _tmp20_;
		Box _tmp21_ = {0};
		Box _tmp22_;
		Box _tmp23_;
		Box _tmp24_;
		Box _tmp25_;
		_tmp13_ = current_dim;
		box_get_dimensions (&cropped, &_tmp14_);
		box_get_scaled_similar (&temp_box, &_tmp13_, &_tmp14_, &_tmp15_);
		temp_box = _tmp15_;
		_tmp16_ = photo;
		photo_get_raw_crop (_tmp16_, &_tmp17_);
		raw_cropped = _tmp17_;
		_tmp18_ = photo;
		box_get_dimensions (&raw_cropped, &_tmp19_);
		_tmp20_ = temp_box;
		orientation_derotate_box (photo_get_orientation (_tmp18_), &_tmp19_, &_tmp20_, &_tmp21_);
		temp_box = _tmp21_;
		_tmp22_ = raw_cropped;
		temp_box.left = temp_box.left + _tmp22_.left;
		_tmp23_ = raw_cropped;
		temp_box.right = temp_box.right + _tmp23_.left;
		_tmp24_ = raw_cropped;
		temp_box.top = temp_box.top + _tmp24_.top;
		_tmp25_ = raw_cropped;
		temp_box.bottom = temp_box.bottom + _tmp25_.top;
	} else {
		Dimensions _tmp26_;
		Photo* _tmp27_;
		Dimensions _tmp28_ = {0};
		Box _tmp29_ = {0};
		Photo* _tmp30_;
		Dimensions _tmp31_;
		Box _tmp32_;
		Box _tmp33_ = {0};
		_tmp26_ = current_dim;
		_tmp27_ = photo;
		media_source_get_dimensions (G_TYPE_CHECK_INSTANCE_CAST (_tmp27_, TYPE_MEDIA_SOURCE, MediaSource), PHOTO_EXCEPTION_NONE, &_tmp28_);
		box_get_scaled_similar (&temp_box, &_tmp26_, &_tmp28_, &_tmp29_);
		temp_box = _tmp29_;
		_tmp30_ = photo;
		_tmp31_ = raw_dim;
		_tmp32_ = temp_box;
		orientation_derotate_box (photo_get_orientation (_tmp30_), &_tmp31_, &_tmp32_, &_tmp33_);
		temp_box = _tmp33_;
	}
	_tmp34_ = temp_box;
	_tmp35_ = raw_dim;
	_vala_x = (_tmp34_.left + (box_get_width (&temp_box) / 2)) / ((gdouble) _tmp35_.width);
	_tmp36_ = temp_box;
	_tmp37_ = raw_dim;
	_vala_y = (_tmp36_.top + (box_get_height (&temp_box) / 2)) / ((gdouble) _tmp37_.height);
	_tmp38_ = temp_box;
	_tmp39_ = raw_dim;
	width_left_end = _tmp38_.left / ((gdouble) _tmp39_.width);
	_tmp40_ = temp_box;
	_tmp41_ = raw_dim;
	width_right_end = _tmp40_.right / ((gdouble) _tmp41_.width);
	_tmp42_ = temp_box;
	_tmp43_ = raw_dim;
	height_top_end = _tmp42_.top / ((gdouble) _tmp43_.height);
	_tmp44_ = temp_box;
	_tmp45_ = raw_dim;
	height_bottom_end = _tmp44_.bottom / ((gdouble) _tmp45_.height);
	_vala_half_width = (width_right_end - width_left_end) / 2;
	_vala_half_height = (height_bottom_end - height_top_end) / 2;
	_g_object_unref0 (photo);
	if (x) {
		*x = _vala_x;
	}
	if (y) {
		*y = _vala_y;
	}
	if (half_width) {
		*half_width = _vala_half_width;
	}
	if (half_height) {
		*half_height = _vala_half_height;
	}
}

static gdouble*
_vala_array_dup40 (gdouble* self,
                   gssize length)
{
	if (length > 0) {
		return _vala_memdup2 (self, length * sizeof (gdouble));
	}
	return NULL;
}

static gdouble*
face_rectangle_real_get_face_vec (FaceShape* base,
                                  gint* result_length1)
{
	FaceRectangle * self;
	gdouble* _tmp0_;
	gint _tmp0__length1;
	gdouble* _tmp1_;
	gint _tmp1__length1;
	gdouble* _tmp2_;
	gint _tmp2__length1;
	gdouble* result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_RECTANGLE, FaceRectangle);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->face_vec;
	_tmp0__length1 = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->face_vec_length1;
	_tmp1_ = (_tmp0_ != NULL) ? _vala_array_dup40 (_tmp0_, _tmp0__length1) : _tmp0_;
	_tmp1__length1 = _tmp0__length1;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = _tmp1__length1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}

static gboolean
face_rectangle_real_equals (FaceShape* base,
                            FaceShape* face_shape)
{
	FaceRectangle * self;
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_RECTANGLE, FaceRectangle);
	g_return_val_if_fail (IS_FACE_SHAPE (face_shape), FALSE);
	_tmp0_ = face_shape_serialize (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape), TRUE);
	_tmp1_ = _tmp0_;
	_tmp2_ = face_shape_serialize (face_shape, TRUE);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strcmp0 (_tmp1_, _tmp3_) == 0;
	_g_free0 (_tmp3_);
	_g_free0 (_tmp1_);
	result = _tmp4_;
	return result;
}

static void
face_rectangle_real_prepare_ctx (FaceShape* base,
                                 cairo_t* ctx,
                                 Dimensions* dim)
{
	FaceRectangle * self;
	cairo_surface_t* _tmp0_;
	cairo_t* _tmp1_;
	cairo_t* _tmp2_;
	cairo_t* _tmp3_;
	cairo_surface_t* _tmp4_;
	cairo_t* _tmp5_;
	cairo_t* _tmp6_;
	cairo_t* _tmp7_;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_RECTANGLE, FaceRectangle);
	g_return_if_fail (ctx != NULL);
	g_return_if_fail (dim != NULL);
	_tmp0_ = cairo_get_target (ctx);
	_tmp1_ = cairo_create (_tmp0_);
	_cairo_destroy0 (self->priv->wide_black_ctx);
	self->priv->wide_black_ctx = _tmp1_;
	_tmp2_ = self->priv->wide_black_ctx;
	set_source_color_from_string (_tmp2_, "#000");
	_tmp3_ = self->priv->wide_black_ctx;
	cairo_set_line_width (_tmp3_, 1 * application_get_scale ());
	_tmp4_ = cairo_get_target (ctx);
	_tmp5_ = cairo_create (_tmp4_);
	_cairo_destroy0 (self->priv->wide_white_ctx);
	self->priv->wide_white_ctx = _tmp5_;
	_tmp6_ = self->priv->wide_white_ctx;
	set_source_color_from_string (_tmp6_, "#FFF");
	_tmp7_ = self->priv->wide_white_ctx;
	cairo_set_line_width (_tmp7_, 1 * application_get_scale ());
}

static gboolean
face_rectangle_on_canvas_manipulation (FaceRectangle* self,
                                       gint x,
                                       gint y)
{
	GdkRectangle scaled_pos = {0};
	EditingToolsPhotoCanvas* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	GdkRectangle _tmp2_;
	GdkRectangle _tmp5_;
	gint left = 0;
	Box _tmp8_;
	gint top = 0;
	Box _tmp9_;
	gint right = 0;
	Box _tmp10_;
	gint bottom = 0;
	Box _tmp11_;
	gint photo_right_edge = 0;
	EditingToolsPhotoCanvas* _tmp12_;
	GdkPixbuf* _tmp13_;
	GdkPixbuf* _tmp14_;
	gint _tmp15_;
	gint _tmp16_;
	gint _tmp17_;
	gint photo_bottom_edge = 0;
	EditingToolsPhotoCanvas* _tmp18_;
	GdkPixbuf* _tmp19_;
	GdkPixbuf* _tmp20_;
	gint _tmp21_;
	gint _tmp22_;
	gint _tmp23_;
	gint width = 0;
	gint height = 0;
	Box new_box = {0};
	Box _tmp28_;
	EditingToolsPhotoCanvas* _tmp35_;
	gboolean result;
	g_return_val_if_fail (IS_FACE_RECTANGLE (self), FALSE);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	editing_tools_photo_canvas_get_scaled_pixbuf_position (_tmp0_, &_tmp1_);
	scaled_pos = _tmp1_;
	_tmp2_ = scaled_pos;
	x = x - _tmp2_.x;
	if (x < 0) {
		x = 0;
	} else {
		GdkRectangle _tmp3_;
		_tmp3_ = scaled_pos;
		if (x >= _tmp3_.width) {
			GdkRectangle _tmp4_;
			_tmp4_ = scaled_pos;
			x = _tmp4_.width - 1;
		}
	}
	_tmp5_ = scaled_pos;
	y = y - _tmp5_.y;
	if (y < 0) {
		y = 0;
	} else {
		GdkRectangle _tmp6_;
		_tmp6_ = scaled_pos;
		if (y >= _tmp6_.height) {
			GdkRectangle _tmp7_;
			_tmp7_ = scaled_pos;
			y = _tmp7_.height - 1;
		}
	}
	_tmp8_ = self->priv->box;
	left = _tmp8_.left;
	_tmp9_ = self->priv->box;
	top = _tmp9_.top;
	_tmp10_ = self->priv->box;
	right = _tmp10_.right;
	_tmp11_ = self->priv->box;
	bottom = _tmp11_.bottom;
	_tmp12_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp13_ = editing_tools_photo_canvas_get_scaled_pixbuf (_tmp12_);
	_tmp14_ = _tmp13_;
	_tmp15_ = gdk_pixbuf_get_width (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _tmp16_ - 1;
	_g_object_unref0 (_tmp14_);
	photo_right_edge = _tmp17_;
	_tmp18_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp19_ = editing_tools_photo_canvas_get_scaled_pixbuf (_tmp18_);
	_tmp20_ = _tmp19_;
	_tmp21_ = gdk_pixbuf_get_height (_tmp20_);
	_tmp22_ = _tmp21_;
	_tmp23_ = _tmp22_ - 1;
	_g_object_unref0 (_tmp20_);
	photo_bottom_edge = _tmp23_;
	switch (self->priv->in_manipulation) {
		case BOX_LOCATION_LEFT_SIDE:
		{
			left = x;
			break;
		}
		case BOX_LOCATION_TOP_SIDE:
		{
			top = y;
			break;
		}
		case BOX_LOCATION_RIGHT_SIDE:
		{
			right = x;
			break;
		}
		case BOX_LOCATION_BOTTOM_SIDE:
		{
			bottom = y;
			break;
		}
		case BOX_LOCATION_TOP_LEFT:
		{
			top = y;
			left = x;
			break;
		}
		case BOX_LOCATION_BOTTOM_LEFT:
		{
			bottom = y;
			left = x;
			break;
		}
		case BOX_LOCATION_TOP_RIGHT:
		{
			top = y;
			right = x;
			break;
		}
		case BOX_LOCATION_BOTTOM_RIGHT:
		{
			bottom = y;
			right = x;
			break;
		}
		case BOX_LOCATION_INSIDE:
		{
			gint delta_x = 0;
			gint delta_y = 0;
			gint width = 0;
			gint height = 0;
			GdkRectangle _tmp24_;
			GdkRectangle _tmp26_;
			gint adj_width = 0;
			gint adj_height = 0;
			_vala_assert (self->priv->last_grab_x >= 0, "last_grab_x >= 0");
			_vala_assert (self->priv->last_grab_y >= 0, "last_grab_y >= 0");
			delta_x = x - self->priv->last_grab_x;
			delta_y = y - self->priv->last_grab_y;
			self->priv->last_grab_x = x;
			self->priv->last_grab_y = y;
			width = (right - left) + 1;
			height = (bottom - top) + 1;
			left += delta_x;
			top += delta_y;
			right += delta_x;
			bottom += delta_y;
			if (left < 0) {
				left = 0;
			}
			if (top < 0) {
				top = 0;
			}
			_tmp24_ = scaled_pos;
			if (right >= _tmp24_.width) {
				GdkRectangle _tmp25_;
				_tmp25_ = scaled_pos;
				right = _tmp25_.width - 1;
			}
			_tmp26_ = scaled_pos;
			if (bottom >= _tmp26_.height) {
				GdkRectangle _tmp27_;
				_tmp27_ = scaled_pos;
				bottom = _tmp27_.height - 1;
			}
			adj_width = (right - left) + 1;
			adj_height = (bottom - top) + 1;
			if (adj_width != width) {
				if (delta_x < 0) {
					right = (left + width) - 1;
				} else {
					left = (right - width) + 1;
				}
			}
			if (adj_height != height) {
				if (delta_y < 0) {
					bottom = (top + height) - 1;
				} else {
					top = (bottom - height) + 1;
				}
			}
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	width = (right - left) + 1;
	height = (bottom - top) + 1;
	if (left < 0) {
		left = 0;
	}
	if (top < 0) {
		top = 0;
	}
	if (right > photo_right_edge) {
		right = photo_right_edge;
	}
	if (bottom > photo_bottom_edge) {
		bottom = photo_bottom_edge;
	}
	width = (right - left) + 1;
	height = (bottom - top) + 1;
	switch (self->priv->in_manipulation) {
		case BOX_LOCATION_LEFT_SIDE:
		case BOX_LOCATION_TOP_LEFT:
		case BOX_LOCATION_BOTTOM_LEFT:
		{
			if (width < FACE_RECTANGLE_FACE_MIN_SIZE) {
				left = right - FACE_RECTANGLE_FACE_MIN_SIZE;
			}
			break;
		}
		case BOX_LOCATION_RIGHT_SIDE:
		case BOX_LOCATION_TOP_RIGHT:
		case BOX_LOCATION_BOTTOM_RIGHT:
		{
			if (width < FACE_RECTANGLE_FACE_MIN_SIZE) {
				right = left + FACE_RECTANGLE_FACE_MIN_SIZE;
			}
			break;
		}
		default:
		{
			break;
		}
	}
	switch (self->priv->in_manipulation) {
		case BOX_LOCATION_TOP_SIDE:
		case BOX_LOCATION_TOP_LEFT:
		case BOX_LOCATION_TOP_RIGHT:
		{
			if (height < FACE_RECTANGLE_FACE_MIN_SIZE) {
				top = bottom - FACE_RECTANGLE_FACE_MIN_SIZE;
			}
			break;
		}
		case BOX_LOCATION_BOTTOM_SIDE:
		case BOX_LOCATION_BOTTOM_LEFT:
		case BOX_LOCATION_BOTTOM_RIGHT:
		{
			if (height < FACE_RECTANGLE_FACE_MIN_SIZE) {
				bottom = top + FACE_RECTANGLE_FACE_MIN_SIZE;
			}
			break;
		}
		default:
		{
			break;
		}
	}
	box_init (&new_box, left, top, right, bottom);
	_tmp28_ = new_box;
	if (!box_equals (&self->priv->box, &_tmp28_)) {
		EditingToolsPhotoCanvas* _tmp29_;
		Box _tmp30_;
		Box _tmp32_;
		EditingToolsPhotoCanvas* _tmp33_;
		Box _tmp34_;
		_tmp29_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
		_tmp30_ = self->priv->box;
		editing_tools_photo_canvas_invalidate_area (_tmp29_, &_tmp30_);
		if (self->priv->in_manipulation != BOX_LOCATION_INSIDE) {
			Box _tmp31_;
			_tmp31_ = new_box;
			face_rectangle_check_resized_box (self, &_tmp31_);
		}
		_tmp32_ = new_box;
		self->priv->box = _tmp32_;
		face_shape_paint (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape));
		_tmp33_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
		_tmp34_ = new_box;
		editing_tools_photo_canvas_invalidate_area (_tmp33_, &_tmp34_);
	}
	if (face_shape_is_editable (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape))) {
		face_shape_update_face_window_position (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape));
	}
	_tmp35_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	editing_tools_photo_canvas_repaint (_tmp35_);
	_g_free0 (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->serialized);
	G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->serialized = NULL;
	result = FALSE;
	return result;
}

static void
face_rectangle_check_resized_box (FaceRectangle* self,
                                  Box* new_box)
{
	Box horizontal = {0};
	gboolean horizontal_enlarged = FALSE;
	Box vertical = {0};
	gboolean vertical_enlarged = FALSE;
	BoxComplements complements = 0;
	Box _tmp0_;
	Box _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	Box _tmp3_ = {0};
	gboolean _tmp4_ = FALSE;
	BoxComplements _tmp5_;
	g_return_if_fail (IS_FACE_RECTANGLE (self));
	g_return_if_fail (new_box != NULL);
	_tmp0_ = *new_box;
	_tmp5_ = box_resized_complements (&self->priv->box, &_tmp0_, &_tmp1_, &_tmp2_, &_tmp3_, &_tmp4_);
	horizontal = _tmp1_;
	horizontal_enlarged = _tmp2_;
	vertical = _tmp3_;
	vertical_enlarged = _tmp4_;
	complements = _tmp5_;
	_vala_assert (complements != BOX_COMPLEMENTS_NONE, "complements != BoxComplements.NONE");
}

static void
face_rectangle_update_cursor (FaceRectangle* self,
                              gint x,
                              gint y)
{
	GdkRectangle scaled_pos = {0};
	EditingToolsPhotoCanvas* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	Box offset_scaled_box = {0};
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	Box _tmp4_ = {0};
	GdkCursorType cursor_type = 0;
	g_return_if_fail (IS_FACE_RECTANGLE (self));
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	editing_tools_photo_canvas_get_scaled_pixbuf_position (_tmp0_, &_tmp1_);
	scaled_pos = _tmp1_;
	_tmp2_ = scaled_pos;
	_tmp3_ = scaled_pos;
	box_get_offset (&self->priv->box, _tmp2_.x, _tmp3_.y, &_tmp4_);
	offset_scaled_box = _tmp4_;
	cursor_type = GDK_LEFT_PTR;
	switch (box_approx_location (&offset_scaled_box, x, y)) {
		case BOX_LOCATION_LEFT_SIDE:
		{
			cursor_type = GDK_LEFT_SIDE;
			break;
		}
		case BOX_LOCATION_TOP_SIDE:
		{
			cursor_type = GDK_TOP_SIDE;
			break;
		}
		case BOX_LOCATION_RIGHT_SIDE:
		{
			cursor_type = GDK_RIGHT_SIDE;
			break;
		}
		case BOX_LOCATION_BOTTOM_SIDE:
		{
			cursor_type = GDK_BOTTOM_SIDE;
			break;
		}
		case BOX_LOCATION_TOP_LEFT:
		{
			cursor_type = GDK_TOP_LEFT_CORNER;
			break;
		}
		case BOX_LOCATION_BOTTOM_LEFT:
		{
			cursor_type = GDK_BOTTOM_LEFT_CORNER;
			break;
		}
		case BOX_LOCATION_TOP_RIGHT:
		{
			cursor_type = GDK_TOP_RIGHT_CORNER;
			break;
		}
		case BOX_LOCATION_BOTTOM_RIGHT:
		{
			cursor_type = GDK_BOTTOM_RIGHT_CORNER;
			break;
		}
		case BOX_LOCATION_INSIDE:
		{
			cursor_type = GDK_FLEUR;
			break;
		}
		default:
		{
			break;
		}
	}
	if (cursor_type != G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->current_cursor_type) {
		EditingToolsPhotoCanvas* _tmp5_;
		_tmp5_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
		editing_tools_photo_canvas_set_cursor (_tmp5_, cursor_type);
		G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->current_cursor_type = cursor_type;
	}
}

static void
face_rectangle_real_on_motion (FaceShape* base,
                               gint x,
                               gint y,
                               GdkModifierType mask)
{
	FaceRectangle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_RECTANGLE, FaceRectangle);
	if (self->priv->in_manipulation != BOX_LOCATION_OUTSIDE) {
		face_rectangle_on_canvas_manipulation (self, x, y);
	}
	face_rectangle_update_cursor (self, x, y);
}

static gboolean
face_rectangle_real_on_left_click (FaceShape* base,
                                   gint x,
                                   gint y)
{
	FaceRectangle * self;
	GdkRectangle scaled_pixbuf_pos = {0};
	EditingToolsPhotoCanvas* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	Box offset_scaled_box = {0};
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	Box _tmp4_ = {0};
	GdkRectangle _tmp5_;
	GdkRectangle _tmp6_;
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_RECTANGLE, FaceRectangle);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	editing_tools_photo_canvas_get_scaled_pixbuf_position (_tmp0_, &_tmp1_);
	scaled_pixbuf_pos = _tmp1_;
	_tmp2_ = scaled_pixbuf_pos;
	_tmp3_ = scaled_pixbuf_pos;
	box_get_offset (&self->priv->box, _tmp2_.x, _tmp3_.y, &_tmp4_);
	offset_scaled_box = _tmp4_;
	self->priv->in_manipulation = box_approx_location (&offset_scaled_box, x, y);
	_tmp5_ = scaled_pixbuf_pos;
	x = x - _tmp5_.x;
	self->priv->last_grab_x = x;
	_tmp6_ = scaled_pixbuf_pos;
	y = y - _tmp6_.y;
	self->priv->last_grab_y = y;
	result = box_approx_location (&self->priv->box, x, y) != BOX_LOCATION_OUTSIDE;
	return result;
}

static void
face_rectangle_real_on_left_released (FaceShape* base,
                                      gint x,
                                      gint y)
{
	FaceRectangle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_RECTANGLE, FaceRectangle);
	if (box_get_width (&self->priv->box) < FACE_RECTANGLE_FACE_MIN_SIZE) {
		g_signal_emit (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape), face_shape_signals[FACE_SHAPE_DELETE_ME_REQUESTED_SIGNAL], 0);
		return;
	}
	if (face_shape_is_editable (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape))) {
		FacesToolEditingFaceToolWindow* _tmp0_;
		FacesToolEditingFaceToolWindow* _tmp1_;
		_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->face_window;
		gtk_widget_show (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, gtk_widget_get_type (), GtkWidget));
		_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->face_window;
		gtk_window_present (G_TYPE_CHECK_INSTANCE_CAST (_tmp1_, gtk_window_get_type (), GtkWindow));
	}
	if (self->priv->in_manipulation == BOX_LOCATION_OUTSIDE) {
		return;
	}
	self->priv->in_manipulation = BOX_LOCATION_OUTSIDE;
	self->priv->last_grab_x = -1;
	self->priv->last_grab_y = -1;
	face_rectangle_update_cursor (self, x, y);
}

static void
face_rectangle_real_on_resized_pixbuf (FaceShape* base,
                                       Dimensions* old_dim,
                                       GdkPixbuf* scaled)
{
	FaceRectangle * self;
	Dimensions new_dim = {0};
	Dimensions _tmp0_ = {0};
	Dimensions uncropped_dim = {0};
	EditingToolsPhotoCanvas* _tmp1_;
	Photo* _tmp2_;
	Photo* _tmp3_;
	Dimensions _tmp4_ = {0};
	Dimensions _tmp5_;
	Box new_box = {0};
	Dimensions _tmp6_;
	Dimensions _tmp7_;
	Box _tmp8_ = {0};
	Dimensions _tmp9_;
	Dimensions _tmp10_;
	Box _tmp11_ = {0};
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_RECTANGLE, FaceRectangle);
	g_return_if_fail (old_dim != NULL);
	g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (scaled, gdk_pixbuf_get_type ()));
	dimensions_for_pixbuf (scaled, &_tmp0_);
	new_dim = _tmp0_;
	_tmp1_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	_tmp2_ = editing_tools_photo_canvas_get_photo (_tmp1_);
	_tmp3_ = _tmp2_;
	photo_get_original_dimensions (_tmp3_, &_tmp4_);
	_tmp5_ = _tmp4_;
	_g_object_unref0 (_tmp3_);
	uncropped_dim = _tmp5_;
	_tmp6_ = *old_dim;
	_tmp7_ = uncropped_dim;
	box_get_scaled_similar (&self->priv->box, &_tmp6_, &_tmp7_, &_tmp8_);
	new_box = _tmp8_;
	_tmp9_ = uncropped_dim;
	_tmp10_ = new_dim;
	box_get_scaled_similar (&new_box, &_tmp9_, &_tmp10_, &_tmp11_);
	self->priv->box = _tmp11_;
	face_shape_update_face_window_position (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape));
}

static gboolean
face_rectangle_real_cursor_is_over (FaceShape* base,
                                    gint x,
                                    gint y)
{
	FaceRectangle * self;
	GdkRectangle scaled_pos = {0};
	EditingToolsPhotoCanvas* _tmp0_;
	GdkRectangle _tmp1_ = {0};
	Box offset_scaled_box = {0};
	GdkRectangle _tmp2_;
	GdkRectangle _tmp3_;
	Box _tmp4_ = {0};
	gboolean result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_RECTANGLE, FaceRectangle);
	_tmp0_ = G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape)->canvas;
	editing_tools_photo_canvas_get_scaled_pixbuf_position (_tmp0_, &_tmp1_);
	scaled_pos = _tmp1_;
	_tmp2_ = scaled_pos;
	_tmp3_ = scaled_pos;
	box_get_offset (&self->priv->box, _tmp2_.x, _tmp3_.y, &_tmp4_);
	offset_scaled_box = _tmp4_;
	result = box_approx_location (&offset_scaled_box, x, y) != BOX_LOCATION_OUTSIDE;
	return result;
}

static gdouble
face_rectangle_real_get_distance (FaceShape* base,
                                  gint x,
                                  gint y)
{
	FaceRectangle * self;
	gdouble center_x = 0.0;
	Box _tmp0_;
	gdouble center_y = 0.0;
	Box _tmp1_;
	gdouble result;
	self = G_TYPE_CHECK_INSTANCE_CAST (base, TYPE_FACE_RECTANGLE, FaceRectangle);
	_tmp0_ = self->priv->box;
	center_x = _tmp0_.left + (box_get_width (&self->priv->box) / 2.0);
	_tmp1_ = self->priv->box;
	center_y = _tmp1_.top + (box_get_height (&self->priv->box) / 2.0);
	result = sqrt (((center_x - x) * (center_x - x)) + ((center_y - y) * (center_y - y)));
	return result;
}

static void
face_rectangle_class_init (FaceRectangleClass * klass,
                           gpointer klass_data)
{
	face_rectangle_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &FaceRectangle_private_offset);
	((FaceShapeClass *) klass)->update_face_window_position = (void (*) (FaceShape*)) face_rectangle_real_update_face_window_position;
	((FaceShapeClass *) klass)->paint = (void (*) (FaceShape*)) face_rectangle_real_paint;
	((FaceShapeClass *) klass)->erase = (void (*) (FaceShape*)) face_rectangle_real_erase;
	((FaceShapeClass *) klass)->serialize = (gchar* (*) (FaceShape*, gboolean)) face_rectangle_real_serialize;
	((FaceShapeClass *) klass)->get_face_vec = (gdouble* (*) (FaceShape*, gint*)) face_rectangle_real_get_face_vec;
	((FaceShapeClass *) klass)->equals = (gboolean (*) (FaceShape*, FaceShape*)) face_rectangle_real_equals;
	((FaceShapeClass *) klass)->prepare_ctx = (void (*) (FaceShape*, cairo_t*, Dimensions*)) face_rectangle_real_prepare_ctx;
	((FaceShapeClass *) klass)->on_motion = (void (*) (FaceShape*, gint, gint, GdkModifierType)) face_rectangle_real_on_motion;
	((FaceShapeClass *) klass)->on_left_click = (gboolean (*) (FaceShape*, gint, gint)) face_rectangle_real_on_left_click;
	((FaceShapeClass *) klass)->on_left_released = (void (*) (FaceShape*, gint, gint)) face_rectangle_real_on_left_released;
	((FaceShapeClass *) klass)->on_resized_pixbuf = (void (*) (FaceShape*, Dimensions*, GdkPixbuf*)) face_rectangle_real_on_resized_pixbuf;
	((FaceShapeClass *) klass)->cursor_is_over = (gboolean (*) (FaceShape*, gint, gint)) face_rectangle_real_cursor_is_over;
	((FaceShapeClass *) klass)->get_distance = (gdouble (*) (FaceShape*, gint, gint)) face_rectangle_real_get_distance;
	G_OBJECT_CLASS (klass)->finalize = face_rectangle_finalize;
}

static void
face_rectangle_instance_init (FaceRectangle * self,
                              gpointer klass)
{
	self->priv = face_rectangle_get_instance_private (self);
	self->priv->in_manipulation = BOX_LOCATION_OUTSIDE;
	self->priv->wide_black_ctx = NULL;
	self->priv->wide_white_ctx = NULL;
	self->priv->last_grab_x = -1;
	self->priv->last_grab_y = -1;
}

static void
face_rectangle_finalize (GObject * obj)
{
	FaceRectangle * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_FACE_RECTANGLE, FaceRectangle);
	if (!face_shape_is_editable (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_FACE_SHAPE, FaceShape))) {
		face_rectangle_erase_label (self);
	}
	_box_free0 (self->priv->label_box);
	_cairo_destroy0 (self->priv->wide_black_ctx);
	_cairo_destroy0 (self->priv->wide_white_ctx);
	G_OBJECT_CLASS (face_rectangle_parent_class)->finalize (obj);
}

static GType
face_rectangle_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (FaceRectangleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) face_rectangle_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (FaceRectangle), 0, (GInstanceInitFunc) face_rectangle_instance_init, NULL };
	GType face_rectangle_type_id;
	face_rectangle_type_id = g_type_register_static (TYPE_FACE_SHAPE, "FaceRectangle", &g_define_type_info, 0);
	FaceRectangle_private_offset = g_type_add_instance_private (face_rectangle_type_id, sizeof (FaceRectanglePrivate));
	return face_rectangle_type_id;
}

GType
face_rectangle_get_type (void)
{
	static volatile gsize face_rectangle_type_id__once = 0;
	if (g_once_init_enter (&face_rectangle_type_id__once)) {
		GType face_rectangle_type_id;
		face_rectangle_type_id = face_rectangle_get_type_once ();
		g_once_init_leave (&face_rectangle_type_id__once, face_rectangle_type_id);
	}
	return face_rectangle_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

static inline gpointer
_vala_memdup2 (gconstpointer mem,
               gsize byte_size)
{
	gpointer new_mem;
	if (mem && byte_size != 0) {
		new_mem = g_malloc (byte_size);
		memcpy (new_mem, mem, byte_size);
	} else {
		new_mem = NULL;
	}
	return new_mem;
}

