/* Plug.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Plug.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2016 elementary LLC.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by: Corentin Noël <corentin@elementary.io>
 */

#include "bluetooth.h"
#include <gtk/gtk.h>
#include <switchboard.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gio/gio.h>
#include <gee.h>
#include <glib-object.h>
#include <glib/gi18n-lib.h>
#include <adwaita.h>
#include <granite-7.h>
#include <gmodule.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

enum  {
	BLUETOOTH_PLUG_0_PROPERTY,
	BLUETOOTH_PLUG_NUM_PROPERTIES
};
static GParamSpec* bluetooth_plug_properties[BLUETOOTH_PLUG_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BluetoothPlugSearchData BluetoothPlugSearchData;

struct _BluetoothPlugPrivate {
	GtkBox* box;
	BluetoothMainView* main_view;
	BluetoothServicesObjectManager* manager;
};

struct _BluetoothPlugSearchData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BluetoothPlug* self;
	gchar* search;
	GeeTreeMap* result;
	GeeTreeMap* search_results;
	GCompareFunc _tmp0_;
	GEqualFunc _tmp1_;
	GeeTreeMap* _tmp2_;
};

static gint BluetoothPlug_private_offset;
static gpointer bluetooth_plug_parent_class = NULL;

static GtkWidget* bluetooth_plug_real_get_widget (SwitchboardPlug* base);
static void ___lambda37_ (BluetoothPlug* self);
static void ____lambda37__bluetooth_main_view_quit_plug (BluetoothMainView* _sender,
                                                  gpointer self);
static void bluetooth_plug_real_shown (SwitchboardPlug* base);
static void bluetooth_plug_real_hidden (SwitchboardPlug* base);
static void __lambda38_ (BluetoothPlug* self);
static void ___lambda38__gasync_ready_callback (GObject* source_object,
                                         GAsyncResult* res,
                                         gpointer self);
static void bluetooth_plug_real_search_callback (SwitchboardPlug* base,
                                          const gchar* location);
static void bluetooth_plug_real_search_data_free (gpointer _data);
static void bluetooth_plug_real_search (SwitchboardPlug* base,
                                 const gchar* search,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_);
static gboolean bluetooth_plug_real_search_co (BluetoothPlugSearchData* _data_);
static void bluetooth_plug_finalize (GObject * obj);
static GType bluetooth_plug_get_type_once (void);

static inline gpointer
bluetooth_plug_get_instance_private (BluetoothPlug* self)
{
	return G_STRUCT_MEMBER_P (self, BluetoothPlug_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

BluetoothPlug*
bluetooth_plug_construct (GType object_type)
{
	BluetoothPlug * self = NULL;
	GeeTreeMap* settings = NULL;
	GeeTreeMap* _tmp0_;
	BluetoothServicesObjectManager* _tmp1_;
	BluetoothServicesObjectManager* _tmp2_;
	BluetoothServicesObjectManager* _tmp3_;
	bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	_tmp0_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL, NULL, NULL, NULL);
	settings = _tmp0_;
	gee_abstract_map_set ((GeeAbstractMap*) settings, "network/bluetooth", NULL);
	self = (BluetoothPlug*) g_object_new (object_type, "category", SWITCHBOARD_PLUG_CATEGORY_NETWORK, "code-name", "io.elementary.settings.bluetooth", "display-name", _ ("Bluetooth"), "description", _ ("Configure Bluetooth Settings"), "icon", "bluetooth", "supported-settings", settings, NULL);
	_tmp1_ = bluetooth_services_object_manager_get_default ();
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->manager);
	self->priv->manager = _tmp2_;
	_tmp3_ = self->priv->manager;
	g_object_bind_property_with_closures ((GObject*) _tmp3_, "has-object", (GObject*) self, "can-show", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
	_g_object_unref0 (settings);
	return self;
}

BluetoothPlug*
bluetooth_plug_new (void)
{
	return bluetooth_plug_construct (BLUETOOTH_TYPE_PLUG);
}

static void
___lambda37_ (BluetoothPlug* self)
{
	switchboard_plug_hidden ((SwitchboardPlug*) self);
}

static void
____lambda37__bluetooth_main_view_quit_plug (BluetoothMainView* _sender,
                                             gpointer self)
{
	___lambda37_ ((BluetoothPlug*) self);
}

static GtkWidget*
bluetooth_plug_real_get_widget (SwitchboardPlug* base)
{
	BluetoothPlug * self;
	GtkBox* _tmp0_;
	GtkBox* _tmp10_;
	GtkWidget* _tmp11_;
	GtkWidget* result;
	self = (BluetoothPlug*) base;
	_tmp0_ = self->priv->box;
	if (_tmp0_ == NULL) {
		AdwHeaderBar* headerbar = NULL;
		AdwHeaderBar* _tmp1_ = NULL;
		AdwHeaderBar* _tmp2_;
		BluetoothMainView* _tmp3_ = NULL;
		GtkBox* _tmp4_;
		GtkBox* _tmp5_;
		AdwHeaderBar* _tmp6_;
		GtkBox* _tmp7_;
		BluetoothMainView* _tmp8_;
		BluetoothMainView* _tmp9_;
		_tmp1_ = (AdwHeaderBar*) adw_header_bar_new ();
		adw_header_bar_set_show_title (_tmp1_, FALSE);
		g_object_ref_sink (_tmp1_);
		headerbar = _tmp1_;
		_tmp2_ = headerbar;
		gtk_widget_add_css_class ((GtkWidget*) _tmp2_, GRANITE_STYLE_CLASS_FLAT);
		_tmp3_ = bluetooth_main_view_new ();
		gtk_widget_set_vexpand ((GtkWidget*) _tmp3_, TRUE);
		g_object_ref_sink (_tmp3_);
		_g_object_unref0 (self->priv->main_view);
		self->priv->main_view = _tmp3_;
		_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 0);
		g_object_ref_sink (_tmp4_);
		_g_object_unref0 (self->priv->box);
		self->priv->box = _tmp4_;
		_tmp5_ = self->priv->box;
		_tmp6_ = headerbar;
		gtk_box_append (_tmp5_, (GtkWidget*) _tmp6_);
		_tmp7_ = self->priv->box;
		_tmp8_ = self->priv->main_view;
		gtk_box_append (_tmp7_, (GtkWidget*) _tmp8_);
		_tmp9_ = self->priv->main_view;
		g_signal_connect_object (_tmp9_, "quit-plug", (GCallback) ____lambda37__bluetooth_main_view_quit_plug, self, 0);
		_g_object_unref0 (headerbar);
	}
	_tmp10_ = self->priv->box;
	_tmp11_ = _g_object_ref0 ((GtkWidget*) _tmp10_);
	result = _tmp11_;
	return result;
}

static void
bluetooth_plug_real_shown (SwitchboardPlug* base)
{
	BluetoothPlug * self;
	BluetoothServicesObjectManager* _tmp0_;
	BluetoothMainView* _tmp1_;
	GtkRoot* _tmp2_;
	BluetoothServicesObjectManager* _tmp3_;
	self = (BluetoothPlug*) base;
	_tmp0_ = self->priv->manager;
	_tmp1_ = self->priv->main_view;
	_tmp2_ = gtk_widget_get_root ((GtkWidget*) _tmp1_);
	bluetooth_services_object_manager_register_agent (_tmp0_, G_TYPE_CHECK_INSTANCE_TYPE (_tmp2_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp2_) : NULL, NULL, NULL);
	_tmp3_ = self->priv->manager;
	bluetooth_services_object_manager_set_global_state (_tmp3_, TRUE, NULL, NULL);
}

static void
__lambda38_ (BluetoothPlug* self)
{
	GApplication* _tmp0_;
	_tmp0_ = g_application_get_default ();
	g_application_release (_tmp0_);
}

static void
___lambda38__gasync_ready_callback (GObject* source_object,
                                    GAsyncResult* res,
                                    gpointer self)
{
	__lambda38_ ((BluetoothPlug*) self);
	g_object_unref (self);
}

static void
bluetooth_plug_real_hidden (SwitchboardPlug* base)
{
	BluetoothPlug * self;
	GApplication* _tmp0_;
	BluetoothServicesObjectManager* _tmp1_;
	BluetoothServicesObjectManager* _tmp2_;
	BluetoothServicesObjectManager* _tmp3_;
	self = (BluetoothPlug*) base;
	_tmp0_ = g_application_get_default ();
	g_application_hold (_tmp0_);
	_tmp1_ = self->priv->manager;
	bluetooth_services_object_manager_unregister_agent (_tmp1_, NULL, NULL);
	_tmp2_ = self->priv->manager;
	bluetooth_services_object_manager_set_discoverable (_tmp2_, FALSE);
	_tmp3_ = self->priv->manager;
	bluetooth_services_object_manager_stop_discovery (_tmp3_, ___lambda38__gasync_ready_callback, g_object_ref (self));
}

static void
bluetooth_plug_real_search_callback (SwitchboardPlug* base,
                                     const gchar* location)
{
	BluetoothPlug * self;
	self = (BluetoothPlug*) base;
	g_return_if_fail (location != NULL);
}

static void
bluetooth_plug_real_search_data_free (gpointer _data)
{
	BluetoothPlugSearchData* _data_;
	_data_ = _data;
	_g_free0 (_data_->search);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothPlugSearchData, _data_);
}

static void
bluetooth_plug_real_search (SwitchboardPlug* base,
                            const gchar* search,
                            GAsyncReadyCallback _callback_,
                            gpointer _user_data_)
{
	BluetoothPlug * self;
	BluetoothPlugSearchData* _data_;
	BluetoothPlug* _tmp0_;
	gchar* _tmp1_;
	g_return_if_fail (search != NULL);
	self = (BluetoothPlug*) base;
	_data_ = g_slice_new0 (BluetoothPlugSearchData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	g_task_set_task_data (_data_->_async_result, _data_, bluetooth_plug_real_search_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = g_strdup (search);
	_g_free0 (_data_->search);
	_data_->search = _tmp1_;
	bluetooth_plug_real_search_co (_data_);
}

static GeeTreeMap*
bluetooth_plug_search_finish (SwitchboardPlug* base,
                              GAsyncResult* _res_)
{
	GeeTreeMap* result;
	BluetoothPlugSearchData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}

static gboolean
bluetooth_plug_real_search_co (BluetoothPlugSearchData* _data_)
{
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = ((GCompareFunc) g_strcmp0);
	_data_->_tmp1_ = g_str_equal;
	_data_->_tmp2_ = gee_tree_map_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, (GCompareDataFunc) _data_->_tmp0_, NULL, NULL, (GeeEqualDataFunc) _data_->_tmp1_, NULL, NULL);
	_data_->search_results = _data_->_tmp2_;
	_data_->result = _data_->search_results;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (!g_task_get_completed (_data_->_async_result)) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}

static void
bluetooth_plug_class_init (BluetoothPlugClass * klass,
                           gpointer klass_data)
{
	bluetooth_plug_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &BluetoothPlug_private_offset);
	((SwitchboardPlugClass *) klass)->get_widget = (GtkWidget* (*) (SwitchboardPlug*)) bluetooth_plug_real_get_widget;
	((SwitchboardPlugClass *) klass)->shown = (void (*) (SwitchboardPlug*)) bluetooth_plug_real_shown;
	((SwitchboardPlugClass *) klass)->hidden = (void (*) (SwitchboardPlug*)) bluetooth_plug_real_hidden;
	((SwitchboardPlugClass *) klass)->search_callback = (void (*) (SwitchboardPlug*, const gchar*)) bluetooth_plug_real_search_callback;
	((SwitchboardPlugClass *) klass)->search = (void (*) (SwitchboardPlug*, const gchar*, GAsyncReadyCallback, gpointer)) bluetooth_plug_real_search;
	((SwitchboardPlugClass *) klass)->search_finish = (GeeTreeMap* (*) (SwitchboardPlug*, GAsyncResult*)) bluetooth_plug_search_finish;
	G_OBJECT_CLASS (klass)->finalize = bluetooth_plug_finalize;
}

static void
bluetooth_plug_instance_init (BluetoothPlug * self,
                              gpointer klass)
{
	self->priv = bluetooth_plug_get_instance_private (self);
}

static void
bluetooth_plug_finalize (GObject * obj)
{
	BluetoothPlug * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BLUETOOTH_TYPE_PLUG, BluetoothPlug);
	_g_object_unref0 (self->priv->box);
	_g_object_unref0 (self->priv->main_view);
	_g_object_unref0 (self->priv->manager);
	G_OBJECT_CLASS (bluetooth_plug_parent_class)->finalize (obj);
}

static GType
bluetooth_plug_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothPlugClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_plug_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothPlug), 0, (GInstanceInitFunc) bluetooth_plug_instance_init, NULL };
	GType bluetooth_plug_type_id;
	bluetooth_plug_type_id = g_type_register_static (SWITCHBOARD_TYPE_PLUG, "BluetoothPlug", &g_define_type_info, 0);
	BluetoothPlug_private_offset = g_type_add_instance_private (bluetooth_plug_type_id, sizeof (BluetoothPlugPrivate));
	return bluetooth_plug_type_id;
}

GType
bluetooth_plug_get_type (void)
{
	static volatile gsize bluetooth_plug_type_id__once = 0;
	if (g_once_init_enter (&bluetooth_plug_type_id__once)) {
		GType bluetooth_plug_type_id;
		bluetooth_plug_type_id = bluetooth_plug_get_type_once ();
		g_once_init_leave (&bluetooth_plug_type_id__once, bluetooth_plug_type_id);
	}
	return bluetooth_plug_type_id__once;
}

SwitchboardPlug*
get_plug (GModule* module)
{
	BluetoothPlug* plug = NULL;
	BluetoothPlug* _tmp0_;
	SwitchboardPlug* result;
	g_return_val_if_fail (module != NULL, NULL);
	g_debug ("Plug.vala:91: Activating Bluetooth plug");
	_tmp0_ = bluetooth_plug_new ();
	plug = _tmp0_;
	result = (SwitchboardPlug*) plug;
	return result;
}

