/* Client.c generated by valac 0.56.17, the Vala compiler
 * generated from Client.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2015 Adam Bieńkowski (https://launchpad.net/switchboard-plug-parental-controls)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Library General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Library General Public License for more details.
 *
 * You should have received a copy of the GNU Library General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Adam Bieńkowski <donadigos159@gmail.com>
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <polkit/polkit.h>
#include <gio/gio.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>
#include <locale.h>
#include <glib/gi18n-lib.h>
#include <granite-7.h>
#include <unistd.h>

#define PC_CONSTANTS_GETTEXT_PACKAGE "io.elementary.settings.screentime-limits"
#define PC_CONSTANTS_LOCALEDIR "/usr/share/locale"
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define PC_CLIENT_TYPE_CLIENT (pc_client_client_get_type ())
#define PC_CLIENT_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_CLIENT_TYPE_CLIENT, PCClientClient))
#define PC_CLIENT_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_CLIENT_TYPE_CLIENT, PCClientClientClass))
#define PC_CLIENT_IS_CLIENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_CLIENT_TYPE_CLIENT))
#define PC_CLIENT_IS_CLIENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_CLIENT_TYPE_CLIENT))
#define PC_CLIENT_CLIENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_CLIENT_TYPE_CLIENT, PCClientClientClass))

typedef struct _PCClientClient PCClientClient;
typedef struct _PCClientClientClass PCClientClientClass;
typedef struct _PCClientClientPrivate PCClientClientPrivate;
enum  {
	PC_CLIENT_CLIENT_0_PROPERTY,
	PC_CLIENT_CLIENT_NUM_PROPERTIES
};
static GParamSpec* pc_client_client_properties[PC_CLIENT_CLIENT_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_option_context_free0(var) ((var == NULL) ? NULL : (var = (g_option_context_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define PC_TYPE_IPARENTAL_CONTROLS (pc_iparental_controls_get_type ())
#define PC_IPARENTAL_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_TYPE_IPARENTAL_CONTROLS, PCIParentalControls))
#define PC_IS_IPARENTAL_CONTROLS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_TYPE_IPARENTAL_CONTROLS))
#define PC_IPARENTAL_CONTROLS_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), PC_TYPE_IPARENTAL_CONTROLS, PCIParentalControlsIface))

typedef struct _PCIParentalControls PCIParentalControls;
typedef struct _PCIParentalControlsIface PCIParentalControlsIface;

#define PC_TYPE_IPARENTAL_CONTROLS_PROXY (pc_iparental_controls_proxy_get_type ())

#define PC_CLIENT_TYPE_APP_UNAVAILABLE_DIALOG (pc_client_app_unavailable_dialog_get_type ())
#define PC_CLIENT_APP_UNAVAILABLE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), PC_CLIENT_TYPE_APP_UNAVAILABLE_DIALOG, PCClientAppUnavailableDialog))
#define PC_CLIENT_APP_UNAVAILABLE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), PC_CLIENT_TYPE_APP_UNAVAILABLE_DIALOG, PCClientAppUnavailableDialogClass))
#define PC_CLIENT_IS_APP_UNAVAILABLE_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PC_CLIENT_TYPE_APP_UNAVAILABLE_DIALOG))
#define PC_CLIENT_IS_APP_UNAVAILABLE_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), PC_CLIENT_TYPE_APP_UNAVAILABLE_DIALOG))
#define PC_CLIENT_APP_UNAVAILABLE_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), PC_CLIENT_TYPE_APP_UNAVAILABLE_DIALOG, PCClientAppUnavailableDialogClass))

typedef struct _PCClientAppUnavailableDialog PCClientAppUnavailableDialog;
typedef struct _PCClientAppUnavailableDialogClass PCClientAppUnavailableDialogClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;

struct _PCClientClient {
	GtkApplication parent_instance;
	PCClientClientPrivate * priv;
};

struct _PCClientClientClass {
	GtkApplicationClass parent_class;
};

struct _PCClientClientPrivate {
	PolkitPermission* permission;
};

struct _PCIParentalControlsIface {
	GTypeInterface parent_iface;
	void (*add_restriction_for_user) (PCIParentalControls* self, const gchar* input, gboolean clean, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*add_restriction_for_user_finish) (PCIParentalControls* self, GAsyncResult* _res_, GError** error);
	void (*remove_restriction_for_user) (PCIParentalControls* self, const gchar* username, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*remove_restriction_for_user_finish) (PCIParentalControls* self, GAsyncResult* _res_, GError** error);
	void (*finish_app_authorization) (PCIParentalControls* self, const gchar* username, gchar** args, gint args_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*finish_app_authorization_finish) (PCIParentalControls* self, GAsyncResult* _res_, GError** error);
	void (*get_user_daemon_active) (PCIParentalControls* self, const gchar* username, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*get_user_daemon_active_finish) (PCIParentalControls* self, GAsyncResult* _res_, GError** error);
	void (*get_user_daemon_admin) (PCIParentalControls* self, const gchar* username, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gboolean (*get_user_daemon_admin_finish) (PCIParentalControls* self, GAsyncResult* _res_, GError** error);
	void (*get_user_daemon_block_urls) (PCIParentalControls* self, const gchar* username, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*get_user_daemon_block_urls_finish) (PCIParentalControls* self, GAsyncResult* _res_, gint* result_length1, GError** error);
	void (*get_user_daemon_targets) (PCIParentalControls* self, const gchar* username, GAsyncReadyCallback _callback_, gpointer _user_data_);
	gchar** (*get_user_daemon_targets_finish) (PCIParentalControls* self, GAsyncResult* _res_, gint* result_length1, GError** error);
	void (*lock_dock_icons_for_user) (PCIParentalControls* self, const gchar* username, gboolean lock, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*lock_dock_icons_for_user_finish) (PCIParentalControls* self, GAsyncResult* _res_, GError** error);
	void (*set_user_daemon_active) (PCIParentalControls* self, const gchar* username, gboolean active, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_user_daemon_active_finish) (PCIParentalControls* self, GAsyncResult* _res_, GError** error);
	void (*set_user_daemon_admin) (PCIParentalControls* self, const gchar* username, gboolean admin, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_user_daemon_admin_finish) (PCIParentalControls* self, GAsyncResult* _res_, GError** error);
	void (*set_user_daemon_block_urls) (PCIParentalControls* self, const gchar* username, gchar** block_urls, gint block_urls_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_user_daemon_block_urls_finish) (PCIParentalControls* self, GAsyncResult* _res_, GError** error);
	void (*set_user_daemon_targets) (PCIParentalControls* self, const gchar* username, gchar** targets, gint targets_length1, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*set_user_daemon_targets_finish) (PCIParentalControls* self, GAsyncResult* _res_, GError** error);
};

struct _Block1Data {
	int _ref_count_;
	PCClientClient* self;
	gchar** argv;
	gint argv_length1;
	gint _argv_size_;
	gulong signal_id;
	gchar* username;
};

struct _Block2Data {
	int _ref_count_;
	Block1Data * _data1_;
	PCIParentalControls* api;
};

static gint PCClientClient_private_offset;
static gpointer pc_client_client_parent_class = NULL;
static gchar* pc_client_client_auth;
static gchar* pc_client_client_app_name;
static gchar* pc_client_client_app_name = NULL;
static gchar* pc_client_client_auth = NULL;

VALA_EXTERN GType pc_client_client_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCClientClient, g_object_unref)
static gint pc_client_client_main (gchar** args,
                            gint args_length1);
VALA_EXTERN PCClientClient* pc_client_client_new (void);
VALA_EXTERN PCClientClient* pc_client_client_construct (GType object_type);
static void pc_client_client_real_activate (GApplication* base);
VALA_EXTERN GType pc_iparental_controls_proxy_get_type (void) G_GNUC_CONST ;
VALA_EXTERN guint pc_iparental_controls_register_object (void* object,
                                             GDBusConnection* connection,
                                             const gchar* path,
                                             GError** error);
VALA_EXTERN GType pc_iparental_controls_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCIParentalControls, g_object_unref)
VALA_EXTERN PCIParentalControls* pc_utils_get_api (void);
VALA_EXTERN GType pc_client_app_unavailable_dialog_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (PCClientAppUnavailableDialog, g_object_unref)
VALA_EXTERN PCClientAppUnavailableDialog* pc_client_app_unavailable_dialog_new (void);
VALA_EXTERN PCClientAppUnavailableDialog* pc_client_app_unavailable_dialog_construct (GType object_type);
static void pc_client_client_on_authorize (PCClientClient* self,
                                    const gchar* username,
                                    const gchar* action_id,
                                    gchar** _args,
                                    gint _args_length1);
static void pc_client_client_on_launch (PCClientClient* self,
                                 gchar** args,
                                 gint args_length1,
                                 gboolean incoming);
static void _pc_client_client_on_launch_pc_iparental_controls_launch (PCIParentalControls* _sender,
                                                               gchar** args,
                                                               gint args_length1,
                                                               gboolean incoming,
                                                               gpointer self);
static void pc_client_client_on_show_timeout (PCClientClient* self,
                                       gint hours,
                                       gint minutes);
static void _pc_client_client_on_show_timeout_pc_iparental_controls_show_timeout (PCIParentalControls* _sender,
                                                                           gint hours,
                                                                           gint minutes,
                                                                           gpointer self);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void __lambda5_ (Block1Data* _data1_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
VALA_EXTERN void pc_iparental_controls_finish_app_authorization (PCIParentalControls* self,
                                                     const gchar* username,
                                                     gchar** args,
                                                     gint args_length1,
                                                     GAsyncReadyCallback _callback_,
                                                     gpointer _user_data_);
VALA_EXTERN void pc_iparental_controls_finish_app_authorization_finish (PCIParentalControls* self,
                                                            GAsyncResult* _res_,
                                                            GError** error);
static void __lambda6_ (Block2Data* _data2_,
                 GObject* obj,
                 GAsyncResult* res);
static void ___lambda6__gasync_ready_callback (GObject* source_object,
                                        GAsyncResult* res,
                                        gpointer self);
static void ___lambda5__g_object_notify (GObject* _sender,
                                  GParamSpec* pspec,
                                  gpointer self);
static void pc_client_client_finalize (GObject * obj);
static GType pc_client_client_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

static const GOptionEntry PC_CLIENT_CLIENT_OPTIONS[3] = {{"authorize", 'a', (gint) 0, G_OPTION_ARG_STRING, &pc_client_client_auth, "Authorizes an application (format: username:action_id:arguments)", NULL}, {"dialog", 'd', (gint) 0, G_OPTION_ARG_STRING, &pc_client_client_app_name, "Show an unavailable dialog for the specified application name", NULL}, {NULL}};

static inline gpointer
pc_client_client_get_instance_private (PCClientClient* self)
{
	return G_STRUCT_MEMBER_P (self, PCClientClient_private_offset);
}

static gint
pc_client_client_main (gchar** args,
                       gint args_length1)
{
	PCClientClient* client = NULL;
	PCClientClient* _tmp9_;
	PCClientClient* _tmp10_;
	GError* _inner_error0_ = NULL;
	gint result;
	setlocale (LC_ALL, "");
	bindtextdomain (PC_CONSTANTS_GETTEXT_PACKAGE, PC_CONSTANTS_LOCALEDIR);
	bind_textdomain_codeset (PC_CONSTANTS_GETTEXT_PACKAGE, "UTF-8");
	textdomain (PC_CONSTANTS_GETTEXT_PACKAGE);
	{
		GOptionContext* opt_context = NULL;
		GOptionContext* _tmp0_;
		GOptionContext* _tmp1_;
		GOptionContext* _tmp2_;
		GOptionContext* _tmp3_;
		_tmp0_ = g_option_context_new (NULL);
		opt_context = _tmp0_;
		_tmp1_ = opt_context;
		g_option_context_set_help_enabled (_tmp1_, TRUE);
		_tmp2_ = opt_context;
		g_option_context_add_main_entries (_tmp2_, PC_CLIENT_CLIENT_OPTIONS, NULL);
		_tmp3_ = opt_context;
		g_option_context_parse (_tmp3_, (gint*) (&args_length1), &args, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			gint _tmp4_ = -1;
			_g_option_context_free0 (opt_context);
			if (_inner_error0_->domain == G_OPTION_ERROR) {
				goto __catch0_g_option_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return _tmp4_;
		}
		_g_option_context_free0 (opt_context);
	}
	goto __finally0;
	__catch0_g_option_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_print ("error: %s\n", _tmp6_);
		_tmp7_ = args[0];
		g_print ("Run '%s --help' to see a full list of available command line options.\n", _tmp7_);
		result = 0;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		gint _tmp8_ = -1;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return _tmp8_;
	}
	_tmp9_ = pc_client_client_new ();
	client = _tmp9_;
	_tmp10_ = client;
	result = g_application_run ((GApplication*) _tmp10_, (gint) args_length1, args);
	_g_object_unref0 (client);
	return result;
}

int
main (int argc,
      char ** argv)
{
	return pc_client_client_main (argv, argc);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

static void
_pc_client_client_on_launch_pc_iparental_controls_launch (PCIParentalControls* _sender,
                                                          gchar** args,
                                                          gint args_length1,
                                                          gboolean incoming,
                                                          gpointer self)
{
	pc_client_client_on_launch ((PCClientClient*) self, args, args_length1, incoming);
}

static void
_pc_client_client_on_show_timeout_pc_iparental_controls_show_timeout (PCIParentalControls* _sender,
                                                                      gint hours,
                                                                      gint minutes,
                                                                      gpointer self)
{
	pc_client_client_on_show_timeout ((PCClientClient*) self, hours, minutes);
}

static void
pc_client_client_real_activate (GApplication* base)
{
	PCClientClient * self;
	PCIParentalControls* api = NULL;
	PCIParentalControls* _tmp0_;
	PCIParentalControls* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp5_;
	PCIParentalControls* _tmp21_;
	PCIParentalControls* _tmp22_;
	GError* _inner_error0_ = NULL;
	self = (PCClientClient*) base;
	_tmp0_ = pc_utils_get_api ();
	_tmp1_ = _g_object_ref0 (_tmp0_);
	api = _tmp1_;
	_tmp2_ = pc_client_client_app_name;
	if (_tmp2_ != NULL) {
		PCClientAppUnavailableDialog* app_lock_dialog = NULL;
		PCClientAppUnavailableDialog* _tmp3_;
		PCClientAppUnavailableDialog* _tmp4_;
		_tmp3_ = pc_client_app_unavailable_dialog_new ();
		g_object_ref_sink (_tmp3_);
		app_lock_dialog = _tmp3_;
		_tmp4_ = app_lock_dialog;
		gtk_window_present ((GtkWindow*) _tmp4_);
		_g_object_unref0 (app_lock_dialog);
	}
	_tmp5_ = pc_client_client_auth;
	if (_tmp5_ != NULL) {
		gchar** tokens = NULL;
		const gchar* _tmp6_;
		gchar** _tmp7_;
		gchar** _tmp8_;
		gint tokens_length1;
		gint _tokens_size_;
		gchar** _tmp9_;
		gint _tmp9__length1;
		_tmp6_ = pc_client_client_auth;
		_tmp8_ = _tmp7_ = g_strsplit (_tmp6_, ":", 3);
		tokens = _tmp8_;
		tokens_length1 = _vala_array_length (_tmp7_);
		_tokens_size_ = tokens_length1;
		_tmp9_ = tokens;
		_tmp9__length1 = tokens_length1;
		if (_tmp9__length1 == 3) {
			{
				gchar** argv = NULL;
				gint argv_length1 = 0;
				gint _argv_size_ = 0;
				gchar** _tmp10_;
				gint _tmp10__length1;
				const gchar* _tmp11_;
				gchar** _tmp12_ = NULL;
				gint _tmp13_ = 0;
				gchar** _tmp14_;
				gint _tmp14__length1;
				const gchar* _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gchar** _tmp18_;
				gint _tmp18__length1;
				_tmp10_ = tokens;
				_tmp10__length1 = tokens_length1;
				_tmp11_ = _tmp10_[2];
				g_shell_parse_argv (_tmp11_, &_tmp13_, &_tmp12_, &_inner_error0_);
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
				argv = _tmp12_;
				argv_length1 = _tmp13_;
				_argv_size_ = argv_length1;
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
					if (_inner_error0_->domain == G_SHELL_ERROR) {
						goto __catch0_g_shell_error;
					}
					tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
					_g_object_unref0 (api);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return;
				}
				_tmp14_ = tokens;
				_tmp14__length1 = tokens_length1;
				_tmp15_ = _tmp14_[0];
				_tmp16_ = tokens;
				_tmp16__length1 = tokens_length1;
				_tmp17_ = _tmp16_[1];
				_tmp18_ = argv;
				_tmp18__length1 = argv_length1;
				pc_client_client_on_authorize (self, _tmp15_, _tmp17_, _tmp18_, (gint) _tmp18__length1);
				argv = (_vala_array_free (argv, argv_length1, (GDestroyNotify) g_free), NULL);
			}
			goto __finally0;
			__catch0_g_shell_error:
			{
				gchar** _tmp19_;
				gint _tmp19__length1;
				const gchar* _tmp20_;
				g_clear_error (&_inner_error0_);
				_tmp19_ = tokens;
				_tmp19__length1 = tokens_length1;
				_tmp20_ = _tmp19_[2];
				g_print ("Failed to parse command line arguments: %s\n", _tmp20_);
			}
			__finally0:
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
				_g_object_unref0 (api);
				g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
				g_clear_error (&_inner_error0_);
				return;
			}
		} else {
			g_print ("Usage: --authorize username:action_id:arguments");
			tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
			_g_object_unref0 (api);
			return;
		}
		tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp21_ = api;
	g_signal_connect_object (_tmp21_, "launch", (GCallback) _pc_client_client_on_launch_pc_iparental_controls_launch, self, 0);
	_tmp22_ = api;
	g_signal_connect_object (_tmp22_, "show-timeout", (GCallback) _pc_client_client_on_show_timeout_pc_iparental_controls_show_timeout, self, 0);
	_g_object_unref0 (api);
}

static Block1Data*
block1_data_ref (Block1Data* _data1_)
{
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}

static void
block1_data_unref (void * _userdata_)
{
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		PCClientClient* self;
		self = _data1_->self;
		_data1_->argv = (_vala_array_free (_data1_->argv, _data1_->argv_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (_data1_->username);
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static Block2Data*
block2_data_ref (Block2Data* _data2_)
{
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}

static void
block2_data_unref (void * _userdata_)
{
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		PCClientClient* self;
		self = _data2_->_data1_->self;
		block1_data_unref (_data2_->_data1_);
		_data2_->_data1_ = NULL;
		g_slice_free (Block2Data, _data2_);
	}
}

static void
__lambda6_ (Block2Data* _data2_,
            GObject* obj,
            GAsyncResult* res)
{
	Block1Data* _data1_;
	PCClientClient* self;
	GError* _inner_error0_ = NULL;
	_data1_ = _data2_->_data1_;
	self = _data1_->self;
	g_return_if_fail (res != NULL);
	{
		pc_iparental_controls_finish_app_authorization_finish (_data2_->api, res, &_inner_error0_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_warning ("Client.vala:132: %s", _tmp1_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static void
___lambda6__gasync_ready_callback (GObject* source_object,
                                   GAsyncResult* res,
                                   gpointer self)
{
	__lambda6_ (self, source_object, res);
	block2_data_unref (self);
}

static void
__lambda5_ (Block1Data* _data1_)
{
	PCClientClient* self;
	Block2Data* _data2_;
	PolkitPermission* _tmp0_;
	PCIParentalControls* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = _data1_->self;
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->_data1_ = block1_data_ref (_data1_);
	_tmp0_ = self->priv->permission;
	g_signal_handler_disconnect ((GObject*) _tmp0_, _data1_->signal_id);
	_tmp1_ = pc_utils_get_api ();
	_data2_->api = _tmp1_;
	_tmp2_ = _data1_->argv;
	_tmp2__length1 = _data1_->argv_length1;
	pc_iparental_controls_finish_app_authorization (_data2_->api, _data1_->username, _tmp2_, (gint) _tmp2__length1, ___lambda6__gasync_ready_callback, block2_data_ref (_data2_));
	block2_data_unref (_data2_);
	_data2_ = NULL;
}

static void
___lambda5__g_object_notify (GObject* _sender,
                             GParamSpec* pspec,
                             gpointer self)
{
	__lambda5_ (self);
}

static void
pc_client_client_on_authorize (PCClientClient* self,
                               const gchar* username,
                               const gchar* action_id,
                               gchar** _args,
                               gint _args_length1)
{
	Block1Data* _data1_;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gboolean _tmp4_ = FALSE;
	PolkitPermission* _tmp5_;
	PolkitPermission* _tmp19_;
	gulong _tmp20_;
	PolkitPermission* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (username != NULL);
	g_return_if_fail (action_id != NULL);
	_data1_ = g_slice_new0 (Block1Data);
	_data1_->_ref_count_ = 1;
	_data1_->self = g_object_ref (self);
	_tmp0_ = g_strdup (username);
	_g_free0 (_data1_->username);
	_data1_->username = _tmp0_;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	_data1_->argv = _tmp1_;
	_data1_->argv_length1 = 0;
	_data1_->_argv_size_ = _data1_->argv_length1;
	{
		gchar** arg_collection = NULL;
		gint arg_collection_length1 = 0;
		gint _arg_collection_size_ = 0;
		gint arg_it = 0;
		arg_collection = _args;
		arg_collection_length1 = _args_length1;
		for (arg_it = 0; arg_it < arg_collection_length1; arg_it = arg_it + 1) {
			const gchar* arg = NULL;
			arg = arg_collection[arg_it];
			{
				const gchar* _tmp2_;
				gchar* _tmp3_;
				_tmp2_ = arg;
				_tmp3_ = g_strdup (_tmp2_);
				_vala_array_add1 (&_data1_->argv, &_data1_->argv_length1, &_data1_->_argv_size_, _tmp3_);
			}
		}
	}
	_tmp5_ = self->priv->permission;
	if (_tmp5_ != NULL) {
		PolkitPermission* _tmp6_;
		_tmp6_ = self->priv->permission;
		_tmp4_ = g_permission_get_can_release ((GPermission*) _tmp6_);
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		{
			PolkitPermission* _tmp7_;
			_tmp7_ = self->priv->permission;
			g_permission_release ((GPermission*) _tmp7_, NULL, &_inner_error0_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
		goto __finally0;
		__catch0_g_error:
		{
			GError* e = NULL;
			GError* _tmp8_;
			const gchar* _tmp9_;
			e = _inner_error0_;
			_inner_error0_ = NULL;
			_tmp8_ = e;
			_tmp9_ = _tmp8_->message;
			g_critical ("Client.vala:112: %s", _tmp9_);
			_g_error_free0 (e);
		}
		__finally0:
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			block1_data_unref (_data1_);
			_data1_ = NULL;
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return;
		}
	}
	{
		PolkitUnixUser* user = NULL;
		PolkitUnixUser* _tmp10_;
		PolkitUnixProcess* unixprocess = NULL;
		PolkitUnixUser* _tmp11_;
		PolkitUnixProcess* _tmp12_;
		PolkitPermission* _tmp13_ = NULL;
		PolkitUnixProcess* _tmp14_;
		PolkitPermission* _tmp15_;
		PolkitPermission* _tmp16_;
		_tmp10_ = (PolkitUnixUser*) polkit_unix_user_new_for_name (_data1_->username, &_inner_error0_);
		user = _tmp10_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch1_g_error;
		}
		_tmp11_ = user;
		_tmp12_ = (PolkitUnixProcess*) polkit_unix_process_new_for_owner ((gint) getpid (), (guint64) 0, polkit_unix_user_get_uid (_tmp11_));
		unixprocess = _tmp12_;
		_tmp14_ = unixprocess;
		_tmp15_ = (PolkitPermission*) polkit_permission_new_sync (action_id, (PolkitSubject*) _tmp14_, NULL, &_inner_error0_);
		_tmp13_ = _tmp15_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_object_unref0 (unixprocess);
			_g_object_unref0 (user);
			goto __catch1_g_error;
		}
		_tmp16_ = _tmp13_;
		_tmp13_ = NULL;
		_g_object_unref0 (self->priv->permission);
		self->priv->permission = _tmp16_;
		_g_object_unref0 (_tmp13_);
		_g_object_unref0 (unixprocess);
		_g_object_unref0 (user);
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp17_;
		const gchar* _tmp18_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp17_ = e;
		_tmp18_ = _tmp17_->message;
		g_critical ("Client.vala:121: %s", _tmp18_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		block1_data_unref (_data1_);
		_data1_ = NULL;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_data1_->signal_id = (gulong) 0;
	_tmp19_ = self->priv->permission;
	_tmp20_ = g_signal_connect_data ((GObject*) _tmp19_, "notify::allowed", (GCallback) ___lambda5__g_object_notify, block1_data_ref (_data1_), (GClosureNotify) block1_data_unref, 0);
	_data1_->signal_id = _tmp20_;
	_tmp21_ = self->priv->permission;
	g_permission_acquire_async ((GPermission*) _tmp21_, NULL, NULL, NULL);
	block1_data_unref (_data1_);
	_data1_ = NULL;
}

static void
pc_client_client_on_launch (PCClientClient* self,
                            gchar** args,
                            gint args_length1,
                            gboolean incoming)
{
	PCIParentalControls* _tmp5_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	if (!incoming) {
		return;
	}
	{
		gchar** _tmp0_;
		gchar** _tmp1_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = _tmp0_ = g_get_environ ();
		_tmp2_ = _tmp1_;
		_tmp2__length1 = _vala_array_length (_tmp0_);
		g_spawn_async ("/", args, _tmp2_, G_SPAWN_SEARCH_PATH | G_SPAWN_DO_NOT_REAP_CHILD, NULL, NULL, NULL, &_inner_error0_);
		_tmp2_ = (_vala_array_free (_tmp2_, _tmp2__length1, (GDestroyNotify) g_free), NULL);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_warning ("Client.vala:153: %s\n", _tmp4_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_tmp5_ = pc_utils_get_api ();
	g_signal_emit_by_name (_tmp5_, "launch", args, (gint) args_length1, FALSE);
}

static void
pc_client_client_on_show_timeout (PCClientClient* self,
                                  gint hours,
                                  gint minutes)
{
	gchar* body = NULL;
	gchar* _tmp0_;
	GNotification* notification = NULL;
	GNotification* _tmp13_;
	GThemedIcon* icon = NULL;
	GThemedIcon* _tmp14_;
	GNotification* _tmp15_;
	GThemedIcon* _tmp16_;
	GNotification* _tmp17_;
	const gchar* _tmp18_;
	GNotification* _tmp19_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (_ ("This computer will lock after %s."));
	body = _tmp0_;
	if (hours > 0) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = body;
		_tmp2_ = g_strdup_printf (ngettext ("%lu hour", "%lu hours", (gulong) hours), (gulong) hours);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strdup_printf (_tmp1_, _tmp3_);
		_g_free0 (body);
		body = _tmp4_;
		_g_free0 (_tmp3_);
	} else {
		if (minutes > 0) {
			const gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			gchar* _tmp8_;
			_tmp5_ = body;
			_tmp6_ = g_strdup_printf (ngettext ("%lu minute", "%lu minutes", (gulong) minutes), (gulong) minutes);
			_tmp7_ = _tmp6_;
			_tmp8_ = g_strdup_printf (_tmp5_, _tmp7_);
			_g_free0 (body);
			body = _tmp8_;
			_g_free0 (_tmp7_);
			if (minutes < 10) {
				const gchar* _tmp9_;
				gchar* _tmp10_;
				gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp9_ = body;
				_tmp10_ = g_strconcat ("\n", _ ("Make sure to close all applications before your computer will be locke" \
"d."), NULL);
				_tmp11_ = _tmp10_;
				_tmp12_ = g_strconcat (_tmp9_, _tmp11_, NULL);
				_g_free0 (body);
				body = _tmp12_;
				_g_free0 (_tmp11_);
			}
		} else {
			_g_free0 (body);
			return;
		}
	}
	_tmp13_ = g_notification_new (_ ("Time left"));
	notification = _tmp13_;
	_tmp14_ = (GThemedIcon*) g_themed_icon_new ("dialog-warning");
	icon = _tmp14_;
	_tmp15_ = notification;
	_tmp16_ = icon;
	g_notification_set_icon (_tmp15_, (GIcon*) _tmp16_);
	_tmp17_ = notification;
	_tmp18_ = body;
	g_notification_set_body (_tmp17_, _tmp18_);
	_tmp19_ = notification;
	g_application_send_notification ((GApplication*) self, "time-reminder", _tmp19_);
	_g_object_unref0 (icon);
	_g_object_unref0 (notification);
	_g_free0 (body);
}

PCClientClient*
pc_client_client_construct (GType object_type)
{
	PCClientClient * self = NULL;
	self = (PCClientClient*) g_object_new (object_type, NULL);
	return self;
}

PCClientClient*
pc_client_client_new (void)
{
	return pc_client_client_construct (PC_CLIENT_TYPE_CLIENT);
}

static void
pc_client_client_class_init (PCClientClientClass * klass,
                             gpointer klass_data)
{
	pc_client_client_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &PCClientClient_private_offset);
	((GApplicationClass *) klass)->activate = (void (*) (GApplication*)) pc_client_client_real_activate;
	G_OBJECT_CLASS (klass)->finalize = pc_client_client_finalize;
}

static void
pc_client_client_instance_init (PCClientClient * self,
                                gpointer klass)
{
	self->priv = pc_client_client_get_instance_private (self);
	self->priv->permission = NULL;
}

static void
pc_client_client_finalize (GObject * obj)
{
	PCClientClient * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, PC_CLIENT_TYPE_CLIENT, PCClientClient);
	_g_object_unref0 (self->priv->permission);
	G_OBJECT_CLASS (pc_client_client_parent_class)->finalize (obj);
}

static GType
pc_client_client_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (PCClientClientClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pc_client_client_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PCClientClient), 0, (GInstanceInitFunc) pc_client_client_instance_init, NULL };
	GType pc_client_client_type_id;
	pc_client_client_type_id = g_type_register_static (gtk_application_get_type (), "PCClientClient", &g_define_type_info, 0);
	PCClientClient_private_offset = g_type_add_instance_private (pc_client_client_type_id, sizeof (PCClientClientPrivate));
	return pc_client_client_type_id;
}

GType
pc_client_client_get_type (void)
{
	static volatile gsize pc_client_client_type_id__once = 0;
	if (g_once_init_enter (&pc_client_client_type_id__once)) {
		GType pc_client_client_type_id;
		pc_client_client_type_id = pc_client_client_get_type_once ();
		g_once_init_leave (&pc_client_client_type_id__once, pc_client_client_type_id);
	}
	return pc_client_client_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

