/* UFWHelpers.c generated by valac 0.56.17, the Vala compiler
 * generated from UFWHelpers.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2014 elementary LLC. (http://launchpad.net/switchboard-plug-security-privacy)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Corentin Noël <tintou@mailoo.org>
 */

#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include "security-privacy.h"
#include <gee.h>
#include <glib-object.h>
#include <gio/gio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
enum  {
	SECURITY_PRIVACY_UFW_HELPERS_RULE_0_PROPERTY,
	SECURITY_PRIVACY_UFW_HELPERS_RULE_NUM_PROPERTIES
};
static GParamSpec* security_privacy_ufw_helpers_rule_properties[SECURITY_PRIVACY_UFW_HELPERS_RULE_NUM_PROPERTIES];
#define _g_match_info_unref0(var) ((var == NULL) ? NULL : (var = (g_match_info_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

static gpointer security_privacy_ufw_helpers_rule_parent_class = NULL;

VALA_EXTERN gchar* security_privacy_ufw_helpers_get_helper_path (void);
static void security_privacy_ufw_helpers_rule_get_address_and_port (SecurityPrivacyUFWHelpersRule* self,
                                                             const gchar* input,
                                                             SecurityPrivacyUFWHelpersRuleVersion* version,
                                                             gchar** ports,
                                                             gchar** address);
static void security_privacy_ufw_helpers_rule_finalize (GObject * obj);
static GType security_privacy_ufw_helpers_rule_get_type_once (void);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gchar*
security_privacy_ufw_helpers_get_helper_path (void)
{
	gchar* _tmp0_;
	gchar* result;
	_tmp0_ = g_strdup_printf ("%s/security-privacy-plug-helper", BUILD_PKGDATADIR);
	result = _tmp0_;
	return result;
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

gboolean
security_privacy_ufw_helpers_get_status (void)
{
	gboolean _tmp7_ = FALSE;
	GError* _inner_error0_ = NULL;
	gboolean result;
	{
		gchar* standard_output = NULL;
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_ = NULL;
		_tmp0_ = security_privacy_ufw_helpers_get_helper_path ();
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strdup_printf ("pkexec %s -4", _tmp1_);
		_tmp3_ = _tmp2_;
		g_spawn_command_line_sync (_tmp3_, &_tmp4_, NULL, NULL, &_inner_error0_);
		_g_free0 (standard_output);
		standard_output = _tmp4_;
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (standard_output);
			goto __catch0_g_error;
		}
		result = string_contains (standard_output, "inactive") == FALSE;
		_g_free0 (standard_output);
		return result;
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_warning ("UFWHelpers.vala:35: %s", _tmp6_);
		result = FALSE;
		_g_error_free0 (e);
		return result;
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return _tmp7_;
}

void
security_privacy_ufw_helpers_set_status (gboolean status)
{
	GError* _inner_error0_ = NULL;
	{
		if (status == TRUE) {
			gchar* _tmp0_;
			gchar* _tmp1_;
			gchar* _tmp2_;
			gchar* _tmp3_;
			_tmp0_ = security_privacy_ufw_helpers_get_helper_path ();
			_tmp1_ = _tmp0_;
			_tmp2_ = g_strdup_printf ("pkexec %s -2", _tmp1_);
			_tmp3_ = _tmp2_;
			g_spawn_command_line_sync (_tmp3_, NULL, NULL, NULL, &_inner_error0_);
			_g_free0 (_tmp3_);
			_g_free0 (_tmp1_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		} else {
			gchar* _tmp4_;
			gchar* _tmp5_;
			gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp4_ = security_privacy_ufw_helpers_get_helper_path ();
			_tmp5_ = _tmp4_;
			_tmp6_ = g_strdup_printf ("pkexec %s -3", _tmp5_);
			_tmp7_ = _tmp6_;
			g_spawn_command_line_sync (_tmp7_, NULL, NULL, NULL, &_inner_error0_);
			_g_free0 (_tmp7_);
			_g_free0 (_tmp5_);
			if (G_UNLIKELY (_inner_error0_ != NULL)) {
				goto __catch0_g_error;
			}
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp8_;
		const gchar* _tmp9_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp8_ = e;
		_tmp9_ = _tmp8_->message;
		g_warning ("UFWHelpers.vala:47: %s", _tmp9_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

GeeLinkedList*
security_privacy_ufw_helpers_get_rules (void)
{
	GeeLinkedList* rules = NULL;
	GeeLinkedList* _tmp0_;
	GError* _inner_error0_ = NULL;
	GeeLinkedList* result;
	_tmp0_ = gee_linked_list_new (SECURITY_PRIVACY_UFW_HELPERS_TYPE_RULE, (GBoxedCopyFunc) g_object_ref, (GDestroyNotify) g_object_unref, NULL, NULL, NULL);
	rules = _tmp0_;
	{
		gchar* standard_output = NULL;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_ = NULL;
		gchar** lines = NULL;
		gchar** _tmp6_;
		gchar** _tmp7_;
		gint lines_length1;
		gint _lines_size_;
		gchar** _tmp8_;
		gint _tmp8__length1;
		_tmp1_ = security_privacy_ufw_helpers_get_helper_path ();
		_tmp2_ = _tmp1_;
		_tmp3_ = g_strdup_printf ("pkexec %s -4", _tmp2_);
		_tmp4_ = _tmp3_;
		g_spawn_command_line_sync (_tmp4_, &_tmp5_, NULL, NULL, &_inner_error0_);
		_g_free0 (standard_output);
		standard_output = _tmp5_;
		_g_free0 (_tmp4_);
		_g_free0 (_tmp2_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_free0 (standard_output);
			goto __catch0_g_error;
		}
		_tmp7_ = _tmp6_ = g_strsplit (standard_output, "\n", 0);
		lines = _tmp7_;
		lines_length1 = _vala_array_length (_tmp6_);
		_lines_size_ = lines_length1;
		_tmp8_ = lines;
		_tmp8__length1 = lines_length1;
		{
			gchar** line_collection = NULL;
			gint line_collection_length1 = 0;
			gint _line_collection_size_ = 0;
			gint line_it = 0;
			line_collection = _tmp8_;
			line_collection_length1 = _tmp8__length1;
			for (line_it = 0; line_it < line_collection_length1; line_it = line_it + 1) {
				gchar* _tmp9_;
				gchar* line = NULL;
				_tmp9_ = g_strdup (line_collection[line_it]);
				line = _tmp9_;
				{
					gboolean _tmp10_ = FALSE;
					gboolean _tmp11_ = FALSE;
					gboolean _tmp12_ = FALSE;
					const gchar* _tmp13_;
					_tmp13_ = line;
					if (string_contains (_tmp13_, "ALLOW")) {
						_tmp12_ = TRUE;
					} else {
						const gchar* _tmp14_;
						_tmp14_ = line;
						_tmp12_ = string_contains (_tmp14_, "DENY");
					}
					if (_tmp12_) {
						_tmp11_ = TRUE;
					} else {
						const gchar* _tmp15_;
						_tmp15_ = line;
						_tmp11_ = string_contains (_tmp15_, "LIMIT");
					}
					if (_tmp11_) {
						_tmp10_ = TRUE;
					} else {
						const gchar* _tmp16_;
						_tmp16_ = line;
						_tmp10_ = string_contains (_tmp16_, "REJECT");
					}
					if (_tmp10_) {
						SecurityPrivacyUFWHelpersRule* rule = NULL;
						const gchar* _tmp17_;
						SecurityPrivacyUFWHelpersRule* _tmp18_;
						SecurityPrivacyUFWHelpersRule* _tmp19_;
						_tmp17_ = line;
						_tmp18_ = security_privacy_ufw_helpers_rule_new_from_line (_tmp17_);
						rule = _tmp18_;
						_tmp19_ = rule;
						gee_abstract_collection_add ((GeeAbstractCollection*) rules, _tmp19_);
						_g_object_unref0 (rule);
					}
					_g_free0 (line);
				}
			}
		}
		lines = (_vala_array_free (lines, lines_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (standard_output);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp20_;
		const gchar* _tmp21_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp20_ = e;
		_tmp21_ = _tmp20_->message;
		g_warning ("UFWHelpers.vala:64: %s", _tmp21_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_object_unref0 (rules);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	result = rules;
	return result;
}

void
security_privacy_ufw_helpers_remove_rule (SecurityPrivacyUFWHelpersRule* rule)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (rule != NULL);
	{
		gchar* _tmp0_;
		gchar* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		_tmp0_ = security_privacy_ufw_helpers_get_helper_path ();
		_tmp1_ = _tmp0_;
		_tmp2_ = g_strdup_printf ("pkexec %s -6 \"%d\"", _tmp1_, rule->number);
		_tmp3_ = _tmp2_;
		g_spawn_command_line_sync (_tmp3_, NULL, NULL, NULL, &_inner_error0_);
		_g_free0 (_tmp3_);
		_g_free0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp4_;
		const gchar* _tmp5_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp4_ = e;
		_tmp5_ = _tmp4_->message;
		g_warning ("UFWHelpers.vala:73: %s", _tmp5_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

void
security_privacy_ufw_helpers_add_rule (SecurityPrivacyUFWHelpersRule* rule)
{
	gchar* rule_str = NULL;
	gchar* _tmp0_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (rule != NULL);
	_tmp0_ = g_strdup ("");
	rule_str = _tmp0_;
	{
		gboolean _tmp13_ = FALSE;
		const gchar* _tmp14_;
		gboolean _tmp33_ = FALSE;
		const gchar* _tmp34_;
		gchar* _tmp53_;
		gchar* _tmp54_;
		const gchar* _tmp55_;
		gchar* _tmp56_;
		gchar* _tmp57_;
		switch (rule->action) {
			case SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_DENY:
			{
				gchar* _tmp1_;
				_tmp1_ = g_strdup ("deny");
				_g_free0 (rule_str);
				rule_str = _tmp1_;
				break;
			}
			case SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_REJECT:
			{
				gchar* _tmp2_;
				_tmp2_ = g_strdup ("reject");
				_g_free0 (rule_str);
				rule_str = _tmp2_;
				break;
			}
			case SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_LIMIT:
			{
				gchar* _tmp3_;
				_tmp3_ = g_strdup ("limit");
				_g_free0 (rule_str);
				rule_str = _tmp3_;
				break;
			}
			default:
			{
				gchar* _tmp4_;
				_tmp4_ = g_strdup ("allow");
				_g_free0 (rule_str);
				rule_str = _tmp4_;
				break;
			}
		}
		switch (rule->direction) {
			case SECURITY_PRIVACY_UFW_HELPERS_RULE_DIRECTION_OUT:
			{
				const gchar* _tmp5_;
				gchar* _tmp6_;
				_tmp5_ = rule_str;
				_tmp6_ = g_strdup_printf ("%s out", _tmp5_);
				_g_free0 (rule_str);
				rule_str = _tmp6_;
				break;
			}
			default:
			{
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = rule_str;
				_tmp8_ = g_strdup_printf ("%s in", _tmp7_);
				_g_free0 (rule_str);
				rule_str = _tmp8_;
				break;
			}
		}
		switch (rule->protocol) {
			case SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_UDP:
			{
				const gchar* _tmp9_;
				gchar* _tmp10_;
				_tmp9_ = rule_str;
				_tmp10_ = g_strdup_printf ("%s proto udp", _tmp9_);
				_g_free0 (rule_str);
				rule_str = _tmp10_;
				break;
			}
			case SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_BOTH:
			{
				break;
			}
			default:
			{
				const gchar* _tmp11_;
				gchar* _tmp12_;
				_tmp11_ = rule_str;
				_tmp12_ = g_strdup_printf ("%s proto tcp", _tmp11_);
				_g_free0 (rule_str);
				rule_str = _tmp12_;
				break;
			}
		}
		_tmp14_ = rule->to;
		if (g_strcmp0 (_tmp14_, "") != 0) {
			const gchar* _tmp15_;
			_tmp15_ = rule->to;
			_tmp13_ = !string_contains (_tmp15_, "Anywhere");
		} else {
			_tmp13_ = FALSE;
		}
		if (_tmp13_) {
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
			const gchar* _tmp19_;
			_tmp16_ = rule_str;
			_tmp17_ = rule->to;
			_tmp18_ = g_strdup_printf ("%s to %s", _tmp16_, _tmp17_);
			_g_free0 (rule_str);
			rule_str = _tmp18_;
			_tmp19_ = rule->to_ports;
			if (g_strcmp0 (_tmp19_, "") != 0) {
				const gchar* _tmp20_;
				const gchar* _tmp21_;
				gchar* _tmp22_;
				_tmp20_ = rule_str;
				_tmp21_ = rule->to_ports;
				_tmp22_ = g_strdup_printf ("%s port %s", _tmp20_, _tmp21_);
				_g_free0 (rule_str);
				rule_str = _tmp22_;
			}
		} else {
			const gchar* _tmp29_;
			if (rule->version == SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_BOTH) {
				const gchar* _tmp23_;
				gchar* _tmp24_;
				_tmp23_ = rule_str;
				_tmp24_ = g_strdup_printf ("%s to any", _tmp23_);
				_g_free0 (rule_str);
				rule_str = _tmp24_;
			} else {
				if (rule->version == SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV6) {
					const gchar* _tmp25_;
					gchar* _tmp26_;
					_tmp25_ = rule_str;
					_tmp26_ = g_strdup_printf ("%s to ::/0", _tmp25_);
					_g_free0 (rule_str);
					rule_str = _tmp26_;
				} else {
					if (rule->version == SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV4) {
						const gchar* _tmp27_;
						gchar* _tmp28_;
						_tmp27_ = rule_str;
						_tmp28_ = g_strdup_printf ("%s to 0.0.0.0/0", _tmp27_);
						_g_free0 (rule_str);
						rule_str = _tmp28_;
					}
				}
			}
			_tmp29_ = rule->to_ports;
			if (g_strcmp0 (_tmp29_, "") != 0) {
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				_tmp30_ = rule_str;
				_tmp31_ = rule->to_ports;
				_tmp32_ = g_strdup_printf ("%s port %s", _tmp30_, _tmp31_);
				_g_free0 (rule_str);
				rule_str = _tmp32_;
			}
		}
		_tmp34_ = rule->from;
		if (g_strcmp0 (_tmp34_, "") != 0) {
			const gchar* _tmp35_;
			_tmp35_ = rule->from;
			_tmp33_ = !string_contains (_tmp35_, "Anywhere");
		} else {
			_tmp33_ = FALSE;
		}
		if (_tmp33_) {
			const gchar* _tmp36_;
			const gchar* _tmp37_;
			gchar* _tmp38_;
			const gchar* _tmp39_;
			_tmp36_ = rule_str;
			_tmp37_ = rule->from;
			_tmp38_ = g_strdup_printf ("%s from %s", _tmp36_, _tmp37_);
			_g_free0 (rule_str);
			rule_str = _tmp38_;
			_tmp39_ = rule->from_ports;
			if (g_strcmp0 (_tmp39_, "") != 0) {
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				gchar* _tmp42_;
				_tmp40_ = rule_str;
				_tmp41_ = rule->from_ports;
				_tmp42_ = g_strdup_printf ("%s port %s", _tmp40_, _tmp41_);
				_g_free0 (rule_str);
				rule_str = _tmp42_;
			}
		} else {
			const gchar* _tmp49_;
			if (rule->version == SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_BOTH) {
				const gchar* _tmp43_;
				gchar* _tmp44_;
				_tmp43_ = rule_str;
				_tmp44_ = g_strdup_printf ("%s from any", _tmp43_);
				_g_free0 (rule_str);
				rule_str = _tmp44_;
			} else {
				if (rule->version == SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV6) {
					const gchar* _tmp45_;
					gchar* _tmp46_;
					_tmp45_ = rule_str;
					_tmp46_ = g_strdup_printf ("%s from ::/0", _tmp45_);
					_g_free0 (rule_str);
					rule_str = _tmp46_;
				} else {
					if (rule->version == SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV4) {
						const gchar* _tmp47_;
						gchar* _tmp48_;
						_tmp47_ = rule_str;
						_tmp48_ = g_strdup_printf ("%s from 0.0.0.0/0", _tmp47_);
						_g_free0 (rule_str);
						rule_str = _tmp48_;
					}
				}
			}
			_tmp49_ = rule->from_ports;
			if (g_strcmp0 (_tmp49_, "") != 0) {
				const gchar* _tmp50_;
				const gchar* _tmp51_;
				gchar* _tmp52_;
				_tmp50_ = rule_str;
				_tmp51_ = rule->from_ports;
				_tmp52_ = g_strdup_printf ("%s port %s", _tmp50_, _tmp51_);
				_g_free0 (rule_str);
				rule_str = _tmp52_;
			}
		}
		_tmp53_ = security_privacy_ufw_helpers_get_helper_path ();
		_tmp54_ = _tmp53_;
		_tmp55_ = rule_str;
		_tmp56_ = g_strdup_printf ("pkexec %s -5 \"%s\"", _tmp54_, _tmp55_);
		_tmp57_ = _tmp56_;
		g_spawn_command_line_sync (_tmp57_, NULL, NULL, NULL, &_inner_error0_);
		_g_free0 (_tmp57_);
		_g_free0 (_tmp54_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp58_;
		const gchar* _tmp59_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp58_ = e;
		_tmp59_ = _tmp58_->message;
		g_warning ("UFWHelpers.vala:152: %s", _tmp59_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		_g_free0 (rule_str);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	_g_free0 (rule_str);
}

static GType
security_privacy_ufw_helpers_rule_action_get_type_once (void)
{
	static const GEnumValue values[] = {{SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_ALLOW, "SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_ALLOW", "allow"}, {SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_DENY, "SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_DENY", "deny"}, {SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_REJECT, "SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_REJECT", "reject"}, {SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_LIMIT, "SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_LIMIT", "limit"}, {0, NULL, NULL}};
	GType security_privacy_ufw_helpers_rule_action_type_id;
	security_privacy_ufw_helpers_rule_action_type_id = g_enum_register_static ("SecurityPrivacyUFWHelpersRuleAction", values);
	return security_privacy_ufw_helpers_rule_action_type_id;
}

GType
security_privacy_ufw_helpers_rule_action_get_type (void)
{
	static volatile gsize security_privacy_ufw_helpers_rule_action_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_ufw_helpers_rule_action_type_id__once)) {
		GType security_privacy_ufw_helpers_rule_action_type_id;
		security_privacy_ufw_helpers_rule_action_type_id = security_privacy_ufw_helpers_rule_action_get_type_once ();
		g_once_init_leave (&security_privacy_ufw_helpers_rule_action_type_id__once, security_privacy_ufw_helpers_rule_action_type_id);
	}
	return security_privacy_ufw_helpers_rule_action_type_id__once;
}

static GType
security_privacy_ufw_helpers_rule_protocol_get_type_once (void)
{
	static const GEnumValue values[] = {{SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_UDP, "SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_UDP", "udp"}, {SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_TCP, "SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_TCP", "tcp"}, {SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_BOTH, "SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_BOTH", "both"}, {0, NULL, NULL}};
	GType security_privacy_ufw_helpers_rule_protocol_type_id;
	security_privacy_ufw_helpers_rule_protocol_type_id = g_enum_register_static ("SecurityPrivacyUFWHelpersRuleProtocol", values);
	return security_privacy_ufw_helpers_rule_protocol_type_id;
}

GType
security_privacy_ufw_helpers_rule_protocol_get_type (void)
{
	static volatile gsize security_privacy_ufw_helpers_rule_protocol_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_ufw_helpers_rule_protocol_type_id__once)) {
		GType security_privacy_ufw_helpers_rule_protocol_type_id;
		security_privacy_ufw_helpers_rule_protocol_type_id = security_privacy_ufw_helpers_rule_protocol_get_type_once ();
		g_once_init_leave (&security_privacy_ufw_helpers_rule_protocol_type_id__once, security_privacy_ufw_helpers_rule_protocol_type_id);
	}
	return security_privacy_ufw_helpers_rule_protocol_type_id__once;
}

static GType
security_privacy_ufw_helpers_rule_direction_get_type_once (void)
{
	static const GEnumValue values[] = {{SECURITY_PRIVACY_UFW_HELPERS_RULE_DIRECTION_IN, "SECURITY_PRIVACY_UFW_HELPERS_RULE_DIRECTION_IN", "in"}, {SECURITY_PRIVACY_UFW_HELPERS_RULE_DIRECTION_OUT, "SECURITY_PRIVACY_UFW_HELPERS_RULE_DIRECTION_OUT", "out"}, {0, NULL, NULL}};
	GType security_privacy_ufw_helpers_rule_direction_type_id;
	security_privacy_ufw_helpers_rule_direction_type_id = g_enum_register_static ("SecurityPrivacyUFWHelpersRuleDirection", values);
	return security_privacy_ufw_helpers_rule_direction_type_id;
}

GType
security_privacy_ufw_helpers_rule_direction_get_type (void)
{
	static volatile gsize security_privacy_ufw_helpers_rule_direction_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_ufw_helpers_rule_direction_type_id__once)) {
		GType security_privacy_ufw_helpers_rule_direction_type_id;
		security_privacy_ufw_helpers_rule_direction_type_id = security_privacy_ufw_helpers_rule_direction_get_type_once ();
		g_once_init_leave (&security_privacy_ufw_helpers_rule_direction_type_id__once, security_privacy_ufw_helpers_rule_direction_type_id);
	}
	return security_privacy_ufw_helpers_rule_direction_type_id__once;
}

static GType
security_privacy_ufw_helpers_rule_version_get_type_once (void)
{
	static const GEnumValue values[] = {{SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV4, "SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV4", "ipv4"}, {SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV6, "SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV6", "ipv6"}, {SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_BOTH, "SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_BOTH", "both"}, {0, NULL, NULL}};
	GType security_privacy_ufw_helpers_rule_version_type_id;
	security_privacy_ufw_helpers_rule_version_type_id = g_enum_register_static ("SecurityPrivacyUFWHelpersRuleVersion", values);
	return security_privacy_ufw_helpers_rule_version_type_id;
}

GType
security_privacy_ufw_helpers_rule_version_get_type (void)
{
	static volatile gsize security_privacy_ufw_helpers_rule_version_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_ufw_helpers_rule_version_type_id__once)) {
		GType security_privacy_ufw_helpers_rule_version_type_id;
		security_privacy_ufw_helpers_rule_version_type_id = security_privacy_ufw_helpers_rule_version_get_type_once ();
		g_once_init_leave (&security_privacy_ufw_helpers_rule_version_type_id__once, security_privacy_ufw_helpers_rule_version_type_id);
	}
	return security_privacy_ufw_helpers_rule_version_type_id__once;
}

SecurityPrivacyUFWHelpersRule*
security_privacy_ufw_helpers_rule_construct (GType object_type)
{
	SecurityPrivacyUFWHelpersRule * self = NULL;
	self = (SecurityPrivacyUFWHelpersRule*) g_object_new (object_type, NULL);
	return self;
}

SecurityPrivacyUFWHelpersRule*
security_privacy_ufw_helpers_rule_new (void)
{
	return security_privacy_ufw_helpers_rule_construct (SECURITY_PRIVACY_UFW_HELPERS_TYPE_RULE);
}

static void
security_privacy_ufw_helpers_rule_get_address_and_port (SecurityPrivacyUFWHelpersRule* self,
                                                        const gchar* input,
                                                        SecurityPrivacyUFWHelpersRuleVersion* version,
                                                        gchar** ports,
                                                        gchar** address)
{
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (input != NULL);
	g_return_if_fail (*ports != NULL);
	g_return_if_fail (*address != NULL);
	{
		gchar** parts = NULL;
		gchar** _tmp0_;
		gchar** _tmp1_;
		gint parts_length1;
		gint _parts_size_;
		gchar** _tmp2_;
		gint _tmp2__length1;
		_tmp1_ = _tmp0_ = g_strsplit (input, " ", 0);
		parts = _tmp1_;
		parts_length1 = _vala_array_length (_tmp0_);
		_parts_size_ = parts_length1;
		_tmp2_ = parts;
		_tmp2__length1 = parts_length1;
		if (_tmp2__length1 > 1) {
			gchar** _tmp3_;
			gint _tmp3__length1;
			const gchar* _tmp4_;
			gchar** _tmp5_;
			gchar** _tmp6_;
			gchar** _tmp7_;
			gint _tmp7__length1;
			const gchar* _tmp8_;
			gchar* _tmp9_;
			gchar** _tmp10_;
			gint _tmp10__length1;
			const gchar* _tmp11_;
			gchar* _tmp12_;
			GInetAddress* ip = NULL;
			gchar** _tmp13_;
			gint _tmp13__length1;
			const gchar* _tmp14_;
			gchar** _tmp15_;
			gchar** _tmp16_;
			gchar** _tmp17_;
			gint _tmp17__length1;
			const gchar* _tmp18_;
			GInetAddress* _tmp19_;
			GInetAddress* _tmp20_;
			GInetAddress* _tmp21_;
			_tmp3_ = parts;
			_tmp3__length1 = parts_length1;
			_tmp4_ = _tmp3_[1];
			_tmp6_ = _tmp5_ = g_strsplit (_tmp4_, "/", 0);
			_tmp7_ = _tmp6_;
			_tmp7__length1 = _vala_array_length (_tmp5_);
			_tmp8_ = _tmp7_[0];
			_tmp9_ = g_strdup (_tmp8_);
			_g_free0 (*ports);
			*ports = _tmp9_;
			_tmp7_ = (_vala_array_free (_tmp7_, _tmp7__length1, (GDestroyNotify) g_free), NULL);
			_tmp10_ = parts;
			_tmp10__length1 = parts_length1;
			_tmp11_ = _tmp10_[0];
			_tmp12_ = g_strdup (_tmp11_);
			_g_free0 (*address);
			*address = _tmp12_;
			_tmp13_ = parts;
			_tmp13__length1 = parts_length1;
			_tmp14_ = _tmp13_[0];
			_tmp16_ = _tmp15_ = g_strsplit (_tmp14_, "/", 0);
			_tmp17_ = _tmp16_;
			_tmp17__length1 = _vala_array_length (_tmp15_);
			_tmp18_ = _tmp17_[0];
			_tmp19_ = g_inet_address_new_from_string (_tmp18_);
			_tmp20_ = _tmp19_;
			_tmp17_ = (_vala_array_free (_tmp17_, _tmp17__length1, (GDestroyNotify) g_free), NULL);
			ip = _tmp20_;
			_tmp21_ = ip;
			if (_tmp21_ != NULL) {
				GInetAddress* _tmp22_;
				_tmp22_ = ip;
				if (g_inet_address_get_family (_tmp22_) == G_SOCKET_FAMILY_IPV6) {
					*version = SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV6;
				} else {
					*version = SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV4;
				}
			}
			_g_object_unref0 (ip);
		} else {
			gchar** ip_parts = NULL;
			gchar** _tmp23_;
			gint _tmp23__length1;
			const gchar* _tmp24_;
			gchar** _tmp25_;
			gchar** _tmp26_;
			gint ip_parts_length1;
			gint _ip_parts_size_;
			gchar** _tmp27_;
			gint _tmp27__length1;
			_tmp23_ = parts;
			_tmp23__length1 = parts_length1;
			_tmp24_ = _tmp23_[0];
			_tmp26_ = _tmp25_ = g_strsplit (_tmp24_, "/", 0);
			ip_parts = _tmp26_;
			ip_parts_length1 = _vala_array_length (_tmp25_);
			_ip_parts_size_ = ip_parts_length1;
			_tmp27_ = ip_parts;
			_tmp27__length1 = ip_parts_length1;
			if (_tmp27__length1 > 1) {
				gboolean _tmp28_ = FALSE;
				gchar** _tmp29_;
				gint _tmp29__length1;
				const gchar* _tmp30_;
				_tmp29_ = ip_parts;
				_tmp29__length1 = ip_parts_length1;
				_tmp30_ = _tmp29_[1];
				if (g_strcmp0 (_tmp30_, "tcp") == 0) {
					_tmp28_ = TRUE;
				} else {
					gchar** _tmp31_;
					gint _tmp31__length1;
					const gchar* _tmp32_;
					_tmp31_ = ip_parts;
					_tmp31__length1 = ip_parts_length1;
					_tmp32_ = _tmp31_[1];
					_tmp28_ = g_strcmp0 (_tmp32_, "udp") == 0;
				}
				if (_tmp28_) {
					gchar** _tmp33_;
					gint _tmp33__length1;
					const gchar* _tmp34_;
					gchar* _tmp35_;
					_tmp33_ = ip_parts;
					_tmp33__length1 = ip_parts_length1;
					_tmp34_ = _tmp33_[0];
					_tmp35_ = g_strdup (_tmp34_);
					_g_free0 (*ports);
					*ports = _tmp35_;
				} else {
					gchar** _tmp36_;
					gint _tmp36__length1;
					const gchar* _tmp37_;
					gchar* _tmp38_;
					GInetAddress* ip = NULL;
					gchar** _tmp39_;
					gint _tmp39__length1;
					const gchar* _tmp40_;
					GInetAddress* _tmp41_;
					GInetAddress* _tmp42_;
					_tmp36_ = parts;
					_tmp36__length1 = parts_length1;
					_tmp37_ = _tmp36_[0];
					_tmp38_ = g_strdup (_tmp37_);
					_g_free0 (*address);
					*address = _tmp38_;
					_tmp39_ = ip_parts;
					_tmp39__length1 = ip_parts_length1;
					_tmp40_ = _tmp39_[0];
					_tmp41_ = g_inet_address_new_from_string (_tmp40_);
					ip = _tmp41_;
					_tmp42_ = ip;
					if (_tmp42_ != NULL) {
						GInetAddress* _tmp43_;
						_tmp43_ = ip;
						if (g_inet_address_get_family (_tmp43_) == G_SOCKET_FAMILY_IPV6) {
							*version = SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV6;
						} else {
							*version = SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV4;
						}
					}
					_g_object_unref0 (ip);
				}
			} else {
				GInetAddress* ip = NULL;
				gchar** _tmp44_;
				gint _tmp44__length1;
				const gchar* _tmp45_;
				GInetAddress* _tmp46_;
				GInetAddress* _tmp47_;
				_tmp44_ = ip_parts;
				_tmp44__length1 = ip_parts_length1;
				_tmp45_ = _tmp44_[0];
				_tmp46_ = g_inet_address_new_from_string (_tmp45_);
				ip = _tmp46_;
				_tmp47_ = ip;
				if (_tmp47_ == NULL) {
					gchar** _tmp48_;
					gint _tmp48__length1;
					const gchar* _tmp49_;
					_tmp48_ = ip_parts;
					_tmp48__length1 = ip_parts_length1;
					_tmp49_ = _tmp48_[0];
					if (string_contains (_tmp49_, "Anywhere")) {
						gchar* _tmp50_;
						_tmp50_ = g_strdup ("Anywhere");
						_g_free0 (*address);
						*address = _tmp50_;
					} else {
						gchar** _tmp51_;
						gint _tmp51__length1;
						const gchar* _tmp52_;
						gchar* _tmp53_;
						_tmp51_ = ip_parts;
						_tmp51__length1 = ip_parts_length1;
						_tmp52_ = _tmp51_[0];
						_tmp53_ = g_strdup (_tmp52_);
						_g_free0 (*ports);
						*ports = _tmp53_;
					}
				} else {
					GInetAddress* _tmp54_;
					_tmp54_ = ip;
					if (g_inet_address_get_family (_tmp54_) == G_SOCKET_FAMILY_IPV6) {
						gchar** _tmp55_;
						gint _tmp55__length1;
						const gchar* _tmp56_;
						gchar* _tmp57_;
						_tmp55_ = ip_parts;
						_tmp55__length1 = ip_parts_length1;
						_tmp56_ = _tmp55_[0];
						_tmp57_ = g_strdup (_tmp56_);
						_g_free0 (*address);
						*address = _tmp57_;
						*version = SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV6;
					} else {
						GInetAddress* _tmp58_;
						_tmp58_ = ip;
						if (g_inet_address_get_family (_tmp58_) == G_SOCKET_FAMILY_IPV4) {
							gchar** _tmp59_;
							gint _tmp59__length1;
							const gchar* _tmp60_;
							gchar* _tmp61_;
							_tmp59_ = ip_parts;
							_tmp59__length1 = ip_parts_length1;
							_tmp60_ = _tmp59_[0];
							_tmp61_ = g_strdup (_tmp60_);
							_g_free0 (*address);
							*address = _tmp61_;
							*version = SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV4;
						}
					}
				}
				_g_object_unref0 (ip);
			}
			ip_parts = (_vala_array_free (ip_parts, ip_parts_length1, (GDestroyNotify) g_free), NULL);
		}
		parts = (_vala_array_free (parts, parts_length1, (GDestroyNotify) g_free), NULL);
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		gchar* _tmp62_;
		gchar* _tmp63_;
		GError* _tmp64_;
		const gchar* _tmp65_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp62_ = g_strdup_printf ("Error parsing to/from address: %s", input);
		_tmp63_ = _tmp62_;
		g_warning ("UFWHelpers.vala:243: %s", _tmp63_);
		_g_free0 (_tmp63_);
		_tmp64_ = e;
		_tmp65_ = _tmp64_->message;
		g_warning ("UFWHelpers.vala:244: %s", _tmp65_);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
}

static gchar*
string_replace (const gchar* self,
                const gchar* old,
                const gchar* replacement)
{
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError* _inner_error0_ = NULL;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		_tmp1_ = (*((gchar*) old)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		_tmp0_ = g_strcmp0 (old, replacement) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp2_;
		_tmp2_ = g_strdup (self);
		result = _tmp2_;
		return result;
	}
	{
		GRegex* regex = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		GRegex* _tmp5_;
		GRegex* _tmp6_;
		gchar* _tmp7_ = NULL;
		GRegex* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		_tmp3_ = g_regex_escape_string (old, -1);
		_tmp4_ = _tmp3_;
		_tmp5_ = g_regex_new (_tmp4_, 0, 0, &_inner_error0_);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		regex = _tmp6_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp8_ = regex;
		_tmp9_ = g_regex_replace_literal (_tmp8_, self, (gssize) -1, 0, replacement, 0, &_inner_error0_);
		_tmp7_ = _tmp9_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error0_->domain == G_REGEX_ERROR) {
				goto __catch0_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
			g_clear_error (&_inner_error0_);
			return NULL;
		}
		_tmp10_ = _tmp7_;
		_tmp7_ = NULL;
		result = _tmp10_;
		_g_free0 (_tmp7_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally0;
	__catch0_g_regex_error:
	{
		g_clear_error (&_inner_error0_);
		g_assert_not_reached ();
	}
	__finally0:
	g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
	g_clear_error (&_inner_error0_);
	return NULL;
}

SecurityPrivacyUFWHelpersRule*
security_privacy_ufw_helpers_rule_construct_from_line (GType object_type,
                                                       const gchar* line)
{
	SecurityPrivacyUFWHelpersRule * self = NULL;
	GError* _inner_error0_ = NULL;
	g_return_val_if_fail (line != NULL, NULL);
	self = (SecurityPrivacyUFWHelpersRule*) g_object_new (object_type, NULL);
	if (string_contains (line, "(v6)")) {
		self->version = SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV6;
	} else {
		self->version = SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_IPV4;
	}
	if (string_contains (line, "tcp")) {
		self->protocol = SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_TCP;
	} else {
		if (string_contains (line, "udp")) {
			self->protocol = SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_UDP;
		} else {
			self->protocol = SECURITY_PRIVACY_UFW_HELPERS_RULE_PROTOCOL_BOTH;
		}
	}
	{
		GRegex* r = NULL;
		GRegex* _tmp0_;
		GMatchInfo* info = NULL;
		GRegex* _tmp1_;
		GMatchInfo* _tmp2_ = NULL;
		GMatchInfo* _tmp3_;
		gchar* _tmp4_;
		gchar* _tmp5_;
		gchar* to_match = NULL;
		GMatchInfo* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* _tmp10_;
		gchar* from_match = NULL;
		GMatchInfo* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		const gchar* _tmp16_;
		const gchar* _tmp17_;
		gchar* type = NULL;
		GMatchInfo* _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		const gchar* _tmp24_;
		_tmp0_ = g_regex_new ("\\[\\s*(\\d+)\\]\\s{1}([A-Za-z0-9 \\(\\)/\\.:,]+?)\\s{2,}([A-Z ]+?)\\s" \
"{2,}([A-Za-z0-9 \\(\\)/\\.:,]+?)(?:\\s{2,}.*)?$", 0, 0, &_inner_error0_);
		r = _tmp0_;
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
		_tmp1_ = r;
		g_regex_match (_tmp1_, line, 0, &_tmp2_);
		_g_match_info_unref0 (info);
		info = _tmp2_;
		_tmp3_ = info;
		_tmp4_ = g_match_info_fetch (_tmp3_, 1);
		_tmp5_ = _tmp4_;
		self->number = atoi (_tmp5_);
		_g_free0 (_tmp5_);
		_tmp6_ = info;
		_tmp7_ = g_match_info_fetch (_tmp6_, 2);
		_tmp8_ = _tmp7_;
		_tmp9_ = string_replace (_tmp8_, " (v6)", "");
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		to_match = _tmp10_;
		_tmp11_ = info;
		_tmp12_ = g_match_info_fetch (_tmp11_, 4);
		_tmp13_ = _tmp12_;
		_tmp14_ = string_replace (_tmp13_, " (v6)", "");
		_tmp15_ = _tmp14_;
		_g_free0 (_tmp13_);
		from_match = _tmp15_;
		_tmp16_ = to_match;
		security_privacy_ufw_helpers_rule_get_address_and_port (self, _tmp16_, &self->version, &self->to_ports, &self->to);
		_tmp17_ = from_match;
		security_privacy_ufw_helpers_rule_get_address_and_port (self, _tmp17_, &self->version, &self->from_ports, &self->from);
		_tmp18_ = info;
		_tmp19_ = g_match_info_fetch (_tmp18_, 3);
		type = _tmp19_;
		_tmp20_ = type;
		if (string_contains (_tmp20_, "ALLOW")) {
			self->action = SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_ALLOW;
		} else {
			const gchar* _tmp21_;
			_tmp21_ = type;
			if (string_contains (_tmp21_, "DENY")) {
				self->action = SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_DENY;
			} else {
				const gchar* _tmp22_;
				_tmp22_ = type;
				if (string_contains (_tmp22_, "REJECT")) {
					self->action = SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_REJECT;
				} else {
					const gchar* _tmp23_;
					_tmp23_ = type;
					if (string_contains (_tmp23_, "LIMIT")) {
						self->action = SECURITY_PRIVACY_UFW_HELPERS_RULE_ACTION_LIMIT;
					}
				}
			}
		}
		_tmp24_ = type;
		if (string_contains (_tmp24_, "IN")) {
			self->direction = SECURITY_PRIVACY_UFW_HELPERS_RULE_DIRECTION_IN;
		} else {
			const gchar* _tmp25_;
			_tmp25_ = type;
			if (string_contains (_tmp25_, "OUT")) {
				self->direction = SECURITY_PRIVACY_UFW_HELPERS_RULE_DIRECTION_OUT;
			}
		}
		_g_free0 (type);
		_g_free0 (from_match);
		_g_free0 (to_match);
		_g_match_info_unref0 (info);
		_g_regex_unref0 (r);
	}
	goto __finally0;
	__catch0_g_error:
	{
		g_clear_error (&_inner_error0_);
		return self;
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return NULL;
	}
	return self;
}

SecurityPrivacyUFWHelpersRule*
security_privacy_ufw_helpers_rule_new_from_line (const gchar* line)
{
	return security_privacy_ufw_helpers_rule_construct_from_line (SECURITY_PRIVACY_UFW_HELPERS_TYPE_RULE, line);
}

static void
security_privacy_ufw_helpers_rule_class_init (SecurityPrivacyUFWHelpersRuleClass * klass,
                                              gpointer klass_data)
{
	security_privacy_ufw_helpers_rule_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->finalize = security_privacy_ufw_helpers_rule_finalize;
}

static void
security_privacy_ufw_helpers_rule_instance_init (SecurityPrivacyUFWHelpersRule * self,
                                                 gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	_tmp0_ = g_strdup ("");
	self->to_ports = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->from_ports = _tmp1_;
	_tmp2_ = g_strdup ("");
	self->to = _tmp2_;
	_tmp3_ = g_strdup ("");
	self->from = _tmp3_;
	self->version = SECURITY_PRIVACY_UFW_HELPERS_RULE_VERSION_BOTH;
}

static void
security_privacy_ufw_helpers_rule_finalize (GObject * obj)
{
	SecurityPrivacyUFWHelpersRule * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, SECURITY_PRIVACY_UFW_HELPERS_TYPE_RULE, SecurityPrivacyUFWHelpersRule);
	_g_free0 (self->to_ports);
	_g_free0 (self->from_ports);
	_g_free0 (self->to);
	_g_free0 (self->from);
	G_OBJECT_CLASS (security_privacy_ufw_helpers_rule_parent_class)->finalize (obj);
}

static GType
security_privacy_ufw_helpers_rule_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (SecurityPrivacyUFWHelpersRuleClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) security_privacy_ufw_helpers_rule_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (SecurityPrivacyUFWHelpersRule), 0, (GInstanceInitFunc) security_privacy_ufw_helpers_rule_instance_init, NULL };
	GType security_privacy_ufw_helpers_rule_type_id;
	security_privacy_ufw_helpers_rule_type_id = g_type_register_static (G_TYPE_OBJECT, "SecurityPrivacyUFWHelpersRule", &g_define_type_info, 0);
	return security_privacy_ufw_helpers_rule_type_id;
}

GType
security_privacy_ufw_helpers_rule_get_type (void)
{
	static volatile gsize security_privacy_ufw_helpers_rule_type_id__once = 0;
	if (g_once_init_enter (&security_privacy_ufw_helpers_rule_type_id__once)) {
		GType security_privacy_ufw_helpers_rule_type_id;
		security_privacy_ufw_helpers_rule_type_id = security_privacy_ufw_helpers_rule_get_type_once ();
		g_once_init_leave (&security_privacy_ufw_helpers_rule_type_id__once, security_privacy_ufw_helpers_rule_type_id);
	}
	return security_privacy_ufw_helpers_rule_type_id__once;
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

