/* ZGUtilities.c generated by valac 0.56.17, the Vala compiler
 * generated from ZGUtilities.vala, do not modify */

/* -*- Mode: vala; indent-tabs-mode: nil; tab-width: 4 -*-*/
/*-
 * Copyright (c) 2011 Collabora Ltd.
 * Copyright (c) 2012 Manish Sinha <manishsinha@ubuntu.com>
 * Copyright (c) 2014 elementary LLC. ((http://launchpad.net/switchboard-plug-security-privacy)
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this program; if not, write to the
 * Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
 * Boston, MA 02110-1301 USA
 *
 * Authored by: Corentin Noël <tintou@mailoo.org>
 *              Siegfried-Angel Gevatter Pujals <siegfried@gevatter.com> (from Activity-Log-Manager)
 *              Seif Lotfy <seif@lotfy.com> (from Activity-Log-Manager)
 */

#include "security-privacy.h"
#include <zeitgeist-datamodel.h>
#include <glib.h>
#include <stdlib.h>
#include <string.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

VALA_EXTERN gboolean security_privacy_utilities_check_field_match (const gchar* property,
                                                       const gchar* template_property,
                                                       const gchar* property_name);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);

gboolean
security_privacy_utilities_matches_event_template (ZeitgeistEvent* event,
                                                   ZeitgeistEvent* template_event)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	g_return_val_if_fail (template_event != NULL, FALSE);
	_tmp0_ = zeitgeist_event_get_interpretation (event);
	_tmp1_ = _tmp0_;
	_tmp2_ = zeitgeist_event_get_interpretation (template_event);
	_tmp3_ = _tmp2_;
	if (!security_privacy_utilities_check_field_match (_tmp1_, _tmp3_, "ev-int")) {
		result = FALSE;
		return result;
	}
	_tmp4_ = zeitgeist_event_get_manifestation (event);
	_tmp5_ = _tmp4_;
	_tmp6_ = zeitgeist_event_get_manifestation (template_event);
	_tmp7_ = _tmp6_;
	if (!security_privacy_utilities_check_field_match (_tmp5_, _tmp7_, "ev-mani")) {
		result = FALSE;
		return result;
	}
	_tmp8_ = zeitgeist_event_get_actor (event);
	_tmp9_ = _tmp8_;
	_tmp10_ = zeitgeist_event_get_actor (template_event);
	_tmp11_ = _tmp10_;
	if (!security_privacy_utilities_check_field_match (_tmp9_, _tmp11_, "ev-actor")) {
		result = FALSE;
		return result;
	}
	if (zeitgeist_event_num_subjects (event) == 0) {
		result = TRUE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp12_ = FALSE;
			_tmp12_ = TRUE;
			while (TRUE) {
				if (!_tmp12_) {
					gint _tmp13_;
					_tmp13_ = i;
					i = _tmp13_ + 1;
				}
				_tmp12_ = FALSE;
				if (!(i < zeitgeist_event_num_subjects (event))) {
					break;
				}
				{
					gint j = 0;
					j = 0;
					{
						gboolean _tmp14_ = FALSE;
						_tmp14_ = TRUE;
						while (TRUE) {
							ZeitgeistSubject* _tmp16_;
							ZeitgeistSubject* _tmp17_;
							ZeitgeistSubject* _tmp18_;
							ZeitgeistSubject* _tmp19_;
							gboolean _tmp20_;
							if (!_tmp14_) {
								gint _tmp15_;
								_tmp15_ = j;
								j = _tmp15_ + 1;
							}
							_tmp14_ = FALSE;
							if (!(j < zeitgeist_event_num_subjects (template_event))) {
								break;
							}
							_tmp16_ = zeitgeist_event_get_subject (event, i);
							_tmp17_ = _tmp16_;
							_tmp18_ = zeitgeist_event_get_subject (template_event, j);
							_tmp19_ = _tmp18_;
							_tmp20_ = security_privacy_utilities_matches_subject_template (_tmp17_, _tmp19_);
							_g_object_unref0 (_tmp19_);
							_g_object_unref0 (_tmp17_);
							if (_tmp20_) {
								result = TRUE;
								return result;
							}
						}
					}
				}
			}
		}
	}
	result = FALSE;
	return result;
}

gboolean
security_privacy_utilities_matches_subject_template (ZeitgeistSubject* subject,
                                                     ZeitgeistSubject* template_subject)
{
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	const gchar* _tmp12_;
	const gchar* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	const gchar* _tmp16_;
	const gchar* _tmp17_;
	const gchar* _tmp18_;
	const gchar* _tmp19_;
	gboolean result;
	g_return_val_if_fail (subject != NULL, FALSE);
	g_return_val_if_fail (template_subject != NULL, FALSE);
	_tmp0_ = zeitgeist_subject_get_uri (subject);
	_tmp1_ = _tmp0_;
	_tmp2_ = zeitgeist_subject_get_uri (template_subject);
	_tmp3_ = _tmp2_;
	if (!security_privacy_utilities_check_field_match (_tmp1_, _tmp3_, "sub-uri")) {
		result = FALSE;
		return result;
	}
	_tmp4_ = zeitgeist_subject_get_interpretation (subject);
	_tmp5_ = _tmp4_;
	_tmp6_ = zeitgeist_subject_get_interpretation (template_subject);
	_tmp7_ = _tmp6_;
	if (!security_privacy_utilities_check_field_match (_tmp5_, _tmp7_, "sub-int")) {
		result = FALSE;
		return result;
	}
	_tmp8_ = zeitgeist_subject_get_manifestation (subject);
	_tmp9_ = _tmp8_;
	_tmp10_ = zeitgeist_subject_get_manifestation (template_subject);
	_tmp11_ = _tmp10_;
	if (!security_privacy_utilities_check_field_match (_tmp9_, _tmp11_, "sub-mani")) {
		result = FALSE;
		return result;
	}
	_tmp12_ = zeitgeist_subject_get_origin (subject);
	_tmp13_ = _tmp12_;
	_tmp14_ = zeitgeist_subject_get_origin (template_subject);
	_tmp15_ = _tmp14_;
	if (!security_privacy_utilities_check_field_match (_tmp13_, _tmp15_, "sub-origin")) {
		result = FALSE;
		return result;
	}
	_tmp16_ = zeitgeist_subject_get_mimetype (subject);
	_tmp17_ = _tmp16_;
	_tmp18_ = zeitgeist_subject_get_mimetype (template_subject);
	_tmp19_ = _tmp18_;
	if (!security_privacy_utilities_check_field_match (_tmp17_, _tmp19_, "sub-mime")) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}

gboolean
security_privacy_utilities_check_field_match (const gchar* property,
                                              const gchar* template_property,
                                              const gchar* property_name)
{
	gboolean matches = FALSE;
	gchar* parsed = NULL;
	gchar* _tmp0_;
	gboolean _tmp1_ = FALSE;
	gboolean is_negated = FALSE;
	const gchar* _tmp3_;
	gboolean _tmp5_ = FALSE;
	gboolean result;
	g_return_val_if_fail (property_name != NULL, FALSE);
	matches = FALSE;
	_tmp0_ = g_strdup (template_property);
	parsed = _tmp0_;
	if (template_property != NULL) {
		gboolean _tmp2_;
		_tmp2_ = security_privacy_utilities_parse_negation (&parsed);
		_tmp1_ = _tmp2_;
	} else {
		_tmp1_ = FALSE;
	}
	is_negated = _tmp1_;
	_tmp3_ = parsed;
	if (g_strcmp0 (_tmp3_, "") == 0) {
		result = TRUE;
		_g_free0 (parsed);
		return result;
	} else {
		const gchar* _tmp4_;
		_tmp4_ = parsed;
		if (g_strcmp0 (_tmp4_, property) == 0) {
			matches = TRUE;
		}
	}
	if (is_negated) {
		_tmp5_ = !matches;
	} else {
		_tmp5_ = matches;
	}
	result = _tmp5_;
	_g_free0 (parsed);
	return result;
}

static glong
string_strnlen (gchar* str,
                glong maxlen)
{
	gchar* end = NULL;
	gchar* _tmp0_;
	gchar* _tmp1_;
	glong result;
	_tmp0_ = memchr (str, 0, (gsize) maxlen);
	end = _tmp0_;
	_tmp1_ = end;
	if (_tmp1_ == NULL) {
		result = maxlen;
		return result;
	} else {
		gchar* _tmp2_;
		_tmp2_ = end;
		result = (glong) (_tmp2_ - str);
		return result;
	}
}

static gchar*
string_substring (const gchar* self,
                  glong offset,
                  glong len)
{
	glong string_length = 0L;
	gboolean _tmp0_ = FALSE;
	gchar* _tmp3_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	if (offset >= ((glong) 0)) {
		_tmp0_ = len >= ((glong) 0);
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		string_length = string_strnlen ((gchar*) self, offset + len);
	} else {
		gint _tmp1_;
		gint _tmp2_;
		_tmp1_ = strlen (self);
		_tmp2_ = _tmp1_;
		string_length = (glong) _tmp2_;
	}
	if (offset < ((glong) 0)) {
		offset = string_length + offset;
		g_return_val_if_fail (offset >= ((glong) 0), NULL);
	} else {
		g_return_val_if_fail (offset <= string_length, NULL);
	}
	if (len < ((glong) 0)) {
		len = string_length - offset;
	}
	g_return_val_if_fail ((offset + len) <= string_length, NULL);
	_tmp3_ = g_strndup (((gchar*) self) + offset, (gsize) len);
	result = _tmp3_;
	return result;
}

gboolean
security_privacy_utilities_parse_negation (gchar** val)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (*val != NULL, FALSE);
	if (!g_str_has_prefix (*val, "!")) {
		result = FALSE;
		return result;
	}
	_tmp0_ = string_substring (*val, (glong) 1, (glong) -1);
	_g_free0 (*val);
	*val = _tmp0_;
	result = TRUE;
	return result;
}

static void
_g_free0_ (gpointer var)
{
	var = (g_free (var), NULL);
}

static void
_g_object_unref0_ (gpointer var)
{
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

GHashTable*
security_privacy_utilities_from_variant (GVariant* templates_variant)
{
	GHashTable* blacklist = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GError* _inner_error0_ = NULL;
	GHashTable* result;
	g_return_val_if_fail (templates_variant != NULL, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	blacklist = _tmp2_;
	{
		GVariantIter* _template_variant_it = NULL;
		GVariantIter* _tmp3_;
		GVariant* template_variant = NULL;
		_tmp3_ = g_variant_iter_new (templates_variant);
		_template_variant_it = _tmp3_;
		while (TRUE) {
			GVariantIter* _tmp4_;
			GVariant* _tmp5_;
			GVariant* _tmp6_;
			GVariantIter* iter = NULL;
			GVariant* _tmp7_;
			GVariantIter* _tmp8_;
			gchar* template_id = NULL;
			GVariantIter* _tmp9_;
			GVariant* _tmp10_;
			GVariant* _tmp11_;
			const gchar* _tmp12_;
			gchar* _tmp13_;
			gchar* _tmp14_;
			GVariant* ev_variant = NULL;
			GVariantIter* _tmp15_;
			GVariant* _tmp16_;
			GVariant* _tmp17_;
			_tmp4_ = _template_variant_it;
			_tmp5_ = g_variant_iter_next_value (_tmp4_);
			_g_variant_unref0 (template_variant);
			template_variant = _tmp5_;
			_tmp6_ = template_variant;
			if (!(_tmp6_ != NULL)) {
				break;
			}
			_tmp7_ = template_variant;
			_tmp8_ = g_variant_iter_new (_tmp7_);
			iter = _tmp8_;
			_tmp9_ = iter;
			_tmp10_ = g_variant_iter_next_value (_tmp9_);
			_tmp11_ = _tmp10_;
			_tmp12_ = g_variant_get_string (_tmp11_, NULL);
			_tmp13_ = g_strdup (_tmp12_);
			_tmp14_ = _tmp13_;
			_g_variant_unref0 (_tmp11_);
			template_id = _tmp14_;
			_tmp15_ = iter;
			_tmp16_ = g_variant_iter_next_value (_tmp15_);
			ev_variant = _tmp16_;
			_tmp17_ = ev_variant;
			if (_tmp17_ != NULL) {
				{
					ZeitgeistEvent* template = NULL;
					GVariant* _tmp18_;
					ZeitgeistEvent* _tmp19_;
					GHashTable* _tmp20_;
					const gchar* _tmp21_;
					gchar* _tmp22_;
					ZeitgeistEvent* _tmp23_;
					ZeitgeistEvent* _tmp24_;
					_tmp18_ = ev_variant;
					_tmp19_ = zeitgeist_event_new_from_variant (_tmp18_, &_inner_error0_);
					template = _tmp19_;
					if (G_UNLIKELY (_inner_error0_ != NULL)) {
						goto __catch0_g_error;
					}
					_tmp20_ = blacklist;
					_tmp21_ = template_id;
					_tmp22_ = g_strdup (_tmp21_);
					_tmp23_ = template;
					_tmp24_ = _g_object_ref0 (_tmp23_);
					g_hash_table_insert (_tmp20_, _tmp22_, _tmp24_);
					_g_object_unref0 (template);
				}
				goto __finally0;
				__catch0_g_error:
				{
					GError* e = NULL;
					GError* _tmp25_;
					const gchar* _tmp26_;
					e = _inner_error0_;
					_inner_error0_ = NULL;
					_tmp25_ = e;
					_tmp26_ = _tmp25_->message;
					g_warning ("ZGUtilities.vala:115: %s", _tmp26_);
					_g_error_free0 (e);
				}
				__finally0:
				if (G_UNLIKELY (_inner_error0_ != NULL)) {
					_g_variant_unref0 (ev_variant);
					_g_free0 (template_id);
					_g_variant_iter_free0 (iter);
					_g_variant_unref0 (template_variant);
					_g_variant_iter_free0 (_template_variant_it);
					_g_hash_table_unref0 (blacklist);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
					g_clear_error (&_inner_error0_);
					return NULL;
				}
			}
			_g_variant_unref0 (ev_variant);
			_g_free0 (template_id);
			_g_variant_iter_free0 (iter);
		}
		_g_variant_unref0 (template_variant);
		_g_variant_iter_free0 (_template_variant_it);
	}
	result = blacklist;
	return result;
}

