/* RsyncLogBox.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from RsyncLogBox.vala, do not modify */

/*
 * RsyncLogBox.vala
 *
 * Copyright 2012-2018 Tony George <teejeetech@gmail.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston,
 * MA 02110-1301, USA.
 *
 *
 */

#include <gtk/gtk.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <gee.h>
#include <glib/gi18n-lib.h>
#include <float.h>
#include <math.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <gdk/gdk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif
#if !defined(VALA_EXTERN)
#if defined(_MSC_VER)
#define VALA_EXTERN __declspec(dllexport) extern
#elif __GNUC__ >= 4
#define VALA_EXTERN __attribute__((visibility("default"))) extern
#else
#define VALA_EXTERN extern
#endif
#endif

#define TYPE_RSYNC_LOG_BOX (rsync_log_box_get_type ())
#define RSYNC_LOG_BOX(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_LOG_BOX, RsyncLogBox))
#define RSYNC_LOG_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_LOG_BOX, RsyncLogBoxClass))
#define IS_RSYNC_LOG_BOX(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_LOG_BOX))
#define IS_RSYNC_LOG_BOX_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_LOG_BOX))
#define RSYNC_LOG_BOX_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_LOG_BOX, RsyncLogBoxClass))

typedef struct _RsyncLogBox RsyncLogBox;
typedef struct _RsyncLogBoxClass RsyncLogBoxClass;
typedef struct _RsyncLogBoxPrivate RsyncLogBoxPrivate;

#define TYPE_FILE_ITEM (file_item_get_type ())
#define FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_FILE_ITEM, FileItem))
#define FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_FILE_ITEM, FileItemClass))
#define IS_FILE_ITEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_FILE_ITEM))
#define IS_FILE_ITEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_FILE_ITEM))
#define FILE_ITEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_FILE_ITEM, FileItemClass))

typedef struct _FileItem FileItem;
typedef struct _FileItemClass FileItemClass;
enum  {
	RSYNC_LOG_BOX_0_PROPERTY,
	RSYNC_LOG_BOX_IS_RUNNING_PROPERTY,
	RSYNC_LOG_BOX_NUM_PROPERTIES
};
static GParamSpec* rsync_log_box_properties[RSYNC_LOG_BOX_NUM_PROPERTIES];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_MAIN (main_get_type ())
#define MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MAIN, Main))
#define MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MAIN, MainClass))
#define IS_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MAIN))
#define IS_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MAIN))
#define MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MAIN, MainClass))

typedef struct _Main Main;
typedef struct _MainClass MainClass;
typedef struct _MainPrivate MainPrivate;

#define TYPE_DEVICE (device_get_type ())
#define DEVICE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DEVICE, Device))
#define DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DEVICE, DeviceClass))
#define IS_DEVICE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DEVICE))
#define IS_DEVICE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DEVICE))
#define DEVICE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DEVICE, DeviceClass))

typedef struct _Device Device;
typedef struct _DeviceClass DeviceClass;

#define TYPE_APP_EXCLUDE_ENTRY (app_exclude_entry_get_type ())
#define APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntry))
#define APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))
#define IS_APP_EXCLUDE_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_EXCLUDE_ENTRY))
#define IS_APP_EXCLUDE_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_EXCLUDE_ENTRY))
#define APP_EXCLUDE_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_EXCLUDE_ENTRY, AppExcludeEntryClass))

typedef struct _AppExcludeEntry AppExcludeEntry;
typedef struct _AppExcludeEntryClass AppExcludeEntryClass;

#define TYPE_MOUNT_ENTRY (mount_entry_get_type ())
#define MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MOUNT_ENTRY, MountEntry))
#define MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MOUNT_ENTRY, MountEntryClass))
#define IS_MOUNT_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MOUNT_ENTRY))
#define IS_MOUNT_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MOUNT_ENTRY))
#define MOUNT_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MOUNT_ENTRY, MountEntryClass))

typedef struct _MountEntry MountEntry;
typedef struct _MountEntryClass MountEntryClass;

#define TYPE_SNAPSHOT_REPO (snapshot_repo_get_type ())
#define SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepo))
#define SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))
#define IS_SNAPSHOT_REPO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT_REPO))
#define IS_SNAPSHOT_REPO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT_REPO))
#define SNAPSHOT_REPO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT_REPO, SnapshotRepoClass))

typedef struct _SnapshotRepo SnapshotRepo;
typedef struct _SnapshotRepoClass SnapshotRepoClass;

#define TYPE_SUBVOLUME (subvolume_get_type ())
#define SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SUBVOLUME, Subvolume))
#define SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SUBVOLUME, SubvolumeClass))
#define IS_SUBVOLUME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SUBVOLUME))
#define IS_SUBVOLUME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SUBVOLUME))
#define SUBVOLUME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SUBVOLUME, SubvolumeClass))

typedef struct _Subvolume Subvolume;
typedef struct _SubvolumeClass SubvolumeClass;

#define TYPE_LINUX_DISTRO (linux_distro_get_type ())
#define LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LINUX_DISTRO, LinuxDistro))
#define LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LINUX_DISTRO, LinuxDistroClass))
#define IS_LINUX_DISTRO(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LINUX_DISTRO))
#define IS_LINUX_DISTRO_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LINUX_DISTRO))
#define LINUX_DISTRO_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LINUX_DISTRO, LinuxDistroClass))

typedef struct _LinuxDistro LinuxDistro;
typedef struct _LinuxDistroClass LinuxDistroClass;

#define TYPE_APP_LOCK (app_lock_get_type ())
#define APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_LOCK, AppLock))
#define APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_LOCK, AppLockClass))
#define IS_APP_LOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_LOCK))
#define IS_APP_LOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_LOCK))
#define APP_LOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_LOCK, AppLockClass))

typedef struct _AppLock AppLock;
typedef struct _AppLockClass AppLockClass;

#define TYPE_SNAPSHOT (snapshot_get_type ())
#define SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SNAPSHOT, Snapshot))
#define SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SNAPSHOT, SnapshotClass))
#define IS_SNAPSHOT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SNAPSHOT))
#define IS_SNAPSHOT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SNAPSHOT))
#define SNAPSHOT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SNAPSHOT, SnapshotClass))

typedef struct _Snapshot Snapshot;
typedef struct _SnapshotClass SnapshotClass;

#define TYPE_ASYNC_TASK (async_task_get_type ())
#define ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ASYNC_TASK, AsyncTask))
#define ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ASYNC_TASK, AsyncTaskClass))
#define IS_ASYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ASYNC_TASK))
#define IS_ASYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ASYNC_TASK))
#define ASYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ASYNC_TASK, AsyncTaskClass))

typedef struct _AsyncTask AsyncTask;
typedef struct _AsyncTaskClass AsyncTaskClass;

#define TYPE_RSYNC_TASK (rsync_task_get_type ())
#define RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_TASK, RsyncTask))
#define RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_TASK, RsyncTaskClass))
#define IS_RSYNC_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_TASK))
#define IS_RSYNC_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_TASK))
#define RSYNC_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_TASK, RsyncTaskClass))

typedef struct _RsyncTask RsyncTask;
typedef struct _RsyncTaskClass RsyncTaskClass;

#define TYPE_DELETE_FILE_TASK (delete_file_task_get_type ())
#define DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTask))
#define DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))
#define IS_DELETE_FILE_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DELETE_FILE_TASK))
#define IS_DELETE_FILE_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DELETE_FILE_TASK))
#define DELETE_FILE_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DELETE_FILE_TASK, DeleteFileTaskClass))

typedef struct _DeleteFileTask DeleteFileTask;
typedef struct _DeleteFileTaskClass DeleteFileTaskClass;

#define TYPE_RSYNC_SPACE_CHECK_TASK (rsync_space_check_task_get_type ())
#define RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTask))
#define RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))
#define IS_RSYNC_SPACE_CHECK_TASK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RSYNC_SPACE_CHECK_TASK))
#define IS_RSYNC_SPACE_CHECK_TASK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_RSYNC_SPACE_CHECK_TASK))
#define RSYNC_SPACE_CHECK_TASK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_RSYNC_SPACE_CHECK_TASK, RsyncSpaceCheckTaskClass))

typedef struct _RsyncSpaceCheckTask RsyncSpaceCheckTask;
typedef struct _RsyncSpaceCheckTaskClass RsyncSpaceCheckTaskClass;

#define TYPE_SYSTEM_USER (system_user_get_type ())
#define SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_SYSTEM_USER, SystemUser))
#define SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_SYSTEM_USER, SystemUserClass))
#define IS_SYSTEM_USER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_SYSTEM_USER))
#define IS_SYSTEM_USER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_SYSTEM_USER))
#define SYSTEM_USER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_SYSTEM_USER, SystemUserClass))

typedef struct _SystemUser SystemUser;
typedef struct _SystemUserClass SystemUserClass;
#define _g_thread_unref0(var) ((var == NULL) ? NULL : (var = (g_thread_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _AsyncTaskPrivate AsyncTaskPrivate;
typedef enum  {
	APP_STATUS_NOT_STARTED,
	APP_STATUS_RUNNING,
	APP_STATUS_PAUSED,
	APP_STATUS_FINISHED,
	APP_STATUS_CANCELLED,
	APP_STATUS_PASSWORD_REQUIRED
} AppStatus;

#define TYPE_APP_STATUS (app_status_get_type ())
typedef struct _Block8Data Block8Data;
typedef struct _FileItemPrivate FileItemPrivate;
#define _g_timer_destroy0(var) ((var == NULL) ? NULL : (var = (g_timer_destroy (var), NULL)))

struct _RsyncLogBox {
	GtkBox parent_instance;
	RsyncLogBoxPrivate * priv;
	GtkLabel* lbl_header;
	GtkLabel* lbl_header_progress;
	GtkLabel* lbl_msg;
	GtkLabel* lbl_status;
	GtkLabel* lbl_remaining;
	GtkProgressBar* progressbar;
};

struct _RsyncLogBoxClass {
	GtkBoxClass parent_class;
};

struct _RsyncLogBoxPrivate {
	GtkBox* vbox_progress;
	GtkBox* vbox_list;
	GtkTreeView* treeview;
	GtkTreeModelFilter* treefilter;
	GtkComboBox* cmb_filter;
	GtkBox* hbox_filter;
	GtkEntry* txt_pattern;
	GtkTreeViewColumn* col_name;
	GtkTreeViewColumn* col_status;
	gchar* name_filter;
	gchar* status_filter;
	GtkSpinner* spinner;
	guint tmr_init;
	gboolean thread_is_running;
	gchar* rsync_log_file;
	GeeArrayList* loglist;
	GtkWindow* window;
	guint tmr_action;
};

struct _Main {
	GObject parent_instance;
	MainPrivate * priv;
	gchar* app_path;
	gchar* share_folder;
	gchar* rsnapshot_conf_path;
	gchar* app_conf_path;
	gchar* app_conf_path_old;
	gchar* app_conf_path_default;
	gboolean first_run;
	gchar* backup_uuid;
	gchar* backup_parent_uuid;
	gboolean btrfs_mode;
	gboolean include_btrfs_home_for_backup;
	gboolean include_btrfs_home_for_restore;
	gboolean stop_cron_emails;
	GeeArrayList* partitions;
	GeeArrayList* exclude_list_user;
	GeeArrayList* exclude_list_default;
	GeeArrayList* exclude_list_default_extra;
	GeeArrayList* exclude_list_home;
	GeeArrayList* exclude_list_restore;
	GeeArrayList* exclude_list_apps;
	GeeArrayList* mount_list;
	GeeArrayList* exclude_app_names;
	SnapshotRepo* repo;
	Device* sys_root;
	Device* sys_boot;
	Device* sys_efi;
	Device* sys_home;
	GeeHashMap* sys_subvolumes;
	gchar* mount_point_restore;
	gchar* mount_point_app;
	LinuxDistro* current_distro;
	gboolean mirror_system;
	gboolean schedule_monthly;
	gboolean schedule_weekly;
	gboolean schedule_daily;
	gboolean schedule_hourly;
	gboolean schedule_boot;
	gint count_monthly;
	gint count_weekly;
	gint count_daily;
	gint count_hourly;
	gint count_boot;
	gchar* app_mode;
	gboolean dry_run;
	gboolean thr_success;
	gboolean thread_estimate_running;
	gboolean thread_estimate_success;
	gboolean thread_restore_running;
	gboolean thread_restore_success;
	gboolean thread_delete_running;
	gboolean thread_delete_success;
	gboolean thread_subvol_info_running;
	gboolean thread_subvol_info_success;
	gint thr_retval;
	gchar* thr_arg1;
	gboolean thr_timeout_active;
	gchar* thr_timeout_cmd;
	gint startup_delay_interval_mins;
	gint retain_snapshots_max_days;
	gchar* log_dir;
	gchar* log_file;
	AppLock* app_lock;
	gchar* date_format;
	GeeArrayList* delete_list;
	Snapshot* snapshot_to_delete;
	Snapshot* snapshot_to_restore;
	gboolean reinstall_grub2;
	gboolean update_initramfs;
	gboolean update_grub;
	gchar* grub_device;
	gboolean use_option_raw;
	gboolean cmd_skip_grub;
	gchar* cmd_grub_device;
	gchar* cmd_target_device;
	gchar* cmd_backup_device;
	gchar* cmd_snapshot;
	gboolean cmd_confirm;
	gboolean cmd_verbose;
	gboolean cmd_scripted;
	gchar* cmd_comments;
	gchar* cmd_tags;
	gboolean* cmd_btrfs_mode;
	gchar* progress_text;
	GtkWindow* parent_window;
	RsyncTask* task;
	DeleteFileTask* delete_file_task;
	RsyncSpaceCheckTask* space_check_task;
	GeeHashMap* current_system_users;
	gchar* users_with_encrypted_home;
	gchar* encrypted_home_dirs;
	gboolean encrypted_home_warning_shown;
	gchar* encrypted_private_dirs;
	gboolean encrypted_private_warning_shown;
};

struct _MainClass {
	GObjectClass parent_class;
};

struct _AsyncTask {
	GObject parent_instance;
	AsyncTaskPrivate * priv;
	GDataOutputStream* dos_log;
	gboolean is_terminated;
	GPid child_pid;
	gchar* script_file;
	gchar* working_dir;
	gchar* log_file;
	gboolean background_mode;
	AppStatus status;
	GMutex status_line_mutex;
	gint exit_code;
	gchar* error_msg;
	GTimer* timer;
	gdouble progress;
	gdouble percent;
	gint64 prg_count;
	gint64 prg_count_total;
	gint64 prg_bytes;
	gint64 prg_bytes_total;
	gchar* eta;
};

struct _AsyncTaskClass {
	GObjectClass parent_class;
	void (*parse_stdout_line) (AsyncTask* self, const gchar* out_line);
	void (*parse_stderr_line) (AsyncTask* self, const gchar* err_line);
	void (*finish_task) (AsyncTask* self);
};

struct _Block8Data {
	int _ref_count_;
	RsyncLogBox* self;
	GtkEntry* txt;
};

struct _FileItem {
	GObject parent_instance;
	FileItemPrivate * priv;
	gchar* file_name;
	gchar* file_location;
	gchar* file_path;
	gchar* file_path_prefix;
	GFileType file_type;
	GDateTime* modified;
	gchar* permissions;
	gchar* owner_user;
	gchar* owner_group;
	gchar* content_type;
	gchar* file_status;
	gboolean is_selected;
	gboolean is_symlink;
	gchar* symlink_target;
	glong file_count;
	glong dir_count;
	GIcon* icon;
};

struct _FileItemClass {
	GObjectClass parent_class;
};

static gint RsyncLogBox_private_offset;
static gpointer rsync_log_box_parent_class = NULL;
VALA_EXTERN Main* App;

VALA_EXTERN GType rsync_log_box_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncLogBox, g_object_unref)
VALA_EXTERN GType file_item_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (FileItem, g_object_unref)
VALA_EXTERN RsyncLogBox* rsync_log_box_new (GtkWindow* _window);
VALA_EXTERN RsyncLogBox* rsync_log_box_construct (GType object_type,
                                      GtkWindow* _window);
VALA_EXTERN void tee_jee_logging_log_debug (const gchar* message);
VALA_EXTERN void rsync_log_box_open_log (RsyncLogBox* self,
                             const gchar* _rsync_log_file);
VALA_EXTERN GType main_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Main, g_object_unref)
VALA_EXTERN GType device_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Device, g_object_unref)
VALA_EXTERN GType app_exclude_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppExcludeEntry, g_object_unref)
VALA_EXTERN GType mount_entry_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (MountEntry, g_object_unref)
VALA_EXTERN GType snapshot_repo_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SnapshotRepo, g_object_unref)
VALA_EXTERN GType subvolume_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Subvolume, g_object_unref)
VALA_EXTERN GType linux_distro_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (LinuxDistro, g_object_unref)
VALA_EXTERN GType app_lock_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AppLock, g_object_unref)
VALA_EXTERN GType snapshot_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (Snapshot, g_object_unref)
VALA_EXTERN GType async_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (AsyncTask, g_object_unref)
VALA_EXTERN GType rsync_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncTask, g_object_unref)
VALA_EXTERN GType delete_file_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (DeleteFileTask, g_object_unref)
VALA_EXTERN GType rsync_space_check_task_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (RsyncSpaceCheckTask, g_object_unref)
VALA_EXTERN GType system_user_get_type (void) G_GNUC_CONST ;
G_DEFINE_AUTOPTR_CLEANUP_FUNC (SystemUser, g_object_unref)
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label_header (GtkBox* box,
                                               const gchar* text,
                                               gboolean large_heading);
static void rsync_log_box_create_progressbar (RsyncLogBox* self);
static void rsync_log_box_create_filters (RsyncLogBox* self);
static void rsync_log_box_create_treeview (RsyncLogBox* self);
static void __lambda130_ (RsyncLogBox* self);
VALA_EXTERN gchar* tee_jee_gtk_helper_gtk_combobox_get_value (GtkComboBox* combo,
                                                  gint index,
                                                  const gchar* default_value);
static gboolean __lambda131_ (RsyncLogBox* self);
static gboolean ___lambda131__gsource_func (gpointer self);
static void ___lambda130__gtk_combo_box_changed (GtkComboBox* _sender,
                                          gpointer self);
static gboolean rsync_log_box_get_is_restore_log (RsyncLogBox* self);
VALA_EXTERN gboolean rsync_log_box_init_delayed (RsyncLogBox* self);
static gboolean _rsync_log_box_init_delayed_gsource_func (gpointer self);
static void rsync_log_box_parse_log_file (RsyncLogBox* self);
static void ___lambda132_ (RsyncLogBox* self);
static void rsync_log_box_parse_log_file_thread (RsyncLogBox* self);
static gpointer ____lambda132__gthread_func (gpointer self);
VALA_EXTERN void tee_jee_logging_log_error (const gchar* message,
                                gboolean highlight,
                                gboolean is_warning);
VALA_EXTERN GType app_status_get_type (void) G_GNUC_CONST ;
VALA_EXTERN void tee_jee_system_sleep (gint milliseconds);
VALA_EXTERN void tee_jee_gtk_helper_gtk_do_events (void);
static void rsync_log_box_treeview_refresh (RsyncLogBox* self);
VALA_EXTERN RsyncTask* rsync_task_new (void);
VALA_EXTERN RsyncTask* rsync_task_construct (GType object_type);
VALA_EXTERN GeeArrayList* rsync_task_parse_log (RsyncTask* self,
                                    const gchar* log_file_path);
VALA_EXTERN GtkLabel* tee_jee_gtk_helper_add_label (GtkBox* box,
                                        const gchar* text,
                                        gboolean bold,
                                        gboolean italic,
                                        gboolean large);
static void rsync_log_box_add_search_entry (RsyncLogBox* self,
                                     GtkBox* hbox);
static void rsync_log_box_add_combo (RsyncLogBox* self,
                              GtkBox* hbox);
static void ___lambda129_ (RsyncLogBox* self);
static void ____lambda129__gtk_button_clicked (GtkButton* _sender,
                                        gpointer self);
static Block8Data* block8_data_ref (Block8Data* _data8_);
static void block8_data_unref (void * _userdata_);
static void __lambda123_ (RsyncLogBox* self);
static gboolean rsync_log_box_execute_action (RsyncLogBox* self);
static void ___lambda123__gtk_entry_activate (GtkEntry* _sender,
                                       gpointer self);
static gboolean __lambda124_ (Block8Data* _data8_,
                       GdkEventFocus* event);
static gboolean ___lambda124__gtk_widget_focus_out_event (GtkWidget* _sender,
                                                   GdkEventFocus* event,
                                                   gpointer self);
static gboolean __lambda125_ (RsyncLogBox* self);
static gboolean ___lambda125__gtk_widget_popup_menu (GtkWidget* _sender,
                                              gpointer self);
static gboolean __lambda126_ (RsyncLogBox* self,
                       GtkWidget* w,
                       GdkEventButton* event);
static gboolean ___lambda126__gtk_widget_button_press_event (GtkWidget* _sender,
                                                      GdkEventButton* event,
                                                      gpointer self);
static gboolean __lambda127_ (RsyncLogBox* self,
                       GdkEventKey* event);
static void rsync_log_box_add_action_delayed (RsyncLogBox* self);
static gboolean ___lambda127__gtk_widget_key_press_event (GtkWidget* _sender,
                                                   GdkEventKey* event,
                                                   gpointer self);
static void __lambda128_ (RsyncLogBox* self,
                   GtkCellLayout* cell_layout,
                   GtkCellRenderer* cell,
                   GtkTreeModel* model,
                   GtkTreeIter* iter);
static void ___lambda128__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                              GtkCellRenderer* cell,
                                              GtkTreeModel* tree_model,
                                              GtkTreeIter* iter,
                                              gpointer self);
static void rsync_log_box_clear_action_delayed (RsyncLogBox* self);
static gboolean _rsync_log_box_execute_action_gsource_func (gpointer self);
static void rsync_log_box_add_column_status (RsyncLogBox* self);
static void rsync_log_box_add_column_name (RsyncLogBox* self);
static void rsync_log_box_add_column_buffer (RsyncLogBox* self);
VALA_EXTERN GTimer* tee_jee_system_timer_start (void);
VALA_EXTERN void tee_jee_gtk_helper_gtk_set_busy (gboolean busy,
                                      GtkWindow* win);
VALA_EXTERN gchar* tee_jee_file_system_file_parent (const gchar* file_path);
VALA_EXTERN GdkPixbuf* icon_manager_lookup (const gchar* icon_name,
                                gint icon_size,
                                gboolean symbolic,
                                gboolean use_hardcoded,
                                gint scale);
VALA_EXTERN GdkPixbuf* file_item_get_icon (FileItem* self,
                               gint icon_size,
                               gboolean add_transparency,
                               gboolean add_emblems);
static gboolean rsync_log_box_filter_packages_func (RsyncLogBox* self,
                                             GtkTreeModel* model,
                                             GtkTreeIter* iter);
static gboolean _rsync_log_box_filter_packages_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model,
                                                                                 GtkTreeIter* iter,
                                                                                 gpointer self);
VALA_EXTERN gchar* tee_jee_system_timer_elapsed_string (GTimer* timer,
                                            gboolean stop);
static void rsync_log_box_exclude_selected_items (RsyncLogBox* self);
VALA_EXTERN gchar* tee_jee_file_system_file_basename (const gchar* file_path);
VALA_EXTERN gboolean rsync_log_box_get_is_running (RsyncLogBox* self);
static void rsync_log_box_finalize (GObject * obj);
static GType rsync_log_box_get_type_once (void);
static void _vala_rsync_log_box_get_property (GObject * object,
                                       guint property_id,
                                       GValue * value,
                                       GParamSpec * pspec);

static inline gpointer
rsync_log_box_get_instance_private (RsyncLogBox* self)
{
	return G_STRUCT_MEMBER_P (self, RsyncLogBox_private_offset);
}

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

RsyncLogBox*
rsync_log_box_construct (GType object_type,
                         GtkWindow* _window)
{
	RsyncLogBox * self = NULL;
	GtkWindow* _tmp0_;
	g_return_val_if_fail (_window != NULL, NULL);
	self = (RsyncLogBox*) g_object_new (object_type, "orientation", GTK_ORIENTATION_VERTICAL, "spacing", 6, NULL);
	g_object_set ((GtkWidget*) self, "margin", 6, NULL);
	tee_jee_logging_log_debug ("RsyncLogBox: RsyncLogBox()");
	_tmp0_ = _g_object_ref0 (_window);
	_g_object_unref0 (self->priv->window);
	self->priv->window = _tmp0_;
	return self;
}

RsyncLogBox*
rsync_log_box_new (GtkWindow* _window)
{
	return rsync_log_box_construct (TYPE_RSYNC_LOG_BOX, _window);
}

static gboolean
__lambda131_ (RsyncLogBox* self)
{
	GtkBox* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeModelFilter* _tmp2_;
	GtkBox* _tmp3_;
	GtkTreeView* _tmp4_;
	gboolean result;
	_tmp0_ = self->priv->hbox_filter;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp0_, FALSE);
	_tmp1_ = self->priv->treeview;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	tee_jee_logging_log_debug ("refilter(): start");
	_tmp2_ = self->priv->treefilter;
	gtk_tree_model_filter_refilter (_tmp2_);
	tee_jee_logging_log_debug ("refilter(): end");
	_tmp3_ = self->priv->hbox_filter;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, TRUE);
	_tmp4_ = self->priv->treeview;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp4_, TRUE);
	result = FALSE;
	return result;
}

static gboolean
___lambda131__gsource_func (gpointer self)
{
	gboolean result;
	result = __lambda131_ ((RsyncLogBox*) self);
	return result;
}

static void
__lambda130_ (RsyncLogBox* self)
{
	GtkComboBox* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	_tmp0_ = self->priv->cmb_filter;
	_tmp1_ = tee_jee_gtk_helper_gtk_combobox_get_value (_tmp0_, 0, "");
	_g_free0 (self->priv->status_filter);
	self->priv->status_filter = _tmp1_;
	_tmp2_ = self->priv->status_filter;
	_tmp3_ = g_strdup_printf ("combo_changed(): filter=%s", _tmp2_);
	_tmp4_ = _tmp3_;
	tee_jee_logging_log_debug (_tmp4_);
	_g_free0 (_tmp4_);
	g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, ___lambda131__gsource_func, g_object_ref (self), g_object_unref);
}

static void
___lambda130__gtk_combo_box_changed (GtkComboBox* _sender,
                                     gpointer self)
{
	__lambda130_ ((RsyncLogBox*) self);
}

static gboolean
_rsync_log_box_init_delayed_gsource_func (gpointer self)
{
	gboolean result;
	result = rsync_log_box_init_delayed ((RsyncLogBox*) self);
	return result;
}

void
rsync_log_box_open_log (RsyncLogBox* self,
                        const gchar* _rsync_log_file)
{
	gchar* _tmp0_;
	Main* _tmp1_;
	GtkComboBox* _tmp4_;
	gboolean _tmp5_;
	gboolean _tmp6_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (_rsync_log_file != NULL);
	_tmp0_ = g_strdup (_rsync_log_file);
	_g_free0 (self->priv->rsync_log_file);
	self->priv->rsync_log_file = _tmp0_;
	_tmp1_ = App;
	if (_tmp1_->dry_run) {
		GtkLabel* _tmp2_;
		GtkLabel* _tmp3_;
		_tmp2_ = tee_jee_gtk_helper_add_label_header ((GtkBox*) self, _ ("Confirm Actions"), TRUE);
		_g_object_unref0 (self->lbl_header);
		self->lbl_header = _tmp2_;
		_tmp3_ = self->lbl_header;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp3_, TRUE);
	}
	rsync_log_box_create_progressbar (self);
	rsync_log_box_create_filters (self);
	rsync_log_box_create_treeview (self);
	_tmp4_ = self->priv->cmb_filter;
	g_signal_connect_object (_tmp4_, "changed", (GCallback) ___lambda130__gtk_combo_box_changed, self, 0);
	_tmp5_ = rsync_log_box_get_is_restore_log (self);
	_tmp6_ = _tmp5_;
	if (_tmp6_) {
		GtkTreeViewColumn* _tmp7_;
		_tmp7_ = self->priv->col_name;
		gtk_tree_view_column_set_title (_tmp7_, _ ("File (system)"));
	} else {
		GtkTreeViewColumn* _tmp8_;
		_tmp8_ = self->priv->col_name;
		gtk_tree_view_column_set_title (_tmp8_, _ ("File (snapshot)"));
	}
	gtk_widget_show_all ((GtkWidget*) self);
	self->priv->tmr_init = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 100, _rsync_log_box_init_delayed_gsource_func, g_object_ref (self), g_object_unref);
	tee_jee_logging_log_debug ("RsyncLogWindow: RsyncLogWindow(): exit");
}

gboolean
rsync_log_box_init_delayed (RsyncLogBox* self)
{
	Main* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	tee_jee_logging_log_debug ("init_delayed()");
	if (self->priv->tmr_init > ((guint) 0)) {
		g_source_remove (self->priv->tmr_init);
		self->priv->tmr_init = (guint) 0;
	}
	rsync_log_box_parse_log_file (self);
	_tmp0_ = App;
	if (_tmp0_->dry_run) {
		GtkLabel* _tmp1_;
		GtkLabel* _tmp2_;
		_tmp1_ = self->lbl_header;
		gtk_widget_set_no_show_all ((GtkWidget*) _tmp1_, FALSE);
		_tmp2_ = self->lbl_header;
		gtk_widget_show ((GtkWidget*) _tmp2_);
	}
	tee_jee_logging_log_debug ("init_delayed(): finish");
	result = FALSE;
	return result;
}

static void
___lambda132_ (RsyncLogBox* self)
{
	rsync_log_box_parse_log_file_thread (self);
}

static gpointer
____lambda132__gthread_func (gpointer self)
{
	gpointer result;
	___lambda132_ ((RsyncLogBox*) self);
	result = NULL;
	g_object_unref (self);
	return result;
}

static void
rsync_log_box_parse_log_file (RsyncLogBox* self)
{
	GtkLabel* _tmp16_;
	GtkBox* _tmp17_;
	GtkBox* _tmp18_;
	GtkBox* _tmp19_;
	GtkBox* _tmp20_;
	GtkBox* _tmp21_;
	GError* _inner_error0_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GThread* _tmp0_;
		GThread* _tmp1_;
		self->priv->thread_is_running = TRUE;
		_tmp0_ = g_thread_try_new ("log-file-parser", ____lambda132__gthread_func, g_object_ref (self), &_inner_error0_);
		_tmp1_ = _tmp0_;
		_g_thread_unref0 (_tmp1_);
		if (G_UNLIKELY (_inner_error0_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error0_;
		_inner_error0_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		tee_jee_logging_log_error (_tmp3_, FALSE, FALSE);
		_g_error_free0 (e);
	}
	__finally0:
	if (G_UNLIKELY (_inner_error0_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error0_->message, g_quark_to_string (_inner_error0_->domain), _inner_error0_->code);
		g_clear_error (&_inner_error0_);
		return;
	}
	while (TRUE) {
		gdouble fraction = 0.0;
		Main* _tmp4_;
		RsyncTask* _tmp5_;
		Main* _tmp6_;
		RsyncTask* _tmp7_;
		GtkLabel* _tmp9_;
		Main* _tmp10_;
		RsyncTask* _tmp11_;
		Main* _tmp12_;
		RsyncTask* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		if (!self->priv->thread_is_running) {
			break;
		}
		_tmp4_ = App;
		_tmp5_ = _tmp4_->task;
		_tmp6_ = App;
		_tmp7_ = _tmp6_->task;
		fraction = (((AsyncTask*) _tmp5_)->prg_count * 1.0) / ((AsyncTask*) _tmp7_)->prg_count_total;
		if (fraction < 0.99) {
			GtkProgressBar* _tmp8_;
			_tmp8_ = self->progressbar;
			gtk_progress_bar_set_fraction (_tmp8_, fraction);
		}
		_tmp9_ = self->lbl_msg;
		_tmp10_ = App;
		_tmp11_ = _tmp10_->task;
		_tmp12_ = App;
		_tmp13_ = _tmp12_->task;
		_tmp14_ = g_strdup_printf (_ ("Read %'d of %'d lines..."), ((AsyncTask*) _tmp11_)->prg_count, ((AsyncTask*) _tmp13_)->prg_count_total);
		_tmp15_ = _tmp14_;
		gtk_label_set_label (_tmp9_, _tmp15_);
		_g_free0 (_tmp15_);
		tee_jee_system_sleep (500);
		tee_jee_gtk_helper_gtk_do_events ();
	}
	_tmp16_ = self->lbl_msg;
	gtk_label_set_label (_tmp16_, _ ("Populating list..."));
	tee_jee_gtk_helper_gtk_do_events ();
	rsync_log_box_treeview_refresh (self);
	_tmp17_ = self->priv->vbox_progress;
	gtk_widget_hide ((GtkWidget*) _tmp17_);
	tee_jee_gtk_helper_gtk_do_events ();
	_tmp18_ = self->priv->vbox_list;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp18_, FALSE);
	_tmp19_ = self->priv->vbox_list;
	gtk_widget_show_all ((GtkWidget*) _tmp19_);
	_tmp20_ = self->priv->hbox_filter;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp20_, FALSE);
	_tmp21_ = self->priv->hbox_filter;
	gtk_widget_show_all ((GtkWidget*) _tmp21_);
}

static void
rsync_log_box_parse_log_file_thread (RsyncLogBox* self)
{
	Main* _tmp0_;
	RsyncTask* _tmp1_;
	Main* _tmp2_;
	RsyncTask* _tmp3_;
	const gchar* _tmp4_;
	GeeArrayList* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = App;
	_tmp1_ = rsync_task_new ();
	_g_object_unref0 (_tmp0_->task);
	_tmp0_->task = _tmp1_;
	_tmp2_ = App;
	_tmp3_ = _tmp2_->task;
	_tmp4_ = self->priv->rsync_log_file;
	_tmp5_ = rsync_task_parse_log (_tmp3_, _tmp4_);
	_g_object_unref0 (self->priv->loglist);
	self->priv->loglist = _tmp5_;
	self->priv->thread_is_running = FALSE;
}

static void
rsync_log_box_create_progressbar (RsyncLogBox* self)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkLabel* _tmp3_;
	GtkBox* hbox_status = NULL;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkSpinner* _tmp6_;
	GtkSpinner* _tmp7_;
	GtkSpinner* _tmp8_;
	GtkLabel* _tmp9_;
	GtkLabel* _tmp10_;
	GtkLabel* _tmp11_;
	GtkLabel* _tmp12_;
	GtkProgressBar* _tmp13_;
	GtkBox* _tmp14_;
	GtkProgressBar* _tmp15_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->vbox_progress);
	self->priv->vbox_progress = _tmp0_;
	_tmp1_ = self->priv->vbox_progress;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	_tmp2_ = self->priv->vbox_progress;
	_tmp3_ = tee_jee_gtk_helper_add_label_header (_tmp2_, _ ("Parsing log file..."), TRUE);
	_g_object_unref0 (self->lbl_header_progress);
	self->lbl_header_progress = _tmp3_;
	_tmp4_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp4_);
	hbox_status = _tmp4_;
	_tmp5_ = self->priv->vbox_progress;
	gtk_container_add ((GtkContainer*) _tmp5_, (GtkWidget*) hbox_status);
	_tmp6_ = (GtkSpinner*) gtk_spinner_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->priv->spinner);
	self->priv->spinner = _tmp6_;
	_tmp7_ = self->priv->spinner;
	g_object_set (_tmp7_, "active", TRUE, NULL);
	_tmp8_ = self->priv->spinner;
	gtk_container_add ((GtkContainer*) hbox_status, (GtkWidget*) _tmp8_);
	_tmp9_ = tee_jee_gtk_helper_add_label (hbox_status, _ ("Preparing..."), FALSE, FALSE, FALSE);
	_g_object_unref0 (self->lbl_msg);
	self->lbl_msg = _tmp9_;
	_tmp10_ = self->lbl_msg;
	gtk_widget_set_hexpand ((GtkWidget*) _tmp10_, TRUE);
	_tmp11_ = self->lbl_msg;
	gtk_label_set_ellipsize (_tmp11_, PANGO_ELLIPSIZE_END);
	_tmp12_ = self->lbl_msg;
	gtk_label_set_max_width_chars (_tmp12_, 50);
	_tmp13_ = (GtkProgressBar*) gtk_progress_bar_new ();
	g_object_ref_sink (_tmp13_);
	_g_object_unref0 (self->progressbar);
	self->progressbar = _tmp13_;
	_tmp14_ = self->priv->vbox_progress;
	_tmp15_ = self->progressbar;
	gtk_container_add ((GtkContainer*) _tmp14_, (GtkWidget*) _tmp15_);
	_g_object_unref0 (hbox_status);
}

static void
___lambda129_ (RsyncLogBox* self)
{
	GtkWindow* _tmp0_;
	_tmp0_ = self->priv->window;
	gtk_widget_destroy ((GtkWidget*) _tmp0_);
}

static void
____lambda129__gtk_button_clicked (GtkButton* _sender,
                                   gpointer self)
{
	___lambda129_ ((RsyncLogBox*) self);
}

static void
rsync_log_box_create_filters (RsyncLogBox* self)
{
	GtkBox* hbox = NULL;
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkBox* _tmp3_;
	GtkBox* _tmp4_;
	GtkBox* _tmp5_;
	GtkBox* _tmp6_;
	Main* _tmp7_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("create_filters()");
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_HORIZONTAL, 6);
	g_object_ref_sink (_tmp0_);
	hbox = _tmp0_;
	_tmp1_ = hbox;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = hbox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = hbox;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->hbox_filter);
	self->priv->hbox_filter = _tmp4_;
	_tmp5_ = hbox;
	rsync_log_box_add_search_entry (self, _tmp5_);
	_tmp6_ = hbox;
	rsync_log_box_add_combo (self, _tmp6_);
	_tmp7_ = App;
	if (!_tmp7_->dry_run) {
		GtkLabel* label = NULL;
		GtkBox* _tmp8_;
		GtkLabel* _tmp9_;
		GtkLabel* _tmp10_;
		GtkButton* button = NULL;
		GtkButton* _tmp11_;
		GtkBox* _tmp12_;
		GtkButton* _tmp13_;
		GtkButton* _tmp14_;
		_tmp8_ = hbox;
		_tmp9_ = tee_jee_gtk_helper_add_label (_tmp8_, "", FALSE, FALSE, FALSE);
		label = _tmp9_;
		_tmp10_ = label;
		gtk_widget_set_hexpand ((GtkWidget*) _tmp10_, TRUE);
		_tmp11_ = (GtkButton*) gtk_button_new_with_label (_ ("Close"));
		g_object_ref_sink (_tmp11_);
		button = _tmp11_;
		_tmp12_ = hbox;
		_tmp13_ = button;
		gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) _tmp13_);
		_tmp14_ = button;
		g_signal_connect_object (_tmp14_, "clicked", (GCallback) ____lambda129__gtk_button_clicked, self, 0);
		_g_object_unref0 (button);
		_g_object_unref0 (label);
	}
	_g_object_unref0 (hbox);
}

static Block8Data*
block8_data_ref (Block8Data* _data8_)
{
	g_atomic_int_inc (&_data8_->_ref_count_);
	return _data8_;
}

static void
block8_data_unref (void * _userdata_)
{
	Block8Data* _data8_;
	_data8_ = (Block8Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data8_->_ref_count_)) {
		RsyncLogBox* self;
		self = _data8_->self;
		_g_object_unref0 (_data8_->txt);
		_g_object_unref0 (self);
		g_slice_free (Block8Data, _data8_);
	}
}

static void
__lambda123_ (RsyncLogBox* self)
{
	rsync_log_box_execute_action (self);
}

static void
___lambda123__gtk_entry_activate (GtkEntry* _sender,
                                  gpointer self)
{
	__lambda123_ ((RsyncLogBox*) self);
}

static gboolean
__lambda124_ (Block8Data* _data8_,
              GdkEventFocus* event)
{
	RsyncLogBox* self;
	gboolean result;
	self = _data8_->self;
	g_return_val_if_fail (event != NULL, FALSE);
	g_signal_emit_by_name (_data8_->txt, "activate");
	result = FALSE;
	return result;
}

static gboolean
___lambda124__gtk_widget_focus_out_event (GtkWidget* _sender,
                                          GdkEventFocus* event,
                                          gpointer self)
{
	gboolean result;
	result = __lambda124_ (self, event);
	return result;
}

static gboolean
__lambda125_ (RsyncLogBox* self)
{
	gboolean result;
	result = TRUE;
	return result;
}

static gboolean
___lambda125__gtk_widget_popup_menu (GtkWidget* _sender,
                                     gpointer self)
{
	gboolean result;
	result = __lambda125_ ((RsyncLogBox*) self);
	return result;
}

static gboolean
__lambda126_ (RsyncLogBox* self,
              GtkWidget* w,
              GdkEventButton* event)
{
	gboolean result;
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	if (event->button == ((guint) 3)) {
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}

static gboolean
___lambda126__gtk_widget_button_press_event (GtkWidget* _sender,
                                             GdkEventButton* event,
                                             gpointer self)
{
	gboolean result;
	result = __lambda126_ ((RsyncLogBox*) self, _sender, event);
	return result;
}

static gboolean
__lambda127_ (RsyncLogBox* self,
              GdkEventKey* event)
{
	gboolean result;
	g_return_val_if_fail (event != NULL, FALSE);
	rsync_log_box_add_action_delayed (self);
	result = FALSE;
	return result;
}

static gboolean
___lambda127__gtk_widget_key_press_event (GtkWidget* _sender,
                                          GdkEventKey* event,
                                          gpointer self)
{
	gboolean result;
	result = __lambda127_ ((RsyncLogBox*) self, event);
	return result;
}

static void
rsync_log_box_add_search_entry (RsyncLogBox* self,
                                GtkBox* hbox)
{
	Block8Data* _data8_;
	GtkEntry* _tmp0_;
	GtkEntry* _tmp1_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hbox != NULL);
	_data8_ = g_slice_new0 (Block8Data);
	_data8_->_ref_count_ = 1;
	_data8_->self = g_object_ref (self);
	_tmp0_ = (GtkEntry*) gtk_entry_new ();
	g_object_ref_sink (_tmp0_);
	_data8_->txt = _tmp0_;
	g_object_set (_data8_->txt, "xalign", 0.0f, NULL);
	gtk_widget_set_hexpand ((GtkWidget*) _data8_->txt, TRUE);
	g_object_set ((GtkWidget*) _data8_->txt, "margin", 0, NULL);
	gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) _data8_->txt);
	gtk_entry_set_placeholder_text (_data8_->txt, _ ("Filter by name or path"));
	_tmp1_ = _g_object_ref0 (_data8_->txt);
	_g_object_unref0 (self->priv->txt_pattern);
	self->priv->txt_pattern = _tmp1_;
	g_signal_connect_object (_data8_->txt, "activate", (GCallback) ___lambda123__gtk_entry_activate, self, 0);
	g_signal_connect_data ((GtkWidget*) _data8_->txt, "focus-out-event", (GCallback) ___lambda124__gtk_widget_focus_out_event, block8_data_ref (_data8_), (GClosureNotify) block8_data_unref, 0);
	g_signal_connect_object ((GtkWidget*) _data8_->txt, "popup-menu", (GCallback) ___lambda125__gtk_widget_popup_menu, self, 0);
	g_signal_connect_object ((GtkWidget*) _data8_->txt, "button-press-event", (GCallback) ___lambda126__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) _data8_->txt, "key-press-event", (GCallback) ___lambda127__gtk_widget_key_press_event, self, 0);
	block8_data_unref (_data8_);
	_data8_ = NULL;
}

static void
__lambda128_ (RsyncLogBox* self,
              GtkCellLayout* cell_layout,
              GtkCellRenderer* cell,
              GtkTreeModel* model,
              GtkTreeIter* iter)
{
	gchar* val = NULL;
	GtkTreeIter _tmp0_;
	gchar* _tmp1_ = NULL;
	g_return_if_fail (cell_layout != NULL);
	g_return_if_fail (cell != NULL);
	g_return_if_fail (model != NULL);
	g_return_if_fail (iter != NULL);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 1, &_tmp1_, -1, -1);
	_g_free0 (val);
	val = _tmp1_;
	g_object_set (G_TYPE_CHECK_INSTANCE_CAST (cell, gtk_cell_renderer_text_get_type (), GtkCellRendererText), "text", val, NULL);
	_g_free0 (val);
}

static void
___lambda128__gtk_cell_layout_data_func (GtkCellLayout* cell_layout,
                                         GtkCellRenderer* cell,
                                         GtkTreeModel* tree_model,
                                         GtkTreeIter* iter,
                                         gpointer self)
{
	__lambda128_ ((RsyncLogBox*) self, cell_layout, cell, tree_model, iter);
}

static void
rsync_log_box_add_combo (RsyncLogBox* self,
                         GtkBox* hbox)
{
	GtkComboBox* combo = NULL;
	GtkComboBox* _tmp0_;
	GtkComboBox* _tmp1_;
	GtkComboBox* _tmp2_;
	GtkComboBox* _tmp3_;
	GtkCellRendererText* cell_text = NULL;
	GtkCellRendererText* _tmp4_;
	GtkCellRendererText* _tmp5_;
	GtkComboBox* _tmp6_;
	GtkCellRendererText* _tmp7_;
	GtkComboBox* _tmp8_;
	GtkCellRendererText* _tmp9_;
	GtkListStore* model = NULL;
	GtkListStore* _tmp10_;
	GtkComboBox* _tmp11_;
	GtkListStore* _tmp12_;
	GtkTreeIter iter = {0};
	GtkListStore* _tmp13_;
	GtkTreeIter _tmp14_ = {0};
	GtkListStore* _tmp15_;
	GtkTreeIter _tmp16_;
	GtkListStore* _tmp17_;
	GtkTreeIter _tmp18_ = {0};
	const gchar* _tmp19_ = NULL;
	Main* _tmp20_;
	GtkListStore* _tmp21_;
	GtkTreeIter _tmp22_;
	gchar* _tmp23_;
	gchar* _tmp24_;
	gboolean _tmp25_;
	gboolean _tmp26_;
	GtkListStore* _tmp35_;
	GtkTreeIter _tmp36_ = {0};
	gchar* txt = NULL;
	gchar* _tmp37_;
	Main* _tmp38_;
	GtkListStore* _tmp44_;
	GtkTreeIter _tmp45_;
	const gchar* _tmp46_;
	gchar* _tmp47_;
	gchar* _tmp48_;
	Main* _tmp49_;
	GtkComboBox* _tmp86_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (hbox != NULL);
	_tmp0_ = (GtkComboBox*) gtk_combo_box_new ();
	g_object_ref_sink (_tmp0_);
	combo = _tmp0_;
	_tmp1_ = combo;
	gtk_container_add ((GtkContainer*) hbox, (GtkWidget*) _tmp1_);
	_tmp2_ = combo;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->cmb_filter);
	self->priv->cmb_filter = _tmp3_;
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp4_);
	cell_text = _tmp4_;
	_tmp5_ = cell_text;
	g_object_set (_tmp5_, "text", "", NULL);
	_tmp6_ = combo;
	_tmp7_ = cell_text;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp6_, (GtkCellRenderer*) _tmp7_, FALSE);
	_tmp8_ = combo;
	_tmp9_ = cell_text;
	gtk_cell_layout_set_cell_data_func ((GtkCellLayout*) _tmp8_, (GtkCellRenderer*) _tmp9_, ___lambda128__gtk_cell_layout_data_func, g_object_ref (self), g_object_unref);
	_tmp10_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_STRING, -1);
	model = _tmp10_;
	_tmp11_ = self->priv->cmb_filter;
	_tmp12_ = model;
	gtk_combo_box_set_model (_tmp11_, (GtkTreeModel*) _tmp12_);
	_tmp13_ = model;
	gtk_list_store_append (_tmp13_, &_tmp14_);
	iter = _tmp14_;
	_tmp15_ = model;
	_tmp16_ = iter;
	gtk_list_store_set (_tmp15_, &_tmp16_, 0, "", 1, _ ("All Files"), -1);
	_tmp17_ = model;
	gtk_list_store_append (_tmp17_, &_tmp18_);
	iter = _tmp18_;
	_tmp20_ = App;
	if (_tmp20_->dry_run) {
		_tmp19_ = _ ("Create");
	} else {
		_tmp19_ = _ ("Created");
	}
	_tmp21_ = model;
	_tmp22_ = iter;
	_tmp23_ = g_strdup_printf ("%s", _tmp19_);
	_tmp24_ = _tmp23_;
	gtk_list_store_set (_tmp21_, &_tmp22_, 0, "created", 1, _tmp24_, -1);
	_g_free0 (_tmp24_);
	_tmp25_ = rsync_log_box_get_is_restore_log (self);
	_tmp26_ = _tmp25_;
	if (_tmp26_) {
		GtkListStore* _tmp27_;
		GtkTreeIter _tmp28_ = {0};
		const gchar* _tmp29_ = NULL;
		Main* _tmp30_;
		GtkListStore* _tmp31_;
		GtkTreeIter _tmp32_;
		gchar* _tmp33_;
		gchar* _tmp34_;
		_tmp27_ = model;
		gtk_list_store_append (_tmp27_, &_tmp28_);
		iter = _tmp28_;
		_tmp30_ = App;
		if (_tmp30_->dry_run) {
			_tmp29_ = _ ("Delete");
		} else {
			_tmp29_ = _ ("Deleted");
		}
		_tmp31_ = model;
		_tmp32_ = iter;
		_tmp33_ = g_strdup_printf ("%s", _tmp29_);
		_tmp34_ = _tmp33_;
		gtk_list_store_set (_tmp31_, &_tmp32_, 0, "deleted", 1, _tmp34_, -1);
		_g_free0 (_tmp34_);
	}
	_tmp35_ = model;
	gtk_list_store_append (_tmp35_, &_tmp36_);
	iter = _tmp36_;
	_tmp37_ = g_strdup ("");
	txt = _tmp37_;
	_tmp38_ = App;
	if (_tmp38_->dry_run) {
		gchar* _tmp39_;
		_tmp39_ = g_strdup (_ ("Restore"));
		_g_free0 (txt);
		txt = _tmp39_;
	} else {
		gboolean _tmp40_;
		gboolean _tmp41_;
		_tmp40_ = rsync_log_box_get_is_restore_log (self);
		_tmp41_ = _tmp40_;
		if (_tmp41_) {
			gchar* _tmp42_;
			_tmp42_ = g_strdup (_ ("Changed"));
			_g_free0 (txt);
			txt = _tmp42_;
		} else {
			gchar* _tmp43_;
			_tmp43_ = g_strdup (_ ("Changed"));
			_g_free0 (txt);
			txt = _tmp43_;
		}
	}
	_tmp44_ = model;
	_tmp45_ = iter;
	_tmp46_ = txt;
	_tmp47_ = g_strdup_printf ("%s", _tmp46_);
	_tmp48_ = _tmp47_;
	gtk_list_store_set (_tmp44_, &_tmp45_, 0, "changed", 1, _tmp48_, -1);
	_g_free0 (_tmp48_);
	_tmp49_ = App;
	if (!_tmp49_->dry_run) {
		GtkListStore* _tmp50_;
		GtkTreeIter _tmp51_ = {0};
		GtkListStore* _tmp52_;
		GtkTreeIter _tmp53_;
		gchar* _tmp54_;
		gchar* _tmp55_;
		GtkListStore* _tmp56_;
		GtkTreeIter _tmp57_ = {0};
		GtkListStore* _tmp58_;
		GtkTreeIter _tmp59_;
		gchar* _tmp60_;
		gchar* _tmp61_;
		GtkListStore* _tmp62_;
		GtkTreeIter _tmp63_ = {0};
		GtkListStore* _tmp64_;
		GtkTreeIter _tmp65_;
		gchar* _tmp66_;
		gchar* _tmp67_;
		GtkListStore* _tmp68_;
		GtkTreeIter _tmp69_ = {0};
		GtkListStore* _tmp70_;
		GtkTreeIter _tmp71_;
		gchar* _tmp72_;
		gchar* _tmp73_;
		GtkListStore* _tmp74_;
		GtkTreeIter _tmp75_ = {0};
		GtkListStore* _tmp76_;
		GtkTreeIter _tmp77_;
		gchar* _tmp78_;
		gchar* _tmp79_;
		GtkListStore* _tmp80_;
		GtkTreeIter _tmp81_ = {0};
		GtkListStore* _tmp82_;
		GtkTreeIter _tmp83_;
		gchar* _tmp84_;
		gchar* _tmp85_;
		_tmp50_ = model;
		gtk_list_store_append (_tmp50_, &_tmp51_);
		iter = _tmp51_;
		_tmp52_ = model;
		_tmp53_ = iter;
		_tmp54_ = g_strdup_printf (" └ %s", _ ("Checksum"));
		_tmp55_ = _tmp54_;
		gtk_list_store_set (_tmp52_, &_tmp53_, 0, "checksum", 1, _tmp55_, -1);
		_g_free0 (_tmp55_);
		_tmp56_ = model;
		gtk_list_store_append (_tmp56_, &_tmp57_);
		iter = _tmp57_;
		_tmp58_ = model;
		_tmp59_ = iter;
		_tmp60_ = g_strdup_printf (" └ %s", _ ("Size"));
		_tmp61_ = _tmp60_;
		gtk_list_store_set (_tmp58_, &_tmp59_, 0, "size", 1, _tmp61_, -1);
		_g_free0 (_tmp61_);
		_tmp62_ = model;
		gtk_list_store_append (_tmp62_, &_tmp63_);
		iter = _tmp63_;
		_tmp64_ = model;
		_tmp65_ = iter;
		_tmp66_ = g_strdup_printf (" └ %s", _ ("Timestamp"));
		_tmp67_ = _tmp66_;
		gtk_list_store_set (_tmp64_, &_tmp65_, 0, "timestamp", 1, _tmp67_, -1);
		_g_free0 (_tmp67_);
		_tmp68_ = model;
		gtk_list_store_append (_tmp68_, &_tmp69_);
		iter = _tmp69_;
		_tmp70_ = model;
		_tmp71_ = iter;
		_tmp72_ = g_strdup_printf (" └ %s", _ ("Permissions"));
		_tmp73_ = _tmp72_;
		gtk_list_store_set (_tmp70_, &_tmp71_, 0, "permissions", 1, _tmp73_, -1);
		_g_free0 (_tmp73_);
		_tmp74_ = model;
		gtk_list_store_append (_tmp74_, &_tmp75_);
		iter = _tmp75_;
		_tmp76_ = model;
		_tmp77_ = iter;
		_tmp78_ = g_strdup_printf (" └ %s", _ ("Owner"));
		_tmp79_ = _tmp78_;
		gtk_list_store_set (_tmp76_, &_tmp77_, 0, "owner", 1, _tmp79_, -1);
		_g_free0 (_tmp79_);
		_tmp80_ = model;
		gtk_list_store_append (_tmp80_, &_tmp81_);
		iter = _tmp81_;
		_tmp82_ = model;
		_tmp83_ = iter;
		_tmp84_ = g_strdup_printf (" └ %s", _ ("Group"));
		_tmp85_ = _tmp84_;
		gtk_list_store_set (_tmp82_, &_tmp83_, 0, "group", 1, _tmp85_, -1);
		_g_free0 (_tmp85_);
	}
	_tmp86_ = self->priv->cmb_filter;
	gtk_combo_box_set_active (_tmp86_, 0);
	_g_free0 (txt);
	_g_object_unref0 (model);
	_g_object_unref0 (cell_text);
	_g_object_unref0 (combo);
}

static gboolean
_rsync_log_box_execute_action_gsource_func (gpointer self)
{
	gboolean result;
	result = rsync_log_box_execute_action ((RsyncLogBox*) self);
	return result;
}

static void
rsync_log_box_add_action_delayed (RsyncLogBox* self)
{
	g_return_if_fail (self != NULL);
	rsync_log_box_clear_action_delayed (self);
	self->priv->tmr_action = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 200, _rsync_log_box_execute_action_gsource_func, g_object_ref (self), g_object_unref);
}

static void
rsync_log_box_clear_action_delayed (RsyncLogBox* self)
{
	g_return_if_fail (self != NULL);
	if (self->priv->tmr_action > ((guint) 0)) {
		g_source_remove (self->priv->tmr_action);
		self->priv->tmr_action = (guint) 0;
	}
}

static gboolean
rsync_log_box_execute_action (RsyncLogBox* self)
{
	GtkEntry* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	GtkTreeModelFilter* _tmp4_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	rsync_log_box_clear_action_delayed (self);
	_tmp0_ = self->priv->txt_pattern;
	_tmp1_ = gtk_entry_get_text (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 (self->priv->name_filter);
	self->priv->name_filter = _tmp3_;
	_tmp4_ = self->priv->treefilter;
	gtk_tree_model_filter_refilter (_tmp4_);
	result = FALSE;
	return result;
}

static void
rsync_log_box_create_treeview (RsyncLogBox* self)
{
	GtkBox* _tmp0_;
	GtkBox* _tmp1_;
	GtkBox* _tmp2_;
	GtkTreeView* _tmp3_;
	GtkTreeView* _tmp4_;
	GtkTreeSelection* _tmp5_;
	GtkTreeView* _tmp6_;
	GtkTreeView* _tmp7_;
	GtkTreeView* _tmp8_;
	GtkTreeView* _tmp9_;
	GtkScrolledWindow* scrolled = NULL;
	GtkScrolledWindow* _tmp10_;
	GtkTreeView* _tmp11_;
	GtkBox* _tmp12_;
	g_return_if_fail (self != NULL);
	_tmp0_ = (GtkBox*) gtk_box_new (GTK_ORIENTATION_VERTICAL, 6);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->priv->vbox_list);
	self->priv->vbox_list = _tmp0_;
	_tmp1_ = self->priv->vbox_list;
	gtk_widget_set_no_show_all ((GtkWidget*) _tmp1_, TRUE);
	_tmp2_ = self->priv->vbox_list;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = (GtkTreeView*) gtk_tree_view_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->treeview);
	self->priv->treeview = _tmp3_;
	_tmp4_ = self->priv->treeview;
	_tmp5_ = gtk_tree_view_get_selection (_tmp4_);
	gtk_tree_selection_set_mode (_tmp5_, GTK_SELECTION_MULTIPLE);
	_tmp6_ = self->priv->treeview;
	gtk_tree_view_set_headers_clickable (_tmp6_, TRUE);
	_tmp7_ = self->priv->treeview;
	gtk_tree_view_set_rubber_banding (_tmp7_, TRUE);
	_tmp8_ = self->priv->treeview;
	gtk_widget_set_has_tooltip ((GtkWidget*) _tmp8_, TRUE);
	_tmp9_ = self->priv->treeview;
	gtk_tree_view_set_show_expanders (_tmp9_, FALSE);
	_tmp10_ = (GtkScrolledWindow*) gtk_scrolled_window_new (NULL, NULL);
	g_object_ref_sink (_tmp10_);
	scrolled = _tmp10_;
	gtk_scrolled_window_set_shadow_type (scrolled, GTK_SHADOW_ETCHED_IN);
	_tmp11_ = self->priv->treeview;
	gtk_container_add ((GtkContainer*) scrolled, (GtkWidget*) _tmp11_);
	g_object_set (scrolled, "hscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	g_object_set (scrolled, "vscrollbar-policy", GTK_POLICY_AUTOMATIC, NULL);
	gtk_widget_set_vexpand ((GtkWidget*) scrolled, TRUE);
	_tmp12_ = self->priv->vbox_list;
	gtk_container_add ((GtkContainer*) _tmp12_, (GtkWidget*) scrolled);
	rsync_log_box_add_column_status (self);
	rsync_log_box_add_column_name (self);
	rsync_log_box_add_column_buffer (self);
	_g_object_unref0 (scrolled);
}

static void
rsync_log_box_add_column_status (RsyncLogBox* self)
{
	GtkTreeViewColumn* col = NULL;
	GtkTreeViewColumn* _tmp0_;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_;
	gboolean _tmp3_;
	GtkTreeViewColumn* _tmp4_;
	GtkTreeView* _tmp5_;
	GtkTreeViewColumn* _tmp6_;
	GtkTreeViewColumn* _tmp7_;
	GtkTreeViewColumn* _tmp8_;
	GtkCellRendererPixbuf* cell_pix = NULL;
	GtkCellRendererPixbuf* _tmp9_;
	GtkTreeViewColumn* _tmp10_;
	GtkTreeViewColumn* _tmp11_;
	GtkCellRendererText* cell_text = NULL;
	GtkCellRendererText* _tmp12_;
	GtkTreeViewColumn* _tmp13_;
	GtkTreeViewColumn* _tmp14_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp0_);
	col = _tmp0_;
	_tmp2_ = rsync_log_box_get_is_restore_log (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		_tmp1_ = _ ("Action");
	} else {
		_tmp1_ = _ ("Status");
	}
	_tmp4_ = col;
	gtk_tree_view_column_set_title (_tmp4_, _tmp1_);
	_tmp5_ = self->priv->treeview;
	_tmp6_ = col;
	gtk_tree_view_append_column (_tmp5_, _tmp6_);
	_tmp7_ = col;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->col_status);
	self->priv->col_status = _tmp8_;
	_tmp9_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp9_);
	cell_pix = _tmp9_;
	g_object_set (cell_pix, "stock-size", (guint) GTK_ICON_SIZE_MENU, NULL);
	_tmp10_ = col;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp10_, (GtkCellRenderer*) cell_pix, FALSE);
	_tmp11_ = col;
	gtk_tree_view_column_set_attributes (_tmp11_, (GtkCellRenderer*) cell_pix, "pixbuf", 3, NULL);
	_tmp12_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp12_);
	cell_text = _tmp12_;
	_tmp13_ = col;
	gtk_cell_layout_pack_start ((GtkCellLayout*) _tmp13_, (GtkCellRenderer*) cell_text, FALSE);
	_tmp14_ = col;
	gtk_tree_view_column_set_attributes (_tmp14_, (GtkCellRenderer*) cell_text, "text", 4, NULL);
	_g_object_unref0 (cell_text);
	_g_object_unref0 (cell_pix);
	_g_object_unref0 (col);
}

static void
rsync_log_box_add_column_name (RsyncLogBox* self)
{
	GtkTreeViewColumn* col = NULL;
	GtkTreeViewColumn* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkTreeViewColumn* _tmp2_;
	GtkCellRendererPixbuf* cell_pix = NULL;
	GtkCellRendererPixbuf* _tmp3_;
	GtkCellRendererText* cell_text = NULL;
	GtkCellRendererText* _tmp4_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp0_);
	col = _tmp0_;
	gtk_tree_view_column_set_title (col, _ ("Name"));
	gtk_tree_view_column_set_clickable (col, TRUE);
	gtk_tree_view_column_set_resizable (col, TRUE);
	gtk_tree_view_column_set_expand (col, TRUE);
	_tmp1_ = self->priv->treeview;
	gtk_tree_view_append_column (_tmp1_, col);
	_tmp2_ = _g_object_ref0 (col);
	_g_object_unref0 (self->priv->col_name);
	self->priv->col_name = _tmp2_;
	_tmp3_ = (GtkCellRendererPixbuf*) gtk_cell_renderer_pixbuf_new ();
	g_object_ref_sink (_tmp3_);
	cell_pix = _tmp3_;
	g_object_set (cell_pix, "stock-size", (guint) GTK_ICON_SIZE_MENU, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) cell_pix, FALSE);
	gtk_tree_view_column_set_attributes (col, (GtkCellRenderer*) cell_pix, "pixbuf", 1, NULL);
	_tmp4_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp4_);
	cell_text = _tmp4_;
	g_object_set (cell_text, "ellipsize", PANGO_ELLIPSIZE_END, NULL);
	gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) cell_text, FALSE);
	gtk_tree_view_column_set_attributes (col, (GtkCellRenderer*) cell_text, "text", 2, NULL);
	_g_object_unref0 (cell_text);
	_g_object_unref0 (cell_pix);
	_g_object_unref0 (col);
}

static void
rsync_log_box_add_column_buffer (RsyncLogBox* self)
{
	GtkTreeViewColumn* col = NULL;
	GtkTreeViewColumn* _tmp0_;
	GtkTreeView* _tmp1_;
	GtkCellRendererText* cell_text = NULL;
	GtkCellRendererText* _tmp2_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_tree_view_column_new ();
	g_object_ref_sink (_tmp0_);
	col = _tmp0_;
	gtk_tree_view_column_set_title (col, "");
	gtk_tree_view_column_set_clickable (col, FALSE);
	gtk_tree_view_column_set_resizable (col, FALSE);
	gtk_tree_view_column_set_min_width (col, 20);
	_tmp1_ = self->priv->treeview;
	gtk_tree_view_append_column (_tmp1_, col);
	_tmp2_ = (GtkCellRendererText*) gtk_cell_renderer_text_new ();
	g_object_ref_sink (_tmp2_);
	cell_text = _tmp2_;
	gtk_cell_layout_pack_start ((GtkCellLayout*) col, (GtkCellRenderer*) cell_text, FALSE);
	_g_object_unref0 (cell_text);
	_g_object_unref0 (col);
}

static gchar*
string_slice (const gchar* self,
              glong start,
              glong end)
{
	glong string_length = 0L;
	gint _tmp0_;
	gint _tmp1_;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gchar* _tmp4_;
	gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	string_length = (glong) _tmp1_;
	if (start < ((glong) 0)) {
		start = string_length + start;
	}
	if (end < ((glong) 0)) {
		end = string_length + end;
	}
	if (start >= ((glong) 0)) {
		_tmp2_ = start <= string_length;
	} else {
		_tmp2_ = FALSE;
	}
	g_return_val_if_fail (_tmp2_, NULL);
	if (end >= ((glong) 0)) {
		_tmp3_ = end <= string_length;
	} else {
		_tmp3_ = FALSE;
	}
	g_return_val_if_fail (_tmp3_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	_tmp4_ = g_strndup (((gchar*) self) + start, (gsize) (end - start));
	result = _tmp4_;
	return result;
}

static gboolean
_rsync_log_box_filter_packages_func_gtk_tree_model_filter_visible_func (GtkTreeModel* model,
                                                                        GtkTreeIter* iter,
                                                                        gpointer self)
{
	gboolean result;
	result = rsync_log_box_filter_packages_func ((RsyncLogBox*) self, model, iter);
	return result;
}

static void
rsync_log_box_treeview_refresh (RsyncLogBox* self)
{
	GTimer* tmr = NULL;
	GTimer* _tmp0_;
	GtkBox* _tmp1_;
	GtkWindow* _tmp2_;
	GtkListStore* model = NULL;
	GtkListStore* _tmp3_;
	GtkTreeIter iter0 = {0};
	gchar* spath = NULL;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	GtkListStore* _tmp86_;
	GtkTreeModelFilter* _tmp87_;
	GtkTreeModelFilter* _tmp88_;
	GtkTreeView* _tmp89_;
	GtkTreeModelFilter* _tmp90_;
	GTimer* _tmp91_;
	gchar* _tmp92_;
	gchar* _tmp93_;
	gchar* _tmp94_;
	gchar* _tmp95_;
	GtkBox* _tmp96_;
	GtkWindow* _tmp97_;
	g_return_if_fail (self != NULL);
	tee_jee_logging_log_debug ("treeview_refresh(): 0");
	_tmp0_ = tee_jee_system_timer_start ();
	tmr = _tmp0_;
	_tmp1_ = self->priv->hbox_filter;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp1_, FALSE);
	_tmp2_ = self->priv->window;
	tee_jee_gtk_helper_gtk_set_busy (TRUE, _tmp2_);
	_tmp3_ = gtk_list_store_new (5, TYPE_FILE_ITEM, gdk_pixbuf_get_type (), G_TYPE_STRING, gdk_pixbuf_get_type (), G_TYPE_STRING, -1);
	model = _tmp3_;
	_tmp4_ = self->priv->rsync_log_file;
	_tmp5_ = tee_jee_file_system_file_parent (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%s/localhost", _tmp6_);
	_tmp8_ = _tmp7_;
	_g_free0 (_tmp6_);
	spath = _tmp8_;
	{
		GeeArrayList* _item_list = NULL;
		GeeArrayList* _tmp9_;
		gint _item_size = 0;
		GeeArrayList* _tmp10_;
		gint _tmp11_;
		gint _tmp12_;
		gint _item_index = 0;
		_tmp9_ = self->priv->loglist;
		_item_list = _tmp9_;
		_tmp10_ = _item_list;
		_tmp11_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp10_);
		_tmp12_ = _tmp11_;
		_item_size = _tmp12_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp13_;
			gint _tmp14_;
			FileItem* item = NULL;
			GeeArrayList* _tmp15_;
			gpointer _tmp16_;
			Main* _tmp17_;
			gchar* status = NULL;
			gchar* _tmp19_;
			GdkPixbuf* status_icon = NULL;
			gboolean _tmp20_;
			gboolean _tmp21_;
			gchar* relpath = NULL;
			FileItem* _tmp50_;
			const gchar* _tmp51_;
			const gchar* _tmp52_;
			gint _tmp53_;
			gint _tmp54_;
			FileItem* _tmp55_;
			const gchar* _tmp56_;
			gint _tmp57_;
			gint _tmp58_;
			gchar* _tmp59_;
			gboolean _tmp60_;
			gboolean _tmp61_;
			GtkListStore* _tmp67_;
			GtkTreeIter _tmp68_ = {0};
			GtkListStore* _tmp69_;
			GtkTreeIter _tmp70_;
			FileItem* _tmp71_;
			GtkListStore* _tmp72_;
			GtkTreeIter _tmp73_;
			FileItem* _tmp74_;
			GdkPixbuf* _tmp75_;
			GdkPixbuf* _tmp76_;
			GtkListStore* _tmp77_;
			GtkTreeIter _tmp78_;
			const gchar* _tmp79_;
			GtkListStore* _tmp80_;
			GtkTreeIter _tmp81_;
			GdkPixbuf* _tmp82_;
			GtkListStore* _tmp83_;
			GtkTreeIter _tmp84_;
			const gchar* _tmp85_;
			_item_index = _item_index + 1;
			_tmp13_ = _item_index;
			_tmp14_ = _item_size;
			if (!(_tmp13_ < _tmp14_)) {
				break;
			}
			_tmp15_ = _item_list;
			_tmp16_ = gee_abstract_list_get ((GeeAbstractList*) _tmp15_, _item_index);
			item = (FileItem*) _tmp16_;
			_tmp17_ = App;
			if (_tmp17_->dry_run) {
				FileItem* _tmp18_;
				_tmp18_ = item;
				if (_tmp18_->file_type == G_FILE_TYPE_DIRECTORY) {
					_g_object_unref0 (item);
					continue;
				}
			}
			_tmp19_ = g_strdup ("");
			status = _tmp19_;
			status_icon = NULL;
			_tmp20_ = rsync_log_box_get_is_restore_log (self);
			_tmp21_ = _tmp20_;
			if (_tmp21_) {
				FileItem* _tmp22_;
				const gchar* _tmp23_;
				const gchar* _tmp24_;
				GQuark _tmp26_ = 0U;
				static GQuark _tmp25_label0 = 0;
				static GQuark _tmp25_label1 = 0;
				static GQuark _tmp25_label2 = 0;
				static GQuark _tmp25_label3 = 0;
				static GQuark _tmp25_label4 = 0;
				static GQuark _tmp25_label5 = 0;
				static GQuark _tmp25_label6 = 0;
				static GQuark _tmp25_label7 = 0;
				_tmp22_ = item;
				_tmp23_ = _tmp22_->file_status;
				_tmp24_ = _tmp23_;
				_tmp26_ = (NULL == _tmp24_) ? 0 : g_quark_from_string (_tmp24_);
				if ((((((_tmp26_ == ((0 != _tmp25_label0) ? _tmp25_label0 : (_tmp25_label0 = g_quark_from_static_string ("checksum")))) || (_tmp26_ == ((0 != _tmp25_label1) ? _tmp25_label1 : (_tmp25_label1 = g_quark_from_static_string ("size"))))) || (_tmp26_ == ((0 != _tmp25_label2) ? _tmp25_label2 : (_tmp25_label2 = g_quark_from_static_string ("timestamp"))))) || (_tmp26_ == ((0 != _tmp25_label3) ? _tmp25_label3 : (_tmp25_label3 = g_quark_from_static_string ("permissions"))))) || (_tmp26_ == ((0 != _tmp25_label4) ? _tmp25_label4 : (_tmp25_label4 = g_quark_from_static_string ("owner"))))) || (_tmp26_ == ((0 != _tmp25_label5) ? _tmp25_label5 : (_tmp25_label5 = g_quark_from_static_string ("group"))))) {
					switch (0) {
						default:
						{
							const gchar* _tmp27_ = NULL;
							Main* _tmp28_;
							gchar* _tmp29_;
							GdkPixbuf* _tmp30_;
							_tmp28_ = App;
							if (_tmp28_->dry_run) {
								_tmp27_ = _ ("Restore");
							} else {
								_tmp27_ = _ ("Changed");
							}
							_tmp29_ = g_strdup (_tmp27_);
							_g_free0 (status);
							status = _tmp29_;
							_tmp30_ = icon_manager_lookup ("item-yellow", 16, FALSE, FALSE, 1);
							_g_object_unref0 (status_icon);
							status_icon = _tmp30_;
							break;
						}
					}
				} else if (_tmp26_ == ((0 != _tmp25_label6) ? _tmp25_label6 : (_tmp25_label6 = g_quark_from_static_string ("created")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp31_ = NULL;
							Main* _tmp32_;
							gchar* _tmp33_;
							GdkPixbuf* _tmp34_;
							_tmp32_ = App;
							if (_tmp32_->dry_run) {
								_tmp31_ = _ ("Create");
							} else {
								_tmp31_ = _ ("Created");
							}
							_tmp33_ = g_strdup (_tmp31_);
							_g_free0 (status);
							status = _tmp33_;
							_tmp34_ = icon_manager_lookup ("item-green", 16, FALSE, FALSE, 1);
							_g_object_unref0 (status_icon);
							status_icon = _tmp34_;
							break;
						}
					}
				} else if (_tmp26_ == ((0 != _tmp25_label7) ? _tmp25_label7 : (_tmp25_label7 = g_quark_from_static_string ("deleted")))) {
					switch (0) {
						default:
						{
							const gchar* _tmp35_ = NULL;
							Main* _tmp36_;
							gchar* _tmp37_;
							GdkPixbuf* _tmp38_;
							_tmp36_ = App;
							if (_tmp36_->dry_run) {
								_tmp35_ = _ ("Delete");
							} else {
								_tmp35_ = _ ("Deleted");
							}
							_tmp37_ = g_strdup (_tmp35_);
							_g_free0 (status);
							status = _tmp37_;
							_tmp38_ = icon_manager_lookup ("item-red", 16, FALSE, FALSE, 1);
							_g_object_unref0 (status_icon);
							status_icon = _tmp38_;
							break;
						}
					}
				}
			} else {
				FileItem* _tmp39_;
				const gchar* _tmp40_;
				const gchar* _tmp41_;
				GQuark _tmp43_ = 0U;
				static GQuark _tmp42_label0 = 0;
				static GQuark _tmp42_label1 = 0;
				static GQuark _tmp42_label2 = 0;
				static GQuark _tmp42_label3 = 0;
				static GQuark _tmp42_label4 = 0;
				static GQuark _tmp42_label5 = 0;
				static GQuark _tmp42_label6 = 0;
				static GQuark _tmp42_label7 = 0;
				_tmp39_ = item;
				_tmp40_ = _tmp39_->file_status;
				_tmp41_ = _tmp40_;
				_tmp43_ = (NULL == _tmp41_) ? 0 : g_quark_from_string (_tmp41_);
				if ((((((_tmp43_ == ((0 != _tmp42_label0) ? _tmp42_label0 : (_tmp42_label0 = g_quark_from_static_string ("checksum")))) || (_tmp43_ == ((0 != _tmp42_label1) ? _tmp42_label1 : (_tmp42_label1 = g_quark_from_static_string ("size"))))) || (_tmp43_ == ((0 != _tmp42_label2) ? _tmp42_label2 : (_tmp42_label2 = g_quark_from_static_string ("timestamp"))))) || (_tmp43_ == ((0 != _tmp42_label3) ? _tmp42_label3 : (_tmp42_label3 = g_quark_from_static_string ("permissions"))))) || (_tmp43_ == ((0 != _tmp42_label4) ? _tmp42_label4 : (_tmp42_label4 = g_quark_from_static_string ("owner"))))) || (_tmp43_ == ((0 != _tmp42_label5) ? _tmp42_label5 : (_tmp42_label5 = g_quark_from_static_string ("group"))))) {
					switch (0) {
						default:
						{
							gchar* _tmp44_;
							GdkPixbuf* _tmp45_;
							_tmp44_ = g_strdup (_ ("Changed"));
							_g_free0 (status);
							status = _tmp44_;
							_tmp45_ = icon_manager_lookup ("item-yellow", 16, FALSE, FALSE, 1);
							_g_object_unref0 (status_icon);
							status_icon = _tmp45_;
							break;
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label6) ? _tmp42_label6 : (_tmp42_label6 = g_quark_from_static_string ("created")))) {
					switch (0) {
						default:
						{
							gchar* _tmp46_;
							GdkPixbuf* _tmp47_;
							_tmp46_ = g_strdup (_ ("Created"));
							_g_free0 (status);
							status = _tmp46_;
							_tmp47_ = icon_manager_lookup ("item-green", 16, FALSE, FALSE, 1);
							_g_object_unref0 (status_icon);
							status_icon = _tmp47_;
							break;
						}
					}
				} else if (_tmp43_ == ((0 != _tmp42_label7) ? _tmp42_label7 : (_tmp42_label7 = g_quark_from_static_string ("deleted")))) {
					switch (0) {
						default:
						{
							gchar* _tmp48_;
							GdkPixbuf* _tmp49_;
							_tmp48_ = g_strdup (_ ("Deleted"));
							_g_free0 (status);
							status = _tmp48_;
							_tmp49_ = icon_manager_lookup ("item-red", 16, FALSE, FALSE, 1);
							_g_object_unref0 (status_icon);
							status_icon = _tmp49_;
							break;
						}
					}
				}
			}
			_tmp50_ = item;
			_tmp51_ = _tmp50_->file_path;
			_tmp52_ = spath;
			_tmp53_ = strlen (_tmp52_);
			_tmp54_ = _tmp53_;
			_tmp55_ = item;
			_tmp56_ = _tmp55_->file_path;
			_tmp57_ = strlen (_tmp56_);
			_tmp58_ = _tmp57_;
			_tmp59_ = string_slice (_tmp51_, (glong) _tmp54_, (glong) _tmp58_);
			relpath = _tmp59_;
			_tmp60_ = rsync_log_box_get_is_restore_log (self);
			_tmp61_ = _tmp60_;
			if (!_tmp61_) {
				const gchar* _tmp62_;
				const gchar* _tmp63_;
				gint _tmp64_;
				gint _tmp65_;
				gchar* _tmp66_;
				_tmp62_ = relpath;
				_tmp63_ = relpath;
				_tmp64_ = strlen (_tmp63_);
				_tmp65_ = _tmp64_;
				_tmp66_ = string_slice (_tmp62_, (glong) 1, (glong) _tmp65_);
				_g_free0 (relpath);
				relpath = _tmp66_;
			}
			_tmp67_ = model;
			gtk_list_store_append (_tmp67_, &_tmp68_);
			iter0 = _tmp68_;
			_tmp69_ = model;
			_tmp70_ = iter0;
			_tmp71_ = item;
			gtk_list_store_set (_tmp69_, &_tmp70_, 0, _tmp71_, -1);
			_tmp72_ = model;
			_tmp73_ = iter0;
			_tmp74_ = item;
			_tmp75_ = file_item_get_icon (_tmp74_, 16, FALSE, FALSE);
			_tmp76_ = _tmp75_;
			gtk_list_store_set (_tmp72_, &_tmp73_, 1, _tmp76_, -1);
			_g_object_unref0 (_tmp76_);
			_tmp77_ = model;
			_tmp78_ = iter0;
			_tmp79_ = relpath;
			gtk_list_store_set (_tmp77_, &_tmp78_, 2, _tmp79_, -1);
			_tmp80_ = model;
			_tmp81_ = iter0;
			_tmp82_ = status_icon;
			gtk_list_store_set (_tmp80_, &_tmp81_, 3, _tmp82_, -1);
			_tmp83_ = model;
			_tmp84_ = iter0;
			_tmp85_ = status;
			gtk_list_store_set (_tmp83_, &_tmp84_, 4, _tmp85_, -1);
			_g_free0 (relpath);
			_g_object_unref0 (status_icon);
			_g_free0 (status);
			_g_object_unref0 (item);
		}
	}
	_tmp86_ = model;
	_tmp87_ = (GtkTreeModelFilter*) gtk_tree_model_filter_new ((GtkTreeModel*) _tmp86_, NULL);
	_g_object_unref0 (self->priv->treefilter);
	self->priv->treefilter = _tmp87_;
	_tmp88_ = self->priv->treefilter;
	gtk_tree_model_filter_set_visible_func (_tmp88_, _rsync_log_box_filter_packages_func_gtk_tree_model_filter_visible_func, g_object_ref (self), g_object_unref);
	_tmp89_ = self->priv->treeview;
	_tmp90_ = self->priv->treefilter;
	gtk_tree_view_set_model (_tmp89_, (GtkTreeModel*) _tmp90_);
	_tmp91_ = tmr;
	_tmp92_ = tee_jee_system_timer_elapsed_string (_tmp91_, TRUE);
	_tmp93_ = _tmp92_;
	_tmp94_ = g_strdup_printf ("treeview_refresh(): %s", _tmp93_);
	_tmp95_ = _tmp94_;
	tee_jee_logging_log_debug (_tmp95_);
	_g_free0 (_tmp95_);
	_g_free0 (_tmp93_);
	_tmp96_ = self->priv->hbox_filter;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp96_, TRUE);
	_tmp97_ = self->priv->window;
	tee_jee_gtk_helper_gtk_set_busy (FALSE, _tmp97_);
	_g_free0 (spath);
	_g_object_unref0 (model);
	_g_timer_destroy0 (tmr);
}

static gboolean
string_contains (const gchar* self,
                 const gchar* needle)
{
	gchar* _tmp0_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = strstr ((gchar*) self, (gchar*) needle);
	result = _tmp0_ != NULL;
	return result;
}

static gboolean
rsync_log_box_filter_packages_func (RsyncLogBox* self,
                                    GtkTreeModel* model,
                                    GtkTreeIter* iter)
{
	FileItem* item = NULL;
	GtkTreeIter _tmp0_;
	FileItem* _tmp1_ = NULL;
	const gchar* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	const gchar* _tmp25_;
	gint _tmp26_;
	gint _tmp27_;
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (model != NULL, FALSE);
	g_return_val_if_fail (iter != NULL, FALSE);
	_tmp0_ = *iter;
	gtk_tree_model_get (model, &_tmp0_, 0, &_tmp1_, -1, -1);
	_g_object_unref0 (item);
	item = _tmp1_;
	_tmp2_ = self->priv->name_filter;
	_tmp3_ = strlen (_tmp2_);
	_tmp4_ = _tmp3_;
	if (_tmp4_ > 0) {
		gchar* spath = NULL;
		const gchar* _tmp5_;
		gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		gchar* relpath = NULL;
		FileItem* _tmp10_;
		const gchar* _tmp11_;
		const gchar* _tmp12_;
		gint _tmp13_;
		gint _tmp14_;
		FileItem* _tmp15_;
		const gchar* _tmp16_;
		gint _tmp17_;
		gint _tmp18_;
		gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		const gchar* _tmp23_;
		gboolean _tmp24_;
		_tmp5_ = self->priv->rsync_log_file;
		_tmp6_ = tee_jee_file_system_file_parent (_tmp5_);
		_tmp7_ = _tmp6_;
		_tmp8_ = g_strdup_printf ("%s/localhost", _tmp7_);
		_tmp9_ = _tmp8_;
		_g_free0 (_tmp7_);
		spath = _tmp9_;
		_tmp10_ = item;
		_tmp11_ = _tmp10_->file_path;
		_tmp12_ = spath;
		_tmp13_ = strlen (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp15_ = item;
		_tmp16_ = _tmp15_->file_path;
		_tmp17_ = strlen (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = string_slice (_tmp11_, (glong) _tmp14_, (glong) _tmp18_);
		relpath = _tmp19_;
		_tmp20_ = relpath;
		_tmp21_ = g_utf8_strdown (_tmp20_, (gssize) -1);
		_tmp22_ = _tmp21_;
		_tmp23_ = self->priv->name_filter;
		_tmp24_ = !string_contains (_tmp22_, _tmp23_);
		_g_free0 (_tmp22_);
		if (_tmp24_) {
			result = FALSE;
			_g_free0 (relpath);
			_g_free0 (spath);
			_g_object_unref0 (item);
			return result;
		}
		_g_free0 (relpath);
		_g_free0 (spath);
	}
	_tmp25_ = self->priv->status_filter;
	_tmp26_ = strlen (_tmp25_);
	_tmp27_ = _tmp26_;
	if (_tmp27_ == 0) {
		result = TRUE;
		_g_object_unref0 (item);
		return result;
	} else {
		const gchar* _tmp28_;
		_tmp28_ = self->priv->status_filter;
		if (g_strcmp0 (_tmp28_, "changed") == 0) {
			FileItem* _tmp29_;
			const gchar* _tmp30_;
			const gchar* _tmp31_;
			GQuark _tmp33_ = 0U;
			static GQuark _tmp32_label0 = 0;
			static GQuark _tmp32_label1 = 0;
			static GQuark _tmp32_label2 = 0;
			static GQuark _tmp32_label3 = 0;
			static GQuark _tmp32_label4 = 0;
			static GQuark _tmp32_label5 = 0;
			_tmp29_ = item;
			_tmp30_ = _tmp29_->file_status;
			_tmp31_ = _tmp30_;
			_tmp33_ = (NULL == _tmp31_) ? 0 : g_quark_from_string (_tmp31_);
			if ((((((_tmp33_ == ((0 != _tmp32_label0) ? _tmp32_label0 : (_tmp32_label0 = g_quark_from_static_string ("checksum")))) || (_tmp33_ == ((0 != _tmp32_label1) ? _tmp32_label1 : (_tmp32_label1 = g_quark_from_static_string ("size"))))) || (_tmp33_ == ((0 != _tmp32_label2) ? _tmp32_label2 : (_tmp32_label2 = g_quark_from_static_string ("timestamp"))))) || (_tmp33_ == ((0 != _tmp32_label3) ? _tmp32_label3 : (_tmp32_label3 = g_quark_from_static_string ("permissions"))))) || (_tmp33_ == ((0 != _tmp32_label4) ? _tmp32_label4 : (_tmp32_label4 = g_quark_from_static_string ("owner"))))) || (_tmp33_ == ((0 != _tmp32_label5) ? _tmp32_label5 : (_tmp32_label5 = g_quark_from_static_string ("group"))))) {
				switch (0) {
					default:
					{
						result = TRUE;
						_g_object_unref0 (item);
						return result;
					}
				}
			} else {
				switch (0) {
					default:
					{
						result = FALSE;
						_g_object_unref0 (item);
						return result;
					}
				}
			}
		} else {
			FileItem* _tmp34_;
			const gchar* _tmp35_;
			const gchar* _tmp36_;
			_tmp34_ = item;
			_tmp35_ = _tmp34_->file_status;
			_tmp36_ = self->priv->status_filter;
			result = g_strcmp0 (_tmp35_, _tmp36_) == 0;
			_g_object_unref0 (item);
			return result;
		}
	}
}

static void
rsync_log_box_exclude_selected_items (RsyncLogBox* self)
{
	GeeArrayList* list = NULL;
	GeeArrayList* _tmp0_;
	Main* _tmp12_;
	GeeArrayList* _tmp13_;
	GtkTreeIter iter = {0};
	GtkListStore* store = NULL;
	GtkTreeView* _tmp14_;
	GtkTreeModel* _tmp15_;
	GtkTreeModel* _tmp16_;
	GtkListStore* _tmp17_;
	gboolean iterExists = FALSE;
	GtkListStore* _tmp18_;
	GtkTreeIter _tmp19_ = {0};
	gboolean _tmp20_;
	Main* _tmp45_;
	GeeArrayList* _tmp46_;
	GeeArrayList* _tmp47_;
	g_return_if_fail (self != NULL);
	_tmp0_ = gee_array_list_new (G_TYPE_STRING, (GBoxedCopyFunc) g_strdup, (GDestroyNotify) g_free, NULL, NULL, NULL);
	list = _tmp0_;
	{
		GeeArrayList* _pattern_list = NULL;
		Main* _tmp1_;
		GeeArrayList* _tmp2_;
		gint _pattern_size = 0;
		GeeArrayList* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		gint _pattern_index = 0;
		_tmp1_ = App;
		_tmp2_ = _tmp1_->exclude_list_user;
		_pattern_list = _tmp2_;
		_tmp3_ = _pattern_list;
		_tmp4_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp3_);
		_tmp5_ = _tmp4_;
		_pattern_size = _tmp5_;
		_pattern_index = -1;
		while (TRUE) {
			gint _tmp6_;
			gint _tmp7_;
			gchar* pattern = NULL;
			GeeArrayList* _tmp8_;
			gpointer _tmp9_;
			GeeArrayList* _tmp10_;
			const gchar* _tmp11_;
			_pattern_index = _pattern_index + 1;
			_tmp6_ = _pattern_index;
			_tmp7_ = _pattern_size;
			if (!(_tmp6_ < _tmp7_)) {
				break;
			}
			_tmp8_ = _pattern_list;
			_tmp9_ = gee_abstract_list_get ((GeeAbstractList*) _tmp8_, _pattern_index);
			pattern = (gchar*) _tmp9_;
			_tmp10_ = list;
			_tmp11_ = pattern;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp10_, _tmp11_);
			_g_free0 (pattern);
		}
	}
	_tmp12_ = App;
	_tmp13_ = _tmp12_->exclude_list_user;
	gee_abstract_collection_clear ((GeeAbstractCollection*) _tmp13_);
	_tmp14_ = self->priv->treeview;
	_tmp15_ = gtk_tree_view_get_model (_tmp14_);
	_tmp16_ = _tmp15_;
	_tmp17_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_CAST (_tmp16_, gtk_list_store_get_type (), GtkListStore));
	store = _tmp17_;
	_tmp18_ = store;
	_tmp20_ = gtk_tree_model_get_iter_first ((GtkTreeModel*) _tmp18_, &_tmp19_);
	iter = _tmp19_;
	iterExists = _tmp20_;
	while (TRUE) {
		FileItem* item = NULL;
		GtkListStore* _tmp21_;
		GtkTreeIter _tmp22_;
		FileItem* _tmp23_ = NULL;
		gchar* pattern = NULL;
		FileItem* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		FileItem* _tmp27_;
		gboolean _tmp30_ = FALSE;
		gboolean _tmp31_ = FALSE;
		Main* _tmp32_;
		GeeArrayList* _tmp33_;
		const gchar* _tmp34_;
		GtkListStore* _tmp43_;
		gboolean _tmp44_;
		if (!iterExists) {
			break;
		}
		_tmp21_ = store;
		_tmp22_ = iter;
		gtk_tree_model_get ((GtkTreeModel*) _tmp21_, &_tmp22_, 0, &_tmp23_, -1);
		_g_object_unref0 (item);
		item = _tmp23_;
		_tmp24_ = item;
		_tmp25_ = _tmp24_->file_path;
		_tmp26_ = g_strdup (_tmp25_);
		pattern = _tmp26_;
		_tmp27_ = item;
		if (_tmp27_->file_type == G_FILE_TYPE_DIRECTORY) {
			const gchar* _tmp28_;
			gchar* _tmp29_;
			_tmp28_ = pattern;
			_tmp29_ = g_strdup_printf ("%s/***", _tmp28_);
			_g_free0 (pattern);
			pattern = _tmp29_;
		} else {
		}
		_tmp32_ = App;
		_tmp33_ = _tmp32_->exclude_list_user;
		_tmp34_ = pattern;
		if (!gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp33_, _tmp34_)) {
			Main* _tmp35_;
			GeeArrayList* _tmp36_;
			const gchar* _tmp37_;
			_tmp35_ = App;
			_tmp36_ = _tmp35_->exclude_list_default;
			_tmp37_ = pattern;
			_tmp31_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp36_, _tmp37_);
		} else {
			_tmp31_ = FALSE;
		}
		if (_tmp31_) {
			Main* _tmp38_;
			GeeArrayList* _tmp39_;
			const gchar* _tmp40_;
			_tmp38_ = App;
			_tmp39_ = _tmp38_->exclude_list_home;
			_tmp40_ = pattern;
			_tmp30_ = !gee_abstract_collection_contains ((GeeAbstractCollection*) _tmp39_, _tmp40_);
		} else {
			_tmp30_ = FALSE;
		}
		if (_tmp30_) {
			GeeArrayList* _tmp41_;
			const gchar* _tmp42_;
			_tmp41_ = list;
			_tmp42_ = pattern;
			gee_abstract_collection_add ((GeeAbstractCollection*) _tmp41_, _tmp42_);
		}
		_tmp43_ = store;
		_tmp44_ = gtk_tree_model_iter_next ((GtkTreeModel*) _tmp43_, &iter);
		iterExists = _tmp44_;
		_g_free0 (pattern);
		_g_object_unref0 (item);
	}
	_tmp45_ = App;
	_tmp46_ = list;
	_tmp47_ = _g_object_ref0 (_tmp46_);
	_g_object_unref0 (_tmp45_->exclude_list_user);
	_tmp45_->exclude_list_user = _tmp47_;
	tee_jee_logging_log_debug ("exclude_selected_items()");
	{
		GeeArrayList* _item_list = NULL;
		Main* _tmp48_;
		GeeArrayList* _tmp49_;
		gint _item_size = 0;
		GeeArrayList* _tmp50_;
		gint _tmp51_;
		gint _tmp52_;
		gint _item_index = 0;
		_tmp48_ = App;
		_tmp49_ = _tmp48_->exclude_list_user;
		_item_list = _tmp49_;
		_tmp50_ = _item_list;
		_tmp51_ = gee_abstract_collection_get_size ((GeeAbstractCollection*) _tmp50_);
		_tmp52_ = _tmp51_;
		_item_size = _tmp52_;
		_item_index = -1;
		while (TRUE) {
			gint _tmp53_;
			gint _tmp54_;
			gchar* item = NULL;
			GeeArrayList* _tmp55_;
			gpointer _tmp56_;
			const gchar* _tmp57_;
			_item_index = _item_index + 1;
			_tmp53_ = _item_index;
			_tmp54_ = _item_size;
			if (!(_tmp53_ < _tmp54_)) {
				break;
			}
			_tmp55_ = _item_list;
			_tmp56_ = gee_abstract_list_get ((GeeAbstractList*) _tmp55_, _item_index);
			item = (gchar*) _tmp56_;
			_tmp57_ = item;
			tee_jee_logging_log_debug (_tmp57_);
			_g_free0 (item);
		}
	}
	_g_object_unref0 (store);
	_g_object_unref0 (list);
}

static gboolean
rsync_log_box_get_is_restore_log (RsyncLogBox* self)
{
	gboolean result;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gboolean _tmp3_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->rsync_log_file;
	_tmp1_ = tee_jee_file_system_file_basename (_tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = string_contains (_tmp2_, "restore");
	_g_free0 (_tmp2_);
	result = _tmp3_;
	return result;
}

gboolean
rsync_log_box_get_is_running (RsyncLogBox* self)
{
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->thread_is_running;
	return result;
}

static void
rsync_log_box_class_init (RsyncLogBoxClass * klass,
                          gpointer klass_data)
{
	rsync_log_box_parent_class = g_type_class_peek_parent (klass);
	g_type_class_adjust_private_offset (klass, &RsyncLogBox_private_offset);
	G_OBJECT_CLASS (klass)->get_property = _vala_rsync_log_box_get_property;
	G_OBJECT_CLASS (klass)->finalize = rsync_log_box_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), RSYNC_LOG_BOX_IS_RUNNING_PROPERTY, rsync_log_box_properties[RSYNC_LOG_BOX_IS_RUNNING_PROPERTY] = g_param_spec_boolean ("is-running", "is-running", "is-running", FALSE, G_PARAM_STATIC_STRINGS | G_PARAM_READABLE));
}

static void
rsync_log_box_instance_init (RsyncLogBox * self,
                             gpointer klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	self->priv = rsync_log_box_get_instance_private (self);
	_tmp0_ = g_strdup ("");
	self->priv->name_filter = _tmp0_;
	_tmp1_ = g_strdup ("");
	self->priv->status_filter = _tmp1_;
	self->priv->tmr_init = (guint) 0;
	self->priv->thread_is_running = FALSE;
	self->priv->tmr_action = (guint) 0;
}

static void
rsync_log_box_finalize (GObject * obj)
{
	RsyncLogBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_RSYNC_LOG_BOX, RsyncLogBox);
	_g_object_unref0 (self->priv->vbox_progress);
	_g_object_unref0 (self->priv->vbox_list);
	_g_object_unref0 (self->priv->treeview);
	_g_object_unref0 (self->priv->treefilter);
	_g_object_unref0 (self->priv->cmb_filter);
	_g_object_unref0 (self->priv->hbox_filter);
	_g_object_unref0 (self->priv->txt_pattern);
	_g_object_unref0 (self->priv->col_name);
	_g_object_unref0 (self->priv->col_status);
	_g_free0 (self->priv->name_filter);
	_g_free0 (self->priv->status_filter);
	_g_object_unref0 (self->lbl_header);
	_g_object_unref0 (self->lbl_header_progress);
	_g_object_unref0 (self->priv->spinner);
	_g_object_unref0 (self->lbl_msg);
	_g_object_unref0 (self->lbl_status);
	_g_object_unref0 (self->lbl_remaining);
	_g_object_unref0 (self->progressbar);
	_g_free0 (self->priv->rsync_log_file);
	_g_object_unref0 (self->priv->loglist);
	_g_object_unref0 (self->priv->window);
	G_OBJECT_CLASS (rsync_log_box_parent_class)->finalize (obj);
}

static GType
rsync_log_box_get_type_once (void)
{
	static const GTypeInfo g_define_type_info = { sizeof (RsyncLogBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) rsync_log_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (RsyncLogBox), 0, (GInstanceInitFunc) rsync_log_box_instance_init, NULL };
	GType rsync_log_box_type_id;
	rsync_log_box_type_id = g_type_register_static (gtk_box_get_type (), "RsyncLogBox", &g_define_type_info, 0);
	RsyncLogBox_private_offset = g_type_add_instance_private (rsync_log_box_type_id, sizeof (RsyncLogBoxPrivate));
	return rsync_log_box_type_id;
}

GType
rsync_log_box_get_type (void)
{
	static volatile gsize rsync_log_box_type_id__once = 0;
	if (g_once_init_enter (&rsync_log_box_type_id__once)) {
		GType rsync_log_box_type_id;
		rsync_log_box_type_id = rsync_log_box_get_type_once ();
		g_once_init_leave (&rsync_log_box_type_id__once, rsync_log_box_type_id);
	}
	return rsync_log_box_type_id__once;
}

static void
_vala_rsync_log_box_get_property (GObject * object,
                                  guint property_id,
                                  GValue * value,
                                  GParamSpec * pspec)
{
	RsyncLogBox * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_RSYNC_LOG_BOX, RsyncLogBox);
	switch (property_id) {
		case RSYNC_LOG_BOX_IS_RUNNING_PROPERTY:
		g_value_set_boolean (value, rsync_log_box_get_is_running (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}

