/* vinagre-dirs.c generated by valac 0.56.18, the Vala compiler
 * generated from vinagre-dirs.vala, do not modify */

/*  Vinagre - GNOME Remote Desktop viewer
 *
 *  Copyright (C) 2011  David King <amigadave@amigadave.com>
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#include "vinagre-vala.h"
#include <stdlib.h>
#include <string.h>
#include <glib.h>
#include <config.h>
#include <glib/gstdio.h>

#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_free0(var) (var = (g_free (var), NULL))

static gchar** _vala_array_dup1 (gchar** self,
                          gssize length);
static void _vala_array_add1 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_add2 (gchar** * array,
                       gint* length,
                       gint* size,
                       gchar* value);
static void _vala_array_destroy (gpointer array,
                          gssize array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gssize array_length,
                       GDestroyNotify destroy_func);
static gssize _vala_array_length (gpointer array);

gchar*
vinagre_dirs_get_user_cache_dir (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_get_user_cache_dir ();
	_tmp1_ = g_build_filename (_tmp0_, PACKAGE_TARNAME, NULL);
	result = _tmp1_;
	return result;
}

gchar*
vinagre_dirs_get_user_data_dir (void)
{
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* result;
	_tmp0_ = g_get_user_data_dir ();
	_tmp1_ = g_build_filename (_tmp0_, PACKAGE_TARNAME, NULL);
	result = _tmp1_;
	return result;
}

static gchar**
_vala_array_dup1 (gchar** self,
                  gssize length)
{
	if (length >= 0) {
		gchar** result;
		gssize i;
		result = g_new0 (gchar*, length + 1);
		for (i = 0; i < length; i++) {
			gchar* _tmp0_;
			_tmp0_ = g_strdup (self[i]);
			result[i] = _tmp0_;
		}
		return result;
	}
	return NULL;
}

static void
_vala_array_add1 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

static void
_vala_array_add2 (gchar** * array,
                  gint* length,
                  gint* size,
                  gchar* value)
{
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}

gchar*
vinagre_dirs_get_package_data_file (const gchar* filename)
{
	gchar** system_data_dirs = NULL;
	gchar** _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gint system_data_dirs_length1;
	gint _system_data_dirs_size_;
	gchar** data_dirs = NULL;
	gchar** _tmp3_;
	gint data_dirs_length1;
	gint _data_dirs_size_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gint _tmp5__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar* result;
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp1_ = _tmp0_ = g_get_system_data_dirs ();
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _vala_array_length (_tmp0_)) : _tmp1_;
	_tmp2__length1 = _vala_array_length (_tmp0_);
	system_data_dirs = _tmp2_;
	system_data_dirs_length1 = _tmp2__length1;
	_system_data_dirs_size_ = system_data_dirs_length1;
	_tmp3_ = g_new0 (gchar*, 0 + 1);
	data_dirs = _tmp3_;
	data_dirs_length1 = 0;
	_data_dirs_size_ = data_dirs_length1;
	_tmp4_ = g_strdup (DATADIR);
	_vala_array_add1 (&data_dirs, &data_dirs_length1, &_data_dirs_size_, _tmp4_);
	_tmp5_ = system_data_dirs;
	_tmp5__length1 = system_data_dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp5_;
		dir_collection_length1 = _tmp5__length1;
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			gchar* _tmp6_;
			gchar* dir = NULL;
			_tmp6_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp6_;
			{
				const gchar* _tmp7_;
				gchar* _tmp8_;
				_tmp7_ = dir;
				_tmp8_ = g_strdup (_tmp7_);
				_vala_array_add2 (&data_dirs, &data_dirs_length1, &_data_dirs_size_, _tmp8_);
				_g_free0 (dir);
			}
		}
	}
	_tmp9_ = data_dirs;
	_tmp9__length1 = data_dirs_length1;
	{
		gchar** dir_collection = NULL;
		gint dir_collection_length1 = 0;
		gint _dir_collection_size_ = 0;
		gint dir_it = 0;
		dir_collection = _tmp9_;
		dir_collection_length1 = _tmp9__length1;
		for (dir_it = 0; dir_it < dir_collection_length1; dir_it = dir_it + 1) {
			gchar* _tmp10_;
			gchar* dir = NULL;
			_tmp10_ = g_strdup (dir_collection[dir_it]);
			dir = _tmp10_;
			{
				gchar* absolute_path = NULL;
				const gchar* _tmp11_;
				gchar* _tmp12_;
				const gchar* _tmp13_;
				_tmp11_ = dir;
				_tmp12_ = g_build_filename (_tmp11_, PACKAGE_TARNAME, filename, NULL);
				absolute_path = _tmp12_;
				_tmp13_ = absolute_path;
				if (g_file_test (_tmp13_, G_FILE_TEST_EXISTS)) {
					result = absolute_path;
					_g_free0 (dir);
					data_dirs = (_vala_array_free (data_dirs, data_dirs_length1, (GDestroyNotify) g_free), NULL);
					system_data_dirs = (_vala_array_free (system_data_dirs, system_data_dirs_length1, (GDestroyNotify) g_free), NULL);
					return result;
				}
				_g_free0 (absolute_path);
				_g_free0 (dir);
			}
		}
	}
	g_error ("vinagre-dirs.vala:47: Data file ‘%s’ could not be found in system data" \
" directories.", filename);
}

static void
_vala_array_destroy (gpointer array,
                     gssize array_length,
                     GDestroyNotify destroy_func)
{
	if ((array != NULL) && (destroy_func != NULL)) {
		gssize i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}

static void
_vala_array_free (gpointer array,
                  gssize array_length,
                  GDestroyNotify destroy_func)
{
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}

static gssize
_vala_array_length (gpointer array)
{
	gssize length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}

