/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.controls;

import org.dbgl.gui.controls.ControlBuilder;
import org.dbgl.gui.controls.DarkTheme;
import org.dbgl.service.TextService;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;

public class Group_ {
    private Group_() {
    }

    public static Builder on(Composite composite) {
        return new Builder(composite);
    }

    public static class Builder
    extends ControlBuilder<Builder> {
        private String text_;
        private Layout layout_;

        Builder(Composite composite) {
            super(composite, 0, 1, 128, false, false);
        }

        public Builder layout(Layout layout) {
            this.layout_ = layout;
            return this;
        }

        public Builder txt(String text) {
            this.text_ = text;
            return this;
        }

        public Builder key(String key) {
            return this.txt(TextService.getInstance().get(key));
        }

        public Group build() {
            Group group = new Group(this.composite_, this.style_);
            if (DarkTheme.forced()) {
                group.setBackground(this.composite_.getBackground());
                group.setForeground(DarkTheme.defaultForeground);
            }
            group.setLayoutData(this.layoutData());
            group.setLayout(this.layout_);
            if (this.text_ != null) {
                group.setText(this.text_);
            }
            return group;
        }
    }
}

