/*
 * Decompiled with CFR 0.152.
 */
package org.dbgl.gui.dialog;

import org.dbgl.gui.abstractdialog.SizeControlledButtonDialog;
import org.dbgl.gui.controls.Button_;
import org.dbgl.gui.controls.Chain;
import org.dbgl.gui.controls.Group_;
import org.dbgl.model.MixerCommand;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;

public class EditMixerDialog
extends SizeControlledButtonDialog<String> {
    private final MixerCommand mixerCommand_;

    public EditMixerDialog(Shell parent, String command) {
        super(parent, "mixerdialog");
        this.mixerCommand_ = new MixerCommand(command);
    }

    @Override
    protected String getDialogTitle() {
        return this.text_.get("dialog.mixer.title");
    }

    @Override
    protected void onShellCreated() {
        this.contents_.setLayout(new GridLayout(MixerCommand.CHANNELS.size(), true));
        for (final String channelName : MixerCommand.CHANNELS) {
            Group channelGroup = ((Group_.Builder)Group_.on(this.contents_).layout(new GridLayout(2, false)).layoutData(new GridData(4, 4, true, true))).key("dialog.mixer." + channelName).build();
            final Chain chnChannel = Chain.on(channelGroup).lbl(l -> l).lbl(l -> l).scl(s -> s.vertical().select(200 - this.mixerCommand_.getVolumeFor(channelName).getLeft()).max(200).pageIncr(10)).scl(s -> s.vertical().select(200 - this.mixerCommand_.getVolumeFor(channelName).getRight()).max(200).pageIncr(10)).but(b -> ((Button_.Builder)b.horSpan(2)).key("dialog.mixer.lockbalance").select(this.mixerCommand_.getVolumeFor(channelName).getLeft() == this.mixerCommand_.getVolumeFor(channelName).getRight())).build();
            final Label left = chnChannel.getLabels().get(0);
            final Label right = chnChannel.getLabels().get(1);
            final Scale scaleLeft = chnChannel.getScales().get(0);
            final Scale scaleRight = chnChannel.getScales().get(1);
            this.setVolumeBar(left, right, scaleLeft, scaleRight);
            scaleLeft.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    if (chnChannel.getButton().getSelection()) {
                        scaleRight.setSelection(scaleLeft.getSelection());
                    }
                    EditMixerDialog.this.mixerCommand_.setVolumeFor(channelName, 200 - scaleLeft.getSelection(), 200 - scaleRight.getSelection());
                    EditMixerDialog.this.setVolumeBar(left, right, scaleLeft, scaleRight);
                }
            });
            scaleRight.addSelectionListener(new SelectionAdapter(){

                @Override
                public void widgetSelected(SelectionEvent arg0) {
                    if (chnChannel.getButton().getSelection()) {
                        scaleLeft.setSelection(scaleRight.getSelection());
                    }
                    EditMixerDialog.this.mixerCommand_.setVolumeFor(channelName, 200 - scaleLeft.getSelection(), 200 - scaleRight.getSelection());
                    EditMixerDialog.this.setVolumeBar(left, right, scaleLeft, scaleRight);
                }
            });
        }
        this.createOkCancelButtons(new SelectionAdapter(){

            @Override
            public void widgetSelected(SelectionEvent event) {
                EditMixerDialog.this.result_ = EditMixerDialog.this.mixerCommand_.toString();
                EditMixerDialog.this.shell_.close();
            }
        });
    }

    private void setVolumeBar(Label left, Label right, Scale scaleLeft, Scale scaleRight) {
        left.setText(this.text_.get("dialog.mixer.leftchannelvolume", new Integer[]{200 - scaleLeft.getSelection()}));
        left.pack();
        right.setText(this.text_.get("dialog.mixer.rightchannelvolume", new Integer[]{200 - scaleRight.getSelection()}));
        right.pack();
    }
}

