exports.id = 2300;
exports.ids = [2300];
exports.modules = {

/***/ 210:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Agenda)
/* harmony export */ });
/* harmony import */ var luxon__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(2353);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var _event__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4651);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([luxon__WEBPACK_IMPORTED_MODULE_0__, _event__WEBPACK_IMPORTED_MODULE_3__]);
([luxon__WEBPACK_IMPORTED_MODULE_0__, _event__WEBPACK_IMPORTED_MODULE_3__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);





function Agenda({
  service,
  colorVariants,
  events,
  showDate
}) {
  const {
    widget
  } = service;
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_2__.useTranslation)();

  if (!showDate) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
      className: " text-center"
    });
  }

  const eventsArray = Object.keys(events).filter(eventKey => showDate.minus({
    days: widget?.previousDays ?? 0
  }).startOf("day").ts <= events[eventKey].date?.startOf("day").ts).map(eventKey => events[eventKey]).sort((a, b) => a.date - b.date).slice(0, widget?.maxEvents ?? 10);

  if (!eventsArray.length) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
      className: "text-center",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
        className: "pl-2 pr-2",
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
          className: classnames__WEBPACK_IMPORTED_MODULE_1___default()("flex flex-col", !eventsArray.length && !events.length && "animate-pulse"),
          children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_event__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
            event: {
              title: t("calendar.noEventsToday"),
              date: luxon__WEBPACK_IMPORTED_MODULE_0__.DateTime.now(),
              color: "gray"
            },
            colorVariants: colorVariants
          }, "no-event")
        })
      })
    });
  }

  const days = Array.from(new Set(eventsArray.map(e => e.date.startOf("day").ts)));
  const eventsByDay = days.map(d => eventsArray.filter(e => e.date.startOf("day").ts === d));
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
    className: "pl-1 pr-1 pb-1",
    children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
      className: classnames__WEBPACK_IMPORTED_MODULE_1___default()("flex flex-col", !eventsArray.length && !events.length && "animate-pulse"),
      children: eventsByDay.map((eventsDay, i) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx("div", {
        children: eventsDay.map((event, j) => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(_event__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
          event: event,
          colorVariants: colorVariants,
          showDate: j === 0,
          showTime: widget?.showTime && event.date.startOf("day").ts === showDate.startOf("day").ts
        }, `event-agenda-${event.title}-${event.date}-${event.additional}`))
      }, days[i]))
    })
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 2300:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(5152);
/* harmony import */ var next_dynamic__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_dynamic__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var luxon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2353);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _monthly__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(9908);
/* harmony import */ var _agenda__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(210);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(8581);
/* harmony import */ var utils_contexts_settings__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(9317);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([luxon__WEBPACK_IMPORTED_MODULE_2__, _monthly__WEBPACK_IMPORTED_MODULE_4__, _agenda__WEBPACK_IMPORTED_MODULE_5__]);
([luxon__WEBPACK_IMPORTED_MODULE_2__, _monthly__WEBPACK_IMPORTED_MODULE_4__, _agenda__WEBPACK_IMPORTED_MODULE_5__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }











const colorVariants = {
  // https://tailwindcss.com/docs/content-configuration#dynamic-class-names
  amber: "bg-amber-500",
  blue: "bg-blue-500",
  cyan: "bg-cyan-500",
  emerald: "bg-emerald-500",
  fuchsia: "bg-fuchsia-500",
  gray: "bg-gray-500",
  green: "bg-green-500",
  indigo: "bg-indigo-500",
  lime: "bg-lime-500",
  neutral: "bg-neutral-500",
  orange: "bg-orange-500",
  pink: "bg-pink-500",
  purple: "bg-purple-500",
  red: "bg-red-500",
  rose: "bg-rose-500",
  sky: "bg-sky-500",
  slate: "bg-slate-500",
  stone: "bg-stone-500",
  teal: "bg-teal-500",
  violet: "bg-violet-500",
  white: "bg-white-500",
  yellow: "bg-yellow-500",
  zinc: "bg-zinc-500"
};
function Component({
  service
}) {
  const {
    widget
  } = service;
  const {
    i18n
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
  const {
    0: showDate,
    1: setShowDate
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(null);
  const {
    0: events,
    1: setEvents
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)({});
  const currentDate = luxon__WEBPACK_IMPORTED_MODULE_2__.DateTime.now().setLocale(i18n.language).startOf("day");
  const {
    settings
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useContext)(utils_contexts_settings__WEBPACK_IMPORTED_MODULE_7__/* .SettingsContext */ .J);
  (0,react__WEBPACK_IMPORTED_MODULE_0__.useEffect)(() => {
    if (!showDate) {
      setShowDate(currentDate);
    }
  }, [showDate, currentDate]); // params for API fetch

  const params = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => {
    const constructedParams = {
      start: "",
      end: "",
      unmonitored: false
    };

    if (showDate) {
      constructedParams.start = showDate.minus({
        months: 3
      }).toFormat("yyyy-MM-dd");
      constructedParams.end = showDate.plus({
        months: 3
      }).toFormat("yyyy-MM-dd");
    }

    return constructedParams;
  }, [showDate]); // Load active integrations

  const integrations = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => widget.integrations?.filter(integration => integration?.type).map(integration => ({
    service: next_dynamic__WEBPACK_IMPORTED_MODULE_1___default()(() => __webpack_require__(1314)(`./${integration.type}`), {
      loadableGenerated: {
        modules: ["../widgets/calendar/component.jsx -> " + `./integrations/${integration.type}`]
      }
    }),
    widget: _objectSpread(_objectSpread({}, widget), integration)
  })) ?? [], [widget]);
  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_6__/* ["default"] */ .Z, {
    service: service,
    children: /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsxs)("div", {
      className: "flex flex-col w-full",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx("div", {
        className: "sticky top-0",
        children: integrations.map(integration => {
          const Integration = integration.service;
          const key = `integration-${integration.widget.type}-${integration.widget.service_name}-${integration.widget.service_group}-${integration.widget.name}`;
          return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(Integration, {
            config: integration.widget,
            params: params,
            setEvents: setEvents,
            hideErrors: settings.hideErrors,
            className: "fixed bottom-0 left-0 bg-red-500 w-screen h-12"
          }, key);
        })
      }), (!widget?.view || widget?.view === "monthly") && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(_monthly__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
        service: service,
        colorVariants: colorVariants,
        events: events,
        showDate: showDate,
        setShowDate: setShowDate,
        className: "flex"
      }, `monthly-${showDate?.toFormat("yyyy-MM-dd")}`), widget?.view === "agenda" && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_8__.jsx(_agenda__WEBPACK_IMPORTED_MODULE_5__/* ["default"] */ .Z, {
        service: service,
        colorVariants: colorVariants,
        events: events,
        showDate: showDate,
        setShowDate: setShowDate,
        className: "flex"
      }, `agenda-${showDate?.toFormat("yyyy-MM-dd")}`)]
    })
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 4651:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Event)
/* harmony export */ });
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var luxon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(2353);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var react_icons_io__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4751);
/* harmony import */ var react_icons_io__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_icons_io__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([luxon__WEBPACK_IMPORTED_MODULE_2__]);
luxon__WEBPACK_IMPORTED_MODULE_2__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







function Event({
  event,
  colorVariants,
  showDate = false,
  showTime = false,
  showDateColumn = true
}) {
  const {
    0: hover,
    1: setHover
  } = (0,react__WEBPACK_IMPORTED_MODULE_0__.useState)(false);
  const {
    i18n
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_1__.useTranslation)();
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: "flex flex-row text-theme-700 dark:text-theme-200 items-center text-xs relative h-5 w-full rounded-md bg-theme-200/50 dark:bg-theme-900/20 mt-1",
    onMouseEnter: () => setHover(!hover),
    onMouseLeave: () => setHover(!hover),
    children: [showDateColumn && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
      className: "ml-2 w-10",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
        children: (showDate || showTime) && event.date.setLocale(i18n.language).toLocaleString(showTime ? luxon__WEBPACK_IMPORTED_MODULE_2__.DateTime.TIME_24_SIMPLE : {
          month: "short",
          day: "numeric"
        })
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
      className: "ml-2 h-2 w-2",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
        className: classnames__WEBPACK_IMPORTED_MODULE_3___default()("block w-2 h-2 rounded", colorVariants[event.color] ?? "gray")
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "ml-2 h-5 text-left relative truncate",
      style: {
        width: "70%"
      },
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "absolute mt-0.5 text-xs",
        children: hover && event.additional ? event.additional : event.title
      })
    }), event.isCompleted && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
      className: "text-xs mr-1 ml-auto z-10",
      children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(react_icons_io__WEBPACK_IMPORTED_MODULE_4__.IoMdCheckmarkCircleOutline, {})
    })]
  }, `event-${event.title}-${event.date}-${event.additional}`);
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 9908:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "Z": () => (/* binding */ Monthly)
/* harmony export */ });
/* unused harmony export Day */
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var luxon__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(2353);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(9003);
/* harmony import */ var classnames__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(classnames__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var _event__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4651);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([luxon__WEBPACK_IMPORTED_MODULE_1__, _event__WEBPACK_IMPORTED_MODULE_4__]);
([luxon__WEBPACK_IMPORTED_MODULE_1__, _event__WEBPACK_IMPORTED_MODULE_4__] = __webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__);







const cellStyle = "relative w-10 flex items-center justify-center flex-col";
const monthButton = "pl-6 pr-6 ml-2 mr-2 hover:bg-theme-100/20 dark:hover:bg-white/5 rounded-md cursor-pointer";
function Day({
  weekNumber,
  weekday,
  events,
  colorVariants,
  showDate,
  setShowDate
}) {
  const currentDate = luxon__WEBPACK_IMPORTED_MODULE_1__.DateTime.now();
  const cellDate = showDate.set({
    weekday,
    weekNumber
  }).startOf("day");
  const filteredEvents = events?.filter(event => event.date?.startOf("day").toUnixInteger() === cellDate.toUnixInteger());

  const dayStyles = displayDate => {
    let style = "h-9 ";

    if ([6, 7].includes(displayDate.weekday)) {
      // weekend style
      style += "text-red-500 "; // different month style

      style += displayDate.month !== showDate.month ? "text-red-500/40 " : "";
    } else if (displayDate.month !== showDate.month) {
      // different month style
      style += "text-gray-500 ";
    } // selected same day style


    style += displayDate.startOf("day").ts === showDate.startOf("day").ts ? "text-black-500 bg-theme-100/20 dark:bg-white/10 rounded-md " : "";

    if (displayDate.startOf("day").ts === currentDate.startOf("day").ts) {
      // today style
      style += "text-black-500 bg-theme-100/20 dark:bg-black/20 rounded-md ";
    } else {
      style += "hover:bg-theme-100/20 dark:hover:bg-white/5 rounded-md cursor-pointer ";
    }

    return style;
  };

  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("button", {
    type: "button",
    className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(dayStyles(cellDate), cellStyle),
    style: {
      width: "14%"
    },
    onClick: () => setShowDate(cellDate),
    children: [cellDate.day, /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
      className: "flex justify-center items-center absolute w-full -mb-6",
      children: filteredEvents && filteredEvents.slice(0, 4).map(event => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
        className: classnames__WEBPACK_IMPORTED_MODULE_2___default()("inline-flex h-1 w-1 m-0.5 rounded", colorVariants[event.color] ?? "gray")
      }, `${event.date.ts}+${event.color}-${event.title}-${event.additional}`))
    })]
  }, `day${weekday}${weekNumber}}`);
}
const dayInWeekId = {
  monday: 1,
  tuesday: 2,
  wednesday: 3,
  thursday: 4,
  friday: 5,
  saturday: 6,
  sunday: 7
};
function Monthly({
  service,
  colorVariants,
  events,
  showDate,
  setShowDate
}) {
  const {
    widget
  } = service;
  const {
    i18n
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_3__.useTranslation)();
  const currentDate = luxon__WEBPACK_IMPORTED_MODULE_1__.DateTime.now().setLocale(i18n.language).startOf("day");
  const dayNames = luxon__WEBPACK_IMPORTED_MODULE_1__.Info.weekdays("short", {
    locale: i18n.language
  });
  const firstDayInWeekCalendar = widget?.firstDayInWeek ? widget?.firstDayInWeek?.toLowerCase() : "monday";

  for (let i = 1; i < dayInWeekId[firstDayInWeekCalendar]; i += 1) {
    dayNames.push(dayNames.shift());
  }

  const daysInWeek = (0,react__WEBPACK_IMPORTED_MODULE_0__.useMemo)(() => [...Array(7).keys()].map(i => i + dayInWeekId[firstDayInWeekCalendar]), [firstDayInWeekCalendar]);

  if (!showDate) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
      className: "w-full text-center"
    });
  }

  const firstWeek = luxon__WEBPACK_IMPORTED_MODULE_1__.DateTime.local(showDate.year, showDate.month, 1).setLocale(i18n.language);
  const weekIncrementChange = dayInWeekId[firstDayInWeekCalendar] > firstWeek.weekday ? -1 : 0;
  let weekNumbers = [...Array(Math.ceil(5) + 1).keys()].map(i => firstWeek.weekNumber + weekIncrementChange + i);

  if (weekNumbers.includes(55)) {
    // if we went too far with the weeks, it's the beginning of the year
    weekNumbers = weekNumbers.map(weekNum => weekNum - 52);
  }

  const eventsArray = Object.keys(events).map(eventKey => events[eventKey]);
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
    className: "w-full text-center",
    children: [/*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "flex-col",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("button", {
          type: "button",
          onClick: () => setShowDate(showDate.minus({
            months: 1
          }).startOf("day")),
          className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(monthButton),
          children: "<"
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("button", {
          type: "button",
          onClick: () => setShowDate(currentDate.startOf("day")),
          children: showDate.setLocale(i18n.language).toFormat("MMMM y")
        })
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
        children: /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("button", {
          type: "button",
          onClick: () => setShowDate(showDate.plus({
            months: 1
          }).startOf("day")),
          className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(monthButton),
          children: ">"
        })
      })]
    }), /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)("div", {
      className: "pl-1 pr-1 pb-1 w-full",
      children: [/*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "flex justify-between flex-wrap",
        children: dayNames.map(name => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("span", {
          className: classnames__WEBPACK_IMPORTED_MODULE_2___default()(cellStyle),
          style: {
            width: "14%"
          },
          children: name
        }, name))
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: classnames__WEBPACK_IMPORTED_MODULE_2___default()("flex justify-between flex-wrap pb-1", !eventsArray.length && widget?.integrations?.length && "animate-pulse"),
        children: weekNumbers.map(weekNumber => daysInWeek.map(dayInWeek => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(Day, {
          weekNumber: weekNumber,
          weekday: dayInWeek,
          events: eventsArray,
          colorVariants: colorVariants,
          showDate: showDate,
          setShowDate: setShowDate
        }, `week${weekNumber}day${dayInWeek}}`)))
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx("div", {
        className: "flex flex-col",
        children: eventsArray?.filter(event => showDate.startOf("day").ts === event.date?.startOf("day").ts).slice(0, widget?.maxEvents ?? 10).map(event => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(_event__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z, {
          event: event,
          colorVariants: colorVariants,
          showDateColumn: widget?.showTime ?? false,
          showTime: widget?.showTime && event.date.startOf("day").ts === showDate.startOf("day").ts
        }, `event-monthly-${event.title}-${event.date}-${event.additional}`))
      })]
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ }),

/***/ 1314:
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

var map = {
	"./ical": [
		2225,
		4582,
		2225
	],
	"./ical.jsx": [
		2225,
		4582,
		2225
	],
	"./lidarr": [
		558,
		4582,
		558
	],
	"./lidarr.jsx": [
		558,
		4582,
		558
	],
	"./radarr": [
		2378,
		4582,
		2378
	],
	"./radarr.jsx": [
		2378,
		4582,
		2378
	],
	"./readarr": [
		8341,
		4582,
		8341
	],
	"./readarr.jsx": [
		8341,
		4582,
		8341
	],
	"./sonarr": [
		5237,
		4582,
		5237
	],
	"./sonarr.jsx": [
		5237,
		4582,
		5237
	]
};
function webpackAsyncContext(req) {
	if(!__webpack_require__.o(map, req)) {
		return Promise.resolve().then(() => {
			var e = new Error("Cannot find module '" + req + "'");
			e.code = 'MODULE_NOT_FOUND';
			throw e;
		});
	}

	var ids = map[req], id = ids[0];
	return Promise.all(ids.slice(1).map(__webpack_require__.e)).then(() => {
		return __webpack_require__(id);
	});
}
webpackAsyncContext.keys = () => (Object.keys(map));
webpackAsyncContext.id = 1314;
module.exports = webpackAsyncContext;

/***/ })

};
;