"use strict";
exports.id = 3902;
exports.ids = [3902];
exports.modules = {

/***/ 3902:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(8581);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(403);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];






function getValue(field, data) {
  let value = data;
  let lastField = field;
  let key = "";

  while (typeof lastField === "object") {
    key = Object.keys(lastField)[0] ?? null;

    if (key === null) {
      break;
    }

    value = value[key];
    lastField = lastField[key];
  }

  if (typeof value === "undefined") {
    return null;
  }

  return value[lastField] ?? null;
}

function formatValue(t, mapping, rawValue) {
  let value = rawValue; // Remap the value.

  const remaps = mapping?.remap ?? [];

  for (let i = 0; i < remaps.length; i += 1) {
    const remap = remaps[i];

    if (remap?.any || remap?.value === value) {
      value = remap.to;
      break;
    }
  } // Scale the value. Accepts either a number to multiply by or a string
  // like "12/345".


  const scale = mapping?.scale;

  if (typeof scale === "number") {
    value *= scale;
  } else if (typeof scale === "string") {
    const parts = scale.split("/");
    const numerator = parts[0] ? parseFloat(parts[0]) : 1;
    const denominator = parts[1] ? parseFloat(parts[1]) : 1;
    value = value * numerator / denominator;
  } // Format the value using a known type.


  switch (mapping?.format) {
    case "number":
      value = t("common.number", {
        value: parseInt(value, 10)
      });
      break;

    case "float":
      value = t("common.number", {
        value
      });
      break;

    case "percent":
      value = t("common.percent", {
        value
      });
      break;

    case "bytes":
      value = t("common.bytes", {
        value
      });
      break;

    case "bitrate":
      value = t("common.bitrate", {
        value
      });
      break;

    case "date":
      value = t("common.date", {
        value,
        dateStyle: mapping?.dateStyle ?? "long",
        timeStyle: mapping?.timeStyle
      });
      break;

    case "text":
    default: // nothing

  } // Apply fixed suffix.


  const suffix = mapping?.suffix;

  if (suffix) {
    value = `${value} ${suffix}`;
  }

  return value;
}

function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    widget
  } = service;
  const {
    mappings = [],
    refreshInterval = 10000
  } = widget;
  const {
    data: customData,
    error: customError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z)(widget, null, {
    refreshInterval: Math.max(1000, refreshInterval)
  });

  if (customError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      error: customError
    });
  }

  if (!customData) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
      service: service,
      children: mappings.slice(0, 4).map(item => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
        label: item.label
      }, item.label))
    });
  }

  return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_1__/* ["default"] */ .Z, {
    service: service,
    children: mappings.slice(0, 4).map(mapping => /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_4__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      label: mapping.label,
      value: formatValue(t, mapping, getValue(mapping.field, customData))
    }, mapping.label))
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;