"use strict";
exports.id = 4136;
exports.ids = [4136];
exports.modules = {

/***/ 4136:
/***/ ((module, __webpack_exports__, __webpack_require__) => {

__webpack_require__.a(module, async (__webpack_handle_async_dependencies__, __webpack_async_result__) => { try {
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (/* binding */ Component)
/* harmony export */ });
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(1377);
/* harmony import */ var next_i18next__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(next_i18next__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(6689);
/* harmony import */ var react__WEBPACK_IMPORTED_MODULE_1___default = /*#__PURE__*/__webpack_require__.n(react__WEBPACK_IMPORTED_MODULE_1__);
/* harmony import */ var components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(8581);
/* harmony import */ var components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(403);
/* harmony import */ var utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(4582);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(997);
/* harmony import */ var react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5___default = /*#__PURE__*/__webpack_require__.n(react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__);
var __webpack_async_dependencies__ = __webpack_handle_async_dependencies__([utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__]);
utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__ = (__webpack_async_dependencies__.then ? (await __webpack_async_dependencies__)() : __webpack_async_dependencies__)[0];







function Component({
  service
}) {
  const {
    t
  } = (0,next_i18next__WEBPACK_IMPORTED_MODULE_0__.useTranslation)();
  const {
    widget
  } = service;
  const {
    data: nextcloudData,
    error: nextcloudError
  } = (0,utils_proxy_use_widget_api__WEBPACK_IMPORTED_MODULE_4__/* ["default"] */ .Z)(widget, "serverinfo"); // Support for deprecated fields (cpuload, memoryusage)

  const {
    0: showCpuLoad,
    1: showMemoryUsage
  } = (0,react__WEBPACK_IMPORTED_MODULE_1__.useMemo)(() => {
    // Default values if fields is not set
    if (!widget.fields) return [false, false]; // Allows for backwards compatibility with existing values of fields

    if (widget.fields.length <= 4) return [true, true]; // If all fields are enabled, drop cpuload and memoryusage

    if (widget.fields.length === 6) return [false, false];
    const hasCpuLoad = widget.fields?.includes("cpuload");
    const hasMemoryUsage = widget.fields?.includes("memoryusage"); // If (for some reason) 5 fields are set, drop memoryusage

    if (hasCpuLoad && hasMemoryUsage) return [true, false];
    return [!hasCpuLoad, !hasMemoryUsage];
  }, [widget.fields]);

  if (nextcloudError) {
    return /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      service: service,
      error: nextcloudError
    });
  }

  if (!nextcloudData) {
    return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
      service: service,
      children: [showCpuLoad && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "nextcloud.cpuload"
      }), showMemoryUsage && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "nextcloud.memoryusage"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "nextcloud.freespace"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "nextcloud.activeusers"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "nextcloud.numfiles"
      }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
        label: "nextcloud.numshares"
      })]
    });
  }

  const {
    nextcloud: nextcloudInfo,
    activeUsers
  } = nextcloudData.ocs.data;
  const memoryUsage = 100 * ((parseFloat(nextcloudInfo.system.mem_total) - parseFloat(nextcloudInfo.system.mem_free)) / parseFloat(nextcloudInfo.system.mem_total));
  return /*#__PURE__*/(0,react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsxs)(components_services_widget_container__WEBPACK_IMPORTED_MODULE_2__/* ["default"] */ .Z, {
    service: service,
    children: [showCpuLoad && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "nextcloud.cpuload",
      value: t("common.percent", {
        value: nextcloudInfo.system.cpuload[0]
      })
    }), showMemoryUsage && /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "nextcloud.memoryusage",
      value: t("common.percent", {
        value: memoryUsage
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "nextcloud.freespace",
      value: t("common.bbytes", {
        value: nextcloudInfo.system.freespace,
        maximumFractionDigits: 1
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "nextcloud.activeusers",
      value: t("common.number", {
        value: activeUsers.last24hours
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "nextcloud.numfiles",
      value: t("common.number", {
        value: nextcloudInfo.storage.num_files
      })
    }), /*#__PURE__*/react_jsx_runtime__WEBPACK_IMPORTED_MODULE_5__.jsx(components_services_widget_block__WEBPACK_IMPORTED_MODULE_3__/* ["default"] */ .Z, {
      label: "nextcloud.numshares",
      value: t("common.number", {
        value: nextcloudInfo.shares.num_shares
      })
    })]
  });
}
__webpack_async_result__();
} catch(e) { __webpack_async_result__(e); } });

/***/ })

};
;